#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Evoland series:
# - Evoland
# - Evoland 2
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250828.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID_EVOLAND1='evoland-1'
GAME_NAME_EVOLAND1='Evoland'

GAME_ID_EVOLAND2='evoland-2'
GAME_NAME_EVOLAND2='Evoland 2, A Slight Case of Spacetime Continuum Disorder'

ARCHIVE_BASE_EVOLAND1_GOG_0_NAME='setup_evoland_1.1.2490_(20677).exe'
ARCHIVE_BASE_EVOLAND1_GOG_0_MD5='97978ef959d097876142ae2c6ce765c2'
ARCHIVE_BASE_EVOLAND1_GOG_0_TYPE='innosetup'
ARCHIVE_BASE_EVOLAND1_GOG_0_SIZE='120000'
ARCHIVE_BASE_EVOLAND1_GOG_0_VERSION='1.1.2490-gog20677'
ARCHIVE_BASE_EVOLAND1_GOG_0_URL='https://www.gog.com/game/evoland'

## This DRM-free native Linux build is no longer available for sale from the Humble Store,
## they now only sell Steam keys for the Evoland "Legendary Edition" bundle.
ARCHIVE_BASE_EVOLAND1_HUMBLE_0_NAME='Evoland.exe'
ARCHIVE_BASE_EVOLAND1_HUMBLE_0_MD5='9585142f38d769d4ac9125f587d0c891'
ARCHIVE_BASE_EVOLAND1_HUMBLE_0_TYPE='nullsoft-installer'
ARCHIVE_BASE_EVOLAND1_HUMBLE_0_SIZE='110000'
ARCHIVE_BASE_EVOLAND1_HUMBLE_0_VERSION='1.1.2490-humble1'

ARCHIVE_BASE_EVOLAND2_GOG_0_NAME='setup_evoland_2_1.0.9137_(20679).exe'
ARCHIVE_BASE_EVOLAND2_GOG_0_MD5='a77db6e435460505bbc6beb1c4fcd5ed'
ARCHIVE_BASE_EVOLAND2_GOG_0_TYPE='innosetup'
ARCHIVE_BASE_EVOLAND2_GOG_0_SIZE='789305'
ARCHIVE_BASE_EVOLAND2_GOG_0_VERSION='1.0.9137-gog20679'
ARCHIVE_BASE_EVOLAND2_GOG_0_URL='https://www.gog.com/game/evoland_2'

## This DRM-free native Linux build is no longer available for sale from the Humble Store,
## they now only sell Steam keys for the Evoland "Legendary Edition" bundle.
ARCHIVE_BASE_EVOLAND2_HUMBLE_0_NAME='Evoland2.zip'
ARCHIVE_BASE_EVOLAND2_HUMBLE_0_MD5='0e34269cb7db3a6c065311eea90e651a'
ARCHIVE_BASE_EVOLAND2_HUMBLE_0_SIZE='790000'
ARCHIVE_BASE_EVOLAND2_HUMBLE_0_VERSION='1.0.9137-humble170116'


CONTENT_PATH_DEFAULT_EVOLAND1='.'
CONTENT_PATH_DEFAULT_EVOLAND2_GOG='.'
CONTENT_PATH_DEFAULT_EVOLAND2_HUMBLE='Evoland2'
CONTENT_GAME_BIN_FILES='
adobe air
dinput8.dll
evoland.exe
evoland2.exe
pad.exe
gamepadconfig.txt'
CONTENT_GAME_DATA_FILES='
icons
meta-inf
mimetype
game.dat
res.pak'

WINE_PERSISTENT_DIRECTORIES_EVOLAND1='
users/${USER}/AppData/Roaming/com.shirogames.evoland'

USER_PERSISTENT_DIRECTORIES_EVOLAND2='
save'

APP_MAIN_EXE_EVOLAND1='evoland.exe'
APP_MAIN_EXE_EVOLAND2='evoland2.exe'
APP_MAIN_ICONS_LIST='
APP_MAIN_ICON_16
APP_MAIN_ICON_32
APP_MAIN_ICON_48
APP_MAIN_ICON_128'
APP_MAIN_ICON_16='icons/evoicon16.png'
APP_MAIN_ICON_32='icons/evoicon32.png'
APP_MAIN_ICON_48='icons/evoicon48.png'
APP_MAIN_ICON_128='icons/evoicon128.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## Easier upgrades from pre-20201219.1 packages
PKG_BIN_PROVIDES_EVOLAND1='${PKG_BIN_PROVIDES_EVOLAND1:-}
evoland'

PKG_DATA_ID_EVOLAND1="${GAME_ID_EVOLAND1}-data"
PKG_DATA_ID_EVOLAND2="${GAME_ID_EVOLAND2}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20201219.1 packages
PKG_DATA_PROVIDES_EVOLAND1='
evoland-data'

## Humble Bundle builds - convmv is used to convert file paths to lower case.
REQUIREMENTS_LIST_EVOLAND1_HUMBLE='
convmv'
REQUIREMENTS_LIST_EVOLAND2_HUMBLE='
convmv'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Humble Bundle builds - Convert all file paths to lower case.
case "$(current_archive)" in
	('ARCHIVE_BASE_EVOLAND1_HUMBLE_'*|'ARCHIVE_BASE_EVOLAND2_HUMBLE_'*)
		tolower "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	;;
esac

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
