{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventPickedNormal: TMFVec3fEvent;
    {  }
    public property EventPickedNormal: TMFVec3fEvent read FEventPickedNormal;

    strict private FEventPickedPoint: TMFVec3fEvent;
    {  }
    public property EventPickedPoint: TMFVec3fEvent read FEventPickedPoint;

    strict private FEventPickedTextureCoordinate: TMFVec3fEvent;
    {  }
    public property EventPickedTextureCoordinate: TMFVec3fEvent read FEventPickedTextureCoordinate;

{$endif read_interface}

{$ifdef read_implementation}

{ TLinePickSensorNode ----------------------------------------------- }

class function TLinePickSensorNode.ClassX3DType: String;
begin
  Result := 'LinePickSensor';
end;

procedure TLinePickSensorNode.CreateNode;
begin
  inherited;

  FEventPickedNormal := TMFVec3fEvent.Create(Self, 'pickedNormal', false);
  AddEvent(FEventPickedNormal);

  FEventPickedPoint := TMFVec3fEvent.Create(Self, 'pickedPoint', false);
  AddEvent(FEventPickedPoint);

  FEventPickedTextureCoordinate := TMFVec3fEvent.Create(Self, 'pickedTextureCoordinate', false);
  AddEvent(FEventPickedTextureCoordinate);
end;

{$endif read_implementation}
