/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef COUNTER_H
#define COUNTER_H

namespace cdo
{
class Counter
{
public:
  Counter() : m_cputime(0) {}

  void start();
  void stop();
  double
  cputime()
  {
    return m_cputime;
  }

private:
  double m_cputime = 0;
  char mark[32] = { 0 };
};
}  // namespace cdo

#endif /* COUNTER_H */
