#ifndef H_CDW_ISO9660
#define H_CDW_ISO9660


#include "main.h"


long long cdw_iso_image_get_n_sectors(void);
double cdw_iso_image_get_size_mb(const char *fullpath);

enum {
	CDW_ISO9660_RR_NONE,
	CDW_ISO9660_RR_USEFUL,
	CDW_ISO9660_RR_FULL
};




#define CDW_ISO9660_ABST_LEN   37
#define CDW_ISO9660_COPY_LEN   37
#define CDW_ISO9660_PUBL_LEN  128
#define CDW_ISO9660_PREP_LEN  128
#define CDW_ISO9660_SYSI_LEN   32
#define CDW_ISO9660_VOLS_LEN  128
#define CDW_ISO9660_VOLI_LEN   32    /* "Volume ID" */


typedef struct {
	/* Turn on creting Joliet filenames. */
	bool joliet_information;                       /* mkisofs: -J;               xorriso: -joliet on|off */

	/* "Allow  Joliet  filenames  to  be  up to 103 Unicode characters, instead of 64." */
	bool joliet_long;                              /* mkisofs: -joliet-long;     xorriso: N/A */

	/* none/useful/full
	   mkisofs: -r for "useful", -R for "full"
	   xorriso: full is always on, "none is not allowed", and for "useful": "-find / -true -exec mkisofs_r --" */
	cdw_id_t rock_ridge;

	/* Follow symbolic links when generating ISO9660 filesystem. */
	bool follow_symlinks;                          /* mkisofs: -f;               xorriso: -follow link */

	bool pad;                                      /* mkisofs: -pad (hardwired value 300k);    xorriso: -padding Xk|m */

	/* Level of conformance with ISO9660; valid values are 1 to 4. */
	cdw_id_t iso_level;                            /* mkisofs: -iso-level;       xorriso: N/A */

	char *root_dir;                                /* mkisofs: -root;            xorriso: N/A */

	/* Place for other mkisofs options, specified manually. */
	char *mkisofs_other_options;

	/* Place for other xorriso ISO9660 options, specified manually. */
	char *xorriso_iso_other_options;

	/* Options for creating a bootable ISO9660 disc. */
	char *boot_disc_options;

	/* +1 for ending '\0' */
	/* Label of disc visible in file managers. */
	char volume_id[CDW_ISO9660_VOLI_LEN + 1];      /* mkisofs: -V;               xorriso: -volid     */
	char volume_set_id[CDW_ISO9660_VOLS_LEN + 1];  /* mkisofs: -volset           xorriso: -volset_id */
	char preparer[CDW_ISO9660_PREP_LEN + 1];       /* mkisofs: -p                xorriso: N/A        */
	char publisher[CDW_ISO9660_PUBL_LEN + 1];      /* mkisofs: -publisher        xorriso: -publisher */
	char system_id[CDW_ISO9660_SYSI_LEN + 1];      /* mkisofs: -sysid            xorriso: -system_id */
	char copyright[CDW_ISO9660_COPY_LEN + 1];      /* mkisofs: -copyright        xorriso: N/A        */
	char abstract[CDW_ISO9660_ABST_LEN + 1];       /* mkisofs: -abstract         xorriso: N/A        */
} cdw_iso9660_t;


void     cdw_iso9660_debug_print_options(cdw_iso9660_t *iso);
cdw_rv_t cdw_iso9660_init(cdw_iso9660_t *iso);
cdw_rv_t cdw_iso9660_set_defaults(cdw_iso9660_t *iso);
cdw_rv_t cdw_iso9660_copy(cdw_iso9660_t *target, cdw_iso9660_t *source);
cdw_rv_t cdw_iso9660_clean(cdw_iso9660_t *iso);

#endif /* #ifndef H_CDW_ISO9660 */
