'\" t
.\"
.\" fstrcmp - fuzzy string compare library
.\" Copyright (C) 2009 Peter Miller
.\" Written by Peter Miller <pmiller@opensource.org.au>
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program. If not, see <http://www.gnu.org/licenses/>.
.\"
.\"
.TH Build fstrcmp fstrcmp "Reference Manual"
.so etc/version.so
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.SH NAME
How to build fstrcmp
.XX "" "How to build fstrcmp"
.SH SPACE REQUIREMENTS
You will need about 3MB to unpack and build the \f[I]fstrcmp\fP package.
Your milage may vary.
.br
.ne 1i
.SH BEFORE YOU START
There are a few pieces of software you may want to fetch and install
before you proceed with your installation of fstrcmp
.TP 8n
GNU libtool
The libtool program is used to build shared libraries.  It understands
neccesary weird and wonderful compiler and linker tricks on many weird
and wonderful systems.
.br
http://www.gnu.org/software/libtool/
.TP 8n
GNU Groff
The documentation for the \f[I]fstrcmp\fP package was prepared using the
GNU Groff package (version 1.14 or later).  This distribution includes
full documentation, which may be processed into PostScript or DVI files
at install time \- if GNU Groff has been installed.
.TP 8n
GCC
You may also want to consider fetching and installing the GNU C Compiler
if you have not done so already.  This is not essential.  The fstrcmp
program was developed using the GNU C compiler.
.PP
The GNU FTP archives may be found at \f[CW]ftp.gnu.org\fP, and are
mirrored around the world.
.br
.ne 1i
.SH SITE CONFIGURATION
The \f[B]fstrcmp\fP package is configured using the \f[I]configure\fP
program included in the source distribution.
.PP
The \f[I]configure\fP shell script attempts to guess correct values for
various system-dependent variables used during compilation, and creates
the \f[I]Makefile\fP and \f[I]lib/config.h\fP files.  It also creates
a shell script \f[I]config.status\fP that you can run in the future to
recreate the current configuration.
.PP
Normally, you just \f[I]cd\fP to the directory containing
\f[I]fstrcmp\fP's source code and then type
.RS
.ft CW
.nf
\f[B]% \fP./configure
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
If you're using \f[I]csh\fP on an old version of System V, you might
need to type
.RS
.ft CW
.nf
\f[B]% \fPsh configure
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
instead, to prevent \f[I]csh\fP from trying to execute \f[I]configure\fP
itself.
.PP
Running \f[I]configure\fP takes a minute or two.  While it is running,
it prints some messages that tell what it is doing.  If you don't want
to see the messages, run \f[I]configure\fP using the quiet option; for
example,
.RS
.FT CW
.nf
\f[B]% \fP./configure --quiet
\bB%\fP
.fi
.ft R
.RE
.PP
To compile the \f[B]fstrcmp\fP package in a different directory from the
one containing the source code, you must use a version of \f[I]make\fP
that supports the \f[I]VPATH\fP variable, such as \f[I]GNU make\fP.
Then \f[I]cd\fP to the directory where you want the object files
and executables to go and run the \f[I]configure\fP script.  The
\f[I]configure\fP script automatically checks for the source code in
the directory that \f[I]configure\fP is in and in \fI..\fP (the parent
directory).  If for some reason \f[I]configure\fP is not in the source
code directory that you are configuring, then it will report that it
can't find the source code.  In that case, run \f[I]configure\fP with
the option \f[CW]--srcdir=\fP\f[I]DIR\fP, where \f[I]DIR\fP is the
directory that contains the source code.
.PP
By default, \f[I]configure\fP will arrange for the \f[I]make
install\fP command to install the \f[B]fstrcmp\fP package's
files in \f[I]/usr/local/bin\fP, \f[I]/usr/local/lib\fP,
\f[I]/usr/local/include\fP, and \f[I]/usr/local/man\fP.  There are
options which allow you to control the placement of these files.
.TP 8n
\f[CW]--prefix=\fP\f[I]PATH\fP
This specifies the path prefix to be used in the installation.
Defaults to \f[I]/usr/local\fP unless otherwise specified.
.TP 8n
\f[CW]--exec-prefix=\fP\f[I]PATH\fP
You can specify separate installation prefixes for architecture-specific
files files.
Defaults to \f[I]${prefix}\fP unless otherwise specified.
.TP 8n
\f[CW]--bindir=\fP\f[I]PATH\fP
This directory contains executable programs.  On a network, this
directory may be shared between machines with identical hardware
and operating systems; it may be mounted read-only.  Defaults to
\f[I]${exec_prefix}/bin\fP unless otherwise specified.
.TP 8n
\f[CW]--mandir=\fP\f[I]PATH\fP
This directory contains the on-line manual entries.  On a network, this
directory may be shared between all machines; it may be mounted
read-only.  Defaults to \f[I]${prefix}/man\fP unless otherwise specified.
.PP
The \f[I]configure\fP script ignores most other arguments that you give
it; use the \f[CW]--help\fP option for a complete list.
.br
.ne 2i
.PP
On systems that require unusual options for compilation or linking that
the \f[I]fstrcmp\fP package's \f[I]configure\fP script does not know
about, you can give \f[I]configure\fP initial values for variables by
setting them in the environment.  In Bourne-compatible shells, you can
do that on the command line like this:
.RS
.ft CW
.nf
\f[B]$ \fPCXX='gcc -traditional' LIBS=-lposix ./configure
\f[I]\&...lots of output...\fP
\f[B]$\fP
.fi
.ft R
.RE
Here are the \f[I]make\fP variables that you might want to override with
environment variables when running the \f[I]configure\fP script:
.TP 8n
Variable: CC
C compiler program.  The default is \f[I]cc\fP.
.TP 8n
Variable: CPPFLAGS
Preprocessor flags, commonly defines and include search paths.
Defaults to empty.
It is common to use \f[CW]CPPFLAGS=-I/usr/local/include\fP to access other
installed packages.
.TP 8n
Variable: INSTALL
Program to use to install files.  The default is \f[I]install\fP if you
have it, \f[I]cp\fP otherwise.
.TP 8n
Variable: LIBS
Libraries to link with, in the form \f[CW]-l\fP\f[I]foo\fP
\f[CW]-l\fP\f[I]bar\fP.  The \f[I]configure\fP script will
append to this, rather than replace it.  It is common to use
\f[CW]LIBS=-L/usr/local/lib\fP to access other installed packages.
.PP
If you need to do unusual things to compile the package, the author
encourages you to figure out how the \f[I]configure\fP script could
check whether to do them, and mail diffs or instructions to the author
so that they can be included in the next release.
.br
.ne 1i
.SH BUILDING FSTRCMP
All you should need to do is use the
.RS
.ft CW
.nf
\f[B]% \fPmake
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
command and wait.
.PP
You can remove the program binaries and object files from the
source directory by using the
.RS
.ft CW
.nf
\f[B]% \fPmake clean
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
command.  To remove all of the above files, and also remove the
\f[I]Makefile\fP and \f[I]lib/config.h\fP and \f[I]config.status\fP
files, use the
.RS
.ft CW
.nf
\f[B]% \fPmake distclean
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
command.
.PP
The file \f[I]etc/configure.ac\fP is used to create \f[I]configure\fP
by a GNU program called \f[I]autoconf\fP.  You only need to know this
if you want to regenerate \f[I]configure\fP using a newer version of
\f[I]autoconf\fP.
.br
.ne 1i
.SH TESTING FSTRCMP
The \f[I]fstrcmp\fP package comes with a test suite.  To run this test
suite, use the command
.RS
.ft CW
.nf
\f[B]% \fPmake sure
\f[I]\&...lots of output...\fP
.if n \f[B]Passed All Tests\fP
.if t \f[CB]Passed All Tests\fP
\f[B]%\fP
.fi
.ft R
.RE
.PP
The tests take a fraction of a second each, with most very fast, and a
couple very slow, but it varies greatly depending on your CPU.
.PP
If all went well, the message
.RS
.ft CW
Passed All Tests
.ft R
.RE
should appear at the end of the make.
.br
.ne 1i
.SH INSTALLING FSTRCMP
As explained in the \f[I]SITE CONFIGURATION\fP section, above, the
\f[I]fstrcmp\fP package is installed under the \f[I]/usr/local\fP
tree by default.  Use the \f[CW]--prefix=\fP\f[I]PATH\fP option
to \f[I]configure\fP if you want some other path.  More specific
installation locations are assignable, use the \f[CW]--help\fP option to
the \f[I]configure\fP script for details.
.PP
All that is required to install the \f[I]fstrcmp\fP package is to use the
.RS
.ft CW
.nf
\f[B]% \fPmake install
\f[I]\&...lots of output...\fP
\f[B]%\fP
.fi
.ft R
.RE
command.  Control of the directories used may be found in the first
few lines of the \f[I]Makefile\fP file and the other files written
by the \f[I]configure\fP script; it is best to reconfigure using the
\f[I]configure\fP script, rather than attempting to do this by hand.
.br
.ne 1i
.SH GETTING HELP
If you need assistance with the \f[I]fstrcmp\fP package, please do not
hesitate to contact the author at
.RS
.ft CW
Peter Miller <pmiller@opensource.org.au>
.ft R
.RE
Any and all feedback is welcome.
.PP
When reporting problems, please include the version number given by the
.RS
.ft CW
.nf
\f[B]% \f[P]explain -version
.if n \f[B]explain version\fP \f[I]\*(V)\fP
.if t \f[CB]explain version\fP \f[I]\*(V)\fP
\f[I]\&...warranty disclaimer...\fP
\f[B]%\fP
.fi
.ft R
.RE
command.  Please do not send this example; run the program for the exact
version number.
.br
.ne 2i
.so man/man1/z_copyright.so
.PP
This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at
your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
.PP
It should be in the \f[I]LICENSE\fP file included in the source distribution.
