//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armworkloads

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ApplicationServerConfiguration.
func (a ApplicationServerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "instanceCount", a.InstanceCount)
	populate(objectMap, "subnetId", a.SubnetID)
	populate(objectMap, "virtualMachineConfiguration", a.VirtualMachineConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationServerConfiguration.
func (a *ApplicationServerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &a.InstanceCount)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &a.SubnetID)
			delete(rawMsg, key)
		case "virtualMachineConfiguration":
			err = unpopulate(val, "VirtualMachineConfiguration", &a.VirtualMachineConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupProfile.
func (b BackupProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupEnabled", b.BackupEnabled)
	populate(objectMap, "vaultResourceId", b.VaultResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupProfile.
func (b *BackupProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupEnabled":
			err = unpopulate(val, "BackupEnabled", &b.BackupEnabled)
			delete(rawMsg, key)
		case "vaultResourceId":
			err = unpopulate(val, "VaultResourceID", &b.VaultResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheProfile.
func (c CacheProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cacheResourceId", c.CacheResourceID)
	populate(objectMap, "capacity", c.Capacity)
	populate(objectMap, "family", c.Family)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "skuName", c.SKUName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheProfile.
func (c *CacheProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheResourceId":
			err = unpopulate(val, "CacheResourceID", &c.CacheResourceID)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &c.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &c.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &c.SKUName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CentralServerConfiguration.
func (c CentralServerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "instanceCount", c.InstanceCount)
	populate(objectMap, "subnetId", c.SubnetID)
	populate(objectMap, "virtualMachineConfiguration", c.VirtualMachineConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CentralServerConfiguration.
func (c *CentralServerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &c.InstanceCount)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &c.SubnetID)
			delete(rawMsg, key)
		case "virtualMachineConfiguration":
			err = unpopulate(val, "VirtualMachineConfiguration", &c.VirtualMachineConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CentralServerVMDetails.
func (c CentralServerVMDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", c.Type)
	populate(objectMap, "virtualMachineId", c.VirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CentralServerVMDetails.
func (c *CentralServerVMDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &c.VirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DB2ProviderInstanceProperties.
func (d DB2ProviderInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dbName", d.DbName)
	populate(objectMap, "dbPassword", d.DbPassword)
	populate(objectMap, "dbPasswordUri", d.DbPasswordURI)
	populate(objectMap, "dbPort", d.DbPort)
	populate(objectMap, "dbUsername", d.DbUsername)
	populate(objectMap, "hostname", d.Hostname)
	objectMap["providerType"] = "Db2"
	populate(objectMap, "sapSid", d.SapSid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DB2ProviderInstanceProperties.
func (d *DB2ProviderInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dbName":
			err = unpopulate(val, "DbName", &d.DbName)
			delete(rawMsg, key)
		case "dbPassword":
			err = unpopulate(val, "DbPassword", &d.DbPassword)
			delete(rawMsg, key)
		case "dbPasswordUri":
			err = unpopulate(val, "DbPasswordURI", &d.DbPasswordURI)
			delete(rawMsg, key)
		case "dbPort":
			err = unpopulate(val, "DbPort", &d.DbPort)
			delete(rawMsg, key)
		case "dbUsername":
			err = unpopulate(val, "DbUsername", &d.DbUsername)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &d.Hostname)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &d.ProviderType)
			delete(rawMsg, key)
		case "sapSid":
			err = unpopulate(val, "SapSid", &d.SapSid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseConfiguration.
func (d DatabaseConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseType", d.DatabaseType)
	populate(objectMap, "instanceCount", d.InstanceCount)
	populate(objectMap, "subnetId", d.SubnetID)
	populate(objectMap, "virtualMachineConfiguration", d.VirtualMachineConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseConfiguration.
func (d *DatabaseConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &d.DatabaseType)
			delete(rawMsg, key)
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &d.InstanceCount)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &d.SubnetID)
			delete(rawMsg, key)
		case "virtualMachineConfiguration":
			err = unpopulate(val, "VirtualMachineConfiguration", &d.VirtualMachineConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseProfile.
func (d DatabaseProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupRetentionDays", d.BackupRetentionDays)
	populate(objectMap, "haEnabled", d.HaEnabled)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "sslEnforcementEnabled", d.SSLEnforcementEnabled)
	populate(objectMap, "serverName", d.ServerName)
	populate(objectMap, "serverResourceId", d.ServerResourceID)
	populate(objectMap, "storageInGB", d.StorageInGB)
	populate(objectMap, "storageIops", d.StorageIops)
	populate(objectMap, "storageSku", d.StorageSKU)
	populate(objectMap, "tier", d.Tier)
	populate(objectMap, "type", d.Type)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseProfile.
func (d *DatabaseProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupRetentionDays":
			err = unpopulate(val, "BackupRetentionDays", &d.BackupRetentionDays)
			delete(rawMsg, key)
		case "haEnabled":
			err = unpopulate(val, "HaEnabled", &d.HaEnabled)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "sslEnforcementEnabled":
			err = unpopulate(val, "SSLEnforcementEnabled", &d.SSLEnforcementEnabled)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &d.ServerName)
			delete(rawMsg, key)
		case "serverResourceId":
			err = unpopulate(val, "ServerResourceID", &d.ServerResourceID)
			delete(rawMsg, key)
		case "storageInGB":
			err = unpopulate(val, "StorageInGB", &d.StorageInGB)
			delete(rawMsg, key)
		case "storageIops":
			err = unpopulate(val, "StorageIops", &d.StorageIops)
			delete(rawMsg, key)
		case "storageSku":
			err = unpopulate(val, "StorageSKU", &d.StorageSKU)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &d.Tier)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseVMDetails.
func (d DatabaseVMDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "status", d.Status)
	populate(objectMap, "virtualMachineId", d.VirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseVMDetails.
func (d *DatabaseVMDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &d.VirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeployerVMPackages.
func (d DeployerVMPackages) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "storageAccountId", d.StorageAccountID)
	populate(objectMap, "url", d.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeployerVMPackages.
func (d *DeployerVMPackages) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &d.StorageAccountID)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &d.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentConfiguration.
func (d DeploymentConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appLocation", d.AppLocation)
	objectMap["configurationType"] = SAPConfigurationTypeDeployment
	populate(objectMap, "infrastructureConfiguration", d.InfrastructureConfiguration)
	populate(objectMap, "softwareConfiguration", d.SoftwareConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentConfiguration.
func (d *DeploymentConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appLocation":
			err = unpopulate(val, "AppLocation", &d.AppLocation)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &d.ConfigurationType)
			delete(rawMsg, key)
		case "infrastructureConfiguration":
			d.InfrastructureConfiguration, err = unmarshalInfrastructureConfigurationClassification(val)
			delete(rawMsg, key)
		case "softwareConfiguration":
			d.SoftwareConfiguration, err = unmarshalSoftwareConfigurationClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentWithOSConfiguration.
func (d DeploymentWithOSConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appLocation", d.AppLocation)
	objectMap["configurationType"] = SAPConfigurationTypeDeploymentWithOSConfig
	populate(objectMap, "infrastructureConfiguration", d.InfrastructureConfiguration)
	populate(objectMap, "osSapConfiguration", d.OSSapConfiguration)
	populate(objectMap, "softwareConfiguration", d.SoftwareConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentWithOSConfiguration.
func (d *DeploymentWithOSConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appLocation":
			err = unpopulate(val, "AppLocation", &d.AppLocation)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &d.ConfigurationType)
			delete(rawMsg, key)
		case "infrastructureConfiguration":
			d.InfrastructureConfiguration, err = unmarshalInfrastructureConfigurationClassification(val)
			delete(rawMsg, key)
		case "osSapConfiguration":
			err = unpopulate(val, "OSSapConfiguration", &d.OSSapConfiguration)
			delete(rawMsg, key)
		case "softwareConfiguration":
			d.SoftwareConfiguration, err = unmarshalSoftwareConfigurationClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoveryConfiguration.
func (d DiscoveryConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appLocation", d.AppLocation)
	populate(objectMap, "centralServerVmId", d.CentralServerVMID)
	objectMap["configurationType"] = SAPConfigurationTypeDiscovery
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoveryConfiguration.
func (d *DiscoveryConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appLocation":
			err = unpopulate(val, "AppLocation", &d.AppLocation)
			delete(rawMsg, key)
		case "centralServerVmId":
			err = unpopulate(val, "CentralServerVMID", &d.CentralServerVMID)
			delete(rawMsg, key)
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &d.ConfigurationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskInfo.
func (d DiskInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sizeInGB", d.SizeInGB)
	populate(objectMap, "storageType", d.StorageType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskInfo.
func (d *DiskInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sizeInGB":
			err = unpopulate(val, "SizeInGB", &d.SizeInGB)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &d.StorageType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnqueueReplicationServerProperties.
func (e EnqueueReplicationServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ersVersion", e.ErsVersion)
	populate(objectMap, "health", e.Health)
	populate(objectMap, "hostname", e.Hostname)
	populate(objectMap, "ipAddress", e.IPAddress)
	populate(objectMap, "instanceNo", e.InstanceNo)
	populate(objectMap, "kernelPatch", e.KernelPatch)
	populate(objectMap, "kernelVersion", e.KernelVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnqueueReplicationServerProperties.
func (e *EnqueueReplicationServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ersVersion":
			err = unpopulate(val, "ErsVersion", &e.ErsVersion)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &e.Health)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &e.Hostname)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &e.IPAddress)
			delete(rawMsg, key)
		case "instanceNo":
			err = unpopulate(val, "InstanceNo", &e.InstanceNo)
			delete(rawMsg, key)
		case "kernelPatch":
			err = unpopulate(val, "KernelPatch", &e.KernelPatch)
			delete(rawMsg, key)
		case "kernelVersion":
			err = unpopulate(val, "KernelVersion", &e.KernelVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnqueueServerProperties.
func (e EnqueueServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "health", e.Health)
	populate(objectMap, "hostname", e.Hostname)
	populate(objectMap, "ipAddress", e.IPAddress)
	populate(objectMap, "port", e.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnqueueServerProperties.
func (e *EnqueueServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "health":
			err = unpopulate(val, "Health", &e.Health)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &e.Hostname)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &e.IPAddress)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &e.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "innerError", e.InnerError)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "info", &e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinition.
func (e ErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinition.
func (e *ErrorDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorInnerError.
func (e ErrorInnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "innerError", e.InnerError)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorInnerError.
func (e *ErrorInnerError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileshareProfile.
func (f FileshareProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "shareName", f.ShareName)
	populate(objectMap, "shareSizeInGB", f.ShareSizeInGB)
	populate(objectMap, "shareType", f.ShareType)
	populate(objectMap, "storageResourceId", f.StorageResourceID)
	populate(objectMap, "storageType", f.StorageType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileshareProfile.
func (f *FileshareProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "shareName":
			err = unpopulate(val, "ShareName", &f.ShareName)
			delete(rawMsg, key)
		case "shareSizeInGB":
			err = unpopulate(val, "ShareSizeInGB", &f.ShareSizeInGB)
			delete(rawMsg, key)
		case "shareType":
			err = unpopulate(val, "ShareType", &f.ShareType)
			delete(rawMsg, key)
		case "storageResourceId":
			err = unpopulate(val, "StorageResourceID", &f.StorageResourceID)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &f.StorageType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayServerProperties.
func (g GatewayServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "health", g.Health)
	populate(objectMap, "port", g.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayServerProperties.
func (g *GatewayServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "health":
			err = unpopulate(val, "Health", &g.Health)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &g.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HanaDbProviderInstanceProperties.
func (h HanaDbProviderInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dbName", h.DbName)
	populate(objectMap, "dbPassword", h.DbPassword)
	populate(objectMap, "dbPasswordUri", h.DbPasswordURI)
	populate(objectMap, "dbSslCertificateUri", h.DbSSLCertificateURI)
	populate(objectMap, "dbUsername", h.DbUsername)
	populate(objectMap, "hostname", h.Hostname)
	populate(objectMap, "instanceNumber", h.InstanceNumber)
	objectMap["providerType"] = "SapHana"
	populate(objectMap, "sqlPort", h.SQLPort)
	populate(objectMap, "sslHostNameInCertificate", h.SSLHostNameInCertificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HanaDbProviderInstanceProperties.
func (h *HanaDbProviderInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dbName":
			err = unpopulate(val, "DbName", &h.DbName)
			delete(rawMsg, key)
		case "dbPassword":
			err = unpopulate(val, "DbPassword", &h.DbPassword)
			delete(rawMsg, key)
		case "dbPasswordUri":
			err = unpopulate(val, "DbPasswordURI", &h.DbPasswordURI)
			delete(rawMsg, key)
		case "dbSslCertificateUri":
			err = unpopulate(val, "DbSSLCertificateURI", &h.DbSSLCertificateURI)
			delete(rawMsg, key)
		case "dbUsername":
			err = unpopulate(val, "DbUsername", &h.DbUsername)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &h.Hostname)
			delete(rawMsg, key)
		case "instanceNumber":
			err = unpopulate(val, "InstanceNumber", &h.InstanceNumber)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &h.ProviderType)
			delete(rawMsg, key)
		case "sqlPort":
			err = unpopulate(val, "SQLPort", &h.SQLPort)
			delete(rawMsg, key)
		case "sslHostNameInCertificate":
			err = unpopulate(val, "SSLHostNameInCertificate", &h.SSLHostNameInCertificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HighAvailabilityConfiguration.
func (h HighAvailabilityConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "highAvailabilityType", h.HighAvailabilityType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HighAvailabilityConfiguration.
func (h *HighAvailabilityConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "highAvailabilityType":
			err = unpopulate(val, "HighAvailabilityType", &h.HighAvailabilityType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HighAvailabilitySoftwareConfiguration.
func (h HighAvailabilitySoftwareConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fencingClientId", h.FencingClientID)
	populate(objectMap, "fencingClientPassword", h.FencingClientPassword)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HighAvailabilitySoftwareConfiguration.
func (h *HighAvailabilitySoftwareConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fencingClientId":
			err = unpopulate(val, "FencingClientID", &h.FencingClientID)
			delete(rawMsg, key)
		case "fencingClientPassword":
			err = unpopulate(val, "FencingClientPassword", &h.FencingClientPassword)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageReference.
func (i ImageReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "exactVersion", i.ExactVersion)
	populate(objectMap, "offer", i.Offer)
	populate(objectMap, "publisher", i.Publisher)
	populate(objectMap, "sku", i.SKU)
	populate(objectMap, "sharedGalleryImageId", i.SharedGalleryImageID)
	populate(objectMap, "version", i.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageReference.
func (i *ImageReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exactVersion":
			err = unpopulate(val, "ExactVersion", &i.ExactVersion)
			delete(rawMsg, key)
		case "offer":
			err = unpopulate(val, "Offer", &i.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &i.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &i.SKU)
			delete(rawMsg, key)
		case "sharedGalleryImageId":
			err = unpopulate(val, "SharedGalleryImageID", &i.SharedGalleryImageID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InfrastructureConfiguration.
func (i InfrastructureConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appResourceGroup", i.AppResourceGroup)
	objectMap["deploymentType"] = i.DeploymentType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InfrastructureConfiguration.
func (i *InfrastructureConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appResourceGroup":
			err = unpopulate(val, "AppResourceGroup", &i.AppResourceGroup)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &i.DeploymentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxConfiguration.
func (l LinuxConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disablePasswordAuthentication", l.DisablePasswordAuthentication)
	objectMap["osType"] = OSTypeLinux
	populate(objectMap, "ssh", l.SSH)
	populate(objectMap, "sshKeyPair", l.SSHKeyPair)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxConfiguration.
func (l *LinuxConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disablePasswordAuthentication":
			err = unpopulate(val, "DisablePasswordAuthentication", &l.DisablePasswordAuthentication)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &l.OSType)
			delete(rawMsg, key)
		case "ssh":
			err = unpopulate(val, "SSH", &l.SSH)
			delete(rawMsg, key)
		case "sshKeyPair":
			err = unpopulate(val, "SSHKeyPair", &l.SSHKeyPair)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRGConfiguration.
func (m ManagedRGConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", m.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRGConfiguration.
func (m *ManagedRGConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MessageServerProperties.
func (m MessageServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "httpPort", m.HTTPPort)
	populate(objectMap, "httpsPort", m.HTTPSPort)
	populate(objectMap, "health", m.Health)
	populate(objectMap, "hostname", m.Hostname)
	populate(objectMap, "ipAddress", m.IPAddress)
	populate(objectMap, "internalMsPort", m.InternalMsPort)
	populate(objectMap, "msPort", m.MSPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MessageServerProperties.
func (m *MessageServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpPort":
			err = unpopulate(val, "HTTPPort", &m.HTTPPort)
			delete(rawMsg, key)
		case "httpsPort":
			err = unpopulate(val, "HTTPSPort", &m.HTTPSPort)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &m.Health)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &m.Hostname)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &m.IPAddress)
			delete(rawMsg, key)
		case "internalMsPort":
			err = unpopulate(val, "InternalMsPort", &m.InternalMsPort)
			delete(rawMsg, key)
		case "msPort":
			err = unpopulate(val, "MSPort", &m.MSPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Monitor.
func (m Monitor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Monitor.
func (m *Monitor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MonitorListResult.
func (m MonitorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MonitorListResult.
func (m *MonitorListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MonitorProperties.
func (m MonitorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appLocation", m.AppLocation)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "logAnalyticsWorkspaceArmId", m.LogAnalyticsWorkspaceArmID)
	populate(objectMap, "managedResourceGroupConfiguration", m.ManagedResourceGroupConfiguration)
	populate(objectMap, "monitorSubnet", m.MonitorSubnet)
	populate(objectMap, "msiArmId", m.MsiArmID)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "routingPreference", m.RoutingPreference)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MonitorProperties.
func (m *MonitorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appLocation":
			err = unpopulate(val, "AppLocation", &m.AppLocation)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "logAnalyticsWorkspaceArmId":
			err = unpopulate(val, "LogAnalyticsWorkspaceArmID", &m.LogAnalyticsWorkspaceArmID)
			delete(rawMsg, key)
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &m.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "monitorSubnet":
			err = unpopulate(val, "MonitorSubnet", &m.MonitorSubnet)
			delete(rawMsg, key)
		case "msiArmId":
			err = unpopulate(val, "MsiArmID", &m.MsiArmID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "routingPreference":
			err = unpopulate(val, "RoutingPreference", &m.RoutingPreference)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MonitorPropertiesErrors.
func (m MonitorPropertiesErrors) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", m.Code)
	populate(objectMap, "details", m.Details)
	populate(objectMap, "innerError", m.InnerError)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "target", m.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MonitorPropertiesErrors.
func (m *MonitorPropertiesErrors) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &m.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &m.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &m.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MsSQLServerProviderInstanceProperties.
func (m MsSQLServerProviderInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dbPassword", m.DbPassword)
	populate(objectMap, "dbPasswordUri", m.DbPasswordURI)
	populate(objectMap, "dbPort", m.DbPort)
	populate(objectMap, "dbUsername", m.DbUsername)
	populate(objectMap, "hostname", m.Hostname)
	objectMap["providerType"] = "MsSqlServer"
	populate(objectMap, "sapSid", m.SapSid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MsSQLServerProviderInstanceProperties.
func (m *MsSQLServerProviderInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dbPassword":
			err = unpopulate(val, "DbPassword", &m.DbPassword)
			delete(rawMsg, key)
		case "dbPasswordUri":
			err = unpopulate(val, "DbPasswordURI", &m.DbPasswordURI)
			delete(rawMsg, key)
		case "dbPort":
			err = unpopulate(val, "DbPort", &m.DbPort)
			delete(rawMsg, key)
		case "dbUsername":
			err = unpopulate(val, "DbUsername", &m.DbUsername)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &m.Hostname)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &m.ProviderType)
			delete(rawMsg, key)
		case "sapSid":
			err = unpopulate(val, "SapSid", &m.SapSid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkConfiguration.
func (n NetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isSecondaryIpEnabled", n.IsSecondaryIPEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkConfiguration.
func (n *NetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isSecondaryIpEnabled":
			err = unpopulate(val, "IsSecondaryIPEnabled", &n.IsSecondaryIPEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureFrontDoorEnabled", n.AzureFrontDoorEnabled)
	populate(objectMap, "azureFrontDoorResourceId", n.AzureFrontDoorResourceID)
	populate(objectMap, "capacity", n.Capacity)
	populate(objectMap, "frontEndPublicIpResourceId", n.FrontEndPublicIPResourceID)
	populate(objectMap, "loadBalancerResourceId", n.LoadBalancerResourceID)
	populate(objectMap, "loadBalancerSku", n.LoadBalancerSKU)
	populate(objectMap, "loadBalancerTier", n.LoadBalancerTier)
	populate(objectMap, "loadBalancerType", n.LoadBalancerType)
	populate(objectMap, "outboundPublicIpResourceIds", n.OutboundPublicIPResourceIDs)
	populate(objectMap, "vNetResourceId", n.VNetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFrontDoorEnabled":
			err = unpopulate(val, "AzureFrontDoorEnabled", &n.AzureFrontDoorEnabled)
			delete(rawMsg, key)
		case "azureFrontDoorResourceId":
			err = unpopulate(val, "AzureFrontDoorResourceID", &n.AzureFrontDoorResourceID)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &n.Capacity)
			delete(rawMsg, key)
		case "frontEndPublicIpResourceId":
			err = unpopulate(val, "FrontEndPublicIPResourceID", &n.FrontEndPublicIPResourceID)
			delete(rawMsg, key)
		case "loadBalancerResourceId":
			err = unpopulate(val, "LoadBalancerResourceID", &n.LoadBalancerResourceID)
			delete(rawMsg, key)
		case "loadBalancerSku":
			err = unpopulate(val, "LoadBalancerSKU", &n.LoadBalancerSKU)
			delete(rawMsg, key)
		case "loadBalancerTier":
			err = unpopulate(val, "LoadBalancerTier", &n.LoadBalancerTier)
			delete(rawMsg, key)
		case "loadBalancerType":
			err = unpopulate(val, "LoadBalancerType", &n.LoadBalancerType)
			delete(rawMsg, key)
		case "outboundPublicIpResourceIds":
			err = unpopulate(val, "OutboundPublicIPResourceIDs", &n.OutboundPublicIPResourceIDs)
			delete(rawMsg, key)
		case "vNetResourceId":
			err = unpopulate(val, "VNetResourceID", &n.VNetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NodeProfile.
func (n NodeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDisks", n.DataDisks)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "nodeResourceIds", n.NodeResourceIDs)
	populate(objectMap, "nodeSku", n.NodeSKU)
	populate(objectMap, "osDisk", n.OSDisk)
	populate(objectMap, "osImage", n.OSImage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NodeProfile.
func (n *NodeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &n.DataDisks)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "nodeResourceIds":
			err = unpopulate(val, "NodeResourceIDs", &n.NodeResourceIDs)
			delete(rawMsg, key)
		case "nodeSku":
			err = unpopulate(val, "NodeSKU", &n.NodeSKU)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &n.OSDisk)
			delete(rawMsg, key)
		case "osImage":
			err = unpopulate(val, "OSImage", &n.OSImage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSConfiguration.
func (o OSConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["osType"] = o.OSType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSConfiguration.
func (o *OSConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osType":
			err = unpopulate(val, "OSType", &o.OSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSProfile.
func (o OSProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminPassword", o.AdminPassword)
	populate(objectMap, "adminUsername", o.AdminUsername)
	populate(objectMap, "osConfiguration", o.OSConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSProfile.
func (o *OSProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &o.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &o.AdminUsername)
			delete(rawMsg, key)
		case "osConfiguration":
			o.OSConfiguration, err = unmarshalOSConfigurationClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatusResult.
func (o OperationStatusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "operations", o.Operations)
	populate(objectMap, "percentComplete", o.PercentComplete)
	populateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusResult.
func (o *OperationStatusResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "operations":
			err = unpopulate(val, "Operations", &o.Operations)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &o.PercentComplete)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsContent.
func (o OperationsContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsContent.
func (o *OperationsContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDefinition.
func (o OperationsDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populate(objectMap, "properties", &o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDefinition.
func (o *OperationsDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDefinitionArrayResponseWithContinuation.
func (o OperationsDefinitionArrayResponseWithContinuation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDefinitionArrayResponseWithContinuation.
func (o *OperationsDefinitionArrayResponseWithContinuation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDefinitionDisplay.
func (o OperationsDefinitionDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDefinitionDisplay.
func (o *OperationsDefinitionDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDisplayDefinition.
func (o OperationsDisplayDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDisplayDefinition.
func (o *OperationsDisplayDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsImageProfile.
func (o OsImageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "offer", o.Offer)
	populate(objectMap, "publisher", o.Publisher)
	populate(objectMap, "sku", o.SKU)
	populate(objectMap, "version", o.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsImageProfile.
func (o *OsImageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "offer":
			err = unpopulate(val, "Offer", &o.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &o.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &o.SKU)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &o.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsSapConfiguration.
func (o OsSapConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deployerVmPackages", o.DeployerVMPackages)
	populate(objectMap, "sapFqdn", o.SapFqdn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsSapConfiguration.
func (o *OsSapConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deployerVmPackages":
			err = unpopulate(val, "DeployerVMPackages", &o.DeployerVMPackages)
			delete(rawMsg, key)
		case "sapFqdn":
			err = unpopulate(val, "SapFqdn", &o.SapFqdn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchResourceRequestBody.
func (p PatchResourceRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchResourceRequestBody.
func (p *PatchResourceRequestBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchResourceRequestBodyIdentity.
func (p PatchResourceRequestBodyIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", p.Type)
	populate(objectMap, "userAssignedIdentities", p.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchResourceRequestBodyIdentity.
func (p *PatchResourceRequestBodyIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &p.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PhpProfile.
func (p PhpProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PhpProfile.
func (p *PhpProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PhpWorkloadResource.
func (p PhpWorkloadResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PhpWorkloadResource.
func (p *PhpWorkloadResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PhpWorkloadResourceIdentity.
func (p PhpWorkloadResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", p.Type)
	populate(objectMap, "userAssignedIdentities", p.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PhpWorkloadResourceIdentity.
func (p *PhpWorkloadResourceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &p.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PhpWorkloadResourceList.
func (p PhpWorkloadResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PhpWorkloadResourceList.
func (p *PhpWorkloadResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PhpWorkloadResourceProperties.
func (p PhpWorkloadResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminUserProfile", p.AdminUserProfile)
	populate(objectMap, "appLocation", p.AppLocation)
	populate(objectMap, "backupProfile", p.BackupProfile)
	populate(objectMap, "cacheProfile", p.CacheProfile)
	populate(objectMap, "controllerProfile", p.ControllerProfile)
	populate(objectMap, "databaseProfile", p.DatabaseProfile)
	populate(objectMap, "fileshareProfile", p.FileshareProfile)
	populate(objectMap, "managedResourceGroupConfiguration", p.ManagedResourceGroupConfiguration)
	populate(objectMap, "networkProfile", p.NetworkProfile)
	populate(objectMap, "phpProfile", p.PhpProfile)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "searchProfile", p.SearchProfile)
	populate(objectMap, "siteProfile", p.SiteProfile)
	populate(objectMap, "webNodesProfile", p.WebNodesProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PhpWorkloadResourceProperties.
func (p *PhpWorkloadResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUserProfile":
			err = unpopulate(val, "AdminUserProfile", &p.AdminUserProfile)
			delete(rawMsg, key)
		case "appLocation":
			err = unpopulate(val, "AppLocation", &p.AppLocation)
			delete(rawMsg, key)
		case "backupProfile":
			err = unpopulate(val, "BackupProfile", &p.BackupProfile)
			delete(rawMsg, key)
		case "cacheProfile":
			err = unpopulate(val, "CacheProfile", &p.CacheProfile)
			delete(rawMsg, key)
		case "controllerProfile":
			err = unpopulate(val, "ControllerProfile", &p.ControllerProfile)
			delete(rawMsg, key)
		case "databaseProfile":
			err = unpopulate(val, "DatabaseProfile", &p.DatabaseProfile)
			delete(rawMsg, key)
		case "fileshareProfile":
			err = unpopulate(val, "FileshareProfile", &p.FileshareProfile)
			delete(rawMsg, key)
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &p.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &p.NetworkProfile)
			delete(rawMsg, key)
		case "phpProfile":
			err = unpopulate(val, "PhpProfile", &p.PhpProfile)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "searchProfile":
			err = unpopulate(val, "SearchProfile", &p.SearchProfile)
			delete(rawMsg, key)
		case "siteProfile":
			err = unpopulate(val, "SiteProfile", &p.SiteProfile)
			delete(rawMsg, key)
		case "webNodesProfile":
			err = unpopulate(val, "WebNodesProfile", &p.WebNodesProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrometheusHaClusterProviderInstanceProperties.
func (p PrometheusHaClusterProviderInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clusterName", p.ClusterName)
	populate(objectMap, "hostname", p.Hostname)
	populate(objectMap, "prometheusUrl", p.PrometheusURL)
	objectMap["providerType"] = "PrometheusHaCluster"
	populate(objectMap, "sid", p.Sid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrometheusHaClusterProviderInstanceProperties.
func (p *PrometheusHaClusterProviderInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterName":
			err = unpopulate(val, "ClusterName", &p.ClusterName)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &p.Hostname)
			delete(rawMsg, key)
		case "prometheusUrl":
			err = unpopulate(val, "PrometheusURL", &p.PrometheusURL)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &p.ProviderType)
			delete(rawMsg, key)
		case "sid":
			err = unpopulate(val, "Sid", &p.Sid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrometheusOSProviderInstanceProperties.
func (p PrometheusOSProviderInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "prometheusUrl", p.PrometheusURL)
	objectMap["providerType"] = "PrometheusOS"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrometheusOSProviderInstanceProperties.
func (p *PrometheusOSProviderInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "prometheusUrl":
			err = unpopulate(val, "PrometheusURL", &p.PrometheusURL)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &p.ProviderType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderInstance.
func (p ProviderInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderInstance.
func (p *ProviderInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderInstanceListResult.
func (p ProviderInstanceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderInstanceListResult.
func (p *ProviderInstanceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderInstanceProperties.
func (p ProviderInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errors", p.Errors)
	populate(objectMap, "providerSettings", p.ProviderSettings)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderInstanceProperties.
func (p *ProviderInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &p.Errors)
			delete(rawMsg, key)
		case "providerSettings":
			p.ProviderSettings, err = unmarshalProviderSpecificPropertiesClassification(val)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderInstancePropertiesErrors.
func (p ProviderInstancePropertiesErrors) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", p.Code)
	populate(objectMap, "details", p.Details)
	populate(objectMap, "innerError", p.InnerError)
	populate(objectMap, "message", p.Message)
	populate(objectMap, "target", p.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderInstancePropertiesErrors.
func (p *ProviderInstancePropertiesErrors) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &p.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &p.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &p.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &p.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &p.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderSpecificProperties.
func (p ProviderSpecificProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["providerType"] = p.ProviderType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderSpecificProperties.
func (p *ProviderSpecificProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerType":
			err = unpopulate(val, "ProviderType", &p.ProviderType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestrictionInfo.
func (r RestrictionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "locations", r.Locations)
	populate(objectMap, "zones", r.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestrictionInfo.
func (r *RestrictionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locations":
			err = unpopulate(val, "Locations", &r.Locations)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &r.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPApplicationServerInstance.
func (s SAPApplicationServerInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPApplicationServerInstance.
func (s *SAPApplicationServerInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPApplicationServerInstanceList.
func (s SAPApplicationServerInstanceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPApplicationServerInstanceList.
func (s *SAPApplicationServerInstanceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPApplicationServerProperties.
func (s SAPApplicationServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errors", s.Errors)
	populate(objectMap, "gatewayPort", s.GatewayPort)
	populate(objectMap, "health", s.Health)
	populate(objectMap, "hostname", s.Hostname)
	populate(objectMap, "ipAddress", s.IPAddress)
	populate(objectMap, "icmHttpPort", s.IcmHTTPPort)
	populate(objectMap, "icmHttpsPort", s.IcmHTTPSPort)
	populate(objectMap, "instanceNo", s.InstanceNo)
	populate(objectMap, "kernelPatch", s.KernelPatch)
	populate(objectMap, "kernelVersion", s.KernelVersion)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "subnet", s.Subnet)
	populate(objectMap, "virtualMachineId", s.VirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPApplicationServerProperties.
func (s *SAPApplicationServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &s.Errors)
			delete(rawMsg, key)
		case "gatewayPort":
			err = unpopulate(val, "GatewayPort", &s.GatewayPort)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &s.Health)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &s.Hostname)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &s.IPAddress)
			delete(rawMsg, key)
		case "icmHttpPort":
			err = unpopulate(val, "IcmHTTPPort", &s.IcmHTTPPort)
			delete(rawMsg, key)
		case "icmHttpsPort":
			err = unpopulate(val, "IcmHTTPSPort", &s.IcmHTTPSPort)
			delete(rawMsg, key)
		case "instanceNo":
			err = unpopulate(val, "InstanceNo", &s.InstanceNo)
			delete(rawMsg, key)
		case "kernelPatch":
			err = unpopulate(val, "KernelPatch", &s.KernelPatch)
			delete(rawMsg, key)
		case "kernelVersion":
			err = unpopulate(val, "KernelVersion", &s.KernelVersion)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &s.Subnet)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &s.VirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPAvailabilityZoneDetailsRequest.
func (s SAPAvailabilityZoneDetailsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appLocation", s.AppLocation)
	populate(objectMap, "databaseType", s.DatabaseType)
	populate(objectMap, "sapProduct", s.SapProduct)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPAvailabilityZoneDetailsRequest.
func (s *SAPAvailabilityZoneDetailsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appLocation":
			err = unpopulate(val, "AppLocation", &s.AppLocation)
			delete(rawMsg, key)
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &s.DatabaseType)
			delete(rawMsg, key)
		case "sapProduct":
			err = unpopulate(val, "SapProduct", &s.SapProduct)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPAvailabilityZoneDetailsResult.
func (s SAPAvailabilityZoneDetailsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availabilityZonePairs", s.AvailabilityZonePairs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPAvailabilityZoneDetailsResult.
func (s *SAPAvailabilityZoneDetailsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZonePairs":
			err = unpopulate(val, "AvailabilityZonePairs", &s.AvailabilityZonePairs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPAvailabilityZonePair.
func (s SAPAvailabilityZonePair) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "zoneA", s.ZoneA)
	populate(objectMap, "zoneB", s.ZoneB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPAvailabilityZonePair.
func (s *SAPAvailabilityZonePair) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "zoneA":
			err = unpopulate(val, "ZoneA", &s.ZoneA)
			delete(rawMsg, key)
		case "zoneB":
			err = unpopulate(val, "ZoneB", &s.ZoneB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPCentralInstanceList.
func (s SAPCentralInstanceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPCentralInstanceList.
func (s *SAPCentralInstanceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPCentralServerInstance.
func (s SAPCentralServerInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPCentralServerInstance.
func (s *SAPCentralServerInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPCentralServerProperties.
func (s SAPCentralServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enqueueReplicationServerProperties", s.EnqueueReplicationServerProperties)
	populate(objectMap, "enqueueServerProperties", s.EnqueueServerProperties)
	populate(objectMap, "errors", s.Errors)
	populate(objectMap, "gatewayServerProperties", s.GatewayServerProperties)
	populate(objectMap, "health", s.Health)
	populate(objectMap, "instanceNo", s.InstanceNo)
	populate(objectMap, "kernelPatch", s.KernelPatch)
	populate(objectMap, "kernelVersion", s.KernelVersion)
	populate(objectMap, "messageServerProperties", s.MessageServerProperties)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "subnet", s.Subnet)
	populate(objectMap, "vmDetails", s.VMDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPCentralServerProperties.
func (s *SAPCentralServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enqueueReplicationServerProperties":
			err = unpopulate(val, "EnqueueReplicationServerProperties", &s.EnqueueReplicationServerProperties)
			delete(rawMsg, key)
		case "enqueueServerProperties":
			err = unpopulate(val, "EnqueueServerProperties", &s.EnqueueServerProperties)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &s.Errors)
			delete(rawMsg, key)
		case "gatewayServerProperties":
			err = unpopulate(val, "GatewayServerProperties", &s.GatewayServerProperties)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &s.Health)
			delete(rawMsg, key)
		case "instanceNo":
			err = unpopulate(val, "InstanceNo", &s.InstanceNo)
			delete(rawMsg, key)
		case "kernelPatch":
			err = unpopulate(val, "KernelPatch", &s.KernelPatch)
			delete(rawMsg, key)
		case "kernelVersion":
			err = unpopulate(val, "KernelVersion", &s.KernelVersion)
			delete(rawMsg, key)
		case "messageServerProperties":
			err = unpopulate(val, "MessageServerProperties", &s.MessageServerProperties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &s.Subnet)
			delete(rawMsg, key)
		case "vmDetails":
			err = unpopulate(val, "VMDetails", &s.VMDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPConfiguration.
func (s SAPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["configurationType"] = s.ConfigurationType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPConfiguration.
func (s *SAPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &s.ConfigurationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPDatabaseInstance.
func (s SAPDatabaseInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPDatabaseInstance.
func (s *SAPDatabaseInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPDatabaseInstanceList.
func (s SAPDatabaseInstanceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPDatabaseInstanceList.
func (s *SAPDatabaseInstanceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPDatabaseProperties.
func (s SAPDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseSid", s.DatabaseSid)
	populate(objectMap, "databaseType", s.DatabaseType)
	populate(objectMap, "errors", s.Errors)
	populate(objectMap, "ipAddress", s.IPAddress)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "subnet", s.Subnet)
	populate(objectMap, "vmDetails", s.VMDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPDatabaseProperties.
func (s *SAPDatabaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseSid":
			err = unpopulate(val, "DatabaseSid", &s.DatabaseSid)
			delete(rawMsg, key)
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &s.DatabaseType)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &s.Errors)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &s.IPAddress)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &s.Subnet)
			delete(rawMsg, key)
		case "vmDetails":
			err = unpopulate(val, "VMDetails", &s.VMDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPDiskConfiguration.
func (s SAPDiskConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskCount", s.DiskCount)
	populate(objectMap, "diskIopsReadWrite", s.DiskIopsReadWrite)
	populate(objectMap, "diskMBpsReadWrite", s.DiskMBpsReadWrite)
	populate(objectMap, "diskSizeGB", s.DiskSizeGB)
	populate(objectMap, "diskStorageType", s.DiskStorageType)
	populate(objectMap, "diskType", s.DiskType)
	populate(objectMap, "volume", s.Volume)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPDiskConfiguration.
func (s *SAPDiskConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskCount":
			err = unpopulate(val, "DiskCount", &s.DiskCount)
			delete(rawMsg, key)
		case "diskIopsReadWrite":
			err = unpopulate(val, "DiskIopsReadWrite", &s.DiskIopsReadWrite)
			delete(rawMsg, key)
		case "diskMBpsReadWrite":
			err = unpopulate(val, "DiskMBpsReadWrite", &s.DiskMBpsReadWrite)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &s.DiskSizeGB)
			delete(rawMsg, key)
		case "diskStorageType":
			err = unpopulate(val, "DiskStorageType", &s.DiskStorageType)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &s.DiskType)
			delete(rawMsg, key)
		case "volume":
			err = unpopulate(val, "Volume", &s.Volume)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPDiskConfigurationsRequest.
func (s SAPDiskConfigurationsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appLocation", s.AppLocation)
	populate(objectMap, "databaseType", s.DatabaseType)
	populate(objectMap, "dbVmSku", s.DbVMSKU)
	populate(objectMap, "deploymentType", s.DeploymentType)
	populate(objectMap, "environment", s.Environment)
	populate(objectMap, "sapProduct", s.SapProduct)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPDiskConfigurationsRequest.
func (s *SAPDiskConfigurationsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appLocation":
			err = unpopulate(val, "AppLocation", &s.AppLocation)
			delete(rawMsg, key)
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &s.DatabaseType)
			delete(rawMsg, key)
		case "dbVmSku":
			err = unpopulate(val, "DbVMSKU", &s.DbVMSKU)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &s.DeploymentType)
			delete(rawMsg, key)
		case "environment":
			err = unpopulate(val, "Environment", &s.Environment)
			delete(rawMsg, key)
		case "sapProduct":
			err = unpopulate(val, "SapProduct", &s.SapProduct)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPDiskConfigurationsResult.
func (s SAPDiskConfigurationsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskConfigurations", s.DiskConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPDiskConfigurationsResult.
func (s *SAPDiskConfigurationsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskConfigurations":
			err = unpopulate(val, "DiskConfigurations", &s.DiskConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPInstallWithoutOSConfigSoftwareConfiguration.
func (s SAPInstallWithoutOSConfigSoftwareConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bomUrl", s.BomURL)
	populate(objectMap, "highAvailabilitySoftwareConfiguration", s.HighAvailabilitySoftwareConfiguration)
	populate(objectMap, "sapBitsStorageAccountId", s.SapBitsStorageAccountID)
	objectMap["softwareInstallationType"] = SAPSoftwareInstallationTypeSAPInstallWithoutOSConfig
	populate(objectMap, "softwareVersion", s.SoftwareVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPInstallWithoutOSConfigSoftwareConfiguration.
func (s *SAPInstallWithoutOSConfigSoftwareConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bomUrl":
			err = unpopulate(val, "BomURL", &s.BomURL)
			delete(rawMsg, key)
		case "highAvailabilitySoftwareConfiguration":
			err = unpopulate(val, "HighAvailabilitySoftwareConfiguration", &s.HighAvailabilitySoftwareConfiguration)
			delete(rawMsg, key)
		case "sapBitsStorageAccountId":
			err = unpopulate(val, "SapBitsStorageAccountID", &s.SapBitsStorageAccountID)
			delete(rawMsg, key)
		case "softwareInstallationType":
			err = unpopulate(val, "SoftwareInstallationType", &s.SoftwareInstallationType)
			delete(rawMsg, key)
		case "softwareVersion":
			err = unpopulate(val, "SoftwareVersion", &s.SoftwareVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPSizingRecommendationRequest.
func (s SAPSizingRecommendationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appLocation", s.AppLocation)
	populate(objectMap, "databaseType", s.DatabaseType)
	populate(objectMap, "dbMemory", s.DbMemory)
	populate(objectMap, "dbScaleMethod", s.DbScaleMethod)
	populate(objectMap, "deploymentType", s.DeploymentType)
	populate(objectMap, "environment", s.Environment)
	populate(objectMap, "highAvailabilityType", s.HighAvailabilityType)
	populate(objectMap, "sapProduct", s.SapProduct)
	populate(objectMap, "saps", s.Saps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPSizingRecommendationRequest.
func (s *SAPSizingRecommendationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appLocation":
			err = unpopulate(val, "AppLocation", &s.AppLocation)
			delete(rawMsg, key)
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &s.DatabaseType)
			delete(rawMsg, key)
		case "dbMemory":
			err = unpopulate(val, "DbMemory", &s.DbMemory)
			delete(rawMsg, key)
		case "dbScaleMethod":
			err = unpopulate(val, "DbScaleMethod", &s.DbScaleMethod)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &s.DeploymentType)
			delete(rawMsg, key)
		case "environment":
			err = unpopulate(val, "Environment", &s.Environment)
			delete(rawMsg, key)
		case "highAvailabilityType":
			err = unpopulate(val, "HighAvailabilityType", &s.HighAvailabilityType)
			delete(rawMsg, key)
		case "sapProduct":
			err = unpopulate(val, "SapProduct", &s.SapProduct)
			delete(rawMsg, key)
		case "saps":
			err = unpopulate(val, "Saps", &s.Saps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPSizingRecommendationResult.
func (s SAPSizingRecommendationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["deploymentType"] = s.DeploymentType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPSizingRecommendationResult.
func (s *SAPSizingRecommendationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &s.DeploymentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPSupportedResourceSKUsResult.
func (s SAPSupportedResourceSKUsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "supportedSkus", s.SupportedSKUs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPSupportedResourceSKUsResult.
func (s *SAPSupportedResourceSKUsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportedSkus":
			err = unpopulate(val, "SupportedSKUs", &s.SupportedSKUs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPSupportedSKU.
func (s SAPSupportedSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isAppServerCertified", s.IsAppServerCertified)
	populate(objectMap, "isDatabaseCertified", s.IsDatabaseCertified)
	populate(objectMap, "vmSku", s.VMSKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPSupportedSKU.
func (s *SAPSupportedSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isAppServerCertified":
			err = unpopulate(val, "IsAppServerCertified", &s.IsAppServerCertified)
			delete(rawMsg, key)
		case "isDatabaseCertified":
			err = unpopulate(val, "IsDatabaseCertified", &s.IsDatabaseCertified)
			delete(rawMsg, key)
		case "vmSku":
			err = unpopulate(val, "VMSKU", &s.VMSKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPSupportedSKUsRequest.
func (s SAPSupportedSKUsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appLocation", s.AppLocation)
	populate(objectMap, "databaseType", s.DatabaseType)
	populate(objectMap, "deploymentType", s.DeploymentType)
	populate(objectMap, "environment", s.Environment)
	populate(objectMap, "highAvailabilityType", s.HighAvailabilityType)
	populate(objectMap, "sapProduct", s.SapProduct)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPSupportedSKUsRequest.
func (s *SAPSupportedSKUsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appLocation":
			err = unpopulate(val, "AppLocation", &s.AppLocation)
			delete(rawMsg, key)
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &s.DatabaseType)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &s.DeploymentType)
			delete(rawMsg, key)
		case "environment":
			err = unpopulate(val, "Environment", &s.Environment)
			delete(rawMsg, key)
		case "highAvailabilityType":
			err = unpopulate(val, "HighAvailabilityType", &s.HighAvailabilityType)
			delete(rawMsg, key)
		case "sapProduct":
			err = unpopulate(val, "SapProduct", &s.SapProduct)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPVirtualInstance.
func (s SAPVirtualInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPVirtualInstance.
func (s *SAPVirtualInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPVirtualInstanceError.
func (s SAPVirtualInstanceError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPVirtualInstanceError.
func (s *SAPVirtualInstanceError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPVirtualInstanceList.
func (s SAPVirtualInstanceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPVirtualInstanceList.
func (s *SAPVirtualInstanceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SAPVirtualInstanceProperties.
func (s SAPVirtualInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configuration", s.Configuration)
	populate(objectMap, "environment", s.Environment)
	populate(objectMap, "errors", s.Errors)
	populate(objectMap, "health", s.Health)
	populate(objectMap, "managedResourceGroupConfiguration", s.ManagedResourceGroupConfiguration)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "sapProduct", s.SapProduct)
	populate(objectMap, "state", s.State)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SAPVirtualInstanceProperties.
func (s *SAPVirtualInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			s.Configuration, err = unmarshalSAPConfigurationClassification(val)
			delete(rawMsg, key)
		case "environment":
			err = unpopulate(val, "Environment", &s.Environment)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &s.Errors)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &s.Health)
			delete(rawMsg, key)
		case "managedResourceGroupConfiguration":
			err = unpopulate(val, "ManagedResourceGroupConfiguration", &s.ManagedResourceGroupConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "sapProduct":
			err = unpopulate(val, "SapProduct", &s.SapProduct)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "size", s.Size)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapability.
func (s SKUCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapability.
func (s *SKUCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapacity.
func (s SKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "default", s.Default)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "minimum", s.Minimum)
	populate(objectMap, "scaleType", s.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapacity.
func (s *SKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &s.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &s.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCost.
func (s SKUCost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedUnit", s.ExtendedUnit)
	populate(objectMap, "meterId", s.MeterID)
	populate(objectMap, "quantity", s.Quantity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCost.
func (s *SKUCost) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedUnit":
			err = unpopulate(val, "ExtendedUnit", &s.ExtendedUnit)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &s.MeterID)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &s.Quantity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUDefinition.
func (s SKUDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "capacity", &s.Capacity)
	populate(objectMap, "costs", s.Costs)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "locationInfo", s.LocationInfo)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "restrictions", s.Restrictions)
	populate(objectMap, "size", s.Size)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUDefinition.
func (s *SKUDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "costs":
			err = unpopulate(val, "Costs", &s.Costs)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "locationInfo":
			err = unpopulate(val, "LocationInfo", &s.LocationInfo)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "restrictions":
			err = unpopulate(val, "Restrictions", &s.Restrictions)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKULocationAndZones.
func (s SKULocationAndZones) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocations", s.ExtendedLocations)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "zoneDetails", s.ZoneDetails)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKULocationAndZones.
func (s *SKULocationAndZones) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocations":
			err = unpopulate(val, "ExtendedLocations", &s.ExtendedLocations)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "zoneDetails":
			err = unpopulate(val, "ZoneDetails", &s.ZoneDetails)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &s.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKURestriction.
func (s SKURestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "reasonCode", s.ReasonCode)
	populate(objectMap, "restrictionInfo", &s.RestrictionInfo)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKURestriction.
func (s *SKURestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reasonCode":
			err = unpopulate(val, "ReasonCode", &s.ReasonCode)
			delete(rawMsg, key)
		case "restrictionInfo":
			err = unpopulate(val, "RestrictionInfo", &s.RestrictionInfo)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUZoneDetail.
func (s SKUZoneDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUZoneDetail.
func (s *SKUZoneDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &s.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUsListResult.
func (s SKUsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUsListResult.
func (s *SKUsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHConfiguration.
func (s SSHConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publicKeys", s.PublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHConfiguration.
func (s *SSHConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &s.PublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHKeyPair.
func (s SSHKeyPair) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "privateKey", s.PrivateKey)
	populate(objectMap, "publicKey", s.PublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHKeyPair.
func (s *SSHKeyPair) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateKey":
			err = unpopulate(val, "PrivateKey", &s.PrivateKey)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &s.PublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKey.
func (s SSHPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyData", s.KeyData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKey.
func (s *SSHPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyData":
			err = unpopulate(val, "KeyData", &s.KeyData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SapNetWeaverProviderInstanceProperties.
func (s SapNetWeaverProviderInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["providerType"] = "SapNetWeaver"
	populate(objectMap, "sapClientId", s.SapClientID)
	populate(objectMap, "sapHostFileEntries", s.SapHostFileEntries)
	populate(objectMap, "sapHostname", s.SapHostname)
	populate(objectMap, "sapInstanceNr", s.SapInstanceNr)
	populate(objectMap, "sapPassword", s.SapPassword)
	populate(objectMap, "sapPasswordUri", s.SapPasswordURI)
	populate(objectMap, "sapPortNumber", s.SapPortNumber)
	populate(objectMap, "sapSslCertificateUri", s.SapSSLCertificateURI)
	populate(objectMap, "sapSid", s.SapSid)
	populate(objectMap, "sapUsername", s.SapUsername)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SapNetWeaverProviderInstanceProperties.
func (s *SapNetWeaverProviderInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerType":
			err = unpopulate(val, "ProviderType", &s.ProviderType)
			delete(rawMsg, key)
		case "sapClientId":
			err = unpopulate(val, "SapClientID", &s.SapClientID)
			delete(rawMsg, key)
		case "sapHostFileEntries":
			err = unpopulate(val, "SapHostFileEntries", &s.SapHostFileEntries)
			delete(rawMsg, key)
		case "sapHostname":
			err = unpopulate(val, "SapHostname", &s.SapHostname)
			delete(rawMsg, key)
		case "sapInstanceNr":
			err = unpopulate(val, "SapInstanceNr", &s.SapInstanceNr)
			delete(rawMsg, key)
		case "sapPassword":
			err = unpopulate(val, "SapPassword", &s.SapPassword)
			delete(rawMsg, key)
		case "sapPasswordUri":
			err = unpopulate(val, "SapPasswordURI", &s.SapPasswordURI)
			delete(rawMsg, key)
		case "sapPortNumber":
			err = unpopulate(val, "SapPortNumber", &s.SapPortNumber)
			delete(rawMsg, key)
		case "sapSslCertificateUri":
			err = unpopulate(val, "SapSSLCertificateURI", &s.SapSSLCertificateURI)
			delete(rawMsg, key)
		case "sapSid":
			err = unpopulate(val, "SapSid", &s.SapSid)
			delete(rawMsg, key)
		case "sapUsername":
			err = unpopulate(val, "SapUsername", &s.SapUsername)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SearchProfile.
func (s SearchProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataDisks", s.DataDisks)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "nodeResourceIds", s.NodeResourceIDs)
	populate(objectMap, "nodeSku", s.NodeSKU)
	populate(objectMap, "osDisk", s.OSDisk)
	populate(objectMap, "osImage", s.OSImage)
	populate(objectMap, "searchType", s.SearchType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SearchProfile.
func (s *SearchProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &s.DataDisks)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "nodeResourceIds":
			err = unpopulate(val, "NodeResourceIDs", &s.NodeResourceIDs)
			delete(rawMsg, key)
		case "nodeSku":
			err = unpopulate(val, "NodeSKU", &s.NodeSKU)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &s.OSDisk)
			delete(rawMsg, key)
		case "osImage":
			err = unpopulate(val, "OSImage", &s.OSImage)
			delete(rawMsg, key)
		case "searchType":
			err = unpopulate(val, "SearchType", &s.SearchType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceInitiatedSoftwareConfiguration.
func (s ServiceInitiatedSoftwareConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bomUrl", s.BomURL)
	populate(objectMap, "highAvailabilitySoftwareConfiguration", s.HighAvailabilitySoftwareConfiguration)
	populate(objectMap, "sshPrivateKey", s.SSHPrivateKey)
	populate(objectMap, "sapBitsStorageAccountId", s.SapBitsStorageAccountID)
	populate(objectMap, "sapFqdn", s.SapFqdn)
	objectMap["softwareInstallationType"] = SAPSoftwareInstallationTypeServiceInitiated
	populate(objectMap, "softwareVersion", s.SoftwareVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceInitiatedSoftwareConfiguration.
func (s *ServiceInitiatedSoftwareConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bomUrl":
			err = unpopulate(val, "BomURL", &s.BomURL)
			delete(rawMsg, key)
		case "highAvailabilitySoftwareConfiguration":
			err = unpopulate(val, "HighAvailabilitySoftwareConfiguration", &s.HighAvailabilitySoftwareConfiguration)
			delete(rawMsg, key)
		case "sshPrivateKey":
			err = unpopulate(val, "SSHPrivateKey", &s.SSHPrivateKey)
			delete(rawMsg, key)
		case "sapBitsStorageAccountId":
			err = unpopulate(val, "SapBitsStorageAccountID", &s.SapBitsStorageAccountID)
			delete(rawMsg, key)
		case "sapFqdn":
			err = unpopulate(val, "SapFqdn", &s.SapFqdn)
			delete(rawMsg, key)
		case "softwareInstallationType":
			err = unpopulate(val, "SoftwareInstallationType", &s.SoftwareInstallationType)
			delete(rawMsg, key)
		case "softwareVersion":
			err = unpopulate(val, "SoftwareVersion", &s.SoftwareVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SingleServerConfiguration.
func (s SingleServerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appResourceGroup", s.AppResourceGroup)
	populate(objectMap, "databaseType", s.DatabaseType)
	objectMap["deploymentType"] = SAPDeploymentTypeSingleServer
	populate(objectMap, "networkConfiguration", s.NetworkConfiguration)
	populate(objectMap, "subnetId", s.SubnetID)
	populate(objectMap, "virtualMachineConfiguration", s.VirtualMachineConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SingleServerConfiguration.
func (s *SingleServerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appResourceGroup":
			err = unpopulate(val, "AppResourceGroup", &s.AppResourceGroup)
			delete(rawMsg, key)
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &s.DatabaseType)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &s.DeploymentType)
			delete(rawMsg, key)
		case "networkConfiguration":
			err = unpopulate(val, "NetworkConfiguration", &s.NetworkConfiguration)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &s.SubnetID)
			delete(rawMsg, key)
		case "virtualMachineConfiguration":
			err = unpopulate(val, "VirtualMachineConfiguration", &s.VirtualMachineConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SingleServerRecommendationResult.
func (s SingleServerRecommendationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["deploymentType"] = SAPDeploymentTypeSingleServer
	populate(objectMap, "vmSku", s.VMSKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SingleServerRecommendationResult.
func (s *SingleServerRecommendationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &s.DeploymentType)
			delete(rawMsg, key)
		case "vmSku":
			err = unpopulate(val, "VMSKU", &s.VMSKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteProfile.
func (s SiteProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "domainName", s.DomainName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteProfile.
func (s *SiteProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &s.DomainName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SoftwareConfiguration.
func (s SoftwareConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["softwareInstallationType"] = s.SoftwareInstallationType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftwareConfiguration.
func (s *SoftwareConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "softwareInstallationType":
			err = unpopulate(val, "SoftwareInstallationType", &s.SoftwareInstallationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StopRequest.
func (s StopRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hardStop", s.HardStop)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StopRequest.
func (s *StopRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hardStop":
			err = unpopulate(val, "HardStop", &s.HardStop)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Tags.
func (t Tags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Tags.
func (t *Tags) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreeTierConfiguration.
func (t ThreeTierConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appResourceGroup", t.AppResourceGroup)
	populate(objectMap, "applicationServer", t.ApplicationServer)
	populate(objectMap, "centralServer", t.CentralServer)
	populate(objectMap, "databaseServer", t.DatabaseServer)
	objectMap["deploymentType"] = SAPDeploymentTypeThreeTier
	populate(objectMap, "highAvailabilityConfig", t.HighAvailabilityConfig)
	populate(objectMap, "networkConfiguration", t.NetworkConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreeTierConfiguration.
func (t *ThreeTierConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appResourceGroup":
			err = unpopulate(val, "AppResourceGroup", &t.AppResourceGroup)
			delete(rawMsg, key)
		case "applicationServer":
			err = unpopulate(val, "ApplicationServer", &t.ApplicationServer)
			delete(rawMsg, key)
		case "centralServer":
			err = unpopulate(val, "CentralServer", &t.CentralServer)
			delete(rawMsg, key)
		case "databaseServer":
			err = unpopulate(val, "DatabaseServer", &t.DatabaseServer)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &t.DeploymentType)
			delete(rawMsg, key)
		case "highAvailabilityConfig":
			err = unpopulate(val, "HighAvailabilityConfig", &t.HighAvailabilityConfig)
			delete(rawMsg, key)
		case "networkConfiguration":
			err = unpopulate(val, "NetworkConfiguration", &t.NetworkConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreeTierRecommendationResult.
func (t ThreeTierRecommendationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationServerInstanceCount", t.ApplicationServerInstanceCount)
	populate(objectMap, "applicationServerVmSku", t.ApplicationServerVMSKU)
	populate(objectMap, "centralServerInstanceCount", t.CentralServerInstanceCount)
	populate(objectMap, "centralServerVmSku", t.CentralServerVMSKU)
	populate(objectMap, "databaseInstanceCount", t.DatabaseInstanceCount)
	populate(objectMap, "dbVmSku", t.DbVMSKU)
	objectMap["deploymentType"] = SAPDeploymentTypeThreeTier
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreeTierRecommendationResult.
func (t *ThreeTierRecommendationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationServerInstanceCount":
			err = unpopulate(val, "ApplicationServerInstanceCount", &t.ApplicationServerInstanceCount)
			delete(rawMsg, key)
		case "applicationServerVmSku":
			err = unpopulate(val, "ApplicationServerVMSKU", &t.ApplicationServerVMSKU)
			delete(rawMsg, key)
		case "centralServerInstanceCount":
			err = unpopulate(val, "CentralServerInstanceCount", &t.CentralServerInstanceCount)
			delete(rawMsg, key)
		case "centralServerVmSku":
			err = unpopulate(val, "CentralServerVMSKU", &t.CentralServerVMSKU)
			delete(rawMsg, key)
		case "databaseInstanceCount":
			err = unpopulate(val, "DatabaseInstanceCount", &t.DatabaseInstanceCount)
			delete(rawMsg, key)
		case "dbVmSku":
			err = unpopulate(val, "DbVMSKU", &t.DbVMSKU)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &t.DeploymentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMonitorRequest.
func (u UpdateMonitorRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", u.Identity)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMonitorRequest.
func (u *UpdateMonitorRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &u.Identity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateSAPApplicationInstanceRequest.
func (u UpdateSAPApplicationInstanceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateSAPApplicationInstanceRequest.
func (u *UpdateSAPApplicationInstanceRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateSAPCentralInstanceRequest.
func (u UpdateSAPCentralInstanceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateSAPCentralInstanceRequest.
func (u *UpdateSAPCentralInstanceRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateSAPDatabaseInstanceRequest.
func (u UpdateSAPDatabaseInstanceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateSAPDatabaseInstanceRequest.
func (u *UpdateSAPDatabaseInstanceRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateSAPVirtualInstanceRequest.
func (u UpdateSAPVirtualInstanceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", u.Identity)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateSAPVirtualInstanceRequest.
func (u *UpdateSAPVirtualInstanceRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &u.Identity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedServiceIdentity.
func (u UserAssignedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", u.Type)
	populate(objectMap, "userAssignedIdentities", u.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedServiceIdentity.
func (u *UserAssignedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &u.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserProfile.
func (u UserProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sshPublicKey", u.SSHPublicKey)
	populate(objectMap, "userName", u.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserProfile.
func (u *UserProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sshPublicKey":
			err = unpopulate(val, "SSHPublicKey", &u.SSHPublicKey)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &u.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineConfiguration.
func (v VirtualMachineConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "imageReference", v.ImageReference)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "vmSize", v.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineConfiguration.
func (v *VirtualMachineConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "imageReference":
			err = unpopulate(val, "ImageReference", &v.ImageReference)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &v.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmssNodesProfile.
func (v VmssNodesProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoScaleMaxCount", v.AutoScaleMaxCount)
	populate(objectMap, "autoScaleMinCount", v.AutoScaleMinCount)
	populate(objectMap, "dataDisks", v.DataDisks)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "nodeResourceIds", v.NodeResourceIDs)
	populate(objectMap, "nodeSku", v.NodeSKU)
	populate(objectMap, "osDisk", v.OSDisk)
	populate(objectMap, "osImage", v.OSImage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmssNodesProfile.
func (v *VmssNodesProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoScaleMaxCount":
			err = unpopulate(val, "AutoScaleMaxCount", &v.AutoScaleMaxCount)
			delete(rawMsg, key)
		case "autoScaleMinCount":
			err = unpopulate(val, "AutoScaleMinCount", &v.AutoScaleMinCount)
			delete(rawMsg, key)
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &v.DataDisks)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "nodeResourceIds":
			err = unpopulate(val, "NodeResourceIDs", &v.NodeResourceIDs)
			delete(rawMsg, key)
		case "nodeSku":
			err = unpopulate(val, "NodeSKU", &v.NodeSKU)
			delete(rawMsg, key)
		case "osDisk":
			err = unpopulate(val, "OSDisk", &v.OSDisk)
			delete(rawMsg, key)
		case "osImage":
			err = unpopulate(val, "OSImage", &v.OSImage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsConfiguration.
func (w WindowsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["osType"] = OSTypeWindows
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsConfiguration.
func (w *WindowsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osType":
			err = unpopulate(val, "OSType", &w.OSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WordpressInstanceResource.
func (w WordpressInstanceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WordpressInstanceResource.
func (w *WordpressInstanceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WordpressInstanceResourceList.
func (w WordpressInstanceResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WordpressInstanceResourceList.
func (w *WordpressInstanceResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WordpressInstanceResourceProperties.
func (w WordpressInstanceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", w.DatabaseName)
	populate(objectMap, "databaseUser", w.DatabaseUser)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "siteUrl", w.SiteURL)
	populate(objectMap, "version", w.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WordpressInstanceResourceProperties.
func (w *WordpressInstanceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &w.DatabaseName)
			delete(rawMsg, key)
		case "databaseUser":
			err = unpopulate(val, "DatabaseUser", &w.DatabaseUser)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "siteUrl":
			err = unpopulate(val, "SiteURL", &w.SiteURL)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &w.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
