/*--------------------------------------------------------------------
 *
 *	Copyright (c) 1991-2024 by the GMT Team (https://www.generic-mapping-tools.org/team.html)
 *	See LICENSE.TXT file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU Lesser General Public License as published by
 *	the Free Software Foundation; version 3 or any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU Lesser General Public License for more details.
 *
 *	Contact info: www.generic-mapping-tools.org
 *--------------------------------------------------------------------*/
/*
 * psldemo.h contains two images as bytestreams since postscriptlight
 * expects any images to be loaded then passed via functions.
 *
 * Author:	Paul Wessel
 * Date:	13-OCT-2017
 * Version:	6 API
 */

/* This is the byte array for circuit.png: 135 x 94 x 24-bit */
unsigned int circuit_dim[3] = {135, 94, 24};
unsigned char circuit[] = {
	 31,  72,  45,  30,  64,  34,  31,  72,  45,  46,  80,  45,  47,  88,  47,  32,
	 80,  46,  30,  64,  34,  55,  64,  59,  31,  72,  45,  48,  80,  62,  46,  80,
	 45,  32,  80,  46,  32,  80,  46,  31,  72,  45,  32,  56,  45,  32,  56,  45,
	 29,  56,  33,  49,  71,  62,  31,  72,  45,  31,  72,  45,  32,  80,  46,  31,
	 72,  45,  32,  64,  46,  29,  56,  33,  32,  80,  46,  20,  64,  32,  32,  56,
	 45,  49,  71,  62,  72,  80,  76,  70,  73,  73,  68,  65,  70,  60,  72,  66,
	 55,  64,  59,  70,  73,  73,  86,  81,  76,  84,  86,  87,  72,  88,  78,  72,
	 88,  78,  47,  88,  47,  19,  71,  34,  48,  80,  62,  32,  80,  46,  32,  80,
	 46,  32,  80,  46,  48,  80,  62,  34,  88,  53,  31,  72,  45,  32,  64,  46,
	 60,  80,  38,  56,  65,  29,  32,  56,  45,  30,  48,  39,  20,  48,  36,  20,
	 48,  36,  31,  72,  45,  31,  72,  45,  11,  56,  28,  11,  64,  29,  32,  80,
	 46,  71,  80,  39,  48,  72,  31,  20,  88,  38,  33, 112,  50,  49, 119,  77,
	 30,  48,  26,  21,  32,  19,  20,  56,  32,  35, 112,  61,  19,  95,  39,  19,
	 71,  34,  29,  72,  35,  35, 104,  60,  46, 112,  58,  32,  80,  46,  20,  64,
	 32,  30,  64,  34,  46,  72,  47,  32,  64,  46,  29,  56,  33,  20,  64,  32,
	 44,  64,  50,  32,  56,  45,  29,  72,  35,  31,  88,  42,  31,  88,  42,  31,
	 88,  42,  32,  80,  46,  34,  88,  53,  33, 104,  49,  33, 112,  50,  33, 104,
	 49,  33, 112,  50,  36, 120,  69,  46, 104,  55,  33,  96,  54,  33,  96,  54,
	 35, 104,  60,  35, 104,  60,  33, 104,  49,  20, 104,  44,  33, 104,  49,  32,
	 80,  46,  20,  64,  32,  32,  56,  45,  31,  88,  42,  46, 104,  55,  31,  96,
	 43,  46, 104,  55,  72, 112,  59,  46,  96,  49,  46, 104,  55,  33, 104,  49,
	 33,  96,  54,  35, 104,  60,  33, 104,  49,  20, 104,  44,  20,  96,  54,  31,
	 88,  42,  31,  72,  45,  20,  56,  32,  20,  56,  32,  32,  80,  46,  31,  88,
	 42,  46,  96,  49,  31,  88,  42,  60, 104,  53,  60, 104,  53,  46, 112,  58,
	 46,  96,  49,  33, 104,  49,  47, 112,  69,  36, 120,  56,  33, 104,  49,  20,
	 96,  54,  35, 104,  60,  32,  80,  46,  20,  64,  32,  29,  72,  35,  31,  88,
	 42,  33,  96,  54,  30,  80,  35,  30,  64,  34,  30,  64,  34,  47,  88,  47,
	 48,  96,  63,  33,  96,  54,  33,  96,  54,  34,  88,  53,  31,  72,  45,  11,
	 56,  28,  11,  40,  24,  20,  56,  32,  32,  80,  46,  19,  71,  34,  20,  80,
	 34,  31,  88,  42,  20,  80,  34,  29,  72,  35,  19,  71,  34,  19,  71,  34,
	 19,  71,  34,  31,  72,  45,  31,  72,  45,  44,  64,  50,  44,  64,  50,  44,
	 56,  49,  55,  64,  59,  32,  56,  45,  32,  64,  46,  44,  64,  50,  70,  73,
	 73,  72,  96,  77,  72,  96,  77,  47,  88,  62,  32,  80,  46,  31,  72,  45,
	 31,  72,  45,  31,  72,  45,  20,  72,  45,  31,  72,  45,  32,  80,  46,  31,
	 72,  45,  30,  64,  34,  48,  72,  31,  44,  65,  31,  30,  64,  34,  20,  55,
	 46,  11,  40,  24,  20,  56,  32,  30,  64,  34,  46,  80,  45,  38,  33,  34,
	 29,  40,  26,  68,  56,  26,  86,  72,  43,  71,  80,  39,  33, 104,  49,  27,
	120,  53,  36, 120,  56,  20,  40,  27,  20,  40,  27,  30,  64,  34,  36, 120,
	 69,  33,  96,  54,  29,  72,  35,  20,  64,  32,  35, 104,  60,  47, 112,  69,
	 20,  80,  34,  20,  56,  32,  31,  72,  45,  48,  80,  62,  31,  72,  45,  20,
	 55,  46,  20,  64,  32,  44,  64,  50,  32,  64,  46,  32,  80,  46,  34,  88,
	 53,  33,  96,  54,  20,  88,  38,  20,  80,  34,  34,  88,  53,  35, 112,  61,
	 35, 112,  61,  35, 112,  61,  36, 120,  56,  49, 119,  77,  35, 112,  61,  33,
	 96,  54,  33,  96,  54,  47, 112,  69,  35, 112,  61,  33, 112,  50,  33, 112,
	 50,  33, 112,  50,  32,  80,  46,  32,  64,  46,  32,  56,  45,  32,  80,  46,
	 33, 104,  49,  46, 104,  55,  46, 112,  58,  72, 112,  59,  70, 104,  55,  46,
	112,  58,  46, 120,  63,  46, 112,  58,  46, 120,  63,  35, 112,  61,  35, 112,
	 61,  33, 104,  49,  31,  88,  42,  32,  80,  46,  20,  64,  32,  30,  48,  39,
	 30,  80,  35,  31,  88,  42,  46, 104,  55,  32,  80,  46,  48,  96,  63,  49,
	104,  69,  60, 112,  53,  46, 104,  55,  46, 112,  58,  49, 119,  77,  36, 120,
	 69,  35, 104,  60,  33,  96,  54,  46, 104,  55,  20,  88,  53,  20,  81,  44,
	 31,  88,  42,  33,  96,  54,  35, 104,  60,  20,  96,  54,  32,  80,  46,  46,
	 80,  45,  31,  96,  43,  33, 104,  49,  46, 112,  58,  33, 104,  49,  33, 104,
	 49,  33,  96,  54,  19,  71,  34,  11,  64,  29,  20,  64,  32,  34,  88,  53,
	 20,  80,  34,  20,  88,  38,  19,  95,  39,  19,  95,  39,  31,  96,  43,  20,
	 88,  38,  20,  88,  38,  31,  88,  42,  31,  88,  42,  30,  80,  35,  31,  72,
	 45,  44,  64,  50,  46,  72,  47,  49,  71,  62,  32,  80,  46,  48,  80,  62,
	 48,  80,  62,  60,  88,  68,  72,  96,  77,  72,  96,  77,  60,  96,  67,  46,
	 80,  45,  32,  80,  46,  32,  80,  46,  32,  80,  46,  32,  80,  46,  32,  80,
	 46,  32,  80,  46,  48,  80,  62,  32,  80,  46,  71,  71,  25,  46,  80,  45,
	 46,  80,  45,  31,  72,  45,  11,  64,  29,  31,  72,  45,  72,  88,  39,  72,
	 88,  39,  70,  72,  39,  48,  72,  31,  71,  80,  39, 100,  86,  44,  70,  97,
	 49,  36, 120,  56,  34, 135,  65,  46, 127,  65,  30,  48,  26,  30,  48,  26,
	 30,  64,  34,  49, 119,  77,  19,  95,  39,  31,  72,  45,  30,  64,  34,  33,
	 96,  54,  47, 112,  69,  20,  80,  34,  11,  56,  28,  31,  72,  45,  48,  80,
	 62,  32,  64,  46,  30,  64,  34,  20,  64,  45,  32,  56,  45,  30,  64,  34,
	 32,  80,  46,  46,  96,  49,  33,  96,  54,  31,  88,  42,  31,  88,  42,  31,
	 88,  42,  36, 120,  56,  46, 120,  63,  46, 120,  63,  46, 120,  63,  46, 127,
	 65,  35, 112,  61,  33,  96,  54,  35, 104,  60,  47, 112,  69,  47, 112,  69,
	 36, 120,  56,  35, 112,  61,  35, 112,  61,  34,  88,  53,  30,  64,  34,  32,
	 56,  45,  20,  88,  38,  33, 104,  49,  33, 104,  49,  46, 120,  63,  60, 120,
	 64,  46, 112,  58,  60, 120,  64,  49, 119,  77,  60, 120,  64,  60, 120,  64,
	 46, 120,  63,  33, 112,  50,  33, 104,  49,  31,  96,  43,  32,  80,  46,  29,
	 72,  35,  11,  48,  24,  32,  80,  46,  33,  96,  54,  46, 104,  55,  30,  80,
	 35,  48,  96,  63,  46, 104,  55,  49, 119,  77,  46, 104,  55,  47, 112,  69,
	 51, 128,  77,  51, 128,  77,  35, 112,  61,  35, 104,  60,  35, 104,  60,  33,
	 96,  54,  31,  88,  42,  31,  88,  42,  46, 112,  58,  46, 120,  63,  35, 104,
	 60,  34,  88,  53,  47,  88,  62,  31,  96,  43,  35, 112,  61,  46, 112,  58,
	 33, 112,  50,  35, 112,  61,  33,  96,  54,  20,  80,  34,  31,  72,  45,  29,
	 72,  35,  46,  96,  49,  31,  88,  42,  19,  95,  39,  33, 112,  50,  33, 104,
	 49,  33, 104,  49,  31,  96,  43,  46, 104,  55,  33, 104,  49,  47,  88,  47,
	 30,  80,  35,  46,  72,  47,  48,  80,  62,  48,  80,  62,  44,  64,  50,  32,
	 80,  46,  48,  80,  62,  48,  80,  62,  48,  80,  62,  49,  71,  62,  31,  72,
	 45,  31,  72,  45,  31,  72,  45,  32,  80,  46,  32,  80,  46,  32,  80,  46,
	 20,  72,  45,  20,  80,  34,  31,  72,  45,  31,  72,  45,  29,  72,  35,  71,
	 80,  39,  72,  88,  39,  60,  96,  47,  32,  80,  46,  29,  72,  35,  46,  80,
	 45,  86,  95,  42,  90,  88,  32,  32,  80,  46,  20,  81,  44,  30,  80,  35,
	 72,  88,  39,  60,  96,  47,  36, 120,  56,  36, 120,  56,  46, 104,  55,  32,
	 56,  45,  29,  40,  26,  30,  64,  34,  47, 112,  69,  20,  88,  38,  30,  64,
	 34,  29,  72,  35,  35, 104,  60,  47, 112,  69,  31,  88,  42,  20,  64,  32,
	 20,  64,  45,  32,  64,  46,  32,  64,  46,  32,  64,  46,  31,  72,  45,  20,
	 56,  32,  30,  64,  34,  32,  80,  46,  33,  96,  54,  31,  96,  43,  20,  88,
	 38,  31,  88,  42,  33,  96,  54,  35, 112,  61,  36, 120,  69,  46, 127,  65,
	 46, 127,  65,  46, 127,  65,  35, 104,  60,  33,  96,  54,  35, 104,  60,  35,
	104,  60,  35, 112,  61,  33, 112,  50,  33, 112,  50,  46, 112,  58,  34,  88,
	 53,  31,  72,  45,  32,  64,  46,  32,  80,  46,  46, 120,  63,  33, 112,  50,
	 46, 120,  63,  46, 120,  63,  46, 104,  55,  46, 120,  63,  46, 120,  63,  60,
	104,  53,  46, 112,  58,  46, 112,  58,  33, 104,  49,  33, 104,  49,  31,  96,
	 43,  32,  80,  46,  32,  64,  46,  20,  48,  36,  32,  80,  46,  31,  96,  43,
	 35, 104,  60,  20,  88,  38,  48,  96,  63,  33,  96,  54,  49, 119,  77,  47,
	112,  69,  46, 112,  58,  51, 128,  77,  46, 127,  65,  35, 112,  61,  35, 104,
	 60,  35, 104,  60,  33,  96,  54,  32,  80,  46,  31,  88,  42,  35, 104,  60,
	 47, 112,  69,  33,  96,  54,  32,  80,  46,  46,  72,  47,  33,  96,  54,  49,
	104,  69,  35, 112,  61,  33,  96,  54,  33,  96,  54,  34,  88,  53,  20,  56,
	 32,  20,  56,  32,  31,  72,  45,  47,  88,  62,  31,  88,  42,  31,  88,  42,
	 35, 104,  60,  33,  96,  54,  33, 104,  49,  33,  96,  54,  34,  88,  53,  46,
	 96,  49,  34,  88,  53,  32,  64,  46,  20,  56,  32,  32,  56,  45,  44,  56,
	 49,  44,  48,  47,  44,  48,  47,  30,  40,  38,  30,  40,  38,  29,  56,  33,
	 30,  64,  34,  32,  80,  46,  32,  80,  46,  31,  88,  42,  32,  80,  46,  32,
	 80,  46,  31,  88,  42,  32,  80,  46,  31,  72,  45,  32,  80,  46,  32,  80,
	 46,  32,  64,  46,  71,  71,  25,  70,  72,  39,  46,  72,  47,  29,  72,  35,
	 30,  64,  34,  60,  80,  38,  84,  78,  28,  79,  64,  30,  11,  48,  24,  11,
	 64,  29,  46,  80,  45,  72,  88,  39,  60,  96,  47,  33, 104,  49,  33, 104,
	 49,  31,  88,  42,  20,  48,  27,  30,  48,  26,  20,  64,  32,  47, 112,  69,
	 20,  88,  38,  30,  64,  34,  30,  64,  34,  33, 104,  49,  33,  96,  54,  33,
	 96,  54,  31,  88,  42,  11,  64,  29,  11,  56,  28,  20,  64,  32,  20,  64,
	 45,  20,  64,  32,  19,  71,  34,  30,  80,  35,  31,  88,  42,  34,  88,  53,
	 31,  88,  42,  31,  88,  42,  33,  96,  54,  35, 104,  60,  35, 112,  61,  46,
	120,  63,  36, 128,  63,  46, 127,  65,  51, 128,  77,  35, 112,  61,  35, 104,
	 60,  49, 104,  69,  35, 112,  61,  35, 112,  61,  27, 120,  53,  33, 112,  50,
	 36, 120,  56,  33,  96,  54,  30,  64,  34,  32,  64,  46,  31,  88,  42,  46,
	120,  63,  36, 120,  69,  36, 128,  63,  46, 120,  63,  46, 112,  58,  46, 120,
	 63,  46, 120,  63,  33,  96,  54,  48,  96,  63,  35, 104,  60,  33, 104,  49,
	 33,  96,  54,  34,  88,  53,  31,  72,  45,  20,  56,  32,  20,  48,  36,  31,
	 72,  45,  31,  88,  42,  35, 104,  60,  32,  80,  46,  33,  96,  54,  33,  96,
	 54,  47, 112,  69,  46, 120,  63,  46, 112,  58,  51, 128,  77,  49, 119,  77,
	 35, 112,  61,  35, 104,  60,  47, 112,  69,  33,  96,  54,  32,  80,  46,  32,
	 80,  46,  48,  96,  63,  46, 104,  55,  31,  88,  42,  29,  72,  35,  30,  64,
	 34,  33,  96,  54,  49, 104,  69,  49, 104,  69,  33,  96,  54,  34,  88,  53,
	 32,  80,  46,  20,  55,  46,  20,  48,  36,  32,  56,  45,  48,  80,  62,  20,
	 72,  45,  31,  88,  42,  31,  88,  42,  20,  88,  38,  34,  88,  53,  32,  80,
	 46,  19,  71,  34,  32,  80,  46,  34,  88,  53,  31,  72,  45,  11,  40,  24,
	 10,  25,  17,  12,  33,  29,  30,  40,  38,  22,  33,  29,  23,  16,  16,  10,
	 25,  17,  30,  48,  26,  47,  88,  62,  49, 104,  69,  35, 104,  60,  34,  88,
	 53,  32,  80,  46,  48,  80,  62,  34,  88,  53,  32,  80,  46,  34,  88,  53,
	 47,  88,  62,  47,  88,  62,  46,  80,  45,  70,  72,  39,  56,  65,  29,  56,
	 65,  29,  30,  64,  34,  44,  56,  28,  56,  65,  29,  71,  71,  25,  68,  56,
	 26,  68,  38,  36,  52,  46,  19,  68,  66,  52,  76,  66,  44,  60,  80,  38,
	 31,  96,  43,  33, 104,  49,  34,  88,  53,  11,  48,  24,  20,  48,  27,  32,
	 64,  46,  47, 112,  69,  31,  96,  43,  29,  72,  35,  30,  64,  34,  20,  96,
	 54,  20,  88,  38,  46, 104,  55,  33,  96,  54,  32,  80,  46,  20,  64,  32,
	 20,  64,  45,  29,  72,  35,  20,  64,  32,  34,  88,  53,  34,  88,  53,  33,
	 96,  54,  31,  96,  43,  31,  96,  43,  19,  95,  39,  33,  96,  54,  35, 104,
	 60,  27, 120,  53,  46, 120,  63,  36, 128,  63,  46, 127,  65,  46, 127,  65,
	 49, 119,  77,  35, 104,  60,  35, 104,  60,  46, 120,  63,  46, 120,  63,  36,
	120,  56,  36, 120,  56,  46, 112,  58,  34,  88,  53,  19,  71,  34,  32,  64,
	 46,  31,  88,  42,  46, 120,  63,  28, 127,  58,  36, 128,  63,  47, 135,  70,
	 46, 120,  63,  51, 128,  77,  49, 119,  77,  33,  96,  54,  35, 104,  60,  35,
	104,  60,  35, 104,  60,  33,  96,  54,  32,  80,  46,  20,  64,  45,  20,  48,
	 36,  20,  48,  36,  20,  72,  45,  20,  88,  38,  35, 104,  60,  34,  88,  53,
	 48,  96,  63,  35, 104,  60,  46, 112,  58,  35, 112,  61,  46, 112,  58,  46,
	120,  63,  46, 120,  63,  33, 104,  49,  35, 104,  60,  47, 112,  69,  33,  96,
	 54,  34,  88,  53,  31,  88,  42,  35, 104,  60,  47, 112,  69,  33,  96,  54,
	 31,  72,  45,  32,  64,  46,  33,  96,  54,  47, 112,  69,  46, 120,  63,  35,
	112,  61,  49, 104,  69,  33,  96,  54,  32,  64,  46,  20,  64,  32,  19,  71,
	 34,  34,  88,  53,  31,  88,  42,  20,  88,  38,  33,  96,  54,  20,  88,  53,
	 31,  88,  42,  20,  81,  44,  20,  80,  34,  31,  96,  43,  33,  96,  54,  48,
	 96,  63,  32,  80,  46,  20,  55,  46,  30,  48,  39,  30,  48,  39,  22,  33,
	 29,  20,  40,  27,  20,  48,  27,  46,  80,  45,  60, 104,  73,  60, 112,  73,
	 31,  88,  42,  20,  72,  45,  31,  72,  45,  20,  64,  45,  32,  64,  46,  20,
	 64,  45,  31,  72,  45,  31,  72,  45,  31,  72,  45,  32,  64,  46,  56,  65,
	 29,  30,  64,  34,  44,  65,  31,  30,  64,  34,  30,  64,  34,  44,  65,  31,
	 55,  64,  59,  44,  56,  28,  68,  50,  44,  55,  55,  31,  56,  65,  29,  56,
	 65,  29,  48,  72,  31,  19,  95,  39,   8, 112,  48,  31,  88,  42,  11,  56,
	 28,  20,  56,  32,  31,  72,  45,  36, 120,  69,  31,  88,  42,  31,  72,  45,
	 29,  72,  35,  20, 104,  44,  31,  88,  42,  31,  96,  43,  46, 104,  55,  33,
	 96,  54,  31,  88,  42,  20,  72,  45,  19,  71,  34,  31,  72,  45,  33,  96,
	 54,  33,  96,  54,  46,  96,  49,  31,  96,  43,  31,  96,  43,  33,  96,  54,
	 33,  96,  54,  35, 104,  60,  35, 112,  61,  36, 120,  56,  36, 120,  56,  36,
	120,  69,  46, 127,  65,  36, 120,  69,  35, 104,  60,  35, 104,  60,  46, 120,
	 63,  36, 120,  69,  36, 120,  56,  27, 120,  53,  33, 112,  50,  31,  88,  42,
	 20,  64,  32,  32,  64,  46,  31,  88,  42,  46, 120,  63,  36, 120,  56,  36,
	128,  63,  47, 135,  70,  46, 127,  65,  60, 127,  68,  46, 120,  63,  47, 112,
	 69,  36, 120,  69,  36, 120,  69,  35, 112,  61,  20,  96,  54,  34,  88,  53,
	 20,  64,  45,  20,  48,  36,  11,  40,  24,  32,  64,  46,  31,  88,  42,  49,
	104,  69,  31,  88,  42,  33,  96,  54,  35, 104,  60,  49, 119,  77,  35, 112,
	 61,  35, 112,  61,  46, 120,  63,  47, 112,  69,  35, 104,  60,  35, 104,  60,
	 35, 112,  61,  33,  96,  54,  20,  88,  53,  20,  88,  53,  46, 104,  55,  36,
	120,  69,  35, 104,  60,  34,  88,  53,  32,  80,  46,  33, 112,  50,  46, 127,
	 65,  46, 120,  63,  46, 120,  63,  46, 120,  63,  31,  96,  43,  19,  71,  34,
	 20,  64,  32,  32,  80,  46,  33, 104,  49,  33, 104,  49,  33, 104,  49,  33,
	112,  50,  33, 104,  49,  33, 104,  49,  31,  88,  42,  33, 104,  49,  31,  96,
	 43,  33, 104,  49,  49, 119,  77,  60, 120,  78,  49, 104,  69,  31,  72,  45,
	 32,  64,  46,  32,  64,  46,  34,  88,  53,  72, 112,  82,  81, 143,  95,  81,
	135,  95,  60, 112,  73,  34,  88,  53,  20,  72,  45,  31,  72,  45,  32,  64,
	 46,  20,  64,  45,  20,  55,  46,  32,  64,  46,  31,  72,  45,  32,  64,  46,
	 32,  56,  45,  20,  56,  32,  20,  48,  27,  29,  56,  33,  32,  64,  46,  20,
	 56,  32,  20,  56,  32,  20,  56,  32,  30,  64,  34,  11,  64,  29,  12,  80,
	 32,  31,  96,  43,  60, 112,  53,  46, 120,  63,  44, 142,  72,  34, 135,  65,
	 35, 104,  60,  31,  72,  45,  32,  64,  46,  32,  80,  46,  35, 104,  60,  20,
	 88,  38,  29,  72,  35,  30,  80,  35,  35, 112,  61,  46, 112,  58,  31,  96,
	 43,  31,  96,  43,  49, 104,  69,  33,  96,  54,  30,  80,  35,  29,  72,  35,
	 46,  96,  49,  31,  96,  43,  33,  96,  54,  31,  96,  43,  31,  96,  43,  31,
	 96,  43,  33,  96,  54,  20, 104,  44,  33,  96,  54,  36, 120,  56,  27, 120,
	 53,  33, 112,  50,  27, 120,  53,  36, 128,  63,  35, 112,  61,  33,  96,  54,
	 35, 104,  60,  46, 112,  58,  36, 120,  56,  33, 112,  50,  33, 112,  50,  33,
	112,  50,  31,  88,  42,  20,  64,  32,  30,  64,  34,  32,  80,  46,  47, 112,
	 69,  28, 127,  58,  28, 127,  58,  47, 135,  70,  51, 128,  77,  60, 120,  64,
	 46, 104,  55,  46, 127,  65,  46, 120,  63,  36, 128,  63,  35, 112,  61,  33,
	104,  49,  31,  96,  43,  31,  72,  45,  32,  56,  45,  20,  40,  27,  31,  72,
	 45,  31,  96,  43,  47, 112,  69,  34,  88,  53,  34,  88,  53,  46, 104,  55,
	 51, 128,  77,  35, 112,  61,  46, 120,  63,  51, 128,  77,  51, 128,  77,  46,
	120,  63,  36, 120,  69,  49, 119,  77,  33,  96,  54,  20,  88,  38,  20,  96,
	 54,  35, 104,  60,  46, 112,  58,  46,  96,  49,  30,  80,  35,  46,  80,  45,
	 47, 112,  69,  51, 128,  77,  36, 128,  63,  36, 120,  56,  46, 120,  63,  46,
	104,  55,  32,  80,  46,  29,  56,  33,  32,  80,  46,  46, 104,  55,  35, 112,
	 61,  20, 104,  44,  33, 104,  49,  31,  96,  43,  31,  96,  43,  19,  95,  39,
	 33, 104,  49,  19,  95,  39,  31,  96,  43,  20, 104,  44,  46, 120,  63,  65,
	136,  84,  60, 112,  73,  60,  88,  68,  60,  96,  67,  60, 112,  73,  66, 143,
	 88,  52, 154,  84,  46, 127,  65,  33, 104,  49,  20,  81,  44,  31,  88,  42,
	 32,  80,  46,  20,  88,  53,  20,  88,  38,  20, 104,  44,  33, 112,  50,  19,
	 95,  39,  31,  88,  42,  31,  96,  43,  20,  80,  34,  20,  88,  38,  31,  88,
	 42,  31,  88,  42,  34,  88,  53,  34,  88,  53,  31,  96,  43,  31,  96,  43,
	 31,  96,  43,  31,  96,  43,  33, 112,  50,  46, 127,  65,  46, 127,  65,  27,
	120,  53,  33, 112,  50,  20, 111,  48,  32,  64,  46,  20,  64,  32,  20,  81,
	 44,  33, 104,  49,  31,  96,  43,  20,  88,  38,  31,  96,  43,  33, 104,  49,
	 33, 104,  49,  20, 104,  44,  33, 112,  50,  33, 104,  49,  33,  96,  54,  47,
	 88,  62,  32,  80,  46,  20,  88,  38,  31,  96,  43,  31,  96,  43,  31,  96,
	 43,  33,  96,  54,  33, 104,  49,  31,  96,  43,  33, 104,  49,  33, 104,  49,
	 46, 104,  55,  46, 120,  63,  46, 127,  65,  36, 128,  63,  36, 120,  56,  33,
	104,  49,  31,  96,  43,  33,  96,  54,  20, 104,  44,  27, 120,  53,  36, 120,
	 56,  20, 111,  48,  20, 104,  44,  20,  88,  38,  20,  64,  45,  11,  56,  28,
	 30,  80,  35,  33, 104,  49,  46, 120,  63,  28, 127,  58,  46, 120,  63,  46,
	127,  65,  46, 127,  65,  36, 120,  56,  46, 112,  58,  49, 119,  77,  49, 119,
	 77,  33, 112,  50,  33, 104,  49,  33,  96,  54,  32,  80,  46,  20,  64,  32,
	 20,  48,  27,  30,  64,  34,  47,  88,  47,  46,  96,  49,  33,  96,  54,  35,
	104,  60,  47, 112,  69,  60, 120,  64,  46, 120,  63,  51, 128,  77,  60, 129,
	 79,  60, 129,  79,  49, 119,  77,  27, 120,  53,  46, 120,  63,  46, 104,  55,
	 33,  96,  54,  33,  96,  54,  46, 120,  63,  46, 120,  63,  33, 112,  50,  33,
	 96,  54,  34,  88,  53,  35, 112,  61,  46, 127,  65,  47, 135,  70,  36, 128,
	 63,  36, 128,  63,  46, 104,  55,  34,  88,  53,  31,  72,  45,  32,  80,  46,
	 33,  96,  54,  33, 104,  49,  20, 104,  44,  33, 104,  49,  31,  96,  43,  31,
	 96,  43,  46, 104,  55,  46, 104,  55,  34,  88,  53,  31,  88,  42,  19,  95,
	 39,  33, 112,  50,  51, 128,  77,  33,  96,  54,  48,  80,  62,  48,  80,  62,
	 49, 104,  69,  49, 119,  77,  36, 128,  63,  36, 120,  56,  33,  96,  54,  32,
	 80,  46,  31,  72,  45,  47,  88,  62,  49, 104,  69,  49, 104,  69,  35, 104,
	 60,  33, 112,  50,  33, 104,  49,  33, 104,  49,  46, 104,  55,  31,  88,  42,
	 34,  88,  53,  47,  88,  62,  48,  96,  63,  48,  96,  63,  49, 104,  69,  49,
	104,  69,  60, 112,  73,  49, 104,  69,  46, 120,  63,  33, 112,  50,  20, 104,
	 44,  20, 111,  48,  46, 127,  65,  46, 120,  63,  33, 104,  49,  46,  72,  47,
	 30,  64,  34,  34,  88,  53,  46, 104,  55,  34,  88,  53,  20,  80,  34,  33,
	104,  49,  33, 104,  49,  35, 112,  61,  33, 112,  50,  33, 112,  50,  33, 104,
	 49,  34,  88,  53,  34,  88,  53,  47,  88,  62,  33,  96,  54,  49, 104,  69,
	 47, 112,  69,  49, 104,  69,  49, 104,  69,  35, 104,  60,  35, 104,  60,  35,
	104,  60,  35, 104,  60,  49, 104,  69,  49, 104,  69,  35, 112,  61,  46, 120,
	 63,  35, 112,  61,  35, 104,  60,  49, 104,  69,  48,  96,  63,  48,  96,  63,
	 49, 104,  69,  49, 104,  69,  49, 104,  69,  48,  96,  63,  48,  80,  62,  46,
	 72,  47,  30,  48,  39,  32,  80,  46,  46, 104,  55,  46, 120,  63,  46, 120,
	 63,  46, 120,  63,  60, 127,  68,  68, 127,  72,  60, 127,  68,  36, 128,  63,
	 46, 127,  65,  51, 128,  77,  36, 120,  56,  33, 104,  49,  33,  96,  54,  19,
	 71,  34,  11,  48,  24,  20,  48,  27,  32,  80,  46,  46,  96,  49,  46, 104,
	 55,  35, 112,  61,  47, 112,  69,  60, 120,  78,  47, 135,  70,  51, 128,  77,
	 47, 135,  70,  65, 136,  84,  47, 135,  70,  36, 128,  63,  36, 128,  63,  36,
	128,  63,  48,  96,  63,  33,  96,  54,  33,  96,  54,  46, 112,  58,  46, 127,
	 65,  33, 112,  50,  20, 104,  44,  20,  96,  54,  20, 111,  48,  36, 128,  63,
	 47, 135,  70,  36, 128,  63,  36, 128,  63,  35, 104,  60,  20,  81,  44,  31,
	 72,  45,  34,  88,  53,  31,  96,  43,  31,  96,  43,  19,  95,  39,  46, 104,
	 55,  70, 104,  55,  73, 104,  81,  72, 112,  82,  72, 112,  82,  48,  96,  63,
	 49, 104,  69,  48,  96,  63,  33, 112,  50,  33, 104,  49,  32,  80,  46,  31,
	 72,  45,  32,  64,  46,  34,  88,  53,  35, 112,  61,  20, 104,  44,  20,  88,
	 38,  48,  96,  63,  87, 113,  79, 100, 129, 107, 127, 137, 126, 129, 149, 131,
	 95, 142, 103,  60, 120,  78,  33, 104,  49,  33, 104,  49,  33, 112,  50,  33,
	104,  49,  32,  80,  46,  46,  80,  45,  34,  88,  53,  46,  80,  45,  47,  88,
	 47,  46,  96,  49,  60, 104,  53,  46, 112,  58,  46, 112,  58,  33, 104,  49,
	 20, 104,  44,  20, 104,  44,  33, 112,  50,  33, 112,  50,  49, 104,  69,  72,
	112,  82,  72,  96,  77,  72,  96,  77,  87, 121,  96,  88, 128,  95,  70, 104,
	 55,  46,  96,  49,  35, 104,  60,  20, 104,  44,  33, 112,  50,  33, 112,  50,
	 33, 112,  50,  33, 104,  49,  32,  80,  46,  32,  64,  46,  32,  64,  46,  31,
	 72,  45,  48,  80,  62,  34,  88,  53,  32,  80,  46,  32,  80,  46,  31,  72,
	 45,  31,  72,  45,  31,  72,  45,  32,  64,  46,  32,  64,  46,  20,  64,  45,
	 20,  64,  45,  20,  64,  45,  20,  64,  45,  32,  64,  46,  32,  56,  45,  32,
	 56,  45,  32,  56,  45,  32,  64,  46,  31,  72,  45,  32,  64,  46,  32,  64,
	 46,  32,  56,  45,  30,  48,  39,  22,  33,  29,  20,  81,  44,  33,  96,  54,
	 47, 112,  69,  46, 120,  63,  46, 120,  63,  51, 128,  77,  51, 128,  77,  46,
	127,  65,  28, 127,  58,  36, 128,  63,  36, 128,  63,  36, 120,  56,  35, 112,
	 61,  33,  96,  54,  29,  72,  35,  20,  48,  27,  11,  56,  28,  29,  72,  35,
	 31,  96,  43,  46, 104,  55,  33, 104,  49,  35, 112,  61,  36, 120,  69,  46,
	120,  63,  36, 128,  63,  46, 127,  65,  51, 128,  77,  47, 135,  70,  51, 128,
	 77,  28, 127,  58,  28, 127,  58,  33,  96,  54,  31,  88,  42,  31,  88,  42,
	 46, 112,  58,  46, 120,  63,  33, 104,  49,  33,  96,  54,  33,  96,  54,  35,
	104,  60,  46, 120,  63,  36, 128,  63,  36, 120,  56,  36, 120,  56,  33,  96,
	 54,  20,  72,  45,  20,  64,  32,  30,  80,  35,  31,  88,  42,  31,  88,  42,
	 33,  96,  54,  60, 104,  73,  87, 105,  93,  73, 104,  81,  87, 113,  96, 100,
	129, 107,  73, 104,  81,  87, 113,  96,  60, 112,  73,  46, 120,  63,  33, 104,
	 49,  20,  81,  44,  20,  64,  45,  20,  55,  46,  34,  88,  53,  33,  96,  54,
	 20,  88,  38,  34,  88,  53,  87, 121,  96, 140, 158, 140, 164, 178, 164, 152,
	176, 159, 152, 176, 159, 140, 168, 148, 111, 149, 119,  73, 120,  87,  47, 112,
	 69,  46, 104,  55,  31,  96,  43,  32,  80,  46,  32,  80,  46,  48,  72,  31,
	 32,  80,  46,  32,  80,  46,  47,  88,  47,  33,  96,  54,  46, 104,  55,  46,
	 96,  49,  31,  96,  43,  31,  96,  43,  36, 120,  56,  33, 112,  50,  49, 104,
	 69,  87, 113,  79, 127, 137, 126, 100, 118, 100,  87, 113,  96, 113, 137, 117,
	129, 149, 131, 100, 113, 101,  87, 113,  79,  60, 127,  68,  20, 111,  48,  33,
	112,  50,  33, 112,  50,  33, 112,  50,  33, 104,  49,  31,  72,  45,  11,  40,
	 24,  11,  40,  24,  20,  48,  27,  20,  40,  27,  20,  40,  36,  22,  33,  29,
	 30,  40,  38,  20,  40,  36,  22,  33,  29,  22,  33,  29,  22,  33,  29,  20,
	 40,  36,  20,  40,  27,  22,  33,  29,  11,  40,  24,  20,  40,  36,  22,  33,
	 29,  12,  33,  29,  21,  25,  22,  12,  33,  29,  20,  40,  36,  20,  40,  36,
	 11,  48,  24,  11,  40,  24,  11,  48,  24,  20,  40,  27,  20,  40,  27,  10,
	 87,  42,  33, 104,  49,  46, 120,  63,  46, 127,  65,  36, 128,  63,  36, 128,
	 63,  36, 128,  63,  36, 128,  63,  46, 127,  65,  46, 120,  63,  46, 120,  63,
	 46, 112,  58,  33, 112,  50,  33, 104,  49,  32,  80,  46,  32,  64,  46,  11,
	 48,  24,  29,  72,  35,  46,  96,  49,  46, 104,  55,  46,  96,  49,  35, 104,
	 60,  46, 112,  58,  46, 120,  63,  36, 128,  63,  46, 120,  63,  51, 128,  77,
	 51, 128,  77,  36, 128,  63,  28, 127,  58,  36, 128,  63,  33, 104,  49,  20,
	 88,  53,  33,  96,  54,  49, 104,  69,  60, 104,  53,  46,  96,  49,  47,  88,
	 47,  48,  80,  62,  46, 104,  55,  49, 119,  77,  46, 120,  63,  46, 112,  58,
	 46, 112,  58,  33,  96,  54,  29,  72,  35,  32,  64,  46,  19,  71,  34,  20,
	 80,  34,  20,  81,  44,  47,  88,  47,  72,  96,  77,  72,  88,  78,  72,  88,
	 78,  72,  88,  78,  87, 105,  93,  86,  93,  88,  87, 105,  93,  72, 112,  82,
	 72, 121,  71,  60, 120,  64,  32,  80,  46,  20,  64,  32,  30,  64,  34,  32,
	 80,  46,  31,  88,  42,  33,  96,  54,  87, 121,  96, 129, 149, 131, 151, 153,
	148, 127, 137, 126, 140, 148, 138, 148, 145, 137, 153, 160, 148, 140, 168, 148,
	 95, 142, 103,  73, 128,  87,  47, 112,  69,  10,  87,  42,  31,  72,  45,  29,
	 72,  35,  19,  71,  34,  29,  72,  35,  30,  80,  35,  20,  81,  44,  31,  88,
	 42,  33,  96,  54,  31,  88,  42,  31,  96,  43,  31,  96,  43,  10,  87,  42,
	 31,  88,  42,  70, 104,  55, 100, 113, 101, 110, 113, 105,  72,  96,  77,  72,
	 88,  78, 100, 104, 101, 110, 113, 105, 100, 104, 101,  86, 104,  81,  73, 128,
	 87,  51, 128,  77,  36, 120,  56,  27, 120,  53,  36, 120,  56,  46, 112,  58,
	 32,  80,  46,  20,  40,  27,  11,  40,  24,  29,  56,  33,  29,  72,  35,  29,
	 72,  35,  31,  72,  45,  31,  72,  45,  31,  72,  45,  32,  64,  46,  31,  72,
	 45,  32,  64,  46,  30,  80,  35,  30,  80,  35,  29,  72,  35,  31,  72,  45,
	 32,  80,  46,  30,  80,  35,  31,  72,  45,  29,  72,  35,  20,  72,  45,  20,
	 81,  44,  20,  81,  44,  20,  80,  34,  32,  80,  46,  20,  80,  34,  20,  81,
	 44,  20,  81,  44,  31,  96,  43,  46, 104,  55,  60, 104,  53,  72, 112,  59,
	 68, 127,  72,  46, 127,  65,  60, 127,  68,  68, 127,  72,  72, 121,  71,  87,
	113,  79,  70, 104,  55,  60, 104,  53,  33, 112,  50,  20, 104,  44,  20,  81,
	 44,  30,  48,  26,  20,  48,  36,  46,  72,  47,  60,  87,  43,  70,  97,  49,
	 60,  96,  47,  49, 104,  69,  60, 112,  73,  60, 127,  68,  60, 129,  79,  60,
	127,  68,  68, 127,  72,  60, 120,  78,  46, 127,  65,  46, 127,  65,  35, 112,
	 61,  33,  96,  54,  31,  88,  42,  34,  88,  53,  46,  96,  49,  60,  96,  47,
	 60,  80,  38,  44,  64,  50,  60,  73,  46,  31,  96,  43,  46, 104,  55,  46,
	104,  55,  46, 104,  55,  46,  96,  49,  47,  88,  47,  32,  64,  46,  30,  64,
	 34,  29,  72,  35,  32,  80,  46,  32,  80,  46,  34,  88,  53,  60,  80,  67,
	 60,  72,  66,  54,  56,  58,  54,  56,  58,  49,  71,  62,  55,  64,  59,  72,
	 88,  78,  60,  96,  67,  73, 120,  87,  73, 128,  87,  48,  96,  63,  20,  64,
	 45,  20,  64,  45,  20,  81,  44,  48,  96,  63,  60, 104,  73,  87, 121,  96,
	127, 137, 126, 124, 129, 111, 100, 113, 101, 115, 128, 119, 110, 113, 105, 127,
	137, 126, 129, 149, 131, 113, 137, 117,  88, 128,  95,  60, 120,  78,  33, 104,
	 49,  32,  80,  46,  32,  80,  46,  31,  72,  45,  32,  80,  46,  32,  80,  46,
	 34,  88,  53,  35, 104,  60,  46,  96,  49,  49, 104,  69,  46,  96,  49,  31,
	 88,  42,  49, 104,  69,  72, 112,  82,  72, 112,  82,  86,  93,  88,  70,  73,
	 73,  72,  80,  76,  60,  72,  66,  70,  73,  73,  72,  80,  76,  86,  81,  76,
	 86,  93,  88,  87, 121,  96,  95, 152, 108,  51, 128,  77,  46, 127,  65,  36,
	120,  56,  46, 112,  58,  31,  72,  45,  20,  48,  36,  20,  48,  36,  48,  80,
	 62,  28, 127,  58,  36, 128,  63,  27, 120,  53,  36, 120,  56,  27, 120,  53,
	 36, 120,  56,  35, 112,  61,  36, 120,  69,  20, 104,  44,  33, 104,  49,  33,
	112,  50,  46, 120,  63,  46, 112,  58,  36, 120,  56,  27, 120,  53,  27, 120,
	 53,  35, 112,  61,  35, 112,  61,  33, 112,  50,  33, 112,  50,  33, 112,  50,
	 20, 104,  44,  33, 104,  49,  33, 104,  49,  60,  96,  47,  71,  80,  27,  88,
	 80,  39,  86,  95,  42,  84, 106,  52,  70, 104,  55,  70,  97,  49,  86,  95,
	 42,  70,  97,  49,  70,  97,  49,  86,  95,  42,  70, 104,  55,  35, 112,  61,
	 20, 104,  44,  19,  71,  34,  20,  48,  27,  30,  48,  39,  44,  65,  31,  71,
	 80,  27,  60,  87,  43,  60,  87,  43,  60,  87,  43,  46, 104,  55,  46, 112,
	 58,  46, 120,  63,  60, 112,  53,  60, 112,  53,  60, 120,  64,  49, 119,  77,
	 46, 127,  65,  46, 120,  63,  19,  95,  39,  20,  81,  44,  32,  80,  46,  47,
	 88,  47,  46,  96,  49,  48,  72,  31,  29,  72,  35,  31,  72,  45,  31,  96,
	 43,  46, 104,  55,  46, 104,  55,  31,  96,  43,  31,  96,  43,  30,  80,  35,
	 29,  72,  35,  32,  64,  46,  32,  80,  46,  32,  80,  46,  31,  72,  45,  49,
	 71,  62,  49,  71,  62,  44,  48,  47,  30,  40,  38,  30,  40,  38,  32,  56,
	 45,  54,  56,  58,  55,  64,  59,  49,  71,  62,  60, 104,  73,  81, 135,  95,
	 48,  96,  63,  11,  48,  24,  20,  64,  32,  32,  80,  46,  48,  96,  63,  60,
	 88,  68,  60,  80,  67,  72,  88,  78,  86,  93,  88,  72,  96,  77,  87, 105,
	 93,  72,  88,  78,  86,  93,  88,  87, 105,  93,  72,  96,  77,  87, 121,  96,
	 73, 120,  87,  33,  96,  54,  47,  88,  62,  47,  88,  62,  48,  80,  62,  48,
	 80,  62,  48,  80,  62,  47,  88,  62,  48,  80,  62,  47,  88,  62,  48,  96,
	 63,  31,  72,  45,  48,  80,  62,  87, 113,  96, 100, 129, 107,  86,  93,  88,
	 60,  72,  66,  60,  72,  66,  60,  72,  66,  55,  64,  59,  44,  64,  50,  55,
	 64,  59,  70,  73,  73,  49,  71,  62,  73, 104,  81, 111, 149, 119,  47, 135,
	 70,  36, 120,  56,  33, 112,  50,  46, 104,  55,  32,  80,  46,  11,  48,  24,
	 20,  48,  36,  47,  88,  47,  27, 120,  53,  20, 111,  48,  20, 111,  48,  20,
	111,  48,  20, 104,  44,  35, 104,  60,  20, 104,  44,  35, 104,  60,  49, 119,
	 77,  73, 120,  87,  73, 128,  87,  81, 135,  95,  88, 128,  95,  60, 129,  79,
	 46, 120,  63,  27, 120,  53,  36, 120,  56,  33, 112,  50,  33, 112,  50,  33,
	112,  50,  33, 104,  49,  33, 104,  49,  19,  95,  39,  20, 104,  44,  46, 104,
	 55,  60,  87,  43,  89,  73,  22,  90,  88,  32,  70,  97,  49,  46, 104,  55,
	 46,  96,  49,  70,  97,  49,  46,  96,  49,  71,  80,  27,  72,  88,  39,  60,
	104,  53,  27, 120,  53,  20, 104,  44,  20,  72,  45,  30,  40,  38,  20,  48,
	 36,  30,  64,  34,  60,  80,  38,  60,  80,  38,  48,  72,  31,  46,  80,  45,
	 46,  96,  49,  46, 104,  55,  46, 104,  55,  46, 104,  55,  46, 104,  55,  46,
	112,  58,  46, 120,  63,  46, 127,  65,  46, 127,  65,  31,  88,  42,  30,  80,
	 35,  30,  80,  35,  46,  96,  49,  46, 104,  55,  31,  88,  42,  31,  88,  42,
	 34,  88,  53,  31,  96,  43,  46, 120,  63,  46, 120,  63,  46, 104,  55,  31,
	 96,  43,  32,  80,  46,  19,  71,  34,  20,  72,  45,  32,  64,  46,  31,  72,
	 45,  20,  64,  45,  32,  64,  46,  44,  56,  49,  38,  33,  34,  10,  25,  17,
	 12,  33,  29,  49,  71,  62,  44,  64,  50,  44,  64,  50,  32,  64,  46,  48,
	 96,  63,  73, 128,  87,  48,  96,  63,  11,  48,  24,  32,  64,  46,  32,  80,
	 46,  48,  80,  62,  31,  72,  45,  32,  64,  46,  44,  48,  47,  32,  56,  45,
	 44,  48,  47,  32,  56,  45,  30,  48,  39,  55,  64,  59,  72,  80,  76,  72,
	 88,  78,  87, 113,  96,  72, 112,  82,  19,  71,  34,  32,  56,  45,  32,  56,
	 45,  20,  40,  36,  20,  40,  27,  20,  40,  27,  21,  32,  19,  11,  40,  24,
	 11,  33,  18,  11,  48,  24,  11,  40,  24,  30,  48,  26,  30,  48,  39,  44,
	 48,  47,  44,  56,  49,  44,  64,  50,  44,  64,  50,  44,  48,  47,  44,  56,
	 49,  30,  48,  39,  54,  56,  58,  55,  64,  59,  44,  48,  47,  60,  80,  67,
	111, 149, 119,  49, 119,  77,  35, 112,  61,  33, 112,  50,  35, 112,  61,  32,
	 80,  46,  11,  40,  24,  11,  48,  24,  29,  72,  35,  46, 112,  58,  46, 104,
	 55,  46,  96,  49,  48,  96,  63,  47,  88,  47,  48,  96,  63,  48,  96,  63,
	 60,  96,  67, 148, 145, 137, 148, 145, 137, 166, 156, 156, 166, 156, 156, 148,
	145, 137, 127, 137, 126,  87, 121,  96,  73, 120,  87,  33, 112,  50,  33, 104,
	 49,  33, 104,  49,  33, 104,  49,  33, 104,  49,  31,  96,  43,  33,  96,  54,
	 31,  96,  43,  20, 111,  48,  31,  96,  43,  60,  87,  43,  70,  97,  49,  60,
	127,  68,  47, 135,  70,  46, 127,  65,  60, 127,  68,  60, 112,  53,  60, 104,
	 53,  60,  87,  43,  46, 104,  55,  20, 111,  48,  20, 104,  44,  20,  72,  45,
	 44,  48,  20,  11,  48,  24,  30,  64,  34,  60,  80,  38,  60,  87,  43,  60,
	 87,  43,  46, 104,  55,  60, 120,  64,  46, 127,  65,  46, 127,  65,  46, 112,
	 58,  60, 112,  53,  46, 120,  63,  46, 127,  65,  36, 128,  63,  27, 120,  53,
	 20,  88,  53,  10,  80,  48,  31,  88,  42,  33, 104,  49,  33, 112,  50,  20,
	104,  44,  20,  88,  38,  32,  80,  46,  33, 104,  49,  46, 112,  58,  46, 112,
	 58,  33, 112,  50,  20, 104,  44,  10,  87,  42,  20,  72,  45,  32,  56,  45,
	 20,  88,  38,  32,  80,  46,  20,  55,  46,  32,  56,  45,  55,  64,  59,  70,
	 73,  73, 100, 104, 101,  88,  98,  92,  32,  64,  46,  68,  65,  70,  68,  54,
	 60,  44,  41,  48,  48,  96,  63,  73, 128,  87,  48,  96,  63,  20,  48,  36,
	 30,  48,  39,  20,  81,  44,  33,  96,  54,  31,  72,  45,  30,  40,  38,  41,
	 25,  31,  44,  41,  48,  22,  33,  29,  20,  48,  36,  44,  48,  47,  38,  33,
	 34,  22,  33,  29,  44,  64,  50,  73, 120,  87,  60, 112,  73,  11,  56,  28,
	 11,  40,  24,  11,  33,  18,  11,  40,  24,  11,  48,  24,  20,  48,  27,  11,
	 48,  24,  11,  56,  28,  19,  71,  34,  11,  64,  29,  19,  71,  34,  29,  72,
	 35,  11,  64,  29,  11,  48,  24,  20,  48,  36,  44,  41,  48,  44,  41,  48,
	 20,  55,  46,  30,  48,  39,  30,  48,  39,  44,  48,  47,  20,  40,  36,  29,
	 56,  33,  73, 120,  87,  97, 160, 113,  36, 128,  63,  33, 112,  50,  33, 104,
	 49,  31,  88,  42,  31,  72,  45,  11,  56,  28,  20,  56,  32,  32,  80,  46,
	 27, 120,  53,  36, 120,  56,  33, 112,  50,  20,  88,  38,  46, 104,  55,  30,
	 80,  35,  73, 104,  81, 113, 137, 117, 112, 119, 110, 112, 119, 110, 110, 113,
	105, 112, 119, 110, 140, 142, 137, 113, 137, 117, 112, 119, 110, 100, 113, 101,
	 46, 120,  63,  33, 104,  49,  31,  96,  43,  33, 104,  49,  46, 104,  55,  31,
	 96,  43,  31,  96,  43,  19,  95,  39,  33, 112,  50,  20, 104,  44,  46, 104,
	 55,  46, 120,  63,  36, 120,  56,  36, 128,  63,  46, 127,  65,  36, 128,  63,
	 34, 135,  65,  20, 111,  48,  20, 104,  44,  33, 112,  50,  33, 112,  50,  20,
	104,  44,  20,  64,  32,  20,  48,  27,  20,  48,  36,  32,  64,  46,  31,  96,
	 43,  31,  96,  43,  33, 104,  49,  33, 104,  49,  27, 120,  53,  44, 142,  72,
	 36, 128,  63,  46, 127,  65,  47, 135,  70,  36, 128,  63,  34, 135,  65,  36,
	120,  69,  27, 120,  53,  31,  88,  42,  20,  80,  34,  30,  80,  35,  46,  96,
	 49,  46, 112,  58,  33, 104,  49,  47,  88,  47,  47,  88,  47,  46, 104,  55,
	 46, 112,  58,  46, 112,  58,  33, 112,  50,  46, 104,  55,  33,  96,  54,  31,
	 72,  45,  32,  64,  46,  11,  64,  29,  48,  96,  63,  47,  88,  47,  32,  56,
	 45,  44,  64,  50, 100, 113, 101, 140, 148, 138, 112, 119, 110,  49,  71,  62,
	 44,  48,  47,  41,  25,  31,  44,  56,  49,  72, 112,  59,  49, 119,  77,  32,
	 80,  46,  11,  40,  24,  12,  33,  29,  32,  80,  46,  47, 112,  69,  32,  80,
	 46,  11,  33,  18,  41,  25,  31,  22,  33,  29,  12,  33,  29,  21,  25,  22,
	 22,  33,  29,  21,  25,  22,  10,  25,  17,  32,  64,  46,  73, 120,  87,  72,
	112,  82,  20,  64,  32,  30,  48,  39,  20,  56,  32,  32,  64,  46,  32,  80,
	 46,  46,  80,  45,  46,  80,  45,  31,  96,  43,  46, 104,  55,  48,  96,  63,
	 30,  80,  35,  33,  96,  54,  73, 120,  87,  60, 104,  73,  20,  55,  46,  12,
	 33,  29,  44,  48,  47,  22,  33,  29,  44,  48,  47,  44,  48,  47,  44,  41,
	 48,  22,  33,  29,  32,  56,  45,  88, 128,  95, 108, 162, 116,  36, 128,  63,
	 20, 104,  44,  33,  96,  54,  48,  96,  63,  32,  80,  46,  29,  56,  33,  32,
	 64,  46,  60,  96,  67,  36, 120,  56,  36, 120,  56,  33, 104,  49,  31,  96,
	 43,  46, 104,  55,  32,  80,  46,  72, 112,  82, 100, 113, 101,  88,  98,  92,
	 72,  80,  76,  72,  80,  76, 100, 104, 101,  88,  98,  92,  87, 105,  93, 116,
	122,  84, 127, 137, 126,  83, 153, 103,  51, 128,  77,  35, 104,  60,  33, 104,
	 49,  33,  96,  54,  33,  96,  54,  33,  96,  54,  19,  95,  39,  33, 104,  49,
	 46, 104,  55,  46, 120,  63,  60, 127,  68,  33, 112,  50,  33, 112,  50,  36,
	120,  56,  60, 112,  53,  46, 120,  63,  46, 112,  58,  46, 104,  55,  35, 104,
	 60,  33,  96,  54,  33,  96,  54,  31,  72,  45,  30,  48,  39,  30,  48,  39,
	 30,  64,  34,  46,  96,  49,  33, 104,  49,  46,  96,  49,  46, 104,  55,  47,
	112,  69,  60, 127,  68,  46, 120,  63,  46, 127,  65,  68, 127,  72,  47, 135,
	 70,  46, 127,  65,  27, 120,  53,  46, 120,  63,  32,  80,  46,  29,  72,  35,
	 30,  80,  35,  46,  96,  49,  46, 104,  55,  34,  88,  53,  31,  72,  45,  48,
	 72,  31,  60,  96,  47,  70, 104,  55,  46, 104,  55,  46,  96,  49,  46, 104,
	 55,  47,  88,  47,  32,  64,  46,  32,  56,  45,  20,  56,  32,  47,  88,  47,
	 34,  88,  53,  20,  72,  45,  11,  40,  24,  11,  40,  24,  44,  56,  49,  54,
	 56,  58,  44,  48,  47,  12,  33,  29,  12,  33,  29,  48,  80,  62,  73, 128,
	 87,  47, 112,  69,  20,  64,  32,  30,  40,  38,  30,  48,  39,  20,  64,  45,
	 33,  96,  54,  35, 112,  61,  31,  72,  45,  10,  25,  17,   9,  16,  12,   9,
	 16,  12,  21,  25,  22,   9,  16,  12,   9,  16,  12,  11,  40,  24,  47,  88,
	 62,  81, 135,  95,  60, 112,  73,  11,  48,  24,  29,  40,  26,  20,  40,  27,
	 20,  64,  45,  32,  80,  46,  32,  80,  46,  30,  80,  35,  19,  95,  39,  33,
	112,  50,  49, 104,  69,  31,  96,  43,  34,  88,  53,  47, 112,  69,  73, 120,
	 87,  60, 104,  73,  32,  56,  45,  10,  25,  17,  30,  40,  38,  44,  41,  48,
	 38,  33,  34,  21,  25,  22,  44,  48,  47,  73, 104,  81,  97, 136, 103,  68,
	127,  72,  33, 112,  50,  19,  95,  39,  31,  88,  42,  73, 104,  81,  60,  88,
	 68,  32,  56,  45,  49,  71,  62,  87, 113,  96,  60, 129,  79,  46, 112,  58,
	 46, 104,  55,  46, 112,  58,  33, 104,  49,  32,  80,  46,  72,  88,  78,  70,
	 73,  73,  72,  80,  76,  55,  64,  59,  72,  80,  76,  84,  86,  87,  68,  65,
	 70,  86,  81,  76, 100, 113, 101, 115, 128, 119, 113, 137, 117,  73, 104,  81,
	 47,  88,  62,  33,  96,  54,  48,  96,  63,  48,  96,  63,  48,  96,  63,  47,
	 88,  62,  47,  88,  62,  46,  96,  49,  70,  97,  49,  70, 104,  55,  70, 104,
	 55,  70,  97,  49,  70, 104,  55,  70,  97,  49,  70, 104,  55,  70, 104,  55,
	 72,  96,  77,  46,  80,  45,  32,  80,  46,  47,  88,  62,  49,  71,  62,  30,
	 48,  39,  20,  40,  36,  31,  72,  45,  47,  88,  47,  46,  96,  49,  60,  87,
	 43,  60,  80,  38,  70,  97,  49,  72, 112,  59,  60, 112,  53,  72, 112,  59,
	 72, 112,  59,  68, 127,  72,  46, 120,  63,  36, 128,  63,  49, 119,  77,  33,
	 96,  54,  30,  80,  35,  30,  80,  35,  46,  96,  49,  33, 104,  49,  30,  80,
	 35,  30,  64,  34,  44,  48,  20,  46,  80,  45,  60,  96,  47,  46, 104,  55,
	 33, 104,  49,  46,  96,  49,  32,  80,  46,  32,  64,  46,  20,  56,  32,  46,
	 80,  45,  32,  80,  46,  34,  88,  53,  49, 119,  77,  49, 104,  69,  11,  56,
	 28,  22,  33,  29,  30,  40,  38,  29,  40,  26,  30,  48,  39,  46,  72,  47,
	 60, 120,  78,  65, 136,  84,  33, 104,  49,  20,  64,  32,  30,  48,  39,  44,
	 56,  49,  11,  56,  28,  10,  80,  48,  51, 128,  77,  60, 112,  73,  46,  72,
	 47,  22,  33,  29,  10,  25,  17,  21,  25,  22,  21,  25,  22,  20,  48,  36,
	 34,  88,  53,  60, 129,  79,  81, 143,  95,  46, 104,  55,  11,  33,  18,  22,
	 33,  29,  30,  48,  26,  29,  72,  35,  30,  80,  35,  30,  80,  35,  20,  80,
	 34,  19,  95,  39,  20, 111,  48,  33, 104,  49,  33, 112,  50,  19,  95,  39,
	 10,  87,  42,  49, 119,  77,  95, 152, 108,  60, 120,  78,  20,  64,  45,  22,
	 33,  29,  12,  33,  29,  10,  25,  17,  30,  40,  38,  47,  88,  62,  81, 135,
	 95,  66, 143,  88,  33, 104,  49,  33, 104,  49,  31,  96,  43,  48,  96,  63,
	 72, 112,  82,  88,  98,  92,  60,  72,  66,  86,  93,  88, 127, 129, 125,  88,
	128,  95,  73, 120,  87,  60, 120,  64,  35, 112,  61,  35, 104,  60,  32,  80,
	 46,  44,  56,  49,  68,  54,  60,  32,  56,  45,  55,  64,  59,  68,  65,  70,
	 54,  56,  58,  54,  56,  58,  54,  56,  58,  44,  56,  49,  44,  48,  47,  68,
	 66,  52,  29,  40,  26,  20,  40,  27,  20,  48,  36,  20,  48,  27,  30,  48,
	 39,  30,  40,  38,  44,  42,  26,  30,  48,  39,  30,  48,  26,  30,  48,  26,
	 55,  55,  31,  68,  56,  26,  79,  64,  30,  92,  66,  32,  71,  47,  23,  44,
	 65,  31,  70,  72,  39,  56,  65,  29,  29,  56,  33,  11,  48,  24,  20,  48,
	 36,  20,  48,  36,  11,  33,  18,  11,  48,  24,  20,  64,  32,  31,  88,  42,
	 47,  88,  47,  48,  72,  31,  56,  65,  29,  71,  80,  27,  86,  95,  42,  60,
	 96,  47,  70,  97,  49,  60, 112,  53,  60, 112,  53,  46, 120,  63,  36, 128,
	 63,  36, 128,  63,  33,  96,  54,  30,  80,  35,  31,  88,  42,  33, 112,  50,
	 46, 112,  58,  31,  96,  43,  30,  80,  35,  55,  64,  59,  48,  72,  31,  46,
	 96,  49,  60, 112,  53,  46, 112,  58,  46,  96,  49,  31,  88,  42,  30,  64,
	 34,  20,  64,  45,  30,  64,  34,  20,  64,  32,  19,  71,  34,  33,  96,  54,
	 60, 120,  78,  72, 112,  82,  32,  56,  45,  30,  40,  38,  55,  64,  59,  73,
	104,  81,  87, 121,  96,  51, 128,  77,  46, 120,  63,  31,  96,  43,  20,  64,
	 32,  20,  40,  27,  20,  40,  27,  30,  64,  34,  31,  88,  42,  35, 104,  60,
	 47, 112,  69,  73, 120,  87,  72,  96,  77,  22,  33,  29,  30,  40,  38,  44,
	 56,  49,  73, 104,  81,  73, 128,  87,  60, 129,  79,  49, 119,  77,  47,  88,
	 47,  30,  48,  26,  29,  40,  26,  29,  56,  33,  31,  72,  45,  20,  80,  34,
	 20,  80,  34,  31,  88,  42,  20, 104,  44,  33, 112,  50,  33, 112,  50,  33,
	112,  50,  20, 104,  44,  20, 104,  44,  33, 112,  50,  51, 128,  77,  65, 136,
	 84,  65, 136,  84,  72, 112,  82,  72, 112,  82,  81, 135,  95,  81, 135,  95,
	 73, 128,  87,  65, 136,  84,  47, 135,  70,  27, 120,  53,  31,  96,  43,  46,
	 96,  49,  72,  96,  77,  72,  96,  77,  72,  80,  76,  70,  73,  73,  84,  86,
	 87, 100, 104, 101, 100, 113, 101,  87, 121,  96,  88, 128,  95,  47, 112,  69,
	 49, 119,  77,  49, 104,  69,  20,  40,  36,  54,  49,  50,  30,  40,  38,  54,
	 56,  58,  44,  48,  47,  44,  41,  48,  54,  56,  58,  44,  41,  48,  12,  33,
	 29,  32,  56,  45,  60,  80,  67,  30,  64,  34,  30,  64,  34,  20,  64,  32,
	 20,  56,  32,  11,  48,  24,  30,  48,  26,  29,  40,  26,  30,  48,  39,  11,
	 48,  24,  20,  56,  32,  29,  56,  33,  52,  50,  20,  77,  57,  27,  79,  64,
	 30,  68,  56,  26,  56,  57,  18,  48,  72,  31,  60,  72,  31,  44,  65,  31,
	 29,  56,  33,  11,  56,  28,  11,  56,  28,  20,  56,  32,  20,  56,  32,  19,
	 71,  34,  30,  80,  35,  30,  80,  35,  48,  72,  31,  56,  65,  29,  71,  71,
	 25,  86,  95,  42,  60,  96,  47,  70, 104,  55,  70,  97,  49,  60, 112,  53,
	 46, 120,  63,  36, 128,  63,  36, 128,  63,  31,  88,  42,  20,  81,  44,  31,
	 88,  42,  35, 104,  60,  36, 120,  69,  33,  96,  54,  47,  88,  47,  48,  72,
	 31,  48,  72,  31,  46,  96,  49,  46, 120,  63,  33, 112,  50,  46, 104,  55,
	 46,  80,  45,  20,  64,  45,  20,  72,  45,  32,  64,  46,  32,  80,  46,  31,
	 88,  42,  20,  81,  44,  49, 104,  69,  60, 112,  73,  46,  72,  47,  55,  64,
	 59,  46,  72,  47,  87, 105,  93,  60, 112,  73,  31,  88,  42,  20,  88,  38,
	 34,  88,  53,  30,  64,  34,  11,  33,  18,  20,  48,  27,  32,  64,  46,  32,
	 80,  46,  20,  81,  44,  20,  88,  38,  60, 104,  73,  60,  88,  68,  32,  56,
	 45,  32,  56,  45,  48,  80,  62,  73, 104,  81,  47, 112,  69,  33,  96,  54,
	 20,  88,  53,  32,  80,  46,  30,  64,  34,  22,  33,  29,  20,  48,  36,  20,
	 64,  32,  19,  71,  34,  30,  80,  35,  30,  80,  35,  46,  96,  49,  46, 104,
	 55,  46, 120,  63,  33, 104,  49,  20, 104,  44,  20, 104,  44,  33, 104,  49,
	 33, 112,  50,  60, 129,  79,  66, 143,  88,  81, 143,  95,  81, 143,  95,  97,
	160, 113,  83, 153, 103,  47, 112,  69,  19,  95,  39,  10,  87,  42,  20, 104,
	 44,  48,  96,  63,  60,  96,  67,  72,  88,  78,  72,  80,  76,  68,  65,  70,
	 68,  65,  70,  70,  73,  73,  72,  80,  76,  84,  86,  87,  88,  98,  92,  88,
	128,  95,  73, 120,  87,  49, 119,  77,  47, 112,  69,  11,  33,  18,  44,  41,
	 48,  20,  40,  36,  44,  48,  47,  30,  40,  38,  44,  41,  48,  54,  56,  58,
	 12,  33,  29,  20,  48,  36,  73, 120,  87,  83, 153, 103,  47, 135,  70,  49,
	119,  77,  46, 120,  63,  33, 104,  49,  33,  96,  54,  33,  96,  54,  49, 104,
	 69,  20,  88,  53,  35, 104,  60,  35, 112,  61,  46, 104,  55,  48,  72,  31,
	 71,  80,  27,  72,  88,  39,  60,  87,  43,  60,  87,  43,  72,  88,  39,  72,
	 88,  39,  70,  97,  49,  47,  88,  62,  34,  88,  53,  32,  80,  46,  47,  88,
	 47,  31,  72,  45,  29,  72,  35,  31,  88,  42,  30,  80,  35,  48,  72,  31,
	 60,  72,  31,  71,  80,  27,  86,  95,  42,  46, 104,  55,  46, 104,  55,  60,
	104,  53,  60, 112,  53,  46, 120,  63,  46, 120,  63,  36, 120,  69,  31,  72,
	 45,  19,  71,  34,  20,  81,  44,  33, 104,  49,  35, 104,  60,  33,  96,  54,
	 31,  72,  45,  31,  72,  45,  56,  65,  29,  46,  96,  49,  33, 112,  50,  20,
	104,  44,  46,  96,  49,  48,  72,  31,  30,  64,  34,  20,  72,  45,  20,  48,
	 36,  20,  64,  32,  31,  72,  45,  11,  64,  29,  30,  80,  35,  31,  72,  45,
	 20,  48,  27,  60,  88,  68,  29,  56,  33,  46,  80,  45,  32,  80,  46,  11,
	 64,  29,  19,  71,  34,  29,  72,  35,  30,  64,  34,  12,  33,  29,  20,  55,
	 46,  20,  56,  32,  31,  72,  45,  31,  72,  45,  11,  64,  29,  20,  64,  32,
	 20,  64,  45,  30,  48,  39,  32,  64,  46,  31,  72,  45,  46,  72,  47,  20,
	 80,  34,  12,  80,  32,  19,  95,  39,  31,  88,  42,  11,  56,  28,  30,  40,
	 38,  32,  56,  45,  31,  72,  45,  29,  72,  35,  30,  80,  35,  46,  72,  47,
	 47,  88,  62,  47,  88,  62,  48,  96,  63,  48,  96,  63,  47,  88,  47,  32,
	 80,  46,  30,  80,  35,  48,  96,  63,  48,  96,  63,  47,  88,  62,  48,  96,
	 63,  32,  80,  46,  60, 104,  73,  48,  96,  63,  47,  88,  62,  34,  88,  53,
	 34,  88,  53,  48,  96,  63,  87, 105,  93,  87, 105,  93,  72,  96,  77,  70,
	 73,  73,  68,  65,  70,  72,  80,  76,  70,  73,  73,  68,  65,  70,  70,  73,
	 73,  70,  73,  73,  72,  88,  78,  73, 120,  87,  47, 112,  69,  49, 104,  69,
	 32,  80,  46,  20,  56,  32,  20,  40,  36,  21,  25,  22,  22,  33,  29,  38,
	 33,  34,  22,  33,  29,  11,  40,  24,  47,  88,  62,  97, 136, 103,  44, 142,
	 72,  27, 120,  53,  33,  96,  54,  20,  88,  53,  32,  80,  46,  20,  72,  45,
	 32,  80,  46,  34,  88,  53,  32,  80,  46,  20,  88,  53,  35, 104,  60,  33,
	 96,  54,  46,  72,  47,  70,  72,  39,  60,  87,  43,  48,  72,  31,  29,  72,
	 35,  71,  80,  27,  72,  88,  39,  48,  72,  31,  31,  72,  45,  31,  72,  45,
	 31,  72,  45,  31,  72,  45,  32,  56,  45,  32,  64,  46,  31,  72,  45,  31,
	 72,  45,  55,  64,  59,  60,  73,  46,  60,  80,  38,  72,  88,  39,  31,  88,
	 42,  46,  80,  45,  47,  88,  47,  47,  88,  47,  46,  96,  49,  31,  96,  43,
	 34,  88,  53,  30,  64,  34,  20,  56,  32,  20,  64,  32,  33,  96,  54,  35,
	104,  60,  33,  96,  54,  31,  72,  45,  55,  64,  59,  56,  65,  29,  46,  96,
	 49,  33, 104,  49,  31,  96,  43,  47,  88,  47,  60,  73,  46,  32,  64,  46,
	 20,  64,  45,  32,  64,  46,  30,  64,  34,  20,  64,  32,  20,  56,  32,  30,
	 80,  35,  32,  80,  46,  11,  33,  18,  11,  40,  24,  20,  48,  27,  32,  64,
	 46,  31,  72,  45,  20,  72,  45,  29,  72,  35,  30,  64,  34,  11,  48,  24,
	 11,  48,  24,  11,  48,  24,  32,  64,  46,  32,  64,  46,  30,  64,  34,  11,
	 64,  29,  31,  72,  45,  20,  64,  45,  11,  33,  18,  11,  48,  24,  20,  56,
	 32,  29,  72,  35,  29,  72,  35,  20,  80,  34,  33,  96,  54,  31,  88,  42,
	 11,  64,  29,  30,  40,  38,  30,  48,  39,  20,  64,  45,  20,  64,  32,  20,
	 56,  32,  32,  56,  45,  44,  48,  47,  30,  48,  39,  20,  40,  36,  30,  48,
	 39,  32,  56,  45,  30,  48,  39,  29,  40,  26,  12,  33,  29,  20,  40,  36,
	 20,  48,  36,  20,  55,  46,  11,  40,  24,  32,  64,  46,  30,  48,  39,  20,
	 40,  36,  44,  41,  48,  30,  40,  38,  30,  40,  38,  60,  88,  68,  60,  80,
	 67,  54,  56,  58,  54,  49,  50,  54,  56,  58,  54,  56,  58,  32,  56,  45,
	 30,  48,  39,  68,  65,  70,  54,  56,  58,  30,  48,  39,  85, 122,  83,  46,
	 96,  49,  46, 120,  63,  95, 152, 108,  32,  80,  46,  22,  33,  29,   9,  16,
	 12,  38,  33,  34,  30,  40,  38,  10,  25,  17,  48,  80,  62,  95, 142, 103,
	 65, 136,  84,  49, 119,  77,  31,  88,  42,  32,  64,  46,  44,  56,  28,  44,
	 48,  47,  44,  48,  47,  30,  48,  39,  30,  48,  39,  44,  56,  49,  32,  56,
	 45,  20,  64,  45,  32,  64,  46,  68,  56,  26,  92,  62,  44,  77,  57,  27,
	 30,  48,  26,  20,  40,  27,  48,  72,  31,  48,  72,  31,  30,  48,  26,  20,
	 40,  36,  32,  56,  45,  29,  56,  33,  11,  48,  24,  44,  41,  48,  30,  48,
	 39,  29,  56,  33,  32,  56,  45,  44,  64,  50,  55,  55,  31,  48,  72,  31,
	 48,  72,  31,  11,  56,  28,  20,  64,  32,  48,  72,  31,  48,  72,  31,  30,
	 64,  34,  11,  56,  28,  29,  56,  33,  30,  64,  34,  20,  72,  45,  34,  88,
	 53,  46,  96,  49,  60,  80,  38,  44,  65,  31,  30,  48,  26,  44,  56,  28,
	 30,  64,  34,  48,  72,  31,  29,  72,  35,  29,  72,  35,  29,  72,  35,  31,
	 72,  45,  32,  56,  45,  32,  64,  46,  32,  56,  45,  30,  64,  34,  20,  64,
	 32,  20,  64,  32,  31,  72,  45,  29,  56,  33,  20,  48,  27,  30,  48,  39,
	 11,  48,  24,  20,  55,  46,  31,  72,  45,  20,  64,  32,  29,  72,  35,  32,
	 64,  46,  20,  40,  27,  20,  40,  36,  11,  40,  24,  20,  56,  32,  29,  72,
	 35,  29,  72,  35,  20,  64,  32,  20,  64,  32,  20,  56,  32,  11,  48,  24,
	 30,  48,  39,  11,  48,  24,  32,  80,  46,  20,  88,  38,  19,  95,  39,  20,
	 88,  38,  34,  88,  53,  11,  56,  28,  30,  48,  39,  20,  48,  27,  31,  72,
	 45,  20,  56,  32,  30,  48,  39,  38,  33,  34,  12,  33,  29,  11,  48,  24,
	 11,  33,  18,  11,  33,  18,  11,  33,  18,  11,  40,  24,  20,  48,  27,  30,
	 48,  26,  20,  48,  27,  11,  40,  24,  20,  48,  27,  20,  56,  32,  20,  48,
	 36,  11,  40,  24,  11,  40,  24,  11,  48,  24,  20,  40,  27,  20,  48,  27,
	 20,  48,  36,  30,  40,  38,  44,  48,  47,  52,  40,  47,  38,  33,  34,  68,
	 54,  60,  68,  65,  70,  44,  41,  48,  44,  48,  47,  21,  25,  22,  32,  64,
	 46,  73, 120,  87,  49, 119,  77,  46, 112,  58,  60, 129,  79,  65, 136,  84,
	 60, 120,  78,  32,  64,  46,  44,  48,  47,  44,  56,  49,  97, 136, 103,  96,
	166, 116,  66, 143,  88,  49, 119,  77,  33, 104,  49,  32,  80,  46,  30,  48,
	 39,  21,  32,  19,  11,  40,  24,  11,  48,  24,  11,  33,  18,  11,  40,  24,
	 20,  48,  27,  11,  33,  18,  52,  46,  19,  76,  66,  44,  44,  56,  49,  20,
	 48,  27,  44,  48,  20,  56,  65,  29,  71,  47,  23,  71,  71,  25,  29,  40,
	 26,  11,  33,  18,  29,  56,  33,  11,  48,  24,  10,  25,  17,  20,  40,  27,
	 21,  32,  19,  21,  32,  19,  52,  46,  19,  55,  55,  31,  44,  48,  20,  30,
	 48,  39,  44,  48,  20,  56,  57,  18,  71,  47,  23,  56,  65,  29,  30,  64,
	 34,  30,  64,  34,  20,  56,  32,  30,  64,  34,  20,  64,  32,  35, 104,  60,
	 20, 104,  44,  19,  95,  39,  33,  96,  54,  30,  80,  35,  30,  64,  34,  46,
	 80,  45,  48,  96,  63,  48,  72,  31,  46,  80,  45,  60,  80,  38,  30,  80,
	 35,  46,  80,  45,  31,  72,  45,  32,  56,  45,  32,  56,  45,  20,  64,  45,
	 32,  64,  46,  20,  64,  32,  20,  64,  32,  31,  72,  45,  20,  56,  32,  20,
	 40,  27,  20,  40,  27,  20,  48,  36,  20,  56,  32,  30,  64,  34,  20,  64,
	 32,  29,  72,  35,  32,  64,  46,  11,  40,  24,  20,  40,  36,  20,  48,  36,
	 29,  56,  33,  20,  64,  32,  19,  71,  34,  29,  72,  35,  29,  72,  35,  29,
	 56,  33,  11,  40,  24,  44,  48,  47,  20,  56,  32,  32,  80,  46,  20,  88,
	 38,  19,  95,  39,  32,  80,  46,  34,  88,  53,  11,  56,  28,  30,  40,  38,
	 20,  48,  27,  20,  64,  45,  20,  56,  32,  30,  40,  38,  30,  48,  39,  32,
	 64,  46,  48,  96,  63,  46, 112,  58,  35, 112,  61,  33, 112,  50,  46, 112,
	 58,  46, 120,  63,  35, 112,  61,  35, 112,  61,  33, 104,  49,  35, 112,  61,
	 36, 120,  69,  47, 112,  69,  35, 112,  61,  33, 104,  49,  35, 104,  60,  35,
	112,  61,  47, 112,  69,  60, 120,  78,  20,  72,  45,  11,  40,  24,  30,  40,
	 38,  44,  41,  48,  30,  40,  38,  30,  40,  38,  30,  48,  39,  44,  41,  48,
	 30,  40,  38,  48,  80,  62,  73, 128,  87,  46, 104,  55,  19,  95,  39,  46,
	120,  63,  60, 129,  79,  73, 128,  87,  60,  88,  68,  72,  80,  76,  60,  80,
	 67,  73, 120,  87,  51, 128,  77,  33, 112,  50,  33, 112,  50,  46, 112,  58,
	 31,  72,  45,  21,  32,  19,  20,  40,  27,  31,  72,  45,  46,  96,  49,  46,
	 96,  49,  46,  80,  45,  20,  81,  44,  48,  72,  31,  56,  65,  29,  56,  65,
	 29,  56,  57,  18,  44,  56,  28,  89,  73,  22, 113,  89,  36, 100,  86,  44,
	 68,  56,  26,  60,  72,  31,  47,  88,  47,  20,  72,  45,  32,  64,  46,  31,
	 72,  45,  29,  56,  33,  20,  72,  45,  20,  56,  32,  29,  56,  33,  30,  64,
	 34,  30,  64,  34,  30,  64,  34,  48,  72,  31,  48,  72,  31,  48,  72,  31,
	 48,  72,  31,  47,  88,  47,  19,  95,  39,  33,  96,  54,  20, 104,  44,  35,
	104,  60,  35, 112,  61,  20, 104,  44,  20, 111,  48,  33, 104,  49,  31,  88,
	 42,  31,  72,  45,  46,  80,  45,  47,  88,  47,  30,  64,  34,  46,  80,  45,
	 46,  80,  45,  46,  80,  45,  30,  80,  35,  29,  72,  35,  30,  64,  34,  20,
	 56,  32,  29,  56,  33,  30,  64,  34,  20,  56,  32,  20,  64,  32,  30,  64,
	 34,  20,  56,  32,  20,  40,  27,  20,  40,  27,  20,  48,  36,  20,  56,  32,
	 29,  72,  35,  11,  64,  29,  30,  64,  34,  30,  64,  34,  20,  40,  27,  22,
	 33,  29,  32,  56,  45,  32,  56,  45,  20,  64,  32,  20,  64,  32,  29,  72,
	 35,  30,  64,  34,  20,  56,  32,  11,  40,  24,  32,  56,  45,  20,  48,  36,
	 32,  80,  46,  31,  88,  42,  31,  96,  43,  31,  88,  42,  34,  88,  53,  11,
	 48,  24,  30,  40,  38,  20,  48,  36,  29,  72,  35,  11,  48,  24,  12,  33,
	 29,  30,  40,  38,  32,  80,  46,  49, 119,  77,  36, 128,  63,  28, 127,  58,
	 36, 128,  63,  34, 135,  65,  34, 135,  65,  34, 135,  65,  28, 127,  58,  28,
	127,  58,  34, 135,  65,  34, 135,  65,  47, 135,  70,  34, 135,  65,  36, 120,
	 56,  36, 128,  63,  36, 120,  56,  36, 128,  63,  60, 129,  79,  47, 112,  69,
	 20,  64,  45,  20,  40,  36,  20,  40,  36,  30,  48,  39,  44,  48,  47,  32,
	 56,  45,   9,  16,  12,  32,  56,  45,  72, 112,  82,  88, 128,  95,  33, 104,
	 49,  20,  88,  38,  33, 104,  49,  35, 104,  60,  20,  81,  44,  11,  56,  28,
	 32,  56,  45,  32,  56,  45,  48,  96,  63,  20, 104,  44,  20, 104,  44,  46,
	112,  58,  33, 112,  50,  29,  72,  35,  20,  40,  27,  30,  48,  39,  30,  80,
	 35,  33, 104,  49,  46, 112,  58,  46,  96,  49,  10,  80,  48,  34,  88,  53,
	 60,  80,  38,  56,  57,  18,  56,  57,  18,  71,  71,  25,  89,  73,  22, 116,
	 74,   4,  89,  73,  22,  71,  71,  25,  48,  72,  31,  30,  80,  35,  31,  88,
	 42,  20,  88,  38,  32,  80,  46,  20,  64,  32,  10,  80,  48,  11,  64,  29,
	 29,  72,  35,  48,  72,  31,  29,  72,  35,  46,  80,  45,  60,  87,  43,  72,
	 88,  39,  48,  72,  31,  60,  96,  47,  60, 112,  53,  46, 104,  55,  33, 112,
	 50,  20, 104,  44,  35, 112,  61,  31,  88,  42,  31,  96,  43,  46,  96,  49,
	 46,  96,  49,  60,  80,  38,  56,  65,  29,  44,  56,  28,  55,  55,  31,  29,
	 72,  35,  48,  72,  31,  48,  72,  31,  30,  80,  35,  48,  72,  31,  29,  72,
	 35,  20,  56,  32,  20,  55,  46,  29,  56,  33,  20,  56,  32,  20,  56,  32,
	 11,  56,  28,  31,  72,  45,  29,  56,  33,  20,  40,  27,  30,  48,  39,  20,
	 48,  36,  20,  56,  32,  30,  64,  34,  20,  56,  32,  20,  64,  32,  32,  56,
	 45,  11,  40,  24,  20,  40,  36,  32,  56,  45,  29,  56,  33,  20,  56,  32,
	 20,  64,  32,  20,  64,  32,  20,  64,  32,  32,  56,  45,  11,  48,  24,  44,
	 48,  47,  11,  48,  24,  30,  80,  35,  10,  87,  42,  31,  96,  43,  31,  96,
	 43,  48,  96,  63,  20,  56,  32,  30,  40,  38,  20,  55,  46,  31,  72,  45,
	 20,  56,  32,  11,  33,  18,  20,  48,  27,  20,  64,  32,  33, 112,  50,  46,
	120,  63,  36, 120,  69,  27, 120,  53,  36, 128,  63,  46, 127,  65,  34, 135,
	 65,  36, 128,  63,  28, 127,  58,  36, 128,  63,  46, 127,  65,  47, 135,  70,
	 46, 127,  65,  27, 120,  53,  33, 112,  50,  33, 112,  50,  33, 112,  50,  35,
	104,  60,  73, 120,  87,  60,  96,  67,  20,  48,  36,  22,  33,  29,  23,  16,
	 16,   9,  16,  12,  21,  25,  22,  20,  55,  46,  72, 112,  82,  95, 152, 108,
	 65, 136,  84,  33, 104,  49,  33, 112,  50,  46, 120,  63,  19,  95,  39,  33,
	 96,  54,  11,  48,  24,  20,  40,  36,  20,  56,  32,  46, 104,  55,  33, 112,
	 50,  20, 104,  44,  33, 104,  49,  33, 104,  49,  20,  64,  32,  30,  48,  39,
	 29,  56,  33,  19,  71,  34,  33, 104,  49,  33, 112,  50,  12,  80,  32,  10,
	 87,  42,  46,  96,  49,  71,  71,  25,  71,  71,  25,  90,  88,  32, 112, 106,
	 56, 113,  89,  36, 124,  90,  28, 124,  90,  28, 112, 106,  56,  84, 106,  52,
	 30,  80,  35,  12,  80,  32,  20,  81,  44,  20,  80,  34,  20,  64,  32,  11,
	 56,  28,  29,  56,  33,  56,  65,  29,  71,  80,  27,  56,  65,  29,  48,  72,
	 31,  71,  80,  39,  71,  80,  27,  60,  80,  38,  71,  80,  27,  60,  87,  43,
	 60,  96,  47,  33,  96,  54,  33,  96,  54,  33,  96,  54,  46, 104,  55,  31,
	 96,  43,  31,  96,  43,  46,  80,  45,  56,  65,  29,  44,  56,  28,  44,  56,
	 49,  44,  64,  50,  31,  72,  45,  46,  80,  45,  29,  72,  35,  48,  72,  31,
	 30,  80,  35,  30,  64,  34,  30,  64,  34,  30,  64,  34,  29,  56,  33,  20,
	 56,  32,  20,  56,  32,  20,  64,  32,  30,  64,  34,  29,  56,  33,  20,  40,
	 36,  30,  48,  39,  20,  48,  36,  20,  56,  32,  30,  64,  34,  11,  56,  28,
	 20,  56,  32,  30,  64,  34,  21,  32,  19,  22,  33,  29,  20,  48,  36,  29,
	 56,  33,  20,  64,  32,  20,  56,  32,  20,  64,  32,  20,  56,  32,  20,  48,
	 36,  20,  40,  36,  30,  48,  39,  11,  48,  24,  32,  80,  46,  31,  88,  42,
	 31,  96,  43,  31,  96,  43,  34,  88,  53,  11,  56,  28,  30,  40,  38,  20,
	 48,  36,  31,  72,  45,  20,  56,  32,  20,  40,  36,  29,  56,  33,  19,  71,
	 34,  33, 112,  50,  46, 127,  65,  46, 120,  63,  46, 120,  63,  46, 120,  63,
	 47, 135,  70,  65, 136,  84,  46, 127,  65,  46, 120,  63,  36, 120,  56,  47,
	135,  70,  47, 135,  70,  46, 127,  65,  36, 120,  56,  33, 112,  50,  36, 120,
	 56,  33, 112,  50,  46, 127,  65,  65, 136,  84,  73, 128,  87,  85, 122,  83,
	 73, 104,  81,  49,  71,  62,  46,  72,  47,  73, 104,  81,  81, 143,  95,  95,
	152, 108,  83, 153, 103,  46, 120,  63,  20, 104,  44,  36, 120,  56,  36, 128,
	 63,  27, 120,  53,  47, 112,  69,  20,  56,  32,  20,  40,  27,  20,  48,  27,
	 47, 112,  69,  27, 120,  53,  20, 104,  44,  31,  96,  43,  46, 112,  58,  30,
	 64,  34,  11,  33,  18,  20,  48,  27,  31,  88,  42,  36, 120,  56,  33, 112,
	 50,  19,  95,  39,  20, 104,  44,  60,  87,  43,  60,  72,  31,  90,  88,  32,
	124, 129, 111, 140, 138, 116, 140, 138, 116, 164, 146, 116, 164, 134, 100, 124,
	110,  76, 116, 122,  84,  87, 113,  79,  30,  64,  34,  19,  71,  34,  32,  80,
	 46,  11,  48,  24,  29,  56,  33,  44,  56,  28,  71,  71,  25,  71,  71,  25,
	 44,  56,  28,  44,  65,  31,  29,  72,  35,  48,  72,  31,  48,  72,  31,  60,
	 80,  38,  60,  72,  31,  60,  87,  43,  46,  96,  49,  33,  96,  54,  33, 104,
	 49,  33, 104,  49,  33, 104,  49,  31,  96,  43,  31,  88,  42,  31,  72,  45,
	 30,  64,  34,  30,  64,  34,  29,  72,  35,  32,  80,  46,  47,  88,  47,  48,
	 72,  31,  29,  72,  35,  48,  72,  31,  30,  64,  34,  29,  56,  33,  32,  64,
	 46,  32,  56,  45,  29,  56,  33,  20,  56,  32,  11,  56,  28,  32,  64,  46,
	 29,  56,  33,  20,  40,  27,  29,  40,  26,  30,  48,  39,  20,  48,  27,  30,
	 64,  34,  11,  56,  28,  20,  56,  32,  29,  56,  33,  12,  33,  29,  29,  40,
	 26,  20,  40,  36,  20,  48,  36,  29,  56,  33,  20,  64,  32,  11,  56,  28,
	 20,  56,  32,  30,  48,  39,  20,  40,  36,  32,  56,  45,  20,  56,  32,  32,
	 80,  46,  20,  88,  38,  31,  96,  43,  31,  88,  42,  34,  88,  53,  11,  48,
	 24,  30,  40,  38,  11,  48,  24,  32,  64,  46,  20,  56,  32,  29,  40,  26,
	 32,  56,  45,  30,  80,  35,  36, 120,  56,  28, 127,  58,  27, 120,  53,  27,
	120,  53,  27, 120,  53,  36, 128,  63,  47, 135,  70,  36, 128,  63,  36, 120,
	 56,  28, 127,  58,  36, 128,  63,  47, 135,  70,  36, 128,  63,  36, 128,  63,
	 36, 120,  56,  36, 128,  63,  36, 128,  63,  20, 104,  44,  20, 111,  48,  36,
	120,  56,  51, 128,  77,  65, 136,  84,  66, 143,  88,  66, 143,  88,  83, 153,
	103,  95, 152, 108,  65, 136,  84,  46, 112,  58,  33, 112,  50,  33, 112,  50,
	 33, 112,  50,  36, 120,  56,  46, 127,  65,  47,  88,  47,  11,  40,  24,  20,
	 40,  27,  20,  48,  27,  33, 104,  49,  33, 112,  50,  31,  96,  43,  33, 104,
	 49,  31,  96,  43,  32,  64,  46,  22,  33,  29,  11,  40,  24,  30,  80,  35,
	 33, 112,  50,  20, 104,  44,  33, 104,  49,  33, 104,  49,  48,  72,  31,  68,
	 64,  28, 108,  98,  76, 127, 129, 125, 115, 128, 119, 112, 119, 110, 127, 129,
	125, 148, 126, 108, 108,  98,  76, 112, 104,  84, 116, 122,  84,  72,  96,  77,
	 46,  72,  47,  30,  64,  34,  30,  64,  34,  32,  64,  46,  30,  64,  34,  71,
	 80,  27,  48,  72,  31,  44,  65,  31,  20,  80,  34,  31,  96,  43,  20, 104,
	 44,  31,  96,  43,  31,  88,  42,  60,  80,  38,  46,  96,  49,  33, 104,  49,
	 20, 111,  48,  35, 112,  61,  20,  81,  44,  20,  81,  44,  32,  80,  46,  30,
	 80,  35,  48,  72,  31,  44,  64,  50,  29,  72,  35,  20,  64,  32,  32,  80,
	 46,  32,  80,  46,  29,  72,  35,  29,  72,  35,  48,  72,  31,  44,  56,  28,
	 20,  48,  27,  32,  56,  45,  29,  56,  33,  29,  56,  33,  20,  56,  32,  20,
	 56,  32,  30,  64,  34,  20,  48,  27,  20,  40,  27,  30,  40,  38,  20,  48,
	 27,  20,  56,  32,  29,  56,  33,  11,  48,  24,  20,  56,  32,  29,  56,  33,
	 20,  40,  27,  22,  33,  29,  20,  40,  36,  20,  48,  36,  20,  56,  32,  20,
	 56,  32,  20,  56,  32,  29,  56,  33,  20,  48,  27,  20,  40,  36,  44,  48,
	 47,  20,  48,  36,  34,  88,  53,  31,  88,  42,  19,  95,  39,  20,  88,  38,
	 34,  88,  53,  11,  48,  24,  20,  40,  27,  20,  56,  32,  20,  64,  32,  20,
	 48,  27,  21,  32,  19,  30,  48,  39,  19,  71,  34,  35, 112,  61,  28, 127,
	 58,  28, 127,  58,  27, 120,  53,  27, 120,  53,  35, 112,  61,  35, 112,  61,
	 35, 104,  60,  46, 104,  55,  35, 104,  60,  35, 112,  61,  46, 120,  63,  35,
	112,  61,  47, 112,  69,  47, 112,  69,  47, 112,  69,  47, 112,  69,  33, 104,
	 49,  47, 112,  69,  35, 104,  60,  33,  96,  54,  49, 104,  69,  60, 129,  79,
	 65, 136,  84,  47, 112,  69,  49, 104,  69,  48,  96,  63,  34,  88,  53,  49,
	104,  69,  49, 104,  69,  49, 104,  69,  46,  96,  49,  47, 112,  69,  48,  96,
	 63,  32,  64,  46,  44,  56,  49,  20,  56,  32,  46, 104,  55,  20, 104,  44,
	 19,  95,  39,  31,  88,  42,  31,  88,  42,  60,  96,  67,  55,  64,  59,  44,
	 56,  49,  48,  96,  63,  31,  96,  43,  20,  88,  38,  46, 104,  55,  31,  96,
	 43,  29,  72,  35,  71,  71,  25, 100,  92,  88,  86,  93,  88,  72,  80,  76,
	 49,  71,  62,  55,  64,  59,  86,  81,  76,  86,  93,  88,  72,  80,  76,  86,
	 81,  76, 112, 119, 110,  88,  98,  92,  31,  72,  45,  47,  88,  62,  20,  72,
	 45,  31,  72,  45,  60,  80,  38,  60,  72,  31,  48,  72,  31,  30,  80,  35,
	 33,  96,  54,  33,  96,  54,  20,  88,  38,  46,  80,  45,  48,  72,  31,  60,
	 87,  43,  34,  88,  53,  20,  88,  53,  10,  80,  48,  32,  56,  45,  30,  64,
	 34,  29,  56,  33,  30,  48,  39,  44,  48,  20,  52,  46,  19,  29,  56,  33,
	 20,  55,  46,  11,  56,  28,  11,  64,  29,  11,  56,  28,  29,  56,  33,  30,
	 64,  34,  30,  48,  26,  20,  40,  27,  30,  48,  39,  30,  48,  26,  29,  56,
	 33,  11,  48,  24,  11,  56,  28,  29,  56,  33,  20,  56,  32,  29,  40,  26,
	 30,  40,  38,  20,  48,  36,  30,  48,  26,  20,  64,  32,  11,  48,  24,  20,
	 56,  32,  29,  56,  33,  21,  32,  19,  22,  33,  29,  20,  40,  36,  20,  48,
	 27,  20,  56,  32,  20,  56,  32,  20,  64,  32,  30,  64,  34,  29,  56,  33,
	 20,  40,  36,  20,  48,  36,  20,  48,  27,  34,  88,  53,  31,  88,  42,  19,
	 95,  39,  30,  80,  35,  34,  88,  53,  11,  48,  24,  20,  40,  27,  11,  48,
	 24,  29,  72,  35,  29,  56,  33,  21,  32,  19,  30,  48,  39,  31,  72,  45,
	 33, 112,  50,  46, 120,  63,  46, 120,  63,  46, 112,  58,  46, 104,  55,  32,
	 80,  46,  30,  64,  34,  30,  64,  34,  32,  64,  46,  32,  64,  46,  31,  72,
	 45,  32,  64,  46,  32,  64,  46,  30,  64,  34,  31,  72,  45,  44,  64,  50,
	 32,  64,  46,  60,  80,  67,  30,  48,  39,  30,  48,  39,  32,  56,  45,  32,
	 56,  45,  32,  64,  46,  31,  72,  45,  31,  72,  45,  11,  48,  24,  31,  72,
	 45,  31,  72,  45,  20,  48,  36,  20,  55,  46,  32,  64,  46,  32,  64,  46,
	 32,  64,  46,  32,  80,  46,  30,  48,  39,  30,  48,  39,  11,  40,  24,  31,
	 96,  43,  33, 112,  50,  31,  96,  43,  31,  88,  42,  60, 112,  73, 100, 129,
	107,  86,  93,  88,  87, 105,  93,  95, 142, 103,  81, 135,  95,  31,  96,  43,
	 46, 104,  55,  33, 112,  50,  30,  80,  35,  60,  72,  31,  76,  66,  44,  54,
	 56,  58,  44,  48,  47,  44,  48,  47,  44,  41,  48,  20,  55,  46,  32,  56,
	 45,  54,  49,  50,  52,  40,  47,  68,  66,  52,  86,  93,  88,  60,  88,  68,
	 11,  64,  29,  20,  64,  45,  44,  65,  31,  68,  64,  28,  79,  64,  30,  56,
	 57,  18,  55,  64,  59,  44,  56,  49,  20,  48,  27,  11,  56,  28,  44,  56,
	 28,  68,  56,  26,  68,  56,  26,  44,  65,  31,  20,  55,  46,  20,  56,  32,
	 11,  48,  24,  11,  48,  24,  11,  48,  24,  29,  56,  33,  29,  56,  33,  44,
	 48,  20,  29,  40,  26,  52,  46,  19,  30,  48,  26,  29,  56,  33,  29,  56,
	 33,  44,  56,  28,  29,  56,  33,  11,  40,  24,  11,  33,  18,  20,  40,  27,
	 11,  48,  24,  30,  64,  34,  11,  64,  29,  29,  72,  35,  20,  56,  32,  29,
	 56,  33,  20,  40,  27,  30,  48,  39,  30,  48,  39,  29,  56,  33,  20,  56,
	 32,  20,  56,  32,  20,  56,  32,  20,  48,  27,  20,  40,  27,  22,  33,  29,
	 30,  48,  39,  20,  48,  27,  30,  64,  34,  20,  64,  32,  20,  64,  32,  30,
	 64,  34,  11,  40,  24,  20,  40,  27,  30,  48,  39,  20,  56,  32,  34,  88,
	 53,  31,  88,  42,  33, 104,  49,  31,  96,  43,  32,  80,  46,  11,  56,  28,
	 30,  48,  26,  20,  48,  27,  31,  72,  45,  20,  48,  27,  30,  40,  38,  20,
	 40,  36,  32,  80,  46,  46, 127,  65,  44, 142,  72,  28, 127,  58,  36, 120,
	 56,  46,  96,  49,  30,  48,  39,  21,  25,  22,  12,  33,  29,  11,  48,  24,
	 10,  25,  17,  21,  25,  22,  22,  33,  29,  22,  33,  29,  30,  40,  38,  21,
	 25,  22,  10,  25,  17,  21,  32,  19,  12,  33,  29,  12,  33,  29,  12,  33,
	 29,  10,  25,  17,  12,  33,  29,  12,  33,  29,  22,  33,  29,  12,  33,  29,
	 11,  40,  24,  22,  33,  29,  12,  33,  29,  21,  25,  22,  10,  25,  17,  22,
	 33,  29,  12,  33,  29,  22,  33,  29,  22,  33,  29,  23,  16,  16,  10,  25,
	 17,  20,  64,  32,  46, 120,  63,  20, 104,  44,  10,  87,  42,  47, 112,  69,
	127, 129, 125, 127, 129, 125, 108, 105, 104,  86,  93,  88, 127, 137, 126, 129,
	149, 131,  87, 113,  96,  86, 104,  81,  47,  88,  47,  46,  96,  49,  32,  80,
	 46,  30,  48,  39,  52,  40,  47,  52,  40,  47,  30,  40,  38,  29,  40,  26,
	 20,  40,  27,  38,  33,  34,  41,  25,  31,  10,  25,  17,  11,  33,  18,  11,
	 33,  18,  11,  33,  18,  12,  33,  29,  12,  33,  29,  21,  32,  19,  37,  33,
	 13,  52,  50,  20,  52,  50,  20,  44,  42,  26,  37,  33,  13,  37,  33,  13,
	 44,  48,  20,  44,  48,  20,  44,  56,  28,  30,  48,  26,  11,  48,  24,  11,
	 48,  24,  11,  48,  24,  34,  88,  53,  47,  88,  47,  30,  80,  35,  29,  72,
	 35,  30,  64,  34,  44,  56,  28,  29,  40,  26,  30,  48,  26,  44,  56,  28,
	 30,  64,  34,  30,  64,  34,  30,  64,  34,  30,  64,  34,  20,  56,  32,  11,
	 40,  24,  32,  56,  45,  20,  64,  32,  29,  72,  35,  20,  64,  32,  30,  64,
	 34,  20,  64,  32,  30,  64,  34,  22,  33,  29,  30,  40,  38,  20,  48,  36,
	 32,  64,  46,  20,  64,  32,  20,  56,  32,  30,  64,  34,  20,  56,  32,  20,
	 40,  27,  12,  33,  29,  30,  48,  39,  20,  48,  27,  30,  64,  34,  20,  56,
	 32,  20,  56,  32,  32,  64,  46,  11,  40,  24,  20,  40,  27,  20,  48,  36,
	 20,  48,  27,  30,  80,  35,  20,  88,  38,  33, 104,  49,  31,  88,  42,  34,
	 88,  53,  11,  48,  24,  30,  40,  38,  20,  48,  36,  31,  72,  45,  20,  48,
	 27,  30,  40,  38,  20,  40,  27,  30,  80,  35,  46, 127,  65,  47, 135,  70,
	 36, 120,  56,  36, 120,  56,  33,  96,  54,  30,  40,  38,  22,  33,  29,  29,
	 56,  33,  20,  80,  34,  46, 112,  58,  46, 112,  58,  33, 112,  50,  35, 104,
	 60,  35, 104,  60,  33,  96,  54,  31,  96,  43,  46, 112,  58,  33, 104,  49,
	 33, 104,  49,  31,  96,  43,  33, 104,  49,  33,  96,  54,  31,  96,  43,  33,
	 96,  54,  31,  96,  43,  31,  96,  43,  33,  96,  54,  33, 104,  49,  46, 104,
	 55,  33,  96,  54,  31,  88,  42,  31,  88,  42,  20,  88,  53,  34,  88,  53,
	 31,  88,  42,  31,  96,  43,  33,  96,  54,  31,  88,  42,  34,  88,  53,  73,
	104,  81, 112, 119, 110,  86,  93,  88,  84,  86,  87,  70,  73,  73,  70,  73,
	 73, 100, 104, 101, 110, 113, 105,  72,  96,  77,  87, 113,  96,  48,  96,  63,
	 33,  96,  54,  20,  81,  44,  20,  48,  36,  21,  25,  22,  21,  25,  22,  22,
	 33,  29,  20,  40,  36,  12,  33,  29,  41,  25,  31,  23,  16,  16,  11,  40,
	 24,  20,  64,  45,  46,  72,  47,  44,  56,  49,  32,  64,  46,  20,  56,  32,
	 29,  56,  33,  44,  56,  28,  55,  55,  31,  44,  56,  28,  44,  65,  31,  52,
	 50,  20,  52,  50,  20,  56,  65,  29,  44,  56,  28,  44,  65,  31,  29,  72,
	 35,  20,  88,  53,  31,  88,  42,  32,  80,  46,  46,  96,  49,  33,  96,  54,
	 34,  88,  53,  30,  80,  35,  46,  80,  45,  30,  64,  34,  29,  56,  33,  44,
	 56,  28,  30,  64,  34,  48,  72,  31,  30,  80,  35,  31,  72,  45,  30,  80,
	 35,  20,  64,  32,  20,  56,  32,  20,  55,  46,  32,  64,  46,  32,  80,  46,
	 20,  64,  32,  19,  71,  34,  30,  64,  34,  30,  64,  34,  20,  40,  27,  22,
	 33,  29,  20,  48,  27,  32,  64,  46,  29,  72,  35,  19,  71,  34,  29,  72,
	 35,  30,  64,  34,  20,  40,  27,  20,  40,  27,  20,  48,  36,  20,  48,  27,
	 29,  56,  33,  11,  56,  28,  20,  56,  32,  30,  64,  34,  11,  40,  24,  20,
	 40,  27,  20,  40,  36,  20,  48,  27,  32,  80,  46,  20,  88,  38,  31,  96,
	 43,  31,  96,  43,  30,  80,  35,  11,  56,  28,  29,  40,  26,  11,  40,  24,
	 31,  72,  45,  20,  40,  27,  20,  40,  36,  20,  40,  27,  32,  80,  46,  36,
	128,  63,  47, 135,  70,  27, 120,  53,  46, 127,  65,  33,  96,  54,  20,  40,
	 27,  12,  33,  29,  32,  80,  46,  47, 112,  69,  20, 111,  48,  28, 127,  58,
	 34, 135,  65,  34, 135,  65,  27, 120,  53,  27, 120,  53,  35, 112,  61,  46,
	120,  63,  33, 112,  50,  33, 112,  50,  33, 112,  50,  33, 104,  49,  33, 112,
	 50,  33, 104,  49,  33, 104,  49,  31,  96,  43,  27, 120,  53,  36, 120,  56,
	 33, 112,  50,  33, 112,  50,  46, 112,  58,  33, 112,  50,  46, 112,  58,  46,
	120,  63,  35, 112,  61,  20,  96,  54,  35, 104,  60,  46, 104,  55,  31,  88,
	 42,  73, 104,  81, 110, 113, 105, 104,  80,  72,  60,  72,  66,  54,  56,  58,
	 68,  65,  70,  68,  65,  70,  60,  72,  66,  70,  73,  73,  60,  72,  66,  72,
	 96,  77,  49, 119,  77,  60, 120,  78,  48,  96,  63,  20,  55,  46,  10,  25,
	 17,   7,   9,   9,  23,  16,  16,  20,  40,  36,  10,  25,  17,  23,  16,  16,
	 23,  16,  16,  20,  55,  46,  48,  96,  63,  48,  96,  63,  31,  72,  45,  19,
	 71,  34,  20,  72,  45,  29,  72,  35,  44,  65,  31,  30,  64,  34,  30,  64,
	 34,  44,  65,  31,  48,  72,  31,  60,  72,  31,  60,  72,  31,  60,  80,  38,
	 48,  72,  31,  46,  96,  49,  46, 104,  55,  35, 112,  61,  35, 104,  60,  31,
	 96,  43,  31,  96,  43,  31,  88,  42,  20,  88,  38,  20,  88,  38,  29,  72,
	 35,  20,  56,  32,  32,  64,  46,  48,  72,  31,  30,  80,  35,  30,  80,  35,
	 30,  80,  35,  32,  80,  46,  20,  64,  32,  11,  56,  28,  32,  64,  46,  20,
	 64,  32,  30,  80,  35,  20,  64,  32,  30,  80,  35,  29,  72,  35,  32,  64,
	 46,  20,  40,  27,  30,  40,  38,  11,  56,  28,  29,  72,  35,  30,  80,  35,
	 19,  71,  34,  30,  80,  35,  20,  64,  32,  20,  48,  27,  20,  40,  27,  30,
	 48,  39,  20,  48,  27,  30,  64,  34,  20,  64,  32,  20,  56,  32,  30,  64,
	 34,  20,  48,  27,  20,  40,  27,  30,  48,  39,  20,  56,  32,  30,  80,  35,
	 20,  80,  34,  31,  96,  43,  31,  96,  43,  34,  88,  53,  20,  56,  32,  20,
	 40,  36,  20,  48,  27,  32,  64,  46,  11,  48,  24,  30,  40,  38,  20,  40,
	 27,  30,  80,  35,  46, 127,  65,  46, 127,  65,  36, 120,  56,  36, 120,  56,
	 46,  96,  49,  11,  40,  24,  12,  33,  29,  32,  80,  46,  49, 119,  77,  32,
	 80,  46,  31,  88,  42,  47,  88,  62,  34,  88,  53,  32,  80,  46,  31,  72,
	 45,  31,  72,  45,  32,  64,  46,  48,  80,  62,  48,  80,  62,  48,  80,  62,
	 48,  80,  62,  48,  80,  62,  48,  80,  62,  48,  80,  62,  48,  80,  62,  34,
	 88,  53,  32,  80,  46,  48,  80,  62,  49,  71,  62,  48,  80,  62,  48,  80,
	 62,  48,  80,  62,  48,  80,  62,  48,  80,  62,  31,  72,  45,  31,  72,  45,
	 31,  72,  45,  48,  96,  63,  73, 120,  87, 100, 113, 101,  70,  73,  73,  49,
	 71,  62,  44,  48,  47,  54,  56,  58,  55,  64,  59,  54,  56,  58,  55,  64,
	 59,  44,  56,  49,  55,  64,  59,  65, 136,  84,  73, 120,  87,  72, 112,  82,
	 48,  96,  63,  20,  48,  36,  23,  16,  16,  21,  25,  22,  10,  25,  17,  10,
	 25,  17,  23,  16,  16,  29,  40,  26,  47,  88,  62,  47, 112,  69,  47,  88,
	 62,  20,  64,  32,  12,  80,  32,  19,  71,  34,  30,  80,  35,  29,  72,  35,
	 44,  56,  28,  29,  56,  33,  44,  65,  31,  60,  72,  31,  60,  72,  31,  48,
	 72,  31,  60,  80,  38,  70,  97,  49,  46,  96,  49,  33, 104,  49,  20, 104,
	 44,  20, 104,  44,  31,  96,  43,  33, 104,  49,  19,  95,  39,  33,  96,  54,
	 33,  96,  54,  20,  72,  45,  20,  56,  32,  29,  56,  33,  30,  80,  35,  46,
	 80,  45,  31,  88,  42,  31,  88,  42,  31,  88,  42,  20,  72,  45,  11,  56,
	 28,  20,  64,  45,  20,  64,  32,  31,  72,  45,  19,  71,  34,  30,  80,  35,
	 19,  71,  34,  30,  64,  34,  20,  40,  27,  30,  48,  39,  20,  56,  32,  30,
	 64,  34,  19,  71,  34,  20,  80,  34,  20,  80,  34,  20,  64,  32,  20,  48,
	 27,  20,  40,  27,  30,  48,  39,  20,  48,  36,  30,  64,  34,  20,  56,  32,
	 20,  64,  32,  30,  64,  34,  11,  40,  24,  20,  40,  27,  30,  48,  39,  20,
	 56,  32,  34,  88,  53,  20,  80,  34,  31,  96,  43,  31,  96,  43,  32,  80,
	 46,  11,  56,  28,  29,  40,  26,  11,  48,  24,  31,  72,  45,  20,  40,  36,
	 20,  40,  36,  20,  48,  36,  32,  80,  46,  46, 127,  65,  46, 120,  63,  27,
	120,  53,  36, 120,  56,  33,  96,  54,  11,  48,  24,  11,  40,  24,  32,  80,
	 46,  27, 120,  53,  32,  56,  45,  30,  40,  38,  20,  48,  36,  20,  40,  36,
	 12,  33,  29,  22,  33,  29,  30,  40,  38,  30,  40,  38,  12,  33,  29,  12,
	 33,  29,  12,  33,  29,  12,  33,  29,  20,  40,  36,  20,  40,  36,  22,  33,
	 29,  22,  33,  29,  12,  33,  29,  12,  33,  29,  22,  33,  29,  12,  33,  29,
	 20,  40,  36,  20,  40,  36,  12,  33,  29,  10,  25,  17,  10,  25,  17,  29,
	 40,  26,  10,  25,  17,  10,  25,  17,  11,  56,  28,  20,  64,  45,  20,  48,
	 36,  30,  40,  38,  44,  48,  47,  20,  40,  36,  54,  56,  58,  44,  48,  47,
	 44,  48,  47,  54,  56,  58,  44,  48,  47,  30,  48,  39,  49, 119,  77,  84,
	106,  52,  87, 113,  79,  85, 122,  83,  47,  88,  47,  68,  56,  26,  52,  34,
	 36,  21,  25,  22,  29,  40,  26,  54,  49,  50,  86,  72,  43,  60, 112,  73,
	 47, 112,  69,  20,  81,  44,  19,  71,  34,  19,  95,  39,  19,  71,  34,  30,
	 80,  35,  48,  72,  31,  48,  72,  31,  30,  64,  34,  56,  65,  29,  60,  72,
	 31,  68,  64,  28,  48,  72,  31,  48,  72,  31,  71,  80,  27,  47,  88,  47,
	 31,  96,  43,  33, 104,  49,  20, 111,  48,  31,  96,  43,  33, 104,  49,  33,
	104,  49,  33, 104,  49,  33,  96,  54,  30,  80,  35,  30,  64,  34,  29,  56,
	 33,  48,  72,  31,  60,  87,  43,  47,  88,  47,  31,  88,  42,  34,  88,  53,
	 31,  72,  45,  20,  56,  32,  20,  55,  46,  20,  64,  32,  32,  80,  46,  20,
	 80,  34,  30,  80,  35,  20,  64,  32,  20,  64,  32,  11,  40,  24,  30,  40,
	 38,  30,  48,  26,  29,  72,  35,  19,  71,  34,  19,  71,  34,  19,  71,  34,
	 20,  64,  32,  20,  48,  27,  20,  40,  27,  30,  48,  39,  20,  48,  27,  30,
	 64,  34,  20,  56,  32,  20,  56,  32,  30,  64,  34,  20,  40,  27,  11,  40,
	 24,  20,  40,  36,  29,  56,  33,  30,  80,  35,  20,  88,  38,  19,  95,  39,
	 31,  88,  42,  34,  88,  53,  11,  48,  24,  30,  40,  38,  20,  40,  27,  31,
	 72,  45,  20,  48,  27,  30,  40,  38,  20,  40,  27,  30,  80,  35,  46, 127,
	 65,  33, 112,  50,  33, 104,  49,  36, 120,  56,  33,  96,  54,  20,  48,  27,
	 11,  40,  24,  20,  81,  44,  35, 112,  61,  30,  48,  39,  11,  33,  18,  11,
	 48,  24,  30,  64,  34,  20,  64,  32,  29,  72,  35,  34,  88,  53,  31,  72,
	 45,  19,  71,  34,  20,  81,  44,  29,  72,  35,  20,  80,  34,  31,  72,  45,
	 29,  72,  35,  19,  71,  34,  20,  64,  32,  31,  72,  45,  31,  72,  45,  20,
	 64,  32,  20,  64,  32,  29,  72,  35,  32,  80,  46,  31,  88,  42,  20,  80,
	 34,  20,  72,  45,  46,  80,  45,  31,  72,  45,  20,  64,  45,  48,  80,  62,
	 32,  64,  46,  22,  33,  29,  38,  33,  34,  30,  48,  39,  30,  40,  38,  44,
	 41,  48,  30,  40,  38,  30,  40,  38,  30,  48,  39,  30,  48,  39,  30,  48,
	 39,  65, 136,  84,  72,  88,  39,  90,  88,  32,  60, 112,  53,  46, 104,  55,
	 88,  80,  39, 100,  70,  52,  55,  55,  31,  55,  55,  31,  86,  72,  43,  90,
	 88,  32,  46, 104,  55,  20,  88,  53,  11,  64,  29,  20,  64,  32,  31,  96,
	 43,  19,  71,  34,  30,  80,  35,  48,  72,  31,  56,  65,  29,  44,  65,  31,
	 44,  65,  31,  48,  72,  31,  71,  71,  25,  47,  88,  47,  60,  87,  43,  60,
	 80,  38,  60,  87,  43,  46,  96,  49,  46, 104,  55,  33, 104,  49,  31,  96,
	 43,  33,  96,  54,  20,  96,  54,  33,  96,  54,  33,  96,  54,  48,  72,  31,
	 29,  56,  33,  56,  57,  18,  60,  80,  38,  60,  87,  43,  47,  88,  47,  46,
	 96,  49,  46,  96,  49,  29,  72,  35,  20,  48,  27,  20,  48,  36,  29,  72,
	 35,  34,  88,  53,  20,  80,  34,  31,  88,  42,  19,  71,  34,  30,  64,  34,
	 11,  40,  24,  20,  40,  27,  20,  48,  27,  32,  64,  46,  29,  72,  35,  20,
	 80,  34,  20,  80,  34,  30,  64,  34,  20,  40,  27,  21,  32,  19,  20,  48,
	 27,  20,  48,  27,  30,  64,  34,  20,  64,  32,  20,  64,  32,  30,  64,  34,
	 11,  40,  24,  11,  33,  18,  20,  40,  36,  20,  56,  32,  34,  88,  53,  20,
	 80,  34,  31,  96,  43,  31,  96,  43,  31,  88,  42,  11,  48,  24,  20,  40,
	 27,  20,  48,  27,  31,  72,  45,  11,  40,  24,  30,  40,  38,  20,  40,  27,
	 32,  80,  46,  36, 120,  56,  36, 120,  56,  33, 112,  50,  36, 120,  56,  46,
	 96,  49,  11,  48,  24,  11,  40,  24,  32,  80,  46,  36, 120,  56,  20,  48,
	 27,  11,  33,  18,  19,  71,  34,  46, 120,  63,  46, 120,  63,  36, 128,  63,
	 46, 127,  65,  36, 128,  63,  46, 120,  63,  36, 120,  56,  33, 112,  50,  33,
	112,  50,  33, 112,  50,  33, 112,  50,  33, 104,  49,  33, 104,  49,  46, 104,
	 55,  46, 104,  55,  46,  96,  49,  31,  88,  42,  31,  96,  43,  33, 112,  50,
	 46, 127,  65,  46, 127,  65,  20, 111,  48,  35, 112,  61,  33, 104,  49,  35,
	104,  60,  35, 112,  61,  49, 104,  69,  32,  64,  46,  21,  25,  22,  38,  33,
	 34,  30,  40,  38,  44,  41,  48,  22,  33,  29,  22,  33,  29,  22,  33,  29,
	 20,  40,  36,  60,  88,  68,  66, 143,  88,  72,  88,  39,  71,  71,  25,  31,
	 96,  43,  31,  96,  43,  84,  78,  28, 104,  80,  72,  76,  66,  44,  55,  55,
	 31, 100,  86,  44, 100,  86,  44,  47,  88,  47,  12,  80,  32,  32,  64,  46,
	 30,  64,  34,  20,  80,  34,  30,  80,  35,  30,  80,  35,  48,  72,  31,  48,
	 72,  31,  30,  64,  34,  44,  56,  28,  48,  72,  31,  71,  80,  27,  46,  96,
	 49,  46,  96,  49,  60,  87,  43,  60,  87,  43,  46, 104,  55,  46, 104,  55,
	 33, 104,  49,  35, 104,  60,  35, 104,  60,  33, 104,  49,  31,  96,  43,  34,
	 88,  53,  48,  72,  31,  52,  50,  20,  52,  46,  19,  60,  80,  38,  60,  87,
	 43,  47,  88,  47,  46,  96,  49,  47,  88,  47,  29,  72,  35,  20,  48,  27,
	 20,  40,  27,  34,  88,  53,  33,  96,  54,  30,  80,  35,  31,  96,  43,  31,
	 88,  42,  30,  80,  35,  20,  48,  27,  20,  48,  36,  20,  48,  27,  30,  64,
	 34,  32,  80,  46,  20,  80,  34,  32,  80,  46,  29,  72,  35,  20,  40,  27,
	 22,  33,  29,  20,  40,  36,  20,  48,  27,  30,  64,  34,  30,  64,  34,  20,
	 64,  32,  30,  64,  34,  11,  40,  24,  20,  40,  27,  20,  40,  27,  29,  56,
	 33,  31,  88,  42,  20,  88,  38,  33, 104,  49,  31,  96,  43,  47,  88,  47,
	 11,  56,  28,  30,  40,  38,  20,  40,  27,  31,  72,  45,  11,  40,  24,  20,
	 40,  36,  11,  40,  24,  30,  80,  35,  36, 120,  56,  46, 127,  65,  36, 120,
	 56,  46, 120,  63,  46,  96,  49,  11,  40,  24,  11,  33,  18,  32,  80,  46,
	 36, 120,  56,  32,  56,  45,  11,  40,  24,  29,  72,  35,  49, 119,  77,  33,
	112,  50,  20, 111,  48,  28, 127,  58,  34, 135,  65,  46, 112,  58,  33, 112,
	 50,  33, 104,  49,  33, 104,  49,  33, 104,  49,  33, 104,  49,  33, 104,  49,
	 33, 104,  49,  60, 104,  73,  88, 128,  95,  81, 135,  95,  73, 128,  87,  60,
	120,  78,  51, 128,  77,  49, 119,  77,  27, 120,  53,  46, 127,  65,  33, 112,
	 50,  27, 120,  53,  27, 120,  53,  27, 120,  53,  47, 135,  70,  60, 120,  78,
	 32,  80,  46,  23,  16,  16,  21,  25,  22,  21,  25,  22,  21,  25,  22,  21,
	 25,  22,  12,  33,  29,  32,  56,  45, 100, 129, 107,  51, 128,  77,  60,  72,
	 31,  71,  71,  25,  33, 112,  50,  20, 104,  44,  71,  80,  27,  79,  64,  30,
	 37,  33,  13,  52,  46,  19,  89,  73,  22,  90,  88,  32,  46,  96,  49,  48,
	 96,  63,  49, 104,  69,  60,  87,  43,  30,  80,  35,  34,  88,  53,  30,  80,
	 35,  60,  80,  38,  46,  80,  45,  30,  64,  34,  30,  64,  34,  48,  72,  31,
	 70,  97,  49,  12,  80,  32,  31,  88,  42,  46,  96,  49,  60,  96,  47,  46,
	 96,  49,  31,  96,  43,  33,  96,  54,  30,  80,  35,  30,  80,  35,  30,  80,
	 35,  30,  80,  35,  32,  80,  46,  20,  56,  32,  20,  40,  27,  29,  40,  26,
	 30,  80,  35,  47,  88,  47,  20,  88,  38,  20,  80,  34,  31,  88,  42,  20,
	 64,  32,  11,  40,  24,  29,  40,  26,  20,  64,  32,  34,  88,  53,  31,  96,
	 43,  19,  95,  39,  20,  88,  38,  32,  80,  46,  11,  33,  18,  22,  33,  29,
	 20,  48,  27,  29,  72,  35,  19,  71,  34,  19,  71,  34,  19,  71,  34,  31,
	 72,  45,  30,  48,  39,  20,  40,  27,  20,  40,  27,  20,  48,  36,  30,  64,
	 34,  20,  64,  32,  20,  64,  32,  30,  64,  34,  29,  56,  33,  11,  33,  18,
	 20,  40,  36,  29,  56,  33,  30,  80,  35,  31,  88,  42,  31,  96,  43,  31,
	 96,  43,  32,  80,  46,  11,  48,  24,  30,  48,  39,  11,  48,  24,  20,  64,
	 45,  20,  56,  32,  22,  33,  29,  30,  48,  39,  32,  80,  46,  46, 112,  58,
	 33, 112,  50,  33, 104,  49,  46, 120,  63,  33,  96,  54,  20,  48,  36,  11,
	 40,  24,  20,  64,  32,  46, 104,  55,  30,  40,  38,  11,  40,  24,  11,  56,
	 28,  35, 112,  61,  33, 112,  50,  33, 112,  50,  27, 120,  53,  34, 135,  65,
	 46, 127,  65,  33, 104,  49,  19,  95,  39,  46, 112,  58,  46, 112,  58,  30,
	 80,  35,  47,  88,  47,  87, 121,  96, 177, 177, 169, 177, 177, 169, 164, 169,
	156, 164, 169, 156, 153, 160, 148, 113, 137, 117,  60, 120,  64,  27, 120,  53,
	 33, 112,  50,  33, 112,  50,  33, 112,  50,  33, 112,  50,  36, 120,  56,  46,
	120,  63,  51, 128,  77,  65, 136,  84,  31,  72,  45,  30,  48,  39,  12,  33,
	 29,   9,  16,  12,  12,  33,  29,  47,  88,  62,  73, 128,  87,  81, 143,  95,
	 60, 104,  53,  60,  96,  47,  47,  88,  47,  60,  87,  43,  60,  87,  43,  60,
	 87,  43,  52,  50,  20,  52,  46,  19,  71,  47,  23,  90,  88,  32,  72,  88,
	 39,  60, 104,  53,  46, 104,  55,  46, 104,  55,  49, 104,  69,  48,  96,  63,
	 47,  88,  47,  30,  80,  35,  30,  80,  35,  48,  72,  31,  56,  57,  18,  56,
	 57,  18,  71,  80,  39,  72,  88,  39,  30,  64,  34,  46,  72,  47,  48,  72,
	 31,  46,  80,  45,  30,  80,  35,  30,  80,  35,  20,  80,  34,  34,  88,  53,
	 33,  96,  54,  31,  88,  42,  31,  88,  42,  30,  80,  35,  20,  56,  32,  20,
	 40,  27,  29,  40,  26,  29,  72,  35,  31,  88,  42,  31,  88,  42,  31,  96,
	 43,  46, 104,  55,  29,  72,  35,  20,  40,  27,  20,  40,  27,  31,  72,  45,
	 31,  96,  43,  31,  96,  43,  20, 104,  44,  31,  96,  43,  46,  96,  49,  20,
	 40,  27,  30,  40,  38,  11,  48,  24,  29,  72,  35,  29,  72,  35,  19,  71,
	 34,  19,  71,  34,  30,  64,  34,  20,  48,  27,  22,  33,  29,  20,  48,  36,
	 20,  56,  32,  30,  64,  34,  30,  64,  34,  11,  64,  29,  30,  64,  34,  29,
	 56,  33,  11,  40,  24,  20,  40,  36,  20,  56,  32,  30,  80,  35,  31,  96,
	 43,  31,  96,  43,  31,  96,  43,  32,  80,  46,  11,  56,  28,  20,  40,  36,
	 11,  48,  24,  20,  64,  45,  20,  56,  32,  12,  33,  29,  30,  48,  39,  31,
	 72,  45,  35, 104,  60,  33, 104,  49,  19,  95,  39,  33, 104,  49,  32,  80,
	 46,  20,  48,  27,  20,  48,  36,  20,  64,  32,  33,  96,  54,  30,  40,  38,
	 11,  40,  24,  11,  64,  29,  46, 112,  58,  33, 104,  49,  33, 112,  50,  20,
	104,  44,  33, 112,  50,  33, 104,  49,  33, 104,  49,  19,  95,  39,  20,  88,
	 38,  20,  88,  38,  32,  80,  46,  87, 113,  79, 140, 158, 140, 140, 138, 116,
	140, 148, 138, 140, 142, 137, 140, 142, 137, 148, 145, 137, 113, 137, 117,  73,
	128,  87,  51, 128,  77,  33, 112,  50,  33, 104,  49,  33, 104,  49,  33, 112,
	 50,  33, 112,  50,  33, 112,  50,  33, 112,  50,  46, 120,  63,  73, 128,  87,
	 73, 120,  87,  72, 112,  82,  73, 104,  81,  73, 104,  81,  73, 128,  87,  81,
	143,  95,  47, 135,  70,  31,  96,  43,  31,  88,  42,  46,  96,  49,  20,  88,
	 38,  46,  96,  49,  46,  96,  49,  44,  56,  28,  56,  57,  18,  68,  56,  26,
	 90,  88,  32,  72,  88,  39,  46, 104,  55,  46, 112,  58,  46, 104,  55,  49,
	104,  69,  60, 104,  73,  48,  96,  63,  46,  80,  45,  46,  80,  45,  46,  72,
	 47,  56,  65,  29,  56,  65,  29,  60,  72,  31,  48,  72,  31,  30,  64,  34,
	 31,  72,  45,  32,  80,  46,  34,  88,  53,  31,  88,  42,  32,  80,  46,  20,
	 88,  38,  46, 104,  55,  46, 104,  55,  33, 104,  49,  33,  96,  54,  34,  88,
	 53,  20,  64,  32,  20,  40,  27,  30,  48,  26,  31,  88,  42,  46,  96,  49,
	 33, 104,  49,  33, 104,  49,  46, 104,  55,  29,  72,  35,  11,  48,  24,  20,
	 40,  27,  29,  72,  35,  33,  96,  54,  33, 104,  49,  33, 104,  49,  31,  96,
	 43,  33,  96,  54,  20,  40,  27,  30,  40,  38,  20,  48,  27,  29,  72,  35,
	 30,  80,  35,  19,  71,  34,  19,  71,  34,  30,  64,  34,  20,  48,  27,  22,
	 33,  29,  20,  40,  27,  20,  48,  36,  30,  64,  34,  19,  71,  34,  20,  64,
	 32,  30,  64,  34,  32,  56,  45,  11,  40,  24,  20,  40,  27,  29,  56,  33,
	 32,  80,  46,  31,  88,  42,  19,  95,  39,  31,  96,  43,  32,  80,  46,  11,
	 56,  28,  29,  40,  26,  11,  40,  24,  20,  64,  45,  20,  56,  32,  11,  33,
	 18,  30,  40,  38,  31,  72,  45,  33, 104,  49,  33, 104,  49,  20,  88,  38,
	 31,  88,  42,  29,  72,  35,  20,  48,  36,  20,  48,  36,  20,  64,  32,  31,
	 88,  42,  21,  32,  19,  11,  40,  24,  11,  48,  24,  31,  88,  42,  31,  88,
	 42,  46,  96,  49,  31,  96,  43,  33, 104,  49,  31,  96,  43,  31,  96,  43,
	 31,  88,  42,  20,  80,  34,  46,  96,  49,  73, 104,  81,  73, 104,  81,  88,
	 98,  92,  86,  93,  88,  86,  93,  88, 100,  92,  88, 100,  92,  88, 108, 105,
	104, 100, 113, 101,  87, 113,  79,  72, 121,  71,  46, 112,  58,  33, 112,  50,
	 36, 120,  56,  36, 120,  56,  36, 120,  56,  33, 112,  50,  33, 112,  50,  33,
	104,  49,  47, 135,  70,  51, 128,  77,  65, 136,  84,  73, 128,  87,  60, 129,
	 79,  65, 136,  84,  46, 127,  65,   8, 112,  48,  33, 112,  50,  33, 112,  50,
	 46, 112,  58,  33, 112,  50,  33, 112,  50,  46, 104,  55,  20,  56,  32,  44,
	 48,  20,  44,  56,  28,  60,  87,  43,  46,  96,  49,  46, 104,  55,  46, 104,
	 55,  31,  96,  43,  48,  96,  63,  48,  96,  63,  60,  96,  67,  34,  88,  53,
	 30,  80,  35,  48,  72,  31,  44,  56,  28,  44,  56,  28,  44,  65,  31,  20,
	 64,  32,  30,  64,  34,  32,  80,  46,  47,  88,  47,  46,  96,  49,  33,  96,
	 54,  33,  96,  54,  33, 104,  49,  46, 112,  58,  35, 112,  61,  33, 104,  49,
	 33, 104,  49,  34,  88,  53,  29,  72,  35,  20,  56,  32,  32,  56,  45,  31,
	 88,  42,  46, 104,  55,  33, 104,  49,  33, 104,  49,  33, 104,  49,  20,  80,
	 34,  11,  48,  24,  20,  48,  27,  32,  80,  46,  46, 104,  55,  33, 104,  49,
	 33, 112,  50,  33, 104,  49,  46,  96,  49,  11,  40,  24,  20,  40,  36,  20,
	 56,  32,  32,  80,  46,  32,  80,  46,  20,  80,  34,  19,  71,  34,  30,  64,
	 34,  20,  48,  27,  22,  33,  29,  20,  48,  36,  20,  56,  32,  30,  64,  34,
	 20,  64,  32,  20,  64,  32,  32,  64,  46,  29,  56,  33,  12,  33,  29,  20,
	 40,  36,  20,  56,  32,  30,  80,  35,  31,  96,  43,  31,  96,  43,  31,  96,
	 43,  32,  80,  46,  11,  48,  24,  20,  40,  36,  11,  48,  24,  31,  72,  45,
	 20,  56,  32,  21,  32,  19,  20,  48,  36,  20,  64,  32,  31,  96,  43,  31,
	 96,  43,  20,  88,  38,  31,  88,  42,  31,  72,  45,  20,  40,  27,  30,  48,
	 39,  20,  56,  32,  30,  80,  35,  30,  40,  38,  11,  48,  24,  11,  56,  28,
	 34,  88,  53,  31,  72,  45,  47,  88,  62,  47,  88,  62,  48,  96,  63,  72,
	112,  82,  60, 104,  73,  47,  88,  62,  60, 104,  73, 100, 129, 107, 115, 128,
	119,  86,  93,  88,  54,  56,  58,  54,  56,  58,  55,  64,  59,  54,  56,  58,
	 54,  56,  58,  76,  60,  56,  72,  80,  76,  72,  96,  77,  60, 112,  73,  51,
	128,  77,  46, 120,  63,  36, 120,  56,  46, 127,  65,  46, 127,  65,  33, 112,
	 50,  33, 104,  49,  33, 104,  49,  28, 127,  58,  20, 111,  48,  35, 112,  61,
	 35, 112,  61,  35, 112,  61,  36, 120,  69,  36, 120,  56,  33, 112,  50,  46,
	127,  65,  46, 120,  63,  46, 127,  65,  36, 120,  56,  36, 120,  56,  33, 104,
	 49,  11,  56,  28,  11,  40,  24,  11,  56,  28,  47,  88,  47,  31,  96,  43,
	 31,  96,  43,  33,  96,  54,  31,  88,  42,  47,  88,  47,  46,  80,  45,  31,
	 72,  45,  32,  80,  46,  47,  88,  62,  31,  72,  45,  20,  48,  27,  30,  48,
	 26,  30,  64,  34,  19,  71,  34,  32,  80,  46,  34,  88,  53,  33,  96,  54,
	 35, 104,  60,  33, 104,  49,  35, 104,  60,  35, 104,  60,  33, 104,  49,  33,
	 96,  54,  31,  96,  43,  19,  95,  39,  31,  88,  42,  20,  64,  32,  11,  48,
	 24,  29,  56,  33,  31,  88,  42,  31,  96,  43,  20,  88,  38,  20,  88,  38,
	 33, 104,  49,  30,  80,  35,  11,  48,  24,  20,  48,  36,  30,  80,  35,  33,
	 96,  54,  33, 112,  50,  33, 112,  50,  33, 104,  49,  48,  96,  63,  11,  48,
	 24,  29,  40,  26,  20,  64,  32,  31,  88,  42,  31,  88,  42,  20,  80,  34,
	 19,  71,  34,  31,  72,  45,  20,  48,  27,  22,  33,  29,  20,  40,  27,  20,
	 48,  36,  30,  64,  34,  19,  71,  34,  20,  64,  32,  30,  64,  34,  20,  56,
	 32,  11,  40,  24,  20,  40,  27,  20,  56,  32,  32,  80,  46,  20,  88,  38,
	 31,  96,  43,  31,  96,  43,  30,  80,  35,  11,  48,  24,  20,  40,  27,  20,
	 48,  27,  31,  72,  45,  20,  56,  32,  22,  33,  29,  20,  40,  27,  20,  64,
	 32,  31,  96,  43,  33, 104,  49,  31,  88,  42,  31,  96,  43,  31,  72,  45,
	 20,  40,  27,  20,  40,  27,  20,  56,  32,  30,  80,  35,  29,  40,  26,  20,
	 48,  36,  20,  56,  32,  32,  80,  46,  20,  56,  32,  32,  56,  45,  32,  56,
	 45,  20,  55,  46,  20,  48,  27,  20,  40,  27,  20,  48,  27,  29,  56,  33,
	 44,  64,  50,  54,  56,  58,  44,  41,  48,  52,  40,  47,  44,  41,  48,  44,
	 48,  47,  44,  41,  48,  38,  33,  34,  52,  40,  47,  54,  49,  50,  49,  71,
	 62,  60,  96,  67,  51, 128,  77,  46, 120,  63,  36, 120,  56,  36, 120,  56,
	 36, 120,  69,  27, 120,  53,  33, 104,  49,  33, 112,  50,  27, 120,  53,  33,
	112,  50,  20, 104,  44,  19,  95,  39,  20,  88,  38,  31,  96,  43,  33, 112,
	 50,  33, 112,  50,  33, 104,  49,  33, 112,  50,  46, 120,  63,  46, 112,  58,
	 36, 120,  56,  31,  96,  43,  20,  48,  27,  21,  32,  19,  11,  64,  29,  34,
	 88,  53,  33,  96,  54,  33, 104,  49,  35, 104,  60,  31,  88,  42,  34,  88,
	 53,  31,  72,  45,  30,  64,  34,  32,  80,  46,  47,  88,  62,  32,  80,  46,
	 20,  56,  32,  20,  56,  32,  31,  72,  45,  20,  81,  44,  20,  72,  45,  31,
	 88,  42,  33,  96,  54,  35, 104,  60,  20, 104,  44,  20,  96,  54,  35, 104,
	 60,  35, 104,  60,  33, 104,  49,  33, 104,  49,  33,  96,  54,  33,  96,  54,
	 20,  64,  32,  11,  48,  24,  20,  48,  36,  30,  80,  35,  31,  96,  43,  19,
	 95,  39,  19,  95,  39,  33, 104,  49,  19,  71,  34,  11,  40,  24,  11,  40,
	 24,  19,  71,  34,  31,  96,  43,  31,  96,  43,  20, 111,  48,  33, 104,  49,
	 31,  96,  43,  11,  40,  24,  30,  40,  38,  11,  56,  28,  34,  88,  53,  31,
	 88,  42,  20,  80,  34,  19,  71,  34,  30,  64,  34,  20,  48,  27,  22,  33,
	 29,  20,  48,  27,  20,  48,  36,  30,  64,  34,  30,  64,  34,  11,  56,  28,
	 30,  64,  34,  29,  56,  33,  11,  33,  18,  20,  40,  36,  20,  56,  32,  30,
	 80,  35,  31,  88,  42,  31,  96,  43,  31,  96,  43,  32,  80,  46,  11,  48,
	 24,  20,  40,  27,  11,  48,  24,  31,  72,  45,  20,  56,  32,  11,  33,  18,
	 20,  40,  27,  19,  71,  34,  31,  96,  43,  31,  88,  42,  20,  88,  38,  46,
	 96,  49,  29,  72,  35,  20,  40,  27,  20,  48,  27,  29,  56,  33,  34,  88,
	 53,  10,  25,  17,  11,  40,  24,  11,  56,  28,  31,  72,  45,  11,  48,  24,
	 11,  33,  18,  11,  33,  18,  11,  33,  18,  20,  48,  27,  11,  40,  24,  11,
	 40,  24,  11,  48,  24,  20,  40,  36,   9,  16,  12,  23,  16,  16,  52,  34,
	 36,  21,  25,  22,  22,  33,  29,  30,  40,  38,  30,  40,  38,  44,  41,  48,
	 38,  33,  34,  32,  56,  45,  60,  96,  67,  60, 129,  79,  36, 120,  56,  33,
	112,  50,  36, 120,  56,  46, 127,  65,  27, 120,  53,  33, 112,  50,  33, 112,
	 50,  27, 120,  53,  20, 104,  44,  33, 104,  49,  31,  96,  43,  31,  88,  42,
	 31,  96,  43,  31,  96,  43,  31,  88,  42,  20, 104,  44,  31,  96,  43,  46,
	112,  58,  33, 104,  49,  46, 104,  55,  31,  88,  42,  20,  48,  27,  21,  32,
	 19,  11,  56,  28,  34,  88,  53,  31,  88,  42,  33,  96,  54,  33,  96,  54,
	 32,  80,  46,  30,  80,  35,  29,  72,  35,  31,  72,  45,  31,  72,  45,  32,
	 80,  46,  19,  71,  34,  20,  56,  32,  30,  64,  34,  31,  72,  45,  20,  72,
	 45,  32,  80,  46,  34,  88,  53,  33,  96,  54,  20, 104,  44,  33,  96,  54,
	 20, 104,  44,  33,  96,  54,  35, 104,  60,  35, 112,  61,  33, 104,  49,  35,
	104,  60,  33,  96,  54,  19,  71,  34,  20,  48,  27,  32,  56,  45,  31,  88,
	 42,  46,  96,  49,  33, 104,  49,  31,  96,  43,  31,  96,  43,  19,  71,  34,
	 11,  48,  24,  30,  48,  39,  20,  80,  34,  33,  96,  54,  33, 104,  49,  33,
	112,  50,  20, 104,  44,  31,  96,  43,  11,  40,  24,  20,  40,  27,  11,  64,
	 29,  34,  88,  53,  31,  88,  42,  20,  81,  44,  19,  71,  34,  20,  64,  32,
	 30,  48,  39,  22,  33,  29,  20,  48,  27,  20,  48,  36,  30,  64,  34,  20,
	 64,  32,  20,  64,  32,  30,  64,  34,  20,  55,  46,  11,  33,  18,  20,  40,
	 36,  29,  56,  33,  32,  80,  46,  31,  96,  43,  19,  95,  39,  31,  96,  43,
	 34,  88,  53,  11,  56,  28,  29,  40,  26,  11,  48,  24,  31,  72,  45,  30,
	 64,  34,  11,  33,  18,  29,  40,  26,  19,  71,  34,  33, 104,  49,  31,  96,
	 43,  20,  88,  38,  31,  96,  43,  29,  72,  35,  11,  40,  24,  20,  48,  36,
	 30,  64,  34,  31,  88,  42,  21,  32,  19,  20,  40,  27,  20,  64,  45,  47,
	 88,  62,  29,  56,  33,  20,  48,  36,  20,  40,  27,  32,  64,  46,  32,  80,
	 46,  30,  80,  35,  11,  64,  29,  29,  72,  35,  46,  80,  45,  32,  56,  45,
	 10,  25,  17,   7,   9,   9,  21,  25,  22,  21,  25,  22,  21,  25,  22,  22,
	 33,  29,  21,  25,  22,  21,  25,  22,  44,  65,  31,  85, 122,  83,  66, 143,
	 88,  36, 120,  56,  27, 120,  53,  46, 127,  65,  47, 135,  70,  46, 120,  63,
	 36, 120,  56,  46, 120,  63,  33, 112,  50,  33, 112,  50,  33, 104,  49,  46,
	112,  58,  33, 104,  49,  33, 104,  49,  46, 104,  55,  31,  96,  43,  33, 104,
	 49,  33, 104,  49,  46, 104,  55,  20, 104,  44,  31,  96,  43,  31,  88,  42,
	 11,  40,  24,  21,  32,  19,  11,  48,  24,  32,  80,  46,  31,  88,  42,  20,
	 88,  53,  31,  88,  42,  19,  71,  34,  19,  71,  34,  20,  64,  32,  29,  72,
	 35,  30,  80,  35,  32,  80,  46,  19,  71,  34,  11,  56,  28,  20,  56,  32,
	 31,  72,  45,  11,  64,  29,  31,  72,  45,  32,  80,  46,  33,  96,  54,  35,
	104,  60,  35, 104,  60,  35, 104,  60,  33,  96,  54,  33, 104,  49,  33, 104,
	 49,  35, 104,  60,  33, 104,  49,  48,  96,  63,  31,  72,  45,  11,  56,  28,
	 30,  48,  39,  30,  80,  35,  46, 104,  55,  31,  96,  43,  31,  96,  43,  31,
	 96,  43,  32,  80,  46,  30,  64,  34,  72,  88,  78,  46,  96,  49,  46, 120,
	 63,  36, 120,  56,  36, 120,  56,  33, 112,  50,  46,  96,  49,  11,  40,  24,
	 30,  40,  38,  11,  64,  29,  34,  88,  53,  33,  96,  54,  20,  81,  44,  20,
	 80,  34,  30,  64,  34,  20,  48,  36,  29,  40,  26,  20,  40,  36,  20,  56,
	 32,  30,  64,  34,  19,  71,  34,  20,  64,  32,  32,  64,  46,  29,  56,  33,
	 20,  40,  27,  20,  48,  36,  29,  56,  33,  34,  88,  53,  31,  96,  43,  31,
	 96,  43,  46, 104,  55,  32,  80,  46,  11,  56,  28,  30,  40,  38,  20,  56,
	 32,  32,  80,  46,  30,  64,  34,  12,  33,  29,  29,  40,  26,  29,  72,  35,
	 33, 104,  49,  33, 112,  50,  31,  96,  43,  33, 104,  49,  30,  64,  34,  20,
	 40,  27,  20,  48,  36,  20,  64,  32,  30,  80,  35,  22,  33,  29,  20,  40,
	 27,  11,  56,  28,  48,  80,  62,  11,  48,  24,  11,  40,  24,  30,  48,  39,
	 48,  80,  62,  31,  96,  43,  31,  96,  43,  20,  88,  38,  31,  96,  43,  47,
	112,  69,  47,  88,  62,  20,  56,  32,  12,  33,  29,  21,  25,  22,  21,  25,
	 22,  10,  25,  17,  21,  25,  22,  21,  25,  22,  11,  33,  18,  60,  80,  67,
	108, 162, 116,  65, 136,  84,  36, 120,  56,  33, 112,  50,  47, 135,  70,  47,
	135,  70,  46, 127,  65,  36, 120,  56,  46, 120,  63,  35, 112,  61,  20, 104,
	 44,  33, 104,  49,  33, 104,  49,  31,  88,  42,  20,  88,  38,  33,  96,  54,
	 19,  95,  39,  19,  95,  39,  31,  96,  43,  31,  96,  43,  19,  95,  39,  31,
	 96,  43,  30,  80,  35,  20,  48,  27,  30,  40,  38,  20,  56,  32,  34,  88,
	 53,  32,  80,  46,  30,  80,  35,  30,  80,  35,  20,  80,  34,  30,  80,  35,
	 29,  72,  35,  30,  64,  34,  32,  80,  46,  33,  96,  54,  32,  80,  46,  11,
	 48,  24,  20,  56,  32,  31,  72,  45,  32,  80,  46,  20,  64,  45,  31,  72,
	 45,  33,  96,  54,  35, 104,  60,  33, 104,  49,  33,  96,  54,  34,  88,  53,
	 33,  96,  54,  20,  88,  53,  31,  96,  43,  33,  96,  54,  32,  80,  46,  11,
	 56,  28,  11,  48,  24,  11,  40,  24,  20,  72,  45,  20,  81,  44,  32,  80,
	 46,  31,  72,  45,  68,  88,  54,  87, 113,  96, 112, 119, 110, 124, 129, 111,
	166, 156, 156, 124, 129, 111,  73, 104,  81,  31,  96,  43,  20, 111,  48,  31,
	 96,  43,  11,  56,  28,  37,  33,  13,  20,  56,  32,  34,  88,  53,  33,  96,
	 54,  10,  87,  42,  19,  71,  34,  30,  64,  34,  20,  48,  27,  11,  40,  24,
	 20,  40,  36,  29,  56,  33,  20,  64,  32,  20,  64,  32,  20,  64,  32,  20,
	 64,  32,  20,  48,  27,  11,  33,  18,  22,  33,  29,  11,  56,  28,  31,  88,
	 42,  20,  88,  38,  33, 104,  49,  31,  96,  43,  34,  88,  53,  11,  56,  28,
	 20,  40,  27,  20,  48,  27,  20,  64,  32,  20,  56,  32,  20,  40,  27,  20,
	 48,  36,  32,  80,  46,  33, 104,  49,  33, 104,  49,  19,  95,  39,  31,  96,
	 43,  32,  80,  46,  21,  32,  19,  20,  48,  36,  11,  48,  24,  31,  88,  42,
	 22,  33,  29,  11,  40,  24,  20,  64,  32,  46,  80,  45,  11,  48,  24,  20,
	 40,  27,  20,  48,  27,  47,  88,  47,  20,  88,  38,  31,  88,  42,  20,  80,
	 34,  20,  80,  34,  31,  96,  43,  47, 112,  69,  33,  96,  54,  20,  64,  32,
	  7,   9,   9,  23,  16,  16,   9,  16,  12,   7,   9,   9,  20,  40,  27,  47,
	 88,  62,  73, 128,  87,  65, 136,  84,  31,  96,  43,  33, 104,  49,  36, 120,
	 56,  46, 127,  65,  36, 128,  63,  36, 120,  56,  33, 104,  49,  33, 112,  50,
	 33, 112,  50,  31,  88,  42,  30,  80,  35,  31,  88,  42,  20,  88,  38,  10,
	 87,  42,  31,  88,  42,  32,  80,  46,  31,  88,  42,  20,  88,  38,  20,  88,
	 38,  31,  96,  43,  20,  80,  34,  20,  64,  32,  11,  48,  24,  12,  33,  29,
	 11,  56,  28,  32,  80,  46,  32,  80,  46,  20,  80,  34,  20,  80,  34,  19,
	 71,  34,  11,  64,  29,  12,  80,  32,  31,  88,  42,  31,  88,  42,  31,  88,
	 42,  20,  72,  45,  11,  64,  29,  11,  64,  29,  31,  72,  45,  20,  64,  32,
	 20,  80,  34,  20,  81,  44,  33,  96,  54,  35, 104,  60,  20, 104,  44,  20,
	104,  44,  20, 104,  44,  32,  80,  46,  30,  80,  35,  32,  80,  46,  48,  80,
	 62,  31,  72,  45,  30,  48,  26,  30,  40,  38,  22,  33,  29,  11,  64,  29,
	 32,  80,  46,  30,  80,  35,  48,  80,  62,  72,  96,  77,  86, 104,  81, 110,
	113, 105, 112, 119, 110, 148, 145, 137, 140, 158, 140, 129, 149, 131,  47, 112,
	 69,  19,  95,  39,  20,  88,  38,  11,  40,  24,  21,  25,  22,  20,  64,  32,
	 31,  88,  42,  31,  96,  43,  20,  88,  38,  19,  71,  34,  30,  64,  34,  20,
	 40,  27,  11,  40,  24,  20,  40,  27,  30,  48,  39,  20,  64,  32,  20,  64,
	 32,  20,  64,  32,  20,  64,  32,  30,  48,  39,  11,  40,  24,  20,  40,  36,
	 29,  56,  33,  34,  88,  53,  20,  88,  38,  33, 104,  49,  19,  95,  39,  30,
	 80,  35,  11,  48,  24,  22,  33,  29,  20,  48,  27,  29,  72,  35,  20,  56,
	 32,  11,  33,  18,  20,  48,  27,  30,  80,  35,  33, 104,  49,  20, 104,  44,
	 19,  95,  39,  31,  88,  42,  31,  72,  45,  11,  33,  18,  30,  48,  39,  11,
	 56,  28,  31,  88,  42,  22,  33,  29,  11,  40,  24,  20,  64,  32,  46,  80,
	 45,  20,  48,  36,  11,  40,  24,  20,  48,  27,  32,  80,  46,  31,  96,  43,
	 31,  96,  43,  30,  80,  35,  30,  80,  35,  19,  95,  39,  35, 104,  60,  46,
	104,  55,  46,  80,  45,  32,  64,  46,  44,  56,  49,  32,  56,  45,  32,  56,
	 45,  47,  88,  62,  72, 112,  59,  49, 119,  77,  20, 104,  44,  31,  96,  43,
	 19,  95,  39,  33, 112,  50,  36, 120,  56,  36, 120,  56,  20, 104,  44,  31,
	 96,  43,  31,  88,  42,  20, 104,  44,  12,  80,  32,  19,  71,  34,  31,  88,
	 42,  20,  81,  44,  10,  87,  42,  31,  88,  42,  32,  80,  46,  31,  72,  45,
	 29,  72,  35,  29,  72,  35,  30,  80,  35,  31,  72,  45,  30,  64,  34,  30,
	 48,  39,  30,  40,  38,  30,  48,  26,  30,  64,  34,  48,  80,  62,  30,  80,
	 35,  46,  80,  45,  46,  80,  45,  30,  80,  35,  48,  80,  62,  47,  88,  47,
	 32,  80,  46,  46,  72,  47,  32,  64,  46,  20,  56,  32,  29,  56,  33,  30,
	 64,  34,  29,  56,  33,  30,  64,  34,  44,  64,  50,  32,  80,  46,  47,  88,
	 47,  34,  88,  53,  34,  88,  53,  31,  88,  42,  31,  88,  42,  20,  80,  34,
	 20,  80,  34,  31,  88,  42,  30,  80,  35,  11,  56,  28,  11,  48,  24,  11,
	 48,  24,  29,  72,  35,  31,  72,  45,  46,  80,  45,  60,  88,  68,  88,  98,
	 92,  86,  93,  88,  86,  93,  88,  86,  93,  88, 112, 104,  84, 127, 129, 125,
	129, 149, 131,  73, 120,  87,  60, 112,  73,  34,  88,  53,  11,  48,  24,  29,
	 40,  26,  20,  56,  32,  31,  88,  42,  33,  96,  54,  10,  87,  42,  19,  71,
	 34,  20,  56,  32,  20,  48,  27,  11,  40,  24,  20,  40,  27,  29,  56,  33,
	 20,  64,  32,  20,  64,  32,  19,  71,  34,  30,  64,  34,  29,  56,  33,  12,
	 33,  29,  20,  40,  27,  20,  56,  32,  34,  88,  53,  20,  88,  38,  33, 104,
	 49,  31,  88,  42,  31,  88,  42,  11,  48,  24,  21,  32,  19,  20,  56,  32,
	 31,  72,  45,  29,  56,  33,  11,  33,  18,  22,  33,  29,  32,  80,  46,  20,
	104,  44,  33, 104,  49,  19,  95,  39,  31,  88,  42,  29,  72,  35,  10,  25,
	 17,  30,  40,  38,  20,  56,  32,  31,  88,  42,  22,  33,  29,  11,  40,  24,
	 20,  56,  32,  32,  80,  46,  20,  48,  36,  20,  40,  27,  20,  48,  27,  31,
	 72,  45,  33,  96,  54,  34,  88,  53,  34,  88,  53,  31,  88,  42,  20,  88,
	 38,  20,  88,  53,  34,  88,  53,  48,  96,  63,  47,  88,  62,  48,  96,  63,
	 73, 104,  81,  60, 112,  73,  60, 112,  73,  46, 104,  55,  33, 104,  49,  19,
	 95,  39,  31,  88,  42,  31,  96,  43,  31,  96,  43,  33, 112,  50,  35, 112,
	 61,  33, 104,  49,  31,  88,  42,  32,  80,  46,  10,  87,  42,  20,  80,  34,
	 29,  72,  35,  32,  80,  46,  19,  71,  34,  19,  71,  34,  19,  71,  34,  20,
	 64,  32,  30,  80,  35,  12,  80,  32,  12,  80,  32,  12,  80,  32,  19,  71,
	 34,  20,  64,  32,  11,  48,  24,  11,  40,  24,  11,  40,  24,  30,  64,  34,
	 30,  80,  35,  19,  71,  34,  20,  80,  34,  20,  80,  34,  30,  80,  35,  32,
	 80,  46,  31,  88,  42,  20,  81,  44,  19,  71,  34,  19,  71,  34,  11,  56,
	 28,  20,  64,  32,  20,  64,  45,  20,  64,  32,  11,  56,  28,  29,  72,  35,
	 31,  88,  42,  34,  88,  53,  20,  88,  38,  31,  88,  42,  31,  96,  43,  31,
	 88,  42,  20,  80,  34,  20,  88,  38,  20,  88,  38,  20,  88,  38,  19,  71,
	 34,  11,  56,  28,  20,  56,  32,  46,  80,  45,  46,  80,  45,  46,  72,  47,
	 60,  73,  46,  60,  80,  67,  55,  64,  59,  44,  56,  49,  54,  56,  58,  60,
	 72,  66,  70,  73,  73,  84,  86,  87,  87, 113,  96,  85, 122,  83,  48,  96,
	 63,  11,  48,  24,  30,  40,  38,  20,  64,  32,  33,  96,  54,  31,  96,  43,
	 20,  88,  38,  19,  71,  34,  30,  64,  34,  20,  48,  27,  11,  40,  24,  20,
	 40,  27,  32,  56,  45,  30,  64,  34,  19,  71,  34,  20,  64,  32,  30,  64,
	 34,  20,  48,  36,  11,  33,  18,  12,  33,  29,  20,  48,  27,  30,  80,  35,
	 20,  88,  38,  31,  96,  43,  31,  96,  43,  34,  88,  53,  11,  56,  28,  20,
	 40,  27,  20,  56,  32,  20,  72,  45,  29,  56,  33,  11,  33,  18,  20,  40,
	 27,  31,  72,  45,  33, 104,  49,  33, 104,  49,  31,  96,  43,  31,  88,  42,
	 31,  72,  45,  11,  33,  18,  30,  48,  39,  11,  56,  28,  32,  80,  46,  12,
	 33,  29,  20,  40,  27,  20,  56,  32,  48,  80,  62,  11,  48,  24,  20,  40,
	 27,  20,  48,  27,  31,  72,  45,  31,  88,  42,  31,  88,  42,  34,  88,  53,
	 33,  96,  54,  20,  88,  38,  12,  80,  32,  19,  71,  34,  32,  80,  46,  31,
	 88,  42,  48,  96,  63,  49, 104,  69,  47, 112,  69,  33,  96,  54,  31,  96,
	 43,  19,  95,  39,  19,  95,  39,  33,  96,  54,  31,  88,  42,  31,  96,  43,
	 33,  96,  54,  33, 104,  49,  47,  88,  47,  32,  80,  46,  32,  80,  46,  48,
	 96,  63,  47,  88,  62,  47,  88,  62,  47,  88,  62,  32,  80,  46,  47,  88,
	 47,  46,  80,  45,  48,  72,  31,  46,  96,  49,  47,  88,  47,  46,  96,  49,
	 46,  96,  49,  46,  96,  49,  46,  80,  45,  30,  64,  34,  44,  56,  28,  29,
	 72,  35,  60,  87,  43,  60,  87,  43,  31,  88,  42,  30,  80,  35,  46,  96,
	 49,  31,  88,  42,  31,  88,  42,  31,  88,  42,  30,  80,  35,  19,  71,  34,
	 19,  71,  34,  20,  64,  32,  31,  72,  45,  47,  88,  47,  31,  72,  45,  30,
	 64,  34,  34,  88,  53,  48,  96,  63,  33, 104,  49,  31,  96,  43,  31,  96,
	 43,  46, 104,  55,  71,  80,  39,  60,  72,  31,  60,  72,  31,  60,  80,  38,
	 46,  72,  47,  56,  65,  29,  44,  48,  20,  44,  42,  26,  48,  72,  31,  48,
	 72,  31,  32,  56,  45,  30,  48,  26,  44,  48,  20,  22,  33,  29,  22,  33,
	 29,  30,  40,  38,  44,  48,  47,  44,  41,  48,  44,  48,  47,  60,  72,  66,
	 85, 122,  83,  60, 104,  73,  11,  33,  18,  11,  40,  24,  20,  56,  32,  33,
	 96,  54,  33,  96,  54,  20,  88,  38,  30,  80,  35,  30,  64,  34,  20,  48,
	 27,  20,  40,  36,  20,  40,  27,  29,  56,  33,  20,  64,  32,  20,  64,  32,
	 20,  64,  32,  20,  64,  32,  20,  48,  36,  11,  33,  18,  30,  40,  38,  20,
	 56,  32,  34,  88,  53,  20,  88,  38,  31,  96,  43,  20,  88,  38,  30,  80,
	 35,  11,  40,  24,  20,  40,  27,  20,  48,  27,  20,  64,  32,  20,  56,  32,
	 22,  33,  29,  20,  40,  27,  31,  72,  45,  20,  88,  38,  34,  88,  53,  31,
	 88,  42,  30,  80,  35,  31,  72,  45,  12,  33,  29,  20,  40,  36,  20,  56,
	 32,  29,  72,  35,  22,  33,  29,  11,  40,  24,  20,  56,  32,  31,  72,  45,
	 20,  40,  27,  20,  40,  27,  20,  48,  27,  31,  72,  45,  20,  80,  34,  20,
	 80,  34,  30,  80,  35,  34,  88,  53,  31,  88,  42,  12,  80,  32,  11,  64,
	 29,  30,  64,  34,  32,  80,  46,  20,  80,  34,  19,  71,  34,  30,  80,  35,
	 34,  88,  53,  31,  88,  42,  31,  88,  42,  31,  88,  42,  31,  88,  42,  31,
	 88,  42,  31,  88,  42,  31,  88,  42,  20,  80,  34,  20,  64,  32,  32,  64,
	 46,  32,  64,  46,  44,  56,  49,  29,  56,  33,  32,  64,  46,  32,  64,  46,
	 44,  64,  50,  60,  73,  46,  71,  80,  39,  70,  72,  39,  86,  72,  43,  68,
	 66,  52,  76,  66,  44,  70,  72,  39,  86,  72,  43,  76,  66,  44,  77,  57,
	 27,  68,  50,  44,  77,  57,  27, 100,  78,  40,  88,  80,  39,  71,  71,  25,
	 71,  71,  25,  71,  71,  25,  88,  80,  39, 100,  78,  40,  71,  71,  25,  71,
	 71,  25,  68,  64,  28,  68,  56,  26,  68,  56,  26,  76,  66,  44,  86,  72,
	 43,  79,  64,  30,  71,  71,  25,  71,  80,  39,  70,  97,  49,  72,  88,  39,
	 60,  80,  38,  60,  80,  38,  71,  80,  27,  60,  72,  31,  56,  65,  29,  30,
	 64,  34,  48,  72,  31,  31,  72,  45,  30,  48,  26,  29,  40,  26,  22,  33,
	 29,  30,  64,  34,  30,  64,  34,  30,  48,  26,  21,  25,  22,  21,  25,  22,
	 22,  33,  29,  21,  25,  22,  22,  33,  29,  38,  33,  34,  54,  49,  50,  30,
	 40,  38,  30,  48,  39,  60, 104,  53,  49, 104,  69,  11,  40,  24,  12,  33,
	 29,  20,  64,  45,  47,  88,  47,  33, 104,  49,  20,  88,  38,  20,  80,  34,
	 30,  64,  34,  20,  48,  27,  20,  48,  27,  12,  33,  29,  20,  48,  36,  20,
	 64,  32,  20,  64,  32,  19,  71,  34,  32,  64,  46,  20,  48,  27,  12,  33,
	 29,  20,  40,  27,  29,  56,  33,  30,  80,  35,  20,  80,  34,  31,  96,  43,
	 30,  80,  35,  30,  80,  35,  11,  48,  24,  30,  40,  38,  11,  48,  24,  20,
	 56,  32,  20,  48,  27,  11,  33,  18,  29,  40,  26,  30,  64,  34,  19,  71,
	 34,  12,  80,  32,  19,  71,  34,  19,  71,  34,  20,  64,  32,  10,  25,  17,
	 30,  48,  39,  20,  48,  36,  20,  64,  32,  22,  33,  29,  20,  40,  27,  20,
	 56,  32,  31,  72,  45,  11,  40,  24,  20,  40,  27,  20,  40,  27,  30,  64,
	 34,  31,  88,  42,  20,  80,  34,  19,  71,  34,  32,  80,  46,  31,  88,  42,
	 20,  81,  44,  19,  71,  34,  29,  72,  35,  19,  71,  34,  20,  64,  32,  19,
	 71,  34,  29,  72,  35,  29,  72,  35,  29,  72,  35,  29,  72,  35,  30,  80,
	 35,  30,  80,  35,  32,  80,  46,  31,  88,  42,  20,  80,  34,  20,  64,  32,
	 11,  48,  24,  11,  40,  24,  29,  40,  26,   9,  16,  12,  10,  25,  17,  11,
	 33,  18,  11,  33,  18,  21,  25,  22,  44,  48,  20,  56,  57,  18,  44,  48,
	 20,  44,  42,  26,  37,  33,  13,  21,  32,  19,  37,  33,  13,  37,  33,  13,
	 37,  33,  13,  21,  32,  19,  37,  33,  13,  52,  46,  19,  56,  57,  18,  56,
	 57,  18,  44,  56,  28,  56,  57,  18,  68,  64,  28,  79,  64,  30,  92,  66,
	 32,  60,  80,  38,  56,  65,  29,  56,  65,  29,  56,  57,  18,  44,  48,  20,
	 44,  48,  20,  56,  57,  18,  44,  48,  20,  44,  48,  20,  56,  65,  29,  60,
	 80,  38,  48,  72,  31,  29,  72,  35,  48,  72,  31,  60,  72,  31,  48,  72,
	 31,  20,  64,  32,  20,  64,  32,  12,  80,  32,  19,  71,  34,  11,  64,  29,
	 11,  56,  28,  20,  48,  27,  30,  64,  34,  31,  72,  45,  30,  48,  26,  11,
	 33,  18,  21,  25,  22,  37,  33,  13,  22,  33,  29,  30,  40,  38,  40,  22,
	 20,  38,  33,  34,  21,  32,  19,  20,  56,  32,  73, 120,  87,  47, 112,  69,
	 11,  40,  24,  30,  40,  38,  20,  56,  32,  33,  96,  54,  33,  96,  54,  20,
	 88,  38,  19,  71,  34,  30,  64,  34,  20,  48,  27,  11,  40,  24,  22,  33,
	 29,  20,  48,  27,  30,  64,  34,  20,  64,  32,  19,  71,  34,  30,  64,  34,
	 20,  56,  32,  11,  33,  18,  22,  33,  29,  20,  48,  27,  32,  80,  46,  20,
	 80,  34,  19,  95,  39,  31,  88,  42,  32,  80,  46,  11,  48,  24,  20,  40,
	 27,  20,  48,  36,  20,  64,  32,  20,  48,  36,  21,  25,  22,  22,  33,  29,
	 30,  64,  34,  12,  80,  32,  20,  64,  32,  19,  71,  34,  19,  71,  34,  29,
	 56,  33,  12,  33,  29,  20,  48,  36,  20,  48,  36,  20,  64,  32,  22,  33,
	 29,  20,  40,  27,  20,  48,  27,  32,  64,  46,  12,  33,  29,  22,  33,  29,
	 20,  48,  27,  30,  64,  34,  20,  81,  44,  29,  72,  35,  29,  72,  35,  20,
	 80,  34,  20,  88,  38,  20,  81,  44,  32,  80,  46,  31,  72,  45,  11,  64,
	 29,  30,  80,  35,  32,  80,  46,  30,  80,  35,  19,  71,  34,  19,  71,  34,
	 29,  72,  35,  32,  80,  46,  32,  80,  46,  20,  80,  34,  31,  88,  42,  20,
	 81,  44,  19,  71,  34,  20,  48,  27,  11,  40,  24,  22,  33,  29,  29,  40,
	 26,  11,  48,  24,  11,  56,  28,  11,  48,  24,  21,  32,  19,  52,  50,  20,
	 56,  65,  29,  44,  48,  20,  11,  56,  28,  11,  56,  28,  20,  56,  32,  20,
	 64,  32,  11,  56,  28,  11,  56,  28,  11,  56,  28,  20,  64,  32,  29,  72,
	 35,  31,  88,  42,  20,  80,  34,  31,  88,  42,  31,  88,  42,  48,  72,  31,
	 48,  72,  31,  71,  80,  27,  30,  80,  35,  20,  80,  34,  20,  80,  34,  19,
	 71,  34,  11,  64,  29,  11,  56,  28,  20,  64,  32,  11,  56,  28,  11,  48,
	 24,  12,  80,  32,  12,  80,  32,  10,  87,  42,  12,  80,  32,  30,  80,  35,
	 30,  80,  35,  56,  65,  29,  44,  56,  28,  30,  64,  34,  29,  72,  35,  30,
	 80,  35,  31,  72,  45,  44,  64,  50,  44,  64,  50,  32,  80,  46,  47,  88,
	 62,  44,  64,  50,  29,  40,  26,  37,  33,  13,  44,  48,  47,  30,  40,  38,
	 29,  40,  26,  40,  22,  20,  23,  16,  16,  21,  25,  22,  32,  80,  46,  95,
	152, 108,  60, 120,  64,  11,  33,  18,  22,  33,  29,  20,  56,  32,  34,  88,
	 53,  31,  96,  43,  10,  87,  42,  19,  71,  34,  29,  56,  33,  20,  48,  27,
	 11,  40,  24,  20,  40,  27,  29,  56,  33,  32,  64,  46,  19,  71,  34,  19,
	 71,  34,  30,  64,  34,  20,  48,  36,  11,  33,  18,  30,  40,  38,  29,  56,
	 33,  30,  80,  35,  20,  88,  38,  31,  88,  42,  20,  88,  38,  30,  80,  35,
	 11,  40,  24,  20,  40,  36,  20,  56,  32,  20,  72,  45,  29,  56,  33,  12,
	 33,  29,  22,  33,  29,  30,  64,  34,  30,  80,  35,  29,  72,  35,  30,  80,
	 35,  29,  72,  35,  20,  64,  45,  10,  25,  17,  20,  48,  36,  20,  40,  27,
	 11,  56,  28,  22,  33,  29,  20,  40,  27,  20,  48,  27,  32,  64,  46,  11,
	 33,  18,  12,  33,  29,  30,  48,  26,  32,  64,  46,  20,  80,  34,  30,  80,
	 35,  32,  80,  46,  32,  80,  46,  20,  88,  53,  31,  88,  42,  31,  72,  45,
	 30,  64,  34,  32,  80,  46,  20,  81,  44,  19,  71,  34,  19,  71,  34,  20,
	 80,  34,  31,  88,  42,  30,  80,  35,  19,  71,  34,  19,  71,  34,  12,  80,
	 32,  20,  81,  44,  32,  80,  46,  31,  72,  45,  20,  56,  32,  20,  40,  27,
	 21,  25,  22,  32,  56,  45,  30,  64,  34,  20,  81,  44,  19,  71,  34,  30,
	 64,  34,  60,  73,  46,  60,  72,  31,  44,  56,  28,  20,  64,  32,  29,  72,
	 35,  47,  88,  47,  60,  96,  67,  60, 104,  53,  60,  96,  67,  46,  96,  49,
	 46, 104,  55,  49, 104,  69,  49, 104,  69,  49, 104,  69,  47, 112,  69,  60,
	104,  53,  46,  80,  45,  56,  57,  18,  68,  64,  28,  31,  88,  42,  31,  88,
	 42,  47,  88,  62,  34,  88,  53,  31,  72,  45,  32,  80,  46,  46,  80,  45,
	 32,  80,  46,  30,  64,  34,  47,  88,  62,  48,  96,  63,  48,  96,  63,  34,
	 88,  53,  47,  88,  47,  48,  72,  31,  71,  80,  39,  29,  56,  33,  11,  56,
	 28,  19,  71,  34,  47,  88,  47,  46,  72,  47,  32,  56,  45,  55,  64,  59,
	 46,  80,  45,  46,  72,  47,  31,  72,  45,  49,  71,  62,  32,  64,  46,  30,
	 40,  38,  22,  33,  29,  38,  33,  34,   9,  16,  12,  10,  25,  17,  31,  72,
	 45,  81, 135,  95,  65, 136,  84,  46,  96,  49,  11,  33,  18,  20,  48,  36,
	 11,  56,  28,  33,  96,  54,  31,  88,  42,  10,  87,  42,  20,  64,  32,  30,
	 64,  34,  11,  33,  18,  20,  40,  27,  20,  40,  27,  20,  56,  32,  30,  64,
	 34,  20,  64,  32,  11,  64,  29,  20,  64,  32,  20,  48,  27,  11,  33,  18,
	 20,  40,  36,  11,  48,  24,  30,  64,  34,  19,  71,  34,  20,  80,  34,  19,
	 71,  34,  30,  64,  34,  11,  40,  24,  20,  40,  36,  20,  40,  27,  29,  56,
	 33,  11,  40,  24,  11,  33,  18,  30,  48,  39,  20,  56,  32,  32,  80,  46,
	 29,  72,  35,  20,  64,  32,  20,  64,  32,  20,  48,  27,  20,  40,  27,  20,
	 40,  36,  20,  48,  36,  20,  64,  32,  22,  33,  29,  20,  40,  27,  11,  48,
	 24,  32,  56,  45,  20,  40,  27,  20,  40,  27,  20,  40,  27,  32,  64,  46,
	 32,  80,  46,  29,  72,  35,  20,  64,  32,  19,  71,  34,  32,  80,  46,  20,
	 81,  44,  20,  72,  45,  19,  71,  34,  30,  64,  34,  29,  72,  35,  31,  72,
	 45,  29,  72,  35,  29,  72,  35,  31,  72,  45,  29,  72,  35,  29,  72,  35,
	 11,  64,  29,  30,  80,  35,  20,  64,  32,  30,  64,  34,  46,  72,  47,  56,
	 65,  29,  79,  64,  30,  89,  73,  22,  48,  72,  31,  29,  72,  35,  30,  64,
	 34,  30,  64,  34,  20,  64,  32,  52,  50,  20,  71,  47,  23,  11,  56,  28,
	 29,  72,  35,  29,  72,  35,  72,  88,  78,  60,  80,  67, 100, 104, 101,  86,
	 93,  88,  70,  73,  73,  86,  93,  88,  72,  88,  78, 100, 104, 101, 100, 104,
	101,  72,  88,  78,  72,  96,  77,  48,  72,  31,  72,  88,  39,  56,  57,  18,
	 30,  80,  35,  31,  96,  43,  49, 104,  69,  32,  64,  46,  86,  93,  88,  72,
	 80,  76,  55,  64,  59,  32,  56,  45,  30,  48,  39,  30,  48,  39,  87, 105,
	 93,  87, 121,  96,  60,  80,  67,  60,  80,  38,  72,  88,  39,  60,  72,  31,
	 29,  56,  33,  11,  64,  29,  30,  80,  35,  32,  80,  46,  30,  48,  26,  11,
	 33,  18,  20,  40,  27,  11,  40,  24,  32,  64,  46,  47,  88,  62,  47,  88,
	 62,  48,  80,  62,  32,  56,  45,  21,  32,  19,  10,  25,  17,  56,  65,  29,
	 48,  80,  62,  60, 112,  73,  65, 136,  84,  46, 120,  63,  31,  88,  42,  11,
	 33,  18,  30,  40,  38,  11,  56,  28,  46, 104,  55,  31,  96,  43,  31,  88,
	 42,  20,  80,  34,  30,  64,  34,  11,  40,  24,  20,  40,  27,  20,  40,  36,
	 29,  56,  33,  30,  64,  34,  19,  71,  34,  20,  64,  32,  30,  64,  34,  20,
	 48,  36,  21,  32,  19,  20,  40,  36,  11,  48,  24,  31,  72,  45,  11,  64,
	 29,  30,  80,  35,  30,  64,  34,  31,  72,  45,  11,  40,  24,  22,  33,  29,
	 20,  48,  27,  29,  56,  33,  20,  48,  27,  11,  33,  18,  20,  40,  36,  20,
	 48,  36,  30,  80,  35,  20,  64,  32,  29,  72,  35,  20,  64,  32,  20,  48,
	 36,  20,  40,  27,  29,  40,  26,  20,  48,  27,  20,  64,  45,  22,  33,  29,
	 20,  40,  36,  11,  40,  24,  29,  56,  33,  11,  33,  18,  29,  40,  26,  11,
	 40,  24,  32,  64,  46,  29,  72,  35,  29,  72,  35,  19,  71,  34,  19,  71,
	 34,  20,  80,  34,  32,  80,  46,  30,  80,  35,  19,  71,  34,  19,  71,  34,
	 29,  72,  35,  19,  71,  34,  29,  72,  35,  19,  71,  34,  29,  72,  35,  19,
	 71,  34,  19,  71,  34,  29,  72,  35,  30,  80,  35,  20,  64,  32,  30,  64,
	 34,  44,  64,  50,  44,  48,  20,  68,  64,  28,  89,  73,  22,  48,  72,  31,
	 30,  64,  34,  20,  56,  32,  20,  56,  32,  19,  71,  34,  68,  64,  28,  77,
	 57,  27,  19,  71,  34,  20,  64,  32,  29,  72,  35,  29,  56,  33,  55,  64,
	 59,  30,  40,  38,  21,  25,  22,  29,  40,  26,  21,  25,  22,  29,  40,  26,
	 10,  25,  17,  44,  48,  47,  44,  48,  47,  49,  71,  62,  68,  88,  54,  56,
	 57,  18,  84,  78,  28,  46,  96,  49,  33,  96,  54,  49, 104,  69,  20,  48,
	 36,  22,  33,  29,   9,  16,  12,  30,  40,  38,  60,  80,  67,  86,  93,  88,
	 30,  48,  39,  20,  48,  36,  30,  48,  26,  32,  64,  46,  60,  80,  38,  60,
	 72,  31,  60,  72,  31,  44,  65,  31,  20,  64,  32,  30,  80,  35,  32,  80,
	 46,  20,  40,  27,  10,  25,  17,  30,  48,  39,  73, 104,  81,  85, 122,  83,
	 72, 112,  82,  73, 104,  81,  47,  88,  62,  47,  88,  62,  73, 104,  81,  72,
	112,  82,  72, 112,  59,  85, 122,  83,  65, 136,  84,  51, 128,  77,  33,  96,
	 54,  31,  88,  42,  11,  33,  18,  11,  33,  18,  20,  56,  32,  48,  96,  63,
	 33, 104,  49,  19,  95,  39,  30,  80,  35,  31,  72,  45,  20,  40,  27,  11,
	 40,  24,  20,  40,  27,  29,  56,  33,  32,  64,  46,  19,  71,  34,  19,  71,
	 34,  20,  64,  32,  20,  48,  27,  11,  40,  24,  30,  40,  38,  11,  48,  24,
	 32,  64,  46,  19,  71,  34,  20,  80,  34,  19,  71,  34,  32,  64,  46,  11,
	 40,  24,  20,  40,  36,  20,  40,  27,  30,  64,  34,  11,  48,  24,  21,  32,
	 19,  30,  48,  39,  20,  56,  32,  32,  80,  46,  29,  72,  35,  19,  71,  34,
	 20,  64,  32,  20,  56,  32,  30,  40,  38,  20,  40,  27,  20,  48,  36,  20,
	 64,  32,  22,  33,  29,  20,  40,  27,  11,  40,  24,  32,  56,  45,  21,  32,
	 19,  20,  40,  27,  11,  40,  24,  30,  64,  34,  30,  64,  34,  19,  71,  34,
	 29,  72,  35,  19,  71,  34,  20,  81,  44,  29,  72,  35,  19,  71,  34,  32,
	 80,  46,  19,  71,  34,  29,  72,  35,  32,  80,  46,  20,  81,  44,  31,  72,
	 45,  32,  80,  46,  20,  80,  34,  19,  71,  34,  29,  72,  35,  31,  88,  42,
	 20,  64,  32,  20,  64,  32,  29,  56,  33,  30,  48,  26,  44,  48,  20,  56,
	 57,  18,  44,  56,  28,  19,  71,  34,  30,  64,  34,  19,  71,  34,  19,  71,
	 34,  68,  64,  28,  79,  64,  30,  30,  64,  34,  20,  64,  32,  47,  88,  47,
	 29,  56,  33,  29,  40,  26,   7,   9,   9,  68,  65,  70, 151, 167, 151, 188,
	190, 188, 129, 149, 131,  68,  66,  52,  22,  33,  29,  21,  25,  22,  30,  48,
	 26,  70, 104,  55,  44,  48,  20,  71,  80,  27,  31,  88,  42,  31,  88,  42,
	 48,  96,  63,  32,  64,  46,  10,  25,  17,  54,  56,  58, 115, 128, 119, 164,
	178, 164, 177, 192, 178, 152, 176, 159,  87, 121,  96,  32,  64,  46,  30,  64,
	 34,  46,  72,  47,  48,  72,  31,  48,  72,  31,  44,  65,  31,  20,  64,  32,
	 32,  80,  46,  31,  72,  45,  30,  48,  26,  55,  64,  59,  88,  98,  92, 100,
	129, 107, 113, 137, 117,  97, 136, 103,  73, 128,  87,  72, 112,  82,  47, 112,
	 69,  47, 112,  69,  60, 120,  78,  72, 121,  71,  60, 127,  68,  36, 120,  56,
	 33, 112,  50,  33, 104,  49,  46, 104,  55,  11,  40,  24,  21,  25,  22,  11,
	 64,  29,  46, 104,  55,  20,  96,  54,  31,  96,  43,  29,  72,  35,  30,  64,
	 34,  20,  40,  27,  11,  33,  18,  20,  40,  27,  29,  56,  33,  30,  64,  34,
	 19,  71,  34,  19,  71,  34,  30,  64,  34,  30,  48,  39,  11,  33,  18,  20,
	 40,  27,  11,  40,  24,  20,  64,  32,  11,  64,  29,  29,  72,  35,  20,  64,
	 32,  30,  64,  34,  11,  33,  18,  20,  40,  36,  20,  48,  27,  29,  56,  33,
	 20,  48,  27,  11,  33,  18,  20,  40,  36,  20,  56,  32,  29,  72,  35,  30,
	 64,  34,  29,  72,  35,  20,  64,  32,  20,  48,  36,  20,  40,  27,  20,  40,
	 27,  20,  56,  32,  20,  55,  46,  21,  32,  19,  20,  40,  27,  11,  40,  24,
	 32,  56,  45,  11,  33,  18,  21,  32,  19,  20,  40,  27,  20,  56,  32,  30,
	 64,  34,  19,  71,  34,  29,  72,  35,  31,  72,  45,  20,  80,  34,  19,  71,
	 34,  30,  80,  35,  29,  72,  35,  19,  71,  34,  32,  80,  46,  20,  80,  34,
	 30,  80,  35,  19,  71,  34,  20,  80,  34,  32,  80,  46,  19,  71,  34,  30,
	 64,  34,  30,  80,  35,  20,  64,  32,  20,  64,  32,  30,  64,  34,  20,  40,
	 27,  37,  33,  13,  44,  48,  20,  20,  48,  27,  19,  71,  34,  32,  80,  46,
	 20,  80,  34,  11,  64,  29,  56,  57,  18,  77,  57,  27,  20,  64,  32,  30,
	 80,  35,  46,  80,  45,  44,  64,  50,   9,  16,  12,  72,  80,  76, 212, 216,
	210, 248, 253, 245, 248, 253, 245, 248, 253, 245, 204, 207, 202,  72,  80,  76,
	 29,  40,  26,  30,  48,  39,  60,  80,  38,  71,  80,  27,  71,  71,  25,  30,
	 80,  35,  31,  96,  43,  48,  96,  63,  30,  48,  39,  22,  33,  29, 127, 129,
	125, 188, 200, 186, 167, 199, 174, 164, 186, 162, 175, 207, 177, 152, 176, 159,
	 47,  88,  62,  11,  40,  24,  29,  56,  33,  48,  72,  31,  48,  72,  31,  30,
	 64,  34,  11,  56,  28,  29,  72,  35,  46,  72,  47,  44,  56,  49,  86, 104,
	 81, 129, 149, 131, 113, 137, 117, 100, 129, 107,  97, 136, 103,  97, 136, 103,
	 73, 120,  87,  31,  96,  43,  20,  88,  38,  33,  96,  54,  46, 112,  58,  20,
	104,  44,  20, 104,  44,  27, 120,  53,  27, 120,  53,  46, 104,  55,  20,  48,
	 27,  21,  25,  22,  20,  64,  32,  48,  96,  63,  19,  95,  39,  20,  88,  38,
	 19,  71,  34,  30,  64,  34,  11,  40,  24,  20,  40,  27,  20,  40,  27,  29,
	 56,  33,  30,  64,  34,  19,  71,  34,  20,  64,  32,  20,  64,  32,  20,  48,
	 27,  11,  33,  18,  20,  40,  27,  20,  40,  27,  30,  64,  34,  11,  56,  28,
	 19,  71,  34,  20,  64,  32,  32,  64,  46,  11,  40,  24,  22,  33,  29,  11,
	 40,  24,  29,  56,  33,  11,  40,  24,  11,  33,  18,  20,  40,  27,  11,  48,
	 24,  19,  71,  34,  29,  72,  35,  20,  64,  32,  20,  64,  32,  20,  48,  36,
	 20,  40,  27,  21,  32,  19,  20,  48,  27,  11,  56,  28,  22,  33,  29,  11,
	 40,  24,  11,  40,  24,  32,  56,  45,  11,  33,  18,  20,  40,  27,  11,  33,
	 18,  20,  56,  32,  30,  64,  34,  29,  72,  35,  32,  80,  46,  20,  80,  34,
	 19,  71,  34,  19,  71,  34,  19,  71,  34,  31,  72,  45,  20,  80,  34,  20,
	 72,  45,  19,  71,  34,  19,  71,  34,  19,  71,  34,  19,  71,  34,  30,  80,
	 35,  20,  80,  34,  20,  64,  32,  29,  72,  35,  19,  71,  34,  19,  71,  34,
	 30,  64,  34,  11,  40,  24,  44,  48,  20,  56,  57,  18,  30,  48,  26,  20,
	 64,  32,  31,  72,  45,  20,  80,  34,  12,  80,  32,  56,  65,  29,  79,  64,
	 30,  29,  72,  35,  29,  72,  35,  29,  72,  35,  32,  56,  45,  21,  32,  19,
	177, 177, 169, 248, 253, 245, 248, 253, 245, 218, 230, 210, 236, 253, 236, 248,
	253, 245, 153, 160, 148,  44,  56,  49,  29,  56,  33,  48,  72,  31,  90,  88,
	 32,  71,  71,  25,  30,  80,  35,  46,  96,  49,  47,  88,  47,  20,  55,  46,
	 30,  40,  38, 177, 177, 169, 212, 216, 210, 152, 176, 159, 164, 186, 162, 164,
	186, 162, 167, 199, 174,  97, 136, 103,  31,  72,  45,  46,  80,  45,  70,  97,
	 49,  60,  72,  31,  29,  72,  35,  11,  56,  28,  48,  80,  62,  72,  88,  78,
	 55,  64,  59, 100, 113, 101, 153, 160, 148, 152, 176, 159, 129, 149, 131, 113,
	137, 117,  97, 136, 103,  73, 120,  87,  31,  88,  42,  19,  95,  39,  36, 120,
	 56,  20, 104,  44,  33, 112,  50,  27, 120,  53,  47, 135,  70,  36, 120,  56,
	 46,  96,  49,  20,  40,  27,  30,  40,  38,  20,  64,  32,  49, 104,  69,  31,
	 96,  43,  20,  88,  38,  29,  72,  35,  29,  72,  35,  20,  40,  27,  20,  40,
	 27,  20,  40,  27,  20,  56,  32,  30,  64,  34,  19,  71,  34,  19,  71,  34,
	 30,  64,  34,  20,  48,  27,  11,  33,  18,  30,  40,  38,  20,  40,  27,  30,
	 64,  34,  11,  64,  29,  29,  72,  35,  30,  64,  34,  30,  64,  34,  11,  40,
	 24,  20,  40,  36,  20,  40,  27,  30,  64,  34,  20,  48,  27,  11,  33,  18,
	 20,  48,  36,  20,  48,  36,  29,  72,  35,  29,  72,  35,  20,  64,  45,  20,
	 64,  32,  20,  48,  27,  20,  40,  27,  22,  33,  29,  20,  48,  36,  11,  56,
	 28,  21,  32,  19,  20,  40,  36,  11,  40,  24,  29,  56,  33,  21,  32,  19,
	 21,  32,  19,  11,  40,  24,  20,  56,  32,  30,  64,  34,  19,  71,  34,  29,
	 72,  35,  31,  72,  45,  20,  80,  34,  19,  71,  34,  19,  71,  34,  19,  71,
	 34,  32,  80,  46,  32,  80,  46,  29,  72,  35,  19,  71,  34,  19,  71,  34,
	 32,  80,  46,  32,  80,  46,  29,  72,  35,  29,  72,  35,  30,  80,  35,  19,
	 71,  34,  19,  71,  34,  20,  64,  32,  20,  40,  27,  52,  50,  20,  71,  71,
	 25,  71,  71,  25,  29,  72,  35,  20,  64,  32,  11,  64,  29,  20,  80,  34,
	 71,  71,  25,  79,  64,  30,  29,  72,  35,  11,  56,  28,  48,  80,  62,  29,
	 56,  33,  44,  56,  49, 217, 225, 217, 236, 239, 230, 248, 253, 245, 248, 253,
	245, 218, 230, 210, 236, 239, 230, 204, 207, 202,  44,  56,  49,  30,  48,  39,
	 70,  97,  49,  71,  80,  27,  68,  64,  28,  30,  80,  35,  31,  88,  42,  47,
	 88,  62,  44,  64,  50,  70,  73,  73, 188, 190, 188, 228, 230, 228, 194, 209,
	190, 194, 209, 190, 164, 186, 162, 167, 199, 174, 129, 149, 131,  46,  72,  47,
	 30,  64,  34,  46,  80,  45,  60,  80,  38,  46,  80,  45,  11,  56,  28,  47,
	 88,  47,  60,  88,  68,  44,  56,  49,  88,  98,  92, 127, 137, 126, 127, 137,
	126, 129, 149, 131, 129, 149, 131, 111, 149, 119,  88, 128,  95,  46, 104,  55,
	 31,  96,  43,  33, 112,  50,  46, 112,  58,  36, 120,  56,  36, 128,  63,  47,
	135,  70,  36, 128,  63,  31,  96,  43,  11,  40,  24,  30,  40,  38,  30,  64,
	 34,  33,  96,  54,  33,  96,  54,  20,  88,  38,  20,  80,  34,  48,  72,  31,
	 11,  40,  24,  20,  40,  27,  22,  33,  29,  29,  56,  33,  31,  72,  45,  19,
	 71,  34,  29,  72,  35,  20,  64,  32,  20,  48,  27,  11,  33,  18,  30,  40,
	 38,  20,  48,  27,  32,  64,  46,  20,  64,  32,  19,  71,  34,  29,  72,  35,
	 32,  64,  46,  20,  40,  27,  20,  40,  27,  20,  48,  27,  30,  64,  34,  20,
	 48,  27,  22,  33,  29,  30,  48,  39,  20,  56,  32,  19,  71,  34,  29,  72,
	 35,  29,  72,  35,  20,  64,  32,  11,  48,  24,  20,  40,  27,  21,  32,  19,
	 11,  48,  24,  20,  55,  46,  21,  32,  19,  20,  40,  27,  11,  40,  24,  32,
	 56,  45,  11,  40,  24,  20,  40,  27,  11,  40,  24,  29,  56,  33,  20,  64,
	 32,  29,  72,  35,  29,  72,  35,  20,  81,  44,  19,  71,  34,  19,  71,  34,
	 19,  71,  34,  29,  72,  35,  29,  72,  35,  32,  80,  46,  30,  80,  35,  29,
	 72,  35,  19,  71,  34,  31,  72,  45,  30,  80,  35,  32,  80,  46,  29,  72,
	 35,  30,  80,  35,  19,  71,  34,  19,  71,  34,  20,  64,  32,  20,  40,  27,
	 56,  57,  18,  89,  73,  22,  86,  87,  46,  29,  72,  35,  30,  64,  34,  29,
	 72,  35,  20,  80,  34,  60,  72,  31,  77,  57,  27,  20,  64,  32,  19,  71,
	 34,  46,  80,  45,  11,  40,  24,  55,  64,  59, 217, 225, 217, 248, 253, 245,
	248, 253, 245, 218, 230, 210, 248, 253, 245, 248, 253, 245, 177, 185, 180,  44,
	 56,  49,  29,  56,  33,  86, 104,  81,  60,  72,  31,  56,  57,  18,  31,  96,
	 43,  47,  88,  47,  48,  96,  63,  32,  64,  46,  55,  64,  59, 151, 153, 148,
	204, 207, 202, 194, 209, 190, 194, 209, 190, 180, 198, 180, 162, 191, 168,  97,
	136, 103,  46,  80,  45,  31,  72,  45,  60,  87,  43,  60,  87,  43,  46,  80,
	 45,  11,  48,  24,  49,  71,  62,  49,  71,  62,  29,  40,  26,  70,  73,  73,
	100, 113, 101, 112, 119, 110, 113, 137, 117, 127, 137, 126, 113, 137, 117,  85,
	122,  83,  49, 104,  69,  33, 104,  49,  33, 112,  50,  60, 120,  64,  46, 127,
	 65,  36, 120,  56,  28, 127,  58,  36, 120,  56,  46, 104,  55,  20,  48,  27,
	 21,  32,  19,  11,  56,  28,  48,  96,  63,  19,  95,  39,  20,  88,  38,  29,
	 72,  35,  31,  72,  45,  20,  40,  27,  11,  33,  18,  20,  40,  27,  29,  56,
	 33,  29,  72,  35,  29,  72,  35,  19,  71,  34,  30,  64,  34,  30,  48,  26,
	 12,  33,  29,  29,  40,  26,  11,  40,  24,  30,  64,  34,  20,  64,  32,  19,
	 71,  34,  30,  64,  34,  32,  64,  46,  11,  40,  24,  22,  33,  29,  20,  40,
	 27,  29,  56,  33,  11,  40,  24,  11,  33,  18,  20,  40,  27,  11,  48,  24,
	 20,  64,  32,  30,  64,  34,  20,  72,  45,  20,  64,  32,  20,  48,  36,  22,
	 33,  29,  20,  40,  27,  20,  48,  36,  11,  56,  28,  22,  33,  29,  20,  40,
	 36,  11,  48,  24,  32,  56,  45,  20,  40,  27,  21,  32,  19,  11,  33,  18,
	 20,  56,  32,  20,  64,  32,  20,  64,  32,  19,  71,  34,  29,  72,  35,  20,
	 80,  34,  32,  80,  46,  29,  72,  35,  19,  71,  34,  20,  64,  32,  29,  72,
	 35,  19,  71,  34,  30,  64,  34,  19,  71,  34,  29,  72,  35,  20,  64,  32,
	 20,  64,  32,  20,  64,  32,  30,  80,  35,  19,  71,  34,  19,  71,  34,  30,
	 64,  34,  21,  32,  19,  52,  46,  19,  92,  66,  32,  56,  57,  18,  44,  56,
	 28,  48,  72,  31,  31,  88,  42,  20,  80,  34,  56,  57,  18,  68,  56,  26,
	 29,  72,  35,  29,  72,  35,  46,  72,  47,  32,  64,  46,  30,  40,  38, 153,
	160, 148, 248, 253, 245, 248, 253, 245, 236, 253, 236, 227, 237, 221, 248, 253,
	245, 140, 148, 138,  56,  65,  29,  29,  56,  33,  72,  88,  39,  71,  80,  27,
	 89,  73,  22,  31,  88,  42,  46,  96,  49,  48,  96,  63,  30,  48,  39,  44,
	 48,  47, 127, 137, 126, 188, 190, 188, 177, 192, 178, 188, 200, 186, 194, 209,
	190, 151, 167, 151,  47,  88,  62,  32,  64,  46,  60,  87,  43,  46,  80,  45,
	 48,  72,  31,  60,  87,  43,  20,  40,  27,  32,  56,  45,  55,  64,  59,  29,
	 40,  26,  44,  48,  47,  60,  72,  66,  86,  93,  88, 112, 119, 110,  87, 105,
	 93,  87, 113,  96,  87, 113,  79,  47,  88,  47,  31,  96,  43,  46, 112,  58,
	 36, 120,  56,  46, 120,  63,  46, 127,  65,  36, 128,  63,  36, 120,  56,  33,
	112,  50,  20,  48,  27,  21,  32,  19,  20,  56,  32,  46,  96,  49,  33,  96,
	 54,  31,  88,  42,  20,  80,  34,  31,  72,  45,  11,  33,  18,  22,  33,  29,
	 20,  40,  27,  20,  48,  36,  30,  64,  34,  29,  72,  35,  29,  72,  35,  30,
	 64,  34,  20,  48,  36,  11,  40,  24,  30,  40,  38,  20,  48,  27,  30,  64,
	 34,  11,  56,  28,  20,  64,  32,  20,  56,  32,  29,  56,  33,  21,  32,  19,
	 22,  33,  29,  11,  40,  24,  30,  64,  34,  11,  48,  24,  21,  32,  19,  22,
	 33,  29,  29,  56,  33,  19,  71,  34,  30,  64,  34,  20,  64,  32,  19,  71,
	 34,  20,  56,  32,  20,  40,  27,  12,  33,  29,  20,  40,  27,  20,  56,  32,
	 21,  25,  22,  11,  40,  24,  20,  40,  27,  32,  56,  45,  11,  33,  18,  20,
	 40,  27,  11,  40,  24,  29,  56,  33,  20,  64,  32,  19,  71,  34,  29,  72,
	 35,  31,  72,  45,  32,  80,  46,  29,  72,  35,  20,  64,  32,  29,  72,  35,
	 32,  80,  46,  20,  64,  32,  11,  64,  29,  20,  64,  32,  29,  72,  35,  29,
	 72,  35,  19,  71,  34,  20,  64,  32,  29,  72,  35,  20,  64,  32,  19,  71,
	 34,  30,  64,  34,  20,  56,  32,  30,  48,  26,  30,  48,  26,  52,  50,  20,
	 29,  56,  33,  19,  71,  34,  29,  72,  35,  30,  80,  35,  20,  88,  38,  56,
	 65,  29,  68,  64,  28,  19,  71,  34,  31,  88,  42,  47,  88,  47,  44,  64,
	 50,  30,  40,  38,  86,  81,  76, 177, 177, 169, 244, 242, 236, 248, 253, 245,
	236, 239, 230, 164, 169, 156,  72,  80,  76,  30,  40,  38,  55,  55,  31,  60,
	 80,  38,  71,  80,  39,  71,  80,  27,  20,  80,  34,  47,  88,  47,  46,  80,
	 45,  30,  48,  39,  44,  41,  48,  54,  56,  58, 110, 113, 105, 151, 153, 148,
	166, 156, 156, 127, 137, 126,  88,  98,  92,  46,  72,  47,  29,  72,  35,  30,
	 80,  35,  47,  88,  47,  60,  96,  47,  60,  80,  38,  11,  33,  18,  44,  56,
	 49,  72,  80,  76,  21,  25,  22,  21,  25,  22,  22,  33,  29,  30,  40,  38,
	 54,  56,  58,  29,  40,  26,  44,  64,  50,  60, 104,  73,  46, 104,  55,  33,
	104,  49,  46, 127,  65,  46, 127,  65,  46, 127,  65,  46, 127,  65,  46, 127,
	 65,  36, 120,  56,  33, 104,  49,  11,  48,  24,  21,  25,  22,  20,  64,  32,
	 33,  96,  54,  31,  96,  43,  31,  96,  43,  20,  80,  34,  31,  72,  45,  20,
	 40,  27,  22,  33,  29,  20,  40,  27,  20,  48,  36,  30,  64,  34,  19,  71,
	 34,  20,  64,  32,  30,  64,  34,  20,  48,  27,  12,  33,  29,  22,  33,  29,
	 20,  40,  27,  30,  64,  34,  20,  64,  32,  29,  72,  35,  20,  64,  32,  32,
	 56,  45,  11,  40,  24,  30,  40,  38,  11,  40,  24,  31,  72,  45,  11,  40,
	 24,  11,  33,  18,  22,  33,  29,  20,  56,  32,  19,  71,  34,  20,  64,  32,
	 29,  72,  35,  19,  71,  34,  20,  56,  32,  11,  40,  24,  22,  33,  29,  20,
	 48,  27,  20,  56,  32,  21,  32,  19,  20,  40,  27,  11,  48,  24,  32,  56,
	 45,  21,  32,  19,  21,  32,  19,  11,  40,  24,  32,  56,  45,  19,  71,  34,
	 30,  64,  34,  19,  71,  34,  31,  72,  45,  29,  72,  35,  31,  72,  45,  19,
	 71,  34,  29,  72,  35,  32,  80,  46,  29,  72,  35,  19,  71,  34,  19,  71,
	 34,  30,  80,  35,  32,  80,  46,  29,  72,  35,  19,  71,  34,  31,  72,  45,
	 31,  72,  45,  20,  72,  45,  29,  72,  35,  20,  56,  32,  30,  48,  26,  37,
	 33,  13,  29,  40,  26,  30,  48,  26,  20,  64,  32,  29,  72,  35,  19,  71,
	 34,  20,  80,  34,  71,  71,  25,  79,  64,  30,  20,  80,  34,  31,  88,  42,
	 47,  88,  47,  46,  72,  47,  11,  33,  18,  10,  25,  17,  55,  64,  59,  88,
	 98,  92,  86, 104,  81,  86,  93,  88,  54,  56,  58,  21,  32,  19,  11,  40,
	 24,  55,  64,  59,  72,  88,  39,  71,  80,  27,  71,  80,  27,  31,  88,  42,
	 47,  88,  47,  48,  80,  62,  30,  48,  39,  10,  25,  17,  23,  16,  16,  38,
	 33,  34,  44,  48,  47,  68,  54,  60,  55,  55,  31,  29,  56,  33,  20,  56,
	 32,  29,  72,  35,  31,  88,  42,  46,  96,  49,  60,  96,  47,  46,  80,  45,
	 10,  25,  17,  30,  48,  26,  60,  80,  67,  44,  56,  28,  30,  40,  38,  38,
	 33,  34,  30,  40,  38,  38,  33,  34,  10,  25,  17,  32,  64,  46,  72, 112,
	 82,  60, 120,  64,  46, 120,  63,  47, 135,  70,  46, 127,  65,  46, 127,  65,
	 46, 127,  65,  47, 135,  70,  27, 120,  53,  46, 112,  58,  11,  40,  24,  21,
	 32,  19,  20,  64,  32,  46, 104,  55,  33,  96,  54,  20,  88,  38,  20,  80,
	 34,  32,  80,  46,  11,  40,  24,  22,  33,  29,  20,  40,  27,  29,  56,  33,
	 20,  64,  32,  19,  71,  34,  19,  71,  34,  20,  64,  32,  20,  48,  27,  11,
	 33,  18,  20,  40,  36,  20,  40,  27,  31,  72,  45,  20,  64,  32,  29,  72,
	 35,  20,  64,  32,  30,  64,  34,  11,  40,  24,  30,  40,  38,  20,  40,  27,
	 29,  72,  35,  11,  48,  24,  21,  32,  19,  22,  33,  29,  29,  56,  33,  19,
	 71,  34,  30,  64,  34,  19,  71,  34,  29,  72,  35,  20,  56,  32,  20,  40,
	 27,  21,  32,  19,  20,  40,  27,  30,  64,  34,  21,  32,  19,  20,  48,  36,
	 11,  40,  24,  32,  56,  45,  20,  40,  27,  20,  40,  27,  11,  33,  18,  20,
	 56,  32,  20,  64,  32,  20,  64,  32,  20,  64,  32,  29,  72,  35,  31,  72,
	 45,  19,  71,  34,  30,  64,  34,  31,  72,  45,  32,  80,  46,  30,  80,  35,
	 29,  72,  35,  31,  72,  45,  29,  72,  35,  19,  71,  34,  19,  71,  34,  29,
	 72,  35,  29,  72,  35,  29,  72,  35,  32,  80,  46,  19,  71,  34,  20,  56,
	 32,  20,  48,  27,  21,  32,  19,  21,  32,  19,  30,  48,  26,  20,  64,  32,
	 19,  71,  34,  29,  72,  35,  20,  88,  38,  70,  72,  39,  76,  66,  44,  31,
	 88,  42,  31,  96,  43,  46, 104,  55,  60,  96,  67,  48,  80,  62,  32,  56,
	 45,  30,  48,  26,  29,  56,  33,  44,  65,  31,  29,  56,  33,  30,  64,  34,
	 31,  72,  45,  48,  80,  62,  70, 104,  55,  70,  97,  49,  71,  80,  39,  72,
	 88,  39,  31,  88,  42,  46,  96,  49,  47,  88,  62,  60,  72,  66,  44,  56,
	 49,  44,  48,  47,  30,  40,  38,  21,  25,  22,  23,  16,  16,  30,  48,  39,
	 49,  71,  62,  46, 104,  55,  46, 112,  58,  60, 112,  53,  60, 112,  53,  60,
	 87,  43,  47,  88,  47,  11,  48,  24,  11,  40,  24,  44,  64,  50,  60,  72,
	 66,  55,  64,  59,  44,  48,  47,  54,  56,  58,  54,  49,  50,  32,  64,  46,
	 60,  96,  67,  81, 135,  95,  51, 128,  77,  36, 128,  63,  34, 135,  65,  46,
	127,  65,  46, 127,  65,  46, 127,  65,  46, 127,  65,  36, 128,  63,  46, 112,
	 58,  20,  48,  27,  22,  33,  29,  11,  64,  29,  46, 104,  55,  31,  96,  43,
	 31,  96,  43,  12,  80,  32,  31,  72,  45,  20,  40,  27,  20,  40,  27,  20,
	 40,  27,  29,  56,  33,  29,  72,  35,  19,  71,  34,  19,  71,  34,  20,  64,
	 32,  29,  56,  33,  11,  33,  18,  20,  40,  27,  20,  48,  36,  31,  72,  45,
	 11,  64,  29,  30,  80,  35,  20,  64,  32,  30,  64,  34,  11,  33,  18,  22,
	 33,  29,  11,  40,  24,  19,  71,  34,  11,  40,  24,  22,  33,  29,  20,  40,
	 27,  29,  56,  33,  20,  81,  44,  19,  71,  34,  29,  72,  35,  19,  71,  34,
	 20,  56,  32,  21,  32,  19,  12,  33,  29,  20,  48,  27,  20,  64,  32,  22,
	 33,  29,  20,  40,  27,  11,  40,  24,  29,  56,  33,  22,  33,  29,  20,  40,
	 27,  11,  33,  18,  20,  55,  46,  29,  72,  35,  20,  64,  32,  20,  64,  32,
	 19,  71,  34,  29,  72,  35,  19,  71,  34,  19,  71,  34,  19,  71,  34,  29,
	 72,  35,  19,  71,  34,  29,  72,  35,  19,  71,  34,  29,  72,  35,  19,  71,
	 34,  29,  72,  35,  29,  72,  35,  20,  72,  45,  29,  72,  35,  19,  71,  34,
	 29,  72,  35,  20,  56,  32,  20,  40,  27,  21,  32,  19,  21,  32,  19,  29,
	 56,  33,  20,  64,  32,  29,  72,  35,  20,  80,  34,  20,  88,  38,  60,  73,
	 46,  89,  73,  22,  31,  96,  43,  31,  96,  43,  46, 104,  55,  72, 112,  59,
	 73, 120,  87,  87, 121,  96,  87, 113,  79,  72, 112,  82,  72, 112,  82,  72,
	121,  71,  88, 128,  95,  88, 128,  95,  73, 120,  87,  73, 120,  87,  70,  97,
	 49,  71,  80,  27,  72,  88,  39,  31,  88,  42,  34,  88,  53,  47,  88,  62,
	 60,  96,  67,  72,  88,  78,  72,  88,  78,  60,  72,  66,  44,  56,  49,  22,
	 33,  29,  49,  71,  62,  73, 104,  81,  73, 120,  87,  68, 127,  72,  46, 120,
	 63,  46, 112,  58,  60,  96,  47,  60,  96,  67,  31,  72,  45,  20,  48,  27,
	 11,  48,  24,  30,  48,  26,  44,  56,  49,  30,  40,  38,  21,  25,  22,  30,
	 48,  26,  46,  72,  47,  72, 112,  82,  60, 127,  68,  46, 127,  65,  27, 120,
	 53,  44, 142,  72,  46, 120,  63,  46, 127,  65,  46, 127,  65,  47, 135,  70,
	 27, 120,  53,  46, 112,  58,  11,  56,  28,  38,  33,  34,  11,  64,  29,  49,
	104,  69,  33, 104,  49,  19,  95,  39,  12,  80,  32,  32,  80,  46,  11,  40,
	 24,  21,  32,  19,  20,  40,  27,  30,  64,  34,  31,  72,  45,  12,  80,  32,
	 19,  71,  34,  29,  72,  35,  20,  56,  32,  11,  33,  18,  20,  40,  27,  20,
	 48,  36,  31,  72,  45,  19,  71,  34,  19,  71,  34,  19,  71,  34,  32,  64,
	 46,  11,  40,  24,  21,  32,  19,  11,  40,  24,  19,  71,  34,  11,  48,  24,
	 11,  33,  18,  21,  32,  19,  30,  64,  34,  20,  81,  44,  19,  71,  34,  30,
	 80,  35,  19,  71,  34,  20,  56,  32,  21,  32,  19,  12,  33,  29,  20,  48,
	 27,  20,  64,  32,  21,  32,  19,  11,  33,  18,  11,  40,  24,  32,  56,  45,
	 11,  40,  24,  21,  32,  19,  11,  40,  24,  32,  56,  45,  19,  71,  34,  20,
	 64,  32,  20,  64,  32,  19,  71,  34,  19,  71,  34,  20,  64,  32,  29,  72,
	 35,  29,  72,  35,  19,  71,  34,  20,  64,  32,  19,  71,  34,  29,  72,  35,
	 19,  71,  34,  20,  64,  32,  19,  71,  34,  32,  80,  46,  29,  72,  35,  29,
	 72,  35,  19,  71,  34,  29,  72,  35,  20,  56,  32,  11,  48,  24,  20,  40,
	 27,  29,  40,  26,  29,  56,  33,  19,  71,  34,  31,  72,  45,  20,  80,  34,
	 20,  80,  34,  60,  72,  31,  68,  66,  52,  31,  88,  42,  20,  80,  34,  30,
	 80,  35,  31,  88,  42,  48,  96,  63,  60, 104,  73,  60, 104,  73,  60, 104,
	 53,  48,  96,  63,  60, 104,  73,  47, 112,  69,  47, 112,  69,  46, 112,  58,
	 49, 104,  69,  47,  88,  47,  71,  80,  27,  86,  95,  42,  31,  96,  43,  30,
	 80,  35,  31,  72,  45,  31,  72,  45,  46,  72,  47,  49,  71,  62,  29,  56,
	 33,  20,  40,  27,  29,  40,  26,  48,  72,  31,  48,  96,  63,  47, 112,  69,
	 46, 112,  58,  33, 104,  49,  33, 104,  49,  70,  97,  49,  46,  96,  49,  48,
	 80,  62,  32,  80,  46,  11,  64,  29,  11,  33,  18,  11,  33,  18,  20,  40,
	 27,  11,  40,  24,  30,  64,  34,  49, 104,  69,  60, 120,  64,  46, 120,  63,
	 33, 112,  50,  33, 112,  50,  47, 135,  70,  46, 127,  65,  46, 127,  65,  46,
	127,  65,  46, 127,  65,  36, 120,  56,  33, 112,  50,  11,  40,  24,  21,  32,
	 19,  11,  64,  29,  46, 112,  58,  33, 112,  50,  19,  95,  39,  10,  87,  42,
	 32,  80,  46,  11,  48,  24,  11,  40,  24,  11,  33,  18,  20,  64,  32,  30,
	 80,  35,  20,  80,  34,  12,  80,  32,  19,  71,  34,  20,  56,  32,  11,  33,
	 18,  20,  40,  27,  11,  48,  24,  32,  80,  46,  19,  71,  34,  20,  80,  34,
	 30,  80,  35,  31,  72,  45,  11,  48,  24,  21,  32,  19,  11,  48,  24,  31,
	 72,  45,  11,  48,  24,  11,  33,  18,  11,  33,  18,  20,  56,  32,  20,  80,
	 34,  20,  72,  45,  30,  80,  35,  29,  72,  35,  20,  56,  32,  21,  32,  19,
	 12,  33,  29,  20,  48,  27,  19,  71,  34,  21,  32,  19,  11,  33,  18,  11,
	 40,  24,  32,  56,  45,  20,  40,  27,  22,  33,  29,  11,  33,  18,  32,  64,
	 46,  19,  71,  34,  19,  71,  34,  19,  71,  34,  29,  72,  35,  29,  72,  35,
	 29,  72,  35,  19,  71,  34,  29,  72,  35,  19,  71,  34,  29,  72,  35,  19,
	 71,  34,  31,  72,  45,  29,  72,  35,  19,  71,  34,  29,  72,  35,  30,  80,
	 35,  31,  72,  45,  29,  72,  35,  29,  72,  35,  19,  71,  34,  20,  64,  32,
	 11,  40,  24,  20,  40,  27,  22,  33,  29,  29,  56,  33,  19,  71,  34,  32,
	 80,  46,  20,  80,  34,  20,  80,  34,  56,  65,  29,  68,  56,  26,  20,  80,
	 34,  19,  71,  34,  20,  81,  44,  32,  80,  46,  19,  71,  34,  29,  72,  35,
	 19,  71,  34,  29,  72,  35,  19,  71,  34,  19,  71,  34,  30,  80,  35,  31,
	 88,  42,  34,  88,  53,  31,  88,  42,  46,  80,  45,  60,  72,  31,  71,  80,
	 27,  46, 104,  55,  33,  96,  54,  19,  71,  34,  20,  56,  32,  20,  56,  32,
	 20,  56,  32,  20,  40,  27,  11,  33,  18,  32,  64,  46,  46,  80,  45,  48,
	 96,  63,  33,  96,  54,  31,  96,  43,  31,  96,  43,  46,  96,  49,  46,  96,
	 49,  30,  80,  35,  47,  88,  47,  48,  96,  63,  33,  96,  54,  31,  88,  42,
	 19,  71,  34,  32,  64,  46,  49, 104,  69,  48,  96,  63,  73, 128,  87,  49,
	119,  77,  33, 104,  49,  33, 112,  50,  33, 112,  50,  36, 120,  56,  46, 127,
	 65,  46, 127,  65,  36, 128,  63,  36, 128,  63,  27, 120,  53,  33, 104,  49,
	 11,  40,  24,  21,  25,  22,  19,  71,  34,  46, 112,  58,  33, 112,  50,  33,
	104,  49,  20,  88,  38,  34,  88,  53,  11,  48,  24,  21,  32,  19,  20,  40,
	 27,  30,  64,  34,  32,  80,  46,  10,  87,  42,  20,  88,  38,  32,  80,  46,
	 30,  64,  34,  11,  33,  18,  11,  40,  24,  20,  56,  32,  32,  80,  46,  19,
	 71,  34,  31,  88,  42,  32,  80,  46,  32,  80,  46,  11,  40,  24,  20,  40,
	 27,  11,  48,  24,  30,  80,  35,  20,  56,  32,  11,  33,  18,  21,  32,  19,
	 20,  64,  32,  31,  88,  42,  20,  81,  44,  31,  88,  42,  30,  80,  35,  29,
	 56,  33,  20,  40,  27,  12,  33,  29,  20,  48,  36,  31,  72,  45,  11,  33,
	 18,  20,  40,  27,  11,  40,  24,  32,  64,  46,  20,  40,  27,  11,  33,  18,
	 11,  33,  18,  31,  72,  45,  29,  72,  35,  19,  71,  34,  30,  80,  35,  30,
	 80,  35,  32,  80,  46,  30,  80,  35,  30,  80,  35,  32,  80,  46,  32,  80,
	 46,  29,  72,  35,  19,  71,  34,  29,  72,  35,  29,  72,  35,  19,  71,  34,
	 29,  72,  35,  31,  72,  45,  29,  72,  35,  29,  72,  35,  29,  72,  35,  19,
	 71,  34,  20,  64,  32,  11,  48,  24,  20,  40,  27,  22,  33,  29,  29,  56,
	 33,  19,  71,  34,  32,  80,  46,  20,  81,  44,  20,  80,  34,  56,  65,  29,
	 56,  65,  29,  20,  80,  34,  30,  80,  35,  29,  72,  35,  32,  80,  46,  30,
	 80,  35,  19,  71,  34,  29,  72,  35,  29,  72,  35,  30,  80,  35,  29,  72,
	 35,  32,  80,  46,  20,  88,  38,  31,  88,  42,  33,  96,  54,  48,  72,  31,
	 48,  72,  31,  71,  71,  25,  46, 104,  55,  31,  96,  43,  34,  88,  53,  19,
	 71,  34,  31,  72,  45,  32,  64,  46,  31,  72,  45,  29,  56,  33,  31,  72,
	 45,  32,  80,  46,  34,  88,  53,  20,  88,  38,  20,  88,  38,  20,  88,  38,
	 31,  88,  42,  60,  80,  38,  31,  72,  45,  31,  88,  42,  46,  96,  49,  46,
	120,  63,  73, 128,  87,  73, 120,  87,  48,  96,  63,  73, 128,  87,  46, 112,
	 58,  46, 120,  63,  19,  95,  39,  19,  95,  39,  33, 112,  50,  33, 112,  50,
	 46, 112,  58,  36, 120,  56,  46, 120,  63,  36, 120,  69,  46, 127,  65,  36,
	120,  56,  33, 104,  49,  11,  48,  24,  21,  32,  19,  19,  71,  34,  46, 120,
	 63,  35, 112,  61,  33, 112,  50,  19,  95,  39,  31,  96,  43,  20,  48,  27,
	 11,  40,  24,  20,  40,  27,  31,  72,  45,  34,  88,  53,  19,  95,  39,  31,
	 96,  43,  34,  88,  53,  29,  72,  35,  20,  40,  27,  11,  40,  24,  29,  56,
	 33,  34,  88,  53,  20,  88,  38,  31,  88,  42,  32,  80,  46,  32,  80,  46,
	 11,  40,  24,  21,  32,  19,  11,  48,  24,  47,  88,  47,  20,  56,  32,  11,
	 33,  18,  11,  33,  18,  32,  64,  46,  33,  96,  54,  32,  80,  46,  31,  88,
	 42,  32,  80,  46,  29,  56,  33,  20,  40,  27,  22,  33,  29,  20,  56,  32,
	 30,  80,  35,  22,  33,  29,  20,  40,  27,  20,  48,  36,  44,  64,  50,  20,
	 40,  27,  21,  25,  22,  11,  40,  24,  32,  64,  46,  30,  80,  35,  30,  80,
	 35,  30,  80,  35,  34,  88,  53,  31,  88,  42,  32,  80,  46,  32,  80,  46,
	 30,  80,  35,  32,  80,  46,  29,  72,  35,  29,  72,  35,  19,  71,  34,  31,
	 72,  45,  19,  71,  34,  20,  64,  32,  20,  64,  32,  30,  64,  34,  19,  71,
	 34,  19,  71,  34,  30,  80,  35,  30,  64,  34,  11,  48,  24,  21,  32,  19,
	 20,  40,  36,  29,  56,  33,  32,  80,  46,  34,  88,  53,  31,  88,  42,  20,
	 88,  38,  56,  65,  29,  68,  64,  28,  31,  88,  42,  32,  80,  46,  32,  64,
	 46,  11,  56,  28,  20,  64,  32,  32,  80,  46,  20,  64,  32,  20,  64,  32,
	 20,  64,  32,  20,  64,  32,  32,  80,  46,  20,  81,  44,  20,  81,  44,  31,
	 88,  42,  48,  72,  31,  48,  72,  31,  90,  88,  32,  31,  88,  42,  34,  88,
	 53,  31,  88,  42,  32,  80,  46,  32,  80,  46,  31,  72,  45,  48,  72,  31,
	 30,  64,  34,  30,  64,  34,  29,  72,  35,  20,  80,  34,  20,  88,  38,  31,
	 96,  43,  46, 104,  55,  46, 104,  55,  60,  87,  43,  30,  80,  35,  19,  71,
	 34,  20,  80,  34,  33, 112,  50,  46, 112,  58,  46, 104,  55,  49, 119,  77,
	 60, 112,  53,  47, 112,  69,  46,  96,  49,  31,  88,  42,  31,  96,  43,  31,
	 96,  43,  46, 104,  55,  46, 112,  58,  33, 104,  49,  46, 112,  58,  33, 112,
	 50,  46, 112,  58,  49, 119,  77,  46, 104,  55,  20,  64,  32,  11,  40,  24,
	 11,  64,  29,  51, 128,  77,  36, 120,  56,   8, 112,  48,  36, 120,  56,  20,
	 88,  38,  32,  64,  46,  11,  33,  18,  21,  32,  19,  20,  81,  44,  20, 104,
	 44,  36, 120,  56,  33, 112,  50,  20, 104,  44,  32,  80,  46,  21,  32,  19,
	 22,  33,  29,  11,  64,  29,  35, 104,  60,  33, 104,  49,  33, 104,  49,  20,
	111,  48,  33, 104,  49,  20,  48,  27,  22,  33,  29,  20,  48,  27,  31,  96,
	 43,  20,  56,  32,  21,  32,  19,  21,  32,  19,  34,  88,  53,  33, 112,  50,
	 33, 112,  50,  33, 104,  49,  33, 104,  49,  30,  80,  35,  11,  40,  24,  21,
	 32,  19,  20,  56,  32,  31,  88,  42,  11,  40,  24,  21,  32,  19,  20,  48,
	 27,  32,  80,  46,  11,  56,  28,  21,  32,  19,  20,  40,  27,  20,  81,  44,
	 20,  88,  38,  20,  88,  38,  31,  96,  43,  31,  96,  43,  33, 104,  49,  31,
	 96,  43,  31,  88,  42,  20,  80,  34,  10,  87,  42,  12,  80,  32,  12,  80,
	 32,  32,  80,  46,  31,  72,  45,  31,  72,  45,  30,  64,  34,  29,  72,  35,
	 31,  72,  45,  29,  72,  35,  19,  71,  34,  30,  80,  35,  19,  71,  34,  11,
	 40,  24,  10,  25,  17,  21,  25,  22,  30,  64,  34,  34,  88,  53,  31,  88,
	 42,  19,  95,  39,  33, 112,  50,  60,  80,  38,  71,  71,  25,  31,  88,  42,
	 31,  96,  43,  30,  80,  35,  48,  96,  63,  32,  80,  46,  30,  64,  34,  31,
	 72,  45,  72,  96,  77,  60,  87,  43,  60,  88,  68,  72,  88,  78,  30,  64,
	 34,  47,  88,  62,  31,  88,  42,  46,  80,  45,  60,  72,  31,  56,  57,  18,
	 31,  88,  42,  33,  96,  54,  31,  88,  42,  19,  71,  34,  32,  80,  46,  31,
	 72,  45,  49,  71,  62,  44,  56,  49,  29,  72,  35,  47,  88,  62,  60,  96,
	 67,  30,  80,  35,  20,  80,  34,  31,  96,  43,  31,  88,  42,  52,  46,  19,
	 29,  40,  26,  21,  32,  19,  30,  48,  39,  32,  56,  45,  32,  64,  46,  32,
	 56,  45,  32,  56,  45,  30,  48,  39,  32,  56,  45,  30,  48,  39,  30,  40,
	 38,  32,  56,  45,  55,  64,  59,  32,  64,  46,  46,  72,  47,  32,  56,  45,
	 32,  56,  45,  20,  56,  32,  20,  56,  32,  32,  64,  46,  30,  48,  39,  22,
	 33,  29,  21,  25,  22,  11,  64,  29,  46, 112,  58,  46, 120,  63,  33, 112,
	 50,  33, 112,  50,  46,  96,  49,  29,  56,  33,  21,  25,  22,  11,  33,  18,
	 31,  88,  42,  33, 112,  50,  33, 112,  50,  33, 112,  50,  20, 111,  48,  34,
	 88,  53,  22,  33,  29,  29,  40,  26,  11,  64,  29,  46, 120,  63,  33, 112,
	 50,  46, 112,  58,  27, 120,  53,  33, 112,  50,  29,  56,  33,  21,  32,  19,
	 11,  48,  24,  46,  96,  49,  20,  64,  32,  11,  33,  18,  29,  40,  26,  47,
	 88,  47,  36, 120,  56,  33, 112,  50,  33, 104,  49,  20, 111,  48,  32,  80,
	 46,  20,  40,  27,  22,  33,  29,  30,  64,  34,  31,  88,  42,  11,  40,  24,
	 21,  32,  19,  20,  48,  27,  47,  88,  62,  11,  48,  24,  21,  32,  19,  20,
	 40,  27,  31,  88,  42,  31,  88,  42,  31,  96,  43,  33, 104,  49,  33, 112,
	 50,  33, 104,  49,  33, 104,  49,  31,  96,  43,  31,  88,  42,  31,  96,  43,
	 19,  71,  34,  11,  56,  28,  31,  72,  45,  73, 104,  81, 113, 137, 117, 129,
	149, 131, 140, 158, 140, 100, 129, 107,  72, 112,  82,  30,  80,  35,  20,  64,
	 32,  30,  64,  34,  30,  48,  26,  21,  32,  19,  22,  33,  29,  30,  64,  34,
	 31,  96,  43,  31,  96,  43,  33, 112,  50,  33, 112,  50,  60,  80,  38,  84,
	 78,  28,  31,  88,  42,  31,  96,  43,  33,  96,  54,  30,  80,  35,  29,  72,
	 35,  72,  96,  77,  72,  96,  77,  60,  80,  67,  46,  72,  47,  49,  71,  62,
	100, 118, 100,  87, 113,  96,  72, 121,  71,  30,  80,  35,  30,  80,  35,  72,
	 88,  39,  84,  78,  28,  20,  80,  34,  20,  80,  34,  19,  71,  34,  20,  80,
	 34,  47,  88,  47,  60,  88,  68,  46,  72,  47,  22,  33,  29,  21,  32,  19,
	 29,  40,  26,  55,  64,  59,  60,  72,  66,  46,  72,  47,  29,  72,  35,  30,
	 64,  34,  37,  33,  13,  37,  33,  13,  21,  32,  19,  22,  33,  29,  30,  48,
	 39,  20,  40,  36,  12,  33,  29,  21,  32,  19,  12,  33,  29,  30,  48,  39,
	 30,  40,  38,  10,  25,  17,  12,  33,  29,  22,  33,  29,  12,  33,  29,  12,
	 33,  29,  21,  32,  19,  29,  40,  26,  11,  33,  18,  11,  33,  18,  11,  40,
	 24,  12,  33,  29,  10,  25,  17,  21,  25,  22,  31,  96,  43,  46, 120,  63,
	 46, 127,  65,  20, 111,  48,  36, 120,  56,  46, 112,  58,  29,  56,  33,  11,
	 40,  24,  21,  32,  19,  33,  96,  54,  27, 120,  53,  36, 120,  56,  33, 112,
	 50,  33, 104,  49,  31,  88,  42,  21,  32,  19,  22,  33,  29,  19,  71,  34,
	 35, 112,  61,  46, 112,  58,  36, 120,  56,  27, 120,  53,  33, 104,  49,  20,
	 48,  27,  21,  32,  19,  11,  48,  24,  46, 104,  55,  20,  64,  32,  11,  33,
	 18,  20,  40,  36,  34,  88,  53,  36, 128,  63,  33, 104,  49,  33, 112,  50,
	 33, 104,  49,  31,  88,  42,  11,  40,  24,  11,  33,  18,  20,  56,  32,  34,
	 88,  53,  11,  48,  24,  21,  32,  19,  30,  48,  26,  34,  88,  53,  11,  48,
	 24,  22,  33,  29,  20,  40,  27,  20,  88,  38,  31,  96,  43,  33,  96,  54,
	 33, 104,  49,  46, 104,  55,  35, 104,  60,  46, 104,  55,  31,  88,  42,  31,
	 88,  42,  29,  72,  35,  31,  72,  45,  48,  80,  62,  86, 104,  81, 127, 137,
	126, 148, 145, 137, 151, 153, 148, 148, 145, 137, 164, 178, 164, 129, 149, 131,
	 72, 112,  59,  31,  72,  45,  29,  72,  35,  20,  48,  27,  20,  40,  27,  22,
	 33,  29,  31,  72,  45,  33, 104,  49,  33, 104,  49,  33, 112,  50,  33, 112,
	 50,  71,  80,  27,  79,  64,  30,  47,  88,  47,  12,  80,  32,  31,  96,  43,
	 47,  88,  47,  47,  88,  62,  60,  88,  68,  30,  48,  39,  20,  40,  27,  44,
	 48,  47,  10,  25,  17,  22,  33,  29,  32,  56,  45,  87, 113,  96,  88, 128,
	 95,  60,  87,  43,  44,  56,  28,  56,  57,  18,  31,  88,  42,  11,  64,  29,
	 20,  80,  34,  47,  88,  62,  20,  56,  32,  11,  33,  18,  21,  32,  19,  44,
	 56,  49,  44,  56,  49,  30,  40,  38,  21,  25,  22,  21,  32,  19,  32,  56,
	 45,  29,  56,  33,  10,  25,  17,  48,  72,  31,  44,  65,  31,  30,  64,  34,
	 30,  80,  35,  34,  88,  53,  30,  80,  35,  31,  72,  45,  46, 104,  55,  81,
	135,  95,  95, 152, 108, 111, 149, 119,  73, 128,  87,  46,  96,  49,  31,  88,
	 42,  31,  88,  42,  46, 104,  55,  30,  80,  35,  30,  80,  35,  31,  88,  42,
	 20,  80,  34,  31,  88,  42,  30,  80,  35,  20,  80,  34,  20,  80,  34,  27,
	120,  53,  27, 120,  53,  34, 135,  65,   8, 112,  48,  27, 120,  53,  36, 120,
	 56,  11,  64,  29,  11,  33,  18,  11,  33,  18,  35, 104,  60,  36, 128,  63,
	 46, 112,  58,  33, 112,  50,  33, 112,  50,  33,  96,  54,  20,  40,  27,  21,
	 32,  19,  11,  64,  29,  36, 120,  56,  33, 112,  50,  36, 120,  56,  27, 120,
	 53,  33, 112,  50,  11,  48,  24,  11,  33,  18,  11,  56,  28,  46, 104,  55,
	 19,  71,  34,  11,  33,  18,  11,  33,  18,  31,  88,  42,  36, 128,  63,  33,
	112,  50,  33, 112,  50,  33, 112,  50,  30,  80,  35,  11,  40,  24,  10,  25,
	 17,  30,  64,  34,  33,  96,  54,  11,  40,  24,  29,  40,  26,  30,  48,  26,
	 32,  80,  46,  11,  56,  28,  21,  32,  19,  20,  40,  27,  31,  88,  42,  31,
	 88,  42,  31,  96,  43,  33,  96,  54,  33, 104,  49,  33, 104,  49,  31,  96,
	 43,  31,  88,  42,  30,  80,  35,  30,  64,  34,  46,  72,  47,  60,  80,  67,
	 72,  80,  76,  68,  65,  70,  68,  54,  60,  72,  80,  76, 112, 104,  84, 140,
	148, 138, 127, 137, 126, 100, 118, 100,  47,  88,  47,  30,  64,  34,  11,  48,
	 24,  21,  32,  19,  22,  33,  29,  29,  72,  35,  33, 104,  49,  33, 104,  49,
	 36, 120,  56,  36, 120,  56,  60,  80,  38,  79,  64,  30,  31,  88,  42,  31,
	 96,  43,  31,  96,  43,  48,  96,  63,  49,  71,  62,  22,  33,  29,  72,  80,
	 76, 153, 160, 148, 177, 185, 180, 151, 153, 148,  70,  73,  73,  21,  25,  22,
	 44,  64,  50,  72, 112,  82,  47,  88,  47,  44,  56,  28,  56,  65,  29,  29,
	 72,  35,  11,  64,  29,  46,  80,  45,  60,  96,  67,  30,  48,  26,  32,  64,
	 46, 100, 113, 101, 151, 167, 151, 148, 184, 172, 129, 149, 131,  73, 104,  81,
	 32,  56,  45,  34,  88,  53,  60, 112,  73,  34,  88,  53,  70, 104,  55,  30,
	 80,  35,  20,  80,  34,  46, 104,  55,  46, 112,  58,  31,  96,  43,  46, 104,
	 55,  95, 152, 108, 108, 162, 116, 104, 174, 128, 108, 162, 116,  95, 142, 103,
	 73, 128,  87,  33, 104,  49,  33,  96,  54,  46, 120,  63,  46, 104,  55,  60,
	112,  53,  46, 104,  55,  46, 112,  58,  46, 120,  63,  46, 112,  58,  33, 104,
	 49,  46, 104,  55,  46, 120,  63,  33, 112,  50,  36, 120,  56,  20, 104,  44,
	 33, 112,  50,  47, 112,  69,  11,  64,  29,  11,  48,  24,  11,  33,  18,  33,
	104,  49,  36, 128,  63,  46, 120,  63,  33, 112,  50,  33, 112,  50,  33,  96,
	 54,  20,  40,  27,  21,  32,  19,  20,  72,  45,  27, 120,  53,  46, 120,  63,
	 46, 120,  63,  28, 127,  58,  35, 112,  61,  20,  56,  32,  20,  40,  27,  11,
	 56,  28,  46, 112,  58,  19,  71,  34,  11,  33,  18,  11,  40,  24,  34,  88,
	 53,  36, 128,  63,  33, 112,  50,  36, 120,  56,  33, 112,  50,  31,  88,  42,
	 20,  40,  27,  11,  33,  18,  20,  56,  32,  33,  96,  54,  11,  48,  24,  20,
	 40,  27,  30,  48,  26,  34,  88,  53,  11,  48,  24,  22,  33,  29,  20,  40,
	 27,  30,  80,  35,  20,  88,  38,  31,  88,  42,  31,  88,  42,  31,  96,  43,
	 33,  96,  54,  31,  96,  43,  31,  88,  42,  30,  80,  35,  32,  80,  46,  46,
	 80,  45,  48,  80,  62,  55,  64,  59,  54,  49,  50,  30,  40,  38,  54,  56,
	 58,  72,  80,  76,  68,  65,  70,  86,  93,  88,  68,  88,  54,  46,  80,  45,
	 30,  64,  34,  11,  48,  24,  11,  33,  18,  29,  40,  26,  19,  71,  34,  35,
	104,  60,  33, 112,  50,  36, 120,  56,  36, 120,  56,  48,  72,  31,  71,  71,
	 25,  47,  88,  47,  31,  96,  43,  46, 104,  55,  46,  80,  45,  20,  40,  27,
	 72,  80,  76, 204, 207, 202, 248, 253, 245, 248, 253, 245, 248, 253, 245, 212,
	216, 210, 108, 105, 104,  21,  32,  19,  32,  56,  45,  60,  87,  43,  60,  80,
	 38,  56,  65,  29,  20,  64,  32,  31,  72,  45,  46,  80,  45,  30,  64,  34,
	 30,  48,  39, 140, 158, 140, 188, 200, 186, 188, 200, 186, 162, 191, 168, 175,
	207, 177, 140, 168, 148,  60,  96,  67,  31,  72,  45,  46,  96,  49,  46,  96,
	 49,  60,  73,  46,  30,  48,  26,  11,  40,  24,  32,  64,  46,  49,  71,  62,
	 20,  55,  46,  49,  71,  62, 113, 137, 117, 100, 129, 107,  87, 113,  96,  73,
	104,  81,  87, 121,  96,  87, 113,  96,  48,  80,  62,  20,  55,  46,  32,  64,
	 46,  32,  56,  45,  32,  64,  46,  29,  56,  33,  20,  56,  32,  32,  56,  45,
	 32,  64,  46,  32,  64,  46,  31,  72,  45,  49,  71,  62,  31,  72,  45,  46,
	 72,  47,  30,  64,  34,  46,  72,  47,  60,  72,  66,  30,  48,  39,  30,  40,
	 38,  11,  40,  24,  35, 104,  60,  36, 120,  56,  46, 112,  58,  33, 104,  49,
	 20, 111,  48,  31,  96,  43,  20,  40,  27,  29,  40,  26,  20,  72,  45,  36,
	120,  56,  46, 120,  63,  36, 120,  56,  28, 127,  58,  46, 120,  63,  29,  56,
	 33,  20,  40,  27,  11,  56,  28,  46, 112,  58,  32,  80,  46,  11,  40,  24,
	 20,  40,  27,  46,  96,  49,  34, 135,  65,  46, 120,  63,  36, 120,  56,  36,
	120,  56,  33,  96,  54,  20,  48,  27,  22,  33,  29,  32,  64,  46,  33,  96,
	 54,  11,  48,  24,  20,  40,  27,  30,  48,  26,  32,  80,  46,  11,  48,  24,
	 21,  25,  22,  21,  32,  19,  30,  80,  35,  32,  80,  46,  20,  88,  38,  31,
	 88,  42,  31,  96,  43,  33,  96,  54,  31,  96,  43,  31,  88,  42,  32,  80,
	 46,  34,  88,  53,  31,  72,  45,  44,  64,  50,  72,  88,  78,  88,  98,  92,
	 72,  80,  76,  55,  64,  59,  44,  48,  47,  44,  48,  20,  54,  56,  58,  30,
	 64,  34,  31,  72,  45,  31,  72,  45,  29,  56,  33,  11,  40,  24,  22,  33,
	 29,  32,  80,  46,  35, 112,  61,  33, 112,  50,  46, 127,  65,  36, 128,  63,
	 48,  72,  31,  71,  71,  25,  31,  96,  43,  31,  96,  43,  46, 104,  55,  20,
	 56,  32,  30,  48,  39, 177, 185, 180, 248, 253, 245, 236, 239, 230, 212, 216,
	210, 212, 216, 210, 236, 239, 230, 177, 177, 169,  44,  48,  47,  29,  56,  33,
	 60,  88,  68,  60,  72,  31,  44,  42,  26,  19,  71,  34,  46,  80,  45,  31,
	 72,  45,  20,  40,  27,  29,  56,  33, 152, 176, 159, 177, 192, 178, 151, 167,
	151, 153, 160, 148, 177, 177, 169, 177, 177, 169, 110, 113, 105,  29,  56,  33,
	 30,  64,  34,  48,  72,  31,  44,  48,  20,  20,  40,  27,  11,  33,  18,  20,
	 48,  27,  20,  48,  36,  11,  40,  24,  44,  64,  50,  87, 113,  96, 100, 104,
	101,  88,  98,  92,  72,  88,  78,  88,  98,  92,  86,  93,  88,  44,  64,  50,
	 11,  40,  24,  11,  40,  24,  20,  40,  27,  20,  40,  27,  12,  33,  29,  10,
	 25,  17,  12,  33,  29,  11,  40,  24,  12,  33,  29,  20,  40,  27,  20,  48,
	 27,  29,  40,  26,  11,  33,  18,  20,  40,  27,  20,  40,  27,  20,  40,  27,
	 29,  40,  26,  11,  33,  18,  30,  64,  34,  35, 104,  60,  33, 112,  50,  33,
	112,  50,  33, 104,  49,  20, 104,  44,  20,  88,  38,  20,  48,  27,  29,  40,
	 26,  11,  64,  29,  35, 112,  61,  33, 112,  50,  33, 112,  50,  27, 120,  53,
	 46, 112,  58,  20,  56,  32,  20,  40,  27,  20,  56,  32,  46, 112,  58,  19,
	 71,  34,  11,  33,  18,  20,  40,  36,  33,  96,  54,  36, 128,  63,  46, 112,
	 58,  27, 120,  53,  36, 120,  56,  33,  96,  54,  29,  56,  33,  20,  40,  27,
	 31,  72,  45,  31,  96,  43,  20,  48,  36,  20,  40,  27,  20,  56,  32,  34,
	 88,  53,  11,  48,  24,  22,  33,  29,  20,  40,  27,  30,  80,  35,  31,  88,
	 42,  31,  88,  42,  33,  96,  54,  33,  96,  54,  33,  96,  54,  34,  88,  53,
	 34,  88,  53,  30,  80,  35,  33,  96,  54,  11,  64,  29,  20,  40,  36,  44,
	 48,  47,  70,  73,  73,  68,  65,  70,  30,  40,  38,  20,  40,  27,  44,  48,
	 47,  32,  56,  45,  32,  56,  45,  31,  72,  45,  46,  80,  45,  30,  64,  34,
	 11,  40,  24,  22,  33,  29,  32,  80,  46,  35, 104,  60,  36, 120,  56,  46,
	127,  65,  36, 128,  63,  48,  72,  31,  71,  71,  25,  46, 104,  55,  60, 112,
	 53,  46, 112,  58,  29,  56,  33,  30,  48,  39, 212, 216, 210, 236, 239, 230,
	218, 230, 210, 227, 237, 221, 217, 225, 217, 227, 237, 221, 177, 177, 169,  32,
	 56,  45,  29,  56,  33,  48,  72,  31,  44,  65,  31,  56,  57,  18,  20,  64,
	 32,  31,  72,  45,  32,  64,  46,  32,  56,  45,  49,  71,  62, 152, 176, 159,
	152, 176, 159, 162, 191, 168, 153, 160, 148, 151, 153, 148, 153, 160, 148, 100,
	113, 101,  29,  56,  33,  20,  48,  27,  44,  56,  28,  48,  72,  31,  29,  72,
	 35,  29,  72,  35,  19,  71,  34,  30,  80,  35,  30,  80,  35,  48,  96,  63,
	 97, 136, 103,  88, 128,  95,  97, 136, 103, 100, 129, 107,  87, 121,  96,  72,
	112,  82,  47,  88,  47,  29,  72,  35,  31,  72,  45,  29,  72,  35,  31,  72,
	 45,  30,  64,  34,  30,  64,  34,  31,  72,  45,  31,  72,  45,  30,  64,  34,
	 19,  71,  34,  31,  72,  45,  31,  72,  45,  11,  64,  29,  31,  72,  45,  20,
	 64,  32,  11,  64,  29,  31,  88,  42,  20,  64,  32,  31,  72,  45,  35, 112,
	 61,  20, 111,  48,  31,  96,  43,  19,  95,  39,  19,  95,  39,  20,  88,  38,
	 30,  48,  26,  30,  40,  38,  20,  72,  45,  46, 112,  58,  33, 104,  49,  46,
	112,  58,  36, 120,  56,  46, 112,  58,  30,  64,  34,  30,  40,  38,  11,  56,
	 28,  46, 104,  55,  20,  64,  32,  11,  33,  18,  21,  32,  19,  30,  80,  35,
	 27, 120,  53,  33, 112,  50,  33, 112,  50,  33, 112,  50,  34,  88,  53,  20,
	 56,  32,  20,  40,  36,  31,  72,  45,  20,  88,  38,  20,  55,  46,  20,  40,
	 27,  29,  56,  33,  34,  88,  53,  11,  48,  24,  21,  25,  22,  20,  40,  27,
	 32,  80,  46,  31,  88,  42,  31,  88,  42,  31,  88,  42,  33,  96,  54,  31,
	 96,  43,  34,  88,  53,  31,  88,  42,  32,  80,  46,  47,  88,  62,  32,  64,
	 46,  30,  40,  38,  44,  42,  26,  38,  33,  34,  38,  33,  34,  21,  25,  22,
	 22,  33,  29,  30,  40,  38,  29,  40,  26,  29,  56,  33,  46,  72,  47,  32,
	 80,  46,  29,  56,  33,  20,  40,  27,  30,  48,  39,  29,  72,  35,  33, 104,
	 49,  33, 112,  50,  36, 128,  63,  28, 127,  58,  48,  72,  31,  71,  71,  25,
	 33, 104,  49,  33, 104,  49,  60, 104,  53,  47,  88,  47,  30,  48,  39, 177,
	192, 178, 227, 237, 221, 236, 253, 236, 199, 227, 201, 204, 218, 196, 218, 230,
	210, 177, 185, 180,  44,  56,  28,  30,  48,  39,  44,  65,  31,  44,  56,  28,
	 60,  72,  31,  19,  71,  34,  48,  80,  62,  31,  72,  45,  20,  40,  27,  32,
	 56,  45, 152, 176, 159, 151, 167, 151, 164, 186, 162, 148, 184, 172, 140, 168,
	148, 148, 184, 172,  87, 121,  96,  11,  56,  28,  20,  80,  34,  46,  96,  49,
	 46,  96,  49,  30,  80,  35,  31,  88,  42,  31,  96,  43,  35, 112,  61,  46,
	112,  58,  51, 128,  77,  60, 129,  79,  97, 160, 113, 104, 174, 128, 104, 174,
	128,  96, 166, 116,  47, 135,  70,  46, 127,  65,  36, 128,  63,  36, 142,  76,
	 46, 112,  58,  33, 104,  49,  31,  96,  43,  31,  96,  43,  46, 104,  55,  33,
	104,  49,  33, 104,  49,  20,  88,  38,  35, 104,  60,  35, 104,  60,  33, 104,
	 49,  33, 104,  49,  33, 104,  49,  35, 104,  60,  33, 104,  49,  33,  96,  54,
	 33, 104,  49,  33,  96,  54,  33,  96,  54,  32,  80,  46,  32,  80,  46,  34,
	 88,  53,  31,  72,  45,  11,  56,  28,  11,  48,  24,  32,  80,  46,  35, 104,
	 60,  35, 112,  61,  33, 112,  50,  33, 112,  50,  20,  88,  53,  19,  71,  34,
	 20,  40,  27,  20,  64,  32,  47,  88,  62,  30,  64,  34,  20,  40,  36,  11,
	 33,  18,  32,  80,  46,  46, 104,  55,  33, 104,  49,  33, 104,  49,  33, 104,
	 49,  31,  88,  42,  29,  56,  33,  20,  48,  36,  31,  72,  45,  46,  96,  49,
	 20,  48,  36,  11,  56,  28,  20,  64,  32,  46,  80,  45,  20,  48,  36,  22,
	 33,  29,  20,  48,  27,  32,  80,  46,  33, 104,  49,  33, 104,  49,  33, 104,
	 49,  33, 104,  49,  33, 104,  49,  31,  96,  43,  31,  96,  43,  19,  95,  39,
	 46, 104,  55,  33,  96,  54,  11,  56,  28,  11,  40,  24,  30,  40,  38,  22,
	 33,  29,  38,  33,  34,  22,  33,  29,  54,  49,  50,  21,  32,  19,  20,  56,
	 32,  48,  96,  63,  60,  96,  67,  29,  56,  33,  11,  48,  24,  29,  56,  33,
	 31,  88,  42,  33, 112,  50,  33, 112,  50,  36, 128,  63,  46, 120,  63,  60,
	 72,  31,  79,  64,  30,  31,  88,  42,  20, 104,  44,  46, 120,  63,  34,  88,
	 53,  19,  71,  34,  88, 128,  95, 199, 227, 201, 236, 253, 236, 199, 227, 201,
	227, 237, 221, 228, 230, 228, 100, 129, 107,  11,  48,  24,  46,  80,  45,  60,
	 87,  43,  56,  57,  18,  86,  87,  46,  20,  80,  34,  31,  96,  43,  35, 112,
	 61,  20,  88,  38,  11,  64,  29, 100, 129, 107, 175, 207, 177, 167, 199, 174,
	167, 199, 174, 175, 207, 177, 124, 170, 132,  46, 112,  58,  31,  96,  43,  46,
	104,  55,  46, 112,  58,  56,  65,  29,  29,  56,  33,  30,  48,  26,  31,  72,
	 45,  47,  88,  47,  47,  88,  47,  32,  80,  46,  48,  80,  62,  72, 112,  82,
	 87, 113,  96,  72, 112,  82,  72,  96,  77,  48,  80,  62,  31,  72,  45,  34,
	 88,  53,  46,  96,  49,  30,  80,  35,  29,  72,  35,  20,  64,  32,  20,  64,
	 32,  29,  72,  35,  32,  80,  46,  32,  80,  46,  29,  72,  35,  32,  80,  46,
	 32,  80,  46,  32,  80,  46,  31,  72,  45,  32,  80,  46,  31,  72,  45,  19,
	 71,  34,  20,  64,  32,  31,  72,  45,  31,  72,  45,  31,  72,  45,  20,  64,
	 32,  32,  64,  46,  46,  72,  47,  32,  64,  46,  29,  56,  33,  11,  48,  24,
	 31,  72,  45,  33,  96,  54,  33, 104,  49,  19,  95,  39,  35, 104,  60,  31,
	 88,  42,  19,  71,  34,  20,  48,  27,  20,  64,  32,  34,  88,  53,  20,  64,
	 32,  20,  40,  27,  22,  33,  29,  32,  80,  46,  33, 104,  49,  33, 104,  49,
	 31,  96,  43,  33, 104,  49,  32,  80,  46,  20,  56,  32,  29,  56,  33,  31,
	 72,  45,  31,  88,  42,  32,  56,  45,  20,  56,  32,  20,  64,  32,  47,  88,
	 62,  11,  40,  24,  11,  40,  24,  20,  40,  27,  32,  80,  46,  33, 104,  49,
	 33, 104,  49,  33, 112,  50,  35, 112,  61,  46, 112,  58,  33, 104,  49,  33,
	104,  49,  33,  96,  54,  33, 104,  49,  60, 112,  73,  47,  88,  47,  20,  48,
	 27,  22,  33,  29,  21,  25,  22,  21,  32,  19,   9,  16,  12,  21,  32,  19,
	 29,  56,  33,  47,  88,  47,  48,  96,  63,  60,  87,  43,  46,  80,  45,  48,
	 72,  31,  29,  72,  35,  72,  88,  39,  46, 104,  55,  33, 104,  49,  46, 112,
	 58,  36, 120,  56,  48,  72,  31,  68,  64,  28,  31,  96,  43,  30,  80,  35,
	 72, 112,  59,  72, 112,  59,  46,  80,  45,  46,  80,  45, 115, 128, 119, 177,
	192, 178, 212, 216, 210, 177, 177, 169, 113, 137, 117,  46,  72,  47,  30,  64,
	 34,  60, 104,  53,  46,  96,  49,  44,  56,  28,  44,  56,  28,  48,  72,  31,
	 30,  80,  35,  47,  88,  47,  60,  96,  67,  60,  80,  38,  29,  56,  33,  72,
	 88,  78, 113, 137, 117, 111, 149, 119,  88, 128,  95,  47,  88,  62,  30,  64,
	 34,  34,  88,  53,  60, 104,  73,  49, 104,  69,  44,  48,  20,  29,  40,  26,
	 21,  32,  19,  30,  48,  39,  30,  64,  34,  31,  72,  45,  29,  56,  33,  20,
	 56,  32,  20,  40,  27,  20,  40,  27,  20,  40,  27,  20,  40,  27,  30,  48,
	 26,  30,  48,  26,  30,  64,  34,  32,  64,  46,  20,  56,  32,  20,  48,  27,
	 11,  40,  24,  20,  40,  27,  30,  48,  26,  29,  56,  33,  20,  48,  36,  20,
	 48,  36,  30,  48,  39,  30,  48,  39,  20,  48,  36,  20,  40,  27,  20,  48,
	 36,  20,  48,  36,  20,  40,  27,  20,  40,  36,  20,  48,  27,  20,  48,  36,
	 20,  48,  27,  11,  40,  24,  11,  40,  24,  20,  48,  36,  20,  48,  27,  11,
	 40,  24,  20,  48,  36,  32,  64,  46,  34,  88,  53,  31,  88,  42,  20,  88,
	 38,  34,  88,  53,  32,  80,  46,  20,  72,  45,  29,  40,  26,  20,  64,  32,
	 32,  80,  46,  20,  64,  32,  20,  40,  36,  11,  40,  24,  32,  80,  46,  33,
	104,  49,  48,  96,  63,  31,  96,  43,  31,  96,  43,  32,  80,  46,  29,  56,
	 33,  20,  56,  32,  31,  72,  45,  20,  88,  38,  32,  56,  45,  11,  64,  29,
	 19,  71,  34,  47,  88,  47,  20,  48,  36,  11,  33,  18,  11,  48,  24,  32,
	 80,  46,  33, 104,  49,  33, 112,  50,  46, 112,  58,  46, 112,  58,  46, 112,
	 58,  47, 112,  69,  33, 104,  49,  33, 104,  49,  33,  96,  54,  60, 120,  78,
	 49, 104,  69,  48,  80,  62,  20,  56,  32,  11,  33,  18,  21,  25,  22,  21,
	 32,  19,  20,  48,  27,  47,  88,  62,  49, 104,  69,  47,  88,  47,  32,  80,
	 46,  60,  88,  68,  60,  80,  38,  32,  64,  46,  88,  80,  39,  70,  97,  49,
	 47,  88,  47,  46, 104,  55,  33, 112,  50,  48,  72,  31,  48,  72,  31,  20,
	104,  44,  19,  71,  34,  49, 104,  69,  73, 120,  87,  72, 112,  82,  48,  80,
	 62,  32,  64,  46,  60,  80,  67,  72,  88,  78,  72,  88,  78,  30,  64,  34,
	 31,  72,  45,  47, 112,  69,  46, 112,  58,  46,  96,  49,  30,  80,  35,  48,
	 72,  31,  30,  64,  34,  31,  72,  45,  31,  72,  45,  47,  88,  62,  73, 104,
	 81,  32,  64,  46,  20,  40,  27,  48,  80,  62,  44,  64,  50,  32,  56,  45,
	 20,  56,  32,  20,  64,  32,  48,  80,  62,  32,  80,  46,  30,  64,  34,  31,
	 72,  45,  20,  56,  32,  11,  56,  28,  11,  64,  29,  31,  88,  42,  31,  96,
	 43,  20,  88,  53,  20,  88,  53,  20,  81,  44,  20,  88,  53,  32,  80,  46,
	 31,  88,  42,  32,  80,  46,  32,  80,  46,  32,  80,  46,  20,  81,  44,  30,
	 64,  34,  29,  56,  33,  20,  48,  27,  20,  48,  27,  20,  48,  27,  20,  48,
	 36,  20,  56,  32,  20,  48,  27,  20,  48,  36,  20,  48,  27,  20,  40,  27,
	 20,  48,  36,  20,  40,  27,  30,  48,  39,  30,  48,  39,  30,  48,  39,  20,
	 40,  36,  30,  48,  39,  20,  48,  36,  20,  40,  27,  11,  40,  24,  20,  48,
	 27,  20,  48,  27,  11,  48,  24,  30,  64,  34,  32,  80,  46,  31,  88,  42,
	 30,  80,  35,  20,  88,  38,  31,  88,  42,  30,  80,  35,  20,  64,  32,  20,
	 48,  36,  20,  56,  32,  32,  80,  46,  20,  56,  32,  29,  40,  26,  20,  40,
	 27,  32,  80,  46,  33,  96,  54,  31,  96,  43,  34,  88,  53,  46,  96,  49,
	 34,  88,  53,  20,  64,  45,  32,  56,  45,  32,  80,  46,  20,  88,  38,  32,
	 56,  45,  11,  56,  28,  20,  64,  32,  47,  88,  62,  20,  48,  36,  11,  40,
	 24,  20,  48,  27,  46,  80,  45,  33, 104,  49,  33, 104,  49,  33, 104,  49,
	 35, 112,  61,  46, 112,  58,  35, 104,  60,  46, 104,  55,  33,  96,  54,  33,
	104,  49,  35, 104,  60,  33,  96,  54,  49, 104,  69,  48,  80,  62,  11,  33,
	 18,  12,  33,  29,  44,  56,  49,  48,  96,  63,  49, 104,  69,  35, 104,  60,
	 34,  88,  53,  29,  72,  35,  29,  56,  33,  29,  56,  33,  30,  64,  34,  79,
	 64,  30,  71,  80,  27,  48,  72,  31,  46, 104,  55,  33, 112,  50,  48,  72,
	 31,  56,  65,  29,  19,  95,  39,  33, 104,  49,  20,  96,  54,  20,  96,  54,
	 35, 104,  60,  49, 119,  77,  49, 104,  69,  33,  96,  54,  32,  80,  46,  32,
	 80,  46,  48,  96,  63,  60, 120,  78,  60, 120,  78,  30,  80,  35,  30,  80,
	 35,  60,  80,  38,  44,  65,  31,  11,  48,  24,  20,  88,  38,  10,  80,  48,
	 10,  80,  48,  47, 112,  69,  47, 112,  69,  20,  81,  44,  10,  80,  48,  31,
	 72,  45,  32,  80,  46,  48,  96,  63,  60, 104,  73,  49, 104,  69,  32,  80,
	 46,  29,  72,  35,  47,  88,  47,  30,  80,  35,  20,  81,  44,  34,  88,  53,
	 33, 104,  49,  35, 112,  61,  46, 112,  58,  49, 119,  77,  36, 120,  69,  46,
	127,  65,  51, 128,  77,  49, 119,  77,  49, 119,  77,  35, 112,  61,  35, 104,
	 60,  20, 104,  44,  47,  88,  62,  34,  88,  53,  29,  72,  35,  29,  72,  35,
	 29,  72,  35,  29,  72,  35,  31,  72,  45,  19,  71,  34,  20,  64,  45,  29,
	 56,  33,  32,  64,  46,  20,  64,  32,  32,  64,  46,  32,  64,  46,  31,  72,
	 45,  31,  72,  45,  29,  56,  33,  32,  56,  45,  32,  64,  46,  30,  64,  34,
	 32,  64,  46,  29,  72,  35,  32,  80,  46,  32,  80,  46,  31,  72,  45,  32,
	 80,  46,  31,  88,  42,  31,  88,  42,  20,  88,  53,  31,  88,  42,  20,  72,
	 45,  20,  64,  32,  20,  48,  36,  20,  64,  32,  32,  80,  46,  11,  56,  28,
	 20,  40,  27,  20,  40,  27,  32,  80,  46,  31,  96,  43,  34,  88,  53,  31,
	 88,  42,  31,  96,  43,  32,  80,  46,  32,  64,  46,  32,  64,  46,  32,  80,
	 46,  20,  88,  53,  32,  56,  45,  11,  64,  29,  19,  71,  34,  47,  88,  47,
	 11,  48,  24,  11,  40,  24,  20,  56,  32,  32,  80,  46,  33, 104,  49,  33,
	104,  49,  35, 104,  60,  35, 104,  60,  46, 104,  55,  35, 104,  60,  35, 104,
	 60,  33,  96,  54,  33, 104,  49,  20,  88,  38,  20,  80,  34,  48,  96,  63,
	 48,  96,  63,  11,  48,  24,  20,  40,  36,  44,  64,  50,  60, 112,  73,  46,
	104,  55,  31,  96,  43,  34,  88,  53,  31,  72,  45,  29,  56,  33,  29,  56,
	 33,  30,  64,  34,  60,  80,  38,  47,  88,  47,  60,  80,  38,  46,  96,  49,
	 33, 112,  50,  48,  72,  31,  68,  56,  26,  31,  88,  42,  33, 104,  49,  19,
	 95,  39,  10,  87,  42,  33, 104,  49,  35, 112,  61,  49, 119,  77,  51, 128,
	 77,  60, 127,  68,  49, 104,  69,  73, 128,  87,  60, 120,  78,  34,  88,  53,
	 31,  72,  45,  48,  72,  31,  56,  65,  29,  52,  50,  20,  20,  64,  32,  20,
	 80,  34,  20,  88,  38,  33, 104,  49,  35, 104,  60,  48,  96,  63,  33,  96,
	 54,  35, 112,  61,  49, 104,  69,  60, 120,  64,  47, 112,  69,  46, 104,  55,
	 46,  96,  49,  47,  88,  47,  31,  88,  42,  44,  65,  31,  30,  64,  34,  46,
	 80,  45,  47,  88,  47,  47,  88,  47,  46,  96,  49,  47,  88,  47,  46,  96,
	 49,  34,  88,  53,  31,  96,  43,  46,  96,  49,  46,  96,  49,  34,  88,  53,
	 47,  88,  47,  34,  88,  53,  33,  96,  54,  31,  88,  42,  30,  80,  35,  29,
	 72,  35,  19,  71,  34,  29,  72,  35,  31,  72,  45,  20,  80,  34,  19,  71,
	 34,  20,  64,  45,  20,  64,  32,  19,  71,  34,  20,  64,  45,  20,  64,  32,
	 20,  64,  32,  20,  64,  32,  20,  72,  45,  30,  64,  34,  30,  64,  34,  30,
	 64,  34,  19,  71,  34,  29,  72,  35,  29,  72,  35,  29,  72,  35,  31,  72,
	 45,  20,  72,  45,  32,  80,  46,  32,  80,  46,  20,  81,  44,  34,  88,  53,
	 32,  80,  46,  32,  80,  46,  20,  72,  45,  30,  48,  26,  11,  56,  28,  32,
	 80,  46,  20,  56,  32,  20,  40,  36,  20,  40,  27,  32,  80,  46,  33,  96,
	 54,  31,  88,  42,  31,  88,  42,  31,  96,  43,  32,  80,  46,  32,  64,  46,
	 32,  64,  46,  32,  80,  46,  31,  88,  42,  32,  64,  46,  20,  64,  32,  20,
	 72,  45,  48,  96,  63,  20,  48,  36,  11,  40,  24,  11,  48,  24,  32,  80,
	 46,  33, 104,  49,  33, 104,  49,  33, 104,  49,  33, 104,  49,  35, 104,  60,
	 33, 104,  49,  33,  96,  54,  33,  96,  54,  20,  96,  54,  33, 104,  49,  10,
	 80,  48,  31,  88,  42,  32,  80,  46,  20,  48,  36,  20,  48,  36,  30,  40,
	 38,  33,  96,  54,  31,  88,  42,  31,  88,  42,  31,  96,  43,  60,  96,  47,
	 60,  87,  43,  46,  80,  45,  46,  72,  47,  70, 104,  55,  60, 104,  53,  60,
	 87,  43,  46,  96,  49,  33, 104,  49,  44,  65,  31,  68,  56,  26,  60,  80,
	 38,  48,  72,  31,  60,  87,  43,  60,  96,  47,  60,  96,  47,  60,  96,  47,
	 70, 104,  55,  60,  96,  47,  46,  96,  49,  46,  96,  49,  47, 112,  69,  46,
	 96,  49,  30,  80,  35,  47,  88,  47,  60,  73,  46,  68,  64,  28,  79,  64,
	 30,  60,  72,  31,  44,  65,  31,  46,  80,  45,  60, 104,  53,  60,  80,  38,
	 47,  88,  47,  60,  87,  43,  47,  88,  47,  46,  96,  49,  46, 104,  55,  46,
	 96,  49,  30,  80,  35,  31,  88,  42,  31,  96,  43,  31,  88,  42,  30,  48,
	 26,  44,  48,  20,  32,  56,  45,  30,  64,  34,  44,  65,  31,  29,  72,  35,
	 44,  65,  31,  44,  65,  31,  46,  80,  45,  46,  80,  45,  48,  72,  31,  31,
	 72,  45,  44,  65,  31,  30,  64,  34,  30,  64,  34,  30,  64,  34,  20,  56,
	 32,  20,  56,  32,  20,  48,  27,  30,  48,  26,  20,  56,  32,  30,  48,  26,
	 20,  56,  32,  20,  56,  32,  20,  48,  27,  20,  48,  27,  20,  56,  32,  30,
	 48,  39,  20,  56,  32,  20,  48,  27,  20,  48,  27,  20,  48,  36,  20,  56,
	 32,  20,  56,  32,  20,  56,  32,  20,  48,  36,  11,  56,  28,  11,  48,  24,
	 11,  56,  28,  11,  48,  24,  29,  56,  33,  20,  64,  32,  20,  64,  45,  20,
	 64,  45,  32,  64,  46,  32,  64,  46,  20,  55,  46,  20,  55,  46,  20,  48,
	 27,  20,  56,  32,  34,  88,  53,  20,  56,  32,  20,  40,  27,  20,  40,  27,
	 32,  80,  46,  33,  96,  54,  20,  96,  54,  31,  96,  43,  33,  96,  54,  34,
	 88,  53,  20,  55,  46,  32,  56,  45,  31,  72,  45,  34,  88,  53,  32,  64,
	 46,  20,  64,  45,  30,  80,  35,  47,  88,  62,  20,  55,  46,  11,  40,  24,
	 20,  48,  36,  32,  80,  46,  35, 104,  60,  33, 104,  49,  35, 104,  60,  33,
	104,  49,  35, 104,  60,  33,  96,  54,  35, 104,  60,  33,  96,  54,  33,  96,
	 54,  35, 104,  60,  31,  88,  42,  31,  88,  42,  31,  72,  45,  11,  48,  24,
	 20,  40,  27,  30,  40,  38,  34,  88,  53,  34,  88,  53,  20,  88,  53,  46,
	 96,  49,  60,  96,  67,  70,  97,  49,  60,  87,  43,  46,  80,  45,  46, 104,
	 55,  46, 104,  55,  46,  80,  45,  31,  96,  43,  20, 111,  48,  30,  64,  34,
	 55,  55,  31,  48,  72,  31,  60,  80,  38,  60,  87,  43,  60,  80,  38,  60,
	 80,  38,  60,  87,  43,  70, 104,  55,  70, 104,  55,  70,  97,  49,  47,  88,
	 47,  70, 104,  55,  46,  96,  49,  47,  88,  47,  48,  72,  31,  30,  64,  34,
	 44,  56,  28,  56,  65,  29,  52,  50,  20,  44,  65,  31,  46,  80,  45,  46,
	 80,  45,  60,  73,  46,  68,  88,  54,  60,  87,  43,  30,  64,  34,  29,  72,
	 35,  60,  87,  43,  46,  96,  49,  47,  88,  47,  31,  88,  42,  46,  80,  45,
	 46,  80,  45,  20,  56,  32,  11,  56,  28,  20,  56,  32,  20,  56,  32,  20,
	 56,  32,  30,  64,  34,  30,  64,  34,  32,  64,  46,  30,  64,  34,  30,  64,
	 34,  30,  64,  34,  32,  56,  45,  30,  64,  34,  30,  64,  34,  32,  64,  46,
	 20,  64,  32,  29,  40,  26,  29,  40,  26,  29,  40,  26,  29,  40,  26,  22,
	 33,  29,  30,  40,  38,  22,  33,  29,  22,  33,  29,  22,  33,  29,  22,  33,
	 29,  30,  40,  38,  30,  40,  38,  29,  40,  26,  30,  40,  38,  30,  40,  38,
	 30,  40,  38,  20,  48,  27,  11,  40,  24,  11,  40,  24,  20,  48,  36,  20,
	 48,  36,  20,  48,  36,  20,  40,  36,  20,  40,  36,  20,  48,  36,  30,  48,
	 26,  20,  40,  27,  20,  40,  27,  20,  40,  36,  20,  40,  36,  20,  40,  27,
	 22,  33,  29,  20,  48,  36,  20,  64,  32,  32,  80,  46,  20,  64,  32,  20,
	 40,  27,  22,  33,  29,  32,  80,  46,  33, 104,  49,  20,  96,  54,  33,  96,
	 54,  33,  96,  54,  32,  80,  46,  20,  56,  32,  20,  48,  36,  31,  72,  45,
	 31,  88,  42,  32,  64,  46,  20,  64,  32,  19,  71,  34,  48,  96,  63,  20,
	 55,  46,  11,  40,  24,  11,  56,  28,  47,  88,  47,  35, 112,  61,  35, 104,
	 60,  33, 104,  49,  33,  96,  54,  33,  96,  54,  33,  96,  54,  33,  96,  54,
	 33,  96,  54,  33,  96,  54,  33, 104,  49,  31,  96,  43,  35, 104,  60,  32,
	 80,  46,  11,  40,  24,  22,  33,  29,  32,  56,  45,  48,  96,  63,  32,  80,
	 46,  31,  88,  42,  46,  96,  49,  60,  87,  43,  60,  80,  38,  31,  72,  45,
	 48,  72,  31,  31,  72,  45,  46,  80,  45,  44,  65,  31,  34,  88,  53,  20,
	111,  48,  19,  71,  34,  55,  55,  31,  31,  72,  45,  30,  64,  34,  31,  72,
	 45,  31,  72,  45,  30,  80,  35,  46,  80,  45,  31,  88,  42,  31,  88,  42,
	 31,  88,  42,  48,  72,  31,  48,  72,  31,  46,  80,  45,  46,  80,  45,  29,
	 72,  35,  46,  80,  45,  34,  88,  53,  30,  64,  34,  11,  40,  24,  32,  64,
	 46,  46,  80,  45,  32,  80,  46,  31,  72,  45,  29,  56,  33,  20,  64,  32,
	 46,  80,  45,  46,  72,  47,  48,  72,  31,  30,  64,  34,  30,  64,  34,  30,
	 64,  34,  30,  64,  34,  29,  56,  33,  32,  80,  46,  29,  72,  35,  32,  80,
	 46,  33,  96,  54,  33, 112,  50,  33, 104,  49,  33,  96,  54,  33,  96,  54,
	 33,  96,  54,  33,  96,  54,  46,  96,  49,  33,  96,  54,  34,  88,  53,  32,
	 80,  46,  32,  80,  46,  34,  88,  53,  31,  72,  45,  29,  72,  35,  20,  56,
	 32,  20,  56,  32,  30,  64,  34,  31,  72,  45,  32,  64,  46,  32,  64,  46,
	 19,  71,  34,  32,  80,  46,  20,  80,  34,  20,  80,  34,  20,  88,  38,  31,
	 88,  42,  31,  88,  42,  31,  88,  42,  31,  88,  42,  31,  88,  42,  20,  88,
	 38,  31,  88,  42,  31,  88,  42,  20,  81,  44,  31,  88,  42,  31,  88,  42,
	 31,  96,  43,  31,  96,  43,  31,  88,  42,  31,  88,  42,  31,  88,  42,  31,
	 96,  43,  34,  88,  53,  31,  88,  42,  20,  88,  38,  31,  88,  42,  47,  88,
	 47,  29,  56,  33,  30,  40,  38,  20,  40,  27,  30,  80,  35,  33, 104,  49,
	 46,  80,  45,  32,  80,  46,  32,  80,  46,  32,  64,  46,  20,  40,  27,  22,
	 33,  29,  32,  56,  45,  32,  80,  46,  20,  40,  27,  11,  40,  24,  11,  48,
	 24,  31,  72,  45,  11,  40,  24,  20,  40,  27,  20,  55,  46,  34,  88,  53,
	 33, 104,  49,  33, 104,  49,  33, 112,  50,  33, 112,  50,  20, 104,  44,  35,
	104,  60,  33, 104,  49,  20, 104,  44,  33,  96,  54,  35, 104,  60,  20, 111,
	 48,  20, 104,  44,  30,  80,  35,  11,  48,  24,  11,  40,  24,  32,  56,  45,
	 47,  88,  62,  34,  88,  53,  33,  96,  54,  49, 104,  69,  72,  96,  77,  46,
	 80,  45,  48,  72,  31,  30,  64,  34,  46, 104,  55,  46,  96,  49,  31,  96,
	 43,  46,  96,  49,  31,  88,  42,  31,  72,  45,  32,  64,  46,  20,  55,  46,
	 34,  88,  53,  34,  88,  53,  31,  96,  43,  33,  96,  54,  33,  96,  54,  46,
	 96,  49,  31,  96,  43,  31,  96,  43,  46,  96,  49,  33,  96,  54,  46, 104,
	 55,  31,  96,  43,  31,  88,  42,  20,  80,  34,  31,  72,  45,  30,  64,  34,
	 30,  64,  34,  20,  81,  44,  35, 104,  60,  20,  88,  53,  34,  88,  53,  29,
	 72,  35,  33,  96,  54,  35, 112,  61,  35, 104,  60,  35, 112,  61,  33, 112,
	 50,  20, 104,  44,  33, 104,  49,  33, 112,  50,  33, 112,  50,  32,  80,  46,
	 32,  64,  46,  29,  72,  35,  46,  80,  45,  33,  96,  54,  33,  96,  54,  31,
	 88,  42,  32,  80,  46,  30,  80,  35,  32,  80,  46,  32,  80,  46,  31,  72,
	 45,  29,  72,  35,  20,  64,  45,  20,  72,  45,  31,  72,  45,  30,  64,  34,
	 20,  64,  32,  20,  56,  32,  20,  56,  32,  20,  64,  32,  32,  64,  46,  20,
	 64,  32,  11,  56,  28,  20,  64,  45,  32,  64,  46,  32,  80,  46,  29,  72,
	 35,  29,  72,  35,  29,  72,  35,  46,  80,  45,  32,  80,  46,  30,  80,  35,
	 32,  80,  46,  34,  88,  53,  34,  88,  53,  47,  88,  47,  32,  80,  46,  32,
	 80,  46,  34,  88,  53,  34,  88,  53,  46,  96,  49,  34,  88,  53,  34,  88,
	 53,  47,  88,  47,  34,  88,  53,  47,  88,  47,  34,  88,  53,  32,  80,  46,
	 34,  88,  53,  47,  88,  62,  20,  48,  36,  30,  48,  39,  20,  48,  36,  47,
	 88,  47,  35, 112,  61,  31,  88,  42,  31,  88,  42,  34,  88,  53,  32,  80,
	 46,  20,  55,  46,  20,  56,  32,  31,  72,  45,  33,  96,  54,  20,  56,  32,
	 11,  56,  28,  11,  64,  29,  47,  88,  62,  30,  64,  34,  20,  56,  32,  31,
	 72,  45,  49, 104,  69,  33, 104,  49,  33, 104,  49,  35, 104,  60,  35, 104,
	 60,  33,  96,  54,  35, 104,  60,  47, 112,  69,  48,  96,  63,  33,  96,  54,
	 33, 104,  49,  20, 104,  44,  33, 104,  49,  32,  80,  46,  20,  48,  36,  11,
	 40,  24,  32,  56,  45,  48,  96,  63,  33,  96,  54,  33,  96,  54,  46, 104,
	 55,  70, 104,  55,  70,  97,  49,  60,  96,  47,  60,  96,  47,  60, 104,  53,
	 46,  96,  49,  46,  96,  49,  33,  96,  54,  31,  88,  42,  31,  72,  45,  20,
	 64,  45,  20,  56,  32,  32,  80,  46,  33,  96,  54,  33,  96,  54,  33, 104,
	 49,  46,  96,  49,  49, 104,  69,  46, 104,  55,  33, 104,  49,  46, 104,  55,
	 46, 104,  55,  46, 104,  55,  33, 104,  49,  31,  96,  43,  34,  88,  53,  32,
	 80,  46,  31,  72,  45,  20,  56,  32,  19,  71,  34,  35, 104,  60,  20,  80,
	 34,  34,  88,  53,  31,  72,  45,  33,  96,  54,  35, 104,  60,  33, 104,  49,
	 46, 104,  55,  33, 104,  49,  33,  96,  54,  33,  96,  54,  33,  96,  54,  33,
	 96,  54,  20,  64,  32,  20,  56,  32,  29,  56,  33,  29,  72,  35,  32,  80,
	 46,  19,  71,  34,  32,  64,  46,  31,  72,  45,  31,  72,  45,  46,  80,  45,
	 31,  72,  45,  31,  72,  45,  31,  72,  45,  30,  64,  34,  32,  64,  46,  32,
	 64,  46,  30,  64,  34,  20,  56,  32,  20,  56,  32,  20,  56,  32,  32,  56,
	 45,  20,  56,  32,  20,  56,  32,  11,  40,  24,  20,  40,  36,  32,  56,  45,
	 32,  56,  45,  20,  56,  32,  11,  48,  24,  20,  48,  27,  20,  48,  36,  32,
	 56,  45,  20,  48,  27,  20,  48,  36,  29,  56,  33,  32,  64,  46,  32,  64,
	 46,  20,  64,  45,  32,  64,  46,  31,  72,  45,  32,  64,  46,  20,  64,  45,
	 20,  64,  32,  20,  64,  32,  20,  56,  32,  20,  64,  32,  20,  64,  32,  20,
	 56,  32,  20,  56,  32,  11,  56,  28,  20,  64,  32,  11,  33,  18,  12,  33,
	 29,  11,  40,  24,  32,  80,  46,  35, 112,  61,  10,  87,  42,  20,  88,  53,
	 33, 104,  49,  33, 104,  49,  31,  72,  45,  20,  72,  45,  33,  96,  54,  33,
	112,  50,  32,  80,  46,  30,  80,  35,  31,  88,  42,  47, 112,  69,  34,  88,
	 53,  29,  72,  35,  20,  80,  34,  33,  96,  54,  46, 104,  55,  31,  96,  43,
	 49, 104,  69,  60, 112,  73,  60, 104,  73,  72, 112,  82,  73, 120,  87,  73,
	120,  87,  60, 104,  73,  49, 104,  69,  33, 112,  50,  33,  96,  54,  32,  80,
	 46,  32,  56,  45,  20,  48,  36,  32,  64,  46,  46, 104,  55,  33,  96,  54,
	 33,  96,  54,  35, 104,  60,  49, 104,  69,  60,  88,  68,  48,  96,  63,  48,
	 96,  63,  60, 104,  53,  46,  96,  49,  31,  96,  43,  33,  96,  54,  34,  88,
	 53,  32,  80,  46,  20,  64,  45,  32,  56,  45,  30,  80,  35,  31,  88,  42,
	 33,  96,  54,  33,  96,  54,  46, 104,  55,  49, 104,  69,  46, 104,  55,  46,
	104,  55,  46,  96,  49,  46, 104,  55,  33, 104,  49,  33,  96,  54,  31,  96,
	 43,  31,  88,  42,  32,  80,  46,  30,  64,  34,  20,  56,  32,  19,  71,  34,
	 33,  96,  54,  20,  88,  38,  46,  80,  45,  46,  80,  45,  46, 104,  55,  35,
	104,  60,  47,  88,  47,  34,  88,  53,  47,  88,  47,  31,  88,  42,  31,  88,
	 42,  34,  88,  53,  31,  88,  42,  20,  64,  45,  20,  56,  32,  30,  64,  34,
	 29,  72,  35,  32,  80,  46,  29,  72,  35,  30,  64,  34,  56,  65,  29,  29,
	 72,  35,  19,  71,  34,  29,  72,  35,  29,  72,  35,  20,  64,  32,  20,  64,
	 32,  30,  64,  34,  20,  56,  32,  32,  56,  45,  32,  56,  45,  20,  56,  32,
	 29,  56,  33,  30,  64,  34,  32,  56,  45,  30,  48,  39,  20,  48,  36,  11,
	 40,  24,  20,  56,  32,  30,  64,  34,  20,  56,  32,  20,  48,  27,  29,  56,
	 33,  44,  64,  50,  46,  72,  47,  32,  64,  46,  32,  64,  46,  32,  64,  46,
	 20,  64,  45,  20,  64,  32,  11,  56,  28,  20,  72,  45,  31,  72,  45,  20,
	 81,  44,  32,  80,  46,  32,  80,  46,  20,  81,  44,  31,  72,  45,  32,  80,
	 46,  31,  72,  45,  30,  64,  34,  48,  72,  31,  31,  72,  45,  31,  72,  45,
	 11,  48,  24,  20,  55,  46,  20,  55,  46,  33,  96,  54,  35, 112,  61,  33,
	 96,  54,  19,  95,  39,  35, 112,  61,  46, 104,  55,  32,  80,  46,  32,  80,
	 46,  33, 104,  49,  33, 112,  50,  46,  72,  47,  32,  80,  46,  32,  80,  46,
	 49, 104,  69,  32,  80,  46,  20,  64,  32,  11,  64,  29,  32,  80,  46,  46,
	 96,  49,  47,  88,  62,  47,  88,  62,  60,  96,  67,  60,  96,  67,  72,  96,
	 77,  87, 113,  96,  87, 105,  93,  73, 104,  81,  73, 104,  81,  49, 104,  69,
	 48,  96,  63,  46,  80,  45,  30,  48,  39,  11,  40,  24,  29,  56,  33,  35,
	104,  60,  33, 104,  49,  20, 104,  44,  46, 112,  58,  49, 104,  69,  47,  88,
	 47,  30,  80,  35,  32,  80,  46,  46,  96,  49,  46,  96,  49,  31,  96,  43,
	 33,  96,  54,  31,  88,  42,  32,  80,  46,  32,  64,  46,  32,  64,  46,  32,
	 80,  46,  31,  88,  42,  31,  96,  43,  46, 104,  55,  46,  96,  49,  70, 104,
	 55,  46, 112,  58,  46, 104,  55,  33,  96,  54,  46, 104,  55,  33, 104,  49,
	 33,  96,  54,  19,  95,  39,  31,  88,  42,  20,  72,  45,  20,  64,  32,  20,
	 56,  32,  30,  80,  35,  31,  96,  43,  34,  88,  53,  47,  88,  47,  60,  87,
	 43,  60, 104,  53,  46, 112,  58,  32,  80,  46,  47,  88,  47,  34,  88,  53,
	 33,  96,  54,  34,  88,  53,  34,  88,  53,  32,  80,  46,  32,  80,  46,  32,
	 80,  46,  32,  80,  46,  33,  96,  54,  33,  96,  54,  31,  88,  42,  32,  80,
	 46,  48,  80,  62,  46, 104,  55,  46, 104,  55,  46, 104,  55,  33, 104,  49,
	 46,  96,  49,  33,  96,  54,  34,  88,  53,  34,  88,  53,  32,  64,  46,  29,
	 56,  33,  30,  48,  39,  20,  55,  46,  30,  48,  39,  20,  56,  32,  20,  56,
	 32,  20,  48,  36,  30,  64,  34,  29,  72,  35,  32,  80,  46,  30,  80,  35,
	 46,  96,  49,  72, 112,  82,  73, 120,  87,  87, 113,  79,  97, 136, 103,  97,
	136, 103,  81, 135,  95,  73, 128,  87,  60, 112,  73,  46, 104,  55,  46, 104,
	 55,  47, 112,  69,  46, 112,  58,  47, 112,  69,  35, 112,  61,  35, 112,  61,
	 46, 104,  55,  47, 112,  69,  46, 104,  55,  48,  96,  63,  70, 104,  55,  70,
	104,  55,  70, 104,  55,  32,  80,  46,  46,  72,  47,  31,  72,  45,  35, 104,
	 60,  27, 120,  53,  31,  88,  42,  33,  96,  54,  46, 104,  55,  46, 104,  55,
	 46,  80,  45,  32,  80,  46,  31,  96,  43,  27, 120,  53,  30,  48,  39,  11,
	 48,  24,  11,  56,  28,  34,  88,  53,  20,  48,  36,  20,  48,  36,  20,  48,
	 36,  31,  72,  45,  34,  88,  53,  32,  64,  46,  32,  64,  46,  44,  64,  50,
	 44,  48,  47,  32,  56,  45,  44,  56,  49,  44,  56,  49,  49,  71,  62,  48,
	 80,  62,  30,  80,  35,  31,  72,  45,  32,  64,  46,  20,  40,  36,  11,  33,
	 18,  20,  56,  32,  33, 104,  49,  20,  96,  54,  33, 112,  50,  47, 112,  69,
	 47, 112,  69,  46,  96,  49,  31,  88,  42,  31,  88,  42,  33,  96,  54,  33,
	 96,  54,  33,  96,  54,  33, 104,  49,  33,  96,  54,  32,  80,  46,  19,  71,
	 34,  32,  64,  46,  31,  88,  42,  31,  96,  43,  33, 104,  49,  46, 104,  55,
	 60,  96,  47,  70, 104,  55,  60, 104,  53,  46, 104,  55,  48,  96,  63,  35,
	104,  60,  46, 112,  58,  33, 104,  49,  33,  96,  54,  33,  96,  54,  32,  80,
	 46,  11,  64,  29,  29,  56,  33,  30,  80,  35,  33,  96,  54,  31,  96,  43,
	 47,  88,  47,  60,  96,  47,  60, 104,  53,  46, 104,  55,  34,  88,  53,  33,
	 96,  54,  46, 104,  55,  35, 104,  60,  35, 104,  60,  35, 104,  60,  33, 104,
	 49,  33,  96,  54,  20,  88,  53,  31,  88,  42,  35, 104,  60,  35, 112,  61,
	 35, 104,  60,  48,  96,  63,  47,  88,  47,  46, 104,  55,  33, 104,  49,  33,
	 96,  54,  35, 104,  60,  20,  96,  54,  31,  88,  42,  20,  81,  44,  32,  80,
	 46,  32,  56,  45,  32,  56,  45,  20,  56,  32,  20,  48,  27,  20,  48,  27,
	 20,  48,  36,  30,  48,  26,  29,  56,  33,  20,  80,  34,  31,  88,  42,  31,
	 88,  42,  31,  96,  43,  60, 112,  53,  73, 128,  87,  97, 136, 103,  88, 128,
	 95,  73, 128,  87,  88, 128,  95,  81, 135,  95,  81, 135,  95,  60, 120,  78,
	 33, 104,  49,  20, 104,  44,  20, 104,  44,  35, 112,  61,  36, 120,  56,  27,
	120,  53,  33, 112,  50,  33, 112,  50,  33, 112,  50,  33, 104,  49,  46,  96,
	 49,  70,  97,  49,  70,  97,  49,  70, 104,  55,  30,  80,  35,  32,  80,  46,
	 32,  80,  46,  31,  96,  43,  33, 112,  50,  32,  80,  46,  31,  88,  42,  46,
	104,  55,  46,  96,  49,  48,  72,  31,  31,  72,  45,  33, 104,  49,  46, 120,
	 63,  30,  48,  39,  20,  48,  36,  20,  55,  46,  31,  72,  45,  20,  48,  36,
	 22,  33,  29,  20,  40,  36,  44,  56,  49,  31,  72,  45,  20,  56,  32,  20,
	 40,  27,  30,  40,  38,  30,  40,  38,  22,  33,  29,  20,  40,  36,  30,  40,
	 38,  30,  48,  39,  30,  48,  39,  29,  56,  33,  30,  64,  34,  30,  48,  39,
	 11,  40,  24,  11,  48,  24,  31,  72,  45,  46, 112,  58,  33, 104,  49,  35,
	112,  61,  35, 112,  61,  47, 112,  69,  48,  96,  63,  33,  96,  54,  35, 104,
	 60,  35, 104,  60,  33, 104,  49,  33, 104,  49,  33, 104,  49,  31,  88,  42,
	 20,  81,  44,  20,  64,  32,  32,  56,  45,  31,  88,  42,  33,  96,  54,  46,
	 96,  49,  46, 104,  55,  60, 104,  53,  60, 104,  53,  60, 104,  53,  33, 104,
	 49,  35, 104,  60,  46, 112,  58,  35, 112,  61,  20, 104,  44,  33, 104,  49,
	 33,  96,  54,  32,  80,  46,  20,  64,  32,  20,  64,  32,  31,  88,  42,  33,
	 96,  54,  31,  96,  43,  46,  80,  45,  72,  88,  39,  46, 104,  55,  60, 112,
	 53,  33,  96,  54,  35, 104,  60,  35, 112,  61,  46, 120,  63,  35, 112,  61,
	 35, 112,  61,  35, 112,  61};

/* This is the byte array for vader.png: 107 x 80 x 8 bit*/
unsigned int vader_dim[3] = {107, 80, 8};

unsigned char vader[] = {
	  1,   0,   0,   0,   0,   2,   4,   5,   4,   1,   0,   0,   0,   1,   1,   0,
	  0,   0,   1,   0,   0,   6,   0, 117, 110,  40,  11,   1,  44, 136, 133, 127,
	125, 120, 121, 133, 136, 130, 127, 130, 133, 149, 157, 176, 184, 190, 193, 190,
	168, 176, 190, 193, 204, 222, 222, 197, 179, 211, 222, 222, 216, 211, 211, 204,
	199, 193, 193, 193, 190, 184, 182, 182, 176, 170, 162, 159, 162, 166, 168, 172,
	188, 163,  20,  55, 172,  99,   0,   3,   0,   0,   0,   0,   0,   0,   2,   5,
	  4,   1,   0,   0,   0,   1,   1,   0,   1,   1,   1,   1,   0,   0,   0,   0,
	  1,   3,   4,   3,   1,   0,   0,   0,   1,   1,   0,   4,   3,   3,   0,   2,
	  5,  35, 134,  84,  29,   7,   1,  48, 130, 125, 123, 115, 115, 120, 127, 127,
	125, 125, 125, 130, 149, 154, 167, 179, 182, 184, 184, 166, 176, 190, 190, 199,
	216, 222, 197, 182, 216, 222, 222, 216, 211, 211, 199, 193, 193, 193, 190, 190,
	184, 182, 182, 172, 168, 159, 156, 156, 156, 162, 166, 170, 172,  35,  38, 143,
	164,  10,   0,   0,   0,   1,   0,   0,   0,   2,   4,   3,   1,   0,   0,   0,
	  1,   1,   0,   1,   1,   1,   1,   0,   0,   0,   0,   1,   3,   4,   3,   1,
	  0,   0,   0,   1,   0,   0,   0,   4,   0,   0,   0,   0,  81, 143,  59,  20,
	  5,   1,  58, 120, 115, 115, 109, 115, 120, 125, 125, 121, 121, 125, 133, 139,
	148, 167, 176, 179, 184, 179, 159, 176, 190, 190, 193, 211, 211, 193, 179, 216,
	222, 222, 216, 211, 211, 199, 199, 193, 193, 190, 190, 182, 179, 172, 167, 162,
	154, 148, 145, 145, 151, 156, 156, 172,  55,  20,  91, 211,  46,   0,   0,   1,
	  1,   0,   0,   0,   1,   2,   3,   1,   0,   0,   0,   1,   0,   0,   1,   1,
	  1,   1,   0,   0,   0,   0,   1,   2,   2,   2,   1,   0,   0,   0,   0,   0,
	  0,   0,   2,   0,   0,   0,   4, 122, 122,  48,  17,   4,   3,  69, 109,  98,
	 98,  98, 109, 120, 121, 121, 121, 125, 125, 133, 149, 154, 167, 176, 179, 184,
	179, 156, 172, 190, 184, 190, 204, 207, 188, 176, 211, 222, 222, 216, 211, 211,
	204, 204, 199, 193, 190, 184, 179, 170, 167, 159, 154, 151, 145, 145, 145, 145,
	145, 151, 160,  58,  12,  58, 199, 106,   2,   1,   1,   1,   1,   0,   0,   0,
	  1,   2,   1,   0,   0,   0,   0,   0,   0,   1,   1,   1,   0,   0,   0,   0,
	  0,   0,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   4,   3,   2,
	  0,  41, 153,  94,  46,  17,   2,   1,  69,  98,  88,  88,  98, 109, 120, 120,
	120, 125, 127, 125, 133, 139, 151, 167, 176, 182, 190, 176, 156, 170, 182, 179,
	184, 204, 204, 182, 172, 204, 216, 216, 211, 211, 211, 211, 211, 204, 193, 188,
	182, 176, 167, 159, 151, 151, 148, 145, 145, 136, 136, 136, 145, 149,  65,   9,
	 44, 153, 188,   7,   1,   1,   1,   1,   1,   1,   0,   0,   1,   1,   1,   1,
	  0,   0,   0,   0,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  1,   2,   2,   1,   0,   0,   0,   4,   3,   0,   1,   0,  88, 150,  77,  44,
	 14,   0,   1,  69,  98,  88,  88,  98, 109, 115, 115, 115, 121, 125, 125, 128,
	139, 148, 162, 170, 179, 184, 170, 151, 166, 176, 176, 184, 199, 193, 172, 168,
	204, 216, 211, 211, 211, 216, 211, 211, 204, 190, 182, 179, 170, 162, 154, 148,
	148, 148, 145, 145, 136, 133, 127, 136, 145,  69,   3,  38, 117, 228,  35,   0,
	  0,   0,   1,   2,   2,   1,   0,   0,   1,   2,   2,   1,   0,   0,   0,   1,
	  1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   3,   2,   1,   0,
	  0,   0,   5,   2,   0,   0,   4, 134, 128,  69,  35,   9,   0,   2,  69,  88,
	 98, 109, 115, 115, 115, 115, 121, 125, 125, 125, 128, 133, 149, 160, 167, 176,
	182, 167, 139, 160, 172, 170, 179, 193, 184, 167, 166, 197, 211, 211, 204, 204,
	211, 204, 199, 193, 188, 182, 176, 168, 159, 154, 151, 151, 148, 145, 136, 133,
	127, 121, 127, 133,  65,   1,  27,  94, 223,  94,   0,   0,   0,   1,   2,   3,
	  1,   0,   0,   1,   3,   2,   1,   0,   0,   0,   1,   1,   1,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   1,   3,   3,   1,   0,   0,   0,   8,   5,   0,
	  4,  13, 164, 106,  65,  31,   5,   0,   5,  76,  98, 115, 123, 125, 121, 120,
	121, 125, 125, 127, 127, 128, 133, 149, 160, 160, 170, 179, 160, 133, 160, 170,
	167, 176, 186, 182, 167, 162, 197, 204, 204, 197, 197, 199, 197, 190, 188, 182,
	179, 176, 168, 159, 154, 156, 151, 148, 145, 136, 127, 121, 115, 115, 121,  55,
	  1,  15,  81, 193, 153,   0,   0,   0,   0,   3,   3,   2,   0,   0,   1,   3,
	  3,   1,   0,   0,   0,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   1,   2,   2,   1,   0,   0,   3,   1,   0,  59, 164,  99,  59,
	 22,   4,   1,   1,  72, 123, 125, 121, 130, 130, 127, 133, 136, 133, 128, 130,
	130, 130, 139, 154, 162, 162, 182, 151, 133, 156, 168, 167, 182, 188, 170, 159,
	162, 193, 197, 197, 188, 188, 184, 188, 182, 176, 172, 168, 168, 166, 160, 154,
	151, 151, 148, 145, 133, 136, 125, 115, 109, 120,  44,   1,   9,  62, 164, 188,
	  3,   0,   1,   0,   0,   0,   0,   1,   2,   1,   0,   0,   0,   0,   0,   1,
	  0,   1,   1,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  1,   2,   2,   0,   1,   2,   1,  91, 153,  88,  54,  29,   1,   1,   6,  35,
	122, 149, 160, 149, 163, 160, 148, 148, 145, 136, 133, 136, 139, 139, 154, 157,
	160, 179, 156, 130, 156, 168, 167, 182, 182, 170, 159, 162, 188, 197, 197, 188,
	190, 182, 176, 168, 162, 156, 154, 156, 154, 151, 148, 148, 148, 145, 136, 125,
	121, 109, 109, 121,  88,  20,   1,   4,  55, 164, 199,  18,   0,   1,   3,   1,
	  2,   1,   2,   1,   1,   0,   0,   0,   0,   1,   1,   0,   1,   1,   2,   2,
	  1,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   1,   3,   4,   1,   0,
	  1,   7, 128, 134,  81,  51,   7,   5,   0,   5,   1,  54, 128, 143, 199, 232,
	232, 211, 207, 204, 182, 176, 166, 157, 148, 154, 160, 167, 182, 157, 130, 154,
	168, 170, 179, 179, 168, 159, 162, 188, 182, 176, 168, 166, 156, 154, 159, 162,
	170, 176, 176, 172, 166, 159, 148, 151, 151, 136, 121, 127, 115, 115, 109,  48,
	  1,   0,   1,  38, 143, 223,  54,   0,   0,   4,   0,   0,   2,   3,   0,   0,
	  0,   0,   0,   1,   2,   2,   1,   0,   0,   3,   2,   1,   1,   0,   0,   1,
	  1,   0,   0,   1,   1,   1,   1,   3,   4,   3,   0,   0,  14, 153, 117,  77,
	 48,  11,   0,   5,   0,  23,   3,   1,  77, 223, 238, 232, 207, 204, 204, 197,
	197, 197, 184, 172, 167, 167, 167, 182, 151, 130, 156, 168, 170, 176, 172, 166,
	156, 166, 176, 159, 162, 167, 172, 182, 199, 207, 216, 222, 232, 232, 232, 216,
	207, 193, 160, 148, 136, 127, 115, 115, 109,  50,   7,   1,   5,   1,  26, 122,
	223,  99,   0,   0,   2,   0,   0,   1,   1,   0,   0,   0,   0,   0,   1,   2,
	  3,   3,   0,   0,   3,   2,   1,   1,   0,   0,   1,   1,   0,   0,   2,   3,
	  3,   2,   2,   2,   0,   1,   1,  35, 164,  99,  66,  38,   4,   1,   8,  27,
	 30,   5, 106, 246, 223, 207, 199, 193, 188, 188, 197, 197, 204, 207, 207, 193,
	179, 170, 182, 149, 130, 156, 168, 170, 172, 170, 166, 154, 163, 186, 178, 199,
	223, 232, 238, 248, 248, 248, 245, 245, 241, 241, 241, 245, 253, 238, 211, 163,
	130, 115, 115,  98,   9,   0,   4,   5,   1,  26, 110, 223, 143,   0,   0,   3,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   3,   3,   0,   0,   2,
	  2,   1,   0,   0,   0,   0,   1,   0,   1,   4,   5,   3,   1,   1,   1,   0,
	  4,   4,  68, 164,  91,  59,  35,   1,  22,  41,  66,  29, 106, 232, 218, 207,
	186, 182, 184, 182, 182, 184, 193, 197, 211, 222, 222, 211, 199, 197, 149, 130,
	159, 168, 170, 168, 168, 170, 151, 172, 232, 238, 248, 252, 252, 252, 248, 253,
	248, 248, 245, 245, 248, 248, 253, 245, 253, 253, 245, 238, 172, 128,  69,   6,
	  0,   4,   0,   1,  32, 110, 211, 164,   0,   0,   4,   6,   1,   0,   0,   0,
	  0,   0,   0,   0,   1,   2,   2,   1,   0,   0,   2,   1,   0,   0,   0,   0,
	  0,   0,   0,   2,   5,   5,   2,   0,   0,   1,   0,   5,   1,  99, 153,  88,
	 58,  38,  33,  72,  81,  46,  84, 207, 216, 182, 193, 182, 172, 172, 176, 182,
	186, 193, 197, 207, 216, 232, 235, 232, 207, 149, 127, 159, 166, 167, 167, 170,
	176, 154, 186, 246, 246, 238, 235, 241, 246, 245, 235, 238, 245, 248, 248, 248,
	248, 245, 255, 255, 254, 254, 241, 110,  77, 128,  32,   4,   2,   1,   1,  31,
	110, 199, 188,   1,   2,   3,   9,   4,   0,   0,   1,   1,   0,   0,   0,   0,
	  1,   1,   0,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   1,   4,   6,
	  4,   1,   0,   0,   2,   0,   3,   0, 117, 134,  88,  62,  55,  99, 128,  66,
	100, 223, 207, 188, 188, 170, 176, 168, 162, 168, 182, 186, 178, 184, 193, 204,
	216, 232, 232, 211, 139, 125, 159, 166, 162, 167, 172, 182, 156, 184, 238, 222,
	223, 232, 245, 246, 241, 238, 238, 232, 232, 232, 238, 238, 238, 241, 255, 254,
	254, 254, 106,   7,  32,  51,   6,   1,   7,   2,  22, 103, 186, 211,   8,   4,
	  0,   8,   3,   0,   2,   2,   1,   0,   0,   0,   0,   0,   1,   0,   1,   1,
	  0,   1,   3,   2,   1,   0,   0,   1,   6,   6,   6,   4,   3,   2,   1,   0,
	  0,   0,   2, 122, 134,  84,  58, 100, 153,  66,  76, 216, 216, 188, 182, 166,
	166, 159, 159, 168, 176, 172, 172, 176, 176, 188, 188, 204, 222, 222, 197, 148,
	133, 156, 162, 162, 162, 176, 188, 162, 190, 222, 232, 228, 235, 245, 255, 254,
	238, 232, 232, 232, 238, 232, 232, 232, 232, 238, 248, 253, 253, 218,  11,  11,
	 44,  35,   4,   1,   1,  22, 110, 178, 223,  30,   0,   4,   4,   6,   9,   3,
	  1,   1,   0,   0,   2,   3,   1,   0,   1,   1,   1,   1,   1,   0,   0,   0,
	  0,   0,   1,   2,   2,   2,   1,   0,   0,   0,   0,   3,   0,   6, 143, 117,
	 65, 100, 178, 106,  31, 199, 216, 188, 172, 149, 128, 113,  98,  88,  88,  98,
	103, 113, 128, 157, 170, 176, 197, 211, 216, 204, 148, 136, 151, 156, 162, 172,
	188, 197, 176, 216, 232, 238, 238, 218, 188, 153, 117,  91,  77,  62,  62,  77,
	100, 128, 150, 193, 223, 245, 248, 253, 218,  30,   7,  62, 106,  72,  12,   1,
	 31, 100, 172, 228,  36,   0,   2,   0,   2,   5,   0,   1,   0,   0,   0,   0,
	  0,   0,   0,   1,   1,   1,   2,   1,   1,   1,   1,   1,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,  19, 153,  99,  84, 188, 128,   4, 143,
	209, 149, 103,  58,  15,  10,   1,   0,   0,   1,   0,   0,   1,  11,  24,  44,
	 76, 128, 172, 209, 207, 157, 123, 149, 160, 160, 157, 160, 176, 193, 209, 164,
	110,  66,  33,  10,   2,   0,   0,   0,   0,   0,   0,   0,   0,   1,  20,  66,
	128, 193, 248, 253, 128,   1,  48, 103, 143, 110,  72,  76, 110, 157, 241,  54,
	  0,   1,   0,   0,   1,   0,   0,   0,   1,   2,   1,   0,   0,   1,   1,   1,
	  1,   1,   2,   3,   6,   6,   5,   1,   0,   1,   1,   1,   1,   1,   1,   1,
	  1,   0,   6,  41, 153,  88, 164, 153,  33,  91, 153,  62,  26,   1,   1,   1,
	  3,   0,   0,   3,   6,   2,   0,   0,   1,   0,   2,   1,   1,   9,  50,  94,
	100,  50,  58,  62,  48,  32,  15,  22,  44,  29,  10,   1,   2,   1,   1,   2,
	  5,   3,   3,   3,   4,   3,   3,   3,   4,   3,   3,   1,  41, 117, 211, 218,
	 50,   2,  99, 164, 150, 143, 122, 103, 157, 246,  72,   2,   4,   0,   0,   2,
	  0,   0,   1,   5,   8,   6,   2,   0,   1,   1,   1,   1,   1,   1,   2,   4,
	  5,   4,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   0,   3,  68, 143,
	153, 178,  51,  54,  68,   3,   1,   1,   0,   2,   3,   1,   4,   1,   1,   4,
	  3,   0,   0,   0,   1,   1,   1,   1,   2,   2,   1,   1,   1,   1,   0,   0,
	  2,   0,   0,   2,   3,   0,   0,   6,   3,   1,   3,   3,   7,   5,   1,   1,
	  1,   1,   1,   3,   0,   8,   0,   1,   1,  35, 150, 199,  35,  12, 143, 186,
	178, 178, 134, 153, 246,  88,   1,   4,   0,   0,   1,   0,   0,   0,   3,   6,
	  5,   0,   0,   2,   1,   1,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,  81, 178, 211,  81,  32,  41,   0,
	  0,  14,   0,   4,   0,   0,   0,   3,   3,   7,  14,  19,  19,  16,  16,   3,
	  7,   3,   1,   1,   0,   0,   7,   0,   2,   0,   0,   0,   1,   1,   0,   4,
	  0,   3,   6,   9,  16,  17,  20,  16,  16,  15,   9,   6,   4,   1,   1,   6,
	  0,   0,   3,  13,   1,   9,  99, 153,  29,  88, 193, 186, 193, 211, 178, 241,
	 99,   0,   2,   0,   0,   0,   0,   2,   0,   0,   1,   0,   0,   0,   3,   1,
	  1,   1,   0,   1,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   1,   2,
	  2,   2,   2,   6, 106, 218, 122,  10,  32,   0,   1,   1,   0,   3,   0,   7,
	  0,   1,   7,  11,  16,  20,  27,  32,  39,  41,  44,  29,   9,   0,   0,   2,
	  0,   1,   1,  15,  16,  11,   5,   5,  10,   1,   0,   4,  14,  16,  17,  19,
	  6,   6,   6,   9,   9,   9,  12,  13,   9,   3,   0,   0,   9,   0,   0,   3,
	  0,   3,  68,  99,  40, 143, 223, 193, 238, 218, 246, 117,   0,   3,   0,   0,
	  0,   0,   3,   0,   0,   3,   3,   0,   0,   2,   1,   1,   1,   0,   3,   8,
	  9,   8,   4,   1,   0,   0,   1,   2,   3,   4,   6,   6,   6,   0,   0, 153,
	188,  27,  10,   0,   5,   5,   0,   0,   3,   0,   1,   4,   7,   7,  11,  11,
	  7,   2,   2,   7,  13,  15,  29,  46,  41,  14,   2,   1,   1,  15,  69, 110,
	117,  94,  69,  51,  12,  16,  20,  23,  12,  10,   5,   0,   6,   2,   1,   0,
	  0,   0,   6,   7,   5,   3,   5,   0,   3,   0,   3,   4,   0,   3,  32,  46,
	100, 188, 218, 211, 255, 255, 122,   4,   6,   0,   0,   0,   0,   2,   0,   2,
	 10,  11,   5,   0,   0,   1,   1,   1,   5,   4,   4,   5,   5,   5,   3,   1,
	  3,   0,   0,   8,  10,   5,   1,   2,   6,   0, 188,  68,   0,   4,   6,   3,
	  0,   0,   0,   0,   0,   4,   9,  11,   6,   4,   3,   3,   0,   0,   0,   2,
	  4,   2,   4,  16,  31,  48,  65,  81,  10,  77, 142, 157, 120, 109, 128,  44,
	 29,  12,   9,   9,   0,   0,   3,   0,   1,   6,   1,   0,   3,   6,   2,   0,
	  9,  11,   8,   0,   0,   3,   3,   0,   0,   6,  22,  55, 150, 218, 218, 248,
	252, 134,   1,   8,   6,   0,   4,   0,   2,   3,   5,   4,   3,   2,   2,   3,
	  1,   1,   1,   0,   0,   0,   0,   2,   2,   2,   0,   2,   0,   0,   4,   6,
	  3,   1,   2,   0,  54, 122,  23,   0,   6,   0,   4,   2,   0,   0,   1,   4,
	  5,   5,   6,   1,   0,   0,   2,   2,   0,   0,   2,   0,   0,   0,   0,   2,
	 20,  54,  77,   3,  65, 142, 170, 139, 128, 123,  38,  21,   9,   0,   0,   0,
	  2,   5,   2,   0,   4,   3,   0,   1,   0,   0,   0,   4,  10,  10,   5,   0,
	  1,   1,   0,   2,   0,   9,  12,  84, 193, 228, 246, 255, 153,   1,   4,   0,
	  3,   0,   0,   0,   1,   2,   1,   0,   0,   1,   2,   1,   1,   1,   1,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   0,  99,
	 46,   0,   0,   4,   0,   5,   5,   0,   0,   5,   9,   6,   1,   0,   1,   0,
	  0,   2,   3,   0,   0,   0,   0,   0,   1,   0,   0,   0,   3,   6,   1,  22,
	 32,  38,  76,  69,  32,   3,   1,   1,   1,   1,   2,   0,   0,   1,   3,   7,
	  6,   5,   6,   5,   1,   1,   0,   6,  11,  10,   4,   0,   0,   2,   2,   0,
	  3,   1,  27, 143, 228, 246, 255, 164,   0,   2,   0,   3,   0,   2,   0,   0,
	  0,   0,   0,   0,   2,   4,   0,   0,   0,   6,   5,   2,   1,   1,   1,   0,
	  0,   0,   1,   1,   0,   0,   0,   0,   0,  25,  72,   2,   0,   6,   0,   0,
	  5,   3,   0,   1,   8,  10,   5,   0,   0,   1,   0,   0,   1,   0,   0,   2,
	  7,   1,   3,   5,   8,  12,  14,   7,   0,  51,  50,  55,  48,  84,  58,   1,
	  0,   7,   3,   0,   0,   1,   2,   2,   1,   5,   4,   2,   1,   0,   0,   0,
	  1,   0,   2,   8,  11,   8,   1,   0,   4,   0,   3,   2,   5,   1,  66, 199,
	252, 252, 188,   0,   1,   0,   0,   0,   1,   2,   2,   2,   1,   1,   2,   5,
	  6,   0,   0,   0,   8,   6,   3,   2,   2,   2,   1,   0,   1,   3,   4,   2,
	  0,   0,   0,   0,  41,  25,   0,   8,   5,   1,   3,   4,   0,   0,   6,  10,
	  8,   1,   0,   0,   0,   0,   0,   0,   0,   0,   9,  23,  66,  88, 106, 110,
	 99,  72,  33,   6,  51,  65, 142, 142,  65,  12,   1,   1,   6,  39,  84,  99,
	 69,  35,  15,   2,   3,   1,   3,   8,   6,   2,   1,   3,   2,   0,   2,   9,
	 10,   5,   2,   3,   2,   5,   0,   4,   0,   4, 117, 246, 255, 218,  13,   0,
	  4,   0,   4,   0,   1,   2,   2,   1,   0,   2,   4,   6,   0,   0,   0,   2,
	  1,   0,   0,   1,   2,   1,   1,   1,   3,   5,   5,   2,   0,   2,   5,  32,
	  2,   5,   0,   0,   6,   2,   1,   0,   3,  10,   9,   4,   0,   0,   2,   0,
	  0,   2,   0,   0,   0,  11,  24,  35,  35,  35,  27,  16,   9,   2,   1,   2,
	  6,  26,  32,  32,   9,   3,   9,   1,   9,  55, 117, 150, 164, 142, 110,  32,
	  8,   0,   0,   2,   5,   6,   4,   4,   0,   0,   4,   9,   8,   3,   1,   3,
	  0,   0,   0,   6,   0,  39, 193, 255, 246,  68,   0,   6,   4,   8,   0,   0,
	  0,   0,   0,   0,   0,   1,   3,   0,   0,   0,   0,   0,   0,   0,   1,   2,
	  1,   0,   1,   0,   3,   5,   2,   0,   4,  11,  14,   0,   6,   0,   0,   5,
	  0,   0,   0,   6,  10,   6,   0,   0,   1,   1,   4,   2,   2,   1,   0,   0,
	  6,  14,   2,   1,   1,   1,   0,   0,   0,   2,  44,  84,  84, 103, 128,  54,
	  0,   0,  11,   0,   0,   9,  46,  94, 122, 122,  88,  46,  12,   1,   0,   1,
	  3,   2,   3,   0,   0,   3,   6,   8,   4,   0,   2,   0,   5,   0,  11,   2,
	  2, 100, 241, 255, 143,   6,   2,   6,   3,   0,   0,   0,   0,   0,   0,   0,
	  0,   1,   1,   1,   1,   2,   1,   1,   1,   2,   2,   0,   0,   0,   0,   0,
	  3,   1,   0,   6,  17,   6,   3,   1,   2,   2,   0,   1,   0,   1,  10,  10,
	  2,   0,   1,   2,   0,   1,   0,   0,   1,   3,   3,   6,   9,   5,   2,   1,
	  2,   0,   0,   0,   0,  13,  33,  65, 103,  76,   2,  11,   4,   1,   4,   5,
	  0,   0,   2,  10,  14,  19,   2,   1,   6,   4,   0,   3,   5,   0,   0,   0,
	  3,   6,   6,   3,   0,   0,   0,   1,   0,   0,   0,   2,  22, 211, 255, 211,
	 14,   0,   4,   0,   4,   1,   2,   3,   3,   1,   1,   1,   2,   1,   1,   1,
	  4,   2,   0,   0,   1,   2,   2,   1,   1,   4,   0,   2,   1,   0,   8,   9,
	  2,   1,   1,   0,   0,   0,   0,   0,   0,  14,   6,   1,   2,   0,   0,   3,
	  0,   0,   0,   0,   4,   7,   7,   7,   6,   1,   3,   3,   0,   0,   3,   0,
	 11,  84,  66,  91, 106,  31,  11,   0,   1,   2,   1,   2,   6,   4,   0,   2,
	  0,   0,   1,   1,   0,   0,   0,   0,   0,   1,   1,   0,   2,   5,   4,   0,
	  2,   2,   2,   2,   2,   2,   2,   2,  94, 255, 255,  88,   0,   5,   0,   4,
	  0,   0,   0,   1,   2,   2,   3,   3,   1,   1,   1,   4,   2,   0,   0,   0,
	  1,   1,   0,   1,   5,   0,   1,   1,   1,   9,   8,   2,   1,   1,   0,   0,
	  0,   0,   0,   0,  10,   2,   0,   2,   0,   0,   2,   1,   1,   1,   0,   0,
	  0,   1,   3,   0,   7,   4,   0,   5,   4,   0,   1,  11,  54, 106, 143, 143,
	 27,   0,   4,   5,   0,   6,   7,   0,   0,   4,   0,   4,   4,   4,   3,   3,
	  1,   1,   1,   0,   1,   1,   0,   2,   5,   4,   0,   1,   1,   1,   1,   1,
	  1,   1,   1,  29, 211, 252, 164,   6,   3,   6,   0,   0,   0,   0,   1,   2,
	  3,   3,   4,   1,   1,   1,   5,   3,   0,   0,   0,   0,   0,   0,   1,   5,
	  1,   0,   1,   5,   9,   5,   2,   1,   1,   0,   0,   0,   0,   0,   0,   6,
	  0,   0,   2,   1,   0,   0,   0,   1,   2,   2,   0,   1,   4,   6,   0,   0,
	  0,   0,   0,   0,   2,  10,   1,   3,  14,   1,   1,  12,   7,   3,   3,   0,
	  0,   1,   3,   0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   2,   0,   1,
	  1,   1,   2,   5,   4,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0, 106,
	255, 241,  46,   2,   0,   0,   0,   0,   0,   1,   2,   3,   4,   4,   1,   1,
	  1,   6,   4,   2,   0,   0,   0,   0,   1,   1,   4,   2,   0,   2,   9,   9,
	  3,   2,   1,   1,   0,   0,   0,   0,   0,   0,   6,   3,   0,   3,   2,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   5,   8,
	  0,   6,   5,  12,  77,   6,  11,   0,  21,   4,   5,   4,   3,   2,   4,   4,
	  1,   0,   1,   1,   1,   1,   0,   0,   0,   0,   2,   2,   1,   2,   5,   4,
	  1,   0,   0,   0,   0,   0,   0,   0,   0,   4,  17, 223, 255, 134,   0,   0,
	  1,   0,   0,   0,   1,   3,   4,   4,   5,   1,   1,   1,   6,   5,   4,   2,
	  0,   0,   1,   2,   0,   3,   2,   0,   2,  11,   8,   1,   2,   1,   1,   0,
	  0,   0,   0,   0,   0,   6,  10,   5,   3,   1,   0,   1,   0,   0,   0,   0,
	  1,   1,   0,   0,   0,   1,   1,   3,   6,   0,   0,   5,   6,   1,  31, 199,
	 91,   1,   4,  68,  68,   7,   0,   4,   0,   0,   3,   0,   0,   0,   1,   1,
	  1,   1,   0,   0,   0,   1,   1,   0,   2,   5,   4,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   6,   0, 122, 255, 223,  14,   5,   4,   0,   0,   0,   1,
	  2,   3,   4,   4,   1,   1,   1,   4,   4,   4,   3,   1,   0,   1,   2,   0,
	  0,   2,   0,   3,   9,   5,   2,   2,   1,   1,   0,   0,   0,   0,   0,   0,
	  5,  12,   6,   2,   2,   0,   2,   0,   0,   0,   0,   1,   1,   0,   0,   7,
	  0,   0,   1,   1,   6,  20,   6,   3,   2,  59, 238, 164,   1,   2,  11,  99,
	 72,  39,  24,  20,  10,   5,   9,   9,   9,   9,   8,   6,   4,   2,   1,   0,
	  1,   1,   0,   2,   4,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  5,  35, 246, 255,  88,   0,   3,   0,   0,   0,   1,   1,   2,   2,   2,   1,
	  1,   1,   0,   2,   3,   3,   1,   0,   0,   1,   0,   0,   2,   0,   3,   8,
	  2,   2,   2,   1,   1,   0,   0,   0,   0,   0,   0,   2,  10,   4,   0,   4,
	  0,   3,   5,   5,   4,   1,   0,   0,   1,   5,   1,   4,  22,  22,  38, 106,
	106,  26,   0,   0,  66, 245, 188,   5,   0,   1,  32,  94,  91,  38,  26,  26,
	 22,  31,  29,  27,  23,  16,   9,   5,   2,   1,   0,   0,   0,   0,   1,   4,
	  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   4, 164, 255, 188,
	  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   0,   0,   2,
	  2,   0,   0,   0,   0,   0,   0,   2,   1,   4,   7,   0,   3,   2,   1,   1,
	  0,   0,   0,   0,   0,   2,   0,   5,   0,   0,   6,   2,   3,   4,   9,  13,
	 14,  14,  23,  36,  46,  66,  94, 110, 128, 150, 134,  65,   2,   9,   3,  29,
	172, 117,   4,   3,  13,   2,  15,  58, 110, 122,  84,  44,  31,  13,   9,   6,
	  2,   0,   1,   2,   3,   0,   0,   0,   0,   0,   3,   2,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   5,   0,   1,  81, 255, 241,  36,   0,   1,   1,   0,
	  0,   0,   0,   0,   0,   1,   1,   1,   0,   0,   0,   0,   1,   1,   1,   1,
	  0,   0,   1,   6,   6,   3,   1,   3,   0,   0,   0,   0,   0,   0,   0,   0,
	  2,   0,   0,   1,   3,   4,   3,   2,   1,   0,   0,   1,   6,  10,  20,  35,
	 88, 123, 157, 164, 122,  50,  12,  24,  27,   9,   9,  12,   9,   1,   9,  38,
	  2,   0,   3,  10,  41,  77, 143, 178, 149, 128, 109,  76,  65,  76,  76,  44,
	  0,   0,   0,   1,   0,   0,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,
	  0,   6,   0,   2, 188, 255, 128,   2,   3,   0,   0,   2,   1,   0,   0,   0,
	  1,   1,   1,   0,   0,   0,   0,   1,   1,   1,   1,   0,   0,   1,   6,   6,
	  3,   1,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   3,   4,   3,
	  1,   0,   0,   3,   6,  24,  38,  62,  84, 100, 134, 157, 178, 142,  58,  20,
	 24,  29,  29,  12,  27,  77, 128, 122,  59,  12,  20,  17,   7,   1,   1,   3,
	 12,  35,  55,  38,  55,  69, 122, 172, 134,  55,  10,   5,   0,   1,   4,   1,
	  3,   4,   0,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   6,   4,  91,
	255, 211,   6,   0,   0,   0,   0,   1,   1,   1,   2,   1,   1,   1,   0,   0,
	  0,   0,   1,   1,   1,   1,   0,   0,   2,   5,   6,   3,   2,   2,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   1,   3,   0,   0,   0,   3,   9,   2,  69,
	143, 150, 142, 128, 123, 149, 150,  88,  26,  12,  48,  62,  35,  22,  40,  66,
	 54,  16,  36,  88,  77,  31,  23,  14,  12,  12,  22,  22,  32,  32,  44,  44,
	 26,  48,  84,  48,   1,   2,   2,   0,   0,   1,   0,   0,   1,   0,   1,   1,
	  1,   1,   1,   1,   1,   1,   1,   0,   4,   0,  11, 211, 255,  68,   0,   3,
	  4,   0,   1,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,
	  1,   1,   2,   3,   5,   5,   3,   2,   2,   0,   0,   0,   0,   0,   0,   0,
	  0,   1,   2,   3,   6,   6,   7,   4,   1,   2,  72, 110,  84,  55,  48,  38,
	 48,  35,  22,  32,  50,  54,  39,  20,  41,  46,   3,   1,  13,   6,   3,  32,
	 68,  22,  20,  24,  32,  50,  62,  69,  72,  65,  65,  50,  26,  10,   0,   1,
	  7,   0,   1,   5,   5,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,
	  1,   3,   4,   0,   1,   0, 128, 255, 153,   0,   0,   6,   0,   2,   1,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   2,   3,   4,   4,
	  3,   3,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   4,   3,
	  0,   0,   2,   4,  16,  50,  54,  39,  39,  41,  36,  24,  15,  10,  16,  14,
	 29,  41,  13,   1,   1,  22,  99, 143,  99,  35,   9,  21,  46,  38,  31,  22,
	 17,  17,  15,  15,  20,  33,  50,  50,  44,  54,  59,  46,  32,  35,  36,  30,
	 11,   1,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   5,   0,   2,   6,
	  0,  36, 235, 228,  25,   0,   4,   0,   2,   1,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   1,   1,   1,   1,   2,   4,   4,   3,   2,   3,   2,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,  13,  24,  32,  35,
	 35,  16,  16,  11,   0,   1,   1,   0,   0,   5,   1,   0,   3,   0,   6,  13,
	 88, 164, 188, 143,  88,  29,   1,  14,  14,   9,   4,   1,   1,   1,   1,   2,
	  0,   0,   1,   9,  18,  24,  27,  35,  36,  39,  30,  10,   0,   0,   0,   1,
	  1,   1,   1,   1,   1,   1,   1,   2,   0,   5,   0,   6,   0, 164, 255,  88,
	  0,   0,   1,   3,   3,   0,   4,   0,   0,   0,   0,   0,   0,   0,   1,   1,
	  1,   1,   2,   5,   5,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   4,   0,   0,  10,  30,  41,  35,  25,   4,   0,   0,   6,   4,   0,
	  0,   5,   3,   3,   3,   0,   0,   1,   0,   0,   9,  81, 134, 117,  88,  68,
	 32,   6,   5,  10,   5,   5,   0,   7,   4,   5,   3,   3,   1,   1,   2,   0,
	  0,   4,   1,   1,   3,   3,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,
	  1,   1,   0,   0,   2,   0,  11,   0,  68, 246, 164,  11,   0,   2,   1,   4,
	  0,   5,   1,   1,   1,   0,   0,   0,   0,   1,   1,   1,   1,   3,   5,   5,
	  2,   1,   3,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
	  8,  12,   9,   2,   0,   2,   1,   1,   1,   0,   1,   6,   0,   1,   0,   0,
	  0,   0,   1,   4,   1,  17,  44,  66,  54,  51,  54,  33,   6,   3,   6,   1,
	  1,   1,   4,   1,   1,   1,   1,   3,   3,   1,   3,   5,   1,   6,   2,   1,
	  1,   0,   2,   5,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   3,
	  1,   0,   9,   6, 211, 246,  30,   1,   2,   0,   4,   0,   2,   1,   1,   1,
	  2,   3,   2,   0,   0,   2,   4,   1,   4,   5,   5,   4,   1,   0,   1,   2,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   0,   0,   1,   3,
	  0,   1,   1,   1,   0,   0,   2,   4,   0,   0,   1,   2,   2,   3,   3,   4,
	 16,  33,  44,  39,  54,  46,  24,  12,   2,   9,   6,   4,  14,  19,   9,   1,
	  2,   2,   3,   3,   3,   1,   1,   6,   3,   2,   2,   2,   1,   0,   0,   0,
	  2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   5,   0,   5,   0,  10,  99,
	255,  94,   4,   0,   3,   3,   0,   0,   1,   8,   4,   1,   2,   1,   0,   0,
	  1,   2,   0,   5,   6,   6,   4,   1,   0,   0,   1,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   1,   2,   2,   0,   0,   0,   2,   0,   1,   1,   0,   0,
	  0,   1,   3,   3,   3,   2,   2,   2,   2,   3,   3,  14,  29,  36,  33,  46,
	 50,  31,  10,   5,   6,   9,   4,   5,  16,  22,  12,   4,   0,   1,   2,   3,
	  1,   1,   1,   3,   2,   2,   2,   1,   0,   0,   0,   1,   1,   1,   1,   1,
	  1,   1,   1,   2,   0,   2,   0,   5,   0,   0,  32, 228, 188,   0,   2,   0,
	  2,   3,   0,   0,   6,   1,   0,   2,   1,   0,   0,   1,   0,   0,   7,   7,
	  6,   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
	  2,   3,   1,   0,   0,   0,   1,   1,   0,   0,   0,   0,   2,   4,   8,   6,
	  4,   2,   1,   2,   3,   4,  16,  32,  36,  35,  39,  44,  36,  17,   7,   3,
	  7,   7,   1,   7,  23,  24,  16,   7,   1,   1,   3,   4,   3,   1,   3,   2,
	  2,   2,   1,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   6,   0,
	  0,   0,   1,   3,   0,   0, 128, 255,  32,   5,   0,   0,   1,   0,   0,   5,
	  1,   0,   1,   0,   0,   1,   0,   0,   0,   8,   7,   5,   3,   1,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   3,   3,   3,   1,   0,
	  0,   1,   0,   0,   0,   1,   3,   6,   8,   9,   7,   4,   2,   2,   3,   4,
	  5,   6,  18,  21,  19,  17,  17,  17,  13,   7,   2,   5,  14,   7,   1,   5,
	 24,  29,  19,   6,   1,   1,   3,   4,   4,   3,   2,   2,   2,   1,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   4,   6,
	  0,  32, 248, 122,   0,   1,   0,   0,   0,   1,   6,   2,   0,   2,   0,   0,
	  3,   1,   0,   2,   9,   7,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   1,   2,   3,   3,   2,   1,   0,   0,   0,   0,   2,
	  4,   7,   9,  12,  10,   6,   3,   2,   3,   5,   6,   6,   2,   4,   0,   0,
	  4,   0,   2,   1,   3,   5,   2,  13,  24,   8,   0,   9,  24,  21,  12,   5,
	  1,   1,   4,   6,   3,   2,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   6, 188, 218,   1,
	  0,   5,   0,   0,   1,   5,   1,   0,   2,   0,   0,   5,   3,   0,   6,   9,
	  7,   3,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   1,   2,   3,   3,   2,   1,   0,   0,   0,   3,   6,   9,  11,  12,   6,
	  5,   2,   2,   5,   6,   5,   5,   3,   3,   1,   1,   3,   1,  11,   1,   1,
	  9,   1,   5,  29,  27,   6,   0,   6,   9,  11,   7,   3,   3,   3,   4,   3,
	  2,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  1,   0,   0,   1,   0,   0,   2,   4,  99, 255,  54,   0,   0,   0,   2,   0,
	  2,   0,   0,   3,   0,   0,   6,   4,   2,  10,   9,   6,   2,   0,   1,   1,
	  1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   3,   4,
	  4,   3,   0,   0,   1,   3,   6,   9,   9,   8,   4,   2,   2,   3,   6,   6,
	  3,   0,   1,  24,  46,  20,   1,   1,  39,   9,   2,   7,   4,   0,  13,  30,
	 21,   1,   0,   5,  10,   5,   4,   4,   4,   1,   3,   2,   2,   2,   1,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   1,
	  3,   6,   0,  25, 218, 153,   0,   0,   0,   0,   0,   1,   0,   0,   3,   0,
	  0,   8,   6,   3,  13,   9,   5,   2,   0,   1,   2,   2,   2,   0,   0,   0,
	  0,   0,   0,   0,   0,   1,   0,   0,   0,   3,   5,   5,   4,   0,   0,   1,
	  3,   6,   7,   6,   4,   2,   1,   3,   4,   6,   5,   1,   0,   1,  55, 106,
	 54,   1,   1,  66,  33,   4,   1,   7,   1,   0,  16,  30,   9,   4,   7,   6,
	  3,   3,   5,   6,   4,   3,   2,   2,   2,   1,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   1,   0,   2,   0,   0,   0,   0,   0,   1,   0, 153,
	241,  11,   3,   5,   0,   1,   3,   0,   2,   3,   2,   3,   5,   1,   4,  25,
	  7,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  1,   1,   1,   0,   0,   2,   6,   9,   5,   1,   3,   0,   2,   6,   2,   5,
	  1,   8,   0,   4,   5,   5,   1,   1,   1,  62, 109,  58,   0,   4,  62,  76,
	  1,   0,   4,   0,   0,   3,  11,  20,   0,   1,   7,  12,   0,   4,   2,   4,
	  5,   4,   2,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   3,  41, 255,  91,   5,   3,   0,
	  1,   1,   1,   0,   1,   0,   1,   1,   1,  10,  25,   7,   4,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,
	  2,   5,   8,   3,   0,   1,   2,   0,   2,   2,   2,   4,   2,   1,   9,   5,
	 24,  17,   3,   1,  58, 109,  58,   0,   1,  65,  98,  12,   1,   4,   9,   6,
	  1,   9,   7,  13,   3,   1,   8,   3,   6,   0,   5,   5,   3,   2,   1,   2,
	  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   1,   1,   2, 188, 188,   0,   1,   3,   1,   1,   1,   0,   0,
	  0,   1,   0,   1,  18,  25,   6,   3,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   0,   1,   3,   5,   4,   0,
	  0,   4,   1,   0,   4,   2,   6,   0,   5,  11,   1,  44,  31,   1,   2,  69,
	123,  65,   0,   1,  65, 123,  38,   0,   3,  29,  31,   0,   3,   1,  17,   3,
	  0,   3,   8,  13,   2,   6,   5,   3,   1,   1,   1,   2,   0,   0,   2,   2,
	  1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,  68, 248,  35,   1,   1,   1,   1,   1,   2,   2,   0,   4,   0,   2,  27,
	 22,   5,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   1,   1,   1,   1,   1,   1,   9,   5,   0,   2,   4,   3,   5,
	  4,   8,   3,   5,   5,   9,  65,  41,   0,   3,  76, 133,  76,   1,   1,  58,
	128,  65,   0,   1,  54,  65,   1,   0,   5,   7,   6,   4,   1,   6,  13,   5,
	  3,   5,   5,   1,   1,   1,   1,   0,   0,   3,   3,   2,   2,   1,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  10,   3, 188, 134,   0,
	  1,   1,   1,   1,   5,   5,   0,   4,   0,   9,  32,  22,   3,   2,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
	  1,   1,   0,   0,  11,   9,   2,   0,   3,   4,   2,   4,   4,   5,   2,   3,
	 48, 110,  55,   4,   1,  76, 139,  88,   1,   1,  58, 130,  84,   1,   0,  58,
	100,  32,   0,   5,   2,   8,   9,   2,   0,   2,   8,   9,   7,   5,   2,   1,
	  1,   1,   1,   0,   3,   3,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   5,   0,   0,   6,  68, 218,  21,   0,   1,   1,   1,   5,
	  6,   1,   3,   3,  17,  35,  18,   2,   1,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   2,   2,   1,   0,   7,
	  9,  13,   2,   0,   4,   0,   1,   1,   5,   0,   4,  76, 142,  62,   0,   1,
	 76, 133,  88,   0,   1,  55, 130, 100,   5,   0,  55, 120,  76,   5,   1,   0,
	  4,   2,   3,   0,   0,  23,  29,   9,   7,   5,   2,   1,   1,   1,   0,   2,
	  2,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
	  3,   0,   4,   6, 211, 106,   0,   1,   1,   1,   3,   3,   1,   0,   7,  25,
	 32,  17,   1,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   1,   0,   0,   0,   2,   3,   2,   1,   0,   8,  36,  19,   0,   4,
	  0,   0,   0,   3,   0,   1,  84, 128,  65,   1,   2,  65, 128, 100,   0,   1,
	 48, 128, 103,   5,   0,  44, 120, 103,   6,   1,   3,   5,   0,   6,   2,   0,
	 41,  35,  14,   9,   5,   3,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   4,   0,   0,  99,
	188,  17,   1,   1,   1,   0,   0,   0,   0,   9,  32,  32,  17,   1,   0,   0,
	  0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,
	  0,   2,   3,   3,   2,   0,   8,  54,  36,   0,   6,   5,   0,   0,   0,   3,
	  2,  69, 113,  72,   4,   1,  55, 123, 100,   3,   1,  44, 123, 103,   4,   2,
	 44, 115, 109,   3,   3,  11,  14,   3,   9,   6,   5,  46,  23,  16,  12,   7,
	  3,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   4,   0,   0,   6,   1,  10, 218,  68,   1,   1,   1,
	  5,   0,   2,   0,  14,  39,  19,  10,   2,   1,   1,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   1,   0,   2,
	  5,   0,  19,  68,  23,   0,   1,   5,  26,  32,   9,   1,  48,  99,  77,   1,
	  2,  58, 117,  84,  15,   2,  38, 113, 100,  15,   2,  38, 103, 100,  20,   2,
	 16,  66,  12,   1,   5,   7,  41,  29,  12,   8,   4,   0,   5,   0,   4,   1,
	  1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   1,   0,   6, 117, 164,   0,   1,   1,   0,   0,   3,   2,   3,
	 11,  10,   5,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   3,   5,   0,   0,   3,   5,   1,   0,   0,  23,  54,  81,  35,
	  5,   0,   9,  88,  88,  65,  58,  76, 100, 100,  69,  84,  81,  94,  94, 100,
	110, 100, 103, 100,  76,  84,  91, 103, 100,  58,  58,  36,  44,   3,   5,  10,
	 19,  99,  81,  31,   1,   4,   3,   0,   0,   0,   0,   1,   1,   1,   1,   1,
	  1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   3,   0,   4,
	  0,  68, 188,   9,   0,   0,   0,   5,   0,   6,   5,   5,   7,   3,   2,   1,
	  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   4,   4, 117, 246, 241,  77,   4,   3,  21,  38,  35,
	 31,  38,  46,  38,  38,  38,  36,  20,  20,  26,  46,  59,  44,  32,  44,  54,
	 66,  46,  29,  22,  10,  17,   9,   6,   0,   1,   0,  54, 235, 241, 153,  35,
	  1,   0,   0,   6,   6,   0,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   3,   6,   0,   6,   0,  14, 188,  22,   3,
	  3,   0,   4,   0,   5,  27,  46,  23,   2,   2,   1,   1,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   4,   2,   0,  11,
	 35,  32, 128, 199, 223,  94,   0,   1,   0,   3,   0,   0,   5,   8,   2,   0,
	  0,   0,   0,   3,   1,   1,   1,   1,   5,   1,   3,   6,   3,   1,   1,   1,
	  4,   7,   2,   3,   0,   0,  54, 241, 218, 188,  35,   2,   6,   0,   0,   0,
	  0,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,
	  0,   1,   0,   5,   0,   0,   3,   0, 134,  16,   0,   0,   2,   0,   0,   1,
	 46,  94,  41,   2,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   3,   3,   0,   0,   0,   0,   2,  16,  50, 106, 218, 246,
	 91,   4,  13,  24,  16,  14,  14,  13,  11,  13,  13,  13,  16,  14,  17,  13,
	 12,  13,  12,  16,  12,   9,   6,  13,  13,   7,  10,  10,   6,   8,  16,  11,
	 19,  68, 241, 228, 164,  29,   6,  11,   5,   6,   4,   1,   1,   1,   1,   1,
	  1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   1,   2,
	  0,   6,   4,  77,   8,   0,   0,   2,   0,   3,   0,  41, 106,  50,   1,   2,
	  1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   5,   6,   0,   0,   0,  91, 164, 134,  27,   4,   9,  13,  19,
	 19,  24,  27,  29,  32,  29,  29,  30,  32,  36,  36,  36,  36,  36,  39,  41,
	 40,  36,  41,  36,  32,  35,  32,  27,  24,  25,  17,  13,  24, 128, 143,  35,
	  0,  41,  50,  24,   3,   0,   5,   1,   1,   1,   1,   1,   1,   1,   1,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   6,  35,   3,
	  5,   5,   1,   0,   4,   0,  17,  94,  59,   1,   2,   1,   1,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   1,   0,   0,   0,
	  0,   1,  99, 188,  59,   0,   0,   2,   5,   5,   6,   3,   6,  10,  16,  17,
	 10,  12,  10,  14,  18,  21,  19,  19,  22,  22,  29,  27,  24,  27,  23,  21,
	 23,  14,  13,   7,   9,  13,  13,   0,   6,   0,   2,   3,  29,  39,  35,  13,
	  1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   2,   1,   4,   0,   5,  12,   0,   0,   0,   1,   0,   1,
	  1,   0,  68,  68,   3,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   2,   3,   0,   1,  36,  88, 134,  68,   3,
	  6,   0,   8,   3,   5,   7,   7,  18,  22,  25,  30,  22,  22,  17,  22,  22,
	 22,  17,  13,  22,  22,  27,  24,  22,  27,  22,  25,  27,  18,   1,   3,   8,
	  1,   0,   3,   2,   1,   0,   3,   6,  20,  44,  19,   1,   0,   1,   1,   1,
	  1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   6,
	  0,   5,   0,   5,   0,   1,   0,   0,   0,   0,   0,   8,   0,  30,  88,  35,
	  0,   0,   2,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   1,  81, 128,  81,   6,   0,   3,   0,   2,   2,   6,
	  6,   9,  14,  19,  21,  19,  17,  13,  19,  19,  19,  19,  19,  19,  22,  22,
	 27,  24,  23,  23,  23,  19,  13,   6,   3,   3,   2,   2,   1,   0,   0,   0,
	  1,   0,   1,   9,  23,  25,  13,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
	  1,   1,   1,   0,   3,   0,   4,   6,   8,  41,  68,  24,   9,   0,   0,   0,
	  0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   2,   0,   0,
	  5,  81, 122,  36,   0,   0,   5,   0,   0,   0,   4,   5,   6,   8,  11,  13,
	 17,  21,  23,  22,  22,  22,  22,  19,  19,  22,  24,  24,  24,  24,  23,  17,
	 13,   8,   5,   3,   3,   2,   1,   1,   0,   0,   0,   1,   0,   0,   6,  14,
	 18,   9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   3,   9,
	  0,   0,   5,   0,   0,  30,  35,  16,   3,   0,   0,   0,   0,   3,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   1,   7,  54,  68,   6,   0,
	  3,   3,   0,   1,   0,   0,   3,   3,   3,   5,   9,  13,  18,  21,  23,  25,
	 27,  25,  21,  18,  19,  23,  23,  24,  24,  19,  11,   5,   3,   4,   2,   2,
	  2,   1,   1,   0,   0,   0,   0,   0,   0,   1,   6,   9,   7,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   4,   5,   0,   1,   6,   0,
	  0,   9,   9,   9,   6,   4,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   1,   5,   0,   0,   0,  11,   3,   1,   0,   3,   0,   0,   5,   0,
	  0,   0,   1,   3,   5,   7,   9,  11,  11,  19,  23,  27,  27,  23,  21,  19,
	 21,  24,  24,  23,  14,   6,   1,   1,   3,   2,   1,   1,   1,   0,   0,   0,
	  0,   0,   1,   1,   0,   0,   3,   3,   1,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   2,   2,
	  2,   1,   1,   1,   0,   0,   0,   2,   0,   1,   6,   0,   0,   0,   4,   8,
	  9,   9,   5,   2,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
	  2,   0,   5,   0,   4,   3,   1,   0,   0,   3,   0,   2,   0,   1,   2,   4,
	  5,   5,   5,   4,  13,  18,  25,  30,  30,  27,  25,  25,  27,  23,  14,   8,
	  3,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   2,   3,   0,
	  0,   1,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   1,   1,   1,   1,   2,   2,   2,   0,   0,   0,   1,
	  1,   0,   0,   3,   0,   0,   1,   9,   0,   0,   6,   9,   6,   2,   2,   0,
	  0,   0,   0,   0,   0,   0,   0,   9,   2,   0,   0,   3,   0,   0,   0,   0,
	  1,   0,   0,   0,   0,   0,   4,   1,   0,   0,   0,   1,   3,   4,   6,   6,
	 12,  21,  27,  30,  30,  29,  29,  21,  14,   7,   3,   2,   2,   2,   1,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   2,   4,   1,   0,   1,   2,   1,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   1,   1,   1,   1,   1,   0,   0,   0,   0,   8,   0,   2,  13,   6,
	  0,   6,  16,   5,   0,   2,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   1,   2,   1,   0,   0,   0,   2,   4,   5,   3,   6,  10,  14,  18,  21,
	 18,  18,   9,   6,   3,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   2,   2,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
	  1,   1,   0,   0,   0,   0,   6,   5,   2,   5,   3,   0,   5,   1,   2,   1,
	  0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   3,
	  0,   0,   1,   0,   0,   1,   2,   0,   0,   1,   0,   0,   0,   2,   2,   2,
	  2,   2,   1,   1,   0,   3,   1,   1,   4,   6,   7,   5,   3,   0,   0,   1,
	  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
	  0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0};
