// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Summary information about the DataIntegration association.
type DataIntegrationAssociationSummary struct {

	// The identifier for teh client that is associated with the DataIntegration
	// association.
	ClientId *string

	// The Amazon Resource Name (ARN)of the DataIntegration.
	DataIntegrationArn *string

	// The Amazon Resource Name (ARN) of the DataIntegration association.
	DataIntegrationAssociationArn *string

	noSmithyDocumentSerde
}

// Summary information about the DataIntegration.
type DataIntegrationSummary struct {

	// The Amazon Resource Name (ARN) of the DataIntegration.
	Arn *string

	// The name of the DataIntegration.
	Name *string

	// The URI of the data source.
	SourceURI *string

	noSmithyDocumentSerde
}

// The event filter.
type EventFilter struct {

	// The source of the events.
	//
	// This member is required.
	Source *string

	noSmithyDocumentSerde
}

// The event integration.
type EventIntegration struct {

	// The event integration description.
	Description *string

	// The Amazon EventBridge bus for the event integration.
	EventBridgeBus *string

	// The event integration filter.
	EventFilter *EventFilter

	// The Amazon Resource Name (ARN) of the event integration.
	EventIntegrationArn *string

	// The name of the event integration.
	Name *string

	// The tags.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The event integration association.
type EventIntegrationAssociation struct {

	// The metadata associated with the client.
	ClientAssociationMetadata map[string]string

	// The identifier for the client that is associated with the event integration.
	ClientId *string

	// The name of the EventBridge rule.
	EventBridgeRuleName *string

	// The Amazon Resource Name (ARN) for the event integration association.
	EventIntegrationAssociationArn *string

	// The identifier for the event integration association.
	EventIntegrationAssociationId *string

	// The name of the event integration.
	EventIntegrationName *string

	noSmithyDocumentSerde
}

// The name of the data and how often it should be pulled from the source.
type ScheduleConfiguration struct {

	// The start date for objects to import in the first flow run.
	FirstExecutionFrom *string

	// The name of the object to pull from the data source.
	Object *string

	// How often the data should be pulled from data source.
	ScheduleExpression *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
