// Code generated by smithy-go-codegen DO NOT EDIT.

package route53resolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53resolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the behavior configuration of Route 53 Resolver behavior for a single
// VPC from Amazon Virtual Private Cloud.
func (c *Client) UpdateResolverConfig(ctx context.Context, params *UpdateResolverConfigInput, optFns ...func(*Options)) (*UpdateResolverConfigOutput, error) {
	if params == nil {
		params = &UpdateResolverConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateResolverConfig", params, optFns, c.addOperationUpdateResolverConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateResolverConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateResolverConfigInput struct {

	// Indicates whether or not the Resolver will create autodefined rules for reverse
	// DNS lookups. This is enabled by default. Disabling this option will also affect
	// EC2-Classic instances using ClassicLink. For more information, see [ClassicLink]in the
	// Amazon EC2 guide.
	//
	// We are retiring EC2-Classic on August 15, 2022. We recommend that you migrate
	// from EC2-Classic to a VPC. For more information, see [Migrate from EC2-Classic to a VPC]in the Amazon EC2 guide
	// and the blog [EC2-Classic Networking is Retiring – Here’s How to Prepare].
	//
	// It can take some time for the status change to be completed.
	//
	// [ClassicLink]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html
	// [Migrate from EC2-Classic to a VPC]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html
	// [EC2-Classic Networking is Retiring – Here’s How to Prepare]: http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/
	//
	// This member is required.
	AutodefinedReverseFlag types.AutodefinedReverseFlag

	// Resource ID of the Amazon VPC that you want to update the Resolver
	// configuration for.
	//
	// This member is required.
	ResourceId *string

	noSmithyDocumentSerde
}

type UpdateResolverConfigOutput struct {

	// An array that contains settings for the specified Resolver configuration.
	ResolverConfig *types.ResolverConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateResolverConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateResolverConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateResolverConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateResolverConfig"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateResolverConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateResolverConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateResolverConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateResolverConfig",
	}
}
