//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	credential azcore.TokenCredential
	options    *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		credential: credential,
		options:    options.Clone(),
	}, nil
}

// NewAlertsClient creates a new instance of AlertsClient.
func (c *ClientFactory) NewAlertsClient() *AlertsClient {
	subClient, _ := NewAlertsClient(c.credential, c.options)
	return subClient
}

// NewBenefitRecommendationsClient creates a new instance of BenefitRecommendationsClient.
func (c *ClientFactory) NewBenefitRecommendationsClient() *BenefitRecommendationsClient {
	subClient, _ := NewBenefitRecommendationsClient(c.credential, c.options)
	return subClient
}

// NewBenefitUtilizationSummariesClient creates a new instance of BenefitUtilizationSummariesClient.
func (c *ClientFactory) NewBenefitUtilizationSummariesClient() *BenefitUtilizationSummariesClient {
	subClient, _ := NewBenefitUtilizationSummariesClient(c.credential, c.options)
	return subClient
}

// NewDimensionsClient creates a new instance of DimensionsClient.
func (c *ClientFactory) NewDimensionsClient() *DimensionsClient {
	subClient, _ := NewDimensionsClient(c.credential, c.options)
	return subClient
}

// NewExportsClient creates a new instance of ExportsClient.
func (c *ClientFactory) NewExportsClient() *ExportsClient {
	subClient, _ := NewExportsClient(c.credential, c.options)
	return subClient
}

// NewForecastClient creates a new instance of ForecastClient.
func (c *ClientFactory) NewForecastClient() *ForecastClient {
	subClient, _ := NewForecastClient(c.credential, c.options)
	return subClient
}

// NewGenerateCostDetailsReportClient creates a new instance of GenerateCostDetailsReportClient.
func (c *ClientFactory) NewGenerateCostDetailsReportClient() *GenerateCostDetailsReportClient {
	subClient, _ := NewGenerateCostDetailsReportClient(c.credential, c.options)
	return subClient
}

// NewGenerateDetailedCostReportClient creates a new instance of GenerateDetailedCostReportClient.
func (c *ClientFactory) NewGenerateDetailedCostReportClient() *GenerateDetailedCostReportClient {
	subClient, _ := NewGenerateDetailedCostReportClient(c.credential, c.options)
	return subClient
}

// NewGenerateDetailedCostReportOperationResultsClient creates a new instance of GenerateDetailedCostReportOperationResultsClient.
func (c *ClientFactory) NewGenerateDetailedCostReportOperationResultsClient() *GenerateDetailedCostReportOperationResultsClient {
	subClient, _ := NewGenerateDetailedCostReportOperationResultsClient(c.credential, c.options)
	return subClient
}

// NewGenerateDetailedCostReportOperationStatusClient creates a new instance of GenerateDetailedCostReportOperationStatusClient.
func (c *ClientFactory) NewGenerateDetailedCostReportOperationStatusClient() *GenerateDetailedCostReportOperationStatusClient {
	subClient, _ := NewGenerateDetailedCostReportOperationStatusClient(c.credential, c.options)
	return subClient
}

// NewGenerateReservationDetailsReportClient creates a new instance of GenerateReservationDetailsReportClient.
func (c *ClientFactory) NewGenerateReservationDetailsReportClient() *GenerateReservationDetailsReportClient {
	subClient, _ := NewGenerateReservationDetailsReportClient(c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPriceSheetClient creates a new instance of PriceSheetClient.
func (c *ClientFactory) NewPriceSheetClient() *PriceSheetClient {
	subClient, _ := NewPriceSheetClient(c.credential, c.options)
	return subClient
}

// NewQueryClient creates a new instance of QueryClient.
func (c *ClientFactory) NewQueryClient() *QueryClient {
	subClient, _ := NewQueryClient(c.credential, c.options)
	return subClient
}

// NewScheduledActionsClient creates a new instance of ScheduledActionsClient.
func (c *ClientFactory) NewScheduledActionsClient() *ScheduledActionsClient {
	subClient, _ := NewScheduledActionsClient(c.credential, c.options)
	return subClient
}

// NewViewsClient creates a new instance of ViewsClient.
func (c *ClientFactory) NewViewsClient() *ViewsClient {
	subClient, _ := NewViewsClient(c.credential, c.options)
	return subClient
}
