// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/feed_mapping.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A feed mapping.
type FeedMapping struct {
	// Immutable. The resource name of the feed mapping.
	// Feed mapping resource names have the form:
	//
	// `customers/{customer_id}/feedMappings/{feed_id}~{feed_mapping_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Immutable. The feed of this feed mapping.
	Feed *wrappers.StringValue `protobuf:"bytes,2,opt,name=feed,proto3" json:"feed,omitempty"`
	// Immutable. Feed attributes to field mappings. These mappings are a one-to-many
	// relationship meaning that 1 feed attribute can be used to populate
	// multiple placeholder fields, but 1 placeholder field can only draw
	// data from 1 feed attribute. Ad Customizer is an exception, 1 placeholder
	// field can be mapped to multiple feed attributes. Required.
	AttributeFieldMappings []*AttributeFieldMapping `protobuf:"bytes,5,rep,name=attribute_field_mappings,json=attributeFieldMappings,proto3" json:"attribute_field_mappings,omitempty"`
	// Output only. Status of the feed mapping.
	// This field is read-only.
	Status enums.FeedMappingStatusEnum_FeedMappingStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v1.enums.FeedMappingStatusEnum_FeedMappingStatus" json:"status,omitempty"`
	// Feed mapping target. Can be either a placeholder or a criterion. For a
	// given feed, the active FeedMappings must have unique targets. Required.
	//
	// Types that are valid to be assigned to Target:
	//	*FeedMapping_PlaceholderType
	//	*FeedMapping_CriterionType
	Target               isFeedMapping_Target `protobuf_oneof:"target"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FeedMapping) Reset()         { *m = FeedMapping{} }
func (m *FeedMapping) String() string { return proto.CompactTextString(m) }
func (*FeedMapping) ProtoMessage()    {}
func (*FeedMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_664f64bb6423b1b2, []int{0}
}

func (m *FeedMapping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeedMapping.Unmarshal(m, b)
}
func (m *FeedMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeedMapping.Marshal(b, m, deterministic)
}
func (m *FeedMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeedMapping.Merge(m, src)
}
func (m *FeedMapping) XXX_Size() int {
	return xxx_messageInfo_FeedMapping.Size(m)
}
func (m *FeedMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_FeedMapping.DiscardUnknown(m)
}

var xxx_messageInfo_FeedMapping proto.InternalMessageInfo

func (m *FeedMapping) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *FeedMapping) GetFeed() *wrappers.StringValue {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *FeedMapping) GetAttributeFieldMappings() []*AttributeFieldMapping {
	if m != nil {
		return m.AttributeFieldMappings
	}
	return nil
}

func (m *FeedMapping) GetStatus() enums.FeedMappingStatusEnum_FeedMappingStatus {
	if m != nil {
		return m.Status
	}
	return enums.FeedMappingStatusEnum_UNSPECIFIED
}

type isFeedMapping_Target interface {
	isFeedMapping_Target()
}

type FeedMapping_PlaceholderType struct {
	PlaceholderType enums.PlaceholderTypeEnum_PlaceholderType `protobuf:"varint,3,opt,name=placeholder_type,json=placeholderType,proto3,enum=google.ads.googleads.v1.enums.PlaceholderTypeEnum_PlaceholderType,oneof"`
}

type FeedMapping_CriterionType struct {
	CriterionType enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType `protobuf:"varint,4,opt,name=criterion_type,json=criterionType,proto3,enum=google.ads.googleads.v1.enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType,oneof"`
}

func (*FeedMapping_PlaceholderType) isFeedMapping_Target() {}

func (*FeedMapping_CriterionType) isFeedMapping_Target() {}

func (m *FeedMapping) GetTarget() isFeedMapping_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *FeedMapping) GetPlaceholderType() enums.PlaceholderTypeEnum_PlaceholderType {
	if x, ok := m.GetTarget().(*FeedMapping_PlaceholderType); ok {
		return x.PlaceholderType
	}
	return enums.PlaceholderTypeEnum_UNSPECIFIED
}

func (m *FeedMapping) GetCriterionType() enums.FeedMappingCriterionTypeEnum_FeedMappingCriterionType {
	if x, ok := m.GetTarget().(*FeedMapping_CriterionType); ok {
		return x.CriterionType
	}
	return enums.FeedMappingCriterionTypeEnum_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FeedMapping) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FeedMapping_PlaceholderType)(nil),
		(*FeedMapping_CriterionType)(nil),
	}
}

// Maps from feed attribute id to a placeholder or criterion field id.
type AttributeFieldMapping struct {
	// Immutable. Feed attribute from which to map.
	FeedAttributeId *wrappers.Int64Value `protobuf:"bytes,1,opt,name=feed_attribute_id,json=feedAttributeId,proto3" json:"feed_attribute_id,omitempty"`
	// Output only. The placeholder field ID. If a placeholder field enum is not published in
	// the current API version, then this field will be populated and the field
	// oneof will be empty.
	// This field is read-only.
	FieldId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Placeholder or criterion field to be populated using data from
	// the above feed attribute. Required.
	//
	// Types that are valid to be assigned to Field:
	//	*AttributeFieldMapping_SitelinkField
	//	*AttributeFieldMapping_CallField
	//	*AttributeFieldMapping_AppField
	//	*AttributeFieldMapping_LocationField
	//	*AttributeFieldMapping_AffiliateLocationField
	//	*AttributeFieldMapping_CalloutField
	//	*AttributeFieldMapping_StructuredSnippetField
	//	*AttributeFieldMapping_MessageField
	//	*AttributeFieldMapping_PriceField
	//	*AttributeFieldMapping_PromotionField
	//	*AttributeFieldMapping_AdCustomizerField
	//	*AttributeFieldMapping_DsaPageFeedField
	//	*AttributeFieldMapping_LocationExtensionTargetingField
	//	*AttributeFieldMapping_EducationField
	//	*AttributeFieldMapping_FlightField
	//	*AttributeFieldMapping_CustomField
	//	*AttributeFieldMapping_HotelField
	//	*AttributeFieldMapping_RealEstateField
	//	*AttributeFieldMapping_TravelField
	//	*AttributeFieldMapping_LocalField
	//	*AttributeFieldMapping_JobField
	Field                isAttributeFieldMapping_Field `protobuf_oneof:"field"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AttributeFieldMapping) Reset()         { *m = AttributeFieldMapping{} }
func (m *AttributeFieldMapping) String() string { return proto.CompactTextString(m) }
func (*AttributeFieldMapping) ProtoMessage()    {}
func (*AttributeFieldMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_664f64bb6423b1b2, []int{1}
}

func (m *AttributeFieldMapping) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeFieldMapping.Unmarshal(m, b)
}
func (m *AttributeFieldMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeFieldMapping.Marshal(b, m, deterministic)
}
func (m *AttributeFieldMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeFieldMapping.Merge(m, src)
}
func (m *AttributeFieldMapping) XXX_Size() int {
	return xxx_messageInfo_AttributeFieldMapping.Size(m)
}
func (m *AttributeFieldMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeFieldMapping.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeFieldMapping proto.InternalMessageInfo

func (m *AttributeFieldMapping) GetFeedAttributeId() *wrappers.Int64Value {
	if m != nil {
		return m.FeedAttributeId
	}
	return nil
}

func (m *AttributeFieldMapping) GetFieldId() *wrappers.Int64Value {
	if m != nil {
		return m.FieldId
	}
	return nil
}

type isAttributeFieldMapping_Field interface {
	isAttributeFieldMapping_Field()
}

type AttributeFieldMapping_SitelinkField struct {
	SitelinkField enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField `protobuf:"varint,3,opt,name=sitelink_field,json=sitelinkField,proto3,enum=google.ads.googleads.v1.enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField,oneof"`
}

type AttributeFieldMapping_CallField struct {
	CallField enums.CallPlaceholderFieldEnum_CallPlaceholderField `protobuf:"varint,4,opt,name=call_field,json=callField,proto3,enum=google.ads.googleads.v1.enums.CallPlaceholderFieldEnum_CallPlaceholderField,oneof"`
}

type AttributeFieldMapping_AppField struct {
	AppField enums.AppPlaceholderFieldEnum_AppPlaceholderField `protobuf:"varint,5,opt,name=app_field,json=appField,proto3,enum=google.ads.googleads.v1.enums.AppPlaceholderFieldEnum_AppPlaceholderField,oneof"`
}

type AttributeFieldMapping_LocationField struct {
	LocationField enums.LocationPlaceholderFieldEnum_LocationPlaceholderField `protobuf:"varint,6,opt,name=location_field,json=locationField,proto3,enum=google.ads.googleads.v1.enums.LocationPlaceholderFieldEnum_LocationPlaceholderField,oneof"`
}

type AttributeFieldMapping_AffiliateLocationField struct {
	AffiliateLocationField enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField `protobuf:"varint,7,opt,name=affiliate_location_field,json=affiliateLocationField,proto3,enum=google.ads.googleads.v1.enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField,oneof"`
}

type AttributeFieldMapping_CalloutField struct {
	CalloutField enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField `protobuf:"varint,8,opt,name=callout_field,json=calloutField,proto3,enum=google.ads.googleads.v1.enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField,oneof"`
}

type AttributeFieldMapping_StructuredSnippetField struct {
	StructuredSnippetField enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField `protobuf:"varint,9,opt,name=structured_snippet_field,json=structuredSnippetField,proto3,enum=google.ads.googleads.v1.enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField,oneof"`
}

type AttributeFieldMapping_MessageField struct {
	MessageField enums.MessagePlaceholderFieldEnum_MessagePlaceholderField `protobuf:"varint,10,opt,name=message_field,json=messageField,proto3,enum=google.ads.googleads.v1.enums.MessagePlaceholderFieldEnum_MessagePlaceholderField,oneof"`
}

type AttributeFieldMapping_PriceField struct {
	PriceField enums.PricePlaceholderFieldEnum_PricePlaceholderField `protobuf:"varint,11,opt,name=price_field,json=priceField,proto3,enum=google.ads.googleads.v1.enums.PricePlaceholderFieldEnum_PricePlaceholderField,oneof"`
}

type AttributeFieldMapping_PromotionField struct {
	PromotionField enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField `protobuf:"varint,12,opt,name=promotion_field,json=promotionField,proto3,enum=google.ads.googleads.v1.enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField,oneof"`
}

type AttributeFieldMapping_AdCustomizerField struct {
	AdCustomizerField enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField `protobuf:"varint,13,opt,name=ad_customizer_field,json=adCustomizerField,proto3,enum=google.ads.googleads.v1.enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField,oneof"`
}

type AttributeFieldMapping_DsaPageFeedField struct {
	DsaPageFeedField enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField `protobuf:"varint,14,opt,name=dsa_page_feed_field,json=dsaPageFeedField,proto3,enum=google.ads.googleads.v1.enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField,oneof"`
}

type AttributeFieldMapping_LocationExtensionTargetingField struct {
	LocationExtensionTargetingField enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField `protobuf:"varint,15,opt,name=location_extension_targeting_field,json=locationExtensionTargetingField,proto3,enum=google.ads.googleads.v1.enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField,oneof"`
}

type AttributeFieldMapping_EducationField struct {
	EducationField enums.EducationPlaceholderFieldEnum_EducationPlaceholderField `protobuf:"varint,16,opt,name=education_field,json=educationField,proto3,enum=google.ads.googleads.v1.enums.EducationPlaceholderFieldEnum_EducationPlaceholderField,oneof"`
}

type AttributeFieldMapping_FlightField struct {
	FlightField enums.FlightPlaceholderFieldEnum_FlightPlaceholderField `protobuf:"varint,17,opt,name=flight_field,json=flightField,proto3,enum=google.ads.googleads.v1.enums.FlightPlaceholderFieldEnum_FlightPlaceholderField,oneof"`
}

type AttributeFieldMapping_CustomField struct {
	CustomField enums.CustomPlaceholderFieldEnum_CustomPlaceholderField `protobuf:"varint,18,opt,name=custom_field,json=customField,proto3,enum=google.ads.googleads.v1.enums.CustomPlaceholderFieldEnum_CustomPlaceholderField,oneof"`
}

type AttributeFieldMapping_HotelField struct {
	HotelField enums.HotelPlaceholderFieldEnum_HotelPlaceholderField `protobuf:"varint,19,opt,name=hotel_field,json=hotelField,proto3,enum=google.ads.googleads.v1.enums.HotelPlaceholderFieldEnum_HotelPlaceholderField,oneof"`
}

type AttributeFieldMapping_RealEstateField struct {
	RealEstateField enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField `protobuf:"varint,20,opt,name=real_estate_field,json=realEstateField,proto3,enum=google.ads.googleads.v1.enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField,oneof"`
}

type AttributeFieldMapping_TravelField struct {
	TravelField enums.TravelPlaceholderFieldEnum_TravelPlaceholderField `protobuf:"varint,21,opt,name=travel_field,json=travelField,proto3,enum=google.ads.googleads.v1.enums.TravelPlaceholderFieldEnum_TravelPlaceholderField,oneof"`
}

type AttributeFieldMapping_LocalField struct {
	LocalField enums.LocalPlaceholderFieldEnum_LocalPlaceholderField `protobuf:"varint,22,opt,name=local_field,json=localField,proto3,enum=google.ads.googleads.v1.enums.LocalPlaceholderFieldEnum_LocalPlaceholderField,oneof"`
}

type AttributeFieldMapping_JobField struct {
	JobField enums.JobPlaceholderFieldEnum_JobPlaceholderField `protobuf:"varint,23,opt,name=job_field,json=jobField,proto3,enum=google.ads.googleads.v1.enums.JobPlaceholderFieldEnum_JobPlaceholderField,oneof"`
}

func (*AttributeFieldMapping_SitelinkField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CallField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AppField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AffiliateLocationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CalloutField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_StructuredSnippetField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_MessageField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_PriceField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_PromotionField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_AdCustomizerField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_DsaPageFeedField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocationExtensionTargetingField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_EducationField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_FlightField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_CustomField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_HotelField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_RealEstateField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_TravelField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_LocalField) isAttributeFieldMapping_Field() {}

func (*AttributeFieldMapping_JobField) isAttributeFieldMapping_Field() {}

func (m *AttributeFieldMapping) GetField() isAttributeFieldMapping_Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *AttributeFieldMapping) GetSitelinkField() enums.SitelinkPlaceholderFieldEnum_SitelinkPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_SitelinkField); ok {
		return x.SitelinkField
	}
	return enums.SitelinkPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCallField() enums.CallPlaceholderFieldEnum_CallPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CallField); ok {
		return x.CallField
	}
	return enums.CallPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAppField() enums.AppPlaceholderFieldEnum_AppPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AppField); ok {
		return x.AppField
	}
	return enums.AppPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocationField() enums.LocationPlaceholderFieldEnum_LocationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocationField); ok {
		return x.LocationField
	}
	return enums.LocationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAffiliateLocationField() enums.AffiliateLocationPlaceholderFieldEnum_AffiliateLocationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AffiliateLocationField); ok {
		return x.AffiliateLocationField
	}
	return enums.AffiliateLocationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCalloutField() enums.CalloutPlaceholderFieldEnum_CalloutPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CalloutField); ok {
		return x.CalloutField
	}
	return enums.CalloutPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetStructuredSnippetField() enums.StructuredSnippetPlaceholderFieldEnum_StructuredSnippetPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_StructuredSnippetField); ok {
		return x.StructuredSnippetField
	}
	return enums.StructuredSnippetPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetMessageField() enums.MessagePlaceholderFieldEnum_MessagePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_MessageField); ok {
		return x.MessageField
	}
	return enums.MessagePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetPriceField() enums.PricePlaceholderFieldEnum_PricePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_PriceField); ok {
		return x.PriceField
	}
	return enums.PricePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetPromotionField() enums.PromotionPlaceholderFieldEnum_PromotionPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_PromotionField); ok {
		return x.PromotionField
	}
	return enums.PromotionPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetAdCustomizerField() enums.AdCustomizerPlaceholderFieldEnum_AdCustomizerPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_AdCustomizerField); ok {
		return x.AdCustomizerField
	}
	return enums.AdCustomizerPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetDsaPageFeedField() enums.DsaPageFeedCriterionFieldEnum_DsaPageFeedCriterionField {
	if x, ok := m.GetField().(*AttributeFieldMapping_DsaPageFeedField); ok {
		return x.DsaPageFeedField
	}
	return enums.DsaPageFeedCriterionFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocationExtensionTargetingField() enums.LocationExtensionTargetingCriterionFieldEnum_LocationExtensionTargetingCriterionField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocationExtensionTargetingField); ok {
		return x.LocationExtensionTargetingField
	}
	return enums.LocationExtensionTargetingCriterionFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetEducationField() enums.EducationPlaceholderFieldEnum_EducationPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_EducationField); ok {
		return x.EducationField
	}
	return enums.EducationPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetFlightField() enums.FlightPlaceholderFieldEnum_FlightPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_FlightField); ok {
		return x.FlightField
	}
	return enums.FlightPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetCustomField() enums.CustomPlaceholderFieldEnum_CustomPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_CustomField); ok {
		return x.CustomField
	}
	return enums.CustomPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetHotelField() enums.HotelPlaceholderFieldEnum_HotelPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_HotelField); ok {
		return x.HotelField
	}
	return enums.HotelPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetRealEstateField() enums.RealEstatePlaceholderFieldEnum_RealEstatePlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_RealEstateField); ok {
		return x.RealEstateField
	}
	return enums.RealEstatePlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetTravelField() enums.TravelPlaceholderFieldEnum_TravelPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_TravelField); ok {
		return x.TravelField
	}
	return enums.TravelPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetLocalField() enums.LocalPlaceholderFieldEnum_LocalPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_LocalField); ok {
		return x.LocalField
	}
	return enums.LocalPlaceholderFieldEnum_UNSPECIFIED
}

func (m *AttributeFieldMapping) GetJobField() enums.JobPlaceholderFieldEnum_JobPlaceholderField {
	if x, ok := m.GetField().(*AttributeFieldMapping_JobField); ok {
		return x.JobField
	}
	return enums.JobPlaceholderFieldEnum_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AttributeFieldMapping) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AttributeFieldMapping_SitelinkField)(nil),
		(*AttributeFieldMapping_CallField)(nil),
		(*AttributeFieldMapping_AppField)(nil),
		(*AttributeFieldMapping_LocationField)(nil),
		(*AttributeFieldMapping_AffiliateLocationField)(nil),
		(*AttributeFieldMapping_CalloutField)(nil),
		(*AttributeFieldMapping_StructuredSnippetField)(nil),
		(*AttributeFieldMapping_MessageField)(nil),
		(*AttributeFieldMapping_PriceField)(nil),
		(*AttributeFieldMapping_PromotionField)(nil),
		(*AttributeFieldMapping_AdCustomizerField)(nil),
		(*AttributeFieldMapping_DsaPageFeedField)(nil),
		(*AttributeFieldMapping_LocationExtensionTargetingField)(nil),
		(*AttributeFieldMapping_EducationField)(nil),
		(*AttributeFieldMapping_FlightField)(nil),
		(*AttributeFieldMapping_CustomField)(nil),
		(*AttributeFieldMapping_HotelField)(nil),
		(*AttributeFieldMapping_RealEstateField)(nil),
		(*AttributeFieldMapping_TravelField)(nil),
		(*AttributeFieldMapping_LocalField)(nil),
		(*AttributeFieldMapping_JobField)(nil),
	}
}

func init() {
	proto.RegisterType((*FeedMapping)(nil), "google.ads.googleads.v1.resources.FeedMapping")
	proto.RegisterType((*AttributeFieldMapping)(nil), "google.ads.googleads.v1.resources.AttributeFieldMapping")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/feed_mapping.proto", fileDescriptor_664f64bb6423b1b2)
}

var fileDescriptor_664f64bb6423b1b2 = []byte{
	// 1409 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x58, 0x5b, 0x6f, 0x1b, 0xc5,
	0x17, 0xff, 0x6f, 0xd2, 0xa4, 0xc9, 0x38, 0x57, 0xf7, 0xdf, 0xd4, 0x94, 0x42, 0xd3, 0x8a, 0xa2,
	0x3c, 0xa0, 0x35, 0x09, 0x15, 0x17, 0x97, 0x8b, 0xec, 0x90, 0xde, 0xd4, 0x56, 0xc1, 0x89, 0x42,
	0x05, 0x91, 0xac, 0xf1, 0xee, 0xd8, 0xd9, 0xb2, 0xde, 0x59, 0xed, 0xcc, 0xa6, 0xb4, 0x55, 0x79,
	0xe0, 0x81, 0x17, 0x78, 0xe3, 0x1b, 0xf0, 0x82, 0xc4, 0x27, 0x01, 0x3e, 0x45, 0x9f, 0xfb, 0x0d,
	0x40, 0x42, 0x42, 0x3b, 0x67, 0x67, 0xbc, 0x49, 0x67, 0x76, 0x16, 0xbf, 0x8d, 0xe7, 0x9c, 0xdf,
	0xf9, 0xfd, 0xf6, 0x9c, 0x33, 0x37, 0xa3, 0xeb, 0x43, 0x4a, 0x87, 0x21, 0x69, 0x62, 0x9f, 0x35,
	0x61, 0x98, 0x8d, 0x8e, 0x37, 0x9b, 0x09, 0x61, 0x34, 0x4d, 0x3c, 0xc2, 0x9a, 0x03, 0x42, 0xfc,
	0xde, 0x08, 0xc7, 0x71, 0x10, 0x0d, 0xdd, 0x38, 0xa1, 0x9c, 0xd6, 0xaf, 0x80, 0xab, 0x8b, 0x7d,
	0xe6, 0x2a, 0x94, 0x7b, 0xbc, 0xe9, 0x2a, 0xd4, 0xc5, 0x6d, 0x53, 0x60, 0x12, 0xa5, 0x23, 0xd6,
	0xc4, 0x7e, 0xcf, 0x4b, 0x19, 0xa7, 0xa3, 0xe0, 0x29, 0x49, 0x7a, 0x71, 0x88, 0x3d, 0x72, 0x44,
	0x43, 0x9f, 0x24, 0xbd, 0x41, 0x40, 0x42, 0x1f, 0x78, 0x2e, 0xde, 0xb6, 0x04, 0x19, 0x0c, 0x82,
	0x30, 0xc0, 0x9c, 0xf4, 0x42, 0xea, 0x61, 0x1e, 0xd0, 0xc8, 0x18, 0xe9, 0x23, 0x4b, 0xa4, 0x38,
	0x36, 0x42, 0x5b, 0xe5, 0x50, 0x0f, 0x87, 0xa1, 0x11, 0xfb, 0x89, 0x1d, 0x4b, 0x53, 0x6e, 0x84,
	0x7f, 0x6c, 0x81, 0x8b, 0x0c, 0x1a, 0xd1, 0xed, 0x72, 0xb4, 0xcf, 0x70, 0x2f, 0xc6, 0x43, 0xd2,
	0x13, 0x05, 0xf6, 0x92, 0x80, 0x93, 0x24, 0x4b, 0x61, 0x31, 0xc4, 0x67, 0xe5, 0x21, 0x88, 0x9f,
	0x5a, 0xf2, 0x6e, 0x09, 0x50, 0xec, 0xad, 0x82, 0x04, 0xfe, 0x24, 0x26, 0x79, 0x80, 0x0f, 0xfe,
	0x43, 0x00, 0xc6, 0x31, 0x4f, 0x59, 0xb5, 0xdc, 0x0d, 0xc2, 0x60, 0x78, 0x64, 0xce, 0xfc, 0x8d,
	0x72, 0xf4, 0x11, 0xe5, 0x24, 0x9c, 0xb4, 0xd9, 0x1e, 0xd1, 0xfe, 0xa4, 0xbc, 0x59, 0x9f, 0x9b,
	0x79, 0x77, 0xed, 0x60, 0x51, 0x2c, 0xf2, 0x2d, 0x27, 0x11, 0x13, 0x89, 0xc6, 0xc9, 0x90, 0xf0,
	0x93, 0xc9, 0x2f, 0x46, 0xfc, 0xb4, 0x62, 0xc4, 0x09, 0xfb, 0x7f, 0x44, 0x18, 0xcb, 0x3a, 0xd0,
	0x04, 0xbf, 0x5e, 0x0e, 0x2f, 0xc2, 0x0a, 0x2d, 0x63, 0xc9, 0x61, 0x9c, 0x04, 0x1e, 0x99, 0xb4,
	0x61, 0xe3, 0x84, 0x8e, 0x68, 0xe9, 0x27, 0x5b, 0x56, 0x5d, 0x42, 0x70, 0xd8, 0x23, 0x59, 0xa7,
	0x9a, 0x35, 0x58, 0xb2, 0xce, 0x02, 0x4e, 0xc2, 0x20, 0xfa, 0x66, 0xd2, 0x6d, 0x93, 0xf1, 0x24,
	0xf5, 0x78, 0x9a, 0x10, 0xbf, 0xc7, 0xa2, 0x20, 0x8e, 0xc9, 0xc4, 0x1b, 0x10, 0x4f, 0xf0, 0x71,
	0xc9, 0x3a, 0xb8, 0x2c, 0xd1, 0x71, 0xd0, 0x14, 0xf3, 0xbd, 0x3e, 0x39, 0xc2, 0xc7, 0x01, 0x4d,
	0x72, 0x87, 0xd7, 0x0a, 0x0e, 0xf2, 0xe8, 0xc8, 0x4d, 0x6f, 0xe6, 0x26, 0xf1, 0xab, 0x9f, 0x0e,
	0x9a, 0x8f, 0x13, 0x1c, 0xc7, 0x24, 0x91, 0xcb, 0xfb, 0x52, 0x01, 0x8a, 0xa3, 0x88, 0x72, 0xd1,
	0x88, 0xb9, 0xf5, 0xea, 0x5f, 0x33, 0xa8, 0x76, 0x93, 0x10, 0xff, 0x3e, 0xec, 0x0c, 0xf5, 0x2f,
	0xd0, 0xa2, 0x8c, 0xdf, 0x8b, 0xf0, 0x88, 0x34, 0x9c, 0x75, 0x67, 0x63, 0xbe, 0xf3, 0xce, 0x8b,
	0xf6, 0xcc, 0xdf, 0xed, 0xb7, 0xd1, 0x5b, 0xe3, 0x43, 0x2c, 0x1f, 0xc5, 0x01, 0x73, 0x3d, 0x3a,
	0x6a, 0x16, 0x82, 0x74, 0x17, 0x64, 0x88, 0x07, 0x78, 0x44, 0xea, 0x5f, 0xa2, 0x33, 0xd9, 0xe6,
	0xd3, 0x98, 0x5a, 0x77, 0x36, 0x6a, 0x5b, 0x97, 0x72, 0xa0, 0x2b, 0xf5, 0xba, 0x7b, 0x3c, 0x09,
	0xa2, 0xe1, 0x01, 0x0e, 0x53, 0xd2, 0xb9, 0x26, 0x78, 0x2e, 0xa3, 0x37, 0x4a, 0x79, 0xba, 0x22,
	0x60, 0xfd, 0x31, 0x6a, 0x60, 0xce, 0x93, 0xa0, 0x9f, 0x72, 0x02, 0xe9, 0x94, 0x1b, 0x1c, 0x6b,
	0xcc, 0xac, 0x4f, 0x6f, 0xd4, 0xb6, 0x3e, 0x74, 0xad, 0xe7, 0xaf, 0xdb, 0x96, 0x21, 0x6e, 0x66,
	0x11, 0xf2, 0x4f, 0xe8, 0x4c, 0xbf, 0x68, 0xcf, 0x74, 0xd7, 0xb0, 0xce, 0xc6, 0xea, 0x1e, 0x9a,
	0x85, 0x1d, 0xb4, 0x31, 0xbb, 0xee, 0x6c, 0x2c, 0x6d, 0xdd, 0x34, 0xd2, 0x88, 0xea, 0xbb, 0x85,
	0xdc, 0xec, 0x09, 0xdc, 0x4e, 0x94, 0x8e, 0x5e, 0x9d, 0xcd, 0x48, 0xa7, 0xbb, 0x79, 0xe8, 0x3a,
	0x47, 0x2b, 0xa7, 0x97, 0x6d, 0x63, 0x5a, 0xd0, 0x75, 0x2c, 0x74, 0xbb, 0x63, 0xd8, 0xfe, 0x93,
	0x98, 0x08, 0xb2, 0x53, 0x73, 0xe2, 0xfb, 0x6e, 0xff, 0xaf, 0xbb, 0x1c, 0x9f, 0x9c, 0xaf, 0x7f,
	0xef, 0xa0, 0xa5, 0x93, 0xc7, 0x4b, 0xe3, 0x8c, 0x20, 0xdd, 0xaf, 0xfe, 0x8d, 0xdb, 0x12, 0xaf,
	0xd8, 0x4d, 0x46, 0x29, 0x63, 0xd1, 0x2b, 0xce, 0xb6, 0xbe, 0x7e, 0xd9, 0x7e, 0x58, 0xad, 0xd5,
	0xea, 0xef, 0xc2, 0xd1, 0x4e, 0x12, 0xd6, 0x7c, 0x26, 0x87, 0xcf, 0xc5, 0x61, 0x27, 0xab, 0xd5,
	0x7c, 0x56, 0x3c, 0xfa, 0x9e, 0x77, 0xe6, 0xd0, 0x2c, 0x6c, 0xe6, 0x57, 0xff, 0xb8, 0x80, 0xce,
	0x6b, 0xab, 0x5f, 0xbf, 0x87, 0x56, 0x05, 0x68, 0xdc, 0x5e, 0x81, 0x2f, 0x56, 0x42, 0x6d, 0xeb,
	0xf5, 0x57, 0xfa, 0xf7, 0x4e, 0xc4, 0xdf, 0xbf, 0x0e, 0xed, 0x2b, 0xba, 0x66, 0x39, 0x83, 0xaa,
	0xb8, 0x77, 0xfc, 0xfa, 0x0d, 0x34, 0x07, 0xdd, 0x19, 0xc8, 0x45, 0x60, 0x0b, 0x32, 0xdd, 0x3d,
	0x2b, 0x10, 0x77, 0x7c, 0x51, 0x10, 0xb5, 0x8f, 0x89, 0xc9, 0xbc, 0x0b, 0x6c, 0x05, 0xd9, 0xcb,
	0x41, 0x85, 0xca, 0x8b, 0x6f, 0x14, 0x05, 0x31, 0x19, 0x55, 0x41, 0x24, 0xa5, 0x98, 0xad, 0x27,
	0x08, 0x89, 0xdb, 0x1b, 0xf0, 0x43, 0x43, 0xdc, 0xb3, 0xf0, 0x6f, 0xe3, 0x30, 0xd4, 0x72, 0xeb,
	0x0c, 0x92, 0x77, 0x3e, 0xa3, 0x01, 0xce, 0x08, 0xcd, 0x67, 0x97, 0x4d, 0xa0, 0x9c, 0x11, 0x94,
	0x77, 0x2d, 0x94, 0xed, 0x38, 0xd6, 0x32, 0x6a, 0xe6, 0x25, 0xe1, 0x1c, 0x8e, 0x63, 0xe0, 0xcb,
	0x12, 0xad, 0x8e, 0x69, 0x60, 0x9d, 0xad, 0x94, 0xe8, 0x7b, 0x39, 0x48, 0x4b, 0x6d, 0x32, 0x8a,
	0x2a, 0x67, 0x89, 0x96, 0x94, 0x20, 0xe2, 0x57, 0x07, 0x35, 0x34, 0x97, 0x75, 0x90, 0x73, 0x56,
	0xc8, 0x19, 0xd8, 0x92, 0x20, 0xe1, 0xa5, 0xba, 0xac, 0x5e, 0x52, 0xe0, 0x1a, 0x3e, 0xed, 0x09,
	0x4a, 0xbf, 0x43, 0x8b, 0xf2, 0x52, 0x0e, 0xea, 0xe6, 0x84, 0xba, 0x6e, 0x85, 0xae, 0xa0, 0x29,
	0x37, 0x36, 0x86, 0xc6, 0x26, 0x4b, 0xb5, 0x90, 0xf3, 0x8d, 0x33, 0xa5, 0x39, 0x9f, 0x41, 0xcb,
	0x7c, 0xa5, 0x4c, 0xed, 0x29, 0xf8, 0x1e, 0xa0, 0xf5, 0x4b, 0xc5, 0xe6, 0x25, 0xf5, 0xad, 0xb1,
	0xd3, 0x9e, 0x2a, 0x53, 0xf2, 0xfa, 0x06, 0xea, 0x50, 0xa5, 0x4c, 0xdd, 0x07, 0x8c, 0x56, 0x93,
	0xc1, 0xa6, 0x32, 0x95, 0xf3, 0x01, 0xff, 0x31, 0xaa, 0xc1, 0x4d, 0x0e, 0xd8, 0x6b, 0x82, 0xfd,
	0x81, 0xed, 0x0c, 0xc9, 0x10, 0x5a, 0x6e, 0xad, 0x45, 0x32, 0x23, 0xc1, 0x04, 0xbc, 0x3f, 0x38,
	0x68, 0x79, 0x7c, 0x0b, 0x04, 0xf2, 0x05, 0x41, 0x7e, 0x60, 0x25, 0xcf, 0x51, 0x06, 0x01, 0x06,
	0xab, 0x14, 0xb1, 0xa4, 0x58, 0x41, 0xc8, 0xcf, 0x0e, 0x3a, 0x77, 0xf2, 0x19, 0x0d, 0x62, 0x16,
	0x85, 0x98, 0x43, 0xdb, 0x7a, 0xf2, 0xb7, 0x15, 0x50, 0xbf, 0x94, 0x4a, 0x1c, 0xa4, 0xa4, 0x55,
	0x5c, 0x70, 0x02, 0x55, 0x3f, 0x39, 0xe8, 0xdc, 0xc9, 0x97, 0x25, 0xa8, 0x5a, 0xaa, 0x94, 0xa2,
	0xcf, 0x19, 0xde, 0xcd, 0x2a, 0x4c, 0x88, 0xaf, 0x4e, 0xd4, 0xb1, 0x24, 0xa3, 0x55, 0xea, 0x59,
	0xf1, 0xc7, 0x1e, 0x20, 0xe7, 0x77, 0x07, 0x5d, 0x2d, 0x7d, 0xf7, 0x80, 0xba, 0x65, 0xa1, 0x8e,
	0x57, 0xdc, 0x12, 0x77, 0x64, 0x9c, 0x7d, 0x19, 0x46, 0x23, 0xb6, 0xaa, 0xb3, 0xd4, 0x7e, 0x39,
	0x34, 0x02, 0xc6, 0x8d, 0x37, 0x7e, 0x70, 0x83, 0xee, 0x95, 0x4a, 0x59, 0xdd, 0x91, 0x28, 0x6d,
	0xa1, 0x8d, 0x56, 0xd5, 0x78, 0x8a, 0x15, 0x84, 0x3c, 0x45, 0x0b, 0xf9, 0xeb, 0x19, 0x44, 0xac,
	0x0a, 0x11, 0xbb, 0xb6, 0x9b, 0x94, 0x80, 0x68, 0x15, 0xe8, 0x4d, 0x92, 0xbe, 0x06, 0x64, 0x8a,
	0x3b, 0xff, 0xd7, 0x03, 0xb8, 0xeb, 0x95, 0xb8, 0xa1, 0x49, 0xf5, 0xbb, 0xb3, 0xd6, 0xa4, 0xb8,
	0x81, 0x4c, 0xed, 0x38, 0xf0, 0xee, 0x07, 0xea, 0x73, 0x95, 0x76, 0x9c, 0xdb, 0x19, 0x42, 0xcb,
	0xac, 0xb5, 0xa8, 0x1d, 0x47, 0x30, 0x01, 0xef, 0x8f, 0x0e, 0x5a, 0x2d, 0x3e, 0x1b, 0x81, 0xfe,
	0xff, 0x82, 0xfe, 0xa1, 0x85, 0xbe, 0x4b, 0x70, 0xb8, 0x23, 0x60, 0x5a, 0x0d, 0x66, 0xb3, 0xba,
	0x4a, 0x27, 0xca, 0x45, 0x55, 0x20, 0x7f, 0xf6, 0x81, 0x8e, 0xf3, 0x95, 0x2a, 0xb0, 0x2f, 0x20,
	0x5a, 0x0d, 0x7a, 0x93, 0xaa, 0x00, 0x90, 0xa9, 0x0a, 0xc0, 0x3f, 0x20, 0x40, 0xbd, 0x56, 0xa9,
	0x02, 0xd9, 0x42, 0x0c, 0x8d, 0xb7, 0x18, 0x73, 0x05, 0x04, 0x93, 0xba, 0xb4, 0x3d, 0xa2, 0xfd,
	0x9c, 0xf5, 0x42, 0xa5, 0x4b, 0xdb, 0x5d, 0xda, 0xd7, 0x72, 0x6a, 0xe6, 0xd5, 0xa5, 0xed, 0x11,
	0xed, 0xc3, 0xc4, 0x59, 0x34, 0x23, 0xb8, 0x3a, 0xff, 0x38, 0xe8, 0x9a, 0x47, 0x47, 0xf6, 0xf7,
	0x5e, 0x67, 0xa5, 0xf0, 0x7c, 0xd8, 0xcd, 0xae, 0xdf, 0xbb, 0xce, 0x57, 0x77, 0x73, 0xd8, 0x90,
	0x86, 0x38, 0x1a, 0xba, 0x34, 0x19, 0x36, 0x87, 0x24, 0x12, 0x97, 0xf3, 0xe6, 0xf8, 0xf1, 0x51,
	0xf2, 0xdf, 0xef, 0x0d, 0x35, 0xfa, 0x65, 0x6a, 0xfa, 0x56, 0xbb, 0xfd, 0xdb, 0xd4, 0x95, 0x5b,
	0x10, 0xb2, 0xed, 0x33, 0x17, 0x86, 0xd9, 0xe8, 0x60, 0xd3, 0xed, 0x4a, 0xcf, 0x3f, 0xa5, 0xcf,
	0x61, 0xdb, 0x67, 0x87, 0xca, 0xe7, 0xf0, 0x60, 0xf3, 0x50, 0xf9, 0xbc, 0x9c, 0xba, 0x06, 0x86,
	0x56, 0xab, 0xed, 0xb3, 0x56, 0x4b, 0x79, 0xb5, 0x5a, 0x07, 0x9b, 0xad, 0x96, 0xf2, 0xeb, 0xcf,
	0x0a, 0xb1, 0xef, 0xfd, 0x1b, 0x00, 0x00, 0xff, 0xff, 0xb3, 0xce, 0x23, 0x06, 0xa7, 0x16, 0x00,
	0x00,
}
