      SUBROUTINE TDASHL	(IERROR)
C
C LATEST REVISION	 APRIL 1984
C
C PURPOSE		 TO PROVIDE A DEMONSTRATION OF DASHLINE
C			 AND TO	TEST DASHLINE ON A SIMPLE PROBLEM
C
C USAGE			 CALL TDASHL (IERROR)
C
C ARGUMENTS
C
C ON OUTPUT		 IERROR
C			   AN INTEGER VARIABLE
C			   = 0,	IF THE TEST IS SUCCESSFUL,
C			   = 1,	OTHERWISE
C
C I/O			 IF THE	TEST IS	SUCCESSFUL, THE	MESSAGE
C
C			   DASHLINE TEST SUCCESSFUL  . . .  SEE	PLOT
C			   TO VERIFY PERFORMANCE
C
C			 IS PRINTED ON UNIT 6.
C
C			 IN ADDITION, ONE FRAME	CONTAINING THE
C			 DASHED	LINE PLOT IS PRODUCED ON THE
C			 MACHINE GRAPHICS DEVICE.  TO DETERMINE
C			 IF THE	TEST IS	SUCCESSFUL, IT IS NECESSARY
C			 TO EXAMINE THIS PLOT.
C
C PRECISION		 SINGLE
C
C REQUIRED LIBRARY	 DASHLINE
C FILES
C
C LANGUAGE		 FORTRAN
C
C ALGORITHM		 TDASHL	UTILIZES THE SOFTWARE DASHLINE
C			 SUBROUTINES DASHDB, FRSTD, VECTD, LINED AND
C			 CURVED	TO DRAW	FIVE CURVES ON ONE PICTURE
C			 USING FIVE DIFFERENT DASHLINE PATTERNS.  EACH
C			 CURVE IS CENTERED ABOUT SOLID AXIS LINES AND
C			 LABELLED WITH THE BINARY REPRESENTATION OF THE
C			 DASHLINE PATTERN USED.
C
C PORTABILITY		 FORTRAN 77
C
C X CONTAINS ABSCISSAE VALUES OF THE CURVE TO BE PLOTTED, Y CONTAINS
C COORDINATE VALUES OF THE CURVE TO BE PLOTTED.
C
      DIMENSION	      X(31)	 ,Y(31)	     ,IPAT(5)
C
C SELECT NORMALIZATION TRANSFORMATION 0
C
      CALL GSELNT(0)
C
C SET SOLID DASH PATTERN,  1111111111111111 (BINARY).
C BOOLEAN OPERATIONS (EMPLOYING	LOCALLY	IMPLEMENTED
C SUPPORT ROUTINES) ARE	USED.
C
      ISOLID = IOR (ISHIFT (32767,1), 1)
C
C ARRAY	IPAT CONTAINS 5	DIFFERENT 16-BIT DASH PATTERNS.	 THE PATTERNS
C CONSTRUCTED WITH BOOLEAN OPERATIONS AS ABOVE.
C THE BINARY REPRESENTATIONS OF	THE PATTERNS ARE
C	 0001110001111111
C	 1111000011110000
C	 1111110011111100
C	 1111111100000000
C	 1111111111111100
C
      IPAT(1) =	IOR (ISHIFT ( 3647,1), 1)
      IPAT(2) =	ISHIFT (30840,1)
      IPAT(3) =	ISHIFT (32382,1)
      IPAT(4) =	ISHIFT (32640,1)
      IPAT(5) =	ISHIFT (32766,1)
C
      DO  70 K=1,5
	 CALL DASHDB (ISOLID)
	 ORG =1.07-0.195*K
C
C	DRAW CENTRAL AXIS FOR EACH CURVE
C
	 CALL FRSTD (.50,ORG-0.03)
	 CALL VECTD (.50,ORG+0.03)
	 CALL LINED (.109,ORG,.891,ORG)
	 CALL DASHDB (IPAT(K))
C
C	COMPUTE	VALUES FOR AND DRAW THE	KTH CURVE
C
	 DO  10	I=1,31
	    THETA = FLOAT(I-1)*3.1415926535897932/15.
	    X(I) = 0.5+.4*COS(THETA)
	    Y(I) = ORG+.075*SIN(FLOAT(K)*THETA)
   10	 CONTINUE
	 CALL CURVED (X,Y,31)
C
C	LABEL EACH CURVE WITH THE APPROPRIATE BINARY REPRESENTATION OF
C	THE DASHLINE PATTERN
C
C	SET TEXT ALIGNMENT TO CENTER THE STRING	AT THE LEFT OF THE
C	STRING AND IN THE VERTICAL CENTER
C
      CALL GSTXAL(1,3)
C
C	SET CHARACTER HEIGHT
C
      CALL GSCHH(.012)
C
	 ORY = ORG+.09
	 GO TO ( 20, 30, 40, 50, 60),K
   20	 CALL GTX (.1,ORY,'IPAT=0001110001111111')
	 GO TO	70
   30	 CALL GTX (.1,ORY,'IPAT=1111000011110000')
	 GO TO	70
   40	 CALL GTX (.1,ORY,'IPAT=1111110011111100')
	 GO TO	70
   50	 CALL GTX (.1,ORY,'IPAT=1111111100000000')
	 GO TO	70
   60	 CALL GTX (.1,ORY,'IPAT=1111111111111100')
C
   70 CONTINUE
C
      CALL GSTXAL(2,3)
      CALL GTX (.5,.991,'DEMONSTRATION PLOT FOR	DASHLINE')
C
C ADVANCE FRAME
C
      CALL NEWFM
C
      IERROR = 0
      WRITE (6,1001)
C
      RETURN
C
 1001 FORMAT ('	  DASHLINE TEST	SUCCESSFUL',24X,
     1	      'SEE PLOT	TO VERIFY PERFORMANCE')
C
      END
