/*
 * SPDX-License-Identifier: ODbL-1.0
 *
 * This code is auto-generated from OpenStreetMap (licensed under ODbL) and Wikidata (licensed under CC0), do not edit!
 */

#include "knowledgedb.h"
#include "trainstationdb.h"

namespace KItinerary {
namespace KnowledgeDb {
static const TrainStation trainstation_table[] = {
    {Coordinate{19.0994, 47.4656}, CountryId{"HU"}}, // Ferencváros railway station
    {Coordinate{75.8931, 19.8308}, CountryId{"IN"}}, // Jalna railway station
    {Coordinate{16.5878, 47.6778}, CountryId{"HU"}}, // Sopron railway station
    {Coordinate{15.1236, 50.1494}, CountryId{"CZ"}}, // Poděbrady (train station)
    {Coordinate{-8.3124, 41.3791}, CountryId{"PT"}}, // Q10275806
    {Coordinate{141.962, 46.8694}, CountryId{"RU"}}, // Q1032032
    {Coordinate{25.6481, 60.3964}, CountryId{"FI"}}, // Porvoo railway station
    {Coordinate{24.4895, 64.6837}, CountryId{"FI"}}, // Raahe railway station
    {Coordinate{24.9414, 60.171}, CountryId{"FI"}}, // Helsinki Central Railway Station
    {Coordinate{24.8639, 60.2467}, CountryId{"FI"}}, // Malminkartano railway station
    {Coordinate{11.5794, 58.5292}, CountryId{"SE"}}, // Dingle railway station
    {Coordinate{24.1858, 56.9189}, CountryId{"LV"}}, // Jāņavārti Station
    {Coordinate{15.1633, 50.9397}, CountryId{"CZ"}}, // Q10513341
    {Coordinate{25.4064, 65.1961}, CountryId{"FI"}}, // Haukipudas railway station
    {Coordinate{25.5547, 60.4081}, CountryId{"FI"}}, // Q10518700
    {Coordinate{9.96278, 53.4656}, CountryId{"DE"}}, // Heimfeld station
    {Coordinate{25.4411, 65.3186}, CountryId{"FI"}}, // Ii railway station
    {Coordinate{22.7147, 63.6744}, CountryId{"FI"}}, // Pietarsaari railway station
    {Coordinate{25.6136, 60.4067}, CountryId{"FI"}}, // Kiiala train stop
    {Coordinate{}, CountryId{"FI"}}, // Q10548421
    {Coordinate{25.1016, 60.457}, CountryId{"FI"}}, // Ainola railway station
    {Coordinate{23.2369, 59.9041}, CountryId{"FI"}}, // Q10554301
    {Coordinate{14.6164, 58.9892}, CountryId{"SE"}}, // Laxå railway station
    {Coordinate{12.2728, 57.7694}, CountryId{"SE"}}, // Lerum railway station
    {Coordinate{18.9611, 47.5358}, CountryId{"HU"}}, // Hárs-hegy
    {Coordinate{27.5792, 64.0647}, CountryId{"FI"}}, // Murtomäki railway station
    {Coordinate{126.633, 45.7619}, CountryId{"CN"}}, // Harbin railway station
    {Coordinate{10.09, 46.6978}, CountryId{"CH"}}, // Zernez station
    {Coordinate{9.90556, 46.4856}, CountryId{"CH"}}, // Surovas
    {Coordinate{10.0544, 46.3247}, CountryId{"CH"}}, // Poschiavo
    {Coordinate{10.0997, 46.2731}, CountryId{"CH"}}, // Miralago
    {Coordinate{8.40417, 46.5672}, CountryId{"CH"}}, // Muttbach-Belvédère Station
    {Coordinate{8.76972, 46.6811}, CountryId{"CH"}}, // Sedrun railway station
    {Coordinate{8.508, 47.3647}, CountryId{"CH"}}, // Zürich Friesenberg railway station
    {Coordinate{8.62073, 46.9493}, CountryId{"CH"}}, // Sisikon railway station
    {Coordinate{7.95869, 46.7362}, CountryId{"CH"}}, // Oberried am Brienzersee railway station
    {Coordinate{7.99012, 46.7525}, CountryId{"CH"}}, // Ebligen railway station
    {Coordinate{8.31, 46.982}, CountryId{"CH"}}, // Hergiswil railway station
    {Coordinate{8.303, 47.0351}, CountryId{"CH"}}, // Lucerne Allmend/Messe railway station
    {Coordinate{8.54448, 47.2867}, CountryId{"CH"}}, // Langnau-Gattikon railway station
    {Coordinate{8.53508, 47.2967}, CountryId{"CH"}}, // Wildpark-Höfli railway station
    {Coordinate{8.52522, 47.3032}, CountryId{"CH"}}, // Sihlau railway station
    {Coordinate{8.5215, 47.3197}, CountryId{"CH"}}, // Sood-Oberleimbach railway station
    {Coordinate{8.87899, 47.3684}, CountryId{"CH"}}, // Bauma railway station
    {Coordinate{8.75207, 47.2359}, CountryId{"CH"}}, // Uerikon railway station
    {Coordinate{9.31, 46.8075}, CountryId{"CH"}}, // Versam-Safien
    {Coordinate{9.70333, 46.7978}, CountryId{"CH"}}, // Litzirüti
    {Coordinate{17.3156, 62.3867}, CountryId{"SE"}}, // Sundsvall central station
    {Coordinate{17.2914, 62.3897}, CountryId{"SE"}}, // Sundsvall western station
    {Coordinate{17.9036, 59.2053}, CountryId{"SE"}}, // Tullinge railway station
    {Coordinate{18.7044, 63.2893}, CountryId{"SE"}}, // Örnsköldsvik central station
    {Coordinate{33.7542, 48.104}, CountryId{"UA"}}, // Q10853622
    {Coordinate{34.2374, 48.4825}, CountryId{"UA"}}, // Verkhivtseve Railway Station
    {Coordinate{9.08733, 45.5198}, CountryId{"IT"}}, // Rho Fiera metro station
    {Coordinate{9.17333, 45.4617}, CountryId{"IT"}}, // Sant’Ambrogio metro station
    {Coordinate{9.19556, 45.4561}, CountryId{"IT"}}, // Crocetta metro station
    {Coordinate{9.51236, 46.8498}, CountryId{"CH"}}, // Chur West
    {Coordinate{15.1, 37.5067}, CountryId{"IT"}}, // Catania Centrale railway station
    {Coordinate{-0.518264, 38.8457}, CountryId{"ES"}}, // Agullent
    {Coordinate{-0.518264, 38.8457}, CountryId{"ES"}}, // Albaida
    {Coordinate{6.39944, 46.4756}, CountryId{"CH"}}, // Allaman railway station
    {Coordinate{-0.510475, 38.8674}, CountryId{"ES"}}, // Bufali
    {Coordinate{6.87722, 46.448}, CountryId{"CH"}}, // Burier railway station
    {Coordinate{6.89542, 46.4428}, CountryId{"CH"}}, // Clarens railway station
    {Coordinate{6.82431, 46.4707}, CountryId{"CH"}}, // Q10948087
    {Coordinate{6.72715, 46.4886}, CountryId{"CH"}}, // Cully railway station
    {Coordinate{6.74516, 46.4893}, CountryId{"CH"}}, // Epesses railway station
    {Coordinate{7.02556, 46.1692}, CountryId{"CH"}}, // Evionnaz railway station
    {Coordinate{6.84361, 46.4631}, CountryId{"CH"}}, // La Tour-de-Peilz railway station
    {Coordinate{6.69062, 46.5038}, CountryId{"CH"}}, // Lutry railway station
    {Coordinate{-0.491567, 38.8841}, CountryId{"ES"}}, // Montaverner
    {Coordinate{-0.602522, 38.8095}, CountryId{"ES"}}, // Ontinyent
    {Coordinate{6.65947, 46.5109}, CountryId{"CH"}}, // Pully railway station
    {Coordinate{6.78458, 46.4742}, CountryId{"CH"}}, // Rivaz railway station
    {Coordinate{6.79702, 46.4726}, CountryId{"CH"}}, // St-Saphorin railway station
    {Coordinate{7.00205, 46.2164}, CountryId{"CH"}}, // St-Maurice railway station
    {Coordinate{6.92292, 46.4264}, CountryId{"CH"}}, // Territet railway station
    {Coordinate{7.03833, 46.1386}, CountryId{"CH"}}, // Vernayaz railway station
    {Coordinate{6.83556, 46.4682}, CountryId{"CH"}}, // Q10952909
    {Coordinate{6.92778, 46.4175}, CountryId{"CH"}}, // Veytaux-Chillon railway station
    {Coordinate{6.70728, 46.4953}, CountryId{"CH"}}, // Villette VD railway station
    {Coordinate{13.3694, 52.5251}, CountryId{"DE"}}, // Berlin Hauptbahnhof
    {Coordinate{8.53619, 47.5239}, CountryId{"CH"}}, // Bülach railway station
    {Coordinate{7.35005, 47.362}, CountryId{"CH"}}, // Delémont Station
    {Coordinate{24.9378, 58.7569}, CountryId{"EE"}}, // Q10987307
    {Coordinate{25.5467, 58.5453}, CountryId{"EE"}}, // Q10990043
    {Coordinate{1.45532, 41.1864}, CountryId{"ES"}}, // Roda de Mar
    {Coordinate{10.4839, 59.875}, CountryId{"NO"}}, // Billingstad Station
    {Coordinate{-0.377125, 39.467}, CountryId{"ES"}}, // Estació del Nord, Valencia
    {Coordinate{19.0911, 47.4903}, CountryId{"HU"}}, // Józsefváros railway station
    {Coordinate{24.8142, 59.065}, CountryId{"EE"}}, // Q11039999
    {Coordinate{24.7011, 59.3381}, CountryId{"EE"}}, // Q11041241
    {Coordinate{24.6767, 59.2736}, CountryId{"EE"}}, // Q11043684
    {Coordinate{25.1447, 58.8344}, CountryId{"EE"}}, // Q11046777
    {Coordinate{24.6947, 59.2227}, CountryId{"EE"}}, // Q11048360
    {Coordinate{24.744, 59.1705}, CountryId{"EE"}}, // Q11049028
    {Coordinate{25.5203, 58.7233}, CountryId{"EE"}}, // Q11049439
    {Coordinate{24.8997, 58.9425}, CountryId{"EE"}}, // Keava railway station
    {Coordinate{7.63381, 48.9524}, CountryId{"FR"}}, // Q1105334
    {Coordinate{17.6852, 49.0328}, CountryId{"CZ"}}, // Q11086341
    {Coordinate{18.4246, 47.1832}, CountryId{"HU"}}, // Székesfehérvár railway station
    {Coordinate{11.2473, 42.4514}, CountryId{"IT"}}, // Orbetello-Monte Argentario railway station
    {Coordinate{9.5753, 45.1693}, CountryId{"IT"}}, // Ospedaletto Lodigiano railway station
    {Coordinate{19.9675, 46.4661}, CountryId{"HU"}}, // Kistelek railway station
    {Coordinate{12.2926, 44.3144}, CountryId{"IT"}}, // Lido di Classe-Lido di Savio train station
    {Coordinate{14.8727, 40.6403}, CountryId{"IT"}}, // Pontecagnano railway station
    {Coordinate{11.3968, 45.2304}, CountryId{"IT"}}, // Q1113920
    {Coordinate{11.6606, 43.4965}, CountryId{"IT"}}, // Q1115149
    {Coordinate{14.8302, 38.1593}, CountryId{"IT"}}, // Q1115937
    {Coordinate{15.6526, 38.1264}, CountryId{"IT"}}, // Reggio di Calabria Santa Caterina railway station
    {Coordinate{14.2709, 51.0844}, CountryId{"DE"}}, // Neukirch West railway station
    {Coordinate{7.5411, 45.2556}, CountryId{"IT"}}, // Mathi railway station
    {Coordinate{9.60582, 47.7848}, CountryId{"DE"}}, // Bahnhof Ravensburg
    {Coordinate{12.2988, 45.8848}, CountryId{"IT"}}, // Conegliano railway station
    {Coordinate{10.0503, 45.6564}, CountryId{"IT"}}, // Iseo railway station
    {Coordinate{15.4232, 40.8869}, CountryId{"IT"}}, // Q1118820
    {Coordinate{11.274, 43.8486}, CountryId{"IT"}}, // Q1121442
    {Coordinate{10.4728, 45.1072}, CountryId{"IT"}}, // Bozzolo railway station
    {Coordinate{16.8671, 48.7379}, CountryId{"CZ"}}, // station Boří les
    {Coordinate{26.7658, 57.1828}, CountryId{"LV"}}, // Gulbene railway station
    {Coordinate{15.8097, 50.2147}, CountryId{"CZ"}}, // Hradec Králové hlavní nádraží
    {Coordinate{11.3975, 61.0131}, CountryId{"NO"}}, // Rudstad Station
    {Coordinate{17.8056, 51.6492}, CountryId{"PL"}}, // Ostrów Wielkopolski
    {Coordinate{17.9081, 49.9344}, CountryId{"CZ"}}, // Opava východ
    {Coordinate{14.8654, 50.0766}, CountryId{"CZ"}}, // Český Brod train station
    {Coordinate{117.332, 49.6394}, CountryId{"RU"}}, // Zabaykalsk Railway Station
    {Coordinate{25.045, 60.2939}, CountryId{"FI"}}, // Tikkurila railway station
    {Coordinate{16.3394, 50.5808}, CountryId{"CZ"}}, // Broumov (train station)
    {Coordinate{142.85, 49.6847}, CountryId{"RU"}}, // Q114061
    {Coordinate{7.61006, 43.7927}, CountryId{"IT"}}, // Ventimiglia railway station
    {Coordinate{12.4544, 41.8964}, CountryId{"IT"}}, // Roma San Pietro railway station
    {Coordinate{11.2367, 43.8003}, CountryId{"IT"}}, // Firenze Rifredi railway station
    {Coordinate{11.8803, 45.4175}, CountryId{"IT"}}, // Padova railway station
    {Coordinate{15.239, 66.4935}, CountryId{"NO"}}, // Bolna Station
    {Coordinate{142.731, 46.8058}, CountryId{"RU"}}, // Q1153093
    {Coordinate{10.6552, 44.7244}, CountryId{"IT"}}, // Reggio Emilia AV Mediopadana railway station
    {Coordinate{141.943, 46.8456}, CountryId{"JP"}}, // Q11584599
    {Coordinate{15.2806, 37.0689}, CountryId{"IT"}}, // Syracuse railway station
    {Coordinate{8.92667, 45.5694}, CountryId{"IT"}}, // Canegrate railway station
    {Coordinate{8.12617, 49.198}, CountryId{"DE"}}, // Landau (Pfalz) Hauptbahnhof
    {Coordinate{142.68, 46.9931}, CountryId{"RU"}}, // Q11627144
    {Coordinate{141.919, 46.799}, CountryId{"JP"}}, // Q11677451
    {Coordinate{-0.450597, 39.1531}, CountryId{"ES"}}, // Alzira
    {Coordinate{0.912611, 40.9993}, CountryId{"ES"}}, // L'Hospitalet de l'Infant station
    {Coordinate{2.29452, 41.6176}, CountryId{"ES"}}, // Les Franqueses - Granollers Nord station
    {Coordinate{-1.89943, 43.3159}, CountryId{"ES"}}, // Lezo-Rentería railway station
    {Coordinate{-8.44784, 43.038}, CountryId{"ES"}}, // Ordes
    {Coordinate{-2.25646, 43.0402}, CountryId{"ES"}}, // Q11681665
    {Coordinate{-8.63574, 42.4216}, CountryId{"ES"}}, // Pontevedra train station
    {Coordinate{9.0683, 47.7147}, CountryId{"DE"}}, // Q11685458
    {Coordinate{11.5737, 47.7605}, CountryId{"DE"}}, // Bad Tölz railway station
    {Coordinate{28.6134, 49.8894}, CountryId{"UA"}}, // Berdychiv
    {Coordinate{7.94266, 52.5511}, CountryId{"DE"}}, // Bersenbrück
    {Coordinate{18.0731, 49.9633}, CountryId{"CZ"}}, // Bolatice (train station)
    {Coordinate{17.8781, 49.8892}, CountryId{"CZ"}}, // Q11688765
    {Coordinate{8.88791, 53.061}, CountryId{"DE"}}, // Bremen-Sebaldsbrück
    {Coordinate{18.7175, 49.6363}, CountryId{"CZ"}}, // Q11689192
    {Coordinate{17.4044, 49.9175}, CountryId{"CZ"}}, // Q11689283
    {Coordinate{7.8817, 48.0687}, CountryId{"DE"}}, // Q11693885
    {Coordinate{18.4728, 49.6697}, CountryId{"CZ"}}, // Dobratice pod Prašivou
    {Coordinate{13.7904, 51.0214}, CountryId{"DE"}}, // Dresden-Reick station
    {Coordinate{18.1714, 49.8806}, CountryId{"CZ"}}, // Děhylov (train station)
    {Coordinate{19.42, 54.1503}, CountryId{"PL"}}, // Elblag (station)
    {Coordinate{9.4095, 47.6883}, CountryId{"DE"}}, // Q11698911
    {Coordinate{9.4291, 47.6643}, CountryId{"DE"}}, // Friedrichshafen-Manzell
    {Coordinate{7.1109, 51.5376}, CountryId{"DE"}}, // Q11699550
    {Coordinate{19.3589, 47.5924}, CountryId{"HU"}}, // Gödöllő railway station
    {Coordinate{8.03083, 44.6978}, CountryId{"IT"}}, // Alba railway station
    {Coordinate{15.2056, 50.8761}, CountryId{"CZ"}}, // Q11706606
    {Coordinate{11.9661, 51.445}, CountryId{"DE"}}, // Q11708471
    {Coordinate{12.4938, 64.5686}, CountryId{"NO"}}, // Harran Station
    {Coordinate{26.0459, 61.2028}, CountryId{"FI"}}, // Heinola railway station
    {Coordinate{11.0105, 52.2221}, CountryId{"DE"}}, // Helmstedt railway station
    {Coordinate{10.2133, 47.5592}, CountryId{"DE"}}, // Immenstadt station
    {Coordinate{10.7599, 47.219}, CountryId{"AT"}}, // Imst-Pitztal railway station
    {Coordinate{17.6917, 49.9175}, CountryId{"CZ"}}, // Q11716284
    {Coordinate{17.3181, 49.9342}, CountryId{"CZ"}}, // Q11716730
    {Coordinate{17.0156, 50.395}, CountryId{"CZ"}}, // Javorník ve Slezsku (train station)
    {Coordinate{17.1935, 50.2277}, CountryId{"CZ"}}, // Q11725828
    {Coordinate{18.1414, 49.8978}, CountryId{"CZ"}}, // Q11727174
    {Coordinate{17.5383, 50.2483}, CountryId{"CZ"}}, // Q11727217
    {Coordinate{18.1509, 49.749}, CountryId{"CZ"}}, // Jistebník
    {Coordinate{25.1739, 61.8649}, CountryId{"FI"}}, // Jämsä railway station
    {Coordinate{17.4419, 49.7103}, CountryId{"CZ"}}, // Q11729826
    {Coordinate{17.4394, 50.105}, CountryId{"CZ"}}, // Q11735892
    {Coordinate{8.3629, 49.0021}, CountryId{"DE"}}, // Karlsruhe West
    {Coordinate{17.6836, 50.0889}, CountryId{"CZ"}}, // Krnov (train station)
    {Coordinate{18.5397, 49.8347}, CountryId{"CZ"}}, // Q11736626
    {Coordinate{18.5272, 49.8558}, CountryId{"CZ"}}, // Karviná Main Station
    {Coordinate{9.454, 51.2763}, CountryId{"DE"}}, // Q11736791
    {Coordinate{20.6178, 50.8742}, CountryId{"PL"}}, // Q11738980
    {Coordinate{17.6989, 50.2281}, CountryId{"CZ"}}, // Q11740482
    {Coordinate{17.1256, 50.3383}, CountryId{"CZ"}}, // Q11740588
    {Coordinate{18.5981, 49.7814}, CountryId{"CZ"}}, // Chotěbuz (train station)
    {Coordinate{9.1627, 47.6775}, CountryId{"DE"}}, // Q11743019
    {Coordinate{9.1732, 47.6742}, CountryId{"DE"}}, // Q11743020
    {Coordinate{9.14717, 47.6825}, CountryId{"DE"}}, // Q11743021
    {Coordinate{14, 54.0333}, CountryId{"DE"}}, // Koserow railway station
    {Coordinate{14.6472, 52.5915}, CountryId{"PL"}}, // Kostrzyn station
    {Coordinate{18.1539, 49.9106}, CountryId{"CZ"}}, // Q11744634
    {Coordinate{15.5697, 54.1822}, CountryId{"PL"}}, // Q11744737
    {Coordinate{18.0392, 49.9308}, CountryId{"CZ"}}, // Q11748043
    {Coordinate{18.01, 49.935}, CountryId{"CZ"}}, // Kravaře ve Slezsku
    {Coordinate{6.6459, 51.3575}, CountryId{"DE"}}, // Krefeld-Uerdingen station
    {Coordinate{17.7128, 50.0939}, CountryId{"CZ"}}, // Q11748247
    {Coordinate{15.9706, 50.6731}, CountryId{"CZ"}}, // Q11750075
    {Coordinate{17.6381, 50.1256}, CountryId{"CZ"}}, // Q11750080
    {Coordinate{16.2445, 50.4298}, CountryId{"PL"}}, // Kudowa-Zdrój
    {Coordinate{17.5158, 50.0372}, CountryId{"CZ"}}, // Q11751099
    {Coordinate{18.2951, 49.535}, CountryId{"CZ"}}, // Q11751113
    {Coordinate{17.9089, 49.925}, CountryId{"CZ"}}, // Q11751788
    {Coordinate{14.0667, 54}, CountryId{"DE"}}, // Kölpinsee railway station
    {Coordinate{14.608, 52.5684}, CountryId{"DE"}}, // Küstrin-Kietz station
    {Coordinate{12.7142, 64.6961}, CountryId{"NO"}}, // Lassemoen Station
    {Coordinate{12.4299, 51.3716}, CountryId{"DE"}}, // Leipzig-Thekla railway station
    {Coordinate{12.3894, 51.3962}, CountryId{"DE"}}, // Leipzig Messe railway station
    {Coordinate{23.7542, 61.3133}, CountryId{"FI"}}, // Lempäälä railway station
    {Coordinate{16.5656, 51.8469}, CountryId{"PL"}}, // Leszno
    {Coordinate{18.0472, 49.9072}, CountryId{"CZ"}}, // Q11755592
    {Coordinate{15.0456, 50.7614}, CountryId{"CZ"}}, // Liberec (train station)
    {Coordinate{16.6589, 50.0973}, CountryId{"CZ"}}, // Lichkov (train station)
    {Coordinate{9.68479, 47.5593}, CountryId{"DE"}}, // Q11756931
    {Coordinate{17.6142, 50.1364}, CountryId{"CZ"}}, // Q11756959
    {Coordinate{17.5729, 49.5292}, CountryId{"CZ"}}, // Lipník nad Bečvou (train station)
    {Coordinate{17.1311, 50.2283}, CountryId{"CZ"}}, // Q11757752
    {Coordinate{17.1431, 50.2447}, CountryId{"CZ"}}, // Q11757753
    {Coordinate{17.1606, 50.2294}, CountryId{"CZ"}}, // Q11757754
    {Coordinate{17.6086, 50.2236}, CountryId{"CZ"}}, // Q11757787
    {Coordinate{17.7342, 49.8875}, CountryId{"CZ"}}, // Q11761999
    {Coordinate{17.4192, 49.8733}, CountryId{"CZ"}}, // Q11762491
    {Coordinate{9.05294, 47.8156}, CountryId{"DE"}}, // Q11763650
    {Coordinate{16.9167, 49.8252}, CountryId{"CZ"}}, // Lukavice na Moravě
    {Coordinate{18.4144, 49.9125}, CountryId{"CZ"}}, // Q11764364
    {Coordinate{18.3281, 49.6981}, CountryId{"CZ"}}, // Q11764481
    {Coordinate{9.4993, 47.6615}, CountryId{"DE"}}, // Löwental
    {Coordinate{13.961, 51.8622}, CountryId{"DE"}}, // Lübbenau railway station
    {Coordinate{11.6578, 52.1665}, CountryId{"DE"}}, // Magdeburg-Eichenweiler railway station
    {Coordinate{8.3141, 49.9612}, CountryId{"DE"}}, // Mainz-Laubenheim station
    {Coordinate{17.3169, 50.01}, CountryId{"CZ"}}, // Malá Morávka (train station)
    {Coordinate{17.9458, 49.9322}, CountryId{"CZ"}}, // Q11766896
    {Coordinate{8.4541, 49.4933}, CountryId{"DE"}}, // Mannheim-Handelshafen station
    {Coordinate{8.53514, 49.4238}, CountryId{"DE"}}, // Mannheim-Rheinau station
    {Coordinate{9.36917, 47.4231}, CountryId{"CH"}}, // St. Gallen railway station
    {Coordinate{9.003, 47.7393}, CountryId{"DE"}}, // Markelfingen station
    {Coordinate{15.3353, 50.7641}, CountryId{"CZ"}}, // Q11774648
    {Coordinate{15.3141, 50.7592}, CountryId{"CZ"}}, // Q11774649
    {Coordinate{11.1431, 47.8449}, CountryId{"DE"}}, // Weilheim (Oberbay) station
    {Coordinate{6.6353, 49.4436}, CountryId{"DE"}}, // Q11777525
    {Coordinate{16.2436, 50.6266}, CountryId{"CZ"}}, // Meziměstí railway station
    {Coordinate{27.2776, 61.6879}, CountryId{"FI"}}, // Mikkeli railway station
    {Coordinate{17.3206, 50.3025}, CountryId{"CZ"}}, // Mikulovice (train station)
    {Coordinate{17.5578, 50.0142}, CountryId{"CZ"}}, // Q11781305
    {Coordinate{12.9598, 50.9872}, CountryId{"DE"}}, // Mittweida railway station
    {Coordinate{17.7122, 49.8944}, CountryId{"CZ"}}, // Q11784196
    {Coordinate{16.9429, 49.7768}, CountryId{"CZ"}}, // Mohelnice
    {Coordinate{18.0308, 49.9094}, CountryId{"CZ"}}, // Q11784850
    {Coordinate{16.9685, 49.7583}, CountryId{"CZ"}}, // Moravičany
    {Coordinate{17.4325, 49.7847}, CountryId{"CZ"}}, // Q11785418
    {Coordinate{18.7514, 49.5078}, CountryId{"CZ"}}, // Q11786026
    {Coordinate{18.7515, 49.5241}, CountryId{"CZ"}}, // Q11786027
    {Coordinate{14.5581, 67.2839}, CountryId{"NO"}}, // Mørkved
    {Coordinate{11.428, 48.1546}, CountryId{"DE"}}, // Munich Leienfelsstraße station
    {Coordinate{11.4436, 48.1487}, CountryId{"DE"}}, // Munich-Westkreuz station
    {Coordinate{17.5783, 50.1681}, CountryId{"CZ"}}, // Q11787946
    {Coordinate{12.8856, 52.6125}, CountryId{"DE"}}, // Nauen railway station
    {Coordinate{14.0667, 54}, CountryId{"DE"}}, // Neu Pudagla railway station
    {Coordinate{13.2617, 53.5622}, CountryId{"DE"}}, // Neubrandenburg railway station
    {Coordinate{8.6123, 47.6826}, CountryId{"CH"}}, // Neuhausen Badischer railway station
    {Coordinate{8.495, 47.6891}, CountryId{"CH"}}, // Q11790775
    {Coordinate{88.4427, 26.6824}, CountryId{"IN"}}, // New Jalpaiguri Junction railway station
    {Coordinate{18.7545, 49.59}, CountryId{"CZ"}}, // Jablunkov-Návsí
    {Coordinate{11.0583, 49.4075}, CountryId{"DE"}}, // Q11794301
    {Coordinate{11.0548, 49.4295}, CountryId{"DE"}}, // Q11794302
    {Coordinate{11.1111, 49.4446}, CountryId{"DE"}}, // Nürnberg-Gleißhammer station
    {Coordinate{11.0682, 49.4428}, CountryId{"DE"}}, // Nürnberg-Steinbühl station
    {Coordinate{11.1217, 49.4641}, CountryId{"DE"}}, // Q11794306
    {Coordinate{17.2784, 49.5926}, CountryId{"CZ"}}, // Olomouc hlavní nádraží
    {Coordinate{17.3436, 50.2725}, CountryId{"CZ"}}, // Q11798302
    {Coordinate{17.3539, 50.2631}, CountryId{"CZ"}}, // Q11798303
    {Coordinate{17.9594, 49.9178}, CountryId{"CZ"}}, // Q11798470
    {Coordinate{17.9342, 49.9292}, CountryId{"CZ"}}, // Q11798471
    {Coordinate{17.8889, 49.9386}, CountryId{"CZ"}}, // Q11798472
    {Coordinate{10.4979, 48.8509}, CountryId{"DE"}}, // Nördlingen station
    {Coordinate{17.7222, 50.2683}, CountryId{"CZ"}}, // Osoblaha (train station)
    {Coordinate{18.34, 49.7786}, CountryId{"CZ"}}, // Q11800679
    {Coordinate{18.2897, 49.8633}, CountryId{"CZ"}}, // Q11800680
    {Coordinate{18.2908, 49.7908}, CountryId{"CZ"}}, // Q11800681
    {Coordinate{18.2967, 49.8094}, CountryId{"CZ"}}, // Q11800682
    {Coordinate{18.2101, 49.8213}, CountryId{"CZ"}}, // Ostrava-Svinov station
    {Coordinate{18.2622, 49.8011}, CountryId{"CZ"}}, // Q11800687
    {Coordinate{18.1958, 49.8422}, CountryId{"CZ"}}, // Q11800688
    {Coordinate{18.3936, 49.5378}, CountryId{"CZ"}}, // Ostravice
    {Coordinate{18.2825, 49.8291}, CountryId{"CZ"}}, // Q11800690
    {Coordinate{18.3803, 49.5503}, CountryId{"CZ"}}, // Q11800691
    {Coordinate{17.8694, 49.9189}, CountryId{"CZ"}}, // Q11800991
    {Coordinate{11.8308, 53.4301}, CountryId{"DE"}}, // Parchim railway station
    {Coordinate{11.7239, 49.1642}, CountryId{"DE"}}, // Bahnhof Parsberg
    {Coordinate{18.3036, 49.7358}, CountryId{"CZ"}}, // Q11813273
    {Coordinate{14.6469, 50.5733}, CountryId{"CZ"}}, // Q11814057
    {Coordinate{10.2316, 52.319}, CountryId{"DE"}}, // Peine station
    {Coordinate{18.5484, 49.8934}, CountryId{"CZ"}}, // Petrovice u Karviné
    {Coordinate{17.8555, 49.5743}, CountryId{"CZ"}}, // Q11821938
    {Coordinate{21.7875, 61.4772}, CountryId{"FI"}}, // Pori railway station
    {Coordinate{13.0367, 52.3928}, CountryId{"DE"}}, // Potsdam Charlottenhof railway station
    {Coordinate{14.3997, 50.097}, CountryId{"CZ"}}, // Q11826597
    {Coordinate{14.3486, 50.0329}, CountryId{"CZ"}}, // Praha-Holyně
    {Coordinate{14.5359, 50.055}, CountryId{"CZ"}}, // Praha-Hostivař
    {Coordinate{14.4043, 49.9903}, CountryId{"CZ"}}, // Praha-Komořany
    {Coordinate{14.3644, 49.9858}, CountryId{"CZ"}}, // Praha-Radotín
    {Coordinate{14.3937, 50.1324}, CountryId{"CZ"}}, // Praha-Sedlec
    {Coordinate{14.3995, 49.9706}, CountryId{"CZ"}}, // Q11826604
    {Coordinate{14.3081, 50.0324}, CountryId{"CZ"}}, // Praha-Řeporyje
    {Coordinate{17.4849, 49.5032}, CountryId{"CZ"}}, // Q11827831
    {Coordinate{12.9501, 48.8394}, CountryId{"DE"}}, // Deggendorf Hauptbahnhof
    {Coordinate{22.7767, 49.7839}, CountryId{"PL"}}, // Przemyśl railway station
    {Coordinate{17.4449, 49.447}, CountryId{"CZ"}}, // Přerov
    {Coordinate{18.3619, 49.6169}, CountryId{"CZ"}}, // Q11830573
    {Coordinate{17.26, 50.2786}, CountryId{"CZ"}}, // Q11832244
    {Coordinate{18.3028, 49.7706}, CountryId{"CZ"}}, // Vratimov (train station)
    {Coordinate{8.9692, 47.7357}, CountryId{"DE"}}, // Radolfzell station
    {Coordinate{19.1003, 49.5069}, CountryId{"PL"}}, // Rajcza Centrum railway station
    {Coordinate{12.3453, 51.5242}, CountryId{"DE"}}, // Delitzsch unterer station
    {Coordinate{}, CountryId{"FI"}}, // Ajos rail yard
    {Coordinate{22.6958, 63.7069}, CountryId{"FI"}}, // Alholma (Leppäluoto) harbor track railway station
    {Coordinate{29.0247, 64.4508}, CountryId{"FI"}}, // Arola railway station
    {Coordinate{24.9568, 60.3041}, CountryId{"FI"}}, // Aviapolis railway station
    {Coordinate{23.0808, 59.8656}, CountryId{"FI"}}, // Q11856399
    {Coordinate{24.1908, 62.5411}, CountryId{"FI"}}, // Eläinpuisto-Zoo
    {Coordinate{}, CountryId{"FI"}}, // Q11858533
    {Coordinate{24.1508, 63.915}, CountryId{"FI"}}, // Eskola railway station
    {Coordinate{24.1314, 65.8281}, CountryId{"FI"}}, // Haparanda railway station
    {Coordinate{25.5086, 60.9208}, CountryId{"FI"}}, // Q11861183
    {Coordinate{21.3458, 60.7961}, CountryId{"FI"}}, // Hangonsaari railway station
    {Coordinate{22.1336, 61.31}, CountryId{"FI"}}, // Harjavalta railway station
    {Coordinate{30.1933, 62.5567}, CountryId{"FI"}}, // Q11861989
    {Coordinate{25.4728, 60.8958}, CountryId{"FI"}}, // Q11862444
    {Coordinate{24.9231, 60.7536}, CountryId{"FI"}}, // Q11862591
    {Coordinate{25.2258, 64.7336}, CountryId{"FI"}}, // Hirvineva railway station
    {Coordinate{23.8491, 53.6865}, CountryId{"BY"}}, // Hrodna
    {Coordinate{28.4631, 64.6838}, CountryId{"FI"}}, // Hyrynsalmi railway station
    {Coordinate{29.4442, 63.4547}, CountryId{"FI"}}, // Q11864162
    {Coordinate{24.9258, 60.2125}, CountryId{"FI"}}, // Ilmala rail yard
    {Coordinate{28.7767, 61.1958}, CountryId{"FI"}}, // Imatra railway station
    {Coordinate{24.1453, 62.5507}, CountryId{"FI"}}, // Inha railway station
    {Coordinate{26.8395, 60.6968}, CountryId{"FI"}}, // Inkeroinen railway station
    {Coordinate{22.3948, 62.9513}, CountryId{"FI"}}, // Isokyrö railway station
    {Coordinate{22.9542, 62.4719}, CountryId{"FI"}}, // Q11865685
    {Coordinate{28.4892, 61.1203}, CountryId{"FI"}}, // Joutseno station
    {Coordinate{26.9378, 60.604}, CountryId{"FI"}}, // Juurikorpi railway station
    {Coordinate{25.2744, 60.8675}, CountryId{"FI"}}, // Q11868360
    {Coordinate{23.0222, 62.0269}, CountryId{"FI"}}, // Q11869011
    {Coordinate{27.3476, 60.9108}, CountryId{"FI"}}, // Q11869035
    {Coordinate{23.9147, 63.8986}, CountryId{"FI"}}, // Kannus railway station
    {Coordinate{23.3883, 61.7511}, CountryId{"FI"}}, // Q11869852
    {Coordinate{24.4183, 64.0156}, CountryId{"FI"}}, // Karhukangas railway station
    {Coordinate{22.2119, 62.4599}, CountryId{"FI"}}, // Q11870457
    {Coordinate{23.0356, 63.0997}, CountryId{"FI"}}, // Kauhava railway station
    {Coordinate{23.6833, 66.4483}, CountryId{"FI"}}, // Q11870545
    {Coordinate{27.2281, 63.7094}, CountryId{"FI"}}, // Q11870623
    {Coordinate{26.3303, 60.8853}, CountryId{"FI"}}, // Kausala railway station
    {Coordinate{25.5139, 64.9128}, CountryId{"FI"}}, // Kempele railway station
    {Coordinate{29.8035, 61.8876}, CountryId{"FI"}}, // Q11871170
    {Coordinate{24.7069, 62.2555}, CountryId{"FI"}}, // Keuruu railway station
    {Coordinate{26.6117, 63.6411}, CountryId{"FI"}}, // Kiuruvesi railway station
    {Coordinate{27.4717, 64.4686}, CountryId{"FI"}}, // Kivesjärvi railway station
    {Coordinate{24.8458, 60.314}, CountryId{"FI"}}, // Kivistö railway station
    {Coordinate{22.3033, 61.2544}, CountryId{"FI"}}, // Kokemäki railway station
    {Coordinate{24.5069, 62.1281}, CountryId{"FI"}}, // Kolho railway station
    {Coordinate{29.8571, 62.7325}, CountryId{"FI"}}, // Kontiolahti railway station
    {Coordinate{28.1133, 64.3386}, CountryId{"FI"}}, // Kontiomäki railway station
    {Coordinate{22.4622, 62.6881}, CountryId{"FI"}}, // Q11872739
    {Coordinate{23.0367, 62.1744}, CountryId{"FI"}}, // Kuivasjärvi railway station
    {Coordinate{27.5171, 62.7719}, CountryId{"FI"}}, // Kurkimäki railway station
    {Coordinate{26.9066, 60.539}, CountryId{"FI"}}, // Kymi railway station
    {Coordinate{26.8976, 60.5076}, CountryId{"FI"}}, // Kyminlinna railway station
    {Coordinate{25.11, 60.4244}, CountryId{"FI"}}, // Kytömaa railway station
    {Coordinate{}, CountryId{"FI"}}, // Q11874094
    {Coordinate{28.0711, 64.1186}, CountryId{"FI"}}, // Q11874402
    {Coordinate{22.0032, 62.9902}, CountryId{"FI"}}, // Q11874419
    {Coordinate{27.7103, 64.2314}, CountryId{"FI"}}, // Q11874538
    {Coordinate{26.1267, 60.5992}, CountryId{"FI"}}, // Q11874637
    {Coordinate{25.1739, 60.8489}, CountryId{"FI"}}, // Q11874694
    {Coordinate{24.5356, 65.7961}, CountryId{"FI"}}, // Laurila railway station
    {Coordinate{25.0391, 60.3227}, CountryId{"FI"}}, // Leinelä railway station
    {Coordinate{24.969, 60.316}, CountryId{"FI"}}, // Helsinki Airport railway station
    {Coordinate{26.2472, 60.4194}, CountryId{"FI"}}, // Loviisa Port railyard
    {Coordinate{14.3474, 50.0959}, CountryId{"CZ"}}, // Nádraží Veleslavín
    {Coordinate{29.3219, 61.8003}, CountryId{"FI"}}, // Lusto railway station
    {Coordinate{28.5, 63.8817}, CountryId{"FI"}}, // Maanselkä railway station
    {Coordinate{23.3375, 63.8414}, CountryId{"FI"}}, // Q11881499
    {Coordinate{27.655, 64.4133}, CountryId{"FI"}}, // Melalahti railway station
    {Coordinate{23.885, 61.2333}, CountryId{"FI"}}, // Q11882289
    {Coordinate{25.08, 60.8231}, CountryId{"FI"}}, // Q11883143
    {Coordinate{}, CountryId{"FI"}}, // Q11883568
    {Coordinate{25.2711, 65.5367}, CountryId{"FI"}}, // Myllykangas railway station
    {Coordinate{26.7883, 60.77}, CountryId{"FI"}}, // Myllykoski railway station
    {Coordinate{24.2789, 62.525}, CountryId{"FI"}}, // Myllymäki railway station
    {Coordinate{25.9897, 61.1636}, CountryId{"FI"}}, // Q11883670
    {Coordinate{21.9642, 60.6507}, CountryId{"FI"}}, // Q11883684
    {Coordinate{26.8814, 61.4214}, CountryId{"FI"}}, // Mäntyharju railway station
    {Coordinate{22.4817, 61.8447}, CountryId{"FI"}}, // Niinisalo railway station
    {Coordinate{25.2661, 60.3825}, CountryId{"FI"}}, // Q11884448
    {Coordinate{}, CountryId{"FI"}}, // Q11884566
    {Coordinate{24.3172, 60.3292}, CountryId{"FI"}}, // Nummela railway station
    {Coordinate{25.7486, 60.8156}, CountryId{"FI"}}, // Q11885783
    {Coordinate{}, CountryId{"FI"}}, // Q11885792
    {Coordinate{24.3706, 61.6744}, CountryId{"FI"}}, // Q11885796
    {Coordinate{27.0897, 64.1139}, CountryId{"FI"}}, // Otanmäki rail yard
    {Coordinate{26.9189, 60.475}, CountryId{"FI"}}, // Q11886387
    {Coordinate{22.6864, 60.4592}, CountryId{"FI"}}, // Paimio railway station
    {Coordinate{27.8222, 64.4008}, CountryId{"FI"}}, // Paltamo railway station
    {Coordinate{29.5022, 61.5586}, CountryId{"FI"}}, // Parikkala railway station
    {Coordinate{23.5522, 60.0981}, CountryId{"FI"}}, // Pohjankuru railway station
    {Coordinate{22.9411, 62.6483}, CountryId{"FI"}}, // Q11888470
    {Coordinate{}, CountryId{"FI"}}, // Q11888974
    {Coordinate{22.129, 60.4858}, CountryId{"FI"}}, // Raisio railway station
    {Coordinate{24.7617, 60.5322}, CountryId{"FI"}}, // Rajamäki railway station
    {Coordinate{29.2944, 61.8031}, CountryId{"FI"}}, // Q11890618
    {Coordinate{22.9967, 62.9033}, CountryId{"FI"}}, // Ruha railway station
    {Coordinate{26.8861, 63.6019}, CountryId{"FI"}}, // Q11891384
    {Coordinate{25.0983, 64.6608}, CountryId{"FI"}}, // Ruukki railway station
    {Coordinate{24.7575, 60.8175}, CountryId{"FI"}}, // Q11891564
    {Coordinate{27.345, 56.5197}, CountryId{"LV"}}, // Q11891612
    {Coordinate{29.6619, 61.6958}, CountryId{"FI"}}, // Q11891820
    {Coordinate{24.2822, 63.9794}, CountryId{"FI"}}, // Sievi railway station
    {Coordinate{27.4061, 62.2897}, CountryId{"FI"}}, // Q11893387
    {Coordinate{27.6661, 63.0753}, CountryId{"FI"}}, // Siilinjärvi railway station
    {Coordinate{23.3115, 59.9262}, CountryId{"FI"}}, // Skogby Stop
    {Coordinate{25.5403, 60.3003}, CountryId{"FI"}}, // Sköldvik railway station
    {Coordinate{27.21, 63.6317}, CountryId{"FI"}}, // Q11893993
    {Coordinate{27.4222, 63.8647}, CountryId{"FI"}}, // Sukeva railway station
    {Coordinate{28.3672, 62.3561}, CountryId{"FI"}}, // Q11895634
    {Coordinate{29.0608, 62.7172}, CountryId{"FI"}}, // Q11895636
    {Coordinate{27.998, 63.9777}, CountryId{"FI"}}, // Talvivaara rail yard
    {Coordinate{21.7419, 62.475}, CountryId{"FI"}}, // Q11897075
    {Coordinate{30.3552, 62.2448}, CountryId{"FI"}}, // Q11897816
    {Coordinate{27.7251, 62.997}, CountryId{"FI"}}, // Q11897875
    {Coordinate{24.6383, 60.9183}, CountryId{"FI"}}, // Turenki railway station
    {Coordinate{}, CountryId{"FI"}}, // Törmä railway station
    {Coordinate{30.2417, 62.9122}, CountryId{"FI"}}, // Uimaharju railway station
    {Coordinate{26.9326, 60.8775}, CountryId{"FI"}}, // Q11899737
    {Coordinate{21.4272, 60.7972}, CountryId{"FI"}}, // Uusikaupunki railway station
    {Coordinate{26.0156, 60.9278}, CountryId{"FI"}}, // Uusikylä railway station
    {Coordinate{26.8425, 64.5581}, CountryId{"FI"}}, // Vaala railway station
    {Coordinate{25.8744, 66.5189}, CountryId{"FI"}}, // Q11899953
    {Coordinate{28.3376, 60.8553}, CountryId{"FI"}}, // Vainikkala railway station
    {Coordinate{24.0167, 61.2742}, CountryId{"FI"}}, // Q11900121
    {Coordinate{30.1639, 62.305}, CountryId{"FI"}}, // Q11900131
    {Coordinate{22.8875, 61.3492}, CountryId{"FI"}}, // Vammala Railway Station
    {Coordinate{29.9486, 64.5397}, CountryId{"FI"}}, // Vartius railway station
    {Coordinate{29.6117, 63.4215}, CountryId{"FI"}}, // Q11901166
    {Coordinate{23.77, 61.2125}, CountryId{"FI"}}, // Q11901292
    {Coordinate{25.8248, 60.9466}, CountryId{"FI"}}, // Villähde railway station
    {Coordinate{24.5072, 62.0258}, CountryId{"FI"}}, // Vilppula railway station
    {Coordinate{22.8236, 63.2864}, CountryId{"FI"}}, // Q11901889
    {Coordinate{28.2733, 64.1475}, CountryId{"FI"}}, // Vuokatti Railway Station
    {Coordinate{30.6443, 62.1671}, CountryId{"RU"}}, // Vyartsilya (railway station)
    {Coordinate{22.9594, 62.4}, CountryId{"FI"}}, // Q11902887
    {Coordinate{29.5653, 62.6206}, CountryId{"FI"}}, // Ylämylly railway station
    {Coordinate{29.4689, 64.4794}, CountryId{"FI"}}, // Ypykkävaara railway station
    {Coordinate{24.0636, 62.5536}, CountryId{"FI"}}, // Ähtäri railway station
    {Coordinate{28.8906, 64.8867}, CountryId{"FI"}}, // Ämmänsaari railway station
    {Coordinate{53.9508, 56.9542}, CountryId{"RU"}}, // Q1191379
    {Coordinate{14.3811, 49.9386}, CountryId{"CZ"}}, // Vrané nad Vltavou
    {Coordinate{12.5314, 64.2828}, CountryId{"NO"}}, // Agle Station
    {Coordinate{11.4829, 59.059}, CountryId{"NO"}}, // Aspedammen Station
    {Coordinate{9.365, 59.9053}, CountryId{"NO"}}, // Bakkerud stasjon
    {Coordinate{10.3881, 59.3183}, CountryId{"NO"}}, // Barkåker Station
    {Coordinate{10.7705, 59.883}, CountryId{"NO"}}, // Bekkelaget Station
    {Coordinate{11.2916, 59.1253}, CountryId{"NO"}}, // Berg Station
    {Coordinate{9.24833, 60.4761}, CountryId{"NO"}}, // Q11960710
    {Coordinate{9.00833, 62.1036}, CountryId{"NO"}}, // Bottheim stoppested
    {Coordinate{12.0219, 60.3158}, CountryId{"NO"}}, // Brandval Station
    {Coordinate{9.20111, 60.4908}, CountryId{"NO"}}, // Bromma Station
    {Coordinate{10.5589, 61.0078}, CountryId{"NO"}}, // Brøttum Station
    {Coordinate{11.5147, 59.0214}, CountryId{"NO"}}, // Q11962528
    {Coordinate{9.88611, 59.8069}, CountryId{"NO"}}, // Burud Station
    {Coordinate{9.32977, 59.3864}, CountryId{"NO"}}, // Dalsvatn Station
    {Coordinate{9.34389, 59.9461}, CountryId{"NO"}}, // Djupdal Station
    {Coordinate{13.2428, 65.7008}, CountryId{"NO"}}, // Q11966887
    {Coordinate{11.2711, 60.5817}, CountryId{"NO"}}, // Espa station
    {Coordinate{9.76972, 60.815}, CountryId{"NO"}}, // Etna Station
    {Coordinate{8.23278, 58.5225}, CountryId{"NO"}}, // Fidjetun Station
    {Coordinate{12.0208, 60.5984}, CountryId{"NO"}}, // Flisa Station
    {Coordinate{9.2766, 62.1188}, CountryId{"NO"}}, // Fokstua Station
    {Coordinate{5.47031, 60.4468}, CountryId{"NO"}}, // Garnes Station
    {Coordinate{12.3919, 64.5339}, CountryId{"NO"}}, // Gartland Station
    {Coordinate{11.2982, 59.3799}, CountryId{"NO"}}, // Gautestad stasjon
    {Coordinate{11.037, 59.2649}, CountryId{"NO"}}, // Greåker Station
    {Coordinate{12.0478, 60.4061}, CountryId{"NO"}}, // Grinder Station
    {Coordinate{10.4894, 60.2961}, CountryId{"NO"}}, // Grindvoll Station
    {Coordinate{9.60694, 60.3828}, CountryId{"NO"}}, // Gulsvik stasjon
    {Coordinate{8.99889, 60.2417}, CountryId{"NO"}}, // Gvammen Station
    {Coordinate{8.5225, 58.6286}, CountryId{"NO"}}, // Helldalsmo Station
    {Coordinate{10.2256, 60.2186}, CountryId{"NO"}}, // Hen Station
    {Coordinate{6.36333, 58.4736}, CountryId{"NO"}}, // Heskestad train station
    {Coordinate{8.36694, 60.5761}, CountryId{"NO"}}, // Hol Station
    {Coordinate{10.3497, 60.7072}, CountryId{"NO"}}, // Hov stasjon
    {Coordinate{9.9675, 61.5475}, CountryId{"NO"}}, // Hundorp Station
    {Coordinate{11.2389, 59.1589}, CountryId{"NO"}}, // Ingedal Station
    {Coordinate{11.2196, 59.3002}, CountryId{"NO"}}, // Ise Station
    {Coordinate{10.985, 60.8289}, CountryId{"NO"}}, // Jessnes stasjon
    {Coordinate{10.4042, 60.2403}, CountryId{"NO"}}, // Jevnaker Station
    {Coordinate{11.7081, 60.8075}, CountryId{"NO"}}, // Jømna Station
    {Coordinate{9.11222, 60.0711}, CountryId{"NO"}}, // Q11980943
    {Coordinate{9.83916, 60.0869}, CountryId{"NO"}}, // Q11981217
    {Coordinate{9.76694, 59.6694}, CountryId{"NO"}}, // Krekling Station
    {Coordinate{9.78087, 60.1268}, CountryId{"NO"}}, // Krøderen Station
    {Coordinate{9.57639, 59.8333}, CountryId{"NO"}}, // Lampeland stasjon
    {Coordinate{10.9017, 63.5475}, CountryId{"NO"}}, // Langstein Station
    {Coordinate{10.151, 59.0615}, CountryId{"NO"}}, // Lauve Station
    {Coordinate{10.2411, 59.787}, CountryId{"NO"}}, // Lier station
    {Coordinate{12.2019, 59.9514}, CountryId{"NO"}}, // Magnor stasjon
    {Coordinate{7.83368, 62.4476}, CountryId{"NO"}}, // Marstein stasjon
    {Coordinate{12.1248, 60.0273}, CountryId{"NO"}}, // Matrand Station
    {Coordinate{10.2728, 63.2894}, CountryId{"NO"}}, // Melhus Station
    {Coordinate{10.7303, 63.4319}, CountryId{"NO"}}, // Midtsandan Station
    {Coordinate{11.2308, 60.3953}, CountryId{"NO"}}, // Minnesund Station
    {Coordinate{7.92389, 58.2156}, CountryId{"NO"}}, // Mosby Station
    {Coordinate{12.0792, 60.4992}, CountryId{"NO"}}, // Namnå Station
    {Coordinate{9.00944, 60.1686}, CountryId{"NO"}}, // Norefjord Station
    {Coordinate{10.3828, 59.4248}, CountryId{"NO"}}, // Nykirke Station
    {Coordinate{10.3369, 63.3167}, CountryId{"NO"}}, // Nypan Station
    {Coordinate{8.11139, 58.4442}, CountryId{"NO"}}, // Oggevatn stasjon
    {Coordinate{11.14, 60.7469}, CountryId{"NO"}}, // Ottestad stasjon
    {Coordinate{6.4675, 60.6347}, CountryId{"NO"}}, // Palmafoss Station
    {Coordinate{9.80333, 60.2689}, CountryId{"NO"}}, // Q11997017
    {Coordinate{10.8653, 62.9622}, CountryId{"NO"}}, // Reitstøa Station
    {Coordinate{9.29417, 59.9847}, CountryId{"NO"}}, // Rollag stasjon
    {Coordinate{7.76079, 62.4843}, CountryId{"NO"}}, // Q11998350
    {Coordinate{12.0529, 60.2565}, CountryId{"NO"}}, // Roverud Station
    {Coordinate{11.3275, 62.7283}, CountryId{"NO"}}, // Rugldalen stasjon
    {Coordinate{9.60528, 59.6331}, CountryId{"NO"}}, // Saggrenda Station
    {Coordinate{11.0911, 59.2769}, CountryId{"NO"}}, // Sandesund Station
    {Coordinate{9.41618, 61.8388}, CountryId{"NO"}}, // Sel Station
    {Coordinate{8.60083, 58.7083}, CountryId{"NO"}}, // Simonstad Station
    {Coordinate{11.1898, 59.2108}, CountryId{"NO"}}, // Skjeberg Station
    {Coordinate{10.3986, 60.6411}, CountryId{"NO"}}, // Skrukli Station
    {Coordinate{9.92694, 60.2408}, CountryId{"NO"}}, // Sokna Station
    {Coordinate{10.1778, 62.955}, CountryId{"NO"}}, // Soknedal stasjon
    {Coordinate{11.2236, 60.6583}, CountryId{"NO"}}, // Steinsrud Station
    {Coordinate{11.2308, 62.8558}, CountryId{"NO"}}, // Stensli Station
    {Coordinate{11.7329, 64.1205}, CountryId{"NO"}}, // Stod Station
    {Coordinate{11.2408, 60.5203}, CountryId{"NO"}}, // Strandlykkja stasjon
    {Coordinate{11.6308, 64.0792}, CountryId{"NO"}}, // Sunnan stasjon
    {Coordinate{9.9165, 59.9942}, CountryId{"NO"}}, // Sysle Station
    {Coordinate{10.8964, 62.3419}, CountryId{"NO"}}, // Telneset stasjon
    {Coordinate{9.62056, 60.8442}, CountryId{"NO"}}, // Tonsåsen Station
    {Coordinate{8.71611, 60.66}, CountryId{"NO"}}, // Torpo stasjon
    {Coordinate{14.7467, 67.3019}, CountryId{"NO"}}, // Tverlandet Station
    {Coordinate{6.34306, 58.5286}, CountryId{"NO"}}, // Ualand Station
    {Coordinate{9.98472, 62.7492}, CountryId{"NO"}}, // Ulsberg Station
    {Coordinate{8.05843, 62.3471}, CountryId{"NO"}}, // Verma Station
    {Coordinate{11.8361, 60.6775}, CountryId{"NO"}}, // Våler Station
    {Coordinate{8.56213, 60.6262}, CountryId{"NO"}}, // Ål Station
    {Coordinate{9.91333, 59.8914}, CountryId{"NO"}}, // Åmot stasjon
    {Coordinate{11.3517, 61.0783}, CountryId{"NO"}}, // Åsta Station
    {Coordinate{10.8919, 59.3051}, CountryId{"NO"}}, // Q12011874
    {Coordinate{9.38472, 59.5658}, CountryId{"NO"}}, // Øysteinstul Station
    {Coordinate{6.2317, 51.008}, CountryId{"DE"}}, // Q12013412
    {Coordinate{7.0752, 51.4503}, CountryId{"DE"}}, // Essen-Steele station
    {Coordinate{6.85219, 51.052}, CountryId{"DE"}}, // Köln-Worringen station
    {Coordinate{15.0734, 50.9188}, CountryId{"CZ"}}, // Frýdlant v Čechách
    {Coordinate{15.0765, 50.9268}, CountryId{"CZ"}}, // Q12017882
    {Coordinate{15.1973, 50.9288}, CountryId{"CZ"}}, // Q12018876
    {Coordinate{15.5877, 49.5987}, CountryId{"CZ"}}, // Havlíčkův Brod (train station)
    {Coordinate{15.185, 50.8795}, CountryId{"CZ"}}, // Hejnice
    {Coordinate{14.5229, 50.6824}, CountryId{"CZ"}}, // Česká Lípa-Holý vrch railway station
    {Coordinate{15.1978, 50.952}, CountryId{"CZ"}}, // Q12020303
    {Coordinate{18.0166, 49.521}, CountryId{"CZ"}}, // Q12020370
    {Coordinate{13.8931, 49.1873}, CountryId{"CZ"}}, // Q12020513
    {Coordinate{15.8654, 49.0942}, CountryId{"CZ"}}, // Q12023715
    {Coordinate{12.8669, 50.2353}, CountryId{"CZ"}}, // Q12028735
    {Coordinate{12.8642, 50.2297}, CountryId{"CZ"}}, // Karlovy Vary dolní nádraží
    {Coordinate{15.1286, 50.9378}, CountryId{"CZ"}}, // Q12031789
    {Coordinate{15.1519, 50.8917}, CountryId{"CZ"}}, // Luh pod Smrkem (train station)
    {Coordinate{15.1649, 50.8864}, CountryId{"CZ"}}, // Lužec pod Smrkem (train station)
    {Coordinate{15.0292, 50.9508}, CountryId{"CZ"}}, // Q12037746
    {Coordinate{18.0684, 49.5288}, CountryId{"CZ"}}, // Mořkov hlavní trať
    {Coordinate{15.0328, 50.7533}, CountryId{"CZ"}}, // Q12041530
    {Coordinate{14.4045, 50.1073}, CountryId{"CZ"}}, // Praha-Bubeneč railway station
    {Coordinate{14.4047, 49.9976}, CountryId{"CZ"}}, // Praha-Modřany
    {Coordinate{14.42, 50.0678}, CountryId{"CZ"}}, // Praha-Vyšehrad railway station
    {Coordinate{14.6767, 49.4139}, CountryId{"CZ"}}, // Tábor (train station)
    {Coordinate{15.9395, 49.5542}, CountryId{"CZ"}}, // Q12041540
    {Coordinate{14.4761, 50.0853}, CountryId{"CZ"}}, // Nákladové nádraží Žižkov
    {Coordinate{14.4733, 50.0511}, CountryId{"CZ"}}, // Praha jih
    {Coordinate{14.4374, 50.1062}, CountryId{"CZ"}}, // Praha-Holešovice railway stop
    {Coordinate{14.5653, 50.0481}, CountryId{"CZ"}}, // Praha-Horní Měcholupy
    {Coordinate{14.4614, 50.0417}, CountryId{"CZ"}}, // Q12046776
    {Coordinate{14.403, 50.0039}, CountryId{"CZ"}}, // Praha-Modřany zastávka
    {Coordinate{14.4053, 50.0678}, CountryId{"CZ"}}, // Q12046781
    {Coordinate{14.4071, 50.0617}, CountryId{"CZ"}}, // Praha-Smíchov severní nástupiště
    {Coordinate{15.1306, 50.8964}, CountryId{"CZ"}}, // Q12048902
    {Coordinate{16.6275, 49.4086}, CountryId{"CZ"}}, // Q12050537
    {Coordinate{15.1578, 49.0661}, CountryId{"CZ"}}, // Q12051403
    {Coordinate{8.44944, 52.2044}, CountryId{"DE"}}, // Bruchmühlen station
    {Coordinate{6.94911, 51.4728}, CountryId{"DE"}}, // Essen-Borbeck station
    {Coordinate{13.8292, 50.6464}, CountryId{"CZ"}}, // Q12058668
    {Coordinate{15.8844, 49.2115}, CountryId{"CZ"}}, // Třebíč train station
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12061636
    {Coordinate{34.5294, 47.6237}, CountryId{"UA"}}, // Q12061666
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12061675
    {Coordinate{34.2442, 48.4961}, CountryId{"UA"}}, // Q12061689
    {Coordinate{34.7261, 48.4658}, CountryId{"UA"}}, // Q12061768
    {Coordinate{34.7378, 48.4586}, CountryId{"UA"}}, // Q12061769
    {Coordinate{34.7761, 48.4411}, CountryId{"UA"}}, // Q12061778
    {Coordinate{36.3494, 49.9614}, CountryId{"UA"}}, // Q12061803
    {Coordinate{36.2694, 49.8772}, CountryId{"UA"}}, // Q12062006
    {Coordinate{36.2822, 49.8689}, CountryId{"UA"}}, // Q12062096
    {Coordinate{33.642, 48.0442}, CountryId{"UA"}}, // Q12062161
    {Coordinate{7.07925, 50.8581}, CountryId{"DE"}}, // Porz-Wahn station
    {Coordinate{8.27944, 52.2364}, CountryId{"DE"}}, // Westerhausen station
    {Coordinate{24.3669, 50.635}, CountryId{"UA"}}, // Q12073651
    {Coordinate{26.3613, 50.4616}, CountryId{"UA"}}, // Ivachkove
    {Coordinate{35.1897, 48.4706}, CountryId{"UA"}}, // Q12073915
    {Coordinate{28.8125, 45.36}, CountryId{"UA"}}, // Izmail
    {Coordinate{37.3011, 49.216}, CountryId{"UA"}}, // Q12074128
    {Coordinate{26.8322, 50.1073}, CountryId{"UA"}}, // Izyaslav
    {Coordinate{35.2803, 48.4014}, CountryId{"UA"}}, // Ilarionove
    {Coordinate{35.1283, 47.8531}, CountryId{"UA"}}, // Imeni Anatoliya Alimova
    {Coordinate{31.6649, 51.367}, CountryId{"UA"}}, // Q12074333
    {Coordinate{38.4719, 48.3947}, CountryId{"UA"}}, // Q12074337
    {Coordinate{37.6823, 49.4734}, CountryId{"UA"}}, // Q12074338
    {Coordinate{31.8944, 49.2033}, CountryId{"UA"}}, // imeni Tarasa Shevchenko
    {Coordinate{33.1419, 47.6786}, CountryId{"UA"}}, // Inhulets
    {Coordinate{29.4517, 50.7211}, CountryId{"UA"}}, // Irsha
    {Coordinate{32.4082, 50.8422}, CountryId{"UA"}}, // Q12075422
    {Coordinate{29.2658, 47.9858}, CountryId{"UA"}}, // Abamelikove
    {Coordinate{33.2219, 51.4531}, CountryId{"UA"}}, // Altynivka
    {Coordinate{29.0109, 50.0246}, CountryId{"UA"}}, // Q12078317
    {Coordinate{26.9831, 49.7928}, CountryId{"UA"}}, // Q12078695
    {Coordinate{33.6906, 47.6594}, CountryId{"UA"}}, // Apostolove
    {Coordinate{29.4228, 45.9961}, CountryId{"UA"}}, // Q12079378
    {Coordinate{36.2983, 45.3747}, CountryId{"RU"}}, // Bagerovo
    {Coordinate{34.6467, 48.4819}, CountryId{"UA"}}, // Q12080158
    {Coordinate{35.5874, 49.362}, CountryId{"UA"}}, // Q12080652
    {Coordinate{29.625, 47.875}, CountryId{"UA"}}, // Q12080698
    {Coordinate{34.8381, 48.5936}, CountryId{"UA"}}, // Q12080746
    {Coordinate{35.6193, 49.9261}, CountryId{"UA"}}, // Baranove
    {Coordinate{31.32, 50.3461}, CountryId{"UA"}}, // Baryshivka
    {Coordinate{33.4844, 47.8728}, CountryId{"UA"}}, // Q12081218
    {Coordinate{32.7987, 51.181}, CountryId{"UA"}}, // Bakhmach-Kyivskiy
    {Coordinate{33.8492, 44.7556}, CountryId{"UA"}}, // Bakhchysarai Railway Station
    {Coordinate{36.2491, 49.8885}, CountryId{"UA"}}, // Q12081555
    {Coordinate{36.1337, 50.1658}, CountryId{"UA"}}, // Bezrukivka Railway Halt
    {Coordinate{31.5019, 50.3282}, CountryId{"UA"}}, // Berezan
    {Coordinate{28.7427, 50.2293}, CountryId{"UA"}}, // Bystra
    {Coordinate{31.0372, 50.6468}, CountryId{"UA"}}, // Bobryk
    {Coordinate{31.3714, 50.7636}, CountryId{"UA"}}, // Bobrovytsya
    {Coordinate{33.3856, 51.8591}, CountryId{"UA"}}, // Q12083236
    {Coordinate{27.1394, 49.3739}, CountryId{"UA"}}, // Q12083285
    {Coordinate{35.4898, 50.1565}, CountryId{"UA"}}, // Bogodukhiv
    {Coordinate{28.5794, 50.3186}, CountryId{"UA"}}, // Q12083401
    {Coordinate{34.1228, 48.3553}, CountryId{"UA"}}, // Bozhedarivka
    {Coordinate{30.9456, 50.3767}, CountryId{"UA"}}, // Boryspil
    {Coordinate{29.8942, 50.6287}, CountryId{"UA"}}, // Borodianka
    {Coordinate{30.4091, 50.4261}, CountryId{"UA"}}, // Borshchahivka-Technichna
    {Coordinate{29.4931, 47.8661}, CountryId{"UA"}}, // Borshchi
    {Coordinate{30.5681, 50.4078}, CountryId{"UA"}}, // Q12084353
    {Coordinate{30.2994, 50.3211}, CountryId{"UA"}}, // Boiarka
    {Coordinate{39.1458, 48.3989}, CountryId{"UA"}}, // Q12084546
    {Coordinate{33.8531, 46.8314}, CountryId{"UA"}}, // Q12084628
    {Coordinate{36.9325, 49.4259}, CountryId{"UA"}}, // Q12084642
    {Coordinate{33.4859, 51.8032}, CountryId{"UA"}}, // Q12084850
    {Coordinate{25.1561, 50.0697}, CountryId{"UA"}}, // Q12084951
    {Coordinate{33.44, 51.6472}, CountryId{"UA"}}, // Bryulovetskyi
    {Coordinate{23.9369, 49.9042}, CountryId{"UA"}}, // Q12085088
    {Coordinate{29.2125, 49.9243}, CountryId{"UA"}}, // Brivky
    {Coordinate{36.4445, 49.6594}, CountryId{"UA"}}, // Q12085277
    {Coordinate{37.3941, 49.1314}, CountryId{"UA"}}, // Q12085501
    {Coordinate{30.2214, 50.5489}, CountryId{"UA"}}, // Bucha
    {Coordinate{30.1098, 49.8121}, CountryId{"UA"}}, // Bila Tserkva
    {Coordinate{30.3392, 46.1847}, CountryId{"UA"}}, // Bilhorod-Dnistrovskyi
    {Coordinate{30.3347, 50.4878}, CountryId{"UA"}}, // Bilychi
    {Coordinate{28.7447, 48.5336}, CountryId{"UA"}}, // Vapnyarka
    {Coordinate{30.2253, 50.2258}, CountryId{"UA"}}, // Vasylkiv 1st
    {Coordinate{32.5449, 51.1143}, CountryId{"UA"}}, // Velyka Zahorivka
    {Coordinate{33.7381, 50.3647}, CountryId{"UA"}}, // Veneslavivka
    {Coordinate{34.3686, 48.5539}, CountryId{"UA"}}, // Verkhnodniprovsk
    {Coordinate{36.3086, 48.2069}, CountryId{"UA"}}, // Q12088881
    {Coordinate{29.992, 47.1059}, CountryId{"UA"}}, // Veselyi Kut
    {Coordinate{33.4281, 47.9958}, CountryId{"UA"}}, // Q12089050
    {Coordinate{30.3978, 46.6136}, CountryId{"UA"}}, // Vyhoda
    {Coordinate{32.8656, 47.9811}, CountryId{"UA"}}, // Q12089634
    {Coordinate{30.3689, 50.3844}, CountryId{"UA"}}, // Vyshneve
    {Coordinate{35.3764, 45.1683}, CountryId{"UA"}}, // Vladislavovka Railway station
    {Coordinate{36.9194, 50.2836}, CountryId{"UA"}}, // Q12089995
    {Coordinate{38.4883, 48.8697}, CountryId{"UA"}}, // Q12090014
    {Coordinate{24.3347, 50.8417}, CountryId{"UA"}}, // Q12090407
    {Coordinate{26.2084, 49.5322}, CountryId{"UA"}}, // Volochysk
    {Coordinate{34.2246, 51.1702}, CountryId{"UA"}}, // Vorozhba
    {Coordinate{30.5844, 47.8767}, CountryId{"UA"}}, // Q12090819
    {Coordinate{26.4503, 49.4955}, CountryId{"UA"}}, // Q12093150
    {Coordinate{34.0158, 48.4653}, CountryId{"UA"}}, // Q12093253
    {Coordinate{29.4381, 51.3616}, CountryId{"UA"}}, // Q12093298
    {Coordinate{28.511, 49.2393}, CountryId{"UA"}}, // Vinnytsia
    {Coordinate{35.574, 50.0842}, CountryId{"UA"}}, // Q12093758
    {Coordinate{30.8397, 49.7474}, CountryId{"UA"}}, // Halyne
    {Coordinate{32.1907, 50.7063}, CountryId{"UA"}}, // Halka
    {Coordinate{27.3918, 50.1311}, CountryId{"UA"}}, // Hannusyne
    {Coordinate{33.0681, 47.9292}, CountryId{"UA"}}, // Q12094549
    {Coordinate{34.7741, 46.1737}, CountryId{"UA"}}, // Q12094739
    {Coordinate{33.9383, 51.6781}, CountryId{"UA"}}, // Hlukhiv
    {Coordinate{33.8228, 49.9125}, CountryId{"UA"}}, // Hoholeve
    {Coordinate{28.7153, 49.5653}, CountryId{"UA"}}, // Holendry
    {Coordinate{28.6823, 50.456}, CountryId{"UA"}}, // Gorbashi
    {Coordinate{31.6419, 51.9144}, CountryId{"UA"}}, // Horodnia
    {Coordinate{24.8156, 50.4498}, CountryId{"UA"}}, // Q12097137
    {Coordinate{34.9836, 48.4783}, CountryId{"UA"}}, // Q12097185
    {Coordinate{36.8671, 49.7292}, CountryId{"UA"}}, // Q12097411
    {Coordinate{32.8234, 51.0179}, CountryId{"UA"}}, // Q12097711
    {Coordinate{33.5397, 51.2139}, CountryId{"UA"}}, // Q12098060
    {Coordinate{26.857, 49.4637}, CountryId{"UA"}}, // Hruzivtsi
    {Coordinate{35.3748, 50.1775}, CountryId{"UA"}}, // Q12098238
    {Coordinate{35.2661, 48.8022}, CountryId{"UA"}}, // Q12098255
    {Coordinate{38.4972, 48.3647}, CountryId{"UA"}}, // Q12100187
    {Coordinate{29.1164, 45.6519}, CountryId{"UA"}}, // Dzynilor
    {Coordinate{30.9408, 50.5923}, CountryId{"UA"}}, // Dymerka
    {Coordinate{34.4169, 48.5892}, CountryId{"UA"}}, // Q12101357
    {Coordinate{34.6353, 48.5897}, CountryId{"UA"}}, // Q12101384
    {Coordinate{34.5875, 48.5256}, CountryId{"UA"}}, // Kamianske
    {Coordinate{34.991, 48.4217}, CountryId{"UA"}}, // Q12101392
    {Coordinate{28.5858, 51.2897}, CountryId{"UA"}}, // Khaichnoryn
    {Coordinate{32.7617, 48.115}, CountryId{"UA"}}, // Dolynska
    {Coordinate{28.6724, 50.9424}, CountryId{"UA"}}, // Drevlyanka
    {Coordinate{33.3922, 51.1989}, CountryId{"UA"}}, // Q12102637
    {Coordinate{37.6917, 48.815}, CountryId{"UA"}}, // Q12102642
    {Coordinate{26.8381, 49.0206}, CountryId{"UA"}}, // Dunaivtsi
    {Coordinate{34.9089, 48.4614}, CountryId{"UA"}}, // Q12103344
    {Coordinate{34.0414, 51.8106}, CountryId{"UA"}}, // Q12104126
    {Coordinate{24.0172, 52.2006}, CountryId{"BY"}}, // Zhabinka
    {Coordinate{33.9153, 48.4369}, CountryId{"UA"}}, // Q12104400
    {Coordinate{31.001, 50.6264}, CountryId{"UA"}}, // Zherdove
    {Coordinate{28.6978, 50.2681}, CountryId{"UA"}}, // Zhytomyr
    {Coordinate{36.2475, 49.8475}, CountryId{"UA"}}, // Q12104670
    {Coordinate{33.6153, 48.3817}, CountryId{"UA"}}, // Zhovti Vody 1
    {Coordinate{28.7204, 48.6012}, CountryId{"UA"}}, // Zhuravlivka
    {Coordinate{31.1357, 50.6901}, CountryId{"UA"}}, // Zavorychi
    {Coordinate{33.5589, 46.7731}, CountryId{"UA"}}, // Q12105183
    {Coordinate{29.795, 50.6567}, CountryId{"UA"}}, // Zahaltsi
    {Coordinate{37.2033, 49.3767}, CountryId{"UA"}}, // Q12105425
    {Coordinate{36.1617, 49.9675}, CountryId{"UA"}}, // Q12105617
    {Coordinate{35.2378, 47.8842}, CountryId{"UA"}}, // Q12105856
    {Coordinate{35.1881, 47.7958}, CountryId{"UA"}}, // Zaporizhzhia I
    {Coordinate{35.1847, 47.8222}, CountryId{"UA"}}, // Zaporizhzhia-2 Railway Station
    {Coordinate{35.2297, 49.2144}, CountryId{"UA"}}, // Q12106211
    {Coordinate{34.0224, 52.1839}, CountryId{"UA"}}, // Zernove
    {Coordinate{32.7012, 48.7089}, CountryId{"UA"}}, // Znamyanka-Pasazhirska
    {Coordinate{32.6539, 48.7163}, CountryId{"UA"}}, // Znamyanka
    {Coordinate{35.9883, 50.2737}, CountryId{"UA"}}, // Q12107002
    {Coordinate{35.0202, 48.3997}, CountryId{"UA"}}, // Zustrichny
    {Coordinate{36.3031, 49.79}, CountryId{"UA"}}, // Q12107263
    {Coordinate{29.0009, 50.8601}, CountryId{"UA"}}, // Yosypivka
    {Coordinate{30.7846, 49.8419}, CountryId{"UA"}}, // Kaharlyk
    {Coordinate{32.7614, 47.8806}, CountryId{"UA"}}, // Kazanka
    {Coordinate{24.3489, 49.0128}, CountryId{"UA"}}, // Kalush
    {Coordinate{33.6647, 48.1553}, CountryId{"UA"}}, // Q12107981
    {Coordinate{31.7806, 51.8633}, CountryId{"UA"}}, // Kamka
    {Coordinate{24.9604, 51.6054}, CountryId{"UA"}}, // Q12108257
    {Coordinate{34.9506, 47.8383}, CountryId{"UA"}}, // Q12108331
    {Coordinate{30.832, 49.6371}, CountryId{"UA"}}, // Karapyshi
    {Coordinate{34.7211, 48.4775}, CountryId{"UA"}}, // Q12108762
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12108950
    {Coordinate{33.4286, 46.7525}, CountryId{"UA"}}, // Q12109158
    {Coordinate{32.6583, 50.8896}, CountryId{"UA"}}, // Q12109192
    {Coordinate{35.7639, 49.2867}, CountryId{"UA"}}, // Q12109390
    {Coordinate{36.4275, 45.3631}, CountryId{"RU"}}, // Kerch Railway station
    {Coordinate{38.6958, 48.4386}, CountryId{"UA"}}, // Q12109879
    {Coordinate{30.0164, 50.5813}, CountryId{"UA"}}, // Klavdijeve
    {Coordinate{23.9803, 49.8556}, CountryId{"UA"}}, // Q12110434
    {Coordinate{28.8129, 48.4719}, CountryId{"UA"}}, // Knyazheve
    {Coordinate{30.783, 50.495}, CountryId{"UA"}}, // Kniazhychi
    {Coordinate{34.1033, 49.2306}, CountryId{"UA"}}, // Q12110816
    {Coordinate{31.5493, 50.8237}, CountryId{"UA"}}, // Kobyzhchi
    {Coordinate{24.7119, 51.2217}, CountryId{"UA"}}, // Kovel
    {Coordinate{28.6646, 50.1078}, CountryId{"UA"}}, // Kodnia
    {Coordinate{29.7315, 49.9811}, CountryId{"UA"}}, // Kozhanka
    {Coordinate{28.8389, 49.7114}, CountryId{"UA"}}, // Koziatyn 1st
    {Coordinate{27.5033, 50.4281}, CountryId{"UA"}}, // Kolodyanka
    {Coordinate{35.2177, 49.855}, CountryId{"UA"}}, // Kolomak
    {Coordinate{31.0172, 47.3036}, CountryId{"UA"}}, // Kolosivka Railway Station
    {Coordinate{27.6656, 49.1947}, CountryId{"UA"}}, // Q12111948
    {Coordinate{36.6961, 47.3286}, CountryId{"UA"}}, // Q12111993
    {Coordinate{32.1067, 50.1775}, CountryId{"UA"}}, // Kononivka
    {Coordinate{28.7834, 49.64}, CountryId{"UA"}}, // Kordyshivka
    {Coordinate{33.0662, 48.7324}, CountryId{"UA"}}, // Korystivka
    {Coordinate{29.5172, 50.0419}, CountryId{"UA"}}, // Kornyn
    {Coordinate{28.6346, 50.9571}, CountryId{"UA"}}, // Korosten
    {Coordinate{29.0202, 50.3163}, CountryId{"UA"}}, // Q12113210
    {Coordinate{34.0989, 51.1703}, CountryId{"UA"}}, // Q12113964
    {Coordinate{27.0139, 49.6692}, CountryId{"UA"}}, // Krasyliv Railway Station
    {Coordinate{24.6147, 49.9169}, CountryId{"UA"}}, // Krasne
    {Coordinate{35.445, 49.3606}, CountryId{"UA"}}, // Q12114235
    {Coordinate{28.62, 50.7697}, CountryId{"UA"}}, // Krasnosilka
    {Coordinate{33.3097, 47.8789}, CountryId{"UA"}}, // Q12114657
    {Coordinate{33.3764, 47.8783}, CountryId{"UA"}}, // Kryvyi Rih
    {Coordinate{26.7003, 50.3616}, CountryId{"UA"}}, // Kryvyn
    {Coordinate{28.8642, 48.3797}, CountryId{"UA"}}, // Kryzhopil'
    {Coordinate{33.3619, 51.5514}, CountryId{"UA"}}, // Krolevets
    {Coordinate{28.6708, 50.2947}, CountryId{"UA"}}, // Q12115030
    {Coordinate{33.4356, 49.0344}, CountryId{"UA"}}, // Q12115164
    {Coordinate{34.0489, 48.2739}, CountryId{"UA"}}, // Q12115417
    {Coordinate{35.3091, 50.2307}, CountryId{"UA"}}, // Q12115859
    {Coordinate{28.1189, 50.4308}, CountryId{"UA"}}, // Q12115988
    {Coordinate{35.1969, 47.7197}, CountryId{"UA"}}, // Q12116306
    {Coordinate{35.2736, 48.8767}, CountryId{"UA"}}, // Q12116431
    {Coordinate{32.2604, 48.5238}, CountryId{"UA"}}, // Kropyvnytskyi
    {Coordinate{35.2183, 45.2272}, CountryId{"UA"}}, // Q12116617
    {Coordinate{32.6436, 50.0955}, CountryId{"UA"}}, // Lazirky
    {Coordinate{26.8505, 48.4311}, CountryId{"UA"}}, // Larga
    {Coordinate{31.987, 50.8756}, CountryId{"UA"}}, // Q12118462
    {Coordinate{33.4603, 50.3681}, CountryId{"UA"}}, // Q12118512
    {Coordinate{39.2081, 48.4097}, CountryId{"UA"}}, // Q12118937
    {Coordinate{35.9273, 49.9412}, CountryId{"UA"}}, // Ljubotin
    {Coordinate{27.3078, 50.2936}, CountryId{"UA"}}, // Maidan-Vyla
    {Coordinate{31.3262, 50.748}, CountryId{"UA"}}, // Makarivka
    {Coordinate{33.5894, 51.8261}, CountryId{"UA"}}, // Makove
    {Coordinate{35.701, 50.0897}, CountryId{"UA"}}, // Q12120655
    {Coordinate{29.9482, 50.6035}, CountryId{"UA"}}, // Makiychukove
    {Coordinate{34.52, 49.3964}, CountryId{"UA"}}, // Mala Pereshchepynska
    {Coordinate{29.2949, 50.7746}, CountryId{"UA"}}, // Malyn
    {Coordinate{26.5492, 51.0947}, CountryId{"UA"}}, // Q12120858
    {Coordinate{32.2672, 50.1481}, CountryId{"UA"}}, // Marianivka
    {Coordinate{34.6214, 47.655}, CountryId{"UA"}}, // Q12121308
    {Coordinate{31.2775, 50.7286}, CountryId{"UA"}}, // Markivtsi
    {Coordinate{33.1464, 46.9188}, CountryId{"UA"}}, // Q12121920
    {Coordinate{36.7361, 48.2506}, CountryId{"UA"}}, // Q12122299
    {Coordinate{28.8692, 50.8892}, CountryId{"UA"}}, // Meleni
    {Coordinate{35.7626, 50.0076}, CountryId{"UA"}}, // Q12122785
    {Coordinate{36.2017, 47.9833}, CountryId{"UA"}}, // Q12123151
    {Coordinate{24.5111, 51.3617}, CountryId{"UA"}}, // Q12123208
    {Coordinate{32.0619, 46.9372}, CountryId{"UA"}}, // Mykolaiv
    {Coordinate{33.9628, 48.1994}, CountryId{"UA"}}, // Q12123391
    {Coordinate{33.6256, 49.9492}, CountryId{"UA"}}, // Myrhorod
    {Coordinate{30.9807, 49.6483}, CountryId{"UA"}}, // Myronivka
    {Coordinate{27.6687, 50.0998}, CountryId{"UA"}}, // Myropil
    {Coordinate{26.5572, 50.4152}, CountryId{"UA"}}, // Mohylyany
    {Coordinate{28.1119, 49.0339}, CountryId{"UA"}}, // Zhmerynka
    {Coordinate{33.6436, 46.7903}, CountryId{"UA"}}, // Q12129294
    {Coordinate{30.1053, 50.1822}, CountryId{"UA"}}, // Motovylivka
    {Coordinate{36.4801, 49.8322}, CountryId{"UA"}}, // Q12130339
    {Coordinate{33.4025, 47.9153}, CountryId{"UA"}}, // Mudrona
    {Coordinate{22.7114, 48.4294}, CountryId{"UA"}}, // Mukachevo Railway Station
    {Coordinate{33.2039, 47.8867}, CountryId{"UA"}}, // Q12130877
    {Coordinate{39.1383, 48.5767}, CountryId{"UA"}}, // Milova
    {Coordinate{26.6211, 49.5085}, CountryId{"UA"}}, // Narkevychi
    {Coordinate{38.4079, 48.9422}, CountryId{"UA"}}, // Q12132512
    {Coordinate{30.087, 50.5617}, CountryId{"UA"}}, // Nemishajeve
    {Coordinate{33.8442, 51.9728}, CountryId{"UA"}}, // Neplyujeve
    {Coordinate{34.7378, 45.4472}, CountryId{"UA"}}, // Q12133681
    {Coordinate{35.0636, 48.4981}, CountryId{"UA"}}, // Q12133684
    {Coordinate{28.6243, 50.6912}, CountryId{"UA"}}, // Nova Borova
    {Coordinate{28.7782, 50.9234}, CountryId{"UA"}}, // Novaki
    {Coordinate{33.2551, 51.9932}, CountryId{"UA"}}, // Novhorod-Siverskyi
    {Coordinate{33.4856, 47.9122}, CountryId{"UA"}}, // Q12134026
    {Coordinate{27.5931, 50.5978}, CountryId{"UA"}}, // Novohrad-Volynskyi 1
    {Coordinate{35.4858, 48.0239}, CountryId{"UA"}}, // Q12134069
    {Coordinate{35.2322, 48.6425}, CountryId{"UA"}}, // Q12134139
    {Coordinate{34.6503, 46.2306}, CountryId{"UA"}}, // Novooleksiivka
    {Coordinate{29.8686, 46.8022}, CountryId{"MD"}}, // Novosavitskaia
    {Coordinate{30.6236, 50.1863}, CountryId{"UA"}}, // Novi Bezradychi
    {Coordinate{34.4042, 49.3281}, CountryId{"UA"}}, // Q12134305
    {Coordinate{31.6041, 50.9028}, CountryId{"UA"}}, // Nosivka
    {Coordinate{34.3944, 47.5867}, CountryId{"UA"}}, // Nikopol Railway Station
    {Coordinate{30.7313, 50.0336}, CountryId{"UA"}}, // Ozernyi
    {Coordinate{26.035, 50.4578}, CountryId{"UA"}}, // Q12135355
    {Coordinate{33.1325, 48.6739}, CountryId{"UA"}}, // Oleksandriya
    {Coordinate{30.6489, 49.6581}, CountryId{"UA"}}, // Olshanytsia
    {Coordinate{27.5614, 50.5053}, CountryId{"UA"}}, // Orepy
    {Coordinate{36.0191, 48.9746}, CountryId{"UA"}}, // Q12136461
    {Coordinate{26.4941, 50.437}, CountryId{"UA"}}, // Ostroh
    {Coordinate{34.9165, 50.3175}, CountryId{"UA"}}, // Q12137017
    {Coordinate{33.6478, 48.4271}, CountryId{"UA"}}, // P'yatykhatky-Stykova
    {Coordinate{33.7031, 48.4144}, CountryId{"UA"}}, // P'yatykhatky
    {Coordinate{32.075, 49.5053}, CountryId{"UA"}}, // Q12138703
    {Coordinate{30.9024, 50.5704}, CountryId{"UA"}}, // Parnykova
    {Coordinate{29.3699, 50.7367}, CountryId{"UA"}}, // Penyzevychi
    {Coordinate{31.1822, 47.2967}, CountryId{"UA"}}, // Q12139466
    {Coordinate{30.8511, 48.0747}, CountryId{"UA"}}, // Q12139476
    {Coordinate{38.5789, 48.6253}, CountryId{"UA"}}, // Q12139477
    {Coordinate{37.6131, 49.3647}, CountryId{"UA"}}, // Q12139564
    {Coordinate{35.3119, 49.0192}, CountryId{"UA"}}, // Q12139842
    {Coordinate{31.6556, 50.2641}, CountryId{"UA"}}, // Pereyaslavska
    {Coordinate{27.8004, 50.0752}, CountryId{"UA"}}, // Pechanivka
    {Coordinate{32.5064, 50.2353}, CountryId{"UA"}}, // Q12140595
    {Coordinate{29.2202, 50.8042}, CountryId{"UA"}}, // Pirizhkivskiy
    {Coordinate{33.601, 48.0161}, CountryId{"UA"}}, // Q12140660
    {Coordinate{34.4508, 48.5361}, CountryId{"UA"}}, // Q12140806
    {Coordinate{34.1324, 48.471}, CountryId{"UA"}}, // Hranove
    {Coordinate{32.4403, 51.1028}, CountryId{"UA"}}, // Plysky
    {Coordinate{36.2592, 47.4761}, CountryId{"UA"}}, // Polohy Railway Station
    {Coordinate{27.4882, 50.1396}, CountryId{"UA"}}, // Polonne
    {Coordinate{33.1642, 47.7644}, CountryId{"UA"}}, // Poltavka-Kryvorizka
    {Coordinate{34.2233, 48.4431}, CountryId{"UA"}}, // Q12142068
    {Coordinate{32.7012, 48.7089}, CountryId{"UA"}}, // Q12142234
    {Coordinate{27.5248, 50.138}, CountryId{"UA"}}, // Poninka
    {Coordinate{29.4594, 49.9445}, CountryId{"UA"}}, // Popilnia
    {Coordinate{33.8864, 48.1597}, CountryId{"UA"}}, // Q12142876
    {Coordinate{29.8786, 50.0533}, CountryId{"UA"}}, // Potiivka
    {Coordinate{34.6589, 48.5172}, CountryId{"UA"}}, // Q12143209
    {Coordinate{34.7558, 48.2269}, CountryId{"UA"}}, // Q12144085
    {Coordinate{36.3764, 48.1175}, CountryId{"UA"}}, // Q12145067
    {Coordinate{28.7064, 50.1758}, CountryId{"UA"}}, // Q12145327
    {Coordinate{33.8497, 51.2025}, CountryId{"UA"}}, // Putyvl
    {Coordinate{33.6036, 51.2131}, CountryId{"UA"}}, // Q12145664
    {Coordinate{26.1408, 49.5292}, CountryId{"UA"}}, // Q12145919
    {Coordinate{30.8936, 48.1092}, CountryId{"UA"}}, // Q12145956
    {Coordinate{30.5542, 50.2668}, CountryId{"UA"}}, // Pidhirtsi
    {Coordinate{24.0339, 49.8511}, CountryId{"UA"}}, // Pidzamche
    {Coordinate{33.9264, 47.6328}, CountryId{"UA"}}, // Q12146117
    {Coordinate{29.6454, 50.6946}, CountryId{"UA"}}, // Pisky
    {Coordinate{27.395, 50.3578}, CountryId{"UA"}}, // Radulyn
    {Coordinate{33.5147, 47.8194}, CountryId{"UA"}}, // Q12146659
    {Coordinate{37.6061, 49.2697}, CountryId{"UA"}}, // Q12146685
    {Coordinate{27.9558, 50.0526}, CountryId{"UA"}}, // Razine
    {Coordinate{30.7743, 49.9434}, CountryId{"UA"}}, // Rasava
    {Coordinate{34.5163, 47.6204}, CountryId{"UA"}}, // Q12147209
    {Coordinate{}, CountryId{"UA"}}, // Q12147742
    {Coordinate{34.1433, 49.6372}, CountryId{"UA"}}, // Reshetylivka
    {Coordinate{28.636, 50.0128}, CountryId{"UA"}}, // Q12147811
    {Coordinate{29.3031, 49.4928}, CountryId{"UA"}}, // Rzhevuska
    {Coordinate{35.5542, 49.3799}, CountryId{"UA"}}, // Q12148412
    {Coordinate{30.5073, 49.6957}, CountryId{"UA"}}, // Rokytne
    {Coordinate{33.4786, 48.0439}, CountryId{"UA"}}, // Rokuvata
    {Coordinate{33.3236, 49.9914}, CountryId{"UA"}}, // Romodan
    {Coordinate{30.1871, 49.7796}, CountryId{"UA"}}, // Rotok
    {Coordinate{28.9344, 48.2606}, CountryId{"UA"}}, // Rudnytsya
    {Coordinate{23.9233, 49.8364}, CountryId{"UA"}}, // Rudno
    {Coordinate{37.0372, 49.3932}, CountryId{"UA"}}, // Q12149977
    {Coordinate{33.6267, 48.2947}, CountryId{"UA"}}, // Q12150023
    {Coordinate{33.5856, 48.0664}, CountryId{"UA"}}, // Q12150237
    {Coordinate{35.8722, 49.1494}, CountryId{"UA"}}, // Q12150831
    {Coordinate{33.9422, 51.9564}, CountryId{"UA"}}, // Svesa
    {Coordinate{37.5556, 49.1244}, CountryId{"UA"}}, // Q12151155
    {Coordinate{32.5828, 52.2039}, CountryId{"UA"}}, // Q12151992
    {Coordinate{31.0614, 50.6603}, CountryId{"UA"}}, // Semypolky
    {Coordinate{38.7496, 48.669}, CountryId{"UA"}}, // Q12152121
    {Coordinate{33.4422, 50.1981}, CountryId{"UA"}}, // Sencha
    {Coordinate{28.8936, 49.7499}, CountryId{"UA"}}, // Sestrynivka
    {Coordinate{21.6281, 47.5206}, CountryId{"HU"}}, // Debrecen Railway Station
    {Coordinate{34.4869, 45.9681}, CountryId{"UA"}}, // Syvash
    {Coordinate{35.5275, 48.3211}, CountryId{"UA"}}, // Synelnykove 1st
    {Coordinate{35.5106, 48.3339}, CountryId{"UA"}}, // Q12152813
    {Coordinate{34.8642, 50.7975}, CountryId{"UA"}}, // Syrovatka
    {Coordinate{30.1992, 50.5335}, CountryId{"UA"}}, // Sklozavodskya
    {Coordinate{23.9308, 49.8169}, CountryId{"UA"}}, // Q12153286
    {Coordinate{37.6961, 49.5631}, CountryId{"UA"}}, // Q12153350
    {Coordinate{29.3853, 50.1}, CountryId{"UA"}}, // Skochyshche
    {Coordinate{35.5111, 48.1244}, CountryId{"UA"}}, // Q12153542
    {Coordinate{26.8851, 50.3207}, CountryId{"UA"}}, // Slavuta 1
    {Coordinate{36.1543, 50.2095}, CountryId{"UA"}}, // Q12153593
    {Coordinate{32.3893, 50.1264}, CountryId{"UA"}}, // Sloboda-Petrivka
    {Coordinate{29.3442, 47.8851}, CountryId{"UA"}}, // Slobidka
    {Coordinate{37.5903, 48.8467}, CountryId{"UA"}}, // Q12153721
    {Coordinate{37.5558, 48.8325}, CountryId{"UA"}}, // Q12153723
    {Coordinate{27.66, 50.5478}, CountryId{"UA"}}, // Q12153972
    {Coordinate{34.9685, 50.4819}, CountryId{"UA"}}, // Q12153994
    {Coordinate{31.8763, 49.2415}, CountryId{"UA"}}, // Smila
    {Coordinate{32.7797, 47.0653}, CountryId{"UA"}}, // Q12154073
    {Coordinate{35.8502, 49.9532}, CountryId{"UA"}}, // Ljubotin-Zahidny
    {Coordinate{33.8361, 48.0978}, CountryId{"UA"}}, // Q12156907
    {Coordinate{28.7911, 50.2031}, CountryId{"UA"}}, // Stanyshivka
    {Coordinate{31.9756, 46.9575}, CountryId{"UA"}}, // Mykolaiv-Vantazhnyi
    {Coordinate{38.9275, 49.2772}, CountryId{"UA"}}, // Q12157377
    {Coordinate{27.1672, 49.7506}, CountryId{"UA"}}, // Q12157413
    {Coordinate{38.5855, 48.5192}, CountryId{"UA"}}, // Q12157568
    {Coordinate{29.0994, 50.1383}, CountryId{"UA"}}, // Stepok
    {Coordinate{33.9228, 45.1594}, CountryId{"UA"}}, // Q12158034
    {Coordinate{28.8106, 50.912}, CountryId{"UA"}}, // Stremyhorod
    {Coordinate{23.8417, 49.2594}, CountryId{"UA"}}, // Q12158201
    {Coordinate{28.6921, 50.3683}, CountryId{"UA"}}, // Strokovytsi
    {Coordinate{30.739, 50.1505}, CountryId{"UA"}}, // Stuhna
    {Coordinate{27.1322, 50.1803}, CountryId{"UA"}}, // Sudylkiv
    {Coordinate{33.4006, 50.3992}, CountryId{"UA"}}, // Sula
    {Coordinate{34.9083, 48.3319}, CountryId{"UA"}}, // Q12158819
    {Coordinate{30.3675, 49.7384}, CountryId{"UA"}}, // Sukholisy
    {Coordinate{35.2842, 47.4378}, CountryId{"UA"}}, // Q12159700
    {Coordinate{31.1292, 49.5702}, CountryId{"UA"}}, // Tahancha
    {Coordinate{30.6621, 50.1743}, CountryId{"UA"}}, // Tatsenky
    {Coordinate{25.6994, 49.3006}, CountryId{"UA"}}, // Q12160673
    {Coordinate{33.4814, 51.7642}, CountryId{"UA"}}, // Tereshenska
    {Coordinate{33.5344, 48.1786}, CountryId{"UA"}}, // Terny
    {Coordinate{36.3492, 49.8536}, CountryId{"UA"}}, // Q12160819
    {Coordinate{25.6, 49.55}, CountryId{"UA"}}, // Ternopil Railway Station
    {Coordinate{29.5994, 50.6986}, CountryId{"UA"}}, // Teteriv
    {Coordinate{29.0696, 50.8448}, CountryId{"UA"}}, // Tyshiv
    {Coordinate{28.667, 50.5375}, CountryId{"UA"}}, // Toporyshche
    {Coordinate{31.0762, 50.365}, CountryId{"UA"}}, // Travneva
    {Coordinate{31.3053, 47.7053}, CountryId{"UA"}}, // Q12162399
    {Coordinate{30.7531, 50.1398}, CountryId{"UA"}}, // Tripillya-Dniprovske
    {Coordinate{37.5281, 49.1316}, CountryId{"UA"}}, // Q12162474
    {Coordinate{31.195, 50.7036}, CountryId{"UA"}}, // Trubizh
    {Coordinate{28.4885, 49.1506}, CountryId{"UA"}}, // Tjushki
    {Coordinate{33.9264, 47.6328}, CountryId{"UA"}}, // Q12163177
    {Coordinate{30.2042, 48.7331}, CountryId{"UA"}}, // Uman
    {Coordinate{28.5891, 50.8626}, CountryId{"UA"}}, // Ushomyr
    {Coordinate{29.9431, 50.0529}, CountryId{"UA"}}, // Fastiv 2nd
    {Coordinate{35.9492, 50.141}, CountryId{"UA"}}, // Q12165665
    {Coordinate{28.4092, 45.4397}, CountryId{"UA"}}, // Frycatzey
    {Coordinate{32.9958, 51.2028}, CountryId{"UA"}}, // Khalymonove
    {Coordinate{36.1813, 50.0262}, CountryId{"UA"}}, // Q12166913
    {Coordinate{36.1412, 49.9573}, CountryId{"UA"}}, // Khvylynka
    {Coordinate{31.4931, 52.0297}, CountryId{"UA"}}, // Khorobychi
    {Coordinate{32.2681, 51.0851}, CountryId{"UA"}}, // Khoroshe Ozero
    {Coordinate{27.2443, 50.1507}, CountryId{"UA"}}, // Khrolyn
    {Coordinate{29.8537, 50.637}, CountryId{"UA"}}, // Khutir Hai
    {Coordinate{26.9541, 50.2572}, CountryId{"UA"}}, // Tsvitokha
    {Coordinate{37.2696, 49.3083}, CountryId{"UA"}}, // Q12168763
    {Coordinate{36.2364, 48.1278}, CountryId{"UA"}}, // Q12169135
    {Coordinate{33.2981, 47.9386}, CountryId{"UA"}}, // Q12169607
    {Coordinate{31.7587, 50.9704}, CountryId{"UA"}}, // Volodkova Divytsia
    {Coordinate{32.6223, 51.1266}, CountryId{"UA"}}, // Cheremushky
    {Coordinate{31.2489, 51.5197}, CountryId{"UA"}}, // Chernihiv-Pivnichnyi
    {Coordinate{28.9393, 50.8739}, CountryId{"UA"}}, // Chepovychi
    {Coordinate{26.7429, 49.4955}, CountryId{"UA"}}, // Chornyi Ostriv
    {Coordinate{38.4906, 48.3294}, CountryId{"UA"}}, // Q12170600
    {Coordinate{27.0117, 50.0278}, CountryId{"UA"}}, // Q12170667
    {Coordinate{30.3544, 46.14}, CountryId{"UA"}}, // Shabo
    {Coordinate{28.7108, 50.9358}, CountryId{"UA"}}, // Shatrishche
    {Coordinate{27.0753, 50.1639}, CountryId{"UA"}}, // Q12171670
    {Coordinate{23.5549, 49.9701}, CountryId{"UA"}}, // Q12171997
    {Coordinate{33.4103, 47.9642}, CountryId{"UA"}}, // Shmakovo
    {Coordinate{33.4689, 51.8633}, CountryId{"UA"}}, // Q12172245
    {Coordinate{33.3944, 48.5944}, CountryId{"UA"}}, // Shchaslyva
    {Coordinate{29.3482, 50.7484}, CountryId{"UA"}}, // Shebzavod
    {Coordinate{30.7565, 50.1239}, CountryId{"UA"}}, // Sherbanivka
    {Coordinate{31.9447, 51.8142}, CountryId{"UA"}}, // Snovsk
    {Coordinate{33.3317, 50.4708}, CountryId{"UA"}}, // Q12173151
    {Coordinate{35.1639, 46.6805}, CountryId{"UA"}}, // Yakymivka
    {Coordinate{30.7573, 50.4787}, CountryId{"UA"}}, // Yalynka
    {Coordinate{33.7447, 51.9119}, CountryId{"UA"}}, // Yampil
    {Coordinate{35.3564, 47.9081}, CountryId{"UA"}}, // Q12173803
    {Coordinate{25.5511, 52.1289}, CountryId{"BY"}}, // Yanaw-Palyeski
    {Coordinate{34.0277, 45.1166}, CountryId{"UA"}}, // Q12173902
    {Coordinate{31.2286, 50.7124}, CountryId{"UA"}}, // Yaroslavka
    {Coordinate{28.268, 48.9023}, CountryId{"UA"}}, // Yaroshenka
    {Coordinate{7.27097, 46.2085}, CountryId{"CH"}}, // Ardon railway station
    {Coordinate{6.55944, 46.6875}, CountryId{"CH"}}, // Bavois
    {Coordinate{7.0008, 46.2513}, CountryId{"CH"}}, // Bex railway station
    {Coordinate{7.24056, 46.1886}, CountryId{"CH"}}, // Chamoson-St-Pierre-de-Clages railway station
    {Coordinate{6.56816, 46.7101}, CountryId{"CH"}}, // Chavornay
    {Coordinate{7.30472, 46.216}, CountryId{"CH"}}, // Châteauneuf-Conthey railway station
    {Coordinate{7.12639, 46.1269}, CountryId{"CH"}}, // Charrat-Fully railway station
    {Coordinate{6.94875, 46.2713}, CountryId{"CH"}}, // Collombey railway station
    {Coordinate{6.5525, 46.6572}, CountryId{"CH"}}, // Eclépens
    {Coordinate{6.6075, 46.7464}, CountryId{"CH"}}, // Ependes
    {Coordinate{6.58056, 46.7278}, CountryId{"CH"}}, // Essert-Pittet
    {Coordinate{7.7475, 46.3067}, CountryId{"CH"}}, // Gampel-Steg railway station
    {Coordinate{8.86578, 46.1791}, CountryId{"CH"}}, // Gordola train station
    {Coordinate{6.85347, 46.3859}, CountryId{"CH"}}, // Bouveret railway station
    {Coordinate{6.87947, 46.3632}, CountryId{"CH"}}, // Les Evouettes railway station
    {Coordinate{6.98556, 46.2414}, CountryId{"CH"}}, // Massongex railway station
    {Coordinate{8.37417, 47.045}, CountryId{"CH"}}, // Q12174810
    {Coordinate{8.40903, 47.0676}, CountryId{"CH"}}, // Merlischachen station
    {Coordinate{8.38306, 47.05}, CountryId{"CH"}}, // Meggen railway station
    {Coordinate{6.95523, 46.2556}, CountryId{"CH"}}, // Monthey railway station
    {Coordinate{7.80139, 46.3064}, CountryId{"CH"}}, // Raron railway station
    {Coordinate{7.21778, 46.1725}, CountryId{"CH"}}, // Riddes railway station
    {Coordinate{8.88532, 46.1755}, CountryId{"CH"}}, // Q12174819
    {Coordinate{6.80616, 46.3922}, CountryId{"CH"}}, // St-Gingolph railway station
    {Coordinate{7.57917, 46.3094}, CountryId{"CH"}}, // Salgesch railway station
    {Coordinate{7.41944, 46.2514}, CountryId{"CH"}}, // St-Léonard railway station
    {Coordinate{7.17333, 46.1494}, CountryId{"CH"}}, // Saxon railway station
    {Coordinate{8.94337, 47.2252}, CountryId{"CH"}}, // Schmerikon railway station
    {Coordinate{8.85056, 46.1775}, CountryId{"CH"}}, // Q12174832
    {Coordinate{7.69972, 46.3094}, CountryId{"CH"}}, // Turtmann railway station
    {Coordinate{8.98068, 47.2243}, CountryId{"CH"}}, // Uznach railway station
    {Coordinate{6.91625, 46.315}, CountryId{"CH"}}, // Vionnaz railway station
    {Coordinate{6.89806, 46.3369}, CountryId{"CH"}}, // Vouvry railway station
    {Coordinate{6.64083, 46.7817}, CountryId{"CH"}}, // Yverdon-les-Bains railway station
    {Coordinate{-3.11408, 43.2103}, CountryId{"ES"}}, // Q12253835
    {Coordinate{-3.05029, 43.202}, CountryId{"ES"}}, // Q12267477
    {Coordinate{-3.13099, 43.2157}, CountryId{"ES"}}, // Q12268164
    {Coordinate{-3.1333, 43.2129}, CountryId{"ES"}}, // Q12269192
    {Coordinate{-3.01605, 43.2333}, CountryId{"ES"}}, // Q12269216
    {Coordinate{27.473, 42.491}, CountryId{"BG"}}, // Burgas Railway Station
    {Coordinate{26.4223, 58.2243}, CountryId{"EE"}}, // Q12362022
    {Coordinate{26.4014, 58.7456}, CountryId{"EE"}}, // Jõgeva railway station
    {Coordinate{24.6856, 59.2383}, CountryId{"EE"}}, // Q12366959
    {Coordinate{24.9989, 58.9617}, CountryId{"EE"}}, // Q12367397
    {Coordinate{25.0086, 58.85}, CountryId{"EE"}}, // Q12368493
    {Coordinate{24.7231, 59.3875}, CountryId{"EE"}}, // Liiva railway station
    {Coordinate{24.7872, 59.1153}, CountryId{"EE"}}, // Q12368930
    {Coordinate{25.5392, 58.6686}, CountryId{"EE"}}, // Q12371442
    {Coordinate{27.0913, 58.07}, CountryId{"EE"}}, // Q12373188
    {Coordinate{24.6989, 59.3342}, CountryId{"EE"}}, // Q12374605
    {Coordinate{25.5444, 58.4669}, CountryId{"EE"}}, // Q12375980
    {Coordinate{24.7459, 59.4127}, CountryId{"EE"}}, // Tallinn-Väike
    {Coordinate{25.4242, 58.8047}, CountryId{"EE"}}, // Q12377636
    {Coordinate{24.7135, 59.2009}, CountryId{"EE"}}, // Q12378648
    {Coordinate{25.5617, 58.6294}, CountryId{"EE"}}, // Q12379075
    {Coordinate{30.3289, 59.92}, CountryId{"RU"}}, // Vitebsky railway station
    {Coordinate{74.6375, 26.4566}, CountryId{"IN"}}, // Ajmer Junction railway station
    {Coordinate{80.8415, 26.7744}, CountryId{"IN"}}, // Amausi railway station
    {Coordinate{76.8287, 30.3382}, CountryId{"IN"}}, // Ambala Cantonment railway station
    {Coordinate{76.3225, 9.48376}, CountryId{"IN"}}, // Alappuzha railway station
    {Coordinate{83.1606, 26.0386}, CountryId{"IN"}}, // Azamgarh railway station
    {Coordinate{78.536, 19.6805}, CountryId{"IN"}}, // Adilabad railway station
    {Coordinate{81.8288, 25.4462}, CountryId{"IN"}}, // Allahabad Junction railway station
    {Coordinate{85.2173, 25.1386}, CountryId{"IN"}}, // Islampur railway station
    {Coordinate{73.6996, 24.5669}, CountryId{"IN"}}, // Udaipur City railway station
    {Coordinate{75.1549, 32.9266}, CountryId{"IN"}}, // Udhampur railway station
    {Coordinate{76.2757, 31.4788}, CountryId{"IN"}}, // Una Himachal railway station
    {Coordinate{78.2875, 30.1072}, CountryId{"IN"}}, // Rishikesh railway station
    {Coordinate{69.0738, 22.471}, CountryId{"IN"}}, // Okha railway station
    {Coordinate{77.5425, 8.08803}, CountryId{"IN"}}, // Kanyakumari railway station
    {Coordinate{82.2329, 16.967}, CountryId{"IN"}}, // Kakinada Town railway station
    {Coordinate{82.2401, 16.9552}, CountryId{"IN"}}, // Kakinada Port railway station
    {Coordinate{91.6907, 26.1571}, CountryId{"IN"}}, // Kamakhya Junction railway station
    {Coordinate{76.9318, 30.8377}, CountryId{"IN"}}, // Kalka railway station
    {Coordinate{88.3304, 25.6393}, CountryId{"IN"}}, // Kaliyaganj railway station
    {Coordinate{78.646, 27.8019}, CountryId{"IN"}}, // Kasganj Junction railway station
    {Coordinate{77.1451, 28.6469}, CountryId{"IN"}}, // Kirti Nagar railway station
    {Coordinate{79.3886, 10.953}, CountryId{"IN"}}, // Kumbakonam railway station
    {Coordinate{78.0327, 15.8337}, CountryId{"IN"}}, // Kurnool railway station
    {Coordinate{78.5212, 29.7429}, CountryId{"IN"}}, // Kotdwara railway station
    {Coordinate{82.713, 22.3376}, CountryId{"IN"}}, // Korba railway station
    {Coordinate{82.7194, 18.7922}, CountryId{"IN"}}, // Koraput railway station
    {Coordinate{76.5968, 8.88659}, CountryId{"IN"}}, // Kollam Junction railway station
    {Coordinate{79.89, 24.797}, CountryId{"IN"}}, // Khajuraho railway station
    {Coordinate{75.6425, 15.437}, CountryId{"IN"}}, // Gadag Junction railway station
    {Coordinate{77.4311, 28.6497}, CountryId{"IN"}}, // Ghaziabad railway station
    {Coordinate{83.3815, 26.7593}, CountryId{"IN"}}, // Gorakhpur railway station
    {Coordinate{48.8942, 55.8161}, CountryId{"RU"}}, // Q124288
    {Coordinate{83.1544, 20.2844}, CountryId{"IN"}}, // Titlagarh railway station
    {Coordinate{83.6021, 25.5717}, CountryId{"IN"}}, // Tarighat railway station
    {Coordinate{77.708, 8.73636}, CountryId{"IN"}}, // Tirunelveli Junction railway station
    {Coordinate{77.238, 28.6276}, CountryId{"IN"}}, // Tilak Bridge railway station
    {Coordinate{95.3341, 27.4797}, CountryId{"IN"}}, // New Tinsukia railway station
    {Coordinate{77.1714, 28.6673}, CountryId{"IN"}}, // Daya basti railway station
    {Coordinate{81.88, 25.4426}, CountryId{"IN"}}, // Daraganj railway station
    {Coordinate{77.1436, 28.6283}, CountryId{"IN"}}, // Indrapuri railway station
    {Coordinate{77.2013, 28.6647}, CountryId{"IN"}}, // Delhi Kishanganj railway station
    {Coordinate{77.438, 28.6744}, CountryId{"IN"}}, // Naya Ghaziabad railway station
    {Coordinate{81.86, 25.3931}, CountryId{"IN"}}, // Naini railway station
    {Coordinate{77.1563, 28.66}, CountryId{"IN"}}, // Patel Nagar railway station
    {Coordinate{77.0929, 28.5857}, CountryId{"IN"}}, // Palam railway station
    {Coordinate{81.7416, 25.4449}, CountryId{"IN"}}, // Bamhrauli railway station
    {Coordinate{80.9614, 26.8686}, CountryId{"IN"}}, // Badshahnagar railway station
    {Coordinate{86.9768, 25.2419}, CountryId{"IN"}}, // Bhagalpur Junction railway station
    {Coordinate{73.9707, 15.2679}, CountryId{"IN"}}, // Madgaon Junction railway station
    {Coordinate{3.61522, 51.1544}, CountryId{"BE"}}, // Waarschoot railway station
    {Coordinate{72.8386, 18.9524}, CountryId{"IN"}}, // Masjid Bunder railway station
    {Coordinate{3.57417, 51.1814}, CountryId{"BE"}}, // Eeklo railway station
    {Coordinate{77.6751, 28.9776}, CountryId{"IN"}}, // Meerut City railway station
    {Coordinate{77.5717, 28.8279}, CountryId{"IN"}}, // Modinagar railway station
    {Coordinate{81.2506, 24.5371}, CountryId{"IN"}}, // Rewa Terminal railway station
    {Coordinate{80.9179, 26.8591}, CountryId{"IN"}}, // Lucknow City railway station
    {Coordinate{77.2441, 28.5793}, CountryId{"IN"}}, // Lajpat Nagar railway station
    {Coordinate{77.2165, 28.5795}, CountryId{"IN"}}, // Lodhi Colony railway station
    {Coordinate{77.1837, 28.6641}, CountryId{"IN"}}, // Vivekanand Puri Halt railway station
    {Coordinate{70.3707, 20.9134}, CountryId{"IN"}}, // Veraval Junction railway station
    {Coordinate{77.2266, 28.6341}, CountryId{"IN"}}, // Shivaji Bridge railway station
    {Coordinate{73.8714, 29.9318}, CountryId{"IN"}}, // Sri Ganganagar railway station
    {Coordinate{77.1671, 28.5958}, CountryId{"IN"}}, // Sardar Patel Road railway station
    {Coordinate{86.595, 25.8752}, CountryId{"IN"}}, // Saharsa Junction railway station
    {Coordinate{77.5417, 29.9605}, CountryId{"IN"}}, // Saharanpur Junction railway station
    {Coordinate{87.6346, 25.2414}, CountryId{"IN"}}, // Sahibganj Jn railway station
    {Coordinate{77.3642, 28.674}, CountryId{"IN"}}, // Sahibabad Junction railway station
    {Coordinate{8.34944, 49.5353}, CountryId{"DE"}}, // Frankenthal Central Station
    {Coordinate{81.7899, 25.4399}, CountryId{"IN"}}, // Subedarganj railway station
    {Coordinate{77.2278, 28.5786}, CountryId{"IN"}}, // Sewa Nagar railway station
    {Coordinate{4.96806, 51.8339}, CountryId{"NL"}}, // Gorinchem railway station
    {Coordinate{19.0894, 47.5253}, CountryId{"HU"}}, // Rákosrendező railway station
    {Coordinate{11.32, 50.2394}, CountryId{"DE"}}, // Kronach station
    {Coordinate{6.99056, 49.2414}, CountryId{"DE"}}, // Saarbrücken Central Station
    {Coordinate{10.3835, 63.4123}, CountryId{"NO"}}, // Q12718620
    {Coordinate{26.2661, 47.6706}, CountryId{"RO"}}, // Suceava railway station
    {Coordinate{18.679, 47.7998}, CountryId{"SK"}}, // Štúrovo railway station
    {Coordinate{7.90778, 46.5983}, CountryId{"CH"}}, // Lauterbrunnen railway station
    {Coordinate{7.95944, 46.5844}, CountryId{"CH"}}, // Kleine Scheidegg railway station
    {Coordinate{53.4486, 56.8686}, CountryId{"RU"}}, // Q1279157
    {Coordinate{54.0172, 57.0417}, CountryId{"RU"}}, // Q1279171
    {Coordinate{10.5256, 59.8928}, CountryId{"NO"}}, // Sandvika Station
    {Coordinate{7.26331, 47.6416}, CountryId{"FR"}}, // Q128074
    {Coordinate{16.4461, 46.5564}, CountryId{"SI"}}, // Lendava train station
    {Coordinate{8.5804, 49.4487}, CountryId{"DE"}}, // Mannheim-Friedrichsfeld station
    {Coordinate{10.555, 59.8972}, CountryId{"NO"}}, // Blommenholm Station
    {Coordinate{21.2297, 48.5083}, CountryId{"HU"}}, // Hidasnémeti railway station
    {Coordinate{17.7948, 46.3529}, CountryId{"HU"}}, // Kaposvár railway station
    {Coordinate{17.1925, 47.9942}, CountryId{"HU"}}, // Rajka railway station
    {Coordinate{19.1742, 47.4887}, CountryId{"HU"}}, // Rákos railway station
    {Coordinate{19.2581, 47.4861}, CountryId{"HU"}}, // Rákosliget railway station
    {Coordinate{20.1758, 47.1789}, CountryId{"HU"}}, // Szolnok railway station
    {Coordinate{18.3932, 47.5856}, CountryId{"HU"}}, // Tatabánya railway station
    {Coordinate{69.2861, 41.2921}, CountryId{"UZ"}}, // Toshkent Passenger
    {Coordinate{1.51179, 44.3333}, CountryId{"FR"}}, // Q1283201
    {Coordinate{6.26389, 50.8148}, CountryId{"DE"}}, // Q129311
    {Coordinate{13.7664, 51.1244}, CountryId{"DE"}}, // Dresden Flughafen railway station
    {Coordinate{20.1428, 46.2397}, CountryId{"HU"}}, // Szeged railway station
    {Coordinate{3.33184, 50.2781}, CountryId{"FR"}}, // Gare de Bouchain
    {Coordinate{30.4033, 53.8769}, CountryId{"BY"}}, // Lupolava
    {Coordinate{9.27, 48.82}, CountryId{"DE"}}, // Fellbach station
    {Coordinate{9.23472, 48.8061}, CountryId{"DE"}}, // Stuttgart Nürnberger Straße station
    {Coordinate{6.43971, 51.1631}, CountryId{"DE"}}, // Rheydt Central Station
    {Coordinate{75.2131, 43.54}, CountryId{"KZ"}}, // Otar
    {Coordinate{73.7199, 16.2588}, CountryId{"IN"}}, // Kankavli railway station
    {Coordinate{70.1181, 22.469}, CountryId{"IN"}}, // Hapa railway station
    {Coordinate{7.25396, 52.1623}, CountryId{"DE"}}, // Metelen Land station
    {Coordinate{79.8462, 10.6869}, CountryId{"IN"}}, // Velankanni railway station
    {Coordinate{13.4956, 66.0858}, CountryId{"NO"}}, // Bjerka Station
    {Coordinate{80.04, 44.01}, CountryId{"KZ"}}, // Kundyzdy
    {Coordinate{79.483, 43.738}, CountryId{"KZ"}}, // Taskaras
    {Coordinate{77.0161, 43.4253}, CountryId{"KZ"}}, // Zhety-Su station
    {Coordinate{6.62735, 46.5099}, CountryId{"CH"}}, // Jordils
    {Coordinate{37.6572, 55.7764}, CountryId{"RU"}}, // Moscow Yaroslavsky railway station
    {Coordinate{28.5971, 49.9183}, CountryId{"UA"}}, // Berdychiv-Zhytomyrskyi
    {Coordinate{32.8184, 51.1785}, CountryId{"UA"}}, // Q13360789
    {Coordinate{32.4274, 51.4033}, CountryId{"UA"}}, // Bondarivka
    {Coordinate{27.7013, 50.6465}, CountryId{"UA"}}, // Q13360796
    {Coordinate{33.1728, 51.2629}, CountryId{"UA"}}, // Vyrivka
    {Coordinate{27.9332, 50.7675}, CountryId{"UA"}}, // Virivka
    {Coordinate{28.3854, 50.915}, CountryId{"UA"}}, // Q13360800
    {Coordinate{29.8059, 49.3079}, CountryId{"UA"}}, // Denhofivka
    {Coordinate{32.5788, 51.316}, CountryId{"UA"}}, // Doch
    {Coordinate{30.0973, 49.2433}, CountryId{"UA"}}, // Zhashkiv
    {Coordinate{29.1978, 49.6461}, CountryId{"UA"}}, // Zarudyntsi
    {Coordinate{28.5936, 50.9565}, CountryId{"UA"}}, // Korosten-Zhytomyrskyi
    {Coordinate{32.2438, 51.7621}, CountryId{"UA"}}, // Koriukivka
    {Coordinate{32.3316, 51.4645}, CountryId{"UA"}}, // Makoshyne
    {Coordinate{28.9143, 49.7278}, CountryId{"UA"}}, // Makharyntsi
    {Coordinate{33.152, 51.368}, CountryId{"UA"}}, // Melnya
    {Coordinate{32.2348, 51.5323}, CountryId{"UA"}}, // Mena
    {Coordinate{32.0748, 51.6714}, CountryId{"UA"}}, // Q13360815
    {Coordinate{28.5648, 50.9638}, CountryId{"UA"}}, // Q13360816
    {Coordinate{28.2925, 50.8982}, CountryId{"UA"}}, // Omelyanivka
    {Coordinate{27.8193, 50.7069}, CountryId{"UA"}}, // Q13360831
    {Coordinate{29.6495, 49.3754}, CountryId{"UA"}}, // Q13360833
    {Coordinate{29.7103, 49.3663}, CountryId{"UA"}}, // Tetiiv
    {Coordinate{28.1975, 50.8584}, CountryId{"UA"}}, // Q13360836
    {Coordinate{32.6992, 51.2422}, CountryId{"UA"}}, // Q13360838
    {Coordinate{28.0664, 50.8061}, CountryId{"UA"}}, // Q13360839
    {Coordinate{26.8042, 49.1789}, CountryId{"UA"}}, // Yarmolyntsi
    {Coordinate{34.0277, 45.1166}, CountryId{"RU"}}, // Saky railway station
    {Coordinate{34.8008, 48.4403}, CountryId{"UA"}}, // Q13361022
    {Coordinate{32.0678, 49.0492}, CountryId{"UA"}}, // Kamyanka
    {Coordinate{32.1708, 49.0119}, CountryId{"UA"}}, // Kosari
    {Coordinate{31.3974, 48.9954}, CountryId{"UA"}}, // Q13361319
    {Coordinate{23.2981, 48.1617}, CountryId{"UA"}}, // Khust
    {Coordinate{34.4577, 51.2405}, CountryId{"UA"}}, // Volfine
    {Coordinate{33.3259, 51.8839}, CountryId{"UA"}}, // Bohdanivka
    {Coordinate{33.3496, 51.2009}, CountryId{"UA"}}, // Q13361355
    {Coordinate{33.2302, 51.2192}, CountryId{"UA"}}, // Q13361359
    {Coordinate{33.5007, 51.2146}, CountryId{"UA"}}, // Q13361360
    {Coordinate{33.7993, 51.9439}, CountryId{"UA"}}, // Ivotka
    {Coordinate{33.2981, 51.2032}, CountryId{"UA"}}, // Kalynivka
    {Coordinate{33.4519, 51.7033}, CountryId{"UA"}}, // Pyrotchyne
    {Coordinate{32.9224, 51.1954}, CountryId{"UA"}}, // Khutir Khalimonove
    {Coordinate{7.4102, 49.5382}, CountryId{"DE"}}, // Kusel station
    {Coordinate{7.4448, 49.4702}, CountryId{"DE"}}, // Glan-Münchweiler station
    {Coordinate{8.85501, 47.6561}, CountryId{"CH"}}, // Stein am Rhein railway station
    {Coordinate{44.7978, 41.7233}, CountryId{"GE"}}, // Tbilisi railway station
    {Coordinate{6.72258, 49.3526}, CountryId{"DE"}}, // Dillingen (Saar) station
    {Coordinate{31.7833, 51.3271}, CountryId{"UA"}}, // Q13423553
    {Coordinate{31.8823, 51.1762}, CountryId{"UA"}}, // Q13423559
    {Coordinate{31.1125, 51.7786}, CountryId{"UA"}}, // Q13423562
    {Coordinate{8.58663, 47.5206}, CountryId{"CH"}}, // Embrach-Rorbas railway station
    {Coordinate{31.1566, 51.9661}, CountryId{"UA"}}, // Q13423579
    {Coordinate{31.3172, 51.4307}, CountryId{"UA"}}, // Q13423580
    {Coordinate{31.2146, 51.5981}, CountryId{"UA"}}, // Q13423581
    {Coordinate{31.5542, 51.4262}, CountryId{"UA"}}, // Q13423583
    {Coordinate{31.9047, 51.0972}, CountryId{"UA"}}, // Q13423584
    {Coordinate{28.6419, 51.0197}, CountryId{"UA"}}, // Q13423592
    {Coordinate{28.6131, 50.9846}, CountryId{"UA"}}, // Korosten-Podilskyi
    {Coordinate{2.94946, 48.9602}, CountryId{"FR"}}, // Q13427283
    {Coordinate{15.025, 50.99}, CountryId{"CZ"}}, // Q13433906
    {Coordinate{10.9924, 62.958}, CountryId{"NO"}}, // Langlete Station
    {Coordinate{37.6553, 55.7763}, CountryId{"RU"}}, // Leningradsky railway station
    {Coordinate{6.8133, 51.3768}, CountryId{"DE"}}, // Duisburg-Entenfang station
    {Coordinate{6.32083, 50.8244}, CountryId{"DE"}}, // Q134564
    {Coordinate{8.65502, 50.1582}, CountryId{"DE"}}, // Frankfurt Eschersheim station
    {Coordinate{4.49278, 52.0464}, CountryId{"NL"}}, // Zoetermeer Oost railway station
    {Coordinate{6.90833, 51.1333}, CountryId{"DE"}}, // Düsseldorf-Hellerhof station
    {Coordinate{11.7388, 53.1607}, CountryId{"DE"}}, // Karstädt station
    {Coordinate{11.9608, 50.4197}, CountryId{"DE"}}, // Gutenfürst station
    {Coordinate{28.5917, 50.9753}, CountryId{"UA"}}, // Post-Pivdenny
    {Coordinate{7.01389, 51.4514}, CountryId{"DE"}}, // Essen Central Station
    {Coordinate{76.2722, 10.7589}, CountryId{"IN"}}, // Shoranur Junction railway station
    {Coordinate{5.88089, 45.2345}, CountryId{"FR"}}, // Lancey
    {Coordinate{15.4632, 66.743}, CountryId{"NO"}}, // Lønsdal Station
    {Coordinate{75.797, 22.5142}, CountryId{"IN"}}, // Indore Patalpani railway station
    {Coordinate{80.3284, 26.4562}, CountryId{"IN"}}, // Kanpur Anwarganj railway station
    {Coordinate{4.61778, 51.1508}, CountryId{"BE"}}, // Kessel railway station
    {Coordinate{23.4642, 56.7025}, CountryId{"LV"}}, // Līvbērze Station
    {Coordinate{6.47226, 51.1996}, CountryId{"DE"}}, // Mönchengladbach-Lürrip station
    {Coordinate{37.5803, 55.7764}, CountryId{"RU"}}, // Belorussky railway station
    {Coordinate{10.5778, 49.2983}, CountryId{"DE"}}, // Ansbach station
    {Coordinate{84.4221, 18.7568}, CountryId{"IN"}}, // Palasa railway station
    {Coordinate{12.0994, 49.0122}, CountryId{"DE"}}, // Regensburg Hauptbahnhof
    {Coordinate{10.5806, 59.9006}, CountryId{"NO"}}, // Høvik Station
    {Coordinate{37.6392, 55.7294}, CountryId{"RU"}}, // Paveletsky railway station
    {Coordinate{9.62471, 62.4241}, CountryId{"NO"}}, // Drivstua Station
    {Coordinate{9.35444, 48.8681}, CountryId{"DE"}}, // Schwaikheim station
    {Coordinate{15.9789, 45.8047}, CountryId{"HR"}}, // Zagreb Main Station
    {Coordinate{11.1191, 46.0726}, CountryId{"IT"}}, // Trento railway station
    {Coordinate{10.7508, 59.9111}, CountryId{"NO"}}, // Oslo Central Station
    {Coordinate{15.2242, 50.925}, CountryId{"CZ"}}, // Q14195910
    {Coordinate{15.1511, 50.9389}, CountryId{"CZ"}}, // Řasnice (train station)
    {Coordinate{15.0286, 50.9733}, CountryId{"CZ"}}, // Višňová
    {Coordinate{13.4311, 52.4675}, CountryId{"DE"}}, // Hermannstraße railway station
    {Coordinate{37.6562, 55.7733}, CountryId{"RU"}}, // Kazansky railway station
    {Coordinate{15.0203, 51.1531}, CountryId{"PL"}}, // Zgorzelec Miasto
    {Coordinate{4.02472, 50.9483}, CountryId{"BE"}}, // Aalst-Kerrebroek railway station
    {Coordinate{3.92238, 50.9071}, CountryId{"BE"}}, // Burst railway station
    {Coordinate{7.3509, 51.4959}, CountryId{"DE"}}, // Dortmund-Somborn station
    {Coordinate{6.20143, 50.8345}, CountryId{"DE"}}, // Eschweiler-St. Jöris station
    {Coordinate{12.94, 49.7431}, CountryId{"CZ"}}, // Q14386728
    {Coordinate{4.90214, 51.174}, CountryId{"BE"}}, // Olen railway station
    {Coordinate{4.65361, 50.8358}, CountryId{"BE"}}, // Oud-Heverlee railway station
    {Coordinate{12.4, 50.1153}, CountryId{"CZ"}}, // Tršnice sttaion
    {Coordinate{13.7513, 52.4296}, CountryId{"DE"}}, // Erkner railway station
    {Coordinate{18.4128, 49.7914}, CountryId{"CZ"}}, // Havířov railway station
    {Coordinate{6.84229, 46.7078}, CountryId{"CH"}}, // Q14475054
    {Coordinate{6.89438, 46.7588}, CountryId{"CH"}}, // Granges-Marnand railway station
    {Coordinate{73.8512, 18.5317}, CountryId{"IN"}}, // Shivajinagar railway station
    {Coordinate{24.4328, 57.2863}, CountryId{"LV"}}, // Ķīšupe Station
    {Coordinate{6.68628, 50.9381}, CountryId{"DE"}}, // Q14506318
    {Coordinate{10.9306, 44.6539}, CountryId{"IT"}}, // Modena railway station
    {Coordinate{9.04722, 51.5247}, CountryId{"DE"}}, // Scherfede station
    {Coordinate{14.435, 50.0875}, CountryId{"CZ"}}, // Praha Masarykovo nádraží
    {Coordinate{6.79722, 50.9981}, CountryId{"DE"}}, // Pulheim station
    {Coordinate{16.4069, 48.1753}, CountryId{"AT"}}, // Wien Geiselbergstraße railway station
    {Coordinate{7.21945, 50.6395}, CountryId{"DE"}}, // Bad Honnef (Rhein) station
    {Coordinate{10.6295, 47.8756}, CountryId{"DE"}}, // Q14544357
    {Coordinate{7.21023, 50.6581}, CountryId{"DE"}}, // Rhöndorf station
    {Coordinate{8.91449, 49.1362}, CountryId{"DE"}}, // Eppingen station
    {Coordinate{8.86361, 52.1719}, CountryId{"DE"}}, // Vlotho station
    {Coordinate{12.6747, 48.2215}, CountryId{"DE"}}, // Altötting station
    {Coordinate{11.1079, 47.9503}, CountryId{"DE"}}, // Bahnhof Dießen
    {Coordinate{9.82944, 52.9831}, CountryId{"DE"}}, // Soltau (Han) station
    {Coordinate{12.0838, 52.9032}, CountryId{"DE"}}, // Glöwen station
    {Coordinate{10.3321, 47.7313}, CountryId{"DE"}}, // Q14550974
    {Coordinate{11.8524, 53.0714}, CountryId{"DE"}}, // Perleberg station
    {Coordinate{10.988, 48.263}, CountryId{"DE"}}, // Mering station
    {Coordinate{8.76033, 47.4652}, CountryId{"CH"}}, // Sennhof-Kyburg railway station
    {Coordinate{24.5058, 56.8396}, CountryId{"LV"}}, // Ikšķile
    {Coordinate{14.5606, 50.1067}, CountryId{"CZ"}}, // Rajská zahrada
    {Coordinate{8.41639, 45.3298}, CountryId{"IT"}}, // Vercelli railway station
    {Coordinate{18.9588, 47.5059}, CountryId{"HU"}}, // Virágvölgy
    {Coordinate{37.5017, 47.5972}, CountryId{"UA"}}, // Q14629819
    {Coordinate{37.6325, 55.7928}, CountryId{"RU"}}, // Rizhsky railway station
    {Coordinate{7.59972, 50.3169}, CountryId{"DE"}}, // Niederlahnstein station
    {Coordinate{14.0444, 50.6597}, CountryId{"CZ"}}, // Ústí nad Labem hlavní nádraží
    {Coordinate{8.05689, 50.0137}, CountryId{"DE"}}, // Hattenheim station
    {Coordinate{10.8665, 53.9589}, CountryId{"DE"}}, // Lübeck-Travemünde Hafen station
    {Coordinate{13.4809, 54.3563}, CountryId{"DE"}}, // Putbus railway station
    {Coordinate{12.2373, 51.8843}, CountryId{"DE"}}, // Roßlau (Elbe) station
    {Coordinate{8.54825, 49.0876}, CountryId{"DE"}}, // Untergrombach station
    {Coordinate{8.26764, 50.4864}, CountryId{"DE"}}, // Weilburg station
    {Coordinate{7.61046, 49.5841}, CountryId{"DE"}}, // Bahnhof Wolfstein
    {Coordinate{16.3996, 48.1879}, CountryId{"AT"}}, // Q14906766
    {Coordinate{11.4158, 47.1935}, CountryId{"AT"}}, // Patsch railway station
    {Coordinate{70.7549, 23.1032}, CountryId{"IN"}}, // Maliya Miyana railway station
    {Coordinate{4.6062, 45.5243}, CountryId{"FR"}}, // Q14918105
    {Coordinate{37.515, 55.7444}, CountryId{"RU"}}, // Fili railway station
    {Coordinate{37.3973, 55.7237}, CountryId{"RU"}}, // Setun' railway station
    {Coordinate{37.5539, 55.8053}, CountryId{"RU"}}, // Grazhdanskaya
    {Coordinate{37.5533, 55.8973}, CountryId{"RU"}}, // Lianozovo
    {Coordinate{37.2467, 55.8233}, CountryId{"RU"}}, // Q14927503
    {Coordinate{35.3789, 55.5131}, CountryId{"RU"}}, // Q14927504
    {Coordinate{42.0228, 58.4252}, CountryId{"RU"}}, // Q14927507
    {Coordinate{45.0122, 53.2042}, CountryId{"RU"}}, // Q14927508
    {Coordinate{27.4422, 53.9375}, CountryId{"BY"}}, // Lyebyadziny
    {Coordinate{40.1906, 48.1555}, CountryId{"RU"}}, // Lykha
    {Coordinate{31.0615, 59.7556}, CountryId{"RU"}}, // Mga
    {Coordinate{38.1362, 56.1088}, CountryId{"RU"}}, // Krasnoarmeysk
    {Coordinate{38.0309, 54.987}, CountryId{"RU"}}, // Q14927517
    {Coordinate{49.3302, 55.9423}, CountryId{"RU"}}, // Q14927518
    {Coordinate{59.9778, 56.8889}, CountryId{"RU"}}, // Q14927533
    {Coordinate{30.9341, 59.976}, CountryId{"RU"}}, // Q14927534
    {Coordinate{27.0659, 54.2537}, CountryId{"BY"}}, // Usha
    {Coordinate{48.0483, 56.5125}, CountryId{"RU"}}, // Q14927539
    {Coordinate{29.1541, 60.552}, CountryId{"RU"}}, // Leypyasuo
    {Coordinate{40.035, 57.7686}, CountryId{"RU"}}, // Q14927543
    {Coordinate{28.7136, 60.5825}, CountryId{"RU"}}, // Q14927545
    {Coordinate{35.7175, 56.9533}, CountryId{"RU"}}, // Q14927549
    {Coordinate{38.9181, 55.0264}, CountryId{"RU"}}, // Q14927574
    {Coordinate{43.1415, 44.2134}, CountryId{"RU"}}, // Q14927597
    {Coordinate{}, CountryId{"RU"}}, // Q14927598
    {Coordinate{38.666, 47.6978}, CountryId{"RU"}}, // Q14927599
    {Coordinate{42.992, 50.327}, CountryId{"RU"}}, // Q14927601
    {Coordinate{109.342, 55.6328}, CountryId{"RU"}}, // Q14927612
    {Coordinate{29.5424, 55.8469}, CountryId{"RU"}}, // Q14927614
    {Coordinate{56.9983, 57.4234}, CountryId{"RU"}}, // Kungur Railway Station
    {Coordinate{38.8093, 55.4104}, CountryId{"RU"}}, // Q14927616
    {Coordinate{35.7871, 55.9942}, CountryId{"RU"}}, // Q14927617
    {Coordinate{37.2661, 55.6099}, CountryId{"RU"}}, // Aeroport
    {Coordinate{39.2114, 56.7063}, CountryId{"RU"}}, // Q14927621
    {Coordinate{45.4122, 53.1141}, CountryId{"RU"}}, // Q14927622
    {Coordinate{37.4616, 54.9949}, CountryId{"RU"}}, // Q14927623
    {Coordinate{75.3408, 43.5347}, CountryId{"KZ"}}, // Q14927624
    {Coordinate{75.4881, 43.535}, CountryId{"KZ"}}, // Q14927625
    {Coordinate{78.8757, 43.7499}, CountryId{"KZ"}}, // Ortakudyk
    {Coordinate{79.8153, 43.9607}, CountryId{"KZ"}}, // Aydarly
    {Coordinate{55.9204, 53.4658}, CountryId{"RU"}}, // Q14927628
    {Coordinate{55.9256, 53.5367}, CountryId{"RU"}}, // Q14927629
    {Coordinate{55.9137, 53.5556}, CountryId{"RU"}}, // Q14927630
    {Coordinate{55.9196, 53.608}, CountryId{"RU"}}, // Q14927631
    {Coordinate{55.91, 53.5669}, CountryId{"RU"}}, // Q14927632
    {Coordinate{38.4278, 48.3411}, CountryId{"UA"}}, // Q14927633
    {Coordinate{37.4583, 56.1258}, CountryId{"RU"}}, // Bely Rast
    {Coordinate{126.75, 52.6311}, CountryId{"RU"}}, // Q14927635
    {Coordinate{45.1906, 54.1956}, CountryId{"RU"}}, // Saransk railway station
    {Coordinate{39.2425, 56.8027}, CountryId{"RU"}}, // Q14927637
    {Coordinate{32.3844, 55.5944}, CountryId{"RU"}}, // Q14927638
    {Coordinate{38.3264, 55.1019}, CountryId{"RU"}}, // Q14927639
    {Coordinate{35.8914, 56.8358}, CountryId{"RU"}}, // Tver railway station
    {Coordinate{36.7578, 54.515}, CountryId{"RU"}}, // Ferzikovo railway station
    {Coordinate{52.1845, 56.9893}, CountryId{"RU"}}, // Q14927642
    {Coordinate{52.3872, 56.9833}, CountryId{"RU"}}, // Q14927643
    {Coordinate{52.8693, 56.9673}, CountryId{"RU"}}, // Q14927644
    {Coordinate{42.2661, 54.2642}, CountryId{"RU"}}, // Q14927645
    {Coordinate{25.3453, 52.7092}, CountryId{"BY"}}, // Ivatsevichy
    {Coordinate{25.2219, 52.6515}, CountryId{"BY"}}, // Kosava-Palyeskaye
    {Coordinate{25.0926, 52.6062}, CountryId{"BY"}}, // Bronnaya Hara
    {Coordinate{53.7375, 63.5572}, CountryId{"RU"}}, // Uhta
    {Coordinate{50.0752, 62.3599}, CountryId{"RU"}}, // Q14927650
    {Coordinate{55.0747, 51.7763}, CountryId{"RU"}}, // Orenburg railway station
    {Coordinate{36.1964, 52.9372}, CountryId{"RU"}}, // Q14927652
    {Coordinate{35.18, 53.1403}, CountryId{"RU"}}, // Q14927653
    {Coordinate{40.1167, 47.4042}, CountryId{"RU"}}, // Novocherkassk railway station
    {Coordinate{34.9817, 53.1344}, CountryId{"RU"}}, // Q14927655
    {Coordinate{34.3081, 53.3142}, CountryId{"RU"}}, // Q14927656
    {Coordinate{31.8484, 53.7258}, CountryId{"BY"}}, // Krychaw II
    {Coordinate{31.7089, 53.7403}, CountryId{"BY"}}, // Krychaw I
    {Coordinate{59.5955, 57.5428}, CountryId{"RU"}}, // Q14927659
    {Coordinate{34.8325, 53.1769}, CountryId{"RU"}}, // Q14927660
    {Coordinate{34.2353, 53.1117}, CountryId{"RU"}}, // Q14927661
    {Coordinate{33.4633, 52.9139}, CountryId{"RU"}}, // Q14927662
    {Coordinate{33.1347, 52.8792}, CountryId{"RU"}}, // Q14927663
    {Coordinate{32.6783, 52.8428}, CountryId{"RU"}}, // Q14927664
    {Coordinate{32.2333, 52.735}, CountryId{"RU"}}, // Q14927665
    {Coordinate{31.9469, 52.5228}, CountryId{"RU"}}, // Q14927666
    {Coordinate{31.165, 52.3881}, CountryId{"BY"}}, // Laryshchava
    {Coordinate{30.7536, 52.3986}, CountryId{"BY"}}, // Prybar
    {Coordinate{30.3928, 52.3486}, CountryId{"BY"}}, // Rechytsa
    {Coordinate{30.2031, 52.3361}, CountryId{"BY"}}, // Dzyemyakhi
    {Coordinate{29.8311, 52.2539}, CountryId{"BY"}}, // Vasilyevichy
    {Coordinate{29.6728, 52.2217}, CountryId{"BY"}}, // Nakhaw
    {Coordinate{29.4992, 52.1622}, CountryId{"BY"}}, // Halyavitsy
    {Coordinate{57.2351, 65.1582}, CountryId{"RU"}}, // Q14927688
    {Coordinate{41.5459, 58.4671}, CountryId{"RU"}}, // Q14927689
    {Coordinate{41.1154, 57.245}, CountryId{"RU"}}, // Q14927690
    {Coordinate{47.5076, 58.2823}, CountryId{"RU"}}, // Svecha station
    {Coordinate{43.3911, 58.3394}, CountryId{"RU"}}, // Q14927693
    {Coordinate{41.6771, 57.9251}, CountryId{"RU"}}, // Q14927694
    {Coordinate{7.6681, 45.0004}, CountryId{"IT"}}, // Moncalieri Sangone railway station
    {Coordinate{7.642, 44.9914}, CountryId{"IT"}}, // Nichelino railway station
    {Coordinate{7.599, 44.9611}, CountryId{"IT"}}, // Candiolo railway station
    {Coordinate{11.3996, 48.1377}, CountryId{"DE"}}, // Munich Freiham station
    {Coordinate{12.5644, 55.6728}, CountryId{"DK"}}, // Copenhagen Central Station
    {Coordinate{27.4679, 57.84}, CountryId{"EE"}}, // Q14955583
    {Coordinate{-0.1609, 51.1565}, CountryId{"GB"}}, // Gatwick Airport railway station
    {Coordinate{10.7303, 59.9114}, CountryId{"NO"}}, // Oslo West Station
    {Coordinate{11.4116, 63.963}, CountryId{"NO"}}, // Vist Station
    {Coordinate{9.26733, 59.5589}, CountryId{"NO"}}, // Notodden New Station
    {Coordinate{6.71583, 60.5208}, CountryId{"NO"}}, // Granvin Station
    {Coordinate{10.2431, 50.0461}, CountryId{"DE"}}, // Schweinfurt Stadt station
    {Coordinate{12.6334, 42.2422}, CountryId{"IT"}}, // Poggio Mirteto railway station
    {Coordinate{12.5961, 42.0639}, CountryId{"IT"}}, // Monterotondo-Mentana railway station
    {Coordinate{9.43698, 45.0632}, CountryId{"IT"}}, // Castel San Giovanni railway station
    {Coordinate{11.842, 44.6165}, CountryId{"IT"}}, // Argenta railway station
    {Coordinate{12.4609, 44.1502}, CountryId{"IT"}}, // Stazione di Bellaria
    {Coordinate{12.0401, 44.5116}, CountryId{"IT"}}, // Q15070219
    {Coordinate{12.0983, 44.4628}, CountryId{"IT"}}, // Q15070225
    {Coordinate{7.7555, 46.3674}, CountryId{"CH"}}, // Goppenstein railway station
    {Coordinate{8.78478, 47.3671}, CountryId{"CH"}}, // Pfäffikon ZH railway station
    {Coordinate{8.75027, 47.3851}, CountryId{"CH"}}, // Fehraltorf railway station
    {Coordinate{8.70475, 47.4517}, CountryId{"CH"}}, // Kemptthal railway station
    {Coordinate{8.93236, 47.354}, CountryId{"CH"}}, // Steg railway station
    {Coordinate{8.92318, 47.3334}, CountryId{"CH"}}, // Fischenthal railway station
    {Coordinate{8.62656, 47.4383}, CountryId{"CH"}}, // Bassersdorf railway station
    {Coordinate{8.91566, 47.3134}, CountryId{"CH"}}, // Gibswil railway station
    {Coordinate{8.8526, 47.2685}, CountryId{"CH"}}, // Tann-Dürnten railway station
    {Coordinate{8.84238, 47.2237}, CountryId{"CH"}}, // Blumenau railway station
    {Coordinate{8.85488, 47.3938}, CountryId{"CH"}}, // Saland railway station
    {Coordinate{8.84359, 47.4373}, CountryId{"CH"}}, // Turbenthal railway station
    {Coordinate{8.81892, 47.4416}, CountryId{"CH"}}, // Rämismühle-Zell railway station
    {Coordinate{8.81892, 47.4416}, CountryId{"CH"}}, // Winterthur Hegi station
    {Coordinate{8.6132, 47.2815}, CountryId{"CH"}}, // Herrliberg-Feldmeilen railway station
    {Coordinate{8.59892, 47.2974}, CountryId{"CH"}}, // Winkel am Zürichsee railway station
    {Coordinate{8.59161, 47.3053}, CountryId{"CH"}}, // Erlenbach ZH railway station
    {Coordinate{8.80066, 47.2136}, CountryId{"CH"}}, // Hurden railway station
    {Coordinate{8.75938, 47.2042}, CountryId{"CH"}}, // Freienbach SOB railway station
    {Coordinate{8.7562, 47.2073}, CountryId{"CH"}}, // Freienbach SBB railway station
    {Coordinate{8.82279, 47.1943}, CountryId{"CH"}}, // Altendorf railway station
    {Coordinate{8.64629, 47.516}, CountryId{"CH"}}, // Pfungen-Neftenbach railway station
    {Coordinate{8.50364, 47.4874}, CountryId{"CH"}}, // Niederglatt railway station
    {Coordinate{8.5106, 47.4702}, CountryId{"CH"}}, // Oberglatt Station
    {Coordinate{8.37371, 47.5653}, CountryId{"CH"}}, // Rümikon AG railway station
    {Coordinate{8.3528, 47.5684}, CountryId{"CH"}}, // Mellikon railway station
    {Coordinate{8.32704, 47.5695}, CountryId{"CH"}}, // Rekingen AG railway station
    {Coordinate{8.27793, 47.6005}, CountryId{"CH"}}, // Rietheim railway station
    {Coordinate{8.23999, 47.6093}, CountryId{"CH"}}, // Koblenz Dorf railway station
    {Coordinate{8.62586, 47.6829}, CountryId{"CH"}}, // Neuhausen railway station
    {Coordinate{13.6618, 51.0132}, CountryId{"DE"}}, // Freital-Potschappel station
    {Coordinate{}, CountryId{"DE"}}, // Anrath station
    {Coordinate{7.64556, 50.6872}, CountryId{"DE"}}, // Altenkirchen (Westerw) station
    {Coordinate{7.96625, 49.2053}, CountryId{"DE"}}, // Annweiler am Trifels station
    {Coordinate{8.0028, 49.1031}, CountryId{"DE"}}, // Q15107129
    {Coordinate{7.69807, 47.9197}, CountryId{"DE"}}, // Bad Krozingen station
    {Coordinate{13.4785, 52.5012}, CountryId{"DE"}}, // Berlin-Rummelsburg railway station
    {Coordinate{11.4085, 47.7235}, CountryId{"DE"}}, // Q15107135
    {Coordinate{13.22, 47.4173}, CountryId{"AT"}}, // Bischofshofen railway station
    {Coordinate{12.9521, 50.8612}, CountryId{"DE"}}, // Chemnitz-Hilbersdorf station
    {Coordinate{7.4283, 49.2454}, CountryId{"DE"}}, // Q15107147
    {Coordinate{10.138, 50.1312}, CountryId{"DE"}}, // Ebenhausen (Unterfr) station
    {Coordinate{7.89941, 49.4903}, CountryId{"DE"}}, // Enkenbach station
    {Coordinate{6.82356, 50.8104}, CountryId{"DE"}}, // Erftstadt station
    {Coordinate{8.09867, 47.8716}, CountryId{"DE"}}, // Feldberg-Bärental Station
    {Coordinate{7.77304, 49.2031}, CountryId{"DE"}}, // Hinterweidenthal Ost station
    {Coordinate{8.89617, 49.4428}, CountryId{"DE"}}, // Q15107186
    {Coordinate{7.89667, 49.4428}, CountryId{"DE"}}, // Hochspeyer station
    {Coordinate{13.2714, 52.6725}, CountryId{"DE"}}, // Hohen Neuendorf West station
    {Coordinate{14.9024, 51.3039}, CountryId{"DE"}}, // Horka Pbf station
    {Coordinate{9.7628, 50.6733}, CountryId{"DE"}}, // Q15107193
    {Coordinate{9.60415, 50.2326}, CountryId{"DE"}}, // Q15107198
    {Coordinate{8.1977, 49.0792}, CountryId{"DE"}}, // Bahnhof Kandel
    {Coordinate{7.701, 49.5001}, CountryId{"DE"}}, // Q15107201
    {Coordinate{10.098, 54.3112}, CountryId{"DE"}}, // Kiel-Hassee CITTI-PARK station
    {Coordinate{11.9884, 51.7522}, CountryId{"DE"}}, // Köthen railway station
    {Coordinate{8.07436, 49.3733}, CountryId{"DE"}}, // Lambrecht (Pfalz) station
    {Coordinate{11.8527, 48.4381}, CountryId{"DE"}}, // Langenbach station
    {Coordinate{8.5037, 49.5016}, CountryId{"DE"}}, // Mannheim-Käfertal station
    {Coordinate{8.81304, 49.3208}, CountryId{"DE"}}, // Meckesheim station
    {Coordinate{9.14667, 49.3522}, CountryId{"DE"}}, // Mosbach (Baden) station
    {Coordinate{11.193, 47.6823}, CountryId{"DE"}}, // Murnau station
    {Coordinate{9.02861, 50.6167}, CountryId{"DE"}}, // Mücke (Hesse) station
    {Coordinate{7.90111, 50.6247}, CountryId{"DE"}}, // Nistertal-Bad Marienberg station
    {Coordinate{7.42624, 51.8922}, CountryId{"DE"}}, // Nottuln-Appelhülsen station
    {Coordinate{7.65284, 49.5381}, CountryId{"DE"}}, // Q15107260
    {Coordinate{7.4442, 49.5421}, CountryId{"DE"}}, // Q15107280
    {Coordinate{7.4404, 49.4852}, CountryId{"DE"}}, // Q15107282
    {Coordinate{7.24275, 51.2153}, CountryId{"DE"}}, // Remscheid-Lüttringhausen station
    {Coordinate{11.0971, 47.9825}, CountryId{"DE"}}, // Q15107284
    {Coordinate{8.1414, 49.1379}, CountryId{"DE"}}, // Rohrbach Station
    {Coordinate{8.829, 49.9732}, CountryId{"DE"}}, // Rödermark-Ober-Roden station
    {Coordinate{11.09, 48.0529}, CountryId{"DE"}}, // Bahnhof Schondorf (Bay)
    {Coordinate{7.68757, 49.3591}, CountryId{"DE"}}, // Schopp station
    {Coordinate{7.44845, 49.5191}, CountryId{"DE"}}, // Q15107299
    {Coordinate{8.2732, 49.0455}, CountryId{"DE"}}, // Wörth (Rhein) station
    {Coordinate{8.66468, 47.7173}, CountryId{"CH"}}, // Herblingen railway station
    {Coordinate{8.70389, 47.7453}, CountryId{"CH"}}, // Thayngen railway station
    {Coordinate{8.53276, 47.4543}, CountryId{"CH"}}, // Rümlang railway station
    {Coordinate{8.48841, 47.4786}, CountryId{"CH"}}, // Niederhasli railway station
    {Coordinate{8.44684, 47.49}, CountryId{"CH"}}, // Steinmaur railway station
    {Coordinate{16.4654, 48.146}, CountryId{"AT"}}, // Wien Kaiserebersdorf railway station
    {Coordinate{6.975, 50.9408}, CountryId{"DE"}}, // Köln Messe/Deutz station
    {Coordinate{18.3275, 47.6647}, CountryId{"HU"}}, // Tata railway station
    {Coordinate{18.1136, 47.7494}, CountryId{"HU"}}, // Komárom railway station
    {Coordinate{18.0039, 47.717}, CountryId{"HU"}}, // Ács railway station
    {Coordinate{12.3746, 51.3403}, CountryId{"DE"}}, // Leipzig Markt station
    {Coordinate{17.1914, 47.1825}, CountryId{"HU"}}, // Boba railway station
    {Coordinate{7.76528, 45.9844}, CountryId{"CH"}}, // Rotenboden railway station
    {Coordinate{80.2829, 13.0835}, CountryId{"IN"}}, // Chennai Fort railway station
    {Coordinate{91.2785, 23.7924}, CountryId{"IN"}}, // Agartala railway station
    {Coordinate{74.7219, 19.0755}, CountryId{"IN"}}, // Ahmednagar railway station
    {Coordinate{7.4834, 44.928}, CountryId{"IT"}}, // Airasca railway station
    {Coordinate{77.0055, 20.7231}, CountryId{"IN"}}, // Akola railway station
    {Coordinate{73.7642, 18.6481}, CountryId{"IN"}}, // Akurdi railway station
    {Coordinate{78.0746, 27.8896}, CountryId{"IN"}}, // Aligarh railway station
    {Coordinate{89.534, 26.5233}, CountryId{"IN"}}, // Alipurduar Junction railway station
    {Coordinate{87.1812, 23.579}, CountryId{"IN"}}, // Andal Junction railway station
    {Coordinate{85.1, 20.8594}, CountryId{"IN"}}, // Angul Railway Station
    {Coordinate{80.2308, 13.3043}, CountryId{"IN"}}, // Anuppambattu railway station
    {Coordinate{73.1526, 18.8635}, CountryId{"IN"}}, // Apta railway station
    {Coordinate{79.668, 13.0815}, CountryId{"IN"}}, // Arakkonam Junction
    {Coordinate{7.30176, 43.7347}, CountryId{"FR"}}, // Gare de l'Ariane - La Trinité
    {Coordinate{7.19454, 43.6624}, CountryId{"FR"}}, // Gare de Saint-Laurent-du-Var
    {Coordinate{13.5382, 52.4525}, CountryId{"DE"}}, // Oberspree station
    {Coordinate{7.75917, 53.2209}, CountryId{"DE"}}, // Augustfehn railway station
    {Coordinate{7.84282, 46.3125}, CountryId{"CH"}}, // Ausserberg railway station
    {Coordinate{77.7323, 20.8568}, CountryId{"IN"}}, // Badnera railway station
    {Coordinate{88.7579, 25.233}, CountryId{"IN"}}, // Balurghat railway station
    {Coordinate{89.5862, 26.0706}, CountryId{"IN"}}, // Bamanhat railway station
    {Coordinate{88.8329, 23.0305}, CountryId{"IN"}}, // Bangaon Junction railway station
    {Coordinate{84.903, 22.6648}, CountryId{"IN"}}, // Bano railway station
    {Coordinate{86.9286, 23.7069}, CountryId{"IN"}}, // Barachak railway station
    {Coordinate{87.8703, 23.2497}, CountryId{"IN"}}, // Barddhaman Junction railway station
    {Coordinate{87.9226, 25.6509}, CountryId{"IN"}}, // Barsoi Junction railway station
    {Coordinate{13.6734, 52.5183}, CountryId{"DE"}}, // Hoppegarten (Mark) station
    {Coordinate{13.7625, 52.5265}, CountryId{"DE"}}, // Fredersdorf station
    {Coordinate{73.709, 18.7012}, CountryId{"IN"}}, // Begdewadi railway station
    {Coordinate{86.447, 23.6422}, CountryId{"IN"}}, // Bhojudih Junction railway station
    {Coordinate{75.7887, 21.0473}, CountryId{"IN"}}, // Bhusawal railway station
    {Coordinate{77.6678, 27.5014}, CountryId{"IN"}}, // Bhuteshwar railway station
    {Coordinate{7.13443, 43.6298}, CountryId{"FR"}}, // Gare de Villeneuve-Loubet-plage
    {Coordinate{87.3013, 23.0651}, CountryId{"IN"}}, // Bishnupur Junction railway station
    {Coordinate{5.09142, 43.6999}, CountryId{"FR"}}, // Lamanon
    {Coordinate{7.33956, 51.3238}, CountryId{"DE"}}, // Gevelsberg Hauptbahnhof
    {Coordinate{86.085, 23.6566}, CountryId{"IN"}}, // Bokaro Steel City Junction railway station
    {Coordinate{84.9251, 22.2355}, CountryId{"IN"}}, // Bondamunda railway station
    {Coordinate{13.8206, 52.8728}, CountryId{"DE"}}, // Britz
    {Coordinate{8.33269, 44.3362}, CountryId{"IT"}}, // Altare
    {Coordinate{8.19189, 44.3907}, CountryId{"IT"}}, // Cengio
    {Coordinate{85.6278, 22.679}, CountryId{"IN"}}, // Chakradharpur railway station
    {Coordinate{83.2677, 25.2611}, CountryId{"IN"}}, // Chandauli Majhwar railway station
    {Coordinate{86.1198, 23.7557}, CountryId{"IN"}}, // Chandrapura railway station
    {Coordinate{74.2377, 16.7026}, CountryId{"IN"}}, // Chattrapati Shahu Maharaj Terminus
    {Coordinate{79.9815, 12.6929}, CountryId{"IN"}}, // Chengalpattu Junction railway station
    {Coordinate{76.6083, 9.3195}, CountryId{"IN"}}, // Chengannur railway station
    {Coordinate{82.8747, 25.1034}, CountryId{"IN"}}, // Chunar railway station
    {Coordinate{13.0334, 52.3237}, CountryId{"DE"}}, // Dallgow-Döberitz railway station
    {Coordinate{86.9085, 23.651}, CountryId{"IN"}}, // Damodar railway station
    {Coordinate{88.2908, 22.6783}, CountryId{"IN"}}, // Dankuni Junction railway station
    {Coordinate{73.8328, 18.58}, CountryId{"IN"}}, // Dapodi railway station
    {Coordinate{75.9196, 14.468}, CountryId{"IN"}}, // Davangere railway station
    {Coordinate{78.0336, 30.314}, CountryId{"IN"}}, // Dehradun railway station
    {Coordinate{84.1854, 24.9149}, CountryId{"IN"}}, // Dehri-on-Sone railway station
    {Coordinate{73.7342, 18.6802}, CountryId{"IN"}}, // Dehu Road Railway Station
    {Coordinate{71.4791, 22.9872}, CountryId{"IN"}}, // Dharangadhra railway station
    {Coordinate{78.1547, 12.1266}, CountryId{"IN"}}, // Dharmapuri Junction railway station
    {Coordinate{89.978, 26.0231}, CountryId{"IN"}}, // Dhubri railway station
    {Coordinate{94.9353, 27.4636}, CountryId{"IN"}}, // Dibrugarh railway station
    {Coordinate{87.5082, 21.6229}, CountryId{"IN"}}, // Digha railway station
    {Coordinate{93.7278, 25.9057}, CountryId{"IN"}}, // Dimapur railway station
    {Coordinate{76.3363, 10.2854}, CountryId{"IN"}}, // Divine Nagar railway station
    {Coordinate{13.5642, 51.6206}, CountryId{"DE"}}, // Doberlug-Kirchhain railway station
    {Coordinate{9.19753, 47.2267}, CountryId{"CH"}}, // Nesslau-Neu St. Johann Station
    {Coordinate{88.3933, 22.6209}, CountryId{"IN"}}, // Dum Dum Junction railway station
    {Coordinate{87.3174, 23.4953}, CountryId{"IN"}}, // Durgapur railway station
    {Coordinate{7.88116, 46.3065}, CountryId{"CH"}}, // Eggerberg railway station
    {Coordinate{13.0001, 52.3251}, CountryId{"DE"}}, // Elstal railway station
    {Coordinate{9.07723, 47.033}, CountryId{"CH"}}, // Ennenda railway station
    {Coordinate{78.654, 27.5719}, CountryId{"IN"}}, // Etah railway station
    {Coordinate{79.0215, 26.786}, CountryId{"IN"}}, // Etawah railway station
    {Coordinate{77.3094, 28.3762}, CountryId{"IN"}}, // Faridabad New Town railway station
    {Coordinate{77.3074, 28.4115}, CountryId{"IN"}}, // Faridabad railway station
    {Coordinate{80.8019, 25.9175}, CountryId{"IN"}}, // Fatehpur railway station
    {Coordinate{78.3867, 27.1474}, CountryId{"IN"}}, // Firozabad railway station
    {Coordinate{24.2987, 56.921}, CountryId{"LV"}}, // Acone railway station
    {Coordinate{25.5775, 56.6336}, CountryId{"LV"}}, // Alotene
    {Coordinate{26.4075, 56.5303}, CountryId{"LV"}}, // Q15218596
    {Coordinate{25.2442, 56.5083}, CountryId{"LV"}}, // Daudzeva
    {Coordinate{25.0436, 56.6583}, CountryId{"LV"}}, // Dendrārijs
    {Coordinate{26.6984, 57.1028}, CountryId{"LV"}}, // Q15218900
    {Coordinate{23.9492, 56.6506}, CountryId{"LV"}}, // Garoza
    {Coordinate{24.2347, 56.6286}, CountryId{"LV"}}, // Iecava
    {Coordinate{25.9763, 56.6871}, CountryId{"LV"}}, // Q15219021
    {Coordinate{23.7567, 56.6508}, CountryId{"LV"}}, // Jelgava II
    {Coordinate{26.0187, 56.7339}, CountryId{"LV"}}, // Q15219083
    {Coordinate{22.7426, 57.1018}, CountryId{"LV"}}, // Līgciems Station
    {Coordinate{22.4194, 57.178}, CountryId{"LV"}}, // Līči Station
    {Coordinate{25.1008, 56.5375}, CountryId{"LV"}}, // Menta
    {Coordinate{24.3964, 56.5914}, CountryId{"LV"}}, // Q15219390
    {Coordinate{21.9314, 57.3089}, CountryId{"LV"}}, // Puze Station
    {Coordinate{24.2292, 56.9208}, CountryId{"LV"}}, // Q15219689
    {Coordinate{22.4846, 57.1319}, CountryId{"LV"}}, // Sabile Station
    {Coordinate{25.3703, 56.5106}, CountryId{"LV"}}, // Sece
    {Coordinate{23.2911, 56.8442}, CountryId{"LV"}}, // Slampe Station
    {Coordinate{25.8254, 56.6616}, CountryId{"LV"}}, // Q15219800
    {Coordinate{24.9281, 56.5625}, CountryId{"LV"}}, // Q15219879
    {Coordinate{26.7689, 56.5608}, CountryId{"LV"}}, // Q15219970
    {Coordinate{24.5367, 56.5903}, CountryId{"LV"}}, // Q15219998
    {Coordinate{26.9383, 56.5608}, CountryId{"LV"}}, // Q15220042
    {Coordinate{28.1161, 56.3917}, CountryId{"LV"}}, // Q15220101
    {Coordinate{24.0856, 56.6414}, CountryId{"LV"}}, // Q15220138
    {Coordinate{70.1478, 23.0691}, CountryId{"IN"}}, // Gandhidham Junction railway station
    {Coordinate{78.002, 22.1264}, CountryId{"IN"}}, // Ghoradongri railway station
    {Coordinate{73.697, 18.7206}, CountryId{"IN"}}, // Ghorawadi railway station
    {Coordinate{89.8307, 26.1084}, CountryId{"IN"}}, // Golokganj railway station
    {Coordinate{7.78222, 45.9833}, CountryId{"CH"}}, // Gornergrat railway station
    {Coordinate{80.2517, 13.0203}, CountryId{"IN"}}, // Greenways Road railway station
    {Coordinate{80.0571, 12.8449}, CountryId{"IN"}}, // Guduvancheri railway station
    {Coordinate{85.2155, 25.7029}, CountryId{"IN"}}, // Hajipur Junction railway station
    {Coordinate{11.4067, 52.2847}, CountryId{"DE"}}, // Haldensleben station
    {Coordinate{88.0659, 22.0453}, CountryId{"IN"}}, // Haldia railway station
    {Coordinate{88.7828, 26.336}, CountryId{"IN"}}, // Haldibari railway station
    {Coordinate{73.0793, 18.7839}, CountryId{"IN"}}, // Hamrapur railway station
    {Coordinate{9.49806, 53.4503}, CountryId{"DE"}}, // Harsefeld
    {Coordinate{88.9134, 22.5712}, CountryId{"IN"}}, // Hasnabad railway station
    {Coordinate{9.38861, 52.3792}, CountryId{"DE"}}, // Haste (Han) station
    {Coordinate{85.9872, 25.3658}, CountryId{"IN"}}, // Hathidah Junction railway station
    {Coordinate{78.1371, 27.6248}, CountryId{"IN"}}, // Hathras Junction railway station
    {Coordinate{8.97224, 53.4986}, CountryId{"DE"}}, // Heinschenwalde station
    {Coordinate{8.66833, 52.1581}, CountryId{"DE"}}, // Hiddenhausen-Schweicheln station
    {Coordinate{7.76459, 46.3224}, CountryId{"CH"}}, // Hohtenn railway station
    {Coordinate{88.3759, 22.9048}, CountryId{"IN"}}, // Hooghly railway station
    {Coordinate{8.58934, 47.2585}, CountryId{"CH"}}, // Horgen Oberdorf railway station
    {Coordinate{77.8228, 12.7176}, CountryId{"IN"}}, // Hosur railway station
    {Coordinate{73.5624, 19.6941}, CountryId{"IN"}}, // Igatpuri railway station
    {Coordinate{76.2809, 10.3395}, CountryId{"IN"}}, // Irinjalakuda railway station
    {Coordinate{79.1192, 21.1578}, CountryId{"IN"}}, // Itwari railway station
    {Coordinate{76.5732, 20.813}, CountryId{"IN"}}, // Jalamb railway station
    {Coordinate{75.5629, 21.0181}, CountryId{"IN"}}, // Jalgaon railway station
    {Coordinate{88.7237, 26.5189}, CountryId{"IN"}}, // Jalpaiguri railway station
    {Coordinate{70.0539, 22.494}, CountryId{"IN"}}, // Jamnagar railway station
    {Coordinate{78.553, 25.4436}, CountryId{"IN"}}, // Jhansi Junction railway station
    {Coordinate{73.0862, 18.8196}, CountryId{"IN"}}, // Jite railway station
    {Coordinate{78.5778, 12.5609}, CountryId{"IN"}}, // Jolarpettai Junction
    {Coordinate{73.1148, 19.0356}, CountryId{"IN"}}, // Kalamboli railway station
    {Coordinate{72.9191, 19.3365}, CountryId{"IN"}}, // Kaman Road railway station
    {Coordinate{7.66061, 51.585}, CountryId{"DE"}}, // Kamen station
    {Coordinate{73.5524, 18.7669}, CountryId{"IN"}}, // Kamshet railway station
    {Coordinate{79.7051, 12.8484}, CountryId{"IN"}}, // Kanchipuram railway station
    {Coordinate{7.67148, 46.4952}, CountryId{"CH"}}, // Kandersteg railway station
    {Coordinate{73.594, 18.7624}, CountryId{"IN"}}, // Kanhe railway station
    {Coordinate{88.4052, 22.8662}, CountryId{"IN"}}, // Kankinara railway station
    {Coordinate{73.8207, 18.6076}, CountryId{"IN"}}, // Kasarwadi railway station
    {Coordinate{73.0794, 18.6406}, CountryId{"IN"}}, // Kasu railway station
    {Coordinate{80.4005, 23.8334}, CountryId{"IN"}}, // Katni Junction railway station
    {Coordinate{80.0261, 12.8057}, CountryId{"IN"}}, // Kattangulathur railway station
    {Coordinate{88.1236, 23.6398}, CountryId{"IN"}}, // Katwa Junction railway station
    {Coordinate{78.5715, 12.6265}, CountryId{"IN"}}, // Kettandapatti railway station
    {Coordinate{13.62, 53.925}, CountryId{"DE"}}, // Klein Bünzow railway station
    {Coordinate{75.8805, 25.2236}, CountryId{"IN"}}, // Kota Junction railway station
    {Coordinate{7.21349, 45.7066}, CountryId{"IT"}}, // Villeneuve railway station
    {Coordinate{7.90852, 46.3014}, CountryId{"CH"}}, // Lalden railway station
    {Coordinate{94.3082, 26.6524}, CountryId{"IN"}}, // Mariani Junction railway station
    {Coordinate{9.70722, 46.8192}, CountryId{"CH"}}, // Langwies (Rhaetian Railway station)
    {Coordinate{95.828, 27.321}, CountryId{"IN"}}, // Lekhapani railway station
    {Coordinate{88.3392, 22.6207}, CountryId{"IN"}}, // Liluah railway station
    {Coordinate{93.1767, 25.7502}, CountryId{"IN"}}, // Lumding railway station
    {Coordinate{9.61333, 46.8317}, CountryId{"CH"}}, // Lüen-Castiel
    {Coordinate{86.8695, 23.6269}, CountryId{"IN"}}, // Madhukunda railway station
    {Coordinate{76.9429, 10.9009}, CountryId{"IN"}}, // Madukkarai railway station
    {Coordinate{79.0348, 27.2165}, CountryId{"IN"}}, // Mainpuri railway station
    {Coordinate{95.441, 27.4857}, CountryId{"IN"}}, // Makum railway station
    {Coordinate{73.4806, 18.7438}, CountryId{"IN"}}, // Malavli railway station
    {Coordinate{74.4383, 20.2499}, CountryId{"IN"}}, // Manmad Junction railway station
    {Coordinate{80.0199, 12.7966}, CountryId{"IN"}}, // Maraimalai Nagar railway station
    {Coordinate{7.27056, 53.5208}, CountryId{"DE"}}, // Marienhafe railway station
    {Coordinate{88.0427, 23.1351}, CountryId{"IN"}}, // Masagram railway station
    {Coordinate{77.6731, 27.4801}, CountryId{"IN"}}, // Mathura Junction railway station
    {Coordinate{79.6287, 11.0952}, CountryId{"IN"}}, // Mayiladuthurai Junction railway station
    {Coordinate{8.27545, 47.4279}, CountryId{"CH"}}, // Mellingen Heitersberg railway station
    {Coordinate{80.2602, 13.282}, CountryId{"IN"}}, // Minjur railway station
    {Coordinate{82.5699, 25.1343}, CountryId{"IN"}}, // Mirzapur railway station
    {Coordinate{9.08142, 47.01}, CountryId{"CH"}}, // Mitlödi railway station
    {Coordinate{59.3831, 56.2208}, CountryId{"RU"}}, // Araslanovo (railroad station in p.Araslanovo)
    {Coordinate{70.8293, 22.8253}, CountryId{"IN"}}, // Morbi railway station
    {Coordinate{76.2078, 10.5969}, CountryId{"IN"}}, // Mulankunnathukavu railway station
    {Coordinate{76.2714, 10.7058}, CountryId{"IN"}}, // Mullurkara railway station
    {Coordinate{11.7858, 48.3537}, CountryId{"DE"}}, // Munich Airport Terminal station
    {Coordinate{86.8093, 23.5931}, CountryId{"IN"}}, // Muradi railway station
    {Coordinate{77.3547, 20.7361}, CountryId{"IN"}}, // Murtajapur railway station
    {Coordinate{2.32556, 48.8606}, CountryId{"FR"}}, // Musée d'Orsay
    {Coordinate{8.23507, 47.4145}, CountryId{"CH"}}, // Mägenwil railway station
    {Coordinate{7.69077, 46.6385}, CountryId{"CH"}}, // Mülenen railway station
    {Coordinate{87.8681, 24.5906}, CountryId{"IN"}}, // Nagarnabi railway station
    {Coordinate{73.1408, 18.5399}, CountryId{"IN"}}, // Nagothane railway station
    {Coordinate{88.4175, 22.8871}, CountryId{"IN"}}, // Naihati Junction railway station
    {Coordinate{91.4403, 26.4506}, CountryId{"IN"}}, // Nalbari railway station
    {Coordinate{79.2834, 17.0612}, CountryId{"IN"}}, // Nalgonda railway station
    {Coordinate{73.8419, 19.9476}, CountryId{"IN"}}, // Nasik Road railway station
    {Coordinate{13.9033, 53.4417}, CountryId{"DE"}}, // Nechlin railway station
    {Coordinate{76.276, 10.3924}, CountryId{"IN"}}, // Nellayi railway station
    {Coordinate{79.9894, 14.4606}, CountryId{"IN"}}, // Nellore railway station
    {Coordinate{11.3918, 47.2141}, CountryId{"AT"}}, // Unterberg-Stefansbrücke railway station
    {Coordinate{73.319, 19.0271}, CountryId{"IN"}}, // Neral railway station
    {Coordinate{73.0181, 19.0336}, CountryId{"IN"}}, // Nerul railway station
    {Coordinate{86.1482, 23.8731}, CountryId{"IN"}}, // Netaji Subhas Chandra Bose Gomoh railway station
    {Coordinate{9.05954, 47.064}, CountryId{"CH"}}, // Netstal railway station
    {Coordinate{9.78722, 53.4728}, CountryId{"DE"}}, // Neu Wulmstorf station
    {Coordinate{8.02207, 51.8017}, CountryId{"DE"}}, // Neubeckum station
    {Coordinate{8.33131, 47.4504}, CountryId{"CH"}}, // Neuenhof railway station
    {Coordinate{14.2139, 51.0211}, CountryId{"DE"}}, // Neustadt (Sachs) railway station
    {Coordinate{9.455, 52.5028}, CountryId{"DE"}}, // Neustadt am Rübenberge station
    {Coordinate{90.5368, 26.4758}, CountryId{"IN"}}, // New Bongaigaon Junction railway station
    {Coordinate{80.4205, 23.8136}, CountryId{"IN"}}, // New Katni Junction railway station
    {Coordinate{88.8228, 26.5784}, CountryId{"IN"}}, // New Maynaguri railway station
    {Coordinate{77.0811, 8.41041}, CountryId{"IN"}}, // Neyyattinkara railway station
    {Coordinate{73.1066, 18.4722}, CountryId{"IN"}}, // Nidi railway station
    {Coordinate{9.06211, 47.1223}, CountryId{"CH"}}, // Nieder- and Oberurnen railway station
    {Coordinate{73.0799, 19.1551}, CountryId{"IN"}}, // Nilaje railway station
    {Coordinate{86.0762, 23.9321}, CountryId{"IN"}}, // Nimiaghat railway station
    {Coordinate{74.0795, 20.0966}, CountryId{"IN"}}, // Niphad railway station
    {Coordinate{7.54, 44.938}, CountryId{"IT"}}, // None railway station
    {Coordinate{9.6977, 59.1104}, CountryId{"NO"}}, // Nystrand Station
    {Coordinate{9.06947, 47.0988}, CountryId{"CH"}}, // Näfels-Mollis railway station
    {Coordinate{7.03056, 49.3044}, CountryId{"DE"}}, // Fischbach-Camphausen
    {Coordinate{6.95667, 49.2419}, CountryId{"DE"}}, // Saarbrücken-Burbach
    {Coordinate{7.00444, 49.2653}, CountryId{"DE"}}, // Jägersfreude
    {Coordinate{8.8107, 53.2833}, CountryId{"DE"}}, // Oldenbüttel station
    {Coordinate{8.21477, 47.4071}, CountryId{"CH"}}, // Othmarsingen railway station
    {Coordinate{83.9826, 26.8977}, CountryId{"IN"}}, // Padrauna railway station
    {Coordinate{87.743, 22.3931}, CountryId{"IN"}}, // Panskura Junction railway station
    {Coordinate{79.9837, 12.7302}, CountryId{"IN"}}, // Paranur railway station
    {Coordinate{83.4337, 18.7839}, CountryId{"IN"}}, // Parvathipuram Town Railway Station
    {Coordinate{85.0685, 25.6214}, CountryId{"IN"}}, // Patliputra Junction
    {Coordinate{85.1368, 25.6026}, CountryId{"IN"}}, // Patna Junction railway station
    {Coordinate{9.67167, 46.8294}, CountryId{"CH"}}, // Peist (Rhaetian Railway station)
    {Coordinate{73.0868, 18.7356}, CountryId{"IN"}}, // Pen railway station
    {Coordinate{7.3485, 44.8917}, CountryId{"IT"}}, // Pinerolo Olimpica railway station
    {Coordinate{7.4255, 44.9217}, CountryId{"IT"}}, // Piscina di Pinerolo railway station
    {Coordinate{77.0013, 10.6531}, CountryId{"IN"}}, // Pollachi Junction railway station
    {Coordinate{80.1988, 13.3323}, CountryId{"IN"}}, // Ponneri railway station
    {Coordinate{69.6155, 21.6436}, CountryId{"IN"}}, // Porbandar railway station
    {Coordinate{80.0369, 12.8209}, CountryId{"IN"}}, // Potheri railway station
    {Coordinate{76.2609, 10.4207}, CountryId{"IN"}}, // Pudukad railway station
    {Coordinate{78.3181, 20.7267}, CountryId{"IN"}}, // Pulgaon railway station
    {Coordinate{79.9371, 13.1229}, CountryId{"IN"}}, // Putlur railway station
    {Coordinate{77.9966, 27.1938}, CountryId{"IN"}}, // Raja ki Mandi railway station
    {Coordinate{87.8678, 24.545}, CountryId{"IN"}}, // Rajgram railway station
    {Coordinate{79.3068, 9.28097}, CountryId{"IN"}}, // Rameswaram railway station
    {Coordinate{86.7623, 23.5799}, CountryId{"IN"}}, // Ramkanali Junction railway station
    {Coordinate{88.5688, 23.1741}, CountryId{"IN"}}, // Ranaghat Junction railway station
    {Coordinate{91.6059, 26.4479}, CountryId{"IN"}}, // Rangiya railway station
    {Coordinate{87.1174, 23.6037}, CountryId{"IN"}}, // Raniganj railway station
    {Coordinate{73.1519, 18.894}, CountryId{"IN"}}, // Rasayani railway station
    {Coordinate{7.69077, 46.6249}, CountryId{"CH"}}, // Reichenbach im Kandertal railway station
    {Coordinate{80.8287, 16.0198}, CountryId{"IN"}}, // Repalle Railway Station
    {Coordinate{8.71208, 47.1968}, CountryId{"CH"}}, // Riedmatt railway station
    {Coordinate{73.1236, 18.4465}, CountryId{"IN"}}, // Roha railway station
    {Coordinate{87.9693, 23.2071}, CountryId{"IN"}}, // Saktigarh railway station
    {Coordinate{70.5034, 23.3098}, CountryId{"IN"}}, // Samakhiali Bg railway station
    {Coordinate{7.7822, 45.2186}, CountryId{"IT"}}, // San Benigno Canavese railway station
    {Coordinate{9.65389, 46.8289}, CountryId{"CH"}}, // Sankt Peter-Molinis station
    {Coordinate{76.3562, 26.0183}, CountryId{"IN"}}, // Sawai Madhopur railway station
    {Coordinate{24.6171, 56.8082}, CountryId{"LV"}}, // Pārogre Station
    {Coordinate{88.3284, 22.7748}, CountryId{"IN"}}, // Seoraphuli Junction railway station
    {Coordinate{78.575, 27.0857}, CountryId{"IN"}}, // Shikohabad railway station
    {Coordinate{80.0011, 12.7625}, CountryId{"IN"}}, // Singaperumal Koil railway station
    {Coordinate{7.045, 49.1431}, CountryId{"DE"}}, // Auersmacher
    {Coordinate{7.03472, 49.1794}, CountryId{"DE"}}, // Bübingen
    {Coordinate{7.03083, 49.1975}, CountryId{"DE"}}, // Güdingen
    {Coordinate{7.04917, 49.2278}, CountryId{"DE"}}, // Schafbrücke
    {Coordinate{}, CountryId{"DE"}}, // Schweighofen
    {Coordinate{70.4083, 20.8961}, CountryId{"IN"}}, // Somnath railway station
    {Coordinate{73.1455, 18.9522}, CountryId{"IN"}}, // Somtane railway station
    {Coordinate{}, CountryId{"DE"}}, // Renchen
    {Coordinate{}, CountryId{"DE"}}, // Gengenbach
    {Coordinate{}, CountryId{"DE"}}, // Buggingen
    {Coordinate{}, CountryId{"DE"}}, // Schliengen
    {Coordinate{7.05764, 47.4398}, CountryId{"CH"}}, // Courchavon
    {Coordinate{7.12833, 47.4241}, CountryId{"CH"}}, // Alle station
    {Coordinate{7.01653, 47.4925}, CountryId{"CH"}}, // Boncourt
    {Coordinate{6.47939, 46.9053}, CountryId{"CH"}}, // Verrières
    {Coordinate{9.74917, 47.505}, CountryId{"AT"}}, // Bregenz railway station
    {Coordinate{8.00294, 49.4143}, CountryId{"DE"}}, // Weidenthal station
    {Coordinate{7.80615, 49.1024}, CountryId{"DE"}}, // Q15297228
    {Coordinate{8.12722, 49.2839}, CountryId{"DE"}}, // Bahnhof Edenkoben
    {Coordinate{4.87111, 46.3922}, CountryId{"FR"}}, // Gare de Senozan
    {Coordinate{4.88409, 46.4509}, CountryId{"FR"}}, // Gare de Fleurville - Pont-de-Vaux
    {Coordinate{9.65073, 46.6712}, CountryId{"CH"}}, // Alvaneu
    {Coordinate{7.84079, 49.8067}, CountryId{"DE"}}, // Q15303880
    {Coordinate{37.3815, 55.6395}, CountryId{"RU"}}, // Новопеределкино (платформа)
    {Coordinate{10.4669, 59.8497}, CountryId{"NO"}}, // Vakås Station
    {Coordinate{10.6072, 59.9081}, CountryId{"NO"}}, // Stabekk Station
    {Coordinate{12.4297, 50.8928}, CountryId{"DE"}}, // Gößnitz station
    {Coordinate{6.23055, 50.7643}, CountryId{"DE"}}, // Q153200
    {Coordinate{8.07051, 49.5545}, CountryId{"DE"}}, // Bahnhof Eisenberg, Rhineland-Palatinate
    {Coordinate{83.1584, 19.9339}, CountryId{"IN"}}, // Bhawanipatna railway station
    {Coordinate{}, CountryId{"FR"}}, // Q15401642
    {Coordinate{}, CountryId{"FR"}}, // Q15401655
    {Coordinate{}, CountryId{"FR"}}, // Q15401658
    {Coordinate{12.4587, 52.4996}, CountryId{"DE"}}, // Pritzerbe station
    {Coordinate{11.94, 48.0433}, CountryId{"DE"}}, // Grafing Bahnhof
    {Coordinate{78.1554, 8.80611}, CountryId{"IN"}}, // Thoothukudi railway station
    {Coordinate{15.4484, 47.0538}, CountryId{"AT"}}, // Graz Ostbahnhof-Messe
    {Coordinate{13.5204, 51.2963}, CountryId{"DE"}}, // Großenhain Berliner Bahnhof
    {Coordinate{11.5308, 48.071}, CountryId{"DE"}}, // Grosshesselohe Isartal station
    {Coordinate{25.631, 56.8957}, CountryId{"LV"}}, // Q15494548
    {Coordinate{7.75058, 49.1975}, CountryId{"DE"}}, // Q15496747
    {Coordinate{12.5197, 48.2482}, CountryId{"DE"}}, // Mühldorf (Oberbayern) station
    {Coordinate{13.2476, 51.5833}, CountryId{"DE"}}, // Falkenberg (Elster) station
    {Coordinate{17.1666, 49.4417}, CountryId{"CZ"}}, // Q15534301
    {Coordinate{30.7711, 50.4125}, CountryId{"UA"}}, // Imeni Heorhiya Kirpy
    {Coordinate{14.4694, 50.1267}, CountryId{"CZ"}}, // Ládví
    {Coordinate{79.3161, 11.535}, CountryId{"IN"}}, // Vriddhachalam railway station
    {Coordinate{6.09407, 46.2206}, CountryId{"CH"}}, // Vernier
    {Coordinate{6.07723, 46.2223}, CountryId{"CH"}}, // Meyrin
    {Coordinate{6.06578, 46.2212}, CountryId{"CH"}}, // Zimeysa
    {Coordinate{13.0709, 42.41}, CountryId{"IT"}}, // Antrodoco-Borgo Velino railway station
    {Coordinate{13.096, 42.398}, CountryId{"IT"}}, // Rocca di Fondi railway station
    {Coordinate{13.1443, 42.3884}, CountryId{"IT"}}, // Q15617142
    {Coordinate{13.19, 42.3606}, CountryId{"IT"}}, // Sella di Corno railway station
    {Coordinate{13.5629, 42.2507}, CountryId{"IT"}}, // Fagnano-Campana railway station
    {Coordinate{13.6044, 42.2228}, CountryId{"IT"}}, // Q15617152
    {Coordinate{13.642, 42.2049}, CountryId{"IT"}}, // Q15617153
    {Coordinate{13.6609, 42.1974}, CountryId{"IT"}}, // Beffi railway station
    {Coordinate{13.8091, 42.0981}, CountryId{"IT"}}, // Raiano railway station
    {Coordinate{13.7397, 42.1436}, CountryId{"IT"}}, // Molina-Castelvecchio Subequo railway station
    {Coordinate{13.8719, 42.0804}, CountryId{"IT"}}, // Pratola Peligna Superiore railway station
    {Coordinate{13.7111, 42.1767}, CountryId{"IT"}}, // Acciano railway station
    {Coordinate{10.6475, 45.1443}, CountryId{"IT"}}, // Castellucchio railway station
    {Coordinate{10.5337, 45.1244}, CountryId{"IT"}}, // Marcaria railway station
    {Coordinate{14.25, 51.4333}, CountryId{"DE"}}, // Hoyerswerda railway station
    {Coordinate{7.05539, 49.2994}, CountryId{"DE"}}, // Sulzbach (Saar) station
    {Coordinate{11.189, 54.4436}, CountryId{"DE"}}, // Fehmarn-Burg station
    {Coordinate{76.5803, 9.39215}, CountryId{"IN"}}, // Tiruvalla railway station
    {Coordinate{9.59111, 47.4669}, CountryId{"CH"}}, // Rheineck railway station
    {Coordinate{9.50521, 47.4778}, CountryId{"CH"}}, // Rorschach station
    {Coordinate{9.63824, 47.4532}, CountryId{"CH"}}, // St. Margrethen railway station
    {Coordinate{10.0061, 44.6247}, CountryId{"IT"}}, // Q15639770
    {Coordinate{9.92705, 44.1735}, CountryId{"IT"}}, // Q15639791
    {Coordinate{14.1, 51.2667}, CountryId{"DE"}}, // Kamenz railway station
    {Coordinate{74.858, 31.6315}, CountryId{"IN"}}, // Amritsar railway station
    {Coordinate{80.8603, 26.8471}, CountryId{"IN"}}, // Alamnagar railway station
    {Coordinate{80.9096, 26.8374}, CountryId{"IN"}}, // Aishbagh junction
    {Coordinate{7.6349, 51.1084}, CountryId{"DE"}}, // Q15648785
    {Coordinate{77.187, 28.5821}, CountryId{"IN"}}, // Delhi Safdarjung railway station
    {Coordinate{39.9743, 43.412}, CountryId{"RU"}}, // Olympic Park
    {Coordinate{8.71083, 49.2194}, CountryId{"DE"}}, // Odenheim train station
    {Coordinate{73.3166, 28.0141}, CountryId{"IN"}}, // Bikaner Junction railway station
    {Coordinate{77.8097, 16.2251}, CountryId{"IN"}}, // Gadwal railway station
    {Coordinate{14.4489, 50.0642}, CountryId{"CZ"}}, // Praha-Vršovice railway station
    {Coordinate{78.0416, 15.9157}, CountryId{"IN"}}, // Jogulamba Halt railway station
    {Coordinate{24.8453, 48.7364}, CountryId{"UA"}}, // Otynia
    {Coordinate{25.9294, 48.3011}, CountryId{"UA"}}, // Chernivtsi
    {Coordinate{8.1128, 53.144}, CountryId{"DE"}}, // Rastede railway station
    {Coordinate{8.14995, 53.399}, CountryId{"DE"}}, // Varel railway station
    {Coordinate{8.03183, 53.4899}, CountryId{"DE"}}, // Sande railway station
    {Coordinate{8.11479, 53.5187}, CountryId{"DE"}}, // Wilhelmshaven railway station
    {Coordinate{8.201, 53.0705}, CountryId{"DE"}}, // Wüsting railway station
    {Coordinate{8.4051, 53.0324}, CountryId{"DE"}}, // Heidkrug railway station
    {Coordinate{8.3157, 53.0556}, CountryId{"DE"}}, // Bookholzberg railway station
    {Coordinate{8.3447, 53.0503}, CountryId{"DE"}}, // Schierbrok railway station
    {Coordinate{8.5989, 53.0695}, CountryId{"DE"}}, // Hoykenkamp railway station
    {Coordinate{11.3677, 44.5777}, CountryId{"IT"}}, // Castelmaggiore railway station
    {Coordinate{11.3789, 44.6467}, CountryId{"IT"}}, // San Giorgio di Piano railway station
    {Coordinate{11.4046, 44.698}, CountryId{"IT"}}, // San Pietro in Casale railway station
    {Coordinate{11.4417, 44.7377}, CountryId{"IT"}}, // Galliera railway station
    {Coordinate{11.5439, 44.7958}, CountryId{"IT"}}, // Coronella railway station
    {Coordinate{10.9779, 44.1558}, CountryId{"IT"}}, // Porretta Terme railway station
    {Coordinate{10.9807, 44.1776}, CountryId{"IT"}}, // Silla railway station
    {Coordinate{11.0535, 44.23}, CountryId{"IT"}}, // Riola railway station
    {Coordinate{11.1141, 44.2828}, CountryId{"IT"}}, // Vergato railway station
    {Coordinate{11.1618, 44.3106}, CountryId{"IT"}}, // Pioppe di Salvaro railway station
    {Coordinate{41.3792, 56.3897}, CountryId{"RU"}}, // Q15714625
    {Coordinate{11.5171, 50.3572}, CountryId{"DE"}}, // Dürrenwaid station
    {Coordinate{7.59, 50.3575}, CountryId{"DE"}}, // Koblenz Stadtmitte station
    {Coordinate{10.6981, 53.8022}, CountryId{"DE"}}, // Lübeck-Flughafen station
    {Coordinate{7.01861, 49.2303}, CountryId{"DE"}}, // Saarbrücken-Ost station
    {Coordinate{13.6619, 51.1061}, CountryId{"DE"}}, // Weißes Roß
    {Coordinate{16.3064, 48.1982}, CountryId{"AT"}}, // Wien Breitensee railway station
    {Coordinate{16.329, 48.2313}, CountryId{"AT"}}, // Wien Gersthof
    {Coordinate{16.3411, 48.2401}, CountryId{"AT"}}, // Wien Krottenbachstraße railway station
    {Coordinate{16.3587, 48.1802}, CountryId{"AT"}}, // Wien Matzleinsdorfer Platz railway station
    {Coordinate{16.3443, 48.2444}, CountryId{"AT"}}, // Wien Oberdöbling railway station
    {Coordinate{16.3818, 48.188}, CountryId{"AT"}}, // Wien Quartier Belvedere train station
    {Coordinate{16.3834, 48.2348}, CountryId{"AT"}}, // Wien Traisengasse railway station
    {Coordinate{8.74076, 48.7086}, CountryId{"DE"}}, // Q15725866
    {Coordinate{12.3864, 51.3008}, CountryId{"DE"}}, // Leipzig-Connewitz railway station
    {Coordinate{8.52271, 45.4027}, CountryId{"IT"}}, // Ponzana railway station
    {Coordinate{14.201, 50.7735}, CountryId{"CZ"}}, // Děčín hlavní nádraží
    {Coordinate{14.8872, 50.4073}, CountryId{"CZ"}}, // Mladá Boleslav Main Station
    {Coordinate{14.5333, 50.6752}, CountryId{"CZ"}}, // Q15735588
    {Coordinate{14.5441, 50.0974}, CountryId{"CZ"}}, // Praha-Kyje
    {Coordinate{9.46722, 51.23}, CountryId{"DE"}}, // Q15785148
    {Coordinate{7.28184, 49.2619}, CountryId{"DE"}}, // Q15785154
    {Coordinate{7.77131, 49.1547}, CountryId{"DE"}}, // Q15785159
    {Coordinate{8.10822, 49.564}, CountryId{"DE"}}, // Q15785163
    {Coordinate{7.45633, 49.4948}, CountryId{"DE"}}, // Q15785166
    {Coordinate{13.5184, 51.4722}, CountryId{"DE"}}, // Elsterwerda-Biehla station
    {Coordinate{8.21066, 49.4884}, CountryId{"DE"}}, // Erpolzheim station
    {Coordinate{7.96985, 49.439}, CountryId{"DE"}}, // Frankenstein (Pfalz) station
    {Coordinate{9.59564, 49.6981}, CountryId{"DE"}}, // Q15785172
    {Coordinate{11.5014, 47.2769}, CountryId{"AT"}}, // Hall in Tirol railway station
    {Coordinate{8.67521, 49.3799}, CountryId{"DE"}}, // Heidelberg-Kirchheim/Rohrbach station
    {Coordinate{8.72357, 48.4823}, CountryId{"DE"}}, // Bahnhof Hochdorf (b Horb)
    {Coordinate{7.74978, 49.4475}, CountryId{"DE"}}, // Bahnhof Kaiserslautern West
    {Coordinate{7.83509, 48.3403}, CountryId{"DE"}}, // Lahr (Schwarzw) station
    {Coordinate{7.56602, 49.4163}, CountryId{"DE"}}, // Landstuhl station
    {Coordinate{9.14595, 49.0764}, CountryId{"DE"}}, // Q15785185
    {Coordinate{8.13336, 50.3776}, CountryId{"DE"}}, // Lindenholzhausen station
    {Coordinate{8.84145, 49.4048}, CountryId{"DE"}}, // Q15785188
    {Coordinate{8.16125, 50.3593}, CountryId{"DE"}}, // Niederbrechen station
    {Coordinate{8.18806, 50.3546}, CountryId{"DE"}}, // Oberbrechen station
    {Coordinate{7.7139, 47.2889}, CountryId{"CH"}}, // Q15785193
    {Coordinate{13.0786, 47.7888}, CountryId{"AT"}}, // Aigen
    {Coordinate{10.1739, 51.8875}, CountryId{"DE"}}, // Seesen station
    {Coordinate{11.0482, 48.0946}, CountryId{"DE"}}, // Train station St. Ottilien
    {Coordinate{7.16564, 49.467}, CountryId{"DE"}}, // St. Wendel station
    {Coordinate{10.5627, 51.9552}, CountryId{"DE"}}, // Vienenburg station
    {Coordinate{26.3108, 56.1844}, CountryId{"LV"}}, // Sergunta
    {Coordinate{26.478, 55.9338}, CountryId{"LV"}}, // 383. kilometers
    {Coordinate{26.4997, 55.8954}, CountryId{"LV"}}, // 387. kilometers
    {Coordinate{7.31855, 49.2683}, CountryId{"DE"}}, // Q15792329
    {Coordinate{8.78281, 48.4798}, CountryId{"DE"}}, // Eutingen im Gäu station
    {Coordinate{8.1813, 49.5372}, CountryId{"DE"}}, // Q15792331
    {Coordinate{8.28764, 49.1595}, CountryId{"DE"}}, // Rülzheim station
    {Coordinate{9.73397, 49.1082}, CountryId{"DE"}}, // Schwäbisch Hall station
    {Coordinate{9.36794, 49.5783}, CountryId{"DE"}}, // Q15792337
    {Coordinate{24.2532, 56.883}, CountryId{"LV"}}, // Rumbula Station
    {Coordinate{24.3242, 56.8644}, CountryId{"LV"}}, // Dole
    {Coordinate{24.4367, 56.8496}, CountryId{"LV"}}, // Saulkalne
    {Coordinate{24.6536, 56.7821}, CountryId{"LV"}}, // Ciemupe
    {Coordinate{25.206, 56.6311}, CountryId{"LV"}}, // Muldakmens
    {Coordinate{14.3979, 52.3369}, CountryId{"DE"}}, // Pillgram
    {Coordinate{14.2814, 52.3464}, CountryId{"DE"}}, // Briesen (Mark) station
    {Coordinate{14.1653, 52.3571}, CountryId{"DE"}}, // Berkenbrück station
    {Coordinate{13.922, 52.4}, CountryId{"DE"}}, // Hangelsberg station
    {Coordinate{13.8716, 53.5283}, CountryId{"DE"}}, // Blumenhagen
    {Coordinate{14.1544, 53.1851}, CountryId{"DE"}}, // Schönow (Kr Uckermark)
    {Coordinate{14.2528, 53.24}, CountryId{"DE"}}, // Petershagen
    {Coordinate{14.148, 53.9529}, CountryId{"DE"}}, // Heringsdorf Neuhof railway station
    {Coordinate{13.694, 52.7746}, CountryId{"DE"}}, // Melchow
    {Coordinate{13.9287, 52.8307}, CountryId{"DE"}}, // Niederfinow
    {Coordinate{13.6752, 52.7558}, CountryId{"DE"}}, // Biesenthal
    {Coordinate{30.6058, 46.5247}, CountryId{"UA"}}, // Usatove
    {Coordinate{29.5361, 45.9889}, CountryId{"UA"}}, // Hnadental
    {Coordinate{10.902, 47.8126}, CountryId{"DE"}}, // Bahnhof Schongau
    {Coordinate{6.12531, 46.1888}, CountryId{"CH"}}, // Lancy-Pont-Rouge
    {Coordinate{12.3791, 51.2501}, CountryId{"DE"}}, // Markkleeberg-Gaschwitz railway station
    {Coordinate{11.2729, 43.3856}, CountryId{"IT"}}, // Badesse
    {Coordinate{11.4063, 43.2944}, CountryId{"IT"}}, // Arbia
    {Coordinate{10.4706, 43.5865}, CountryId{"IT"}}, // Collesalvetti railway station
    {Coordinate{8.56693, 44.3568}, CountryId{"IT"}}, // Varazze railway station
    {Coordinate{2.8411, 50.3352}, CountryId{"FR"}}, // Q15865337
    {Coordinate{8.15941, 49.355}, CountryId{"DE"}}, // Neustadt (Weinstr) Böbig station
    {Coordinate{14.5989, 49.4458}, CountryId{"CZ"}}, // Q15886695
    {Coordinate{15.3983, 49.3175}, CountryId{"CZ"}}, // Q15886701
    {Coordinate{14.4777, 49.3}, CountryId{"CZ"}}, // Bechyně railway station
    {Coordinate{15.0911, 49.1397}, CountryId{"CZ"}}, // Blažejov (train station)
    {Coordinate{13.5314, 49.5808}, CountryId{"CZ"}}, // Blovice railway station
    {Coordinate{14.6425, 48.8911}, CountryId{"CZ"}}, // Borovany (train station)
    {Coordinate{14.4442, 48.9269}, CountryId{"CZ"}}, // Boršov nad Vltavou (train station)
    {Coordinate{14.4925, 49.4475}, CountryId{"CZ"}}, // Q15886733
    {Coordinate{14.3456, 49.4025}, CountryId{"CZ"}}, // Q15886735
    {Coordinate{14.6666, 49.7415}, CountryId{"CZ"}}, // Bystřice u Benešova
    {Coordinate{12.843, 50.8156}, CountryId{"DE"}}, // Q15886751
    {Coordinate{14.8681, 48.9503}, CountryId{"CZ"}}, // Majdalena
    {Coordinate{14.6689, 49.4736}, CountryId{"CZ"}}, // Q15886755
    {Coordinate{14.5292, 49.0783}, CountryId{"CZ"}}, // Q15886757
    {Coordinate{14.9839, 49.3419}, CountryId{"CZ"}}, // Q15886760
    {Coordinate{14.8108, 49.4153}, CountryId{"CZ"}}, // Q15886763
    {Coordinate{15.6417, 49.4783}, CountryId{"CZ"}}, // Dobronín
    {Coordinate{14.7994, 49.2081}, CountryId{"CZ"}}, // Q15886782
    {Coordinate{14.6292, 49.1467}, CountryId{"CZ"}}, // Q15886785
    {Coordinate{14.3008, 49.1061}, CountryId{"CZ"}}, // Q15886787
    {Coordinate{14.5833, 49.6033}, CountryId{"CZ"}}, // Heřmaničky
    {Coordinate{14.42, 49.0325}, CountryId{"CZ"}}, // Hluboká nad Vltavou railway station
    {Coordinate{15.3244, 49.3108}, CountryId{"CZ"}}, // Q15886810
    {Coordinate{14.0261, 48.7647}, CountryId{"CZ"}}, // Horní Planá
    {Coordinate{14.6661, 49.1672}, CountryId{"CZ"}}, // Q15886815
    {Coordinate{14.1828, 48.7714}, CountryId{"CZ"}}, // Q15886817
    {Coordinate{15.0789, 49.1819}, CountryId{"CZ"}}, // Q15886831
    {Coordinate{14.6069, 49.5767}, CountryId{"CZ"}}, // Q15886839
    {Coordinate{15.5995, 49.4147}, CountryId{"CZ"}}, // Jihlava railway station
    {Coordinate{15.2947, 49.2525}, CountryId{"CZ"}}, // Q15886843
    {Coordinate{15.0042, 49.155}, CountryId{"CZ"}}, // Q15886845
    {Coordinate{14.7044, 48.8772}, CountryId{"CZ"}}, // Q15886848
    {Coordinate{15.0744, 49.295}, CountryId{"CZ"}}, // Q15886851
    {Coordinate{14.8605, 49.1836}, CountryId{"CZ"}}, // Q15886853
    {Coordinate{13.8233, 49.2692}, CountryId{"CZ"}}, // Q15886855
    {Coordinate{14.4797, 49.6592}, CountryId{"CZ"}}, // Q15886864
    {Coordinate{14.2658, 48.8128}, CountryId{"CZ"}}, // Q15886889
    {Coordinate{14.3313, 48.9046}, CountryId{"CZ"}}, // Q15886891
    {Coordinate{14.7297, 49.0911}, CountryId{"CZ"}}, // Q15886904
    {Coordinate{15.0506, 49.2014}, CountryId{"CZ"}}, // Q15886906
    {Coordinate{14.5853, 49.3594}, CountryId{"CZ"}}, // Q15886917
    {Coordinate{14.3775, 49.4417}, CountryId{"CZ"}}, // Q15886927
    {Coordinate{13.6083, 49.4975}, CountryId{"CZ"}}, // Q15886935
    {Coordinate{13.5164, 49.6422}, CountryId{"CZ"}}, // Nezvěstice station
    {Coordinate{15.1108, 49.0189}, CountryId{"CZ"}}, // Nová Bystřice
    {Coordinate{15.1175, 49.4256}, CountryId{"CZ"}}, // Q15886945
    {Coordinate{13.9531, 48.7897}, CountryId{"CZ"}}, // Nová Pec (train station)
    {Coordinate{14.9228, 48.8117}, CountryId{"CZ"}}, // Q15886949
    {Coordinate{15.0664, 49.2369}, CountryId{"CZ"}}, // Q15886952
    {Coordinate{14.8089, 48.8231}, CountryId{"CZ"}}, // Q15886954
    {Coordinate{14.9539, 49.4289}, CountryId{"CZ"}}, // Q15886959
    {Coordinate{14.6241, 49.6668}, CountryId{"CZ"}}, // Olbramovice (train station)
    {Coordinate{15.0172, 49.4599}, CountryId{"CZ"}}, // Q15886973
    {Coordinate{13.6206, 49.3911}, CountryId{"CZ"}}, // Pačejov railway station
    {Coordinate{15.2225, 49.4192}, CountryId{"CZ"}}, // Q15886977
    {Coordinate{14.7058, 49.3539}, CountryId{"CZ"}}, // Q15886983
    {Coordinate{14.1203, 48.7994}, CountryId{"CZ"}}, // Q15886990
    {Coordinate{14.1478, 48.7983}, CountryId{"CZ"}}, // Q15886992
    {Coordinate{15.1786, 49.2203}, CountryId{"CZ"}}, // Q15886995
    {Coordinate{14.7822, 49.7378}, CountryId{"CZ"}}, // Postupice
    {Coordinate{14.2117, 49.2122}, CountryId{"CZ"}}, // Q15887003
    {Coordinate{14.1314, 49.2639}, CountryId{"CZ"}}, // Q15887014
    {Coordinate{14.1428, 49.2964}, CountryId{"CZ"}}, // Q15887017
    {Coordinate{15.5131, 49.4066}, CountryId{"CZ"}}, // Rantířov (train station)
    {Coordinate{14.1083, 49.2447}, CountryId{"CZ"}}, // Q15887033
    {Coordinate{14.7153, 49.2969}, CountryId{"CZ"}}, // Q15887039
    {Coordinate{14.4339, 49.6558}, CountryId{"CZ"}}, // Q15887060
    {Coordinate{14.7256, 49.2556}, CountryId{"CZ"}}, // Soběslav station
    {Coordinate{13.4783, 49.6953}, CountryId{"CZ"}}, // Starý Plzenec station
    {Coordinate{13.9158, 49.2553}, CountryId{"CZ"}}, // Strakonice
    {Coordinate{14.6775, 49.9494}, CountryId{"CZ"}}, // Strančice
    {Coordinate{13.7789, 49.3053}, CountryId{"CZ"}}, // Q15887089
    {Coordinate{14.6211, 49.5383}, CountryId{"CZ"}}, // Q15887091
    {Coordinate{15.1344, 49.1347}, CountryId{"CZ"}}, // Q15887094
    {Coordinate{14.8825, 48.9022}, CountryId{"CZ"}}, // Q15887096
    {Coordinate{14.5411, 49.295}, CountryId{"CZ"}}, // Q15887098
    {Coordinate{14.6614, 49.5086}, CountryId{"CZ"}}, // Q15887100
    {Coordinate{14.6553, 49.6989}, CountryId{"CZ"}}, // Q15887116
    {Coordinate{15.0094, 49.7075}, CountryId{"CZ"}}, // Trhový Štěpánov
    {Coordinate{14.7606, 49.0153}, CountryId{"CZ"}}, // Q15887122
    {Coordinate{14.7167, 49.1936}, CountryId{"CZ"}}, // Q15887128
    {Coordinate{14.2231, 49.3692}, CountryId{"CZ"}}, // Q15887130
    {Coordinate{14.8975, 49.7003}, CountryId{"CZ"}}, // Vlašim
    {Coordinate{14.6199, 49.6378}, CountryId{"CZ"}}, // Votice
    {Coordinate{14.3514, 48.8506}, CountryId{"CZ"}}, // Q15887171
    {Coordinate{14.3618, 49.0655}, CountryId{"CZ"}}, // Zliv railway station
    {Coordinate{14.2036, 49.3431}, CountryId{"CZ"}}, // Q15887177
    {Coordinate{14.0156, 49.2517}, CountryId{"CZ"}}, // Q15887179
    {Coordinate{14.0867, 48.7428}, CountryId{"CZ"}}, // Q15887182
    {Coordinate{14.7017, 49.8514}, CountryId{"CZ"}}, // Čerčany
    {Coordinate{14.9572, 48.7694}, CountryId{"CZ"}}, // Q15887192
    {Coordinate{14.3172, 48.8222}, CountryId{"CZ"}}, // Český Krumlov train station
    {Coordinate{14.2216, 49.1536}, CountryId{"CZ"}}, // Číčenice station
    {Coordinate{14.6642, 49.9969}, CountryId{"CZ"}}, // Říčany
    {Coordinate{14.5742, 49.0975}, CountryId{"CZ"}}, // Ševětín
    {Coordinate{15.6526, 49.5452}, CountryId{"CZ"}}, // Q15887220
    {Coordinate{14.5169, 49.6667}, CountryId{"CZ"}}, // Q15887224
    {Coordinate{38.035, 48.7153}, CountryId{"UA"}}, // Q1590535
    {Coordinate{16.4261, 48.1542}, CountryId{"AT"}}, // Wien Zentralfriedhof
    {Coordinate{84.8741, 25.5609}, CountryId{"IN"}}, // Bihta railway station
    {Coordinate{8.2831, 45.7163}, CountryId{"IT"}}, // Borgosesia railway station
    {Coordinate{11.6305, 52.1093}, CountryId{"DE"}}, // Bahnhof Magdeburg-Buckau
    {Coordinate{7.5631, 52.0218}, CountryId{"DE"}}, // Münster-Häger
    {Coordinate{7.48186, 52.0515}, CountryId{"DE"}}, // Altenberge
    {Coordinate{7.18419, 52.2016}, CountryId{"DE"}}, // Ochtrup
    {Coordinate{7.37545, 52.1232}, CountryId{"DE"}}, // Steinfurt-Grottenkamp
    {Coordinate{7.39696, 52.1188}, CountryId{"DE"}}, // Steinfurt-Borghorst
    {Coordinate{7.46133, 52.0778}, CountryId{"DE"}}, // Nordwalde station
    {Coordinate{7.78105, 51.9811}, CountryId{"DE"}}, // Telgte
    {Coordinate{7.5282, 51.9146}, CountryId{"DE"}}, // Münster-Albachten
    {Coordinate{7.59895, 51.8841}, CountryId{"DE"}}, // Münster-Amelsbüren
    {Coordinate{7.59877, 51.8171}, CountryId{"DE"}}, // Davensberg
    {Coordinate{7.6892, 51.8446}, CountryId{"DE"}}, // Rinkerode
    {Coordinate{9.015, 53.0057}, CountryId{"DE"}}, // Achim railway station
    {Coordinate{9.2464, 52.8469}, CountryId{"DE"}}, // Dörverden railway station
    {Coordinate{9.23139, 52.7829}, CountryId{"DE"}}, // Eystrup railway station
    {Coordinate{9.87639, 53.3244}, CountryId{"DE"}}, // Buchholz (Nordheide) railway station
    {Coordinate{9.19497, 52.9779}, CountryId{"DE"}}, // Langwedel railway station
    {Coordinate{9.6988, 52.4585}, CountryId{"DE"}}, // Hannover Flughafen railway station
    {Coordinate{10.0636, 52.2117}, CountryId{"DE"}}, // Hämelerwald station
    {Coordinate{9.8429, 52.2328}, CountryId{"DE"}}, // Sarstedt railway station
    {Coordinate{9.45102, 52.4222}, CountryId{"DE"}}, // Wunstorf station
    {Coordinate{7.88684, 53.2022}, CountryId{"DE"}}, // Westerstede-Ocholt railway station
    {Coordinate{9.7319, 53.2717}, CountryId{"DE"}}, // Tostedt railway station
    {Coordinate{10.359, 52.2579}, CountryId{"DE"}}, // Vechelde station
    {Coordinate{8.25528, 53.0545}, CountryId{"DE"}}, // Sandkrug
    {Coordinate{8.26644, 52.9905}, CountryId{"DE"}}, // Huntlosen
    {Coordinate{8.01466, 53.5074}, CountryId{"DE"}}, // Sanderbusch
    {Coordinate{8.8871, 53.054}, CountryId{"DE"}}, // Bremen-Hemelingen
    {Coordinate{9.08192, 53.0077}, CountryId{"DE"}}, // Baden
    {Coordinate{9.1241, 52.9991}, CountryId{"DE"}}, // Etelsen station
    {Coordinate{7.7496, 44.9204}, CountryId{"IT"}}, // Villastellone
    {Coordinate{8.55138, 44.8648}, CountryId{"IT"}}, // Cantalupo railway station
    {Coordinate{8.85581, 44.8106}, CountryId{"IT"}}, // Villalvernia railway station
    {Coordinate{6.01755, 46.1878}, CountryId{"CH"}}, // Russin
    {Coordinate{8.60861, 46.5275}, CountryId{"CH"}}, // Airolo railway station
    {Coordinate{8.69015, 46.5106}, CountryId{"CH"}}, // Ambrì-Piotta railway station
    {Coordinate{8.69611, 47.1317}, CountryId{"CH"}}, // Altmatt station
    {Coordinate{8.66917, 47.0933}, CountryId{"CH"}}, // Biberegg station
    {Coordinate{6.5189, 46.6981}, CountryId{"CH"}}, // Arnex railway station
    {Coordinate{7.10611, 46.8169}, CountryId{"CH"}}, // Q15964056
    {Coordinate{7.10917, 46.8219}, CountryId{"CH"}}, // Q15964057
    {Coordinate{6.81167, 46.9297}, CountryId{"CH"}}, // Bevaix
    {Coordinate{6.87778, 46.9797}, CountryId{"CH"}}, // Auvernier
    {Coordinate{7.2725, 47.1447}, CountryId{"CH"}}, // Biel Mett railway station
    {Coordinate{7.42806, 47.1947}, CountryId{"CH"}}, // Bettlach station
    {Coordinate{7.495, 47.2083}, CountryId{"CH"}}, // Bellach station
    {Coordinate{8.36556, 47.2469}, CountryId{"CH"}}, // Q15964066
    {Coordinate{8.51694, 47.1831}, CountryId{"CH"}}, // Q15964067
    {Coordinate{7.90833, 47.3203}, CountryId{"CH"}}, // Aarburg-Oftringen station
    {Coordinate{9.50522, 47.0103}, CountryId{"CH"}}, // Bad Ragaz station
    {Coordinate{9.55667, 47.3742}, CountryId{"CH"}}, // Altstätten SG station
    {Coordinate{9.64139, 47.4361}, CountryId{"CH"}}, // Au SG railway station
    {Coordinate{9.43333, 47.5105}, CountryId{"CH"}}, // Arbon railway station
    {Coordinate{9.42472, 47.5214}, CountryId{"CH"}}, // Arbon Seemoosriet railway station
    {Coordinate{9.26611, 47.6214}, CountryId{"CH"}}, // Altnau station
    {Coordinate{9.02194, 47.6731}, CountryId{"CH"}}, // Berlingen station
    {Coordinate{7.49833, 46.8892}, CountryId{"CH"}}, // Belp railway station
    {Coordinate{7.55944, 47.0956}, CountryId{"CH"}}, // Q15964077
    {Coordinate{6.52368, 46.606}, CountryId{"CH"}}, // Cossonay-Penthalaz railway station
    {Coordinate{6.47473, 46.7151}, CountryId{"CH"}}, // Bretonnières railway station
    {Coordinate{6.69917, 46.5097}, CountryId{"CH"}}, // Bossière railway station
    {Coordinate{6.77861, 46.4811}, CountryId{"CH"}}, // Q15964085
    {Coordinate{7.00056, 46.7492}, CountryId{"CH"}}, // Q15964086
    {Coordinate{6.78639, 46.8169}, CountryId{"CH"}}, // Q15964087
    {Coordinate{6.95722, 46.8289}, CountryId{"CH"}}, // Q15964088
    {Coordinate{6.72306, 46.8508}, CountryId{"CH"}}, // Concise
    {Coordinate{6.835, 46.9594}, CountryId{"CH"}}, // Boudry
    {Coordinate{6.84889, 46.9678}, CountryId{"CH"}}, // Colombier
    {Coordinate{7.02361, 47.0386}, CountryId{"CH"}}, // Cornaux
    {Coordinate{8.31472, 47.3053}, CountryId{"CH"}}, // Q15964093
    {Coordinate{8.45722, 47.1781}, CountryId{"CH"}}, // Q15964094
    {Coordinate{8.47111, 47.1822}, CountryId{"CH"}}, // Cham Alpenblick train station
    {Coordinate{8.35639, 47.0936}, CountryId{"CH"}}, // Q15964096
    {Coordinate{7.95694, 47.2628}, CountryId{"CH"}}, // Q15964097
    {Coordinate{9.47878, 47.1688}, CountryId{"CH"}}, // Buchs station
    {Coordinate{6.47813, 46.6967}, CountryId{"CH"}}, // Croy-Romainmôtier railway station
    {Coordinate{6.54051, 46.5291}, CountryId{"CH"}}, // Denges-Echandens railway station
    {Coordinate{9.34806, 47.0967}, CountryId{"CH"}}, // Flums railway station
    {Coordinate{6.81111, 46.6106}, CountryId{"CH"}}, // Q15964106
    {Coordinate{7.035, 46.7513}, CountryId{"CH"}}, // Q15964107
    {Coordinate{6.84306, 46.8444}, CountryId{"CH"}}, // Q15964108
    {Coordinate{6.88917, 46.8161}, CountryId{"CH"}}, // Q15964109
    {Coordinate{6.9775, 46.8186}, CountryId{"CH"}}, // Cousset Station
    {Coordinate{7.1225, 46.8678}, CountryId{"CH"}}, // Q15964111
    {Coordinate{7.14972, 46.9}, CountryId{"CH"}}, // Q15964112
    {Coordinate{7.03972, 47.0519}, CountryId{"CH"}}, // Cressier railway station
    {Coordinate{7.61889, 47.2183}, CountryId{"CH"}}, // Deitingen railway station
    {Coordinate{7.79889, 47.3147}, CountryId{"CH"}}, // Q15964115
    {Coordinate{7.94667, 47.3542}, CountryId{"CH"}}, // Dulliken railway station
    {Coordinate{7.97833, 47.3564}, CountryId{"CH"}}, // Däniken railway station
    {Coordinate{8.235, 47.3736}, CountryId{"CH"}}, // Q15964118
    {Coordinate{8.34222, 47.0842}, CountryId{"CH"}}, // Q15964121
    {Coordinate{7.97889, 47.2175}, CountryId{"CH"}}, // Q15964122
    {Coordinate{9.383, 47.544}, CountryId{"CH"}}, // Egnach railway station
    {Coordinate{8.87639, 47.6456}, CountryId{"CH"}}, // Eschenz railway station
    {Coordinate{9.08583, 47.67}, CountryId{"CH"}}, // Ermatingen railway station
    {Coordinate{8.7525, 47.6853}, CountryId{"CH"}}, // Diessenhofen railway station
    {Coordinate{7.31944, 46.8885}, CountryId{"CH"}}, // Flamatt railway station
    {Coordinate{6.72306, 46.4969}, CountryId{"CH"}}, // Grandvaux railway station
    {Coordinate{6.87, 46.735}, CountryId{"CH"}}, // Q15964135
    {Coordinate{7.06611, 46.8319}, CountryId{"CH"}}, // Q15964136
    {Coordinate{6.64167, 46.8061}, CountryId{"CH"}}, // Grandson
    {Coordinate{7.12528, 46.8167}, CountryId{"CH"}}, // Q15964138
    {Coordinate{6.78111, 46.8992}, CountryId{"CH"}}, // Gorgier-Saint-Aubin
    {Coordinate{7.84389, 47.3303}, CountryId{"CH"}}, // Q15964141
    {Coordinate{8.16667, 47.4286}, CountryId{"CH"}}, // Holderbank railway station
    {Coordinate{8.2075, 47.3894}, CountryId{"CH"}}, // Hendschiken train station
    {Coordinate{8.44972, 47.1692}, CountryId{"CH"}}, // Q15964144
    {Coordinate{8.45028, 47.1736}, CountryId{"CH"}}, // Q15964145
    {Coordinate{8.39417, 47.1208}, CountryId{"CH"}}, // Gisikon-Root station
    {Coordinate{9.6275, 47.4103}, CountryId{"CH"}}, // Heerbrugg Station
    {Coordinate{9.46333, 47.4903}, CountryId{"CH"}}, // Horn station
    {Coordinate{9.46667, 47.4739}, CountryId{"CH"}}, // Goldach station
    {Coordinate{9.2925, 47.6086}, CountryId{"CH"}}, // Güttingen station
    {Coordinate{9.27667, 47.39}, CountryId{"CH"}}, // Herisau railway station
    {Coordinate{7.65556, 47.0161}, CountryId{"CH"}}, // Q15964153
    {Coordinate{7.38944, 47.1917}, CountryId{"CH"}}, // Grenchen Nord railway station
    {Coordinate{7.23444, 46.9422}, CountryId{"CH"}}, // Gümmenen station
    {Coordinate{8.83974, 46.4409}, CountryId{"CH"}}, // Lavorgo railway station
    {Coordinate{6.51736, 46.6588}, CountryId{"CH"}}, // La Sarraz railway station
    {Coordinate{6.67833, 46.5131}, CountryId{"CH"}}, // La Conversion railway station
    {Coordinate{7.06639, 47.0567}, CountryId{"CH"}}, // Le Landeron
    {Coordinate{7.09528, 47.0628}, CountryId{"CH"}}, // La Neuveville
    {Coordinate{7.13476, 47.0837}, CountryId{"CH"}}, // Ligerz
    {Coordinate{7.36667, 47.1794}, CountryId{"CH"}}, // Lengnau railway station
    {Coordinate{7.94222, 47.3072}, CountryId{"CH"}}, // Q15964166
    {Coordinate{8.01917, 47.3247}, CountryId{"CH"}}, // Q15964167
    {Coordinate{8.02653, 47.3372}, CountryId{"CH"}}, // Q15964168
    {Coordinate{9.3175, 47.5956}, CountryId{"CH"}}, // Kesswil railway station
    {Coordinate{8.66222, 47.6833}, CountryId{"CH"}}, // Langwiesen railway station
    {Coordinate{7.78417, 46.9392}, CountryId{"CH"}}, // Langnau im Emmental railway station
    {Coordinate{7.62139, 46.8806}, CountryId{"CH"}}, // Konolfingen Station
    {Coordinate{7.23802, 46.9026}, CountryId{"CH"}}, // Laupen railway station
    {Coordinate{8.85028, 46.1453}, CountryId{"CH"}}, // Q15964178
    {Coordinate{6.50806, 46.5181}, CountryId{"CH"}}, // Morges-St-Jean
    {Coordinate{6.51944, 46.5231}, CountryId{"CH"}}, // Lonay-Préverenges
    {Coordinate{9.17306, 47.1179}, CountryId{"CH"}}, // Mühlehorn railway station
    {Coordinate{9.215, 47.1133}, CountryId{"CH"}}, // Murg station
    {Coordinate{9.27639, 47.1131}, CountryId{"CH"}}, // Mols railway station
    {Coordinate{9.41778, 47.0539}, CountryId{"CH"}}, // Mels railway station
    {Coordinate{6.78583, 46.5086}, CountryId{"CH"}}, // Moreillon railway station
    {Coordinate{6.80278, 46.6681}, CountryId{"CH"}}, // Q15964186
    {Coordinate{7.09639, 46.7889}, CountryId{"CH"}}, // Q15964187
    {Coordinate{7.01167, 46.8283}, CountryId{"CH"}}, // Q15964188
    {Coordinate{7.58351, 47.2171}, CountryId{"CH"}}, // Luterbach-Attisholz railway station
    {Coordinate{8.34, 47.2767}, CountryId{"CH"}}, // Q15964190
    {Coordinate{8.38833, 47.225}, CountryId{"CH"}}, // Q15964191
    {Coordinate{8.9139, 47.6442}, CountryId{"CH"}}, // Mammern railway station
    {Coordinate{9.05278, 47.6736}, CountryId{"CH"}}, // Mannenbach-Salenstein  station
    {Coordinate{9.41444, 47.4747}, CountryId{"CH"}}, // Mörschwil railway station
    {Coordinate{7.8321, 47.2654}, CountryId{"CH"}}, // Murgenthal station
    {Coordinate{7.01083, 47.0092}, CountryId{"CH"}}, // Marin-Epagnier
    {Coordinate{7.30639, 47.0764}, CountryId{"CH"}}, // Lyss Station
    {Coordinate{7.65556, 47.0161}, CountryId{"CH"}}, // Q15964199
    {Coordinate{8.88722, 46.1511}, CountryId{"CH"}}, // Q15964201
    {Coordinate{6.65806, 46.5147}, CountryId{"CH"}}, // Pully-Nord railway station
    {Coordinate{6.76583, 46.4939}, CountryId{"CH"}}, // Puidoux-Chexbres railway station
    {Coordinate{6.83722, 46.5725}, CountryId{"CH"}}, // Oron railway station
    {Coordinate{7.06514, 46.7661}, CountryId{"CH"}}, // Q15964206
    {Coordinate{7.1375, 46.8431}, CountryId{"CH"}}, // Q15964207
    {Coordinate{7.11444, 46.9119}, CountryId{"CH"}}, // Q15964208
    {Coordinate{6.90333, 46.9839}, CountryId{"CH"}}, // Neuchâtel-Serrières
    {Coordinate{7.34028, 47.1714}, CountryId{"CH"}}, // Pieterlen railway station
    {Coordinate{7.77194, 47.3053}, CountryId{"CH"}}, // Oberbuchsiten train station
    {Coordinate{7.8975, 47.3486}, CountryId{"CH"}}, // Q15964212
    {Coordinate{8.40472, 47.1661}, CountryId{"CH"}}, // Q15964213
    {Coordinate{8.13861, 47.1389}, CountryId{"CH"}}, // Q15964214
    {Coordinate{8.11417, 47.1553}, CountryId{"CH"}}, // Q15964215
    {Coordinate{7.9775, 47.1922}, CountryId{"CH"}}, // Nebikon train station
    {Coordinate{7.96876, 47.2415}, CountryId{"CH"}}, // Reiden Station
    {Coordinate{8.04833, 47.3564}, CountryId{"CH"}}, // Oberentfelden railway station
    {Coordinate{8.08222, 47.3714}, CountryId{"CH"}}, // Suhr railway station
    {Coordinate{9.57139, 47.3236}, CountryId{"CH"}}, // Oberriet station
    {Coordinate{9.58667, 47.3925}, CountryId{"CH"}}, // Rebstein-Marbach railway station
    {Coordinate{8.67472, 47.1058}, CountryId{"CH"}}, // Rothenthurm station
    {Coordinate{8.6275, 47.08}, CountryId{"CH"}}, // Sattel-Aegeri station
    {Coordinate{8.97417, 46.1606}, CountryId{"CH"}}, // Sant'Antonino
    {Coordinate{8.80694, 46.135}, CountryId{"CH"}}, // Q15964229
    {Coordinate{7.06208, 46.7825}, CountryId{"CH"}}, // Q15964231
    {Coordinate{6.9825, 47.0147}, CountryId{"CH"}}, // Saint-Blaise CFF
    {Coordinate{8.12694, 47.4033}, CountryId{"CH"}}, // Rupperswil railway station
    {Coordinate{8.27306, 47.0908}, CountryId{"CH"}}, // Q15964235
    {Coordinate{8.24917, 47.0883}, CountryId{"CH"}}, // Q15964236
    {Coordinate{8.37361, 47.1047}, CountryId{"CH"}}, // Q15964237
    {Coordinate{7.98333, 47.3218}, CountryId{"CH"}}, // Q15964238
    {Coordinate{9.48528, 47.15}, CountryId{"CH"}}, // Q15964239
    {Coordinate{9.5025, 47.2417}, CountryId{"CH"}}, // Salez-Sennwald train station
    {Coordinate{9.53611, 47.2867}, CountryId{"CH"}}, // Rüthi SG railway station
    {Coordinate{9.49389, 47.4786}, CountryId{"CH"}}, // Rorschach Hafen station
    {Coordinate{9.48944, 47.4756}, CountryId{"CH"}}, // Rorschach Stadt railway station
    {Coordinate{9.33806, 47.4078}, CountryId{"CH"}}, // St. Gallen Haggen station
    {Coordinate{7.87917, 47.3064}, CountryId{"CH"}}, // Rothrist station
    {Coordinate{7.81472, 47.2517}, CountryId{"CH"}}, // Roggwil-Wynau station
    {Coordinate{6.98472, 47.0119}, CountryId{"CH"}}, // Saint-Blaise-Lac
    {Coordinate{8.60722, 47.0478}, CountryId{"CH"}}, // Steinen station
    {Coordinate{8.58528, 47.0522}, CountryId{"CH"}}, // Steinerberg station
    {Coordinate{6.88528, 46.6592}, CountryId{"CH"}}, // Siviriez railway station
    {Coordinate{7.45667, 47.2006}, CountryId{"CH"}}, // Selzach station
    {Coordinate{8, 47.3714}, CountryId{"CH"}}, // Schönenwerd railway station
    {Coordinate{8.16694, 47.4517}, CountryId{"CH"}}, // Q15964258
    {Coordinate{8.39778, 47.1883}, CountryId{"CH"}}, // Q15964259
    {Coordinate{8.19583, 47.1161}, CountryId{"CH"}}, // Q15964260
    {Coordinate{8.07444, 47.18}, CountryId{"CH"}}, // Q15964261
    {Coordinate{9.49389, 47.1256}, CountryId{"CH"}}, // Sevelen Station
    {Coordinate{9.53639, 47.4808}, CountryId{"CH"}}, // Staad station
    {Coordinate{9.44222, 47.5008}, CountryId{"CH"}}, // Steinach railway station
    {Coordinate{8.98111, 47.6644}, CountryId{"CH"}}, // Steckborn Station
    {Coordinate{8.77036, 47.6669}, CountryId{"CH"}}, // Schlattingen railway station
    {Coordinate{8.73194, 47.6875}, CountryId{"CH"}}, // St. Katharinental railway station
    {Coordinate{8.6875, 47.6794}, CountryId{"CH"}}, // Schlatt railway station
    {Coordinate{8.73444, 47.1976}, CountryId{"CH"}}, // Wilen railway station
    {Coordinate{6.53076, 46.5762}, CountryId{"CH"}}, // Vufflens-la-Ville railway station
    {Coordinate{9.09472, 47.1299}, CountryId{"CH"}}, // Weesen station
    {Coordinate{9.25501, 47.1139}, CountryId{"CH"}}, // Unterterzen railway station
    {Coordinate{9.31306, 47.1197}, CountryId{"CH"}}, // Walenstadt railway station
    {Coordinate{6.91625, 46.78}, CountryId{"CH"}}, // Q15964277
    {Coordinate{6.85014, 46.6214}, CountryId{"CH"}}, // Q15964278
    {Coordinate{6.96056, 46.7206}, CountryId{"CH"}}, // Villaz-Saint-Pierre railway station
    {Coordinate{7.11667, 46.7897}, CountryId{"CH"}}, // Q15964280
    {Coordinate{6.7575, 46.8778}, CountryId{"CH"}}, // Vaumarcus
    {Coordinate{7.15667, 47.0936}, CountryId{"CH"}}, // Twann
    {Coordinate{7.19694, 47.1147}, CountryId{"CH"}}, // Tüscherz
    {Coordinate{7.65639, 47.2319}, CountryId{"CH"}}, // Q15964284
    {Coordinate{7.86861, 47.3414}, CountryId{"CH"}}, // Q15964285
    {Coordinate{8.16306, 47.4156}, CountryId{"CH"}}, // Wildegg railway station
    {Coordinate{8.505, 47.1083}, CountryId{"CH"}}, // Walchwil Hörndli station
    {Coordinate{8.01889, 47.1839}, CountryId{"CH"}}, // Wauwil train station
    {Coordinate{8.51694, 47.0989}, CountryId{"CH"}}, // Walchwil station
    {Coordinate{7.96333, 47.32}, CountryId{"CH"}}, // Q15964290
    {Coordinate{9.48033, 47.0716}, CountryId{"CH"}}, // Q15964291
    {Coordinate{9.50167, 47.0914}, CountryId{"CH"}}, // Q15964292
    {Coordinate{9.34028, 47.5858}, CountryId{"CH"}}, // Uttwil station
    {Coordinate{7.49611, 46.8586}, CountryId{"CH"}}, // Q15964294
    {Coordinate{7.55583, 47.1522}, CountryId{"CH"}}, // Q15964295
    {Coordinate{7.55361, 47.1283}, CountryId{"CH"}}, // Q15964296
    {Coordinate{8.72476, 47.1954}, CountryId{"CH"}}, // Wollerau railway station
    {Coordinate{6.6625, 46.7822}, CountryId{"CH"}}, // Yverdon-Champ Pittet
    {Coordinate{6.74694, 46.8008}, CountryId{"CH"}}, // Yvonand
    {Coordinate{8.48611, 47.1803}, CountryId{"CH"}}, // Q15964302
    {Coordinate{8.48611, 47.1803}, CountryId{"CH"}}, // Q15964303
    {Coordinate{8.51694, 47.1683}, CountryId{"CH"}}, // Q15964304
    {Coordinate{8.515, 47.1622}, CountryId{"CH"}}, // Q15964305
    {Coordinate{8.51222, 47.1564}, CountryId{"CH"}}, // Q15964306
    {Coordinate{9.38861, 47.4631}, CountryId{"CH"}}, // Wittenbach railway station
    {Coordinate{7.46306, 47.0019}, CountryId{"CH"}}, // Zollikofen train station
    {Coordinate{7.37528, 46.5531}, CountryId{"CH"}}, // Zweisimmen railway station
    {Coordinate{9.2409, 51.3234}, CountryId{"DE"}}, // Hofgeismar-Hümme railway station
    {Coordinate{9.4749, 53.5961}, CountryId{"DE"}}, // Stade station
    {Coordinate{30.755, 46.554}, CountryId{"UA"}}, // Odesa-Sortuvalna
    {Coordinate{40.1045, 53.709}, CountryId{"RU"}}, // Ряжск I
    {Coordinate{7.06622, 51.6102}, CountryId{"DE"}}, // Gelsenkirchen-Hassel station
    {Coordinate{7.14182, 50.6964}, CountryId{"DE"}}, // Hochkreuz/Deutsches Museum Bonn
    {Coordinate{7.1005, 51.6541}, CountryId{"DE"}}, // Marl Mitte station
    {Coordinate{7.1311, 51.6826}, CountryId{"DE"}}, // Marl-Hamm station
    {Coordinate{8.66111, 49.2111}, CountryId{"DE"}}, // Bad Schönborn Süd station
    {Coordinate{8.66111, 49.2111}, CountryId{"DE"}}, // Bad Schönborn-Kronau station
    {Coordinate{19.0485, 47.5681}, CountryId{"HU"}}, // Aquincum HÉV station
    {Coordinate{10.6431, 44.6978}, CountryId{"IT"}}, // Reggio Emilia railway station
    {Coordinate{7.817, 49.7272}, CountryId{"DE"}}, // Alsenz station
    {Coordinate{11.7761, 49.87}, CountryId{"DE"}}, // Q16054528
    {Coordinate{8.27426, 49.1196}, CountryId{"DE"}}, // Rheinzabern station
    {Coordinate{12.5741, 48.8773}, CountryId{"DE"}}, // Bahnhof Straubing
    {Coordinate{9.01229, 51.6218}, CountryId{"DE"}}, // Q16054534
    {Coordinate{6.5731, 49.6953}, CountryId{"DE"}}, // Konz
    {Coordinate{6.57368, 49.7001}, CountryId{"DE"}}, // Konz Mitte
    {Coordinate{6.57667, 49.7039}, CountryId{"DE"}}, // Kreuz Konz
    {Coordinate{6.53739, 49.7083}, CountryId{"DE"}}, // Wasserliesch
    {Coordinate{6.57414, 49.6693}, CountryId{"DE"}}, // Kanzem
    {Coordinate{6.68347, 49.7797}, CountryId{"DE"}}, // Pfalzel
    {Coordinate{6.37264, 49.5044}, CountryId{"DE"}}, // Besch
    {Coordinate{6.37606, 49.5388}, CountryId{"DE"}}, // Nennig
    {Coordinate{6.37225, 49.565}, CountryId{"DE"}}, // Palzem
    {Coordinate{6.40665, 49.6084}, CountryId{"DE"}}, // Wincheringen
    {Coordinate{6.44101, 49.654}, CountryId{"DE"}}, // Nittel
    {Coordinate{6.44182, 49.6727}, CountryId{"DE"}}, // Wellen (Mosel) station
    {Coordinate{6.46225, 49.6883}, CountryId{"DE"}}, // Temmels
    {Coordinate{6.5119, 49.7101}, CountryId{"DE"}}, // Oberbillig
    {Coordinate{6.5942, 49.3438}, CountryId{"DE"}}, // Niedaltdorf
    {Coordinate{6.6659, 49.3617}, CountryId{"DE"}}, // Siersburg
    {Coordinate{6.94494, 49.2436}, CountryId{"DE"}}, // Burbach Mitte
    {Coordinate{6.6485, 49.4096}, CountryId{"DE"}}, // Fremersdorf
    {Coordinate{6.55181, 46.5476}, CountryId{"CH"}}, // Bussigny railway station
    {Coordinate{9.02256, 53.0841}, CountryId{"DE"}}, // Sagehorn station
    {Coordinate{9.13356, 53.0969}, CountryId{"DE"}}, // Ottersberg railway station
    {Coordinate{9.25017, 53.1012}, CountryId{"DE"}}, // Sottrum railway station
    {Coordinate{9.5643, 53.197}, CountryId{"DE"}}, // Lauenbrück railway station
    {Coordinate{9.81253, 53.3094}, CountryId{"DE"}}, // Sprötze railway station
    {Coordinate{9.85524, 53.3159}, CountryId{"DE"}}, // Suerhop station
    {Coordinate{9.92919, 53.3661}, CountryId{"DE"}}, // Klecken railway station
    {Coordinate{9.97446, 53.4036}, CountryId{"DE"}}, // Hittfeld railway station
    {Coordinate{12.0684, 60.5592}, CountryId{"NO"}}, // Arneberg Station
    {Coordinate{9.36258, 60.4314}, CountryId{"NO"}}, // Q16169705
    {Coordinate{2.03417, 49.0494}, CountryId{"FR"}}, // Gare de Cergy – Saint-Christophe
    {Coordinate{10.4855, 61.0367}, CountryId{"NO"}}, // Bergseng Station
    {Coordinate{9.33179, 61.9216}, CountryId{"NO"}}, // Brennhaug Station
    {Coordinate{9.75725, 53.5832}, CountryId{"DE"}}, // Rissen
    {Coordinate{9.79757, 53.5811}, CountryId{"DE"}}, // Sülldorf
    {Coordinate{9.81446, 53.5764}, CountryId{"DE"}}, // Iserbrook
    {Coordinate{10.0377, 53.5609}, CountryId{"DE"}}, // Landwehr
    {Coordinate{10.044, 53.5384}, CountryId{"DE"}}, // Rothenburgsort
    {Coordinate{9.76062, 53.6751}, CountryId{"DE"}}, // Prisdorf
    {Coordinate{9.71538, 53.6969}, CountryId{"DE"}}, // Tornesch
    {Coordinate{9.90154, 53.61}, CountryId{"DE"}}, // Eidelstedt Zentrum
    {Coordinate{75.1071, 33.7385}, CountryId{"IN"}}, // Anantnag railway station
    {Coordinate{78.1953, 26.2376}, CountryId{"IN"}}, // Gwalior Birlanagar railway station
    {Coordinate{84.5815, 18.9813}, CountryId{"IN"}}, // Sompeta railway station
    {Coordinate{78.7967, 28.8261}, CountryId{"IN"}}, // Katghar railway station
    {Coordinate{72.9335, 20.6086}, CountryId{"IN"}}, // Valsad railway station
    {Coordinate{11.478, 48.1643}, CountryId{"DE"}}, // München-Obermenzing
    {Coordinate{11.6989, 48.1183}, CountryId{"DE"}}, // Gronsdorf station
    {Coordinate{10.1176, 44.8371}, CountryId{"IT"}}, // Borghetto Parmense railway station
    {Coordinate{11.0961, 44.2469}, CountryId{"IT"}}, // Carbona railway station
    {Coordinate{12.1019, 44.8365}, CountryId{"IT"}}, // Codigoro railway station
    {Coordinate{10.3828, 44.9279}, CountryId{"IT"}}, // Colorno railway station
    {Coordinate{11.8318, 44.5111}, CountryId{"IT"}}, // Q16268787
    {Coordinate{10.8154, 44.9392}, CountryId{"IT"}}, // Gonzaga-Reggiolo railway station
    {Coordinate{10.1402, 44.7493}, CountryId{"IT"}}, // Medesano railway station
    {Coordinate{11.11, 44.5104}, CountryId{"IT"}}, // Muffa railway station
    {Coordinate{10.1471, 44.8099}, CountryId{"IT"}}, // Noceto railway station
    {Coordinate{11.189, 44.3324}, CountryId{"IT"}}, // Pian di Venola railway station
    {Coordinate{11.2295, 44.4882}, CountryId{"IT"}}, // Pilastrino railway station
    {Coordinate{11.4842, 44.7672}, CountryId{"IT"}}, // Poggio Renatico railway station
    {Coordinate{11.2693, 44.423}, CountryId{"IT"}}, // Pontecchio Marconi railway station
    {Coordinate{11.241, 44.4855}, CountryId{"IT"}}, // Riale railway station
    {Coordinate{10.8677, 44.8857}, CountryId{"IT"}}, // Rolo-Novi-Fabbrico railway station
    {Coordinate{11.8258, 44.4903}, CountryId{"IT"}}, // Q16268803
    {Coordinate{11.0332, 44.4832}, CountryId{"IT"}}, // Savignano Comune railway station
    {Coordinate{11.047, 44.494}, CountryId{"IT"}}, // Savignano Mulino railway station
    {Coordinate{10.4463, 44.8432}, CountryId{"IT"}}, // Sorbolo railway station
    {Coordinate{11.5231, 44.4368}, CountryId{"IT"}}, // Varignana railway station
    {Coordinate{11.0085, 44.4817}, CountryId{"IT"}}, // Vignola railway station
    {Coordinate{11.218, 44.4926}, CountryId{"IT"}}, // Zola Centro railway station
    {Coordinate{11.2095, 44.4942}, CountryId{"IT"}}, // Zola Chiesa railway station
    {Coordinate{40.2886, 48.2625}, CountryId{"RU"}}, // Q16271814
    {Coordinate{40.2508, 48.2236}, CountryId{"RU"}}, // Q16271822
    {Coordinate{40.2244, 48.1989}, CountryId{"RU"}}, // Q16271826
    {Coordinate{37.4153, 54.8719}, CountryId{"RU"}}, // Q16271829
    {Coordinate{47.8636, 56.6289}, CountryId{"RU"}}, // Q16271835
    {Coordinate{37.4761, 54.6781}, CountryId{"RU"}}, // Q16271843
    {Coordinate{142.663, 47.0579}, CountryId{"RU"}}, // Q16271848
    {Coordinate{35.7085, 56.0064}, CountryId{"RU"}}, // Q16271850
    {Coordinate{37.6228, 54.5253}, CountryId{"RU"}}, // Q16271868
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16271880
    {Coordinate{37.5811, 54.2308}, CountryId{"RU"}}, // Q16271896
    {Coordinate{31.1125, 59.7578}, CountryId{"RU"}}, // Q16271906
    {Coordinate{38.9431, 55.4444}, CountryId{"RU"}}, // Q16271910
    {Coordinate{39.2803, 57.8121}, CountryId{"RU"}}, // Q16271915
    {Coordinate{43.6692, 56.2589}, CountryId{"RU"}}, // Q16271929
    {Coordinate{31.7983, 59.5247}, CountryId{"RU"}}, // Q16271942
    {Coordinate{31.8442, 59.5025}, CountryId{"RU"}}, // Q16271947
    {Coordinate{53.3405, 56.8377}, CountryId{"RU"}}, // Q16271951
    {Coordinate{85.1111, 56.3892}, CountryId{"RU"}}, // Q16271959
    {Coordinate{142.094, 46.9964}, CountryId{"RU"}}, // Q16271977
    {Coordinate{142.079, 47.0091}, CountryId{"RU"}}, // Q16271986
    {Coordinate{29.1532, 60.2441}, CountryId{"RU"}}, // Q16271992
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16271996
    {Coordinate{53.3911, 53.4143}, CountryId{"RU"}}, // Q16272065
    {Coordinate{55.7689, 54.65}, CountryId{"RU"}}, // Q16272081
    {Coordinate{47.8024, 56.629}, CountryId{"RU"}}, // Q16272545
    {Coordinate{132.058, 43.3333}, CountryId{"RU"}}, // Q16273069
    {Coordinate{33.0696, 68.9724}, CountryId{"RU"}}, // Apatity-1 railway station
    {Coordinate{43.7899, 55.4092}, CountryId{"RU"}}, // Arzamas-I
    {Coordinate{33.7023, 46.1161}, CountryId{"UA"}}, // Armyansk
    {Coordinate{23.3031, 56.5478}, CountryId{"LV"}}, // Q16273440
    {Coordinate{37.66, 54.3244}, CountryId{"RU"}}, // Q16273636
    {Coordinate{36.6625, 55.1789}, CountryId{"RU"}}, // Q16273742
    {Coordinate{43.16, 51.535}, CountryId{"RU"}}, // Q16273755
    {Coordinate{131.957, 43.695}, CountryId{"RU"}}, // Banevurovo
    {Coordinate{89.3054, 56.1228}, CountryId{"RU"}}, // Bogotol
    {Coordinate{104.09, 52.0775}, CountryId{"RU"}}, // Q16274588
    {Coordinate{25.4105, 52.7779}, CountryId{"BY"}}, // Borki
    {Coordinate{52.4838, 54.3114}, CountryId{"RU"}}, // Q16274648
    {Coordinate{30.5675, 52.7126}, CountryId{"BY"}}, // Q16274652
    {Coordinate{32.4655, 58.7274}, CountryId{"RU"}}, // Q16274664
    {Coordinate{8.30536, 49.38}, CountryId{"DE"}}, // Böhl-Iggelheim station
    {Coordinate{8.39066, 49.4242}, CountryId{"DE"}}, // Limburgerhof station
    {Coordinate{11.6602, 48.0757}, CountryId{"DE"}}, // Neubiberg station
    {Coordinate{1.78424, 44.9216}, CountryId{"FR"}}, // Gare de Puybrun
    {Coordinate{27.9589, 56.4307}, CountryId{"LV"}}, // Q16347889
    {Coordinate{26.4917, 55.8765}, CountryId{"LV"}}, // Q16349670
    {Coordinate{24.5774, 57.395}, CountryId{"LV"}}, // Q16353013
    {Coordinate{34.4492, 45.884}, CountryId{"RU"}}, // Solone Ozero
    {Coordinate{1.73379, 44.9429}, CountryId{"FR"}}, // Gare de Bétaille
    {Coordinate{24.7221, 57.5089}, CountryId{"LV"}}, // Q16362569
    {Coordinate{22.35, 56.6977}, CountryId{"LV"}}, // Lutriņi Station
    {Coordinate{23.4097, 56.6025}, CountryId{"LV"}}, // Q16362840
    {Coordinate{33.5981, 44.6072}, CountryId{"RU"}}, // Q16389195
    {Coordinate{}, CountryId{"NO"}}, // Narvik Port
    {Coordinate{13.3165, 46.4453}, CountryId{"IT"}}, // Q16469209
    {Coordinate{133.52, 45.62}, CountryId{"RU"}}, // Prokhasko
    {Coordinate{13.4179, 52.5148}, CountryId{"DE"}}, // Berlin Jannowitzbrücke station
    {Coordinate{12.635, 41.5521}, CountryId{"IT"}}, // Q16482098
    {Coordinate{40.2886, 48.2625}, CountryId{"RU"}}, // Q16484388
    {Coordinate{35.5869, 56.0224}, CountryId{"RU"}}, // Q16484826
    {Coordinate{1.93155, 44.9512}, CountryId{"FR"}}, // Gare de Laval-de-Cère
    {Coordinate{37.4973, 56.4185}, CountryId{"RU"}}, // Imeni Barsuchenko
    {Coordinate{30.4095, 59.0808}, CountryId{"RU"}}, // Q16486682
    {Coordinate{16.0213, 40.5747}, CountryId{"IT"}}, // Q16487703
    {Coordinate{18.347, 39.8921}, CountryId{"IT"}}, // Q16487792
    {Coordinate{104.265, 52.2547}, CountryId{"RU"}}, // Q16487861
    {Coordinate{18.3398, 39.9795}, CountryId{"IT"}}, // Q16488036
    {Coordinate{43.45, 56.2333}, CountryId{"RU"}}, // Q16495703
    {Coordinate{1.84428, 44.9276}, CountryId{"FR"}}, // Gare de Bretenoux - Biars
    {Coordinate{19.0393, 47.5068}, CountryId{"HU"}}, // Batthyány tér HÉV station
    {Coordinate{19.0549, 47.5985}, CountryId{"HU"}}, // Békásmegyer HÉV station
    {Coordinate{4.92156, 44.0053}, CountryId{"FR"}}, // Gare d'Entraigues-sur-la-Sorgue
    {Coordinate{5.04553, 43.7859}, CountryId{"FR"}}, // Q16507943
    {Coordinate{6.53029, 46.7242}, CountryId{"CH"}}, // Q16507967
    {Coordinate{14.84, 66.4458}, CountryId{"NO"}}, // Dunderland Station
    {Coordinate{19.0393, 47.5148}, CountryId{"HU"}}, // Margit híd HÉV station
    {Coordinate{19.0463, 47.5519}, CountryId{"HU"}}, // Filatorigát HÉV station
    {Coordinate{19.0453, 47.5569}, CountryId{"HU"}}, // Kaszásdűlő HÉV station
    {Coordinate{19.0447, 47.5858}, CountryId{"HU"}}, // Csillaghegy HÉV station
    {Coordinate{19.0549, 47.6162}, CountryId{"HU"}}, // Budakalász HÉV station
    {Coordinate{19.0467, 47.6217}, CountryId{"HU"}}, // Budakalász, Lenfonó HÉV station
    {Coordinate{4.95693, 43.9298}, CountryId{"FR"}}, // Q16508003
    {Coordinate{2.83094, 50.3575}, CountryId{"FR"}}, // Gare de Farbus
    {Coordinate{6.5394, 46.5271}, CountryId{"CH"}}, // Q16508009
    {Coordinate{7.06194, 45.7446}, CountryId{"IT"}}, // Q16508010
    {Coordinate{7.12395, 47.2972}, CountryId{"CH"}}, // Bollement Railway Station
    {Coordinate{18.9902, 47.3909}, CountryId{"HU"}}, // Kastélypark railway station
    {Coordinate{19.0401, 47.5273}, CountryId{"HU"}}, // Szépvölgyi út HÉV station
    {Coordinate{19.0442, 47.5336}, CountryId{"HU"}}, // Tímár utca HÉV station
    {Coordinate{19.0472, 47.5397}, CountryId{"HU"}}, // Szentlélek Square HÉV station
    {Coordinate{19.0485, 47.5753}, CountryId{"HU"}}, // Rómaifürdő HÉV station
    {Coordinate{19.0433, 47.6288}, CountryId{"HU"}}, // Szentistvántelep HÉV station
    {Coordinate{19.0324, 47.643}, CountryId{"HU"}}, // Pomáz HÉV station
    {Coordinate{19.065, 47.6523}, CountryId{"HU"}}, // Pannóniatelep HÉV station
    {Coordinate{19.0754, 47.6609}, CountryId{"HU"}}, // Szentendre HÉV station
    {Coordinate{4.99483, 44.0374}, CountryId{"FR"}}, // Gare de Monteux
    {Coordinate{4.87399, 43.9325}, CountryId{"FR"}}, // Gare de Montfavet
    {Coordinate{5.07323, 43.7409}, CountryId{"FR"}}, // Q16508051
    {Coordinate{7.25843, 45.7178}, CountryId{"IT"}}, // Q16508066
    {Coordinate{7.41461, 45.7414}, CountryId{"IT"}}, // Q16508067
    {Coordinate{7.87801, 45.2787}, CountryId{"IT"}}, // Rodallo railway station
    {Coordinate{2.61075, 46.5363}, CountryId{"FR"}}, // Q16508093
    {Coordinate{4.99638, 43.9265}, CountryId{"FR"}}, // Q16508095
    {Coordinate{2.60008, 46.4145}, CountryId{"FR"}}, // Q16508099
    {Coordinate{6.54132, 46.721}, CountryId{"CH"}}, // Les Granges (Orbe) station
    {Coordinate{6.96511, 46.4546}, CountryId{"CH"}}, // Jor railway station
    {Coordinate{19.2712, 47.4872}, CountryId{"HU"}}, // Rákoscsaba-Újtelep railway station
    {Coordinate{18.6722, 47.1247}, CountryId{"HU"}}, // Zichyújfalu railway station
    {Coordinate{53.3405, 56.8377}, CountryId{"RU"}}, // Q16525083
    {Coordinate{-8.31953, 41.4031}, CountryId{"PT"}}, // Q16531603
    {Coordinate{14.683, 49.78}, CountryId{"CZ"}}, // Benešov u Prahy
    {Coordinate{8.6625, 50.1069}, CountryId{"DE"}}, // Frankfurt (Main) Hauptbahnhof
    {Coordinate{15.2745, 49.3567}, CountryId{"CZ"}}, // Q16540362
    {Coordinate{13.8008, 49.2881}, CountryId{"CZ"}}, // Q16540571
    {Coordinate{14.7169, 49.3222}, CountryId{"CZ"}}, // Q16541040
    {Coordinate{13.7774, 51.1282}, CountryId{"DE"}}, // Dresden Grenzstraße railway station
    {Coordinate{14.1353, 49.2367}, CountryId{"CZ"}}, // Q16558037
    {Coordinate{14.4642, 49.0506}, CountryId{"CZ"}}, // Q16558231
    {Coordinate{13.7389, 49.3311}, CountryId{"CZ"}}, // Horažďovice předměstí station
    {Coordinate{14.4667, 49.0344}, CountryId{"CZ"}}, // Q16558520
    {Coordinate{14.4822, 49.0197}, CountryId{"CZ"}}, // Q16558592
    {Coordinate{15.1583, 49.0453}, CountryId{"CZ"}}, // Hůrky
    {Coordinate{13.6656, 49.3697}, CountryId{"CZ"}}, // Jetenovice railway station
    {Coordinate{15.5834, 49.404}, CountryId{"CZ"}}, // Jihlava město (train station)
    {Coordinate{15.4823, 49.3573}, CountryId{"CZ"}}, // Kostelec u Jihlavy (train station)
    {Coordinate{13.6133, 49.4133}, CountryId{"CZ"}}, // Kovčín railway station
    {Coordinate{15.1628, 49.1119}, CountryId{"CZ"}}, // Kunžak-Lomy (train station)
    {Coordinate{14.2203, 49.1728}, CountryId{"CZ"}}, // Q16577340
    {Coordinate{13.6081, 49.4617}, CountryId{"CZ"}}, // Q16577343
    {Coordinate{14.7197, 49.9103}, CountryId{"CZ"}}, // Mirošovice u Prahy
    {Coordinate{14.7072, 49.9326}, CountryId{"CZ"}}, // Mnichovice
    {Coordinate{15.0644, 50.8322}, CountryId{"CZ"}}, // Q16578807
    {Coordinate{13.9758, 49.2564}, CountryId{"CZ"}}, // Q16578843
    {Coordinate{13.6914, 50.7178}, CountryId{"CZ"}}, // Moldava v Krušných horách (train station)
    {Coordinate{34.2942, 45.5022}, CountryId{"UA"}}, // Q16580618
    {Coordinate{13.6103, 49.4383}, CountryId{"CZ"}}, // Nekvasovy railway station
    {Coordinate{14.6042, 49.125}, CountryId{"CZ"}}, // Q16581782
    {Coordinate{34.1786, 45.3525}, CountryId{"UA"}}, // Q16582012
    {Coordinate{13.4186, 49.7244}, CountryId{"CZ"}}, // Plzeň-Koterov station
    {Coordinate{9.64389, 47.9533}, CountryId{"DE"}}, // Aulendorf station
    {Coordinate{15.2124, 49.237}, CountryId{"CZ"}}, // Q16590776
    {Coordinate{13.8489, 49.2581}, CountryId{"CZ"}}, // Q16591052
    {Coordinate{14.6261, 50.0136}, CountryId{"CZ"}}, // Praha-Kolovraty
    {Coordinate{14.4906, 50.0675}, CountryId{"CZ"}}, // Praha-Strašnice zastávka
    {Coordinate{14.5911, 50.0336}, CountryId{"CZ"}}, // Q16591125
    {Coordinate{14.2222, 49.1964}, CountryId{"CZ"}}, // Q16591682
    {Coordinate{14.6972, 49.3794}, CountryId{"CZ"}}, // Q16600722
    {Coordinate{10.4561, 59.8437}, CountryId{"NO"}}, // Høn Station
    {Coordinate{14.1644, 49.2236}, CountryId{"CZ"}}, // Q16601616
    {Coordinate{7.16167, 53.6211}, CountryId{"DE"}}, // Norddeich railway station
    {Coordinate{3.39379, 50.3846}, CountryId{"FR"}}, // Q1660435
    {Coordinate{13.5919, 49.5247}, CountryId{"CZ"}}, // Q16605554
    {Coordinate{15.0253, 50.7886}, CountryId{"CZ"}}, // Q16607735
    {Coordinate{14.0569, 49.2494}, CountryId{"CZ"}}, // Q16607895
    {Coordinate{14.6572, 49.9697}, CountryId{"CZ"}}, // Světice
    {Coordinate{14.4255, 36.9968}, CountryId{"IT"}}, // Acate railway station
    {Coordinate{15.0016, 40.3515}, CountryId{"IT"}}, // Agropoli-Castellabate railway station
    {Coordinate{10.9965, 45.7591}, CountryId{"IT"}}, // Ala railway station
    {Coordinate{11.9444, 45.9026}, CountryId{"IT"}}, // Alano-Fener-Valdobbiadene railway station
    {Coordinate{14.1285, 40.9963}, CountryId{"IT"}}, // Albanova railway station
    {Coordinate{11.4542, 45.5118}, CountryId{"IT"}}, // Altavilla-Tavernelle railway station
    {Coordinate{10.6726, 43.8174}, CountryId{"IT"}}, // Stazione di Altopascio
    {Coordinate{13.5208, 43.5664}, CountryId{"IT"}}, // Q16608740
    {Coordinate{13.4559, 43.6101}, CountryId{"IT"}}, // Q16608743
    {Coordinate{13.8357, 42.0175}, CountryId{"IT"}}, // Anversa-Villalago-Scanno railway station
    {Coordinate{12.6161, 41.4617}, CountryId{"IT"}}, // Q16608749
    {Coordinate{15.1723, 40.141}, CountryId{"IT"}}, // Q16608758
    {Coordinate{9.97055, 44.2097}, CountryId{"IT"}}, // Aulla
    {Coordinate{10.9561, 45.7337}, CountryId{"IT"}}, // Avio railway station
    {Coordinate{15.126, 36.9075}, CountryId{"IT"}}, // Q16608770
    {Coordinate{10.5518, 44.0035}, CountryId{"IT"}}, // Q16608773
    {Coordinate{15.4954, 40.65}, CountryId{"IT"}}, // Q16608776
    {Coordinate{7.81947, 44.722}, CountryId{"IT"}}, // Q16608779
    {Coordinate{10.4521, 44.0681}, CountryId{"IT"}}, // Barga-Gallicano
    {Coordinate{12.1525, 42.2124}, CountryId{"IT"}}, // Q16608802
    {Coordinate{8.57108, 45.8433}, CountryId{"IT"}}, // Belgirate railway station
    {Coordinate{15.8532, 39.6166}, CountryId{"IT"}}, // Q16608814
    {Coordinate{16.6823, 40.3977}, CountryId{"IT"}}, // Bernalda railway station
    {Coordinate{8.28954, 46.0684}, CountryId{"IT"}}, // Q16608820
    {Coordinate{7.28715, 44.8097}, CountryId{"IT"}}, // Q16608823
    {Coordinate{11.4114, 44.9019}, CountryId{"IT"}}, // Bondeno railway station
    {Coordinate{10.9269, 45.6968}, CountryId{"IT"}}, // Borghetto sull'Adige
    {Coordinate{10.5412, 43.9774}, CountryId{"IT"}}, // Borgo a Mozzano
    {Coordinate{16.8574, 38.9341}, CountryId{"IT"}}, // Q16608857
    {Coordinate{7.30837, 44.8256}, CountryId{"IT"}}, // Bricherasio railway station
    {Coordinate{12.7932, 37.9469}, CountryId{"IT"}}, // Q16608863
    {Coordinate{15.3742, 40.6009}, CountryId{"IT"}}, // Q16608869
    {Coordinate{13.8633, 42.0316}, CountryId{"IT"}}, // Bugnara railway station
    {Coordinate{8.26661, 45.4719}, CountryId{"IT"}}, // Buronzo railway station
    {Coordinate{11.9795, 46.04}, CountryId{"IT"}}, // Busche-Lentiai-Mel railway station
    {Coordinate{13.849, 42.1941}, CountryId{"IT"}}, // Q16608882
    {Coordinate{14.1718, 37.1452}, CountryId{"IT"}}, // Butera railway station
    {Coordinate{10.9883, 45.3389}, CountryId{"IT"}}, // Buttapietra
    {Coordinate{12.8561, 37.9389}, CountryId{"IT"}}, // Q16608890
    {Coordinate{10.5321, 44.0199}, CountryId{"IT"}}, // Calavorno
    {Coordinate{9.84164, 45.5328}, CountryId{"IT"}}, // Calcio railway halt
    {Coordinate{11.1698, 45.4144}, CountryId{"IT"}}, // Caldiero railway station
    {Coordinate{16.8192, 39.579}, CountryId{"IT"}}, // Calopezzati Railway Station
    {Coordinate{13.5207, 43.5297}, CountryId{"IT"}}, // Q16608906
    {Coordinate{13.8771, 37.9925}, CountryId{"IT"}}, // Campofelice di Roccella railway station
    {Coordinate{10.3346, 44.1614}, CountryId{"IT"}}, // Camporgiano
    {Coordinate{8.10031, 45.5474}, CountryId{"IT"}}, // Candelo railway halt
    {Coordinate{18.3729, 40.156}, CountryId{"IT"}}, // Q16608936
    {Coordinate{15.0137, 40.4545}, CountryId{"IT"}}, // Capaccio-Roccadaspide railway station
    {Coordinate{15.8742, 39.5584}, CountryId{"IT"}}, // Q16608942
    {Coordinate{16.9236, 41.0492}, CountryId{"IT"}}, // Capurso railway station
    {Coordinate{8.85391, 44.8602}, CountryId{"IT"}}, // Carbonara Scrivia railway station
    {Coordinate{16.952, 39.4968}, CountryId{"IT"}}, // Stazione di Cariati
    {Coordinate{8.21235, 45.4033}, CountryId{"IT"}}, // Carisio railway station
    {Coordinate{8.42286, 45.529}, CountryId{"IT"}}, // Carpignano Sesia railway station
    {Coordinate{8.49034, 45.4912}, CountryId{"IT"}}, // Casaleggio railway station
    {Coordinate{16.9147, 40.9542}, CountryId{"IT"}}, // Casamassima railway station
    {Coordinate{8.85898, 44.7626}, CountryId{"IT"}}, // Cassano Spinola railway station
    {Coordinate{15.1918, 36.9628}, CountryId{"IT"}}, // Q16608984
    {Coordinate{17.1658, 40.8869}, CountryId{"IT"}}, // Castellana Grotte railway station
    {Coordinate{10.455, 44.0901}, CountryId{"IT"}}, // Castelvecchio Pascoli
    {Coordinate{9.80804, 46.1615}, CountryId{"IT"}}, // Castione Andevenno railway station
    {Coordinate{16.4671, 38.344}, CountryId{"IT"}}, // Caulonia railway station
    {Coordinate{15.3946, 40.1028}, CountryId{"IT"}}, // Q16609017
    {Coordinate{12.3914, 44.2007}, CountryId{"IT"}}, // Cesenatico railway station
    {Coordinate{15.9394, 39.5127}, CountryId{"IT"}}, // Q16609028
    {Coordinate{15.1567, 41.9218}, CountryId{"IT"}}, // Q16609034
    {Coordinate{13.3107, 46.4094}, CountryId{"IT"}}, // Chiusaforte railway station
    {Coordinate{12.9429, 42.3879}, CountryId{"IT"}}, // Cittaducale railway station
    {Coordinate{8.68996, 45.8603}, CountryId{"IT"}}, // Cocquio-Trevisago railway station
    {Coordinate{13.7766, 42.0408}, CountryId{"IT"}}, // Q16609064
    {Coordinate{13.6293, 42.0604}, CountryId{"IT"}}, // Collarmele train station
    {Coordinate{11.4416, 46.9381}, CountryId{"IT"}}, // Colle Isarco railway station
    {Coordinate{8.56611, 45.7143}, CountryId{"IT"}}, // Comignago railway station
    {Coordinate{14.6005, 36.9472}, CountryId{"IT"}}, // Comiso railway station
    {Coordinate{15.5356, 38.1503}, CountryId{"IT"}}, // Q16609084
    {Coordinate{17.1153, 40.9711}, CountryId{"IT"}}, // Conversano railway station
    {Coordinate{16.5148, 39.6281}, CountryId{"IT"}}, // Corigliano Calabro railway station
    {Coordinate{18.2624, 40.1618}, CountryId{"IT"}}, // Q16609096
    {Coordinate{12.0127, 45.8338}, CountryId{"IT"}}, // Cornuda railway station
    {Coordinate{9.52521, 46.1355}, CountryId{"IT"}}, // Cosio-Traona railway station
    {Coordinate{8.49826, 45.6463}, CountryId{"IT"}}, // Q16609111
    {Coordinate{16.8134, 38.9221}, CountryId{"IT"}}, // Q16609117
    {Coordinate{17.0406, 39.4496}, CountryId{"IT"}}, // Q16609120
    {Coordinate{8.4566, 45.6725}, CountryId{"IT"}}, // Cureggio railway station
    {Coordinate{16.9639, 39.0259}, CountryId{"IT"}}, // Q16609129
    {Coordinate{9.46128, 46.1386}, CountryId{"IT"}}, // Delebio railway station
    {Coordinate{10.5077, 43.9596}, CountryId{"IT"}}, // Q16609140
    {Coordinate{14.5689, 36.8822}, CountryId{"IT"}}, // Donnafugata railway station
    {Coordinate{8.58222, 45.7234}, CountryId{"IT"}}, // Dormelletto railway halt
    {Coordinate{10.3294, 46.177}, CountryId{"IT"}}, // Edolo
    {Coordinate{11.2574, 46.3194}, CountryId{"IT"}}, // Egna-Termeno railway station
    {Coordinate{9.06296, 39.2572}, CountryId{"IT"}}, // Elmas Aeroporto railway station
    {Coordinate{14.0526, 37.1135}, CountryId{"IT"}}, // Falconara railway station
    {Coordinate{11.9919, 45.7083}, CountryId{"IT"}}, // Fanzolo railway station
    {Coordinate{8.86285, 45.1119}, CountryId{"IT"}}, // Ferrera Lomellina railway halt
    {Coordinate{14.8089, 37.3112}, CountryId{"IT"}}, // Q16609182
    {Coordinate{13.7749, 37.9666}, CountryId{"IT"}}, // Fiumetorto railway station
    {Coordinate{13.4249, 41.3378}, CountryId{"IT"}}, // Fondi-Sperlonga railway station
    {Coordinate{10.4733, 44.0454}, CountryId{"IT"}}, // Fornaci di Barga
    {Coordinate{11.6103, 46.7889}, CountryId{"IT"}}, // Fortezza railway station
    {Coordinate{10.4443, 44.1187}, CountryId{"IT"}}, // Fosciandora-Ceserana
    {Coordinate{15.6245, 40.6786}, CountryId{"IT"}}, // Q16609213
    {Coordinate{16.0118, 39.4097}, CountryId{"IT"}}, // Fuscaldo railway station
    {Coordinate{18.3573, 39.8505}, CountryId{"IT"}}, // Gagliano Leuca railway station
    {Coordinate{11.6711, 44.7781}, CountryId{"IT"}}, // Gaibanella railway station
    {Coordinate{15.5054, 38.1046}, CountryId{"IT"}}, // Q16609231
    {Coordinate{11.8277, 45.6528}, CountryId{"IT"}}, // Q16609236
    {Coordinate{17.9883, 40.0574}, CountryId{"IT"}}, // Gallipoli railway station
    {Coordinate{8.36467, 45.6114}, CountryId{"IT"}}, // Gattinara railway station
    {Coordinate{8.37946, 45.5261}, CountryId{"IT"}}, // Ghislarengo railway halt
    {Coordinate{10.5103, 44.0278}, CountryId{"IT"}}, // Q16609254
    {Coordinate{15.4797, 38.0639}, CountryId{"IT"}}, // Giampilieri railway station
    {Coordinate{18.4395, 40.1428}, CountryId{"IT"}}, // Q16609260
    {Coordinate{13.7829, 42.0827}, CountryId{"IT"}}, // Q16609265
    {Coordinate{8.44057, 45.7446}, CountryId{"IT"}}, // Gozzano railway station
    {Coordinate{16.2408, 40.5931}, CountryId{"IT"}}, // Grassano-Garaguso railway station
    {Coordinate{8.42863, 45.9341}, CountryId{"IT"}}, // Gravellona Toce railway station
    {Coordinate{8.33367, 45.6828}, CountryId{"IT"}}, // Q16609279
    {Coordinate{15.8212, 39.7398}, CountryId{"IT"}}, // Q16609282
    {Coordinate{17.4244, 40.5291}, CountryId{"IT"}}, // Q16609285
    {Coordinate{9.8629, 45.6342}, CountryId{"IT"}}, // Grumello del Monte railway station
    {Coordinate{16.5744, 38.4372}, CountryId{"IT"}}, // Guardavalle railway station
    {Coordinate{14.9142, 36.7782}, CountryId{"IT"}}, // Q16609304
    {Coordinate{8.62113, 45.8117}, CountryId{"IT"}}, // Ispra railway station
    {Coordinate{11.1824, 46.6074}, CountryId{"IT"}}, // Stazione di Lana-Postal
    {Coordinate{13.9288, 38.0116}, CountryId{"IT"}}, // Lascari-Gratteri railway station
    {Coordinate{7.94153, 44.3857}, CountryId{"IT"}}, // Q16609340
    {Coordinate{12.626, 41.5006}, CountryId{"IT"}}, // Q16609347
    {Coordinate{9.30283, 45.9609}, CountryId{"IT"}}, // Lierna railway station
    {Coordinate{8.79912, 45.1174}, CountryId{"IT"}}, // Lomello railway station
    {Coordinate{10.4872, 45.4575}, CountryId{"IT"}}, // Lonato railway station
    {Coordinate{13.6203, 43.4481}, CountryId{"IT"}}, // Q16609362
    {Coordinate{7.24765, 44.8158}, CountryId{"IT"}}, // Luserna San Giovanni train station
    {Coordinate{7.7477, 44.6954}, CountryId{"IT"}}, // Q16609371
    {Coordinate{7.77686, 44.4466}, CountryId{"IT"}}, // Magliano-Crava-Morozzo railway station
    {Coordinate{18.2997, 40.1258}, CountryId{"IT"}}, // Maglie railway station
    {Coordinate{11.1824, 45.0022}, CountryId{"IT"}}, // Magnacavallo railway station
    {Coordinate{16.8931, 39.5253}, CountryId{"IT"}}, // Q16609385
    {Coordinate{12.1348, 42.1282}, CountryId{"IT"}}, // Manziana-Canale Monterano
    {Coordinate{15.8229, 39.7669}, CountryId{"IT"}}, // Marcellina-Verbicaro-Orsomarso station
    {Coordinate{}, CountryId{"IT"}}, // Masserano railway station
    {Coordinate{8.74251, 45.0951}, CountryId{"IT"}}, // Mede railway halt
    {Coordinate{8.53576, 45.7945}, CountryId{"IT"}}, // Meina railway station
    {Coordinate{18.2772, 40.1479}, CountryId{"IT"}}, // Q16609411
    {Coordinate{8.44101, 45.9615}, CountryId{"IT"}}, // Mergozzo railway station
    {Coordinate{18.3232, 39.9644}, CountryId{"IT"}}, // Q16609421
    {Coordinate{8.93015, 44.5389}, CountryId{"IT"}}, // Mignanego railway station
    {Coordinate{15.5181, 38.1244}, CountryId{"IT"}}, // Q16609427
    {Coordinate{9.45005, 45.162}, CountryId{"IT"}}, // Miradolo Terme railway station
    {Coordinate{16.7773, 39.6047}, CountryId{"IT"}}, // Q16609433
    {Coordinate{13.3471, 41.3461}, CountryId{"IT"}}, // Monte San Biagio-Terracina Mare railway station
    {Coordinate{17.3615, 40.5237}, CountryId{"IT"}}, // Q16609452
    {Coordinate{13.3466, 43.6513}, CountryId{"IT"}}, // Q16609458
    {Coordinate{7.96495, 44.7038}, CountryId{"IT"}}, // Q16609461
    {Coordinate{10.2393, 45.4513}, CountryId{"IT"}}, // Q16609464
    {Coordinate{9.56869, 46.1366}, CountryId{"IT"}}, // Morbegno railway station
    {Coordinate{7.53043, 44.7655}, CountryId{"IT"}}, // Moretta railway station
    {Coordinate{18.3349, 40.0988}, CountryId{"IT"}}, // Q16609478
    {Coordinate{8.01667, 44.7134}, CountryId{"IT"}}, // Q16609481
    {Coordinate{17.2577, 40.5082}, CountryId{"IT"}}, // Q16609484
    {Coordinate{8.55804, 45.4814}, CountryId{"IT"}}, // Nibbia railway halt
    {Coordinate{8.67129, 45.2756}, CountryId{"IT"}}, // Nicorvo railway halt
    {Coordinate{12.7668, 43.1007}, CountryId{"IT"}}, // Q16609494
    {Coordinate{16.6439, 40.1304}, CountryId{"IT"}}, // Nova Siri-Rotondella railway station
    {Coordinate{8.41313, 45.8719}, CountryId{"IT"}}, // Omegna railway station
    {Coordinate{15.1345, 40.2527}, CountryId{"IT"}}, // Q16609521
    {Coordinate{11.2972, 46.361}, CountryId{"IT"}}, // Ora railway station
    {Coordinate{8.42125, 45.7959}, CountryId{"IT"}}, // Orta-Miasino railway station
    {Coordinate{13.5471, 43.4968}, CountryId{"IT"}}, // Q16609534
    {Coordinate{7.72066, 43.7999}, CountryId{"IT"}}, // Ospedaletti Ligure railway station
    {Coordinate{10.0745, 45.546}, CountryId{"IT"}}, // Ospitaletto-Travagliato railway station
    {Coordinate{18.4816, 40.1495}, CountryId{"IT"}}, // Otranto railway station
    {Coordinate{12.6293, 41.5136}, CountryId{"IT"}}, // Q16609551
    {Coordinate{17.0591, 40.5172}, CountryId{"IT"}}, // Palagiona-Chiatona railway station
    {Coordinate{14.8925, 37.3182}, CountryId{"IT"}}, // Q16609557
    {Coordinate{15.9901, 40.9392}, CountryId{"IT"}}, // Palazzo San Gervasio-Montemilone
    {Coordinate{8.26058, 46.0436}, CountryId{"IT"}}, // Q16609566
    {Coordinate{13.4298, 43.6171}, CountryId{"IT"}}, // Q16609569
    {Coordinate{13.8443, 43.094}, CountryId{"IT"}}, // Q16609574
    {Coordinate{10.9006, 45.6583}, CountryId{"IT"}}, // Peri railway station
    {Coordinate{13.669, 42.0374}, CountryId{"IT"}}, // Pescina railway station
    {Coordinate{10.5027, 43.9372}, CountryId{"IT"}}, // Piaggione
    {Coordinate{13.9516, 42.2544}, CountryId{"IT"}}, // Piano d'Orta Bolognano railway station
    {Coordinate{15.6417, 40.6403}, CountryId{"IT"}}, // railway station of Picerno
    {Coordinate{8.26106, 46.0244}, CountryId{"IT"}}, // Q16609602
    {Coordinate{15.7921, 40.7533}, CountryId{"IT"}}, // Q16609605
    {Coordinate{8.95968, 45.1162}, CountryId{"IT"}}, // Pieve Albignola railway halt
    {Coordinate{8.27625, 46.0098}, CountryId{"IT"}}, // Q16609611
    {Coordinate{12.4102, 43.0951}, CountryId{"IT"}}, // Q16609613
    {Coordinate{15.2435, 40.0914}, CountryId{"IT"}}, // Q16609617
    {Coordinate{16.5521, 40.4207}, CountryId{"IT"}}, // Q16609621
    {Coordinate{7.89254, 44.7011}, CountryId{"IT"}}, // Q16609623
    {Coordinate{18.3705, 40.0517}, CountryId{"IT"}}, // Q16609629
    {Coordinate{10.3506, 44.1485}, CountryId{"IT"}}, // Poggio-Careggine-Vagli
    {Coordinate{16.2669, 40.9351}, CountryId{"IT"}}, // Poggiorsini railway station
    {Coordinate{16.0839, 38.4071}, CountryId{"IT"}}, // Polistena railway station
    {Coordinate{8.63684, 45.6496}, CountryId{"IT"}}, // Q16609641
    {Coordinate{15.3901, 40.6087}, CountryId{"IT"}}, // Q16609644
    {Coordinate{10.4092, 45.4739}, CountryId{"IT"}}, // Ponte San Marco-Calcinato railway station
    {Coordinate{15.5028, 38.0961}, CountryId{"IT"}}, // Q16609651
    {Coordinate{15.4943, 38.0809}, CountryId{"IT"}}, // Q16609654
    {Coordinate{10.3873, 44.1327}, CountryId{"IT"}}, // Pontecosi
    {Coordinate{13.6617, 43.4338}, CountryId{"IT"}}, // Q16609672
    {Coordinate{13.7602, 43.2566}, CountryId{"IT"}}, // Q16609674
    {Coordinate{15.7771, 40.7811}, CountryId{"IT"}}, // Possidente railway station
    {Coordinate{12.1484, 45.716}, CountryId{"IT"}}, // Q16609682
    {Coordinate{13.698, 43.3602}, CountryId{"IT"}}, // Q16609685
    {Coordinate{14.8472, 36.7335}, CountryId{"IT"}}, // Pozzallo railway station
    {Coordinate{8.37042, 45.6464}, CountryId{"IT"}}, // Q16609697
    {Coordinate{8.32718, 46.0024}, CountryId{"IT"}}, // Premosello-Chiovenda railway station
    {Coordinate{13.8345, 42.0537}, CountryId{"IT"}}, // Prezza railway station
    {Coordinate{8.26655, 45.7635}, CountryId{"IT"}}, // Q16609706
    {Coordinate{11.92, 45.9396}, CountryId{"IT"}}, // Quero-Vas railway station
    {Coordinate{13.2147, 46.3945}, CountryId{"IT"}}, // Resiutta railway station
    {Coordinate{16.5281, 38.3892}, CountryId{"IT"}}, // Q16609720
    {Coordinate{11.6698, 46.7972}, CountryId{"IT"}}, // Rio di Pusteria
    {Coordinate{8.59703, 45.2934}, CountryId{"IT"}}, // Robbio railway station
    {Coordinate{16.9005, 38.9423}, CountryId{"IT"}}, // Q16609729
    {Coordinate{16.5744, 38.4372}, CountryId{"IT"}}, // Q16609738
    {Coordinate{15.4476, 40.6102}, CountryId{"IT"}}, // Q16609744
    {Coordinate{9.75352, 45.5238}, CountryId{"IT"}}, // Romano railway station
    {Coordinate{14.9528, 36.8161}, CountryId{"IT"}}, // Q16609750
    {Coordinate{16.6408, 39.6029}, CountryId{"IT"}}, // Q16609753
    {Coordinate{11.7849, 45.7022}, CountryId{"IT"}}, // Q16609756
    {Coordinate{17.0084, 41.0116}, CountryId{"IT"}}, // Rutigliano railway station
    {Coordinate{16.3515, 40.5834}, CountryId{"IT"}}, // Q16609768
    {Coordinate{8.08233, 44.3963}, CountryId{"IT"}}, // Q16609770
    {Coordinate{8.17278, 44.4045}, CountryId{"IT"}}, // Q16609777
    {Coordinate{11.2029, 46.2457}, CountryId{"IT"}}, // Salorno railway station
    {Coordinate{14.7446, 36.732}, CountryId{"IT"}}, // Q16609786
    {Coordinate{11.2742, 45.4024}, CountryId{"IT"}}, // San Bonifacio railway station
    {Coordinate{14.1721, 40.9923}, CountryId{"IT"}}, // San Marcellino-Frignano railway station
    {Coordinate{12.1082, 42.382}, CountryId{"IT"}}, // Q16609814
    {Coordinate{15.4883, 38.0712}, CountryId{"IT"}}, // Q16609817
    {Coordinate{11.0175, 44.9971}, CountryId{"IT"}}, // San Rocco Mantovano railway station
    {Coordinate{18.3474, 40.0836}, CountryId{"IT"}}, // Q16609832
    {Coordinate{8.08119, 45.5195}, CountryId{"IT"}}, // Q16609835
    {Coordinate{8.90513, 45.1055}, CountryId{"IT"}}, // Sannazzaro railway station
    {Coordinate{12.3292, 46.0939}, CountryId{"IT"}}, // Santa Croce del Lago railway station
    {Coordinate{12.043, 46.0778}, CountryId{"IT"}}, // Santa Giustina-Cesio railway station
    {Coordinate{7.91608, 44.6959}, CountryId{"IT"}}, // Q16609856
    {Coordinate{8.4932, 44.3098}, CountryId{"IT"}}, // Q16609869
    {Coordinate{13.9983, 42.2674}, CountryId{"IT"}}, // Q16609875
    {Coordinate{15.8012, 39.8082}, CountryId{"IT"}}, // Q16609878
    {Coordinate{16.7054, 40.2536}, CountryId{"IT"}}, // Scanzano Jonico-Montalbano Jonico railway station
    {Coordinate{14.6989, 36.7899}, CountryId{"IT"}}, // Q16609884
    {Coordinate{12.8282, 37.9495}, CountryId{"IT"}}, // Q16609890
    {Coordinate{16.7647, 38.9039}, CountryId{"IT"}}, // Q16609893
    {Coordinate{11.0153, 45.8083}, CountryId{"IT"}}, // Serravalle all'Adige railway station
    {Coordinate{8.44502, 45.5213}, CountryId{"IT"}}, // Q16609905
    {Coordinate{8.57907, 45.5396}, CountryId{"IT"}}, // Q16609916
    {Coordinate{7.77725, 44.7708}, CountryId{"IT"}}, // Sommariva del Bosco train station
    {Coordinate{8.86516, 44.7194}, CountryId{"IT"}}, // Stazzano-Serravalle railway station
    {Coordinate{17.1081, 39.2281}, CountryId{"IT"}}, // Q16609932
    {Coordinate{10.5705, 43.8342}, CountryId{"IT"}}, // Tassignano-Capannori
    {Coordinate{9.95958, 44.2373}, CountryId{"IT"}}, // Stazione di Terrarossa-Tresana
    {Coordinate{18.3579, 39.9047}, CountryId{"IT"}}, // Q16609958
    {Coordinate{13.9047, 42.2267}, CountryId{"IT"}}, // Q16609961
    {Coordinate{7.57121, 45.0311}, CountryId{"IT"}}, // Q16609964
    {Coordinate{17.1083, 39.3044}, CountryId{"IT"}}, // Q16609970
    {Coordinate{15.4812, 40.0991}, CountryId{"IT"}}, // Q16609973
    {Coordinate{7.22602, 44.819}, CountryId{"IT"}}, // Q16609976
    {Coordinate{13.9375, 42.244}, CountryId{"IT"}}, // Q16609978
    {Coordinate{16.7073, 39.6075}, CountryId{"IT"}}, // Q16609984
    {Coordinate{15.5269, 38.1381}, CountryId{"IT"}}, // Q16609990
    {Coordinate{12.1038, 45.7474}, CountryId{"IT"}}, // Q16609993
    {Coordinate{18.3526, 39.9334}, CountryId{"IT"}}, // Q16609996
    {Coordinate{16.9164, 41.0642}, CountryId{"IT"}}, // Triggiano railway station
    {Coordinate{15.9978, 40.5886}, CountryId{"IT"}}, // Q16610005
    {Coordinate{15.1584, 40.2296}, CountryId{"IT"}}, // Q16610017
    {Coordinate{8.25926, 45.8143}, CountryId{"IT"}}, // Varallo Sesia railway station
    {Coordinate{13.5232, 43.5748}, CountryId{"IT"}}, // Varano railway station
    {Coordinate{8.88709, 45.7773}, CountryId{"IT"}}, // Vedano Olona railway station
    {Coordinate{8.89507, 45.7367}, CountryId{"IT"}}, // Venegono Inferiore railway station
    {Coordinate{8.89025, 45.7581}, CountryId{"IT"}}, // Venegono Superiore-Castiglione railway station
    {Coordinate{10.332, 45.3738}, CountryId{"IT"}}, // Viadana Bresciana railway station
    {Coordinate{7.89567, 44.3738}, CountryId{"IT"}}, // Vicoforte-San Michele train station
    {Coordinate{12.6171, 41.4844}, CountryId{"IT"}}, // Q16610056
    {Coordinate{8.26455, 46.0642}, CountryId{"IT"}}, // Villadossola railway station
    {Coordinate{10.3678, 44.1469}, CountryId{"IT"}}, // Villetta San Romano
    {Coordinate{11.4402, 46.8957}, CountryId{"IT"}}, // Vipiteno-Val di Vizze railway station
    {Coordinate{10.3633, 45.3154}, CountryId{"IT"}}, // Q16610082
    {Coordinate{14.525, 36.9587}, CountryId{"IT"}}, // Vittoria railway station
    {Coordinate{8.29471, 46.0058}, CountryId{"IT"}}, // Q16610090
    {Coordinate{11.9361, 44.5404}, CountryId{"IT"}}, // Q16610093
    {Coordinate{12.3163, 46.1373}, CountryId{"IT"}}, // Q16610191
    {Coordinate{14.7775, 49.0072}, CountryId{"CZ"}}, // Q16612371
    {Coordinate{13.7011, 49.3458}, CountryId{"CZ"}}, // Q16613294
    {Coordinate{14.6961, 49.1772}, CountryId{"CZ"}}, // Q16613337
    {Coordinate{14.3267, 49.0894}, CountryId{"CZ"}}, // Q16619732
    {Coordinate{13.5169, 49.6064}, CountryId{"CZ"}}, // Q16619830
    {Coordinate{14.9692, 49.6894}, CountryId{"CZ"}}, // Zdislavice
    {Coordinate{14.2647, 49.1247}, CountryId{"CZ"}}, // Q16620772
    {Coordinate{14.2733, 49.3717}, CountryId{"CZ"}}, // Q16621016
    {Coordinate{14.6125, 49.5583}, CountryId{"CZ"}}, // Q16621018
    {Coordinate{14.714, 49.8685}, CountryId{"CZ"}}, // Čtyřkoly
    {Coordinate{14.7242, 49.2242}, CountryId{"CZ"}}, // Q16621533
    {Coordinate{13.5033, 49.6692}, CountryId{"CZ"}}, // Šťáhlavy (train station)
    {Coordinate{13.5736, 49.5506}, CountryId{"CZ"}}, // Q16622440
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16629882
    {Coordinate{48.1601, 52.7132}, CountryId{"RU"}}, // Q16631178
    {Coordinate{5.3675, 43.3134}, CountryId{"FR"}}, // Q16638550
    {Coordinate{-0.607064, 43.1792}, CountryId{"FR"}}, // Q16638563
    {Coordinate{2.19281, 44.9641}, CountryId{"FR"}}, // Q16638572
    {Coordinate{-0.604883, 43.1207}, CountryId{"FR"}}, // Q16638575
    {Coordinate{1.3976, 45.3131}, CountryId{"FR"}}, // Gare de Vignols-St-Solve
    {Coordinate{1.42965, 45.2158}, CountryId{"FR"}}, // Gare de Le Burg
    {Coordinate{131.374, 44.4064}, CountryId{"RU"}}, // Grodekovo
    {Coordinate{43.45, 56.2333}, CountryId{"RU"}}, // Q16643982
    {Coordinate{39.4477, 54.8217}, CountryId{"RU"}}, // Q16644117
    {Coordinate{25.4742, 52.8288}, CountryId{"BY"}}, // Damanava
    {Coordinate{33.4986, 53.6897}, CountryId{"RU"}}, // Q16646722
    {Coordinate{38.1253, 53.15}, CountryId{"RU"}}, // Q16650766
    {Coordinate{32.2694, 55.8514}, CountryId{"RU"}}, // Q16651249
    {Coordinate{31.6419, 59.5656}, CountryId{"RU"}}, // Q16651331
    {Coordinate{94.4159, 55.5716}, CountryId{"RU"}}, // Zaozyorny train station
    {Coordinate{40.115, 48.0203}, CountryId{"RU"}}, // Q16653670
    {Coordinate{106.504, 56.7462}, CountryId{"RU"}}, // Q16653716
    {Coordinate{40.304, 46.8465}, CountryId{"RU"}}, // Zernograd
    {Coordinate{11.5933, 50.8838}, CountryId{"DE"}}, // Jena-Göschwitz station
    {Coordinate{40.2531, 52.6328}, CountryId{"RU"}}, // Q16655143
    {Coordinate{80.1956, 44.1371}, CountryId{"KZ"}}, // Yintal railway station
    {Coordinate{96.0711, 56.2394}, CountryId{"RU"}}, // Ilanskaya train station
    {Coordinate{42.9167, 45.7072}, CountryId{"RU"}}, // Q16656069
    {Coordinate{69.5126, 56.112}, CountryId{"RU"}}, // Ishim station
    {Coordinate{53.3405, 56.8377}, CountryId{"RU"}}, // Q16656563
    {Coordinate{15.2136, 50.025}, CountryId{"CZ"}}, // Kolín train station
    {Coordinate{76.5129, 9.18259}, CountryId{"IN"}}, // Kayamkulam Junction railway station
    {Coordinate{37.5146, 56.3844}, CountryId{"RU"}}, // Kanalstroy
    {Coordinate{95.4202, 56.1155}, CountryId{"RU"}}, // Kansk train station
    {Coordinate{42.7717, 43.9619}, CountryId{"RU"}}, // Q16661998
    {Coordinate{41.3236, 54.8958}, CountryId{"RU"}}, // Q16662206
    {Coordinate{44.1625, 56.6523}, CountryId{"RU"}}, // Q16663003
    {Coordinate{51.505, 56.2802}, CountryId{"RU"}}, // Q16663312
    {Coordinate{131.924, 43.4721}, CountryId{"RU"}}, // Q16663489
    {Coordinate{107.455, 56.1794}, CountryId{"RU"}}, // Q16663546
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16663645
    {Coordinate{44.0434, 56.4735}, CountryId{"RU"}}, // Q16663694
    {Coordinate{103.876, 52.5989}, CountryId{"RU"}}, // Kitoy station
    {Coordinate{52.3469, 58.1761}, CountryId{"RU"}}, // Q16664469
    {Coordinate{33.0503, 68.8883}, CountryId{"RU"}}, // Q16664670
    {Coordinate{35.1332, 55.5304}, CountryId{"RU"}}, // Q16664696
    {Coordinate{43.45, 56.2333}, CountryId{"RU"}}, // Q16665322
    {Coordinate{48.1917, 58.1908}, CountryId{"RU"}}, // Kotelnich I railway station
    {Coordinate{46.6528, 61.2117}, CountryId{"RU"}}, // Q16666452
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16666512
    {Coordinate{57.9851, 55.0111}, CountryId{"RU"}}, // Q16667393
    {Coordinate{47.811, 52.598}, CountryId{"RU"}}, // Q16668591
    {Coordinate{43.8678, 56.2591}, CountryId{"RU"}}, // Kustovaya
    {Coordinate{37.4183, 56.7699}, CountryId{"RU"}}, // Q16670303
    {Coordinate{105.951, 56.809}, CountryId{"RU"}}, // Q16670672
    {Coordinate{105.741, 56.7808}, CountryId{"RU"}}, // Q16670677
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16670942
    {Coordinate{38.4341, 55.1677}, CountryId{"RU"}}, // Q16670989
    {Coordinate{44.1018, 56.6127}, CountryId{"RU"}}, // Q16671349
    {Coordinate{32.9853, 53.8914}, CountryId{"RU"}}, // Q16671472
    {Coordinate{33.556, 60.7281}, CountryId{"RU"}}, // Q16671932
    {Coordinate{38.7425, 54.5383}, CountryId{"RU"}}, // Q16672216
    {Coordinate{36.1, 52.9319}, CountryId{"RU"}}, // Q16672319
    {Coordinate{36.4805, 55.0058}, CountryId{"RU"}}, // Q16673847
    {Coordinate{36.2163, 56.0183}, CountryId{"RU"}}, // Q16674812
    {Coordinate{52.2057, 56.4465}, CountryId{"RU"}}, // Q16677287
    {Coordinate{44.0732, 56.3572}, CountryId{"RU"}}, // Mohovye Gory station
    {Coordinate{105.863, 51.7187}, CountryId{"RU"}}, // Mysovaya railway station
    {Coordinate{71.2109, 55.3405}, CountryId{"RU"}}, // Nazyvaevskaya station
    {Coordinate{124.757, 56.65}, CountryId{"RU"}}, // Q16680396
    {Coordinate{99.0125, 54.5343}, CountryId{"RU"}}, // Nizhneudinsk train station
    {Coordinate{43.854, 56.2859}, CountryId{"RU"}}, // Nizhny Novgorod sorting
    {Coordinate{39.2228, 51.3114}, CountryId{"RU"}}, // Q16681310
    {Coordinate{132.019, 45.1002}, CountryId{"RU"}}, // Q16681385
    {Coordinate{59.5925, 56.0167}, CountryId{"RU"}}, // Q16681950
    {Coordinate{45.0122, 53.2042}, CountryId{"RU"}}, // Q16685336
    {Coordinate{45.0328, 53.1847}, CountryId{"RU"}}, // Q16685338
    {Coordinate{41.9564, 52.7167}, CountryId{"RU"}}, // Q16686496
    {Coordinate{103.457, 56.4598}, CountryId{"RU"}}, // Q16686497
    {Coordinate{87.3263, 53.9016}, CountryId{"RU"}}, // Q16686898
    {Coordinate{30.6363, 46.3834}, CountryId{"UA"}}, // 13 km
    {Coordinate{33.2309, 49.9928}, CountryId{"UA"}}, // 200 km
    {Coordinate{30.591, 46.3466}, CountryId{"UA"}}, // 22 km
    {Coordinate{33.386, 48.9959}, CountryId{"UA"}}, // 270 km
    {Coordinate{32.2409, 46.9811}, CountryId{"UA"}}, // 44 km
    {Coordinate{33.2419, 47.8575}, CountryId{"UA"}}, // 6 km
    {Coordinate{32.0467, 49.4845}, CountryId{"UA"}}, // 882 km
    {Coordinate{32.0197, 49.3986}, CountryId{"UA"}}, // 894 km
    {Coordinate{31.996, 49.3699}, CountryId{"UA"}}, // 898 km
    {Coordinate{40.0908, 48.0619}, CountryId{"RU"}}, // Q16687943
    {Coordinate{32.8193, 47.0927}, CountryId{"UA"}}, // Q16689312
    {Coordinate{30.5993, 48.3388}, CountryId{"UA"}}, // Yemylivka
    {Coordinate{30.2697, 46.7192}, CountryId{"UA"}}, // Yeremiivka
    {Coordinate{36.5583, 56.5042}, CountryId{"RU"}}, // Q16689629
    {Coordinate{38.0947, 56.1156}, CountryId{"RU"}}, // Putilovo
    {Coordinate{32.8595, 47.0357}, CountryId{"UA"}}, // Q16689659
    {Coordinate{29.9387, 47.1821}, CountryId{"UA"}}, // Ivanivka
    {Coordinate{24.0581, 50.8285}, CountryId{"UA"}}, // Q16689895
    {Coordinate{30.6293, 46.3223}, CountryId{"UA"}}, // Q16689983
    {Coordinate{23.0455, 48.3162}, CountryId{"UA"}}, // Q16690359
    {Coordinate{31.2177, 48.9913}, CountryId{"UA"}}, // Iskrene
    {Coordinate{34.3486, 49.6078}, CountryId{"UA"}}, // Abazivka
    {Coordinate{32.3694, 50.7789}, CountryId{"UA"}}, // Avhustivskyi
    {Coordinate{131.985, 45.1645}, CountryId{"RU"}}, // Q16690769
    {Coordinate{31.4804, 48.3544}, CountryId{"UA"}}, // Q16691145
    {Coordinate{27.6715, 49.6683}, CountryId{"UA"}}, // Adampil
    {Coordinate{131.204, 44.3812}, CountryId{"RU"}}, // Rassipnaya Padi
    {Coordinate{34.5686, 45.5878}, CountryId{"UA"}}, // Q16691435
    {Coordinate{37.6631, 54.3633}, CountryId{"RU"}}, // Q16691508
    {Coordinate{30.5607, 46.3336}, CountryId{"UA"}}, // Q16691530
    {Coordinate{29.1875, 45.7903}, CountryId{"UA"}}, // Q16691763
    {Coordinate{33.374, 50.5626}, CountryId{"UA"}}, // Andriyashivka
    {Coordinate{32.7599, 46.6762}, CountryId{"UA"}}, // Antonivka
    {Coordinate{26.3031, 51.3117}, CountryId{"UA"}}, // Antonivka
    {Coordinate{40.4818, 48.1853}, CountryId{"RU"}}, // Q16691925
    {Coordinate{37.5803, 47.2481}, CountryId{"UA"}}, // Aslanove
    {Coordinate{31.0459, 49.0174}, CountryId{"UA"}}, // Bahacheve
    {Coordinate{31.9328, 47.0913}, CountryId{"UA"}}, // Q16692280
    {Coordinate{31.034, 48.1243}, CountryId{"UA"}}, // Q16692314
    {Coordinate{27.7226, 49.0361}, CountryId{"UA"}}, // Bar
    {Coordinate{30.5236, 46.2533}, CountryId{"UA"}}, // Q16692330
    {Coordinate{22.4901, 48.3681}, CountryId{"UA"}}, // Q16692372
    {Coordinate{22.3858, 48.3614}, CountryId{"UA"}}, // Batiovo
    {Coordinate{22.6306, 48.2019}, CountryId{"UA"}}, // Q16692574
    {Coordinate{29.206, 46.2303}, CountryId{"UA"}}, // Q16692604
    {Coordinate{32.9922, 47.2443}, CountryId{"UA"}}, // Q16692608
    {Coordinate{30.942, 47.1924}, CountryId{"UA"}}, // Q16692644
    {Coordinate{29.5477, 48.3404}, CountryId{"UA"}}, // Bershad Railway Station
    {Coordinate{23.3273, 48.7627}, CountryId{"UA"}}, // Q16692709
    {Coordinate{28.6771, 51.0729}, CountryId{"UA"}}, // Behy
    {Coordinate{33.4408, 47.4093}, CountryId{"UA"}}, // Q16692794
    {Coordinate{33.0225, 50.8538}, CountryId{"UA"}}, // Q16692814
    {Coordinate{30.8857, 49.5644}, CountryId{"UA"}}, // Q16692871
    {Coordinate{33.4578, 50.2916}, CountryId{"UA"}}, // Bodakva
    {Coordinate{34.7906, 49.6592}, CountryId{"UA"}}, // Bozhkiv
    {Coordinate{28.6027, 45.7362}, CountryId{"UA"}}, // Bolgrad
    {Coordinate{22.7193, 48.1646}, CountryId{"UA"}}, // Q16692989
    {Coordinate{24.2564, 49.8605}, CountryId{"UA"}}, // Q16693099
    {Coordinate{34.038, 49.6788}, CountryId{"UA"}}, // Brateshky
    {Coordinate{33.1592, 46.4237}, CountryId{"UA"}}, // Brylivka
    {Coordinate{39.5038, 54.7305}, CountryId{"RU"}}, // Q16693224
    {Coordinate{34.7131, 51.5684}, CountryId{"RU"}}, // Q16693286
    {Coordinate{33.3177, 48.9759}, CountryId{"UA"}}, // Burty
    {Coordinate{23.4942, 48.0561}, CountryId{"UA"}}, // Q16693532
    {Coordinate{30.7194, 46.9108}, CountryId{"UA"}}, // Q16693536
    {Coordinate{33.1961, 47.3517}, CountryId{"UA"}}, // Q16693614
    {Coordinate{26.6234, 50.033}, CountryId{"UA"}}, // Bilhorodka
    {Coordinate{33.4886, 50.6552}, CountryId{"UA"}}, // Bilovody
    {Coordinate{31.9511, 49.3082}, CountryId{"UA"}}, // Biloziria
    {Coordinate{28.0507, 51.1174}, CountryId{"UA"}}, // Bilokorovychi
    {Coordinate{32.5686, 50.989}, CountryId{"UA"}}, // Q16693765
    {Coordinate{23.9424, 49.3898}, CountryId{"UA"}}, // Q16693771
    {Coordinate{33.5978, 46.1825}, CountryId{"UA"}}, // Vadym
    {Coordinate{34.627, 49.6154}, CountryId{"UA"}}, // Vakulintsi
    {Coordinate{23.1071, 49.483}, CountryId{"UA"}}, // Q16693941
    {Coordinate{22.458, 48.8985}, CountryId{"UA"}}, // Q16694102
    {Coordinate{32.9945, 46.5075}, CountryId{"UA"}}, // Velyki Kopani
    {Coordinate{28.4939, 51.2953}, CountryId{"UA"}}, // Q16694178
    {Coordinate{27.7798, 48.6073}, CountryId{"UA"}}, // Q16694183
    {Coordinate{25.5958, 50.2808}, CountryId{"UA"}}, // Q16694212
    {Coordinate{24.6933, 51.2339}, CountryId{"UA"}}, // Q16694222
    {Coordinate{23.5883, 49.0922}, CountryId{"UA"}}, // Q16694309
    {Coordinate{33.1877, 49.6032}, CountryId{"UA"}}, // Veselyi Podil
    {Coordinate{31.2259, 47.3625}, CountryId{"UA"}}, // Q16694347
    {Coordinate{32.8101, 50.0561}, CountryId{"UA"}}, // Vyly
    {Coordinate{23.0271, 48.134}, CountryId{"UA"}}, // Q16694486
    {Coordinate{33.5297, 47.4834}, CountryId{"UA"}}, // Q16694526
    {Coordinate{31.4498, 48.1615}, CountryId{"UA"}}, // Q16694534
    {Coordinate{23.0829, 48.6048}, CountryId{"UA"}}, // Vovchyi
    {Coordinate{31.3236, 47.5735}, CountryId{"UA"}}, // Voznesensk
    {Coordinate{23.1842, 48.7136}, CountryId{"UA"}}, // Q16694820
    {Coordinate{31.6929, 49.1888}, CountryId{"UA"}}, // Q16694848
    {Coordinate{22.8083, 48.9818}, CountryId{"UA"}}, // Q16694873
    {Coordinate{28.7117, 49.1237}, CountryId{"UA"}}, // Q16694954
    {Coordinate{34.0044, 45.8708}, CountryId{"UA"}}, // Q16695005
    {Coordinate{35.9286, 52.9272}, CountryId{"RU"}}, // Q16695020
    {Coordinate{38.2736, 48.3167}, CountryId{"UA"}}, // Q16695089
    {Coordinate{52.2083, 58.6811}, CountryId{"RU"}}, // Q16695263
    {Coordinate{26.6004, 49.1685}, CountryId{"UA"}}, // Victoria
    {Coordinate{40.2844, 48.2456}, CountryId{"RU"}}, // Q16695774
    {Coordinate{29.8545, 48.3401}, CountryId{"UA"}}, // Haivoron
    {Coordinate{32.7557, 46.9597}, CountryId{"UA"}}, // Q16695974
    {Coordinate{33.7541, 49.1708}, CountryId{"UA"}}, // Haleshchyna
    {Coordinate{33.9004, 49.2371}, CountryId{"UA"}}, // Q16696072
    {Coordinate{29.2215, 45.8606}, CountryId{"UA"}}, // Hlavani
    {Coordinate{25.5332, 49.6171}, CountryId{"UA"}}, // Hlybochok-Velykyi
    {Coordinate{23.897, 49.7374}, CountryId{"UA"}}, // Q16696424
    {Coordinate{33.2268, 49.3999}, CountryId{"UA"}}, // Q16696434
    {Coordinate{25.3195, 50.6909}, CountryId{"UA"}}, // Q16696492
    {Coordinate{25.0064, 51.0835}, CountryId{"UA"}}, // Holoby
    {Coordinate{30.3967, 48.3599}, CountryId{"UA"}}, // Q16696551
    {Coordinate{30.6507, 48.9045}, CountryId{"UA"}}, // Hordyshivka
    {Coordinate{31.4328, 49.2677}, CountryId{"UA"}}, // Horodyshche
    {Coordinate{23.6297, 49.7897}, CountryId{"UA"}}, // Q16696770
    {Coordinate{32.5006, 47.448}, CountryId{"UA"}}, // Horozhene
    {Coordinate{32.1497, 46.9933}, CountryId{"UA"}}, // Horokhivka
    {Coordinate{32.4052, 50.365}, CountryId{"UA"}}, // Q16696866
    {Coordinate{32.3032, 47.1138}, CountryId{"UA"}}, // Hreihove
    {Coordinate{30.238, 48.3249}, CountryId{"UA"}}, // Q16697037
    {Coordinate{29.3634, 48.6214}, CountryId{"UA"}}, // Hubnyk
    {Coordinate{26.606, 48.7699}, CountryId{"UA"}}, // Humentsi
    {Coordinate{30.779, 48.9189}, CountryId{"UA"}}, // Husakove
    {Coordinate{29.2722, 45.9453}, CountryId{"UA"}}, // Q16697379
    {Coordinate{30.5469, 46.5807}, CountryId{"UA"}}, // Dachne
    {Coordinate{29.0855, 48.5712}, CountryId{"UA"}}, // Demkivka
    {Coordinate{29.736, 48.4575}, CountryId{"UA"}}, // Dzhulynka
    {Coordinate{32.6701, 47.7831}, CountryId{"UA"}}, // Dobrovilskyi
    {Coordinate{22.3358, 48.6376}, CountryId{"UA"}}, // Domanyntsi
    {Coordinate{32.2906, 49.945}, CountryId{"UA"}}, // Q16698284
    {Coordinate{23.5436, 49.355}, CountryId{"UA"}}, // Q16698333
    {Coordinate{30.4928, 46.1005}, CountryId{"UA"}}, // Druzhba
    {Coordinate{33.6186, 47.57}, CountryId{"UA"}}, // Q16698501
    {Coordinate{25.7528, 50.3867}, CountryId{"UA"}}, // Q16698510
    {Coordinate{22.4876, 48.8096}, CountryId{"UA"}}, // Q16698540
    {Coordinate{45.0394, 43.3322}, CountryId{"RU"}}, // Sleptsovskaya
    {Coordinate{26.5951, 51.5607}, CountryId{"UA"}}, // Dubrovytsya
    {Coordinate{29.5075, 48.6024}, CountryId{"UA"}}, // Duklia
    {Coordinate{23.0082, 48.0129}, CountryId{"UA"}}, // Q16698664
    {Coordinate{27.9708, 51.1558}, CountryId{"UA"}}, // Dibrova-Olevska
    {Coordinate{34.1322, 45.2914}, CountryId{"UA"}}, // Q16698869
    {Coordinate{22.314, 48.3951}, CountryId{"UA"}}, // Q16699007
    {Coordinate{132.026, 43.3358}, CountryId{"RU"}}, // Q16699151
    {Coordinate{29.8763, 47.8365}, CountryId{"UA"}}, // Zherebkove
    {Coordinate{23.9675, 50.0495}, CountryId{"UA"}}, // Zhovkva
    {Coordinate{23.0215, 49.2109}, CountryId{"UA"}}, // Q16699304
    {Coordinate{22.633, 48.9869}, CountryId{"UA"}}, // Q16699338
    {Coordinate{31.0123, 51.5024}, CountryId{"UA"}}, // Q16699374
    {Coordinate{31.1569, 59.7281}, CountryId{"RU"}}, // Q16699435
    {Coordinate{24.2517, 51.6292}, CountryId{"UA"}}, // Q16699507
    {Coordinate{24.9764, 50.0378}, CountryId{"UA"}}, // Q16699508
    {Coordinate{24.4406, 49.8778}, CountryId{"UA"}}, // Q16699647
    {Coordinate{26.3204, 49.1119}, CountryId{"UA"}}, // Zakupne
    {Coordinate{24.2238, 49.9214}, CountryId{"UA"}}, // Q16699881
    {Coordinate{32.4209, 47.025}, CountryId{"UA"}}, // Q16699993
    {Coordinate{29.8787, 47.336}, CountryId{"UA"}}, // Zatyshshya
    {Coordinate{23.6756, 49.8403}, CountryId{"UA"}}, // Zatoka
    {Coordinate{25.1328, 49.6918}, CountryId{"UA"}}, // Zboriv Railway Station
    {Coordinate{30.9833, 48.9824}, CountryId{"UA"}}, // Zvenyhorodka
    {Coordinate{24.9091, 50.518}, CountryId{"UA"}}, // Q16700109
    {Coordinate{32.7576, 48.0617}, CountryId{"UA"}}, // Zhoda
    {Coordinate{26.2597, 50.5094}, CountryId{"UA"}}, // Zdolbuniv
    {Coordinate{33.5025, 48.5081}, CountryId{"UA"}}, // Zelena
    {Coordinate{31.6056, 47.2518}, CountryId{"UA"}}, // Q16700166
    {Coordinate{32.0775, 49.6567}, CountryId{"UA"}}, // Zolotonosha 1
    {Coordinate{24.8914, 49.7889}, CountryId{"UA"}}, // Zolochiv
    {Coordinate{29.4447, 48.7103}, CountryId{"UA"}}, // Ziatkivtsi
    {Coordinate{30.5206, 51.4964}, CountryId{"BY"}}, // Yolcha
    {Coordinate{30.732, 48.2472}, CountryId{"UA"}}, // Q16700505
    {Coordinate{31.2727, 47.9101}, CountryId{"UA"}}, // Q16700548
    {Coordinate{33.4619, 49.1411}, CountryId{"UA"}}, // Q16700552
    {Coordinate{33.4664, 46.2544}, CountryId{"UA"}}, // Kalanchak
    {Coordinate{23.2947, 49.5578}, CountryId{"UA"}}, // Q16700661
    {Coordinate{28.4761, 49.4565}, CountryId{"UA"}}, // Q16700669
    {Coordinate{32.9467, 47.162}, CountryId{"UA"}}, // Q16700722
    {Coordinate{30.7859, 47.9123}, CountryId{"UA"}}, // Q16700746
    {Coordinate{25.7, 50.3511}, CountryId{"UA"}}, // Q16700748
    {Coordinate{22.4144, 48.6924}, CountryId{"UA"}}, // Q16700752
    {Coordinate{30.0806, 46.1114}, CountryId{"UA"}}, // Kantemyr
    {Coordinate{31.5513, 48.4715}, CountryId{"UA"}}, // Q16700899
    {Coordinate{33.0119, 51.5451}, CountryId{"UA"}}, // Q16701067
    {Coordinate{30.5322, 46.1447}, CountryId{"UA"}}, // Karolina-Buhaz
    {Coordinate{28.9606, 48.926}, CountryId{"UA"}}, // Q16701098
    {Coordinate{30.3328, 46.6872}, CountryId{"UA"}}, // Karpove
    {Coordinate{11.7931, 60.7234}, CountryId{"NO"}}, // Braskereidfoss Station
    {Coordinate{33.4687, 49.9459}, CountryId{"UA"}}, // Kybyntsi
    {Coordinate{28.9934, 48.5786}, CountryId{"UA"}}, // Kyrnasivka
    {Coordinate{30.4109, 50.4523}, CountryId{"UA"}}, // Q16701527
    {Coordinate{26.0275, 50.7511}, CountryId{"UA"}}, // Klevan
    {Coordinate{26.7594, 50.0567}, CountryId{"UA"}}, // Q16701606
    {Coordinate{26.8916, 51.3115}, CountryId{"UA"}}, // Klesiv
    {Coordinate{28.4974, 50.9979}, CountryId{"UA"}}, // Klochki
    {Coordinate{22.6415, 48.4092}, CountryId{"UA"}}, // Q16701705
    {Coordinate{31.3797, 59.6383}, CountryId{"RU"}}, // Q16701735
    {Coordinate{29.1214, 48.0912}, CountryId{"UA"}}, // Kodyma
    {Coordinate{28.7832, 49.7571}, CountryId{"UA"}}, // Kozyatyn 2
    {Coordinate{24.2752, 50.0018}, CountryId{"UA"}}, // Q16702132
    {Coordinate{32.3597, 50.7232}, CountryId{"UA"}}, // Q16702146
    {Coordinate{22.7693, 48.4654}, CountryId{"UA"}}, // Q16702209
    {Coordinate{23.68, 49.6577}, CountryId{"UA"}}, // Q16702240
    {Coordinate{23.7515, 49.2156}, CountryId{"UA"}}, // Q16702504
    {Coordinate{27.7544, 48.8838}, CountryId{"UA"}}, // Kopai
    {Coordinate{32.3074, 46.8096}, CountryId{"UA"}}, // Kopani
    {Coordinate{23.1407, 48.1534}, CountryId{"UA"}}, // Korolevo station
    {Coordinate{33.2233, 48.5761}, CountryId{"UA"}}, // Korolivka
    {Coordinate{32.9801, 51.5611}, CountryId{"UA"}}, // Korop
    {Coordinate{23.5705, 49.6687}, CountryId{"UA"}}, // Q16702763
    {Coordinate{31.3117, 49.4301}, CountryId{"UA"}}, // Korsun
    {Coordinate{22.4664, 48.287}, CountryId{"UA"}}, // Q16702836
    {Coordinate{26.4439, 50.8711}, CountryId{"UA"}}, // Q16702895
    {Coordinate{22.6008, 48.945}, CountryId{"UA"}}, // Q16702901
    {Coordinate{28.9764, 45.6268}, CountryId{"UA"}}, // Q16702947
    {Coordinate{32.1808, 46.8661}, CountryId{"UA"}}, // Kotlyareve
    {Coordinate{27.7535, 48.7883}, CountryId{"UA"}}, // Q16702979
    {Coordinate{42.7717, 43.9619}, CountryId{"RU"}}, // Q16703021
    {Coordinate{34.9697, 49.7419}, CountryId{"UA"}}, // Kochubejivka
    {Coordinate{40.0928, 47.8811}, CountryId{"RU"}}, // Q16703095
    {Coordinate{30.3104, 47.0078}, CountryId{"UA"}}, // Q16703206
    {Coordinate{34.2164, 45.4017}, CountryId{"UA"}}, // Q16703220
    {Coordinate{30.7846, 46.7373}, CountryId{"UA"}}, // Q16703310
    {Coordinate{34.5894, 49.6022}, CountryId{"UA"}}, // Kryvokhatky
    {Coordinate{46.4797, 58.3464}, CountryId{"RU"}}, // Q16703417
    {Coordinate{24.3769, 51.5343}, CountryId{"UA"}}, // Q16703438
    {Coordinate{103.949, 52.5005}, CountryId{"RU"}}, // Q16703602
    {Coordinate{30.6215, 46.3633}, CountryId{"UA"}}, // Q16703703
    {Coordinate{29.647, 48.6738}, CountryId{"UA"}}, // Kublych
    {Coordinate{48.4819, 53.1707}, CountryId{"RU"}}, // Syzran-Gorod railway station
    {Coordinate{29.913, 46.0402}, CountryId{"UA"}}, // Kulevcha
    {Coordinate{30.7931, 46.6337}, CountryId{"UA"}}, // Q16704044
    {Coordinate{32.0694, 46.9155}, CountryId{"UA"}}, // Kulbakyne
    {Coordinate{114.834, 56.3594}, CountryId{"RU"}}, // Taksimo
    {Coordinate{30.0025, 46.7538}, CountryId{"UA"}}, // Q16704324
    {Coordinate{25.4728, 50.8317}, CountryId{"UA"}}, // Kivertsi
    {Coordinate{30.8447, 47.9672}, CountryId{"UA"}}, // Kinetspil
    {Coordinate{41.4272, 52.7175}, CountryId{"RU"}}, // Q16704452
    {Coordinate{23.3576, 48.8106}, CountryId{"UA"}}, // Q16704471
    {Coordinate{29.24, 48.6304}, CountryId{"UA"}}, // Ladyzhyn
    {Coordinate{44.1942, 56.6827}, CountryId{"RU"}}, // Q16704653
    {Coordinate{26.2149, 49.9555}, CountryId{"UA"}}, // Q16704842
    {Coordinate{33.0668, 47.3001}, CountryId{"UA"}}, // Q16704844
    {Coordinate{30.5129, 46.129}, CountryId{"UA"}}, // Lymanska
    {Coordinate{32.376, 50.4725}, CountryId{"UA"}}, // Q16704911
    {Coordinate{29.2284, 49.2475}, CountryId{"UA"}}, // Lypovets
    {Coordinate{32.377, 47.2048}, CountryId{"UA"}}, // Lotskyne
    {Coordinate{28.3798, 51.035}, CountryId{"UA"}}, // Luhyny
    {Coordinate{25.3511, 50.758}, CountryId{"UA"}}, // Lutsk Railway Station
    {Coordinate{23.6951, 49.1498}, CountryId{"UA"}}, // Q16705489
    {Coordinate{24.8255, 51.1619}, CountryId{"UA"}}, // Lyubytiv
    {Coordinate{24.6206, 51.1797}, CountryId{"UA"}}, // Lyublynets-Volynskiy
    {Coordinate{26.3744, 50.7681}, CountryId{"UA"}}, // Q16705510
    {Coordinate{24.0408, 51.2156}, CountryId{"UA"}}, // Lyuboml
    {Coordinate{23.7317, 49.7153}, CountryId{"UA"}}, // Q16705527
    {Coordinate{31.4481, 48.0288}, CountryId{"UA"}}, // Q16705546
    {Coordinate{142.587, 47.1131}, CountryId{"JP"}}, // Q16705556
    {Coordinate{33.1637, 48.8217}, CountryId{"UA"}}, // Q16705656
    {Coordinate{26.4712, 49.1466}, CountryId{"UA"}}, // Lisovody
    {Coordinate{34.2669, 49.2602}, CountryId{"UA"}}, // Lischynivka
    {Coordinate{25.9083, 49.5966}, CountryId{"UA"}}, // Q16706011
    {Coordinate{32.83, 48.0517}, CountryId{"UA"}}, // Tymkove
    {Coordinate{25.5334, 51.2931}, CountryId{"UA"}}, // Manevychi railway station
    {Coordinate{29.7391, 47.5364}, CountryId{"UA"}}, // Mardarivka
    {Coordinate{31.2791, 47.4687}, CountryId{"UA"}}, // Q16706407
    {Coordinate{27.9469, 49.0401}, CountryId{"UA"}}, // Mateikove
    {Coordinate{33.8542, 49.8554}, CountryId{"UA"}}, // Matyashivka
    {Coordinate{24.3642, 51.2406}, CountryId{"UA"}}, // Matseiv
    {Coordinate{32.2315, 49.8676}, CountryId{"UA"}}, // Mekhedivka
    {Coordinate{30.0483, 46.9869}, CountryId{"UA"}}, // Myhajeve
    {Coordinate{23.9535, 49.5116}, CountryId{"UA"}}, // Q16707010
    {Coordinate{33.7507, 49.9356}, CountryId{"UA"}}, // Mylashenkove
    {Coordinate{26.7228, 51.6961}, CountryId{"UA"}}, // Mylyachi
    {Coordinate{34.7108, 49.5086}, CountryId{"UA"}}, // Q16707070
    {Coordinate{27.775, 48.4577}, CountryId{"UA"}}, // Mohyliv-Podilskyi railway station
    {Coordinate{26.515, 50.9847}, CountryId{"UA"}}, // Q16707329
    {Coordinate{29.7127, 49.006}, CountryId{"UA"}}, // Monastyrysche
    {Coordinate{23.8746, 49.1501}, CountryId{"UA"}}, // Q16707509
    {Coordinate{23.1292, 49.8183}, CountryId{"UA"}}, // Q16707535
    {Coordinate{23.0328, 49.8167}, CountryId{"UA"}}, // Mostyska II
    {Coordinate{24.6189, 51.2913}, CountryId{"UA"}}, // Q16707606
    {Coordinate{37.5151, 56.1209}, CountryId{"RU"}}, // Trudovaya
    {Coordinate{23.7756, 49.83}, CountryId{"UA"}}, // Mshana
    {Coordinate{32.0902, 46.979}, CountryId{"UA"}}, // Q16708427
    {Coordinate{31.2419, 59.6908}, CountryId{"RU"}}, // Q16708683
    {Coordinate{30.637, 51.5117}, CountryId{"UA"}}, // Nedanchychi
    {Coordinate{27.7588, 48.6824}, CountryId{"UA"}}, // Q16708915
    {Coordinate{28.875, 48.9902}, CountryId{"UA"}}, // Nemyriv
    {Coordinate{26.5739, 51.2019}, CountryId{"UA"}}, // Q16708937
    {Coordinate{25.156, 50.6114}, CountryId{"UA"}}, // Q16708979
    {Coordinate{32.7689, 47.9639}, CountryId{"UA"}}, // Novodanylivka
    {Coordinate{33.3261, 47.3748}, CountryId{"UA"}}, // Q16709201
    {Coordinate{31.3996, 47.299}, CountryId{"UA"}}, // Q16709210
    {Coordinate{33.3137, 46.3387}, CountryId{"UA"}}, // Novokyivka
    {Coordinate{32.6039, 47.0608}, CountryId{"UA"}}, // Q16709243
    {Coordinate{32.5174, 47.5386}, CountryId{"UA"}}, // Novopoltavka
    {Coordinate{26.6076, 48.8263}, CountryId{"UA"}}, // Q16709460
    {Coordinate{26.1796, 50.6762}, CountryId{"UA"}}, // Obariv
    {Coordinate{23.8926, 49.7813}, CountryId{"UA"}}, // Q16709645
    {Coordinate{29.5247, 47.8551}, CountryId{"UA"}}, // Q16709672
    {Coordinate{24.3853, 50.9283}, CountryId{"UA"}}, // Q16709684
    {Coordinate{28.818, 51.3248}, CountryId{"UA"}}, // Q16709694
    {Coordinate{30.6542, 46.4782}, CountryId{"UA"}}, // Odesa-Zastava 1st
    {Coordinate{30.6535, 46.4387}, CountryId{"UA"}}, // Odessa-Zakhidna
    {Coordinate{30.7264, 46.525}, CountryId{"UA"}}, // Q16709739
    {Coordinate{30.7871, 46.5953}, CountryId{"UA"}}, // Odesa-Skhidna
    {Coordinate{25.3983, 49.6106}, CountryId{"UA"}}, // Q16709810
    {Coordinate{27.6479, 51.2284}, CountryId{"UA"}}, // Olevsk
    {Coordinate{48.203, 54.1642}, CountryId{"RU"}}, // Q16709927
    {Coordinate{31.3005, 47.6424}, CountryId{"UA"}}, // Q16709938
    {Coordinate{25.7391, 50.7833}, CountryId{"UA"}}, // Olyka
    {Coordinate{31.4828, 48.0989}, CountryId{"UA"}}, // Q16710075
    {Coordinate{29.3902, 49.1753}, CountryId{"UA"}}, // Orativ
    {Coordinate{30.9229, 48.0498}, CountryId{"UA"}}, // Orlyk
    {Coordinate{27.3683, 51.263}, CountryId{"UA"}}, // Ostky
    {Coordinate{103.391, 52.4333}, CountryId{"RU"}}, // Usolye-Siberian
    {Coordinate{102.776, 57.9097}, CountryId{"RU"}}, // Q16710638
    {Coordinate{58.1011, 54.5615}, CountryId{"RU"}}, // Q16710652
    {Coordinate{33.3389, 48.9117}, CountryId{"UA"}}, // Pavlysh
    {Coordinate{104.061, 51.5414}, CountryId{"RU"}}, // Q16710729
    {Coordinate{32.1531, 49.761}, CountryId{"UA"}}, // Palmira
    {Coordinate{32.8835, 48.6759}, CountryId{"UA"}}, // Pantaivka
    {Coordinate{94.1943, 55.4818}, CountryId{"RU"}}, // Uyar station
    {Coordinate{31.7625, 49.2214}, CountryId{"UA"}}, // Perehonivka
    {Coordinate{29.7319, 47.8729}, CountryId{"UA"}}, // Q16711280
    {Coordinate{25.1554, 50.9887}, CountryId{"UA"}}, // Perespa
    {Coordinate{29.7954, 47.4385}, CountryId{"UA"}}, // Perekhrestove
    {Coordinate{22.4782, 48.733}, CountryId{"UA"}}, // Q16711348
    {Coordinate{32.3419, 50.025}, CountryId{"UA"}}, // Q16711626
    {Coordinate{29.5141, 47.8096}, CountryId{"UA"}}, // Poberezhzhya
    {Coordinate{25.1322, 51.2719}, CountryId{"UA"}}, // Povorsk
    {Coordinate{29.2948, 49.4383}, CountryId{"UA"}}, // Pohrebysche 1
    {Coordinate{30.2082, 48.93}, CountryId{"UA"}}, // Podibne
    {Coordinate{28.9757, 48.2152}, CountryId{"UA"}}, // Popelyukhy
    {Coordinate{28.7681, 51.2255}, CountryId{"UA"}}, // Potapovychi
    {Coordinate{30.3289, 48.9201}, CountryId{"UA"}}, // Potash
    {Coordinate{33.6198, 49.1265}, CountryId{"UA"}}, // Q16712474
    {Coordinate{27.8068, 51.2058}, CountryId{"UA"}}, // Poyasky
    {Coordinate{34.0714, 45.2017}, CountryId{"RU"}}, // Q16713308
    {Coordinate{31.2691, 48.9945}, CountryId{"UA"}}, // Prudianka
    {Coordinate{31.2629, 47.82}, CountryId{"UA"}}, // Pivdennoukrainska
    {Coordinate{24.1287, 49.8473}, CountryId{"UA"}}, // Q16713656
    {Coordinate{23.9562, 49.4497}, CountryId{"UA"}}, // Q16713837
    {Coordinate{32.9443, 46.5639}, CountryId{"UA"}}, // Radenske
    {Coordinate{24.6256, 50.2842}, CountryId{"UA"}}, // Q16713914
    {Coordinate{31.9993, 49.0967}, CountryId{"UA"}}, // Raihorod
    {Coordinate{30.8317, 47.1699}, CountryId{"UA"}}, // Q16714076
    {Coordinate{25.9989, 51.3067}, CountryId{"UA"}}, // Rafalivka
    {Coordinate{28.472, 48.7888}, CountryId{"UA"}}, // Rakhny
    {Coordinate{29.2793, 51.3524}, CountryId{"UA"}}, // Q16714098
    {Coordinate{26.2797, 50.7056}, CountryId{"UA"}}, // Q16714318
    {Coordinate{33.3129, 50.8166}, CountryId{"UA"}}, // Rohyntsi
    {Coordinate{23.5114, 49.7931}, CountryId{"UA"}}, // Q16714477
    {Coordinate{25.2607, 50.9097}, CountryId{"UA"}}, // Rozhyshche
    {Coordinate{30.0447, 46.8889}, CountryId{"UA"}}, // Rozdilna-Sortuvalna
    {Coordinate{30.0739, 46.8504}, CountryId{"UA"}}, // Rozdilna 1st
    {Coordinate{29.791, 48.7531}, CountryId{"UA"}}, // Rozkoshivka
    {Coordinate{30.8571, 48.9554}, CountryId{"UA"}}, // Rozsokhuvatka
    {Coordinate{30.0504, 48.7771}, CountryId{"UA"}}, // Rozsishky
    {Coordinate{27.2207, 51.2712}, CountryId{"UA"}}, // Rokytne-Volynske
    {Coordinate{23.1783, 48.1949}, CountryId{"UA"}}, // Q16714630
    {Coordinate{33.4684, 50.7491}, CountryId{"UA"}}, // Romny
    {Coordinate{30.4496, 46.9915}, CountryId{"UA"}}, // Q16714791
    {Coordinate{5.65167, 53.0322}, CountryId{"NL"}}, // Sneek railway station
    {Coordinate{32.9449, 50.9374}, CountryId{"UA"}}, // Rubanka
    {Coordinate{33.3343, 49.2508}, CountryId{"UA"}}, // Q16714834
    {Coordinate{23.4983, 49.6414}, CountryId{"UA"}}, // Q16714868
    {Coordinate{28.9344, 48.2606}, CountryId{"UA"}}, // Rudnytsia
    {Coordinate{25.4978, 50.223}, CountryId{"UA"}}, // Q16714886
    {Coordinate{23.2122, 49.5167}, CountryId{"UA"}}, // Sambir railway station
    {Coordinate{29.079, 48.873}, CountryId{"UA"}}, // Samchyntsi
    {Coordinate{24.3379, 50.084}, CountryId{"UA"}}, // Q16715391
    {Coordinate{29.6794, 46.0158}, CountryId{"UA"}}, // Sarata
    {Coordinate{26.6029, 51.3388}, CountryId{"UA"}}, // Sarny
    {Coordinate{22.988, 48.5516}, CountryId{"UA"}}, // Q16715494
    {Coordinate{34.6894, 49.625}, CountryId{"UA"}}, // Svynkivka
    {Coordinate{30.1059, 51.3957}, CountryId{"UA"}}, // Semikhody
    {Coordinate{30.7535, 47.0084}, CountryId{"UA"}}, // Q16716000
    {Coordinate{31.3974, 48.9954}, CountryId{"UA"}}, // Q16716150
    {Coordinate{29.1835, 48.9036}, CountryId{"UA"}}, // Sytkivtsi
    {Coordinate{30.4122, 59.0833}, CountryId{"RU"}}, // Q16716404
    {Coordinate{23.5046, 49.0341}, CountryId{"UA"}}, // Skole
    {Coordinate{35.0678, 49.7781}, CountryId{"UA"}}, // Skorohodove
    {Coordinate{23.2638, 48.7263}, CountryId{"UA"}}, // Q16716628
    {Coordinate{23.4446, 48.8486}, CountryId{"UA"}}, // Q16716695
    {Coordinate{30.753, 51.5153}, CountryId{"UA"}}, // Q16716710
    {Coordinate{24.2567, 50.4644}, CountryId{"UA"}}, // Q16717090
    {Coordinate{22.8878, 49.0831}, CountryId{"UA"}}, // Q16717108
    {Coordinate{33.0365, 49.9812}, CountryId{"UA"}}, // Solonytska
    {Coordinate{23.877, 47.9498}, CountryId{"UA"}}, // Solotvyno 1
    {Coordinate{23.882, 47.9589}, CountryId{"UA"}}, // Solotvyno 2
    {Coordinate{22.5378, 48.9512}, CountryId{"UA"}}, // Q16717217
    {Coordinate{33.4798, 45.1611}, CountryId{"UA"}}, // Q16717243
    {Coordinate{30.48, 46.0875}, CountryId{"UA"}}, // Q16717253
    {Coordinate{24.2628, 50.2917}, CountryId{"UA"}}, // Q16717330
    {Coordinate{31.203, 49.49}, CountryId{"UA"}}, // Sotnyky
    {Coordinate{31.8906, 49.1355}, CountryId{"UA"}}, // Sofiivka
    {Coordinate{22.7063, 48.9923}, CountryId{"UA"}}, // Q16717716
    {Coordinate{23.8487, 49.7452}, CountryId{"UA"}}, // Q16717727
    {Coordinate{36.3489, 54.1017}, CountryId{"RU"}}, // Q16717830
    {Coordinate{23.0037, 49.4412}, CountryId{"UA"}}, // Q16717852
    {Coordinate{27.2789, 49.7336}, CountryId{"UA"}}, // Starokostiantyniv-II
    {Coordinate{24.6666, 50.378}, CountryId{"UA"}}, // Q16718200
    {Coordinate{22.5662, 48.3875}, CountryId{"UA"}}, // Q16718203
    {Coordinate{26.7545, 51.3302}, CountryId{"UA"}}, // Strashiv
    {Coordinate{32.6942, 46.7841}, CountryId{"UA"}}, // Q16718320
    {Coordinate{22.2447, 48.5122}, CountryId{"UA"}}, // Q16718381
    {Coordinate{22.9897, 49.3366}, CountryId{"UA"}}, // Q16718403
    {Coordinate{26.5847, 51.432}, CountryId{"UA"}}, // Strilsk
    {Coordinate{30.5569, 46.1653}, CountryId{"UA"}}, // Q16718435
    {Coordinate{23.3844, 49.7992}, CountryId{"UA"}}, // Sudova Vyshnia
    {Coordinate{27.7037, 48.49}, CountryId{"UA"}}, // Q16718594
    {Coordinate{34.4757, 49.5894}, CountryId{"UA"}}, // Suprunivka
    {Coordinate{26.3815, 49.9994}, CountryId{"UA"}}, // Sukhovolya
    {Coordinate{22.902, 49.0232}, CountryId{"UA"}}, // Q16718801
    {Coordinate{34.3746, 46.9423}, CountryId{"UA"}}, // Q16718889
    {Coordinate{33.1412, 50.8466}, CountryId{"UA"}}, // Talalaivka
    {Coordinate{30.7231, 48.8954}, CountryId{"UA"}}, // Talne
    {Coordinate{33.1555, 49.987}, CountryId{"UA"}}, // Tarnavshchyna
    {Coordinate{30.1025, 48.3771}, CountryId{"UA"}}, // Q16719214
    {Coordinate{28.9221, 45.5185}, CountryId{"UA"}}, // Q16719233
    {Coordinate{46.6172, 57.6719}, CountryId{"RU"}}, // Q16719684
    {Coordinate{23.6999, 47.9959}, CountryId{"UA"}}, // Teresva railway station
    {Coordinate{31.9567, 47.0561}, CountryId{"UA"}}, // Q16719828
    {Coordinate{33.5189, 45.1428}, CountryId{"UA"}}, // Q16719918
    {Coordinate{28.8754, 51.3863}, CountryId{"UA"}}, // Q16720129
    {Coordinate{27.0688, 51.3017}, CountryId{"UA"}}, // Tomashhorod
    {Coordinate{31.8144, 47.149}, CountryId{"UA"}}, // Q16720371
    {Coordinate{25.3375, 51.2885}, CountryId{"UA"}}, // Troyanivka
    {Coordinate{23.512, 49.2827}, CountryId{"UA"}}, // Q16720460
    {Coordinate{38.4808, 55.1779}, CountryId{"RU"}}, // Q16720463
    {Coordinate{23.0239, 49.1519}, CountryId{"UA"}}, // Q16720551
    {Coordinate{32.8825, 47.0957}, CountryId{"UA"}}, // Q16720560
    {Coordinate{24.5328, 51.0797}, CountryId{"UA"}}, // Q16720582
    {Coordinate{23.478, 48.92}, CountryId{"UA"}}, // Q16720590
    {Coordinate{23.5759, 48.0148}, CountryId{"UA"}}, // Q16720627
    {Coordinate{26.7504, 51.7473}, CountryId{"UA"}}, // Udryts'k
    {Coordinate{22.3005, 48.6095}, CountryId{"UA"}}, // Uzhhorod
    {Coordinate{28.204, 49.5074}, CountryId{"UA"}}, // Uladivka
    {Coordinate{34.274, 49.6257}, CountryId{"UA"}}, // Umantsivka
    {Coordinate{38.4122, 55.1483}, CountryId{"RU"}}, // Q16721052
    {Coordinate{37.5947, 54.5747}, CountryId{"RU"}}, // Q16721153
    {Coordinate{28.8548, 49.0708}, CountryId{"UA"}}, // Ferdynandivka
    {Coordinate{133.78, 46.0384}, CountryId{"RU"}}, // Q16721614
    {Coordinate{29.9584, 48.3149}, CountryId{"UA"}}, // Q16722009
    {Coordinate{32.6616, 46.693}, CountryId{"UA"}}, // Q16722048
    {Coordinate{31.4631, 49.201}, CountryId{"UA"}}, // Khlystunivka
    {Coordinate{27.9845, 49.5591}, CountryId{"UA"}}, // Q16722127
    {Coordinate{28.3468, 49.4918}, CountryId{"UA"}}, // Kholonivska
    {Coordinate{33.2074, 49.7844}, CountryId{"UA"}}, // Q16722260
    {Coordinate{29.9726, 48.8152}, CountryId{"UA"}}, // Khrystynivka
    {Coordinate{31.5292, 49.1537}, CountryId{"UA"}}, // Tsvitkove
    {Coordinate{32.4123, 48.8442}, CountryId{"UA"}}, // Tsybuleve
    {Coordinate{25.8839, 50.7732}, CountryId{"UA"}}, // Tsuman
    {Coordinate{32.8346, 46.6312}, CountryId{"UA"}}, // Oleshky
    {Coordinate{84.8417, 55.7128}, CountryId{"RU"}}, // Yurga I
    {Coordinate{32.0747, 49.572}, CountryId{"UA"}}, // Q16722826
    {Coordinate{24.2289, 50.3967}, CountryId{"UA"}}, // Q16723109
    {Coordinate{105.901, 56.8047}, CountryId{"RU"}}, // Q16723195
    {Coordinate{55.9785, 53.6815}, CountryId{"RU"}}, // Q16723277
    {Coordinate{32.4189, 46.7672}, CountryId{"UA"}}, // Chekhovychi
    {Coordinate{22.8478, 48.4926}, CountryId{"UA"}}, // Q16723371
    {Coordinate{52.1111, 58.2486}, CountryId{"RU"}}, // Yar
    {Coordinate{22.2056, 48.4328}, CountryId{"UA"}}, // Chop
    {Coordinate{32.5293, 46.7182}, CountryId{"UA"}}, // Chornobaivka
    {Coordinate{30.76, 46.8278}, CountryId{"UA"}}, // Chornomorska
    {Coordinate{25.8344, 51.2996}, CountryId{"UA"}}, // Chortoryisk
    {Coordinate{29.5834, 47.6521}, CountryId{"UA"}}, // Chubivka
    {Coordinate{26.5975, 57.0619}, CountryId{"LV"}}, // Q16723542
    {Coordinate{30.5342, 48.9185}, CountryId{"UA"}}, // Q16723616
    {Coordinate{34.557, 49.6308}, CountryId{"UA"}}, // Shvedska Mohyla
    {Coordinate{22.8186, 49.008}, CountryId{"UA"}}, // Q16723963
    {Coordinate{23.8701, 49.6558}, CountryId{"UA"}}, // Q16723967
    {Coordinate{28.5798, 48.7015}, CountryId{"UA"}}, // Yurkivka
    {Coordinate{32.4704, 47.3193}, CountryId{"UA"}}, // Yavkyne
    {Coordinate{23.0724, 49.1869}, CountryId{"UA"}}, // Q16724083
    {Coordinate{23.8958, 51.1981}, CountryId{"UA"}}, // Yahodyn
    {Coordinate{33.6178, 48.4524}, CountryId{"UA"}}, // Yakovlivka
    {Coordinate{33.8832, 49.8152}, CountryId{"UA"}}, // Yaresky
    {Coordinate{30.117, 48.9124}, CountryId{"UA"}}, // Yarovatka
    {Coordinate{22.9795, 49.276}, CountryId{"UA"}}, // Q16724256
    {Coordinate{31.7171, 47.1876}, CountryId{"UA"}}, // Q16724261
    {Coordinate{8.26995, 47.3484}, CountryId{"CH"}}, // Wohlen railway station
    {Coordinate{4.63635, 49.6501}, CountryId{"FR"}}, // Gare de Poix-Terron
    {Coordinate{107.68, 51.8242}, CountryId{"RU"}}, // Zaudinskiy station
    {Coordinate{9.72278, 52.3527}, CountryId{"DE"}}, // Hannover-Linden station
    {Coordinate{8.72782, 48.5555}, CountryId{"DE"}}, // Q16830552
    {Coordinate{11.5804, 50.0937}, CountryId{"DE"}}, // Q16830553
    {Coordinate{11.5954, 49.8106}, CountryId{"DE"}}, // Q16830554
    {Coordinate{8.5302, 49.2919}, CountryId{"DE"}}, // Neulußheim station
    {Coordinate{78.7803, 28.4586}, CountryId{"IN"}}, // Chandausi railway station
    {Coordinate{79.0778, 12.2381}, CountryId{"IN"}}, // Tiruvannamalai Town railway station
    {Coordinate{75.8585, 22.7423}, CountryId{"IN"}}, // Indore Lakshmibai Nagar railway station
    {Coordinate{79.0907, 12.337}, CountryId{"IN"}}, // Turinjapuram railway station
    {Coordinate{11.5936, 50.9368}, CountryId{"DE"}}, // Jena Saalbahnhof
    {Coordinate{78.7213, 12.7829}, CountryId{"IN"}}, // Ambur railway station
    {Coordinate{78.1019, 9.52463}, CountryId{"IN"}}, // Aruppukkottai railway station
    {Coordinate{79.3486, 19.849}, CountryId{"IN"}}, // Balharshah railway station
    {Coordinate{91.1763, 26.4975}, CountryId{"IN"}}, // Pathsala railway station
    {Coordinate{8.23008, 50.3327}, CountryId{"DE"}}, // Niederselters station
    {Coordinate{72.7854, 24.4807}, CountryId{"IN"}}, // Abu Road railway station
    {Coordinate{76.8221, 30.702}, CountryId{"IN"}}, // Chandigarh Junction railway station
    {Coordinate{75.7888, 13.3039}, CountryId{"IN"}}, // Chikkamagaluru railway station
    {Coordinate{74.0254, 30.4086}, CountryId{"IN"}}, // Fazilka railway station
    {Coordinate{74.6184, 30.9425}, CountryId{"IN"}}, // Firozpur Cantonment railway station
    {Coordinate{10.91, 52.2138}, CountryId{"DE"}}, // Frellstedt railway station
    {Coordinate{76.8244, 17.3144}, CountryId{"IN"}}, // Gulbarga railway station
    {Coordinate{77.3666, 15.1756}, CountryId{"IN"}}, // Guntakal junction railway station
    {Coordinate{75.5915, 31.3317}, CountryId{"IN"}}, // Jalandhar City Junction railway station
    {Coordinate{75.6321, 31.3062}, CountryId{"IN"}}, // Jalandhar Cantonment railway station
    {Coordinate{75.8245, 29.8018}, CountryId{"IN"}}, // Jakhal railway station
    {Coordinate{76.2896, 29.3289}, CountryId{"IN"}}, // Jind Junction railway station
    {Coordinate{73.0232, 26.2838}, CountryId{"IN"}}, // Jodhpur railway station
    {Coordinate{79.839, 10.9171}, CountryId{"IN"}}, // Karaikal railway station
    {Coordinate{80.3912, 23.8312}, CountryId{"IN"}}, // Katni Murwara Junction railway station
    {Coordinate{74.9353, 32.9822}, CountryId{"IN"}}, // Katra railway station
    {Coordinate{79.511, 17.9742}, CountryId{"IN"}}, // Kazipet railway station
    {Coordinate{81.2589, 18.6381}, CountryId{"IN"}}, // Kirandul railway station
    {Coordinate{10.8125, 52.2572}, CountryId{"DE"}}, // Königslutter railway station
    {Coordinate{12.1605, 51.1855}, CountryId{"DE"}}, // Leipzig Miltitzer Allee railway station
    {Coordinate{75.8479, 30.9124}, CountryId{"IN"}}, // Ludhiana Junction railway station
    {Coordinate{86.6422, 24.2706}, CountryId{"IN"}}, // Madhupur Junction railway station
    {Coordinate{74.8801, 12.8662}, CountryId{"IN"}}, // Mangalore Junction railway station
    {Coordinate{76.2971, 30.6695}, CountryId{"IN"}}, // Mandi Gobindgarh railway station
    {Coordinate{76.9345, 11.2997}, CountryId{"IN"}}, // Mettupalayam railway station
    {Coordinate{78.7658, 28.8316}, CountryId{"IN"}}, // Moradabad railway station
    {Coordinate{75.6118, 31.9419}, CountryId{"IN"}}, // Mukerian railway station
    {Coordinate{75.4125, 23.4559}, CountryId{"IN"}}, // Nagda Junction railway station
    {Coordinate{93.7008, 27.103}, CountryId{"IN"}}, // Naharlagun railway station
    {Coordinate{76.964, 29.389}, CountryId{"IN"}}, // Panipat railway station
    {Coordinate{76.6682, 8.81576}, CountryId{"IN"}}, // Paravur railway station
    {Coordinate{75.6444, 32.2718}, CountryId{"IN"}}, // Pathankot Junction railway station
    {Coordinate{75.636, 32.2593}, CountryId{"IN"}}, // Pathankot Cantonment railway station
    {Coordinate{75.7655, 31.2176}, CountryId{"IN"}}, // Phagwara railway station
    {Coordinate{85.0794, 25.5863}, CountryId{"IN"}}, // Phulwari Sharif railway station
    {Coordinate{79.8281, 11.9254}, CountryId{"IN"}}, // Pondicherry railway station
    {Coordinate{78.7098, 10.7918}, CountryId{"IN"}}, // Ponmalai (Golden Rock) railway station
    {Coordinate{87.5191, 25.7907}, CountryId{"IN"}}, // Purnia Junction railway station
    {Coordinate{74.5378, 26.4907}, CountryId{"IN"}}, // Pushkar railway station
    {Coordinate{77.3392, 16.1924}, CountryId{"IN"}}, // Raichur railway station
    {Coordinate{88.648, 26.544}, CountryId{"IN"}}, // Raninagar Jalpaiguri Junction railway station
    {Coordinate{78.5331, 17.4617}, CountryId{"IN"}}, // Safilguda railway station
    {Coordinate{75.9795, 30.8374}, CountryId{"IN"}}, // Sahnewal railway station
    {Coordinate{75.1362, 33.6755}, CountryId{"IN"}}, // Sadura railway station
    {Coordinate{10.6857, 52.2673}, CountryId{"DE"}}, // Schandelah railway station
    {Coordinate{76.3832, 30.6242}, CountryId{"IN"}}, // Sirhind Junction railway station
    {Coordinate{8.47818, 47.1945}, CountryId{"CH"}}, // Steinhausen railway station
    {Coordinate{13.1072, 54.305}, CountryId{"DE"}}, // Stralsund Rügendamm railway station
    {Coordinate{86.4403, 23.6545}, CountryId{"IN"}}, // Sudamdih railway station
    {Coordinate{71.6301, 22.7443}, CountryId{"IN"}}, // Surendranagar railway station
    {Coordinate{73.672, 18.7348}, CountryId{"IN"}}, // Talegaon railway station
    {Coordinate{11.97, 52.5458}, CountryId{"DE"}}, // Tangermünde station
    {Coordinate{88.0145, 22.8821}, CountryId{"IN"}}, // Tarakeswar railway station
    {Coordinate{79.1383, 10.7781}, CountryId{"IN"}}, // Thanjavur Junction railway station
    {Coordinate{79.6339, 10.7643}, CountryId{"IN"}}, // Thiruvarur Junction railway station
    {Coordinate{88.3243, 22.5986}, CountryId{"IN"}}, // Tikiapara railway station
    {Coordinate{85.4011, 24.822}, CountryId{"IN"}}, // Tilaiya Junction railway station
    {Coordinate{78.7031, 10.8294}, CountryId{"IN"}}, // Tiruchirappalli Town railway station
    {Coordinate{77.3412, 11.1089}, CountryId{"IN"}}, // Tiruppur railway station
    {Coordinate{77.2965, 28.5035}, CountryId{"IN"}}, // Tughlakabad railway station
    {Coordinate{88.0932, 22.4724}, CountryId{"IN"}}, // Uluberia railway station
    {Coordinate{80.4862, 26.5484}, CountryId{"IN"}}, // Unnao railway station
    {Coordinate{80.0718, 12.8672}, CountryId{"IN"}}, // Urapakkam railway station
    {Coordinate{73.6369, 18.7429}, CountryId{"IN"}}, // Vadgaon railway station
    {Coordinate{76.2809, 10.7316}, CountryId{"IN"}}, // Vallathol Nagar railway station
    {Coordinate{77.8906, 8.8821}, CountryId{"IN"}}, // Vanchi Maniyachchi Junction railway station
    {Coordinate{76.7229, 8.74073}, CountryId{"IN"}}, // Varkala Sivagiri railway station
    {Coordinate{72.9084, 20.3734}, CountryId{"IN"}}, // Vapi railway station
    {Coordinate{79.9987, 13.1239}, CountryId{"IN"}}, // Veppampattu railway station
    {Coordinate{18.2256, 46.0667}, CountryId{"HU"}}, // Pécs railway station
    {Coordinate{79.5001, 11.943}, CountryId{"IN"}}, // Viluppuram Junction railway station
    {Coordinate{10.1008, 52.2007}, CountryId{"DE"}}, // Vöhrum station
    {Coordinate{77.6939, 27.5762}, CountryId{"IN"}}, // Vrindavan railway station
    {Coordinate{76.9915, 17.0543}, CountryId{"IN"}}, // Wadi Junction railway station
    {Coordinate{14.0756, 49.9569}, CountryId{"CZ"}}, // Beroun
    {Coordinate{70.9656, 22.6226}, CountryId{"IN"}}, // Wankaner Junction railway station
    {Coordinate{10.6243, 52.2693}, CountryId{"DE"}}, // Weddel railway station
    {Coordinate{9.27942, 47.3755}, CountryId{"CH"}}, // Wilen railway station
    {Coordinate{8.76097, 47.5167}, CountryId{"CH"}}, // Winterthur Wallrüti railway station
    {Coordinate{78.0381, 27.1915}, CountryId{"IN"}}, // Yamuna Bridge railway station
    {Coordinate{13.7547, 52.9639}, CountryId{"DE"}}, // Joachimsthal Kaiserbahnhof
    {Coordinate{25.1895, 62.2568}, CountryId{"FI"}}, // Petäjävesi railway station
    {Coordinate{72.8355, 18.9398}, CountryId{"IN"}}, // Bori Bunder railway station
    {Coordinate{8.78267, 44.7974}, CountryId{"IT"}}, // Q16912683
    {Coordinate{78.482, 17.3407}, CountryId{"IN"}}, // Huppuguda railway station
    {Coordinate{78.4917, 17.3596}, CountryId{"IN"}}, // Yakutpura railway station
    {Coordinate{78.5248, 17.4408}, CountryId{"IN"}}, // Lallaguda railway station
    {Coordinate{9.1275, 48.705}, CountryId{"DE"}}, // Oberaichen station
    {Coordinate{9.37028, 48.8131}, CountryId{"DE"}}, // Endersbach station
    {Coordinate{77.1166, 28.6135}, CountryId{"IN"}}, // Delhi Cantonment railway station
    {Coordinate{80.2512, 12.9893}, CountryId{"IN"}}, // Thiruvanmiyur railway station
    {Coordinate{14.4024, 50.0457}, CountryId{"CZ"}}, // Q16957150
    {Coordinate{15.7428, 49.5697}, CountryId{"CZ"}}, // Přibyslav
    {Coordinate{92.7631, 26.6812}, CountryId{"IN"}}, // Dekargaon railway station
    {Coordinate{83.568, 25.5831}, CountryId{"IN"}}, // Ghazipur City railway station
    {Coordinate{0.77502, 49.7201}, CountryId{"FR"}}, // Q16964672
    {Coordinate{0.562068, 49.4895}, CountryId{"FR"}}, // Q16964674
    {Coordinate{4.39987, 50.8391}, CountryId{"BE"}}, // Merode railway station
    {Coordinate{0.70513, 49.7597}, CountryId{"FR"}}, // Q16964682
    {Coordinate{73.0133, 26.2485}, CountryId{"IN"}}, // Bhagat Ki Kothi railway station
    {Coordinate{13.5469, 49.5653}, CountryId{"CZ"}}, // Q16978284
    {Coordinate{14.4792, 48.9944}, CountryId{"CZ"}}, // Q16978389
    {Coordinate{16.4994, 41.2353}, CountryId{"IT"}}, // Bisceglie railway station
    {Coordinate{77.5138, 17.9117}, CountryId{"IN"}}, // Bidar railway station
    {Coordinate{75.74, 16.8311}, CountryId{"IN"}}, // Bijapur railway station
    {Coordinate{29.1381, 63.5411}, CountryId{"FI"}}, // Nurmes railway station
    {Coordinate{8.57853, 49.3834}, CountryId{"DE"}}, // Schwetzingen train station
    {Coordinate{84.6626, 25.5489}, CountryId{"IN"}}, // Arrah Junction railway station
    {Coordinate{77.5993, 12.9937}, CountryId{"IN"}}, // Bangalore Cantonment railway station
    {Coordinate{78.1782, 12.9848}, CountryId{"IN"}}, // Bangarapet railway station
    {Coordinate{75.1944, 31.8215}, CountryId{"IN"}}, // Batala railway station
    {Coordinate{74.9321, 30.2095}, CountryId{"IN"}}, // Bathinda railway station
    {Coordinate{75.0428, 12.3855}, CountryId{"IN"}}, // Bekal Fort railway station
    {Coordinate{72.9996, 21.7034}, CountryId{"IN"}}, // Bharuch Junction railway station
    {Coordinate{76.1256, 28.7984}, CountryId{"IN"}}, // Bhiwani railway station
    {Coordinate{69.6778, 23.266}, CountryId{"IN"}}, // Bhuj railway station
    {Coordinate{83.3457, 18.5768}, CountryId{"IN"}}, // Bobbili railway station
    {Coordinate{75.7864, 26.8559}, CountryId{"IN"}}, // Durgapura railway station
    {Coordinate{82.3841, 26.5695}, CountryId{"IN"}}, // Goshainganj railway station
    {Coordinate{78.1823, 26.2165}, CountryId{"IN"}}, // Gwalior Junction railway station
    {Coordinate{12.876, 46.0203}, CountryId{"IT"}}, // Q17056852
    {Coordinate{12.5509, 37.9914}, CountryId{"IT"}}, // Q17056890
    {Coordinate{12.5042, 37.9265}, CountryId{"IT"}}, // Q17056891
    {Coordinate{12.4772, 37.8363}, CountryId{"IT"}}, // Q17056893
    {Coordinate{12.4432, 37.7932}, CountryId{"IT"}}, // Marsala railway station
    {Coordinate{12.4807, 37.7486}, CountryId{"IT"}}, // Q17056895
    {Coordinate{12.7333, 37.6363}, CountryId{"IT"}}, // Q17056899
    {Coordinate{12.8657, 37.8067}, CountryId{"IT"}}, // Salemi-Gibellina railway station
    {Coordinate{12.9489, 37.8579}, CountryId{"IT"}}, // Q17056904
    {Coordinate{12.9157, 37.9789}, CountryId{"IT"}}, // Q17056905
    {Coordinate{12.4991, 37.8849}, CountryId{"IT"}}, // Q17056946
    {Coordinate{67.8902, 55.0711}, CountryId{"RU"}}, // Q17057303
    {Coordinate{58.1141, 53.9104}, CountryId{"RU"}}, // Q17057339
    {Coordinate{58.1796, 53.9168}, CountryId{"RU"}}, // Q17057342
    {Coordinate{58.2398, 53.9223}, CountryId{"RU"}}, // Q17057343
    {Coordinate{88.2658, 22.7206}, CountryId{"IN"}}, // Janai Road railway station
    {Coordinate{84.99, 25.2247}, CountryId{"IN"}}, // Jehanabad railway station
    {Coordinate{82.9461, 19.8741}, CountryId{"IN"}}, // Junagarh Road railway station
    {Coordinate{82.1039, 21.1131}, CountryId{"IN"}}, // Mahasamund Railway Station
    {Coordinate{78.7933, 10.0685}, CountryId{"IN"}}, // Karaikkudi Junction railway station
    {Coordinate{73.3775, 18.7551}, CountryId{"IN"}}, // Khandala railway station
    {Coordinate{87.3249, 22.3399}, CountryId{"IN"}}, // Kharagpur Junction railway station
    {Coordinate{78.3311, 24.0515}, CountryId{"IN"}}, // Khurai railway station
    {Coordinate{79.7663, 11.7151}, CountryId{"IN"}}, // Cuddalore Port Junction railway station
    {Coordinate{75.4171, 18.0913}, CountryId{"IN"}}, // Kurduvadi railway station
    {Coordinate{76.7941, 30.4798}, CountryId{"IN"}}, // Lalru railway station
    {Coordinate{72.3887, 23.6026}, CountryId{"IN"}}, // Mahesana railway station
    {Coordinate{78.4535, 9.68154}, CountryId{"IN"}}, // Manamadurai Junction railway station
    {Coordinate{73.6093, 25.7205}, CountryId{"IN"}}, // Marwar Junction railway station
    {Coordinate{90.6339, 25.9151}, CountryId{"IN"}}, // Mendipathar railway station
    {Coordinate{78.8019, 10.3725}, CountryId{"IN"}}, // Pudukkottai railway station
    {Coordinate{79.5335, 16.8604}, CountryId{"IN"}}, // Miryalaguda railway station
    {Coordinate{70.2765, 25.7426}, CountryId{"IN"}}, // Munabao railway station
    {Coordinate{7.74861, 46.0097}, CountryId{"CH"}}, // Findelbach railway station
    {Coordinate{77.5212, 10.4587}, CountryId{"IN"}}, // Palani railway station
    {Coordinate{75.9394, 24.6446}, CountryId{"IN"}}, // Ramganj Mandi railway station
    {Coordinate{85.7874, 25.8583}, CountryId{"IN"}}, // Samastipur Junction railway station
    {Coordinate{73.2904, 19.0091}, CountryId{"IN"}}, // Water pipe railway station
    {Coordinate{75.8934, 17.6645}, CountryId{"IN"}}, // Solapur railway station
    {Coordinate{7.61904, 51.5047}, CountryId{"DE"}}, // Holzwickede station
    {Coordinate{7.68, 46.6861}, CountryId{"CH"}}, // Spiez railway station
    {Coordinate{13.2271, 50.7067}, CountryId{"DE"}}, // Pockau-Lengefeld station
    {Coordinate{17.1231, 40.8564}, CountryId{"IT"}}, // Putignano railway station
    {Coordinate{7.75389, 46.0047}, CountryId{"CH"}}, // Riffelalp railway station
    {Coordinate{7.755, 45.9928}, CountryId{"CH"}}, // Riffelberg railway station
    {Coordinate{7.68634, 45.0995}, CountryId{"IT"}}, // Torino Rebaudengo Fossata railway station
    {Coordinate{16.4178, 41.2725}, CountryId{"IT"}}, // Trani railway station
    {Coordinate{17.0174, 40.9142}, CountryId{"IT"}}, // Turi railway station
    {Coordinate{81.0444, 16.6941}, CountryId{"IN"}}, // Vatluru railway station
    {Coordinate{72.053, 23.1291}, CountryId{"IN"}}, // Viramgam railway station
    {Coordinate{78.1175, 8.5025}, CountryId{"IN"}}, // Thiruchendur railway station
    {Coordinate{10.8376, 48.2665}, CountryId{"DE"}}, // Q17122383
    {Coordinate{13.5628, 47.4076}, CountryId{"AT"}}, // Q17122384
    {Coordinate{8.99, 49.6568}, CountryId{"DE"}}, // Railway Station Erbach (Odenw)
    {Coordinate{6.97326, 51.6145}, CountryId{"DE"}}, // Q17123492
    {Coordinate{27.6892, 62.2103}, CountryId{"FI"}}, // Huutokoski railway station
    {Coordinate{25.3339, 63.7544}, CountryId{"FI"}}, // Haapajärvi railway station
    {Coordinate{12.9862, 43.3458}, CountryId{"IT"}}, // Albacina railway station
    {Coordinate{12.8588, 43.3452}, CountryId{"IT"}}, // Q17145113
    {Coordinate{12.8183, 43.4621}, CountryId{"IT"}}, // Monterosso Marche railway station
    {Coordinate{12.8513, 43.4364}, CountryId{"IT"}}, // Sassoferrato-Arcevia train station
    {Coordinate{16.6479, 40.7989}, CountryId{"IT"}}, // Casal Sabini
    {Coordinate{29.2369, 62.6414}, CountryId{"FI"}}, // Wine Lake Station area
    {Coordinate{13.6748, 37.5704}, CountryId{"IT"}}, // Acquaviva-Casteltermini railway station
    {Coordinate{12.8242, 43.5202}, CountryId{"IT"}}, // Q17146356
    {Coordinate{11.6024, 44.0684}, CountryId{"IT"}}, // Stazione di Biforco
    {Coordinate{13.6867, 37.5101}, CountryId{"IT"}}, // Campofranco railway station
    {Coordinate{14.2105, 41.1014}, CountryId{"IT"}}, // Capua railway station
    {Coordinate{13.7847, 37.9539}, CountryId{"IT"}}, // Cerda railway station
    {Coordinate{13.653, 37.4238}, CountryId{"IT"}}, // Q17146370
    {Coordinate{11.5482, 44.0418}, CountryId{"IT"}}, // Stazione di Crespino del Lamone
    {Coordinate{15.8241, 39.6769}, CountryId{"IT"}}, // Q17146374
    {Coordinate{13.838, 42.7059}, CountryId{"IT"}}, // Bellante-Ripattone railway station
    {Coordinate{13.7929, 42.6957}, CountryId{"IT"}}, // Q17146388
    {Coordinate{12.757, 43.2839}, CountryId{"IT"}}, // Fossato di Vico-Gubbio train station
    {Coordinate{12.7673, 43.2334}, CountryId{"IT"}}, // Q17146397
    {Coordinate{13.6933, 37.859}, CountryId{"IT"}}, // Q17146400
    {Coordinate{13.8763, 42.7067}, CountryId{"IT"}}, // Q17146404
    {Coordinate{11.6364, 44.093}, CountryId{"IT"}}, // Q17146420
    {Coordinate{13.8968, 42.9127}, CountryId{"IT"}}, // Porto d'Ascoli train station
    {Coordinate{}, CountryId{"IT"}}, // Q17146425
    {Coordinate{11.8713, 44.5956}, CountryId{"IT"}}, // Q17146426
    {Coordinate{12.8819, 46.045}, CountryId{"IT"}}, // Q17146427
    {Coordinate{13.7742, 37.9031}, CountryId{"IT"}}, // Q17146430
    {Coordinate{12.8986, 46.108}, CountryId{"IT"}}, // Q17146434
    {Coordinate{12.4185, 42.7899}, CountryId{"IT"}}, // Todi Ponte Rio railway station
    {Coordinate{12.918, 46.1526}, CountryId{"IT"}}, // Q17146438
    {Coordinate{12.8711, 46.0004}, CountryId{"IT"}}, // Q17146441
    {Coordinate{13.0666, 46.2193}, CountryId{"IT"}}, // Q17146446
    {Coordinate{11.0025, 45.8613}, CountryId{"IT"}}, // Mori railway halt
    {Coordinate{9.79117, 48.4039}, CountryId{"DE"}}, // Q17148684
    {Coordinate{14.6355, 50.6816}, CountryId{"CZ"}}, // Zákupy
    {Coordinate{80.9186, 26.832}, CountryId{"IN"}}, // Lucknow Junction railway station
    {Coordinate{61.3712, 56.7305}, CountryId{"RU"}}, // Q17154677
    {Coordinate{13.552, 66.0997}, CountryId{"NO"}}, // Elsfjord Station
    {Coordinate{9.88246, 62.6531}, CountryId{"NO"}}, // Fagerhaug Station
    {Coordinate{7.9625, 62.4302}, CountryId{"NO"}}, // Q17194595
    {Coordinate{9.42788, 59.8628}, CountryId{"NO"}}, // Flesberg stasjon
    {Coordinate{10.1851, 61.4493}, CountryId{"NO"}}, // Fåvang Station
    {Coordinate{10.1052, 62.8899}, CountryId{"NO"}}, // Garli Station
    {Coordinate{11.639, 60.824}, CountryId{"NO"}}, // Heradsbygd Station
    {Coordinate{8.35235, 58.5357}, CountryId{"NO"}}, // Herefoss Station
    {Coordinate{10.3071, 60.1889}, CountryId{"NO"}}, // Hval station
    {Coordinate{12.0613, 60.4579}, CountryId{"NO"}}, // Kirkenær Station
    {Coordinate{8.6959, 62.1445}, CountryId{"NO"}}, // Lora stasjon
    {Coordinate{10.2257, 61.385}, CountryId{"NO"}}, // Losna Station
    {Coordinate{10.6589, 63.4389}, CountryId{"NO"}}, // Malvik Station
    {Coordinate{9.50113, 59.6301}, CountryId{"NO"}}, // Meheia Station
    {Coordinate{11.2398, 60.4704}, CountryId{"NO"}}, // Morskogen station
    {Coordinate{10.9064, 59.2694}, CountryId{"NO"}}, // Onsøy Station
    {Coordinate{11.537, 58.9911}, CountryId{"NO"}}, // Prestebakke Station
    {Coordinate{10.5343, 63.428}, CountryId{"NO"}}, // Ranheim Station
    {Coordinate{10.3334, 59.2812}, CountryId{"NO"}}, // Sem Station
    {Coordinate{9.54154, 61.6822}, CountryId{"NO"}}, // Sjoa Station
    {Coordinate{9.89542, 59.8456}, CountryId{"NO"}}, // Skotselv stasjon
    {Coordinate{12.1181, 59.9843}, CountryId{"NO"}}, // Skotterud Station
    {Coordinate{9.30407, 59.5304}, CountryId{"NO"}}, // Tinnegrend Station
    {Coordinate{10.2955, 61.3122}, CountryId{"NO"}}, // Tretten Station
    {Coordinate{10.1063, 60.0841}, CountryId{"NO"}}, // Tyristrand Station
    {Coordinate{9.152, 60.044}, CountryId{"NO"}}, // Veggli Station
    {Coordinate{10.0927, 60.2066}, CountryId{"NO"}}, // Veme Station
    {Coordinate{11.5928, 60.8404}, CountryId{"NO"}}, // Vesterhaug Station
    {Coordinate{12.1149, 60.1113}, CountryId{"NO"}}, // Åbogen Station
    {Coordinate{10.4071, 61.2634}, CountryId{"NO"}}, // Øyer stasjon
    {Coordinate{77.819, 28.2064}, CountryId{"IN"}}, // Khurja Junction railway station
    {Coordinate{80.4582, 16.31}, CountryId{"IN"}}, // New Guntur railway station
    {Coordinate{11.0444, 59.9531}, CountryId{"NO"}}, // Lillestrøm Station
    {Coordinate{24.8436, 60.295}, CountryId{"FI"}}, // Vehkala railway station
    {Coordinate{76.9161, 9.02334}, CountryId{"IN"}}, // Punalur Railway Station
    {Coordinate{15.6506, 41.4081}, CountryId{"IT"}}, // Incoronata railway station
    {Coordinate{16.091, 41.3494}, CountryId{"IT"}}, // Trinitapoli-San Ferdinando di Puglia railway station
    {Coordinate{19.2936, 48.0714}, CountryId{"HU"}}, // Balassagyarmat railway station
    {Coordinate{8.06528, 48.6336}, CountryId{"DE"}}, // Achern station
    {Coordinate{8.99028, 49.3539}, CountryId{"DE"}}, // Aglasterhausen station
    {Coordinate{7.72864, 50.3276}, CountryId{"DE"}}, // Bad Ems station
    {Coordinate{8.29456, 49.1883}, CountryId{"DE"}}, // Bellheim station
    {Coordinate{8.4107, 48.4675}, CountryId{"DE"}}, // Freudenstadt Stadt station
    {Coordinate{11.1852, 53.429}, CountryId{"DE"}}, // Hagenow Stadt railway station
    {Coordinate{30.4156, 59.0531}, CountryId{"RU"}}, // Q17333373
    {Coordinate{17.9283, 62.635}, CountryId{"SE"}}, // Härnösand railway station
    {Coordinate{8.179, 49.5807}, CountryId{"DE"}}, // Q17353341
    {Coordinate{8.27233, 49.0925}, CountryId{"DE"}}, // Jockgrim station
    {Coordinate{8.28348, 49.5119}, CountryId{"DE"}}, // Q17353766
    {Coordinate{8.24987, 49.5139}, CountryId{"DE"}}, // Q17354278
    {Coordinate{17.3297, 62.4864}, CountryId{"SE"}}, // Timrå railway station
    {Coordinate{16.5631, 48.1208}, CountryId{"AT"}}, // Vienna Airport station
    {Coordinate{6.71472, 51.9681}, CountryId{"NL"}}, // Winterswijk railway station
    {Coordinate{36.127, 54.6497}, CountryId{"RU"}}, // Q17385159
    {Coordinate{6.16108, 52.257}, CountryId{"NL"}}, // Deventer railway station
    {Coordinate{13.2879, 43.6773}, CountryId{"IT"}}, // Q17462133
    {Coordinate{44.3363, 48.6812}, CountryId{"RU"}}, // Q17462325
    {Coordinate{15.3927, 50.7716}, CountryId{"CZ"}}, // Harrachov railway station
    {Coordinate{9.17806, 59.3892}, CountryId{"NO"}}, // Gvarv Station
    {Coordinate{9.33889, 59.4567}, CountryId{"NO"}}, // Holtsås Station
    {Coordinate{7.14222, 51.4264}, CountryId{"DE"}}, // Bochum-Dahlhausen station
    {Coordinate{4.78583, 43.9217}, CountryId{"FR"}}, // Gare d'Avignon TGV
    {Coordinate{11.515, 60.9286}, CountryId{"NO"}}, // Grundset Station
    {Coordinate{11.9905, 51.3569}, CountryId{"DE"}}, // Merseburg Hauptbahnhof
    {Coordinate{10.2889, 63.2625}, CountryId{"NO"}}, // Søberg Station
    {Coordinate{10.6353, 62.95}, CountryId{"NO"}}, // Bjørgen Station
    {Coordinate{9.96889, 59.9328}, CountryId{"NO"}}, // Geithus stasjon
    {Coordinate{8.28311, 45.7163}, CountryId{"IT"}}, // Q17494287
    {Coordinate{8.4177, 45.5955}, CountryId{"IT"}}, // Q17494292
    {Coordinate{8.43602, 45.5738}, CountryId{"IT"}}, // Q17494294
    {Coordinate{12.1028, 45.6767}, CountryId{"IT"}}, // Q17494296
    {Coordinate{11.8573, 45.6558}, CountryId{"IT"}}, // Q17494300
    {Coordinate{11.7489, 45.6349}, CountryId{"IT"}}, // Q17494303
    {Coordinate{11.7148, 45.6215}, CountryId{"IT"}}, // Q17494305
    {Coordinate{8.47884, 45.5387}, CountryId{"IT"}}, // Q17494314
    {Coordinate{12.5337, 44.0883}, CountryId{"IT"}}, // Rimini Viserba railway station
    {Coordinate{12.0756, 44.4833}, CountryId{"IT"}}, // Q17494366
    {Coordinate{8.94689, 46.0055}, CountryId{"CH"}}, // Lugano railway station
    {Coordinate{10.8161, 60.9158}, CountryId{"NO"}}, // Rudshøgda Station
    {Coordinate{10.6577, 60.7842}, CountryId{"NO"}}, // Nygard Station
    {Coordinate{75.3106, 19.8593}, CountryId{"IN"}}, // Aurangabad railway station
    {Coordinate{32.6514, 46.6825}, CountryId{"UA"}}, // Puteiska
    {Coordinate{13.3343, 52.597}, CountryId{"DE"}}, // Berlin-Wittenau station
    {Coordinate{12.8817, 47.7308}, CountryId{"DE"}}, // Bad Reichenhall station
    {Coordinate{10.3301, 51.6439}, CountryId{"DE"}}, // Herzberg (Harz) station
    {Coordinate{7.03361, 49.1578}, CountryId{"DE"}}, // Kleinblittersdorf
    {Coordinate{8.42117, 49.4617}, CountryId{"DE"}}, // Ludwigshafen-Mundenheim station
    {Coordinate{30.438, 60.0331}, CountryId{"RU"}}, // Murino
    {Coordinate{8.36036, 49.195}, CountryId{"DE"}}, // Sondernheim station
    {Coordinate{10.9786, 59.2342}, CountryId{"NO"}}, // Lisleby stasjon
    {Coordinate{-8.43205, 40.2088}, CountryId{"PT"}}, // Coimbra-Cidade train station
    {Coordinate{10.3712, 60.6794}, CountryId{"NO"}}, // Fall stasjon
    {Coordinate{36.6114, 45.3636}, CountryId{"UA"}}, // Krym
    {Coordinate{14.4517, 50.1231}, CountryId{"CZ"}}, // Kobylisy
    {Coordinate{-7.05562, 43.536}, CountryId{"ES"}}, // Q17631368
    {Coordinate{15.3822, 41.7786}, CountryId{"IT"}}, // Apricena Città railway station
    {Coordinate{12.2947, 42.518}, CountryId{"IT"}}, // Attigliano-Bomarzo railway station
    {Coordinate{8.7144, 46.2398}, CountryId{"CH"}}, // Q17637112
    {Coordinate{13.6876, 45.754}, CountryId{"IT"}}, // Aurisina railway station
    {Coordinate{8.74292, 46.2058}, CountryId{"CH"}}, // Q17637118
    {Coordinate{11.9694, 44.4123}, CountryId{"IT"}}, // Q17637120
    {Coordinate{11.9954, 45.0608}, CountryId{"IT"}}, // Baricetta train station
    {Coordinate{8.60747, 46.3393}, CountryId{"CH"}}, // Q17637133
    {Coordinate{8.62239, 46.1584}, CountryId{"CH"}}, // Q17637136
    {Coordinate{9.05639, 40.8919}, CountryId{"IT"}}, // Q17637145
    {Coordinate{8.45164, 46.1358}, CountryId{"IT"}}, // Q17637147
    {Coordinate{8.61108, 46.1548}, CountryId{"CH"}}, // Q17637154
    {Coordinate{12.2492, 45.1112}, CountryId{"IT"}}, // Cavanella d’Adige railway station
    {Coordinate{11.5702, 45.5963}, CountryId{"IT"}}, // Q17637176
    {Coordinate{8.72123, 46.1837}, CountryId{"CH"}}, // Cavigliano train station
    {Coordinate{8.39867, 46.1266}, CountryId{"IT"}}, // Q17637193
    {Coordinate{12.779, 42.412}, CountryId{"IT"}}, // Q17637204
    {Coordinate{8.67516, 46.1688}, CountryId{"CH"}}, // Q17637209
    {Coordinate{8.32562, 46.1241}, CountryId{"IT"}}, // Q17637214
    {Coordinate{7.36991, 44.4627}, CountryId{"IT"}}, // Dronero railway station
    {Coordinate{8.43367, 46.133}, CountryId{"IT"}}, // Q17637235
    {Coordinate{11.5463, 45.6351}, CountryId{"IT"}}, // Dueville railway station
    {Coordinate{8.55804, 46.1343}, CountryId{"IT"}}, // Folsogno-Dissimo railway station
    {Coordinate{8.41983, 46.1288}, CountryId{"IT"}}, // Q17637269
    {Coordinate{16.6689, 41.1808}, CountryId{"IT"}}, // Giovinazzo railway station
    {Coordinate{12.0712, 44.3894}, CountryId{"IT"}}, // Godo railway halt
    {Coordinate{8.74185, 46.2249}, CountryId{"CH"}}, // Q17637281
    {Coordinate{12.7768, 42.4628}, CountryId{"IT"}}, // Q17637283
    {Coordinate{8.70222, 46.1775}, CountryId{"CH"}}, // Q17637306
    {Coordinate{12.7463, 42.5061}, CountryId{"IT"}}, // Labro-Moggio railway station
    {Coordinate{11.913, 45.0434}, CountryId{"IT"}}, // Q17637327
    {Coordinate{8.80101, 46.1727}, CountryId{"CH"}}, // Locarno FART station
    {Coordinate{8.78614, 46.1689}, CountryId{"CH"}}, // Locarno Sant'Antonio train station
    {Coordinate{8.6904, 46.2613}, CountryId{"CH"}}, // Q17637337
    {Coordinate{12.1916, 45.0595}, CountryId{"IT"}}, // Q17637338
    {Coordinate{8.94771, 46.0045}, CountryId{"CH"}}, // Lugano FPL railway station
    {Coordinate{8.49935, 46.1292}, CountryId{"IT"}}, // Q17637358
    {Coordinate{11.4246, 45.7068}, CountryId{"IT"}}, // Q17637360
    {Coordinate{12.7151, 42.5474}, CountryId{"IT"}}, // Q17637371
    {Coordinate{8.33342, 46.1226}, CountryId{"IT"}}, // Q17637373
    {Coordinate{8.32403, 46.132}, CountryId{"IT"}}, // Q17637376
    {Coordinate{8.98305, 45.8774}, CountryId{"CH"}}, // Q17637381
    {Coordinate{16.5964, 41.1958}, CountryId{"IT"}}, // Molfetta railway station
    {Coordinate{8.54342, 39.2446}, CountryId{"IT"}}, // Monte Arcau railway station
    {Coordinate{14.7575, 40.82}, CountryId{"IT"}}, // Q17637409
    {Coordinate{10.8237, 45.3067}, CountryId{"IT"}}, // Mozzecane railway station
    {Coordinate{8.06125, 44.339}, CountryId{"IT"}}, // Q17637417
    {Coordinate{11.6065, 45.2217}, CountryId{"IT"}}, // Q17637425
    {Coordinate{8.63095, 46.1611}, CountryId{"CH"}}, // Q17637428
    {Coordinate{15.3507, 41.8077}, CountryId{"IT"}}, // Q17637455
    {Coordinate{8.75327, 46.1858}, CountryId{"CH"}}, // Q17637457
    {Coordinate{8.29269, 46.1456}, CountryId{"IT"}}, // Preglia railway station
    {Coordinate{8.4796, 46.1331}, CountryId{"IT"}}, // Q17637478
    {Coordinate{10.9119, 44.6913}, CountryId{"IT"}}, // Quattro Ville railway halt
    {Coordinate{8.5395, 46.1273}, CountryId{"IT"}}, // Q17637487
    {Coordinate{8.60177, 46.1543}, CountryId{"IT"}}, // Q17637494
    {Coordinate{15.49, 41.5792}, CountryId{"IT"}}, // Rignano Garganico railway station
    {Coordinate{12.2195, 42.2825}, CountryId{"IT"}}, // Q17637520
    {Coordinate{8.5442, 45.5111}, CountryId{"IT"}}, // Q17637527
    {Coordinate{8.77037, 46.172}, CountryId{"CH"}}, // San Martino train station
    {Coordinate{8.4605, 46.1364}, CountryId{"IT"}}, // Q17637544
    {Coordinate{11.8491, 44.3565}, CountryId{"IT"}}, // Solarolo railway station
    {Coordinate{8.77759, 46.1695}, CountryId{"CH"}}, // Solduno train station
    {Coordinate{10.9061, 44.7227}, CountryId{"IT"}}, // Soliera Modenese railway station
    {Coordinate{8.6619, 46.2867}, CountryId{"CH"}}, // Q17637569
    {Coordinate{14.093, 41.1858}, CountryId{"IT"}}, // Q17637573
    {Coordinate{12.6538, 42.518}, CountryId{"IT"}}, // Stroncone railway station
    {Coordinate{8.74278, 46.1861}, CountryId{"CH"}}, // Q17637585
    {Coordinate{12.625, 42.5496}, CountryId{"IT"}}, // Terni Cospea railway station
    {Coordinate{12.7828, 42.4363}, CountryId{"IT"}}, // Terria train station
    {Coordinate{11.4767, 45.6999}, CountryId{"IT"}}, // Q17637595
    {Coordinate{12.1833, 41.9243}, CountryId{"IT"}}, // Q17637600
    {Coordinate{10.3627, 44.8857}, CountryId{"IT"}}, // Torrile-San Polo railway station
    {Coordinate{8.33354, 46.1226}, CountryId{"IT"}}, // Q17637611
    {Coordinate{8.24491, 46.2063}, CountryId{"IT"}}, // Varzo railway station
    {Coordinate{8.64939, 46.1652}, CountryId{"CH"}}, // Q17637629
    {Coordinate{8.35215, 46.1219}, CountryId{"IT"}}, // Q17637630
    {Coordinate{8.72987, 46.1846}, CountryId{"CH"}}, // Verscio train station
    {Coordinate{11.5241, 45.6569}, CountryId{"IT"}}, // Q17637637
    {Coordinate{8.49076, 46.1296}, CountryId{"IT"}}, // Q17637645
    {Coordinate{10.4619, 59.8589}, CountryId{"NO"}}, // Hvalstad Station
    {Coordinate{12.0825, 50.0044}, CountryId{"DE"}}, // Marktredwitz station
    {Coordinate{8.95111, 60.2681}, CountryId{"NO"}}, // Rødberg stasjon
    {Coordinate{9.61028, 59.7164}, CountryId{"NO"}}, // Pikerfoss Station
    {Coordinate{10.0581, 60.0436}, CountryId{"NO"}}, // Nakkerud stasjon
    {Coordinate{24.7337, 59.4114}, CountryId{"EE"}}, // Tondi railway station
    {Coordinate{32.0503, 49.4261}, CountryId{"UA"}}, // Cherkasy
    {Coordinate{8.58297, 47.4482}, CountryId{"CH"}}, // Kloten railway station
    {Coordinate{8.56174, 47.4292}, CountryId{"CH"}}, // Opfikon railway station
    {Coordinate{8.47208, 47.4368}, CountryId{"CH"}}, // Regensdorf-Watt railway station
    {Coordinate{8.50824, 47.421}, CountryId{"CH"}}, // Zurich Affoltern railway station
    {Coordinate{8.43615, 47.4533}, CountryId{"CH"}}, // Buchs-Dällikon railway station
    {Coordinate{2.34028, 48.8467}, CountryId{"FR"}}, // Gare du Luxembourg
    {Coordinate{10.7303, 59.9147}, CountryId{"NO"}}, // Nationaltheatret Station
    {Coordinate{13.0194, 64.8464}, CountryId{"NO"}}, // Brekkvasselv Station
    {Coordinate{80.3536, 15.8308}, CountryId{"IN"}}, // Chirala railway station
    {Coordinate{80.4684, 15.9086}, CountryId{"IN"}}, // Bapatla railway station
    {Coordinate{15.2231, 51.2901}, CountryId{"PL"}}, // Węgliniec railway station
    {Coordinate{47.0465, 53.1509}, CountryId{"RU"}}, // Q17749204
    {Coordinate{46.8288, 53.1052}, CountryId{"RU"}}, // Q17749214
    {Coordinate{46.2287, 53.1402}, CountryId{"RU"}}, // Q17749510
    {Coordinate{}, CountryId{"NO"}}, // Aurdal Station
    {Coordinate{16.0803, 49.5686}, CountryId{"CZ"}}, // Q17749879
    {Coordinate{13.7358, 50.0989}, CountryId{"CZ"}}, // Rakovník (train station)
    {Coordinate{17.5317, 49.2026}, CountryId{"CZ"}}, // Otrokovice railway station
    {Coordinate{14.2431, 48.6336}, CountryId{"CZ"}}, // Q17749936
    {Coordinate{16.9626, 48.7328}, CountryId{"CZ"}}, // Lanžhot railway station
    {Coordinate{14.4922, 50.3528}, CountryId{"CZ"}}, // Mělník
    {Coordinate{12.6444, 50.1858}, CountryId{"CZ"}}, // Sokolov
    {Coordinate{17.3827, 48.9488}, CountryId{"CZ"}}, // Q17749949
    {Coordinate{13.1531, 49.2969}, CountryId{"CZ"}}, // Q17749990
    {Coordinate{16.7561, 50.0806}, CountryId{"CZ"}}, // Q17749992
    {Coordinate{17.9605, 49.4745}, CountryId{"CZ"}}, // Valašské Meziříčí
    {Coordinate{15.3491, 48.9938}, CountryId{"CZ"}}, // Q17750055
    {Coordinate{14.0031, 49.6889}, CountryId{"CZ"}}, // Q17750059
    {Coordinate{14.3086, 48.6236}, CountryId{"CZ"}}, // Vyšší Brod klášter
    {Coordinate{15.3942, 49.9156}, CountryId{"CZ"}}, // Q17750064
    {Coordinate{17.9939, 49.3353}, CountryId{"CZ"}}, // Q17750066
    {Coordinate{15.7867, 49.9483}, CountryId{"CZ"}}, // Chrudim
    {Coordinate{15.1383, 50.5869}, CountryId{"CZ"}}, // Turnov
    {Coordinate{17.6585, 49.2265}, CountryId{"CZ"}}, // Q17750109
    {Coordinate{13.8228, 50.3611}, CountryId{"CZ"}}, // Q17750110
    {Coordinate{17.122, 48.8564}, CountryId{"CZ"}}, // Hodonín railway station
    {Coordinate{14.0756, 50.2283}, CountryId{"CZ"}}, // Q17750112
    {Coordinate{}, CountryId{"NO"}}, // Bjørgo Station
    {Coordinate{6.73683, 58.4096}, CountryId{"NO"}}, // Q17750496
    {Coordinate{16.4856, 48.2334}, CountryId{"AT"}}, // Hausfeldstraße
    {Coordinate{7.95198, 58.1626}, CountryId{"NO"}}, // Dalane train station
    {Coordinate{10.0269, 60.015}, CountryId{"NO"}}, // Q17767848
    {Coordinate{}, CountryId{"NO"}}, // Fluberg Station
    {Coordinate{12.3422, 64.4005}, CountryId{"NO"}}, // Formofoss stasjon
    {Coordinate{11.3296, 59.4738}, CountryId{"NO"}}, // Heia Station
    {Coordinate{10.8031, 59.8464}, CountryId{"NO"}}, // Hauketo Station
    {Coordinate{10.8375, 59.7561}, CountryId{"NO"}}, // Vevelstad Station
    {Coordinate{10.7977, 59.8234}, CountryId{"NO"}}, // Rosenholm Station
    {Coordinate{10.8004, 59.7866}, CountryId{"NO"}}, // Myrvoll Station
    {Coordinate{10.6574, 59.4321}, CountryId{"NO"}}, // Moss Station
    {Coordinate{11.1179, 59.2858}, CountryId{"NO"}}, // Sarpsborg Station
    {Coordinate{10.8369, 59.7503}, CountryId{"NO"}}, // Langhus Station
    {Coordinate{11.3049, 59.5137}, CountryId{"NO"}}, // Eidsberg Station
    {Coordinate{11.2615, 59.5671}, CountryId{"NO"}}, // Slitu Station
    {Coordinate{10.8042, 59.8013}, CountryId{"NO"}}, // Solbråtan Station
    {Coordinate{11.0794, 59.6208}, CountryId{"NO"}}, // Spydeberg Station
    {Coordinate{10.8011, 59.8108}, CountryId{"NO"}}, // Kolbotn Station
    {Coordinate{11.3393, 59.4271}, CountryId{"NO"}}, // Rakkestad Station
    {Coordinate{11.0327, 59.6245}, CountryId{"NO"}}, // Knapstad Station
    {Coordinate{10.9506, 59.2091}, CountryId{"NO"}}, // Fredrikstad Station
    {Coordinate{11.1631, 59.5817}, CountryId{"NO"}}, // Askim Station
    {Coordinate{10.6922, 59.4775}, CountryId{"NO"}}, // Kambo Station
    {Coordinate{10.7854, 59.8636}, CountryId{"NO"}}, // Nordstrand Station
    {Coordinate{10.8112, 59.7697}, CountryId{"NO"}}, // Oppegård Station
    {Coordinate{10.7256, 59.5146}, CountryId{"NO"}}, // Sonsveien Station
    {Coordinate{10.9475, 59.665}, CountryId{"NO"}}, // Skotbu Station
    {Coordinate{10.8075, 59.7723}, CountryId{"NO"}}, // Greverud Station
    {Coordinate{11.3236, 59.5542}, CountryId{"NO"}}, // Mysen Station
    {Coordinate{10.4378, 61.2232}, CountryId{"NO"}}, // Hunderfossen Station
    {Coordinate{10.6993, 60.9292}, CountryId{"NO"}}, // Moelv Station
    {Coordinate{11.1956, 60.7172}, CountryId{"NO"}}, // Stange Station
    {Coordinate{10.1388, 61.5291}, CountryId{"NO"}}, // Ringebu Station
    {Coordinate{10.2853, 63.0517}, CountryId{"NO"}}, // Støren Station
    {Coordinate{10.8663, 59.3477}, CountryId{"NO"}}, // Råde Station
    {Coordinate{10.7486, 59.6039}, CountryId{"NO"}}, // Vestby Station
    {Coordinate{11.0026, 59.6599}, CountryId{"NO"}}, // Tomter Station
    {Coordinate{10.7851, 59.853}, CountryId{"NO"}}, // Ljan Station
    {Coordinate{10.8909, 59.6833}, CountryId{"NO"}}, // Kråkstad Station
    {Coordinate{10.7973, 59.8356}, CountryId{"NO"}}, // Holmlia Station
    {Coordinate{11.3842, 59.1202}, CountryId{"NO"}}, // Halden Station
    {Coordinate{10.7481, 59.3781}, CountryId{"NO"}}, // Rygge Station
    {Coordinate{10.8349, 59.7195}, CountryId{"NO"}}, // Ski Station
    {Coordinate{13.6311, 52.2966}, CountryId{"DE"}}, // Königs Wusterhausen station
    {Coordinate{10.8986, 63.4461}, CountryId{"NO"}}, // Hell Station
    {Coordinate{14.3914, 67.2864}, CountryId{"NO"}}, // Bodø Station
    {Coordinate{7.8699, 60.5114}, CountryId{"NO"}}, // Haugastøl Station
    {Coordinate{6.41035, 60.6292}, CountryId{"NO"}}, // Voss Station
    {Coordinate{9.32297, 59.4178}, CountryId{"NO"}}, // Nordagutu Station
    {Coordinate{5.62414, 60.429}, CountryId{"NO"}}, // Trengereid Station
    {Coordinate{5.46643, 60.4204}, CountryId{"NO"}}, // Arna Station
    {Coordinate{8.51556, 47.1742}, CountryId{"CH"}}, // Zug railway station
    {Coordinate{5.73556, 60.4786}, CountryId{"NO"}}, // Vaksdal Station
    {Coordinate{7.0125, 60.7256}, CountryId{"NO"}}, // Upsete Station
    {Coordinate{5.8163, 60.5865}, CountryId{"NO"}}, // Dale Station
    {Coordinate{9.145, 45.1889}, CountryId{"IT"}}, // Pavia railway station
    {Coordinate{5.54944, 53.1822}, CountryId{"NL"}}, // Franeker railway station
    {Coordinate{6.56389, 53.2106}, CountryId{"NL"}}, // Groningen railway station
    {Coordinate{6.58444, 53.205}, CountryId{"NL"}}, // Groningen Europapark railway station
    {Coordinate{6.55639, 53.23}, CountryId{"NL"}}, // Groningen Noord railway station
    {Coordinate{5.79324, 53.1965}, CountryId{"NL"}}, // Leeuwarden railway station
    {Coordinate{5.84167, 53.2019}, CountryId{"NL"}}, // Leeuwarden Camminghaburen railway station
    {Coordinate{5.81639, 53.1989}, CountryId{"NL"}}, // Leeuwarden Achter de Hoven railway station
    {Coordinate{6.51861, 53.3614}, CountryId{"NL"}}, // Baflo railway station
    {Coordinate{6.51972, 53.3306}, CountryId{"NL"}}, // Winsum railway station
    {Coordinate{11.4016, 63.8575}, CountryId{"NO"}}, // Røra Station
    {Coordinate{10.5847, 60.3053}, CountryId{"NO"}}, // Lunner Station
    {Coordinate{11.7292, 45.9197}, CountryId{"IT"}}, // Q18005296
    {Coordinate{14.3959, 41.0486}, CountryId{"IT"}}, // Maddaloni Superiore railway station
    {Coordinate{8.79518, 40.7776}, CountryId{"IT"}}, // Martis train station
    {Coordinate{11.7247, 45.7945}, CountryId{"IT"}}, // Q18005304
    {Coordinate{11.6914, 45.8381}, CountryId{"IT"}}, // Q18005310
    {Coordinate{8.2126, 48.9806}, CountryId{"DE"}}, // Bahnhof Berg (Pfalz)
    {Coordinate{19.1272, 47.4829}, CountryId{"HU"}}, // Kőbánya alsó railway station
    {Coordinate{19.1338, 47.4918}, CountryId{"HU"}}, // Kőbánya felső railway station
    {Coordinate{8.23852, 48.9923}, CountryId{"DE"}}, // Q18005407
    {Coordinate{19.097, 47.4338}, CountryId{"HU"}}, // Pesterzsébet railway station
    {Coordinate{19.1881, 47.4025}, CountryId{"HU"}}, // Pestszentimre railway station
    {Coordinate{19.1731, 47.414}, CountryId{"HU"}}, // Pestszentimre felső railway station
    {Coordinate{19.1823, 47.455}, CountryId{"HU"}}, // Pestszentlőrinc railway station
    {Coordinate{19.1223, 47.5777}, CountryId{"HU"}}, // Rákospalota-Kertváros railway station
    {Coordinate{19.1462, 47.5212}, CountryId{"HU"}}, // Rákosszentmihály railway station
    {Coordinate{1.61806, 43.7506}, CountryId{"FR"}}, // Gare de Roqueserière-Buzet
    {Coordinate{19.1232, 47.4023}, CountryId{"HU"}}, // Soroksár railway station
    {Coordinate{19.0836, 47.4575}, CountryId{"HU"}}, // Soroksári út railway station
    {Coordinate{19.2128, 47.444}, CountryId{"HU"}}, // Szemeretelep railway station
    {Coordinate{6.23753, 60.632}, CountryId{"NO"}}, // Seimsgrend Station
    {Coordinate{6.28276, 60.6309}, CountryId{"NO"}}, // Bulken Station
    {Coordinate{5.73306, 60.5489}, CountryId{"NO"}}, // Stanghelle Station
    {Coordinate{5.95802, 60.6378}, CountryId{"NO"}}, // Bolstadøyri Station
    {Coordinate{6.10934, 60.647}, CountryId{"NO"}}, // Evanger Station
    {Coordinate{11.7908, 50.1891}, CountryId{"DE"}}, // Q18018567
    {Coordinate{9.76691, 49.0968}, CountryId{"DE"}}, // Schwäbisch Hall-Hessental station
    {Coordinate{12.4317, 52.0989}, CountryId{"DE"}}, // Q18018576
    {Coordinate{12.9131, 49.7628}, CountryId{"CZ"}}, // Svojšín
    {Coordinate{-0.296208, 46.3605}, CountryId{"FR"}}, // Q1808439
    {Coordinate{6.78213, 51.1235}, CountryId{"DE"}}, // Nievenheim station
    {Coordinate{9.33611, 59.5119}, CountryId{"NO"}}, // Trykkerud Station
    {Coordinate{7.63829, 48.4231}, CountryId{"FR"}}, // Erstein
    {Coordinate{2.4592, 49.8993}, CountryId{"FR"}}, // Gare de Daours
    {Coordinate{16.3159, 48.1668}, CountryId{"AT"}}, // Wien Hetzendorf railway station
    {Coordinate{6.42083, 52.2839}, CountryId{"NL"}}, // Holten railway station
    {Coordinate{2.75125, 48.4872}, CountryId{"FR"}}, // Q1810022
    {Coordinate{-3.15721, 48.7056}, CountryId{"FR"}}, // Q1810028
    {Coordinate{10.7225, 60.206}, CountryId{"NO"}}, // Harestua Station
    {Coordinate{7.83152, 48.9163}, CountryId{"FR"}}, // Q1810354
    {Coordinate{6.4161, 48.2446}, CountryId{"FR"}}, // Q1810836
    {Coordinate{7.39768, 51.3417}, CountryId{"DE"}}, // Hagen-Westerbauer station
    {Coordinate{76.7692, 11.3591}, CountryId{"IN"}}, // Aravankadu railway station
    {Coordinate{79.0683, 11.15}, CountryId{"IN"}}, // Ariyalur railway station
    {Coordinate{75.1892, 33.4507}, CountryId{"IN"}}, // Banihal
    {Coordinate{78.8985, 17.5247}, CountryId{"IN"}}, // Bhongir railway station
    {Coordinate{78.7944, 17.4705}, CountryId{"IN"}}, // Bibinagar railway station
    {Coordinate{81.8654, 25.3787}, CountryId{"IN"}}, // Cheoki junction
    {Coordinate{79.7033, 11.3915}, CountryId{"IN"}}, // Chidambaram railway station
    {Coordinate{76.7913, 11.3437}, CountryId{"IN"}}, // Coonoor railway station
    {Coordinate{-0.368163, 48.7019}, CountryId{"FR"}}, // Gare de Briouze
    {Coordinate{77.9855, 10.3538}, CountryId{"IN"}}, // Dindigul Junction railway station
    {Coordinate{80.1532, 17.446}, CountryId{"IN"}}, // Dornakal Junction railway station
    {Coordinate{-0.814986, 44.71}, CountryId{"FR"}}, // gare de Croix-d'Hins
    {Coordinate{1.205, 45.7783}, CountryId{"FR"}}, // Gare de l'Aiguille
    {Coordinate{8.58681, 50.2833}, CountryId{"DE"}}, // Bahnhof Saalburg
    {Coordinate{76.6231, 8.86695}, CountryId{"IN"}}, // Eravipuram railway station
    {Coordinate{78.6782, 17.4531}, CountryId{"IN"}}, // Ghatkesar railway station
    {Coordinate{73.8934, 18.5278}, CountryId{"IN"}}, // Ghorpuri railway station
    {Coordinate{80.9876, 16.4299}, CountryId{"IN"}}, // Gudivada Junction railway station
    {Coordinate{83.81, 19.0691}, CountryId{"IN"}}, // Gunupur railway station
    {Coordinate{73.9278, 18.5269}, CountryId{"IN"}}, // Hadapsar railway station
    {Coordinate{75.9899, 17.5657}, CountryId{"IN"}}, // Hotgi Junction railway station
    {Coordinate{75.1481, 15.3503}, CountryId{"IN"}}, // Hubli Junction railway station
    {Coordinate{88.7097, 26.5594}, CountryId{"IN"}}, // Jalpaiguri Road railway station
    {Coordinate{79.1423, 18.459}, CountryId{"IN"}}, // Karimnagar railway station
    {Coordinate{76.544, 9.06527}, CountryId{"IN"}}, // Karunagappalli railway station
    {Coordinate{78.0851, 10.9656}, CountryId{"IN"}}, // Karur Junction railway station
    {Coordinate{76.7375, 11.382}, CountryId{"IN"}}, // Ketti railway station
    {Coordinate{76.6328, 8.91829}, CountryId{"IN"}}, // Kilikollur railway station
    {Coordinate{80.5467, 16.6232}, CountryId{"IN"}}, // Kondapalli railway station
    {Coordinate{76.766, 9.00028}, CountryId{"IN"}}, // Kottarakkara railway station
    {Coordinate{76.6786, 8.96037}, CountryId{"IN"}}, // Kundara railway station
    {Coordinate{76.8528, 29.9694}, CountryId{"IN"}}, // Kurukshetra Junction railway station
    {Coordinate{76.7043, 11.3824}, CountryId{"IN"}}, // Lovedale railway station
    {Coordinate{79.8931, 12.5044}, CountryId{"IN"}}, // Madurantakam railway station
    {Coordinate{80.565, 16.4383}, CountryId{"IN"}}, // Mangalagiri railway station
    {Coordinate{7.09398, 47.8132}, CountryId{"FR"}}, // Gare de Thann-Saint-Jacques
    {Coordinate{76.6473, 8.83776}, CountryId{"IN"}}, // Mayyanad railway station
    {Coordinate{75.7711, 22.5552}, CountryId{"IN"}}, // Dr. Ambedkar Nagar railway station
    {Coordinate{77.7078, 29.4687}, CountryId{"IN"}}, // Muzaffarnagar railway station
    {Coordinate{78.1791, 11.2261}, CountryId{"IN"}}, // Namakkal railway station
    {Coordinate{89.5414, 26.4857}, CountryId{"IN"}}, // New Alipurduar railway station
    {Coordinate{88.7858, 26.5695}, CountryId{"IN"}}, // New Domohani railway station
    {Coordinate{78.1032, 18.6792}, CountryId{"IN"}}, // Nizamabad railway station
    {Coordinate{80.9615, 16.6499}, CountryId{"IN"}}, // Nuzvid railway station
    {Coordinate{78.0452, 11.7383}, CountryId{"IN"}}, // Omalur Junction railway station
    {Coordinate{72.838, 19.1503}, CountryId{"IN"}}, // Oshiwara railway station
    {Coordinate{78.0721, 12.2974}, CountryId{"IN"}}, // Palakkodu railway station
    {Coordinate{72.4302, 24.1744}, CountryId{"IN"}}, // Palanpur Junction railway station
    {Coordinate{84.0806, 18.7866}, CountryId{"IN"}}, // Parlakhemundi railway station
    {Coordinate{7.22127, 51.2742}, CountryId{"DE"}}, // Wuppertal-Oberbarmen
    {Coordinate{1.5628, 46.6947}, CountryId{"FR"}}, // Q1813754
    {Coordinate{0.675851, 44.2328}, CountryId{"FR"}}, // Gare de Pont-du-Casse
    {Coordinate{15.9461, 50.0019}, CountryId{"CZ"}}, // Moravany (train station)
    {Coordinate{1.74238, 43.744}, CountryId{"FR"}}, // Q1814219
    {Coordinate{3.45139, 50.5694}, CountryId{"BE"}}, // Antoing railway station
    {Coordinate{12.3817, 51.3292}, CountryId{"DE"}}, // Leipzig Bayerischer Bahnhof
    {Coordinate{5.70493, 43.1873}, CountryId{"FR"}}, // Station Saint-Cyr-les-Lecques-la-Cadière
    {Coordinate{2.29167, 48.9797}, CountryId{"FR"}}, // Gare du Champ de courses d'Enghien
    {Coordinate{16.7192, 41.0151}, CountryId{"IT"}}, // Grumo Appula railway station
    {Coordinate{12.0497, 45.1978}, CountryId{"IT"}}, // Q18170171
    {Coordinate{16.0258, 48.7808}, CountryId{"CZ"}}, // Q18170832
    {Coordinate{12.8311, 50.0828}, CountryId{"CZ"}}, // Q18170833
    {Coordinate{15.8743, 48.9231}, CountryId{"CZ"}}, // Šumná
    {Coordinate{15.3, 50.2106}, CountryId{"CZ"}}, // Q18170851
    {Coordinate{13.4358, 49.295}, CountryId{"CZ"}}, // Q18170852
    {Coordinate{16.92, 50.0892}, CountryId{"CZ"}}, // Q18170853
    {Coordinate{16.2736, 50.1578}, CountryId{"CZ"}}, // Rychnov nad Kněžnou
    {Coordinate{13.6633, 50.1417}, CountryId{"CZ"}}, // Q18170875
    {Coordinate{15.7236, 50.0317}, CountryId{"CZ"}}, // Q18170876
    {Coordinate{15.1322, 50.4414}, CountryId{"CZ"}}, // Q18170878
    {Coordinate{15.1886, 49.8156}, CountryId{"CZ"}}, // Q18170880
    {Coordinate{13.3036, 49.3044}, CountryId{"CZ"}}, // Běšiny station
    {Coordinate{14.0294, 50.6581}, CountryId{"CZ"}}, // Ústí nad Labem západ (train station)
    {Coordinate{16.1644, 48.8415}, CountryId{"CZ"}}, // Q18170910
    {Coordinate{14.7581, 50.7692}, CountryId{"CZ"}}, // Q18170911
    {Coordinate{13.3747, 49.7367}, CountryId{"CZ"}}, // Q18170912
    {Coordinate{14.305, 50.7381}, CountryId{"CZ"}}, // Q18170945
    {Coordinate{16.0856, 50.0971}, CountryId{"CZ"}}, // Borohrádek
    {Coordinate{16.2877, 48.8233}, CountryId{"CZ"}}, // Božice u Znojma (train station)
    {Coordinate{16.9231, 50.0581}, CountryId{"CZ"}}, // Q18170982
    {Coordinate{13.6958, 50.0783}, CountryId{"CZ"}}, // Q18170983
    {Coordinate{16.3831, 48.8101}, CountryId{"CZ"}}, // Q18170986
    {Coordinate{15.0614, 50.7472}, CountryId{"CZ"}}, // Q18170987
    {Coordinate{13.9547, 50.6125}, CountryId{"CZ"}}, // Q18170988
    {Coordinate{14.335, 50.5853}, CountryId{"CZ"}}, // Q18171011
    {Coordinate{15.468, 49.8366}, CountryId{"CZ"}}, // Q18171012
    {Coordinate{15.5228, 50.4864}, CountryId{"CZ"}}, // Q18171013
    {Coordinate{13.3478, 49.7417}, CountryId{"CZ"}}, // Q18171014
    {Coordinate{13.6036, 50.1356}, CountryId{"CZ"}}, // Q18171015
    {Coordinate{2.48443, 47.0965}, CountryId{"FR"}}, // Q1817161
    {Coordinate{7.3391, 48.5258}, CountryId{"FR"}}, // Q1817356
    {Coordinate{14.5131, 46.0589}, CountryId{"SI"}}, // Ljubljana railway station
    {Coordinate{-1.11561, 46.1081}, CountryId{"FR"}}, // Q1817868
    {Coordinate{2.40887, 50.7307}, CountryId{"FR"}}, // Ebblinghem
    {Coordinate{16.6635, 49.2953}, CountryId{"CZ"}}, // Adamov
    {Coordinate{14.9228, 50.4719}, CountryId{"CZ"}}, // Q18180125
    {Coordinate{14.0839, 49.1264}, CountryId{"CZ"}}, // Q18180126
    {Coordinate{14.4828, 49.2933}, CountryId{"CZ"}}, // Q18180127
    {Coordinate{15.0708, 49.9558}, CountryId{"CZ"}}, // Bečváry (train station)
    {Coordinate{12.7206, 49.5886}, CountryId{"CZ"}}, // Q18180129
    {Coordinate{14.836, 50.4883}, CountryId{"CZ"}}, // Bělá pod Bezdězem (train station)
    {Coordinate{13.3211, 49.2936}, CountryId{"CZ"}}, // Q18180131
    {Coordinate{12.9694, 49.9031}, CountryId{"CZ"}}, // Q18180132
    {Coordinate{13.7719, 50.5539}, CountryId{"CZ"}}, // Q18180134
    {Coordinate{16.6478, 49.3521}, CountryId{"CZ"}}, // Q18180137
    {Coordinate{13.8725, 49.4308}, CountryId{"CZ"}}, // Blatná railway station
    {Coordinate{16.9011, 50.0261}, CountryId{"CZ"}}, // Q18180139
    {Coordinate{14.1489, 50.4911}, CountryId{"CZ"}}, // Q18180140
    {Coordinate{17.7955, 49.0361}, CountryId{"CZ"}}, // Q18180141
    {Coordinate{12.7783, 49.7175}, CountryId{"CZ"}}, // Bor station
    {Coordinate{16.6514, 49.4913}, CountryId{"CZ"}}, // Q18180145
    {Coordinate{14.6533, 50.1839}, CountryId{"CZ"}}, // Brandýs nad Labem (train station)
    {Coordinate{17.015, 50.1467}, CountryId{"CZ"}}, // Q18180148
    {Coordinate{13.9639, 49.5583}, CountryId{"CZ"}}, // Q18180149
    {Coordinate{16.5204, 49.6333}, CountryId{"CZ"}}, // Q18180150
    {Coordinate{18.0365, 49.0942}, CountryId{"CZ"}}, // Q18180153
    {Coordinate{16.9995, 49.1457}, CountryId{"CZ"}}, // Q18180154
    {Coordinate{17.6139, 49.7956}, CountryId{"CZ"}}, // Q18180155
    {Coordinate{14.1339, 50.405}, CountryId{"CZ"}}, // Q18180156
    {Coordinate{18.014, 49.0677}, CountryId{"CZ"}}, // Bylnice (train station)
    {Coordinate{17.6655, 49.393}, CountryId{"CZ"}}, // Q18180158
    {Coordinate{17.263, 48.9692}, CountryId{"CZ"}}, // Q18180159
    {Coordinate{16.9585, 48.9422}, CountryId{"CZ"}}, // Q18180160
    {Coordinate{14.7542, 50.1578}, CountryId{"CZ"}}, // Čelákovice
    {Coordinate{16.7464, 50.0469}, CountryId{"CZ"}}, // Červená Voda (train station)
    {Coordinate{16.0755, 50.4838}, CountryId{"CZ"}}, // Červený Kostelec (train station)
    {Coordinate{14.4139, 50.7958}, CountryId{"CZ"}}, // Česká Kamenice (train station)
    {Coordinate{12.865, 49.3742}, CountryId{"CZ"}}, // Q18180165
    {Coordinate{16.054, 50.3956}, CountryId{"CZ"}}, // Česká Skalice
    {Coordinate{14.4756, 48.9592}, CountryId{"CZ"}}, // České Budějovice jižní zastávka
    {Coordinate{14.9353, 49.8136}, CountryId{"CZ"}}, // Český Šternberk (train station)
    {Coordinate{14.9297, 49.8083}, CountryId{"CZ"}}, // Q18180170
    {Coordinate{13.9214, 50.6803}, CountryId{"CZ"}}, // Q18180171
    {Coordinate{15.4572, 50.1633}, CountryId{"CZ"}}, // Q18180172
    {Coordinate{12.7539, 50.2314}, CountryId{"CZ"}}, // Q18180173
    {Coordinate{13.4136, 50.4697}, CountryId{"CZ"}}, // Chomutov město
    {Coordinate{15.6825, 49.7117}, CountryId{"CZ"}}, // Q18180175
    {Coordinate{14.9519, 50.8131}, CountryId{"CZ"}}, // Q18180176
    {Coordinate{17.361, 49.3694}, CountryId{"CZ"}}, // Q18180177
    {Coordinate{15.7939, 49.9575}, CountryId{"CZ"}}, // Chrudim město (train station)
    {Coordinate{13.2478, 50.1111}, CountryId{"CZ"}}, // Q18180181
    {Coordinate{15.3292, 49.9424}, CountryId{"CZ"}}, // Q18180182
    {Coordinate{13.5689, 50.0331}, CountryId{"CZ"}}, // Q18180183
    {Coordinate{15.4392, 49.0859}, CountryId{"CZ"}}, // Dačice (train station)
    {Coordinate{15.3089, 50.7533}, CountryId{"CZ"}}, // Q18180185
    {Coordinate{13.3033, 49.6564}, CountryId{"CZ"}}, // Q18180186
    {Coordinate{13.3239, 49.6814}, CountryId{"CZ"}}, // Q18180187
    {Coordinate{14.1833, 49.79}, CountryId{"CZ"}}, // Q18180188
    {Coordinate{16.1522, 50.2892}, CountryId{"CZ"}}, // Dobruška
    {Coordinate{16.7211, 50.0892}, CountryId{"CZ"}}, // Dolní Lipka (train station)
    {Coordinate{12.9431, 49.435}, CountryId{"CZ"}}, // Domažlice railway station
    {Coordinate{13.3831, 49.7217}, CountryId{"CZ"}}, // Q18180201
    {Coordinate{13.755, 50.6172}, CountryId{"CZ"}}, // Q18180206
    {Coordinate{16.9292, 50.0717}, CountryId{"CZ"}}, // Q18180217
    {Coordinate{15.6583, 49.9514}, CountryId{"CZ"}}, // Q18180222
    {Coordinate{17.5709, 49.327}, CountryId{"CZ"}}, // Holešov (train station)
    {Coordinate{15.9925, 50.0692}, CountryId{"CZ"}}, // Q18180233
    {Coordinate{13.7097, 49.3208}, CountryId{"CZ"}}, // Horažďovice
    {Coordinate{12.7664, 50.3878}, CountryId{"CZ"}}, // Q18180235
    {Coordinate{13.3794, 49.8508}, CountryId{"CZ"}}, // Q18180236
    {Coordinate{12.8039, 50.1375}, CountryId{"CZ"}}, // Horní Slavkov
    {Coordinate{12.9375, 49.5242}, CountryId{"CZ"}}, // Q18180239
    {Coordinate{15.7378, 50.5367}, CountryId{"CZ"}}, // Q18180240
    {Coordinate{14.2583, 50.0839}, CountryId{"CZ"}}, // Hostivice (train station)
    {Coordinate{14.3275, 50.4914}, CountryId{"CZ"}}, // Q18180243
    {Coordinate{15.8414, 50.2222}, CountryId{"CZ"}}, // Q18180244
    {Coordinate{15.8594, 50.2217}, CountryId{"CZ"}}, // Q18180245
    {Coordinate{14.847, 50.8558}, CountryId{"CZ"}}, // Hrádek nad Nisou railway station
    {Coordinate{17.7418, 49.5458}, CountryId{"CZ"}}, // Q18180248
    {Coordinate{13.7218, 50.6603}, CountryId{"CZ"}}, // Q18180249
    {Coordinate{16.1767, 50.4728}, CountryId{"CZ"}}, // Hronov (train station)
    {Coordinate{16.5913, 49.0344}, CountryId{"CZ"}}, // Q18180254
    {Coordinate{17.4766, 49.3165}, CountryId{"CZ"}}, // Hulín (train station)
    {Coordinate{15.3482, 49.5349}, CountryId{"CZ"}}, // Humpolec
    {Coordinate{17.4651, 49.1149}, CountryId{"CZ"}}, // Q18180260
    {Coordinate{16.3726, 49.0982}, CountryId{"CZ"}}, // Q18180264
    {Coordinate{17.0872, 49.3063}, CountryId{"CZ"}}, // Ivanovice na Hané
    {Coordinate{15.435, 50.7003}, CountryId{"CZ"}}, // Jablonec nad Jizerou (train station)
    {Coordinate{15.1606, 50.7208}, CountryId{"CZ"}}, // Jablonec nad Nisou (train station)
    {Coordinate{16.5944, 50.0264}, CountryId{"CZ"}}, // Q18180272
    {Coordinate{16.6025, 50.0397}, CountryId{"CZ"}}, // Q18180274
    {Coordinate{13.2036, 49.3525}, CountryId{"CZ"}}, // Janovice nad Úhlavou station
    {Coordinate{15.5809, 49.016}, CountryId{"CZ"}}, // Q18180280
    {Coordinate{13.4717, 50.0931}, CountryId{"CZ"}}, // Jesenice (train station)
    {Coordinate{16.7309, 49.6308}, CountryId{"CZ"}}, // Q18180284
    {Coordinate{15.3611, 50.4306}, CountryId{"CZ"}}, // Q18180286
    {Coordinate{15.5136, 50.6042}, CountryId{"CZ"}}, // Q18180292
    {Coordinate{14.4972, 49.8778}, CountryId{"CZ"}}, // Jílové u Prahy (train station)
    {Coordinate{16.9892, 50.0989}, CountryId{"CZ"}}, // Q18180296
    {Coordinate{13.4475, 50.4853}, CountryId{"CZ"}}, // Q18180298
    {Coordinate{15.0183, 49.7867}, CountryId{"CZ"}}, // Q18180301
    {Coordinate{13.2769, 50.3817}, CountryId{"CZ"}}, // Q18180303
    {Coordinate{14.9836, 50.7736}, CountryId{"CZ"}}, // Q18180306
    {Coordinate{18.2457, 49.3504}, CountryId{"CZ"}}, // Q18180308
    {Coordinate{13.7439, 49.4569}, CountryId{"CZ"}}, // Q18180310
    {Coordinate{13.3749, 49.8938}, CountryId{"CZ"}}, // Q18180312
    {Coordinate{13.0322, 49.3836}, CountryId{"CZ"}}, // Kdyně station
    {Coordinate{14.1139, 50.1278}, CountryId{"CZ"}}, // Kladno
    {Coordinate{14.1299, 50.1634}, CountryId{"CZ"}}, // Q18180320
    {Coordinate{14.1147, 50.1614}, CountryId{"CZ"}}, // Q18180322
    {Coordinate{13.1961, 50.385}, CountryId{"CZ"}}, // Klášterec nad Ohří
    {Coordinate{13.2749, 49.4012}, CountryId{"CZ"}}, // Klatovy (train station)
    {Coordinate{13.295, 49.3858}, CountryId{"CZ"}}, // Q18180325
    {Coordinate{12.8225, 49.4389}, CountryId{"CZ"}}, // Q18180326
    {Coordinate{14.9038, 50.0943}, CountryId{"CZ"}}, // Klučov
    {Coordinate{17.3048, 49.3454}, CountryId{"CZ"}}, // Q18180328
    {Coordinate{15.2228, 50.0153}, CountryId{"CZ"}}, // Kolín místní nádraží
    {Coordinate{15.195, 50.0306}, CountryId{"CZ"}}, // Kolín zastávka
    {Coordinate{16.8837, 49.5916}, CountryId{"CZ"}}, // Konice (train station)
    {Coordinate{15.2604, 50.334}, CountryId{"CZ"}}, // Q18180332
    {Coordinate{18.1472, 49.5953}, CountryId{"CZ"}}, // Kopřivnice
    {Coordinate{18.1494, 49.6039}, CountryId{"CZ"}}, // Kopřivnice zastávka
    {Coordinate{15.3661, 50.77}, CountryId{"CZ"}}, // Kořenov railway station
    {Coordinate{15.3469, 50.7624}, CountryId{"CZ"}}, // Q18180336
    {Coordinate{17.065, 49.5091}, CountryId{"CZ"}}, // Kostelec na Hané (train station)
    {Coordinate{14.5792, 50.2211}, CountryId{"CZ"}}, // Kostelec nad Labem (train station)
    {Coordinate{16.2239, 50.1164}, CountryId{"CZ"}}, // Q18180339
    {Coordinate{14.9878, 50.005}, CountryId{"CZ"}}, // Q18180340
    {Coordinate{13.0119, 49.3969}, CountryId{"CZ"}}, // Q18180341
    {Coordinate{16.7486, 50.0867}, CountryId{"CZ"}}, // Q18180342
    {Coordinate{14.3136, 50.2381}, CountryId{"CZ"}}, // Kralupy nad Vltavou
    {Coordinate{12.5022, 50.3306}, CountryId{"CZ"}}, // Q18180344
    {Coordinate{14.5119, 50.9189}, CountryId{"CZ"}}, // Krásná Lípa railway station
    {Coordinate{13.3686, 50.2556}, CountryId{"CZ"}}, // Q18180346
    {Coordinate{13.8686, 50.0381}, CountryId{"CZ"}}, // Q18180349
    {Coordinate{17.403, 49.3023}, CountryId{"CZ"}}, // Kroměříž (train station)
    {Coordinate{13.7229, 50.1697}, CountryId{"CZ"}}, // Q18180351
    {Coordinate{13.8506, 50.6783}, CountryId{"CZ"}}, // Q18180352
    {Coordinate{17.4703, 49.052}, CountryId{"CZ"}}, // Kunovice
    {Coordinate{16.5343, 49.301}, CountryId{"CZ"}}, // Q18180354
    {Coordinate{15.3011, 49.9617}, CountryId{"CZ"}}, // Kutná Hora hlavní nádraží
    {Coordinate{15.2772, 49.9497}, CountryId{"CZ"}}, // Q18180356
    {Coordinate{15.2669, 49.9372}, CountryId{"CZ"}}, // Q18180357
    {Coordinate{15.2903, 49.9575}, CountryId{"CZ"}}, // Q18180358
    {Coordinate{17.1226, 49.0161}, CountryId{"CZ"}}, // Q18180359
    {Coordinate{15.9294, 50.6733}, CountryId{"CZ"}}, // Q18180361
    {Coordinate{16.6033, 49.9086}, CountryId{"CZ"}}, // Lanškroun (train station)
    {Coordinate{15.5772, 50.4261}, CountryId{"CZ"}}, // Q18180364
    {Coordinate{15.2704, 49.698}, CountryId{"CZ"}}, // Q18180365
    {Coordinate{14.9322, 49.8472}, CountryId{"CZ"}}, // Q18180366
    {Coordinate{16.5709, 49.556}, CountryId{"CZ"}}, // Letovice
    {Coordinate{14.3642, 50.1997}, CountryId{"CZ"}}, // Q18180370
    {Coordinate{14.4356, 50.4142}, CountryId{"CZ"}}, // Q18180371
    {Coordinate{14.0547, 50.4103}, CountryId{"CZ"}}, // Q18180374
    {Coordinate{14.1314, 50.5408}, CountryId{"CZ"}}, // Q18180377
    {Coordinate{16.3041, 49.8748}, CountryId{"CZ"}}, // Litomyšl
    {Coordinate{13.6103, 50.5928}, CountryId{"CZ"}}, // Q18180380
    {Coordinate{13.6139, 50.5911}, CountryId{"CZ"}}, // Q18180381
    {Coordinate{12.7528, 50.1898}, CountryId{"CZ"}}, // Loket (train station)
    {Coordinate{15.3744, 50.527}, CountryId{"CZ"}}, // Q18180383
    {Coordinate{17.0867, 50.0689}, CountryId{"CZ"}}, // Q18180384
    {Coordinate{17.0839, 50.0564}, CountryId{"CZ"}}, // Q18180385
    {Coordinate{14.2567, 48.6206}, CountryId{"CZ"}}, // Q18180386
    {Coordinate{14.2453, 48.6244}, CountryId{"CZ"}}, // Q18180387
    {Coordinate{13.7678, 50.3433}, CountryId{"CZ"}}, // Q18180389
    {Coordinate{14.0594, 50.5094}, CountryId{"CZ"}}, // Q18180390
    {Coordinate{14.0447, 50.5211}, CountryId{"CZ"}}, // Lovosice město (train station)
    {Coordinate{13.3056, 49.3642}, CountryId{"CZ"}}, // Luby u Klatov station
    {Coordinate{17.752, 49.0989}, CountryId{"CZ"}}, // Q18180395
    {Coordinate{15.71, 49.3696}, CountryId{"CZ"}}, // Q18180397
    {Coordinate{16.4842, 50.0492}, CountryId{"CZ"}}, // Q18180398
    {Coordinate{14.8422, 50.1956}, CountryId{"CZ"}}, // Q18180399
    {Coordinate{15.2308, 49.9072}, CountryId{"CZ"}}, // Q18180400
    {Coordinate{17.8758, 49.6356}, CountryId{"CZ"}}, // Q18180406
    {Coordinate{14.8817, 50.2292}, CountryId{"CZ"}}, // Q18180407
    {Coordinate{14.7144, 50.6578}, CountryId{"CZ"}}, // Q18180408
    {Coordinate{13.6661, 49.7}, CountryId{"CZ"}}, // Q18180409
    {Coordinate{14.0342, 49.5097}, CountryId{"CZ"}}, // Q18180410
    {Coordinate{14.9781, 50.5183}, CountryId{"CZ"}}, // Q18180412
    {Coordinate{14.2698, 49.8538}, CountryId{"CZ"}}, // Mníšek pod Brdy
    {Coordinate{16.6062, 49.1338}, CountryId{"CZ"}}, // Q18180415
    {Coordinate{17.0221, 48.7996}, CountryId{"CZ"}}, // Moravská Nová Ves
    {Coordinate{16.6665, 49.7667}, CountryId{"CZ"}}, // Q18180417
    {Coordinate{15.8092, 49.0575}, CountryId{"CZ"}}, // Moravské Budějovice (train station)
    {Coordinate{16.3384, 49.0465}, CountryId{"CZ"}}, // Q18180419
    {Coordinate{13.6583, 50.5112}, CountryId{"CZ"}}, // Q18180420
    {Coordinate{13.6217, 50.5433}, CountryId{"CZ"}}, // Q18180421
    {Coordinate{13.6233, 50.5642}, CountryId{"CZ"}}, // Q18180422
    {Coordinate{14.6978, 49.8322}, CountryId{"CZ"}}, // Mrač
    {Coordinate{14.6406, 50.4356}, CountryId{"CZ"}}, // Q18180424
    {Coordinate{13.7042, 50.2169}, CountryId{"CZ"}}, // Mutějovice (train station)
    {Coordinate{13.7025, 50.1872}, CountryId{"CZ"}}, // Mutějovice zastávka
    {Coordinate{16.1475, 49.207}, CountryId{"CZ"}}, // Náměšť nad Oslavou (train station)
    {Coordinate{17.5048, 49.1631}, CountryId{"CZ"}}, // Q18180429
    {Coordinate{12.7274, 50.3191}, CountryId{"CZ"}}, // Q18180432
    {Coordinate{14.5175, 50.2625}, CountryId{"CZ"}}, // Q18180433
    {Coordinate{14.1069, 50.6725}, CountryId{"CZ"}}, // Q18180434
    {Coordinate{14.1894, 49.0539}, CountryId{"CZ"}}, // Q18180435
    {Coordinate{16.1375, 50.3533}, CountryId{"CZ"}}, // Nové Město nad Metují
    {Coordinate{13.8817, 50.1519}, CountryId{"CZ"}}, // Nové Strašecí (train station)
    {Coordinate{14.5474, 50.7607}, CountryId{"CZ"}}, // Q18180438
    {Coordinate{15.4858, 50.2447}, CountryId{"CZ"}}, // Q18180439
    {Coordinate{18.0089, 49.5986}, CountryId{"CZ"}}, // Q18180440
    {Coordinate{15.0456, 50.1931}, CountryId{"CZ"}}, // Q18180441
    {Coordinate{13.2095, 49.715}, CountryId{"CZ"}}, // Q18180442
    {Coordinate{17.8333, 49.6697}, CountryId{"CZ"}}, // Q18180443
    {Coordinate{17.2412, 49.5941}, CountryId{"CZ"}}, // Q18180445
    {Coordinate{17.2443, 49.5873}, CountryId{"CZ"}}, // Nová Ulice
    {Coordinate{16.3463, 49.1189}, CountryId{"CZ"}}, // Oslavany
    {Coordinate{15.0143, 50.7632}, CountryId{"CZ"}}, // Ostašov railway station
    {Coordinate{17.0506, 50.1833}, CountryId{"CZ"}}, // Q18180451
    {Coordinate{16.3717, 50.5611}, CountryId{"CZ"}}, // Otovice (train station)
    {Coordinate{15.0269, 50.0897}, CountryId{"CZ"}}, // Pečky train station
    {Coordinate{13.9586, 50.3358}, CountryId{"CZ"}}, // Q18180456
    {Coordinate{15.8128, 50.5342}, CountryId{"CZ"}}, // Q18180457
    {Coordinate{14.1614, 49.3139}, CountryId{"CZ"}}, // Q18180458
    {Coordinate{13.3794, 49.9308}, CountryId{"CZ"}}, // Q18180459
    {Coordinate{15.7925, 50.2347}, CountryId{"CZ"}}, // Q18180461
    {Coordinate{12.8114, 49.5133}, CountryId{"CZ"}}, // Poběžovice railway station
    {Coordinate{13.1356, 49.3461}, CountryId{"CZ"}}, // Q18180463
    {Coordinate{13.4045, 50.2234}, CountryId{"CZ"}}, // Q18180464
    {Coordinate{16.8541, 48.8375}, CountryId{"CZ"}}, // Q18180465
    {Coordinate{16.2641, 49.7189}, CountryId{"CZ"}}, // Q18180466
    {Coordinate{16.6682, 48.9243}, CountryId{"CZ"}}, // Q18180467
    {Coordinate{14.6764, 49.8372}, CountryId{"CZ"}}, // Poříčí nad Sázavou
    {Coordinate{13.6914, 50.3603}, CountryId{"CZ"}}, // Q18180469
    {Coordinate{12.8147, 49.4589}, CountryId{"CZ"}}, // Q18180470
    {Coordinate{13.3225, 49.575}, CountryId{"CZ"}}, // Q18180474
    {Coordinate{18.1423, 49.6359}, CountryId{"CZ"}}, // Příbor
    {Coordinate{17.1296, 49.4724}, CountryId{"CZ"}}, // Prostějov railway station
    {Coordinate{13.5967, 49.858}, CountryId{"CZ"}}, // Q18180480
    {Coordinate{13.7506, 50.1047}, CountryId{"CZ"}}, // Q18180482
    {Coordinate{14.9503, 49.8436}, CountryId{"CZ"}}, // Q18180484
    {Coordinate{14.9789, 49.8494}, CountryId{"CZ"}}, // Q18180485
    {Coordinate{14.9478, 49.8444}, CountryId{"CZ"}}, // Q18180486
    {Coordinate{14.9411, 49.8397}, CountryId{"CZ"}}, // Q18180487
    {Coordinate{15.1603, 49.9814}, CountryId{"CZ"}}, // Q18180488
    {Coordinate{13.8008, 50.6422}, CountryId{"CZ"}}, // Řetenice (train station)
    {Coordinate{15.4229, 50.7121}, CountryId{"CZ"}}, // Q18180491
    {Coordinate{16.4653, 50.1614}, CountryId{"CZ"}}, // Rokytnice v Orlických horách (train station)
    {Coordinate{15.5281, 49.8947}, CountryId{"CZ"}}, // Ronov nad Doubravou (train station)
    {Coordinate{14.8047, 50.0786}, CountryId{"CZ"}}, // Rostoklaty
    {Coordinate{16.8677, 49.197}, CountryId{"CZ"}}, // Rousínov
    {Coordinate{15.2633, 50.5319}, CountryId{"CZ"}}, // Q18180496
    {Coordinate{14.3631, 48.6264}, CountryId{"CZ"}}, // Q18180497
    {Coordinate{13.8821, 49.6021}, CountryId{"CZ"}}, // Rožmitál pod Třemšínem (train station)
    {Coordinate{18.1345, 49.4605}, CountryId{"CZ"}}, // Rožnov pod Radhoštěm
    {Coordinate{14.9867, 50.1311}, CountryId{"CZ"}}, // Q18180501
    {Coordinate{16.7065, 48.9126}, CountryId{"CZ"}}, // Q18180502
    {Coordinate{14.8936, 49.8692}, CountryId{"CZ"}}, // Q18180503
    {Coordinate{14.9061, 49.875}, CountryId{"CZ"}}, // Sázava
    {Coordinate{15.4957, 49.2248}, CountryId{"CZ"}}, // Q18180505
    {Coordinate{15.3239, 50.6033}, CountryId{"CZ"}}, // Semily
    {Coordinate{18.1283, 49.6564}, CountryId{"CZ"}}, // Skotnice
    {Coordinate{15.995, 49.8376}, CountryId{"CZ"}}, // Q18180508
    {Coordinate{16.7295, 49.1568}, CountryId{"CZ"}}, // Q18180509
    {Coordinate{15.8251, 49.9189}, CountryId{"CZ"}}, // Q18180510
    {Coordinate{17.8994, 49.0741}, CountryId{"CZ"}}, // Q18180511
    {Coordinate{16.8736, 49.145}, CountryId{"CZ"}}, // Slavkov u Brna
    {Coordinate{14.4617, 51.0064}, CountryId{"CZ"}}, // Šluknov railway station
    {Coordinate{17.065, 50.0175}, CountryId{"CZ"}}, // Sobotín (train station)
    {Coordinate{15.1678, 50.4653}, CountryId{"CZ"}}, // Q18180517
    {Coordinate{16.2539, 50.2036}, CountryId{"CZ"}}, // Q18180518
    {Coordinate{13.0716, 49.5475}, CountryId{"CZ"}}, // Q18180520
    {Coordinate{14.6922, 50.2097}, CountryId{"CZ"}}, // Q18180521
    {Coordinate{16.9419, 50.1622}, CountryId{"CZ"}}, // Q18180522
    {Coordinate{17.2859, 49.7205}, CountryId{"CZ"}}, // Q18180523
    {Coordinate{14.3939, 50.4564}, CountryId{"CZ"}}, // Q18180524
    {Coordinate{16.7544, 49.9703}, CountryId{"CZ"}}, // Q18180525
    {Coordinate{13.9653, 50.1411}, CountryId{"CZ"}}, // Q18180526
    {Coordinate{13.155, 49.6394}, CountryId{"CZ"}}, // Q18180527
    {Coordinate{18.1322, 49.5829}, CountryId{"CZ"}}, // Štramberk
    {Coordinate{17.3185, 48.8975}, CountryId{"CZ"}}, // Q18180529
    {Coordinate{14.7458, 49.7619}, CountryId{"CZ"}}, // Struhařov
    {Coordinate{13.5417, 49.2467}, CountryId{"CZ"}}, // Sušice railway station
    {Coordinate{15.4172, 49.6703}, CountryId{"CZ"}}, // Q18180532
    {Coordinate{15.4017, 49.6692}, CountryId{"CZ"}}, // Q18180533
    {Coordinate{16.4794, 49.7589}, CountryId{"CZ"}}, // Q18180534
    {Coordinate{15.8203, 50.6217}, CountryId{"CZ"}}, // Q18180536
    {Coordinate{12.6386, 49.8019}, CountryId{"CZ"}}, // Tachov (train station)
    {Coordinate{15.3108, 50.7433}, CountryId{"CZ"}}, // Q18180538
    {Coordinate{16.6081, 50.0686}, CountryId{"CZ"}}, // Q18180539
    {Coordinate{15.4645, 49.1825}, CountryId{"CZ"}}, // Q18180540
    {Coordinate{14.3464, 49.1956}, CountryId{"CZ"}}, // Q18180541
    {Coordinate{12.86, 49.9756}, CountryId{"CZ"}}, // Q18180542
    {Coordinate{16.1786, 50.5814}, CountryId{"CZ"}}, // Q18180543
    {Coordinate{13.8136, 50.6336}, CountryId{"CZ"}}, // Q18180544
    {Coordinate{16.4184, 49.3469}, CountryId{"CZ"}}, // Tišnov
    {Coordinate{17.5012, 49.254}, CountryId{"CZ"}}, // Q18180547
    {Coordinate{13.3092, 49.4292}, CountryId{"CZ"}}, // Q18180548
    {Coordinate{15.9822, 50.2}, CountryId{"CZ"}}, // Q18180549
    {Coordinate{13.5803, 50.5236}, CountryId{"CZ"}}, // Q18180551
    {Coordinate{13.3944, 49.8189}, CountryId{"CZ"}}, // Třemošná u Plzně (train station)
    {Coordinate{15.5764, 49.8719}, CountryId{"CZ"}}, // Q18180554
    {Coordinate{15.4766, 49.2984}, CountryId{"CZ"}}, // Q18180555
    {Coordinate{13.9869, 50.6472}, CountryId{"CZ"}}, // Q18180558
    {Coordinate{15.945, 50.5778}, CountryId{"CZ"}}, // Q18180561
    {Coordinate{15.9597, 50.5781}, CountryId{"CZ"}}, // Q18180562
    {Coordinate{15.8817, 50.5908}, CountryId{"CZ"}}, // Q18180563
    {Coordinate{15.8881, 50.5806}, CountryId{"CZ"}}, // Q18180564
    {Coordinate{14.7706, 50.077}, CountryId{"CZ"}}, // Tuklaty
    {Coordinate{14.4082, 49.2233}, CountryId{"CZ"}}, // Q18180566
    {Coordinate{14.5929, 49.8342}, CountryId{"CZ"}}, // Týnec nad Sázavou
    {Coordinate{16.0739, 50.1547}, CountryId{"CZ"}}, // Týniště nad Orlicí (train station)
    {Coordinate{17.4574, 49.0667}, CountryId{"CZ"}}, // Q18180569
    {Coordinate{17.6435, 49.0218}, CountryId{"CZ"}}, // Uherský Brod (train station)
    {Coordinate{17.4035, 48.982}, CountryId{"CZ"}}, // Q18180572
    {Coordinate{15.0597, 49.8822}, CountryId{"CZ"}}, // Uhlířské Janovice
    {Coordinate{17.1156, 49.7792}, CountryId{"CZ"}}, // Q18180575
    {Coordinate{14.0806, 50.6642}, CountryId{"CZ"}}, // Ústí nad Labem sever
    {Coordinate{14.7263, 50.0745}, CountryId{"CZ"}}, // Úvaly
    {Coordinate{18.0228, 49.1423}, CountryId{"CZ"}}, // Q18180579
    {Coordinate{13.3381, 49.7131}, CountryId{"CZ"}}, // Plzeň-Valcha
    {Coordinate{16.7428, 48.7475}, CountryId{"CZ"}}, // Valtice
    {Coordinate{16.2828, 50.1178}, CountryId{"CZ"}}, // Vamberk
    {Coordinate{14.6386, 50.9031}, CountryId{"CZ"}}, // Varnsdorf railway station
    {Coordinate{13.2844, 49.7297}, CountryId{"CZ"}}, // Q18180584
    {Coordinate{14.1461, 50.6642}, CountryId{"CZ"}}, // Q18180585
    {Coordinate{17.0439, 50.0333}, CountryId{"CZ"}}, // Velké Losiny (train station)
    {Coordinate{17.0589, 50.0417}, CountryId{"CZ"}}, // Q18180587
    {Coordinate{16.0219, 49.3457}, CountryId{"CZ"}}, // Q18180588
    {Coordinate{16.6908, 49.6113}, CountryId{"CZ"}}, // Velké Opatovice
    {Coordinate{16.8237, 48.8899}, CountryId{"CZ"}}, // Q18180590
    {Coordinate{14.2431, 50.2819}, CountryId{"CZ"}}, // Q18180591
    {Coordinate{16.5575, 50.0114}, CountryId{"CZ"}}, // Q18180592
    {Coordinate{13.7906, 49.0553}, CountryId{"CZ"}}, // Q18180593
    {Coordinate{17.7472, 49.7739}, CountryId{"CZ"}}, // Q18180594
    {Coordinate{17.8432, 49.2201}, CountryId{"CZ"}}, // Q18180595
    {Coordinate{15.1717, 49.7286}, CountryId{"CZ"}}, // Vlastějovice (train station)
    {Coordinate{14.1801, 49.1451}, CountryId{"CZ"}}, // Q18180597
    {Coordinate{13.8831, 48.9069}, CountryId{"CZ"}}, // Q18180598
    {Coordinate{13.8928, 49.17}, CountryId{"CZ"}}, // Volyně (train station)
    {Coordinate{15.0933, 50.74}, CountryId{"CZ"}}, // Q18180601
    {Coordinate{15.6228, 50.6188}, CountryId{"CZ"}}, // Vrchlabí (train station)
    {Coordinate{14.1072, 49.8675}, CountryId{"CZ"}}, // Q18180604
    {Coordinate{16.1471, 49.9554}, CountryId{"CZ"}}, // Vysoké Mýto
    {Coordinate{15.9117, 50.6653}, CountryId{"CZ"}}, // Q18180606
    {Coordinate{13.3264, 49.7472}, CountryId{"CZ"}}, // Q18180607
    {Coordinate{16.782, 48.8894}, CountryId{"CZ"}}, // Zaječí
    {Coordinate{16.4502, 50.0739}, CountryId{"CZ"}}, // Q18180609
    {Coordinate{15.0319, 49.9625}, CountryId{"CZ"}}, // Zásmuky
    {Coordinate{13.555, 50.3364}, CountryId{"CZ"}}, // Q18180612
    {Coordinate{13.5347, 50.3381}, CountryId{"CZ"}}, // Žatec západ (train station)
    {Coordinate{15.8045, 49.7001}, CountryId{"CZ"}}, // Q18180615
    {Coordinate{15.265, 50.6397}, CountryId{"CZ"}}, // Železný Brod
    {Coordinate{18.1308, 49.5647}, CountryId{"CZ"}}, // Ženklava
    {Coordinate{13.6175, 49.2675}, CountryId{"CZ"}}, // Žichovice railway station
    {Coordinate{17.614, 49.2125}, CountryId{"CZ"}}, // Q18180620
    {Coordinate{17.5994, 49.2098}, CountryId{"CZ"}}, // Zlín-Malenovice (train station)
    {Coordinate{13.1592, 50.0844}, CountryId{"CZ"}}, // Q18180624
    {Coordinate{16.0593, 48.8528}, CountryId{"CZ"}}, // Q18180625
    {Coordinate{16.0442, 48.82}, CountryId{"CZ"}}, // Q18180626
    {Coordinate{15.1039, 49.7383}, CountryId{"CZ"}}, // Zruč nad Sázavou
    {Coordinate{15.0853, 49.7428}, CountryId{"CZ"}}, // Q18180628
    {Coordinate{4.58754, 48.7179}, CountryId{"FR"}}, // Gare de Vitry-le-François
    {Coordinate{79.6049, 17.9725}, CountryId{"IN"}}, // Warangal railway station
    {Coordinate{3.57556, 51.0644}, CountryId{"BE"}}, // Landegem railway station
    {Coordinate{14.7275, 49.8969}, CountryId{"CZ"}}, // Senohraby
    {Coordinate{3.49635, 50.5472}, CountryId{"BE"}}, // Maubray railway station
    {Coordinate{4.15593, 50.5628}, CountryId{"BE"}}, // Écaussinnes railway station
    {Coordinate{13.7703, 50.1447}, CountryId{"CZ"}}, // Q18203353
    {Coordinate{16.6494, 49.2181}, CountryId{"CZ"}}, // Q18203355
    {Coordinate{15.9109, 49.9013}, CountryId{"CZ"}}, // Q18203356
    {Coordinate{6.66447, 49.0517}, CountryId{"FR"}}, // Q1820464
    {Coordinate{14.3222, 50.0456}, CountryId{"CZ"}}, // Luka
    {Coordinate{4.28306, 51.0772}, CountryId{"BE"}}, // Puurs railway station
    {Coordinate{74.3884, 34.2208}, CountryId{"IN"}}, // Baramulla railway station
    {Coordinate{2.27333, 48.7347}, CountryId{"FR"}}, // Gare de Massy-Verrières
    {Coordinate{2.4275, 44.2703}, CountryId{"FR"}}, // Gare de Baraqueville
    {Coordinate{5.58186, 45.322}, CountryId{"FR"}}, // Gare de Moirans
    {Coordinate{7.3806, 48.9201}, CountryId{"FR"}}, // Wingen-sur-Moder
    {Coordinate{3.41078, 44.4996}, CountryId{"FR"}}, // Gare de Barjac
    {Coordinate{2.25083, 48.5181}, CountryId{"FR"}}, // Lardy (Paris RER)
    {Coordinate{1.94028, 42.4572}, CountryId{"FR"}}, // Gare de Ur-Les Escaldes
    {Coordinate{-5.79235, 43.3795}, CountryId{"ES"}}, // Colloto railway station
    {Coordinate{-5.70225, 43.3823}, CountryId{"ES"}}, // Q18222964
    {Coordinate{-5.72972, 43.3818}, CountryId{"ES"}}, // Q18223245
    {Coordinate{11.8033, 43.48}, CountryId{"IT"}}, // Q18223645
    {Coordinate{-5.74859, 43.381}, CountryId{"ES"}}, // Meres railway station
    {Coordinate{-5.80879, 43.3865}, CountryId{"ES"}}, // Q18224563
    {Coordinate{14.3801, 41.0362}, CountryId{"IT"}}, // Maddaloni Inferiore railway station
    {Coordinate{14.0771, 41.232}, CountryId{"IT"}}, // Q18224699
    {Coordinate{-5.6648, 43.3882}, CountryId{"ES"}}, // Q18224711
    {Coordinate{3.91142, 50.3912}, CountryId{"BE"}}, // Genly railway station
    {Coordinate{4.36167, 50.7942}, CountryId{"BE"}}, // Saint-Job railway station
    {Coordinate{4.27382, 50.7664}, CountryId{"BE"}}, // Lot railway station
    {Coordinate{5.86417, 50.5908}, CountryId{"BE"}}, // Verviers-Palais railway station
    {Coordinate{3.78167, 50.9367}, CountryId{"BE"}}, // Scheldewindeke railway station
    {Coordinate{14.3953, 50.1125}, CountryId{"CZ"}}, // Praha-Podbaba railway station
    {Coordinate{5.13455, 48.1095}, CountryId{"FR"}}, // Gare de Chaumont
    {Coordinate{1.79736, 47.3693}, CountryId{"FR"}}, // Q1826289
    {Coordinate{1.58147, 49.0387}, CountryId{"FR"}}, // Bonnières
    {Coordinate{-1.38983, 47.9132}, CountryId{"FR"}}, // Gare de Retiers
    {Coordinate{3.00652, 49.577}, CountryId{"FR"}}, // Gare de Noyon
    {Coordinate{14.3303, 49.9461}, CountryId{"CZ"}}, // Q1827105
    {Coordinate{1.13979, 48.4786}, CountryId{"FR"}}, // Q1828187
    {Coordinate{3.44861, 50.0911}, CountryId{"FR"}}, // Gare de Bertry
    {Coordinate{12.3686, 50.1658}, CountryId{"CZ"}}, // Skalná (train station)
    {Coordinate{7.55583, 50.1558}, CountryId{"DE"}}, // Q18286822
    {Coordinate{8.43143, 50.0173}, CountryId{"DE"}}, // Flörsheim (Main) station
    {Coordinate{12.0852, 45.1479}, CountryId{"IT"}}, // Q18289214
    {Coordinate{12.0915, 45.1361}, CountryId{"IT"}}, // Q18289217
    {Coordinate{3.40972, 50.1114}, CountryId{"FR"}}, // Gare de Caudry
    {Coordinate{0.387395, 43.1142}, CountryId{"FR"}}, // Gare de Lannemezan
    {Coordinate{5.83944, 51.995}, CountryId{"NL"}}, // Oosterbeek railway station
    {Coordinate{1.25139, 43.3558}, CountryId{"FR"}}, // Gare de Longages-Noé
    {Coordinate{7.31256, 47.9603}, CountryId{"FR"}}, // Gare de Rouffach
    {Coordinate{2.17214, 50.4248}, CountryId{"FR"}}, // Gare de Blangy-sur-Ternoise
    {Coordinate{56.7628, 59.4014}, CountryId{"RU"}}, // Q18325042
    {Coordinate{14.3497, 53.2708}, CountryId{"DE"}}, // Tantow railway station
    {Coordinate{2.92028, 45.8606}, CountryId{"FR"}}, // Q1832854
    {Coordinate{38.374, 49.0027}, CountryId{"UA"}}, // Q18340062
    {Coordinate{10.3216, 51.3876}, CountryId{"DE"}}, // Leinefelde station
    {Coordinate{7.585, 51.5569}, CountryId{"DE"}}, // Dortmund-Kurl station
    {Coordinate{75.158, 33.5886}, CountryId{"IN"}}, // Qazigund Railway Station
    {Coordinate{5.40647, 43.2962}, CountryId{"FR"}}, // Marseille-Blancarde
    {Coordinate{15.8774, 50.331}, CountryId{"CZ"}}, // Semonice (train station)
    {Coordinate{76.5989, 9.03231}, CountryId{"IN"}}, // Sasthamkotta railway station
    {Coordinate{74.9919, 33.8879}, CountryId{"IN"}}, // Awantipora railway station
    {Coordinate{79.3178, 11.7022}, CountryId{"IN"}}, // Ulundurpet railway station
    {Coordinate{17.1079, 40.5828}, CountryId{"IT"}}, // Massafra railway station
    {Coordinate{75.0756, 33.7895}, CountryId{"IN"}}, // Bijbehara railway station
    {Coordinate{77.2876, 30.1168}, CountryId{"IN"}}, // Jagadhri railway station
    {Coordinate{79.7275, 11.2414}, CountryId{"IN"}}, // Sirkazhi railway station
    {Coordinate{-3.16438, 48.698}, CountryId{"FR"}}, // Halte de Pontrieux
    {Coordinate{5.05495, 47.3228}, CountryId{"FR"}}, // Gare de Dijon-Porte-Neuve
    {Coordinate{1.03959, 49.5133}, CountryId{"FR"}}, // Malaunay-Le Houlme
    {Coordinate{108.037, 51.915}, CountryId{"RU"}}, // Onohoy station
    {Coordinate{76.7861, 11.3559}, CountryId{"IN"}}, // Wellington railway station
    {Coordinate{5.19345, 45.9019}, CountryId{"FR"}}, // Q1837811
    {Coordinate{77.5636, 28.5079}, CountryId{"IN"}}, // Boraki Railway Station
    {Coordinate{2.31518, 44.1004}, CountryId{"FR"}}, // Q18380048
    {Coordinate{5.25685, 43.3402}, CountryId{"FR"}}, // Gare de Niolon
    {Coordinate{-4.28514, 48.3922}, CountryId{"FR"}}, // Q1838040
    {Coordinate{77.1997, 28.6687}, CountryId{"IN"}}, // Subzi Mandi railway station
    {Coordinate{16.9845, 40.6067}, CountryId{"IT"}}, // Palagianello railway station
    {Coordinate{9.02239, 47.2179}, CountryId{"CH"}}, // Kaltbrunn railway station
    {Coordinate{74.5632, 34.1659}, CountryId{"IN"}}, // Pattan railway station
    {Coordinate{76.9698, 29.6946}, CountryId{"IN"}}, // Karnal railway station
    {Coordinate{2.77722, 49.3866}, CountryId{"FR"}}, // Q1838995
    {Coordinate{78.1777, 29.9811}, CountryId{"IN"}}, // Motichur railway station
    {Coordinate{}, CountryId{"IN"}}, // Railway stations in Coimbatore
    {Coordinate{74.7362, 34.0387}, CountryId{"IN"}}, // Budgam railway station
    {Coordinate{75.8049, 22.6331}, CountryId{"IN"}}, // Rau railway station
    {Coordinate{79.5063, 13.6363}, CountryId{"IN"}}, // Renigunta Junction railway station
    {Coordinate{79.6513, 12.2294}, CountryId{"IN"}}, // Tindivanam railway station
    {Coordinate{76.3528, 9.9501}, CountryId{"IN"}}, // Tripunithura railway station
    {Coordinate{30.4206, 58.9042}, CountryId{"RU"}}, // Q18394946
    {Coordinate{30.3717, 59.2283}, CountryId{"RU"}}, // Q18395256
    {Coordinate{77.9577, 9.59641}, CountryId{"IN"}}, // Virudhunagar Junction railway station
    {Coordinate{36.2443, 54.566}, CountryId{"RU"}}, // Q18396312
    {Coordinate{12.7551, 43.0569}, CountryId{"IT"}}, // Q18397591
    {Coordinate{12.7541, 43.0268}, CountryId{"IT"}}, // Q18397592
    {Coordinate{12.7377, 42.9839}, CountryId{"IT"}}, // Q18397595
    {Coordinate{15.3433, 49.9297}, CountryId{"CZ"}}, // Q18398040
    {Coordinate{15.1006, 50.6672}, CountryId{"CZ"}}, // Q18398041
    {Coordinate{30.3536, 59.3828}, CountryId{"RU"}}, // Q18398515
    {Coordinate{60.5103, 56.8642}, CountryId{"RU"}}, // Q18398720
    {Coordinate{48.1905, 46.7157}, CountryId{"RU"}}, // Q18398773
    {Coordinate{48.3627, 46.691}, CountryId{"RU"}}, // Q18398795
    {Coordinate{28.7331, 59.5397}, CountryId{"RU"}}, // Q18398978
    {Coordinate{31.9246, 53.6079}, CountryId{"BY"}}, // Klimavichy
    {Coordinate{25.125, 52.5614}, CountryId{"BY"}}, // Rechytsa
    {Coordinate{24.1241, 52.2543}, CountryId{"BY"}}, // Yakawchytsy
    {Coordinate{29.1825, 60.2225}, CountryId{"RU"}}, // Q18399209
    {Coordinate{25.5542, 56.89}, CountryId{"LV"}}, // Q18399262
    {Coordinate{39.2228, 51.3114}, CountryId{"RU"}}, // Q18399325
    {Coordinate{32.0594, 53.3781}, CountryId{"BY"}}, // Q18399428
    {Coordinate{29.0097, 59.7283}, CountryId{"RU"}}, // Q18399596
    {Coordinate{23.8514, 52.1429}, CountryId{"BY"}}, // Koshalyeva
    {Coordinate{23.9834, 52.1879}, CountryId{"BY"}}, // Tsukrovy Zavod
    {Coordinate{38.1653, 49.4086}, CountryId{"UA"}}, // Q18399974
    {Coordinate{38.2369, 49.0536}, CountryId{"UA"}}, // Q18400018
    {Coordinate{38.8501, 56.5077}, CountryId{"RU"}}, // Balakirevo train station
    {Coordinate{33.5288, 44.5952}, CountryId{"RU"}}, // Sevastopol
    {Coordinate{35.5711, 45.2431}, CountryId{"UA"}}, // Q18400357
    {Coordinate{44.4847, 56.7958}, CountryId{"RU"}}, // Semyonov station
    {Coordinate{28.9142, 59.6606}, CountryId{"RU"}}, // Q18400466
    {Coordinate{25.1867, 52.4666}, CountryId{"BY"}}, // Byelaazyorsk
    {Coordinate{38.529, 54.6791}, CountryId{"RU"}}, // Q18400852
    {Coordinate{38.6997, 55.7744}, CountryId{"RU"}}, // Q18400930
    {Coordinate{31.1914, 58.6389}, CountryId{"RU"}}, // Q18400965
    {Coordinate{39.9784, 63.6045}, CountryId{"RU"}}, // Q18400996
    {Coordinate{28.7639, 59.4839}, CountryId{"RU"}}, // Q18401016
    {Coordinate{30.6744, 61.6953}, CountryId{"RU"}}, // Q18401116
    {Coordinate{23.7317, 52.1117}, CountryId{"BY"}}, // Q18401257
    {Coordinate{38.3083, 56.3918}, CountryId{"RU"}}, // Buzhaninovo
    {Coordinate{24.3316, 52.4107}, CountryId{"BY"}}, // Lyasy
    {Coordinate{60.5539, 56.8581}, CountryId{"RU"}}, // Q18401552
    {Coordinate{34.4255, 45.7946}, CountryId{"RU"}}, // Mamut
    {Coordinate{24.1693, 52.2817}, CountryId{"BY"}}, // Stawpy
    {Coordinate{24.0882, 52.2347}, CountryId{"BY"}}, // Matsyeyevichy
    {Coordinate{38.5871, 56.3789}, CountryId{"RU"}}, // Strunino
    {Coordinate{3.96161, 50.5364}, CountryId{"BE"}}, // Masnuy-Saint-Pierre railway station
    {Coordinate{24.9739, 52.5477}, CountryId{"BY"}}, // Q18404556
    {Coordinate{25.1561, 52.5125}, CountryId{"BY"}}, // Vaytsyeshyn
    {Coordinate{29.0553, 59.8044}, CountryId{"RU"}}, // Q18404908
    {Coordinate{29.5092, 60.2019}, CountryId{"RU"}}, // Q18404969
    {Coordinate{37.6244, 55.8033}, CountryId{"RU"}}, // Q18405077
    {Coordinate{23.8818, 52.1522}, CountryId{"BY"}}, // Kharytony
    {Coordinate{36.1581, 54.6191}, CountryId{"RU"}}, // Muratovka
    {Coordinate{40.0939, 47.4442}, CountryId{"RU"}}, // Q18405474
    {Coordinate{23.9394, 52.1708}, CountryId{"BY"}}, // Naharany
    {Coordinate{36.1383, 54.6115}, CountryId{"RU"}}, // Q18405718
    {Coordinate{38.5788, 55.2125}, CountryId{"RU"}}, // Q18405747
    {Coordinate{24.5229, 52.4704}, CountryId{"BY"}}, // Aranchytsy
    {Coordinate{49.99, 58.5336}, CountryId{"RU"}}, // Q18406895
    {Coordinate{36.7214, 56.6281}, CountryId{"RU"}}, // Q18406986
    {Coordinate{35.9078, 45.3297}, CountryId{"UA"}}, // Q18407043
    {Coordinate{24.6851, 52.5074}, CountryId{"BY"}}, // Pawlavichy
    {Coordinate{45.5153, 51.1924}, CountryId{"RU"}}, // Q18407403
    {Coordinate{60.6467, 56.8297}, CountryId{"RU"}}, // Shartash Railway Station
    {Coordinate{43.3931, 56.6444}, CountryId{"RU"}}, // Q18407889
    {Coordinate{45.0153, 53.1611}, CountryId{"RU"}}, // Q18408010
    {Coordinate{45.0122, 53.2042}, CountryId{"RU"}}, // Q18408133
    {Coordinate{33.61, 44.5889}, CountryId{"UA"}}, // Q18408450
    {Coordinate{24.3924, 52.4299}, CountryId{"BY"}}, // Prylutchyna
    {Coordinate{24.7717, 52.5146}, CountryId{"BY"}}, // Kabaki
    {Coordinate{38.0833, 49.4}, CountryId{"UA"}}, // Q18408698
    {Coordinate{38.3837, 54.7319}, CountryId{"RU"}}, // Q18408758
    {Coordinate{61.9228, 56.4273}, CountryId{"RU"}}, // Kamensk-Uralsky train station
    {Coordinate{44.5264, 52.7006}, CountryId{"RU"}}, // Q18409141
    {Coordinate{30.379, 59.5407}, CountryId{"RU"}}, // Q18409162
    {Coordinate{35.3489, 54.1162}, CountryId{"RU"}}, // Sukhinichi
    {Coordinate{38.1657, 55.1223}, CountryId{"RU"}}, // Q18409379
    {Coordinate{24.6123, 52.4982}, CountryId{"BY"}}, // Tkachy
    {Coordinate{37.8966, 55.1548}, CountryId{"RU"}}, // Q18409871
    {Coordinate{6.6078, 51.7697}, CountryId{"DE"}}, // Bahnhof Dingden
    {Coordinate{7.80935, 48.8861}, CountryId{"FR"}}, // Walbourg
    {Coordinate{13.4574, 66.0708}, CountryId{"NO"}}, // Drevvatn Station
    {Coordinate{2.54806, 48.8406}, CountryId{"FR"}}, // Noisy-le-Grand – Mont d'Est
    {Coordinate{15.1914, 37.6889}, CountryId{"IT"}}, // Q18420506
    {Coordinate{15.7581, 40.7877}, CountryId{"IT"}}, // Castel Lagopesole railway station
    {Coordinate{15.7523, 40.8372}, CountryId{"IT"}}, // Filiano railway station
    {Coordinate{10.1117, 45.7128}, CountryId{"IT"}}, // Sale Marasino
    {Coordinate{9.17155, 45.5289}, CountryId{"IT"}}, // Milano Bruzzano railway station
    {Coordinate{8.51199, 40.2725}, CountryId{"IT"}}, // Q18420518
    {Coordinate{8.94449, 45.8498}, CountryId{"CH"}}, // Stabio railway station
    {Coordinate{16.1242, 50.6153}, CountryId{"CZ"}}, // Q18420893
    {Coordinate{20.9947, 52.2586}, CountryId{"PL"}}, // Warszawa Gdańska station
    {Coordinate{12.8683, 49.3992}, CountryId{"CZ"}}, // Q18423293
    {Coordinate{13.0453, 50.1547}, CountryId{"CZ"}}, // Q18423513
    {Coordinate{13.2992, 49.5267}, CountryId{"CZ"}}, // Q18423528
    {Coordinate{14.4322, 48.7019}, CountryId{"CZ"}}, // Q18423596
    {Coordinate{16.247, 49.5137}, CountryId{"CZ"}}, // Q18423620
    {Coordinate{15.0794, 50.0778}, CountryId{"CZ"}}, // Cerhenice
    {Coordinate{15.7492, 50.0631}, CountryId{"CZ"}}, // Q18423707
    {Coordinate{16.038, 50.5994}, CountryId{"CZ"}}, // Q18423820
    {Coordinate{12.925, 49.4356}, CountryId{"CZ"}}, // Q18424233
    {Coordinate{14.3348, 48.8279}, CountryId{"CZ"}}, // Q18424238
    {Coordinate{14.2306, 50.7933}, CountryId{"CZ"}}, // Děčín-Prostřední Žleb
    {Coordinate{14.2233, 50.775}, CountryId{"CZ"}}, // Děčín východ railway station
    {Coordinate{16.5161, 48.9766}, CountryId{"CZ"}}, // Q18424689
    {Coordinate{16.2119, 50.5133}, CountryId{"CZ"}}, // Q18424745
    {Coordinate{15.473, 49.8217}, CountryId{"CZ"}}, // Golčův Jeníkov město (train station)
    {Coordinate{15.5394, 49.6142}, CountryId{"CZ"}}, // Q18425174
    {Coordinate{17.7581, 49.7133}, CountryId{"CZ"}}, // Q18425212
    {Coordinate{14.9222, 50.1111}, CountryId{"CZ"}}, // Poříčany
    {Coordinate{14.6514, 49.8417}, CountryId{"CZ"}}, // Q18425251
    {Coordinate{15.6336, 49.8939}, CountryId{"CZ"}}, // Prachovice (train station)
    {Coordinate{14.2242, 50.0714}, CountryId{"CZ"}}, // Q18425274
    {Coordinate{14.346, 50.0622}, CountryId{"CZ"}}, // Q18425278
    {Coordinate{15.7314, 50.175}, CountryId{"CZ"}}, // Praskačka
    {Coordinate{12.8686, 50.3067}, CountryId{"CZ"}}, // Q18425286
    {Coordinate{15.6961, 50.5472}, CountryId{"CZ"}}, // Prosečné (train station)
    {Coordinate{17.1117, 49.479}, CountryId{"CZ"}}, // Q18425459
    {Coordinate{17.7887, 49.6968}, CountryId{"CZ"}}, // Q18425664
    {Coordinate{15.9111, 50.3569}, CountryId{"CZ"}}, // Jaroměř zastávka
    {Coordinate{13.4486, 50.4922}, CountryId{"CZ"}}, // Q18425820
    {Coordinate{14.0378, 50.14}, CountryId{"CZ"}}, // Q18425991
    {Coordinate{14.4489, 48.8911}, CountryId{"CZ"}}, // Q18425993
    {Coordinate{14.0867, 50.1472}, CountryId{"CZ"}}, // Q18426205
    {Coordinate{14.1536, 50.1661}, CountryId{"CZ"}}, // Q18426208
    {Coordinate{14.0844, 50.1414}, CountryId{"CZ"}}, // Q18426211
    {Coordinate{12.9747, 49.8847}, CountryId{"CZ"}}, // Q18426336
    {Coordinate{15.6489, 49.9283}, CountryId{"CZ"}}, // Q18426382
    {Coordinate{15.6511, 49.9206}, CountryId{"CZ"}}, // Q18426384
    {Coordinate{14.9617, 50.1858}, CountryId{"CZ"}}, // Kostomlaty nad Labem (train station)
    {Coordinate{-1.24499, 49.3023}, CountryId{"FR"}}, // Gare de Carentan
    {Coordinate{14.9836, 50.0994}, CountryId{"CZ"}}, // Tatce
    {Coordinate{16.1722, 50.5928}, CountryId{"CZ"}}, // Q18430229
    {Coordinate{16.1494, 50.5967}, CountryId{"CZ"}}, // Q18430230
    {Coordinate{16.7984, 49.1637}, CountryId{"CZ"}}, // Q18430251
    {Coordinate{16.409, 49.1722}, CountryId{"CZ"}}, // Q18430254
    {Coordinate{13.2419, 49.7242}, CountryId{"CZ"}}, // Tlučná
    {Coordinate{12.9911, 50.0506}, CountryId{"CZ"}}, // Q18430354
    {Coordinate{15.6567, 50.1594}, CountryId{"CZ"}}, // Q18430373
    {Coordinate{12.8394, 49.42}, CountryId{"CZ"}}, // Q18430408
    {Coordinate{15.8881, 50.5614}, CountryId{"CZ"}}, // Q18430427
    {Coordinate{14.4217, 48.6017}, CountryId{"CZ"}}, // Q18430535
    {Coordinate{15.72, 50.5392}, CountryId{"CZ"}}, // Q18430537
    {Coordinate{14.4686, 48.775}, CountryId{"CZ"}}, // Q18430693
    {Coordinate{14.1358, 50.105}, CountryId{"CZ"}}, // Q18430695
    {Coordinate{13.0333, 50.5}, CountryId{"CZ"}}, // Vejprty station
    {Coordinate{14.4361, 48.8197}, CountryId{"CZ"}}, // Q18430775
    {Coordinate{14.4531, 48.8364}, CountryId{"CZ"}}, // Velešín město
    {Coordinate{15.1244, 50.0675}, CountryId{"CZ"}}, // Velim
    {Coordinate{14.38, 50.9931}, CountryId{"CZ"}}, // Velký Šenov railway station
    {Coordinate{13.7636, 49.0486}, CountryId{"CZ"}}, // Q18430802
    {Coordinate{12.8144, 49.4864}, CountryId{"CZ"}}, // Q18430806
    {Coordinate{15.8342, 50.5464}, CountryId{"CZ"}}, // Q18430809
    {Coordinate{13.2997, 49.3492}, CountryId{"CZ"}}, // Vrhaveč station
    {Coordinate{15.7642, 50.2525}, CountryId{"CZ"}}, // Všestary
    {Coordinate{15.6961, 50.1667}, CountryId{"CZ"}}, // Q18431479
    {Coordinate{15.1831, 50.1276}, CountryId{"CZ"}}, // Q18431491
    {Coordinate{17.0745, 49.7129}, CountryId{"CZ"}}, // Litovel
    {Coordinate{17.0713, 49.6941}, CountryId{"CZ"}}, // Litovel předměstí
    {Coordinate{13.1156, 49.3656}, CountryId{"CZ"}}, // Q18431669
    {Coordinate{17.0911, 50.0889}, CountryId{"CZ"}}, // Q18431671
    {Coordinate{14.0811, 50.5103}, CountryId{"CZ"}}, // Q18431676
    {Coordinate{13.3272, 50.1261}, CountryId{"CZ"}}, // Q18431679
    {Coordinate{13.3144, 49.5483}, CountryId{"CZ"}}, // Q18431701
    {Coordinate{13.2156, 49.6803}, CountryId{"CZ"}}, // Q18431800
    {Coordinate{16.0506, 50.5294}, CountryId{"CZ"}}, // Q18431820
    {Coordinate{14.7353, 50.1597}, CountryId{"CZ"}}, // Čelákovice zastávka
    {Coordinate{17.7094, 49.7881}, CountryId{"CZ"}}, // Q18432116
    {Coordinate{16.1847, 50.5522}, CountryId{"CZ"}}, // Q18432121
    {Coordinate{13.8289, 49.1111}, CountryId{"CZ"}}, // Q18432124
    {Coordinate{12.9844, 49.4667}, CountryId{"CZ"}}, // Milavče station
    {Coordinate{16.2042, 50.5372}, CountryId{"CZ"}}, // Žďár nad Metují
    {Coordinate{16.429, 49.0852}, CountryId{"CZ"}}, // Moravské Bránice (train station)
    {Coordinate{13.8204, 50.6588}, CountryId{"CZ"}}, // Q18432742
    {Coordinate{16.4941, 48.8257}, CountryId{"CZ"}}, // Q18432744
    {Coordinate{12.78, 50.2736}, CountryId{"CZ"}}, // Nová Role
    {Coordinate{15.1506, 50.0547}, CountryId{"CZ"}}, // Nová Ves u Kolína
    {Coordinate{15.0333, 50.1844}, CountryId{"CZ"}}, // Q18432796
    {Coordinate{17.8092, 49.685}, CountryId{"CZ"}}, // Q18432881
    {Coordinate{15.4869, 49.6306}, CountryId{"CZ"}}, // Okrouhlice
    {Coordinate{12.5581, 50.2547}, CountryId{"CZ"}}, // Q18432938
    {Coordinate{14.4475, 48.725}, CountryId{"CZ"}}, // Q18432942
    {Coordinate{16.4858, 49.815}, CountryId{"CZ"}}, // Q18432944
    {Coordinate{13.2989, 49.6006}, CountryId{"CZ"}}, // Q18433528
    {Coordinate{16.06, 50.5753}, CountryId{"CZ"}}, // Q18433560
    {Coordinate{12.5353, 50.2872}, CountryId{"CZ"}}, // Q18433931
    {Coordinate{16.4627, 49.1082}, CountryId{"CZ"}}, // Silůvky (train station)
    {Coordinate{15.9768, 38.713}, CountryId{"IT"}}, // Q18434303
    {Coordinate{14.1019, 50.2261}, CountryId{"CZ"}}, // Q18434317
    {Coordinate{12.7011, 49.7397}, CountryId{"CZ"}}, // Q18434544
    {Coordinate{16.4829, 49.1539}, CountryId{"CZ"}}, // Q18434966
    {Coordinate{14.7777, 41.0501}, CountryId{"IT"}}, // Chianche-Ceppaloni railway station
    {Coordinate{14.5722, 41.2105}, CountryId{"IT"}}, // stazione di Solopaca
    {Coordinate{0.803018, 44.38}, CountryId{"FR"}}, // Gare de Penne-d'Agenais
    {Coordinate{5.79917, 49.5636}, CountryId{"BE"}}, // Aubange railway station
    {Coordinate{3.3435, 50.3102}, CountryId{"FR"}}, // Q1845098
    {Coordinate{8.63891, 40.6814}, CountryId{"IT"}}, // Campomela railway station
    {Coordinate{24.7275, 59.4255}, CountryId{"EE"}}, // Lilleküla railway station
    {Coordinate{5.10767, 50.2677}, CountryId{"BE"}}, // Leignon railway station
    {Coordinate{7.78227, 48.8135}, CountryId{"FR"}}, // Gare de Haguenau
    {Coordinate{2.32126, 43.1305}, CountryId{"FR"}}, // Gare de Verzeille
    {Coordinate{-0.910766, 43.5245}, CountryId{"FR"}}, // Gare de Puyoô
    {Coordinate{2.13817, 48.8427}, CountryId{"FR"}}, // Gare de La Celle-Saint-Cloud
    {Coordinate{6.03222, 51.235}, CountryId{"NL"}}, // Swalmen railway station
    {Coordinate{-8.45265, 40.6723}, CountryId{"PT"}}, // Sernada do Vouga railway station
    {Coordinate{14.4514, 50.0925}, CountryId{"CZ"}}, // Křižíkova
    {Coordinate{4.86463, 51.0026}, CountryId{"BE"}}, // Langdorp railway station
    {Coordinate{6.16241, 47.2001}, CountryId{"FR"}}, // Gare de Mamirolle
    {Coordinate{-1.38926, 47.2929}, CountryId{"FR"}}, // Q1848535
    {Coordinate{12.2598, 42.5919}, CountryId{"IT"}}, // Stazione di Alviano
    {Coordinate{2.5425, 48.5644}, CountryId{"FR"}}, // Saint-Fargeau railway station
    {Coordinate{73.1811, 22.3108}, CountryId{"IN"}}, // Vadodara junction railway station
    {Coordinate{8.22267, 44.9569}, CountryId{"IT"}}, // Stazione di Portacomaro
    {Coordinate{4.34, 51.1256}, CountryId{"BE"}}, // Schelle railway station
    {Coordinate{37.5881, 55.7942}, CountryId{"RU"}}, // Savyolovsky railway station
    {Coordinate{14.426, 41.0876}, CountryId{"IT"}}, // Q18510373
    {Coordinate{4.83977, 45.0723}, CountryId{"FR"}}, // Gare de Tain-l'Hermitage - Tournon
    {Coordinate{72.8408, 21.2066}, CountryId{"IN"}}, // Surat railway station
    {Coordinate{11.3745, 53.3863}, CountryId{"DE"}}, // Jasnitz railway station
    {Coordinate{73.9258, 30.1471}, CountryId{"PK"}}, // Hindumalkote railway station
    {Coordinate{27.216, 59.3612}, CountryId{"EE"}}, // Kohtla railway station
    {Coordinate{27.0547, 59.3587}, CountryId{"EE"}}, // Püssi railway station
    {Coordinate{4.76879, 45.7347}, CountryId{"FR"}}, // Q1852144
    {Coordinate{5.58944, 52.1408}, CountryId{"NL"}}, // Barneveld Centrum railway station
    {Coordinate{6.669, 51.4135}, CountryId{"DE"}}, // Q1852663
    {Coordinate{26.9551, 59.3528}, CountryId{"EE"}}, // Kiviõli railway station
    {Coordinate{13.2364, 49.3806}, CountryId{"CZ"}}, // Q18534518
    {Coordinate{4.59757, 50.7074}, CountryId{"BE"}}, // Bierges-Walibi railway station
    {Coordinate{2.26806, 48.5911}, CountryId{"FR"}}, // Gare de La Norville - Saint-Germain-lès-Arpajon
    {Coordinate{13.8997, 49.8436}, CountryId{"CZ"}}, // Q1854987
    {Coordinate{4.21302, 50.3212}, CountryId{"BE"}}, // Fontaine-Valmont railway station
    {Coordinate{6.49261, 47.6831}, CountryId{"FR"}}, // Q1855889
    {Coordinate{1.10915, 46.0247}, CountryId{"FR"}}, // Q1856227
    {Coordinate{-0.501579, 45.4778}, CountryId{"FR"}}, // Clion-sur-Seugne
    {Coordinate{6.89348, 51.3415}, CountryId{"DE"}}, // Hösel station
    {Coordinate{5.36688, 50.67}, CountryId{"BE"}}, // Momalle railway station
    {Coordinate{2.37167, 48.7478}, CountryId{"FR"}}, // Pont de Rungis – Aéroport d'Orly
    {Coordinate{2.82529, 49.4228}, CountryId{"FR"}}, // Gare de Compiègne
    {Coordinate{2.30083, 48.8625}, CountryId{"FR"}}, // Pont de l'Alma
    {Coordinate{15.4654, 38.0464}, CountryId{"IT"}}, // Q18590151
    {Coordinate{15.4043, 37.9861}, CountryId{"IT"}}, // Q18590155
    {Coordinate{16.5726, 49.8925}, CountryId{"CZ"}}, // Q18590817
    {Coordinate{15.5611, 50.155}, CountryId{"CZ"}}, // Q18590819
    {Coordinate{16.4975, 49.8581}, CountryId{"CZ"}}, // Třebovice v Čechách
    {Coordinate{13.3439, 49.2847}, CountryId{"CZ"}}, // Nemilkov station
    {Coordinate{14.6106, 50.1161}, CountryId{"CZ"}}, // Praha-Horní Počernice
    {Coordinate{13.4853, 50.51}, CountryId{"CZ"}}, // Q18590893
    {Coordinate{13.8328, 50.1489}, CountryId{"CZ"}}, // Q18590898
    {Coordinate{15.0792, 49.4297}, CountryId{"CZ"}}, // Q18590899
    {Coordinate{14.4183, 50.3661}, CountryId{"CZ"}}, // Q18590900
    {Coordinate{16.0719, 50.6047}, CountryId{"CZ"}}, // Q18590933
    {Coordinate{17.062, 48.8276}, CountryId{"CZ"}}, // Q18590936
    {Coordinate{16.0847, 50.5869}, CountryId{"CZ"}}, // Q18590938
    {Coordinate{17.1615, 49.3357}, CountryId{"CZ"}}, // Q18590939
    {Coordinate{2.54222, 48.8231}, CountryId{"FR"}}, // Villiers-sur-Marne - Le Plessis-Trévise station
    {Coordinate{-2.24225, 53.4739}, CountryId{"GB"}}, // Manchester Oxford Road railway station
    {Coordinate{-2.24453, 53.4872}, CountryId{"GB"}}, // Manchester Victoria station
    {Coordinate{-4.7589, 43.4209}, CountryId{"ES"}}, // Q18601876
    {Coordinate{2.4357, 44.921}, CountryId{"FR"}}, // Gare d'Aurillac
    {Coordinate{11.2655, 47.4403}, CountryId{"DE"}}, // Mittenwald station
    {Coordinate{9.16317, 49.2304}, CountryId{"DE"}}, // Bad Wimpfen train station
    {Coordinate{6.49241, 47.0508}, CountryId{"FR"}}, // Gare de Gilley
    {Coordinate{11.7784, 45.2915}, CountryId{"IT"}}, // Q18613410
    {Coordinate{10.4208, 50.5742}, CountryId{"DE"}}, // Meiningen station
    {Coordinate{13.1981, 49.6569}, CountryId{"CZ"}}, // Chotěšov u Stoda
    {Coordinate{14.2961, 50.4369}, CountryId{"CZ"}}, // Q18613952
    {Coordinate{13.7242, 50.525}, CountryId{"CZ"}}, // Q18613955
    {Coordinate{12.6639, 49.8061}, CountryId{"CZ"}}, // Q18614025
    {Coordinate{14.8653, 49.4214}, CountryId{"CZ"}}, // Q18614027
    {Coordinate{13.175, 49.2772}, CountryId{"CZ"}}, // Dešenice
    {Coordinate{15.2439, 50.7402}, CountryId{"CZ"}}, // Q18614032
    {Coordinate{13.0161, 50.3075}, CountryId{"CZ"}}, // Q18614113
    {Coordinate{2.63389, 48.8389}, CountryId{"FR"}}, // Lognes
    {Coordinate{2.44933, 49.2927}, CountryId{"FR"}}, // Q1861624
    {Coordinate{34.5697, 48.1833}, CountryId{"UA"}}, // Ryasna
    {Coordinate{8.24932, 50.4003}, CountryId{"DE"}}, // Aumenau station
    {Coordinate{9.10134, 49.2377}, CountryId{"DE"}}, // Bad Rappenau station
    {Coordinate{12.5307, 52.4118}, CountryId{"DE"}}, // Q18616521
    {Coordinate{13.8822, 53.6597}, CountryId{"DE"}}, // Ferdinandshof railway station
    {Coordinate{10.4217, 51.9111}, CountryId{"DE"}}, // Goslar railway station
    {Coordinate{6.60694, 51.2228}, CountryId{"DE"}}, // Kaarster Bahnhof station
    {Coordinate{8.78175, 48.9837}, CountryId{"DE"}}, // Q18616528
    {Coordinate{16.2293, 46.9455}, CountryId{"AT"}}, // Bahnhof Mogersdorf
    {Coordinate{7.28874, 50.9329}, CountryId{"DE"}}, // Bahnhof Overath
    {Coordinate{21.7781, 57.3544}, CountryId{"LV"}}, // Elkšķene Station
    {Coordinate{4.4325, 51.2817}, CountryId{"BE"}}, // Kapellen railway station
    {Coordinate{10.3142, 53.5297}, CountryId{"DE"}}, // Aumühle railway station
    {Coordinate{10.0964, 53.5158}, CountryId{"DE"}}, // Billwerder-Moorfleet station
    {Coordinate{83.4168, 26.7506}, CountryId{"IN"}}, // Gorakhpur Cantonment railway station
    {Coordinate{74.9136, 33.9531}, CountryId{"IN"}}, // Kakapora railway station
    {Coordinate{74.6388, 16.8199}, CountryId{"IN"}}, // Miraj Junction railway station
    {Coordinate{10.1317, 53.4978}, CountryId{"DE"}}, // Mittlerer Landweg station
    {Coordinate{76.6115, 8.99454}, CountryId{"IN"}}, // Munroturuttu railway station
    {Coordinate{10.1811, 53.4878}, CountryId{"DE"}}, // Nettelnburg station
    {Coordinate{76.5256, 9.13202}, CountryId{"IN"}}, // Ochira railway station
    {Coordinate{74.895, 33.9988}, CountryId{"IN"}}, // Pampore railway station
    {Coordinate{76.6203, 8.94792}, CountryId{"IN"}}, // Perinad railway station
    {Coordinate{85.4147, 25.0331}, CountryId{"IN"}}, // Rajgir railway station
    {Coordinate{17.9654, 40.3897}, CountryId{"IT"}}, // Salice-Veglie railway station
    {Coordinate{74.4512, 34.258}, CountryId{"IN"}}, // Sopore Railway Station
    {Coordinate{10.0658, 53.5311}, CountryId{"DE"}}, // Tiefstack station
    {Coordinate{22.5686, 51.2316}, CountryId{"PL"}}, // Lublin
    {Coordinate{7.31428, 43.707}, CountryId{"FR"}}, // Villefranche-sur-Mer railway station
    {Coordinate{0.573483, 43.078}, CountryId{"FR"}}, // Gare de Montréjeau-Gourdan-Polignan
    {Coordinate{7.07957, 51.1638}, CountryId{"DE"}}, // Solingen Grünewald station
    {Coordinate{7.64659, 47.5337}, CountryId{"CH"}}, // Q18630045
    {Coordinate{2.29074, 48.5651}, CountryId{"FR"}}, // Marolles-en-Hurepoix (Paris RER)
    {Coordinate{7.40799, 50.9868}, CountryId{"DE"}}, // Engelskirchen station
    {Coordinate{2.02757, 48.9704}, CountryId{"FR"}}, // Q1864282
    {Coordinate{28.8857, 60.3582}, CountryId{"RU"}}, // Q18643833
    {Coordinate{29.3984, 60.1713}, CountryId{"RU"}}, // Q18643860
    {Coordinate{29.359, 60.1793}, CountryId{"RU"}}, // Q18643862
    {Coordinate{3.34558, 44.474}, CountryId{"FR"}}, // Q1865145
    {Coordinate{8.61002, 46.9992}, CountryId{"CH"}}, // Brunnen railway station
    {Coordinate{0.900523, 45.8814}, CountryId{"FR"}}, // Q1865229
    {Coordinate{4.43472, 51.2914}, CountryId{"BE"}}, // Sint-Mariaburg railway station
    {Coordinate{6.02552, 48.9855}, CountryId{"FR"}}, // Gare de Pagny-sur-Moselle
    {Coordinate{2.17532, 49.0705}, CountryId{"FR"}}, // Gare d'Auvers-sur-Oise
    {Coordinate{4.25944, 51.2083}, CountryId{"BE"}}, // Beveren railway station
    {Coordinate{27.175, 62.4522}, CountryId{"FI"}}, // Q18658791
    {Coordinate{}, CountryId{"FI"}}, // Hamina railway station
    {Coordinate{25.0726, 60.3399}, CountryId{"FI"}}, // Q18658843
    {Coordinate{27.22, 66.6967}, CountryId{"FI"}}, // Q18658855
    {Coordinate{}, CountryId{"FI"}}, // Q18658867
    {Coordinate{26.7878, 61.1953}, CountryId{"FI"}}, // Q18659086
    {Coordinate{28.8849, 61.2477}, CountryId{"FI"}}, // Q18659345
    {Coordinate{22.6551, 63.4084}, CountryId{"FI"}}, // Q18659468
    {Coordinate{27.1179, 60.8999}, CountryId{"FI"}}, // Kaipiainen railway station
    {Coordinate{24.7128, 64.1433}, CountryId{"FI"}}, // Kangas railway station
    {Coordinate{29.114, 61.8614}, CountryId{"FI"}}, // Q18659988
    {Coordinate{24.9617, 64.3464}, CountryId{"FI"}}, // Kilpua railway station
    {Coordinate{29.2878, 63.5147}, CountryId{"FI"}}, // Q18660102
    {Coordinate{26.6019, 60.8472}, CountryId{"FI"}}, // Koria railway station
    {Coordinate{29.7533, 63.3617}, CountryId{"FI"}}, // Kylänlahti railway station
    {Coordinate{22.9359, 61.9804}, CountryId{"FI"}}, // Q18660483
    {Coordinate{28.26, 61.0668}, CountryId{"FI"}}, // Q18660512
    {Coordinate{29.9925, 63.1522}, CountryId{"FI"}}, // Q18660555
    {Coordinate{-1.6725, 48.1033}, CountryId{"FR"}}, // Rennes railway station
    {Coordinate{25.4948, 60.7997}, CountryId{"FI"}}, // Henna railway station
    {Coordinate{}, CountryId{"FI"}}, // Q18660761
    {Coordinate{28.3371, 61.0867}, CountryId{"FI"}}, // Q18660892
    {Coordinate{21.513, 61.5904}, CountryId{"FI"}}, // Mäntyluoto railway station
    {Coordinate{}, CountryId{"FI"}}, // Q18660944
    {Coordinate{}, CountryId{"FI"}}, // Q18660971
    {Coordinate{25.375, 60.3822}, CountryId{"FI"}}, // Olli points
    {Coordinate{22.5158, 60.4233}, CountryId{"FI"}}, // Piikkiö railway station
    {Coordinate{29.7416, 61.7904}, CountryId{"FI"}}, // Q18661412
    {Coordinate{27.9731, 60.9272}, CountryId{"FI"}}, // Pulsa railway station
    {Coordinate{29.3825, 61.7611}, CountryId{"FI"}}, // Punkaharju railway station
    {Coordinate{28.6875, 61.1785}, CountryId{"FI"}}, // Q18661641
    {Coordinate{}, CountryId{"FI"}}, // Q18661662
    {Coordinate{28.3181, 63.0631}, CountryId{"FI"}}, // Q18661665
    {Coordinate{30.0486, 62.1428}, CountryId{"FI"}}, // Q18661666
    {Coordinate{21.4889, 61.1314}, CountryId{"FI"}}, // Rauma railway station
    {Coordinate{28.8028, 60.7322}, CountryId{"RU"}}, // Q18661669
    {Coordinate{24.1619, 65.7608}, CountryId{"FI"}}, // Q18661801
    {Coordinate{27.2856, 62.6758}, CountryId{"FI"}}, // Salminen railway station
    {Coordinate{26.9394, 60.4681}, CountryId{"FI"}}, // Kotka port railway station
    {Coordinate{23.3128, 61.8361}, CountryId{"FI"}}, // Q18662004
    {Coordinate{23.4428, 59.9794}, CountryId{"FI"}}, // Tammisaari railway station
    {Coordinate{28.0961, 61.0178}, CountryId{"FI"}}, // Q18662288
    {Coordinate{26.9544, 60.5733}, CountryId{"FI"}}, // Q18662311
    {Coordinate{27.9973, 61.0094}, CountryId{"FI"}}, // Q18662535
    {Coordinate{25.8792, 62.2478}, CountryId{"FI"}}, // Vaajakoski railway station
    {Coordinate{23.2272, 61.9174}, CountryId{"FI"}}, // Q18662650
    {Coordinate{}, CountryId{"FI"}}, // Q18662782
    {Coordinate{}, CountryId{"FI"}}, // Q18662802
    {Coordinate{26.795, 61.0956}, CountryId{"FI"}}, // Q18662950
    {Coordinate{29.9925, 63.1522}, CountryId{"FI"}}, // Vuonislahti railway station
    {Coordinate{22.5328, 62.9181}, CountryId{"FI"}}, // Q18663108
    {Coordinate{22.7066, 61.2968}, CountryId{"FI"}}, // Q18663135
    {Coordinate{2.11661, 49.3472}, CountryId{"FR"}}, // Gare de Saint-Sulpice-Auteuil
    {Coordinate{2.64037, 50.5212}, CountryId{"FR"}}, // Q1866833
    {Coordinate{-2.7525, 47.6653}, CountryId{"FR"}}, // Gare de Vannes
    {Coordinate{-1.94139, 46.6964}, CountryId{"FR"}}, // Gare de Saint-Gilles-Croix-de-Vie
    {Coordinate{11.9975, 53.837}, CountryId{"DE"}}, // Bützow station
    {Coordinate{11.9863, 51.9934}, CountryId{"DE"}}, // Güterglück railway station
    {Coordinate{2.41917, 48.7253}, CountryId{"FR"}}, // gare d'Ablon
    {Coordinate{14.4911, 50.0728}, CountryId{"CZ"}}, // Strašnická
    {Coordinate{9.027, 48.21}, CountryId{"DE"}}, // Albstadt-Ebingen
    {Coordinate{9.38237, 48.7204}, CountryId{"DE"}}, // Altbach
    {Coordinate{27.8089, 62.175}, CountryId{"FI"}}, // Q18681899
    {Coordinate{22.0886, 61.2095}, CountryId{"FI"}}, // Kiukainen railway station
    {Coordinate{25.2069, 66.1697}, CountryId{"FI"}}, // Koivu railway station
    {Coordinate{24.3756, 61.8077}, CountryId{"FI"}}, // Q18682054
    {Coordinate{22.7489, 60.7028}, CountryId{"FI"}}, // Kyrö railway station
    {Coordinate{}, CountryId{"FI"}}, // Q18682154
    {Coordinate{26.1961, 62.26}, CountryId{"FI"}}, // Lievestuore Railway Station
    {Coordinate{27.2628, 64.5347}, CountryId{"FI"}}, // Q18682185
    {Coordinate{28.6739, 62.9278}, CountryId{"FI"}}, // Q18682203
    {Coordinate{27.7606, 60.9444}, CountryId{"FI"}}, // Luumäki railway station
    {Coordinate{8.84099, 47.7589}, CountryId{"DE"}}, // Singen (Hohentwiel) station
    {Coordinate{26.1855, 60.9164}, CountryId{"FI"}}, // Q18682240
    {Coordinate{}, CountryId{"FI"}}, // Q18682293
    {Coordinate{22.0011, 61.365}, CountryId{"FI"}}, // Q18682313
    {Coordinate{30.6003, 62.1747}, CountryId{"FI"}}, // Niirala railway station
    {Coordinate{24.3661, 61.05}, CountryId{"FI"}}, // Q18682401
    {Coordinate{28.2775, 62.0139}, CountryId{"FI"}}, // Rantasalmi railway station
    {Coordinate{27.8975, 60.9778}, CountryId{"FI"}}, // Q18682507
    {Coordinate{26.4783, 62.3026}, CountryId{"FI"}}, // Hankasalmi Railway Station
    {Coordinate{29.085, 61.3008}, CountryId{"FI"}}, // Q18682514
    {Coordinate{23.6267, 61.0633}, CountryId{"FI"}}, // Q18682515
    {Coordinate{28.8001, 63.6864}, CountryId{"FI"}}, // Valtimo railway station
    {Coordinate{28.1867, 64.4886}, CountryId{"FI"}}, // Q18682528
    {Coordinate{24.3651, 61.7969}, CountryId{"FI"}}, // Juupajoki stop
    {Coordinate{25.0606, 65.6633}, CountryId{"FI"}}, // Simo railway station
    {Coordinate{29.3719, 61.425}, CountryId{"FI"}}, // Q18682635
    {Coordinate{30.1208, 62.3179}, CountryId{"FI"}}, // Säkäniemi railway point
    {Coordinate{27.5592, 60.9131}, CountryId{"FI"}}, // Taavetti railway station
    {Coordinate{25.2903, 64.7703}, CountryId{"FI"}}, // Tikkaperä railway station
    {Coordinate{25.0283, 64.6083}, CountryId{"FI"}}, // Tuomioja railway station
    {Coordinate{26.4139, 64.7589}, CountryId{"FI"}}, // Utajärvi railway station
    {Coordinate{}, CountryId{"FI"}}, // Q18682850
    {Coordinate{}, CountryId{"FI"}}, // Q18682873
    {Coordinate{8.98453, 49.4654}, CountryId{"DE"}}, // Eberbach railway station
    {Coordinate{4.06923, 50.5731}, CountryId{"BE"}}, // Soignies railway station
    {Coordinate{1.21219, 45.6213}, CountryId{"FR"}}, // Gare de La Meyze
    {Coordinate{4.25361, 51.9164}, CountryId{"NL"}}, // Maassluis Centrum metro station
    {Coordinate{12.9817, 52.9615}, CountryId{"DE"}}, // Lindow (Mark) railway station
    {Coordinate{12.9001, 53.0929}, CountryId{"DE"}}, // Rheinsberg (Mark) railway station
    {Coordinate{0.830346, 44.8625}, CountryId{"FR"}}, // Gare de Trémolat
    {Coordinate{2.79944, 48.3783}, CountryId{"FR"}}, // Gare de Moret-Veneux-les-Sablons
    {Coordinate{1.98, 45.3544}, CountryId{"FR"}}, // Gare de Montaignac-Saint-Hippolyte
    {Coordinate{23.42, 62.6422}, CountryId{"FI"}}, // Q18691335
    {Coordinate{4.25776, 50.7507}, CountryId{"BE"}}, // Buizingen railway station
    {Coordinate{6.88229, 51.0372}, CountryId{"DE"}}, // Köln-Blumenberg station
    {Coordinate{2.43109, 50.4802}, CountryId{"FR"}}, // Q1869616
    {Coordinate{4.76405, 52.9326}, CountryId{"NL"}}, // Den Helder Zuid railway station
    {Coordinate{1.27639, 49.5567}, CountryId{"FR"}}, // Gare de Longuerue-Vieux-Manoir
    {Coordinate{0.330393, 49.5607}, CountryId{"FR"}}, // Gare d'Étainhus - Saint-Romain
    {Coordinate{-0.441667, 45.4389}, CountryId{"FR"}}, // Jonzac
    {Coordinate{25.7544, 64.9125}, CountryId{"FI"}}, // Pikkarala railway station
    {Coordinate{6.4825, 46.3692}, CountryId{"FR"}}, // Gare de Thonon-les-Bains
    {Coordinate{14.5681, 50.0886}, CountryId{"CZ"}}, // Praha-Dolní Počernice
    {Coordinate{5.48294, 43.2863}, CountryId{"FR"}}, // Gare de la Barasse
    {Coordinate{23.5815, 49.9355}, CountryId{"UA"}}, // Q18712024
    {Coordinate{14.1565, 49.9033}, CountryId{"CZ"}}, // Q18718630
    {Coordinate{6.77056, 43.4228}, CountryId{"FR"}}, // Q1871873
    {Coordinate{15.5281, 50.0364}, CountryId{"CZ"}}, // Q1872080
    {Coordinate{6.57556, 52.4414}, CountryId{"NL"}}, // Daarlerveen railway station
    {Coordinate{2.52018, 49.2979}, CountryId{"FR"}}, // Q1872396
    {Coordinate{24.185, 65.8508}, CountryId{"FI"}}, // Q1873186
    {Coordinate{4.70396, 44.3749}, CountryId{"FR"}}, // Q1873503
    {Coordinate{11.1527, 51.7853}, CountryId{"DE"}}, // Quedlinburg station
    {Coordinate{6.9916, 51.0316}, CountryId{"DE"}}, // Leverkusen Mitte station
    {Coordinate{12.3586, 50.1167}, CountryId{"CZ"}}, // Františkovy Lázně-Aquaforum station
    {Coordinate{14.9971, 37.4558}, CountryId{"IT"}}, // Q18747427
    {Coordinate{16.9494, 50.1431}, CountryId{"CZ"}}, // Q18747816
    {Coordinate{15.0625, 49.7494}, CountryId{"CZ"}}, // Q18747820
    {Coordinate{14.5844, 50.2822}, CountryId{"CZ"}}, // Q18747822
    {Coordinate{14.3247, 49.3928}, CountryId{"CZ"}}, // Q18747878
    {Coordinate{15.0486, 49.7519}, CountryId{"CZ"}}, // Q18747879
    {Coordinate{14.6142, 50.2536}, CountryId{"CZ"}}, // Q18747880
    {Coordinate{12.7686, 49.635}, CountryId{"CZ"}}, // Q18747884
    {Coordinate{7.29143, 43.7222}, CountryId{"FR"}}, // Q18749562
    {Coordinate{73.8134, 15.3972}, CountryId{"IN"}}, // Vasco da Gama railway station
    {Coordinate{2.4593, 50.7878}, CountryId{"FR"}}, // Cassel
    {Coordinate{10.0331, 53.6064}, CountryId{"DE"}}, // Rübenkamp station
    {Coordinate{2.3536, 48.9846}, CountryId{"FR"}}, // Gare de Groslay
    {Coordinate{3.43053, 46.2091}, CountryId{"FR"}}, // Gare de Saint-Germain-des-Fossés
    {Coordinate{12.1547, 50.2431}, CountryId{"CZ"}}, // Q1875817
    {Coordinate{16.3677, 48.2606}, CountryId{"AT"}}, // Q18762414
    {Coordinate{0.693611, 47.3897}, CountryId{"FR"}}, // Tours railway station
    {Coordinate{5.67278, 51.9222}, CountryId{"NL"}}, // Hemmen-Dodewaard railway station
    {Coordinate{1.80892, 48.983}, CountryId{"FR"}}, // Q1877088
    {Coordinate{14.439, 50.091}, CountryId{"CZ"}}, // Florenc
    {Coordinate{6.899, 45.9505}, CountryId{"FR"}}, // Gare des Tines
    {Coordinate{57.8346, 55.0417}, CountryId{"RU"}}, // Q18776148
    {Coordinate{8.9409, 49.8331}, CountryId{"DE"}}, // Groß-Umstadt Wiebelsbach station
    {Coordinate{0.549316, 46.8186}, CountryId{"FR"}}, // Q1878152
    {Coordinate{9.08601, 40.9083}, CountryId{"IT"}}, // Aggius train station
    {Coordinate{10.9681, 43.6054}, CountryId{"IT"}}, // Q18785594
    {Coordinate{11.7908, 42.0918}, CountryId{"IT"}}, // Q18785596
    {Coordinate{15.5955, 41.0621}, CountryId{"IT"}}, // Q18785602
    {Coordinate{10.6966, 44.9591}, CountryId{"IT"}}, // Luzzara railway station
    {Coordinate{8.89871, 46.1731}, CountryId{"CH"}}, // Riazzino-Cugnasco train station
    {Coordinate{11.8746, 44.767}, CountryId{"IT"}}, // Rovereto-San Vito-Medelana railway station
    {Coordinate{7.27002, 48.5075}, CountryId{"FR"}}, // Wisches
    {Coordinate{6.01771, 49.225}, CountryId{"FR"}}, // Q1879204
    {Coordinate{8.83056, 54.3342}, CountryId{"DE"}}, // Q1879381
    {Coordinate{2.11309, 42.5021}, CountryId{"FR"}}, // Gare de Mont-Louis - La Cabanasse
    {Coordinate{12.725, 49.9025}, CountryId{"CZ"}}, // Chodová Planá railway station
    {Coordinate{6.30278, 45.353}, CountryId{"FR"}}, // Saint-Avre - La Chambre
    {Coordinate{14.4311, 50.0753}, CountryId{"CZ"}}, // I. P. Pavlova
    {Coordinate{4.60778, 52.3908}, CountryId{"NL"}}, // Overveen railway station
    {Coordinate{1.65722, 44.8183}, CountryId{"FR"}}, // Gare de Rocamadour-Padirac
    {Coordinate{37.8717, 48.1208}, CountryId{"UA"}}, // Yasynuvata
    {Coordinate{1.71532, 48.9836}, CountryId{"FR"}}, // Mantes-Station
    {Coordinate{6.22985, 50.7686}, CountryId{"DE"}}, // Q1881097
    {Coordinate{5.5242, 50.4027}, CountryId{"BE"}}, // Sy railway station
    {Coordinate{15.3089, 49.6844}, CountryId{"CZ"}}, // Q18817191
    {Coordinate{14.6036, 50.3056}, CountryId{"CZ"}}, // Q18817192
    {Coordinate{14.8575, 48.9647}, CountryId{"CZ"}}, // Q18817194
    {Coordinate{14.3245, 48.8931}, CountryId{"CZ"}}, // Holubov
    {Coordinate{14.5569, 50.2675}, CountryId{"CZ"}}, // Tišice
    {Coordinate{15.4617, 50.6322}, CountryId{"CZ"}}, // Q18817255
    {Coordinate{14.5725, 49.3336}, CountryId{"CZ"}}, // Q18817256
    {Coordinate{14.3572, 48.9172}, CountryId{"CZ"}}, // Vrábče (train station)
    {Coordinate{14.4983, 50.2356}, CountryId{"CZ"}}, // Q18817259
    {Coordinate{14.1569, 50.6706}, CountryId{"CZ"}}, // Povrly
    {Coordinate{13.9917, 49.8753}, CountryId{"CZ"}}, // Q18817280
    {Coordinate{15.3289, 50.1458}, CountryId{"CZ"}}, // Q18817281
    {Coordinate{14.5797, 49.3489}, CountryId{"CZ"}}, // Q18817282
    {Coordinate{14.5072, 50.215}, CountryId{"CZ"}}, // Zlonín
    {Coordinate{15.235, 49.7078}, CountryId{"CZ"}}, // Q18817284
    {Coordinate{2.57806, 48.8425}, CountryId{"FR"}}, // Noisy - Champs Station
    {Coordinate{2.2282, 48.8197}, CountryId{"FR"}}, // Gare de Bellevue
    {Coordinate{6.14667, 52.0906}, CountryId{"NL"}}, // Brummen railway station
    {Coordinate{4.32583, 51.0811}, CountryId{"BE"}}, // Ruisbroek-Sauvegarde railway station
    {Coordinate{15.38, 37.9617}, CountryId{"IT"}}, // Q18844698
    {Coordinate{15.1695, 37.6618}, CountryId{"IT"}}, // Q18844700
    {Coordinate{15.3914, 37.9729}, CountryId{"IT"}}, // Q18844701
    {Coordinate{15.3677, 37.9463}, CountryId{"IT"}}, // Santa Teresa di Riva railway station
    {Coordinate{3.7936, 50.6612}, CountryId{"BE"}}, // Rebaix railway station
    {Coordinate{-1.51083, 47.2067}, CountryId{"FR"}}, // Gare de Saint-Sébastien-Pas-Enchantés
    {Coordinate{3.97351, 47.8596}, CountryId{"FR"}}, // Q1885176
    {Coordinate{15.8175, 52.2419}, CountryId{"PL"}}, // Zbąszynek
    {Coordinate{4.08389, 51.1492}, CountryId{"BE"}}, // Belsele railway station
    {Coordinate{6.98788, 51.2508}, CountryId{"DE"}}, // Mettmann Stadtwald station
    {Coordinate{5.92361, 46.8592}, CountryId{"FR"}}, // Gare d'Andelot
    {Coordinate{3.51694, 50.3633}, CountryId{"FR"}}, // Valenciennes railway station
    {Coordinate{6.87763, 48.1984}, CountryId{"FR"}}, // Q1888255
    {Coordinate{7.23919, 47.6273}, CountryId{"FR"}}, // Q1888534
    {Coordinate{3.44608, 50.0397}, CountryId{"FR"}}, // Gare de Busigny
    {Coordinate{0.192021, 49.2871}, CountryId{"FR"}}, // Gare de Pont-l'Évêque
    {Coordinate{1.66695, 50.6609}, CountryId{"FR"}}, // Hesdigneul
    {Coordinate{7.42451, 48.5332}, CountryId{"FR"}}, // Q1889469
    {Coordinate{2.99527, 50.7082}, CountryId{"FR"}}, // Quesnoy-sur-Deûle
    {Coordinate{2.18167, 48.6975}, CountryId{"FR"}}, // Orsay-Ville Station
    {Coordinate{2.08939, 43.6241}, CountryId{"FR"}}, // Q1890161
    {Coordinate{1.97052, 49.0997}, CountryId{"FR"}}, // Gare d'Us
    {Coordinate{7.07, 46.0931}, CountryId{"CH"}}, // Q1891056
    {Coordinate{7.73944, 50.7831}, CountryId{"DE"}}, // Q1891076
    {Coordinate{3.89257, 45.0428}, CountryId{"FR"}}, // Le Puy-en-Velay railway station
    {Coordinate{-3.19321, 47.7822}, CountryId{"FR"}}, // Q1891517
    {Coordinate{6.73267, 43.432}, CountryId{"FR"}}, // Gare de Fréjus
    {Coordinate{6.07081, 50.7491}, CountryId{"DE"}}, // Aachen Süd railway station
    {Coordinate{2.32778, 48.7983}, CountryId{"FR"}}, // gare d'Arcueil - Cachan
    {Coordinate{1.00049, 47.1305}, CountryId{"FR"}}, // Q1892240
    {Coordinate{12.3185, 43.0947}, CountryId{"IT"}}, // Q18923658
    {Coordinate{12.3559, 43.1024}, CountryId{"IT"}}, // Perugia Capitini railway station
    {Coordinate{5.19434, 44.6945}, CountryId{"FR"}}, // Q1892411
    {Coordinate{15.0578, 49.9136}, CountryId{"CZ"}}, // Hatě (train station)
    {Coordinate{15.0561, 49.8956}, CountryId{"CZ"}}, // Q18924229
    {Coordinate{16.1358, 50.0648}, CountryId{"CZ"}}, // Čermná nad Orlicí (train station)
    {Coordinate{15.0483, 49.8656}, CountryId{"CZ"}}, // Q18924301
    {Coordinate{14.8872, 50.4478}, CountryId{"CZ"}}, // Q18924303
    {Coordinate{15.7709, 49.248}, CountryId{"CZ"}}, // Q18924304
    {Coordinate{14.5106, 49.2922}, CountryId{"CZ"}}, // Q18924305
    {Coordinate{4.18049, 50.4782}, CountryId{"BE"}}, // La Louvière-Centre railway station
    {Coordinate{4.97694, 52.2786}, CountryId{"NL"}}, // Abcoude railway station
    {Coordinate{-1.84306, 48.5939}, CountryId{"FR"}}, // Q1893283
    {Coordinate{5.29194, 51.6547}, CountryId{"NL"}}, // Vught railway station
    {Coordinate{3.98732, 50.911}, CountryId{"BE"}}, // Ede railway station
    {Coordinate{2.58139, 49.5625}, CountryId{"FR"}}, // Gare de Tricot
    {Coordinate{6.94111, 50.9686}, CountryId{"DE"}}, // Köln Geldernstraße Parkgürtel station
    {Coordinate{14.0833, 49.9669}, CountryId{"CZ"}}, // Beroun-Závodí railway station
    {Coordinate{2.09022, 41.3313}, CountryId{"ES"}}, // Prat de Llobregat
    {Coordinate{9.44056, 48.6447}, CountryId{"DE"}}, // Kirchheim (Teck) station
    {Coordinate{14.1731, 49.9317}, CountryId{"CZ"}}, // Karlštejn (train station)
    {Coordinate{-2.44972, 47.6833}, CountryId{"FR"}}, // Q1895691
    {Coordinate{3.24916, 50.4772}, CountryId{"FR"}}, // Orchies
    {Coordinate{2.42278, 42.6181}, CountryId{"FR"}}, // Q1897049
    {Coordinate{0.631366, 42.9629}, CountryId{"FR"}}, // Q1897337
    {Coordinate{4.63194, 43.6847}, CountryId{"FR"}}, // Gare d'Arles
    {Coordinate{0.707778, 45.1874}, CountryId{"FR"}}, // Gare de Périgueux
    {Coordinate{-1.55, 47.1842}, CountryId{"FR"}}, // Gare de Rezé-Pont-Rousseau
    {Coordinate{7.20966, 51.4725}, CountryId{"DE"}}, // Bochum-Ehrenfeld station
    {Coordinate{2.09905, 47.2101}, CountryId{"FR"}}, // Q1901288
    {Coordinate{3.18966, 50.6116}, CountryId{"FR"}}, // Tressin
    {Coordinate{1.64166, 45.1818}, CountryId{"FR"}}, // Gare d'Aubazine-Saint-Hilaire
    {Coordinate{8.88889, 40.8254}, CountryId{"IT"}}, // Q19060534
    {Coordinate{11.6753, 44.923}, CountryId{"IT"}}, // Q19060595
    {Coordinate{11.7386, 44.961}, CountryId{"IT"}}, // Q19060596
    {Coordinate{11.7492, 45.1322}, CountryId{"IT"}}, // Q19060599
    {Coordinate{131.969, 43.3997}, CountryId{"RU"}}, // Q19060782
    {Coordinate{17.1143, 49.133}, CountryId{"CZ"}}, // Q19061069
    {Coordinate{14.1553, 50.5322}, CountryId{"CZ"}}, // Q19061070
    {Coordinate{15.9658, 49.2126}, CountryId{"CZ"}}, // Vladislav (train station)
    {Coordinate{15.0919, 49.1947}, CountryId{"CZ"}}, // Q19061075
    {Coordinate{14.5467, 50.2386}, CountryId{"CZ"}}, // Jiřice (train station)
    {Coordinate{14.4355, 51.0068}, CountryId{"CZ"}}, // Šluknov zastávka railway station
    {Coordinate{14.0442, 48.7519}, CountryId{"CZ"}}, // Q19061177
    {Coordinate{14.61, 50.2044}, CountryId{"CZ"}}, // Q19061178
    {Coordinate{14.9511, 49.1642}, CountryId{"CZ"}}, // Q19061181
    {Coordinate{12.2719, 50.0861}, CountryId{"CZ"}}, // Pomezí nad Ohří station
    {Coordinate{13.39, 50.1}, CountryId{"CZ"}}, // Q19061223
    {Coordinate{14.8828, 49.1692}, CountryId{"CZ"}}, // Q19061224
    {Coordinate{14.6647, 50.1836}, CountryId{"CZ"}}, // Q19061225
    {Coordinate{-0.673809, 46.1997}, CountryId{"FR"}}, // Q1906409
    {Coordinate{5.49796, 50.6185}, CountryId{"BE"}}, // Jemeppe-sur-Meuse railway station
    {Coordinate{4.14417, 51.1719}, CountryId{"BE"}}, // Sint-Niklaas railway station
    {Coordinate{-3.88221, 48.5079}, CountryId{"FR"}}, // Gare de Pleyber-Christ
    {Coordinate{16.1361, 49.9958}, CountryId{"CZ"}}, // Q1907836
    {Coordinate{5.66222, 53.0397}, CountryId{"NL"}}, // Sneek Noord railway station
    {Coordinate{5.32146, 43.3635}, CountryId{"FR"}}, // L'Estaque
    {Coordinate{-5.4286, 57.4228}, CountryId{"GB"}}, // Strathcarron railway station
    {Coordinate{3.27547, 50.1918}, CountryId{"FR"}}, // Q1910819
    {Coordinate{4.67194, 51.0947}, CountryId{"BE"}}, // Melkouwen railway station
    {Coordinate{3.20182, 51.2231}, CountryId{"BE"}}, // Brugge-Sint-Pieters railway station
    {Coordinate{7.10172, 51.2543}, CountryId{"DE"}}, // Velbert-Rosenhügel station
    {Coordinate{3.12106, 49.5807}, CountryId{"FR"}}, // Q1912185
    {Coordinate{7.10958, 51.4417}, CountryId{"DE"}}, // Essen-Eiberg station
    {Coordinate{-0.538965, 45.5781}, CountryId{"FR"}}, // Pons
    {Coordinate{2.82753, 45.7637}, CountryId{"FR"}}, // Q1914494
    {Coordinate{5.17944, 52.0169}, CountryId{"NL"}}, // Houten Castellum railway station
    {Coordinate{4.6325, 51.3569}, CountryId{"BE"}}, // Noorderkempen railway station
    {Coordinate{2.20972, 49.0358}, CountryId{"FR"}}, // Gare de Bessancourt
    {Coordinate{-1.96191, 48.4995}, CountryId{"FR"}}, // Gare de Pleudihen
    {Coordinate{6.93332, 46.0325}, CountryId{"FR"}}, // Gare de Vallorcine
    {Coordinate{7.45762, 43.7607}, CountryId{"FR"}}, // Q1917107
    {Coordinate{3.34876, 50.4564}, CountryId{"FR"}}, // Rosult
    {Coordinate{2.36389, 49.7544}, CountryId{"FR"}}, // Gare d'Ailly-sur-Noye
    {Coordinate{3.88868, 50.508}, CountryId{"BE"}}, // Erbisœul railway station
    {Coordinate{7.1284, 51.1631}, CountryId{"DE"}}, // Bahnhof Solingen-Schaberg
    {Coordinate{4.8132, 45.7174}, CountryId{"FR"}}, // Gare d'Oullins
    {Coordinate{-0.227205, 44.5686}, CountryId{"FR"}}, // Gare de Saint-Macaire
    {Coordinate{4.41176, 50.3527}, CountryId{"BE"}}, // Jamioulx railway station
    {Coordinate{3.38599, 45.8212}, CountryId{"FR"}}, // Gare de Lezoux
    {Coordinate{6.67444, 53.4094}, CountryId{"NL"}}, // Uithuizen railway station
    {Coordinate{5.56944, 51.3853}, CountryId{"NL"}}, // Heeze railway station
    {Coordinate{7.51607, 43.9441}, CountryId{"FR"}}, // Gare de Breil-sur-Roya
    {Coordinate{5.50972, 50.6197}, CountryId{"BE"}}, // Pont-de-Seraing railway station
    {Coordinate{18.9151, 50.3434}, CountryId{"PL"}}, // Bytom
    {Coordinate{4.80427, 45.8886}, CountryId{"FR"}}, // Gare de Saint-Germain-au-Mont-d'Or
    {Coordinate{7.56613, 48.5454}, CountryId{"FR"}}, // Gare de Duttlenheim
    {Coordinate{7.48756, 47.6349}, CountryId{"FR"}}, // Gare de Bartenheim
    {Coordinate{2.6991, 49.0321}, CountryId{"FR"}}, // Q1923376
    {Coordinate{2.46389, 48.8436}, CountryId{"FR"}}, // Fontenay-sous-Bois (Paris RER)
    {Coordinate{-3.11806, 48.7618}, CountryId{"FR"}}, // Q1923442
    {Coordinate{-0.220278, 47.3622}, CountryId{"FR"}}, // Gare des Rosiers-sur-Loire
    {Coordinate{4.63876, 50.958}, CountryId{"BE"}}, // Wespelaar-Tildonk railway station
    {Coordinate{5.43694, 51.2214}, CountryId{"BE"}}, // Neerpelt railway station
    {Coordinate{3.12734, 51.025}, CountryId{"BE"}}, // Lichtervelde railway station
    {Coordinate{2.79925, 48.4067}, CountryId{"FR"}}, // Q1925713
    {Coordinate{7.21605, 48.4801}, CountryId{"FR"}}, // Gare de Schirmeck-La Broque
    {Coordinate{3.01271, 48.5614}, CountryId{"FR"}}, // Gare de Nangis
    {Coordinate{4.77837, 45.9069}, CountryId{"FR"}}, // Q1926670
    {Coordinate{2.79439, 49.1428}, CountryId{"FR"}}, // Gare de Nanteuil-le-Haudouin
    {Coordinate{6.76454, 50.5592}, CountryId{"DE"}}, // Bad Münstereifel station
    {Coordinate{6.68544, 49.802}, CountryId{"DE"}}, // Ehrang station
    {Coordinate{13.6152, 52.3715}, CountryId{"DE"}}, // Eichwalde station
    {Coordinate{8.783, 50.6053}, CountryId{"DE"}}, // Großen Buseck station
    {Coordinate{13.2675, 52.2986}, CountryId{"DE"}}, // Ludwigsfelde railway station
    {Coordinate{11.1328, 51.6703}, CountryId{"DE"}}, // Q19274496
    {Coordinate{6.35789, 51.1505}, CountryId{"DE"}}, // Q19274497
    {Coordinate{14.1008, 52.5244}, CountryId{"DE"}}, // Müncheberg
    {Coordinate{14.4492, 51.8441}, CountryId{"DE"}}, // Peitz Ost station
    {Coordinate{13.9228, 52.5283}, CountryId{"DE"}}, // Rehfelde station
    {Coordinate{10.3722, 52.0496}, CountryId{"DE"}}, // Salzgitter-Bad station
    {Coordinate{14.3517, 52.5594}, CountryId{"DE"}}, // Seelow-Gusow station
    {Coordinate{13.7453, 53.515}, CountryId{"DE"}}, // Strasburg (Uckerm) railway station
    {Coordinate{13.1722, 52.685}, CountryId{"DE"}}, // Velten
    {Coordinate{7.95654, 51.6163}, CountryId{"DE"}}, // Welver station
    {Coordinate{14.4056, 52.565}, CountryId{"DE"}}, // Werbig station
    {Coordinate{10.5319, 52.1589}, CountryId{"DE"}}, // Wolfenbüttel station
    {Coordinate{6.59199, 51.5424}, CountryId{"DE"}}, // Rheinberg (Rheinland)
    {Coordinate{2.50472, 48.7525}, CountryId{"FR"}}, // Boissy-Saint-Léger
    {Coordinate{-0.34187, 47.8417}, CountryId{"FR"}}, // Gare de Sablé
    {Coordinate{6.985, 51.589}, CountryId{"DE"}}, // Gladbeck-Zweckel station
    {Coordinate{6.65956, 48.5049}, CountryId{"FR"}}, // Q1928764
    {Coordinate{1.80869, 48.9632}, CountryId{"FR"}}, // Épône - Mézières
    {Coordinate{18.6231, 49.7433}, CountryId{"CZ"}}, // Český Těšín railway station
    {Coordinate{14.0483, 50.65}, CountryId{"CZ"}}, // Ústí nad Labem-Střekov railway station
    {Coordinate{7.58717, 48.5441}, CountryId{"FR"}}, // Gare de Duppigheim
    {Coordinate{7.6534, 48.9052}, CountryId{"FR"}}, // Gare de Gundershoffen
    {Coordinate{1.38322, 43.5965}, CountryId{"FR"}}, // Gare de Lardenne
    {Coordinate{5.72944, 51.8111}, CountryId{"NL"}}, // Wijchen railway station
    {Coordinate{1.69183, 47.8136}, CountryId{"FR"}}, // Gare de Meung-sur-Loire
    {Coordinate{2.82481, 48.6446}, CountryId{"FR"}}, // Gare de Verneuil-l'Étang
    {Coordinate{5.52448, 45.5446}, CountryId{"FR"}}, // Saint-André-le-Gaz railway station
    {Coordinate{3.82694, 50.8158}, CountryId{"BE"}}, // Lierde railway station
    {Coordinate{4.40816, 50.7947}, CountryId{"BE"}}, // Boitsfort railway station
    {Coordinate{10.8153, 59.6886}, CountryId{"NO"}}, // Holstad Station
    {Coordinate{11.4483, 59.1244}, CountryId{"NO"}}, // Tistedal Station
    {Coordinate{9.05083, 60.6489}, CountryId{"NO"}}, // Q19327501
    {Coordinate{9.5675, 59.2544}, CountryId{"NO"}}, // Hoppestad Station
    {Coordinate{9.34667, 59.3411}, CountryId{"NO"}}, // Valebø Station
    {Coordinate{9.85583, 61.5756}, CountryId{"NO"}}, // Harpefoss Station
    {Coordinate{10.42, 61.1406}, CountryId{"NO"}}, // Hove Station
    {Coordinate{10.6667, 60.96}, CountryId{"NO"}}, // Ring stasjon
    {Coordinate{10.7369, 60.9125}, CountryId{"NO"}}, // Ringsaker Station
    {Coordinate{9.42583, 62.1764}, CountryId{"NO"}}, // Q19327577
    {Coordinate{10.2464, 59.7669}, CountryId{"NO"}}, // Q19327607
    {Coordinate{14.17, 66.3222}, CountryId{"NO"}}, // Gullsmedvik Station
    {Coordinate{14.94, 66.4992}, CountryId{"NO"}}, // Hjartåsen Station
    {Coordinate{13.2894, 65.6217}, CountryId{"NO"}}, // Laksfors Station
    {Coordinate{11.4397, 63.7606}, CountryId{"NO"}}, // Rinnan Station
    {Coordinate{14.5356, 66.4017}, CountryId{"NO"}}, // Storforshei Station
    {Coordinate{9.05972, 60.0997}, CountryId{"NO"}}, // Q19327842
    {Coordinate{11.3722, 62.7036}, CountryId{"NO"}}, // Q19327896
    {Coordinate{11.3019, 62.5472}, CountryId{"NO"}}, // Q19327899
    {Coordinate{11.4547, 60.9847}, CountryId{"NO"}}, // Øksna Station
    {Coordinate{11.9361, 60.6211}, CountryId{"NO"}}, // Haslemo Station
    {Coordinate{6.155, 58.5339}, CountryId{"NO"}}, // Helleland train station
    {Coordinate{9.08722, 59.1861}, CountryId{"NO"}}, // Nakksjø Station
    {Coordinate{7.01806, 58.3678}, CountryId{"NO"}}, // Sandvatn Station
    {Coordinate{8.72611, 58.6917}, CountryId{"NO"}}, // Selåsvatn Station
    {Coordinate{}, CountryId{"NO"}}, // Leira Station
    {Coordinate{9.96444, 60.8297}, CountryId{"NO"}}, // Nordsinni Station
    {Coordinate{10.4893, 60.6232}, CountryId{"NO"}}, // Trevatn Station
    {Coordinate{9.61222, 59.2061}, CountryId{"NO"}}, // Skien Old Station
    {Coordinate{2.8374, 49.2001}, CountryId{"FR"}}, // Q1934115
    {Coordinate{6.62806, 52.5725}, CountryId{"NL"}}, // Hardenberg railway station
    {Coordinate{0.334675, 48.0195}, CountryId{"FR"}}, // Gare de Champagné
    {Coordinate{5.7175, 50.8378}, CountryId{"NL"}}, // Maastricht Randwyck railway station
    {Coordinate{13.7692, 54.0439}, CountryId{"DE"}}, // Wolgast railway station
    {Coordinate{3.85723, 44.7327}, CountryId{"FR"}}, // Gare de Langogne
    {Coordinate{4.39045, 51.1975}, CountryId{"BE"}}, // Antwerp-South railway station
    {Coordinate{15.3231, 50.7605}, CountryId{"CZ"}}, // Dolní Polubný railway station
    {Coordinate{10.0833, 54.3311}, CountryId{"DE"}}, // Q19361135
    {Coordinate{10.0909, 54.3492}, CountryId{"DE"}}, // Q19361144
    {Coordinate{9.97891, 54.4098}, CountryId{"DE"}}, // Q19361648
    {Coordinate{9.82056, 54.5418}, CountryId{"DE"}}, // Q19361996
    {Coordinate{5.42317, 45.3967}, CountryId{"FR"}}, // Grand-Lemps railway station
    {Coordinate{9.77118, 54.6371}, CountryId{"DE"}}, // Q19362007
    {Coordinate{15.6044, 50.5092}, CountryId{"CZ"}}, // Q19366262
    {Coordinate{17.1665, 48.9879}, CountryId{"CZ"}}, // Q19366263
    {Coordinate{13.4228, 50.1686}, CountryId{"CZ"}}, // Q19366264
    {Coordinate{15.6589, 50.5}, CountryId{"CZ"}}, // Q19366266
    {Coordinate{12.6247, 50.19}, CountryId{"CZ"}}, // Q19366268
    {Coordinate{14.0086, 49.6147}, CountryId{"CZ"}}, // Q19366338
    {Coordinate{15.0564, 50.5586}, CountryId{"CZ"}}, // Q19366340
    {Coordinate{13.8614, 48.8775}, CountryId{"CZ"}}, // Q19366341
    {Coordinate{15.0517, 50.2392}, CountryId{"CZ"}}, // Q19366346
    {Coordinate{15.0122, 49.9994}, CountryId{"CZ"}}, // Q19366348
    {Coordinate{10.1817, 54.2867}, CountryId{"DE"}}, // Kiel-Elmschenhagen
    {Coordinate{10.0626, 54.2431}, CountryId{"DE"}}, // Q19366881
    {Coordinate{9.99788, 54.1293}, CountryId{"DE"}}, // Einfeld station
    {Coordinate{9.82354, 53.99}, CountryId{"DE"}}, // Q19368505
    {Coordinate{9.68078, 53.8526}, CountryId{"DE"}}, // Q19368562
    {Coordinate{9.64506, 53.8049}, CountryId{"DE"}}, // Q19368581
    {Coordinate{2.73774, 42.6774}, CountryId{"FR"}}, // Q1937209
    {Coordinate{9.3275, 58.9356}, CountryId{"NO"}}, // Farsjø Station
    {Coordinate{-0.505715, 44.7168}, CountryId{"FR"}}, // Gare de Saint-Médard-d'Eyrans
    {Coordinate{10.4815, 59.4041}, CountryId{"NO"}}, // Horten Station
    {Coordinate{6.56941, 48.1088}, CountryId{"FR"}}, // Gare de Pouxeux
    {Coordinate{4.07259, 50.8914}, CountryId{"BE"}}, // Denderleeuw railway station
    {Coordinate{0.855388, 49.0037}, CountryId{"FR"}}, // Q1938997
    {Coordinate{14.9391, 50.4789}, CountryId{"CZ"}}, // Q19400421
    {Coordinate{14.5539, 49.31}, CountryId{"CZ"}}, // Bechyňská Smoleč
    {Coordinate{15.15, 49.2089}, CountryId{"CZ"}}, // Q19400433
    {Coordinate{12.7086, 49.5919}, CountryId{"CZ"}}, // Q19400435
    {Coordinate{14.1783, 49.9096}, CountryId{"CZ"}}, // Q19400436
    {Coordinate{15.0087, 49.3291}, CountryId{"CZ"}}, // Q19400437
    {Coordinate{15.7328, 50.4517}, CountryId{"CZ"}}, // Q19400444
    {Coordinate{17.4396, 48.9407}, CountryId{"CZ"}}, // Q19400447
    {Coordinate{13.8786, 50.6722}, CountryId{"CZ"}}, // Q19400455
    {Coordinate{17.9262, 49.0962}, CountryId{"CZ"}}, // Q19400456
    {Coordinate{16.3561, 48.988}, CountryId{"CZ"}}, // Q19400458
    {Coordinate{15.015, 50.0153}, CountryId{"CZ"}}, // Q19400463
    {Coordinate{15.7495, 49.3056}, CountryId{"CZ"}}, // Q19400465
    {Coordinate{14.0028, 49.7383}, CountryId{"CZ"}}, // Q19400466
    {Coordinate{15.0361, 50.5456}, CountryId{"CZ"}}, // Q19400468
    {Coordinate{15.1844, 49.7222}, CountryId{"CZ"}}, // Q19400475
    {Coordinate{17.2895, 48.9369}, CountryId{"CZ"}}, // Q19400476
    {Coordinate{14.9489, 50.2722}, CountryId{"CZ"}}, // Q19400479
    {Coordinate{16.2061, 49.9057}, CountryId{"CZ"}}, // Q19400486
    {Coordinate{17.7728, 49.5274}, CountryId{"CZ"}}, // Q19400495
    {Coordinate{14.4058, 48.9267}, CountryId{"CZ"}}, // Q19400496
    {Coordinate{14.2861, 48.6442}, CountryId{"CZ"}}, // Q19400498
    {Coordinate{15.2069, 49.9878}, CountryId{"CZ"}}, // Q19400499
    {Coordinate{13.3047, 49.4956}, CountryId{"CZ"}}, // Q19400500
    {Coordinate{16.7836, 50.1044}, CountryId{"CZ"}}, // Q19400501
    {Coordinate{12.3481, 50.0739}, CountryId{"CZ"}}, // Cheb-Skalka station
    {Coordinate{14.4564, 50.2672}, CountryId{"CZ"}}, // Q19400509
    {Coordinate{14.8058, 49.8697}, CountryId{"CZ"}}, // Q19400512
    {Coordinate{13.0678, 49.3653}, CountryId{"CZ"}}, // Q19400513
    {Coordinate{15.6428, 49.9892}, CountryId{"CZ"}}, // Q19400514
    {Coordinate{14.8103, 50.3394}, CountryId{"CZ"}}, // Q19400518
    {Coordinate{15.1211, 49.9703}, CountryId{"CZ"}}, // Q19400519
    {Coordinate{14.5769, 49.8394}, CountryId{"CZ"}}, // Q19400520
    {Coordinate{15.1944, 49.7122}, CountryId{"CZ"}}, // Q19400521
    {Coordinate{14.3375, 50.2397}, CountryId{"CZ"}}, // Q19400524
    {Coordinate{12.6156, 50.1644}, CountryId{"CZ"}}, // Citice (train station)
    {Coordinate{12.8864, 50.2547}, CountryId{"CZ"}}, // Q19400547
    {Coordinate{14.3985, 49.8876}, CountryId{"CZ"}}, // Davle
    {Coordinate{13.2861, 49.4508}, CountryId{"CZ"}}, // Q19400554
    {Coordinate{14.9654, 49.3623}, CountryId{"CZ"}}, // Q19400563
    {Coordinate{13.9992, 49.5561}, CountryId{"CZ"}}, // Q19400565
    {Coordinate{13.0881, 49.3717}, CountryId{"CZ"}}, // Q19400568
    {Coordinate{14.7697, 49.42}, CountryId{"CZ"}}, // Q19400569
    {Coordinate{14.9394, 50.3553}, CountryId{"CZ"}}, // Q19400571
    {Coordinate{16.1211, 50.2844}, CountryId{"CZ"}}, // Q19400572
    {Coordinate{14.3506, 50.2206}, CountryId{"CZ"}}, // Dolany nad Vltavou
    {Coordinate{14.4364, 50.3886}, CountryId{"CZ"}}, // Q19400578
    {Coordinate{16.7472, 50.0656}, CountryId{"CZ"}}, // Q19400581
    {Coordinate{14.0484, 50.5967}, CountryId{"CZ"}}, // Dolní Zálezly
    {Coordinate{15.0628, 49.9369}, CountryId{"CZ"}}, // Q19400592
    {Coordinate{14.6342, 50.2425}, CountryId{"CZ"}}, // Dřísy (train station)
    {Coordinate{12.7219, 49.6289}, CountryId{"CZ"}}, // Q19400600
    {Coordinate{13.1775, 49.3353}, CountryId{"CZ"}}, // Q19400601
    {Coordinate{14.8969, 48.8553}, CountryId{"CZ"}}, // Q19400603
    {Coordinate{14.7364, 49.1183}, CountryId{"CZ"}}, // Q19400623
    {Coordinate{15.8744, 48.9846}, CountryId{"CZ"}}, // Grešlové Mýto
    {Coordinate{13.175, 49.2111}, CountryId{"CZ"}}, // Q19400672
    {Coordinate{15.4734, 49.5254}, CountryId{"CZ"}}, // Q19400676
    {Coordinate{14.3494, 48.6192}, CountryId{"CZ"}}, // Q19400677
    {Coordinate{16.3897, 48.7517}, CountryId{"CZ"}}, // Q19400679
    {Coordinate{15.2933, 49.9817}, CountryId{"CZ"}}, // Hlízov
    {Coordinate{14.6753, 48.8958}, CountryId{"CZ"}}, // Q19400682
    {Coordinate{15.2186, 50.0022}, CountryId{"CZ"}}, // Q19400683
    {Coordinate{14.3614, 50.4528}, CountryId{"CZ"}}, // Q19400684
    {Coordinate{14.1039, 48.7786}, CountryId{"CZ"}}, // Hodňov
    {Coordinate{13.2222, 49.1908}, CountryId{"CZ"}}, // Q19400687
    {Coordinate{14.4478, 48.8514}, CountryId{"CZ"}}, // Q19400689
    {Coordinate{16.8246, 49.1798}, CountryId{"CZ"}}, // Holubice
    {Coordinate{15.0286, 50.1528}, CountryId{"CZ"}}, // Q19400691
    {Coordinate{15.5681, 50.5267}, CountryId{"CZ"}}, // Q19400692
    {Coordinate{16.0831, 50.6231}, CountryId{"CZ"}}, // Q19400693
    {Coordinate{15.5867, 50.5967}, CountryId{"CZ"}}, // Q19400694
    {Coordinate{14.3864, 50.4225}, CountryId{"CZ"}}, // Q19400698
    {Coordinate{15.3117, 49.2908}, CountryId{"CZ"}}, // Q19400700
    {Coordinate{15.2586, 49.2344}, CountryId{"CZ"}}, // Q19400701
    {Coordinate{12.7778, 49.5603}, CountryId{"CZ"}}, // Q19400706
    {Coordinate{14.5275, 50.1806}, CountryId{"CZ"}}, // Q19400709
    {Coordinate{15.5011, 50.6231}, CountryId{"CZ"}}, // Q19400710
    {Coordinate{14.3653, 48.9264}, CountryId{"CZ"}}, // Hradce
    {Coordinate{17.5752, 49.0444}, CountryId{"CZ"}}, // Q19400714
    {Coordinate{14.8794, 48.8728}, CountryId{"CZ"}}, // Q19400716
    {Coordinate{14.1742, 50.485}, CountryId{"CZ"}}, // Hrdly (train station)
    {Coordinate{14.2289, 50.4597}, CountryId{"CZ"}}, // Q19400720
    {Coordinate{14.0261, 49.0497}, CountryId{"CZ"}}, // Q19400722
    {Coordinate{14.7719, 49.8722}, CountryId{"CZ"}}, // Q19400724
    {Coordinate{15.4511, 50.6806}, CountryId{"CZ"}}, // Q19400729
    {Coordinate{14.3967, 49.9469}, CountryId{"CZ"}}, // Dolní Břežany-Jarov
    {Coordinate{14.2114, 50.0942}, CountryId{"CZ"}}, // Jeneč (train station)
    {Coordinate{14.4077, 48.629}, CountryId{"CZ"}}, // Q19400739
    {Coordinate{14.2908, 49.3819}, CountryId{"CZ"}}, // Q19400742
    {Coordinate{15.3806, 50.4503}, CountryId{"CZ"}}, // Q19400751
    {Coordinate{13.9872, 49.7822}, CountryId{"CZ"}}, // Q19400752
    {Coordinate{15.0308, 49.7756}, CountryId{"CZ"}}, // Q19400756
    {Coordinate{15.0031, 50.1889}, CountryId{"CZ"}}, // Q19400759
    {Coordinate{14.5169, 49.8664}, CountryId{"CZ"}}, // Kamenný Přívoz
    {Coordinate{14.4511, 48.9092}, CountryId{"CZ"}}, // Q19400761
    {Coordinate{15.6608, 50.5583}, CountryId{"CZ"}}, // Q19400784
    {Coordinate{17.7692, 49.7372}, CountryId{"CZ"}}, // Q19400792
    {Coordinate{13.6406, 50.1422}, CountryId{"CZ"}}, // Q19400794
    {Coordinate{14.6561, 50.3069}, CountryId{"CZ"}}, // Q19400797
    {Coordinate{16.8995, 49.2158}, CountryId{"CZ"}}, // Q19400801
    {Coordinate{15.1383, 49.9731}, CountryId{"CZ"}}, // Q19400808
    {Coordinate{14.6706, 50.3172}, CountryId{"CZ"}}, // Q19400810
    {Coordinate{15.4036, 50.5686}, CountryId{"CZ"}}, // Q19400811
    {Coordinate{17.1069, 50.0992}, CountryId{"CZ"}}, // Q19400836
    {Coordinate{15.8044, 49.2153}, CountryId{"CZ"}}, // Krahulov (train station)
    {Coordinate{12.675, 50.1892}, CountryId{"CZ"}}, // Q19400842
    {Coordinate{16.6876, 49.8488}, CountryId{"CZ"}}, // Krasíkov
    {Coordinate{15.6106, 50.1575}, CountryId{"CZ"}}, // Q19400844
    {Coordinate{14.9417, 49.3856}, CountryId{"CZ"}}, // Q19400846
    {Coordinate{16.8246, 49.1435}, CountryId{"CZ"}}, // Q19400848
    {Coordinate{14.2144, 50.5258}, CountryId{"CZ"}}, // Q19400850
    {Coordinate{14.5531, 49.8486}, CountryId{"CZ"}}, // Q19400851
    {Coordinate{15.1436, 50.2658}, CountryId{"CZ"}}, // Q19400852
    {Coordinate{14.8689, 50.3764}, CountryId{"CZ"}}, // Q19400854
    {Coordinate{14.7008, 50.3244}, CountryId{"CZ"}}, // Kropáčova Vrutice (train station)
    {Coordinate{15.8842, 50.3958}, CountryId{"CZ"}}, // Q19400858
    {Coordinate{15.6228, 50.5839}, CountryId{"CZ"}}, // Q19400861
    {Coordinate{17.9636, 49.6364}, CountryId{"CZ"}}, // Q19400863
    {Coordinate{15.1589, 49.7294}, CountryId{"CZ"}}, // Q19400873
    {Coordinate{14.7114, 50.1683}, CountryId{"CZ"}}, // Q19400874
    {Coordinate{15.1858, 50.2839}, CountryId{"CZ"}}, // Q19400879
    {Coordinate{16.8016, 48.7941}, CountryId{"CZ"}}, // Lednice (train station)
    {Coordinate{14.3725, 50.1894}, CountryId{"CZ"}}, // Libčice nad Vltavou-Letky (train station)
    {Coordinate{14.6194, 49.3814}, CountryId{"CZ"}}, // Q19400887
    {Coordinate{14.0406, 50.5642}, CountryId{"CZ"}}, // Q19400888
    {Coordinate{15.4172, 50.5556}, CountryId{"CZ"}}, // Q19400889
    {Coordinate{11.1281, 60.0397}, CountryId{"NO"}}, // Lindeberg Station
    {Coordinate{15.5383, 49.5561}, CountryId{"CZ"}}, // Q19400893
    {Coordinate{17.4578, 48.9098}, CountryId{"CZ"}}, // Q19400894
    {Coordinate{14.3711, 49.4211}, CountryId{"CZ"}}, // Q19400895
    {Coordinate{15.2122, 50.6472}, CountryId{"CZ"}}, // Q19400896
    {Coordinate{14.0333, 50.5586}, CountryId{"CZ"}}, // Litochovice nad Labem
    {Coordinate{14.1389, 50.5325}, CountryId{"CZ"}}, // Litoměřice město (train station)
    {Coordinate{14.5306, 50.2508}, CountryId{"CZ"}}, // Q19400903
    {Coordinate{13.9742, 49.8464}, CountryId{"CZ"}}, // Lochovice (train station)
    {Coordinate{12.6853, 49.8172}, CountryId{"CZ"}}, // Q19400905
    {Coordinate{14.7156, 49.8636}, CountryId{"CZ"}}, // Lštění
    {Coordinate{14.4625, 49.8647}, CountryId{"CZ"}}, // Luka pod Medníkem
    {Coordinate{14.0931, 50.5025}, CountryId{"CZ"}}, // Q19400914
    {Coordinate{16.923, 49.2486}, CountryId{"CZ"}}, // Q19400916
    {Coordinate{14.9461, 50.3183}, CountryId{"CZ"}}, // Q19400918
    {Coordinate{14.75, 49.0536}, CountryId{"CZ"}}, // Q19400920
    {Coordinate{14.8014, 50.2}, CountryId{"CZ"}}, // Q19400923
    {Coordinate{14.0564, 50.5381}, CountryId{"CZ"}}, // Q19400941
    {Coordinate{13.3672, 49.2992}, CountryId{"CZ"}}, // Malonice station
    {Coordinate{14.9319, 49.8219}, CountryId{"CZ"}}, // Q19400943
    {Coordinate{12.6578, 49.7869}, CountryId{"CZ"}}, // Q19400946
    {Coordinate{14.5258, 50.3331}, CountryId{"CZ"}}, // Q19400947
    {Coordinate{15.5408, 50.5806}, CountryId{"CZ"}}, // Martinice v Krkonoších
    {Coordinate{15.7676, 49.9746}, CountryId{"CZ"}}, // Q19400954
    {Coordinate{14.4675, 50.375}, CountryId{"CZ"}}, // Q19400957
    {Coordinate{14.5133, 50.2056}, CountryId{"CZ"}}, // Q19400959
    {Coordinate{14.2408, 48.7886}, CountryId{"CZ"}}, // Q19400962
    {Coordinate{14.5803, 49.4478}, CountryId{"CZ"}}, // Q19400963
    {Coordinate{14.3367, 50.9842}, CountryId{"CZ"}}, // Mikulášovice dolní nádraží
    {Coordinate{14.3572, 50.9622}, CountryId{"CZ"}}, // Mikulášovice střed
    {Coordinate{14.0219, 49.6322}, CountryId{"CZ"}}, // Milín
    {Coordinate{16.3625, 48.9354}, CountryId{"CZ"}}, // Miroslav
    {Coordinate{14.9156, 50.4192}, CountryId{"CZ"}}, // Q19400976
    {Coordinate{13.3639, 49.9867}, CountryId{"CZ"}}, // Q19400977
    {Coordinate{14.3467, 50.3186}, CountryId{"CZ"}}, // Q19400979
    {Coordinate{16.7531, 50.0256}, CountryId{"CZ"}}, // Q19400986
    {Coordinate{17.3147, 48.9772}, CountryId{"CZ"}}, // Q19400988
    {Coordinate{15.6922, 50.4911}, CountryId{"CZ"}}, // Q19400992
    {Coordinate{14.6914, 50.1364}, CountryId{"CZ"}}, // Mstětice
    {Coordinate{17.0395, 48.9047}, CountryId{"CZ"}}, // Mutěnice station
    {Coordinate{12.7731, 49.5447}, CountryId{"CZ"}}, // Q19401002
    {Coordinate{14.0219, 49.5286}, CountryId{"CZ"}}, // Q19401008
    {Coordinate{14.6394, 49.4503}, CountryId{"CZ"}}, // Q19401013
    {Coordinate{15.3519, 50.5842}, CountryId{"CZ"}}, // Q19401015
    {Coordinate{14.3086, 50.2833}, CountryId{"CZ"}}, // Q19401016
    {Coordinate{14.3022, 50.2625}, CountryId{"CZ"}}, // Q19401017
    {Coordinate{17.2165, 49.3449}, CountryId{"CZ"}}, // Q19401018
    {Coordinate{14.9111, 50.3739}, CountryId{"CZ"}}, // Q19401019
    {Coordinate{14.5217, 50.2558}, CountryId{"CZ"}}, // Q19401020
    {Coordinate{17.0802, 49.1493}, CountryId{"CZ"}}, // Q19401022
    {Coordinate{14.4214, 50.26}, CountryId{"CZ"}}, // Q19401023
    {Coordinate{17.7489, 49.0223}, CountryId{"CZ"}}, // Nezdenice (train station)
    {Coordinate{13.2994, 49.3256}, CountryId{"CZ"}}, // Neznašovy (train station)
    {Coordinate{14.4983, 48.9519}, CountryId{"CZ"}}, // Train station Nové Hodějovice
    {Coordinate{14.1192, 50.4972}, CountryId{"CZ"}}, // Q19401035
    {Coordinate{17.0053, 50.1161}, CountryId{"CZ"}}, // Q19401036
    {Coordinate{14.3164, 50.3014}, CountryId{"CZ"}}, // Nové Ouholice (train station)
    {Coordinate{17.9931, 49.6114}, CountryId{"CZ"}}, // Šenov u Nového Jičína
    {Coordinate{12.8125, 49.4772}, CountryId{"CZ"}}, // Q19401043
    {Coordinate{14.9483, 49.4244}, CountryId{"CZ"}}, // Q19401052
    {Coordinate{12.85, 49.5131}, CountryId{"CZ"}}, // Q19401055
    {Coordinate{15.949, 48.9032}, CountryId{"CZ"}}, // Q19401060
    {Coordinate{14.1939, 50.4775}, CountryId{"CZ"}}, // Q19401061
    {Coordinate{15.0861, 50.2417}, CountryId{"CZ"}}, // Q19401071
    {Coordinate{14.8909, 50.1879}, CountryId{"CZ"}}, // Ostrá
    {Coordinate{14.7461, 50.2058}, CountryId{"CZ"}}, // Q19401078
    {Coordinate{13.9378, 48.8053}, CountryId{"CZ"}}, // Q19401079
    {Coordinate{14.535, 49.4475}, CountryId{"CZ"}}, // Q19401081
    {Coordinate{14.1653, 50.095}, CountryId{"CZ"}}, // Q19401220
    {Coordinate{14.6256, 49.8336}, CountryId{"CZ"}}, // Q19401223
    {Coordinate{16.4192, 50.1608}, CountryId{"CZ"}}, // Q19401224
    {Coordinate{13.9108, 48.8481}, CountryId{"CZ"}}, // Pěkná
    {Coordinate{12.6792, 49.7708}, CountryId{"CZ"}}, // Q19401229
    {Coordinate{14.7558, 48.8456}, CountryId{"CZ"}}, // Q19401231
    {Coordinate{16.0033, 50.6017}, CountryId{"CZ"}}, // Q19401232
    {Coordinate{13.4341, 50.1354}, CountryId{"CZ"}}, // Petrohrad (train station)
    {Coordinate{14.4283, 49.8792}, CountryId{"CZ"}}, // Q19401234
    {Coordinate{14.4106, 49.8764}, CountryId{"CZ"}}, // Q19401237
    {Coordinate{13.1795, 49.3209}, CountryId{"CZ"}}, // Q19401238
    {Coordinate{14.3508, 48.865}, CountryId{"CZ"}}, // Q19401255
    {Coordinate{14.875, 49.8783}, CountryId{"CZ"}}, // Q19401256
    {Coordinate{15.6244, 50.6006}, CountryId{"CZ"}}, // Q19401262
    {Coordinate{16.8492, 50.0906}, CountryId{"CZ"}}, // Q19401263
    {Coordinate{14.2675, 50.5108}, CountryId{"CZ"}}, // Q19401266
    {Coordinate{15.4569, 50.6486}, CountryId{"CZ"}}, // Q19401274
    {Coordinate{15.4508, 50.6667}, CountryId{"CZ"}}, // Q19401275
    {Coordinate{16.8521, 48.7509}, CountryId{"CZ"}}, // Q19401283
    {Coordinate{16.9633, 50.08}, CountryId{"CZ"}}, // Q19401284
    {Coordinate{14.0086, 49.0151}, CountryId{"CZ"}}, // Prachatice
    {Coordinate{13.9975, 49.0058}, CountryId{"CZ"}}, // Prachatice lázně
    {Coordinate{14.0361, 50.5725}, CountryId{"CZ"}}, // Prackovice nad Labem
    {Coordinate{14.3103, 50.0839}, CountryId{"CZ"}}, // Q19401293
    {Coordinate{15.4072, 50.1525}, CountryId{"CZ"}}, // Q19401294
    {Coordinate{15.0786, 50.5789}, CountryId{"CZ"}}, // Q19401299
    {Coordinate{14.5322, 49.8636}, CountryId{"CZ"}}, // Q19401301
    {Coordinate{16.7539, 50.0989}, CountryId{"CZ"}}, // Prostřední Lipka
    {Coordinate{14.4442, 48.6811}, CountryId{"CZ"}}, // Q19401313
    {Coordinate{15.1058, 49.9672}, CountryId{"CZ"}}, // Q19401314
    {Coordinate{14.6986, 49.8611}, CountryId{"CZ"}}, // Pyšely
    {Coordinate{14.6117, 48.9008}, CountryId{"CZ"}}, // Q19401324
    {Coordinate{17.0331, 50.0156}, CountryId{"CZ"}}, // Q19401327
    {Coordinate{16.9125, 50.04}, CountryId{"CZ"}}, // Q19401329
    {Coordinate{13.9703, 49.8089}, CountryId{"CZ"}}, // Q19401331
    {Coordinate{14.3553, 50.1792}, CountryId{"CZ"}}, // Řež
    {Coordinate{17.4539, 49.379}, CountryId{"CZ"}}, // Q19401343
    {Coordinate{14.7319, 49.2067}, CountryId{"CZ"}}, // Q19401344
    {Coordinate{17.1986, 48.8929}, CountryId{"CZ"}}, // Q19401345
    {Coordinate{15.1803, 50.2992}, CountryId{"CZ"}}, // Q19401353
    {Coordinate{15.49, 50.5544}, CountryId{"CZ"}}, // Q19401354
    {Coordinate{14.365, 50.1678}, CountryId{"CZ"}}, // Q19401355
    {Coordinate{16.0911, 50.4994}, CountryId{"CZ"}}, // Q19401357
    {Coordinate{14.4317, 48.6494}, CountryId{"CZ"}}, // Q19401358
    {Coordinate{15.1439, 50.6836}, CountryId{"CZ"}}, // Q19401361
    {Coordinate{14.835, 49.8861}, CountryId{"CZ"}}, // Q19401368
    {Coordinate{14.9164, 49.8611}, CountryId{"CZ"}}, // Q19401372
    {Coordinate{15.2411, 50.13}, CountryId{"CZ"}}, // Q19401373
    {Coordinate{14.0533, 50.5928}, CountryId{"CZ"}}, // Q19401375
    {Coordinate{14.42, 49.4406}, CountryId{"CZ"}}, // Q19401391
    {Coordinate{14.9747, 49.4378}, CountryId{"CZ"}}, // Q19401403
    {Coordinate{16.6094, 49.4804}, CountryId{"CZ"}}, // Skalice nad Svitavou
    {Coordinate{14.3761, 49.9247}, CountryId{"CZ"}}, // Skochovice
    {Coordinate{14.475, 50.9903}, CountryId{"CZ"}}, // Šluknov údolí railway station
    {Coordinate{14.7353, 49.4158}, CountryId{"CZ"}}, // Q19401427
    {Coordinate{14.9606, 49.7897}, CountryId{"CZ"}}, // Q19401428
    {Coordinate{16.7333, 49.108}, CountryId{"CZ"}}, // Sokolnice-Telnice
    {Coordinate{13.9694, 48.9261}, CountryId{"CZ"}}, // Spálenecv
    {Coordinate{12.9858, 49.4156}, CountryId{"CZ"}}, // Q19401444
    {Coordinate{13.2225, 49.1614}, CountryId{"CZ"}}, // Q19401445
    {Coordinate{15.757, 50.0001}, CountryId{"CZ"}}, // Q19401460
    {Coordinate{13.0106, 49.3842}, CountryId{"CZ"}}, // Q19401464
    {Coordinate{14.9931, 50.2375}, CountryId{"CZ"}}, // Q19401473
    {Coordinate{14.9078, 50.1872}, CountryId{"CZ"}}, // Q19401474
    {Coordinate{13.0592, 50.3403}, CountryId{"CZ"}}, // Q19401475
    {Coordinate{12.7725, 49.6653}, CountryId{"CZ"}}, // Q19401476
    {Coordinate{15.0219, 49.7628}, CountryId{"CZ"}}, // Q19401478
    {Coordinate{14.8569, 49.8831}, CountryId{"CZ"}}, // Q19401479
    {Coordinate{16.0691, 49.2226}, CountryId{"CZ"}}, // Studenec
    {Coordinate{15.3194, 49.6703}, CountryId{"CZ"}}, // Q19401488
    {Coordinate{14.8803, 48.8919}, CountryId{"CZ"}}, // Q19401489
    {Coordinate{16.0053, 50.5322}, CountryId{"CZ"}}, // Suchovršice (train station)
    {Coordinate{14.9458, 49.4066}, CountryId{"CZ"}}, // Q19401491
    {Coordinate{17.2432, 48.8718}, CountryId{"CZ"}}, // Q19401493
    {Coordinate{12.6069, 50.1972}, CountryId{"CZ"}}, // Q19401498
    {Coordinate{17.6686, 49.7997}, CountryId{"CZ"}}, // Q19401499
    {Coordinate{12.7694, 49.5742}, CountryId{"CZ"}}, // Q19401503
    {Coordinate{15.465, 50.5458}, CountryId{"CZ"}}, // Q19401520
    {Coordinate{14.3219, 48.6197}, CountryId{"CZ"}}, // Těchoraz
    {Coordinate{13.9875, 49.5886}, CountryId{"CZ"}}, // Q19401527
    {Coordinate{15.0147, 49.9853}, CountryId{"CZ"}}, // Q19401529
    {Coordinate{14.9603, 50.1253}, CountryId{"CZ"}}, // Q19401531
    {Coordinate{17.5195, 49.3174}, CountryId{"CZ"}}, // Q19401533
    {Coordinate{12.7014, 49.6253}, CountryId{"CZ"}}, // Q19401534
    {Coordinate{14.3483, 48.8833}, CountryId{"CZ"}}, // Q19401535
    {Coordinate{14.5872, 48.9025}, CountryId{"CZ"}}, // Q19401536
    {Coordinate{13.1578, 49.3275}, CountryId{"CZ"}}, // Q19401543
    {Coordinate{14.3519, 50.1697}, CountryId{"CZ"}}, // Q19401545
    {Coordinate{12.75, 49.5778}, CountryId{"CZ"}}, // Q19401546
    {Coordinate{16.1789, 50.0317}, CountryId{"CZ"}}, // Q19401547
    {Coordinate{15.4189, 49.0536}, CountryId{"CZ"}}, // Q19401565
    {Coordinate{14.3764, 50.2564}, CountryId{"CZ"}}, // Q19401569
    {Coordinate{14.5069, 50.9811}, CountryId{"CZ"}}, // Valdek railway station
    {Coordinate{14.4494, 48.9242}, CountryId{"CZ"}}, // Q19401574
    {Coordinate{15.0233, 50.2144}, CountryId{"CZ"}}, // Q19401575
    {Coordinate{15.3136, 50.7114}, CountryId{"CZ"}}, // Q19401577
    {Coordinate{13.6633, 49.2983}, CountryId{"CZ"}}, // Velké Hydčice
    {Coordinate{16.0222, 50.5403}, CountryId{"CZ"}}, // Q19401579
    {Coordinate{15.1008, 50.1644}, CountryId{"CZ"}}, // Velké Zboží (train station)
    {Coordinate{14.0803, 50.5261}, CountryId{"CZ"}}, // Velké Žernoseky
    {Coordinate{15.1933, 50.1017}, CountryId{"CZ"}}, // Q19401585
    {Coordinate{14.3939, 51.0047}, CountryId{"CZ"}}, // Velký Šenov zastávka railway station
    {Coordinate{15.1997, 50.0736}, CountryId{"CZ"}}, // Q19401587
    {Coordinate{17.4162, 49.4083}, CountryId{"CZ"}}, // Q19401592
    {Coordinate{15.4839, 50.6269}, CountryId{"CZ"}}, // Q19401594
    {Coordinate{15.1581, 49.4156}, CountryId{"CZ"}}, // Q19401599
    {Coordinate{16.9, 50.0872}, CountryId{"CZ"}}, // Q19401600
    {Coordinate{14.8142, 49.8747}, CountryId{"CZ"}}, // Q19401601
    {Coordinate{14.9472, 50.3364}, CountryId{"CZ"}}, // Q19401602
    {Coordinate{14.3717, 50.335}, CountryId{"CZ"}}, // Vraňany (train station)
    {Coordinate{14.9861, 49.7897}, CountryId{"CZ"}}, // Q19401608
    {Coordinate{16.6048, 48.9637}, CountryId{"CZ"}}, // Q19401609
    {Coordinate{14.5664, 49.3244}, CountryId{"CZ"}}, // Q19401610
    {Coordinate{14.9575, 50.2569}, CountryId{"CZ"}}, // Q19401611
    {Coordinate{14.8658, 48.7961}, CountryId{"CZ"}}, // Q19401613
    {Coordinate{16.9375, 50.1164}, CountryId{"CZ"}}, // Q19401614
    {Coordinate{14.3264, 50.4572}, CountryId{"CZ"}}, // Q19401674
    {Coordinate{12.8325, 49.5161}, CountryId{"CZ"}}, // Q19401704
    {Coordinate{14.3897, 50.7119}, CountryId{"CZ"}}, // Žandov
    {Coordinate{16.0669, 50.1192}, CountryId{"CZ"}}, // Q19401717
    {Coordinate{15.9781, 49.8262}, CountryId{"CZ"}}, // Q19401718
    {Coordinate{13.1789, 49.2492}, CountryId{"CZ"}}, // Q19401719
    {Coordinate{14.6675, 50.1303}, CountryId{"CZ"}}, // Zeleneč
    {Coordinate{13.3628, 50.0467}, CountryId{"CZ"}}, // Q19401726
    {Coordinate{15.8481, 50.4031}, CountryId{"CZ"}}, // Q19401727
    {Coordinate{14.1008, 48.7636}, CountryId{"CZ"}}, // Žlábek
    {Coordinate{19.5444, 51.7631}, CountryId{"PL"}}, // Łódź Widzew railway station
    {Coordinate{0.569167, 46.8747}, CountryId{"FR"}}, // Q1940437
    {Coordinate{10.0574, 53.5767}, CountryId{"DE"}}, // Friedrichsberg station
    {Coordinate{1.69964, 46.8097}, CountryId{"FR"}}, // Gare de Châteauroux
    {Coordinate{12.7131, 52.6758}, CountryId{"DE"}}, // Bahnhof Paulinenaue
    {Coordinate{4.27509, 50.8897}, CountryId{"BE"}}, // Zellik railway station
    {Coordinate{6.92631, 45.9819}, CountryId{"FR"}}, // Q1943343
    {Coordinate{7.26948, 51.2855}, CountryId{"DE"}}, // Schwelm West station
    {Coordinate{5.57389, 52.0458}, CountryId{"NL"}}, // Veenendaal-De Klomp railway station
    {Coordinate{4.3625, 50.5128}, CountryId{"BE"}}, // Pont-à-Celles railway station
    {Coordinate{89.7822, 26.2115}, CountryId{"IN"}}, // Agomani Railway Station
    {Coordinate{76.6417, 8.9298}, CountryId{"IN"}}, // Chandanattop Halt
    {Coordinate{76.7151, 8.97914}, CountryId{"IN"}}, // Ezhukone railway station
    {Coordinate{77.0317, 26.7562}, CountryId{"IN"}}, // Hindaun City railway station
    {Coordinate{10.0356, 53.5975}, CountryId{"DE"}}, // Alte Wöhr station
    {Coordinate{6.60017, 48.0871}, CountryId{"FR"}}, // Gare d'Éloyes
    {Coordinate{10.0544, 53.6325}, CountryId{"DE"}}, // Kornweg station
    {Coordinate{2.3626, 49.167}, CountryId{"FR"}}, // Gare de Boran-sur-Oise
    {Coordinate{6.696, 48.4913}, CountryId{"FR"}}, // Q1947085
    {Coordinate{5.73639, 50.8969}, CountryId{"NL"}}, // Bunde railway station
    {Coordinate{5.42056, 50.9106}, CountryId{"BE"}}, // Diepenbeek railway station
    {Coordinate{3.1485, 50.5605}, CountryId{"FR"}}, // Fretin
    {Coordinate{12.1833, 50.3022}, CountryId{"CZ"}}, // Hranice v Čechách
    {Coordinate{5.39757, 46.1943}, CountryId{"FR"}}, // Gare de Villereversure
    {Coordinate{6.22222, 52.4267}, CountryId{"NL"}}, // Heino railway station
    {Coordinate{8.54392, 47.4117}, CountryId{"CH"}}, // Zürich Oerlikon railway station
    {Coordinate{6.57753, 46.3979}, CountryId{"FR"}}, // Évian-les-Bains
    {Coordinate{4.4288, 50.2693}, CountryId{"BE"}}, // Pry railway station
    {Coordinate{4.86247, 50.4691}, CountryId{"BE"}}, // Namur railway station
    {Coordinate{5.61972, 52.3375}, CountryId{"NL"}}, // Harderwijk railway station
    {Coordinate{4.01119, 51.0031}, CountryId{"BE"}}, // Schoonaarde railway station
    {Coordinate{8.77001, 58.4649}, CountryId{"NO"}}, // Arendal Station
    {Coordinate{6.95806, 50.9425}, CountryId{"DE"}}, // Cologne Central Station
    {Coordinate{11.2471, 60.3295}, CountryId{"NO"}}, // Eidsvoll Station
    {Coordinate{12.5004, 45.6242}, CountryId{"IT"}}, // Q19545547
    {Coordinate{12.7594, 45.7519}, CountryId{"IT"}}, // Q19545550
    {Coordinate{8.94654, 46.0064}, CountryId{"CH"}}, // Q19545551
    {Coordinate{8.95158, 46.0029}, CountryId{"CH"}}, // Q19545553
    {Coordinate{14.6483, 41.2198}, CountryId{"IT"}}, // Q19545569
    {Coordinate{8.5593, 45.179}, CountryId{"IT"}}, // Q19545576
    {Coordinate{18.9889, 47.3987}, CountryId{"HU"}}, // Barosstelep railway station
    {Coordinate{3.12522, 48.9509}, CountryId{"FR"}}, // Q1956946
    {Coordinate{19.0976, 47.5449}, CountryId{"HU"}}, // Vasútmúzeum railway station
    {Coordinate{19.2956, 47.4566}, CountryId{"HU"}}, // Rákoskert railway station
    {Coordinate{19.2448, 47.468}, CountryId{"HU"}}, // Rákoshegy railway station
    {Coordinate{18.9494, 47.5959}, CountryId{"HU"}}, // Solymár railway station
    {Coordinate{19.0142, 47.575}, CountryId{"HU"}}, // Aranyvölgy railway station
    {Coordinate{19.2843, 47.4921}, CountryId{"HU"}}, // Rákoscsaba railway station
    {Coordinate{10.0681, 53.6356}, CountryId{"DE"}}, // Hoheneichen station
    {Coordinate{76.8174, 9.0351}, CountryId{"IN"}}, // Kuri railway station
    {Coordinate{10.0825, 53.6411}, CountryId{"DE"}}, // Wellingsbüttel station
    {Coordinate{80.4009, 23.8167}, CountryId{"IN"}}, // Katni South Junction railway station
    {Coordinate{6.9816, 43.5514}, CountryId{"FR"}}, // Gare du Bosquet
    {Coordinate{18.1664, 40.3039}, CountryId{"IT"}}, // San Cesario di Lecce railway station
    {Coordinate{18.1853, 40.2697}, CountryId{"IT"}}, // San Donato di Lecce railway station
    {Coordinate{17.2125, 40.5656}, CountryId{"IT"}}, // Statte (Italy) railway station
    {Coordinate{18.2253, 40.2181}, CountryId{"IT"}}, // Sternatia railway station
    {Coordinate{9.1425, 48.6964}, CountryId{"DE"}}, // Leinfelden station
    {Coordinate{2.32111, 48.7931}, CountryId{"FR"}}, // Bagneux
    {Coordinate{0.553106, 48.7436}, CountryId{"FR"}}, // Station Rai - Aube
    {Coordinate{5.27278, 45.5839}, CountryId{"FR"}}, // Q1958669
    {Coordinate{-2.96056, 47.6783}, CountryId{"FR"}}, // Gare de Sainte-Anne
    {Coordinate{16.2126, 48.3825}, CountryId{"AT"}}, // Bahnhof Stockerau
    {Coordinate{10.2528, 53.5083}, CountryId{"DE"}}, // Reinbek station
    {Coordinate{10.2781, 53.5207}, CountryId{"DE"}}, // Wohltorf station
    {Coordinate{4.89235, 45.8039}, CountryId{"FR"}}, // Gare de Crépieux-la-Pape
    {Coordinate{-1.5459, 43.4592}, CountryId{"FR"}}, // Gare de Biarritz
    {Coordinate{10.0028, 52.4492}, CountryId{"DE"}}, // Burgdorf station
    {Coordinate{17.224, 49.6165}, CountryId{"CZ"}}, // Q19602504
    {Coordinate{2.15139, 48.8069}, CountryId{"FR"}}, // Gare de Montreuil
    {Coordinate{-3.66797, 40.3816}, CountryId{"ES"}}, // Estación de Asamblea de Madrid-Entrevías
    {Coordinate{6.56694, 53.3906}, CountryId{"NL"}}, // Warffum railway station
    {Coordinate{5.86833, 51.8267}, CountryId{"NL"}}, // Nijmegen Heyendaal railway station
    {Coordinate{8.61959, 47.4205}, CountryId{"CH"}}, // Dietlikon railway station
    {Coordinate{10.2044, 59.74}, CountryId{"NO"}}, // Drammen Station
    {Coordinate{8.44786, 47.3986}, CountryId{"CH"}}, // Schlieren railway station
    {Coordinate{8.42136, 47.3987}, CountryId{"CH"}}, // Glanzenberg railway station
    {Coordinate{5.63444, 53.1778}, CountryId{"NL"}}, // Dronryp railway station
    {Coordinate{8.62294, 47.4}, CountryId{"CH"}}, // Dübendorf railway station
    {Coordinate{2.09837, 48.9969}, CountryId{"FR"}}, // Gare de Conflans-Sainte-Honorine
    {Coordinate{54.3653, 39.4964}, CountryId{"TM"}}, // Q19613410
    {Coordinate{60.6406, 56.7925}, CountryId{"RU"}}, // Q19614010
    {Coordinate{60.1189, 57.2539}, CountryId{"RU"}}, // Q19614195
    {Coordinate{107.546, 51.9044}, CountryId{"RU"}}, // Divizionnaya station
    {Coordinate{27.829, 56.4822}, CountryId{"LV"}}, // Q19616282
    {Coordinate{108.451, 55.7633}, CountryId{"RU"}}, // Q19618666
    {Coordinate{60.6669, 56.8169}, CountryId{"RU"}}, // Q19618876
    {Coordinate{48.3857, 55.8573}, CountryId{"RU"}}, // Q19619183
    {Coordinate{2.29778, 48.8853}, CountryId{"FR"}}, // Pereire – Levallois
    {Coordinate{2.48583, 48.8053}, CountryId{"FR"}}, // Le Parc de Saint-Maur (Paris RER)
    {Coordinate{5.15194, 52.3428}, CountryId{"NL"}}, // Almere Poort railway station
    {Coordinate{7.77925, 48.703}, CountryId{"FR"}}, // Hœrdt
    {Coordinate{11.7959, 45.7323}, CountryId{"IT"}}, // Q19622699
    {Coordinate{11.8776, 45.6881}, CountryId{"IT"}}, // Q19622702
    {Coordinate{13.8189, 42.8857}, CountryId{"IT"}}, // Monsampolo del Tronto railway station
    {Coordinate{13.8499, 42.8942}, CountryId{"IT"}}, // Monteprandone railway station
    {Coordinate{13.7202, 42.8621}, CountryId{"IT"}}, // Q19622710
    {Coordinate{13.7628, 42.8703}, CountryId{"IT"}}, // Q19622714
    {Coordinate{14.2906, 50.0536}, CountryId{"CZ"}}, // Zličín
    {Coordinate{7.25549, 48.9062}, CountryId{"FR"}}, // Station Tieffenbach - Struth
    {Coordinate{2.31194, 48.78}, CountryId{"FR"}}, // Gare de Bourg-la-Reine
    {Coordinate{15.0439, 49.3039}, CountryId{"CZ"}}, // Q19632318
    {Coordinate{12.5187, 50.3119}, CountryId{"CZ"}}, // Q19632319
    {Coordinate{14.1286, 49.8748}, CountryId{"CZ"}}, // Q19632320
    {Coordinate{15.2247, 49.8772}, CountryId{"CZ"}}, // Krasoňovice
    {Coordinate{12.5808, 50.2217}, CountryId{"CZ"}}, // Q19632323
    {Coordinate{15.486, 50.5163}, CountryId{"CZ"}}, // Q19632454
    {Coordinate{15.2206, 50.3175}, CountryId{"CZ"}}, // Q19632457
    {Coordinate{15.192, 50.634}, CountryId{"CZ"}}, // Q19632460
    {Coordinate{4.34417, 51.9031}, CountryId{"NL"}}, // Vlaardingen Centrum metro station
    {Coordinate{6.73611, 51.4572}, CountryId{"DE"}}, // Haltepunkt Duisburg-Ruhrort
    {Coordinate{6.9709, 51.713}, CountryId{"DE"}}, // Bahnhof Deuten
    {Coordinate{-4.38813, 48.4095}, CountryId{"FR"}}, // Q1963578
    {Coordinate{-2.22897, 48.5216}, CountryId{"FR"}}, // Gare de Plancoët
    {Coordinate{-2.84359, 48.4993}, CountryId{"FR"}}, // Q1965252
    {Coordinate{1.90462, 47.9078}, CountryId{"FR"}}, // Gare d'Orléans
    {Coordinate{10.6789, 59.9222}, CountryId{"NO"}}, // Skøyen Station
    {Coordinate{4.92556, 50.8061}, CountryId{"BE"}}, // Tienen railway station
    {Coordinate{10.6358, 59.9136}, CountryId{"NO"}}, // Lysaker Station
    {Coordinate{4.61694, 51.9653}, CountryId{"NL"}}, // Nieuwerkerk aan den IJssel railway station
    {Coordinate{6.11904, 50.8874}, CountryId{"DE"}}, // Herzogenrath August-Schmidt-Platz station
    {Coordinate{39.8353, 57.6256}, CountryId{"RU"}}, // Yaroslavl railway station
    {Coordinate{7.14361, 46.0278}, CountryId{"CH"}}, // Q1968217
    {Coordinate{16.1506, 38.7264}, CountryId{"IT"}}, // Pizzo railway station
    {Coordinate{2.26333, 48.9897}, CountryId{"FR"}}, // Gare d'Ermont-Halte
    {Coordinate{7.05228, 48.7385}, CountryId{"FR"}}, // Q1968912
    {Coordinate{43.9217, 40.1831}, CountryId{"AM"}}, // Q19689155
    {Coordinate{8.72933, 40.4559}, CountryId{"IT"}}, // Giave railway station
    {Coordinate{6.49661, 44.567}, CountryId{"FR"}}, // Q1969231
    {Coordinate{27.0784, 52.2232}, CountryId{"BY"}}, // Lakhva
    {Coordinate{27.6887, 53.7461}, CountryId{"BY"}}, // Mikhanavichy
    {Coordinate{25.3745, 49.0612}, CountryId{"UA"}}, // Buchach
    {Coordinate{3.11561, 50.6228}, CountryId{"FR"}}, // Hellemmes
    {Coordinate{3.23767, 45.7886}, CountryId{"FR"}}, // Gare de Pont-du-Château
    {Coordinate{-4.08217, 48.496}, CountryId{"FR"}}, // Q1970255
    {Coordinate{0.4965, 46.7597}, CountryId{"FR"}}, // Naintré-les-Barres
    {Coordinate{8.53032, 40.6893}, CountryId{"IT"}}, // Tissi-Usini railway station
    {Coordinate{27.485, 48.4056}, CountryId{"MD"}}, // Ocnița railway station
    {Coordinate{1.58971, 46.7353}, CountryId{"FR"}}, // Q1970651
    {Coordinate{6.4497, 48.56}, CountryId{"FR"}}, // Q1971525
    {Coordinate{5.76833, 46.3569}, CountryId{"FR"}}, // Q1971887
    {Coordinate{11.797, 51.1631}, CountryId{"DE"}}, // Naumburg (Saale) Hauptbahnhof
    {Coordinate{8.8712, 53.0185}, CountryId{"DE"}}, // Dreye railway station
    {Coordinate{8.8185, 52.9468}, CountryId{"DE"}}, // Barrien railway station
    {Coordinate{14.4377, 50.0753}, CountryId{"CZ"}}, // Náměstí Míru
    {Coordinate{57.2691, 54.995}, CountryId{"RU"}}, // Q19721733
    {Coordinate{34.5817, 46.0357}, CountryId{"UA"}}, // 1334 km
    {Coordinate{107.553, 51.7761}, CountryId{"RU"}}, // Medvedchikovo station
    {Coordinate{107.389, 51.6139}, CountryId{"RU"}}, // Q19721825
    {Coordinate{15.0865, 50.7074}, CountryId{"CZ"}}, // Jeřmanice
    {Coordinate{14.0817, 49.8364}, CountryId{"CZ"}}, // Osov
    {Coordinate{15.2162, 49.841}, CountryId{"CZ"}}, // Q19722234
    {Coordinate{13.5536, 52.5575}, CountryId{"DE"}}, // Mehrower Allee station
    {Coordinate{2.31194, 51.0022}, CountryId{"FR"}}, // Gare de Grande-Synthe
    {Coordinate{60.0889, 57.9543}, CountryId{"RU"}}, // Q19742076
    {Coordinate{60.021, 57.9544}, CountryId{"RU"}}, // Q19742671
    {Coordinate{29.1094, 60.9619}, CountryId{"RU"}}, // Kamennogorsk railway station
    {Coordinate{15.3594, 50.0375}, CountryId{"CZ"}}, // Týnec nad Labem
    {Coordinate{2.20056, 49.9283}, CountryId{"FR"}}, // Gare d'Ailly-sur-Somme
    {Coordinate{14.215, 50.8464}, CountryId{"CZ"}}, // Dolní Žleb railway station
    {Coordinate{-3.86799, 40.4943}, CountryId{"ES"}}, // Las Rozas
    {Coordinate{4.60972, 51.6414}, CountryId{"NL"}}, // Zevenbergen railway station
    {Coordinate{18.9142, 47.6092}, CountryId{"HU"}}, // Vörösvárbánya railway station
    {Coordinate{18.9281, 47.6011}, CountryId{"HU"}}, // Szélhegy railway station
    {Coordinate{11.5551, 49.499}, CountryId{"DE"}}, // Bahnhof in Pommelsbrunn
    {Coordinate{4.22278, 50.955}, CountryId{"BE"}}, // Merchtem railway station
    {Coordinate{-0.555143, 44.7994}, CountryId{"FR"}}, // Gare de Bègles
    {Coordinate{12.1352, 43.5698}, CountryId{"IT"}}, // Sansepolcro railway station
    {Coordinate{13.6647, 42.8449}, CountryId{"IT"}}, // Maltignano railway station
    {Coordinate{5.08168, 50.4972}, CountryId{"BE"}}, // Château-de-Seilles railway station
    {Coordinate{6.87695, 48.3672}, CountryId{"FR"}}, // Gare d'Étival-Clairefontaine
    {Coordinate{3.18431, 51.3303}, CountryId{"BE"}}, // Zeebrugge-Strand railway station
    {Coordinate{15.7561, 50.9028}, CountryId{"PL"}}, // Jelenia Góra train station
    {Coordinate{82.8653, 18.3329}, CountryId{"IN"}}, // Araku railway station
    {Coordinate{81.5383, 16.5431}, CountryId{"IN"}}, // Bhimavaram Junction railway station
    {Coordinate{81.5195, 16.5472}, CountryId{"IN"}}, // Bhimavaram town railway station
    {Coordinate{4.96472, 50.2106}, CountryId{"BE"}}, // Gendron-Celles railway station
    {Coordinate{7.5897, 48.0271}, CountryId{"DE"}}, // Breisach station
    {Coordinate{0.6088, 46.9376}, CountryId{"FR"}}, // Q1978811
    {Coordinate{60.025, 57.8531}, CountryId{"RU"}}, // Q19788457
    {Coordinate{37.1583, 57.7806}, CountryId{"RU"}}, // Sonkovo railway station
    {Coordinate{3.79528, 50.4358}, CountryId{"BE"}}, // Boussu railway station
    {Coordinate{73.5224, 17.5425}, CountryId{"IN"}}, // Chiplun railway station
    {Coordinate{6.62349, 47.6991}, CountryId{"FR"}}, // Q1981040
    {Coordinate{7.17667, 49.3531}, CountryId{"DE"}}, // Neunkirchen Central Station
    {Coordinate{37.7463, 48.0439}, CountryId{"UA"}}, // Donetsk Railway Station
    {Coordinate{4.72099, 50.5514}, CountryId{"BE"}}, // Lonzée railway station
    {Coordinate{81.2869, 27.1214}, CountryId{"IN"}}, // Sundhiamau railway station
    {Coordinate{13.3881, 49.7436}, CountryId{"CZ"}}, // Plzeň hlavní nádraží
    {Coordinate{7.02889, 49.2164}, CountryId{"DE"}}, // Brebach
    {Coordinate{5.31278, 51.2117}, CountryId{"BE"}}, // Lommel railway station
    {Coordinate{13.3276, 43.5958}, CountryId{"IT"}}, // Chiaravalle railway halt
    {Coordinate{13.2519, 43.5208}, CountryId{"IT"}}, // Q19819430
    {Coordinate{13.1828, 43.501}, CountryId{"IT"}}, // Q19819431
    {Coordinate{13.0847, 43.4816}, CountryId{"IT"}}, // Q19819433
    {Coordinate{13.0273, 43.445}, CountryId{"IT"}}, // Q19819434
    {Coordinate{12.9774, 43.403}, CountryId{"IT"}}, // Genga-San Vittore Terme railway station
    {Coordinate{12.7844, 43.1819}, CountryId{"IT"}}, // Q19819439
    {Coordinate{12.7339, 42.8763}, CountryId{"IT"}}, // Q19819440
    {Coordinate{12.7615, 42.8228}, CountryId{"IT"}}, // Q19819441
    {Coordinate{14.061, 42.3059}, CountryId{"IT"}}, // Manoppello railway station
    {Coordinate{14.0196, 42.2872}, CountryId{"IT"}}, // Alanno railway station
    {Coordinate{13.8762, 42.1023}, CountryId{"IT"}}, // Q19819467
    {Coordinate{8.59696, 40.6989}, CountryId{"IT"}}, // Scala di Giocca railway station
    {Coordinate{14.7243, 41.1721}, CountryId{"IT"}}, // Q19820610
    {Coordinate{6.36528, 51.9217}, CountryId{"NL"}}, // Terborg railway station
    {Coordinate{12.0319, 48.0836}, CountryId{"DE"}}, // Steinhöring station
    {Coordinate{6.94433, 51.2186}, CountryId{"DE"}}, // Hochdahl station
    {Coordinate{8.70806, 50.1128}, CountryId{"DE"}}, // Frankfurt East station
    {Coordinate{14.405, 50.074}, CountryId{"CZ"}}, // Anděl
    {Coordinate{1.91254, 48.1414}, CountryId{"FR"}}, // Gare de Château-Gaillard
    {Coordinate{8.6505, 49.9506}, CountryId{"DE"}}, // Q19835112
    {Coordinate{7.05007, 49.1188}, CountryId{"DE"}}, // Hanweiler-Bad Rilchingen
    {Coordinate{9.7354, 52.4508}, CountryId{"DE"}}, // Langenhagen Pferdemarkt station
    {Coordinate{8.32381, 48.8895}, CountryId{"DE"}}, // Malsch station
    {Coordinate{12.4503, 52.8531}, CountryId{"DE"}}, // Q19835119
    {Coordinate{11.2274, 52.0307}, CountryId{"DE"}}, // Oschersleben
    {Coordinate{7.16303, 51.1692}, CountryId{"DE"}}, // Remscheid-Güldenwerth station
    {Coordinate{8.11496, 49.8461}, CountryId{"DE"}}, // Q19835127
    {Coordinate{13.3175, 52.9797}, CountryId{"DE"}}, // Zehdenick train station
    {Coordinate{3.28832, 45.7845}, CountryId{"FR"}}, // Gare de Vertaizon
    {Coordinate{15.8581, 50.3003}, CountryId{"CZ"}}, // Smiřice
    {Coordinate{6.80819, 51.392}, CountryId{"DE"}}, // Duisburg-Bissingheim station
    {Coordinate{6.7206, 45.9266}, CountryId{"FR"}}, // Gare de Chedde
    {Coordinate{3.00924, 50.7403}, CountryId{"FR"}}, // Sainte-Marguerite
    {Coordinate{10.5628, 50.8628}, CountryId{"DE"}}, // Reinhardsbrunn-Friedrichroda railway station
    {Coordinate{9.59053, 54.3926}, CountryId{"DE"}}, // Q19850738
    {Coordinate{9.85188, 54.1671}, CountryId{"DE"}}, // Nortorf station
    {Coordinate{34.6333, 47.5019}, CountryId{"UA"}}, // Enerhodar
    {Coordinate{3.64179, 49.0791}, CountryId{"FR"}}, // Q1985272
    {Coordinate{8.81849, 40.6321}, CountryId{"IT"}}, // Ardara railway station
    {Coordinate{8.68706, 40.0206}, CountryId{"IT"}}, // Bauladu-Milis railway station
    {Coordinate{8.76067, 40.4178}, CountryId{"IT"}}, // Bonorva railway station
    {Coordinate{16.9552, 46.2494}, CountryId{"HU"}}, // Gyékényes railway station
    {Coordinate{5.0559, 50.3582}, CountryId{"BE"}}, // Florée railway station
    {Coordinate{9.65182, 52.3232}, CountryId{"DE"}}, // Ronnenberg station
    {Coordinate{9.63528, 52.2981}, CountryId{"DE"}}, // Weetzen station
    {Coordinate{-1.9513, 47.3587}, CountryId{"FR"}}, // Savenay
    {Coordinate{2.29417, 48.7022}, CountryId{"FR"}}, // Longjumeau
    {Coordinate{3.00763, 48.9982}, CountryId{"FR"}}, // Gare d'Isles - Armentières - Congis
    {Coordinate{75.0578, 21.0495}, CountryId{"IN"}}, // Amalner Railway Station
    {Coordinate{92.5563, 24.8652}, CountryId{"IN"}}, // Badarpur railway station
    {Coordinate{77.5946, 14.1002}, CountryId{"IN"}}, // Penukonda Junction railway station
    {Coordinate{77.7576, 14.1605}, CountryId{"IN"}}, // Sathya Sai Prasanthi Nilayam railway station
    {Coordinate{88.3398, 22.6357}, CountryId{"IN"}}, // Belur railway station
    {Coordinate{76.017, 20.9036}, CountryId{"IN"}}, // Bodwad railway station
    {Coordinate{34.3441, 61.7842}, CountryId{"RU"}}, // Railway station Petrozavodsk
    {Coordinate{9.4037, 40.8377}, CountryId{"IT"}}, // Su Canale railway station
    {Coordinate{9.36734, 40.8309}, CountryId{"IT"}}, // Chirialza railway station
    {Coordinate{16.7361, 48.9374}, CountryId{"CZ"}}, // Hustopeče (train station)
    {Coordinate{74.999, 20.4641}, CountryId{"IN"}}, // Chalisgaon Junction Railway Station
    {Coordinate{74.6237, 24.8743}, CountryId{"IN"}}, // Chittaurgarh Junction
    {Coordinate{84.0748, 24.0331}, CountryId{"IN"}}, // Daltonganj Railway Station
    {Coordinate{75.2861, 21.0064}, CountryId{"IN"}}, // Dharangaon Railway Station
    {Coordinate{74.7688, 20.8878}, CountryId{"IN"}}, // Dhule Railway Station
    {Coordinate{79.4841, 15.8346}, CountryId{"IN"}}, // Donakonda railway station
    {Coordinate{76.7277, 26.469}, CountryId{"IN"}}, // Gangapur City Railway Station
    {Coordinate{77.7152, 14.4261}, CountryId{"IN"}}, // Dharmavaram Junction railway station
    {Coordinate{77.868, 15.3952}, CountryId{"IN"}}, // Dhone Junction railway station
    {Coordinate{77.6258, 15.1492}, CountryId{"IN"}}, // Gooty Junction railway station
    {Coordinate{78.8292, 14.4517}, CountryId{"IN"}}, // Kadapa railway station
    {Coordinate{79.1141, 13.4511}, CountryId{"IN"}}, // Pakala Junction railway station
    {Coordinate{85.5407, 25.3718}, CountryId{"IN"}}, // Harnaut Railway Station
    {Coordinate{85.3402, 23.9837}, CountryId{"IN"}}, // Hazaribagh Town railway station
    {Coordinate{74.5096, 15.8492}, CountryId{"IN"}}, // Belagavi railway station
    {Coordinate{74.497, 15.4503}, CountryId{"IN"}}, // Londa Junction railway station
    {Coordinate{77.0691, 11.0172}, CountryId{"IN"}}, // Irugur Junction railway station
    {Coordinate{75.7748, 20.8064}, CountryId{"IN"}}, // Jamner Railway Station
    {Coordinate{93.1244, 24.7988}, CountryId{"IN"}}, // Jiribam railway station
    {Coordinate{82.9185, 25.6478}, CountryId{"IN"}}, // Kirakat railway station
    {Coordinate{83.5643, 25.9395}, CountryId{"IN"}}, // Mau Junction
    {Coordinate{74.6191, 34.1106}, CountryId{"IN"}}, // Mazhom railway station
    {Coordinate{76.74, 30.6661}, CountryId{"IN"}}, // SAS Nagar Mohali railway station
    {Coordinate{87.8387, 24.2957}, CountryId{"IN"}}, // Nalhati Junction railway station
    {Coordinate{74.2465, 21.3748}, CountryId{"IN"}}, // Nandurbar Railway Station
    {Coordinate{75.3483, 20.6684}, CountryId{"IN"}}, // Pachora Junction Railway Station
    {Coordinate{3.0754, 50.612}, CountryId{"FR"}}, // Gare de Lille-Porte-de-Douai
    {Coordinate{79.4351, 18.7633}, CountryId{"IN"}}, // Ramagundam railway station
    {Coordinate{76.0446, 21.2222}, CountryId{"IN"}}, // Raver Railway Station
    {Coordinate{5.16823, 46.1306}, CountryId{"FR"}}, // Q1989588
    {Coordinate{26.0597, 56.5403}, CountryId{"LV"}}, // Q19896844
    {Coordinate{23.6778, 56.4089}, CountryId{"LV"}}, // Q19896848
    {Coordinate{26.252, 56.5421}, CountryId{"LV"}}, // Mežāre railway station
    {Coordinate{26.6368, 56.5659}, CountryId{"LV"}}, // Q19896854
    {Coordinate{35.015, 48.4772}, CountryId{"UA"}}, // Dnipro Railway station
    {Coordinate{13.4006, 50.4572}, CountryId{"CZ"}}, // Q1989836
    {Coordinate{83.2205, 17.7447}, CountryId{"IN"}}, // Simhachalam railway station
    {Coordinate{16.3855, 48.2419}, CountryId{"AT"}}, // Handelskai (Vienna U-Bahn)
    {Coordinate{5.57556, 52.2653}, CountryId{"NL"}}, // Putten railway station
    {Coordinate{2.06972, 48.7025}, CountryId{"FR"}}, // Gare de Saint-Rémy-lès-Chevreuse
    {Coordinate{2.78139, 50.2869}, CountryId{"FR"}}, // Arras railway station
    {Coordinate{36.9003, 55.389}, CountryId{"RU"}}, // 240 km BMO railway platform
    {Coordinate{36.9099, 55.3791}, CountryId{"RU"}}, // Q19906689
    {Coordinate{37.62, 63.7}, CountryId{"RU"}}, // Q19906742
    {Coordinate{60.6325, 56.8425}, CountryId{"RU"}}, // Q19907082
    {Coordinate{61.1739, 55.0328}, CountryId{"RU"}}, // Q19907909
    {Coordinate{60.625, 56.7778}, CountryId{"RU"}}, // Q19908034
    {Coordinate{48.361, 55.8628}, CountryId{"RU"}}, // Q19908213
    {Coordinate{106.187, 50.6875}, CountryId{"RU"}}, // Dzhida railway station
    {Coordinate{39.0311, 55.3746}, CountryId{"RU"}}, // Q19909285
    {Coordinate{28.7745, 60.3693}, CountryId{"RU"}}, // Q19909318
    {Coordinate{49.6014, 54.2261}, CountryId{"RU"}}, // Q19909393
    {Coordinate{56.0783, 54.9258}, CountryId{"RU"}}, // Q19909402
    {Coordinate{34.6752, 59.4953}, CountryId{"RU"}}, // Q19909419
    {Coordinate{36.6747, 45.3407}, CountryId{"RU"}}, // Port Kavkaz railway station
    {Coordinate{28.9828, 60.3376}, CountryId{"RU"}}, // Q19909786
    {Coordinate{98.9388, 54.9648}, CountryId{"RU"}}, // Q19909810
    {Coordinate{29.2632, 60.1971}, CountryId{"RU"}}, // Q19910061
    {Coordinate{105.588, 51.6529}, CountryId{"RU"}}, // Q19910124
    {Coordinate{107.497, 52.011}, CountryId{"RU"}}, // Mostovoy
    {Coordinate{106.102, 50.3883}, CountryId{"RU"}}, // Naushki railway station
    {Coordinate{60.1828, 57.4914}, CountryId{"RU"}}, // Q19910321
    {Coordinate{30.3769, 59.1869}, CountryId{"RU"}}, // Q19910405
    {Coordinate{47.654, 56.6791}, CountryId{"RU"}}, // Q19910451
    {Coordinate{47.6467, 56.7758}, CountryId{"RU"}}, // Q19910454
    {Coordinate{131.9, 43.5142}, CountryId{"RU"}}, // Q19910463
    {Coordinate{131.951, 43.4508}, CountryId{"RU"}}, // 9230 km
    {Coordinate{131.951, 43.4414}, CountryId{"RU"}}, // 9232 km
    {Coordinate{45.0122, 53.2042}, CountryId{"RU"}}, // Q19910626
    {Coordinate{29.3628, 58.4233}, CountryId{"RU"}}, // Q19910677
    {Coordinate{39.1754, 54.9563}, CountryId{"RU"}}, // Q19910696
    {Coordinate{29.4306, 60.1725}, CountryId{"RU"}}, // Q19910802
    {Coordinate{28.63, 60.3653}, CountryId{"RU"}}, // Q19910809
    {Coordinate{59.9258, 56.8119}, CountryId{"RU"}}, // Q19910901
    {Coordinate{31.2747, 59.7833}, CountryId{"RU"}}, // Q19910989
    {Coordinate{39.557, 55.1462}, CountryId{"RU"}}, // Ryazanovka
    {Coordinate{106.872, 52.0332}, CountryId{"RU"}}, // Q19911141
    {Coordinate{106.244, 50.8744}, CountryId{"RU"}}, // Selenduma station
    {Coordinate{35.7728, 45.2992}, CountryId{"UA"}}, // Q19911172
    {Coordinate{59.98, 57.94}, CountryId{"RU"}}, // Q19911257
    {Coordinate{60.0249, 57.853}, CountryId{"RU"}}, // Q19911370
    {Coordinate{47.7108, 56.9634}, CountryId{"RU"}}, // Tabashino
    {Coordinate{47.6512, 56.8763}, CountryId{"RU"}}, // Q19915880
    {Coordinate{46.4115, 55.491}, CountryId{"RU"}}, // Q19915886
    {Coordinate{106.158, 50.4806}, CountryId{"RU"}}, // Q19916062
    {Coordinate{99.3417, 54.7911}, CountryId{"RU"}}, // Q19916091
    {Coordinate{106.195, 50.5739}, CountryId{"RU"}}, // Khuzhir railway station
    {Coordinate{14.2875, 49.9272}, CountryId{"CZ"}}, // Q1991621
    {Coordinate{105.216, 56.8566}, CountryId{"RU"}}, // Q19916711
    {Coordinate{73.3233, 61.2898}, CountryId{"RU"}}, // Q19916768
    {Coordinate{107.139, 52.1142}, CountryId{"RU"}}, // Q19916827
    {Coordinate{29.1364, 60.2597}, CountryId{"RU"}}, // Q19916840
    {Coordinate{107.435, 52.1393}, CountryId{"RU"}}, // Q19916854
    {Coordinate{106.849, 51.5004}, CountryId{"RU"}}, // Q19917111
    {Coordinate{57.9138, 53.9343}, CountryId{"RU"}}, // Q19917149
    {Coordinate{55.9631, 54.5578}, CountryId{"RU"}}, // Q19917179
    {Coordinate{4.61276, 50.6383}, CountryId{"BE"}}, // Mont-Saint-Guibert railway station
    {Coordinate{4.82556, 45.7483}, CountryId{"FR"}}, // Gare de Lyon-Perrache
    {Coordinate{5.59776, 46.7628}, CountryId{"FR"}}, // Q1992498
    {Coordinate{6.67698, 51.3978}, CountryId{"DE"}}, // Bahnhof Rumeln
    {Coordinate{9.16944, 48.6919}, CountryId{"DE"}}, // Echterdingen station
    {Coordinate{18.9944, 51.5894}, CountryId{"PL"}}, // Zduńska Wola Karsznice
    {Coordinate{0.9325, 44.1019}, CountryId{"FR"}}, // Gare de Pommevic
    {Coordinate{5.29247, 50.0196}, CountryId{"BE"}}, // Poix-Saint-Hubert railway station
    {Coordinate{4.77365, 51.0373}, CountryId{"BE"}}, // Booischot railway station
    {Coordinate{15.2323, 46.1545}, CountryId{"SI"}}, // Laško train station
    {Coordinate{9.17937, 40.9239}, CountryId{"IT"}}, // Luras train station
    {Coordinate{1.73068, 41.2206}, CountryId{"ES"}}, // Vilanova i la Geltrú railway station
    {Coordinate{0.421255, 46.7039}, CountryId{"FR"}}, // Q1995058
    {Coordinate{18.1495, 46.37}, CountryId{"HU"}}, // Dombóvár railway station
    {Coordinate{4.06417, 51.0151}, CountryId{"BE"}}, // Oudegem railway station
    {Coordinate{18.8941, 47.6259}, CountryId{"HU"}}, // Szabadságliget railway station
    {Coordinate{18.8525, 47.6302}, CountryId{"HU"}}, // Pázmáneum railway station
    {Coordinate{18.8463, 47.6377}, CountryId{"HU"}}, // Klotildliget railway station
    {Coordinate{18.8299, 47.6382}, CountryId{"HU"}}, // Piliscsaba railway station
    {Coordinate{18.8184, 47.6478}, CountryId{"HU"}}, // Magdolnavölgy railway station
    {Coordinate{18.9022, 47.6142}, CountryId{"HU"}}, // Pilisvörösvár railway station
    {Coordinate{18.7964, 47.6562}, CountryId{"HU"}}, // Pilisjászfalu railway station
    {Coordinate{18.7913, 47.6739}, CountryId{"HU"}}, // Piliscsév railway station
    {Coordinate{18.7719, 47.688}, CountryId{"HU"}}, // Leányvár railway station
    {Coordinate{18.7329, 47.7233}, CountryId{"HU"}}, // Dorog railway station
    {Coordinate{18.7177, 47.7429}, CountryId{"HU"}}, // Esztergom-Kertváros railway station
    {Coordinate{18.7445, 47.7756}, CountryId{"HU"}}, // Esztergom railway station
    {Coordinate{14.0828, 52.7628}, CountryId{"DE"}}, // Bahnhof Altranft
    {Coordinate{14.14, 52.7158}, CountryId{"DE"}}, // Wriezen station
    {Coordinate{6.70121, 45.9066}, CountryId{"FR"}}, // Gare de Saint-Gervais-les-Bains-Le Fayet
    {Coordinate{6.94814, 51.7512}, CountryId{"DE"}}, // Q19965709
    {Coordinate{6.9062, 51.8092}, CountryId{"DE"}}, // Q19971789
    {Coordinate{-0.882882, 48.8463}, CountryId{"FR"}}, // Gare de Vire
    {Coordinate{-1.59639, 48.0469}, CountryId{"FR"}}, // Q1998060
    {Coordinate{73.3569, 17.0028}, CountryId{"IN"}}, // Ratnagiri railway station
    {Coordinate{6.80743, 48.206}, CountryId{"FR"}}, // Q1998882
    {Coordinate{12.4042, 50.2517}, CountryId{"CZ"}}, // Q1998899
    {Coordinate{5.37548, 45.5611}, CountryId{"FR"}}, // Q1998901
    {Coordinate{1.87558, 48.8594}, CountryId{"FR"}}, // Q1999027
    {Coordinate{7.49314, 43.7748}, CountryId{"FR"}}, // Gare de Menton
    {Coordinate{2.43528, 48.7717}, CountryId{"FR"}}, // Créteil-Pompadour (Paris RER)
    {Coordinate{13.5987, 42.8505}, CountryId{"IT"}}, // Q20008429
    {Coordinate{9.58761, 41.0107}, CountryId{"IT"}}, // Cala Sabina railway station
    {Coordinate{9.43107, 40.8571}, CountryId{"IT"}}, // Enas railway station
    {Coordinate{9.04604, 40.672}, CountryId{"IT"}}, // Madonna di Castro railway station
    {Coordinate{10.723, 44.8457}, CountryId{"IT"}}, // Novellara railway station
    {Coordinate{8.98649, 40.6274}, CountryId{"IT"}}, // Ozieri-Fraigas railway station
    {Coordinate{9.53111, 40.9941}, CountryId{"IT"}}, // Rudalza railway station
    {Coordinate{16.2074, 38.1757}, CountryId{"IT"}}, // Ardore railway station
    {Coordinate{8.01835, 45.19}, CountryId{"IT"}}, // Q20009382
    {Coordinate{8.52063, 45.0871}, CountryId{"IT"}}, // Borgo San Martino railway station
    {Coordinate{15.9239, 37.9303}, CountryId{"IT"}}, // Bova Marina railway station
    {Coordinate{8.44053, 45.1604}, CountryId{"IT"}}, // Casale Popolo railway station
    {Coordinate{16.8908, 40.4292}, CountryId{"IT"}}, // Castellaneta Marina railway station
    {Coordinate{15.8749, 37.9277}, CountryId{"IT"}}, // Q20009393
    {Coordinate{8.10717, 45.1942}, CountryId{"IT"}}, // Crescentino railway station
    {Coordinate{16.1345, 38.0163}, CountryId{"IT"}}, // Q20009398
    {Coordinate{8.18873, 45.1912}, CountryId{"IT"}}, // Q20009400
    {Coordinate{14.2881, 42.4215}, CountryId{"IT"}}, // Francavilla al Mare railway station
    {Coordinate{8.56095, 45.0561}, CountryId{"IT"}}, // Giarole railway station
    {Coordinate{16.8908, 40.4292}, CountryId{"IT"}}, // Ginosa railway station
    {Coordinate{12.5545, 45.7844}, CountryId{"IT"}}, // Q20009406
    {Coordinate{12.0134, 44.8041}, CountryId{"IT"}}, // Massafiscaglia railway station
    {Coordinate{11.9385, 44.7693}, CountryId{"IT"}}, // Migliarino railway station
    {Coordinate{11.975, 44.7951}, CountryId{"IT"}}, // Migliaro railway station
    {Coordinate{12.6972, 43.9774}, CountryId{"IT"}}, // Misano Adriatico railway station
    {Coordinate{13.6463, 43.2893}, CountryId{"IT"}}, // Montecosaro railway station
    {Coordinate{8.36619, 45.1707}, CountryId{"IT"}}, // Q20009420
    {Coordinate{13.5828, 43.2792}, CountryId{"IT"}}, // Q20009421
    {Coordinate{8.12018, 44.7228}, CountryId{"IT"}}, // Q20009422
    {Coordinate{8.23281, 45.189}, CountryId{"IT"}}, // Q20009427
    {Coordinate{15.9864, 37.9188}, CountryId{"IT"}}, // Q20009428
    {Coordinate{8.42675, 45.2333}, CountryId{"IT"}}, // Pertengo railway station
    {Coordinate{8.72806, 40.6613}, CountryId{"IT"}}, // Ploaghe railway station
    {Coordinate{12.4605, 45.7193}, CountryId{"IT"}}, // Q20009436
    {Coordinate{15.6517, 38.0672}, CountryId{"IT"}}, // Reggio di Calabria Aeroporto railway station
    {Coordinate{15.6386, 38.0057}, CountryId{"IT"}}, // Q20009443
    {Coordinate{15.651, 38.0587}, CountryId{"IT"}}, // Q20009445
    {Coordinate{16.6156, 40.1001}, CountryId{"IT"}}, // Rocca Imperiale railway station
    {Coordinate{13.5012, 45.8183}, CountryId{"IT"}}, // Ronchi dei Legionari Sud railway station
    {Coordinate{12.3774, 45.6867}, CountryId{"IT"}}, // Q20009451
    {Coordinate{8.95603, 40.8692}, CountryId{"IT"}}, // Q20009457
    {Coordinate{13.8758, 41.1961}, CountryId{"IT"}}, // Q20009461
    {Coordinate{7.96952, 45.1931}, CountryId{"IT"}}, // Verolengo railway station
    {Coordinate{14.7278, 40.6742}, CountryId{"IT"}}, // Vietri sul Mare-Amalfi railway station
    {Coordinate{13.3955, 45.8132}, CountryId{"IT"}}, // Villa Vicentina railway station
    {Coordinate{15.9965, 41.3467}, CountryId{"IT"}}, // Candida railway station
    {Coordinate{16.3308, 38.3001}, CountryId{"IT"}}, // Q20009822
    {Coordinate{14.0687, 42.6077}, CountryId{"IT"}}, // Pineto-Atri train station
    {Coordinate{14.0413, 42.6424}, CountryId{"IT"}}, // Q20009826
    {Coordinate{14.3397, 42.3939}, CountryId{"IT"}}, // Tollo-Canosa Sannita railway station
    {Coordinate{16.144, 38.0527}, CountryId{"IT"}}, // Africo Nuovo railway station
    {Coordinate{16.5676, 38.5722}, CountryId{"IT"}}, // Badolato railway station
    {Coordinate{16.1532, 38.0891}, CountryId{"IT"}}, // Bianco railway station
    {Coordinate{8.80953, 40.2189}, CountryId{"IT"}}, // Borore train station
    {Coordinate{16.1806, 38.1491}, CountryId{"IT"}}, // Q20009909
    {Coordinate{16.1033, 37.9654}, CountryId{"IT"}}, // Brancaleone train station
    {Coordinate{13.0575, 43.2104}, CountryId{"IT"}}, // Q20009918
    {Coordinate{15.1329, 37.9013}, CountryId{"IT"}}, // Q20009948
    {Coordinate{15.66, 37.977}, CountryId{"IT"}}, // Q20009963
    {Coordinate{16.2648, 38.2332}, CountryId{"IT"}}, // Locri railway station
    {Coordinate{16.5977, 40.0408}, CountryId{"IT"}}, // Monte Giordano railway station
    {Coordinate{16.5418, 38.7286}, CountryId{"IT"}}, // Q20009984
    {Coordinate{8.87589, 40.5559}, CountryId{"IT"}}, // Mores-Ittireddu railway station
    {Coordinate{16.6029, 39.9338}, CountryId{"IT"}}, // Amendolara-Oriolo railway station
    {Coordinate{8.74101, 39.6112}, CountryId{"IT"}}, // Pabillonis railway station
    {Coordinate{8.77582, 40.0773}, CountryId{"IT"}}, // Paulilatino railway station
    {Coordinate{15.7108, 37.9387}, CountryId{"IT"}}, // Saline di Reggio train station
    {Coordinate{16.302, 38.2708}, CountryId{"IT"}}, // Q20010034
    {Coordinate{8.6798, 39.9525}, CountryId{"IT"}}, // Solarussa railway station
    {Coordinate{12.6688, 42.9844}, CountryId{"IT"}}, // Q20010042
    {Coordinate{8.78162, 40.4827}, CountryId{"IT"}}, // Torralba railway station
    {Coordinate{16.5321, 39.8656}, CountryId{"IT"}}, // Trebisacce railway station
    {Coordinate{8.69631, 39.6926}, CountryId{"IT"}}, // Uras-Mogoro railway station
    {Coordinate{16.4906, 39.8105}, CountryId{"IT"}}, // Villapiana Lido railway station
    {Coordinate{16.4794, 39.7906}, CountryId{"IT"}}, // Villapiana-Torre Cerchiara railway station
    {Coordinate{8.28278, 47.0706}, CountryId{"CH"}}, // Q20012446
    {Coordinate{6.62655, 46.5072}, CountryId{"CH"}}, // Ouchy station
    {Coordinate{14.5987, 50.0817}, CountryId{"CZ"}}, // Praha-Běchovice
    {Coordinate{7.79211, 47.5512}, CountryId{"CH"}}, // Rheinfelden railway station
    {Coordinate{10.3827, 53.8054}, CountryId{"DE"}}, // Bad Oldesloe railway station
    {Coordinate{3.03161, 49.0217}, CountryId{"FR"}}, // Q2002635
    {Coordinate{2.03517, 50.3783}, CountryId{"FR"}}, // Q2002851
    {Coordinate{5.7875, 51.4561}, CountryId{"NL"}}, // Deurne railway station
    {Coordinate{2.88891, 48.6137}, CountryId{"FR"}}, // Gare de Mormant
    {Coordinate{7.17432, 50.7098}, CountryId{"DE"}}, // Oberkassel Süd/Römlinghoven
    {Coordinate{7.08151, 50.7365}, CountryId{"DE"}}, // Bonn West
    {Coordinate{7.10246, 50.7374}, CountryId{"DE"}}, // Bertha-von-Suttner-Platz
    {Coordinate{6.77167, 45.6181}, CountryId{"FR"}}, // Gare de Bourg-Saint-Maurice
    {Coordinate{2.39, 48.9761}, CountryId{"FR"}}, // Garges – Sarcelles
    {Coordinate{-1.10013, 49.1169}, CountryId{"FR"}}, // Gare de Saint-Lô
    {Coordinate{-0.145023, 44.5803}, CountryId{"FR"}}, // Gare de Caudrot
    {Coordinate{6.36965, 49.473}, CountryId{"DE"}}, // Perl railway station
    {Coordinate{2.60222, 48.9528}, CountryId{"FR"}}, // Gare de Villeparisis – Mitry-le-Neuf
    {Coordinate{-8.64353, 41.0022}, CountryId{"PT"}}, // Espinho-Vouga railway station
    {Coordinate{-8.53161, 40.6095}, CountryId{"PT"}}, // Eirol railway station
    {Coordinate{-8.56816, 40.6311}, CountryId{"PT"}}, // Eixo railway station
    {Coordinate{-8.58451, 40.972}, CountryId{"PT"}}, // Paços de Brandão railway station
    {Coordinate{-8.49513, 40.8986}, CountryId{"PT"}}, // São João da Madeira railway station
    {Coordinate{18.7614, 47.1395}, CountryId{"HU"}}, // Pusztaszabolcs railway station
    {Coordinate{-8.45831, 40.6532}, CountryId{"PT"}}, // Macinhata do Vouga railway station
    {Coordinate{-8.48168, 40.8402}, CountryId{"PT"}}, // Oliveira de Azeméis railway station
    {Coordinate{-8.53556, 40.9242}, CountryId{"PT"}}, // Vila da Feira railway station
    {Coordinate{4.24441, 50.8662}, CountryId{"BE"}}, // Dilbeek railway station
    {Coordinate{1.76804, 47.2948}, CountryId{"FR"}}, // Q2006291
    {Coordinate{2.32623, 49.1552}, CountryId{"FR"}}, // Q2006647
    {Coordinate{4.32389, 52.0811}, CountryId{"NL"}}, // Den Haag Centraal railway station
    {Coordinate{106.38, 51.2436}, CountryId{"RU"}}, // Q20072984
    {Coordinate{36.7708, 46.7942}, CountryId{"UA"}}, // Q20073062
    {Coordinate{36.8039, 46.751}, CountryId{"UA"}}, // Q20073063
    {Coordinate{25.605, 49.4908}, CountryId{"UA"}}, // Q20073102
    {Coordinate{31.3797, 48.19}, CountryId{"UA"}}, // Q20073147
    {Coordinate{36.4011, 46.9486}, CountryId{"UA"}}, // Q20073318
    {Coordinate{108.509, 51.7197}, CountryId{"RU"}}, // Ilka station
    {Coordinate{3.25557, 50.9137}, CountryId{"BE"}}, // Ingelmunster railway station
    {Coordinate{32.1659, 48.0957}, CountryId{"UA"}}, // Q20073774
    {Coordinate{34.2717, 45.774}, CountryId{"RU"}}, // Q20073795
    {Coordinate{35.3297, 47.3583}, CountryId{"UA"}}, // Q20074179
    {Coordinate{36.49, 47.2652}, CountryId{"UA"}}, // Bilmanka
    {Coordinate{34.0597, 46.8564}, CountryId{"UA"}}, // Q20074359
    {Coordinate{35.7189, 47.2336}, CountryId{"UA"}}, // Q20074370
    {Coordinate{36.3, 47.2203}, CountryId{"UA"}}, // Q20074505
    {Coordinate{29.832, 49.2606}, CountryId{"UA"}}, // Vysoke
    {Coordinate{24.5647, 48.2933}, CountryId{"UA"}}, // Vorokhta railway station
    {Coordinate{13.7853, 49.8322}, CountryId{"CZ"}}, // Zbiroh (train station)
    {Coordinate{36.1267, 47.8272}, CountryId{"UA"}}, // Q20075375
    {Coordinate{25.2864, 48.5812}, CountryId{"UA"}}, // Q20075439
    {Coordinate{25.4768, 48.682}, CountryId{"UA"}}, // Q20075841
    {Coordinate{29.8915, 49.2362}, CountryId{"UA"}}, // Horoshkiv
    {Coordinate{37.3539, 49.666}, CountryId{"UA"}}, // Q20075959
    {Coordinate{36.1656, 47.6478}, CountryId{"UA"}}, // Q20076019
    {Coordinate{36.3736, 47.4694}, CountryId{"UA"}}, // Q20076027
    {Coordinate{106.27, 51.1144}, CountryId{"RU"}}, // Q20076031
    {Coordinate{105.93, 49.4844}, CountryId{"MN"}}, // Darkhan I railway station
    {Coordinate{24.6165, 48.5086}, CountryId{"UA"}}, // Deliatyn station
    {Coordinate{106.454, 48.8568}, CountryId{"MN"}}, // Zuunharaa railway station
    {Coordinate{35.0256, 47.81}, CountryId{"UA"}}, // Dniprobud 2
    {Coordinate{32.7939, 46.6792}, CountryId{"UA"}}, // Dniprovska
    {Coordinate{34.9614, 47.1744}, CountryId{"UA"}}, // Q20076374
    {Coordinate{32.9119, 46.5894}, CountryId{"UA"}}, // Express
    {Coordinate{106.488, 51.3242}, CountryId{"RU"}}, // Q20076935
    {Coordinate{25.7385, 48.6454}, CountryId{"UA"}}, // Zalishchyky
    {Coordinate{37.1978, 47.47}, CountryId{"UA"}}, // Q20077093
    {Coordinate{108.277, 51.8406}, CountryId{"RU"}}, // Zaigraevo station
    {Coordinate{2.17056, 49.2042}, CountryId{"FR"}}, // Gare d'Esches
    {Coordinate{32.73, 46.8892}, CountryId{"UA"}}, // Q20077285
    {Coordinate{35.2489, 47.6531}, CountryId{"UA"}}, // Q20077473
    {Coordinate{35.0289, 47.3825}, CountryId{"UA"}}, // Q20077572
    {Coordinate{36.335, 47.33}, CountryId{"UA"}}, // Q20077651
    {Coordinate{35.4672, 47.8072}, CountryId{"UA"}}, // Kyrpotyne
    {Coordinate{25.06, 48.5344}, CountryId{"UA"}}, // Kolomyia
    {Coordinate{29.9407, 49.2249}, CountryId{"UA"}}, // Kryvchunka
    {Coordinate{31.5252, 48.1179}, CountryId{"UA"}}, // Q20078340
    {Coordinate{4.85944, 45.7606}, CountryId{"FR"}}, // Gare de Lyon-Part-Dieu
    {Coordinate{108.883, 51.4569}, CountryId{"RU"}}, // Kizha station
    {Coordinate{35.3555, 47.8092}, CountryId{"UA"}}, // Q20081561
    {Coordinate{36.5119, 47.4311}, CountryId{"UA"}}, // Q20081859
    {Coordinate{35.9144, 47.5275}, CountryId{"UA"}}, // Q20081911
    {Coordinate{37.2217, 48.4228}, CountryId{"UA"}}, // Q20082172
    {Coordinate{35.6133, 47.2017}, CountryId{"UA"}}, // Q20082386
    {Coordinate{29.4287, 49.4075}, CountryId{"UA"}}, // Nakaznyi Post
    {Coordinate{36.163, 47.2137}, CountryId{"UA"}}, // Q20082883
    {Coordinate{34.8803, 47.0247}, CountryId{"UA"}}, // Q20082942
    {Coordinate{36.0433, 47.5092}, CountryId{"UA"}}, // Q20082979
    {Coordinate{31.5161, 48.3327}, CountryId{"UA"}}, // Q20083082
    {Coordinate{108.701, 51.6764}, CountryId{"RU"}}, // Novoilinsky station
    {Coordinate{33.935, 46.8417}, CountryId{"UA"}}, // Q20083101
    {Coordinate{35.6606, 47.6692}, CountryId{"UA"}}, // Q20083186
    {Coordinate{35.325, 46.9333}, CountryId{"UA"}}, // Obilna
    {Coordinate{35.7883, 47.5594}, CountryId{"UA"}}, // Q20083381
    {Coordinate{31.8861, 48.1025}, CountryId{"UA"}}, // Q20083386
    {Coordinate{34.7497, 46.3297}, CountryId{"UA"}}, // Partyzany
    {Coordinate{14.6636, 50.0873}, CountryId{"CZ"}}, // Praha-Klánovice
    {Coordinate{34.1616, 45.8303}, CountryId{"UA"}}, // Q20091077
    {Coordinate{35.2239, 47.8189}, CountryId{"UA"}}, // Peredatna
    {Coordinate{35.3275, 47.5661}, CountryId{"UA"}}, // Q20091313
    {Coordinate{35.3119, 47.1656}, CountryId{"UA"}}, // Q20091341
    {Coordinate{32.8158, 46.6436}, CountryId{"UA"}}, // Q20091442
    {Coordinate{35.325, 47.2589}, CountryId{"UA"}}, // Q20091902
    {Coordinate{24.2089, 48.0547}, CountryId{"UA"}}, // Rakhiv station
    {Coordinate{28.2647, 45.4586}, CountryId{"UA"}}, // Reni railway station
    {Coordinate{37.0647, 47.3744}, CountryId{"UA"}}, // Q20092484
    {Coordinate{35.2831, 47.8089}, CountryId{"UA"}}, // Q20092520
    {Coordinate{33.9819, 49.7296}, CountryId{"UA"}}, // Sahaidak
    {Coordinate{35.5072, 47.0772}, CountryId{"UA"}}, // Q20092823
    {Coordinate{32.5359, 48.1253}, CountryId{"UA"}}, // Q20092842
    {Coordinate{36.3153, 47.275}, CountryId{"UA"}}, // Q20093005
    {Coordinate{34.9478, 46.4994}, CountryId{"UA"}}, // Sokolohirne
    {Coordinate{32.7008, 46.8047}, CountryId{"UA"}}, // Q20093229
    {Coordinate{25.6875, 48.6183}, CountryId{"UA"}}, // Q20093594
    {Coordinate{36.0178, 47.2125}, CountryId{"UA"}}, // Q20093678
    {Coordinate{106.582, 51.3718}, CountryId{"RU"}}, // Q20093718
    {Coordinate{107.783, 51.8478}, CountryId{"RU"}}, // Taltsy station
    {Coordinate{32.6825, 46.7436}, CountryId{"UA"}}, // Q20093910
    {Coordinate{35.01, 47.0328}, CountryId{"UA"}}, // Q20095877
    {Coordinate{35.5345, 47.7241}, CountryId{"UA"}}, // Fisaky
    {Coordinate{37.4103, 47.4864}, CountryId{"UA"}}, // Q20095981
    {Coordinate{25.7889, 49.0272}, CountryId{"UA"}}, // Chortkiv
    {Coordinate{34.1256, 47.62}, CountryId{"UA"}}, // Q20096147
    {Coordinate{36.595, 47.3092}, CountryId{"UA"}}, // Q20096199
    {Coordinate{24.5525, 48.4489}, CountryId{"UA"}}, // Yaremche station
    {Coordinate{36.1314, 47.4936}, CountryId{"UA"}}, // Q20096255
    {Coordinate{32.5198, 48.7486}, CountryId{"UA"}}, // Chornoliska
    {Coordinate{24.3539, 48.2562}, CountryId{"UA"}}, // Yasinia station
    {Coordinate{31.025, 49.6229}, CountryId{"UA"}}, // Yakhny
    {Coordinate{5.65923, 47.1502}, CountryId{"FR"}}, // Q2009927
    {Coordinate{2.73472, 48.1819}, CountryId{"FR"}}, // Gare de Souppes–Château-Landon
    {Coordinate{3.44282, 49.9884}, CountryId{"FR"}}, // Q2010433
    {Coordinate{5.3031, 46.0957}, CountryId{"FR"}}, // Gare de Saint-Martin-du-Mont
    {Coordinate{3.80002, 50.6144}, CountryId{"BE"}}, // Maffle railway station
    {Coordinate{5.32581, 46.1834}, CountryId{"FR"}}, // Gare de Ceyzériat
    {Coordinate{4.80378, 45.7801}, CountryId{"FR"}}, // Gare de Lyon-Vaise
    {Coordinate{2.21139, 48.7058}, CountryId{"FR"}}, // Gare de Lozère
    {Coordinate{5.94377, 46.6546}, CountryId{"FR"}}, // Q2011910
    {Coordinate{}, CountryId{"BE"}}, // Sterpenich railway station
    {Coordinate{6.23351, 47.299}, CountryId{"FR"}}, // Gare de Laissey
    {Coordinate{4.97833, 49.9844}, CountryId{"BE"}}, // Gedinne railway station
    {Coordinate{2.03835, 42.4912}, CountryId{"FR"}}, // Font-Romeu-Odeillo-Via train station
    {Coordinate{14.4306, 50.0631}, CountryId{"CZ"}}, // Vyšehrad
    {Coordinate{3.64583, 50.2503}, CountryId{"FR"}}, // Le Quesnoy
    {Coordinate{1.84578, 48.9922}, CountryId{"FR"}}, // Q2014665
    {Coordinate{2.0775, 48.97}, CountryId{"FR"}}, // Gare d'Achères – Ville
    {Coordinate{-0.713757, 48.1092}, CountryId{"FR"}}, // Q2014983
    {Coordinate{4.82695, 45.766}, CountryId{"FR"}}, // Gare de Lyon-Saint-Paul
    {Coordinate{2.97194, 42.6011}, CountryId{"FR"}}, // Gare d'Elne
    {Coordinate{40.6325, 56.8856}, CountryId{"RU"}}, // Q20160499
    {Coordinate{1.08934, 43.6172}, CountryId{"FR"}}, // Gare de L'Isle-Jourdain
    {Coordinate{6.27401, 51.0331}, CountryId{"DE"}}, // Hückelhoven-Baal station
    {Coordinate{76.9677, 26.6842}, CountryId{"IN"}}, // Shri Mahaveerji railway station
    {Coordinate{15.2777, 41.2419}, CountryId{"IT"}}, // Orsara di Puglia railway station
    {Coordinate{6.25722, 51.8342}, CountryId{"DE"}}, // Emmerich station
    {Coordinate{13.1411, 54.3228}, CountryId{"DE"}}, // Altefähr railway station
    {Coordinate{8.33863, 48.9648}, CountryId{"DE"}}, // Q20170857
    {Coordinate{1.85717, 48.9092}, CountryId{"FR"}}, // Q2018357
    {Coordinate{7.89989, 49.9013}, CountryId{"DE"}}, // Langenlonsheim station
    {Coordinate{13.1124, 52.5349}, CountryId{"DE"}}, // Löwenberg (Mark) railway station
    {Coordinate{13.7385, 52.6375}, CountryId{"DE"}}, // Werneuchen station
    {Coordinate{7.59238, 50.8072}, CountryId{"DE"}}, // Schladern station
    {Coordinate{3.00985, 50.7609}, CountryId{"FR"}}, // Comines
    {Coordinate{2.22297, 43.0564}, CountryId{"FR"}}, // Gare de Limoux
    {Coordinate{1.54619, 47.2818}, CountryId{"FR"}}, // Selles-sur-Cher station
    {Coordinate{7.41289, 51.5192}, CountryId{"DE"}}, // Dortmund-Wischlingen station
    {Coordinate{1.97055, 50.3946}, CountryId{"FR"}}, // Gare d'Aubin-Saint-Vaast
    {Coordinate{7.58411, 48.3736}, CountryId{"FR"}}, // Gare de Benfeld
    {Coordinate{2.15999, 42.5064}, CountryId{"FR"}}, // Gare de Sauto
    {Coordinate{4.72321, 50.0828}, CountryId{"FR"}}, // Q2022973
    {Coordinate{-1.66102, 43.3857}, CountryId{"FR"}}, // Gare de Saint-Jean-de-Luz-Ciboure
    {Coordinate{30.2585, 58.3485}, CountryId{"RU"}}, // Q20233905
    {Coordinate{-0.0982976, 48.9236}, CountryId{"FR"}}, // Coulibœuf
    {Coordinate{36.2043, 49.9896}, CountryId{"UA"}}, // Kharkiv-Pasazhyrskiy
    {Coordinate{5.71778, 50.8708}, CountryId{"NL"}}, // Maastricht Noord railway station
    {Coordinate{6.70125, 47.7032}, CountryId{"FR"}}, // Champagney
    {Coordinate{4.81969, 44.1375}, CountryId{"FR"}}, // Gare d'Orange
    {Coordinate{19.4297, 51.7581}, CountryId{"PL"}}, // Łódź Kaliska railway station
    {Coordinate{5.39746, 50.6642}, CountryId{"BE"}}, // Fexhe-le-Haut-Clocher railway station
    {Coordinate{4.53332, 50.7114}, CountryId{"BE"}}, // Rixensart railway station
    {Coordinate{3.22993, 49.2726}, CountryId{"FR"}}, // Q2027393
    {Coordinate{5.44124, 43.2905}, CountryId{"FR"}}, // Q2027721
    {Coordinate{39.6908, 47.2184}, CountryId{"RU"}}, // Rostov-Glavny
    {Coordinate{7.15722, 52.3097}, CountryId{"DE"}}, // Bad Bentheim station
    {Coordinate{3.46528, 43.3175}, CountryId{"FR"}}, // Gare d'Agde
    {Coordinate{13.7675, 49.8003}, CountryId{"CZ"}}, // Q2028648
    {Coordinate{13.5814, 51.9156}, CountryId{"DE"}}, // Drahnsdorf railway station
    {Coordinate{2.68039, 49.0083}, CountryId{"FR"}}, // Gare de Thieux - Nantouillet
    {Coordinate{4.505, 50.8831}, CountryId{"BE"}}, // Nossegem railway station
    {Coordinate{4.53097, 52.3758}, CountryId{"NL"}}, // Zandvoort aan Zee railway station
    {Coordinate{3.65598, 49.6308}, CountryId{"FR"}}, // Q2029724
    {Coordinate{7.22456, 47.781}, CountryId{"FR"}}, // Gare de Graffenwald
    {Coordinate{10.2902, 59.7634}, CountryId{"NO"}}, // Lier Station
    {Coordinate{6.31944, 51.5131}, CountryId{"DE"}}, // Q2030582
    {Coordinate{0.33329, 46.5203}, CountryId{"FR"}}, // Q2030786
    {Coordinate{26.0425, 53.1292}, CountryId{"BY"}}, // Baranavichy-Palyeskiya
    {Coordinate{2.23056, 49.0214}, CountryId{"FR"}}, // Gare de Vaucelles
    {Coordinate{76.8528, 9.03651}, CountryId{"IN"}}, // Auvaneeswaram railway station
    {Coordinate{77.1528, 8.98111}, CountryId{"IN"}}, // Aryankavu railway station
    {Coordinate{76.3638, 9.38606}, CountryId{"IN"}}, // Ambalappuzha railway station
    {Coordinate{24.2181, 59.3246}, CountryId{"EE"}}, // Q2031564
    {Coordinate{3.29716, 49.8397}, CountryId{"FR"}}, // Gare de Saint-Quentin
    {Coordinate{3.48933, 50.3317}, CountryId{"FR"}}, // Gare de Trith-Saint-Léger
    {Coordinate{8.44604, 47.2759}, CountryId{"CH"}}, // Affoltern am Albis railway station
    {Coordinate{8.79227, 47.317}, CountryId{"CH"}}, // Wetzikon railway station
    {Coordinate{4.54372, 50.4821}, CountryId{"BE"}}, // Fleurus railway station
    {Coordinate{8.68662, 47.3691}, CountryId{"CH"}}, // Nänikon-Greifensee railway station
    {Coordinate{6.20641, 45.5576}, CountryId{"FR"}}, // Chamousset
    {Coordinate{5.78444, 52.3708}, CountryId{"NL"}}, // Nunspeet railway station
    {Coordinate{142.845, 49.7756}, CountryId{"RU"}}, // Q2034917
    {Coordinate{25.9938, 53.1323}, CountryId{"BY"}}, // Baranavichy-Tsentral′nyya
    {Coordinate{2.32278, 49.0453}, CountryId{"FR"}}, // Gare de Bouffémont - Moisselles
    {Coordinate{5.3425, 45.9539}, CountryId{"FR"}}, // Gare d'Ambérieu
    {Coordinate{9.14361, 49.9803}, CountryId{"DE"}}, // Aschaffenburg Central Station
    {Coordinate{12.1847, 50.2183}, CountryId{"CZ"}}, // Q2035909
    {Coordinate{4.47194, 50.9781}, CountryId{"BE"}}, // Weerde railway station
    {Coordinate{7.38738, 51.508}, CountryId{"DE"}}, // Dortmund-Marten Süd station
    {Coordinate{4.60194, 45.8118}, CountryId{"FR"}}, // Gare de Sain-Bel
    {Coordinate{10.4345, 59.8337}, CountryId{"NO"}}, // Asker Station
    {Coordinate{10.2328, 59.7436}, CountryId{"NO"}}, // Brakerøya Station
    {Coordinate{7.3273, 51.3195}, CountryId{"DE"}}, // Gevelsberg-Kipp station
    {Coordinate{1.3892, 48.4382}, CountryId{"FR"}}, // Q2040993
    {Coordinate{5.64415, 46.8233}, CountryId{"FR"}}, // Q2041345
    {Coordinate{2.59889, 49.965}, CountryId{"FR"}}, // Gare de Buire-sur-l'Ancre
    {Coordinate{2.4075, 48.6361}, CountryId{"FR"}}, // gare d'Orangis - Bois de l'Épine
    {Coordinate{5.53944, 43.6439}, CountryId{"FR"}}, // Q2041563
    {Coordinate{15.2594, 49.3796}, CountryId{"CZ"}}, // Q20428339
    {Coordinate{4.11944, 51.9817}, CountryId{"NL"}}, // Hoek van Holland Strand railway station
    {Coordinate{27.8, 47.2035}, CountryId{"MD"}}, // Ungheni railway station
    {Coordinate{6.1025, 52.0447}, CountryId{"NL"}}, // Dieren railway station
    {Coordinate{2.24902, 42.529}, CountryId{"FR"}}, // Gare de Thuès-les-Bains
    {Coordinate{5.80951, 49.6803}, CountryId{"BE"}}, // Arlon railway station
    {Coordinate{3.97305, 49.4081}, CountryId{"FR"}}, // Q2043286
    {Coordinate{6.12167, 45.9022}, CountryId{"FR"}}, // Gare d'Annecy
    {Coordinate{4.43892, 50.4043}, CountryId{"BE"}}, // Charleroi-South railway station
    {Coordinate{12.9122, 38.0244}, CountryId{"IT"}}, // Castellammare del Golfo railway station
    {Coordinate{13.0969, 38.1553}, CountryId{"IT"}}, // Cinisi-Terrasini railway station
    {Coordinate{13.0369, 38.0653}, CountryId{"IT"}}, // Trappeto railway station
    {Coordinate{13.0074, 38.0533}, CountryId{"IT"}}, // Balestrate railway station
    {Coordinate{13.109, 38.0585}, CountryId{"IT"}}, // Q20439873
    {Coordinate{4.08455, 49.9144}, CountryId{"FR"}}, // Q2044263
    {Coordinate{5.44077, 50.284}, CountryId{"BE"}}, // Melreux-Hotton railway station
    {Coordinate{-2.09722, 47.1144}, CountryId{"FR"}}, // Gare de Pornic
    {Coordinate{4.38306, 51.9225}, CountryId{"NL"}}, // Schiedam Nieuwland metro station
    {Coordinate{2.42639, 48.7394}, CountryId{"FR"}}, // Gare de Villeneuve-le-Roi
    {Coordinate{-0.1918, 51.5473}, CountryId{"GB"}}, // West Hampstead railway station
    {Coordinate{5.28111, 52.2081}, CountryId{"NL"}}, // Baarn railway station
    {Coordinate{0.913333, 43.1189}, CountryId{"FR"}}, // Gare de Lestelle
    {Coordinate{4.46718, 48.2402}, CountryId{"FR"}}, // Q2046189
    {Coordinate{6.92047, 46.0191}, CountryId{"FR"}}, // Gare du Buet (Vallorcine)
    {Coordinate{1.38889, 43.5278}, CountryId{"FR"}}, // Gare de Portet-Saint-Simon
    {Coordinate{7.05861, 46.0867}, CountryId{"CH"}}, // Q2047644
    {Coordinate{13.1545, 47.3186}, CountryId{"AT"}}, // Bahnhof Schwarzach-St. Veit
    {Coordinate{3.28733, 48.5456}, CountryId{"FR"}}, // Gare de Champbenoist-Poigny
    {Coordinate{3.91002, 50.5302}, CountryId{"BE"}}, // Jurbise railway station
    {Coordinate{2.51444, 48.9736}, CountryId{"FR"}}, // Parc des Expositions
    {Coordinate{2.46083, 48.5931}, CountryId{"FR"}}, // Villabé
    {Coordinate{5.50095, 45.9228}, CountryId{"FR"}}, // Tenay - Hauteville
    {Coordinate{21.2975, 52.2408}, CountryId{"PL"}}, // Sulejówek Miłosna train station
    {Coordinate{14.4064, 50.0275}, CountryId{"CZ"}}, // Praha-Braník
    {Coordinate{2.14667, 48.7708}, CountryId{"FR"}}, // Petit Jouy - Les Loges
    {Coordinate{2.35242, 49.8637}, CountryId{"FR"}}, // Longueau station
    {Coordinate{2.5107, 50.6814}, CountryId{"FR"}}, // Gare de Steenbecque
    {Coordinate{17.8184, 40.6502}, CountryId{"IT"}}, // San Vito dei Normanni railway station
    {Coordinate{6.19685, 50.8558}, CountryId{"DE"}}, // Alsdorf Poststraße station
    {Coordinate{12.3275, 50.1675}, CountryId{"CZ"}}, // Vojtanov railway station
    {Coordinate{6.58165, 48.0458}, CountryId{"FR"}}, // Gare de Saint-Nabord
    {Coordinate{4.26167, 50.3461}, CountryId{"BE"}}, // Lobbes railway station
    {Coordinate{6.133, 47.2841}, CountryId{"FR"}}, // Q2051959
    {Coordinate{15.8308, 50.0269}, CountryId{"CZ"}}, // Q2051975
    {Coordinate{6.34225, 47.1498}, CountryId{"FR"}}, // Q2052258
    {Coordinate{4.97861, 44.9917}, CountryId{"FR"}}, // Gare de Valence TGV
    {Coordinate{6.21328, 46.8702}, CountryId{"FR"}}, // Q2052516
    {Coordinate{4.76997, 45.4503}, CountryId{"FR"}}, // Gare de Saint-Clair - Les Roches
    {Coordinate{4.575, 50.6908}, CountryId{"BE"}}, // Limal railway station
    {Coordinate{13.0397, 52.7539}, CountryId{"DE"}}, // Kremmen railway station
    {Coordinate{2.9175, 42.8356}, CountryId{"FR"}}, // Salses
    {Coordinate{2.0652, 45.4022}, CountryId{"FR"}}, // Gare d'Égletons
    {Coordinate{6.75145, 48.1856}, CountryId{"FR"}}, // Q2054652
    {Coordinate{6.41685, 46.0779}, CountryId{"FR"}}, // Bonneville
    {Coordinate{}, CountryId{"NO"}}, // Q20553041
    {Coordinate{5.17583, 50.8172}, CountryId{"BE"}}, // Sint-Truiden railway station
    {Coordinate{3.04359, 51.0251}, CountryId{"BE"}}, // Kortemark railway station
    {Coordinate{1.86283, 46.8826}, CountryId{"FR"}}, // Gare de Neuvy-Pailloux
    {Coordinate{-3.71139, 40.4025}, CountryId{"ES"}}, // Pirámides
    {Coordinate{3.76689, 50.428}, CountryId{"BE"}}, // Hainin railway station
    {Coordinate{-0.924011, 53.7729}, CountryId{"GB"}}, // Wressle railway station
    {Coordinate{7.18537, 48.9406}, CountryId{"FR"}}, // Q2057826
    {Coordinate{0.223626, 49.5637}, CountryId{"FR"}}, // Q2058851
    {Coordinate{4.80479, 45.7661}, CountryId{"FR"}}, // Gare de Lyon-Gorge-de-Loup
    {Coordinate{3.98556, 50.9706}, CountryId{"BE"}}, // Lede railway station
    {Coordinate{31.2672, 51.4858}, CountryId{"UA"}}, // Chernihiv
    {Coordinate{30.3767, 54.5208}, CountryId{"BY"}}, // Orsha-Tsentral′naya
    {Coordinate{4.37583, 50.6842}, CountryId{"BE"}}, // Braine-l'Alleud railway station
    {Coordinate{2.3377, 48.9758}, CountryId{"FR"}}, // Gare de Deuil - Montmagny
    {Coordinate{5.91011, 46.7494}, CountryId{"FR"}}, // Q2060905
    {Coordinate{30.185, 55.1961}, CountryId{"BY"}}, // Viciebsk station
    {Coordinate{6.62984, 51.2168}, CountryId{"DE"}}, // Kaarst IKEA station
    {Coordinate{9.36753, 53.6124}, CountryId{"DE"}}, // Hammah
    {Coordinate{9.16611, 53.6839}, CountryId{"DE"}}, // Hemmoor
    {Coordinate{9.31019, 53.6234}, CountryId{"DE"}}, // Himmelpforten
    {Coordinate{6.88819, 50.9482}, CountryId{"DE"}}, // Köln-Müngersdorf Technologiepark station
    {Coordinate{4.43599, 50.2591}, CountryId{"BE"}}, // Walcourt railway station
    {Coordinate{3.01316, 42.9325}, CountryId{"FR"}}, // Q2062228
    {Coordinate{34.0823, 44.9616}, CountryId{"RU"}}, // Simferopol Passenger
    {Coordinate{2.57306, 48.5292}, CountryId{"FR"}}, // Boissise-le-Roi
    {Coordinate{14.343, 50.05}, CountryId{"CZ"}}, // Hůrka
    {Coordinate{20.8817, 51.1158}, CountryId{"PL"}}, // Skarżysko-Kamienna
    {Coordinate{18.237, 40.1989}, CountryId{"IT"}}, // Zollino railway station
    {Coordinate{14.1878, 50.7336}, CountryId{"CZ"}}, // Boletice nad Labem (train station)
    {Coordinate{12.1845, 53.1461}, CountryId{"DE"}}, // Pritzwalk station
    {Coordinate{12.8578, 52.0919}, CountryId{"DE"}}, // Treuenbrietzen station
    {Coordinate{2.94121, 50.3164}, CountryId{"FR"}}, // Q2064695
    {Coordinate{4.63278, 52.4339}, CountryId{"NL"}}, // Santpoort Noord railway station
    {Coordinate{14.6458, 50.9864}, CountryId{"DE"}}, // Eibau station
    {Coordinate{14.7267, 41.2859}, CountryId{"IT"}}, // Q20657363
    {Coordinate{5.83278, 50.8692}, CountryId{"NL"}}, // Valkenburg railway station
    {Coordinate{6.41694, 52.5097}, CountryId{"NL"}}, // Ommen railway station
    {Coordinate{5.56861, 50.6983}, CountryId{"BE"}}, // Liers railway station
    {Coordinate{14.0074, 51.028}, CountryId{"DE"}}, // Dürrröhrsdorf station
    {Coordinate{10.6756, 44.7608}, CountryId{"IT"}}, // Bagnolo in Piano railway station
    {Coordinate{43.3619, 51.8822}, CountryId{"RU"}}, // Letyazhevka railway station
    {Coordinate{-2.29555, 47.6758}, CountryId{"FR"}}, // Malansac
    {Coordinate{6.77341, 51.4024}, CountryId{"DE"}}, // Duisburg Schlenk station
    {Coordinate{11.1489, 60.7914}, CountryId{"NO"}}, // Hjellum stasjon
    {Coordinate{4.8051, 52.4693}, CountryId{"NL"}}, // Zaandijk Zaanse Schans railway station
    {Coordinate{25.8596, 56.5206}, CountryId{"LV"}}, // Krustpils Station
    {Coordinate{-3.27428, 48.4799}, CountryId{"FR"}}, // Q2068634
    {Coordinate{5.70216, 45.0437}, CountryId{"FR"}}, // Q2068835
    {Coordinate{1.95389, 49.5714}, CountryId{"FR"}}, // Gare de Marseille-en-Beauvaisis
    {Coordinate{30.9911, 52.4308}, CountryId{"BY"}}, // Homyel′-Pasazhyrski
    {Coordinate{5.48028, 50.605}, CountryId{"BE"}}, // Flémalle-Grande railway station
    {Coordinate{4.49306, 51.0914}, CountryId{"BE"}}, // Duffel railway station
    {Coordinate{79.9883, 14.916}, CountryId{"IN"}}, // Kavali railway station
    {Coordinate{5.08846, 43.639}, CountryId{"FR"}}, // Salon
    {Coordinate{6.07796, 49.0743}, CountryId{"FR"}}, // Q2071376
    {Coordinate{75.4638, 11.7789}, CountryId{"IN"}}, // Dharmadam railway station
    {Coordinate{75.4438, 11.8062}, CountryId{"IN"}}, // Edakkad railway station
    {Coordinate{76.5452, 9.6762}, CountryId{"IN"}}, // Ettumanoor railway station
    {Coordinate{76.5484, 9.44988}, CountryId{"IN"}}, // Changanasseri railway station
    {Coordinate{75.2309, 12.0687}, CountryId{"IN"}}, // Ezhimala railway station
    {Coordinate{75.8303, 11.175}, CountryId{"IN"}}, // Feroke railway station
    {Coordinate{76.3251, 9.69099}, CountryId{"IN"}}, // Cherthala railway station
    {Coordinate{75.1544, 12.2133}, CountryId{"IN"}}, // Cheruvathur railway station
    {Coordinate{84.7244, 25.7879}, CountryId{"IN"}}, // Chhapra Junction railway station
    {Coordinate{75.354, 11.9089}, CountryId{"IN"}}, // Chirakkal railway station
    {Coordinate{76.7854, 8.65834}, CountryId{"IN"}}, // Chirayinkeezhu railway station
    {Coordinate{76.3747, 9.92651}, CountryId{"IN"}}, // Chottanikkara Road railway station
    {Coordinate{7.16611, 51.9511}, CountryId{"DE"}}, // Coesfeld Schulzentrum station
    {Coordinate{76.4622, 9.2796}, CountryId{"IN"}}, // Haripad railway station
    {Coordinate{77.3105, 19.1605}, CountryId{"IN"}}, // Hazur Sahib Nanded railway station
    {Coordinate{75.5078, 11.738}, CountryId{"IN"}}, // Jaganath Temple Gate railway station
    {Coordinate{76.7667, 8.67908}, CountryId{"IN"}}, // Kadakkavoor railway station
    {Coordinate{76.7553, 10.8009}, CountryId{"IN"}}, // Kanjikode railway station
    {Coordinate{75.4003, 11.8669}, CountryId{"IN"}}, // Kannur South railway station
    {Coordinate{77.0977, 8.96989}, CountryId{"IN"}}, // Kalthuruthi Halt railway station
    {Coordinate{88.3223, 22.519}, CountryId{"IN"}}, // Majerhat railway station
    {Coordinate{76.6977, 10.627}, CountryId{"IN"}}, // Kollengode railway station
    {Coordinate{81.7265, 17.0071}, CountryId{"IN"}}, // Kovvur railway station
    {Coordinate{75.6939, 11.4461}, CountryId{"IN"}}, // Koyilandi railway station
    {Coordinate{74.9435, 12.5903}, CountryId{"IN"}}, // Kumbla railway station
    {Coordinate{76.6902, 8.96926}, CountryId{"IN"}}, // Kundara East railway station
    {Coordinate{77.2188, 8.30235}, CountryId{"IN"}}, // Kuzhithurai railway station
    {Coordinate{76.4345, 10.7532}, CountryId{"IN"}}, // Lakkiti railway station
    {Coordinate{7.08889, 52.0347}, CountryId{"DE"}}, // Legden station
    {Coordinate{75.547, 11.6992}, CountryId{"IN"}}, // Mahe railway station
    {Coordinate{74.8876, 12.7242}, CountryId{"IN"}}, // Manjeshwaram railway station
    {Coordinate{76.318, 9.59799}, CountryId{"IN"}}, // Mararikulam railway station
    {Coordinate{76.5457, 9.23949}, CountryId{"IN"}}, // Mavelikara railway station
    {Coordinate{75.5756, 11.6395}, CountryId{"IN"}}, // Nadapuram Road railway station
    {Coordinate{77.4194, 8.19957}, CountryId{"IN"}}, // Nagercoil Town railway station
    {Coordinate{74.6604, 20.3093}, CountryId{"IN"}}, // Nandgaon Railway Station
    {Coordinate{76.378, 10.77}, CountryId{"IN"}}, // Ottapalam railway station
    {Coordinate{76.6522, 10.7754}, CountryId{"IN"}}, // Palakkad Town railway station
    {Coordinate{77.1655, 8.33984}, CountryId{"IN"}}, // Parassala railway station
    {Coordinate{75.6176, 11.5167}, CountryId{"IN"}}, // Payyoli railway station
    {Coordinate{75.2596, 12.0215}, CountryId{"IN"}}, // Payangadi railway station
    {Coordinate{77.14, 26.82}, CountryId{"IN"}}, // Phatehsinghpura railway station, Suroth
    {Coordinate{76.4547, 9.82867}, CountryId{"IN"}}, // Piravam Road railway station
    {Coordinate{7.1225, 51.9981}, CountryId{"DE"}}, // Rosendahl-Holtwick station
    {Coordinate{77.4668, 8.14948}, CountryId{"IN"}}, // Suchindram railway station
    {Coordinate{91.9052, 26.6571}, CountryId{"IN"}}, // Tangla railway station
    {Coordinate{75.8806, 10.9795}, CountryId{"IN"}}, // Tanur railway station
    {Coordinate{76.409, 9.3701}, CountryId{"IN"}}, // Thakazhy railway station
    {Coordinate{75.1761, 12.1422}, CountryId{"IN"}}, // Thrikaripur railway station
    {Coordinate{76.31, 9.77281}, CountryId{"IN"}}, // Thuravoor railway station
    {Coordinate{74.9065, 12.6698}, CountryId{"IN"}}, // Uppala railway station
    {Coordinate{76.4746, 9.77765}, CountryId{"IN"}}, // Vaikom Road railway station
    {Coordinate{75.3464, 11.9277}, CountryId{"IN"}}, // Valapattanam railway station
    {Coordinate{77.9094, 17.3371}, CountryId{"IN"}}, // Vikarabad Railway station
    {Coordinate{75.7652, 11.286}, CountryId{"IN"}}, // West Hill railway station
    {Coordinate{-0.626062, 44.8272}, CountryId{"FR"}}, // Mérignac-Arlac
    {Coordinate{2.43778, 48.7464}, CountryId{"FR"}}, // Villeneuve-Triage
    {Coordinate{5.1, 45.6382}, CountryId{"FR"}}, // Q2072293
    {Coordinate{6.44639, 51.1378}, CountryId{"DE"}}, // Rheydt-Odenkirchen station
    {Coordinate{3.29027, 48.1375}, CountryId{"FR"}}, // Étigny-Véron station
    {Coordinate{12.3743, 52.3852}, CountryId{"DE"}}, // Bahnhof Wusterwitz
    {Coordinate{14.0301, 52.7873}, CountryId{"DE"}}, // Bahnhof Bad Freienwalde (Oder)
    {Coordinate{4.49528, 51.1631}, CountryId{"BE"}}, // Boechout railway station
    {Coordinate{1.99, 49.7781}, CountryId{"FR"}}, // Gare de Poix-de-Picardie
    {Coordinate{-0.501714, 46.0434}, CountryId{"FR"}}, // Q2073351
    {Coordinate{4.86906, 50.3488}, CountryId{"BE"}}, // Godinne railway station
    {Coordinate{13.1692, 49.7767}, CountryId{"CZ"}}, // Q2074008
    {Coordinate{7.16553, 48.4076}, CountryId{"FR"}}, // Q2074825
    {Coordinate{9.27383, 51.492}, CountryId{"DE"}}, // Q20754313
    {Coordinate{7.16998, 49.6056}, CountryId{"DE"}}, // Neubrücke (Nahe) station
    {Coordinate{4.53306, 51.5875}, CountryId{"NL"}}, // Oudenbosch railway station
    {Coordinate{4.04234, 51.0731}, CountryId{"BE"}}, // Zele railway station
    {Coordinate{1.35294, 43.6026}, CountryId{"FR"}}, // Gare des Ramassiers
    {Coordinate{4.82435, 45.7068}, CountryId{"FR"}}, // Gare de Pierre-Bénite
    {Coordinate{26.8393, 54.3162}, CountryId{"BY"}}, // Maladzyechna
    {Coordinate{4.94796, 48.6426}, CountryId{"FR"}}, // Q2077891
    {Coordinate{5.18722, 52.2164}, CountryId{"NL"}}, // Hilversum Sportpark railway station
    {Coordinate{6.37254, 47.8148}, CountryId{"FR"}}, // Q2078765
    {Coordinate{27.4037, 59.3557}, CountryId{"EE"}}, // Q207883
    {Coordinate{5.17389, 52.2378}, CountryId{"NL"}}, // Hilversum Media Park railway station
    {Coordinate{4.69056, 50.5702}, CountryId{"BE"}}, // Gembloux railway station
    {Coordinate{3.11812, 50.5906}, CountryId{"FR"}}, // Lesquin
    {Coordinate{4.54374, 50.4241}, CountryId{"BE"}}, // Campinaire railway station
    {Coordinate{5.28139, 51.0383}, CountryId{"BE"}}, // Heusden railway station
    {Coordinate{5.44995, 45.5601}, CountryId{"FR"}}, // Q2082423
    {Coordinate{13.1086, 51.2975}, CountryId{"DE"}}, // Oschatz station
    {Coordinate{6.04333, 50.7089}, CountryId{"BE"}}, // Hergenrath railway station
    {Coordinate{7.98806, 46.3194}, CountryId{"CH"}}, // Brig railway station
    {Coordinate{0.74977, 44.2875}, CountryId{"FR"}}, // Gare de Laroque-Timbaut
    {Coordinate{14.4344, 50.0561}, CountryId{"CZ"}}, // Pražského povstání
    {Coordinate{13.2583, 50.4119}, CountryId{"CZ"}}, // Kadaň-Prunéřov (train station)
    {Coordinate{14.7088, 50.9661}, CountryId{"DE"}}, // Oberoderwitz station
    {Coordinate{77.5193, 21.2776}, CountryId{"IN"}}, // Achalpur railway station
    {Coordinate{5.43855, 45.9474}, CountryId{"FR"}}, // Saint-Rambert-en-Bugey
    {Coordinate{3.96016, 49.0465}, CountryId{"FR"}}, // Gare d'Épernay
    {Coordinate{4.12653, 50.4743}, CountryId{"BE"}}, // Bracquegnies railway station
    {Coordinate{4.76334, 49.8584}, CountryId{"FR"}}, // Gare de Bogny-sur-Meuse
    {Coordinate{1.61139, 43.1892}, CountryId{"FR"}}, // Gare du Vernet-d'Ariège
    {Coordinate{11.1893, 47.3289}, CountryId{"AT"}}, // Bahnhof Seefeld in Tirol
    {Coordinate{6.859, 45.9165}, CountryId{"FR"}}, // Gare des Moussoux
    {Coordinate{0.971667, 44.0881}, CountryId{"FR"}}, // Gare de Malause
    {Coordinate{1.48113, 48.4483}, CountryId{"FR"}}, // Gare de Chartres
    {Coordinate{14.4305, 50.0889}, CountryId{"CZ"}}, // Náměstí Republiky
    {Coordinate{4.58556, 50.8964}, CountryId{"BE"}}, // Erps-Kwerps railway station
    {Coordinate{4.17652, 50.6513}, CountryId{"BE"}}, // Hennuyères railway station
    {Coordinate{2.31417, 48.92}, CountryId{"FR"}}, // Les Grésillons
    {Coordinate{4.26614, 50.7517}, CountryId{"BE"}}, // Huizingen railway station
    {Coordinate{3.32919, 51.1282}, CountryId{"BE"}}, // Beernem railway station
    {Coordinate{5.8208, 47.0588}, CountryId{"FR"}}, // Q2090314
    {Coordinate{5.92944, 50.8867}, CountryId{"NL"}}, // Voerendaal railway station
    {Coordinate{}, CountryId{"FI"}}, // Q20916960
    {Coordinate{4.97701, 45.8274}, CountryId{"FR"}}, // Gare de Saint-Maurice-de-Beynost
    {Coordinate{7.48899, 48.4621}, CountryId{"FR"}}, // Q2092112
    {Coordinate{2.38639, 48.6761}, CountryId{"FR"}}, // gare de Viry-Châtillon
    {Coordinate{5.98194, 49.6386}, CountryId{"LU"}}, // Capellen railway station
    {Coordinate{13.592, 50.983}, CountryId{"DE"}}, // Tharandt station
    {Coordinate{13.2932, 51.0609}, CountryId{"DE"}}, // Nossen station
    {Coordinate{30.6448, 50.4314}, CountryId{"UA"}}, // Darnytsia
    {Coordinate{2.31778, 48.6853}, CountryId{"FR"}}, // Gravigny – Balizy Station
    {Coordinate{2.13686, 42.5009}, CountryId{"FR"}}, // Gare de Planès
    {Coordinate{23.3208, 42.7122}, CountryId{"BG"}}, // Sofia Central Station
    {Coordinate{11.5065, 44.8581}, CountryId{"IT"}}, // Vigarano Pieve railway station
    {Coordinate{1.87688, 47.2691}, CountryId{"FR"}}, // Q2095460
    {Coordinate{4.365, 51.9906}, CountryId{"NL"}}, // Delft Campus railway station
    {Coordinate{3.83435, 50.5998}, CountryId{"BE"}}, // Mévergnies-Attre railway station
    {Coordinate{1.94334, 48.8318}, CountryId{"FR"}}, // Gare de Plaisir - Grignon
    {Coordinate{6.72387, 51.4018}, CountryId{"DE"}}, // Rheinhausen Ost station
    {Coordinate{8.65116, 44.751}, CountryId{"IT"}}, // Predosa railway station
    {Coordinate{8.58958, 44.8434}, CountryId{"IT"}}, // Castellazzo-Casalcermelli railway station
    {Coordinate{8.65612, 44.6752}, CountryId{"IT"}}, // Roccagrimalda railway halt
    {Coordinate{8.64464, 44.6466}, CountryId{"IT"}}, // Ovada Nord railway station
    {Coordinate{7.88645, 45.3534}, CountryId{"IT"}}, // Mercenasco railway station
    {Coordinate{7.88796, 45.3825}, CountryId{"IT"}}, // Strambino railway station
    {Coordinate{7.87635, 45.4615}, CountryId{"IT"}}, // Ivrea railway station
    {Coordinate{7.89189, 45.3299}, CountryId{"IT"}}, // Candia Canavese railway station
    {Coordinate{7.90259, 45.3032}, CountryId{"IT"}}, // Caluso railway station
    {Coordinate{7.85836, 45.2327}, CountryId{"IT"}}, // Montanaro railway station
    {Coordinate{7.91418, 44.1502}, CountryId{"IT"}}, // Ormea railway station
    {Coordinate{7.99445, 44.1854}, CountryId{"IT"}}, // Trappa railway station
    {Coordinate{8.01653, 44.2006}, CountryId{"IT"}}, // Garessio railway station
    {Coordinate{8.0234, 44.2487}, CountryId{"IT"}}, // Priola railway station
    {Coordinate{8.02602, 44.2625}, CountryId{"IT"}}, // Pievetta railway station
    {Coordinate{13.4742, 46.5098}, CountryId{"IT"}}, // Ugovizza railway station
    {Coordinate{15.8004, 38.2827}, CountryId{"IT"}}, // Bagnara railway station
    {Coordinate{5.95131, 46.5748}, CountryId{"FR"}}, // Q2097368
    {Coordinate{6.80833, 43.4164}, CountryId{"FR"}}, // Gare de Boulouris-sur-Mer
    {Coordinate{13.6376, 50.9887}, CountryId{"DE"}}, // Freital-Hainsberg station
    {Coordinate{2.87667, 50.8478}, CountryId{"BE"}}, // Ieper railway station
    {Coordinate{30.3306, 58.7828}, CountryId{"RU"}}, // 133 km railway platform (October railway)
    {Coordinate{5.11859, 49.8953}, CountryId{"BE"}}, // Paliseul railway station
    {Coordinate{12.1292, 50.4864}, CountryId{"DE"}}, // Q2098942
    {Coordinate{14.5789, 51.0044}, CountryId{"DE"}}, // Ebersbach (Sachs) station
    {Coordinate{-1.30054, 43.4993}, CountryId{"FR"}}, // Gare d'Urt
    {Coordinate{2.69512, 48.4871}, CountryId{"FR"}}, // Q2099787
    {Coordinate{2.51694, 50.505}, CountryId{"FR"}}, // Gare de Vis-à-Marles
    {Coordinate{2.56465, 50.5382}, CountryId{"FR"}}, // Gare de Chocques
    {Coordinate{4.39361, 50.8019}, CountryId{"BE"}}, // Boondael railway station
    {Coordinate{75.1357, 12.2559}, CountryId{"IN"}}, // Nileshwar Railway Station
    {Coordinate{-0.241589, 43.1819}, CountryId{"FR"}}, // Gare de Coarraze-Nay
    {Coordinate{8.53222, 51.1986}, CountryId{"DE"}}, // Winterberg (Westf) station
    {Coordinate{1.01091, 48.4738}, CountryId{"FR"}}, // Q2101016
    {Coordinate{8.8987, 53.8078}, CountryId{"DE"}}, // Otterndorf
    {Coordinate{9.05832, 53.768}, CountryId{"DE"}}, // Cadenberge
    {Coordinate{9.22824, 53.6387}, CountryId{"DE"}}, // Hechthausen
    {Coordinate{9.09817, 53.7452}, CountryId{"DE"}}, // Wingst
    {Coordinate{}, CountryId{"FI"}}, // Siuro station area
    {Coordinate{4.94944, 52.3531}, CountryId{"NL"}}, // Amsterdam Science Park railway station
    {Coordinate{7.44961, 51.3533}, CountryId{"DE"}}, // Hagen-Wehringhausen station
    {Coordinate{-1.63432, 48.1814}, CountryId{"FR"}}, // Betton railway station
    {Coordinate{13.5009, 50.9259}, CountryId{"DE"}}, // Klingenberg-Colmnitz station
    {Coordinate{6.4453, 51.6597}, CountryId{"DE"}}, // Q21035431
    {Coordinate{14.2164, 52.5381}, CountryId{"DE"}}, // Trebnitz
    {Coordinate{11.3221, 49.5204}, CountryId{"DE"}}, // Bahnhof Neunkirchen a Sand
    {Coordinate{7.07861, 49.3692}, CountryId{"DE"}}, // Wemmetsweiler station
    {Coordinate{7.84988, 47.7057}, CountryId{"DE"}}, // Zell (Wiesental) station
    {Coordinate{7.97028, 51.4381}, CountryId{"DE"}}, // Q21035442
    {Coordinate{73.4088, 17.7121}, CountryId{"IN"}}, // Khed railway station
    {Coordinate{73.3993, 17.6206}, CountryId{"IN"}}, // Anjani railway station
    {Coordinate{73.2239, 18.3923}, CountryId{"IN"}}, // Kolad railway station
    {Coordinate{73.2447, 18.2977}, CountryId{"IN"}}, // Indapur railway station
    {Coordinate{73.2757, 18.2473}, CountryId{"IN"}}, // Mangaon railway station
    {Coordinate{73.3301, 18.1134}, CountryId{"IN"}}, // Veer railway station
    {Coordinate{73.3716, 18.0582}, CountryId{"IN"}}, // Sape Wamane railway station
    {Coordinate{73.4043, 17.9981}, CountryId{"IN"}}, // Karanjadi railway station
    {Coordinate{73.3837, 17.9149}, CountryId{"IN"}}, // Vinhere railway station
    {Coordinate{73.5155, 17.4773}, CountryId{"IN"}}, // Kamathe railway station
    {Coordinate{73.5382, 17.3165}, CountryId{"IN"}}, // Aravali railway station
    {Coordinate{73.5462, 17.202}, CountryId{"IN"}}, // Sangameshwar railway station
    {Coordinate{73.4559, 17.1298}, CountryId{"IN"}}, // Ukshi railway station
    {Coordinate{73.3811, 17.0491}, CountryId{"IN"}}, // Bhoke railway station
    {Coordinate{73.4546, 16.9466}, CountryId{"IN"}}, // Nivasar railway station
    {Coordinate{73.6193, 16.7856}, CountryId{"IN"}}, // Vilavade railway station
    {Coordinate{73.5929, 16.9216}, CountryId{"IN"}}, // Adavali railway station
    {Coordinate{73.6266, 16.6352}, CountryId{"IN"}}, // Rajapur Road railway station
    {Coordinate{73.7076, 16.512}, CountryId{"IN"}}, // Vaibhavwadi Road railway station
    {Coordinate{73.7306, 16.3875}, CountryId{"IN"}}, // Nandgaon Road railway station
    {Coordinate{7.07466, 51.458}, CountryId{"DE"}}, // Essen-Kray Süd station
    {Coordinate{5.13056, 45.8514}, CountryId{"FR"}}, // Gare de La-Valbonne
    {Coordinate{30.489, 50.4404}, CountryId{"UA"}}, // Kiev Passenger Railway Station
    {Coordinate{6.00222, 52.4536}, CountryId{"NL"}}, // Wezep railway station
    {Coordinate{-4.08604, 48.2543}, CountryId{"FR"}}, // Q2105624
    {Coordinate{9.99105, 44.8929}, CountryId{"IT"}}, // Alseno railway station
    {Coordinate{2.32833, 48.9583}, CountryId{"FR"}}, // Gare d'Épinay-Villetaneuse
    {Coordinate{5.79343, 43.8231}, CountryId{"FR"}}, // Q2106331
    {Coordinate{1.55349, 49.6138}, CountryId{"FR"}}, // Gare de Forges-les-Eaux
    {Coordinate{7.58667, 47.7897}, CountryId{"DE"}}, // Auggen
    {Coordinate{5.63034, 46.239}, CountryId{"FR"}}, // Gare de Bellignat
    {Coordinate{1.85056, 50.9533}, CountryId{"FR"}}, // Calais-Ville railway station
    {Coordinate{6.70361, 51.9744}, CountryId{"NL"}}, // Winterswijk West railway station
    {Coordinate{12.4783, 50.1169}, CountryId{"CZ"}}, // Q2108338
    {Coordinate{2.23694, 48.7075}, CountryId{"FR"}}, // Gare de Palaiseau-Villebon
    {Coordinate{1.89816, 50.9454}, CountryId{"FR"}}, // Beau-Marais
    {Coordinate{-3.24354, 48.5075}, CountryId{"FR"}}, // Q2109565
    {Coordinate{6.38608, 48.5652}, CountryId{"FR"}}, // Q2110347
    {Coordinate{8.54879, 47.3241}, CountryId{"CH"}}, // Kilchberg railway station
    {Coordinate{8.57825, 47.2796}, CountryId{"CH"}}, // Oberrieden railway station
    {Coordinate{8.55577, 47.3063}, CountryId{"CH"}}, // Rüschlikon railway station
    {Coordinate{-1.24455, 49.068}, CountryId{"FR"}}, // Carantilly - Marigny
    {Coordinate{142.758, 48.5725}, CountryId{"RU"}}, // Q211071
    {Coordinate{142.498, 48.0253}, CountryId{"RU"}}, // Q211079
    {Coordinate{7.1625, 46.0828}, CountryId{"CH"}}, // Q2110844
    {Coordinate{4.23505, 50.506}, CountryId{"BE"}}, // Manage railway station
    {Coordinate{6.06846, 43.1451}, CountryId{"FR"}}, // Q2110920
    {Coordinate{1.60929, 50.7274}, CountryId{"FR"}}, // Gare de Boulogne-Tintelleries
    {Coordinate{16.0764, 51.6706}, CountryId{"PL"}}, // Głogów
    {Coordinate{4.44331, 50.8904}, CountryId{"BE"}}, // Diegem railway station
    {Coordinate{13.7103, 45.7133}, CountryId{"IT"}}, // Grignano railway station
    {Coordinate{8.6663, 45.3856}, CountryId{"IT"}}, // Garbagna train station
    {Coordinate{4.81972, 52.4567}, CountryId{"NL"}}, // Zaandam Kogerveld railway station
    {Coordinate{-3.98738, 48.6769}, CountryId{"FR"}}, // Gare de Saint-Pol-de-Léon
    {Coordinate{2.5625, 49.6417}, CountryId{"FR"}}, // Gare de Montdidier
    {Coordinate{11.6597, 58.9417}, CountryId{"NO"}}, // Kornsjø Station
    {Coordinate{10.7722, 52.1406}, CountryId{"DE"}}, // Schöppenstedt station
    {Coordinate{14.5876, 38.0583}, CountryId{"IT"}}, // Acquedolci-San Fratello train station
    {Coordinate{2.21528, 48.7511}, CountryId{"FR"}}, // gare de Bièvres
    {Coordinate{2.436, 49.2511}, CountryId{"FR"}}, // Gare de Montataire
    {Coordinate{10.6942, 60.7972}, CountryId{"NO"}}, // Gjøvik Station
    {Coordinate{7.67865, 48.5595}, CountryId{"FR"}}, // Q2116031
    {Coordinate{5.86824, 49.1665}, CountryId{"FR"}}, // Q2116516
    {Coordinate{24.7931, 59.4234}, CountryId{"EE"}}, // Ülemiste railway station
    {Coordinate{4.76099, 50.1039}, CountryId{"FR"}}, // Q2116916
    {Coordinate{7.71139, 53.6064}, CountryId{"DE"}}, // Burhafe station
    {Coordinate{7.61583, 53.6361}, CountryId{"DE"}}, // Esens (Ostfriesland) station
    {Coordinate{7.89306, 53.5686}, CountryId{"DE"}}, // Jever train station
    {Coordinate{7.78889, 53.5794}, CountryId{"DE"}}, // Wittmund train station
    {Coordinate{7.94639, 53.5419}, CountryId{"DE"}}, // Schortens-Heidmühle train station
    {Coordinate{4.12534, 45.8859}, CountryId{"FR"}}, // Q2116993
    {Coordinate{13.1603, 52.0906}, CountryId{"DE"}}, // Luckenwalde station
    {Coordinate{4.83806, 52.3794}, CountryId{"NL"}}, // Amsterdam De Vlugtlaan
    {Coordinate{0.41765, 49.6036}, CountryId{"FR"}}, // Gare de Bréauté-Beuzeville
    {Coordinate{2.94306, 48.3794}, CountryId{"FR"}}, // Gare de Montereau
    {Coordinate{1.60667, 42.97}, CountryId{"FR"}}, // Gare de Foix
    {Coordinate{16.0685, 39.1343}, CountryId{"IT"}}, // Q21184964
    {Coordinate{8.40079, 45.1741}, CountryId{"IT"}}, // Q21184970
    {Coordinate{16.0645, 39.1643}, CountryId{"IT"}}, // Q21184974
    {Coordinate{8.11554, 45.3094}, CountryId{"IT"}}, // Bianzè railway station
    {Coordinate{15.3692, 41.2782}, CountryId{"IT"}}, // Bovino-Deliceto train station
    {Coordinate{13.3292, 46.0126}, CountryId{"IT"}}, // Q21184981
    {Coordinate{12.6286, 43.0196}, CountryId{"IT"}}, // Q21184987
    {Coordinate{15.6532, 38.2342}, CountryId{"IT"}}, // Villa San Giovanni-Cannitello railway station
    {Coordinate{13.5175, 45.9388}, CountryId{"IT"}}, // Q21184991
    {Coordinate{15.5955, 41.3975}, CountryId{"IT"}}, // Cervaro train station
    {Coordinate{14.7874, 41.2114}, CountryId{"IT"}}, // Q21185007
    {Coordinate{12.0415, 42.8749}, CountryId{"IT"}}, // Fabro-Ficulle
    {Coordinate{16.1499, 38.9707}, CountryId{"IT"}}, // Q21185013
    {Coordinate{16.059, 39.2464}, CountryId{"IT"}}, // Q21185021
    {Coordinate{14.7648, 41.2472}, CountryId{"IT"}}, // Q21185023
    {Coordinate{11.7109, 45.4866}, CountryId{"IT"}}, // Q21185030
    {Coordinate{13.3455, 46.5117}, CountryId{"IT"}}, // Q21185036
    {Coordinate{11.6358, 45.5188}, CountryId{"IT"}}, // Q21185042
    {Coordinate{15.2886, 41.8393}, CountryId{"IT"}}, // Q21185044
    {Coordinate{16.0612, 39.2115}, CountryId{"IT"}}, // Q21185046
    {Coordinate{12.2024, 43.1374}, CountryId{"IT"}}, // Magione
    {Coordinate{12.1879, 43.1584}, CountryId{"IT"}}, // Torricella railway station
    {Coordinate{13.3751, 45.9881}, CountryId{"IT"}}, // Q21185052
    {Coordinate{16.4669, 38.9233}, CountryId{"IT"}}, // Q21185054
    {Coordinate{11.7739, 45.458}, CountryId{"IT"}}, // Q21185058
    {Coordinate{13.1769, 46.3973}, CountryId{"IT"}}, // Q21185060
    {Coordinate{15.0275, 41.2156}, CountryId{"IT"}}, // Montecalvo-Buonalbergo-Casalbore railway station
    {Coordinate{14.6775, 41.3405}, CountryId{"IT"}}, // Morcone train station
    {Coordinate{14.7187, 41.3176}, CountryId{"IT"}}, // Q21185071
    {Coordinate{13.5475, 45.9351}, CountryId{"IT"}}, // Q21185073
    {Coordinate{16.1196, 39.0159}, CountryId{"IT"}}, // Q21185075
    {Coordinate{13.3663, 38.127}, CountryId{"IT"}}, // Q21185086
    {Coordinate{12.1332, 43.1884}, CountryId{"IT"}}, // Passignano sul Trasimeno
    {Coordinate{14.1607, 41.1739}, CountryId{"IT"}}, // Q21185094
    {Coordinate{14.7122, 41.2957}, CountryId{"IT"}}, // Q21185096
    {Coordinate{8.39734, 40.8379}, CountryId{"IT"}}, // Porto Torres Marittima railway station
    {Coordinate{15.6412, 38.1857}, CountryId{"IT"}}, // Reggio di Calabria Catona railway halt
    {Coordinate{15.6507, 38.1653}, CountryId{"IT"}}, // Reggio di Calabria Gallico railway station
    {Coordinate{13.5059, 45.8302}, CountryId{"IT"}}, // Q21185115
    {Coordinate{13.4838, 45.8723}, CountryId{"IT"}}, // Sagrado railway station
    {Coordinate{8.24989, 45.3535}, CountryId{"IT"}}, // San Germano Vercellese train station
    {Coordinate{13.3975, 45.9761}, CountryId{"IT"}}, // Q21185132
    {Coordinate{16.7536, 40.9586}, CountryId{"IT"}}, // Q21185136
    {Coordinate{14.6667, 41.3996}, CountryId{"IT"}}, // Q21185150
    {Coordinate{16.5105, 38.9027}, CountryId{"IT"}}, // Q21185154
    {Coordinate{7.85481, 45.5148}, CountryId{"IT"}}, // Q21185158
    {Coordinate{16.5497, 38.8925}, CountryId{"IT"}}, // Q21185166
    {Coordinate{12.634, 45.6883}, CountryId{"IT"}}, // Q21185169
    {Coordinate{15.2351, 41.2353}, CountryId{"IT"}}, // Montaguto-Panni railway station
    {Coordinate{12.3133, 46.0509}, CountryId{"IT"}}, // Nove railway station
    {Coordinate{13.4723, 42.0571}, CountryId{"IT"}}, // Paterno-San Pelino train station
    {Coordinate{15.167, 41.2307}, CountryId{"IT"}}, // Savignano-Greci railway station
    {Coordinate{17.1767, 40.5167}, CountryId{"IT"}}, // Q21185194
    {Coordinate{12.0796, 43.1967}, CountryId{"IT"}}, // Tuoro sul Trasimeno
    {Coordinate{6.63229, 48.5196}, CountryId{"FR"}}, // Gare de Chenevières
    {Coordinate{2.28722, 48.7394}, CountryId{"FR"}}, // Gare des Baconnets
    {Coordinate{7.34938, 50.7683}, CountryId{"DE"}}, // Blankenberg station
    {Coordinate{6.61051, 51.3299}, CountryId{"DE"}}, // Krefeld-Oppum station
    {Coordinate{8.17872, 53.1517}, CountryId{"DE"}}, // Oldenburg-Wechloy railway station
    {Coordinate{12.3308, 43.3041}, CountryId{"IT"}}, // Q21192986
    {Coordinate{49.6514, 58.5783}, CountryId{"RU"}}, // Q21193149
    {Coordinate{}, CountryId{"RU"}}, // Q21193912
    {Coordinate{44.5118, 48.5196}, CountryId{"RU"}}, // Sarepta
    {Coordinate{8.47533, 53.3053}, CountryId{"DE"}}, // Kirchhammelwarden station
    {Coordinate{0.808218, 45.1383}, CountryId{"FR"}}, // Gare de Niversac
    {Coordinate{2.5125, 48.8889}, CountryId{"FR"}}, // Le Raincy – Villemomble – Montfermeil
    {Coordinate{6.15631, 45.5574}, CountryId{"FR"}}, // Saint-Pierre-d'Albigny railway station
    {Coordinate{-4.3145, 55.9412}, CountryId{"GB"}}, // Milngavie railway station
    {Coordinate{4.04333, 50.2842}, CountryId{"FR"}}, // Q2122876
    {Coordinate{7.14088, 49.0559}, CountryId{"FR"}}, // Wittring
    {Coordinate{1.9929, 48.8238}, CountryId{"FR"}}, // Q2123084
    {Coordinate{5.68833, 50.5731}, CountryId{"BE"}}, // Trooz railway station
    {Coordinate{1.97924, 41.2789}, CountryId{"ES"}}, // Castelldefels railway station
    {Coordinate{6.56917, 52.4575}, CountryId{"NL"}}, // Vroomshoop railway station
    {Coordinate{-3.83265, 48.5779}, CountryId{"FR"}}, // Gare de Morlaix
    {Coordinate{3.53549, 43.3182}, CountryId{"FR"}}, // Marseillan-Plage
    {Coordinate{2.40278, 48.7417}, CountryId{"FR"}}, // Orly-Ville
    {Coordinate{5.41056, 52.9028}, CountryId{"NL"}}, // Koudum-Molkwerum railway station
    {Coordinate{3.40949, 49.038}, CountryId{"FR"}}, // Gare de Château-Thierry
    {Coordinate{}, CountryId{"FI"}}, // Rajaperkiö railway station
    {Coordinate{}, CountryId{"FI"}}, // Q21280549
    {Coordinate{}, CountryId{"FI"}}, // Q21280552
    {Coordinate{}, CountryId{"FI"}}, // Q21280554
    {Coordinate{}, CountryId{"FI"}}, // Q21280559
    {Coordinate{}, CountryId{"FI"}}, // Q21280560
    {Coordinate{}, CountryId{"FI"}}, // Q21280563
    {Coordinate{23.471, 61.6819}, CountryId{"FI"}}, // Q21280568
    {Coordinate{}, CountryId{"FI"}}, // Q21280606
    {Coordinate{23.527, 61.6255}, CountryId{"FI"}}, // Q21280612
    {Coordinate{23.7512, 61.4249}, CountryId{"FI"}}, // Sääksjärvi railway station
    {Coordinate{}, CountryId{"FI"}}, // Q21282081
    {Coordinate{}, CountryId{"FI"}}, // Q21282188
    {Coordinate{23.6795, 61.5096}, CountryId{"FI"}}, // Lielahti railway station
    {Coordinate{5.57806, 51.9581}, CountryId{"NL"}}, // Rhenen railway station
    {Coordinate{4.45611, 51.1708}, CountryId{"BE"}}, // Mortsel-Oude-God railway station
    {Coordinate{12.413, 51.1505}, CountryId{"DE"}}, // Neukieritzsch station
    {Coordinate{12.6976, 51.0582}, CountryId{"DE"}}, // Geithain station
    {Coordinate{12.4862, 51.118}, CountryId{"DE"}}, // Borna (b Leipzig) railway station
    {Coordinate{22.9319, 42.9219}, CountryId{"BG"}}, // Q21293321
    {Coordinate{11.1494, 51.73}, CountryId{"DE"}}, // Q2129519
    {Coordinate{8.59512, 53.1853}, CountryId{"DE"}}, // Klinikum Bremen-Nord/Beckedorf
    {Coordinate{8.61761, 53.1851}, CountryId{"DE"}}, // Bremen-Aumund
    {Coordinate{8.58094, 53.1836}, CountryId{"DE"}}, // Bremen-Blumenthal
    {Coordinate{8.57133, 53.1852}, CountryId{"DE"}}, // Bremen-Mühlenstraße
    {Coordinate{8.55738, 53.1889}, CountryId{"DE"}}, // Bremen-Kleinsloger
    {Coordinate{8.5447, 53.1935}, CountryId{"DE"}}, // Bremen-Turnerstraße station
    {Coordinate{0.971667, 43.1789}, CountryId{"FR"}}, // Boussens train station
    {Coordinate{-1.3955, 43.3241}, CountryId{"FR"}}, // Itsasu/Itxassou station
    {Coordinate{2.35194, 43.2181}, CountryId{"FR"}}, // Gare de Carcassonne
    {Coordinate{2.93644, 50.5745}, CountryId{"FR"}}, // Wavrin
    {Coordinate{4.98027, 43.5154}, CountryId{"FR"}}, // Istres
    {Coordinate{2.86717, 50.5481}, CountryId{"FR"}}, // Q2130876
    {Coordinate{6.23639, 46.1994}, CountryId{"FR"}}, // Gare d'Annemasse
    {Coordinate{19.8422, 54.3811}, CountryId{"PL"}}, // Q2131055
    {Coordinate{6.95357, 51.3634}, CountryId{"DE"}}, // Kettwig station
    {Coordinate{2.01047, 41.3034}, CountryId{"ES"}}, // Estació de Gavà
    {Coordinate{8.49892, 47.9478}, CountryId{"DE"}}, // Donaueschingen station
    {Coordinate{5.03667, 50.7636}, CountryId{"BE"}}, // Neerwinden railway station
    {Coordinate{4.18808, 50.4654}, CountryId{"BE"}}, // La Louvière-South railway station
    {Coordinate{14.408, 50.065}, CountryId{"CZ"}}, // Smíchovské nádraží
    {Coordinate{24.06, 59.3445}, CountryId{"EE"}}, // Paldiski train station
    {Coordinate{3.94621, 50.1197}, CountryId{"FR"}}, // Q2133341
    {Coordinate{5.04662, 46.2349}, CountryId{"FR"}}, // Q2133524
    {Coordinate{5.7225, 51.9194}, CountryId{"NL"}}, // Zetten-Andelst railway station
    {Coordinate{2.09222, 48.955}, CountryId{"FR"}}, // Achères - Grand-Cormier
    {Coordinate{4.8145, 45.1857}, CountryId{"FR"}}, // Q2134090
    {Coordinate{6.43387, 43.4309}, CountryId{"FR"}}, // Gare de Vidauban
    {Coordinate{2.07356, 48.799}, CountryId{"FR"}}, // gare de Saint-Cyr
    {Coordinate{2.55389, 44.2908}, CountryId{"FR"}}, // Gare de Luc-Primaube
    {Coordinate{21.1353, 52.2369}, CountryId{"PL"}}, // Warszawa Gocławek railway station
    {Coordinate{4.01043, 50.5434}, CountryId{"BE"}}, // Neufvilles railway station
    {Coordinate{2.36865, 48.9957}, CountryId{"FR"}}, // Gare de Sarcelles-Saint-Brice
    {Coordinate{2.095, 49.046}, CountryId{"FR"}}, // Gare de Pontoise
    {Coordinate{1.77444, 49.6856}, CountryId{"FR"}}, // Gare d'Abancourt
    {Coordinate{4.46889, 51.1692}, CountryId{"BE"}}, // Mortsel-Liersesteenweg railway station
    {Coordinate{-1.78134, 46.4998}, CountryId{"FR"}}, // Les Sables-d'Olonne
    {Coordinate{4.55197, 50.5571}, CountryId{"BE"}}, // Tilly railway station
    {Coordinate{-1.3714, 47.7174}, CountryId{"FR"}}, // Châteaubriant
    {Coordinate{14.4233, 50.0838}, CountryId{"CZ"}}, // Můstek
    {Coordinate{3.83679, 50.7126}, CountryId{"BE"}}, // Lessines railway station
    {Coordinate{-0.867991, 47.4102}, CountryId{"FR"}}, // Q2140129
    {Coordinate{1.64251, 50.5171}, CountryId{"FR"}}, // Gare d'Étaples-Le Touquet
    {Coordinate{9.86992, 53.2848}, CountryId{"DE"}}, // Holm-Seppensen station
    {Coordinate{6.99728, 50.9356}, CountryId{"DE"}}, // Köln-Trimbornstraße station
    {Coordinate{78.1621, 11.66}, CountryId{"IN"}}, // Salem Town Railway Station
    {Coordinate{8.57583, 53.6889}, CountryId{"DE"}}, // Q21416449
    {Coordinate{6.14447, 48.7554}, CountryId{"FR"}}, // Q2142149
    {Coordinate{8.62127, 53.7786}, CountryId{"DE"}}, // Q21421807
    {Coordinate{3.32984, 50.2255}, CountryId{"FR"}}, // Q2142874
    {Coordinate{5.79918, 46.9771}, CountryId{"FR"}}, // Gare de Mouchard
    {Coordinate{2.42889, 48.6256}, CountryId{"FR"}}, // Gare d'Évry-Courcouronnes
    {Coordinate{8.70772, 58.614}, CountryId{"NO"}}, // Q21445392
    {Coordinate{2.45889, 48.8961}, CountryId{"FR"}}, // Noisy-le-Sec
    {Coordinate{2.33889, 48.8206}, CountryId{"FR"}}, // Gare de Cité Universitaire
    {Coordinate{7.43883, 51.5097}, CountryId{"DE"}}, // Dortmund West railway station
    {Coordinate{1.45305, 48.4368}, CountryId{"FR"}}, // Lucé railway station
    {Coordinate{5.74229, 45.0855}, CountryId{"FR"}}, // Q2145513
    {Coordinate{6.97693, 51.4802}, CountryId{"DE"}}, // Essen-Bergeborbeck station
    {Coordinate{5.26778, 49.8528}, CountryId{"BE"}}, // Bertrix railway station
    {Coordinate{1.62583, 49.9325}, CountryId{"FR"}}, // Gare de Blangy-sur-Bresle
    {Coordinate{9.2092, 48.496}, CountryId{"DE"}}, // Reutlingen Central Railway Station
    {Coordinate{1.57511, 41.1896}, CountryId{"ES"}}, // Calafell
    {Coordinate{22.9818, 61.4045}, CountryId{"FI"}}, // Heinoon rautatieasema
    {Coordinate{4.40035, 50.462}, CountryId{"BE"}}, // Courcelles-Motte railway station
    {Coordinate{8.3769, 40.6499}, CountryId{"IT"}}, // Olmedo railway station
    {Coordinate{7.45874, 47.6557}, CountryId{"FR"}}, // Gare de Sierentz
    {Coordinate{8.24096, 52.9448}, CountryId{"DE"}}, // Großenkneten
    {Coordinate{8.20957, 52.8996}, CountryId{"DE"}}, // Ahlhorn
    {Coordinate{8.05587, 52.844}, CountryId{"DE"}}, // Cloppenburg
    {Coordinate{7.94544, 52.7236}, CountryId{"DE"}}, // Essen (Oldb)
    {Coordinate{2.39278, 48.3931}, CountryId{"FR"}}, // gare de Maisse
    {Coordinate{6.72056, 53.4139}, CountryId{"NL"}}, // Uithuizermeeden railway station
    {Coordinate{0.411509, 46.5263}, CountryId{"FR"}}, // Mignaloux-Beauvoir railway station
    {Coordinate{-1.57537, 47.9852}, CountryId{"FR"}}, // Q2150105
    {Coordinate{8.29247, 52.7485}, CountryId{"DE"}}, // Station Vechta Stoppelmarkt
    {Coordinate{13.5475, 52.5506}, CountryId{"DE"}}, // Raoul-Wallenberg-Straße railway station
    {Coordinate{2.39889, 49.1189}, CountryId{"FR"}}, // Gare de Seugy
    {Coordinate{15.6142, 50.0317}, CountryId{"CZ"}}, // Q2151227
    {Coordinate{10.0298, 53.4243}, CountryId{"DE"}}, // Meckelfeld station
    {Coordinate{10.066, 53.4035}, CountryId{"DE"}}, // Maschen station
    {Coordinate{10.1091, 53.3877}, CountryId{"DE"}}, // Stelle station
    {Coordinate{10.145, 53.3688}, CountryId{"DE"}}, // Ashausen station
    {Coordinate{10.2901, 53.3177}, CountryId{"DE"}}, // Radbruch station
    {Coordinate{10.3723, 53.2903}, CountryId{"DE"}}, // Bardowick station
    {Coordinate{10.2085, 53.3535}, CountryId{"DE"}}, // Winsen station
    {Coordinate{9.85857, 53.2696}, CountryId{"DE"}}, // Büsenbachtal station
    {Coordinate{9.84476, 53.2418}, CountryId{"DE"}}, // Handeloh station
    {Coordinate{9.82863, 53.1861}, CountryId{"DE"}}, // Wintermoor station
    {Coordinate{6.23454, 49.3804}, CountryId{"FR"}}, // Basse-Ham
    {Coordinate{5.65334, 46.2597}, CountryId{"FR"}}, // Gare d'Oyonnax
    {Coordinate{6.15765, 46.8577}, CountryId{"FR"}}, // Gare de Frasne
    {Coordinate{6.47056, 52.3656}, CountryId{"NL"}}, // Nijverdal railway station
    {Coordinate{6.8725, 52.7475}, CountryId{"NL"}}, // Emmen Zuid railway station
    {Coordinate{2.14417, 48.9458}, CountryId{"FR"}}, // Gare de Maisons-Laffitte
    {Coordinate{34.3769, 54.0681}, CountryId{"RU"}}, // Q21538485
    {Coordinate{-2.35209, 48.376}, CountryId{"FR"}}, // Q2154264
    {Coordinate{19.9472, 50.0656}, CountryId{"PL"}}, // Kraków Główny railway station
    {Coordinate{5.32972, 51.0336}, CountryId{"BE"}}, // Zolder railway station
    {Coordinate{3.20476, 46.0976}, CountryId{"FR"}}, // Q2154970
    {Coordinate{6.96528, 51.455}, CountryId{"DE"}}, // Essen-Frohnhausen station
    {Coordinate{16.1086, 49.9947}, CountryId{"CZ"}}, // Q2155261
    {Coordinate{1.37019, 48.7314}, CountryId{"FR"}}, // Gare de Dreux
    {Coordinate{1.62091, 48.2744}, CountryId{"FR"}}, // Q2155896
    {Coordinate{13.5328, 43.2874}, CountryId{"IT"}}, // San Claudio railway station
    {Coordinate{13.4778, 43.2816}, CountryId{"IT"}}, // Corridonia-Mogliano railway station
    {Coordinate{13.4408, 43.2926}, CountryId{"IT"}}, // Macerata Fontescodella railway station
    {Coordinate{13.417, 43.2575}, CountryId{"IT"}}, // Urbisaglia-Sforzacosta railway station
    {Coordinate{13.367, 43.2409}, CountryId{"IT"}}, // Pollenza railway station
    {Coordinate{13.1835, 43.23}, CountryId{"IT"}}, // San Severino Marche railway station
    {Coordinate{13.0753, 43.2202}, CountryId{"IT"}}, // Gagliole railway station
    {Coordinate{13.0151, 43.2539}, CountryId{"IT"}}, // Matelica railway station
    {Coordinate{4.08545, 46.0239}, CountryId{"FR"}}, // Gare du Coteau
    {Coordinate{-0.368059, 45.2119}, CountryId{"FR"}}, // Gare de Bussac
    {Coordinate{19.8222, 49.9772}, CountryId{"PL"}}, // Q2156575
    {Coordinate{2.97922, 45.1254}, CountryId{"FR"}}, // Q2156841
    {Coordinate{38.9858, 45.0711}, CountryId{"RU"}}, // ZIP (Krasnodar)
    {Coordinate{25.9581, 48.0239}, CountryId{"UA"}}, // Vadul Siret
    {Coordinate{4.45111, 51.4625}, CountryId{"BE"}}, // Essen railway station
    {Coordinate{}, CountryId{"FI"}}, // Raippo railway station
    {Coordinate{3.07184, 48.3426}, CountryId{"FR"}}, // Gare de Villeneuve-la-Guyard
    {Coordinate{8.5969, 47.2615}, CountryId{"CH"}}, // Horgen railway station
    {Coordinate{8.69286, 47.2087}, CountryId{"CH"}}, // Burghalden railway station
    {Coordinate{8.64358, 47.2468}, CountryId{"CH"}}, // Au ZH railway station
    {Coordinate{8.67528, 47.2294}, CountryId{"CH"}}, // Wädenswil railway station
    {Coordinate{0.189471, 49.543}, CountryId{"FR"}}, // Gare de Montivilliers
    {Coordinate{1.90611, 42.4586}, CountryId{"FR"}}, // Latour-de-Carol-Enveitg station
    {Coordinate{4.65014, 50.7365}, CountryId{"BE"}}, // Gastuche railway station
    {Coordinate{6.45981, 50.7265}, CountryId{"DE"}}, // Q2158763
    {Coordinate{12.3553, 50.1239}, CountryId{"CZ"}}, // Q2159153
    {Coordinate{86.1325, 20.9435}, CountryId{"IN"}}, // Jajpur Keonjhar Road Railway Station
    {Coordinate{5.62412, 52.0847}, CountryId{"NL"}}, // Lunteren railway station
    {Coordinate{8.61348, 52.3787}, CountryId{"DE"}}, // Espelkamp station
    {Coordinate{13.5714, 50.5195}, CountryId{"CZ"}}, // Q21598545
    {Coordinate{8.54599, 52.2891}, CountryId{"DE"}}, // Holzhausen-Heddinghausen station
    {Coordinate{8.52086, 52.2637}, CountryId{"DE"}}, // Neue Mühle station
    {Coordinate{8.51689, 52.2393}, CountryId{"DE"}}, // Bieren-Rödinghausen station
    {Coordinate{3.9219, 51.0031}, CountryId{"BE"}}, // Schellebelle railway station
    {Coordinate{10.4331, 59.8203}, CountryId{"NO"}}, // Bondivatn Station
    {Coordinate{10.4364, 59.8067}, CountryId{"NO"}}, // Gullhella Station
    {Coordinate{10.3897, 59.7466}, CountryId{"NO"}}, // Røyken Station
    {Coordinate{11.6782, 58.4846}, CountryId{"SE"}}, // Munkedal railway station
    {Coordinate{0.873825, 46.4175}, CountryId{"FR"}}, // Montmorillon railway station
    {Coordinate{10.4306, 59.7867}, CountryId{"NO"}}, // Heggedal Station
    {Coordinate{1.55235, 46.4405}, CountryId{"FR"}}, // Q2161232
    {Coordinate{4.70446, 44.4433}, CountryId{"FR"}}, // Q2161382
    {Coordinate{2.31639, 48.9664}, CountryId{"FR"}}, // Gare de La Barre - Ormesson
    {Coordinate{10.1056, 45.8066}, CountryId{"IT"}}, // Pisogne
    {Coordinate{7.33837, 43.764}, CountryId{"FR"}}, // Q21619066
    {Coordinate{5.78583, 50.9469}, CountryId{"NL"}}, // Beek-Elsloo railway station
    {Coordinate{23.6003, 62.6175}, CountryId{"FI"}}, // Alavus railway station
    {Coordinate{14.2975, 50.0639}, CountryId{"CZ"}}, // Q2162591
    {Coordinate{4.49185, 50.0564}, CountryId{"BE"}}, // Couvin railway station
    {Coordinate{14.4503, 50.0778}, CountryId{"CZ"}}, // Jiřího z Poděbrad
    {Coordinate{2.76361, 48.3942}, CountryId{"FR"}}, // Gare de Thomery
    {Coordinate{43.5028, 51.9381}, CountryId{"RU"}}, // Q21635617
    {Coordinate{46.8528, 45.4414}, CountryId{"RU"}}, // Q21635631
    {Coordinate{59.7903, 56.9439}, CountryId{"RU"}}, // Q21636133
    {Coordinate{40.5378, 56.1947}, CountryId{"RU"}}, // Bogolyubovo railway station
    {Coordinate{106.07, 51.8489}, CountryId{"RU"}}, // Q21636455
    {Coordinate{1.88304, 48.081}, CountryId{"FR"}}, // Gare d'Artenay
    {Coordinate{32.1986, 54.8029}, CountryId{"RU"}}, // Q21636685
    {Coordinate{}, CountryId{"RU"}}, // Q21636760
    {Coordinate{59.955, 57.345}, CountryId{"RU"}}, // Q21636884
    {Coordinate{32.2104, 54.8076}, CountryId{"RU"}}, // Q21637320
    {Coordinate{43.6311, 56.2567}, CountryId{"RU"}}, // Q21637408
    {Coordinate{104.646, 51.4467}, CountryId{"RU"}}, // Vydrino station
    {Coordinate{42.1686, 56.2022}, CountryId{"RU"}}, // Q21637624
    {Coordinate{5.06833, 52.0986}, CountryId{"NL"}}, // Utrecht Leidsche Rijn railway station
    {Coordinate{108.793, 51.5597}, CountryId{"RU"}}, // Gorkhon station
    {Coordinate{}, CountryId{"RU"}}, // Q21638430
    {Coordinate{40.2475, 61.9328}, CountryId{"RU"}}, // Q21638468
    {Coordinate{}, CountryId{"RU"}}, // Q21638736
    {Coordinate{43.0508, 45.8114}, CountryId{"RU"}}, // Q21638768
    {Coordinate{43.3394, 45.8975}, CountryId{"RU"}}, // Q21638881
    {Coordinate{}, CountryId{"RU"}}, // Q21638934
    {Coordinate{}, CountryId{"RU"}}, // Q21639107
    {Coordinate{60.0869, 57.4297}, CountryId{"RU"}}, // Q21639222
    {Coordinate{33.1695, 54.5745}, CountryId{"RU"}}, // Q21639262
    {Coordinate{33.3877, 54.5412}, CountryId{"RU"}}, // Q21639403
    {Coordinate{104.929, 51.5103}, CountryId{"RU"}}, // Q21640181
    {Coordinate{}, CountryId{"RU"}}, // Q21640266
    {Coordinate{105.736, 51.6842}, CountryId{"RU"}}, // Q21640274
    {Coordinate{}, CountryId{"RU"}}, // Q21640338
    {Coordinate{}, CountryId{"RU"}}, // Q21640457
    {Coordinate{39.8822, 59.2069}, CountryId{"RU"}}, // Konosha I
    {Coordinate{33.4848, 54.5202}, CountryId{"RU"}}, // Q21640516
    {Coordinate{28.7572, 59.6125}, CountryId{"RU"}}, // Q21640568
    {Coordinate{}, CountryId{"RU"}}, // Q21640632
    {Coordinate{49.6514, 58.5783}, CountryId{"RU"}}, // Krasnoselsky passing
    {Coordinate{31.9063, 54.8004}, CountryId{"RU"}}, // Q21640692
    {Coordinate{38.9542, 44.9889}, CountryId{"RU"}}, // Q21640779
    {Coordinate{124.217, 55.1911}, CountryId{"RU"}}, // Q21640847
    {Coordinate{}, CountryId{"RU"}}, // Q21640913
    {Coordinate{123.119, 55.4994}, CountryId{"RU"}}, // Q21641032
    {Coordinate{107.249, 52.1158}, CountryId{"RU"}}, // Q21641137
    {Coordinate{122.769, 55.7667}, CountryId{"RU"}}, // Q21641237
    {Coordinate{34.3017, 63.1506}, CountryId{"RU"}}, // Maselskaya (railway station)
    {Coordinate{16.378, 49.9714}, CountryId{"CZ"}}, // Ústí nad Orlicí
    {Coordinate{30.3456, 57.8936}, CountryId{"RU"}}, // Q21641806
    {Coordinate{3.30298, 48.5556}, CountryId{"FR"}}, // Gare de Provins
    {Coordinate{}, CountryId{"RU"}}, // Q21643429
    {Coordinate{54.2431, 56.1036}, CountryId{"RU"}}, // Q21643453
    {Coordinate{32.103, 54.7838}, CountryId{"RU"}}, // Q21643540
    {Coordinate{76.6903, 66.0903}, CountryId{"RU"}}, // Q21643552
    {Coordinate{120.736, 57.0203}, CountryId{"RU"}}, // Q21643615
    {Coordinate{}, CountryId{"RU"}}, // Q21643657
    {Coordinate{}, CountryId{"RU"}}, // Q21643748
    {Coordinate{40.7133, 56.9347}, CountryId{"RU"}}, // Q21643786
    {Coordinate{105.253, 51.5792}, CountryId{"RU"}}, // Q21643811
    {Coordinate{}, CountryId{"RU"}}, // Q21643818
    {Coordinate{108.86, 51.2946}, CountryId{"RU"}}, // Petrovsky Zavod station
    {Coordinate{29.9344, 57.3817}, CountryId{"RU"}}, // Q21643931
    {Coordinate{45.8281, 52.2614}, CountryId{"RU"}}, // Q21643983
    {Coordinate{61.1103, 55.0292}, CountryId{"RU"}}, // Q21644002
    {Coordinate{30.1489, 57.8567}, CountryId{"RU"}}, // Q21644008
    {Coordinate{106.354, 51.9689}, CountryId{"RU"}}, // Q21644031
    {Coordinate{}, CountryId{"RU"}}, // Q21644075
    {Coordinate{54.9322, 54.0608}, CountryId{"RU"}}, // Q21644158
    {Coordinate{31.8208, 54.7954}, CountryId{"RU"}}, // Q21644169
    {Coordinate{61.4317, 57.365}, CountryId{"RU"}}, // Q21644187
    {Coordinate{97.2067, 56.1578}, CountryId{"RU"}}, // Q21644202
    {Coordinate{29.7381, 57.8039}, CountryId{"RU"}}, // Q21644239
    {Coordinate{}, CountryId{"RU"}}, // Q21644277
    {Coordinate{40.5525, 56.8011}, CountryId{"RU"}}, // Q21644332
    {Coordinate{42.0228, 56.2236}, CountryId{"RU"}}, // Q21644365
    {Coordinate{34.0714, 45.2017}, CountryId{"RU"}}, // Q21644398
    {Coordinate{32.1241, 54.8107}, CountryId{"RU"}}, // Q21644440
    {Coordinate{32.2159, 54.7592}, CountryId{"RU"}}, // Q21644466
    {Coordinate{}, CountryId{"RU"}}, // Q21644579
    {Coordinate{40.2475, 61.9328}, CountryId{"RU"}}, // Q21644604
    {Coordinate{105.112, 51.5547}, CountryId{"RU"}}, // Q21644619
    {Coordinate{40.5642, 56.8575}, CountryId{"RU"}}, // Q21644639
    {Coordinate{40.8903, 56.9983}, CountryId{"RU"}}, // Q21644640
    {Coordinate{}, CountryId{"RU"}}, // Q21644648
    {Coordinate{106.616, 52.0039}, CountryId{"RU"}}, // Q21644657
    {Coordinate{32.2286, 54.6915}, CountryId{"RU"}}, // Q21644754
    {Coordinate{46.8528, 45.4414}, CountryId{"RU"}}, // Q21644784
    {Coordinate{43.7753, 46.075}, CountryId{"RU"}}, // Q21644801
    {Coordinate{28.3058, 59.6489}, CountryId{"RU"}}, // Q21644880
    {Coordinate{119.956, 56.9144}, CountryId{"RU"}}, // Q21645051
    {Coordinate{43.9833, 46.3106}, CountryId{"RU"}}, // Q21645070
    {Coordinate{40.2475, 61.9328}, CountryId{"RU"}}, // Q21645073
    {Coordinate{123.761, 55.3742}, CountryId{"RU"}}, // Q21645165
    {Coordinate{99.6331, 54.7047}, CountryId{"RU"}}, // Q21645201
    {Coordinate{108.39, 51.7606}, CountryId{"RU"}}, // Chelutai station
    {Coordinate{56.0169, 54.6265}, CountryId{"RU"}}, // Chernoye Ozero
    {Coordinate{122.409, 56.0008}, CountryId{"RU"}}, // Q21645651
    {Coordinate{34.0492, 44.9031}, CountryId{"RU"}}, // Q21645655
    {Coordinate{}, CountryId{"RU"}}, // Q21645802
    {Coordinate{54.6022, 56.2442}, CountryId{"RU"}}, // Q21645804
    {Coordinate{121.63, 56.5944}, CountryId{"RU"}}, // Yuktali railway station
    {Coordinate{}, CountryId{"RU"}}, // Q21645882
    {Coordinate{7.17367, 47.8019}, CountryId{"FR"}}, // Gare de Cernay
    {Coordinate{5.55559, 50.6108}, CountryId{"BE"}}, // Sclessin railway station
    {Coordinate{51.3089, 43.6969}, CountryId{"KZ"}}, // Q21659355
    {Coordinate{32.7789, 56.2211}, CountryId{"RU"}}, // Q21661170
    {Coordinate{8.68188, 40.7491}, CountryId{"IT"}}, // Q21662090
    {Coordinate{1.40111, 43.6842}, CountryId{"FR"}}, // Gare de Fenouillet-Saint-Alban
    {Coordinate{61.5703, 54.1131}, CountryId{"RU"}}, // Troitsk
    {Coordinate{1.06992, 49.5513}, CountryId{"FR"}}, // Q2166681
    {Coordinate{-1.05038, 43.7208}, CountryId{"FR"}}, // Dax
    {Coordinate{9.00976, 52.3681}, CountryId{"DE"}}, // Petershagen-Lahde railway station
    {Coordinate{9.1105, 52.5096}, CountryId{"DE"}}, // Leese-Stolzenau railway station
    {Coordinate{8.84175, 40.8133}, CountryId{"IT"}}, // Q21675364
    {Coordinate{1.17006, 45.9598}, CountryId{"FR"}}, // Q2167746
    {Coordinate{1.9581, 47.3837}, CountryId{"FR"}}, // Q2167825
    {Coordinate{3.10083, 45.7786}, CountryId{"FR"}}, // Gare de Clermont-Ferrand
    {Coordinate{8.93761, 53.0871}, CountryId{"DE"}}, // Bremen-Oberneuland station
    {Coordinate{2.25237, 46.9921}, CountryId{"FR"}}, // Q2168788
    {Coordinate{3.06972, 49.7397}, CountryId{"FR"}}, // Gare de Ham
    {Coordinate{4.00797, 50.4698}, CountryId{"BE"}}, // Obourg railway station
    {Coordinate{3.33361, 50.1283}, CountryId{"FR"}}, // Gare de Cattenières
    {Coordinate{2.28355, 49.8932}, CountryId{"FR"}}, // Gare de Saint-Roch
    {Coordinate{5.22722, 51.9472}, CountryId{"NL"}}, // Culemborg railway station
    {Coordinate{8.80146, 51.9915}, CountryId{"DE"}}, // Lage (Lippe) railway station
    {Coordinate{4.38, 50.5072}, CountryId{"BE"}}, // Luttre railway station
    {Coordinate{83.0319, 25.3266}, CountryId{"IN"}}, // Kashi Railway station
    {Coordinate{14.0877, 51.1022}, CountryId{"DE"}}, // Großharthau railway station
    {Coordinate{3.18228, 50.811}, CountryId{"BE"}}, // Wevelgem railway station
    {Coordinate{11.1732, 58.9363}, CountryId{"SE"}}, // Strömstad
    {Coordinate{3.52621, 50.5273}, CountryId{"BE"}}, // Callenelle railway station
    {Coordinate{3.8095, 50.1981}, CountryId{"FR"}}, // Berlaimont
    {Coordinate{7.4077, 51.9666}, CountryId{"DE"}}, // Havixbeck station
    {Coordinate{4.81556, 51.8294}, CountryId{"NL"}}, // Hardinxveld Blauwe Zoom railway station
    {Coordinate{4.53422, 50.5778}, CountryId{"BE"}}, // Villers-la-Ville railway station
    {Coordinate{7.65783, 48.9308}, CountryId{"FR"}}, // Q2173596
    {Coordinate{5.56194, 50.6408}, CountryId{"BE"}}, // Liège-Carré railway station
    {Coordinate{6.30435, 46.0667}, CountryId{"FR"}}, // La Roche-sur-Foron
    {Coordinate{2.73464, 50.0957}, CountryId{"FR"}}, // Gare de Miraumont
    {Coordinate{9.10549, 40.8976}, CountryId{"IT"}}, // Tempio Pausania Station
    {Coordinate{14.1512, 51.1109}, CountryId{"DE"}}, // Weickersdorf (Sachs) railway station
    {Coordinate{14.2396, 51.1422}, CountryId{"DE"}}, // Demitz-Thumitz railway station
    {Coordinate{14.325, 51.1536}, CountryId{"DE"}}, // Seitschen railway station
    {Coordinate{14.5094, 51.1656}, CountryId{"DE"}}, // Kubschütz railway station
    {Coordinate{2.78681, 50.7129}, CountryId{"FR"}}, // Steenwerck
    {Coordinate{10.5822, 43.3394}, CountryId{"IT"}}, // Riparbella railway station
    {Coordinate{10.7423, 43.3351}, CountryId{"IT"}}, // Ponte Ginori railway station
    {Coordinate{2.13472, 48.8097}, CountryId{"FR"}}, // Gare de Versailles-Rive-Droite
    {Coordinate{7.51534, 51.5134}, CountryId{"DE"}}, // Dortmund-Körne station
    {Coordinate{2.43278, 48.5708}, CountryId{"FR"}}, // gare de Mennecy
    {Coordinate{1.8315, 48.6437}, CountryId{"FR"}}, // Gare de Rambouillet
    {Coordinate{4.4575, 50.9586}, CountryId{"BE"}}, // Eppegem railway station
    {Coordinate{1.83083, 49.6544}, CountryId{"FR"}}, // Gare de Feuquières-Broquiers
    {Coordinate{2.05111, 48.8678}, CountryId{"FR"}}, // Gare de Saint-Nom-la-Bretèche – Forêt de Marly
    {Coordinate{6.93405, 45.9967}, CountryId{"FR"}}, // Q2177034
    {Coordinate{6.40556, 53.2483}, CountryId{"NL"}}, // Zuidhorn railway station
    {Coordinate{4.70164, 50.9226}, CountryId{"BE"}}, // Wijgmaal railway station
    {Coordinate{13.3679, 52.4924}, CountryId{"DE"}}, // Yorckstraße (Großgörschenstraße) station
    {Coordinate{13.3721, 52.4918}, CountryId{"DE"}}, // Yorckstraße station
    {Coordinate{9.19009, 40.9265}, CountryId{"IT"}}, // Q21779001
    {Coordinate{7.25119, 48.7296}, CountryId{"FR"}}, // Gare de Lutzelbourg
    {Coordinate{-3.12855, 48.7276}, CountryId{"FR"}}, // Halte de Frynaudour
    {Coordinate{6.17361, 48.6897}, CountryId{"FR"}}, // Gare de Nancy-Ville
    {Coordinate{4.0861, 49.9291}, CountryId{"FR"}}, // Q2178893
    {Coordinate{-1.36222, 43.3055}, CountryId{"FR"}}, // Luhuso/Louhossoa station
    {Coordinate{4.40707, 50.285}, CountryId{"BE"}}, // Berzée railway station
    {Coordinate{2.61667, 48.8433}, CountryId{"FR"}}, // Noisiel
    {Coordinate{2.25483, 50.4469}, CountryId{"FR"}}, // Gare d'Anvin
    {Coordinate{1.45028, 43.5797}, CountryId{"FR"}}, // Gare de Toulouse-Saint-Agne
    {Coordinate{6.95083, 52.2211}, CountryId{"NL"}}, // Enschede De Eschmarke railway station
    {Coordinate{-1.54167, 47.2167}, CountryId{"FR"}}, // Nantes station
    {Coordinate{3.75665, 51.0383}, CountryId{"BE"}}, // Gentbrugge railway station
    {Coordinate{4.80528, 52.7861}, CountryId{"NL"}}, // Schagen railway station
    {Coordinate{4.17695, 50.5463}, CountryId{"BE"}}, // Marche-lez-Écaussinnes railway station
    {Coordinate{13.5356, 52.5356}, CountryId{"DE"}}, // Berlin Poelchaustraße station
    {Coordinate{2.70944, 48.8364}, CountryId{"FR"}}, // Bussy-Saint-Georges Station
    {Coordinate{5.06138, 50.343}, CountryId{"BE"}}, // Natoye railway station
    {Coordinate{4.12064, 45.5544}, CountryId{"FR"}}, // Gare de Saint-Romain le Puy
    {Coordinate{13.4972, 49.7853}, CountryId{"CZ"}}, // Chrást u Plzně (train station)
    {Coordinate{12.0541, 60.3468}, CountryId{"NO"}}, // Nor Station
    {Coordinate{11.2711, 60.7913}, CountryId{"NO"}}, // Q21819376
    {Coordinate{-0.236448, 44.9159}, CountryId{"FR"}}, // Gare de Libourne
    {Coordinate{-0.493586, 46.1527}, CountryId{"FR"}}, // Gare de Prissé-la-Charrière
    {Coordinate{36.6728, 56.5758}, CountryId{"RU"}}, // Q21821302
    {Coordinate{40.5836, 64.1531}, CountryId{"RU"}}, // Q21821327
    {Coordinate{2.46361, 48.6061}, CountryId{"FR"}}, // gare d'Essonnes - Robinson
    {Coordinate{1.82419, 50.1021}, CountryId{"FR"}}, // Gare d'Abbeville
    {Coordinate{1.94917, 42.4322}, CountryId{"FR"}}, // Gare de Bourg-Madame
    {Coordinate{-0.292532, 48.1342}, CountryId{"FR"}}, // Q2182950
    {Coordinate{-0.513033, 46.0987}, CountryId{"FR"}}, // Gare de Villeneuve-la-Comtesse
    {Coordinate{17.2969, 50.9311}, CountryId{"PL"}}, // Oława railway station
    {Coordinate{6.79702, 45.8936}, CountryId{"FR"}}, // Q2183736
    {Coordinate{1.44453, 44.092}, CountryId{"FR"}}, // Q2183967
    {Coordinate{3.62378, 50.8703}, CountryId{"BE"}}, // Eine railway station
    {Coordinate{5.55133, 46.6685}, CountryId{"FR"}}, // Lons-le-Saunier railway station
    {Coordinate{37.6564, 55.7733}, CountryId{"RU"}}, // Moskva-Passazirskaya-Kazanskaya
    {Coordinate{3.22353, 49.6111}, CountryId{"FR"}}, // Gare de Chauny
    {Coordinate{5.29972, 52.1833}, CountryId{"NL"}}, // Soestdijk railway station
    {Coordinate{19.1329, 47.7826}, CountryId{"HU"}}, // Vác railway station
    {Coordinate{9.37242, 41.0816}, CountryId{"IT"}}, // Q21855978
    {Coordinate{4.93139, 52.495}, CountryId{"NL"}}, // Purmerend Weidevenne railway station
    {Coordinate{2.65472, 48.8394}, CountryId{"FR"}}, // Torcy
    {Coordinate{19.1288, 47.6075}, CountryId{"HU"}}, // Dunakeszi alsó railway station
    {Coordinate{19.1362, 47.6258}, CountryId{"HU"}}, // Dunakeszi railway station
    {Coordinate{19.1348, 47.6434}, CountryId{"HU"}}, // Dunakeszi-Gyártelep railway station
    {Coordinate{19.1347, 47.678}, CountryId{"HU"}}, // Alsógöd railway station
    {Coordinate{19.1375, 47.6878}, CountryId{"HU"}}, // Göd railway station
    {Coordinate{19.1432, 47.7055}, CountryId{"HU"}}, // Felsőgöd railway station
    {Coordinate{19.1549, 47.728}, CountryId{"HU"}}, // Sződ-Sződliget railway station
    {Coordinate{19.1495, 47.7732}, CountryId{"HU"}}, // Vác-Alsóváros railway station
    {Coordinate{19.0313, 47.8238}, CountryId{"HU"}}, // Verőce railway station
    {Coordinate{19.0109, 47.8274}, CountryId{"HU"}}, // Kismaros railway station
    {Coordinate{18.956, 47.7858}, CountryId{"HU"}}, // Nagymaros-Visegrád railway station
    {Coordinate{18.9517, 47.7799}, CountryId{"HU"}}, // Nagymaros railway station
    {Coordinate{18.9176, 47.7705}, CountryId{"HU"}}, // Dömösi átkelés railway station
    {Coordinate{18.9091, 47.8007}, CountryId{"HU"}}, // Zebegény railway station
    {Coordinate{18.8691, 47.8181}, CountryId{"HU"}}, // Szob alsó railway station
    {Coordinate{18.862, 47.8211}, CountryId{"HU"}}, // Szob railway station
    {Coordinate{19.1137, 47.7954}, CountryId{"HU"}}, // Kisvác railway station
    {Coordinate{19.1642, 47.7525}, CountryId{"HU"}}, // Máriaudvar railway station
    {Coordinate{7.01944, 43.5539}, CountryId{"FR"}}, // Gare de Cannes
    {Coordinate{19.154, 47.6018}, CountryId{"HU"}}, // Alagimajor railway station
    {Coordinate{4.51722, 52.2153}, CountryId{"NL"}}, // Sassenheim railway station
    {Coordinate{6.4971, 48.5879}, CountryId{"FR"}}, // Q2186882
    {Coordinate{3.38869, 50.3347}, CountryId{"FR"}}, // Gare de Denain
    {Coordinate{1.54155, 45.5362}, CountryId{"FR"}}, // Gare de Masseret
    {Coordinate{19.1818, 47.6114}, CountryId{"HU"}}, // Fót railway station
    {Coordinate{19.1928, 47.615}, CountryId{"HU"}}, // Fótújfalu railway station
    {Coordinate{19.2008, 47.6217}, CountryId{"HU"}}, // Fótfürdő railway station
    {Coordinate{19.2229, 47.6356}, CountryId{"HU"}}, // Csomád railway station
    {Coordinate{19.2742, 47.6418}, CountryId{"HU"}}, // Ivacs railway station
    {Coordinate{19.2888, 47.6491}, CountryId{"HU"}}, // Veresegyház railway station
    {Coordinate{19.2959, 47.6622}, CountryId{"HU"}}, // Erdőkertes railway station
    {Coordinate{19.2861, 47.6759}, CountryId{"HU"}}, // Vicziántelep railway station
    {Coordinate{19.284, 47.6856}, CountryId{"HU"}}, // Őrbottyán railway station
    {Coordinate{19.2582, 47.7174}, CountryId{"HU"}}, // Rudnaykert railway station
    {Coordinate{19.2495, 47.7253}, CountryId{"HU"}}, // Váchartán railway station
    {Coordinate{19.1963, 47.736}, CountryId{"HU"}}, // Csörög railway station
    {Coordinate{19.2179, 47.7328}, CountryId{"HU"}}, // Vácrátót railway station
    {Coordinate{4.34833, 51.1828}, CountryId{"BE"}}, // Hoboken-Polder railway station
    {Coordinate{19.0683, 47.8182}, CountryId{"HU"}}, // Fenyveshegy railway station
    {Coordinate{2.71111, 49.8225}, CountryId{"FR"}}, // Gare de Rosières
    {Coordinate{3.25001, 48.5135}, CountryId{"FR"}}, // Gare de Longueville
    {Coordinate{21.0815, 46.6697}, CountryId{"HU"}}, // Békéscsaba railway station
    {Coordinate{17.9113, 47.119}, CountryId{"HU"}}, // Veszprém railway station (Jutas)
    {Coordinate{18.1489, 47.1947}, CountryId{"HU"}}, // Várpalota railway station
    {Coordinate{5.23389, 50.5272}, CountryId{"BE"}}, // Huy railway station
    {Coordinate{16.8475, 46.8318}, CountryId{"HU"}}, // Zalaegerszeg railway station
    {Coordinate{16.6326, 47.2374}, CountryId{"HU"}}, // Szombathely railway station
    {Coordinate{18.7128, 46.3493}, CountryId{"HU"}}, // Szekszárd railway station
    {Coordinate{17.1962, 47.0406}, CountryId{"HU"}}, // Ukk railway station
    {Coordinate{7.31389, 50.773}, CountryId{"DE"}}, // Hennef im Siegbogen station
    {Coordinate{2.52611, 48.8833}, CountryId{"FR"}}, // Gare de Gagny
    {Coordinate{4.97321, 43.4966}, CountryId{"FR"}}, // Q2187498
    {Coordinate{19.2058, 47.3894}, CountryId{"HU"}}, // Gyál felső railway station
    {Coordinate{19.2202, 47.376}, CountryId{"HU"}}, // Gyál railway station
    {Coordinate{19.2325, 47.3013}, CountryId{"HU"}}, // Ócsa railway station
    {Coordinate{19.2306, 47.3432}, CountryId{"HU"}}, // Felsőpakony railway station
    {Coordinate{19.3177, 47.2471}, CountryId{"HU"}}, // Inárcs-Kakucs railway station
    {Coordinate{19.3291, 47.1947}, CountryId{"HU"}}, // Dabas railway station
    {Coordinate{19.3514, 47.1806}, CountryId{"HU"}}, // Gyón railway station
    {Coordinate{19.4017, 47.1614}, CountryId{"HU"}}, // Hernád railway station
    {Coordinate{19.4471, 47.133}, CountryId{"HU"}}, // Örkény railway station
    {Coordinate{19.479, 47.0988}, CountryId{"HU"}}, // Táborfalva railway staton
    {Coordinate{19.4983, 47.069}, CountryId{"HU"}}, // Felsőlajos railway station
    {Coordinate{19.5424, 47.0284}, CountryId{"HU"}}, // Lajosmizse railway station
    {Coordinate{19.5502, 47.0228}, CountryId{"HU"}}, // Lajosmizse alsó railway station
    {Coordinate{17.1527, 47.2612}, CountryId{"HU"}}, // Celldömölk railway station
    {Coordinate{17.4591, 47.3406}, CountryId{"HU"}}, // Pápa railway station
    {Coordinate{17.8186, 47.4434}, CountryId{"HU"}}, // Veszprémvarsány railway station
    {Coordinate{17.8779, 47.2667}, CountryId{"HU"}}, // Zirc railway station
    {Coordinate{17.6635, 47.6845}, CountryId{"HU"}}, // Győr-Gyárváros railway station
    {Coordinate{17.6482, 47.6634}, CountryId{"HU"}}, // Győrszabadhegy railway station
    {Coordinate{17.6982, 47.5877}, CountryId{"HU"}}, // Nyúl railway station
    {Coordinate{17.7407, 47.5476}, CountryId{"HU"}}, // Pannonhalma railway station
    {Coordinate{17.7596, 47.53}, CountryId{"HU"}}, // Ravazd railway station
    {Coordinate{17.8177, 47.396}, CountryId{"HU"}}, // Bakonyszentlászló railway station
    {Coordinate{17.8197, 47.3602}, CountryId{"HU"}}, // Vinye railway station
    {Coordinate{17.8414, 47.3269}, CountryId{"HU"}}, // Porva-Csesznek railway station
    {Coordinate{17.9215, 47.1927}, CountryId{"HU"}}, // Eplény railway station
    {Coordinate{17.8118, 47.4161}, CountryId{"HU"}}, // Bakonygyirót railway station
    {Coordinate{17.805, 47.4741}, CountryId{"HU"}}, // Bakonypéterd railway station
    {Coordinate{17.2493, 47.6021}, CountryId{"HU"}}, // Csorna railway station
    {Coordinate{16.8598, 47.5998}, CountryId{"HU"}}, // Fertőszentmiklós railway station
    {Coordinate{16.9289, 47.2589}, CountryId{"HU"}}, // Sárvár railway station
    {Coordinate{17.573, 47.106}, CountryId{"HU"}}, // Ajka railway station
    {Coordinate{16.5766, 46.8456}, CountryId{"HU"}}, // Zalalövő railway station
    {Coordinate{16.833, 47.2388}, CountryId{"HU"}}, // Porpác railway station
    {Coordinate{16.2633, 46.9573}, CountryId{"HU"}}, // Szentgotthárd railway station
    {Coordinate{16.9873, 46.4408}, CountryId{"HU"}}, // Nagykanizsa railway station
    {Coordinate{17.2478, 46.7583}, CountryId{"HU"}}, // Keszthely railway station
    {Coordinate{17.2889, 46.6926}, CountryId{"HU"}}, // Balatonszentgyörgy railway station
    {Coordinate{17.5564, 46.7497}, CountryId{"HU"}}, // Fonyód railway station
    {Coordinate{18.0535, 46.9076}, CountryId{"HU"}}, // Siófok railway station
    {Coordinate{17.4288, 46.877}, CountryId{"HU"}}, // Tapolca railway station
    {Coordinate{18.6014, 46.814}, CountryId{"HU"}}, // Rétszilas railway station
    {Coordinate{18.388, 47.1055}, CountryId{"HU"}}, // Szabadbattyán railway station
    {Coordinate{18.6187, 47.4841}, CountryId{"HU"}}, // Bicske railway station
    {Coordinate{18.965, 47.4475}, CountryId{"HU"}}, // Budaörs railway station
    {Coordinate{18.9096, 47.45}, CountryId{"HU"}}, // Törökbálint railway station
    {Coordinate{18.834, 47.4805}, CountryId{"HU"}}, // Biatorbágy railway station
    {Coordinate{18.7449, 47.4939}, CountryId{"HU"}}, // Herceghalom railway station
    {Coordinate{18.6433, 47.4867}, CountryId{"HU"}}, // Bicske alsó railway station
    {Coordinate{18.5276, 47.4851}, CountryId{"HU"}}, // Szár railway station
    {Coordinate{18.4958, 47.5183}, CountryId{"HU"}}, // Szárliget railway station
    {Coordinate{18.4245, 47.5634}, CountryId{"HU"}}, // Alsógalla railway station
    {Coordinate{18.3757, 47.6188}, CountryId{"HU"}}, // Vértesszőlős railway station
    {Coordinate{18.348, 47.647}, CountryId{"HU"}}, // Tóvároskert railway station
    {Coordinate{18.262, 47.7253}, CountryId{"HU"}}, // Almásfüzitő railway station
    {Coordinate{18.217, 47.7313}, CountryId{"HU"}}, // Almásfüzitő felső railway station
    {Coordinate{18.1771, 47.7357}, CountryId{"HU"}}, // Szőny railway station
    {Coordinate{17.8699, 47.7054}, CountryId{"HU"}}, // Nagyszentjános railway station
    {Coordinate{17.7461, 47.6888}, CountryId{"HU"}}, // Győrszentiván railway station
    {Coordinate{18.8744, 47.3658}, CountryId{"HU"}}, // Tárnok railway station
    {Coordinate{18.7813, 47.3206}, CountryId{"HU"}}, // Martonvásár railway station
    {Coordinate{18.7549, 47.2984}, CountryId{"HU"}}, // Baracska railway station
    {Coordinate{18.7131, 47.2627}, CountryId{"HU"}}, // Pettend railway station
    {Coordinate{18.6927, 47.2454}, CountryId{"HU"}}, // Kápolnásnyék railway station
    {Coordinate{18.6638, 47.2269}, CountryId{"HU"}}, // Velence railway station
    {Coordinate{18.6482, 47.2186}, CountryId{"HU"}}, // Velencefürdő railway station
    {Coordinate{18.6247, 47.206}, CountryId{"HU"}}, // Gárdony railway station
    {Coordinate{18.6062, 47.1982}, CountryId{"HU"}}, // Agárd railway station
    {Coordinate{18.5626, 47.1804}, CountryId{"HU"}}, // Dinnyés railway station
    {Coordinate{18.9371, 47.3896}, CountryId{"HU"}}, // Érdliget railway station
    {Coordinate{18.9228, 47.3813}, CountryId{"HU"}}, // Érd felső railway station
    {Coordinate{18.9011, 47.37}, CountryId{"HU"}}, // Érd railway station
    {Coordinate{18.8989, 47.3225}, CountryId{"HU"}}, // Százhalombatta railway station
    {Coordinate{18.8789, 47.2944}, CountryId{"HU"}}, // Dunai Finomító railway station
    {Coordinate{18.8755, 47.2472}, CountryId{"HU"}}, // Ercsi railway station
    {Coordinate{18.8121, 47.1778}, CountryId{"HU"}}, // Iváncsa railway station
    {Coordinate{19.3386, 47.4936}, CountryId{"HU"}}, // Pécel railway station
    {Coordinate{19.3901, 47.5351}, CountryId{"HU"}}, // Isaszeg railway station
    {Coordinate{19.3896, 47.5957}, CountryId{"HU"}}, // Máriabesnyő railway station
    {Coordinate{19.4718, 47.6412}, CountryId{"HU"}}, // Bag railway station
    {Coordinate{19.4924, 47.6478}, CountryId{"HU"}}, // Aszód railway station
    {Coordinate{19.5585, 47.6324}, CountryId{"HU"}}, // Galgahévíz railway station
    {Coordinate{19.5972, 47.6264}, CountryId{"HU"}}, // Tura railway station
    {Coordinate{19.0496, 47.9401}, CountryId{"HU"}}, // Diósjenő railway station
    {Coordinate{18.4067, 47.1589}, CountryId{"HU"}}, // Székesfehérvár-Repülőtér railway station
    {Coordinate{18.1708, 46.9843}, CountryId{"HU"}}, // Balatonaliga railway station
    {Coordinate{18.018, 46.8979}, CountryId{"HU"}}, // Balatonszéplak felső railway station
    {Coordinate{17.9933, 46.8919}, CountryId{"HU"}}, // Balatonszéplak alsó railway station
    {Coordinate{17.9697, 46.886}, CountryId{"HU"}}, // Zamárdi felső railway station
    {Coordinate{17.9448, 46.8799}, CountryId{"HU"}}, // Zamárdi railway station
    {Coordinate{17.8995, 46.8623}, CountryId{"HU"}}, // Szántód-Kőröshegy railway station
    {Coordinate{17.8799, 46.8533}, CountryId{"HU"}}, // Balatonföldvár railway station
    {Coordinate{17.8304, 46.8321}, CountryId{"HU"}}, // Balatonszárszó railway station
    {Coordinate{17.7765, 46.8119}, CountryId{"HU"}}, // Balatonszemes railway station
    {Coordinate{17.7201, 46.7947}, CountryId{"HU"}}, // Balatonlelle felső railway station
    {Coordinate{17.6945, 46.7875}, CountryId{"HU"}}, // Balatonlelle railway station
    {Coordinate{17.6472, 46.7761}, CountryId{"HU"}}, // Balatonboglár railway station
    {Coordinate{17.5926, 46.7592}, CountryId{"HU"}}, // Fonyódliget railway station
    {Coordinate{17.5349, 46.7376}, CountryId{"HU"}}, // Bélatelep railway station
    {Coordinate{17.5163, 46.7242}, CountryId{"HU"}}, // Alsóbélatelep railway station
    {Coordinate{17.4826, 46.7136}, CountryId{"HU"}}, // Balatonfenyves railway station
    {Coordinate{17.4538, 46.7083}, CountryId{"HU"}}, // Balatonfenyves alsó railway station
    {Coordinate{17.4349, 46.7049}, CountryId{"HU"}}, // Máriahullámtelep railway station
    {Coordinate{17.3753, 46.7042}, CountryId{"HU"}}, // Balatonmáriafürdő railway station
    {Coordinate{17.3172, 46.7138}, CountryId{"HU"}}, // Balatonberény railway station
    {Coordinate{19.4939, 46.4338}, CountryId{"HU"}}, // Kiskunhalas railway station
    {Coordinate{19.6103, 46.1948}, CountryId{"HU"}}, // Kelebia railway station
    {Coordinate{20.1602, 46.2419}, CountryId{"HU"}}, // Újszeged railway station
    {Coordinate{18.7156, 46.2025}, CountryId{"HU"}}, // Bátaszék railway station
    {Coordinate{18.9573, 46.1872}, CountryId{"HU"}}, // Baja railway station
    {Coordinate{18.914, 46.9607}, CountryId{"HU"}}, // Dunaújváros railway station
    {Coordinate{20.0667, 47.2858}, CountryId{"HU"}}, // Újszász railway station
    {Coordinate{19.9373, 47.7831}, CountryId{"HU"}}, // Gyöngyös railway station
    {Coordinate{20.4127, 47.7507}, CountryId{"HU"}}, // Füzesabony railway station
    {Coordinate{20.3816, 47.8918}, CountryId{"HU"}}, // Eger railway station
    {Coordinate{20.254, 47.7341}, CountryId{"HU"}}, // Kál-Kápolna railway station
    {Coordinate{21.7062, 47.9453}, CountryId{"HU"}}, // Nyíregyháza railway station
    {Coordinate{22.1838, 48.4019}, CountryId{"HU"}}, // Záhony railway station
    {Coordinate{21.1287, 47.3278}, CountryId{"HU"}}, // Püspökladány railway station
    {Coordinate{21.7219, 47.1355}, CountryId{"HU"}}, // Biharkeresztes raiway station
    {Coordinate{21.2632, 46.9391}, CountryId{"HU"}}, // Vésztő railway station
    {Coordinate{21.2733, 46.6564}, CountryId{"HU"}}, // Gyula railway station
    {Coordinate{20.8209, 46.9272}, CountryId{"HU"}}, // Gyoma railway station
    {Coordinate{20.93, 46.8623}, CountryId{"HU"}}, // Csárdaszállás railway station
    {Coordinate{20.7607, 46.5969}, CountryId{"HU"}}, // Orosházi tanyák railway station
    {Coordinate{20.3399, 46.4133}, CountryId{"HU"}}, // Hódmezővásárhely railway station
    {Coordinate{17.307, 46.2891}, CountryId{"HU"}}, // Somogyszob railway station
    {Coordinate{17.9907, 46.0331}, CountryId{"HU"}}, // Szentlőrinc railway station
    {Coordinate{18.4515, 45.8773}, CountryId{"HU"}}, // Villány railway station
    {Coordinate{18.3088, 47.487}, CountryId{"HU"}}, // Oroszlány railway station
    {Coordinate{18.372, 47.5738}, CountryId{"HU"}}, // Bánhida railway station
    {Coordinate{18.3337, 47.5429}, CountryId{"HU"}}, // Környe railway station
    {Coordinate{18.317, 47.5208}, CountryId{"HU"}}, // Kecskéd alsó railway station
    {Coordinate{-2.43267, 47.2826}, CountryId{"FR"}}, // Le Pouliguen train station
    {Coordinate{1.8, 42.5889}, CountryId{"FR"}}, // Gare d'Andorre-L'Hospitalet
    {Coordinate{2.99318, 48.8085}, CountryId{"FR"}}, // Q2187977
    {Coordinate{-0.0769444, 49.3}, CountryId{"FR"}}, // Gare de Houlgate
    {Coordinate{5.99333, 50.89}, CountryId{"NL"}}, // Heerlen de Kissel railway station
    {Coordinate{0.116578, 46.4357}, CountryId{"FR"}}, // Q2188462
    {Coordinate{-0.120914, 48.7151}, CountryId{"FR"}}, // Écouché
    {Coordinate{17.7888, 47.5047}, CountryId{"HU"}}, // Tarjánpuszta railway station
    {Coordinate{17.7989, 47.494}, CountryId{"HU"}}, // Győrasszonyfa railway station
    {Coordinate{79.5552, 11.7732}, CountryId{"IN"}}, // Panruti railway station
    {Coordinate{13.9286, 49.8683}, CountryId{"CZ"}}, // Q2188706
    {Coordinate{16.637, 47.6327}, CountryId{"HU"}}, // Kópháza railway station
    {Coordinate{16.6901, 47.6011}, CountryId{"HU"}}, // Nagycenk railway station
    {Coordinate{16.7486, 47.5475}, CountryId{"HU"}}, // Sopronkövesd railway station
    {Coordinate{16.7773, 47.5097}, CountryId{"HU"}}, // Lövő railway station
    {Coordinate{16.7866, 47.4579}, CountryId{"HU"}}, // Újkér railway station
    {Coordinate{16.7817, 47.4303}, CountryId{"HU"}}, // Tormásliget railway station
    {Coordinate{16.7522, 47.3886}, CountryId{"HU"}}, // Bük railway station
    {Coordinate{16.7347, 47.3084}, CountryId{"HU"}}, // Acsád railway station
    {Coordinate{16.7038, 47.2911}, CountryId{"HU"}}, // Salköveskút-Vassurány railway station
    {Coordinate{16.5974, 47.0161}, CountryId{"HU"}}, // Körmend railway station
    {Coordinate{16.6418, 47.2065}, CountryId{"HU"}}, // Szombathely-Szőlős railway station
    {Coordinate{16.6303, 47.1614}, CountryId{"HU"}}, // Ják-Balogunyom railway station
    {Coordinate{16.6197, 47.091}, CountryId{"HU"}}, // Egyházasrádóc railway station
    {Coordinate{16.5437, 47.0052}, CountryId{"HU"}}, // Horvátnádalja railway station
    {Coordinate{16.4997, 46.9783}, CountryId{"HU"}}, // Csákánydoroszló railway station
    {Coordinate{16.433, 46.9676}, CountryId{"HU"}}, // Rátót railway station
    {Coordinate{16.3782, 46.9643}, CountryId{"HU"}}, // Alsórönök railway station
    {Coordinate{16.2824, 46.9646}, CountryId{"HU"}}, // Haris railway station
    {Coordinate{-0.391459, 43.2343}, CountryId{"FR"}}, // Gare de Gan
    {Coordinate{16.727, 47.236}, CountryId{"HU"}}, // Vép railway station
    {Coordinate{16.8431, 47.3006}, CountryId{"HU"}}, // Ölbő-Alsószeleste railway station
    {Coordinate{2.72833, 48.7453}, CountryId{"FR"}}, // Gretz-Armainvilliers Station
    {Coordinate{5.86222, 51.0603}, CountryId{"NL"}}, // Susteren railway station
    {Coordinate{17.5231, 47.6576}, CountryId{"HU"}}, // Ikrény railway station
    {Coordinate{17.463, 47.6491}, CountryId{"HU"}}, // Rábapatona stop
    {Coordinate{17.4248, 47.6442}, CountryId{"HU"}}, // Enese railway station
    {Coordinate{17.1616, 47.5928}, CountryId{"HU"}}, // Rábatamási railway station
    {Coordinate{17.1961, 47.596}, CountryId{"HU"}}, // Farád railway station
    {Coordinate{17.3573, 47.6323}, CountryId{"HU"}}, // Kóny railway station
    {Coordinate{17.123, 47.5893}, CountryId{"HU"}}, // Szárföld railway station
    {Coordinate{17.0999, 47.5871}, CountryId{"HU"}}, // Veszkény railway station
    {Coordinate{17.048, 47.5819}, CountryId{"HU"}}, // Kapuvár railway station
    {Coordinate{16.9868, 47.5821}, CountryId{"HU"}}, // Vitnyéd-Csermajor railway station
    {Coordinate{16.8895, 47.5957}, CountryId{"HU"}}, // Petőháza railway station
    {Coordinate{16.769, 47.6002}, CountryId{"HU"}}, // Pinnye railway station
    {Coordinate{16.6916, 47.6251}, CountryId{"HU"}}, // Fertőboz railway station
    {Coordinate{16.8507, 47.618}, CountryId{"HU"}}, // Fertőszéplak-Fertőd railway station
    {Coordinate{16.9034, 47.7041}, CountryId{"AT"}}, // Bahnhof Pamhagen
    {Coordinate{5.11278, 51.1903}, CountryId{"BE"}}, // Mol railway station
    {Coordinate{-0.698056, 49.2697}, CountryId{"FR"}}, // Gare de Bayeux
    {Coordinate{17.2078, 47.9734}, CountryId{"HU"}}, // Bezenye railway station
    {Coordinate{17.1922, 47.8898}, CountryId{"HU"}}, // Levél railway station
    {Coordinate{17.5407, 47.6907}, CountryId{"HU"}}, // Abda railway station
    {Coordinate{17.4891, 47.7198}, CountryId{"HU"}}, // Öttevény railway station
    {Coordinate{17.4253, 47.7558}, CountryId{"HU"}}, // Lébény-Mosonszentmiklós railway station
    {Coordinate{17.3419, 47.8045}, CountryId{"HU"}}, // Kimle-Károlyháza railway station
    {Coordinate{17.2664, 47.8506}, CountryId{"HU"}}, // Mosonmagyaróvár railway station
    {Coordinate{6.8887, 45.9396}, CountryId{"FR"}}, // Gare des Praz-de-Chamonix
    {Coordinate{2.39806, 49.8461}, CountryId{"FR"}}, // Gare de Boves
    {Coordinate{3.09062, 45.768}, CountryId{"FR"}}, // Q2189379
    {Coordinate{15.2953, 50.0108}, CountryId{"CZ"}}, // Station Starý Kolín
    {Coordinate{1.55278, 49.9819}, CountryId{"FR"}}, // Gare de Longroy-Gamaches
    {Coordinate{3.50245, 50.3299}, CountryId{"FR"}}, // Poirier-Université
    {Coordinate{21.2353, 47.2998}, CountryId{"HU"}}, // Báránd railway station
    {Coordinate{21.5321, 47.2122}, CountryId{"HU"}}, // Berettyóújfalu railway station
    {Coordinate{21.6256, 47.1762}, CountryId{"HU"}}, // Mezőpeterd railway station
    {Coordinate{21.3608, 47.2597}, CountryId{"HU"}}, // Sáp railway station
    {Coordinate{7.71804, 48.666}, CountryId{"FR"}}, // Vendenheim
    {Coordinate{9.38506, 41.1811}, CountryId{"IT"}}, // Q21903489
    {Coordinate{5.34892, 50.9896}, CountryId{"BE"}}, // Zonhoven railway station
    {Coordinate{6.4414, 48.178}, CountryId{"FR"}}, // Épinal railway station
    {Coordinate{4.65111, 50.7997}, CountryId{"BE"}}, // Sint-Joris-Weert railway station
    {Coordinate{3.03205, 50.4453}, CountryId{"FR"}}, // Ostricourt
    {Coordinate{3.05702, 44.3247}, CountryId{"FR"}}, // Q2191151
    {Coordinate{6.07278, 51.9231}, CountryId{"NL"}}, // Zevenaar railway station
    {Coordinate{2.43028, 48.9105}, CountryId{"FR"}}, // Gare de Bobigny
    {Coordinate{21.1481, 47.0152}, CountryId{"HU"}}, // Szeghalom railway station
    {Coordinate{21.0858, 46.9701}, CountryId{"HU"}}, // Körösladány railway station
    {Coordinate{20.9437, 47.0343}, CountryId{"HU"}}, // Dévaványa railway station
    {Coordinate{20.7457, 46.9768}, CountryId{"HU"}}, // Nagylapos railway station
    {Coordinate{4.69528, 50.8625}, CountryId{"BE"}}, // Heverlee railway station
    {Coordinate{-4.09222, 47.9947}, CountryId{"FR"}}, // Gare de Quimper
    {Coordinate{-1.31393, 47.8321}, CountryId{"FR"}}, // Q2191724
    {Coordinate{0.81022, 48.3261}, CountryId{"FR"}}, // Q2192067
    {Coordinate{-0.930065, 45.6666}, CountryId{"FR"}}, // Saujon
    {Coordinate{19.2564, 47.4085}, CountryId{"HU"}}, // Vecsés railway station
    {Coordinate{19.2728, 47.4033}, CountryId{"HU"}}, // Vecsés-Kertekalja railway station
    {Coordinate{19.3509, 47.3908}, CountryId{"HU"}}, // Üllő railway station
    {Coordinate{19.3902, 47.3703}, CountryId{"HU"}}, // Hosszúberek-Péteri railway station
    {Coordinate{19.4373, 47.3451}, CountryId{"HU"}}, // Monor railway station
    {Coordinate{19.4999, 47.3085}, CountryId{"HU"}}, // Monorierdő railway station
    {Coordinate{19.5371, 47.2794}, CountryId{"HU"}}, // Pilis railway station
    {Coordinate{19.6068, 47.24}, CountryId{"HU"}}, // Q21921442
    {Coordinate{19.6577, 47.2163}, CountryId{"HU"}}, // Q21921444
    {Coordinate{19.6861, 47.2108}, CountryId{"HU"}}, // Ceglédbercel-Cserő railway station
    {Coordinate{19.7324, 47.2084}, CountryId{"HU"}}, // Budai út railway station
    {Coordinate{20.0161, 47.1732}, CountryId{"HU"}}, // Abony railway station
    {Coordinate{30.4717, 60.0944}, CountryId{"RU"}}, // Kapitolovo
    {Coordinate{20.2953, 47.1704}, CountryId{"HU"}}, // Szajol railway station
    {Coordinate{20.3696, 47.1357}, CountryId{"HU"}}, // Tiszatenyő railway station
    {Coordinate{20.4112, 47.1696}, CountryId{"HU"}}, // Törökszentmiklós railway station
    {Coordinate{30.1139, 60.6319}, CountryId{"RU"}}, // Q219220
    {Coordinate{30.5088, 60.1492}, CountryId{"RU"}}, // Toksovo station
    {Coordinate{0.0841667, 49.36}, CountryId{"FR"}}, // Gare de Trouville-Deauville
    {Coordinate{1.26417, 43.9239}, CountryId{"FR"}}, // Gare de Montbartier
    {Coordinate{20.4878, 47.077}, CountryId{"HU"}}, // Kétpó railway station
    {Coordinate{20.5414, 47.0503}, CountryId{"HU"}}, // Csugar railway station
    {Coordinate{20.4558, 47.093}, CountryId{"HU"}}, // Pusztapó railway station
    {Coordinate{20.6195, 47.0135}, CountryId{"HU"}}, // Mezőtúr railway station
    {Coordinate{21.0129, 46.8147}, CountryId{"HU"}}, // Mezőberény station
    {Coordinate{21.038, 46.757}, CountryId{"HU"}}, // Q21923133
    {Coordinate{21.2376, 46.4321}, CountryId{"HU"}}, // Lőkösháza railway station
    {Coordinate{21.1718, 46.5326}, CountryId{"HU"}}, // Q21923139
    {Coordinate{20.1251, 47.2066}, CountryId{"HU"}}, // Abonyi út railway station
    {Coordinate{20.0974, 47.2443}, CountryId{"HU"}}, // Zagyvarékas railway station
    {Coordinate{2.47627, 46.3715}, CountryId{"FR"}}, // Q2192387
    {Coordinate{19.3148, 47.4406}, CountryId{"HU"}}, // Ecser railway station
    {Coordinate{19.3407, 47.4389}, CountryId{"HU"}}, // Maglód railway station
    {Coordinate{19.3635, 47.4342}, CountryId{"HU"}}, // Maglódi nyaraló railway station
    {Coordinate{19.3939, 47.4296}, CountryId{"HU"}}, // Gyömrő railway station
    {Coordinate{19.4398, 47.4267}, CountryId{"HU"}}, // Mende railway station
    {Coordinate{19.4707, 47.4396}, CountryId{"HU"}}, // Pusztaszenistván railway station
    {Coordinate{19.5271, 47.4518}, CountryId{"HU"}}, // Sülysáp railway station
    {Coordinate{19.5594, 47.4507}, CountryId{"HU"}}, // Szőlősnyaraló railway station
    {Coordinate{19.6205, 47.4413}, CountryId{"HU"}}, // Tápiószecső railway station
    {Coordinate{19.6798, 47.4322}, CountryId{"HU"}}, // Szentmártonkáta railway station
    {Coordinate{19.7376, 47.4099}, CountryId{"HU"}}, // Nagykáta railway station
    {Coordinate{19.7974, 47.3737}, CountryId{"HU"}}, // Tápiószentmárton railway station
    {Coordinate{19.8374, 47.3554}, CountryId{"HU"}}, // Farmos railway station
    {Coordinate{19.8737, 47.3462}, CountryId{"HU"}}, // Tápiószele railway station
    {Coordinate{19.9494, 47.325}, CountryId{"HU"}}, // Tápiógyörgye railway station
    {Coordinate{19.7602, 47.0382}, CountryId{"HU"}}, // Nagykőrös railway station
    {Coordinate{2.0763, 50.8755}, CountryId{"FR"}}, // Gare d'Audruicq
    {Coordinate{6.663, 50.698}, CountryId{"DE"}}, // Zülpich
    {Coordinate{2.18783, 48.8121}, CountryId{"FR"}}, // Gare de Chaville-Rive-Droite
    {Coordinate{3.27056, 49.6922}, CountryId{"FR"}}, // Gare de Mennessis
    {Coordinate{5.82861, 49.5633}, CountryId{"BE"}}, // Athus railway station
    {Coordinate{14.5433, 53.5878}, CountryId{"PL"}}, // Q2194143
    {Coordinate{5.41111, 53.1747}, CountryId{"NL"}}, // Harlingen Haven railway station
    {Coordinate{-0.627669, 44.8426}, CountryId{"FR"}}, // gare de Caudéran - Mérignac
    {Coordinate{19.8925, 47.4955}, CountryId{"HU"}}, // Jászberény railway station
    {Coordinate{19.7943, 47.5642}, CountryId{"HU"}}, // Pusztamonostor railway station
    {Coordinate{19.9395, 47.4411}, CountryId{"HU"}}, // Meggyespele railway station
    {Coordinate{19.7542, 47.5931}, CountryId{"HU"}}, // Jászfényszaru railway station
    {Coordinate{0.908147, 44.8471}, CountryId{"FR"}}, // Gare du Buisson
    {Coordinate{19.9587, 47.418}, CountryId{"HU"}}, // Portelek railway station
    {Coordinate{20.001, 47.3675}, CountryId{"HU"}}, // Jászboldogháza-Jánoshida railway station
    {Coordinate{-1.65431, 48.2395}, CountryId{"FR"}}, // Gare de Saint-Germain-sur-Ille
    {Coordinate{10.846, 44.5777}, CountryId{"IT"}}, // Formigine railway station
    {Coordinate{4.22139, 51.1261}, CountryId{"BE"}}, // Temse railway station
    {Coordinate{4.54947, 50.6935}, CountryId{"BE"}}, // Profondsart railway station
    {Coordinate{1.78556, 50.8731}, CountryId{"FR"}}, // Gare de Pihen
    {Coordinate{5.96118, 46.1447}, CountryId{"FR"}}, // Pougny - Chancy
    {Coordinate{5.8251, 43.1225}, CountryId{"FR"}}, // Q2195891
    {Coordinate{3.06666, 46.1993}, CountryId{"FR"}}, // Gare de Bellenaves
    {Coordinate{2.19139, 48.7047}, CountryId{"FR"}}, // Gare du Guichet
    {Coordinate{4.46694, 51.3908}, CountryId{"BE"}}, // Kalmthout railway station
    {Coordinate{28.2339, 59.3678}, CountryId{"RU"}}, // Ivangorod railway station
    {Coordinate{2.70417, 48.2294}, CountryId{"FR"}}, // Gare de Bagneaux-sur-Loing
    {Coordinate{4.76264, 50.4432}, CountryId{"BE"}}, // Floreffe railway station
    {Coordinate{10.736, 44.5854}, CountryId{"IT"}}, // Casalgrande railway station
    {Coordinate{1.53694, 50.0589}, CountryId{"FR"}}, // Gare de Woincourt
    {Coordinate{10.694, 44.6004}, CountryId{"IT"}}, // Scandiano railway station
    {Coordinate{24.3167, 49.4}, CountryId{"UA"}}, // Q21980526
    {Coordinate{4.81111, 52.8669}, CountryId{"NL"}}, // Anna Paulowna railway station
    {Coordinate{3.44909, 51.092}, CountryId{"BE"}}, // Aalter railway station
    {Coordinate{0.329707, 43.1035}, CountryId{"FR"}}, // Gare de Capvern
    {Coordinate{24.4159, 59.3061}, CountryId{"EE"}}, // Q2198819
    {Coordinate{19.8343, 46.7071}, CountryId{"HU"}}, // Kiskunfélegyháza railway station
    {Coordinate{7.57224, 48.7552}, CountryId{"FR"}}, // Q2198911
    {Coordinate{2.40306, 48.7122}, CountryId{"FR"}}, // gare d'Athis-Mons
    {Coordinate{16.3718, 39.0808}, CountryId{"IT"}}, // Soveria Mannelli
    {Coordinate{20.044, 46.3457}, CountryId{"HU"}}, // Szatymaz railway station
    {Coordinate{2.43361, 48.7653}, CountryId{"FR"}}, // gare de Villeneuve-Prairie
    {Coordinate{20.541, 46.5041}, CountryId{"HU"}}, // Székkutas railway station
    {Coordinate{19.909, 46.5383}, CountryId{"HU"}}, // Csengele railway station
    {Coordinate{4.06479, 48.2959}, CountryId{"FR"}}, // Gare de Troyes
    {Coordinate{18.6474, 47.7414}, CountryId{"HU"}}, // Q21996736
    {Coordinate{18.6747, 47.7346}, CountryId{"HU"}}, // Q21996752
    {Coordinate{18.5616, 47.7612}, CountryId{"HU"}}, // Q21996758
    {Coordinate{18.5408, 47.7624}, CountryId{"HU"}}, // Q21996760
    {Coordinate{18.53, 47.7555}, CountryId{"HU"}}, // Q21996765
    {Coordinate{18.4779, 47.7532}, CountryId{"HU"}}, // Q21996775
    {Coordinate{18.4376, 47.7569}, CountryId{"HU"}}, // Q21996776
    {Coordinate{18.5147, 47.7522}, CountryId{"HU"}}, // Lábatlan railway station
    {Coordinate{18.4549, 47.7613}, CountryId{"HU"}}, // Q21996779
    {Coordinate{18.3679, 47.7375}, CountryId{"HU"}}, // Q21996780
    {Coordinate{18.3452, 47.7344}, CountryId{"HU"}}, // Q21996781
    {Coordinate{18.3262, 47.733}, CountryId{"HU"}}, // Dunaalmás railway station
    {Coordinate{18.2479, 47.3172}, CountryId{"HU"}}, // Bodajk railway station
    {Coordinate{18.0507, 47.6309}, CountryId{"HU"}}, // Nagyigmánd-Bábolna railway station
    {Coordinate{18.0249, 47.4942}, CountryId{"HU"}}, // Kisbér railway station
    {Coordinate{18.1032, 47.4439}, CountryId{"HU"}}, // Bakonysárkány railway station
    {Coordinate{18.1887, 47.3695}, CountryId{"HU"}}, // Mór railway station
    {Coordinate{18.2376, 47.3299}, CountryId{"HU"}}, // Csókakő railway station
    {Coordinate{18.1432, 47.7369}, CountryId{"HU"}}, // Szőny-Déli railway station
    {Coordinate{18.9239, 47.3799}, CountryId{"HU"}}, // Érd alsó railway station
    {Coordinate{18.8479, 47.1062}, CountryId{"HU"}}, // Adony railway station
    {Coordinate{18.8974, 47.051}, CountryId{"HU"}}, // Kulcs railway station
    {Coordinate{18.9098, 47.0243}, CountryId{"HU"}}, // Rácalmás railway station
    {Coordinate{18.9036, 46.9829}, CountryId{"HU"}}, // Dunaújváros külső railway station
    {Coordinate{18.6128, 47.1193}, CountryId{"HU"}}, // Seregélyes-Szőlőhegy railway station
    {Coordinate{18.5816, 47.1209}, CountryId{"HU"}}, // Seregélyes train station
    {Coordinate{18.5151, 47.1401}, CountryId{"HU"}}, // Börgönd railway station
    {Coordinate{18.6119, 46.8968}, CountryId{"HU"}}, // Sárbogárd railway station
    {Coordinate{18.4997, 47.1029}, CountryId{"HU"}}, // Belsőbáránd railway station
    {Coordinate{18.5424, 47.0237}, CountryId{"HU"}}, // Aba-Sárkereszúr railway station
    {Coordinate{18.6236, 46.7723}, CountryId{"HU"}}, // Cece railway station
    {Coordinate{18.648, 46.7142}, CountryId{"HU"}}, // Vajta railway station
    {Coordinate{18.7289, 46.3809}, CountryId{"HU"}}, // Szekszárd-Palánk railway station
    {Coordinate{18.6497, 46.6154}, CountryId{"HU"}}, // Nagydorog railway station
    {Coordinate{18.6951, 46.5158}, CountryId{"HU"}}, // Tengelic railway station
    {Coordinate{18.7358, 46.4489}, CountryId{"HU"}}, // Fácánkert railway station
    {Coordinate{18.7501, 46.4148}, CountryId{"HU"}}, // Tolna-Mözs railway station
    {Coordinate{18.7425, 46.3188}, CountryId{"HU"}}, // Őcsény railway station
    {Coordinate{18.7561, 46.2838}, CountryId{"HU"}}, // Decs railway station
    {Coordinate{18.7382, 46.1994}, CountryId{"HU"}}, // Alsónyék railway station
    {Coordinate{18.8279, 46.1991}, CountryId{"HU"}}, // Pörböly railway station
    {Coordinate{18.9211, 46.1931}, CountryId{"HU"}}, // Baja-Dunafürdő railway station
    {Coordinate{18.1528, 46.3371}, CountryId{"HU"}}, // Csikóstőttős railway station
    {Coordinate{18.2222, 46.3103}, CountryId{"HU"}}, // Mágocs-Alsómocsolád railway station
    {Coordinate{18.289, 46.2846}, CountryId{"HU"}}, // Szalatnak railway station
    {Coordinate{18.3698, 46.2874}, CountryId{"HU"}}, // Szászvár railway station
    {Coordinate{18.409, 46.2791}, CountryId{"HU"}}, // Máza-Szászvár railway station
    {Coordinate{18.4368, 46.2811}, CountryId{"HU"}}, // Váralja railway station
    {Coordinate{18.4571, 46.2796}, CountryId{"HU"}}, // Nagymányok railway station
    {Coordinate{18.5233, 46.2691}, CountryId{"HU"}}, // Hidas-Bonyhád railway station
    {Coordinate{18.5574, 46.2635}, CountryId{"HU"}}, // Cikó railway station
    {Coordinate{18.5945, 46.257}, CountryId{"HU"}}, // Mőcsény railway station
    {Coordinate{6.36617, 46.2701}, CountryId{"FR"}}, // Gare de Bons-en-Chablais
    {Coordinate{18.1431, 46.3309}, CountryId{"HU"}}, // Kaposszekcső railway station
    {Coordinate{18.1387, 46.3102}, CountryId{"HU"}}, // Vásárosdombó railway station
    {Coordinate{18.1045, 46.2572}, CountryId{"HU"}}, // Sásd railway station
    {Coordinate{18.1047, 46.2233}, CountryId{"HU"}}, // Godisa railway station
    {Coordinate{18.0838, 46.2026}, CountryId{"HU"}}, // Szatina-Kishajmás railway station
    {Coordinate{18.0753, 46.1527}, CountryId{"HU"}}, // Abaliget railway station
    {Coordinate{18.045, 46.1282}, CountryId{"HU"}}, // Hethehely railway station
    {Coordinate{17.9874, 46.0855}, CountryId{"HU"}}, // Cserdi-Helesfa railway station
    {Coordinate{17.9994, 46.113}, CountryId{"HU"}}, // Bükkösd railway station
    {Coordinate{18.054, 46.041}, CountryId{"HU"}}, // Bicsérd railway station
    {Coordinate{18.1521, 46.0602}, CountryId{"HU"}}, // Mecsekalja-Cserkút railway station
    {Coordinate{18.5891, 46.7826}, CountryId{"HU"}}, // Q21999784
    {Coordinate{5.76494, 46.9125}, CountryId{"FR"}}, // Q2199980
    {Coordinate{18.5408, 46.7565}, CountryId{"HU"}}, // Simontornya railway station
    {Coordinate{8.73972, 50.105}, CountryId{"DE"}}, // Offenbach-Kaiserlei station
    {Coordinate{6.42513, 51.3679}, CountryId{"DE"}}, // Bahnhof Kempen
    {Coordinate{2.27067, 48.8394}, CountryId{"FR"}}, // Gare du Pont du Garigliano
    {Coordinate{6.46639, 51.1033}, CountryId{"DE"}}, // Hochneukirch station
    {Coordinate{18.4774, 46.7289}, CountryId{"HU"}}, // Q22002084
    {Coordinate{18.4301, 46.6812}, CountryId{"HU"}}, // Q22002085
    {Coordinate{18.4113, 46.6396}, CountryId{"HU"}}, // Q22002086
    {Coordinate{18.4264, 46.5973}, CountryId{"HU"}}, // Q22002087
    {Coordinate{18.4204, 46.5753}, CountryId{"HU"}}, // Q22002088
    {Coordinate{18.3963, 46.5688}, CountryId{"HU"}}, // Q22002090
    {Coordinate{18.3893, 46.5238}, CountryId{"HU"}}, // Q22002091
    {Coordinate{18.3356, 46.4662}, CountryId{"HU"}}, // Q22002092
    {Coordinate{18.3184, 46.4503}, CountryId{"HU"}}, // Q22002093
    {Coordinate{18.253, 46.4164}, CountryId{"HU"}}, // Q22002094
    {Coordinate{18.3774, 46.4942}, CountryId{"HU"}}, // Q22002127
    {Coordinate{18.7044, 47.0827}, CountryId{"HU"}}, // Szabadegyháza railway station
    {Coordinate{18.6602, 47.0396}, CountryId{"HU"}}, // Sárosd railway station
    {Coordinate{18.6357, 46.9793}, CountryId{"HU"}}, // Nagylók railway station
    {Coordinate{17.8592, 45.8732}, CountryId{"HU"}}, // Sellye railway station
    {Coordinate{17.8523, 45.9048}, CountryId{"HU"}}, // Kákics railway station
    {Coordinate{17.8649, 45.9338}, CountryId{"HU"}}, // Okorág-Kárászpuszta railway station
    {Coordinate{17.9117, 45.9607}, CountryId{"HU"}}, // Sumony railway station
    {Coordinate{17.9569, 45.983}, CountryId{"HU"}}, // Gyöngyfa-Magyarmecske railway station
    {Coordinate{17.9723, 45.9894}, CountryId{"HU"}}, // Királyegyháza-Rigópuszta railway station
    {Coordinate{18.2401, 46.0717}, CountryId{"HU"}}, // Pécs-Külváros railway station
    {Coordinate{18.2701, 46.064}, CountryId{"HU"}}, // Pécsbánya-Rendező railway station
    {Coordinate{18.2755, 46.0093}, CountryId{"HU"}}, // Pécsudvard railway station
    {Coordinate{18.2906, 45.967}, CountryId{"HU"}}, // Szőkéd railway station
    {Coordinate{18.307, 45.9358}, CountryId{"HU"}}, // Áta railway station
    {Coordinate{18.3153, 45.9095}, CountryId{"HU"}}, // Kistótfalu railway station
    {Coordinate{18.3343, 45.8995}, CountryId{"HU"}}, // Vokány railway station
    {Coordinate{18.3941, 45.8914}, CountryId{"HU"}}, // Palkonya railway station
    {Coordinate{18.4263, 45.8798}, CountryId{"HU"}}, // Villánykövesd railway station
    {Coordinate{18.4907, 45.835}, CountryId{"HU"}}, // Magyarbóly railway station
    {Coordinate{18.4991, 45.8868}, CountryId{"HU"}}, // Márok railway station
    {Coordinate{18.5383, 45.9376}, CountryId{"HU"}}, // Bóly railway station
    {Coordinate{18.5649, 45.9534}, CountryId{"HU"}}, // Nagynyárád railway station
    {Coordinate{18.6692, 45.9959}, CountryId{"HU"}}, // Középmező railway station
    {Coordinate{18.6845, 46.0025}, CountryId{"HU"}}, // Mohács railway station
    {Coordinate{17.4469, 45.9518}, CountryId{"HU"}}, // Barcs railway station
    {Coordinate{17.4862, 45.9583}, CountryId{"HU"}}, // Barcs felső railway station
    {Coordinate{17.5986, 45.9922}, CountryId{"HU"}}, // Q22003448
    {Coordinate{17.5249, 45.9705}, CountryId{"HU"}}, // Középrigóc railway station
    {Coordinate{17.6671, 46.012}, CountryId{"HU"}}, // Kisdobsza railway station
    {Coordinate{17.802, 46.0431}, CountryId{"HU"}}, // Szigetvár railway station
    {Coordinate{17.8979, 46.0381}, CountryId{"HU"}}, // Nagypeterd railway station
    {Coordinate{17.7073, 46.0236}, CountryId{"HU"}}, // Nemeske railway station
    {Coordinate{17.7484, 46.0352}, CountryId{"HU"}}, // Molvány railway station
    {Coordinate{17.9271, 46.0365}, CountryId{"HU"}}, // Szentdénes railway station
    {Coordinate{17.1795, 46.1632}, CountryId{"HU"}}, // Somogyudvarhely railway station
    {Coordinate{17.2078, 46.1229}, CountryId{"HU"}}, // Q22003646
    {Coordinate{17.3425, 46.0284}, CountryId{"HU"}}, // Babócsa railway station
    {Coordinate{17.3581, 46.0067}, CountryId{"HU"}}, // Péterhida-Komlósd railway station
    {Coordinate{17.1435, 46.2012}, CountryId{"HU"}}, // Q22003650
    {Coordinate{17.2395, 46.1013}, CountryId{"HU"}}, // Q22003652
    {Coordinate{6.19889, 51.6236}, CountryId{"DE"}}, // Weeze railway station
    {Coordinate{0.596937, 43.6473}, CountryId{"FR"}}, // Q2200917
    {Coordinate{6.78912, 51.2119}, CountryId{"DE"}}, // Düsseldorf-Friedrichstadt station
    {Coordinate{4.36194, 50.8522}, CountryId{"BE"}}, // Brussels Congress railway station
    {Coordinate{3.69649, 43.4128}, CountryId{"FR"}}, // Gare de Sète
    {Coordinate{0.77258, 49.0743}, CountryId{"FR"}}, // Beaumont-le-Roger
    {Coordinate{7.09567, 48.7429}, CountryId{"FR"}}, // Gare de Réding
    {Coordinate{19.3756, 47.5643}, CountryId{"HU"}}, // Gödöllő-Állami telepek railway station
    {Coordinate{19.5259, 47.6389}, CountryId{"HU"}}, // Hévízgyörk railway station
    {Coordinate{19.0403, 47.8313}, CountryId{"HU"}}, // Magyarkút-Verőce railway station
    {Coordinate{19.0467, 47.8491}, CountryId{"HU"}}, // Magyarkút railway station
    {Coordinate{19.0306, 47.8711}, CountryId{"HU"}}, // Szokolya railway station
    {Coordinate{19.0713, 47.8855}, CountryId{"HU"}}, // Berkenye railway station
    {Coordinate{19.0471, 47.9022}, CountryId{"HU"}}, // Nógrád railway station
    {Coordinate{19.057, 48.0424}, CountryId{"HU"}}, // Drégely railway station
    {Coordinate{19.0467, 48.0548}, CountryId{"HU"}}, // Drégelypalánk railway station
    {Coordinate{19.1964, 48.0455}, CountryId{"HU"}}, // Dejtár railway station
    {Coordinate{19.0947, 47.9733}, CountryId{"HU"}}, // Borsosberény railway station
    {Coordinate{19.1007, 47.9939}, CountryId{"HU"}}, // Nagyoroszi railway station
    {Coordinate{19.0796, 48.002}, CountryId{"HU"}}, // Drégelyvár railway station
    {Coordinate{19.1072, 48.0574}, CountryId{"HU"}}, // Ipolyvece railway station
    {Coordinate{19.2239, 48.0546}, CountryId{"HU"}}, // Ipolyszög railway station
    {Coordinate{19.0443, 48.0286}, CountryId{"HU"}}, // Sáferkút railway station
    {Coordinate{2.99019, 50.6069}, CountryId{"FR"}}, // Haubourdin
    {Coordinate{19.4038, 48.0788}, CountryId{"HU"}}, // Őrhalom railway station
    {Coordinate{19.4239, 48.0829}, CountryId{"HU"}}, // Hugyag railway station
    {Coordinate{19.5212, 48.0925}, CountryId{"HU"}}, // Szécsény railway station
    {Coordinate{19.5295, 48.1325}, CountryId{"HU"}}, // Ludányhalászi railway station
    {Coordinate{19.5217, 48.1781}, CountryId{"HU"}}, // Nógrádszakál railway station
    {Coordinate{19.5413, 48.2072}, CountryId{"HU"}}, // Ráróspuszta railway station
    {Coordinate{19.5987, 48.2159}, CountryId{"HU"}}, // Litke railway station
    {Coordinate{19.6291, 48.2366}, CountryId{"HU"}}, // Ipolytarnóc railway station
    {Coordinate{19.4284, 47.6678}, CountryId{"HU"}}, // Iklad-Domony felső railway station
    {Coordinate{19.3925, 47.6941}, CountryId{"HU"}}, // Galgamácsa railway station
    {Coordinate{19.3861, 47.801}, CountryId{"HU"}}, // Acsa-Erdőkürt railway station
    {Coordinate{19.3673, 47.8956}, CountryId{"HU"}}, // Becske alsó railway station
    {Coordinate{19.3331, 48.0363}, CountryId{"HU"}}, // Szügy railway station
    {Coordinate{19.3722, 47.7353}, CountryId{"HU"}}, // Galgagyörk railway station
    {Coordinate{19.3688, 47.7728}, CountryId{"HU"}}, // Püspökhatvan railway station
    {Coordinate{19.3712, 47.8795}, CountryId{"HU"}}, // Nógrádkövesd railway station
    {Coordinate{19.358, 47.9723}, CountryId{"HU"}}, // Magyarnándor railway station
    {Coordinate{19.3465, 47.9967}, CountryId{"HU"}}, // Mohora railway station
    {Coordinate{13.0425, 49.7617}, CountryId{"CZ"}}, // Q2202662
    {Coordinate{0.952409, 45.8781}, CountryId{"FR"}}, // Q2202693
    {Coordinate{4.43417, 51.2817}, CountryId{"BE"}}, // Ekeren railway station
    {Coordinate{2.29051, 48.5333}, CountryId{"FR"}}, // Bouray (Paris RER)
    {Coordinate{5.89222, 50.9197}, CountryId{"NL"}}, // Nuth railway station
    {Coordinate{19.0648, 47.2745}, CountryId{"HU"}}, // Dunavarsány railway station
    {Coordinate{19.0794, 47.1104}, CountryId{"HU"}}, // Dömsöd railway station
    {Coordinate{19.1002, 47.0183}, CountryId{"HU"}}, // Kunszentmiklós-Tass railway station
    {Coordinate{19.0966, 47.3528}, CountryId{"HU"}}, // Dunaharaszti railway station
    {Coordinate{19.0767, 47.3205}, CountryId{"HU"}}, // Taksony railway station
    {Coordinate{19.087, 47.3404}, CountryId{"HU"}}, // Dunaharaszti alsó railway station
    {Coordinate{19.0608, 47.2536}, CountryId{"HU"}}, // Délegyháza railway station
    {Coordinate{19.0437, 47.185}, CountryId{"HU"}}, // Kiskunlacháza railway station
    {Coordinate{19.7189, 46.9632}, CountryId{"HU"}}, // Katonatelep railway station
    {Coordinate{19.1597, 46.9383}, CountryId{"HU"}}, // Bösztör railway station
    {Coordinate{19.2101, 46.8704}, CountryId{"HU"}}, // Szabadszállás railway station
    {Coordinate{19.2636, 46.7685}, CountryId{"HU"}}, // Soltszentimre railway station
    {Coordinate{19.4344, 46.5213}, CountryId{"HU"}}, // Pirtói szőlők railway station
    {Coordinate{19.5331, 46.3493}, CountryId{"HU"}}, // Balotaszállás railway station
    {Coordinate{19.5772, 46.2335}, CountryId{"HU"}}, // Tompa railway station
    {Coordinate{19.5387, 46.2788}, CountryId{"HU"}}, // Kisszállás railway station
    {Coordinate{19.2469, 46.8212}, CountryId{"HU"}}, // Fülöpszállás railway station
    {Coordinate{19.2826, 46.6798}, CountryId{"HU"}}, // Tabdi railway station
    {Coordinate{3.24132, 50.1768}, CountryId{"FR"}}, // Cambrai-Ville railway station
    {Coordinate{19.3954, 46.5698}, CountryId{"HU"}}, // Soltvadkert railway station
    {Coordinate{19.2745, 46.7175}, CountryId{"HU"}}, // Csengőd railway station
    {Coordinate{19.2974, 46.6262}, CountryId{"HU"}}, // Kiskőrös railway station
    {Coordinate{19.4501, 46.4989}, CountryId{"HU"}}, // Pirtó railway station
    {Coordinate{6.99796, 51.3868}, CountryId{"DE"}}, // Essen-Werden station
    {Coordinate{5.02561, 43.3929}, CountryId{"FR"}}, // Martigues train station
    {Coordinate{6.75694, 51.1422}, CountryId{"DE"}}, // Neuss Allerheiligen station
    {Coordinate{4.77952, 45.7657}, CountryId{"FR"}}, // railway station of Écully-la-Demi-Lune
    {Coordinate{19.1601, 46.1156}, CountryId{"HU"}}, // Bácsbokod-Bácsborsód railway station
    {Coordinate{19.3286, 46.1162}, CountryId{"HU"}}, // Almás railway station
    {Coordinate{19.3465, 46.1176}, CountryId{"HU"}}, // Bácsalmás railway station
    {Coordinate{19.3704, 46.2129}, CountryId{"HU"}}, // Mélykút railway station
    {Coordinate{19.3305, 46.2927}, CountryId{"HU"}}, // Jánoshalma railway station
    {Coordinate{19.3949, 46.3294}, CountryId{"HU"}}, // Erdőszél railway station
    {Coordinate{19.4169, 46.3559}, CountryId{"HU"}}, // Kunfehértó railway station
    {Coordinate{19.6019, 46.4586}, CountryId{"HU"}}, // Harkakötöny railway station
    {Coordinate{19.6502, 46.4725}, CountryId{"HU"}}, // Tajó railway station
    {Coordinate{19.7538, 46.5663}, CountryId{"HU"}}, // Jászszentlászló railway station
    {Coordinate{19.7355, 46.5383}, CountryId{"HU"}}, // Kiskunmajsa railway station
    {Coordinate{19.8012, 46.6252}, CountryId{"HU"}}, // Galambos railway station
    {Coordinate{19.9324, 47.7443}, CountryId{"HU"}}, // Gyöngyöshalász railway station
    {Coordinate{19.9353, 47.7666}, CountryId{"HU"}}, // Kitérőgyár railway station
    {Coordinate{19.9276, 47.686}, CountryId{"HU"}}, // Vámosgyörk railway station
    {Coordinate{19.9702, 47.6361}, CountryId{"HU"}}, // Jászárokszállás railway station
    {Coordinate{20.0285, 47.5628}, CountryId{"HU"}}, // Jászdózsa railway station
    {Coordinate{20.2036, 47.456}, CountryId{"HU"}}, // Jászkisér railway station
    {Coordinate{20.2024, 47.4382}, CountryId{"HU"}}, // Jászkisér felső railway station
    {Coordinate{20.0909, 47.3206}, CountryId{"HU"}}, // Szászberek railway station
    {Coordinate{20.1552, 47.5136}, CountryId{"HU"}}, // Jászapáti railway station
    {Coordinate{20.189, 47.4256}, CountryId{"HU"}}, // Szellőhát railway station
    {Coordinate{20.1586, 47.3729}, CountryId{"HU"}}, // Jászladány railway station
    {Coordinate{19.7972, 47.6723}, CountryId{"HU"}}, // Q22039452
    {Coordinate{20.4022, 47.8524}, CountryId{"HU"}}, // Andornaktálya railway station
    {Coordinate{20.4046, 47.808}, CountryId{"HU"}}, // Maklár railway station
    {Coordinate{20.3808, 47.9075}, CountryId{"HU"}}, // Egervár railway station
    {Coordinate{20.3707, 47.9366}, CountryId{"HU"}}, // Eger-Felnémet railway station
    {Coordinate{20.3326, 47.9884}, CountryId{"HU"}}, // Szarvaskő railway station
    {Coordinate{20.3298, 48.0321}, CountryId{"HU"}}, // Mónosbél railway station
    {Coordinate{20.3556, 48.0584}, CountryId{"HU"}}, // Bélapátfalvi Cementgyár railway station
    {Coordinate{20.3825, 48.0956}, CountryId{"HU"}}, // Szilvásvárad-Szalajkavölgy railway station
    {Coordinate{20.3577, 47.9549}, CountryId{"HU"}}, // Almár railway station
    {Coordinate{20.3406, 48.0559}, CountryId{"HU"}}, // Bélapátfalva railway station
    {Coordinate{20.379, 48.1135}, CountryId{"HU"}}, // Szilvásvárad railway station
    {Coordinate{21.03, 47.9261}, CountryId{"HU"}}, // Tiszaújváros railway station
    {Coordinate{20.9893, 47.9425}, CountryId{"HU"}}, // Sajószöged railway station
    {Coordinate{20.9464, 47.9537}, CountryId{"HU"}}, // Nagycsécs railway station
    {Coordinate{20.8697, 47.9604}, CountryId{"HU"}}, // Hejőkeresztúr railway station
    {Coordinate{20.8403, 47.9926}, CountryId{"HU"}}, // Nyékládháza railway station
    {Coordinate{20.4928, 47.7672}, CountryId{"HU"}}, // Szihalom railway station
    {Coordinate{19.9756, 47.6967}, CountryId{"HU"}}, // Adács railway station
    {Coordinate{20.045, 47.7171}, CountryId{"HU"}}, // Karácsond railway station
    {Coordinate{20.0956, 47.724}, CountryId{"HU"}}, // Ludas railway station
    {Coordinate{20.1621, 47.7266}, CountryId{"HU"}}, // Nagyút railway station
    {Coordinate{0.00972222, 49.3161}, CountryId{"FR"}}, // Gare de Villers-sur-Mer
    {Coordinate{2.41778, 48.7461}, CountryId{"FR"}}, // Les Saules
    {Coordinate{20.021, 46.689}, CountryId{"HU"}}, // Kettőshalom railway station
    {Coordinate{19.866, 46.6974}, CountryId{"HU"}}, // Városi park railway station
    {Coordinate{19.9229, 46.6902}, CountryId{"HU"}}, // Csongrádi úti tanyák railway station
    {Coordinate{19.9623, 46.685}, CountryId{"HU"}}, // Gátér railway station
    {Coordinate{20.0597, 46.695}, CountryId{"HU"}}, // Kónyaszék railway station
    {Coordinate{20.1278, 46.7114}, CountryId{"HU"}}, // Csongrád alsó railway station
    {Coordinate{20.1404, 46.7044}, CountryId{"HU"}}, // Csongrád railway station
    {Coordinate{20.2669, 46.6751}, CountryId{"HU"}}, // Hékéd railway station
    {Coordinate{20.3128, 46.4033}, CountryId{"HU"}}, // Hódmezővásárhelyi Népkert railway station
    {Coordinate{20.2493, 46.5885}, CountryId{"HU"}}, // Q22043851
    {Coordinate{20.2251, 46.5643}, CountryId{"HU"}}, // Q22043855
    {Coordinate{20.1939, 46.524}, CountryId{"HU"}}, // Q22043856
    {Coordinate{20.2362, 46.4733}, CountryId{"HU"}}, // Mártély railway station
    {Coordinate{20.452, 46.4594}, CountryId{"HU"}}, // Kútvölgy railway station
    {Coordinate{20.1252, 46.2662}, CountryId{"HU"}}, // Szeged-Rókus railway station
    {Coordinate{20.196, 46.3355}, CountryId{"HU"}}, // Algyő railway station
    {Coordinate{20.6645, 46.5662}, CountryId{"HU"}}, // Orosháza railway station
    {Coordinate{20.8409, 46.6235}, CountryId{"HU"}}, // Csorvás railway station
    {Coordinate{20.8898, 46.6351}, CountryId{"HU"}}, // Csorvás alsó railway station
    {Coordinate{20.9639, 46.6559}, CountryId{"HU"}}, // Telekgerendás railway station
    {Coordinate{21.0234, 46.6724}, CountryId{"HU"}}, // Fürjes railway station
    {Coordinate{20.3682, 46.6699}, CountryId{"HU"}}, // Dónát railway station
    {Coordinate{20.4073, 46.6764}, CountryId{"HU"}}, // Q22045696
    {Coordinate{20.4566, 46.67}, CountryId{"HU"}}, // Fábiánsebestyén railway station
    {Coordinate{20.6283, 46.5909}, CountryId{"HU"}}, // Szentetornya railway station
    {Coordinate{20.5882, 46.6566}, CountryId{"HU"}}, // Gádoros railway station
    {Coordinate{20.5362, 46.6605}, CountryId{"HU"}}, // Q22045704
    {Coordinate{20.6164, 46.6196}, CountryId{"HU"}}, // Justhmajor railway station
    {Coordinate{20.6306, 46.5677}, CountryId{"HU"}}, // Gyopárosfürdő railway station
    {Coordinate{1.34194, 43.7858}, CountryId{"FR"}}, // Gare de Castelnau-d'Estrétefonds
    {Coordinate{21.1795, 46.6598}, CountryId{"HU"}}, // Q22046606
    {Coordinate{21.3329, 46.7046}, CountryId{"HU"}}, // Q22046607
    {Coordinate{21.1657, 46.66}, CountryId{"HU"}}, // Q22046608
    {Coordinate{21.3228, 46.6949}, CountryId{"HU"}}, // Q22046610
    {Coordinate{21.3839, 46.7298}, CountryId{"HU"}}, // Q22046611
    {Coordinate{21.3988, 46.7355}, CountryId{"HU"}}, // Q22046612
    {Coordinate{21.4796, 46.7586}, CountryId{"HU"}}, // Q22046613
    {Coordinate{21.4556, 46.7743}, CountryId{"HU"}}, // Méhkerék railway station
    {Coordinate{21.417, 46.8232}, CountryId{"HU"}}, // Q22046615
    {Coordinate{21.3392, 46.8925}, CountryId{"HU"}}, // Okány railway station
    {Coordinate{2.0888, 49.4265}, CountryId{"FR"}}, // Gare de Beauvais
    {Coordinate{21.2016, 47.0937}, CountryId{"HU"}}, // Füzesgyarmatfürdő railway station
    {Coordinate{21.1943, 47.1131}, CountryId{"HU"}}, // Füzesgyarmat railway station
    {Coordinate{21.2218, 47.2088}, CountryId{"HU"}}, // Biharnagybajom railway station
    {Coordinate{21.1807, 47.2314}, CountryId{"HU"}}, // Sárrétudvari railway station
    {Coordinate{21.1458, 47.2344}, CountryId{"HU"}}, // Szerep railway station
    {Coordinate{21.1019, 47.2356}, CountryId{"HU"}}, // Hosszúhát railway station
    {Coordinate{21.0914, 47.2673}, CountryId{"HU"}}, // Ürmöshát railway station
    {Coordinate{21.0961, 47.3191}, CountryId{"HU"}}, // Püspökladány-Vásártér railway station
    {Coordinate{20.929, 47.3033}, CountryId{"HU"}}, // Karcag railway station
    {Coordinate{20.9071, 47.3219}, CountryId{"HU"}}, // Karcag-Vásártér railway station
    {Coordinate{20.7498, 47.4535}, CountryId{"HU"}}, // Q22047644
    {Coordinate{20.7372, 47.616}, CountryId{"HU"}}, // Q22047645
    {Coordinate{20.8272, 47.3749}, CountryId{"HU"}}, // Q22047647
    {Coordinate{20.7333, 47.4909}, CountryId{"HU"}}, // Q22047648
    {Coordinate{20.7282, 47.5552}, CountryId{"HU"}}, // Tiszaszőlős railway station
    {Coordinate{20.7558, 47.6279}, CountryId{"HU"}}, // Tiszafüred railway station
    {Coordinate{20.793, 47.4152}, CountryId{"HU"}}, // Q22047651
    {Coordinate{20.6655, 47.3249}, CountryId{"HU"}}, // Bánhalma-Halastó railway station
    {Coordinate{20.6864, 47.2543}, CountryId{"HU"}}, // Kenderes railway station
    {Coordinate{20.7511, 47.2239}, CountryId{"HU"}}, // Kisújszállás railway station
    {Coordinate{20.3664, 47.5618}, CountryId{"HU"}}, // Hevesvezekény railway station
    {Coordinate{20.3903, 47.5472}, CountryId{"HU"}}, // Tarnaszentmiklós railway station
    {Coordinate{20.4815, 47.4954}, CountryId{"HU"}}, // Kisköre railway station
    {Coordinate{20.5079, 47.4808}, CountryId{"HU"}}, // Kisköre-Tiszahíd railway station
    {Coordinate{20.5532, 47.4553}, CountryId{"HU"}}, // Abádszalók railway station
    {Coordinate{20.6409, 47.3765}, CountryId{"HU"}}, // Kunhegyes railway station
    {Coordinate{20.654, 47.3634}, CountryId{"HU"}}, // Előhát railway station
    {Coordinate{20.3062, 47.6094}, CountryId{"HU"}}, // Heves railway station
    {Coordinate{20.3024, 47.6832}, CountryId{"HU"}}, // Erdőtelek railway station
    {Coordinate{14.7848, 41.0151}, CountryId{"IT"}}, // Altavilla Irpina railway station
    {Coordinate{14.8427, 40.9885}, CountryId{"IT"}}, // Prata-Pratola railway station
    {Coordinate{14.8159, 41.0138}, CountryId{"IT"}}, // Tufo railway station
    {Coordinate{14.8276, 40.9507}, CountryId{"IT"}}, // Montefredane railway station
    {Coordinate{20.0932, 47.1759}, CountryId{"HU"}}, // Paládicspuszta railway station
    {Coordinate{4.04082, 49.1665}, CountryId{"FR"}}, // Gare de Rilly-la-Montagne
    {Coordinate{20.5576, 47.1944}, CountryId{"HU"}}, // Fegyvernek-Örményes railway station
    {Coordinate{21.2593, 47.3689}, CountryId{"HU"}}, // Kaba railway station
    {Coordinate{21.4069, 47.4293}, CountryId{"HU"}}, // Hajdúszoboszló railway station
    {Coordinate{21.4886, 47.4626}, CountryId{"HU"}}, // Ebes railway station
    {Coordinate{6.43464, 47.1298}, CountryId{"FR"}}, // Gare d'Avoudrey
    {Coordinate{21.6479, 47.5405}, CountryId{"HU"}}, // Debrecen-Csapókert railway station
    {Coordinate{21.6558, 47.584}, CountryId{"HU"}}, // Apafa railway station
    {Coordinate{21.666, 47.6403}, CountryId{"HU"}}, // Bocskaikert railway station
    {Coordinate{21.6848, 47.7146}, CountryId{"HU"}}, // Téglás railway station
    {Coordinate{21.6793, 47.6868}, CountryId{"HU"}}, // Hajdúhadház railway station
    {Coordinate{21.7065, 47.8148}, CountryId{"HU"}}, // Újfehértó railway station
    {Coordinate{21.729, 47.9971}, CountryId{"HU"}}, // Sóstó railway station
    {Coordinate{21.884, 48.0933}, CountryId{"HU"}}, // Q22054861
    {Coordinate{21.8016, 48.0654}, CountryId{"HU"}}, // Q22054862
    {Coordinate{21.7428, 48.0123}, CountryId{"HU"}}, // Q22054863
    {Coordinate{21.9269, 48.1116}, CountryId{"HU"}}, // Q22054864
    {Coordinate{21.9526, 48.1287}, CountryId{"HU"}}, // Q22054865
    {Coordinate{21.855, 48.0823}, CountryId{"HU"}}, // Q22054866
    {Coordinate{21.9968, 48.1587}, CountryId{"HU"}}, // Q22054869
    {Coordinate{22.0464, 48.1855}, CountryId{"HU"}}, // Q22054870
    {Coordinate{22.079, 48.209}, CountryId{"HU"}}, // Q22054871
    {Coordinate{22.0918, 48.2283}, CountryId{"HU"}}, // Q22054872
    {Coordinate{22.1072, 48.2674}, CountryId{"HU"}}, // Q22054873
    {Coordinate{22.1182, 48.3051}, CountryId{"HU"}}, // Q22054874
    {Coordinate{22.1316, 48.3424}, CountryId{"HU"}}, // Q22054875
    {Coordinate{22.1449, 48.3713}, CountryId{"HU"}}, // Q22054876
    {Coordinate{14.5139, 50.1253}, CountryId{"CZ"}}, // Letňany
    {Coordinate{21.7401, 47.9431}, CountryId{"HU"}}, // Q22056021
    {Coordinate{21.8732, 47.9487}, CountryId{"HU"}}, // Q22056026
    {Coordinate{22.2033, 48.0591}, CountryId{"HU"}}, // Q22056041
    {Coordinate{21.8064, 47.9458}, CountryId{"HU"}}, // Q22056049
    {Coordinate{21.9391, 47.9538}, CountryId{"HU"}}, // Q22056064
    {Coordinate{22.0413, 47.9406}, CountryId{"HU"}}, // Q22056069
    {Coordinate{22.0713, 47.9516}, CountryId{"HU"}}, // Q22056071
    {Coordinate{22.0834, 47.9886}, CountryId{"HU"}}, // Q22056073
    {Coordinate{22.1635, 48.0065}, CountryId{"HU"}}, // Q22056075
    {Coordinate{22.178, 48.0221}, CountryId{"HU"}}, // Q22056077
    {Coordinate{22.2513, 48.0821}, CountryId{"HU"}}, // Q22056081
    {Coordinate{22.3058, 48.1266}, CountryId{"HU"}}, // Q22056084
    {Coordinate{21.9937, 47.948}, CountryId{"HU"}}, // Q22056099
    {Coordinate{20.0327, 46.194}, CountryId{"HU"}}, // Röszke railway station
    {Coordinate{22.2692, 48.1715}, CountryId{"HU"}}, // Q22056391
    {Coordinate{22.1964, 48.3272}, CountryId{"HU"}}, // Q22056392
    {Coordinate{22.3137, 47.951}, CountryId{"HU"}}, // Mátészalka railway station
    {Coordinate{22.3182, 47.9979}, CountryId{"HU"}}, // Q22056394
    {Coordinate{22.3114, 48.0541}, CountryId{"HU"}}, // Q22056395
    {Coordinate{22.3082, 48.0955}, CountryId{"HU"}}, // Q22056396
    {Coordinate{22.2902, 48.1518}, CountryId{"HU"}}, // Q22056397
    {Coordinate{22.2535, 48.2114}, CountryId{"HU"}}, // Q22056398
    {Coordinate{22.2215, 48.2512}, CountryId{"HU"}}, // Q22056399
    {Coordinate{22.2022, 48.2684}, CountryId{"HU"}}, // Q22056400
    {Coordinate{22.1902, 48.3606}, CountryId{"HU"}}, // Q22056401
    {Coordinate{22.4029, 47.8153}, CountryId{"HU"}}, // Tiborszállás railway station
    {Coordinate{22.3854, 47.8649}, CountryId{"HU"}}, // Q22056457
    {Coordinate{22.3483, 47.9081}, CountryId{"HU"}}, // Q22056458
    {Coordinate{37.4923, 47.5538}, CountryId{"UA"}}, // 412 km
    {Coordinate{38.085, 48.8165}, CountryId{"UA"}}, // Q22056514
    {Coordinate{38.0289, 48.6958}, CountryId{"UA"}}, // Q22056519
    {Coordinate{37.9707, 48.5014}, CountryId{"UA"}}, // Q22056523
    {Coordinate{33.2307, 47.8932}, CountryId{"UA"}}, // Q22056534
    {Coordinate{34.52, 46.9678}, CountryId{"UA"}}, // Q22056535
    {Coordinate{31.4357, 51.4261}, CountryId{"UA"}}, // Q22056540
    {Coordinate{37.9733, 48.5402}, CountryId{"UA"}}, // Klishchiivka
    {Coordinate{37.7422, 49.0103}, CountryId{"UA"}}, // Q22056556
    {Coordinate{32.6741, 47.0695}, CountryId{"UA"}}, // Q22056557
    {Coordinate{38.0708, 48.7552}, CountryId{"UA"}}, // Q22056565
    {Coordinate{38.0673, 48.3394}, CountryId{"UA"}}, // Q22056568
    {Coordinate{37.6343, 49.0658}, CountryId{"UA"}}, // Q22056579
    {Coordinate{37.7331, 48.1489}, CountryId{"UA"}}, // Q22057695
    {Coordinate{38.1319, 48.3161}, CountryId{"UA"}}, // Q22057703
    {Coordinate{21.5833, 47.364}, CountryId{"HU"}}, // Derecske railway station
    {Coordinate{25.3471, 48.1757}, CountryId{"UA"}}, // Berehomet
    {Coordinate{21.581, 47.3516}, CountryId{"HU"}}, // Derecske-Vásártér railway station
    {Coordinate{21.7454, 47.3241}, CountryId{"HU"}}, // Konyári Sóstófürdő railway station
    {Coordinate{24.9501, 49.445}, CountryId{"UA"}}, // Q22057726
    {Coordinate{21.8139, 47.2439}, CountryId{"HU"}}, // Q22057729
    {Coordinate{21.8004, 47.1908}, CountryId{"HU"}}, // Q22057731
    {Coordinate{25.6871, 49.0397}, CountryId{"UA"}}, // Q22057740
    {Coordinate{21.6251, 47.4143}, CountryId{"HU"}}, // Sáránd  railway station
    {Coordinate{24.5247, 49.0353}, CountryId{"UA"}}, // Bodnariv
    {Coordinate{21.6662, 47.3236}, CountryId{"HU"}}, // Konyár railway station
    {Coordinate{21.7928, 47.2883}, CountryId{"HU"}}, // Pocsaj-Esztár railway station
    {Coordinate{23.8722, 49.0632}, CountryId{"UA"}}, // Q22057759
    {Coordinate{26.0594, 48.8044}, CountryId{"UA"}}, // Q22057768
    {Coordinate{24.7186, 48.8232}, CountryId{"UA"}}, // Q22057779
    {Coordinate{24.4948, 49.26}, CountryId{"UA"}}, // Q22057787
    {Coordinate{38.3597, 48.3025}, CountryId{"UA"}}, // Q22057794
    {Coordinate{24.6476, 49.2173}, CountryId{"UA"}}, // Q22057795
    {Coordinate{25.9077, 48.2027}, CountryId{"UA"}}, // Q22057805
    {Coordinate{25.7515, 48.5413}, CountryId{"UA"}}, // Q22057814
    {Coordinate{25.8601, 49.0383}, CountryId{"UA"}}, // Vyhnanka
    {Coordinate{25.4255, 48.4471}, CountryId{"UA"}}, // Q22057833
    {Coordinate{25.1928, 48.2492}, CountryId{"UA"}}, // Q22057842
    {Coordinate{35.7145, 49.5922}, CountryId{"UA"}}, // Q22057850
    {Coordinate{24.5082, 48.2794}, CountryId{"UA"}}, // Q22057950
    {Coordinate{25.9017, 49.0486}, CountryId{"UA"}}, // Q22057972
    {Coordinate{24.7327, 49.1371}, CountryId{"UA"}}, // Q22057986
    {Coordinate{25.08, 48.5984}, CountryId{"UA"}}, // Q22057995
    {Coordinate{38.0442, 48.3111}, CountryId{"UA"}}, // Q22058004
    {Coordinate{37.3133, 48.2269}, CountryId{"UA"}}, // Q22058012
    {Coordinate{26.1837, 49.0734}, CountryId{"UA"}}, // Q22058031
    {Coordinate{36.4753, 48.1781}, CountryId{"UA"}}, // Q22058040
    {Coordinate{25.7732, 49.239}, CountryId{"UA"}}, // Derenivka
    {Coordinate{37.0758, 48.4483}, CountryId{"UA"}}, // Q22058055
    {Coordinate{23.9841, 48.9823}, CountryId{"UA"}}, // Dolyna
    {Coordinate{38.1325, 48.4144}, CountryId{"UA"}}, // Q22058073
    {Coordinate{24.7952, 49.0916}, CountryId{"UA"}}, // Q22058092
    {Coordinate{24.7659, 49.0408}, CountryId{"UA"}}, // Q22058111
    {Coordinate{38.1997, 48.2264}, CountryId{"UA"}}, // Q22058121
    {Coordinate{24.3762, 49.3129}, CountryId{"UA"}}, // Q22058130
    {Coordinate{25.3074, 48.4737}, CountryId{"UA"}}, // Q22058139
    {Coordinate{38.1968, 47.924}, CountryId{"UA"}}, // Q22058165
    {Coordinate{25.2524, 48.2985}, CountryId{"UA"}}, // Ispas
    {Coordinate{37.8814, 48.0639}, CountryId{"UA"}}, // Q22058183
    {Coordinate{25.8412, 48.0944}, CountryId{"UA"}}, // Q22058201
    {Coordinate{37.6175, 48.5792}, CountryId{"UA"}}, // Q22058210
    {Coordinate{25.7767, 48.4361}, CountryId{"UA"}}, // Q22058218
    {Coordinate{25.1643, 49.4295}, CountryId{"UA"}}, // Q22058227
    {Coordinate{25.0169, 48.6538}, CountryId{"UA"}}, // Q22058236
    {Coordinate{25.7188, 48.6441}, CountryId{"UA"}}, // Q22058247
    {Coordinate{37.7214, 48.5167}, CountryId{"UA"}}, // Q22058248
    {Coordinate{37.5092, 47.9919}, CountryId{"UA"}}, // Q22058249
    {Coordinate{37.7814, 48.4089}, CountryId{"UA"}}, // Q22058250
    {Coordinate{38.0244, 48.1267}, CountryId{"UA"}}, // Q22058251
    {Coordinate{37.3742, 48.0367}, CountryId{"UA"}}, // Q22058253
    {Coordinate{37.9597, 48.4639}, CountryId{"UA"}}, // Q22058254
    {Coordinate{32.7916, 48.3136}, CountryId{"UA"}}, // Kutsivka
    {Coordinate{26.0833, 49.8742}, CountryId{"UA"}}, // Q22058256
    {Coordinate{38.2881, 49.9242}, CountryId{"UA"}}, // Q22058257
    {Coordinate{32.125, 48.5189}, CountryId{"UA"}}, // Lelekivka
    {Coordinate{25.7708, 48.3617}, CountryId{"UA"}}, // Luzhany railway station
    {Coordinate{26.5753, 48.2526}, CountryId{"UA"}}, // Mamalyha railway station
    {Coordinate{38.635, 48.4089}, CountryId{"UA"}}, // Q22058262
    {Coordinate{24.7883, 48.8195}, CountryId{"UA"}}, // Markivtsi railway station
    {Coordinate{25.1661, 48.5094}, CountryId{"UA"}}, // Q22058264
    {Coordinate{32.6715, 48.5659}, CountryId{"UA"}}, // Mederove
    {Coordinate{25.6308, 48.0525}, CountryId{"UA"}}, // Q22058266
    {Coordinate{24.5938, 48.3969}, CountryId{"UA"}}, // Mikulichin station
    {Coordinate{38.075, 47.8817}, CountryId{"UA"}}, // Q22058270
    {Coordinate{24.5849, 48.6242}, CountryId{"UA"}}, // Nadvirna
    {Coordinate{25.6532, 48.3997}, CountryId{"UA"}}, // Nepolokivtsi
    {Coordinate{26.2806, 48.2242}, CountryId{"UA"}}, // Novoselytsia railway station
    {Coordinate{37.995, 48.2}, CountryId{"UA"}}, // Q22058277
    {Coordinate{25.4411, 49.0669}, CountryId{"UA"}}, // Pyshkivtsi
    {Coordinate{24.7781, 49.38}, CountryId{"UA"}}, // Pidvysoke Railway Station
    {Coordinate{31.7269, 48.4612}, CountryId{"UA"}}, // Q22058280
    {Coordinate{24.9814, 49.377}, CountryId{"UA"}}, // Q22058281
    {Coordinate{25.6848, 49.4168}, CountryId{"UA"}}, // Proshova
    {Coordinate{38.04, 48.1428}, CountryId{"UA"}}, // Q22058283
    {Coordinate{24.6213, 49.3995}, CountryId{"UA"}}, // Rohatyn
    {Coordinate{39.0231, 48.5547}, CountryId{"UA"}}, // Q22058285
    {Coordinate{24.1599, 49.0002}, CountryId{"UA"}}, // Q22058286
    {Coordinate{25.9507, 48.331}, CountryId{"UA"}}, // Sadhora railway station
    {Coordinate{32.6254, 48.644}, CountryId{"UA"}}, // Saharna
    {Coordinate{38.0928, 48.8694}, CountryId{"UA"}}, // Q22058291
    {Coordinate{38.9097, 48.5461}, CountryId{"UA"}}, // Q22058293
    {Coordinate{25.5052, 48.4293}, CountryId{"UA"}}, // Snyatyn
    {Coordinate{27.3727, 48.4443}, CountryId{"UA"}}, // Q22058295
    {Coordinate{25.7107, 48.7575}, CountryId{"UA"}}, // Torskie
    {Coordinate{32.3672, 48.6849}, CountryId{"UA"}}, // Q22058298
    {Coordinate{37.0139, 48.2408}, CountryId{"UA"}}, // Q22058300
    {Coordinate{38.1519, 48.0325}, CountryId{"UA"}}, // Q22058301
    {Coordinate{24.7416, 48.8911}, CountryId{"UA"}}, // Q22058302
    {Coordinate{32.7961, 48.5009}, CountryId{"UA"}}, // Sharivka
    {Coordinate{37.9958, 48.6547}, CountryId{"UA"}}, // Q22058306
    {Coordinate{31.9717, 48.5166}, CountryId{"UA"}}, // Q22058309
    {Coordinate{38.1403, 48.1942}, CountryId{"UA"}}, // Q22058310
    {Coordinate{25.7344, 48.9333}, CountryId{"UA"}}, // Q22058311
    {Coordinate{24.7111, 48.9854}, CountryId{"UA"}}, // Yamnytsia
    {Coordinate{5.89064, 48.1797}, CountryId{"FR"}}, // Q2205857
    {Coordinate{20.1279, 47.1467}, CountryId{"HU"}}, // Piroska railway station
    {Coordinate{20.1384, 47.0981}, CountryId{"HU"}}, // Tószeg railway station
    {Coordinate{20.1424, 47.0365}, CountryId{"HU"}}, // Tiszajenő-Vezseny railway station
    {Coordinate{20.1345, 47.017}, CountryId{"HU"}}, // Tiszajenő alsó railway station
    {Coordinate{20.0936, 46.9621}, CountryId{"HU"}}, // Óbög railway station
    {Coordinate{20.1111, 46.9871}, CountryId{"HU"}}, // Újbög railway station
    {Coordinate{20.082, 46.9375}, CountryId{"HU"}}, // Tiszakécske railway station
    {Coordinate{20.0466, 46.9024}, CountryId{"HU"}}, // Kerekdomb railway station
    {Coordinate{20.0039, 46.8729}, CountryId{"HU"}}, // Lakitelek railway station
    {Coordinate{20.1428, 47.0594}, CountryId{"HU"}}, // Tiszavárkony railway station
    {Coordinate{19.7797, 46.8985}, CountryId{"HU"}}, // Alsóúrrét railway station
    {Coordinate{19.9895, 46.8665}, CountryId{"HU"}}, // Árpádszállás railway station
    {Coordinate{19.9754, 46.8583}, CountryId{"HU"}}, // Szikra railway station
    {Coordinate{19.94, 46.8552}, CountryId{"HU"}}, // Világoshegy railway station
    {Coordinate{19.923, 46.8577}, CountryId{"HU"}}, // Nyárjas railway station
    {Coordinate{19.8787, 46.8641}, CountryId{"HU"}}, // Nyárlőrinc alsó railway station
    {Coordinate{19.8515, 46.8701}, CountryId{"HU"}}, // Nyárlőrinc railway station
    {Coordinate{19.8282, 46.8776}, CountryId{"HU"}}, // Nyárlőrici szőlők railway station
    {Coordinate{19.8073, 46.8884}, CountryId{"HU"}}, // Kisfái railway station
    {Coordinate{19.8474, 46.7253}, CountryId{"HU"}}, // Petőfiváros railway station
    {Coordinate{19.8879, 46.7537}, CountryId{"HU"}}, // Kismindszenti út railway station
    {Coordinate{19.9129, 46.7699}, CountryId{"HU"}}, // Borsihalom railway station
    {Coordinate{19.9515, 46.7908}, CountryId{"HU"}}, // Tiszaalpár alsó railway station
    {Coordinate{19.9827, 46.8186}, CountryId{"HU"}}, // Tiszaalpár railway station
    {Coordinate{19.977, 46.8362}, CountryId{"HU"}}, // Tiszaalpár felső railway station
    {Coordinate{19.98, 46.8512}, CountryId{"HU"}}, // Tőserdő railway station
    {Coordinate{20.0524, 46.8662}, CountryId{"HU"}}, // Tiszaug-Tiszahídfő railway station
    {Coordinate{20.0742, 46.8505}, CountryId{"HU"}}, // Tiszaug railway station
    {Coordinate{20.0899, 46.8258}, CountryId{"HU"}}, // Tiszasas railway station
    {Coordinate{20.135, 46.8125}, CountryId{"HU"}}, // Csépa railway station
    {Coordinate{20.1958, 46.8117}, CountryId{"HU"}}, // Szelevény railway station
    {Coordinate{20.2935, 46.8483}, CountryId{"HU"}}, // Kunszentmárton railway station
    {Coordinate{5.25194, 52.6961}, CountryId{"NL"}}, // Bovenkarspel Flora railway station
    {Coordinate{20.2921, 47.0208}, CountryId{"HU"}}, // Q22061479
    {Coordinate{20.2766, 46.9757}, CountryId{"HU"}}, // Q22061483
    {Coordinate{20.3157, 47.0603}, CountryId{"HU"}}, // Q22061490
    {Coordinate{20.3399, 47.0899}, CountryId{"HU"}}, // Kengyel railway station
    {Coordinate{20.2695, 46.9458}, CountryId{"HU"}}, // Homok railway station
    {Coordinate{20.2679, 46.9083}, CountryId{"HU"}}, // Kungyalu railway station
    {Coordinate{20.2916, 46.7633}, CountryId{"HU"}}, // Q22061707
    {Coordinate{20.2814, 46.7157}, CountryId{"HU"}}, // Q22061711
    {Coordinate{5.71992, 45.1528}, CountryId{"FR"}}, // Gare d'Échirolles
    {Coordinate{-0.2502, 52.5748}, CountryId{"GB"}}, // Peterborough railway station
    {Coordinate{6.98, 51.4542}, CountryId{"DE"}}, // Essen West station
    {Coordinate{4.46278, 50.4322}, CountryId{"BE"}}, // Lodelinsart railway station
    {Coordinate{2.21476, 48.8214}, CountryId{"FR"}}, // gare de Sèvres-Rive-Gauche
    {Coordinate{-2.765, 48.5075}, CountryId{"FR"}}, // Gare de Saint-Brieuc
    {Coordinate{3.32215, 48.9687}, CountryId{"FR"}}, // Gare de Nogent-l'Artaud - Charly
    {Coordinate{19.791, 48.0893}, CountryId{"HU"}}, // Salgótarján külső railway station
    {Coordinate{19.8157, 48.1552}, CountryId{"HU"}}, // Somoskőújfalu railway station
    {Coordinate{19.7067, 47.9388}, CountryId{"HU"}}, // Mátraszőlős-Hasznos railway station
    {Coordinate{19.8194, 47.9797}, CountryId{"HU"}}, // Nagybátony railway station
    {Coordinate{19.7463, 47.956}, CountryId{"HU"}}, // Tar railway station
    {Coordinate{19.8306, 48.0236}, CountryId{"HU"}}, // Kisterenye-Bányatelep railway station
    {Coordinate{19.785, 48.0673}, CountryId{"HU"}}, // Zagyvapálfalva railway station
    {Coordinate{19.8319, 48.0096}, CountryId{"HU"}}, // Kisterenye railway station
    {Coordinate{19.6889, 47.919}, CountryId{"HU"}}, // Pásztó railway station
    {Coordinate{19.7787, 47.9683}, CountryId{"HU"}}, // Mátraverebély railway station
    {Coordinate{19.6903, 47.8515}, CountryId{"HU"}}, // Szurdokpüspöki railway station
    {Coordinate{19.6681, 47.7913}, CountryId{"HU"}}, // Apc-Zagyvaszántó railway station
    {Coordinate{19.6738, 47.7196}, CountryId{"HU"}}, // Mátravidéki Erőmű railway station
    {Coordinate{19.6874, 47.829}, CountryId{"HU"}}, // Jobbágyi  railway station
    {Coordinate{19.6709, 47.7589}, CountryId{"HU"}}, // Selyp railway station
    {Coordinate{19.6739, 47.7377}, CountryId{"HU"}}, // Lőrinci railway station
    {Coordinate{20.8661, 48.0836}, CountryId{"HU"}}, // Felsőzsolca railway station
    {Coordinate{20.9075, 48.1219}, CountryId{"HU"}}, // Onga railway station
    {Coordinate{20.9348, 48.1929}, CountryId{"HU"}}, // Q22071385
    {Coordinate{20.9417, 48.2016}, CountryId{"HU"}}, // Q22071386
    {Coordinate{20.9618, 48.2201}, CountryId{"HU"}}, // Q22071387
    {Coordinate{20.9911, 48.246}, CountryId{"HU"}}, // Q22071388
    {Coordinate{21.0341, 48.2772}, CountryId{"HU"}}, // Q22071389
    {Coordinate{21.0535, 48.2893}, CountryId{"HU"}}, // Q22071390
    {Coordinate{21.1177, 48.3275}, CountryId{"HU"}}, // Q22071391
    {Coordinate{21.1402, 48.363}, CountryId{"HU"}}, // Q22071392
    {Coordinate{21.1702, 48.4039}, CountryId{"HU"}}, // Q22071393
    {Coordinate{21.2136, 48.4868}, CountryId{"HU"}}, // Q22071394
    {Coordinate{20.7665, 48.1856}, CountryId{"HU"}}, // Q22071955
    {Coordinate{20.7829, 48.1477}, CountryId{"HU"}}, // Q22071956
    {Coordinate{20.7741, 48.1679}, CountryId{"HU"}}, // Q22071957
    {Coordinate{20.726, 48.2197}, CountryId{"HU"}}, // Q22071958
    {Coordinate{20.7085, 48.2221}, CountryId{"HU"}}, // Q22071959
    {Coordinate{20.6725, 48.2389}, CountryId{"HU"}}, // Q22071960
    {Coordinate{20.6499, 48.2548}, CountryId{"HU"}}, // Q22071961
    {Coordinate{20.6284, 48.2642}, CountryId{"HU"}}, // Q22071962
    {Coordinate{20.5822, 48.2728}, CountryId{"HU"}}, // Q22072652
    {Coordinate{20.5559, 48.2763}, CountryId{"HU"}}, // Q22072711
    {Coordinate{20.5045, 48.2807}, CountryId{"HU"}}, // Q22072739
    {Coordinate{20.4374, 48.2865}, CountryId{"HU"}}, // Q22072803
    {Coordinate{20.3816, 48.2964}, CountryId{"HU"}}, // Q22072857
    {Coordinate{20.352, 48.2998}, CountryId{"HU"}}, // Bánréve railway station
    {Coordinate{20.3681, 48.2839}, CountryId{"HU"}}, // Q22072965
    {Coordinate{20.367, 48.2701}, CountryId{"HU"}}, // Q22072968
    {Coordinate{20.319, 48.2344}, CountryId{"HU"}}, // Ózd alsó railway station
    {Coordinate{6.77722, 50.9365}, CountryId{"DE"}}, // Frechen-Königsdorf station
    {Coordinate{3.16307, 50.6957}, CountryId{"FR"}}, // Gare de Roubaix
    {Coordinate{20.7922, 48.2126}, CountryId{"HU"}}, // Alsóboldva railway station
    {Coordinate{20.7906, 48.2232}, CountryId{"HU"}}, // Boldva railway station
    {Coordinate{20.771, 48.2587}, CountryId{"HU"}}, // Q22073974
    {Coordinate{20.7609, 48.2788}, CountryId{"HU"}}, // Q22073975
    {Coordinate{20.7494, 48.2997}, CountryId{"HU"}}, // Q22073976
    {Coordinate{20.7317, 48.3342}, CountryId{"HU"}}, // Q22073977
    {Coordinate{20.7256, 48.3741}, CountryId{"HU"}}, // Q22073978
    {Coordinate{20.7214, 48.4003}, CountryId{"HU"}}, // Q22073979
    {Coordinate{20.7201, 48.41}, CountryId{"HU"}}, // Q22073980
    {Coordinate{20.7223, 48.4485}, CountryId{"HU"}}, // Q22073981
    {Coordinate{20.6912, 48.4719}, CountryId{"HU"}}, // Q22073982
    {Coordinate{20.6938, 48.4898}, CountryId{"HU"}}, // Q22073983
    {Coordinate{20.7379, 48.5375}, CountryId{"HU"}}, // Q22073984
    {Coordinate{20.7565, 48.5462}, CountryId{"HU"}}, // Q22073985
    {Coordinate{20.7871, 48.558}, CountryId{"HU"}}, // Tornanádaska railway station
    {Coordinate{35.0497, 47.3047}, CountryId{"UA"}}, // 166 km
    {Coordinate{35.0712, 47.8175}, CountryId{"UA"}}, // 168 km
    {Coordinate{35.0964, 47.8497}, CountryId{"UA"}}, // 172 km
    {Coordinate{35.1122, 47.8553}, CountryId{"UA"}}, // 174 km
    {Coordinate{35.2203, 47.8372}, CountryId{"UA"}}, // Iskra
    {Coordinate{35.2092, 47.8286}, CountryId{"UA"}}, // Motor
    {Coordinate{20.9853, 48.0515}, CountryId{"HU"}}, // Hernádnémeti-Bőcs railway station
    {Coordinate{21.0566, 48.0395}, CountryId{"HU"}}, // Tiszalúc railway station
    {Coordinate{21.1291, 48.0919}, CountryId{"HU"}}, // Taktaharkány railway station
    {Coordinate{21.1495, 48.1125}, CountryId{"HU"}}, // Taktaszada railway station
    {Coordinate{21.2148, 48.1559}, CountryId{"HU"}}, // Szerencs railway station
    {Coordinate{21.2676, 48.1569}, CountryId{"HU"}}, // Q22074412
    {Coordinate{20.7639, 47.8908}, CountryId{"HU"}}, // Csincse railway station
    {Coordinate{20.5676, 47.7973}, CountryId{"HU"}}, // Mezőkövesd railway station
    {Coordinate{20.5898, 47.8064}, CountryId{"HU"}}, // Mezőkövesd felső railway station
    {Coordinate{20.6696, 47.8452}, CountryId{"HU"}}, // Mezőkeresztes-Mezőnyárád railway station
    {Coordinate{20.8227, 47.9308}, CountryId{"HU"}}, // Emőd railway station
    {Coordinate{21.3399, 48.125}, CountryId{"HU"}}, // Q22074469
    {Coordinate{21.407, 48.113}, CountryId{"HU"}}, // Q22074470
    {Coordinate{21.5261, 48.0679}, CountryId{"HU"}}, // Q22074492
    {Coordinate{21.4748, 48.1202}, CountryId{"HU"}}, // Q22074494
    {Coordinate{21.5552, 48.0398}, CountryId{"HU"}}, // Q22074495
    {Coordinate{21.6164, 48.0047}, CountryId{"HU"}}, // Q22074496
    {Coordinate{21.6476, 47.9888}, CountryId{"HU"}}, // Q22074497
    {Coordinate{21.3693, 48.0129}, CountryId{"HU"}}, // Q22074505
    {Coordinate{21.4699, 47.9891}, CountryId{"HU"}}, // Q22074506
    {Coordinate{21.4146, 47.9989}, CountryId{"HU"}}, // Q22074507
    {Coordinate{21.5145, 48.0262}, CountryId{"HU"}}, // Bashalom railway station
    {Coordinate{21.4922, 48.0106}, CountryId{"HU"}}, // Q22074509
    {Coordinate{21.3867, 48.201}, CountryId{"HU"}}, // Q22074883
    {Coordinate{21.3539, 48.1753}, CountryId{"HU"}}, // Q22074885
    {Coordinate{21.4019, 48.2181}, CountryId{"HU"}}, // Q22074886
    {Coordinate{21.448, 48.2582}, CountryId{"HU"}}, // Q22074887
    {Coordinate{21.5121, 48.2854}, CountryId{"HU"}}, // Q22074889
    {Coordinate{21.5659, 48.3257}, CountryId{"HU"}}, // Q22074890
    {Coordinate{21.6579, 48.3859}, CountryId{"HU"}}, // Sátoraljaújhely railway station
    {Coordinate{21.2688, 48.19}, CountryId{"HU"}}, // Mád railway station
    {Coordinate{21.223, 48.2282}, CountryId{"HU"}}, // Tállya railway station
    {Coordinate{21.2047, 48.2425}, CountryId{"HU"}}, // Golop railway station
    {Coordinate{21.1812, 48.2865}, CountryId{"HU"}}, // Abaújszántó railway station
    {Coordinate{21.1796, 48.2687}, CountryId{"HU"}}, // Abaújszántói fürdő  railway station
    {Coordinate{21.2302, 48.2144}, CountryId{"HU"}}, // Rátka railway station
    {Coordinate{21.198, 48.3089}, CountryId{"HU"}}, // Abaújkér railway station
    {Coordinate{21.2087, 48.345}, CountryId{"HU"}}, // Boldogkőváralja railway station
    {Coordinate{21.2192, 48.3647}, CountryId{"HU"}}, // Korlát-Vizsoly railway station
    {Coordinate{21.2424, 48.411}, CountryId{"HU"}}, // Fony railway station
    {Coordinate{21.2455, 48.4193}, CountryId{"HU"}}, // Hejce-Vilmány railway station
    {Coordinate{21.2471, 48.4454}, CountryId{"HU"}}, // Göncruszka railway station
    {Coordinate{21.2616, 48.4705}, CountryId{"HU"}}, // Gönc railway station
    {Coordinate{21.2647, 48.4922}, CountryId{"HU"}}, // Zsujta railway station
    {Coordinate{21.5887, 47.5292}, CountryId{"HU"}}, // Tócóvölgy railway station
    {Coordinate{21.5847, 47.6005}, CountryId{"HU"}}, // Józsa railway station
    {Coordinate{21.5784, 47.6082}, CountryId{"HU"}}, // Hajdúszentgyörgy railway station
    {Coordinate{21.5784, 47.6268}, CountryId{"HU"}}, // Zelemér railway station
    {Coordinate{21.5082, 47.7486}, CountryId{"HU"}}, // Hajdúvid railway station
    {Coordinate{21.524, 47.6688}, CountryId{"HU"}}, // Hajdúböszörmény railway station
    {Coordinate{21.4276, 47.8319}, CountryId{"HU"}}, // Hajdúnánás railway station
    {Coordinate{21.4076, 47.8428}, CountryId{"HU"}}, // Hajdúnánás-Vásártér railway station
    {Coordinate{21.4931, 47.8054}, CountryId{"HU"}}, // Hajdúdorog railway station
    {Coordinate{21.4041, 47.9027}, CountryId{"HU"}}, // Tedej railway station
    {Coordinate{21.375, 47.9453}, CountryId{"HU"}}, // Tiszavasvári railway station
    {Coordinate{21.365, 47.9725}, CountryId{"HU"}}, // Q22075991
    {Coordinate{21.3653, 47.9788}, CountryId{"HU"}}, // Q22075994
    {Coordinate{21.4457, 47.5812}, CountryId{"HU"}}, // Nagyhát railway station
    {Coordinate{21.348, 47.6139}, CountryId{"HU"}}, // Balmazújváros railway station
    {Coordinate{21.2376, 47.6007}, CountryId{"HU"}}, // Kónya railway station
    {Coordinate{21.1541, 47.5861}, CountryId{"HU"}}, // Hortobágy railway station
    {Coordinate{21.0741, 47.6039}, CountryId{"HU"}}, // Hortobágyi Halastó railway station
    {Coordinate{20.951, 47.6234}, CountryId{"HU"}}, // Ohat-Pusztakócs railway station
    {Coordinate{20.8837, 47.6167}, CountryId{"HU"}}, // Egyek railway station
    {Coordinate{35.0769, 47.8322}, CountryId{"UA"}}, // Zaporizka Sich
    {Coordinate{20.6546, 47.6579}, CountryId{"HU"}}, // Poroszló railway station
    {Coordinate{20.5645, 47.6944}, CountryId{"HU"}}, // Kétútköz railway station
    {Coordinate{20.5224, 47.7115}, CountryId{"HU"}}, // Egerfarmos railway station
    {Coordinate{20.4802, 47.7252}, CountryId{"HU"}}, // Mezőtárkány railway station
    {Coordinate{21.6587, 47.5277}, CountryId{"HU"}}, // Debrecen-Szabadságtelep
    {Coordinate{21.9658, 47.5198}, CountryId{"HU"}}, // Q22076759
    {Coordinate{21.7136, 47.5252}, CountryId{"HU"}}, // Q22076761
    {Coordinate{21.7633, 47.5238}, CountryId{"HU"}}, // Q22076763
    {Coordinate{21.8187, 47.5216}, CountryId{"HU"}}, // Q22076764
    {Coordinate{21.894, 47.5179}, CountryId{"HU"}}, // Q22076765
    {Coordinate{22.0166, 47.5238}, CountryId{"HU"}}, // Nyírábrány railway station
    {Coordinate{21.7957, 47.6327}, CountryId{"HU"}}, // Q22077094
    {Coordinate{21.8238, 47.6445}, CountryId{"HU"}}, // Q22077096
    {Coordinate{21.8427, 47.6629}, CountryId{"HU"}}, // Q22077097
    {Coordinate{21.7548, 47.6081}, CountryId{"HU"}}, // Q22077099
    {Coordinate{21.7065, 47.6029}, CountryId{"HU"}}, // Q22077100
    {Coordinate{21.9025, 47.699}, CountryId{"HU"}}, // Nyíradony railway station
    {Coordinate{21.9588, 47.7374}, CountryId{"HU"}}, // Q22077171
    {Coordinate{21.9879, 47.7509}, CountryId{"HU"}}, // Q22077173
    {Coordinate{22.0671, 47.7932}, CountryId{"HU"}}, // Q22077176
    {Coordinate{22.1794, 47.8658}, CountryId{"HU"}}, // Q22077181
    {Coordinate{22.2138, 47.8962}, CountryId{"HU"}}, // Q22077182
    {Coordinate{22.2566, 47.9226}, CountryId{"HU"}}, // Q22077184
    {Coordinate{22.1316, 47.8426}, CountryId{"HU"}}, // Q22077190
    {Coordinate{21.8257, 47.8709}, CountryId{"HU"}}, // Q22077262
    {Coordinate{21.935, 47.8545}, CountryId{"HU"}}, // Q22077263
    {Coordinate{22.0191, 47.8529}, CountryId{"HU"}}, // Q22077264
    {Coordinate{-1.345, 43.2681}, CountryId{"FR"}}, // Bidarrai-Nobilia Zubia/Bidarray-Pont Nobilia station
    {Coordinate{22.3757, 47.942}, CountryId{"HU"}}, // Q22078557
    {Coordinate{22.4014, 47.9463}, CountryId{"HU"}}, // Q22078558
    {Coordinate{22.4247, 47.9368}, CountryId{"HU"}}, // Q22078559
    {Coordinate{22.4434, 47.9211}, CountryId{"HU"}}, // Q22078560
    {Coordinate{22.4965, 47.9109}, CountryId{"HU"}}, // Q22078561
    {Coordinate{22.5684, 47.8681}, CountryId{"HU"}}, // Q22078562
    {Coordinate{22.6665, 47.8262}, CountryId{"HU"}}, // Csenger railway station
    {Coordinate{10.7666, 46.6261}, CountryId{"IT"}}, // Schlanders train station
    {Coordinate{2.31384, 48.8628}, CountryId{"FR"}}, // Invalides
    {Coordinate{22.4426, 47.9606}, CountryId{"HU"}}, // Q22086181
    {Coordinate{22.5243, 47.9788}, CountryId{"HU"}}, // Q22086182
    {Coordinate{22.4648, 47.9661}, CountryId{"HU"}}, // Q22086185
    {Coordinate{22.5672, 47.9953}, CountryId{"HU"}}, // Penyige railway station
    {Coordinate{22.6135, 47.9759}, CountryId{"HU"}}, // Q22086219
    {Coordinate{22.6298, 47.9659}, CountryId{"HU"}}, // Q22086220
    {Coordinate{22.6571, 47.9421}, CountryId{"HU"}}, // Q22086221
    {Coordinate{22.7451, 47.9263}, CountryId{"HU"}}, // Q22086222
    {Coordinate{22.7823, 47.9129}, CountryId{"HU"}}, // Q22086223
    {Coordinate{22.7953, 47.903}, CountryId{"HU"}}, // Zajta railway station
    {Coordinate{19.5514, 47.0061}, CountryId{"HU"}}, // Klábertelep railway station
    {Coordinate{19.5578, 46.987}, CountryId{"HU"}}, // Felsőméntelek railway station
    {Coordinate{19.5707, 46.9787}, CountryId{"HU"}}, // Méntelek railway station
    {Coordinate{19.579, 46.9616}, CountryId{"HU"}}, // Alsóméntelek railway station
    {Coordinate{19.5949, 46.9309}, CountryId{"HU"}}, // Hetényegyháza railway station
    {Coordinate{19.6205, 46.918}, CountryId{"HU"}}, // Úrihegy railway station
    {Coordinate{19.6308, 46.9134}, CountryId{"HU"}}, // Miklóstelep railway station
    {Coordinate{19.6758, 46.9013}, CountryId{"HU"}}, // Kecskemét-Máriaváros railway station
    {Coordinate{19.6922, 46.8957}, CountryId{"HU"}}, // Kecskemét alsó railway station
    {Coordinate{18.2837, 47.0697}, CountryId{"HU"}}, // Polgárdi railway station
    {Coordinate{18.2558, 47.0501}, CountryId{"HU"}}, // Füle railway station
    {Coordinate{18.2142, 47.0312}, CountryId{"HU"}}, // Balatonfőkajár felső railway station
    {Coordinate{18.1862, 47.0338}, CountryId{"HU"}}, // Csajág railway station
    {Coordinate{18.1678, 47.0174}, CountryId{"HU"}}, // Balatonakarattya railway station
    {Coordinate{18.1375, 47.0253}, CountryId{"HU"}}, // Csittényhegy railway station
    {Coordinate{18.1055, 47.0325}, CountryId{"HU"}}, // Balatonkenese railway station
    {Coordinate{18.0426, 47.0599}, CountryId{"HU"}}, // Balatonfűzfő railway station
    {Coordinate{18.015, 47.0283}, CountryId{"HU"}}, // Balatonalmádi railway station
    {Coordinate{18.3142, 47.0794}, CountryId{"HU"}}, // Polgárdi-Ipartelepek railway station
    {Coordinate{18.004, 47.0102}, CountryId{"HU"}}, // Káptalanfüred railway station
    {Coordinate{17.9759, 46.9852}, CountryId{"HU"}}, // Alsóörs railway station
    {Coordinate{17.9312, 46.9745}, CountryId{"HU"}}, // Csopak railway station
    {Coordinate{17.8975, 46.9625}, CountryId{"HU"}}, // Balatonarács railway station
    {Coordinate{17.8831, 46.9561}, CountryId{"HU"}}, // Balatonfüred railway station
    {Coordinate{17.8325, 46.9254}, CountryId{"HU"}}, // Aszófő railway station
    {Coordinate{17.8182, 46.9123}, CountryId{"HU"}}, // Örvényes railway station
    {Coordinate{17.7896, 46.8935}, CountryId{"HU"}}, // Fövenyes railway station
    {Coordinate{17.7085, 46.8775}, CountryId{"HU"}}, // Zánkafürdő railway station
    {Coordinate{17.6877, 46.8728}, CountryId{"HU"}}, // Zánka-Köveskál railway station
    {Coordinate{17.6633, 46.8512}, CountryId{"HU"}}, // Balatonszepezd railway station
    {Coordinate{17.6324, 46.8291}, CountryId{"HU"}}, // Révfülöp railway station
    {Coordinate{17.8077, 46.9046}, CountryId{"HU"}}, // Balatonudvari railway station
    {Coordinate{17.7481, 46.8798}, CountryId{"HU"}}, // Balatonakali-Dörgicse railway station
    {Coordinate{17.6497, 46.8397}, CountryId{"HU"}}, // Szepezdfürdő railway station
    {Coordinate{17.5841, 46.8255}, CountryId{"HU"}}, // Balatonrendes railway station
    {Coordinate{17.572, 46.8149}, CountryId{"HU"}}, // Ábrahámhegy railway station
    {Coordinate{17.4741, 46.7907}, CountryId{"HU"}}, // Badacsonylábdihegy railway station
    {Coordinate{17.5299, 46.8065}, CountryId{"HU"}}, // Badacsonyörs railway station
    {Coordinate{17.5182, 46.8046}, CountryId{"HU"}}, // Badacsonytomaj railway station
    {Coordinate{17.5065, 46.7885}, CountryId{"HU"}}, // Badacsony railway station
    {Coordinate{17.469, 46.8098}, CountryId{"HU"}}, // Badacsonytördemic-Szigliget railway station
    {Coordinate{17.4763, 46.837}, CountryId{"HU"}}, // Nemesgulács-Kisapáti railway station
    {Coordinate{1.91921, 49.0067}, CountryId{"FR"}}, // Q2209315
    {Coordinate{17.5992, 47.6216}, CountryId{"HU"}}, // Ménfőcsanak railway station
    {Coordinate{17.6144, 47.6378}, CountryId{"HU"}}, // Ménfőcsanak felső railway station
    {Coordinate{17.5847, 47.5672}, CountryId{"HU"}}, // Győrszemere railway station
    {Coordinate{17.5606, 47.5202}, CountryId{"HU"}}, // Halipuszta railway station
    {Coordinate{17.5595, 47.5016}, CountryId{"HU"}}, // Gyömöre-Tét railway station
    {Coordinate{17.5588, 47.4853}, CountryId{"HU"}}, // Gyömöre railway station
    {Coordinate{17.5151, 47.4562}, CountryId{"HU"}}, // Gecse-Gyarmat railway station
    {Coordinate{17.4963, 47.4025}, CountryId{"HU"}}, // Vaszar railway station
    {Coordinate{17.5474, 47.4692}, CountryId{"HU"}}, // Szerecseny railway station
    {Coordinate{17.3642, 47.3235}, CountryId{"HU"}}, // Mezőlak railway station
    {Coordinate{17.3293, 47.3185}, CountryId{"HU"}}, // Mihályháza railway station
    {Coordinate{17.2826, 47.3057}, CountryId{"HU"}}, // Vinár railway station
    {Coordinate{17.2217, 47.28}, CountryId{"HU"}}, // Külsővat railway station
    {Coordinate{17.1091, 47.279}, CountryId{"HU"}}, // Kemenesmihályfa railway station
    {Coordinate{17.0575, 47.2656}, CountryId{"HU"}}, // Nagysimonyi railway station
    {Coordinate{17.0242, 47.2839}, CountryId{"HU"}}, // Ostffyasszonyfa railway station
    {Coordinate{17.188, 47.2039}, CountryId{"HU"}}, // Nemeskocs railway station
    {Coordinate{17.3165, 47.5222}, CountryId{"HU"}}, // Egyed-Rábacsanak railway station
    {Coordinate{17.3152, 47.4607}, CountryId{"HU"}}, // Szany-Rábaszentandrás railway station
    {Coordinate{17.3489, 47.4277}, CountryId{"HU"}}, // Marcaltő railway station
    {Coordinate{17.3766, 47.4028}, CountryId{"HU"}}, // Nemesgörzsöny railway station
    {Coordinate{17.3152, 47.5574}, CountryId{"HU"}}, // Rábapordány railway station
    {Coordinate{17.3377, 47.4385}, CountryId{"HU"}}, // Rábahíd railway station
    {Coordinate{2.36867, 46.8017}, CountryId{"FR"}}, // Q2209490
    {Coordinate{2.30167, 48.6064}, CountryId{"FR"}}, // Brétigny (Paris RER)
    {Coordinate{113.556, 56.1924}, CountryId{"RU"}}, // Okusikan
    {Coordinate{77.9781, 44.3569}, CountryId{"KZ"}}, // Sary-Ozek station
    {Coordinate{2.145, 48.4275}, CountryId{"FR"}}, // Saint-Martin-d'Étampes
    {Coordinate{5.58556, 50.4858}, CountryId{"BE"}}, // Rivage railway station
    {Coordinate{12.3989, 50.1472}, CountryId{"CZ"}}, // Nový Drahov (train station)
    {Coordinate{18.1225, 47.1673}, CountryId{"HU"}}, // Pétfürdő railway station
    {Coordinate{18.0749, 47.1598}, CountryId{"HU"}}, // Öskü railway station
    {Coordinate{18.0095, 47.141}, CountryId{"HU"}}, // Hajmáskér railway station
    {Coordinate{17.1829, 47.1393}, CountryId{"HU"}}, // Kemenespálfa railway station
    {Coordinate{17.1718, 47.1158}, CountryId{"HU"}}, // Jánosháza railway station
    {Coordinate{17.1839, 47.0932}, CountryId{"HU"}}, // Nemeskeresztúr railway station
    {Coordinate{17.1994, 47.0606}, CountryId{"HU"}}, // Rigács railway station
    {Coordinate{16.9966, 46.9591}, CountryId{"HU"}}, // Pakod railway station
    {Coordinate{16.972, 46.9245}, CountryId{"HU"}}, // Pókaszepetk railway station
    {Coordinate{16.9466, 46.9057}, CountryId{"HU"}}, // Kemendollár railway station
    {Coordinate{16.9087, 46.8875}, CountryId{"HU"}}, // Zalaszentiván railway station
    {Coordinate{17.1669, 47.0258}, CountryId{"HU"}}, // Dabronc railway station
    {Coordinate{17.0946, 46.9952}, CountryId{"HU"}}, // Türje railway station
    {Coordinate{17.0406, 46.9831}, CountryId{"HU"}}, // Zalabér-Batyk railway station
    {Coordinate{16.8375, 46.8513}, CountryId{"HU"}}, // Zalaegerszeg-Ola railway station
    {Coordinate{16.7794, 46.8626}, CountryId{"HU"}}, // Andráshida railway station
    {Coordinate{16.746, 46.875}, CountryId{"HU"}}, // Bagod railway station
    {Coordinate{16.7115, 46.8719}, CountryId{"HU"}}, // Zalaszentgyörgy railway station
    {Coordinate{16.6613, 46.8578}, CountryId{"HU"}}, // Zalacséb-Salomvár railway station
    {Coordinate{16.625, 46.8516}, CountryId{"HU"}}, // Budafa railway station
    {Coordinate{16.6041, 46.8455}, CountryId{"HU"}}, // Zalapatakalja railway station
    {Coordinate{16.5436, 46.8414}, CountryId{"HU"}}, // Felsőjánosfa railway station
    {Coordinate{16.4976, 46.8361}, CountryId{"HU"}}, // Pankasz railway station
    {Coordinate{16.4557, 46.8272}, CountryId{"HU"}}, // Nagyrákos railway station
    {Coordinate{16.4161, 46.8292}, CountryId{"HU"}}, // Őriszentpéter railway station
    {Coordinate{16.3581, 46.8181}, CountryId{"HU"}}, // Bajánsenye railway station
    {Coordinate{2.89701, 48.3788}, CountryId{"FR"}}, // Gare de La Grande-Paroisse
    {Coordinate{17.3315, 47.1287}, CountryId{"HU"}}, // Tüskevár railway station
    {Coordinate{17.8108, 47.1269}, CountryId{"HU"}}, // Márkó railway station
    {Coordinate{17.7607, 47.137}, CountryId{"HU"}}, // Herend railway station
    {Coordinate{17.7073, 47.1365}, CountryId{"HU"}}, // Szentgál railway station
    {Coordinate{17.6531, 47.1445}, CountryId{"HU"}}, // Városlőd railway station
    {Coordinate{17.6296, 47.1332}, CountryId{"HU"}}, // Városlőd-Kislőd railway station
    {Coordinate{17.5553, 47.0968}, CountryId{"HU"}}, // Ajka-Gyártelep railway station
    {Coordinate{17.4357, 47.1123}, CountryId{"HU"}}, // Devecser railway station
    {Coordinate{17.3689, 47.1244}, CountryId{"HU"}}, // Somlóvásárhely railway station
    {Coordinate{17.2882, 47.1336}, CountryId{"HU"}}, // Karakószörcsök railway station
    {Coordinate{17.2384, 47.1515}, CountryId{"HU"}}, // Kerta railway station
    {Coordinate{16.8006, 46.6699}, CountryId{"HU"}}, // Q22116522
    {Coordinate{16.6852, 46.6265}, CountryId{"HU"}}, // Q22116523
    {Coordinate{16.6418, 46.6078}, CountryId{"HU"}}, // Q22116524
    {Coordinate{16.6035, 46.6032}, CountryId{"HU"}}, // Q22116525
    {Coordinate{16.8534, 46.7783}, CountryId{"HU"}}, // Q22116526
    {Coordinate{16.8492, 46.732}, CountryId{"HU"}}, // Q22116527
    {Coordinate{16.74, 46.6469}, CountryId{"HU"}}, // Q22116528
    {Coordinate{16.5725, 46.6113}, CountryId{"HU"}}, // Q22116529
    {Coordinate{16.5297, 46.6212}, CountryId{"HU"}}, // Q22116530
    {Coordinate{16.4711, 46.618}, CountryId{"HU"}}, // Rédics railway station
    {Coordinate{16.8513, 46.7552}, CountryId{"HU"}}, // Q22116532
    {Coordinate{16.7666, 46.6551}, CountryId{"HU"}}, // Q22116533
    {Coordinate{16.8247, 46.6907}, CountryId{"HU"}}, // Q22116537
    {Coordinate{17.2077, 47.0212}, CountryId{"HU"}}, // Gógánfa railway station
    {Coordinate{17.2208, 47.011}, CountryId{"HU"}}, // Zalagyömörő railway station
    {Coordinate{17.2475, 46.9976}, CountryId{"HU"}}, // Nyírlak railway station
    {Coordinate{17.2707, 46.9811}, CountryId{"HU"}}, // Sümeg railway station
    {Coordinate{17.3316, 46.9204}, CountryId{"HU"}}, // Uzsa railway station
    {Coordinate{17.3453, 46.8983}, CountryId{"HU"}}, // Uzsabánya alsó railway station
    {Coordinate{17.2925, 46.9523}, CountryId{"HU"}}, // Sümegi Bazaltbánya railway station
    {Coordinate{17.3182, 46.7552}, CountryId{"HU"}}, // Vonyarcvashegy railway station
    {Coordinate{17.2924, 46.7633}, CountryId{"HU"}}, // Gyenesdiás railway station
    {Coordinate{17.4125, 46.8508}, CountryId{"HU"}}, // Raposka railway station
    {Coordinate{17.3845, 46.8026}, CountryId{"HU"}}, // Balatonederics train station
    {Coordinate{17.3726, 46.7761}, CountryId{"HU"}}, // Becehegy railway station
    {Coordinate{17.3542, 46.752}, CountryId{"HU"}}, // Balatongyörök railway station
    {Coordinate{17.2766, 46.7659}, CountryId{"HU"}}, // Alsógyenes railway station
    {Coordinate{17.2488, 46.7117}, CountryId{"HU"}}, // Fenékpuszta railway station
    {Coordinate{17.2353, 46.6092}, CountryId{"HU"}}, // Sávoly railway station
    {Coordinate{17.1883, 46.53}, CountryId{"HU"}}, // Zalakomár railway station
    {Coordinate{17.1354, 46.4915}, CountryId{"HU"}}, // Zalaszentjakab railway station
    {Coordinate{17.0436, 46.4638}, CountryId{"HU"}}, // Nagyrécse railway station
    {Coordinate{17.26, 46.6634}, CountryId{"HU"}}, // Vörs railway station
    {Coordinate{16.9327, 46.7923}, CountryId{"HU"}}, // Búcsúszentlászló railway station
    {Coordinate{16.9519, 46.7233}, CountryId{"HU"}}, // Zalaszentmihály-Pacsa railway station
    {Coordinate{16.9827, 46.6003}, CountryId{"HU"}}, // Gelse railway station
    {Coordinate{16.9364, 46.8542}, CountryId{"HU"}}, // Alsónemesapáti railway station
    {Coordinate{16.935, 46.8322}, CountryId{"HU"}}, // Nagykapornak railway station
    {Coordinate{16.98, 46.5193}, CountryId{"HU"}}, // Újudvar railway station
    {Coordinate{16.958, 46.682}, CountryId{"HU"}}, // Pötréte railway station
    {Coordinate{16.9827, 46.667}, CountryId{"HU"}}, // Felsőrajk railway station
    {Coordinate{16.5886, 47.3164}, CountryId{"HU"}}, // Gyöngyösfalu railway station
    {Coordinate{16.6259, 47.2543}, CountryId{"HU"}}, // Kámon railway station
    {Coordinate{16.6001, 47.2858}, CountryId{"HU"}}, // Gencsapáti alsó railway station
    {Coordinate{16.5938, 47.2995}, CountryId{"HU"}}, // Gencsapáti felső railway station
    {Coordinate{16.5852, 47.3266}, CountryId{"HU"}}, // Lukácsháza alsó railway station
    {Coordinate{16.5804, 47.3408}, CountryId{"HU"}}, // Lukácsháza railway station
    {Coordinate{16.5674, 47.3618}, CountryId{"HU"}}, // Kőszegfalva railway station
    {Coordinate{16.5568, 47.3815}, CountryId{"HU"}}, // Kőszeg railway station
    {Coordinate{5.90332, 45.6485}, CountryId{"FR"}}, // Viviers-du-Lac
    {Coordinate{1.94072, 49.6618}, CountryId{"FR"}}, // Gare de Grandvilliers
    {Coordinate{18.1185, 46.9341}, CountryId{"HU"}}, // Szabadisóstó railway station
    {Coordinate{18.0999, 46.9244}, CountryId{"HU"}}, // Szabadifürdő railway station
    {Coordinate{18.3549, 47.0481}, CountryId{"HU"}}, // Kiscséripuszta railway station
    {Coordinate{18.3006, 47.019}, CountryId{"HU"}}, // Polgárdi-Tekerespuszta railway station
    {Coordinate{18.2475, 46.9874}, CountryId{"HU"}}, // Lepsény railway station
    {Coordinate{18.1576, 46.9639}, CountryId{"HU"}}, // Balatonvilágos railway station
    {Coordinate{16.9215, 46.3791}, CountryId{"HU"}}, // Fityeház railway station
    {Coordinate{16.8775, 46.3263}, CountryId{"HU"}}, // Belezna railway station
    {Coordinate{16.938, 46.255}, CountryId{"HU"}}, // Zákány railway station
    {Coordinate{16.8766, 46.3638}, CountryId{"HU"}}, // Murakeresztúr railway station
    {Coordinate{16.8877, 46.2978}, CountryId{"HU"}}, // Őrtilos railway station
    {Coordinate{17.3543, 46.2284}, CountryId{"HU"}}, // Q22121789
    {Coordinate{18.1101, 46.7461}, CountryId{"HU"}}, // Bábonymegyer railway station
    {Coordinate{18.0411, 46.7341}, CountryId{"HU"}}, // Tab railway station
    {Coordinate{18.1254, 46.8806}, CountryId{"HU"}}, // Siójut railway station
    {Coordinate{18.1414, 46.8541}, CountryId{"HU"}}, // Ádánd railway station
    {Coordinate{18.1494, 46.8028}, CountryId{"HU"}}, // Som-Nagyberény railway station
    {Coordinate{18.1469, 46.7667}, CountryId{"HU"}}, // Daránypuszta railway station
    {Coordinate{18.077, 46.9112}, CountryId{"HU"}}, // Sióvölgy railway station
    {Coordinate{17.9777, 46.7136}, CountryId{"HU"}}, // Kapoly railway station
    {Coordinate{17.8749, 46.6811}, CountryId{"HU"}}, // Karád railway station
    {Coordinate{17.9207, 46.7204}, CountryId{"HU"}}, // Somogymeggyes railway station
    {Coordinate{17.8922, 46.6473}, CountryId{"HU"}}, // Andocs railway station
    {Coordinate{17.9107, 46.6091}, CountryId{"HU"}}, // Bonnya railway station
    {Coordinate{17.8216, 46.5593}, CountryId{"HU"}}, // Felsőmocsolád railway station
    {Coordinate{17.8668, 46.615}, CountryId{"HU"}}, // Kisbárapáti railway station
    {Coordinate{17.8324, 46.5081}, CountryId{"HU"}}, // Mernye railway station
    {Coordinate{17.8406, 46.4537}, CountryId{"HU"}}, // Somogyaszaló railway station
    {Coordinate{17.8399, 46.3957}, CountryId{"HU"}}, // Toponár railway station
    {Coordinate{17.8201, 46.3566}, CountryId{"HU"}}, // Kaposszentjakab railway station
    {Coordinate{17.8475, 46.4303}, CountryId{"HU"}}, // Répáspuszta railway station
    {Coordinate{17.8367, 46.4724}, CountryId{"HU"}}, // Somodor railway station
    {Coordinate{18.1565, 46.1931}, CountryId{"HU"}}, // Magyarhertelend railway station
    {Coordinate{18.186, 46.2102}, CountryId{"HU"}}, // Magyarszék railway station
    {Coordinate{18.2135, 46.2241}, CountryId{"HU"}}, // Mecsekpölöske railway station
    {Coordinate{18.2653, 46.1891}, CountryId{"HU"}}, // Komló railway station
    {Coordinate{18.1289, 46.2}, CountryId{"HU"}}, // Bodolyabér railway station
    {Coordinate{18.2419, 46.2163}, CountryId{"HU"}}, // Mecsekjánosi railway station
    {Coordinate{4.99954, 43.5805}, CountryId{"FR"}}, // Miramas Station
    {Coordinate{15.7081, 51.7992}, CountryId{"PL"}}, // Nowa Sól
    {Coordinate{13.3036, 49.7517}, CountryId{"CZ"}}, // Q2212512
    {Coordinate{3.10583, 42.5189}, CountryId{"FR"}}, // Port-Ventres railway station
    {Coordinate{8.947, 44.4066}, CountryId{"IT"}}, // Genova Brignole
    {Coordinate{17.5946, 46.6866}, CountryId{"HU"}}, // Pusztaberény railway station
    {Coordinate{17.6134, 46.6607}, CountryId{"HU"}}, // Lengyeltóti railway station
    {Coordinate{17.6212, 46.6366}, CountryId{"HU"}}, // Tatárvár railway station
    {Coordinate{17.6328, 46.6088}, CountryId{"HU"}}, // Öreglak railway station
    {Coordinate{17.6348, 46.5805}, CountryId{"HU"}}, // Somogyvár railway station
    {Coordinate{17.6341, 46.5572}, CountryId{"HU"}}, // Pamuk railway station
    {Coordinate{17.6572, 46.5145}, CountryId{"HU"}}, // Osztopán railway station
    {Coordinate{17.7594, 46.4149}, CountryId{"HU"}}, // Kaposfüred railway station
    {Coordinate{17.6945, 46.4907}, CountryId{"HU"}}, // Somogyjád railway station
    {Coordinate{17.7252, 46.4605}, CountryId{"HU"}}, // Várda railway station
    {Coordinate{17.7742, 46.366}, CountryId{"HU"}}, // Kapostüskevár railway station
    {Coordinate{18.7829, 46.8659}, CountryId{"HU"}}, // Nagykarácsony felső railway station
    {Coordinate{18.7658, 46.8487}, CountryId{"HU"}}, // Nagykarácsony railway station
    {Coordinate{18.6574, 46.832}, CountryId{"HU"}}, // Alap railway station
    {Coordinate{18.6372, 46.8288}, CountryId{"HU"}}, // Rétszilas alsó railway station
    {Coordinate{18.8105, 46.9053}, CountryId{"HU"}}, // Mezőfalva railway station
    {Coordinate{18.8713, 46.9372}, CountryId{"HU"}}, // Újvenyim railway station
    {Coordinate{85.5909, 20.6768}, CountryId{"IN"}}, // Dhenkanal railway station
    {Coordinate{16.8557, 47.3269}, CountryId{"HU"}}, // Pósfa railway station
    {Coordinate{16.8984, 47.3578}, CountryId{"HU"}}, // Hegyfalu railway station
    {Coordinate{16.9283, 47.3745}, CountryId{"HU"}}, // Vasegerszeg railway station
    {Coordinate{16.9614, 47.3853}, CountryId{"HU"}}, // Vámoscsalád railway station
    {Coordinate{17.009, 47.419}, CountryId{"HU"}}, // Répcelak railway station
    {Coordinate{17.0261, 47.4303}, CountryId{"HU"}}, // Csánig railway station
    {Coordinate{17.055, 47.4487}, CountryId{"HU"}}, // Dénesfa railway station
    {Coordinate{17.0847, 47.4667}, CountryId{"HU"}}, // Beled railway station
    {Coordinate{17.1117, 47.4777}, CountryId{"HU"}}, // Vica railway station
    {Coordinate{17.1762, 47.5142}, CountryId{"HU"}}, // Magyarkeresztúr-Zsebeháza railway station
    {Coordinate{17.1373, 47.4922}, CountryId{"HU"}}, // Páli-Vadosfa railway station
    {Coordinate{17.2096, 47.5334}, CountryId{"HU"}}, // Szil-Sopronnémeti railway station
    {Coordinate{17.2342, 47.6854}, CountryId{"HU"}}, // Bősárkány railway station
    {Coordinate{17.2155, 47.72}, CountryId{"HU"}}, // Hanságliget railway station
    {Coordinate{17.1891, 47.7411}, CountryId{"HU"}}, // Hanság-Nagyerdő railway station
    {Coordinate{17.1376, 47.7891}, CountryId{"HU"}}, // Jánossomorja railway station
    {Coordinate{17.1605, 47.8526}, CountryId{"HU"}}, // Mosonszolnok railway station
    {Coordinate{-1.32178, 48.1092}, CountryId{"FR"}}, // Q2213900
    {Coordinate{13.6561, 49.755}, CountryId{"CZ"}}, // Q2213987
    {Coordinate{16.8338, 47.0098}, CountryId{"HU"}}, // Pácsony railway station
    {Coordinate{16.8422, 46.9897}, CountryId{"HU"}}, // Győrvár railway station
    {Coordinate{16.8625, 46.9419}, CountryId{"HU"}}, // Egervár-Vasboldogasszony railway station
    {Coordinate{16.6572, 47.2029}, CountryId{"HU"}}, // Gyöngyöshermán railway station
    {Coordinate{16.7197, 47.1369}, CountryId{"HU"}}, // Sorkifalud railway station
    {Coordinate{16.7337, 47.1219}, CountryId{"HU"}}, // Szentléránt railway station
    {Coordinate{16.7686, 47.0849}, CountryId{"HU"}}, // Püspökmolnári railway station
    {Coordinate{16.81, 47.0574}, CountryId{"HU"}}, // Vasvár railway station
    {Coordinate{16.8773, 46.9141}, CountryId{"HU"}}, // Zalaszentlőrinc railway station
    {Coordinate{6.74833, 53.3344}, CountryId{"NL"}}, // Loppersum railway station
    {Coordinate{7.22694, 51.9825}, CountryId{"DE"}}, // Lutum station
    {Coordinate{5.69684, 44.6693}, CountryId{"FR"}}, // Q2215039
    {Coordinate{1.97101, 50.8921}, CountryId{"FR"}}, // Pont-d'Ardres
    {Coordinate{19.7536, 46.8158}, CountryId{"HU"}}, // Városföld railway station
    {Coordinate{19.7687, 46.781}, CountryId{"HU"}}, // Kunszállás railway station
    {Coordinate{19.8264, 47.1684}, CountryId{"HU"}}, // Ceglédi szállások railway station
    {Coordinate{19.7925, 47.1003}, CountryId{"HU"}}, // Nyársapát railway station
    {Coordinate{19.9286, 46.5143}, CountryId{"HU"}}, // Kisteleki szőlők railway station
    {Coordinate{19.8535, 46.6555}, CountryId{"HU"}}, // Selymes railway station
    {Coordinate{19.8655, 46.6173}, CountryId{"HU"}}, // Petőfiszállás railway station
    {Coordinate{19.8748, 46.5877}, CountryId{"HU"}}, // Petőfiszállási tanyák railway station
    {Coordinate{19.9876, 46.4353}, CountryId{"HU"}}, // Kapitányság railway station
    {Coordinate{20.0014, 46.4135}, CountryId{"HU"}}, // Balástya railway station
    {Coordinate{20.0159, 46.3904}, CountryId{"HU"}}, // Őszeszék railway station
    {Coordinate{20.0309, 46.3664}, CountryId{"HU"}}, // Vilmaszállás railway station
    {Coordinate{20.0512, 46.3343}, CountryId{"HU"}}, // Jánosszállás railway station
    {Coordinate{20.0909, 46.2713}, CountryId{"HU"}}, // Kiskundorozsma railway station
    {Coordinate{4.45111, 51.4625}, CountryId{"BE"}}, // Wildert railway station
    {Coordinate{3.30278, 48.0268}, CountryId{"FR"}}, // Gare de Saint-Julien-du-Sault
    {Coordinate{4.079, 45.6038}, CountryId{"FR"}}, // Q2217344
    {Coordinate{6.8934, 51.0146}, CountryId{"DE"}}, // Köln-Volkhovener Weg station
    {Coordinate{-0.908241, 44.0336}, CountryId{"FR"}}, // Morcenx
    {Coordinate{2.5075, 48.7708}, CountryId{"FR"}}, // Sucy – Bonneuil (Paris RER)
    {Coordinate{7.27942, 48.0858}, CountryId{"FR"}}, // Gare de Turckheim
    {Coordinate{3.98333, 50.9433}, CountryId{"BE"}}, // Vijfhuizen railway station
    {Coordinate{-0.767612, 43.4841}, CountryId{"FR"}}, // Gare d'Orthez
    {Coordinate{15.5144, 51.9475}, CountryId{"PL"}}, // Zielona Góra
    {Coordinate{-1.23884, 43.1681}, CountryId{"FR"}}, // Donibane Garazi/Saint-Jean-Pied-de-Port station
    {Coordinate{1.38947, 44.742}, CountryId{"FR"}}, // Gare de Gourdon
    {Coordinate{6.71811, 51.2061}, CountryId{"DE"}}, // Neuss Rheinpark-Center station
    {Coordinate{2.24167, 49.3544}, CountryId{"FR"}}, // Gare d'Hermes-Berthecourt
    {Coordinate{2.73601, 50.8544}, CountryId{"BE"}}, // Poperinge railway station
    {Coordinate{1.9743, 43.6562}, CountryId{"FR"}}, // Q2222023
    {Coordinate{18.1341, 46.3638}, CountryId{"HU"}}, // Dombóvár alsó railway station
    {Coordinate{18.0968, 46.3731}, CountryId{"HU"}}, // Kapospula railway station
    {Coordinate{18.045, 46.3666}, CountryId{"HU"}}, // Csoma-Szabadi railway station
    {Coordinate{18.0078, 46.3562}, CountryId{"HU"}}, // Nagyberki railway station
    {Coordinate{17.9609, 46.3556}, CountryId{"HU"}}, // Baté railway station
    {Coordinate{17.9218, 46.3674}, CountryId{"HU"}}, // Kaposhomok railway station
    {Coordinate{17.8937, 46.3635}, CountryId{"HU"}}, // Taszár railway station
    {Coordinate{18.0675, 46.3687}, CountryId{"HU"}}, // Attala railway station
    {Coordinate{17.7244, 46.367}, CountryId{"HU"}}, // Kaposújlak railway station
    {Coordinate{17.6996, 46.3654}, CountryId{"HU"}}, // Kaposmérő railway station
    {Coordinate{17.6604, 46.3642}, CountryId{"HU"}}, // Kaposfő railway station
    {Coordinate{17.6089, 46.3623}, CountryId{"HU"}}, // Kiskorpád railway station
    {Coordinate{17.5553, 46.3446}, CountryId{"HU"}}, // Jákó-Nagybajom railway station
    {Coordinate{17.4534, 46.326}, CountryId{"HU"}}, // Kutas railway station
    {Coordinate{17.4206, 46.3167}, CountryId{"HU"}}, // Beleg railway station
    {Coordinate{17.3579, 46.2927}, CountryId{"HU"}}, // Ötvöskónyi railway station
    {Coordinate{17.1809, 46.2737}, CountryId{"HU"}}, // Szenta railway station
    {Coordinate{17.0209, 46.2532}, CountryId{"HU"}}, // Porrogszentkirály railway station
    {Coordinate{17.2754, 46.2821}, CountryId{"HU"}}, // Bolhás railway station
    {Coordinate{17.1408, 46.2751}, CountryId{"HU"}}, // Zrínyitelep railway station
    {Coordinate{17.0916, 46.2612}, CountryId{"HU"}}, // Csurgó railway station
    {Coordinate{17.4795, 46.7125}, CountryId{"HU"}}, // Q22222762
    {Coordinate{17.4998, 46.6805}, CountryId{"HU"}}, // Q22222767
    {Coordinate{17.4575, 46.6628}, CountryId{"HU"}}, // Q22222768
    {Coordinate{17.4719, 46.6492}, CountryId{"HU"}}, // Q22222769
    {Coordinate{17.4785, 46.639}, CountryId{"HU"}}, // Q22222770
    {Coordinate{5.01194, 52.1031}, CountryId{"NL"}}, // Vleuten railway station
    {Coordinate{7.26846, 47.6763}, CountryId{"FR"}}, // Q2222548
    {Coordinate{20.4136, 46.1921}, CountryId{"HU"}}, // Q22227129
    {Coordinate{20.1826, 46.2117}, CountryId{"HU"}}, // :Szőreg railway station
    {Coordinate{20.4306, 46.191}, CountryId{"HU"}}, // Q22227132
    {Coordinate{20.4748, 46.2046}, CountryId{"HU"}}, // Makó railway station
    {Coordinate{20.2464, 46.21}, CountryId{"HU"}}, // Deszk railway station
    {Coordinate{20.5806, 46.1752}, CountryId{"HU"}}, // Q22227154
    {Coordinate{20.6103, 46.1746}, CountryId{"HU"}}, // Q22227155
    {Coordinate{20.7081, 46.1701}, CountryId{"HU"}}, // Q22227156
    {Coordinate{20.7174, 46.189}, CountryId{"HU"}}, // Q22227157
    {Coordinate{20.7326, 46.236}, CountryId{"HU"}}, // Q22227158
    {Coordinate{20.8158, 46.3108}, CountryId{"HU"}}, // Q22227159
    {Coordinate{20.8485, 46.3413}, CountryId{"HU"}}, // Q22227171
    {Coordinate{20.8669, 46.3671}, CountryId{"HU"}}, // Q22227172
    {Coordinate{20.8999, 46.408}, CountryId{"HU"}}, // Q22227173
    {Coordinate{20.9191, 46.4159}, CountryId{"HU"}}, // Q22227174
    {Coordinate{20.9692, 46.451}, CountryId{"HU"}}, // Q22227175
    {Coordinate{21.0304, 46.4964}, CountryId{"HU"}}, // Q22227176
    {Coordinate{20.8792, 46.3851}, CountryId{"HU"}}, // Q22227177
    {Coordinate{21.0939, 46.5054}, CountryId{"HU"}}, // Q22227178
    {Coordinate{20.6558, 46.5535}, CountryId{"HU"}}, // Orosháza felső railway station
    {Coordinate{20.7374, 46.3708}, CountryId{"HU"}}, // Q22227189
    {Coordinate{20.7461, 46.3263}, CountryId{"HU"}}, // Q22227190
    {Coordinate{20.7269, 46.4087}, CountryId{"HU"}}, // Q22227191
    {Coordinate{20.6976, 46.4982}, CountryId{"HU"}}, // Q22227194
    {Coordinate{20.7406, 46.3531}, CountryId{"HU"}}, // Q22227195
    {Coordinate{20.6834, 46.5799}, CountryId{"HU"}}, // Orosháza-Üveggyár railway station
    {Coordinate{20.5568, 46.94}, CountryId{"HU"}}, // Pusztabánréve railway station
    {Coordinate{20.6745, 46.6728}, CountryId{"HU"}}, // Nagyszénás railway station
    {Coordinate{20.7176, 46.7192}, CountryId{"HU"}}, // Kiscsákó railway station
    {Coordinate{20.7215, 46.7512}, CountryId{"HU"}}, // Kisszénás railway station
    {Coordinate{20.6633, 46.8228}, CountryId{"HU"}}, // Csabacsűd railway station
    {Coordinate{20.6493, 46.8292}, CountryId{"HU"}}, // Csabacsűd felső railway station
    {Coordinate{20.5667, 46.8605}, CountryId{"HU"}}, // Szarvas railway station
    {Coordinate{20.5625, 46.9112}, CountryId{"HU"}}, // Halászlak railway station
    {Coordinate{20.6098, 46.8406}, CountryId{"HU"}}, // Sirató railway station
    {Coordinate{20.9067, 46.3203}, CountryId{"HU"}}, // Q22227453
    {Coordinate{20.967, 46.321}, CountryId{"HU"}}, // Q22227454
    {Coordinate{21.004, 46.282}, CountryId{"HU"}}, // Q22227455
    {Coordinate{-2.08833, 47.4352}, CountryId{"FR"}}, // Pontchâteau
    {Coordinate{6.06277, 49.0574}, CountryId{"FR"}}, // Q2222801
    {Coordinate{-2.14518, 48.2484}, CountryId{"FR"}}, // Gare de Quédillac
    {Coordinate{7.00433, 50.9535}, CountryId{"DE"}}, // Köln-Buchforst station
    {Coordinate{4.01376, 49.3295}, CountryId{"FR"}}, // Q2224318
    {Coordinate{0.489222, 44.8573}, CountryId{"FR"}}, // Gare de Bergerac
    {Coordinate{4.56912, 50.6596}, CountryId{"BE"}}, // Céroux-Mousty railway station
    {Coordinate{5.72456, 47.1526}, CountryId{"FR"}}, // Gare de Ranchot
    {Coordinate{7.54714, 48.8424}, CountryId{"FR"}}, // Obermodern
    {Coordinate{7.62003, 45.4052}, CountryId{"IT"}}, // Campore railway station
    {Coordinate{7.66114, 45.3695}, CountryId{"IT"}}, // Valperga railway station
    {Coordinate{7.74369, 45.3037}, CountryId{"IT"}}, // Feletto railway station
    {Coordinate{7.76186, 45.2675}, CountryId{"IT"}}, // Bosconero railway station
    {Coordinate{4.02611, 50.8394}, CountryId{"BE"}}, // Ninove railway station
    {Coordinate{6.71583, 52.26}, CountryId{"NL"}}, // Delden railway station
    {Coordinate{7.1342, 51.3724}, CountryId{"DE"}}, // Velbert-Nierenhof station
    {Coordinate{24.2447, 59.3419}, CountryId{"EE"}}, // Q2226890
    {Coordinate{2.46592, 50.5899}, CountryId{"FR"}}, // Q2226896
    {Coordinate{0.984289, 44.8197}, CountryId{"FR"}}, // Gare de Siorac-en-Périgord
    {Coordinate{3.61677, 50.6006}, CountryId{"BE"}}, // Leuze railway station
    {Coordinate{6.8981, 51.0212}, CountryId{"DE"}}, // Bahnhof Köln-Chorweiler
    {Coordinate{1.2894, 43.6215}, CountryId{"FR"}}, // Q2227003
    {Coordinate{-0.210094, 46.9852}, CountryId{"FR"}}, // Gare de Thouars
    {Coordinate{3.60177, 50.7422}, CountryId{"BE"}}, // Ronse railway station
    {Coordinate{4.66699, 50.5925}, CountryId{"BE"}}, // Ernage railway station
    {Coordinate{6.84116, 51.2025}, CountryId{"DE"}}, // Düsseldorf-Eller Mitte station
    {Coordinate{13.2994, 52.5303}, CountryId{"DE"}}, // Berlin Jungfernheide station
    {Coordinate{26.146, 59.3382}, CountryId{"EE"}}, // Kadrina railway station
    {Coordinate{3.09053, 50.3718}, CountryId{"FR"}}, // Douai railway station
    {Coordinate{5.61194, 50.6439}, CountryId{"BE"}}, // Bressoux railway station
    {Coordinate{2.75944, 48.7392}, CountryId{"FR"}}, // Gare de Tournan
    {Coordinate{4.67139, 51.7897}, CountryId{"NL"}}, // Dordrecht Zuid railway station
    {Coordinate{-0.187799, 44.5753}, CountryId{"FR"}}, // Gare de Saint-Pierre-d'Aurillac
    {Coordinate{7.59105, 44.4962}, CountryId{"IT"}}, // Centallo railway station
    {Coordinate{5.45406, 50.6563}, CountryId{"BE"}}, // Bierset-Awans railway station
    {Coordinate{5.21861, 50.5286}, CountryId{"BE"}}, // Statte railway station
    {Coordinate{3.66768, 49.6487}, CountryId{"FR"}}, // Q2230592
    {Coordinate{4.74278, 52.0147}, CountryId{"NL"}}, // Gouda Goverwelle railway station
    {Coordinate{2.04727, 47.0859}, CountryId{"FR"}}, // Q2230843
    {Coordinate{1.01185, 44.7774}, CountryId{"FR"}}, // Gare de Belvès
    {Coordinate{-1.42841, 43.3784}, CountryId{"FR"}}, // Haltsu–Larresoro/Halsou–Larressore station
    {Coordinate{4.71667, 51.8017}, CountryId{"NL"}}, // Dordrecht Stadspolders railway station
    {Coordinate{1.7718, 48.6258}, CountryId{"FR"}}, // Gare de Gazeran
    {Coordinate{4.44917, 50.7661}, CountryId{"BE"}}, // Groenendaal railway station
    {Coordinate{8.77639, 46.1169}, CountryId{"CH"}}, // Ranzo-Sant’Abbondio railway station
    {Coordinate{8.785, 46.1219}, CountryId{"CH"}}, // Gerra (Gambarogno) railway station
    {Coordinate{4.24028, 51.0992}, CountryId{"BE"}}, // Bornem railway station
    {Coordinate{16.2429, 39.6535}, CountryId{"IT"}}, // Tarsia railway station
    {Coordinate{16.2226, 39.5385}, CountryId{"IT"}}, // Mongrassano-Cervicati railway station
    {Coordinate{16.2105, 39.4945}, CountryId{"IT"}}, // Torano-Lattarico railway station
    {Coordinate{16.2452, 39.4414}, CountryId{"IT"}}, // Acri-Bisignano-Luzzi railway station
    {Coordinate{16.2475, 39.4071}, CountryId{"IT"}}, // Montalto-Rose railway station
    {Coordinate{25.333, 59.3375}, CountryId{"EE"}}, // Q2232297
    {Coordinate{11.1524, 45.1888}, CountryId{"IT"}}, // Sanguinetto railway station
    {Coordinate{11.3487, 45.1531}, CountryId{"IT"}}, // Villabartolomea railway station
    {Coordinate{11.6964, 45.0457}, CountryId{"IT"}}, // Costa railway station
    {Coordinate{14.1761, 38.018}, CountryId{"IT"}}, // Pollina-San Mauro Castelverde railway station
    {Coordinate{14.2567, 38.008}, CountryId{"IT"}}, // Tusa railway station
    {Coordinate{15.2581, 38.1978}, CountryId{"IT"}}, // Milazzo railway station
    {Coordinate{15.3126, 38.2025}, CountryId{"IT"}}, // Pace del Mela railway station
    {Coordinate{15.3836, 38.2195}, CountryId{"IT"}}, // Spadafora railway station
    {Coordinate{15.4293, 38.2336}, CountryId{"IT"}}, // Villafranca Tirrena-Saponara railway station
    {Coordinate{8.75917, 51.7278}, CountryId{"DE"}}, // Q22329094
    {Coordinate{7.07073, 50.9816}, CountryId{"DE"}}, // Köln-Dellbrück station
    {Coordinate{15.3892, 40.5618}, CountryId{"IT"}}, // Petina railway station
    {Coordinate{15.4973, 40.5129}, CountryId{"IT"}}, // Polla railway station
    {Coordinate{15.6049, 40.3687}, CountryId{"IT"}}, // Sassano-Teggiano railway station
    {Coordinate{15.6299, 40.3352}, CountryId{"IT"}}, // Padula railway station
    {Coordinate{15.6538, 40.2867}, CountryId{"IT"}}, // Montesano-Buonabitacolo railway station
    {Coordinate{15.686, 40.2141}, CountryId{"IT"}}, // Casalbuono railway station
    {Coordinate{2.07799, 44.5782}, CountryId{"FR"}}, // Gare de Capdenac
    {Coordinate{10.123, 53.5864}, CountryId{"DE"}}, // Hamburg-Tonndorf station
    {Coordinate{10.1544, 53.6048}, CountryId{"DE"}}, // Hamburg-Rahlstedt station
    {Coordinate{3.09396, 49.2501}, CountryId{"FR"}}, // Gare de Villers-Cotterêts
    {Coordinate{1.87291, 49.2612}, CountryId{"FR"}}, // Q2234313
    {Coordinate{3.79287, 47.5289}, CountryId{"FR"}}, // Q2234530
    {Coordinate{4.53607, 50.1915}, CountryId{"BE"}}, // Philippeville railway station
    {Coordinate{6.37528, 51.4583}, CountryId{"DE"}}, // Nieukerk
    {Coordinate{5.85444, 50.5878}, CountryId{"BE"}}, // Verviers-Central railway station
    {Coordinate{5.37944, 49.1656}, CountryId{"FR"}}, // Q2234913
    {Coordinate{14.5131, 50.1103}, CountryId{"CZ"}}, // Kolbenova
    {Coordinate{14.24, 49.9167}, CountryId{"CZ"}}, // Q2235620
    {Coordinate{-0.476521, 48.1576}, CountryId{"FR"}}, // Gare de Neau
    {Coordinate{6.27367, 49.3966}, CountryId{"FR"}}, // Kœnigsmacker
    {Coordinate{4.00151, 50.0889}, CountryId{"FR"}}, // Gare de Sains-du-Nord
    {Coordinate{12.4211, 50.2197}, CountryId{"CZ"}}, // Q2237878
    {Coordinate{2.30667, 48.6358}, CountryId{"FR"}}, // Saint-Michel-sur-Orge (Paris RER)
    {Coordinate{5.2357, 51.0507}, CountryId{"BE"}}, // Beringen railway station
    {Coordinate{4.21097, 50.4303}, CountryId{"BE"}}, // Leval railway station
    {Coordinate{-0.659722, 44.7934}, CountryId{"FR"}}, // gare d'Alouette-France
    {Coordinate{1.41854, 43.5934}, CountryId{"FR"}}, // Gare de Toulouse-Saint-Cyprien-Arènes
    {Coordinate{4.63883, 51.1135}, CountryId{"BE"}}, // Berlaar railway station
    {Coordinate{2.19415, 50.9523}, CountryId{"FR"}}, // Q2243517
    {Coordinate{3.12806, 42.4831}, CountryId{"FR"}}, // Banyuls-sur-Mer railway station
    {Coordinate{-3.56107, 40.4238}, CountryId{"ES"}}, // Coslada
    {Coordinate{0.620833, 44.2083}, CountryId{"FR"}}, // Gare d'Agen
    {Coordinate{-0.784, 51.788}, CountryId{"GB"}}, // Stoke Mandeville railway station
    {Coordinate{8.54028, 47.3778}, CountryId{"CH"}}, // Zürich Hauptbahnhof
    {Coordinate{3.85767, 49.5269}, CountryId{"FR"}}, // Gare de Saint-Erme
    {Coordinate{1.37167, 43.7381}, CountryId{"FR"}}, // Gare de Saint-Jory
    {Coordinate{0.826667, 44.1267}, CountryId{"FR"}}, // Gare de Lamagistère
    {Coordinate{7.50241, 51.51}, CountryId{"DE"}}, // Dortmund-Körne West station
    {Coordinate{2.37679, 49.2034}, CountryId{"FR"}}, // Q2247293
    {Coordinate{16.7442, 53.1431}, CountryId{"PL"}}, // Piła Główna
    {Coordinate{2.96216, 50.5918}, CountryId{"FR"}}, // Santes
    {Coordinate{9.76, 48.6833}, CountryId{"DE"}}, // Süßen station
    {Coordinate{2.15247, 48.8369}, CountryId{"FR"}}, // Q2248860
    {Coordinate{5.62278, 50.6606}, CountryId{"BE"}}, // Herstal railway station
    {Coordinate{6.847, 45.9124}, CountryId{"FR"}}, // Q2249371
    {Coordinate{-0.100664, 49.2912}, CountryId{"FR"}}, // Gare de Dives-sur-Mer-Port-Guillaume
    {Coordinate{0.109401, 45.8874}, CountryId{"FR"}}, // Q2249657
    {Coordinate{5.95278, 50.8961}, CountryId{"NL"}}, // Heerlen Woonboulevard railway station
    {Coordinate{1.89024, 48.7218}, CountryId{"FR"}}, // Gare des Essarts-le-Roi
    {Coordinate{0.166206, 48.5999}, CountryId{"FR"}}, // Gare de Sées
    {Coordinate{6.87398, 45.9227}, CountryId{"FR"}}, // Q2250995
    {Coordinate{15.91, 50.3419}, CountryId{"CZ"}}, // Jaroměř
    {Coordinate{5.08014, 50.7478}, CountryId{"BE"}}, // Landen railway station
    {Coordinate{3.88244, 51.0016}, CountryId{"BE"}}, // Wetteren railway station
    {Coordinate{2.90751, 48.7891}, CountryId{"FR"}}, // Gare de Mortcerf
    {Coordinate{18.7883, 54.0978}, CountryId{"PL"}}, // Q2253001
    {Coordinate{7.3085, 47.747}, CountryId{"FR"}}, // Gare de Mulhouse-Dornach
    {Coordinate{4.77882, 46.2829}, CountryId{"FR"}}, // Gare de Mâcon-Loché TGV
    {Coordinate{6.22427, 43.2984}, CountryId{"FR"}}, // Q2253083
    {Coordinate{3.03469, 50.6145}, CountryId{"FR"}}, // Gare de Lille-CHR
    {Coordinate{2.097, 48.7961}, CountryId{"FR"}}, // Q2253549
    {Coordinate{3.73306, 50.8753}, CountryId{"BE"}}, // Munkzwalm railway station
    {Coordinate{-4.48046, 48.3878}, CountryId{"FR"}}, // Brest railway station
    {Coordinate{2.76306, 48.1481}, CountryId{"FR"}}, // Gare de Dordives
    {Coordinate{5.87318, 50.3691}, CountryId{"BE"}}, // Trois-Ponts railway station
    {Coordinate{6.60028, 52.4019}, CountryId{"NL"}}, // Vriezenveen railway station
    {Coordinate{8.74301, 39.462}, CountryId{"IT"}}, // Villacidro railway station
    {Coordinate{8.95763, 39.6204}, CountryId{"IT"}}, // Villamar railway station
    {Coordinate{10.8742, 60.8981}, CountryId{"NO"}}, // Veldre stasjon
    {Coordinate{3.76095, 45.8163}, CountryId{"FR"}}, // Gare de Noirétable
    {Coordinate{6.93878, 51.1025}, CountryId{"DE"}}, // Langenfeld station
    {Coordinate{4.56583, 52.3028}, CountryId{"NL"}}, // Hillegom railway station
    {Coordinate{10.5371, 53.337}, CountryId{"DE"}}, // Echem station
    {Coordinate{3.41931, 50.4433}, CountryId{"FR"}}, // Saint-Amand-les-Eaux
    {Coordinate{3.36392, 48.9917}, CountryId{"FR"}}, // Q2259679
    {Coordinate{2.36167, 48.9175}, CountryId{"FR"}}, // Gare de La Plaine-Stade de France
    {Coordinate{1.8155, 48.8026}, CountryId{"FR"}}, // Q2260519
    {Coordinate{-0.369481, 43.2915}, CountryId{"FR"}}, // Gare de Pau
    {Coordinate{2.37194, 48.9636}, CountryId{"FR"}}, // Gare de Pierrefitte - Stains
    {Coordinate{7.62477, 51.534}, CountryId{"DE"}}, // Dortmund-Wickede station
    {Coordinate{4.6275, 52.4042}, CountryId{"NL"}}, // Bloemendaal railway station
    {Coordinate{4.79626, 45.6073}, CountryId{"FR"}}, // Q2260903
    {Coordinate{1.04907, 44.627}, CountryId{"FR"}}, // Gare de Villefranche-du-Périgord
    {Coordinate{4.01389, 50.7242}, CountryId{"BE"}}, // Herne railway station
    {Coordinate{4.02247, 49.2336}, CountryId{"FR"}}, // Q2261583
    {Coordinate{13.8367, 49.8367}, CountryId{"CZ"}}, // Cerhovice (train station)
    {Coordinate{3.02011, 50.5154}, CountryId{"FR"}}, // Phalempin
    {Coordinate{23.1356, 53.1344}, CountryId{"PL"}}, // Białystok railway station
    {Coordinate{7.46493, 48.7518}, CountryId{"FR"}}, // Q2262411
    {Coordinate{0.718873, 49.1076}, CountryId{"FR"}}, // Serquigny
    {Coordinate{2.72694, 48.4161}, CountryId{"FR"}}, // Fontainebleau–Avon railway station
    {Coordinate{5.32077, 50.6787}, CountryId{"BE"}}, // Remicourt railway station
    {Coordinate{3.66789, 51.126}, CountryId{"BE"}}, // Sleidinge railway station
    {Coordinate{10.8164, 60.6739}, CountryId{"NO"}}, // Lena Station
    {Coordinate{10.8536, 60.675}, CountryId{"NO"}}, // Kraby Station
    {Coordinate{10.9331, 60.6531}, CountryId{"NO"}}, // Skreia Station
    {Coordinate{5.03361, 52.1353}, CountryId{"NL"}}, // Maarssen railway station
    {Coordinate{2.27194, 48.8642}, CountryId{"FR"}}, // Avenue Henri Martin
    {Coordinate{19.5715, 46.8575}, CountryId{"HU"}}, // Ballószög railway station
    {Coordinate{7.10437, 50.9847}, CountryId{"DE"}}, // Duckterath station
    {Coordinate{7.35695, 43.7224}, CountryId{"FR"}}, // Èze-sur-Mer railway station
    {Coordinate{1.35263, 49.1747}, CountryId{"FR"}}, // Gare de Gaillon - Aubevoye
    {Coordinate{142.941, 48.8836}, CountryId{"RU"}}, // Q2267282
    {Coordinate{3.02533, 48.9592}, CountryId{"FR"}}, // Q2267427
    {Coordinate{10.4636, 53.2176}, CountryId{"DE"}}, // Wendisch Evern station
    {Coordinate{10.5552, 53.1991}, CountryId{"DE"}}, // Vastorf station
    {Coordinate{10.6291, 53.1875}, CountryId{"DE"}}, // Bavendorf station
    {Coordinate{8.46225, 50.1248}, CountryId{"DE"}}, // Kelkheim-Münster station
    {Coordinate{3.62823, 44.5285}, CountryId{"FR"}}, // Q2267810
    {Coordinate{10.7088, 53.1694}, CountryId{"DE"}}, // Dahlenburg station
    {Coordinate{10.761, 53.1637}, CountryId{"DE"}}, // Neetzendorf station
    {Coordinate{-4.20529, 48.4741}, CountryId{"FR"}}, // Q2268018
    {Coordinate{8.6028, 49.4741}, CountryId{"DE"}}, // Ladenburg station
    {Coordinate{6.27778, 52.3917}, CountryId{"NL"}}, // Raalte railway station
    {Coordinate{2.14056, 49.9461}, CountryId{"FR"}}, // Gare de Picquigny
    {Coordinate{5.3446, 47.8771}, CountryId{"FR"}}, // Q2268586
    {Coordinate{2.61194, 49.5031}, CountryId{"FR"}}, // Gare de Wacquemoulin
    {Coordinate{9.65063, 59.6723}, CountryId{"NO"}}, // Kongsberg Station
    {Coordinate{13.3658, 49.7403}, CountryId{"CZ"}}, // Plzeň-Jižní Předměstí
    {Coordinate{12.5949, 52.1359}, CountryId{"DE"}}, // Bad Belzig station
    {Coordinate{8.07386, 49.8083}, CountryId{"DE"}}, // Q22691245
    {Coordinate{9.9125, 51.7972}, CountryId{"DE"}}, // Einbeck-Salzderhelden station
    {Coordinate{9.0053, 50.0767}, CountryId{"DE"}}, // Q22691248
    {Coordinate{11.4522, 50.1097}, CountryId{"DE"}}, // Kulmbach station
    {Coordinate{10.3429, 51.9303}, CountryId{"DE"}}, // Langelsheim station
    {Coordinate{9.42269, 49.43}, CountryId{"DE"}}, // Osterburken station
    {Coordinate{9.48499, 48.1497}, CountryId{"DE"}}, // Riedlingen station
    {Coordinate{12.1314, 51.0564}, CountryId{"DE"}}, // Zeitz station
    {Coordinate{8.49479, 49.9123}, CountryId{"DE"}}, // Q22692098
    {Coordinate{10.5486, 46.6843}, CountryId{"IT"}}, // Q22692924
    {Coordinate{14.3921, 51.0931}, CountryId{"DE"}}, // Q22694635
    {Coordinate{16.8775, 48.6863}, CountryId{"AT"}}, // Bernhardsthal railway station
    {Coordinate{15.21, 50.0372}, CountryId{"CZ"}}, // Kolín-Zálabí
    {Coordinate{-2.44111, 48.425}, CountryId{"FR"}}, // Q2269977
    {Coordinate{-2.05276, 48.19}, CountryId{"FR"}}, // Montauban-de-Bretagne Station
    {Coordinate{4.92389, 51.5839}, CountryId{"NL"}}, // Gilze-Rijen railway station
    {Coordinate{9.80056, 59.7014}, CountryId{"NO"}}, // Darbu Station
    {Coordinate{4.65472, 50.7608}, CountryId{"BE"}}, // Florival railway station
    {Coordinate{39.0792, 45.0514}, CountryId{"RU"}}, // Q22709418
    {Coordinate{14.4881, 48.9743}, CountryId{"CZ"}}, // České Budějovice railway station
    {Coordinate{17.2812, 49.639}, CountryId{"CZ"}}, // Hlušovice railway station
    {Coordinate{1.91314, 48.9925}, CountryId{"FR"}}, // Gare des Mureaux
    {Coordinate{5.72306, 52.5339}, CountryId{"NL"}}, // Dronten railway station
    {Coordinate{4.74722, 52.3858}, CountryId{"NL"}}, // Halfweg-Zwanenburg railway station
    {Coordinate{6.14023, 48.2708}, CountryId{"FR"}}, // Q2273195
    {Coordinate{1.32353, 47.5854}, CountryId{"FR"}}, // Gare de Blois
    {Coordinate{5.98222, 45.7861}, CountryId{"FR"}}, // Albens
    {Coordinate{-1.14273, 44.637}, CountryId{"FR"}}, // La Teste
    {Coordinate{8.75167, 50.1058}, CountryId{"DE"}}, // Q2274451
    {Coordinate{-1.139, 50.678}, CountryId{"GB"}}, // Brading railway station
    {Coordinate{2.44557, 49.3248}, CountryId{"FR"}}, // Q2274967
    {Coordinate{4.93013, 49.6949}, CountryId{"FR"}}, // Q2275121
    {Coordinate{7.29756, 48.0889}, CountryId{"FR"}}, // Q2275567
    {Coordinate{2.07639, 48.8681}, CountryId{"FR"}}, // Gare de L'Étang-la-Ville
    {Coordinate{2.1375, 48.6983}, CountryId{"FR"}}, // Gif-sur-Yvette Station
    {Coordinate{6.80687, 47.681}, CountryId{"FR"}}, // Q2277130
    {Coordinate{15.8178, 50.2527}, CountryId{"CZ"}}, // Q2277484
    {Coordinate{4.13106, 43.6794}, CountryId{"FR"}}, // Gare de Lunel
    {Coordinate{-0.623787, 44.9176}, CountryId{"FR"}}, // Gare de Blanquefort
    {Coordinate{1.17803, 45.6918}, CountryId{"FR"}}, // Gare de Nexon
    {Coordinate{3.42436, 50.8917}, CountryId{"BE"}}, // Waregem railway station
    {Coordinate{7.54601, 50.8091}, CountryId{"DE"}}, // Dattenfeld station
    {Coordinate{2.76941, 43.1999}, CountryId{"FR"}}, // Gare de Lézignan-Corbières
    {Coordinate{5.81893, 44.3165}, CountryId{"FR"}}, // Gare de Laragne
    {Coordinate{17.4227, 49.076}, CountryId{"CZ"}}, // Staré Město u Uherského Hradiště railway station
    {Coordinate{6.3022, 49.4215}, CountryId{"FR"}}, // Q2280858
    {Coordinate{14.2089, 50.7847}, CountryId{"CZ"}}, // Q22811336
    {Coordinate{14.1957, 50.7669}, CountryId{"CZ"}}, // Q22811339
    {Coordinate{14.5845, 50.637}, CountryId{"CZ"}}, // Srní u České Lípy train station
    {Coordinate{14.5332, 50.6917}, CountryId{"CZ"}}, // Česká Lípa střelnice railway station
    {Coordinate{14.6076, 50.6713}, CountryId{"CZ"}}, // Vlčí Důl-Dobranov railway station
    {Coordinate{14.5062, 50.6373}, CountryId{"CZ"}}, // Zahrádky u České Lípy railway station
    {Coordinate{14.8334, 50.4433}, CountryId{"CZ"}}, // Bukovno railway stop
    {Coordinate{10.9128, 53.1692}, CountryId{"DE"}}, // Leitstade station
    {Coordinate{6.00765, 45.4342}, CountryId{"FR"}}, // Q2281291
    {Coordinate{11.0386, 53.1391}, CountryId{"DE"}}, // Hitzacker station
    {Coordinate{9.18648, 45.484}, CountryId{"IT"}}, // Milano Porta Garibaldi
    {Coordinate{14.2805, 50.0263}, CountryId{"CZ"}}, // Zbuzany railway station
    {Coordinate{3.28342, 44.7183}, CountryId{"FR"}}, // Gare d'Aumont-Aubrac
    {Coordinate{5.45439, 46.2129}, CountryId{"FR"}}, // Q2281639
    {Coordinate{5.82361, 51.8278}, CountryId{"NL"}}, // Nijmegen Goffert railway station
    {Coordinate{12.4581, 50.0294}, CountryId{"CZ"}}, // Lipová u Chebu railway station
    {Coordinate{14.3984, 50.1596}, CountryId{"CZ"}}, // Q22826051
    {Coordinate{14.5559, 50.135}, CountryId{"CZ"}}, // Q22826064
    {Coordinate{14.6161, 50.0837}, CountryId{"CZ"}}, // Praha-Běchovice střed
    {Coordinate{3.2776, 49.2911}, CountryId{"FR"}}, // Q2282895
    {Coordinate{82.157, 26.7746}, CountryId{"IN"}}, // Acharya Narendra Dev Nagar railway station
    {Coordinate{2.87973, 42.6963}, CountryId{"FR"}}, // Perpignan railway station
    {Coordinate{4.55258, 50.4291}, CountryId{"BE"}}, // Farciennes railway station
    {Coordinate{4.66343, 50.4514}, CountryId{"BE"}}, // Jemeppe-sur-Sambre railway station
    {Coordinate{4.8182, 50.1402}, CountryId{"FR"}}, // Givet railway station
    {Coordinate{4.53918, 50.6095}, CountryId{"BE"}}, // La Roche railway station
    {Coordinate{1.51349, 48.7684}, CountryId{"FR"}}, // Q2284960
    {Coordinate{2.642, 48.976}, CountryId{"FR"}}, // Gare de Mitry – Claye
    {Coordinate{-1.02859, 45.9937}, CountryId{"FR"}}, // Saint-Laurent Fouras
    {Coordinate{3.94334, 50.2658}, CountryId{"FR"}}, // Louvroil
    {Coordinate{12.8461, 49.7858}, CountryId{"CZ"}}, // Q2286105
    {Coordinate{4.24907, 45.6444}, CountryId{"FR"}}, // Q2286280
    {Coordinate{2.8948, 50.3036}, CountryId{"FR"}}, // Gare de Rœux
    {Coordinate{4.49028, 51.03}, CountryId{"BE"}}, // Mechelen-Nekkerspoel railway station
    {Coordinate{1.47842, 49.0912}, CountryId{"FR"}}, // Gare de Vernon
    {Coordinate{1.61008, 50.7155}, CountryId{"FR"}}, // Boulogne-Ville railway station
    {Coordinate{8.87481, 49.2505}, CountryId{"DE"}}, // Sinsheim Central Station
    {Coordinate{12.5408, 50.0117}, CountryId{"CZ"}}, // Q2289805
    {Coordinate{13.9797, 49.9078}, CountryId{"CZ"}}, // Q2289939
    {Coordinate{4.99528, 50.7714}, CountryId{"BE"}}, // Ezemaal train station
    {Coordinate{2.33722, 48.8394}, CountryId{"FR"}}, // Gare de Port-Royal
    {Coordinate{7.96722, 50.5578}, CountryId{"DE"}}, // Westerburg station
    {Coordinate{7.99535, 45.1613}, CountryId{"IT"}}, // Lauriano railway station
    {Coordinate{8.01924, 45.1585}, CountryId{"IT"}}, // Monteu da Po railway station
    {Coordinate{8.04751, 45.1537}, CountryId{"IT"}}, // Cavagnolo-Brusasco railway station
    {Coordinate{8.06966, 45.0838}, CountryId{"IT"}}, // Cocconato railway station
    {Coordinate{8.1069, 45.0676}, CountryId{"IT"}}, // Montiglio-Murisengo railway station
    {Coordinate{8.11006, 45.0369}, CountryId{"IT"}}, // Cunico-Scandeluzza railway station
    {Coordinate{8.12885, 44.985}, CountryId{"IT"}}, // Chiusano-Cossombrato railway station
    {Coordinate{5.58944, 52.1408}, CountryId{"NL"}}, // Barneveld Zuid railway station
    {Coordinate{10.4844, 53.1423}, CountryId{"DE"}}, // Bienenbüttel station
    {Coordinate{10.5742, 53.0782}, CountryId{"DE"}}, // Bad Bevensen station
    {Coordinate{12.5233, 41.8794}, CountryId{"IT"}}, // Roma Tuscolana railway station
    {Coordinate{4.96533, 50.4807}, CountryId{"BE"}}, // Marche-les-Dames railway station
    {Coordinate{1.52056, 43.3053}, CountryId{"FR"}}, // Gare de Cintegabelle
    {Coordinate{2.92583, 51.2289}, CountryId{"BE"}}, // Oostende railway station
    {Coordinate{2.263, 42.5417}, CountryId{"FR"}}, // Gare de Nyer
    {Coordinate{10.5923, 52.9076}, CountryId{"DE"}}, // Stederdorf (Kr Uelzen) station
    {Coordinate{4.20583, 50.6918}, CountryId{"BE"}}, // Tubize railway station
    {Coordinate{2.44583, 48.73}, CountryId{"FR"}}, // Villeneuve-Saint-Georges
    {Coordinate{15.4268, 40.5365}, CountryId{"IT"}}, // Q22939462
    {Coordinate{7.54271, 47.2042}, CountryId{"CH"}}, // Solothurn railway station
    {Coordinate{-0.255702, 44.5554}, CountryId{"FR"}}, // Gare de Langon
    {Coordinate{7.05572, 48.9458}, CountryId{"FR"}}, // Gare de Schopperten
    {Coordinate{4.8803, 50.4549}, CountryId{"BE"}}, // Jambes-Est railway station
    {Coordinate{5.29083, 50.5392}, CountryId{"BE"}}, // Ampsin railway station
    {Coordinate{10.6556, 52.8926}, CountryId{"DE"}}, // Wieren station
    {Coordinate{10.7612, 52.8742}, CountryId{"DE"}}, // Soltendieck station
    {Coordinate{4.38972, 52.0561}, CountryId{"NL"}}, // Den Haag Ypenburg railway station
    {Coordinate{3.49389, 50.8264}, CountryId{"BE"}}, // Anzegem railway station
    {Coordinate{1.01639, 43.1961}, CountryId{"FR"}}, // Gare de Martres-Tolosane
    {Coordinate{3.84694, 50.7328}, CountryId{"BE"}}, // Acren railway station
    {Coordinate{2.20139, 48.5003}, CountryId{"FR"}}, // Étréchy (Paris RER)
    {Coordinate{9.17015, 40.3182}, CountryId{"IT"}}, // Q22963397
    {Coordinate{9.1354, 40.3216}, CountryId{"IT"}}, // Q22964110
    {Coordinate{0.389734, 45.7402}, CountryId{"FR"}}, // Gare de La Rochefoucauld
    {Coordinate{9.03795, 40.3231}, CountryId{"IT"}}, // Iscra railway station
    {Coordinate{3.59167, 50.5136}, CountryId{"BE"}}, // Péruwelz railway station
    {Coordinate{3.65569, 51.0471}, CountryId{"BE"}}, // Drongen railway station
    {Coordinate{10.4169, 53.0172}, CountryId{"DE"}}, // Ebstorf (Kr Uelzen) station
    {Coordinate{10.259, 53.0022}, CountryId{"DE"}}, // Brockhöfe station
    {Coordinate{10.0962, 52.9933}, CountryId{"DE"}}, // Munster (Örtze) station
    {Coordinate{4.78472, 51.1683}, CountryId{"BE"}}, // Wolfstee railway station
    {Coordinate{8.96251, 40.3104}, CountryId{"IT"}}, // Bolotana railway station
    {Coordinate{8.89364, 40.2847}, CountryId{"IT"}}, // Silanus railway station
    {Coordinate{8.84214, 40.2794}, CountryId{"IT"}}, // Bortigali railway station
    {Coordinate{2.3141, 48.8878}, CountryId{"FR"}}, // Gare de Pont-Cardinet
    {Coordinate{7.49106, 44.6142}, CountryId{"IT"}}, // Manta railway station
    {Coordinate{7.48263, 44.5694}, CountryId{"IT"}}, // Costigliole Saluzzo railway station
    {Coordinate{7.48153, 44.5206}, CountryId{"IT"}}, // Busca railway station
    {Coordinate{4.0685, 50.8768}, CountryId{"BE"}}, // Iddergem railway station
    {Coordinate{5.815, 50.5364}, CountryId{"BE"}}, // Theux railway station
    {Coordinate{8.64794, 47.3253}, CountryId{"CH"}}, // Forch railway station
    {Coordinate{8.7099, 47.2878}, CountryId{"CH"}}, // Esslingen railway station
    {Coordinate{8.58338, 47.351}, CountryId{"CH"}}, // Zürich Rehalp railway station
    {Coordinate{0.81185, 45.8696}, CountryId{"FR"}}, // Q2300634
    {Coordinate{5.09113, 50.2913}, CountryId{"BE"}}, // Ciney railway station
    {Coordinate{69.1697, 54.8564}, CountryId{"KZ"}}, // Petropavl railway station
    {Coordinate{9.79891, 53.1105}, CountryId{"DE"}}, // Schneverdingen station
    {Coordinate{9.84521, 53.0272}, CountryId{"DE"}}, // Wolterdingen (Han) station
    {Coordinate{9.86112, 53.0015}, CountryId{"DE"}}, // Soltau (Han) Nord station
    {Coordinate{9.7712, 52.8991}, CountryId{"DE"}}, // Dorfmark station
    {Coordinate{9.70031, 52.8629}, CountryId{"DE"}}, // Bad Fallingbostel station
    {Coordinate{5.91981, 46.7425}, CountryId{"FR"}}, // Q23013004
    {Coordinate{9.60116, 52.8649}, CountryId{"DE"}}, // Walsrode station
    {Coordinate{7.60808, 50.7972}, CountryId{"DE"}}, // Rosbach station
    {Coordinate{6.84592, 47.6486}, CountryId{"FR"}}, // Gare de Trois-Chênes
    {Coordinate{79.9009, 13.9083}, CountryId{"IN"}}, // Nayudupeta railway station
    {Coordinate{79.9835, 14.4445}, CountryId{"IN"}}, // Nellore South railway station
    {Coordinate{79.99, 14.497}, CountryId{"IN"}}, // Padugupadu railway station
    {Coordinate{80.0182, 13.6965}, CountryId{"IN"}}, // Sullurpeta railway station
    {Coordinate{79.9571, 14.4045}, CountryId{"IN"}}, // Vedayapalem railway station
    {Coordinate{79.9273, 14.3273}, CountryId{"IN"}}, // Venkatachalam railway station
    {Coordinate{79.6564, 10.9594}, CountryId{"IN"}}, // Peralam Junction railway station
    {Coordinate{5.45833, 52.1664}, CountryId{"NL"}}, // Hoevelaken railway station
    {Coordinate{8.7305, 40.2819}, CountryId{"IT"}}, // Bara train station
    {Coordinate{6.75806, 52.6944}, CountryId{"NL"}}, // Dalen railway station
    {Coordinate{80.3978, 16.3083}, CountryId{"IN"}}, // Nallapadu railway station
    {Coordinate{80.7432, 16.1781}, CountryId{"IN"}}, // Vemuru railway station
    {Coordinate{83.4942, 20.6886}, CountryId{"IN"}}, // Balangir railway station
    {Coordinate{5.04306, 52.1008}, CountryId{"NL"}}, // Utrecht Terwijde railway station
    {Coordinate{-1.47806, 47.1861}, CountryId{"FR"}}, // Gare de Vertou
    {Coordinate{8.71083, 58.5983}, CountryId{"NO"}}, // Bøylefossbru stasjon
    {Coordinate{0.849734, 49.6367}, CountryId{"FR"}}, // Gare de Motteville
    {Coordinate{4.89289, 46.2678}, CountryId{"FR"}}, // Gare de Pont-de-Veyle
    {Coordinate{2.20083, 49.3811}, CountryId{"FR"}}, // Gare de Montreuil-sur-Thérain
    {Coordinate{9.59529, 52.7663}, CountryId{"DE"}}, // Hodenhagen station
    {Coordinate{2.3075, 48.9333}, CountryId{"FR"}}, // Gennevilliers
    {Coordinate{9.62449, 52.6786}, CountryId{"DE"}}, // Schwarmstedt station
    {Coordinate{9.68875, 52.611}, CountryId{"DE"}}, // Lindwedel station
    {Coordinate{10.433, 52.9051}, CountryId{"DE"}}, // Suderburg station
    {Coordinate{10.3002, 52.8349}, CountryId{"DE"}}, // Unterlüß station
    {Coordinate{10.2307, 52.7412}, CountryId{"DE"}}, // Eschede station
    {Coordinate{7.18727, 48.4249}, CountryId{"FR"}}, // Gare de Fouday
    {Coordinate{10.0626, 52.6209}, CountryId{"DE"}}, // Celle station
    {Coordinate{10.6954, 46.6185}, CountryId{"IT"}}, // Laas railway station
    {Coordinate{6.05224, 49.0276}, CountryId{"FR"}}, // Q2306832
    {Coordinate{5.26472, 51.8069}, CountryId{"NL"}}, // Zaltbommel railway station
    {Coordinate{26.1096, 51.8101}, CountryId{"UA"}}, // Zarichne
    {Coordinate{1.37778, 50.0631}, CountryId{"FR"}}, // Gare du Tréport-Mers
    {Coordinate{9.85726, 52.5062}, CountryId{"DE"}}, // Großburgwedel station
    {Coordinate{9.80309, 52.4858}, CountryId{"DE"}}, // Isernhagen station
    {Coordinate{85.5394, 25.2031}, CountryId{"IN"}}, // Bihar Sharif Junction railway station
    {Coordinate{76.1383, 17.4507}, CountryId{"IN"}}, // Akkalkot Road railway station
    {Coordinate{77.0704, 8.96877}, CountryId{"IN"}}, // Thenmala railway station
    {Coordinate{81.3759, 21.2081}, CountryId{"IN"}}, // Bhilai Power House railway station
    {Coordinate{-3.68222, 40.4722}, CountryId{"ES"}}, // Madrid Chamartín station
    {Coordinate{0.956815, 44.9774}, CountryId{"FR"}}, // Gare de Mauzens-Miremont
    {Coordinate{5.3929, 43.3307}, CountryId{"FR"}}, // Picon-Busserine
    {Coordinate{7.00939, 48.8091}, CountryId{"FR"}}, // Q2308590
    {Coordinate{4.05083, 50.9031}, CountryId{"BE"}}, // Welle railway station
    {Coordinate{77.6185, 13.0015}, CountryId{"IN"}}, // Bangalore East Railway Station
    {Coordinate{5.69981, 49.2843}, CountryId{"FR"}}, // Q2309377
    {Coordinate{1.42583, 43.4333}, CountryId{"FR"}}, // Gare de Venerque-le-Vernet
    {Coordinate{5.16278, 52.2656}, CountryId{"NL"}}, // Bussum Zuid railway station
    {Coordinate{3.35233, 49.1877}, CountryId{"FR"}}, // Q2309625
    {Coordinate{6.62722, 51.6558}, CountryId{"DE"}}, // Wesel railway station
    {Coordinate{14.4612, 50.0776}, CountryId{"CZ"}}, // Flora
    {Coordinate{4.3366, 47.6187}, CountryId{"FR"}}, // Gare de Montbard
    {Coordinate{4.39417, 50.4122}, CountryId{"BE"}}, // Marchienne-au-Pont railway station
    {Coordinate{-1.78083, 43.3533}, CountryId{"FR"}}, // Gare d'Hendaye
    {Coordinate{5.17886, 43.5008}, CountryId{"FR"}}, // Gare de Berre
    {Coordinate{-0.199835, 48.1601}, CountryId{"FR"}}, // Q2311391
    {Coordinate{7.49447, 48.3101}, CountryId{"FR"}}, // Gare d'Ebersheim
    {Coordinate{3.85627, 50.4499}, CountryId{"BE"}}, // Quaregnon railway station
    {Coordinate{1.67358, 46.0912}, CountryId{"FR"}}, // Q2312849
    {Coordinate{-2.15559, 48.2844}, CountryId{"FR"}}, // Gare de Caulnes
    {Coordinate{70.7923, 22.283}, CountryId{"IN"}}, // Bhaktinagar Railway Station
    {Coordinate{5.71833, 44.4247}, CountryId{"FR"}}, // Q2313377
    {Coordinate{6.02383, 46.5257}, CountryId{"FR"}}, // Gare de Morez
    {Coordinate{14.3886, 50.0578}, CountryId{"CZ"}}, // Radlická
    {Coordinate{4.34235, 50.8728}, CountryId{"BE"}}, // Tour and Taxis railway station
    {Coordinate{0.265307, 46.4267}, CountryId{"FR"}}, // Q2314920
    {Coordinate{1.1264, 48.0738}, CountryId{"FR"}}, // Q2314948
    {Coordinate{3.07816, 42.5268}, CountryId{"FR"}}, // Gare de Collioure
    {Coordinate{-2.0437, 47.5163}, CountryId{"FR"}}, // Q2315187
    {Coordinate{1.38612, 48.1863}, CountryId{"FR"}}, // Q2315461
    {Coordinate{22.6774, 50.0109}, CountryId{"PL"}}, // Train stations in Jarosław
    {Coordinate{2.15208, 44.0487}, CountryId{"FR"}}, // Gare de Carmaux
    {Coordinate{5.45639, 50.5947}, CountryId{"BE"}}, // Flémalle-Haute railway station
    {Coordinate{1.49144, 47.1397}, CountryId{"FR"}}, // Q2316810
    {Coordinate{2.37083, 48.5319}, CountryId{"FR"}}, // Ballancourt
    {Coordinate{1.76472, 48.8106}, CountryId{"FR"}}, // Q2317468
    {Coordinate{6.3534, 46.9008}, CountryId{"FR"}}, // Pontarlier
    {Coordinate{2.51167, 48.8247}, CountryId{"FR"}}, // Les Boullereaux – Champigny (Paris RER)
    {Coordinate{1.47623, 46.0469}, CountryId{"FR"}}, // Gare de Saint-Sulpice-Laurière
    {Coordinate{8.65619, 40.295}, CountryId{"IT"}}, // Q23199378
    {Coordinate{-0.201145, 46.4064}, CountryId{"FR"}}, // Gare de Saint-Maixent (Deux-Sèvres)
    {Coordinate{6.68048, 50.9033}, CountryId{"DE"}}, // Sindorf station
    {Coordinate{21.0078, 52.2294}, CountryId{"PL"}}, // Warszawa Śródmieście PKP railway station
    {Coordinate{8.55098, 40.2681}, CountryId{"IT"}}, // Q23210654
    {Coordinate{16.4475, 49.8967}, CountryId{"CZ"}}, // Česká Třebová railway station
    {Coordinate{2.41205, 50.8898}, CountryId{"FR"}}, // Gare d'Esquelbecq
    {Coordinate{3.07526, 49.1355}, CountryId{"FR"}}, // Q2321640
    {Coordinate{14.4989, 50.1186}, CountryId{"CZ"}}, // Prosek
    {Coordinate{5.46694, 50.5997}, CountryId{"BE"}}, // Leman railway station
    {Coordinate{7.04694, 51.4936}, CountryId{"DE"}}, // Essen Zollverein Nord station
    {Coordinate{0.217804, 46.1467}, CountryId{"FR"}}, // Q2322939
    {Coordinate{2.24222, 49.1358}, CountryId{"FR"}}, // Gare de Champagne-sur-Oise
    {Coordinate{7.35694, 49.2469}, CountryId{"DE"}}, // Zweibrücken Central Station
    {Coordinate{7.36376, 51.4981}, CountryId{"DE"}}, // Dortmund-Germania station
    {Coordinate{2.35194, 48.485}, CountryId{"FR"}}, // La Ferté-Alais Station
    {Coordinate{0.335556, 44.2983}, CountryId{"FR"}}, // Gare d'Aiguillon
    {Coordinate{4.11238, 50.3037}, CountryId{"BE"}}, // Erquelinnes railway station
    {Coordinate{1.06654, 49.8717}, CountryId{"FR"}}, // Gare de Saint-Aubin-sur-Scie
    {Coordinate{6.93742, 51.1635}, CountryId{"DE"}}, // Hilden Süd station
    {Coordinate{3.66661, 50.5053}, CountryId{"BE"}}, // Blaton railway station
    {Coordinate{14.4631, 50.0967}, CountryId{"CZ"}}, // Invalidovna
    {Coordinate{4.35083, 50.3775}, CountryId{"BE"}}, // Landelies railway station
    {Coordinate{7.39434, 43.7205}, CountryId{"FR"}}, // Cap-d'Ail
    {Coordinate{2.28111, 48.78}, CountryId{"FR"}}, // Robinson
    {Coordinate{5.94389, 52.9356}, CountryId{"NL"}}, // Heerenveen IJsstadion railway station
    {Coordinate{0.192097, 49.506}, CountryId{"FR"}}, // Q2326704
    {Coordinate{19.3403, 47.7051}, CountryId{"HU"}}, // Váckisújfalu railway station
    {Coordinate{19.2651, 47.7242}, CountryId{"HU"}}, // Kisnémedi railway station
    {Coordinate{2.16778, 41.39}, CountryId{"ES"}}, // Passeig de Gràcia
    {Coordinate{20.9656, 52.2194}, CountryId{"PL"}}, // Warszawa Zachodnia WKD
    {Coordinate{18.9636, 47.5413}, CountryId{"HU"}}, // Q23287275
    {Coordinate{18.9553, 47.5284}, CountryId{"HU"}}, // Q23288262
    {Coordinate{18.9492, 47.5228}, CountryId{"HU"}}, // Q23289575
    {Coordinate{18.9509, 47.5149}, CountryId{"HU"}}, // János-hegy rail station, Budapest
    {Coordinate{18.9617, 47.4981}, CountryId{"HU"}}, // Q23292616
    {Coordinate{18.9708, 47.4999}, CountryId{"HU"}}, // Q23292887
    {Coordinate{18.9769, 47.4941}, CountryId{"HU"}}, // Széchenyi-hegy Station
    {Coordinate{18.9744, 47.388}, CountryId{"HU"}}, // Nagytétény railway station
    {Coordinate{2.47177, 48.8352}, CountryId{"FR"}}, // Nogent-sur-Marne (Paris RER)
    {Coordinate{24.2792, 57.1283}, CountryId{"LV"}}, // Carnikava Station
    {Coordinate{4.67557, 50.513}, CountryId{"BE"}}, // Mazy railway station
    {Coordinate{24.1563, 56.9655}, CountryId{"LV"}}, // Zemitāni Station
    {Coordinate{24.02, 56.9497}, CountryId{"LV"}}, // Zolitūde Station
    {Coordinate{5.30306, 52.1653}, CountryId{"NL"}}, // Soest Zuid railway station
    {Coordinate{5.89038, 50.8665}, CountryId{"NL"}}, // Klimmen-Ransdaal railway station
    {Coordinate{5.33447, 46.054}, CountryId{"FR"}}, // Q2330039
    {Coordinate{15.9251, 38.6832}, CountryId{"IT"}}, // Q23301322
    {Coordinate{2.30722, 48.7006}, CountryId{"FR"}}, // Gare de Chilly-Mazarin
    {Coordinate{-1.21165, 48.1225}, CountryId{"FR"}}, // Gare de Vitré
    {Coordinate{6.01472, 51.9431}, CountryId{"NL"}}, // Duiven railway station
    {Coordinate{6.30944, 53.2558}, CountryId{"NL"}}, // Grijpskerk railway station
    {Coordinate{3.77778, 50.6272}, CountryId{"BE"}}, // Ath railway station
    {Coordinate{7.13159, 48.3146}, CountryId{"FR"}}, // Q2331565
    {Coordinate{4.33167, 50.7786}, CountryId{"BE"}}, // Moensberg railway station
    {Coordinate{3.7975, 51.0031}, CountryId{"BE"}}, // Melle railway station
    {Coordinate{6.295, 51.9583}, CountryId{"NL"}}, // Doetinchem railway station
    {Coordinate{5.36972, 52.0642}, CountryId{"NL"}}, // Maarn railway station
    {Coordinate{-0.066175, 48.1684}, CountryId{"FR"}}, // Q2332424
    {Coordinate{6.11086, 47.2763}, CountryId{"FR"}}, // Q2332908
    {Coordinate{4.23611, 51.9256}, CountryId{"NL"}}, // Maassluis West railway station
    {Coordinate{5.87692, 43.117}, CountryId{"FR"}}, // Gare de La Seyne-Six-Fours
    {Coordinate{2.20556, 49.0778}, CountryId{"FR"}}, // Gare de Mériel
    {Coordinate{2.12194, 48.8981}, CountryId{"FR"}}, // Le Vésinet – Le Pecq
    {Coordinate{0.716888, 45.8725}, CountryId{"FR"}}, // Gare de Chabanais
    {Coordinate{1.62861, 43.0414}, CountryId{"FR"}}, // Gare de Varilhes
    {Coordinate{24.0516, 56.9417}, CountryId{"LV"}}, // Zasulauks Station
    {Coordinate{3.50898, 50.389}, CountryId{"FR"}}, // Beuvrages
    {Coordinate{2.90944, 49.7639}, CountryId{"FR"}}, // Gare de Nesle
    {Coordinate{7.5332, 48.5428}, CountryId{"FR"}}, // Gare de Dachstein
    {Coordinate{5.85556, 50.4903}, CountryId{"BE"}}, // Spa railway station
    {Coordinate{14.5156, 50.0757}, CountryId{"CZ"}}, // Depo Hostivař
    {Coordinate{4.16592, 50.8746}, CountryId{"BE"}}, // Ternat railway station
    {Coordinate{2.31333, 48.6531}, CountryId{"FR"}}, // Sainte-Geneviève-des-Bois (Paris RER)
    {Coordinate{6.0998, 49.2559}, CountryId{"FR"}}, // Q2339319
    {Coordinate{-3.98322, 48.7207}, CountryId{"FR"}}, // Gare de Roscoff
    {Coordinate{4.02431, 49.8908}, CountryId{"FR"}}, // Gare d'Origny-en-Thiérache
    {Coordinate{0.429067, 48.7173}, CountryId{"FR"}}, // Q2340022
    {Coordinate{-4.30714, 48.4264}, CountryId{"FR"}}, // Q2340141
    {Coordinate{2.13549, 49.4142}, CountryId{"FR"}}, // Gare de Villers-sur-Thère
    {Coordinate{14.4917, 50.1061}, CountryId{"CZ"}}, // Českomoravská
    {Coordinate{19.4381, 51.0747}, CountryId{"PL"}}, // Q2341427
    {Coordinate{13.2496, 52.7536}, CountryId{"DE"}}, // Oranienburg station
    {Coordinate{2.30083, 48.7544}, CountryId{"FR"}}, // Gare d'Antony
    {Coordinate{5.16509, 51.1693}, CountryId{"BE"}}, // Balen railway station
    {Coordinate{-1.0692, 44.6406}, CountryId{"FR"}}, // gare de Gujan-Mestras
    {Coordinate{0.595833, 49.0872}, CountryId{"FR"}}, // Gare de Bernay
    {Coordinate{4.15387, 51.0194}, CountryId{"BE"}}, // Baasrode-South railway station
    {Coordinate{23.6014, 52.074}, CountryId{"PL"}}, // Q2342808
    {Coordinate{-1.11572, 43.5468}, CountryId{"FR"}}, // Gare de Peyrehorade
    {Coordinate{3.96112, 49.4348}, CountryId{"FR"}}, // Q2342913
    {Coordinate{-3.04612, 48.7769}, CountryId{"FR"}}, // Gare de Paimpol
    {Coordinate{5.40852, 50.9557}, CountryId{"BE"}}, // Bokrijk railway station
    {Coordinate{-0.131376, 45.0367}, CountryId{"FR"}}, // Gare de Coutras
    {Coordinate{13.2888, 52.6885}, CountryId{"DE"}}, // Birkenwerder station
    {Coordinate{2.20139, 48.8278}, CountryId{"FR"}}, // Gare de Sèvres – Ville-d'Avray
    {Coordinate{3.91722, 50.7517}, CountryId{"BE"}}, // Viane-Moerbeke railway station
    {Coordinate{3.19328, 50.604}, CountryId{"FR"}}, // Anstaing
    {Coordinate{2.12328, 50.9787}, CountryId{"FR"}}, // Gravelines
    {Coordinate{2.23373, 48.8835}, CountryId{"FR"}}, // Gare de Puteaux
    {Coordinate{5.11005, 43.333}, CountryId{"FR"}}, // Sausset-les-Pins train station
    {Coordinate{0.572491, 48.1223}, CountryId{"FR"}}, // Gare de Sceaux - Boëssé
    {Coordinate{3.26362, 51.3383}, CountryId{"BE"}}, // Duinbergen railway station
    {Coordinate{1.43583, 49.6294}, CountryId{"FR"}}, // Gare de Sommery
    {Coordinate{2.54778, 48.6672}, CountryId{"FR"}}, // gare de Combs-la-Ville - Quincy
    {Coordinate{6.27074, 47.1559}, CountryId{"FR"}}, // Gare d'Étalans
    {Coordinate{3.74313, 50.1582}, CountryId{"FR"}}, // Hachette railway station
    {Coordinate{6.67611, 52.61}, CountryId{"NL"}}, // Gramsbergen railway station
    {Coordinate{4.20583, 50.8669}, CountryId{"BE"}}, // Sint-Martens-Bodegem railway station
    {Coordinate{12.1772, 50.2775}, CountryId{"CZ"}}, // Studánka station
    {Coordinate{5.85944, 51.8644}, CountryId{"NL"}}, // Nijmegen Lent railway station
    {Coordinate{2.12323, 48.8611}, CountryId{"FR"}}, // Gare de Louveciennes
    {Coordinate{6.57806, 51.9211}, CountryId{"NL"}}, // Aalten railway station
    {Coordinate{5.42804, 45.4384}, CountryId{"FR"}}, // Châbons railway station
    {Coordinate{-2.51139, 48.4658}, CountryId{"FR"}}, // Gare de Lamballe
    {Coordinate{1.73028, 50.8053}, CountryId{"FR"}}, // Gare de Marquise-Rinxent
    {Coordinate{-1.75013, 48.5441}, CountryId{"FR"}}, // Gare de Dol-de-Bretagne
    {Coordinate{2.47917, 48.5736}, CountryId{"FR"}}, // Gare du Plessis-Chenet
    {Coordinate{-0.5958, 49.216}, CountryId{"FR"}}, // Q2353104
    {Coordinate{6.8712, 51.4396}, CountryId{"DE"}}, // Mülheim West station
    {Coordinate{15.3486, 50.0308}, CountryId{"CZ"}}, // Station Záboří nad Labem
    {Coordinate{7.14583, 46.0769}, CountryId{"CH"}}, // Sembrancher train station
    {Coordinate{5.69417, 50.7442}, CountryId{"BE"}}, // Visé railway station
    {Coordinate{1.09835, 49.3245}, CountryId{"FR"}}, // Gare de Tourville
    {Coordinate{3.00871, 50.4802}, CountryId{"FR"}}, // Libercourt
    {Coordinate{3.80566, 50.9007}, CountryId{"BE"}}, // Balegem-Zuid railway station
    {Coordinate{2.25861, 48.9969}, CountryId{"FR"}}, // Gare du Gros Noyer – Saint-Prix
    {Coordinate{2.42056, 49.1172}, CountryId{"FR"}}, // Gare de Luzarches
    {Coordinate{15.5739, 50.0394}, CountryId{"CZ"}}, // Přelouč (train station)
    {Coordinate{5.94361, 51.9881}, CountryId{"NL"}}, // Arnhem Presikhaaf railway station
    {Coordinate{6.03415, 47.2404}, CountryId{"FR"}}, // Q2356506
    {Coordinate{9.67993, 52.3505}, CountryId{"DE"}}, // Hannover-Bornum station
    {Coordinate{2.02315, 46.1228}, CountryId{"FR"}}, // Q2357627
    {Coordinate{4.13417, 51.005}, CountryId{"BE"}}, // Lebbeke railway station
    {Coordinate{9.66898, 52.3401}, CountryId{"DE"}}, // Empelde station
    {Coordinate{7.11994, 47.8056}, CountryId{"FR"}}, // Gare de Vieux-Thann
    {Coordinate{2.49956, 49.9117}, CountryId{"FR"}}, // Gare de Corbie
    {Coordinate{0.6077, 46.9723}, CountryId{"FR"}}, // Ormes-sur-Vienne station
    {Coordinate{72.8355, 18.9398}, CountryId{"IN"}}, // Chhatrapati Shivaji Maharaj Terminus
    {Coordinate{4.36639, 43.8325}, CountryId{"FR"}}, // Gare de Nîmes
    {Coordinate{4.21182, 47.7293}, CountryId{"FR"}}, // Q2360723
    {Coordinate{2.76071, 48.4426}, CountryId{"FR"}}, // Gare d'Héricy
    {Coordinate{4.88564, 50.4282}, CountryId{"BE"}}, // Dave-Saint-Martin railway station
    {Coordinate{-2.89239, 48.5086}, CountryId{"FR"}}, // Gare de Plouvara - Plerneuf
    {Coordinate{1.43306, 44.4492}, CountryId{"FR"}}, // Gare de Cahors
    {Coordinate{2.47296, 50.6525}, CountryId{"FR"}}, // Gare de Thiennes
    {Coordinate{-1.42882, 43.5871}, CountryId{"FR"}}, // Labenne
    {Coordinate{1.1717, 47.3438}, CountryId{"FR"}}, // Q2362220
    {Coordinate{3.91369, 50.1321}, CountryId{"FR"}}, // Q2362288
    {Coordinate{2.28811, 43.1121}, CountryId{"FR"}}, // Gare de Pomas
    {Coordinate{5.47203, 45.4918}, CountryId{"FR"}}, // Gare de Virieu-sur-Bourbre
    {Coordinate{5.4634, 43.4559}, CountryId{"FR"}}, // Gare de Gardanne
    {Coordinate{2.69194, 48.4756}, CountryId{"FR"}}, // Gare de Bois-le-Roi
    {Coordinate{3.22003, 48.974}, CountryId{"FR"}}, // Q2363439
    {Coordinate{4.26356, 50.4479}, CountryId{"BE"}}, // Carnières railway station
    {Coordinate{10.5028, 59.8853}, CountryId{"NO"}}, // Slependen Station
    {Coordinate{14.0212, 49.929}, CountryId{"CZ"}}, // Q2364893
    {Coordinate{-1.49076, 43.5235}, CountryId{"FR"}}, // Gare de Boucau
    {Coordinate{7.14861, 46.0525}, CountryId{"CH"}}, // Q2365843
    {Coordinate{4.21622, 45.5222}, CountryId{"FR"}}, // Gare de Bonson
    {Coordinate{7.04899, 48.9655}, CountryId{"FR"}}, // Q2366623
    {Coordinate{6.21892, 50.7851}, CountryId{"DE"}}, // Q2366688
    {Coordinate{8.47959, 40.2901}, CountryId{"IT"}}, // Q23666993
    {Coordinate{2.35083, 49.0794}, CountryId{"FR"}}, // Gare de Villaines
    {Coordinate{8.50121, 40.2928}, CountryId{"IT"}}, // Q23671458
    {Coordinate{-1.60989, 43.4254}, CountryId{"FR"}}, // Gare de Guéthary
    {Coordinate{9.60891, 52.2851}, CountryId{"DE"}}, // Lemmie station
    {Coordinate{9.57217, 52.2795}, CountryId{"DE"}}, // Wennigsen (Deister) station
    {Coordinate{12.5197, 50.1258}, CountryId{"CZ"}}, // Q2369541
    {Coordinate{10.5308, 44.698}, CountryId{"IT"}}, // Cavriago railway station
    {Coordinate{1.22471, 49.2339}, CountryId{"FR"}}, // Saint-Pierre-du-Vauvray
    {Coordinate{35.3114, 54.9878}, CountryId{"RU"}}, // Iznoski
    {Coordinate{9.51323, 52.2788}, CountryId{"DE"}}, // Egestorf (Deister) station
    {Coordinate{13.7247, 48.2717}, CountryId{"AT"}}, // Bahnhof Neumarkt-Kallham
    {Coordinate{21.0178, 52.2636}, CountryId{"PL"}}, // Warszawa Zoo railway station
    {Coordinate{10.4692, 44.6641}, CountryId{"IT"}}, // Bibbiano railway station
    {Coordinate{9.49163, 52.2902}, CountryId{"DE"}}, // Kirchdorf (Deister) station
    {Coordinate{6.9418, 50.9588}, CountryId{"DE"}}, // Köln-Nippes station
    {Coordinate{9.43614, 52.3234}, CountryId{"DE"}}, // Winninghausen station
    {Coordinate{9.41777, 52.3322}, CountryId{"DE"}}, // Bantorf station
    {Coordinate{9.37839, 52.344}, CountryId{"DE"}}, // Bad Nenndorf station
    {Coordinate{1.62706, 50.6827}, CountryId{"FR"}}, // Pont-de-Briques
    {Coordinate{12.7411, 49.8292}, CountryId{"CZ"}}, // Q2372955
    {Coordinate{5.8185, 49.5927}, CountryId{"BE"}}, // Messancy railway station
    {Coordinate{2.51361, 48.8533}, CountryId{"FR"}}, // Neuilly-Plaisance
    {Coordinate{3.87486, 50.587}, CountryId{"BE"}}, // Cambron-Casteau railway station
    {Coordinate{1.34083, 44.0139}, CountryId{"FR"}}, // Gare de Montauban-Ville-Bourbon
    {Coordinate{7.25166, 48.4982}, CountryId{"FR"}}, // Q2373826
    {Coordinate{1.39972, 43.4792}, CountryId{"FR"}}, // Gare de Pins-Justaret
    {Coordinate{78.0275, 12.5149}, CountryId{"IN"}}, // Rayakottai railway station
    {Coordinate{5.085, 52.6533}, CountryId{"NL"}}, // Hoorn Kersenboogerd railway station
    {Coordinate{142.024, 46.9956}, CountryId{"RU"}}, // Q2375438
    {Coordinate{-3.32228, 48.5935}, CountryId{"FR"}}, // Gare de Belle-Isle - Bégard
    {Coordinate{-2.216, 53.042}, CountryId{"GB"}}, // Longport railway station
    {Coordinate{6.146, 51.7896}, CountryId{"DE"}}, // Kleve
    {Coordinate{5.63663, 47.036}, CountryId{"FR"}}, // Q2376752
    {Coordinate{9.86722, 59.7344}, CountryId{"NO"}}, // Vestfossen Station
    {Coordinate{3.10583, 51.0648}, CountryId{"BE"}}, // Torhout railway station
    {Coordinate{7.46285, 48.5336}, CountryId{"FR"}}, // Q2377439
    {Coordinate{6.08562, 46.142}, CountryId{"FR"}}, // Saint-Julien-en-Genevois
    {Coordinate{9.91083, 59.7669}, CountryId{"NO"}}, // Hokksund Station
    {Coordinate{12.4105, 50.0504}, CountryId{"CZ"}}, // Cheb-Všeboř station
    {Coordinate{8.45695, 47.1781}, CountryId{"CH"}}, // Q23784034
    {Coordinate{2.82278, 46.9993}, CountryId{"FR"}}, // Q2378542
    {Coordinate{6.66388, 51.373}, CountryId{"DE"}}, // Krefeld-Hohenbudberg Chempark station
    {Coordinate{7.17335, 51.6676}, CountryId{"DE"}}, // Marl-Sinsen station
    {Coordinate{7.51766, 51.2528}, CountryId{"DE"}}, // Q23787924
    {Coordinate{8.19612, 47.801}, CountryId{"DE"}}, // Q23787942
    {Coordinate{3.15989, 50.622}, CountryId{"FR"}}, // Gare d'Ascq
    {Coordinate{1.98578, 46.9488}, CountryId{"FR"}}, // Q2379431
    {Coordinate{-0.321485, 44.605}, CountryId{"FR"}}, // Gare de Barsac
    {Coordinate{2.45472, 48.9325}, CountryId{"FR"}}, // Drancy Station
    {Coordinate{77.9448, 23.8453}, CountryId{"IN"}}, // Ganj Basoda railway station
    {Coordinate{75.6733, 23.0091}, CountryId{"IN"}}, // Fatehabad Chandrawatiganj Junction railway station
    {Coordinate{7.60346, 47.4534}, CountryId{"CH"}}, // Duggingen railway station
    {Coordinate{5.81312, 45.5363}, CountryId{"FR"}}, // Aiguebelette-le-Lac
    {Coordinate{-2.05353, 48.4568}, CountryId{"FR"}}, // Gare de Dinan
    {Coordinate{4.81803, 45.6272}, CountryId{"FR"}}, // Q2382041
    {Coordinate{6.16738, 50.8675}, CountryId{"DE"}}, // Alsdorf-Kellersberg station
    {Coordinate{9.96256, 52.318}, CountryId{"DE"}}, // Sehnde station
    {Coordinate{9.96658, 52.252}, CountryId{"DE"}}, // Algermissen station
    {Coordinate{0.354206, 49.5836}, CountryId{"FR"}}, // Q2382506
    {Coordinate{9.96576, 52.2076}, CountryId{"DE"}}, // Harsum station
    {Coordinate{2.25794, 48.9135}, CountryId{"FR"}}, // Les Vallées
    {Coordinate{44.4597, 48.6683}, CountryId{"RU"}}, // Yelshanka railway station
    {Coordinate{44.4406, 48.5808}, CountryId{"RU"}}, // Railway Station Beketovskaya
    {Coordinate{3.04876, 45.7948}, CountryId{"FR"}}, // Gare de Durtol - Nohanent
    {Coordinate{1.09824, 49.7155}, CountryId{"FR"}}, // Q2383414
    {Coordinate{3.16155, 45.7921}, CountryId{"FR"}}, // Gare d'Aulnat-Aéroport
    {Coordinate{14.4356, 50.0828}, CountryId{"CZ"}}, // Hlavní nádraží
    {Coordinate{6.49402, 46.5111}, CountryId{"CH"}}, // Morges railway station
    {Coordinate{5.1347, 47.1938}, CountryId{"FR"}}, // Gare de Longecourt
    {Coordinate{1.00817, 44.9412}, CountryId{"FR"}}, // Gare des Eyzies
    {Coordinate{3.62421, 49.5706}, CountryId{"FR"}}, // Gare de Laon
    {Coordinate{7.02556, 47.6178}, CountryId{"FR"}}, // Q2385464
    {Coordinate{1.41938, 43.5736}, CountryId{"FR"}}, // Gallieni-Cancéropôle
    {Coordinate{5.54444, 51.2461}, CountryId{"BE"}}, // Hamont railway station
    {Coordinate{4.74936, 46.907}, CountryId{"FR"}}, // Q2386091
    {Coordinate{1.97292, 48.2566}, CountryId{"FR"}}, // Gare de Boisseaux
    {Coordinate{6.84861, 52.7183}, CountryId{"NL"}}, // Nieuw Amsterdam railway station
    {Coordinate{3.25019, 49.6276}, CountryId{"FR"}}, // Q2386825
    {Coordinate{2.01806, 42.4633}, CountryId{"FR"}}, // Gare d'Estavar
    {Coordinate{21.1551, 51.3912}, CountryId{"PL"}}, // Radom railway station
    {Coordinate{9.86588, 52.1624}, CountryId{"DE"}}, // Emmerke station
    {Coordinate{2.264, 48.9704}, CountryId{"FR"}}, // Gare de Sannois
    {Coordinate{4.99278, 51.8719}, CountryId{"NL"}}, // Arkel railway station
    {Coordinate{6.22384, 50.7736}, CountryId{"DE"}}, // Q2388287
    {Coordinate{1.65722, 50.0825}, CountryId{"FR"}}, // Gare d'Acheux-Franleu
    {Coordinate{5.83162, 45.963}, CountryId{"FR"}}, // Seyssel - Corbonod
    {Coordinate{7.48189, 43.7623}, CountryId{"FR"}}, // Q2388773
    {Coordinate{0.6334, 47.2011}, CountryId{"FR"}}, // Q2389054
    {Coordinate{5.69048, 48.3582}, CountryId{"FR"}}, // Q2389073
    {Coordinate{5.0875, 49.9072}, CountryId{"BE"}}, // Carlsbourg railway station
    {Coordinate{4.69434, 50.4529}, CountryId{"BE"}}, // Moustier railway station
    {Coordinate{-2.14141, 48.496}, CountryId{"FR"}}, // Station Corseul - Languenan
    {Coordinate{3.18472, 49.7194}, CountryId{"FR"}}, // Gare de Flavy-le-Martel
    {Coordinate{4.50944, 51.9053}, CountryId{"NL"}}, // Rotterdam Zuid railway station
    {Coordinate{6.98667, 43.5489}, CountryId{"FR"}}, // Gare de Cannes-La Bocca
    {Coordinate{6.66042, 50.224}, CountryId{"DE"}}, // Gerolstein station
    {Coordinate{9.81487, 52.1952}, CountryId{"DE"}}, // Barnten station
    {Coordinate{9.81922, 52.2862}, CountryId{"DE"}}, // Rethen (Leine) station
    {Coordinate{3.96283, 50.9295}, CountryId{"BE"}}, // Erpe-Mere railway station
    {Coordinate{2.075, 48.5375}, CountryId{"FR"}}, // Sermaise
    {Coordinate{1.70229, 47.3325}, CountryId{"FR"}}, // Gare des Quatre-Roues
    {Coordinate{-1.44101, 47.2652}, CountryId{"FR"}}, // Thouaré
    {Coordinate{9.6907, 52.4084}, CountryId{"DE"}}, // Hannover-Ledeburg station
    {Coordinate{0.098889, 48.4342}, CountryId{"FR"}}, // Alençon railway station
    {Coordinate{9.70765, 52.4241}, CountryId{"DE"}}, // Hannover-Vinnhorst station
    {Coordinate{6.57093, 49.9987}, CountryId{"DE"}}, // Bitburg-Erdorf station
    {Coordinate{9.72587, 52.4407}, CountryId{"DE"}}, // Langenhagen Mitte station
    {Coordinate{1.34028, 44.6533}, CountryId{"FR"}}, // Q2391846
    {Coordinate{9.73636, 52.48}, CountryId{"DE"}}, // Langenhagen-Kaltenweide station
    {Coordinate{9.74813, 52.5225}, CountryId{"DE"}}, // Bissendorf station
    {Coordinate{9.7443, 52.5486}, CountryId{"DE"}}, // Mellendorf station
    {Coordinate{9.72673, 52.5811}, CountryId{"DE"}}, // Bennemühlen station
    {Coordinate{6.28133, 51.1451}, CountryId{"DE"}}, // Wegberg
    {Coordinate{6.58096, 50.3448}, CountryId{"DE"}}, // Jünkerath station
    {Coordinate{7.41993, 51.5001}, CountryId{"DE"}}, // Dortmund-Dorstfeld Süd station
    {Coordinate{9.65319, 52.272}, CountryId{"DE"}}, // Holtensen/Linderte station
    {Coordinate{3.57993, 47.8508}, CountryId{"FR"}}, // Q2393009
    {Coordinate{-1.73947, 48.0432}, CountryId{"FR"}}, // Gare de Ker-Lann
    {Coordinate{11.7514, 51.7961}, CountryId{"DE"}}, // Bernburg Hauptbahnhof
    {Coordinate{5.24857, 50.6945}, CountryId{"BE"}}, // Waremme railway station
    {Coordinate{3.92127, 50.8016}, CountryId{"BE"}}, // Idegem railway station
    {Coordinate{2.55285, 48.8772}, CountryId{"FR"}}, // Gare du Chénay – Gagny
    {Coordinate{4.99581, 50.3875}, CountryId{"BE"}}, // Courrière railway station
    {Coordinate{2.04, 48.933}, CountryId{"FR"}}, // Poissy station
    {Coordinate{0.522922, 45.1389}, CountryId{"FR"}}, // Gare de Saint-Astier
    {Coordinate{6.15667, 51.3725}, CountryId{"NL"}}, // Blerick railway station
    {Coordinate{3.99065, 49.3466}, CountryId{"FR"}}, // Q2395523
    {Coordinate{5.60648, 44.8269}, CountryId{"FR"}}, // Q2395629
    {Coordinate{2.27278, 49.3403}, CountryId{"FR"}}, // Gare d'Heilles-Mouchy
    {Coordinate{4.725, 49.7678}, CountryId{"FR"}}, // Gare de Charleville-Mézières
    {Coordinate{-0.611786, 44.9744}, CountryId{"FR"}}, // gare de Ludon
    {Coordinate{6.08389, 52.1781}, CountryId{"NL"}}, // Klarenbeek railway station
    {Coordinate{3.82944, 50.9914}, CountryId{"BE"}}, // Kwatrecht railway station
    {Coordinate{9.66535, 52.2403}, CountryId{"DE"}}, // Bennigsen station
    {Coordinate{9.62626, 52.2118}, CountryId{"DE"}}, // Völksen/Eldagsen station
    {Coordinate{9.55659, 52.2152}, CountryId{"DE"}}, // Springe station
    {Coordinate{2.00889, 48.5331}, CountryId{"FR"}}, // Dourdan
    {Coordinate{9.46804, 52.1778}, CountryId{"DE"}}, // Bad Münder (Deister) station
    {Coordinate{-1.59472, 48.0144}, CountryId{"FR"}}, // Gare de Saint-Armel
    {Coordinate{16.3587, 49.1875}, CountryId{"CZ"}}, // Q23988646
    {Coordinate{2.74486, 49.0963}, CountryId{"FR"}}, // Gare du Plessis-Belleville
    {Coordinate{5.87583, 50.9386}, CountryId{"NL"}}, // Schinnen railway station
    {Coordinate{2.23987, 48.9095}, CountryId{"FR"}}, // La Garenne-Colombes
    {Coordinate{4.82339, 50.984}, CountryId{"BE"}}, // Aarschot railway station
    {Coordinate{9.38306, 52.0463}, CountryId{"DE"}}, // Emmerthal station
    {Coordinate{9.27286, 51.9744}, CountryId{"DE"}}, // Bad Pyrmont station
    {Coordinate{9.15164, 51.9223}, CountryId{"DE"}}, // Schieder station
    {Coordinate{9.08854, 51.8683}, CountryId{"DE"}}, // Steinheim (Westf) station
    {Coordinate{0.942812, 44.9057}, CountryId{"FR"}}, // Gare du Bugue
    {Coordinate{5.19417, 52.0631}, CountryId{"NL"}}, // Bunnik railway station
    {Coordinate{0.640734, 47.4313}, CountryId{"FR"}}, // La Membrolle-sur-Choisille
    {Coordinate{-3.409, 54.356}, CountryId{"GB"}}, // Ravenglass railway station
    {Coordinate{4.49491, 50.2369}, CountryId{"BE"}}, // Yves-Gomezée railway station
    {Coordinate{6.52832, 48.1199}, CountryId{"FR"}}, // Gare d'Arches
    {Coordinate{0.375503, 49.7595}, CountryId{"FR"}}, // Q2402132
    {Coordinate{0.314167, 44.3928}, CountryId{"FR"}}, // Gare de Tonneins
    {Coordinate{2.22743, 42.5237}, CountryId{"FR"}}, // Gare de Thuès-Carança
    {Coordinate{2.51905, 48.9267}, CountryId{"FR"}}, // Freinville – Sevran railway station
    {Coordinate{2.02901, 42.4428}, CountryId{"FR"}}, // Gare d'Err
    {Coordinate{9.97921, 52.4032}, CountryId{"DE"}}, // Aligse station
    {Coordinate{10.0172, 52.4876}, CountryId{"DE"}}, // Otze station
    {Coordinate{10.0296, 52.5236}, CountryId{"DE"}}, // Ehlershausen station
    {Coordinate{3.09647, 50.6177}, CountryId{"FR"}}, // Mont-de-Terre
    {Coordinate{2.19337, 48.9684}, CountryId{"FR"}}, // Q2403653
    {Coordinate{78.1197, 20.3873}, CountryId{"IN"}}, // Yavatmal Terminus railway station
    {Coordinate{85.4628, 25.1224}, CountryId{"IN"}}, // Nalanda railway station
    {Coordinate{88.237, 22.7669}, CountryId{"IN"}}, // Baruipara railway station
    {Coordinate{5.01611, 44.7301}, CountryId{"FR"}}, // Q2404429
    {Coordinate{6.792, 51.21}, CountryId{"DE"}}, // Düsseldorf Volksgarten station
    {Coordinate{9.24399, 52.1665}, CountryId{"DE"}}, // Hessisch Oldendorf station
    {Coordinate{9.53722, 52.1194}, CountryId{"DE"}}, // Coppenbrügge station
    {Coordinate{9.58295, 52.1015}, CountryId{"DE"}}, // Voldagsen station
    {Coordinate{9.63572, 52.0974}, CountryId{"DE"}}, // Osterwald station
    {Coordinate{9.74705, 52.1205}, CountryId{"DE"}}, // Elze (Han) station
    {Coordinate{-0.600833, 43.0522}, CountryId{"FR"}}, // Gare de Sarrance
    {Coordinate{9.29111, 49.4333}, CountryId{"DE"}}, // Eicholzheim station
    {Coordinate{2.58128, 44.3619}, CountryId{"FR"}}, // Gare de Rodez
    {Coordinate{7.6933, 48.5631}, CountryId{"FR"}}, // Strasbourg-Roethig
    {Coordinate{3.05953, 50.4276}, CountryId{"FR"}}, // Leforest
    {Coordinate{3.07247, 50.6608}, CountryId{"FR"}}, // La Madeleine
    {Coordinate{0.235974, 46.2276}, CountryId{"FR"}}, // Q2406713
    {Coordinate{-0.631747, 44.8044}, CountryId{"FR"}}, // Gare de Pessac
    {Coordinate{2.29384, 50.997}, CountryId{"FR"}}, // Courghain
    {Coordinate{1.37746, 45.9046}, CountryId{"FR"}}, // Gare des Bardys
    {Coordinate{2.25936, 43.5426}, CountryId{"FR"}}, // Q2408107
    {Coordinate{7.07994, 49.0138}, CountryId{"FR"}}, // Herbitzheim
    {Coordinate{11.0312, 51.7459}, CountryId{"DE"}}, // Thale Central Station
    {Coordinate{88.7852, 22.9617}, CountryId{"IN"}}, // Chandpara railway station
    {Coordinate{75.741, 23.1458}, CountryId{"IN"}}, // Chintaman Ganesh railway station
    {Coordinate{75.5286, 23.0269}, CountryId{"IN"}}, // Gautampura Road railway station
    {Coordinate{6.145, 53.2564}, CountryId{"NL"}}, // Buitenpost railway station
    {Coordinate{6.54, 53.2911}, CountryId{"NL"}}, // Sauwerd railway station
    {Coordinate{1.0508, 49.48}, CountryId{"FR"}}, // Maromme
    {Coordinate{7.0528, 50.9156}, CountryId{"DE"}}, // Köln-Frankfurter Straße station
    {Coordinate{5.4306, 50.6608}, CountryId{"BE"}}, // Voroux railway station
    {Coordinate{3.19615, 44.4475}, CountryId{"FR"}}, // Q2410794
    {Coordinate{2.13056, 49.0604}, CountryId{"FR"}}, // Gare de Pont-Petit
    {Coordinate{2.60279, 49.31}, CountryId{"FR"}}, // Gare de Pont-Sainte-Maxence
    {Coordinate{3.8853, 50.4526}, CountryId{"BE"}}, // Jemappes railway station
    {Coordinate{2.51278, 48.795}, CountryId{"FR"}}, // La Varenne – Chennevières (Paris RER)
    {Coordinate{7.38006, 49.0007}, CountryId{"FR"}}, // gare de Lemberg
    {Coordinate{0.750208, 49.6222}, CountryId{"FR"}}, // Q2411757
    {Coordinate{3.68207, 50.1284}, CountryId{"FR"}}, // Landrecies railway station
    {Coordinate{12.6136, 49.9933}, CountryId{"CZ"}}, // Lázně Kynžvart
    {Coordinate{3.05108, 50.6724}, CountryId{"FR"}}, // Marquette
    {Coordinate{6.13072, 48.773}, CountryId{"FR"}}, // Q2412350
    {Coordinate{6.73794, 47.0556}, CountryId{"CH"}}, // Q2412486
    {Coordinate{-0.395564, 44.6744}, CountryId{"FR"}}, // Gare d'Arbanats
    {Coordinate{4.63917, 52.4428}, CountryId{"NL"}}, // Driehuis railway station
    {Coordinate{7.13723, 48.3601}, CountryId{"FR"}}, // Q2412987
    {Coordinate{4.65724, 43.8011}, CountryId{"FR"}}, // Tarascon
    {Coordinate{5.90747, 47.1847}, CountryId{"FR"}}, // Q2413225
    {Coordinate{2.19139, 48.5772}, CountryId{"FR"}}, // Breuillet - Bruyères-le-Châtel
    {Coordinate{5.855, 51.9167}, CountryId{"NL"}}, // Elst railway station
    {Coordinate{2.21472, 48.9014}, CountryId{"FR"}}, // Gare de Nanterre – Université
    {Coordinate{3.15873, 50.5492}, CountryId{"FR"}}, // Ennevelin
    {Coordinate{7.03779, 48.2658}, CountryId{"FR"}}, // Q2415356
    {Coordinate{4.63278, 50.9003}, CountryId{"BE"}}, // Veltem railway station
    {Coordinate{2.15611, 48.8853}, CountryId{"FR"}}, // Chatou – Croissy
    {Coordinate{2.28, 48.8531}, CountryId{"FR"}}, // Avenue du Président Kennedy
    {Coordinate{6.39508, 49.0143}, CountryId{"FR"}}, // Q2417113
    {Coordinate{3.48828, 51.0835}, CountryId{"BE"}}, // Bellem railway station
    {Coordinate{3.38682, 51.1075}, CountryId{"BE"}}, // Maria-Aalter railway station
    {Coordinate{12.0971, 45.3855}, CountryId{"IT"}}, // Casello 11 railway station
    {Coordinate{2.60254, 51.0773}, CountryId{"BE"}}, // De Panne railway station
    {Coordinate{-1.811, 52.484}, CountryId{"GB"}}, // Stechford railway station
    {Coordinate{5.12385, 46.2448}, CountryId{"FR"}}, // Q2419249
    {Coordinate{7.73998, 45.3497}, CountryId{"IT"}}, // Ozegna railway station
    {Coordinate{12.4878, 54.2511}, CountryId{"DE"}}, // Ribnitz-Damgarten Ost railway station
    {Coordinate{0.610432, 43.0211}, CountryId{"FR"}}, // Gare de Loures-Barbazan
    {Coordinate{2.275, 48.8564}, CountryId{"FR"}}, // Boulainvilliers
    {Coordinate{2.13611, 48.7958}, CountryId{"FR"}}, // Gare de Versailles-Chantiers
    {Coordinate{12.3728, 50.2036}, CountryId{"CZ"}}, // Velký Luh
    {Coordinate{5.1582, 47.1673}, CountryId{"FR"}}, // Gare d'Aiserey
    {Coordinate{1.93686, 49.1627}, CountryId{"FR"}}, // Gare de Chars
    {Coordinate{2.58333, 48.5967}, CountryId{"FR"}}, // gare de Savigny-le-Temple - Nandy
    {Coordinate{3.49382, 48.498}, CountryId{"FR"}}, // Q2424780
    {Coordinate{2.22106, 48.8717}, CountryId{"FR"}}, // Gare de Suresnes-Mont-Valérien
    {Coordinate{7.44976, 48.3823}, CountryId{"FR"}}, // Gare d'Eichhoffen
    {Coordinate{5.21211, 47.1315}, CountryId{"FR"}}, // Gare de Brazey-en-Plaine
    {Coordinate{1.7025, 50.1089}, CountryId{"FR"}}, // Gare de Quesnoy-le-Montant
    {Coordinate{5.69984, 45.1251}, CountryId{"FR"}}, // Pont-de-Claix railway station
    {Coordinate{27.9261, 47.7861}, CountryId{"MD"}}, // Bălți-Slobozia railway station
    {Coordinate{12.4007, 42.4004}, CountryId{"IT"}}, // Castel Bagnolo di Orte railway station
    {Coordinate{5.073, 47.2557}, CountryId{"FR"}}, // Gare d'Ouges
    {Coordinate{12.2581, 42.3039}, CountryId{"IT"}}, // Caprarola railway station
    {Coordinate{7.7157, 45.3809}, CountryId{"IT"}}, // Castellamonte railway station
    {Coordinate{13.7809, 37.3636}, CountryId{"IT"}}, // Castrofilippo railway station
    {Coordinate{7.11802, 50.7146}, CountryId{"DE"}}, // Bonn UN Campus
    {Coordinate{10.0203, 52.0977}, CountryId{"DE"}}, // Groß Düngen station
    {Coordinate{4.09972, 51.0228}, CountryId{"BE"}}, // Dendermonde railway station
    {Coordinate{2.37509, 51.0175}, CountryId{"FR"}}, // Coudekerque-Branche
    {Coordinate{2.1525, 48.695}, CountryId{"FR"}}, // Gare de La Hacquinière
    {Coordinate{10.0342, 52.0811}, CountryId{"DE"}}, // Wesseln station
    {Coordinate{10.0186, 52.0701}, CountryId{"DE"}}, // Q24278926
    {Coordinate{10.0055, 52.0626}, CountryId{"DE"}}, // Q24278951
    {Coordinate{2.02241, 47.5938}, CountryId{"FR"}}, // Gare de Lamotte-Beuvron
    {Coordinate{2.03211, 48.3485}, CountryId{"FR"}}, // Gare de Monnerville
    {Coordinate{9.75051, 52.0659}, CountryId{"DE"}}, // Banteln station
    {Coordinate{9.89897, 51.9281}, CountryId{"DE"}}, // Freden (Leine) station
    {Coordinate{7.68499, 48.521}, CountryId{"FR"}}, // Geispolsheim
    {Coordinate{6.17361, 51.7583}, CountryId{"DE"}}, // Bedburg-Hau railway station
    {Coordinate{0.4412, 46.7288}, CountryId{"FR"}}, // Q2430077
    {Coordinate{3.98169, 49.8596}, CountryId{"FR"}}, // Q2430408
    {Coordinate{5.61639, 53.0147}, CountryId{"NL"}}, // IJlst railway station
    {Coordinate{-0.0749, 49.0708}, CountryId{"FR"}}, // Gare de Mézidon
    {Coordinate{2.86901, 51.0327}, CountryId{"BE"}}, // Diksmuide railway station
    {Coordinate{6.10238, 47.2096}, CountryId{"FR"}}, // Q2432168
    {Coordinate{2.0407, 48.8074}, CountryId{"FR"}}, // Q2433863
    {Coordinate{2.07942, 48.8811}, CountryId{"FR"}}, // Gare de Mareil-Marly
    {Coordinate{-3.46686, 48.6062}, CountryId{"FR"}}, // Gare de Plouaret-Trégor
    {Coordinate{2.47879, 50.5616}, CountryId{"FR"}}, // Q2435363
    {Coordinate{2.46222, 48.7081}, CountryId{"FR"}}, // Montgeron - Crosne railway station
    {Coordinate{4.29314, 45.5659}, CountryId{"FR"}}, // Gare de Saint-Galmier - Veauche
    {Coordinate{2.48584, 42.6428}, CountryId{"FR"}}, // Q2437638
    {Coordinate{5.05181, 43.34}, CountryId{"FR"}}, // La Couronne-Carro train station
    {Coordinate{2.41111, 48.7642}, CountryId{"FR"}}, // Choisy-le-Roi
    {Coordinate{4.74883, 50.5338}, CountryId{"BE"}}, // Beuzet railway station
    {Coordinate{4.36976, 49.5043}, CountryId{"FR"}}, // Q2438613
    {Coordinate{6.82997, 53.4588}, CountryId{"NL"}}, // Eemshaven railway station
    {Coordinate{4.82583, 50.4542}, CountryId{"BE"}}, // Ronet railway station
    {Coordinate{6.33696, 47.914}, CountryId{"FR"}}, // Q2441064
    {Coordinate{4.55361, 51.8544}, CountryId{"NL"}}, // Barendrecht railway station
    {Coordinate{3.90944, 50.3414}, CountryId{"BE"}}, // Quévy railway station
    {Coordinate{5.58356, 50.5705}, CountryId{"BE"}}, // Tilff railway station
    {Coordinate{8.01757, 49.6619}, CountryId{"DE"}}, // Kirchheimbolanden station
    {Coordinate{6.00333, 52.2147}, CountryId{"NL"}}, // Apeldoorn Osseveld railway station
    {Coordinate{15.6692, 50.0303}, CountryId{"CZ"}}, // Q2442258
    {Coordinate{9.6205, 51.881}, CountryId{"DE"}}, // Stadtoldendorf station
    {Coordinate{4.35583, 51.0664}, CountryId{"BE"}}, // Willebroek railway station
    {Coordinate{0.252373, 49.5286}, CountryId{"FR"}}, // Gare de Saint-Laurent - Gainneville
    {Coordinate{2.4611, 45.6452}, CountryId{"FR"}}, // Q2442991
    {Coordinate{-0.814696, 46.7523}, CountryId{"FR"}}, // Gare de Pouzauges
    {Coordinate{2.29167, 48.7875}, CountryId{"FR"}}, // Fontenay-aux-Roses
    {Coordinate{15.8696, 50.3155}, CountryId{"CZ"}}, // Q2443591
    {Coordinate{1.41694, 50.0542}, CountryId{"FR"}}, // Gare d'Eu
    {Coordinate{5.77869, 45.8432}, CountryId{"FR"}}, // Culoz
    {Coordinate{-3.70651, 47.9267}, CountryId{"FR"}}, // Gare de Bannalec
    {Coordinate{9.45376, 51.8201}, CountryId{"DE"}}, // Holzminden station
    {Coordinate{9.4273, 51.7911}, CountryId{"DE"}}, // Lüchtringen station
    {Coordinate{9.3571, 51.7353}, CountryId{"DE"}}, // Godelheim station
    {Coordinate{13.0611, 49.7617}, CountryId{"CZ"}}, // Q2445344
    {Coordinate{7.42451, 51.3523}, CountryId{"DE"}}, // Hagen-Heubing station
    {Coordinate{0.069498, 43.2402}, CountryId{"FR"}}, // Gare de Tarbes
    {Coordinate{15.7837, 50.1559}, CountryId{"CZ"}}, // Opatovice nad Labem (train station)
    {Coordinate{4.55917, 51.1361}, CountryId{"BE"}}, // Lier railway station
    {Coordinate{7.11079, 48.3471}, CountryId{"FR"}}, // Gare de Saales
    {Coordinate{2.70425, 48.8821}, CountryId{"FR"}}, // Q2447714
    {Coordinate{-0.325965, 45.6844}, CountryId{"FR"}}, // Gare de Cognac
    {Coordinate{6.17594, 46.0109}, CountryId{"FR"}}, // Pringy
    {Coordinate{6.83701, 48.4038}, CountryId{"FR"}}, // Gare de Raon-l'Étape
    {Coordinate{2.84611, 45.8208}, CountryId{"FR"}}, // Gare de Pontgibaud
    {Coordinate{12.7297, 49.8597}, CountryId{"CZ"}}, // Planá u Mariánských Lázní (train station)
    {Coordinate{1.34362, 45.8847}, CountryId{"FR"}}, // Q2450041
    {Coordinate{5.98, 51.9947}, CountryId{"NL"}}, // Velp railway station
    {Coordinate{7.47699, 48.8727}, CountryId{"FR"}}, // Ingwiller
    {Coordinate{-1.0254, 48.1136}, CountryId{"FR"}}, // Q2453000
    {Coordinate{0.694498, 48.2672}, CountryId{"FR"}}, // Q2453056
    {Coordinate{5.93806, 50.625}, CountryId{"BE"}}, // Dolhain-Gileppe railway station
    {Coordinate{5.61444, 52.3011}, CountryId{"NL"}}, // Ermelo railway station
    {Coordinate{4.99, 51.1689}, CountryId{"BE"}}, // Geel railway station
    {Coordinate{2.56694, 48.9442}, CountryId{"FR"}}, // gare du Vert-Galant
    {Coordinate{6.13845, 43.2831}, CountryId{"FR"}}, // Q2454091
    {Coordinate{7.98738, 58.1457}, CountryId{"NO"}}, // Kristiansand Station
    {Coordinate{3.12073, 50.2863}, CountryId{"FR"}}, // Q2454325
    {Coordinate{3.25194, 49.7383}, CountryId{"FR"}}, // Gare de Montescourt
    {Coordinate{1.92087, 48.7436}, CountryId{"FR"}}, // Q2455021
    {Coordinate{3.61609, 49.3052}, CountryId{"FR"}}, // Q2455391
    {Coordinate{2.39068, 42.6034}, CountryId{"FR"}}, // Gare de Ria
    {Coordinate{4.46111, 51.3981}, CountryId{"BE"}}, // Heide railway station
    {Coordinate{8.585, 48.0878}, CountryId{"DE"}}, // Trossingen station
    {Coordinate{2.26881, 48.9055}, CountryId{"FR"}}, // Bécon-les-Bruyères
    {Coordinate{5.31333, 50.2025}, CountryId{"BE"}}, // Marloie railway station
    {Coordinate{2.63667, 47.6989}, CountryId{"FR"}}, // Gare de Gien
    {Coordinate{2.87749, 50.6806}, CountryId{"FR"}}, // Armentières
    {Coordinate{3.21897, 50.5405}, CountryId{"FR"}}, // Cobrieux
    {Coordinate{1.46889, 43.3486}, CountryId{"FR"}}, // Gare d'Auterive
    {Coordinate{2.28778, 49.1136}, CountryId{"FR"}}, // Gare de Presles-Courcelles
    {Coordinate{17.6567, 68.4335}, CountryId{"NO"}}, // Straumsnes Station
    {Coordinate{17.9659, 68.3977}, CountryId{"NO"}}, // Katterat Station
    {Coordinate{-1.1521, 46.1676}, CountryId{"FR"}}, // La Rochelle-Porte Dauphine
    {Coordinate{7.07667, 48.2896}, CountryId{"FR"}}, // Gare de Lesseux - Frapelle
    {Coordinate{4.64806, 52.0556}, CountryId{"NL"}}, // Waddinxveen Noord railway station
    {Coordinate{5.25778, 51.1175}, CountryId{"BE"}}, // Leopoldsburg railway station
    {Coordinate{5.28604, 50.6852}, CountryId{"BE"}}, // Bleret railway station
    {Coordinate{4.93384, 45.6866}, CountryId{"FR"}}, // Gare de Saint-Priest
    {Coordinate{8.73407, 44.4725}, CountryId{"IT"}}, // Mele railway station
    {Coordinate{3.03919, 43.02}, CountryId{"FR"}}, // Port-la-Nouvelle
    {Coordinate{-1.94905, 48.1388}, CountryId{"FR"}}, // Q2461161
    {Coordinate{-3.55306, 47.8694}, CountryId{"FR"}}, // Gare de Quimperlé
    {Coordinate{1.01029, 49.3027}, CountryId{"FR"}}, // Elbeuf - Saint-Aubin
    {Coordinate{9.98111, 53.4606}, CountryId{"DE"}}, // Hamburg-Harburg Rathaus
    {Coordinate{2.20972, 49.1144}, CountryId{"FR"}}, // Gare de L'Isle-Adam – Parmain
    {Coordinate{6.42528, 52.1667}, CountryId{"NL"}}, // Lochem railway station
    {Coordinate{6.05694, 50.8614}, CountryId{"NL"}}, // Kerkrade Centrum railway station
    {Coordinate{4.66556, 51.1594}, CountryId{"BE"}}, // Nijlen railway station
    {Coordinate{5.68063, 45.5245}, CountryId{"FR"}}, // Gare de Pont-de-Beauvoisin
    {Coordinate{4.30208, 50.7664}, CountryId{"BE"}}, // Beersel railway station
    {Coordinate{4.81722, 44.7544}, CountryId{"FR"}}, // Q2462836
    {Coordinate{8.7034, 58.576}, CountryId{"NO"}}, // Bøylestad Station
    {Coordinate{5.23722, 43.4425}, CountryId{"FR"}}, // Q2462992
    {Coordinate{7.08997, 51.3135}, CountryId{"DE"}}, // Velbert-Neviges station
    {Coordinate{8.68122, 58.6394}, CountryId{"NO"}}, // Flaten Station
    {Coordinate{5.61673, 50.6077}, CountryId{"BE"}}, // Chênée railway station
    {Coordinate{88.3386, 22.7541}, CountryId{"IN"}}, // Shrirampur railway station
    {Coordinate{5.23411, 51.0871}, CountryId{"BE"}}, // Beverlo railway station
    {Coordinate{2.07833, 49.0139}, CountryId{"FR"}}, // Gare de Neuville – Université
    {Coordinate{10.6174, 48.0456}, CountryId{"DE"}}, // Q2464536
    {Coordinate{7.02314, 51.4399}, CountryId{"DE"}}, // Essen Süd station
    {Coordinate{6.6326, 44.89}, CountryId{"FR"}}, // Gare de Briançon
    {Coordinate{5.20105, 47.0463}, CountryId{"FR"}}, // Gare de Pagny (Côte-d'Or)
    {Coordinate{8.72967, 47.9362}, CountryId{"DE"}}, // Immendingen station
    {Coordinate{11.3133, 50.9717}, CountryId{"DE"}}, // Berkaer Bahnhof
    {Coordinate{2.95238, 50.4169}, CountryId{"FR"}}, // Hénin-Beaumont
    {Coordinate{14.1308, 49.9372}, CountryId{"CZ"}}, // Q2466438
    {Coordinate{2.95464, 48.8105}, CountryId{"FR"}}, // Q2466859
    {Coordinate{2.29444, 48.8736}, CountryId{"FR"}}, // Charles-de-Gaulle - Étoile
    {Coordinate{2.17111, 48.5644}, CountryId{"FR"}}, // Gare de Breuillet - Village
    {Coordinate{24.6561, 60.205}, CountryId{"FI"}}, // Espoo railway station
    {Coordinate{0.639181, 48.1865}, CountryId{"FR"}}, // Q2468105
    {Coordinate{2.18444, 48.9206}, CountryId{"FR"}}, // Gare de Houilles – Carrières-sur-Seine
    {Coordinate{4.80022, 51.0225}, CountryId{"BE"}}, // Begijnendijk railway station
    {Coordinate{5.7546, 44.5195}, CountryId{"FR"}}, // Gare d'Aspres-sur-Buech
    {Coordinate{4.70161, 46.9107}, CountryId{"FR"}}, // Q2468656
    {Coordinate{16.4225, 49.9356}, CountryId{"CZ"}}, // Dlouhá Třebová
    {Coordinate{6.90296, 51.2204}, CountryId{"DE"}}, // Erkrath station
    {Coordinate{-3.49072, 48.3406}, CountryId{"FR"}}, // Gare de Carnoët - Locarn
    {Coordinate{18.0712, 68.4323}, CountryId{"NO"}}, // Bjørnfjell Station
    {Coordinate{7.18293, 50.9015}, CountryId{"DE"}}, // Q24706440
    {Coordinate{5.53139, 52.0281}, CountryId{"NL"}}, // Veenendaal West railway station
    {Coordinate{4.64556, 52.2597}, CountryId{"NL"}}, // Nieuw Vennep railway station
    {Coordinate{5.25361, 43.4097}, CountryId{"FR"}}, // Gare de Pas-des-Lanciers
    {Coordinate{76.7741, 19.2575}, CountryId{"IN"}}, // Parbhani Junction railway station
    {Coordinate{20.9753, 50.0053}, CountryId{"PL"}}, // Tarnów
    {Coordinate{0.183945, 49.5325}, CountryId{"FR"}}, // Jacques-Monod-la-Demi-Lieue station
    {Coordinate{4.64944, 52.0447}, CountryId{"NL"}}, // Waddinxveen railway station
    {Coordinate{7.08083, 51.4692}, CountryId{"DE"}}, // Essen-Kray Nord station
    {Coordinate{2.36876, 51.0304}, CountryId{"FR"}}, // Dunkirk railway station
    {Coordinate{14.392, 50.1006}, CountryId{"CZ"}}, // Dejvická
    {Coordinate{77.025, 19.1805}, CountryId{"IN"}}, // Purna Junction railway station
    {Coordinate{1.05456, 48.7608}, CountryId{"FR"}}, // Q2475867
    {Coordinate{5.04032, 43.5512}, CountryId{"FR"}}, // Saint-Chamas
    {Coordinate{14.5497, 53.4186}, CountryId{"PL"}}, // Szczecin Główny
    {Coordinate{6.59372, 51.2268}, CountryId{"DE"}}, // Kaarster See station
    {Coordinate{4.96667, 52.5114}, CountryId{"NL"}}, // Purmerend Overwhere railway station
    {Coordinate{4.32361, 50.8025}, CountryId{"BE"}}, // Uccle-Stalle railway station
    {Coordinate{4.49212, 46.0611}, CountryId{"FR"}}, // Gare de Lamure-sur-Azergues
    {Coordinate{0.576, 47.111}, CountryId{"FR"}}, // Q2478637
    {Coordinate{5.87417, 51.7267}, CountryId{"NL"}}, // Cuijk railway station
    {Coordinate{5.33176, 49.7071}, CountryId{"BE"}}, // Florenville railway station
    {Coordinate{4.32056, 50.8092}, CountryId{"BE"}}, // Forest-East railway station
    {Coordinate{13.592, 49.7401}, CountryId{"CZ"}}, // Q2479648
    {Coordinate{-3.67819, 40.3956}, CountryId{"ES"}}, // Méndez Álvaro
    {Coordinate{-3.60886, 40.4042}, CountryId{"ES"}}, // Vicálvaro - Rey Juan Carlos University
    {Coordinate{5.2243, 47.2443}, CountryId{"FR"}}, // Gare de Genlis
    {Coordinate{0.3727, 46.6515}, CountryId{"FR"}}, // Chasseneuil station
    {Coordinate{5.36236, 44.7587}, CountryId{"FR"}}, // Gare de Die
    {Coordinate{73.7853, 15.8665}, CountryId{"IN"}}, // Sawantwadi Road railway station
    {Coordinate{73.8165, 15.7079}, CountryId{"IN"}}, // Pernem railway station
    {Coordinate{5.02619, 50.4921}, CountryId{"BE"}}, // Sclaigneaux railway station
    {Coordinate{5.50944, 50.6611}, CountryId{"BE"}}, // Ans railway station
    {Coordinate{5.31889, 51.5847}, CountryId{"NL"}}, // Boxtel railway station
    {Coordinate{-1.4356, 46.6726}, CountryId{"FR"}}, // Gare de La Roche-sur-Yon
    {Coordinate{9.7389, 47.4174}, CountryId{"AT"}}, // Dornbirn station
    {Coordinate{6.11119, 46.4545}, CountryId{"CH"}}, // La Givrine station
    {Coordinate{3.7238, 50.4648}, CountryId{"BE"}}, // Ville-Pommerœul railway station
    {Coordinate{6.33562, 48.3435}, CountryId{"FR"}}, // Q2482640
    {Coordinate{0.853056, 43.1047}, CountryId{"FR"}}, // Gare de Labarthe-Inard
    {Coordinate{-0.550776, 48.1413}, CountryId{"FR"}}, // Q2483118
    {Coordinate{6.60472, 47.0536}, CountryId{"FR"}}, // Morteau
    {Coordinate{1.41389, 43.6639}, CountryId{"FR"}}, // Q2484686
    {Coordinate{-1.58748, 48.8384}, CountryId{"FR"}}, // Gare de Granville
    {Coordinate{4.39944, 45.4433}, CountryId{"FR"}}, // Gare de Saint-Étienne-Châteaucreux
    {Coordinate{4.70083, 52.6}, CountryId{"NL"}}, // Heiloo railway station
    {Coordinate{6.15641, 49.408}, CountryId{"FR"}}, // Hettange-Grande railway station
    {Coordinate{4.70972, 51.0733}, CountryId{"BE"}}, // Heist-op-den-Berg railway station
    {Coordinate{88.2117, 22.8081}, CountryId{"IN"}}, // Balarambati railway station
    {Coordinate{77.6449, 9.4975}, CountryId{"IN"}}, // Srivilliputtur railway station
    {Coordinate{88.371, 22.7603}, CountryId{"IN"}}, // Barrackpore railway station
    {Coordinate{2.77444, 48.8561}, CountryId{"FR"}}, // Val d'Europe
    {Coordinate{6.69029, 51.1858}, CountryId{"DE"}}, // Neuss Süd station
    {Coordinate{1.31113, 45.5077}, CountryId{"FR"}}, // Gare de Coussac-Bonneval
    {Coordinate{73.8761, 15.6295}, CountryId{"IN"}}, // Tivim Railway Station
    {Coordinate{6.56667, 52.4761}, CountryId{"NL"}}, // Geerdijk railway station
    {Coordinate{78.0918, 8.57914}, CountryId{"IN"}}, // Arumuganeri Railway Station
    {Coordinate{-1.81834, 47.8224}, CountryId{"FR"}}, // Messac - Guipry
    {Coordinate{5.97407, 45.3419}, CountryId{"FR"}}, // Goncelin
    {Coordinate{6.08567, 43.2364}, CountryId{"FR"}}, // Q2489194
    {Coordinate{87.475, 25.7951}, CountryId{"IN"}}, // Purnea Court Railway Station
    {Coordinate{12.6947, 49.9571}, CountryId{"CZ"}}, // Q2489524
    {Coordinate{7.33385, 48.0859}, CountryId{"FR"}}, // Q2489577
    {Coordinate{2.47333, 48.6139}, CountryId{"FR"}}, // Corbeil-Essonnes
    {Coordinate{4.95639, 50.1153}, CountryId{"BE"}}, // Beauraing railway station
    {Coordinate{76.8376, 10.8472}, CountryId{"IN"}}, // Walayar railway station
    {Coordinate{5.82222, 53.0894}, CountryId{"NL"}}, // Grou-Jirnsum railway station
    {Coordinate{2.1683, 48.8055}, CountryId{"FR"}}, // Viroflay-Rive-Droite station
    {Coordinate{91.48, 23.5108}, CountryId{"IN"}}, // Udaipur railway station
    {Coordinate{63.1667, 67.0833}, CountryId{"RU"}}, // Q2490848
    {Coordinate{5.58731, 50.5475}, CountryId{"BE"}}, // Méry railway station
    {Coordinate{5.19361, 51.5819}, CountryId{"NL"}}, // Oisterwijk railway station
    {Coordinate{82.6457, 22.3485}, CountryId{"IN"}}, // Gevra Road railway station
    {Coordinate{77.1468, 19.7264}, CountryId{"IN"}}, // Hingoli Deccan railway station
    {Coordinate{30.7406, 46.4644}, CountryId{"UA"}}, // Odessa Railway Station
    {Coordinate{-2.1936, 47.3004}, CountryId{"FR"}}, // Q2491824
    {Coordinate{4.60917, 50.4322}, CountryId{"BE"}}, // Tamines railway station
    {Coordinate{79.0435, 20.1393}, CountryId{"IN"}}, // Majri Junction railway station
    {Coordinate{77.5097, 19.1481}, CountryId{"IN"}}, // Mudkhed railway station
    {Coordinate{79.4046, 13.6245}, CountryId{"IN"}}, // Tirupati West Halt railway station
    {Coordinate{73.3025, 18.1625}, CountryId{"IN"}}, // Goregaon Road railway station
    {Coordinate{73.4182, 17.8554}, CountryId{"IN"}}, // Diwankhavati railway station
    {Coordinate{73.5155, 17.405}, CountryId{"IN"}}, // Sawarda railway station
    {Coordinate{80.3007, 15.7834}, CountryId{"IN"}}, // Vetapalem railway station
    {Coordinate{79.9833, 14.7667}, CountryId{"IN"}}, // Bitragunta railway station
    {Coordinate{80.1385, 17.2493}, CountryId{"IN"}}, // Khammam railway station
    {Coordinate{80.616, 17.5504}, CountryId{"IN"}}, // Bhadrachalam Road
    {Coordinate{85.5813, 25.6394}, CountryId{"IN"}}, // Shahpur Patori railway station
    {Coordinate{86.5162, 21.0917}, CountryId{"IN"}}, // Bhadrak railway station
    {Coordinate{77.8148, 23.5223}, CountryId{"IN"}}, // Vidisha railway station
    {Coordinate{92.3221, 24.6105}, CountryId{"IN"}}, // Patharkandi railway station
    {Coordinate{83.0141, 25.3341}, CountryId{"IN"}}, // Varanasi City railway station
    {Coordinate{77.4886, 27.2371}, CountryId{"IN"}}, // Bharatpur Junction railway station
    {Coordinate{84.1168, 23.8438}, CountryId{"IN"}}, // Barwadih Junction railway station
    {Coordinate{86.4652, 25.5059}, CountryId{"IN"}}, // Khagaria Junction railway station
    {Coordinate{85.7033, 25.6063}, CountryId{"IN"}}, // Mohiuddinnagar Railway Station
    {Coordinate{85.3652, 25.6767}, CountryId{"IN"}}, // Chak Sikandar Railway Station
    {Coordinate{85.3154, 25.6888}, CountryId{"IN"}}, // Akshaywat Rai Nagar Railway Station
    {Coordinate{78.4725, 15.468}, CountryId{"IN"}}, // Nandyal railway station
    {Coordinate{81.8492, 25.4394}, CountryId{"IN"}}, // Allahabad City railway station
    {Coordinate{77.3286, 16.4093}, CountryId{"IN"}}, // Krishna railway station
    {Coordinate{40.1167, 63.5167}, CountryId{"RU"}}, // Q24934906
    {Coordinate{4.60514, 50.7162}, CountryId{"BE"}}, // Wavre railway station
    {Coordinate{41.3047, 56.3689}, CountryId{"RU"}}, // Kovrov train station
    {Coordinate{82.88, 25.4536}, CountryId{"IN"}}, // Babatpur railway station
    {Coordinate{3.09917, 50.6205}, CountryId{"FR"}}, // Lezennes
    {Coordinate{5.25516, 47.0873}, CountryId{"FR"}}, // Q24936906
    {Coordinate{13.0774, 37.5066}, CountryId{"IT"}}, // Q24937183
    {Coordinate{13.2607, 37.499}, CountryId{"IT"}}, // Q24937188
    {Coordinate{5.24404, 47.0998}, CountryId{"FR"}}, // Q24937300
    {Coordinate{5.10452, 47.2241}, CountryId{"FR"}}, // Q24937330
    {Coordinate{35.2572, 47.8547}, CountryId{"UA"}}, // Zaporizhzhia-Vantazhne
    {Coordinate{-0.509862, 45.9408}, CountryId{"FR"}}, // Gare de Saint-Jean-d'Angély
    {Coordinate{77.3978, 8.75139}, CountryId{"IN"}}, // Kizha Ambur railway station
    {Coordinate{12.9728, 37.5938}, CountryId{"IT"}}, // Q24937760
    {Coordinate{12.8405, 37.5852}, CountryId{"IT"}}, // Selinunte railway station
    {Coordinate{79.7534, 11.7488}, CountryId{"IN"}}, // Thirupadiripuliyur railway station
    {Coordinate{23.75, 52.0644}, CountryId{"BY"}}, // Brest-South railway station
    {Coordinate{88.7778, 22.9244}, CountryId{"IN"}}, // Thakurnagar railway station
    {Coordinate{88.7451, 22.8565}, CountryId{"IN"}}, // Machhlandapur railway station
    {Coordinate{7.648, 44.5188}, CountryId{"IT"}}, // Maddalene railway station
    {Coordinate{40.1717, 50.4219}, CountryId{"RU"}}, // Q24938258
    {Coordinate{4.5009, 50.9896}, CountryId{"BE"}}, // Hofstade railway station
    {Coordinate{13.7027, 37.4097}, CountryId{"IT"}}, // Q24939188
    {Coordinate{13.7277, 37.4061}, CountryId{"IT"}}, // Q24939189
    {Coordinate{82.6997, 25.7628}, CountryId{"IN"}}, // Jaunpur Junction railway station
    {Coordinate{75.8671, 23.1139}, CountryId{"IN"}}, // Matana Buzurg railway station
    {Coordinate{75.8603, 23.2111}, CountryId{"IN"}}, // Pingleshwar railway station
    {Coordinate{84.7398, 23.6808}, CountryId{"IN"}}, // Tori Junction railway station
    {Coordinate{18.3543, 40.1463}, CountryId{"IT"}}, // Q24940099
    {Coordinate{5.07833, 47.3708}, CountryId{"FR"}}, // Gare de Ruffey
    {Coordinate{14.8601, 40.8589}, CountryId{"IT"}}, // Q24940466
    {Coordinate{14.8535, 40.8745}, CountryId{"IT"}}, // Q24940469
    {Coordinate{5.11006, 47.3898}, CountryId{"FR"}}, // Q24940485
    {Coordinate{14.4627, 41.0286}, CountryId{"IT"}}, // Santa Maria a Vico railway station
    {Coordinate{83.1873, 25.5447}, CountryId{"IN"}}, // Aunrihar Junction railway station
    {Coordinate{16.0583, 37.9249}, CountryId{"IT"}}, // Capo Spartivento railway station
    {Coordinate{83.1451, 23.137}, CountryId{"IN"}}, // Ambikapur railway station
    {Coordinate{82.667, 25.7341}, CountryId{"IN"}}, // Jaunpur City railway station
    {Coordinate{84.0194, 24.9559}, CountryId{"IN"}}, // Sasaram Junction railway station
    {Coordinate{75.7767, 22.5837}, CountryId{"IN"}}, // Haranya Kheri railway station
    {Coordinate{75.7389, 22.9313}, CountryId{"IN"}}, // Ajnod railway station
    {Coordinate{72.5036, 23.2446}, CountryId{"IN"}}, // Kalol railway station
    {Coordinate{75.377, 23.0602}, CountryId{"IN"}}, // Badnagar railway station
    {Coordinate{72.6292, 23.2334}, CountryId{"IN"}}, // Gandhinagar Capital railway station
    {Coordinate{85.8413, 20.3478}, CountryId{"IN"}}, // Patia railway station
    {Coordinate{86.4853, 25.3701}, CountryId{"IN"}}, // Purabsarai railway station
    {Coordinate{85.8532, 20.2929}, CountryId{"IN"}}, // Vani Vihar railway station
    {Coordinate{85.8449, 20.3219}, CountryId{"IN"}}, // Mancheswar railway station
    {Coordinate{85.8352, 20.3822}, CountryId{"IN"}}, // New Bhubaneswar railway station
    {Coordinate{74.0205, 18.4916}, CountryId{"IN"}}, // Loni railway station
    {Coordinate{73.9714, 18.512}, CountryId{"IN"}}, // Manjari Budruk railway station
    {Coordinate{75.0046, 15.4404}, CountryId{"IN"}}, // Dharwad railway station
    {Coordinate{74.1368, 18.4942}, CountryId{"IN"}}, // Uruli railway station
    {Coordinate{74.2563, 18.4889}, CountryId{"IN"}}, // Yawat railway station
    {Coordinate{74.1714, 18.2866}, CountryId{"IN"}}, // Jejuri railway station
    {Coordinate{74.0637, 17.6884}, CountryId{"IN"}}, // Satara railway station
    {Coordinate{88.6696, 26.5306}, CountryId{"IN"}}, // Mohitnagar railway station
    {Coordinate{74.853, 24.4599}, CountryId{"IN"}}, // Neemuch railway station
    {Coordinate{75.0763, 24.0759}, CountryId{"IN"}}, // Mandsaur railway station
    {Coordinate{77.7324, 20.9021}, CountryId{"IN"}}, // New Amravati railway station
    {Coordinate{71.9231, 26.9306}, CountryId{"IN"}}, // Pokaran railway station
    {Coordinate{70.9282, 26.9165}, CountryId{"IN"}}, // Jaisalmer railway station
    {Coordinate{81.8063, 26.153}, CountryId{"IN"}}, // Amethi railway station
    {Coordinate{79.846, 10.7592}, CountryId{"IN"}}, // Nagapattinam Junction railway station
    {Coordinate{79.6301, 10.5318}, CountryId{"IN"}}, // Tiruturaipundi Junction railway station
    {Coordinate{79.4556, 10.6745}, CountryId{"IN"}}, // Mannargudi railway station
    {Coordinate{79.4127, 10.7736}, CountryId{"IN"}}, // Nidamangalam Junction railway station
    {Coordinate{77.3073, 8.96399}, CountryId{"IN"}}, // Tenkasi Junction railway station
    {Coordinate{79.0034, 10.1721}, CountryId{"IN"}}, // Aranthangi railway station
    {Coordinate{79.319, 10.4168}, CountryId{"IN"}}, // Pattukkottai railway station
    {Coordinate{77.345, 10.02}, CountryId{"IN"}}, // Bodinayakkanur railway station
    {Coordinate{78.8369, 9.35839}, CountryId{"IN"}}, // Ramanathapuram railway station
    {Coordinate{81.1066, 16.7132}, CountryId{"IN"}}, // Powerpet railway station
    {Coordinate{81.1805, 16.7814}, CountryId{"IN"}}, // Denduluru railway station
    {Coordinate{77.2419, 8.98741}, CountryId{"IN"}}, // Sengottai railway station
    {Coordinate{79.2004, 10.2854}, CountryId{"IN"}}, // Peravurani railway station
    {Coordinate{77.561, 9.4524}, CountryId{"IN"}}, // Rajapalayam railway station
    {Coordinate{77.6814, 22.7868}, CountryId{"IN"}}, // Budhni railway station
    {Coordinate{78.5614, 12.498}, CountryId{"IN"}}, // Tiruppattur railway station
    {Coordinate{84.9865, 25.5746}, CountryId{"IN"}}, // Neora railway station
    {Coordinate{79.6475, 21.2385}, CountryId{"IN"}}, // Bhandara Road railway station
    {Coordinate{79.7514, 21.3424}, CountryId{"IN"}}, // Tumsar Road Junction railway station
    {Coordinate{79.7124, 21.263}, CountryId{"IN"}}, // Koka railway station
    {Coordinate{79.694, 21.5502}, CountryId{"IN"}}, // Dongri Buzurg railway station
    {Coordinate{79.7232, 21.5147}, CountryId{"IN"}}, // Gobarwahi railway station
    {Coordinate{79.7063, 21.4663}, CountryId{"IN"}}, // Chicholi railway station
    {Coordinate{79.7139, 21.422}, CountryId{"IN"}}, // Mitewani railway station
    {Coordinate{79.7418, 21.3838}, CountryId{"IN"}}, // Tumsar Town railway station
    {Coordinate{80.1527, 16.405}, CountryId{"IN"}}, // Sattenapalle railway station
    {Coordinate{79.5508, 21.2422}, CountryId{"IN"}}, // Khat railway station
    {Coordinate{76.6903, 20.8017}, CountryId{"IN"}}, // Shegaon railway station
    {Coordinate{81.5263, 16.81}, CountryId{"IN"}}, // Tadepalligudem railway station
    {Coordinate{79.5463, 29.2666}, CountryId{"IN"}}, // Kathgodam railway station
    {Coordinate{73.6793, 16.1113}, CountryId{"IN"}}, // Sindhudurg railway station
    {Coordinate{73.6781, 16.0177}, CountryId{"IN"}}, // Kudal railway station
    {Coordinate{73.7341, 15.9477}, CountryId{"IN"}}, // Zarap railway station
    {Coordinate{73.8128, 15.8039}, CountryId{"IN"}}, // Madure railway station
    {Coordinate{77.1242, 31.0388}, CountryId{"IN"}}, // Shoghi railway station
    {Coordinate{76.7889, 31.9884}, CountryId{"IN"}}, // Joginder Nagar railway station
    {Coordinate{75.2908, 31.5194}, CountryId{"IN"}}, // Beas Junction railway station
    {Coordinate{76.4019, 30.3421}, CountryId{"IN"}}, // Patiala railway station
    {Coordinate{76.594, 30.4865}, CountryId{"IN"}}, // Rajpura Junction railway station
    {Coordinate{74.5889, 16.8587}, CountryId{"IN"}}, // Sangli railway station
    {Coordinate{73.8373, 19.8975}, CountryId{"IN"}}, // Devlali railway station
    {Coordinate{74.5033, 19.9029}, CountryId{"IN"}}, // Kopargaon railway station
    {Coordinate{74.2157, 17.31}, CountryId{"IN"}}, // Karad railway station
    {Coordinate{75.3193, 17.6685}, CountryId{"IN"}}, // Pandharpur railway station
    {Coordinate{79.3005, 19.9601}, CountryId{"IN"}}, // Chandrapur railway station
    {Coordinate{77.9059, 21.8964}, CountryId{"IN"}}, // Betul railway station
    {Coordinate{78.6192, 20.7391}, CountryId{"IN"}}, // Sevagram Junction railway station
    {Coordinate{78.1381, 20.7847}, CountryId{"IN"}}, // Dhamangaon railway station
    {Coordinate{72.9143, 20.9469}, CountryId{"IN"}}, // Navsari railway station
    {Coordinate{72.8515, 21.1712}, CountryId{"IN"}}, // Udhna Junction railway station
    {Coordinate{74.2534, 22.8436}, CountryId{"IN"}}, // Dahod railway station
    {Coordinate{73.0006, 21.6239}, CountryId{"IN"}}, // Ankleshwar railway station
    {Coordinate{72.8557, 22.6941}, CountryId{"IN"}}, // Nadiad Junction railway station
    {Coordinate{70.3508, 23.3041}, CountryId{"IN"}}, // Bhachau railway station
    {Coordinate{72.1411, 21.7817}, CountryId{"IN"}}, // Bhavnagar Terminus railway station
    {Coordinate{70.4576, 21.5306}, CountryId{"IN"}}, // Junagadh Junction railway station
    {Coordinate{70.7956, 21.9725}, CountryId{"IN"}}, // Gondal railway station
    {Coordinate{71.6656, 22.1829}, CountryId{"IN"}}, // Botad Junction railway station
    {Coordinate{77.7173, 22.753}, CountryId{"IN"}}, // Hoshangabad railway station
    {Coordinate{80.7631, 24.2555}, CountryId{"IN"}}, // Maihar railway station
    {Coordinate{78.3545, 22.7539}, CountryId{"IN"}}, // Pipariya railway station
    {Coordinate{78.7917, 22.8995}, CountryId{"IN"}}, // Gadarwara railway station
    {Coordinate{79.2144, 22.9431}, CountryId{"IN"}}, // Narsinghpur railway station
    {Coordinate{75.6507, 25.4079}, CountryId{"IN"}}, // Bundi railway station
    {Coordinate{75.8298, 24.4195}, CountryId{"IN"}}, // Bhawani Mandi railway station
    {Coordinate{75.1322, 32.7691}, CountryId{"IN"}}, // Manwal railway station
    {Coordinate{74.8292, 12.9636}, CountryId{"IN"}}, // Thokur railway station
    {Coordinate{79.7342, 26.555}, CountryId{"IN"}}, // Jhinjhak railway station
    {Coordinate{80.962, 16.6496}, CountryId{"IN"}}, // Nuzividu railway station
    {Coordinate{80.788, 16.1059}, CountryId{"IN"}}, // Bhattiprolu railway station
    {Coordinate{79.683, 13.7464}, CountryId{"IN"}}, // Srikalahasti railway station
    {Coordinate{79.1032, 13.2199}, CountryId{"IN"}}, // Chittoor railway station
    {Coordinate{79.604, 13.9439}, CountryId{"IN"}}, // Venkatagiri railway station
    {Coordinate{73.7281, 24.5824}, CountryId{"IN"}}, // Rana Pratap Nagar railway station
    {Coordinate{73.0397, 26.2916}, CountryId{"IN"}}, // Raikabag Palace Junction railway station
    {Coordinate{79.3921, 18.6138}, CountryId{"IN"}}, // Peddapalli Junction railway station
    {Coordinate{76.6388, 28.5935}, CountryId{"IN"}}, // Jhajjar railway station
    {Coordinate{77.3422, 28.1518}, CountryId{"IN"}}, // Palwal railway station
    {Coordinate{76.5796, 28.8909}, CountryId{"IN"}}, // Rohtak Junction railway station
    {Coordinate{79.4383, 16.4695}, CountryId{"IN"}}, // Macherla railway station
    {Coordinate{79.748, 16.0507}, CountryId{"IN"}}, // Vinukonda railway station
    {Coordinate{86.1345, 25.4253}, CountryId{"IN"}}, // Begusarai railway station
    {Coordinate{84.9053, 26.6557}, CountryId{"IN"}}, // Bapudham Motihari railway station
    {Coordinate{92.7868, 24.8303}, CountryId{"IN"}}, // Silchar Railway Station
    {Coordinate{80.0399, 16.2297}, CountryId{"IN"}}, // Narasaraopet railway station
    {Coordinate{76.1467, 24.5806}, CountryId{"IN"}}, // Jhalawar City railway station
    {Coordinate{93.4384, 25.8372}, CountryId{"IN"}}, // Diphu railway station
    {Coordinate{82.9575, 25.2879}, CountryId{"IN"}}, // Bhulanpur railway station
    {Coordinate{80.2364, 26.4592}, CountryId{"IN"}}, // Panki railway station
    {Coordinate{79.5717, 27.3824}, CountryId{"IN"}}, // Farrukhabad Junction railway station
    {Coordinate{78.1342, 9.90851}, CountryId{"IN"}}, // Madurai East railway station
    {Coordinate{79.5337, 29.2151}, CountryId{"IN"}}, // Haldwani railway station
    {Coordinate{79.5176, 29.0716}, CountryId{"IN"}}, // Lalkuan Junction Railway Station
    {Coordinate{79.1222, 29.3902}, CountryId{"IN"}}, // Ramnagar railway station
    {Coordinate{74.5168, 17.008}, CountryId{"IN"}}, // Bhilawadi railway station
    {Coordinate{88.3978, 22.4727}, CountryId{"IN"}}, // New Garia railway station
    {Coordinate{74.1476, 17.691}, CountryId{"IN"}}, // Koregaon railway station
    {Coordinate{79.3123, 19.9401}, CountryId{"IN"}}, // Chanda Fort railway station
    {Coordinate{79.3128, 19.9209}, CountryId{"IN"}}, // Babupeth railway station
    {Coordinate{79.2796, 19.9819}, CountryId{"IN"}}, // Vivekanand Nagar railway station
    {Coordinate{75.0046, 30.1981}, CountryId{"IN"}}, // Bathinda Cantonment railway station
    {Coordinate{75.7243, 29.1523}, CountryId{"IN"}}, // Hisar Junction railway station
    {Coordinate{77.7796, 28.7396}, CountryId{"IN"}}, // Hapur Junction railway station
    {Coordinate{75.1534, 27.6163}, CountryId{"IN"}}, // Sikar Junction railway station
    {Coordinate{73.7399, 25.6694}, CountryId{"IN"}}, // Marwar Ranawas railway station
    {Coordinate{76.2521, 13.3144}, CountryId{"IN"}}, // Arsikere Junction railway station
    {Coordinate{77.7267, 24.5802}, CountryId{"IN"}}, // Ashoknagar railway station
    {Coordinate{77.0472, 21.0957}, CountryId{"IN"}}, // Akot railway station
    {Coordinate{81.068, 20.5867}, CountryId{"IN"}}, // Dalli-Rajhara railway station
    {Coordinate{75.4208, 32.0441}, CountryId{"IN"}}, // Gurdaspur railway station
    {Coordinate{77.2168, 28.6586}, CountryId{"IN"}}, // Sadar Bazar railway station
    {Coordinate{77.1299, 28.6802}, CountryId{"IN"}}, // Shakur Basti railway station
    {Coordinate{84.9733, 19.359}, CountryId{"IN"}}, // Chhatrapur railway station
    {Coordinate{75.9056, 31.5241}, CountryId{"IN"}}, // Hoshiarpur railway station
    {Coordinate{77.1008, 22.3384}, CountryId{"IN"}}, // Harda railway station
    {Coordinate{74.2936, 29.6117}, CountryId{"IN"}}, // Hanumangarh Junction railway station
    {Coordinate{76.4359, 22.548}, CountryId{"IN"}}, // Harsud railway station
    {Coordinate{81.2393, 26.2327}, CountryId{"IN"}}, // Rae Bareli Junction railway station
    {Coordinate{78.1923, 27.3289}, CountryId{"IN"}}, // Barhan railway station
    {Coordinate{74.1831, 14.8214}, CountryId{"IN"}}, // Karwar railway station
    {Coordinate{82.502, 25.1608}, CountryId{"IN"}}, // Vindhyachal railway station
    {Coordinate{74.7717, 13.3363}, CountryId{"IN"}}, // Udupi railway station
    {Coordinate{74.6534, 26.4108}, CountryId{"IN"}}, // Adarshnagar railway station
    {Coordinate{82.4221, 22.0291}, CountryId{"IN"}}, // Akaltara railway station
    {Coordinate{76.2862, 25.8282}, CountryId{"IN"}}, // Amli railway station
    {Coordinate{78.1232, 21.9197}, CountryId{"IN"}}, // Amla Junction railway station
    {Coordinate{91.8608, 23.9305}, CountryId{"IN"}}, // Ambassa railway station
    {Coordinate{81.3343, 21.2013}, CountryId{"IN"}}, // Bhilai Nagar railway station
    {Coordinate{77.1377, 28.7468}, CountryId{"IN"}}, // Badli railway station
    {Coordinate{77.083, 30.8909}, CountryId{"IN"}}, // Barog railway station
    {Coordinate{79.2543, 28.8656}, CountryId{"IN"}}, // Bilaspur Road railway station
    {Coordinate{85.8794, 23.7864}, CountryId{"IN"}}, // Bokaro Thermal railway station
    {Coordinate{92.5411, 24.1955}, CountryId{"IN"}}, // Bairabi railway station
    {Coordinate{79.1464, 29.1579}, CountryId{"IN"}}, // Bazpur railway station
    {Coordinate{74.0395, 15.0069}, CountryId{"IN"}}, // Canacona railway station
    {Coordinate{82.6651, 22.0347}, CountryId{"IN"}}, // Champa Junction railway station
    {Coordinate{76.8868, 30.7271}, CountryId{"IN"}}, // Chandi Mandir railway station
    {Coordinate{75.3032, 22.5938}, CountryId{"IN"}}, // Dhar railway station
    {Coordinate{74.3345, 15.3979}, CountryId{"IN"}}, // Castle Rock railway station
    {Coordinate{74.9662, 28.2883}, CountryId{"IN"}}, // Churu Junction railway station
    {Coordinate{83.5872, 26.6449}, CountryId{"IN"}}, // Chauri Chaura railway station
    {Coordinate{77.7385, 29.8964}, CountryId{"IN"}}, // Chodiala railway station
    {Coordinate{77.2932, 28.6731}, CountryId{"IN"}}, // Delhi Shahdara Junction railway station
    {Coordinate{77.0239, 30.9005}, CountryId{"IN"}}, // Dharmpur Himachal railway station
    {Coordinate{78.331, 25.8812}, CountryId{"IN"}}, // Dabra railway station
    {Coordinate{68.9804, 22.251}, CountryId{"IN"}}, // Dwarka railway station
    {Coordinate{77.9061, 26.6976}, CountryId{"IN"}}, // Dholpur Junction railway station
    {Coordinate{77.3141, 24.6405}, CountryId{"IN"}}, // Guna Junction railway station
    {Coordinate{74.971, 28.0007}, CountryId{"IN"}}, // Fatehpur Sekhawati railway station
    {Coordinate{78.0551, 27.5998}, CountryId{"IN"}}, // Hathras City railway station
    {Coordinate{74.3312, 29.5742}, CountryId{"IN"}}, // Hanumangarh Town railway station
    {Coordinate{77.5004, 13.8191}, CountryId{"IN"}}, // Hindupur Junction railway station
    {Coordinate{78.058, 27.5949}, CountryId{"IN"}}, // Hathras Kila railway station
    {Coordinate{78.1397, 27.6231}, CountryId{"IN"}}, // Hathras Road railway station
    {Coordinate{88.3965, 22.9049}, CountryId{"IN"}}, // Hooghly Ghat railway station
    {Coordinate{73.0109, 23.8354}, CountryId{"IN"}}, // Idar railway station
    {Coordinate{82.0138, 19.066}, CountryId{"IN"}}, // Jagdalpur railway station
    {Coordinate{76.2264, 32.0157}, CountryId{"IN"}}, // Jawalamukhi Road railway station
    {Coordinate{74.7644, 24.5576}, CountryId{"IN"}}, // Jawad Road railway station
    {Coordinate{75.9197, 24.5419}, CountryId{"IN"}}, // Jhalawar Road railway station
    {Coordinate{70.0314, 21.9067}, CountryId{"IN"}}, // Jam Jodhpur Junction railway station
    {Coordinate{82.7066, 25.2505}, CountryId{"IN"}}, // Kachhwa Road railway station
    {Coordinate{77.1158, 28.7697}, CountryId{"IN"}}, // Khera Kalan railway station
    {Coordinate{74.4164, 17.0842}, CountryId{"IN"}}, // Kirloskarwadi railway station
    {Coordinate{84.4681, 23.7251}, CountryId{"IN"}}, // Latehar railway station
    {Coordinate{73.0032, 26.0013}, CountryId{"IN"}}, // Luni Junction railway station
    {Coordinate{86.3121, 26.2367}, CountryId{"IN"}}, // Mithila Deep railway station
    {Coordinate{86.5746, 26.3053}, CountryId{"IN"}}, // Nirmali railway station
    {Coordinate{86.0768, 26.3482}, CountryId{"IN"}}, // Madhubani railway station
    {Coordinate{72.6333, 23.7846}, CountryId{"IN"}}, // Vadnagar railway station
    {Coordinate{73.9224, 15.314}, CountryId{"IN"}}, // Majorda Junction railway station
    {Coordinate{77.5111, 23.0937}, CountryId{"IN"}}, // Mandideep railway station
    {Coordinate{77.7358, 23.4881}, CountryId{"IN"}}, // Sanchi railway station
    {Coordinate{76.067, 23.2646}, CountryId{"IN"}}, // Tarana Road railway station
    {Coordinate{75.6823, 23.2009}, CountryId{"IN"}}, // Naikheri railway station
    {Coordinate{74.5398, 22.9075}, CountryId{"IN"}}, // Meghnagar railway station
    {Coordinate{75.5465, 18.0297}, CountryId{"IN"}}, // Madha railway station
    {Coordinate{80.3563, 22.5869}, CountryId{"IN"}}, // Mandla Fort railway station
    {Coordinate{77.1669, 28.7146}, CountryId{"IN"}}, // Naya Azadpur railway station
    {Coordinate{77.0857, 28.8469}, CountryId{"IN"}}, // Narela railway station
    {Coordinate{75.193, 26.7965}, CountryId{"IN"}}, // Naraina railway station
    {Coordinate{77.057, 28.6863}, CountryId{"IN"}}, // Nangloi railway station
    {Coordinate{85.5486, 24.8868}, CountryId{"IN"}}, // Nawada railway station
    {Coordinate{82.5646, 22.023}, CountryId{"IN"}}, // Janjgir Naila railway station
    {Coordinate{79.4595, 25.9825}, CountryId{"IN"}}, // Orai railway station
    {Coordinate{81.8992, 22.7558}, CountryId{"IN"}}, // Pendra Road railway station
    {Coordinate{72.6294, 22.9597}, CountryId{"IN"}}, // Vatva Railway Station
    {Coordinate{76.5158, 32.0814}, CountryId{"IN"}}, // Palampur Himachal railway station
    {Coordinate{76.5244, 18.853}, CountryId{"IN"}}, // Parli Vaijnath railway station
    {Coordinate{75.7388, 18.9689}, CountryId{"IN"}}, // Beed railway station
    {Coordinate{79.5178, 29.0177}, CountryId{"IN"}}, // Pantnagar railway station
    {Coordinate{84.7995, 22.2567}, CountryId{"IN"}}, // Quarry Siding railway station
    {Coordinate{83.3907, 21.8913}, CountryId{"IN"}}, // Raigarh railway station
    {Coordinate{74.6068, 18.8781}, CountryId{"IN"}}, // Ranjangaon Road railway station
    {Coordinate{85.3836, 26.0974}, CountryId{"IN"}}, // Ram Dayalu Nagar railway station
    {Coordinate{75.5636, 27.3734}, CountryId{"IN"}}, // Ringas Junction railway station
    {Coordinate{78.2099, 30.0321}, CountryId{"IN"}}, // Raiwala railway station
    {Coordinate{70.6024, 21.169}, CountryId{"IN"}}, // Sasan Gir railway station
    {Coordinate{79.3792, 28.9693}, CountryId{"IN"}}, // Rudrapur railway station
    {Coordinate{70.7556, 21.3417}, CountryId{"IN"}}, // Visavadar Junction railway station
    {Coordinate{72.8741, 21.0777}, CountryId{"IN"}}, // Sachin railway station
    {Coordinate{74.1087, 15.2641}, CountryId{"IN"}}, // Curchorem railway station
    {Coordinate{77.0975, 30.9079}, CountryId{"IN"}}, // Solan railway station
    {Coordinate{80.109, 29.0671}, CountryId{"IN"}}, // Tanakpur railway station
    {Coordinate{77.1599, 31.1028}, CountryId{"IN"}}, // Shimla railway station
    {Coordinate{79.481, 18.1834}, CountryId{"IN"}}, // Uppal railway station
    {Coordinate{75.021, 32.572}, CountryId{"IN"}}, // Vijaypur Jammu railway station
    {Coordinate{75.5384, 23.7651}, CountryId{"IN"}}, // Vikramgarh Alot railway station
    {Coordinate{75.6985, 23.0758}, CountryId{"IN"}}, // Lekoda railway station
    {Coordinate{73.9546, 18.4732}, CountryId{"IN"}}, // Sasvad Road railway station
    {Coordinate{74.2377, 18.038}, CountryId{"IN"}}, // Taradgaon railway station
    {Coordinate{74.5782, 18.1537}, CountryId{"IN"}}, // Baramati railway station
    {Coordinate{74.4783, 18.0623}, CountryId{"IN"}}, // Sangawi railway station
    {Coordinate{76.5472, 22.0526}, CountryId{"IN"}}, // Bir railway station
    {Coordinate{76.0303, 22.2554}, CountryId{"IN"}}, // Barwaha railway station
    {Coordinate{76.0465, 22.2151}, CountryId{"IN"}}, // Omkareshwar Road railway station
    {Coordinate{76.2978, 23.4251}, CountryId{"IN"}}, // Shajapur railway station
    {Coordinate{81.0855, 20.4384}, CountryId{"IN"}}, // Gudum railway station
    {Coordinate{88.263, 27.0378}, CountryId{"IN"}}, // Darjeeling railway station
    {Coordinate{88.1437, 25.0532}, CountryId{"IN"}}, // Old Malda Junction railway station
    {Coordinate{88.4689, 26.8806}, CountryId{"IN"}}, // Sivok railway station
    {Coordinate{88.1699, 26.5767}, CountryId{"IN"}}, // Adhikari railway station
    {Coordinate{}, CountryId{"IN"}}, // Rangpo railway station
    {Coordinate{}, CountryId{"IN"}}, // Itahar Junction railway station
    {Coordinate{84.8446, 26.987}, CountryId{"IN"}}, // Raxaul Junction railway station
    {Coordinate{71.3971, 25.7445}, CountryId{"IN"}}, // Barmer railway station
    {Coordinate{84.614, 27.3332}, CountryId{"IN"}}, // Bhikhna Thori railway station
    {Coordinate{83.4213, 27.4269}, CountryId{"IN"}}, // Nautanwa railway station
    {Coordinate{82.1607, 27.4158}, CountryId{"IN"}}, // Balrampur railway station
    {Coordinate{}, CountryId{"IN"}}, // Sanu railway station
    {Coordinate{73.0379, 26.3087}, CountryId{"IN"}}, // Mahamandir railway station
    {Coordinate{70.643, 25.7439}, CountryId{"IN"}}, // Gadra Road railway station
    {Coordinate{73.0106, 26.223}, CountryId{"IN"}}, // Basni railway station
    {Coordinate{73.0929, 26.3128}, CountryId{"IN"}}, // Jodhpur Cantt railway station
    {Coordinate{73.1464, 26.3395}, CountryId{"IN"}}, // Banar railway station
    {Coordinate{73.0421, 26.3507}, CountryId{"IN"}}, // Mandor railway station
    {Coordinate{73.0145, 26.14}, CountryId{"IN"}}, // Salawas railway station
    {Coordinate{77.0107, 28.4892}, CountryId{"IN"}}, // Gurgaon railway station
    {Coordinate{76.7522, 28.3479}, CountryId{"IN"}}, // Pataudi Road railway station
    {Coordinate{77.2648, 28.5593}, CountryId{"IN"}}, // Okhla railway station
    {Coordinate{77.2473, 28.6153}, CountryId{"IN"}}, // Pragati Maidan railway station
    {Coordinate{77.2726, 28.9575}, CountryId{"IN"}}, // Baghpat Road railway station
    {Coordinate{77.5374, 28.5379}, CountryId{"IN"}}, // Dadri railway station
    {Coordinate{76.8285, 28.4671}, CountryId{"IN"}}, // Farrukhnagar railway station
    {Coordinate{76.9297, 28.4375}, CountryId{"IN"}}, // Garhi Harsaru Junction railway station
    {Coordinate{78.9607, 29.205}, CountryId{"IN"}}, // Kashipur Junction railway station
    {Coordinate{78.3357, 29.6035}, CountryId{"IN"}}, // Najibabad Junction railway station
    {Coordinate{78.1468, 29.3856}, CountryId{"IN"}}, // Bijnor railway station
    {Coordinate{77.3162, 29.4446}, CountryId{"IN"}}, // Shamli railway station
    {Coordinate{77.9726, 26.3659}, CountryId{"IN"}}, // Ambikeshwar railway station
    {Coordinate{76.286, 21.894}, CountryId{"IN"}}, // Ajanti railway station
    {Coordinate{76.5006, 31.2305}, CountryId{"IN"}}, // Anandpur Sahib railway station
    {Coordinate{83.8417, 26.1214}, CountryId{"IN"}}, // Belthara Road railway station
    {Coordinate{80.8906, 26.8102}, CountryId{"IN"}}, // Manak Nagar railway station
    {Coordinate{81.0034, 26.8603}, CountryId{"IN"}}, // Gomti Nagar railway station
    {Coordinate{72.1187, 21.7709}, CountryId{"IN"}}, // Bhavanagar Para railway station
    {Coordinate{86.9393, 23.6724}, CountryId{"IN"}}, // Burnpur railway station
    {Coordinate{76.1443, 28.8257}, CountryId{"IN"}}, // Bhiwani City railway station
    {Coordinate{77.0191, 20.9121}, CountryId{"IN"}}, // Gandhi Smarak Road railway station
    {Coordinate{75.8324, 26.8369}, CountryId{"IN"}}, // Gator Jagatpura Railway Station
    {Coordinate{75.7657, 26.9443}, CountryId{"IN"}}, // Dehar Ka Balaji Railway Station
    {Coordinate{75.7898, 26.902}, CountryId{"IN"}}, // Bais Godam railway station
    {Coordinate{75.7032, 26.9292}, CountryId{"IN"}}, // Kanakpura Railway Station
    {Coordinate{76.848, 30.6111}, CountryId{"IN"}}, // Ghaggar railway station
    {Coordinate{75.9098, 23.1048}, CountryId{"IN"}}, // Karchha railway station
    {Coordinate{77.148, 20.1031}, CountryId{"IN"}}, // Washim railway station
    {Coordinate{76.5345, 19.3582}, CountryId{"IN"}}, // Manwath Road railway station
    {Coordinate{86.1428, 23.7089}, CountryId{"IN"}}, // Ispatnagar railway station
    {Coordinate{86.0891, 23.5979}, CountryId{"IN"}}, // Radhagaon railway station
    {Coordinate{77.6851, 27.491}, CountryId{"IN"}}, // Mathura Cantt railway station
    {Coordinate{}, CountryId{"IN"}}, // Uran City railway station
    {Coordinate{86.6201, 20.2804}, CountryId{"IN"}}, // Paradeep railway station
    {Coordinate{77.6274, 27.4124}, CountryId{"IN"}}, // Murhesi Rampur railway station
    {Coordinate{77.6228, 27.5555}, CountryId{"IN"}}, // Vrindaban Road railway station
    {Coordinate{77.6706, 27.094}, CountryId{"IN"}}, // Fatehpur Sikri railway station
    {Coordinate{79.9576, 27.8147}, CountryId{"IN"}}, // Pt Ram Prasad Bismil railway station
    {Coordinate{78.0034, 26.5005}, CountryId{"IN"}}, // Morena railway station
    {Coordinate{77.6382, 25.4384}, CountryId{"IN"}}, // Shivpuri railway station
    {Coordinate{74.6308, 25.3436}, CountryId{"IN"}}, // Bhilwara railway station
    {Coordinate{73.235, 25.2358}, CountryId{"IN"}}, // Falna railway station
    {Coordinate{73.3104, 25.3476}, CountryId{"IN"}}, // Rani railway station
    {Coordinate{74.5379, 26.4908}, CountryId{"IN"}}, // Budha Pushkar Halt railway station
    {Coordinate{74.6865, 26.4643}, CountryId{"IN"}}, // Madar Junction railway station
    {Coordinate{79.5543, 26.6321}, CountryId{"IN"}}, // Phaphund railway station
    {Coordinate{78.1832, 24.171}, CountryId{"IN"}}, // Bina Junction railway station
    {Coordinate{77.4843, 12.918}, CountryId{"IN"}}, // Kengeri railway station
    {Coordinate{80.5572, 16.0679}, CountryId{"IN"}}, // Nidubrolu railway station
    {Coordinate{76.397, 21.4639}, CountryId{"IN"}}, // Nepanagar railway station
    {Coordinate{76.1987, 21.3344}, CountryId{"IN"}}, // Burhanpur railway station
    {Coordinate{76.2681, 21.3784}, CountryId{"IN"}}, // Asirgarh Road railway station
    {Coordinate{73.9072, 29.3242}, CountryId{"IN"}}, // Suratgarh Junction railway station
    {Coordinate{73.3139, 28.0436}, CountryId{"IN"}}, // Lalgarh Junction railway station
    {Coordinate{75.2455, 26.8728}, CountryId{"IN"}}, // Phulera Junction railway station
    {Coordinate{75.1799, 26.9043}, CountryId{"IN"}}, // Sambhar Lake Town railway station
    {Coordinate{83.0399, 24.2036}, CountryId{"IN"}}, // Renukoot railway station
    {Coordinate{82.6427, 24.2043}, CountryId{"IN"}}, // Singrauli railway station
    {Coordinate{82.7047, 24.1229}, CountryId{"IN"}}, // Shaktinagar Terminal railway station
    {Coordinate{83.0778, 24.6831}, CountryId{"IN"}}, // Sonbhadra railway station
    {Coordinate{72.6129, 23.044}, CountryId{"IN"}}, // Asarva Junction railway station
    {Coordinate{74.9533, 32.7624}, CountryId{"IN"}}, // Bajalta railway station
    {Coordinate{75.1512, 32.845}, CountryId{"IN"}}, // Ram Nagar JK railway station
    {Coordinate{75.0501, 32.8047}, CountryId{"IN"}}, // Sangar railway station
    {Coordinate{75.0828, 32.9419}, CountryId{"IN"}}, // Chak Rakhwal railway station
    {Coordinate{78.1345, 11.5549}, CountryId{"IN"}}, // Mallur railway station
    {Coordinate{78.1786, 11.4535}, CountryId{"IN"}}, // Rasipuram railway station
    {Coordinate{78.14, 11.0689}, CountryId{"IN"}}, // Mohanur railway station
    {Coordinate{78.1836, 11.3859}, CountryId{"IN"}}, // Puduchatram railway station
    {Coordinate{78.1761, 11.3316}, CountryId{"IN"}}, // Kalangani railway station
    {Coordinate{78.1693, 11.1711}, CountryId{"IN"}}, // Laddivadi railway station
    {Coordinate{74.0143, 22.3148}, CountryId{"IN"}}, // Chhota Udaipur railway station
    {Coordinate{78.1134, 11.0419}, CountryId{"IN"}}, // Vangal railway station
    {Coordinate{77.8233, 11.8046}, CountryId{"IN"}}, // Mettur Dam railway station
    {Coordinate{75.5519, 32.3979}, CountryId{"IN"}}, // Kathua railway station
    {Coordinate{78.0196, 29.754}, CountryId{"IN"}}, // Laksar Junction railway station
    {Coordinate{77.8628, 20.8218}, CountryId{"IN"}}, // Malkhed Railway Station
    {Coordinate{76.3858, 15.2868}, CountryId{"IN"}}, // Hosapete Junction railway station
    {Coordinate{80.673, 16.538}, CountryId{"IN"}}, // Gunadala railway station
    {Coordinate{80.7318, 16.5469}, CountryId{"IN"}}, // Mustabada railway station
    {Coordinate{77.2748, 15.617}, CountryId{"IN"}}, // Adoni railway station
    {Coordinate{80.6091, 16.2453}, CountryId{"IN"}}, // Angalakuduru railway station
    {Coordinate{80.5705, 16.2466}, CountryId{"IN"}}, // Sangam Jagarlamudi railway station
    {Coordinate{80.5197, 16.2372}, CountryId{"IN"}}, // Vejendla railway station
    {Coordinate{80.6126, 16.4142}, CountryId{"IN"}}, // Pedavadlapudi railway station
    {Coordinate{80.6048, 16.4482}, CountryId{"IN"}}, // Kolanukonda railway station
    {Coordinate{80.4958, 16.3587}, CountryId{"IN"}}, // Namburu railway station
    {Coordinate{80.4862, 16.3432}, CountryId{"IN"}}, // Pedakakani Halt railway station
    {Coordinate{80.7759, 16.1314}, CountryId{"IN"}}, // Penumarru railway station
    {Coordinate{85.4234, 22.0002}, CountryId{"IN"}}, // Banspani railway station
    {Coordinate{77.4386, 8.70778}, CountryId{"IN"}}, // Ambasamudram railway station
    {Coordinate{81.2611, 16.8085}, CountryId{"IN"}}, // Bhimadolu railway station
    {Coordinate{76.3722, 10.1331}, CountryId{"IN"}}, // Chowara railway station
    {Coordinate{86.9128, 24.8667}, CountryId{"IN"}}, // Banka railway station
    {Coordinate{77.9994, 16.7578}, CountryId{"IN"}}, // Mahbubnagar railway station
    {Coordinate{77.5619, 8.67944}, CountryId{"IN"}}, // Cheranmahadevi railway station
    {Coordinate{86.7362, 25.2409}, CountryId{"IN"}}, // Sultanganj railway station
    {Coordinate{87.0262, 24.8061}, CountryId{"IN"}}, // Mandar Hill railway station
    {Coordinate{86.4813, 25.3771}, CountryId{"IN"}}, // Munger railway station
    {Coordinate{82.3991, 25.5571}, CountryId{"IN"}}, // Jarauna railway station
    {Coordinate{88.2223, 22.7907}, CountryId{"IN"}}, // Mirzapur Bankipur railway station
    {Coordinate{-0.582266, 46.2445}, CountryId{"FR"}}, // Q2495776
    {Coordinate{2.18159, 42.8738}, CountryId{"FR"}}, // Gare de Quillan
    {Coordinate{-0.051918, 46.3998}, CountryId{"FR"}}, // Q2497266
    {Coordinate{7.32118, 48.0873}, CountryId{"FR"}}, // Q2497752
    {Coordinate{6.80166, 47.5105}, CountryId{"FR"}}, // Montbéliard railway station
    {Coordinate{2.23133, 48.9504}, CountryId{"FR"}}, // Q2498496
    {Coordinate{2.65444, 48.5272}, CountryId{"FR"}}, // Gare de Melun
    {Coordinate{1.94758, 47.8192}, CountryId{"FR"}}, // Q2499133
    {Coordinate{21.1347, 55.7208}, CountryId{"LT"}}, // Klaipėda railway station
    {Coordinate{3.1467, 50.6229}, CountryId{"FR"}}, // Annappes
    {Coordinate{6.83958, 45.9074}, CountryId{"FR"}}, // Q2499816
    {Coordinate{6.35932, 47.3541}, CountryId{"FR"}}, // Q2500921
    {Coordinate{5.76494, 45.5416}, CountryId{"FR"}}, // Lépin-le-Lac - La Bauche
    {Coordinate{-0.636382, 46.2191}, CountryId{"FR"}}, // Q2501811
    {Coordinate{52.4397, 56.5006}, CountryId{"RU"}}, // Q2502164
    {Coordinate{1.70333, 48.9898}, CountryId{"FR"}}, // Gare de Mantes-la-Jolie
    {Coordinate{2.63925, 48.8752}, CountryId{"FR"}}, // Gare de Vaires-Torcy
    {Coordinate{1.15962, 49.317}, CountryId{"FR"}}, // Q2504721
    {Coordinate{8.544, 47.4186}, CountryId{"CH"}}, // Zurich Seebach railway station
    {Coordinate{0.941325, 44.4865}, CountryId{"FR"}}, // Gare de Monsempron-Libos
    {Coordinate{4.63604, 50.6205}, CountryId{"BE"}}, // Blanmont railway station
    {Coordinate{6.18844, 50.862}, CountryId{"DE"}}, // Alsdorf-Mariadorf station
    {Coordinate{3.83518, 50.7028}, CountryId{"BE"}}, // Houraing railway station
    {Coordinate{2.48889, 48.8542}, CountryId{"FR"}}, // Val de Fontenay
    {Coordinate{3.60028, 50.8497}, CountryId{"BE"}}, // Oudenaarde railway station
    {Coordinate{1.55862, 47.1631}, CountryId{"FR"}}, // Gare de Valençay
    {Coordinate{5.71004, 50.772}, CountryId{"NL"}}, // Eijsden railway station
    {Coordinate{8.56603, 49.6589}, CountryId{"DE"}}, // Bahnhof Lorsch
    {Coordinate{8.64559, 49.9137}, CountryId{"DE"}}, // Darmstadt-Arheilgen station
    {Coordinate{11.0736, 51.8994}, CountryId{"DE"}}, // Halberstadt station
    {Coordinate{11.77, 51.2063}, CountryId{"DE"}}, // Q25089303
    {Coordinate{8.6058, 52.3063}, CountryId{"DE"}}, // Lübbecke station
    {Coordinate{11.2756, 50.6825}, CountryId{"DE"}}, // Q25089975
    {Coordinate{8.82812, 48.5228}, CountryId{"DE"}}, // Bondorf (b Herrenberg) station
    {Coordinate{4.29417, 50.7906}, CountryId{"BE"}}, // Ruisbroek railway station
    {Coordinate{0.317047, 46.4842}, CountryId{"FR"}}, // Q2510926
    {Coordinate{4.46528, 51.1539}, CountryId{"BE"}}, // Hove railway station
    {Coordinate{8.65371, 58.5295}, CountryId{"NO"}}, // Blakstad Station
    {Coordinate{8.6231, 58.4684}, CountryId{"NO"}}, // Rise Station
    {Coordinate{2.80481, 45.5795}, CountryId{"FR"}}, // Gare du Mont-Dore
    {Coordinate{8.68981, 58.4628}, CountryId{"NO"}}, // Bråstad Station
    {Coordinate{13.0006, 49.7411}, CountryId{"CZ"}}, // Stříbro station
    {Coordinate{4.82833, 51.1806}, CountryId{"BE"}}, // Herentals railway station
    {Coordinate{3.45611, 50.0675}, CountryId{"FR"}}, // Gare de Maurois
    {Coordinate{1.28569, 45.7562}, CountryId{"FR"}}, // Gare de Solignac-Le Vigen
    {Coordinate{-0.391464, 45.1391}, CountryId{"FR"}}, // Saint-Mariens - Saint-Yzan
    {Coordinate{11.2696, 60.6159}, CountryId{"NO"}}, // Tangen Station
    {Coordinate{1.61487, 50.576}, CountryId{"FR"}}, // Dannes - Camiers
    {Coordinate{3.87222, 50.7703}, CountryId{"BE"}}, // Geraardsbergen railway station
    {Coordinate{6.01417, 51.5264}, CountryId{"NL"}}, // Venray railway station
    {Coordinate{15.8975, 50.0128}, CountryId{"CZ"}}, // Q2516076
    {Coordinate{16.358, 48.2356}, CountryId{"AT"}}, // Wien Spittelau railway station
    {Coordinate{16.42, 48.1703}, CountryId{"AT"}}, // Wien Simmering railway station
    {Coordinate{3.54, 50.0914}, CountryId{"FR"}}, // Gare du Cateau
    {Coordinate{-0.547298, 44.7683}, CountryId{"FR"}}, // Gare de Villenave-d'Ornon
    {Coordinate{4.77806, 51.8294}, CountryId{"NL"}}, // Sliedrecht railway station
    {Coordinate{3.22516, 50.8262}, CountryId{"BE"}}, // Bissegem railway station
    {Coordinate{2.38444, 49.6264}, CountryId{"FR"}}, // Breteuil-Embranchement station
    {Coordinate{2.27222, 48.9138}, CountryId{"FR"}}, // Gare de Bois-Colombes
    {Coordinate{5.8602, 46.39}, CountryId{"FR"}}, // Saint-Claude railway station
    {Coordinate{86.2708, 23.7475}, CountryId{"IN"}}, // Mahuda Junction railway station
    {Coordinate{7.36544, 51.4895}, CountryId{"DE"}}, // Dortmund-Kley station
    {Coordinate{2.50972, 48.8069}, CountryId{"FR"}}, // Champigny
    {Coordinate{-1.24127, 43.6713}, CountryId{"FR"}}, // Saint-Geours-de-Maremne
    {Coordinate{6.14, 52.3897}, CountryId{"NL"}}, // Wijhe railway station
    {Coordinate{2.31028, 46.8567}, CountryId{"FR"}}, // Q2521024
    {Coordinate{6.11306, 52.3342}, CountryId{"NL"}}, // Olst railway station
    {Coordinate{4.56936, 50.6737}, CountryId{"BE"}}, // Ottignies railway station
    {Coordinate{17.646, 59.8587}, CountryId{"SE"}}, // Uppsala Central Station
    {Coordinate{5.05751, 45.8478}, CountryId{"FR"}}, // Q2522225
    {Coordinate{6.37676, 48.0531}, CountryId{"FR"}}, // Gare de Xertigny
    {Coordinate{6.01972, 50.8964}, CountryId{"NL"}}, // Landgraaf railway station
    {Coordinate{3.68219, 49.3109}, CountryId{"FR"}}, // Gare de Fismes
    {Coordinate{3.69833, 50.8742}, CountryId{"BE"}}, // Sint-Denijs-Boekel railway station
    {Coordinate{7.08893, 51.4441}, CountryId{"DE"}}, // Essen-Steele Ost station
    {Coordinate{14.3883, 50.0075}, CountryId{"CZ"}}, // Praha-Velká Chuchle
    {Coordinate{4.02361, 50.9067}, CountryId{"BE"}}, // Haaltert railway station
    {Coordinate{-3.71889, 40.4214}, CountryId{"ES"}}, // Príncipe Pío
    {Coordinate{5.85167, 51.9547}, CountryId{"NL"}}, // Arnhem Zuid railway station
    {Coordinate{1.98833, 49.5036}, CountryId{"FR"}}, // Gare de Milly-sur-Thérain
    {Coordinate{13.2436, 49.7622}, CountryId{"CZ"}}, // Q2527749
    {Coordinate{1.25148, 45.8384}, CountryId{"FR"}}, // Gare de Limoges-Montjovis
    {Coordinate{2.12278, 48.5494}, CountryId{"FR"}}, // gare de Saint-Chéron
    {Coordinate{-0.454722, 46.3194}, CountryId{"FR"}}, // Gare de Niort
    {Coordinate{3.24593, 50.7137}, CountryId{"BE"}}, // Herseaux railway station
    {Coordinate{5.195, 51.8992}, CountryId{"NL"}}, // Beesd railway station
    {Coordinate{2.15944, 48.4369}, CountryId{"FR"}}, // Gare d'Étampes
    {Coordinate{24.548, 59.3249}, CountryId{"EE"}}, // Q2531292
    {Coordinate{0.045103, 44.5629}, CountryId{"FR"}}, // Gare de Lamothe-Landerron
    {Coordinate{4.36056, 51.0908}, CountryId{"BE"}}, // Boom railway station
    {Coordinate{2.61152, 46.3356}, CountryId{"FR"}}, // Q2531756
    {Coordinate{2.38694, 48.3706}, CountryId{"FR"}}, // gare de Buno - Gironville
    {Coordinate{2.07361, 48.9906}, CountryId{"FR"}}, // Gare de Conflans-Fin-d'Oise
    {Coordinate{6.0505, 48.9003}, CountryId{"FR"}}, // Gare de Pont-à-Mousson
    {Coordinate{6.63634, 45.9357}, CountryId{"FR"}}, // Q2533028
    {Coordinate{6.04611, 50.8897}, CountryId{"NL"}}, // Eygelshoven railway station
    {Coordinate{9.91517, 51.4212}, CountryId{"DE"}}, // Friedland (Han) station
    {Coordinate{2.2982, 48.8968}, CountryId{"FR"}}, // Gare de Clichy-Levallois
    {Coordinate{-9.10304, 38.7467}, CountryId{"PT"}}, // Braço de Prata
    {Coordinate{1.82472, 42.5386}, CountryId{"FR"}}, // Gare de Porté-Puymorens
    {Coordinate{9.86281, 51.3517}, CountryId{"DE"}}, // Witzenhausen Nord station
    {Coordinate{9.80429, 51.38}, CountryId{"DE"}}, // Gertenbach station
    {Coordinate{83.0089, 17.6955}, CountryId{"IN"}}, // Anakapalle railway station
    {Coordinate{1.10961, 49.677}, CountryId{"FR"}}, // Q2535233
    {Coordinate{6.2125, 51.9567}, CountryId{"NL"}}, // Wehl railway station
    {Coordinate{4.84852, 47.023}, CountryId{"FR"}}, // Gare de Beaune
    {Coordinate{6.77774, 51.365}, CountryId{"DE"}}, // Duisburg-Großenbaum station
    {Coordinate{2.10106, 41.3643}, CountryId{"ES"}}, // Rambla Just Oliveras
    {Coordinate{2.53139, 49.7142}, CountryId{"FR"}}, // Gare d'Hargicourt-Pierrepont
    {Coordinate{9.762, 51.3921}, CountryId{"DE"}}, // Hedemünden station
    {Coordinate{9.65815, 51.4124}, CountryId{"DE"}}, // Hann. Münden station
    {Coordinate{5.28071, 50.0907}, CountryId{"BE"}}, // Grupont railway station
    {Coordinate{41.6775, 41.6586}, CountryId{"GE"}}, // Batumi railway station
    {Coordinate{8.6778, 48.8656}, CountryId{"DE"}}, // Q25389195
    {Coordinate{5.3904, 43.3391}, CountryId{"FR"}}, // Q2538961
    {Coordinate{40.0167, 61.6667}, CountryId{"RU"}}, // Q25393617
    {Coordinate{32.2839, 54.7991}, CountryId{"RU"}}, // Q25393696
    {Coordinate{89.0342, 53.4783}, CountryId{"RU"}}, // Q25393791
    {Coordinate{31.2167, 69.5833}, CountryId{"RU"}}, // Q25393792
    {Coordinate{38.0081, 63.75}, CountryId{"RU"}}, // Q25393812
    {Coordinate{38.2017, 56.3439}, CountryId{"RU"}}, // 76 km
    {Coordinate{89.9606, 54.4883}, CountryId{"RU"}}, // Q25393935
    {Coordinate{91.1317, 53.5953}, CountryId{"RU"}}, // Q25393939
    {Coordinate{100.548, 54.5919}, CountryId{"RU"}}, // Tulun station
    {Coordinate{90.4189, 53.1317}, CountryId{"RU"}}, // Askiz
    {Coordinate{89.5183, 53.4589}, CountryId{"RU"}}, // Q25393942
    {Coordinate{93.3767, 54.2933}, CountryId{"RU"}}, // Q25393944
    {Coordinate{112.823, 56.2597}, CountryId{"RU"}}, // Q25393948
    {Coordinate{111.736, 56.1492}, CountryId{"RU"}}, // Q25393952
    {Coordinate{110.102, 55.9303}, CountryId{"RU"}}, // Q25393954
    {Coordinate{109.603, 55.8117}, CountryId{"RU"}}, // Q25393956
    {Coordinate{110.907, 56.0119}, CountryId{"RU"}}, // Q25393962
    {Coordinate{111.527, 56.1636}, CountryId{"RU"}}, // Q25393975
    {Coordinate{113.672, 56.1683}, CountryId{"RU"}}, // Q25394017
    {Coordinate{104.245, 56.7114}, CountryId{"RU"}}, // Q25394040
    {Coordinate{24.7917, 56.5758}, CountryId{"LV"}}, // Lāčplēsis train station
    {Coordinate{61.685, 57.8564}, CountryId{"RU"}}, // Q25394264
    {Coordinate{40.5836, 64.1531}, CountryId{"RU"}}, // Q25394338
    {Coordinate{62.0506, 56.7781}, CountryId{"RU"}}, // Q25394486
    {Coordinate{}, CountryId{"RU"}}, // Q25394514
    {Coordinate{133.41, 44.28}, CountryId{"RU"}}, // Q25394517
    {Coordinate{62.7128, 56.8486}, CountryId{"RU"}}, // Q25394621
    {Coordinate{39.7181, 52.0694}, CountryId{"RU"}}, // Q25394642
    {Coordinate{43.6994, 54.9447}, CountryId{"RU"}}, // Bereshino
    {Coordinate{54.1505, 54.0182}, CountryId{"RU"}}, // Q25394689
    {Coordinate{59.643, 42.438}, CountryId{"UZ"}}, // Q25394710
    {Coordinate{29.245, 60.9617}, CountryId{"RU"}}, // Q25394799
    {Coordinate{30.8806, 59.7917}, CountryId{"RU"}}, // Q25395025
    {Coordinate{36.4329, 53.2429}, CountryId{"RU"}}, // Q25395512
    {Coordinate{27.1514, 56.537}, CountryId{"LV"}}, // Q25395632
    {Coordinate{28.0569, 54.0196}, CountryId{"BY"}}, // Smalyavichy
    {Coordinate{33.3049, 54.5565}, CountryId{"RU"}}, // Q25395760
    {Coordinate{90.6977, 53.2656}, CountryId{"RU"}}, // Q25395780
    {Coordinate{32.4878, 67.3736}, CountryId{"RU"}}, // Q25395958
    {Coordinate{61.4556, 59.2778}, CountryId{"RU"}}, // Q25396117
    {Coordinate{30.3672, 59.5736}, CountryId{"RU"}}, // Q25396143
    {Coordinate{88.0316, 53.6949}, CountryId{"RU"}}, // Q25396301
    {Coordinate{60.0972, 57.1739}, CountryId{"RU"}}, // Q25396411
    {Coordinate{60.1522, 57.3303}, CountryId{"RU"}}, // Q25396412
    {Coordinate{60.7564, 54.9832}, CountryId{"RU"}}, // Q25396586
    {Coordinate{32.1573, 53.7222}, CountryId{"BY"}}, // Shastsyorawka
    {Coordinate{25.6168, 56.526}, CountryId{"LV"}}, // Q25396738
    {Coordinate{15.7692, 50.1311}, CountryId{"CZ"}}, // Q2539686
    {Coordinate{}, CountryId{"RU"}}, // Q25397021
    {Coordinate{73.4856, 54.9351}, CountryId{"RU"}}, // Q25397062
    {Coordinate{74.5781, 55.0435}, CountryId{"RU"}}, // Q25397063
    {Coordinate{74.0963, 54.9974}, CountryId{"RU"}}, // Q25397068
    {Coordinate{75.9567, 55.2147}, CountryId{"RU"}}, // Q25397143
    {Coordinate{75.2186, 55.1247}, CountryId{"RU"}}, // Q25397172
    {Coordinate{76.5792, 54.7103}, CountryId{"RU"}}, // Q25397290
    {Coordinate{76.3452, 54.901}, CountryId{"RU"}}, // Q25397298
    {Coordinate{73.2575, 54.908}, CountryId{"RU"}}, // Q25397325
    {Coordinate{7.5727, 44.461}, CountryId{"IT"}}, // San Benigno di Cuneo railway station
    {Coordinate{9.43056, 46.8286}, CountryId{"CH"}}, // Ems Werk
    {Coordinate{15.0814, 50.7432}, CountryId{"CZ"}}, // Q25400744
    {Coordinate{18.6811, 49.6707}, CountryId{"CZ"}}, // Třinec centrum (Trzyniec centrum)
    {Coordinate{14.1475, 49.8883}, CountryId{"CZ"}}, // Q25402332
    {Coordinate{13.2294, 49.1433}, CountryId{"CZ"}}, // Q25402333
    {Coordinate{15.3108, 50.355}, CountryId{"CZ"}}, // Q25402378
    {Coordinate{12.4969, 50.3404}, CountryId{"CZ"}}, // Q25402390
    {Coordinate{13.2369, 49.1363}, CountryId{"CZ"}}, // Q25402428
    {Coordinate{15.1019, 50.608}, CountryId{"CZ"}}, // Doubí u Turnova
    {Coordinate{12.9997, 49.5303}, CountryId{"CZ"}}, // Q25402469
    {Coordinate{15.0581, 49.2097}, CountryId{"CZ"}}, // Q25402471
    {Coordinate{-1.60201, 48.1126}, CountryId{"FR"}}, // Cesson-Sévigné
    {Coordinate{16.3958, 49.9683}, CountryId{"CZ"}}, // Ústí nad Orlicí město
    {Coordinate{2.16416, 45.5305}, CountryId{"FR"}}, // Gare de Meymac
    {Coordinate{15.0381, 50.8013}, CountryId{"CZ"}}, // Q25411591
    {Coordinate{14.6291, 49.3849}, CountryId{"CZ"}}, // Q25411594
    {Coordinate{14.2031, 50.6997}, CountryId{"CZ"}}, // Q25411907
    {Coordinate{13.374, 50.184}, CountryId{"CZ"}}, // Q25411908
    {Coordinate{16.2037, 49.1924}, CountryId{"CZ"}}, // Q25411910
    {Coordinate{15.2585, 49.9237}, CountryId{"CZ"}}, // Q25411916
    {Coordinate{13.4181, 50.2619}, CountryId{"CZ"}}, // Q25411917
    {Coordinate{12.8747, 49.51}, CountryId{"CZ"}}, // Q25411918
    {Coordinate{17.3751, 49.0326}, CountryId{"CZ"}}, // Nedakonice
    {Coordinate{13.9767, 48.9369}, CountryId{"CZ"}}, // Q25411931
    {Coordinate{15.24, 49.8914}, CountryId{"CZ"}}, // Bykáň
    {Coordinate{12.8986, 49.5183}, CountryId{"CZ"}}, // Q25411939
    {Coordinate{15.2358, 49.8861}, CountryId{"CZ"}}, // Q25411943
    {Coordinate{15.5307, 50.5243}, CountryId{"CZ"}}, // Q25411945
    {Coordinate{12.5875, 50.2178}, CountryId{"CZ"}}, // Q25411946
    {Coordinate{17.5106, 48.8789}, CountryId{"CZ"}}, // Velká nad Veličkou
    {Coordinate{15.2956, 50.345}, CountryId{"CZ"}}, // Pševes
    {Coordinate{12.9829, 49.5347}, CountryId{"CZ"}}, // Q25411954
    {Coordinate{15.0797, 49.2812}, CountryId{"CZ"}}, // Q25411963
    {Coordinate{15.3366, 50.3739}, CountryId{"CZ"}}, // Q25411966
    {Coordinate{15.3244, 50.3614}, CountryId{"CZ"}}, // Q25411969
    {Coordinate{17.1887, 49.3876}, CountryId{"CZ"}}, // Pivín railway station
    {Coordinate{15.1928, 50.2684}, CountryId{"CZ"}}, // Q25411975
    {Coordinate{16.2575, 49.1835}, CountryId{"CZ"}}, // Q25411978
    {Coordinate{15.1711, 50.6036}, CountryId{"CZ"}}, // Q25411979
    {Coordinate{15.2155, 50.2559}, CountryId{"CZ"}}, // Q25411983
    {Coordinate{14.1, 49.8547}, CountryId{"CZ"}}, // Q25411987
    {Coordinate{15.0626, 49.2235}, CountryId{"CZ"}}, // Q25411990
    {Coordinate{15.233, 50.2437}, CountryId{"CZ"}}, // Q25411991
    {Coordinate{15.3413, 50.1859}, CountryId{"CZ"}}, // Q25411994
    {Coordinate{15.2242, 49.8553}, CountryId{"CZ"}}, // Q25411998
    {Coordinate{15.6325, 49.6696}, CountryId{"CZ"}}, // Q25411999
    {Coordinate{14.5155, 50.3467}, CountryId{"CZ"}}, // Q25412000
    {Coordinate{14.018, 48.9471}, CountryId{"CZ"}}, // Skříněřov
    {Coordinate{14.5464, 50.3442}, CountryId{"CZ"}}, // Q25412007
    {Coordinate{14.0561, 49.4981}, CountryId{"CZ"}}, // Q25412008
    {Coordinate{13.4647, 50.3297}, CountryId{"CZ"}}, // Q25412011
    {Coordinate{14.0767, 49.4703}, CountryId{"CZ"}}, // Q25412014
    {Coordinate{15.0784, 50.6293}, CountryId{"CZ"}}, // Q25412023
    {Coordinate{15.1084, 50.6942}, CountryId{"CZ"}}, // Q25412030
    {Coordinate{15.0986, 50.6364}, CountryId{"CZ"}}, // Q25412031
    {Coordinate{17.7426, 49.4232}, CountryId{"CZ"}}, // Q25412037
    {Coordinate{12.5672, 50.1397}, CountryId{"CZ"}}, // Q25412038
    {Coordinate{14.0818, 49.4458}, CountryId{"CZ"}}, // Q25412041
    {Coordinate{14.6382, 51.5056}, CountryId{"DE"}}, // Weißwasser (Oberlausitz) railway station
    {Coordinate{7.12213, 51.3548}, CountryId{"DE"}}, // Velbert-Langenberg station
    {Coordinate{5.12528, 52.11}, CountryId{"NL"}}, // Utrecht Overvecht railway station
    {Coordinate{11.4633, 60.8753}, CountryId{"NO"}}, // Q25425250
    {Coordinate{8.65705, 58.4651}, CountryId{"NO"}}, // Rossedalen Station
    {Coordinate{6.12413, 43.1088}, CountryId{"FR"}}, // Gare d'Hyères
    {Coordinate{7.13445, 49.0782}, CountryId{"FR"}}, // Q2542772
    {Coordinate{10.6744, 60.6635}, CountryId{"NO"}}, // Bøverbru Station
    {Coordinate{10.7489, 60.6533}, CountryId{"NO"}}, // Kolbu Station
    {Coordinate{10.9022, 60.6714}, CountryId{"NO"}}, // Bilitt Station
    {Coordinate{}, CountryId{"NO"}}, // Ørtfjell Station
    {Coordinate{2.13417, 48.89}, CountryId{"FR"}}, // Le Vésinet – Centre
    {Coordinate{37.7011, 49.0333}, CountryId{"UA"}}, // Q25432066
    {Coordinate{37.6494, 48.8689}, CountryId{"UA"}}, // Q25432189
    {Coordinate{37.9731, 48.3958}, CountryId{"UA"}}, // Q25432241
    {Coordinate{38.0842, 48.7889}, CountryId{"UA"}}, // Q25432364
    {Coordinate{37.8639, 48.2236}, CountryId{"UA"}}, // Q25432482
    {Coordinate{32.3837, 48.5906}, CountryId{"UA"}}, // Q25434278
    {Coordinate{39.2419, 48.5697}, CountryId{"UA"}}, // Q25434705
    {Coordinate{38.5428, 48.3825}, CountryId{"UA"}}, // Q25435245
    {Coordinate{37.5589, 48.5936}, CountryId{"UA"}}, // Q25435435
    {Coordinate{38.0775, 48.0858}, CountryId{"UA"}}, // Q25435638
    {Coordinate{37.7867, 48.0914}, CountryId{"UA"}}, // Q25435677
    {Coordinate{35.4867, 48.2423}, CountryId{"UA"}}, // Q25435717
    {Coordinate{24.614, 48.6894}, CountryId{"UA"}}, // Tarnovytsia
    {Coordinate{24.5952, 49.0001}, CountryId{"UA"}}, // Q25435779
    {Coordinate{37.2439, 48.1494}, CountryId{"UA"}}, // Q25435799
    {Coordinate{37.3069, 48.0833}, CountryId{"UA"}}, // Q25435800
    {Coordinate{25.723, 49.0231}, CountryId{"UA"}}, // Bila-Chortkivska
    {Coordinate{25.6496, 49.3606}, CountryId{"UA"}}, // Mykulyntsi-Strusiv
    {Coordinate{25.9452, 48.8897}, CountryId{"UA"}}, // Q25435832
    {Coordinate{25.3544, 49.4714}, CountryId{"UA"}}, // Q25435846
    {Coordinate{37.4061, 48.8303}, CountryId{"UA"}}, // Q25435910
    {Coordinate{37.27, 48.8597}, CountryId{"UA"}}, // Q25435914
    {Coordinate{38.4289, 48.3528}, CountryId{"UA"}}, // Q25436013
    {Coordinate{38.5081, 48.2061}, CountryId{"UA"}}, // Q25436020
    {Coordinate{38.5672, 48.1319}, CountryId{"UA"}}, // Q25436021
    {Coordinate{38.4972, 48.0403}, CountryId{"UA"}}, // Q25436026
    {Coordinate{24.0921, 49.8825}, CountryId{"UA"}}, // Q25436034
    {Coordinate{22.7584, 49.5046}, CountryId{"UA"}}, // Q25436046
    {Coordinate{38.2586, 48.0256}, CountryId{"UA"}}, // Q25436306
    {Coordinate{38.2239, 47.9564}, CountryId{"UA"}}, // Q25436312
    {Coordinate{34.8651, 50.7256}, CountryId{"UA"}}, // Q25436369
    {Coordinate{34.8539, 50.8952}, CountryId{"UA"}}, // Sumy-Tovarna
    {Coordinate{34.3043, 51.093}, CountryId{"UA"}}, // Q25436507
    {Coordinate{34.3747, 50.9539}, CountryId{"UA"}}, // Q25436567
    {Coordinate{33.4322, 49.1065}, CountryId{"UA"}}, // Q25436842
    {Coordinate{36.3291, 49.0312}, CountryId{"UA"}}, // Q25437090
    {Coordinate{35.8522, 49.6736}, CountryId{"UA"}}, // Q25437184
    {Coordinate{39.4744, 48.6544}, CountryId{"UA"}}, // Q25437501
    {Coordinate{39.4472, 48.6767}, CountryId{"UA"}}, // Q25437507
    {Coordinate{39.2778, 48.7719}, CountryId{"UA"}}, // Q25437586
    {Coordinate{39.0689, 48.8436}, CountryId{"UA"}}, // Q25437614
    {Coordinate{36.3483, 48.3794}, CountryId{"UA"}}, // Q25439131
    {Coordinate{35.6242, 48.3064}, CountryId{"UA"}}, // Q25439605
    {Coordinate{1.90667, 47.9267}, CountryId{"FR"}}, // Gare des Aubrais-Orléans
    {Coordinate{2.32222, 48.9056}, CountryId{"FR"}}, // Saint-Ouen
    {Coordinate{25.9275, 49.0989}, CountryId{"UA"}}, // Kopychyntsi
    {Coordinate{34.7331, 47.7706}, CountryId{"UA"}}, // Q25444859
    {Coordinate{24.1934, 49.6999}, CountryId{"UA"}}, // Q25444923
    {Coordinate{24.1493, 49.7418}, CountryId{"UA"}}, // Q25444927
    {Coordinate{37.86, 48.4328}, CountryId{"UA"}}, // Q25444938
    {Coordinate{24.2266, 49.628}, CountryId{"UA"}}, // Q25444945
    {Coordinate{24.2145, 49.5605}, CountryId{"UA"}}, // Q25444947
    {Coordinate{24.2193, 49.4964}, CountryId{"UA"}}, // Q25444955
    {Coordinate{24.1578, 49.3778}, CountryId{"UA"}}, // Q25444956
    {Coordinate{24.1048, 49.3281}, CountryId{"UA"}}, // Hnizdychiv
    {Coordinate{23.9637, 49.2925}, CountryId{"UA"}}, // Q25444959
    {Coordinate{37.1492, 48.8828}, CountryId{"UA"}}, // Q25444967
    {Coordinate{37.1492, 48.8828}, CountryId{"UA"}}, // Q25444975
    {Coordinate{36.9253, 48.9264}, CountryId{"UA"}}, // Q25444976
    {Coordinate{23.8284, 50.1241}, CountryId{"UA"}}, // Q25445001
    {Coordinate{23.6631, 49.3011}, CountryId{"UA"}}, // Q25445009
    {Coordinate{23.5464, 49.2956}, CountryId{"UA"}}, // Stebnyk
    {Coordinate{24.3508, 50.1989}, CountryId{"UA"}}, // Q25445023
    {Coordinate{37.5492, 48.8575}, CountryId{"UA"}}, // Q25445037
    {Coordinate{24.2236, 50.3533}, CountryId{"UA"}}, // Q25445049
    {Coordinate{38.5231, 48.2658}, CountryId{"UA"}}, // Q25445053
    {Coordinate{38.3906, 48.0403}, CountryId{"UA"}}, // Q25445094
    {Coordinate{25.7661, 50.2417}, CountryId{"UA"}}, // Q25445118
    {Coordinate{26.1872, 51.4317}, CountryId{"UA"}}, // Q25445128
    {Coordinate{26.018, 51.6404}, CountryId{"UA"}}, // Q25445129
    {Coordinate{35.9514, 50.1597}, CountryId{"UA"}}, // Q25445222
    {Coordinate{35.0641, 50.4021}, CountryId{"UA"}}, // Q25445284
    {Coordinate{35.1349, 50.3434}, CountryId{"UA"}}, // Q25445285
    {Coordinate{34.9197, 50.5467}, CountryId{"UA"}}, // Q25445297
    {Coordinate{34.8773, 50.6509}, CountryId{"UA"}}, // Q25445306
    {Coordinate{34.6771, 50.5725}, CountryId{"UA"}}, // Q25445308
    {Coordinate{34.4909, 50.5691}, CountryId{"UA"}}, // Q25445349
    {Coordinate{34.8867, 50.8621}, CountryId{"UA"}}, // Basy
    {Coordinate{34.6706, 50.9425}, CountryId{"UA"}}, // Q25445377
    {Coordinate{34.5728, 50.9739}, CountryId{"UA"}}, // Q25445384
    {Coordinate{34.4642, 51.0017}, CountryId{"UA"}}, // Ambary
    {Coordinate{34.3748, 51.0212}, CountryId{"UA"}}, // Vyry
    {Coordinate{34.2714, 51.1419}, CountryId{"UA"}}, // Q25445428
    {Coordinate{35.025, 50.8252}, CountryId{"UA"}}, // Q25445447
    {Coordinate{35.1374, 50.82}, CountryId{"UA"}}, // Q25445459
    {Coordinate{35.2579, 50.7831}, CountryId{"UA"}}, // Q25445467
    {Coordinate{33.5667, 49.016}, CountryId{"UA"}}, // Q25445496
    {Coordinate{33.4898, 50.7013}, CountryId{"UA"}}, // Q25445542
    {Coordinate{36.0781, 49.9762}, CountryId{"UA"}}, // Q25445565
    {Coordinate{36.0024, 49.9953}, CountryId{"UA"}}, // Q25445568
    {Coordinate{35.9533, 50.0497}, CountryId{"UA"}}, // Q25445578
    {Coordinate{36.0531, 49.7184}, CountryId{"UA"}}, // Q25445591
    {Coordinate{36.1404, 49.651}, CountryId{"UA"}}, // Q25445593
    {Coordinate{36.1696, 49.5911}, CountryId{"UA"}}, // Bezpalivka
    {Coordinate{36.1398, 49.483}, CountryId{"UA"}}, // Q25445612
    {Coordinate{36.2081, 49.3821}, CountryId{"UA"}}, // Q25445626
    {Coordinate{36.3067, 49.2639}, CountryId{"UA"}}, // Q25445628
    {Coordinate{36.3214, 49.1399}, CountryId{"UA"}}, // Q25445631
    {Coordinate{36.2811, 48.9404}, CountryId{"UA"}}, // Q25445647
    {Coordinate{36.0876, 49.7705}, CountryId{"UA"}}, // Q25445657
    {Coordinate{35.8592, 50.4175}, CountryId{"UA"}}, // Q25445671
    {Coordinate{36.4311, 49.9022}, CountryId{"UA"}}, // Q25445683
    {Coordinate{37.8153, 48.5925}, CountryId{"UA"}}, // Q25445796
    {Coordinate{37.9925, 48.6339}, CountryId{"UA"}}, // Q25445799
    {Coordinate{36.2231, 48.7692}, CountryId{"UA"}}, // Q25445818
    {Coordinate{35.9856, 48.7047}, CountryId{"UA"}}, // Q25445824
    {Coordinate{35.8867, 48.6275}, CountryId{"UA"}}, // Aromatna
    {Coordinate{35.6806, 48.4247}, CountryId{"UA"}}, // Q25445871
    {Coordinate{35.4031, 48.6167}, CountryId{"UA"}}, // Q25445934
    {Coordinate{35.5661, 48.5928}, CountryId{"UA"}}, // Q25445948
    {Coordinate{35.3283, 47.9186}, CountryId{"UA"}}, // Ninth kilometer
    {Coordinate{36.0267, 48.4444}, CountryId{"UA"}}, // Q25446105
    {Coordinate{36.4864, 48.4311}, CountryId{"UA"}}, // Petropavlivka
    {Coordinate{36.7056, 48.3875}, CountryId{"UA"}}, // Q25446176
    {Coordinate{35.175, 49.1039}, CountryId{"UA"}}, // Q25446186
    {Coordinate{35.7103, 48.3264}, CountryId{"UA"}}, // Q25446197
    {Coordinate{35.8044, 48.2033}, CountryId{"UA"}}, // Q25446200
    {Coordinate{36.0572, 48.2072}, CountryId{"UA"}}, // Q25446226
    {Coordinate{35.1217, 48.5403}, CountryId{"UA"}}, // Samarivka
    {Coordinate{28.7822, 55.4913}, CountryId{"BY"}}, // Polatsk
    {Coordinate{37.1032, 50.2039}, CountryId{"UA"}}, // Q25446556
    {Coordinate{37.345, 50.1613}, CountryId{"UA"}}, // Q25446590
    {Coordinate{108.357, 46.3578}, CountryId{"MN"}}, // Choir railway station
    {Coordinate{34.2582, 51.26}, CountryId{"RU"}}, // Q25447076
    {Coordinate{107.389, 51.6139}, CountryId{"RU"}}, // Q25447549
    {Coordinate{3.26762, 48.1978}, CountryId{"FR"}}, // Sens railway station
    {Coordinate{1.59035, 48.5429}, CountryId{"FR"}}, // Q2545316
    {Coordinate{5.7147, 45.1908}, CountryId{"FR"}}, // Grenoble railway station
    {Coordinate{4.61833, 45.8332}, CountryId{"FR"}}, // Gare de l'Arbresle
    {Coordinate{1.48163, 45.8321}, CountryId{"FR"}}, // Saint-Léonard-de-Noblat station
    {Coordinate{4.39254, 45.4172}, CountryId{"FR"}}, // Q2545435
    {Coordinate{7.67597, 51.5389}, CountryId{"DE"}}, // Unna West station
    {Coordinate{6.71869, 48.2049}, CountryId{"FR"}}, // Gare de Bruyères
    {Coordinate{3.08481, 50.3981}, CountryId{"FR"}}, // Pont-de-la-Deûle
    {Coordinate{2.8631, 49.467}, CountryId{"FR"}}, // Gare de Longueil-Annel
    {Coordinate{3.2905, 50.4688}, CountryId{"FR"}}, // Landas
    {Coordinate{5.97914, 49.0136}, CountryId{"FR"}}, // Q2545995
    {Coordinate{7.16697, 43.6605}, CountryId{"FR"}}, // Q2546150
    {Coordinate{11.555, 48.1408}, CountryId{"DE"}}, // Munich Central Station
    {Coordinate{1.87164, 48.8937}, CountryId{"FR"}}, // Q2546484
    {Coordinate{3.43278, 49.9502}, CountryId{"FR"}}, // Q2546900
    {Coordinate{9.56386, 51.3773}, CountryId{"DE"}}, // Staufenberg-Speele station
    {Coordinate{15.3969, 50.0406}, CountryId{"CZ"}}, // Kojice
    {Coordinate{5.89241, 43.9247}, CountryId{"FR"}}, // Q2548471
    {Coordinate{7.6568, 50.7737}, CountryId{"DE"}}, // Au station
    {Coordinate{7.4151, 48.7636}, CountryId{"FR"}}, // Gare de Steinbourg
    {Coordinate{2.15722, 48.9375}, CountryId{"FR"}}, // Gare de Sartrouville
    {Coordinate{4.23996, 50.7334}, CountryId{"BE"}}, // Halle railway station
    {Coordinate{4.86906, 50.3488}, CountryId{"BE"}}, // Lustin railway station
    {Coordinate{7.53743, 51.5187}, CountryId{"DE"}}, // Dortmund Knappschaftskrankenhaus station
    {Coordinate{14.4778, 50.0372}, CountryId{"CZ"}}, // Roztyly
    {Coordinate{-2.36464, 47.2837}, CountryId{"FR"}}, // Q2552507
    {Coordinate{2.46299, 50.614}, CountryId{"FR"}}, // Isbergues
    {Coordinate{14.42, 50.08}, CountryId{"CZ"}}, // Národní třída
    {Coordinate{5.90737, 49.1939}, CountryId{"FR"}}, // Q2552882
    {Coordinate{1.95711, 41.2669}, CountryId{"ES"}}, // Platja de Castelldefels railway station
    {Coordinate{4.805, 43.9417}, CountryId{"FR"}}, // Gare d'Avignon-Centre
    {Coordinate{78.3146, 27.1757}, CountryId{"IN"}}, // Hirangaon railway station
    {Coordinate{5.24139, 52.14}, CountryId{"NL"}}, // Den Dolder railway station
    {Coordinate{6.68639, 53.3258}, CountryId{"NL"}}, // Stedum railway station
    {Coordinate{89.5291, 26.0602}, CountryId{"IN"}}, // Abutara Halt railway station
    {Coordinate{79.4044, 26.7019}, CountryId{"IN"}}, // Achalda railway station
    {Coordinate{77.1667, 28.7142}, CountryId{"IN"}}, // Adarsh Nagar railway station
    {Coordinate{86.159, 22.7822}, CountryId{"IN"}}, // Adityapur Railway Station
    {Coordinate{78.7029, 28.9395}, CountryId{"IN"}}, // Aghwanpur railway station
    {Coordinate{78.2169, 24.234}, CountryId{"IN"}}, // Agasod railway station
    {Coordinate{78.0158, 27.1946}, CountryId{"IN"}}, // Agra City railway station
    {Coordinate{83.8248, 26.4684}, CountryId{"IN"}}, // Ahalyapur railway station
    {Coordinate{78.0436, 29.8079}, CountryId{"IN"}}, // Aithal railway station
    {Coordinate{79.2304, 25.9037}, CountryId{"IN"}}, // Ait railway station
    {Coordinate{77.5937, 28.4728}, CountryId{"IN"}}, // Ajaibpur railway station
    {Coordinate{76.5992, 23.3783}, CountryId{"IN"}}, // Akodia railway station
    {Coordinate{81.3691, 16.5827}, CountryId{"IN"}}, // Akividu railway station
    {Coordinate{74.6691, 18.9854}, CountryId{"IN"}}, // Akolner railway station
    {Coordinate{92.5959, 24.7548}, CountryId{"IN"}}, // Algapur railway station
    {Coordinate{70.2104, 22.4468}, CountryId{"IN"}}, // Alia Bada railway station
    {Coordinate{88.1856, 26.2697}, CountryId{"IN"}}, // Aluabari Road Junction railway station
    {Coordinate{88.5106, 26.6416}, CountryId{"IN"}}, // Ambari Falakata railway station
    {Coordinate{88.354, 23.2114}, CountryId{"IN"}}, // Ambika Kalna railway station
    {Coordinate{77.7578, 20.9301}, CountryId{"IN"}}, // Amravati railway station
    {Coordinate{78.4743, 28.8927}, CountryId{"IN"}}, // Amroha railway station
    {Coordinate{86.5598, 23.4811}, CountryId{"IN"}}, // Anara Junction railway station
    {Coordinate{73.2046, 29.1969}, CountryId{"IN"}}, // Anupgarh railway station
    {Coordinate{92.743, 24.8556}, CountryId{"IN"}}, // Arunachal Junction railway station
    {Coordinate{74.6072, 31.5949}, CountryId{"IN"}}, // Atari Shyam Singh railway station
    {Coordinate{76.2049, 21.9987}, CountryId{"IN"}}, // Attar railway station
    {Coordinate{88.2516, 24.2395}, CountryId{"IN"}}, // Azimganj City railway station
    {Coordinate{92.641, 26.3102}, CountryId{"IN"}}, // Bebejia railway station
    {Coordinate{76.9662, 29.4497}, CountryId{"IN"}}, // Babarpur railway station
    {Coordinate{82.5001, 26.9385}, CountryId{"IN"}}, // Babhnan railway station
    {Coordinate{78.4518, 25.2378}, CountryId{"IN"}}, // Babina railway station
    {Coordinate{78.4034, 28.2665}, CountryId{"IN"}}, // Babrala railway station
    {Coordinate{77.8555, 28.7474}, CountryId{"IN"}}, // Babugarh railway station
    {Coordinate{81.2385, 18.7035}, CountryId{"IN"}}, // Bacheli railway station
    {Coordinate{81.1055, 26.4773}, CountryId{"IN"}}, // Bachhrawan railway station
    {Coordinate{83.2711, 20.3849}, CountryId{"IN"}}, // Badmal railway station
    {Coordinate{85.9001, 25.5813}, CountryId{"IN"}}, // Bachwara Jn railway station
    {Coordinate{77.6897, 27.3959}, CountryId{"IN"}}, // Baad railway station
    {Coordinate{75.6767, 15.9589}, CountryId{"IN"}}, // Badami railway station
    {Coordinate{86.1122, 22.0887}, CountryId{"IN"}}, // Badampahar railway station
    {Coordinate{81.4737, 16.8281}, CountryId{"IN"}}, // Badampudi railway station
    {Coordinate{92.5811, 24.8729}, CountryId{"IN"}}, // Badurpur Ghat railway station
    {Coordinate{80.651, 25.2484}, CountryId{"IN"}}, // Badausa railway station
    {Coordinate{71.3374, 21.2703}, CountryId{"IN"}}, // Badhada railway station
    {Coordinate{75.4516, 27.2521}, CountryId{"IN"}}, // Badhal railway station
    {Coordinate{75.7225, 19.874}, CountryId{"IN"}}, // Badnapur railway station
    {Coordinate{82.1906, 25.6523}, CountryId{"IN"}}, // Badshahpur railway station
    {Coordinate{73.663, 27.3114}, CountryId{"IN"}}, // Badwasi railway station
    {Coordinate{75.7002, 16.1788}, CountryId{"IN"}}, // Bagalkot railway station
    {Coordinate{84.067, 27.13}, CountryId{"IN"}}, // Bagaha railway station
    {Coordinate{82.3841, 21.0463}, CountryId{"IN"}}, // Bagbahra railway station
    {Coordinate{80.2963, 27.2281}, CountryId{"IN"}}, // Baghauli railway station
    {Coordinate{78.2603, 24.1359}, CountryId{"IN"}}, // Baghora railway station
    {Coordinate{75.8281, 16.4799}, CountryId{"IN"}}, // Bagevadi Rd railway station
    {Coordinate{77.9937, 22.6307}, CountryId{"IN"}}, // Bagra Tawa
    {Coordinate{73.7878, 25.8957}, CountryId{"IN"}}, // Bagri Nagar railway station
    {Coordinate{73.8218, 25.9168}, CountryId{"IN"}}, // Bagri Sajjanpur railway station
    {Coordinate{75.8589, 30.319}, CountryId{"IN"}}, // Bahadur Singh Wala railway station
    {Coordinate{74.7725, 30.0332}, CountryId{"IN"}}, // Bagwali railway station
    {Coordinate{88.4634, 23.4385}, CountryId{"IN"}}, // Bahadurpur railway station
    {Coordinate{76.9309, 28.7009}, CountryId{"IN"}}, // Bahadurgarh railway station
    {Coordinate{79.5006, 28.7781}, CountryId{"IN"}}, // Baheri railway station
    {Coordinate{78.6315, 28.4015}, CountryId{"IN"}}, // Bahjoi railway station
    {Coordinate{80.9986, 25.1371}, CountryId{"IN"}}, // Bahilpurwa railway station
    {Coordinate{81.6075, 27.5815}, CountryId{"IN"}}, // Bahraich railway station
    {Coordinate{86.6921, 24.4893}, CountryId{"IN"}}, // Baidyanathdham Deoghar railway station
    {Coordinate{91.6843, 26.3437}, CountryId{"IN"}}, // Baihata railway station
    {Coordinate{82.9658, 18.827}, CountryId{"IN"}}, // Baiguda railway station
    {Coordinate{86.6538, 25.901}, CountryId{"IN"}}, // Baijnathpur railway station
    {Coordinate{88.1963, 23.1191}, CountryId{"IN"}}, // Bainchi railway station
    {Coordinate{82.5299, 23.3173}, CountryId{"IN"}}, // Baikunthpur Rd railway station
    {Coordinate{85.2733, 26.7383}, CountryId{"IN"}}, // Bairgania railway station
    {Coordinate{83.7386, 26.5527}, CountryId{"IN"}}, // Baitalpur railway station
    {Coordinate{80.1994, 21.8112}, CountryId{"IN"}}, // Balaghat railway station
    {Coordinate{72.4876, 25.2131}, CountryId{"IN"}}, // Bakra Road railway station
    {Coordinate{78.1124, 29.6274}, CountryId{"IN"}}, // Balawali railway station
    {Coordinate{75.7563, 22.8737}, CountryId{"IN"}}, // Balauda Takun railway station
    {Coordinate{77.6337, 29.9285}, CountryId{"IN"}}, // Baliakheri railway station
    {Coordinate{92.5704, 26.4683}, CountryId{"IN"}}, // Balikotia railway station
    {Coordinate{77.3128, 28.3409}, CountryId{"IN"}}, // Ballabgarh railway station
    {Coordinate{74.021, 15.1517}, CountryId{"IN"}}, // Balli railway station
    {Coordinate{84.1485, 25.7591}, CountryId{"IN"}}, // Ballia railway station
    {Coordinate{79.1451, 27.5866}, CountryId{"IN"}}, // Ballupur railway station
    {Coordinate{88.3404, 22.6551}, CountryId{"IN"}}, // Bally railway station
    {Coordinate{74.4739, 27.5813}, CountryId{"IN"}}, // Balsamand railway station
    {Coordinate{85.201, 19.7474}, CountryId{"IN"}}, // Balugaon railway station
    {Coordinate{88.51, 22.749}, CountryId{"IN"}}, // Bamangachhi railway station
    {Coordinate{72.5545, 25.5031}, CountryId{"IN"}}, // Balwara railway station
    {Coordinate{69.9611, 21.8959}, CountryId{"IN"}}, // Balwa railway station
    {Coordinate{77.7064, 29.5148}, CountryId{"IN"}}, // Bamanheri railway station
    {Coordinate{79.3642, 20.9224}, CountryId{"IN"}}, // Bamhni railway station
    {Coordinate{76.2441, 28.8325}, CountryId{"IN"}}, // Bamla railway station
    {Coordinate{72.5442, 25.763}, CountryId{"IN"}}, // Bamsin railway station
    {Coordinate{74.7585, 23.0949}, CountryId{"IN"}}, // Bamnia railway station
    {Coordinate{84.291, 22.0514}, CountryId{"IN"}}, // Bamra railway station
    {Coordinate{91.2829, 26.012}, CountryId{"IN"}}, // Bamuni Gaon railway station
    {Coordinate{84.3899, 25.5613}, CountryId{"IN"}}, // Banahi railway station
    {Coordinate{77.4807, 22.4704}, CountryId{"IN"}}, // Banapura railway station
    {Coordinate{89.0257, 26.7979}, CountryId{"IN"}}, // Banarhat railway station
    {Coordinate{80.0732, 28.9917}, CountryId{"IN"}}, // Banbasa railway station
    {Coordinate{76.6593, 13.2653}, CountryId{"IN"}}, // Banasandra railway station
    {Coordinate{72.9887, 24.7132}, CountryId{"IN"}}, // Banas railway station
    {Coordinate{80.3362, 25.4777}, CountryId{"IN"}}, // Banda railway station
    {Coordinate{79.576, 23.8482}, CountryId{"IN"}}, // Bandakpur railway station
    {Coordinate{74.6914, 26.1253}, CountryId{"IN"}}, // Bandanwara railway station
    {Coordinate{92.8007, 25.0698}, CountryId{"IN"}}, // Bandarkhal railway station
    {Coordinate{77.3641, 26.9104}, CountryId{"IN"}}, // Bandh Bareta railway station
    {Coordinate{76.5667, 27.0393}, CountryId{"IN"}}, // Bandikui Junction railway station
    {Coordinate{75.1241, 23.3982}, CountryId{"IN"}}, // Bangrod railway station
    {Coordinate{81.6209, 26.2275}, CountryId{"IN"}}, // Bani railway station
    {Coordinate{71.6686, 25.8602}, CountryId{"IN"}}, // Baniya Sanda Dhora railway station
    {Coordinate{87.1937, 25.8851}, CountryId{"IN"}}, // Banmankhi Junction railway station
    {Coordinate{84.0949, 26.2659}, CountryId{"IN"}}, // Bankata railway station
    {Coordinate{87.0747, 23.2244}, CountryId{"IN"}}, // Bankura Junction railway station
    {Coordinate{77.4572, 26.9328}, CountryId{"IN"}}, // Bansi Paharpur railway station
    {Coordinate{78.0989, 26.3556}, CountryId{"IN"}}, // Banmor railway station
    {Coordinate{86.1448, 25.1245}, CountryId{"IN"}}, // Bansipur railway station
    {Coordinate{84.2152, 25.8116}, CountryId{"IN"}}, // Bansdih Road railway station
    {Coordinate{75.9351, 26.3839}, CountryId{"IN"}}, // Banasthali Niwai railway station
    {Coordinate{73.5274, 25.6018}, CountryId{"IN"}}, // Banta Raghunathgarh railway station
    {Coordinate{79.8282, 27.9292}, CountryId{"IN"}}, // Banthra railway station
    {Coordinate{75.0345, 12.8785}, CountryId{"IN"}}, // Bantawala railway station
    {Coordinate{74.0299, 29.92}, CountryId{"IN"}}, // Banwali railway station
    {Coordinate{75.5113, 27.4145}, CountryId{"IN"}}, // Baori Thikria railway station
    {Coordinate{74.1132, 26.063}, CountryId{"IN"}}, // Bar railway station
    {Coordinate{85.4124, 22.1665}, CountryId{"IN"}}, // Bara Jamda railway station
    {Coordinate{82.8137, 22.0117}, CountryId{"IN"}}, // Baradwar railway station
    {Coordinate{86.2112, 23.0913}, CountryId{"IN"}}, // Barabhum railway station
    {Coordinate{81.8475, 26.7558}, CountryId{"IN"}}, // Baragaon railway station
    {Coordinate{92.3441, 24.6841}, CountryId{"IN"}}, // Baraigram Junction railway station
    {Coordinate{92.1395, 26.1204}, CountryId{"IN"}}, // Barahu railway station
    {Coordinate{86.8189, 23.7417}, CountryId{"IN"}}, // Barakar railway station
    {Coordinate{77.81, 28.4941}, CountryId{"IN"}}, // Baral railway station
    {Coordinate{76.5051, 25.0968}, CountryId{"IN"}}, // Baran railway station
    {Coordinate{88.3789, 22.6535}, CountryId{"IN"}}, // Baranagar Road railway station
    {Coordinate{77.0355, 30.2133}, CountryId{"IN"}}, // Barara railway station
    {Coordinate{77.9208, 22.197}, CountryId{"IN"}}, // Barbatpur railway station
    {Coordinate{78.3116, 21.9515}, CountryId{"IN"}}, // Barchi Road railway station
    {Coordinate{73.105, 21.1339}, CountryId{"IN"}}, // Bardoli railway station
    {Coordinate{72.6779, 22.8954}, CountryId{"IN"}}, // Barejadi Nandej railway station
    {Coordinate{75.6924, 29.8593}, CountryId{"IN"}}, // Bareta railway station
    {Coordinate{77.9997, 23.9149}, CountryId{"IN"}}, // Bareth railway station
    {Coordinate{83.6426, 21.3329}, CountryId{"IN"}}, // Bargarh Road Railway Station
    {Coordinate{82.456, 24.197}, CountryId{"IN"}}, // Bargawan railway station
    {Coordinate{82.7915, 27.4957}, CountryId{"IN"}}, // Barhni railway station
    {Coordinate{74.9162, 32.639}, CountryId{"IN"}}, // Bad Brahman Railway Station
    {Coordinate{74.7597, 13.4775}, CountryId{"IN"}}, // Barkur railway station
    {Coordinate{86.574, 25.281}, CountryId{"IN"}}, // Bariarpur railway station
    {Coordinate{75.9621, 22.8942}, CountryId{"IN"}}, // Barlai railway station
    {Coordinate{75.5492, 30.3704}, CountryId{"IN"}}, // Barnala railway station
    {Coordinate{83.5949, 21.1836}, CountryId{"IN"}}, // Barpali railway station
    {Coordinate{90.964, 26.5028}, CountryId{"IN"}}, // Barpeta Road railway station
    {Coordinate{82.4739, 25.5641}, CountryId{"IN"}}, // Barsathi railway station
    {Coordinate{77.0609, 20.5761}, CountryId{"IN"}}, // Barsi Takli railway station
    {Coordinate{76.2317, 29.3944}, CountryId{"IN"}}, // Barsola railway station
    {Coordinate{85.1198, 21.8474}, CountryId{"IN"}}, // Barsuan railway station
    {Coordinate{84.5542, 18.9007}, CountryId{"IN"}}, // Baruva railway station
    {Coordinate{78.7316, 25.3518}, CountryId{"IN"}}, // Barwa Sagar railway station
    {Coordinate{82.2266, 25.5669}, CountryId{"IN"}}, // Barya Ram railway station
    {Coordinate{78.3943, 25.1429}, CountryId{"IN"}}, // Basai railway station
    {Coordinate{89.9004, 26.1844}, CountryId{"IN"}}, // Basbari railway station
    {Coordinate{77.9385, 18.8651}, CountryId{"IN"}}, // Basar railway station
    {Coordinate{79.2852, 28.288}, CountryId{"IN"}}, // Basharatganj railway station
    {Coordinate{78.2133, 29.4972}, CountryId{"IN"}}, // Basi Kiratpur railway station
    {Coordinate{77.1518, 19.3335}, CountryId{"IN"}}, // Basmat railway station
    {Coordinate{76.4097, 30.6885}, CountryId{"IN"}}, // Bassi Pathanam railway station
    {Coordinate{87.0638, 21.7029}, CountryId{"IN"}}, // Basta railway station
    {Coordinate{82.7701, 26.8157}, CountryId{"IN"}}, // Basti railway station
    {Coordinate{90.4202, 26.4602}, CountryId{"IN"}}, // Basugaon railway station
    {Coordinate{76.5756, 27.1497}, CountryId{"IN"}}, // Baswa railway station
    {Coordinate{92.5381, 26.4669}, CountryId{"IN"}}, // Batadrowa Road railway station
    {Coordinate{72.3651, 22.8334}, CountryId{"IN"}}, // Bavla railway station
    {Coordinate{76.5724, 28.0703}, CountryId{"IN"}}, // Bawal railway station
    {Coordinate{88.1635, 22.5036}, CountryId{"IN"}}, // Bauria railway station
    {Coordinate{77.2971, 26.9164}, CountryId{"IN"}}, // Bayana Jn railway station
    {Coordinate{76.0327, 28.9395}, CountryId{"IN"}}, // Bawani Khera railway station
    {Coordinate{71.7687, 25.8975}, CountryId{"IN"}}, // Baytu railway station
    {Coordinate{76.9658, 29.6134}, CountryId{"IN"}}, // Bazida Jatan railway station
    {Coordinate{92.3969, 24.6106}, CountryId{"IN"}}, // Bazurghat railway station
    {Coordinate{74.315, 26.1089}, CountryId{"IN"}}, // Beawar railway station
    {Coordinate{86.0126, 23.3837}, CountryId{"IN"}}, // Begun Kudar railway station
    {Coordinate{80.0549, 27.5304}, CountryId{"IN"}}, // Behtagokul railway station
    {Coordinate{88.4288, 23.182}, CountryId{"IN"}}, // Behula railway station
    {Coordinate{79.4863, 19.0537}, CountryId{"IN"}}, // Bellampally railway station
    {Coordinate{73.915, 24.9832}, CountryId{"IN"}}, // Bejnal railway station
    {Coordinate{79.5545, 25.2768}, CountryId{"IN"}}, // Bela Tal railway station
    {Coordinate{74.6627, 19.6195}, CountryId{"IN"}}, // Belapur (BAP) railway station
    {Coordinate{82.0772, 21.962}, CountryId{"IN"}}, // Belha railway station
    {Coordinate{88.3892, 22.6614}, CountryId{"IN"}}, // Belgharia railway station
    {Coordinate{82.0324, 22.4311}, CountryId{"IN"}}, // Belgahna railway station
    {Coordinate{76.922, 15.1451}, CountryId{"IN"}}, // Ballari Junction railway station
    {Coordinate{76.8851, 15.157}, CountryId{"IN"}}, // Ballari Cantonment railway station
    {Coordinate{83.8491, 21.8272}, CountryId{"IN"}}, // Belpahar railway station
    {Coordinate{92.5145, 26.8005}, CountryId{"IN"}}, // Belsiri railway station
    {Coordinate{80.9153, 28.3794}, CountryId{"IN"}}, // Belrayan railway station
    {Coordinate{74.622, 18.7107}, CountryId{"IN"}}, // Belvandi railway station
    {Coordinate{76.3342, 23.2825}, CountryId{"IN"}}, // Berchha railway station
    {Coordinate{88.2636, 24.0891}, CountryId{"IN"}}, // Berhampore Court railway station
    {Coordinate{81.3797, 24.0003}, CountryId{"IN"}}, // Beohari railway station
    {Coordinate{74.8862, 21.1492}, CountryId{"IN"}}, // Betavad railway station
    {Coordinate{84.523, 26.8059}, CountryId{"IN"}}, // Bettiah Railway Station
    {Coordinate{74.5607, 26.9907}, CountryId{"IN"}}, // Besroli railway station
    {Coordinate{77.5353, 23.3752}, CountryId{"IN"}}, // Bhadbhadaghat railway station
    {Coordinate{78.7375, 26.9794}, CountryId{"IN"}}, // Bhadan railway station
    {Coordinate{83.7384, 25.4504}, CountryId{"IN"}}, // Bhadaura railway station
    {Coordinate{75.6729, 21.0237}, CountryId{"IN"}}, // Bhadli railway station
    {Coordinate{82.5584, 25.3953}, CountryId{"IN"}}, // Bhadohi railway station
    {Coordinate{78.1814, 26.306}, CountryId{"IN"}}, // Bhadroli railway station
    {Coordinate{86.4056, 23.7233}, CountryId{"IN"}}, // Bhaga Junction railway station
    {Coordinate{75.7028, 13.8424}, CountryId{"IN"}}, // Bhadravati railway station
    {Coordinate{85.3011, 25.8583}, CountryId{"IN"}}, // Bhagwanpur railway station
    {Coordinate{75.7209, 27.6772}, CountryId{"IN"}}, // Bhagega railway station
    {Coordinate{73.3633, 25.419}, CountryId{"IN"}}, // Bhagwanpura railway station
    {Coordinate{76.9554, 29.7515}, CountryId{"IN"}}, // Bhaini Khurd railway station
    {Coordinate{74.7761, 23.1449}, CountryId{"IN"}}, // Bhairongarh railway station
    {Coordinate{83.2943, 19.3281}, CountryId{"IN"}}, // Bhalumaska railway station
    {Coordinate{76.0364, 15.3869}, CountryId{"IN"}}, // Bhanapur railway station
    {Coordinate{77.2281, 18.047}, CountryId{"IN"}}, // Bhalki railway station
    {Coordinate{79.1125, 20.0843}, CountryId{"IN"}}, // Bhandak railway station
    {Coordinate{92.4799, 24.854}, CountryId{"IN"}}, // Bhanga railway station
    {Coordinate{80.7677, 25.2172}, CountryId{"IN"}}, // Bharat Kup railway station
    {Coordinate{82.1274, 26.6361}, CountryId{"IN"}}, // Bharatkund railway station
    {Coordinate{72.1278, 23.2708}, CountryId{"IN"}}, // Bhankoda railway station
    {Coordinate{79.0171, 21.2317}, CountryId{"IN"}}, // Bharatwada railway station
    {Coordinate{79.2164, 26.7502}, CountryId{"IN"}}, // Bharthana railway station
    {Coordinate{81.4919, 25.5592}, CountryId{"IN"}}, // Bharwari railway station
    {Coordinate{69.4936, 22.1641}, CountryId{"IN"}}, // Bhatel railway station
    {Coordinate{80.1674, 25.8254}, CountryId{"IN"}}, // Bharwa Sumerpur railway station
    {Coordinate{81.7127, 21.1716}, CountryId{"IN"}}, // Bhatgaon railway station
    {Coordinate{83.934, 26.3813}, CountryId{"IN"}}, // Bhatni Jn railway station
    {Coordinate{74.5657, 13.9894}, CountryId{"IN"}}, // Bhatkal railway station
    {Coordinate{75.7129, 27.1056}, CountryId{"IN"}}, // Bhaton Ki Gali railway station
    {Coordinate{84.0331, 26.3105}, CountryId{"IN"}}, // Bhatpar Rani railway station
    {Coordinate{75.3401, 29.3873}, CountryId{"IN"}}, // Bhattu railway station
    {Coordinate{74.3129, 17.1569}, CountryId{"IN"}}, // Bhavani Nagar railway station
    {Coordinate{82.1611, 27.4156}, CountryId{"IN"}}, // Bhawanipur Kalan railway station
    {Coordinate{70.2353, 21.8494}, CountryId{"IN"}}, // Bhayavadar railway station
    {Coordinate{72.3923, 25.1296}, CountryId{"IN"}}, // Bheempura railway station
    {Coordinate{71.3573, 21.4857}, CountryId{"IN"}}, // Bhemswadi railway station
    {Coordinate{79.7979, 23.1698}, CountryId{"IN"}}, // Bheraghat railway station
    {Coordinate{81.9892, 25.265}, CountryId{"IN"}}, // Bheerpur railway station
    {Coordinate{73.7181, 25.8244}, CountryId{"IN"}}, // Bhesana railway station
    {Coordinate{74.775, 18.3173}, CountryId{"IN"}}, // Bhigwan railway station
    {Coordinate{72.8874, 20.2753}, CountryId{"IN"}}, // Bhilad railway station
    {Coordinate{72.0082, 24.1943}, CountryId{"IN"}}, // Bhildi Junction railway station
    {Coordinate{71.8817, 25.8929}, CountryId{"IN"}}, // Bhimarlai railway station
    {Coordinate{72.8863, 24.5956}, CountryId{"IN"}}, // Bhimana railway station
    {Coordinate{70.175, 23.1865}, CountryId{"IN"}}, // Bhimasar railway station
    {Coordinate{73.9224, 24.7524}, CountryId{"IN"}}, // Bhimal railway station
    {Coordinate{71.925, 22.246}, CountryId{"IN"}}, // Bhimnath railway station
    {Coordinate{80.2181, 26.4198}, CountryId{"IN"}}, // Bhimsen railway station
    {Coordinate{78.7774, 26.5889}, CountryId{"IN"}}, // Bhind railway station
    {Coordinate{79.3065, 28.47}, CountryId{"IN"}}, // Bhitaura railway station
    {Coordinate{73.4925, 25.5597}, CountryId{"IN"}}, // Bhinwaliya railway station
    {Coordinate{75.6452, 31.5566}, CountryId{"IN"}}, // Bhogpur Sirwal railway station
    {Coordinate{79.4472, 28.494}, CountryId{"IN"}}, // Bhojipura Jn railway station
    {Coordinate{77.0082, 29.1852}, CountryId{"IN"}}, // Bhodwal Majri railway station
    {Coordinate{95.0324, 27.0636}, CountryId{"IN"}}, // Bhojo railway station
    {Coordinate{75.2225, 21.0189}, CountryId{"IN"}}, // Bhone railway station
    {Coordinate{74.6343, 25.7882}, CountryId{"IN"}}, // Bhojras railway station
    {Coordinate{79.1657, 27.259}, CountryId{"IN"}}, // Bhongaon railway station
    {Coordinate{74.2116, 24.8478}, CountryId{"IN"}}, // Bhupalsagar railway station
    {Coordinate{81.9703, 25.8752}, CountryId{"IN"}}, // Bhupia Mau railway station
    {Coordinate{70.9085, 23.5335}, CountryId{"IN"}}, // Bhutakia Bhimsa railway station
    {Coordinate{81.2721, 28.1831}, CountryId{"IN"}}, // Bichia railway station
    {Coordinate{77.9144, 27.1764}, CountryId{"IN"}}, // Bichpuri railway station
    {Coordinate{81.442, 25.585}, CountryId{"IN"}}, // Bidanpur railway station
    {Coordinate{77.3903, 12.8004}, CountryId{"IN"}}, // Bidadi railway station
    {Coordinate{92.6891, 24.9628}, CountryId{"IN"}}, // Bihara railway station
    {Coordinate{89.7675, 26.2719}, CountryId{"IN"}}, // Bidyadabri railway station
    {Coordinate{80.6935, 26.3551}, CountryId{"IN"}}, // Bighapur railway station
    {Coordinate{84.449, 25.5589}, CountryId{"IN"}}, // Bihiya railway station
    {Coordinate{74.6531, 25.931}, CountryId{"IN"}}, // Bijainagar railway station
    {Coordinate{90.7078, 26.498}, CountryId{"IN"}}, // Bijni railway station
    {Coordinate{78.5177, 25.3765}, CountryId{"IN"}}, // Bijauli railway station
    {Coordinate{81.111, 23.9787}, CountryId{"IN"}}, // Bijaysota railway station
    {Coordinate{76.3957, 25.1451}, CountryId{"IN"}}, // Bijora railway station
    {Coordinate{74.6421, 13.8222}, CountryId{"IN"}}, // Bijoor railway station
    {Coordinate{78.4216, 24.9469}, CountryId{"IN"}}, // Bijrotha railway station
    {Coordinate{82.1189, 23.2503}, CountryId{"IN"}}, // Bijuri railway station
    {Coordinate{79.5863, 23.0822}, CountryId{"IN"}}, // Bikrampur railway station
    {Coordinate{74.9185, 23.2255}, CountryId{"IN"}}, // Bildi railway station
    {Coordinate{82.269, 26.6813}, CountryId{"IN"}}, // Bilhar Ghat railway station
    {Coordinate{80.0604, 26.839}, CountryId{"IN"}}, // Bilhaur railway station
    {Coordinate{72.9699, 20.7664}, CountryId{"IN"}}, // Bilimora Junction railway station
    {Coordinate{70.6004, 21.4431}, CountryId{"IN"}}, // Bilkha railway station
    {Coordinate{79.6258, 28.0837}, CountryId{"IN"}}, // Bilpur railway station
    {Coordinate{83.0119, 24.4534}, CountryId{"IN"}}, // Billi railway station
    {Coordinate{80.1787, 26.4027}, CountryId{"IN"}}, // Binaur railway station
    {Coordinate{82.6652, 26.159}, CountryId{"IN"}}, // Bilwai railway station
    {Coordinate{80.5806, 26.1166}, CountryId{"IN"}}, // Bindki Road railway station
    {Coordinate{89.0524, 26.7471}, CountryId{"IN"}}, // Binnaguri railway station
    {Coordinate{73.8965, 29.1741}, CountryId{"IN"}}, // Biradhwal railway station
    {Coordinate{74.6359, 29.9126}, CountryId{"IN"}}, // Birang Khera railway station
    {Coordinate{77.3249, 26.9228}, CountryId{"IN"}}, // Birambad railway station
    {Coordinate{82.9173, 25.3989}, CountryId{"IN"}}, // Birapatti railway station
    {Coordinate{82.4498, 25.1738}, CountryId{"IN"}}, // Birohe railway station
    {Coordinate{84.737, 22.3971}, CountryId{"IN"}}, // Biramitrapur railway station
    {Coordinate{73.1925, 25.1705}, CountryId{"IN"}}, // Biroliya railway station
    {Coordinate{81.0434, 23.3672}, CountryId{"IN"}}, // Birsinghpur railway station
    {Coordinate{75.9747, 13.5911}, CountryId{"IN"}}, // Birur Junction railway station
    {Coordinate{74.7831, 24.5}, CountryId{"IN"}}, // Bisalwas Kalan railway station
    {Coordinate{72.5752, 25.4489}, CountryId{"IN"}}, // Bishengarh railway station
    {Coordinate{75.0612, 28.2401}, CountryId{"IN"}}, // Bissau railway station
    {Coordinate{81.9354, 25.8019}, CountryId{"IN"}}, // Bishnathganj railway station
    {Coordinate{80.9905, 27.4895}, CountryId{"IN"}}, // Biswan railway station
    {Coordinate{82.9829, 23.1792}, CountryId{"IN"}}, // Bishrampur railway station
    {Coordinate{76.3392, 20.8852}, CountryId{"IN"}}, // Biswa Bridge railway station
    {Coordinate{75.4987, 26.9058}, CountryId{"IN"}}, // Bobas railway station
    {Coordinate{76.9081, 23.937}, CountryId{"IN"}}, // Biyavra Rajgarh railway station
    {Coordinate{73.7166, 22.2702}, CountryId{"IN"}}, // Bodeli railway station
    {Coordinate{77.8882, 18.6459}, CountryId{"IN"}}, // Bodhan railway station
    {Coordinate{84.7482, 20.92}, CountryId{"IN"}}, // Boinda railway station
    {Coordinate{93.7795, 26.0184}, CountryId{"IN"}}, // Bokajan railway station
    {Coordinate{91.2197, 25.9998}, CountryId{"IN"}}, // Boko railway station
    {Coordinate{77.2736, 19.552}, CountryId{"IN"}}, // Bolda railway station
    {Coordinate{76.4864, 23.3614}, CountryId{"IN"}}, // Bolai railway station
    {Coordinate{87.6981, 23.6578}, CountryId{"IN"}}, // Bolpur Shantiniketan railway station
    {Coordinate{78.2463, 11.9847}, CountryId{"IN"}}, // Bommidi railway station
    {Coordinate{78.3482, 21.997}, CountryId{"IN"}}, // Bordhai railway station
    {Coordinate{74.6694, 27.0283}, CountryId{"IN"}}, // Borawar railway station
    {Coordinate{90.5606, 26.4786}, CountryId{"IN"}}, // Bongaigaon railway station
    {Coordinate{74.3471, 22.8665}, CountryId{"IN"}}, // Bordi railway station
    {Coordinate{77.1796, 20.7291}, CountryId{"IN"}}, // Borgaon railway station
    {Coordinate{74.8417, 20.7843}, CountryId{"IN"}}, // Borvihir railway station
    {Coordinate{75.0928, 23.5557}, CountryId{"IN"}}, // Brayla Chaurasi railway station
    {Coordinate{80.2727, 26.6035}, CountryId{"IN"}}, // Brahmavart railway station
    {Coordinate{89.7516, 26.3073}, CountryId{"IN"}}, // Boxirhat railway station
    {Coordinate{83.9237, 21.8227}, CountryId{"IN"}}, // Brajrajnagar railway station
    {Coordinate{79.136, 28.0275}, CountryId{"IN"}}, // Budaun railway station
    {Coordinate{78.9814, 10.7828}, CountryId{"IN"}}, // Budalur railway station
    {Coordinate{75.4329, 32.4404}, CountryId{"IN"}}, // Budhi railway station
    {Coordinate{75.5497, 29.9217}, CountryId{"IN"}}, // Budhlada railway station
    {Coordinate{77.8482, 28.3919}, CountryId{"IN"}}, // Bulandshahr railway station
    {Coordinate{78.3933, 29.5226}, CountryId{"IN"}}, // Bundki railway station
    {Coordinate{81.5284, 23.2132}, CountryId{"IN"}}, // Burhar railway station
    {Coordinate{81.3902, 27.0871}, CountryId{"IN"}}, // Burhwal railway station
    {Coordinate{75.1833, 31.5564}, CountryId{"IN"}}, // Butari railway station
    {Coordinate{83.9822, 25.5621}, CountryId{"IN"}}, // Buxar railway station
    {Coordinate{74.8968, 31.0804}, CountryId{"IN"}}, // Butewala railway station
    {Coordinate{76.7521, 12.502}, CountryId{"IN"}}, // Byadarahalli railway station
    {Coordinate{80.8001, 27.4496}, CountryId{"IN"}}, // Barai Jalalpur railway station
    {Coordinate{88.4274, 22.6642}, CountryId{"IN"}}, // Birati railway station
    {Coordinate{82.1788, 23.2678}, CountryId{"IN"}}, // Boridand railway station
    {Coordinate{88.3466, 22.5768}, CountryId{"IN"}}, // B.B.D Bag railway station
    {Coordinate{88.1939, 22.4927}, CountryId{"IN"}}, // Budge Budge railway station
    {Coordinate{88.5722, 22.7898}, CountryId{"IN"}}, // Bira railway station
    {Coordinate{88.8039, 23.0002}, CountryId{"IN"}}, // Bibhuti Bhushan Halt railway station
    {Coordinate{88.3512, 22.5902}, CountryId{"IN"}}, // Burra Bazar railway station
    {Coordinate{88.3514, 22.6311}, CountryId{"IN"}}, // Belur Math railway station
    {Coordinate{88.3651, 22.6049}, CountryId{"IN"}}, // Bagbazar railway station
    {Coordinate{88.4349, 22.6767}, CountryId{"IN"}}, // Bisharpara Kodaliya railway station
    {Coordinate{77.1292, 16.7421}, CountryId{"IN"}}, // Yadgir railway station
    {Coordinate{86.3231, 25.216}, CountryId{"IN"}}, // Abhaipur railway station
    {Coordinate{80.5454, 26.4446}, CountryId{"IN"}}, // Achalganj railway station
    {Coordinate{74.1957, 30.1394}, CountryId{"IN"}}, // Abohar railway station
    {Coordinate{76.9559, 21.1239}, CountryId{"IN"}}, // Adgaon Buzurg railway station
    {Coordinate{92.6827, 26.8216}, CountryId{"IN"}}, // Rangapara North Junction railway station
    {Coordinate{50.1813, 56.1108}, CountryId{"RU"}}, // Q25556791
    {Coordinate{51.0333, 56.2294}, CountryId{"RU"}}, // Q25556800
    {Coordinate{-1.45706, 43.5687}, CountryId{"FR"}}, // Ondres
    {Coordinate{-1.68596, 48.3506}, CountryId{"FR"}}, // Dingé
    {Coordinate{2.22306, 48.8956}, CountryId{"FR"}}, // Nanterre-Préfecture
    {Coordinate{5.57834, 50.509}, CountryId{"BE"}}, // Poulseur railway station
    {Coordinate{79.7236, 16.5906}, CountryId{"IN"}}, // Nadikude railway station
    {Coordinate{78.047, 15.8957}, CountryId{"IN"}}, // Alampur Road railway station
    {Coordinate{1.61389, 50.7644}, CountryId{"FR"}}, // Gare de Wimille-Wimereux
    {Coordinate{73.9247, 15.4902}, CountryId{"IN"}}, // Karmali railway station
    {Coordinate{73.9393, 15.2919}, CountryId{"IN"}}, // Suravali railway station
    {Coordinate{74.2597, 14.7408}, CountryId{"IN"}}, // Harwada railway station
    {Coordinate{74.3672, 14.5828}, CountryId{"IN"}}, // Gokarna Road railway station
    {Coordinate{74.3329, 14.6453}, CountryId{"IN"}}, // Ankola railway station
    {Coordinate{74.4332, 14.3169}, CountryId{"IN"}}, // Honnavar railway station
    {Coordinate{74.4207, 14.4369}, CountryId{"IN"}}, // Kumta railway station
    {Coordinate{74.5052, 14.1003}, CountryId{"IN"}}, // Murudeshwar railway station
    {Coordinate{74.5366, 14.0361}, CountryId{"IN"}}, // Chitrapur railway station
    {Coordinate{74.6328, 13.8726}, CountryId{"IN"}}, // Mookambika Road Byndoor railway station
    {Coordinate{74.594, 13.9309}, CountryId{"IN"}}, // Shiroor railway station
    {Coordinate{74.684, 13.7177}, CountryId{"IN"}}, // Senapura railway station
    {Coordinate{74.7284, 13.6129}, CountryId{"IN"}}, // Kundapura railway station
    {Coordinate{74.7612, 13.2556}, CountryId{"IN"}}, // Innanje railway station
    {Coordinate{74.7682, 13.197}, CountryId{"IN"}}, // Padubidri railway station
    {Coordinate{74.8065, 13.1331}, CountryId{"IN"}}, // Nandikoor railway station
    {Coordinate{74.805, 13.0685}, CountryId{"IN"}}, // Mulki railway station
    {Coordinate{74.8062, 12.9892}, CountryId{"IN"}}, // Surathkal railway station
    {Coordinate{73.9125, 15.3536}, CountryId{"IN"}}, // Verna railway station
    {Coordinate{74.1477, 14.8763}, CountryId{"IN"}}, // Asnoti railway station
    {Coordinate{74.4932, 14.1744}, CountryId{"IN"}}, // Manki railway station
    {Coordinate{5.50372, 43.6848}, CountryId{"FR"}}, // Q2557517
    {Coordinate{80.7957, 16.5558}, CountryId{"IN"}}, // Gannavaram railway station
    {Coordinate{81.1438, 16.2521}, CountryId{"IN"}}, // Pedana railway station
    {Coordinate{80.5629, 16.5775}, CountryId{"IN"}}, // Rayanapadu railway station
    {Coordinate{80.6275, 16.2952}, CountryId{"IN"}}, // Kolakaluru railway station
    {Coordinate{80.6236, 16.3276}, CountryId{"IN"}}, // Duggirala railway station
    {Coordinate{80.6169, 16.3796}, CountryId{"IN"}}, // Chiluvur railway station
    {Coordinate{81.6999, 16.4459}, CountryId{"IN"}}, // Narasapur railway station
    {Coordinate{81.6755, 16.8983}, CountryId{"IN"}}, // Nidadavolu railway station
    {Coordinate{80.6046, 16.4772}, CountryId{"IN"}}, // Krishna Canal railway station
    {Coordinate{2.33932, 50.3789}, CountryId{"FR"}}, // Q2557790
    {Coordinate{0.253347, 47.1641}, CountryId{"FR"}}, // Q2558544
    {Coordinate{0.485061, 49.5916}, CountryId{"FR"}}, // Gare de Bolbec - Nointot
    {Coordinate{75.676, 17.8052}, CountryId{"IN"}}, // Mohol railway station
    {Coordinate{2.34417, 49.2942}, CountryId{"FR"}}, // Gare de Balagny-Saint-Épin
    {Coordinate{6.79278, 51.2203}, CountryId{"DE"}}, // Düsseldorf Central Station
    {Coordinate{3.96654, 50.2726}, CountryId{"FR"}}, // Gare de Maubeuge
    {Coordinate{2.3125, 48.7478}, CountryId{"FR"}}, // Chemin d'Antony
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q25603901
    {Coordinate{6.76962, 47.5733}, CountryId{"FR"}}, // Q2560558
    {Coordinate{5.86722, 50.4892}, CountryId{"BE"}}, // Spa-Géronstère railway station
    {Coordinate{2.3141, 45.557}, CountryId{"FR"}}, // Gare d'Ussel
    {Coordinate{7.33177, 43.7068}, CountryId{"FR"}}, // Beaulieu-sur-Mer railway station
    {Coordinate{2.43333, 48.8472}, CountryId{"FR"}}, // Vincennes
    {Coordinate{3.69189, 49.7026}, CountryId{"FR"}}, // Q2562340
    {Coordinate{-0.736223, 43.9783}, CountryId{"FR"}}, // Ygos
    {Coordinate{4.83056, 44.7797}, CountryId{"FR"}}, // Q2563655
    {Coordinate{4.8134, 45.6456}, CountryId{"FR"}}, // Q2563981
    {Coordinate{-1.17786, 47.3695}, CountryId{"FR"}}, // Q2564893
    {Coordinate{3.36979, 49.6578}, CountryId{"FR"}}, // Q2565580
    {Coordinate{7.82341, 48.7819}, CountryId{"FR"}}, // Marienthal
    {Coordinate{4.95417, 52.5033}, CountryId{"NL"}}, // Purmerend railway station
    {Coordinate{4.29028, 50.4928}, CountryId{"BE"}}, // Godarville railway station
    {Coordinate{5.18389, 52.6906}, CountryId{"NL"}}, // Hoogkarspel railway station
    {Coordinate{5.67284, 50.4727}, CountryId{"BE"}}, // Aywaille railway station
    {Coordinate{7.21472, 46.0792}, CountryId{"CH"}}, // Q2569112
    {Coordinate{5.4671, 43.2881}, CountryId{"FR"}}, // Q2569951
    {Coordinate{5.93444, 53.2189}, CountryId{"NL"}}, // Hurdegaryp railway station
    {Coordinate{5.63111, 51.4681}, CountryId{"NL"}}, // Helmond 't Hout railway station
    {Coordinate{3.33922, 46.5613}, CountryId{"FR"}}, // Moulins-sur-Allier railway station
    {Coordinate{79.8399, 10.8764}, CountryId{"IN"}}, // Tirumalairayanpattinam railway station
    {Coordinate{1.47566, 45.258}, CountryId{"FR"}}, // Gare d'Allassac
    {Coordinate{-0.612264, 43.1948}, CountryId{"FR"}}, // Gare d'Oloron-Sainte-Marie
    {Coordinate{6.15172, 47.6175}, CountryId{"FR"}}, // Gare de Vesoul
    {Coordinate{2.28056, 49.1325}, CountryId{"FR"}}, // Gare de Nointel - Mours
    {Coordinate{1.74022, 47.367}, CountryId{"FR"}}, // Gare du Faubourg-d'Orléans
    {Coordinate{80.2749, 13.0848}, CountryId{"IN"}}, // Chennai Central railway station
    {Coordinate{5.19761, 43.3344}, CountryId{"FR"}}, // La Redonne-Ensuès train station
    {Coordinate{12.7792, 49.8206}, CountryId{"CZ"}}, // Q2574039
    {Coordinate{7.0577, 50.8952}, CountryId{"DE"}}, // Köln-Steinstraße station
    {Coordinate{9.15582, 58.9711}, CountryId{"NO"}}, // Neslandsvatn Station
    {Coordinate{14.5019, 50.1114}, CountryId{"CZ"}}, // Vysočanská
    {Coordinate{4.72107, 45.9846}, CountryId{"FR"}}, // Gare de Villefranche-sur-Saône
    {Coordinate{2.53333, 48.6806}, CountryId{"FR"}}, // Boussy-Saint-Antoine
    {Coordinate{-0.963719, 45.9474}, CountryId{"FR"}}, // Gare de Rochefort
    {Coordinate{2.1626, 47.1758}, CountryId{"FR"}}, // Q2577332
    {Coordinate{3.51304, 47.9611}, CountryId{"FR"}}, // Q2577756
    {Coordinate{4.36167, 51.91}, CountryId{"NL"}}, // Vlaardingen Oost
    {Coordinate{3.06139, 45.7675}, CountryId{"FR"}}, // Gare de Royat - Chamalières
    {Coordinate{6.58146, 47.4473}, CountryId{"FR"}}, // Q2578262
    {Coordinate{7.34275, 53.1634}, CountryId{"DE"}}, // Weener railway station
    {Coordinate{3.43064, 46.1264}, CountryId{"FR"}}, // Gare de Vichy
    {Coordinate{-3.9989, 48.4851}, CountryId{"FR"}}, // Q2579335
    {Coordinate{6.71, 45.0767}, CountryId{"IT"}}, // Bardonecchia railway station
    {Coordinate{4.18528, 51.1853}, CountryId{"BE"}}, // Nieuwkerken-Waas railway station
    {Coordinate{-0.885655, 48.0968}, CountryId{"FR"}}, // Q2580610
    {Coordinate{-3.16685, 48.5609}, CountryId{"FR"}}, // Halte de Gourland
    {Coordinate{2.49, 49.138}, CountryId{"FR"}}, // Gare d'Orry-la-Ville-Coye
    {Coordinate{10.1002, 51.6859}, CountryId{"DE"}}, // Katlenburg station
    {Coordinate{10.1755, 51.6594}, CountryId{"DE"}}, // Wulften station
    {Coordinate{10.2366, 51.6461}, CountryId{"DE"}}, // Hattorf station
    {Coordinate{1.10946, 49.3771}, CountryId{"FR"}}, // Saint-Étienne-du-Rouvray
    {Coordinate{5.66222, 51.4758}, CountryId{"NL"}}, // Helmond railway station
    {Coordinate{25.7536, 62.2408}, CountryId{"FI"}}, // Jyväskylä railway station
    {Coordinate{2.095, 48.8981}, CountryId{"FR"}}, // Saint-Germain-en-Laye station
    {Coordinate{4.1875, 45.8179}, CountryId{"FR"}}, // Q2583133
    {Coordinate{18.9418, 47.1756}, CountryId{"HU"}}, // Ráckeve HÉV station
    {Coordinate{19.0936, 47.4382}, CountryId{"HU"}}, // Pesterzsébet felső HÉV station
    {Coordinate{19.0042, 47.3337}, CountryId{"HU"}}, // Q25834903
    {Coordinate{18.9742, 47.3133}, CountryId{"HU"}}, // Q25835296
    {Coordinate{18.9562, 47.27}, CountryId{"HU"}}, // Q25835884
    {Coordinate{18.9461, 47.2281}, CountryId{"HU"}}, // Q25835890
    {Coordinate{1.60277, 48.7959}, CountryId{"FR"}}, // Q2583814
    {Coordinate{19.2249, 47.5451}, CountryId{"HU"}}, // Csömör HÉV station
    {Coordinate{19.1678, 47.507}, CountryId{"HU"}}, // Nagyicce HÉV station
    {Coordinate{19.2712, 47.5533}, CountryId{"HU"}}, // Kerepes HÉV station
    {Coordinate{19.3566, 47.5986}, CountryId{"HU"}}, // Gödöllő, Palotakert HÉV station
    {Coordinate{19.1256, 50.2786}, CountryId{"PL"}}, // Sosnowiec Main Station
    {Coordinate{35.3844, 45.0303}, CountryId{"UA"}}, // Feodosia
    {Coordinate{10.574, 51.5825}, CountryId{"DE"}}, // Bad Sachsa station
    {Coordinate{10.6089, 51.5848}, CountryId{"DE"}}, // Walkenried station
    {Coordinate{-1.9851, 52.584}, CountryId{"GB"}}, // Walsall railway station
    {Coordinate{6.59881, 48.0164}, CountryId{"FR"}}, // Gare de Remiremont
    {Coordinate{-1.3969, 43.3655}, CountryId{"FR"}}, // Kanbo/Cambo-les-Bains station
    {Coordinate{6.04321, 49.2468}, CountryId{"FR"}}, // Gare de Moyeuvre-grande
    {Coordinate{2.56954, 48.6284}, CountryId{"FR"}}, // Lieusaint - Moissy
    {Coordinate{1.4065, 45.9529}, CountryId{"FR"}}, // Gare d'Ambazac
    {Coordinate{4.0875, 50.2961}, CountryId{"FR"}}, // Jeumont railway station
    {Coordinate{3.2574, 51.1543}, CountryId{"BE"}}, // Oostkamp railway station
    {Coordinate{6.58306, 52.2303}, CountryId{"NL"}}, // Goor railway station
    {Coordinate{1.03506, 48.9885}, CountryId{"FR"}}, // Gare de La Bonneville-sur-Iton
    {Coordinate{-2.00314, 48.496}, CountryId{"FR"}}, // Q2591014
    {Coordinate{3.00566, 43.1906}, CountryId{"FR"}}, // Gare de Narbonne
    {Coordinate{10.3328, 51.6541}, CountryId{"DE"}}, // Herzberg Schloß station
    {Coordinate{2.63162, 44.9759}, CountryId{"FR"}}, // Gare de Vic-sur-Cère
    {Coordinate{2.92629, 50.5665}, CountryId{"FR"}}, // La Fontaine
    {Coordinate{10.2731, 51.717}, CountryId{"DE"}}, // Osterode am Harz Leege station
    {Coordinate{10.2455, 51.7261}, CountryId{"DE"}}, // Osterode am Harz Mitte station
    {Coordinate{10.2031, 51.7872}, CountryId{"DE"}}, // Gittede/Bad Grund (Harz)
    {Coordinate{7.4182, 47.7378}, CountryId{"FR"}}, // Q2592955
    {Coordinate{10.0202, 51.8674}, CountryId{"DE"}}, // Bad Gandersheim station
    {Coordinate{130.847, 52.4561}, CountryId{"RU"}}, // Q25930308
    {Coordinate{5.54861, 52.0197}, CountryId{"NL"}}, // Veenendaal Centrum railway station
    {Coordinate{21.1578, 52.2569}, CountryId{"PL"}}, // Warszawa Rembertów railway station
    {Coordinate{1.52352, 48.4826}, CountryId{"FR"}}, // Gare de La Villette-Saint-Prest
    {Coordinate{4.64667, 52.0769}, CountryId{"NL"}}, // Boskoop railway station
    {Coordinate{2.24639, 48.7175}, CountryId{"FR"}}, // Gare de Palaiseau
    {Coordinate{5.51948, 50.3769}, CountryId{"BE"}}, // Bomal railway station
    {Coordinate{4.33861, 51.1364}, CountryId{"BE"}}, // Hemiksem railway station
    {Coordinate{6.25833, 51.9592}, CountryId{"NL"}}, // Doetinchem De Huet railway station
    {Coordinate{6.34314, 43.3903}, CountryId{"FR"}}, // Gare du Luc-et-Le Cannet
    {Coordinate{7.30474, 47.6989}, CountryId{"FR"}}, // Flaxlanden
    {Coordinate{3.16811, 50.7166}, CountryId{"FR"}}, // Tourcoing
    {Coordinate{3.891, 49.2782}, CountryId{"FR"}}, // Gare de Muizon
    {Coordinate{0.250308, 46.3493}, CountryId{"FR"}}, // Q2598406
    {Coordinate{4.28818, 50.3425}, CountryId{"BE"}}, // Thuin railway station
    {Coordinate{-4.08383, 52.926}, CountryId{"GB"}}, // Minffordd railway station
    {Coordinate{3.19652, 45.2537}, CountryId{"FR"}}, // Q2599851
    {Coordinate{5.63028, 51.3039}, CountryId{"NL"}}, // Maarheeze railway station
    {Coordinate{7.13175, 49.0006}, CountryId{"FR"}}, // Oermingen
    {Coordinate{23.8521, 56.9814}, CountryId{"LV"}}, // Bulduri Station
    {Coordinate{10.2037, 56.1499}, CountryId{"DK"}}, // Aarhus Central Station
    {Coordinate{6.25167, 51.5811}, CountryId{"DE"}}, // Kevelaer station
    {Coordinate{4.675, 50.9036}, CountryId{"BE"}}, // Herent railway station
    {Coordinate{-3.46033, 48.7273}, CountryId{"FR"}}, // Gare de Lannion
    {Coordinate{2.47667, 49.0322}, CountryId{"FR"}}, // Noues
    {Coordinate{2.5825, 48.8742}, CountryId{"FR"}}, // Gare de Chelles-Gournay
    {Coordinate{-1.76522, 48.4763}, CountryId{"FR"}}, // Bonnemain
    {Coordinate{2.0032, 49.0807}, CountryId{"FR"}}, // Gare de Montgeroult - Courcelles
    {Coordinate{4.68639, 50.9311}, CountryId{"BE"}}, // Hambos railway station
    {Coordinate{5.57276, 50.5305}, CountryId{"BE"}}, // Esneux railway station
    {Coordinate{2.63146, 50.7134}, CountryId{"FR"}}, // Strazeele
    {Coordinate{10.4784, 51.9049}, CountryId{"DE"}}, // Oker station
    {Coordinate{2.37491, 43.4978}, CountryId{"FR"}}, // Q2606934
    {Coordinate{4.40666, 50.3338}, CountryId{"BE"}}, // Beignée railway station
    {Coordinate{2.57944, 48.8231}, CountryId{"FR"}}, // Gare des Yvris-Noisy-le-Grand
    {Coordinate{12.1265, 42.7239}, CountryId{"IT"}}, // Q2608652
    {Coordinate{7.31694, 43.76}, CountryId{"FR"}}, // Q2608753
    {Coordinate{-0.494972, 38.3444}, CountryId{"ES"}}, // Alicante railway station
    {Coordinate{9.07278, 45.8092}, CountryId{"IT"}}, // Como San Giovanni railway station
    {Coordinate{7.29433, 47.6944}, CountryId{"FR"}}, // Gare de Zillisheim
    {Coordinate{1.53944, 49.6314}, CountryId{"FR"}}, // Gare de Serqueux
    {Coordinate{0.596512, 42.7973}, CountryId{"FR"}}, // Gare de Luchon
    {Coordinate{1.14972, 49.0186}, CountryId{"FR"}}, // Gare d'Évreux-Normandie
    {Coordinate{2.69331, 42.689}, CountryId{"FR"}}, // Q2609571
    {Coordinate{-0.011587, 48.1274}, CountryId{"FR"}}, // Gare de Conlie
    {Coordinate{3.50416, 49.2086}, CountryId{"FR"}}, // Q2611283
    {Coordinate{13.96, 49.8858}, CountryId{"CZ"}}, // Q2611568
    {Coordinate{1.83361, 42.7244}, CountryId{"FR"}}, // Gare d'Ax-les-Thermes
    {Coordinate{1.32389, 43.4647}, CountryId{"FR"}}, // Gare de Muret
    {Coordinate{2.45194, 48.6344}, CountryId{"FR"}}, // gare d'Évry-Val-de-Seine
    {Coordinate{3.03463, 50.5482}, CountryId{"FR"}}, // Q2612480
    {Coordinate{1.64612, 47.2551}, CountryId{"FR"}}, // Q2612548
    {Coordinate{2.38308, 48.839}, CountryId{"FR"}}, // Paris-Bercy-Bourgogne-Pays-d'Auvergne railway station
    {Coordinate{2.85436, 48.8826}, CountryId{"FR"}}, // Q2613961
    {Coordinate{1.21167, 43.2978}, CountryId{"FR"}}, // Gare de Carbonne
    {Coordinate{3.98639, 51.1075}, CountryId{"BE"}}, // Lokeren railway station
    {Coordinate{5.975, 50.6592}, CountryId{"BE"}}, // Welkenraedt railway station
    {Coordinate{14.4375, 50.0986}, CountryId{"CZ"}}, // Vltavská
    {Coordinate{-1.84663, 47.3022}, CountryId{"FR"}}, // Cordemais
    {Coordinate{2.40111, 48.2933}, CountryId{"FR"}}, // Malesherbes
    {Coordinate{5.0512, 50.9931}, CountryId{"BE"}}, // Diest railway station
    {Coordinate{-0.897671, 45.9433}, CountryId{"FR"}}, // Tonnay-Charente train station
    {Coordinate{4.37948, 45.4648}, CountryId{"FR"}}, // Gare de Saint-Étienne-La Terrasse
    {Coordinate{6.39954, 48.2709}, CountryId{"FR"}}, // Q2616463
    {Coordinate{24.2575, 59.3205}, CountryId{"EE"}}, // Q2616477
    {Coordinate{1.48316, 45.0147}, CountryId{"FR"}}, // Gare de Gignac-Cressensac
    {Coordinate{4.58488, 50.4295}, CountryId{"BE"}}, // Aiseau railway station
    {Coordinate{6.05806, 50.8961}, CountryId{"NL"}}, // Eygelshoven Markt railway station
    {Coordinate{125.324, 43.91}, CountryId{"CN"}}, // Changchun railway station
    {Coordinate{1.60646, 41.1925}, CountryId{"ES"}}, // Segur de Calafell
    {Coordinate{14.4394, 50.0508}, CountryId{"CZ"}}, // Pankrác
    {Coordinate{7.14805, 48.3897}, CountryId{"FR"}}, // Q2618399
    {Coordinate{3.71959, 51.089}, CountryId{"BE"}}, // Wondelgem railway station
    {Coordinate{2.51222, 48.9628}, CountryId{"FR"}}, // Gare de Villepinte
    {Coordinate{5.63277, 43.1997}, CountryId{"FR"}}, // Gare de La Ciotat
    {Coordinate{5.51567, 43.2848}, CountryId{"FR"}}, // Q2619859
    {Coordinate{3.99333, 50.7353}, CountryId{"BE"}}, // Tollembeek railway station
    {Coordinate{5.09528, 50.4967}, CountryId{"BE"}}, // Andenne railway station
    {Coordinate{7.0916, 49.0914}, CountryId{"FR"}}, // Rémelfing
    {Coordinate{4.41722, 50.9078}, CountryId{"BE"}}, // Buda railway station
    {Coordinate{1.94364, 48.7556}, CountryId{"FR"}}, // Gare de La Verrière
    {Coordinate{2.02299, 50.883}, CountryId{"FR"}}, // Nortkerque
    {Coordinate{16.2238, 49.994}, CountryId{"CZ"}}, // Choceň railway station
    {Coordinate{14.0414, 49.9433}, CountryId{"CZ"}}, // Králův Dvůr
    {Coordinate{5.80639, 50.5681}, CountryId{"BE"}}, // Pepinster railway station
    {Coordinate{5.80444, 50.5636}, CountryId{"BE"}}, // Pepinster-Cité railway station
    {Coordinate{12.5031, 50.0272}, CountryId{"CZ"}}, // Q2622653
    {Coordinate{-1.71354, 48.0673}, CountryId{"FR"}}, // Saint-Jacques-de-la-Lande
    {Coordinate{-2.00399, 48.6466}, CountryId{"FR"}}, // Gare de Saint-Malo
    {Coordinate{3.1307, 48.3239}, CountryId{"FR"}}, // Gare de Champigny-sur-Yonne
    {Coordinate{0.93793, 48.9622}, CountryId{"FR"}}, // Q2623394
    {Coordinate{13.0751, 50.8544}, CountryId{"DE"}}, // Flöha railway station
    {Coordinate{2.75338, 45.0907}, CountryId{"FR"}}, // Gare du Lioran
    {Coordinate{17.3417, 50.4778}, CountryId{"PL"}}, // Main Train Station in Nysa
    {Coordinate{2.77176, 50.4342}, CountryId{"FR"}}, // Gare de Liévin
    {Coordinate{4.62133, 50.7243}, CountryId{"BE"}}, // Basse-Wavre railway station
    {Coordinate{15.7452, 48.6855}, CountryId{"AT"}}, // Sigmundsherberg station
    {Coordinate{14.3231, 49.9594}, CountryId{"CZ"}}, // Q2625617
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q26257043
    {Coordinate{}, CountryId{"FI"}}, // Porokylä railway station
    {Coordinate{}, CountryId{"FI"}}, // Niittylahti railway station
    {Coordinate{}, CountryId{"FI"}}, // Ilomantsi railway station
    {Coordinate{5.37683, 47.1928}, CountryId{"FR"}}, // Gare d'Auxonne
    {Coordinate{-1.02369, 46.1206}, CountryId{"FR"}}, // Q26257933
    {Coordinate{7.85917, 45.4903}, CountryId{"IT"}}, // Q26258088
    {Coordinate{7.8094, 45.5672}, CountryId{"IT"}}, // Q26258089
    {Coordinate{8.20655, 44.8644}, CountryId{"IT"}}, // San Marzanotto railway station
    {Coordinate{2.12917, 48.8}, CountryId{"FR"}}, // Versailles-Château
    {Coordinate{5.34972, 50.9544}, CountryId{"BE"}}, // Kiewit railway station
    {Coordinate{1.94906, 49.124}, CountryId{"FR"}}, // Q2627008
    {Coordinate{4.6987, 50.5581}, CountryId{"BE"}}, // Chapelle-Dieu railway station
    {Coordinate{4.34853, 50.8412}, CountryId{"BE"}}, // Brussels-Chapel railway station
    {Coordinate{1.23694, 43.6147}, CountryId{"FR"}}, // Q2628524
    {Coordinate{4.64868, 50.6088}, CountryId{"BE"}}, // Chastre railway station
    {Coordinate{6.28012, 46.7765}, CountryId{"FR"}}, // Q2629074
    {Coordinate{3.89611, 50.9014}, CountryId{"BE"}}, // Terhagen railway station
    {Coordinate{3.96936, 50.8118}, CountryId{"BE"}}, // Appelterre railway station
    {Coordinate{7.88249, 48.9346}, CountryId{"FR"}}, // Q2630630
    {Coordinate{-0.609242, 44.8866}, CountryId{"FR"}}, // gare de Bruges
    {Coordinate{13.3069, 52.6178}, CountryId{"DE"}}, // Berlin-Hermsdorf station
    {Coordinate{2.15333, 49.0194}, CountryId{"FR"}}, // Gare de Pierrelaye
    {Coordinate{-1.76606, 47.8979}, CountryId{"FR"}}, // Q2632104
    {Coordinate{3.27159, 49.1873}, CountryId{"FR"}}, // Q2632376
    {Coordinate{5.13139, 52.0872}, CountryId{"NL"}}, // Utrecht Maliebaan railway station
    {Coordinate{-2.33167, 48.5074}, CountryId{"FR"}}, // Gare de Landébia
    {Coordinate{2.49222, 48.5661}, CountryId{"FR"}}, // Gare du Coudray-Montceaux
    {Coordinate{4.20111, 51.0164}, CountryId{"BE"}}, // Buggenhout railway station
    {Coordinate{4.09528, 50.8825}, CountryId{"BE"}}, // Liedekerke railway station
    {Coordinate{7.86944, 50.7894}, CountryId{"DE"}}, // Betzdorf (Sieg) station
    {Coordinate{7.0019, 50.9901}, CountryId{"DE"}}, // Köln-Stammheim station
    {Coordinate{7.59406, 44.0899}, CountryId{"FR"}}, // Tende railway station
    {Coordinate{-2.97384, 48.5332}, CountryId{"FR"}}, // Q2637353
    {Coordinate{30.1525, 59.9945}, CountryId{"RU"}}, // Lakhta railway station
    {Coordinate{28.7513, 60.7154}, CountryId{"RU"}}, // Vyborg railway station
    {Coordinate{85.6727, 25.9064}, CountryId{"IN"}}, // Khudiram Bose Pusa station
    {Coordinate{14.4176, 50.0882}, CountryId{"CZ"}}, // Staroměstská
    {Coordinate{6.59306, 53.3069}, CountryId{"NL"}}, // Bedum railway station
    {Coordinate{24.8533, 60.2706}, CountryId{"FI"}}, // Louhela railway station
    {Coordinate{1.93231, 47.721}, CountryId{"FR"}}, // Q2641304
    {Coordinate{13.4085, 52.3602}, CountryId{"DE"}}, // Mahlow station
    {Coordinate{8.63251, 44.6305}, CountryId{"IT"}}, // Ovada railway station
    {Coordinate{11.5803, 49.95}, CountryId{"DE"}}, // Bayreuth Central Station
    {Coordinate{-1.76028, 47.9353}, CountryId{"FR"}}, // Gare de Guichen - Bourg-des-Comptes
    {Coordinate{14.4095, 50.0912}, CountryId{"CZ"}}, // Malostranská
    {Coordinate{4.99056, 52.17}, CountryId{"NL"}}, // Breukelen railway station
    {Coordinate{4.63167, 52.4194}, CountryId{"NL"}}, // Santpoort Zuid railway station
    {Coordinate{-4.09417, 48.2016}, CountryId{"FR"}}, // Q2644205
    {Coordinate{6.31483, 47.1511}, CountryId{"FR"}}, // Q2645004
    {Coordinate{6.96338, 51.0642}, CountryId{"DE"}}, // Leverkusen-Rheindorf station
    {Coordinate{-0.276111, 47.3972}, CountryId{"FR"}}, // Gare de La Ménitré
    {Coordinate{2.75329, 49.3595}, CountryId{"FR"}}, // Gare du Meux - La Croix-Saint-Ouen
    {Coordinate{6.85256, 51.4491}, CountryId{"DE"}}, // Mülheim-Styrum station
    {Coordinate{4.11666, 50.8825}, CountryId{"BE"}}, // Essene-Lombeek railway station
    {Coordinate{-3.38234, 48.4274}, CountryId{"FR"}}, // Q2649057
    {Coordinate{18.853, 46.6067}, CountryId{"HU"}}, // Paks railway station
    {Coordinate{-0.537784, 44.752}, CountryId{"FR"}}, // Gare de Cadaujac
    {Coordinate{3.72873, 48.5142}, CountryId{"FR"}}, // Gare de Romilly-sur-Seine
    {Coordinate{4.58417, 51.9533}, CountryId{"NL"}}, // Capelle Schollevaar railway station
    {Coordinate{2.24056, 49.1636}, CountryId{"FR"}}, // Gare de Chambly
    {Coordinate{2.95433, 49.5343}, CountryId{"FR"}}, // Q2650500
    {Coordinate{-3.31144, 48.4702}, CountryId{"FR"}}, // Q2650643
    {Coordinate{2.13761, 43.9226}, CountryId{"FR"}}, // Gare d'Albi-Ville
    {Coordinate{3.82327, 50.6864}, CountryId{"BE"}}, // Papignies railway station
    {Coordinate{2.40826, 50.8316}, CountryId{"FR"}}, // Gare d'Arnèke
    {Coordinate{36.6056, 50.5931}, CountryId{"RU"}}, // Q2651951
    {Coordinate{6.03583, 53.2483}, CountryId{"NL"}}, // De Westereen railway station
    {Coordinate{2.48361, 48.7064}, CountryId{"FR"}}, // Yerres railway station
    {Coordinate{6.2131, 47.1692}, CountryId{"FR"}}, // Gare de L'Hôpital-du-Grosbois
    {Coordinate{6.64861, 45.5544}, CountryId{"FR"}}, // Gare d'Aime-La Plagne
    {Coordinate{2.7375, 47.8528}, CountryId{"FR"}}, // Gare de Nogent-sur-Vernisson
    {Coordinate{3.21577, 49.2551}, CountryId{"FR"}}, // Q2653635
    {Coordinate{26.5275, 55.8749}, CountryId{"LV"}}, // Daugavpils Station
    {Coordinate{6.03915, 48.9523}, CountryId{"FR"}}, // Q2654586
    {Coordinate{-1.4491, 43.4047}, CountryId{"FR"}}, // Uztaritze/Ustaritz station
    {Coordinate{14.4308, 50.0799}, CountryId{"CZ"}}, // Muzeum
    {Coordinate{14.5267, 50.0306}, CountryId{"CZ"}}, // Háje
    {Coordinate{5.80888, 47.1836}, CountryId{"FR"}}, // Gare de Saint-Vit
    {Coordinate{7.11212, 49.0862}, CountryId{"FR"}}, // Q2655906
    {Coordinate{-0.853716, 44.6905}, CountryId{"FR"}}, // Marcheprime
    {Coordinate{3.23073, 50.5061}, CountryId{"FR"}}, // Nomain
    {Coordinate{4.79278, 52.4892}, CountryId{"NL"}}, // Wormerveer railway station
    {Coordinate{5.48795, 47.0961}, CountryId{"FR"}}, // Dole-Ville railway station
    {Coordinate{1.50788, 46.6265}, CountryId{"FR"}}, // Q2657063
    {Coordinate{14.4894, 50.1261}, CountryId{"CZ"}}, // Střížkov
    {Coordinate{14.4489, 50.0444}, CountryId{"CZ"}}, // Budějovická
    {Coordinate{7.4624, 49.5474}, CountryId{"DE"}}, // Altenglan station
    {Coordinate{2.48083, 48.8825}, CountryId{"FR"}}, // Rosny-Bois-Perrier station
    {Coordinate{13.5797, 51.1231}, CountryId{"DE"}}, // Coswig (b Dresden) station
    {Coordinate{7.96444, 51.1728}, CountryId{"DE"}}, // Finnentrop station
    {Coordinate{9.82771, 47.6463}, CountryId{"DE"}}, // Hergatz station
    {Coordinate{12.2356, 50.5712}, CountryId{"DE"}}, // Herlasgrün station
    {Coordinate{9.12111, 52.3081}, CountryId{"DE"}}, // Kirchhorsten railway station
    {Coordinate{7.72949, 49.4838}, CountryId{"DE"}}, // Q2657925
    {Coordinate{7.59071, 49.6537}, CountryId{"DE"}}, // Lauterecken-Grumbach station
    {Coordinate{12.7989, 52.9302}, CountryId{"DE"}}, // Bahnhof Neuruppin
    {Coordinate{7.60389, 50.2998}, CountryId{"DE"}}, // Oberlahnstein station
    {Coordinate{10.277, 47.4104}, CountryId{"DE"}}, // Oberstdorf station
    {Coordinate{11.427, 47.9142}, CountryId{"DE"}}, // Wolfratshausen station
    {Coordinate{1.58889, 50.0633}, CountryId{"FR"}}, // Gare de Feuquières-Fressenneville
    {Coordinate{2.418, 49.2142}, CountryId{"FR"}}, // Q2659445
    {Coordinate{6.03889, 50.635}, CountryId{"BE"}}, // Eupen railway station
    {Coordinate{14.5075, 50.0681}, CountryId{"CZ"}}, // Skalka
    {Coordinate{6.47697, 49.0038}, CountryId{"FR"}}, // Q2659780
    {Coordinate{14.4741, 50.0784}, CountryId{"CZ"}}, // Želivského
    {Coordinate{24.1218, 56.9463}, CountryId{"LV"}}, // Riga Central Station
    {Coordinate{5.93952, 51.6445}, CountryId{"NL"}}, // Boxmeer railway station
    {Coordinate{-0.798537, 45.8945}, CountryId{"FR"}}, // Bords
    {Coordinate{2.23694, 48.8922}, CountryId{"FR"}}, // La Défense
    {Coordinate{4.99176, 46.2271}, CountryId{"FR"}}, // Q2661260
    {Coordinate{6.60842, 48.5312}, CountryId{"FR"}}, // Q2661330
    {Coordinate{3.70194, 51.1072}, CountryId{"BE"}}, // Evergem railway station
    {Coordinate{14.418, 50.076}, CountryId{"CZ"}}, // Karlovo náměstí
    {Coordinate{15.2333, 50.0119}, CountryId{"CZ"}}, // Station Kolín dílny
    {Coordinate{-0.186111, 49.1111}, CountryId{"FR"}}, // Moult - Argences
    {Coordinate{4.51333, 51.0086}, CountryId{"BE"}}, // Muizen railway station
    {Coordinate{6.03083, 52.01}, CountryId{"NL"}}, // Rheden railway station
    {Coordinate{25.9613, 59.2656}, CountryId{"EE"}}, // Tapa railway station
    {Coordinate{14.3047, 49.9325}, CountryId{"CZ"}}, // Q2663694
    {Coordinate{7.26516, 47.8275}, CountryId{"FR"}}, // Gare de Staffelfelden
    {Coordinate{12.235, 51.84}, CountryId{"DE"}}, // Dessau Central Station
    {Coordinate{5.19056, 50.5219}, CountryId{"BE"}}, // Bas-Oha railway station
    {Coordinate{1.49223, 46.2398}, CountryId{"FR"}}, // Q2666389
    {Coordinate{6.86676, 45.9199}, CountryId{"FR"}}, // Q2667134
    {Coordinate{}, CountryId{"FI"}}, // Q26683837
    {Coordinate{3.78111, 50.9533}, CountryId{"BE"}}, // Moortsele railway station
    {Coordinate{3.77477, 49.5563}, CountryId{"FR"}}, // Q2668765
    {Coordinate{1.92061, 49.2026}, CountryId{"FR"}}, // Gare de Lavilletertre
    {Coordinate{2.70475, 45.6469}, CountryId{"FR"}}, // Q2669277
    {Coordinate{}, CountryId{"FI"}}, // Q26694328
    {Coordinate{5.8148, 44.5315}, CountryId{"FR"}}, // Q2669992
    {Coordinate{4.67188, 50.4529}, CountryId{"BE"}}, // Ham-sur-Sambre railway station
    {Coordinate{1.08333, 43.2128}, CountryId{"FR"}}, // Gare de Cazères-sur-Garonne
    {Coordinate{}, CountryId{"FI"}}, // Q26706935
    {Coordinate{6.90968, 51.2294}, CountryId{"DE"}}, // Erkrath Nord station
    {Coordinate{}, CountryId{"DE"}}, // Q26714912
    {Coordinate{10.55, 52.022}, CountryId{"DE"}}, // Schladen (Harz) station
    {Coordinate{10.569, 52.0605}, CountryId{"DE"}}, // Börßum station
    {Coordinate{21.2307, 62.3835}, CountryId{"FI"}}, // Kaskinen railway station
    {Coordinate{12.6647, 49.9767}, CountryId{"CZ"}}, // Q2672232
    {Coordinate{30.614, 62.1728}, CountryId{"FI"}}, // Niirala-raja railway station
    {Coordinate{0.5257, 46.7834}, CountryId{"FR"}}, // Q2672815
    {Coordinate{2.36981, 42.5916}, CountryId{"FR"}}, // Gare de Villefranche-Vernet-les-Bains
    {Coordinate{2.62341, 48.5401}, CountryId{"FR"}}, // Gare du Mée
    {Coordinate{4.74689, 45.7728}, CountryId{"FR"}}, // Q2672930
    {Coordinate{0.239004, 43.1836}, CountryId{"FR"}}, // Gare de Tournay
    {Coordinate{5.4225, 51.2156}, CountryId{"BE"}}, // Overpelt railway station
    {Coordinate{8.31009, 45.3415}, CountryId{"IT"}}, // Olcenengo railway station
    {Coordinate{3.32958, 50.9904}, CountryId{"BE"}}, // Tielt railway station
    {Coordinate{6.03499, 43.1363}, CountryId{"FR"}}, // Gare de La Pauline-Hyères
    {Coordinate{-3.56229, 48.2778}, CountryId{"FR"}}, // Gare de Carhaix
    {Coordinate{-1.49611, 47.1903}, CountryId{"FR"}}, // Gare de Saint-Sébastien-Frêne-Rond
    {Coordinate{0.682844, 49.2715}, CountryId{"FR"}}, // Glos-Montfort
    {Coordinate{7.38133, 48.5274}, CountryId{"FR"}}, // Gare de Heiligenberg - Mollkirch
    {Coordinate{-0.507644, 43.154}, CountryId{"FR"}}, // Gare d'Ogeu-les-Bains
    {Coordinate{0.789187, 43.65}, CountryId{"FR"}}, // Q2676863
    {Coordinate{23.3538, 52.518}, CountryId{"PL"}}, // Q2677271
    {Coordinate{-1.62139, 49.6333}, CountryId{"FR"}}, // Cherbourg railway station
    {Coordinate{5.84278, 50.9672}, CountryId{"NL"}}, // Geleen Oost railway station
    {Coordinate{4.79549, 45.3717}, CountryId{"FR"}}, // Gare du Péage-de-Roussillon
    {Coordinate{1.87917, 46.1742}, CountryId{"FR"}}, // Gare de Guéret
    {Coordinate{6.83861, 52.2372}, CountryId{"NL"}}, // Enschede Kennispark railway station
    {Coordinate{2.35028, 48.9175}, CountryId{"FR"}}, // Stade de France – Saint-Denis
    {Coordinate{5.37028, 43.4031}, CountryId{"FR"}}, // Q2678689
    {Coordinate{2.42611, 48.9308}, CountryId{"FR"}}, // Gare du Bourget
    {Coordinate{8.51606, 49.4599}, CountryId{"DE"}}, // Mannheim ARENA/Maimarkt station
    {Coordinate{5.81779, 50.5299}, CountryId{"BE"}}, // Franchimont railway station
    {Coordinate{5.42106, 46.2203}, CountryId{"FR"}}, // Q2679597
    {Coordinate{3.76454, 51.0201}, CountryId{"BE"}}, // Merelbeke railway station
    {Coordinate{5.12466, 50.2619}, CountryId{"BE"}}, // Chapois railway station
    {Coordinate{6.15642, 50.8706}, CountryId{"DE"}}, // Alsdorf-Annapark station
    {Coordinate{4.61575, 50.6698}, CountryId{"BE"}}, // Louvain-la-Neuve railway station
    {Coordinate{3.41861, 50.9844}, CountryId{"BE"}}, // Aarsele railway station
    {Coordinate{-3.41507, 50.6218}, CountryId{"GB"}}, // Exmouth railway station
    {Coordinate{2.53957, 49.9435}, CountryId{"FR"}}, // Q2681583
    {Coordinate{2.70596, 49.4333}, CountryId{"FR"}}, // Q2681989
    {Coordinate{20.9408, 52.2061}, CountryId{"PL"}}, // Warszawa Aleje Jerozolimskie railway station
    {Coordinate{9.96751, 51.8514}, CountryId{"DE"}}, // Kreiensen station
    {Coordinate{7.85613, 49.5704}, CountryId{"DE"}}, // Winnweiler station
    {Coordinate{12.2472, 54.1767}, CountryId{"DE"}}, // Rövershagen railway station
    {Coordinate{11.705, 50.1544}, CountryId{"DE"}}, // Q26821640
    {Coordinate{11.8403, 52.2742}, CountryId{"DE"}}, // Burg (bei Magdeburg) station
    {Coordinate{17.9502, 47.4798}, CountryId{"HU"}}, // Bakonyszombathely railway station
    {Coordinate{2.27167, 48.9806}, CountryId{"FR"}}, // Gare d'Ermont - Eaubonne
    {Coordinate{17.9138, 47.4716}, CountryId{"HU"}}, // Bakonybánk railway station
    {Coordinate{17.8675, 47.4772}, CountryId{"HU"}}, // Tápszentmiklós railway station
    {Coordinate{17.8355, 47.4701}, CountryId{"HU"}}, // Lázi railway station
    {Coordinate{17.7934, 47.4394}, CountryId{"HU"}}, // Románd railway station
    {Coordinate{17.748, 47.428}, CountryId{"HU"}}, // Gic-Hathalom railway station
    {Coordinate{17.7233, 47.4143}, CountryId{"HU"}}, // Bakonytamási railway station
    {Coordinate{17.6843, 47.376}, CountryId{"HU"}}, // Pápateszér railway station
    {Coordinate{17.6374, 47.3486}, CountryId{"HU"}}, // Franciavágás railway station
    {Coordinate{17.6002, 47.3326}, CountryId{"HU"}}, // Ugod railway station
    {Coordinate{17.5602, 47.3422}, CountryId{"HU"}}, // Nagygyimót railway station
    {Coordinate{17.515, 47.3496}, CountryId{"HU"}}, // Pusztagyimót  railway station
    {Coordinate{-0.677693, 45.8759}, CountryId{"FR"}}, // Saint-Savinien-sur-Charente
    {Coordinate{18.2983, 47.5301}, CountryId{"HU"}}, // Kecskéd railway station
    {Coordinate{18.2279, 47.5231}, CountryId{"HU"}}, // Dad railway station
    {Coordinate{18.1874, 47.5168}, CountryId{"HU"}}, // Szákszend railway station
    {Coordinate{18.1494, 47.5085}, CountryId{"HU"}}, // Császár railway station
    {Coordinate{18.0781, 47.5157}, CountryId{"HU"}}, // Ete railway station
    {Coordinate{18.2713, 47.5164}, CountryId{"HU"}}, // Bokod railway station
    {Coordinate{17.9436, 47.2968}, CountryId{"HU"}}, // Q26833849
    {Coordinate{17.7289, 47.5611}, CountryId{"HU"}}, // Écs railway staion
    {Coordinate{2.28286, 48.9061}, CountryId{"FR"}}, // Gare d'Asnières-sur-Seine
    {Coordinate{5.92972, 43.1286}, CountryId{"FR"}}, // Gare de Toulon
    {Coordinate{8.56889, 50.1436}, CountryId{"DE"}}, // Q26836599
    {Coordinate{13.0227, 48.2631}, CountryId{"DE"}}, // Simbach (Inn) station
    {Coordinate{2.35222, 48.6761}, CountryId{"FR"}}, // Savigny-sur-Orge (Paris RER)
    {Coordinate{6.18647, 43.2975}, CountryId{"FR"}}, // Q2684008
    {Coordinate{5.87167, 50.8561}, CountryId{"NL"}}, // Schin op Geul railway station
    {Coordinate{0.89, 44.1117}, CountryId{"FR"}}, // Gare de Valence-d'Agen
    {Coordinate{18.4487, 47.5518}, CountryId{"HU"}}, // Felsőgalla railway station
    {Coordinate{5.5021, 50.3496}, CountryId{"BE"}}, // Barvaux railway station
    {Coordinate{37.7461, 55.8039}, CountryId{"RU"}}, // Cherkizovo
    {Coordinate{5.55028, 51.42}, CountryId{"NL"}}, // Geldrop railway station
    {Coordinate{-0.651585, 43.93}, CountryId{"FR"}}, // Saint-Martin-d'Oney
    {Coordinate{2.32639, 49.3206}, CountryId{"FR"}}, // Gare de Mouy-Bury
    {Coordinate{20.9719, 52.1722}, CountryId{"PL"}}, // Warsaw Chopin Airport railway station
    {Coordinate{12.2789, 50.1614}, CountryId{"CZ"}}, // Hazlov (train station)
    {Coordinate{-1.63038, 48.2086}, CountryId{"FR"}}, // Gare de Chevaigné
    {Coordinate{4.13166, 50.3102}, CountryId{"BE"}}, // Erquelinnes-Village railway station
    {Coordinate{16.2842, 50.0003}, CountryId{"CZ"}}, // Brandýs nad Orlicí station
    {Coordinate{4.74278, 49.8119}, CountryId{"FR"}}, // Q2687707
    {Coordinate{1.84814, 48.9721}, CountryId{"FR"}}, // Aubergenville-Élisabethville
    {Coordinate{7.70032, 48.7328}, CountryId{"FR"}}, // Brumath
    {Coordinate{3.53622, 51.0731}, CountryId{"BE"}}, // Hansbeke railway station
    {Coordinate{10.229, 52.0892}, CountryId{"DE"}}, // Baddeckenstedt station
    {Coordinate{10.1438, 52.0969}, CountryId{"DE"}}, // Derneburg (Han) station
    {Coordinate{2.2425, 49.0156}, CountryId{"FR"}}, // Gare de Saint-Leu-la-Forêt
    {Coordinate{4.56571, 50.6466}, CountryId{"BE"}}, // Court-Saint-Étienne railway station
    {Coordinate{5.35791, 43.3696}, CountryId{"FR"}}, // Gare de Saint-Antoine
    {Coordinate{-3.28576, 47.7991}, CountryId{"FR"}}, // Gare d'Hennebont
    {Coordinate{-0.318056, 47.4122}, CountryId{"FR"}}, // Gare de Saint-Mathurin
    {Coordinate{4.66306, 51.6908}, CountryId{"NL"}}, // Lage Zwaluwe railway station
    {Coordinate{5.89126, 49.3666}, CountryId{"FR"}}, // Audun-le-Roman
    {Coordinate{5.88098, 50.3912}, CountryId{"BE"}}, // Coo railway station
    {Coordinate{6.92106, 47.6216}, CountryId{"FR"}}, // Gare de Chèvremont
    {Coordinate{5.33409, 46.4338}, CountryId{"FR"}}, // Q2691181
    {Coordinate{-3.56823, 48.5816}, CountryId{"FR"}}, // Gare de Plounérin
    {Coordinate{15.4789, 50.0314}, CountryId{"CZ"}}, // Q2691470
    {Coordinate{6.57491, 50.8627}, CountryId{"DE"}}, // Buir station
    {Coordinate{3.54326, 45.8612}, CountryId{"FR"}}, // Gare de Thiers
    {Coordinate{5.58361, 51.9314}, CountryId{"NL"}}, // Kesteren railway station
    {Coordinate{7.32075, 48.0166}, CountryId{"FR"}}, // Q2692559
    {Coordinate{4.96694, 52.3453}, CountryId{"NL"}}, // Diemen railway station
    {Coordinate{2.36028, 49.2725}, CountryId{"FR"}}, // Gare de Cires-lès-Mello
    {Coordinate{-1.305, 43.235}, CountryId{"FR"}}, // Ortzaize-Arrosa/Ossès-Saint-Martin-d'Arrossa station
    {Coordinate{4.99278, 51.5739}, CountryId{"NL"}}, // Tilburg Reeshof railway station
    {Coordinate{2.13611, 49.2886}, CountryId{"FR"}}, // Gare de Laboissière-Le Déluge
    {Coordinate{7.53117, 47.6095}, CountryId{"FR"}}, // Gare de Saint-Louis-la-Chaussée
    {Coordinate{20.9653, 52.2203}, CountryId{"PL"}}, // Warszawa Zachodnia station
    {Coordinate{1.81799, 49.2827}, CountryId{"FR"}}, // Gare de Trie-Château
    {Coordinate{5.60861, 51.4622}, CountryId{"NL"}}, // Helmond Brandevoort railway station
    {Coordinate{6.35017, 49.444}, CountryId{"FR"}}, // Sierck-les-Bains
    {Coordinate{1.06614, 47.3307}, CountryId{"FR"}}, // Q2695647
    {Coordinate{4.38338, 50.715}, CountryId{"BE"}}, // Waterloo railway station
    {Coordinate{85.1353, 25.6997}, CountryId{"IN"}}, // Pahlejaghat Junction railway station
    {Coordinate{3.44884, 49.496}, CountryId{"FR"}}, // Q2696779
    {Coordinate{2.25951, 48.9235}, CountryId{"FR"}}, // Gare de Colombes
    {Coordinate{4.29778, 51.0092}, CountryId{"BE"}}, // Londerzeel railway station
    {Coordinate{4.41444, 50.8892}, CountryId{"BE"}}, // Haren-South railway station
    {Coordinate{11.133, 45.0541}, CountryId{"IT"}}, // Revere railway station
    {Coordinate{2.16188, 48.9903}, CountryId{"FR"}}, // Q2697336
    {Coordinate{-3.72664, 40.4951}, CountryId{"ES"}}, // Pitis
    {Coordinate{1.83433, 47.3903}, CountryId{"FR"}}, // Gare de Loreux
    {Coordinate{2.84234, 48.3865}, CountryId{"FR"}}, // Q2697657
    {Coordinate{1.68611, 42.7864}, CountryId{"FR"}}, // Gare des Cabannes
    {Coordinate{2.21665, 48.8569}, CountryId{"FR"}}, // Gare du Val d'Or
    {Coordinate{-0.534813, 45.8501}, CountryId{"FR"}}, // Saint-Hilaire - Brizambourg
    {Coordinate{-0.425286, 44.6929}, CountryId{"FR"}}, // Gare de Portets
    {Coordinate{6.97417, 52.2186}, CountryId{"NL"}}, // Glanerbrug railway station
    {Coordinate{7.93344, 48.9313}, CountryId{"FR"}}, // Q2700531
    {Coordinate{2.24811, 42.9424}, CountryId{"FR"}}, // Gare de Couiza-Montazels
    {Coordinate{2.67905, 48.5103}, CountryId{"FR"}}, // Gare de Livry-sur-Seine
    {Coordinate{2.16175, 45.9598}, CountryId{"FR"}}, // Q2701026
    {Coordinate{-0.030946, 44.58}, CountryId{"FR"}}, // Gare de La Réole
    {Coordinate{5.8775, 51.7647}, CountryId{"NL"}}, // Mook Molenhoek railway station
    {Coordinate{2.3925, 49.7994}, CountryId{"FR"}}, // Gare de Dommartin-Remiencourt
    {Coordinate{7.55009, 51.5207}, CountryId{"DE"}}, // Dortmund-Brackel station
    {Coordinate{17.4707, 50.8531}, CountryId{"PL"}}, // Brzeg railway station
    {Coordinate{16.78, 48.0189}, CountryId{"AT"}}, // Q27031506
    {Coordinate{10.4937, 52.1804}, CountryId{"DE"}}, // Salzgitter-Thiede station
    {Coordinate{10.4418, 52.1501}, CountryId{"DE"}}, // Q27031811
    {Coordinate{10.4071, 52.1501}, CountryId{"DE"}}, // Salzgitter-Watenstedt station
    {Coordinate{10.333, 52.1513}, CountryId{"DE"}}, // Salzgitter-Lebenstedt station
    {Coordinate{-0.921062, 44.2106}, CountryId{"FR"}}, // Labouheyre
    {Coordinate{14.2033, 49.9186}, CountryId{"CZ"}}, // Q2703262
    {Coordinate{2.41444, 48.7083}, CountryId{"FR"}}, // gare de Vigneux-sur-Seine
    {Coordinate{-0.974109, 48.1108}, CountryId{"FR"}}, // Q2703622
    {Coordinate{-1.45641, 43.4314}, CountryId{"FR"}}, // Milafranga/Villefranque station
    {Coordinate{74.0878, 14.9392}, CountryId{"IN"}}, // Loliem railway station
    {Coordinate{10.6606, 52.1568}, CountryId{"DE"}}, // Dettum station
    {Coordinate{10.3198, 52.1968}, CountryId{"DE"}}, // Lengede-Broistedt station
    {Coordinate{10.2792, 52.2007}, CountryId{"DE"}}, // Woltwiesche station
    {Coordinate{10.1972, 52.2001}, CountryId{"DE"}}, // Q27057411
    {Coordinate{0.221314, 45.6763}, CountryId{"FR"}}, // Q2706277
    {Coordinate{7.95402, 48.9614}, CountryId{"FR"}}, // Q2707075
    {Coordinate{7.44306, 48.26}, CountryId{"FR"}}, // Sélestat
    {Coordinate{6.2746, 51.2743}, CountryId{"DE"}}, // Boisheim railway station
    {Coordinate{-1.37013, 48.6902}, CountryId{"FR"}}, // Avranches
    {Coordinate{15.533, 41.3518}, CountryId{"IT"}}, // Ponte Albanito railway station
    {Coordinate{6.68903, 47.4554}, CountryId{"FR"}}, // Q2711259
    {Coordinate{2.27501, 46.9352}, CountryId{"FR"}}, // Q2711794
    {Coordinate{4.80198, 50.4992}, CountryId{"BE"}}, // Rhisnes railway station
    {Coordinate{7.12496, 47.6276}, CountryId{"FR"}}, // Gare de Dannemarie
    {Coordinate{1.00959, 45.8767}, CountryId{"FR"}}, // Q2713487
    {Coordinate{7.34531, 48.0817}, CountryId{"FR"}}, // Gare de Colmar-Saint-Joseph
    {Coordinate{1.60806, 43.0125}, CountryId{"FR"}}, // Gare de Saint-Jean-de-Verges
    {Coordinate{16.162, 50.0389}, CountryId{"CZ"}}, // Plchůvky train station
    {Coordinate{-0.951618, 46.0939}, CountryId{"FR"}}, // Gare d'Aigrefeuille - Le Thou
    {Coordinate{14.7131, 52.6192}, CountryId{"PL"}}, // Dąbroszyn station
    {Coordinate{2.50194, 49.0492}, CountryId{"FR"}}, // Louvres
    {Coordinate{6.90128, 49.1895}, CountryId{"FR"}}, // Gare de Forbach
    {Coordinate{0.191944, 47.9942}, CountryId{"FR"}}, // Gare du Mans
    {Coordinate{2.08748, 42.4979}, CountryId{"FR"}}, // Gare de Bolquère - Eyne
    {Coordinate{-1.84323, 48.5936}, CountryId{"FR"}}, // Q2718288
    {Coordinate{6.73556, 52.6631}, CountryId{"NL"}}, // Coevorden railway station
    {Coordinate{0.381752, 46.682}, CountryId{"FR"}}, // Janay-Clan station
    {Coordinate{-1.49777, 47.9553}, CountryId{"FR"}}, // Q2720994
    {Coordinate{1.93722, 43.9283}, CountryId{"FR"}}, // Gare de Tessonnières
    {Coordinate{0.892317, 48.4328}, CountryId{"FR"}}, // Q2723066
    {Coordinate{77.2539, 28.587}, CountryId{"IN"}}, // Hazrat Nizamuddin railway station
    {Coordinate{4.38944, 50.8222}, CountryId{"BE"}}, // Etterbeek railway station
    {Coordinate{6.77441, 49.1262}, CountryId{"FR"}}, // Q2725085
    {Coordinate{2.498, 50.357}, CountryId{"FR"}}, // Q2725104
    {Coordinate{2.34861, 49.6964}, CountryId{"FR"}}, // Gare de La Faloise
    {Coordinate{1.51832, 46.5923}, CountryId{"FR"}}, // Q2727028
    {Coordinate{1.73912, 47.3556}, CountryId{"FR"}}, // Gare de Romorantin-Blanc-Argent
    {Coordinate{2.69028, 48.7706}, CountryId{"FR"}}, // Ozoir-la-Ferrière Station
    {Coordinate{-0.397182, 48.1555}, CountryId{"FR"}}, // Q2727830
    {Coordinate{5.76812, 49.6909}, CountryId{"BE"}}, // Stockem railway station
    {Coordinate{1.84992, 50.9409}, CountryId{"FR"}}, // Gare des Fontinettes
    {Coordinate{6.3103, 49.0635}, CountryId{"FR"}}, // Q2729654
    {Coordinate{7.06913, 51.4292}, CountryId{"DE"}}, // Essen-Überruhr station
    {Coordinate{2.42895, 49.5036}, CountryId{"FR"}}, // Gare de Saint-Just-en-Chaussée
    {Coordinate{2.42566, 49.4681}, CountryId{"FR"}}, // Gare de Saint-Rémy-en-l'Eau
    {Coordinate{6.22467, 46.1945}, CountryId{"FR"}}, // Ambilly Station
    {Coordinate{4.66222, 50.7547}, CountryId{"BE"}}, // Archennes railway station
    {Coordinate{68.835, 40.2101}, CountryId{"UZ"}}, // Khavast
    {Coordinate{13.2761, 49.7594}, CountryId{"CZ"}}, // Q2732921
    {Coordinate{5.53375, 50.4283}, CountryId{"BE"}}, // Hamoir railway station
    {Coordinate{4.33, 51.2142}, CountryId{"BE"}}, // Zwijndrecht railway station
    {Coordinate{2.22222, 48.5817}, CountryId{"FR"}}, // gare d'Égly
    {Coordinate{6.69855, 51.22}, CountryId{"DE"}}, // Neuss Am Kaiser station
    {Coordinate{2.47583, 49.7767}, CountryId{"FR"}}, // Gare de Moreuil
    {Coordinate{2.52139, 49.8628}, CountryId{"FR"}}, // Gare de Villers-Bretonneux
    {Coordinate{2.64222, 49.4386}, CountryId{"FR"}}, // Gare d'Estrées-Saint-Denis
    {Coordinate{2.80111, 49.8075}, CountryId{"FR"}}, // Gare de Chaulnes
    {Coordinate{4.43389, 52.1264}, CountryId{"NL"}}, // Voorschoten railway station
    {Coordinate{16.0619, 49.9897}, CountryId{"CZ"}}, // Q2736047
    {Coordinate{4.88797, 45.7052}, CountryId{"FR"}}, // Gare de Vénissieux
    {Coordinate{2.57261, 49.9556}, CountryId{"FR"}}, // Q2738092
    {Coordinate{-3.83417, 47.9606}, CountryId{"FR"}}, // Gare de Rosporden
    {Coordinate{-0.260278, 49.1411}, CountryId{"FR"}}, // Gare de Frénouville-Cagny
    {Coordinate{4.03944, 50.9428}, CountryId{"BE"}}, // Aalst railway station
    {Coordinate{-0.644454, 45.8304}, CountryId{"FR"}}, // Taillebourg
    {Coordinate{77.22, 28.6423}, CountryId{"IN"}}, // New Delhi railway station
    {Coordinate{7.60269, 48.7537}, CountryId{"FR"}}, // Schwindratzheim
    {Coordinate{10.5244, 52.4163}, CountryId{"DE"}}, // Rötgesbüttel station
    {Coordinate{10.5358, 52.3813}, CountryId{"DE"}}, // Meine station
    {Coordinate{5.04361, 49.9336}, CountryId{"BE"}}, // Graide railway station
    {Coordinate{5.16838, 49.6283}, CountryId{"FR"}}, // Q2743849
    {Coordinate{-1.12815, 46.1275}, CountryId{"FR"}}, // Aytré-Plage
    {Coordinate{-0.34105, 44.6324}, CountryId{"FR"}}, // Gare de Cérons
    {Coordinate{4.87458, 45.5213}, CountryId{"FR"}}, // Gare de Vienne
    {Coordinate{-2.16096, 47.3213}, CountryId{"FR"}}, // Q2744949
    {Coordinate{-0.809245, 44.007}, CountryId{"FR"}}, // Arengosse
    {Coordinate{4.32857, 50.881}, CountryId{"BE"}}, // Jette railway station
    {Coordinate{6.01774, 46.5393}, CountryId{"FR"}}, // Q2745587
    {Coordinate{17.0172, 54.4672}, CountryId{"PL"}}, // Słupsk railway station
    {Coordinate{2.14139, 43.9378}, CountryId{"FR"}}, // Gare d'Albi-Madeleine
    {Coordinate{5.39222, 51.8739}, CountryId{"NL"}}, // Tiel Passewaaij railway station
    {Coordinate{4.90806, 50.2611}, CountryId{"BE"}}, // Dinant railway station
    {Coordinate{15.7422, 50.0456}, CountryId{"CZ"}}, // Pardubice-Rosice nad Labem (train station)
    {Coordinate{3.04639, 50.7818}, CountryId{"BE"}}, // Wervik railway station
    {Coordinate{5.63694, 51.9261}, CountryId{"NL"}}, // Opheusden railway station
    {Coordinate{-0.773, 52.035}, CountryId{"GB"}}, // Milton Keynes Central railway station
    {Coordinate{2.21809, 42.9358}, CountryId{"FR"}}, // Gare d'Espéraza
    {Coordinate{6.88828, 48.3271}, CountryId{"FR"}}, // Q2747695
    {Coordinate{0.486871, 48.0737}, CountryId{"FR"}}, // Q2747705
    {Coordinate{11.2448, 51.1802}, CountryId{"DE"}}, // Q27478676
    {Coordinate{6.95734, 50.7958}, CountryId{"DE"}}, // Sechtem station
    {Coordinate{7.72889, 48.0497}, CountryId{"DE"}}, // Q27478870
    {Coordinate{8.02722, 48.3386}, CountryId{"DE"}}, // Q27478874
    {Coordinate{13.3636, 50.8758}, CountryId{"DE"}}, // Q27478889
    {Coordinate{7.7694, 48.1523}, CountryId{"DE"}}, // Riegel-Malterdingen station
    {Coordinate{11.7572, 47.7141}, CountryId{"DE"}}, // Tegernsee station
    {Coordinate{9.8307, 47.6891}, CountryId{"DE"}}, // Wangen (Allgäu) station
    {Coordinate{9.17235, 48.7759}, CountryId{"DE"}}, // Stuttgart Stadtmitte station
    {Coordinate{4.82437, 46.3025}, CountryId{"FR"}}, // Gare de Mâcon-Ville
    {Coordinate{6.85383, 47.6336}, CountryId{"FR"}}, // Gare de Belfort
    {Coordinate{2.05987, 47.2266}, CountryId{"FR"}}, // Gare de Vierzon-Ville
    {Coordinate{1.52833, 45.1525}, CountryId{"FR"}}, // Gare de Brive-la-Gaillarde
    {Coordinate{3.15056, 46.9869}, CountryId{"FR"}}, // Gare de Nevers
    {Coordinate{3.1585, 50.2685}, CountryId{"FR"}}, // Gare d'Aubigny-au-Bac
    {Coordinate{4.05568, 50.9193}, CountryId{"BE"}}, // Erembodegem railway station
    {Coordinate{4.21053, 50.52}, CountryId{"BE"}}, // Familleureux railway station
    {Coordinate{-1.67446, 48.3072}, CountryId{"FR"}}, // Q2750216
    {Coordinate{4.74333, 51.8297}, CountryId{"NL"}}, // Sliedrecht Baanhoek railway station
    {Coordinate{-1.4447, 43.3911}, CountryId{"FR"}}, // Jatsu/Jatxou station
    {Coordinate{3.16389, 51.1267}, CountryId{"BE"}}, // Zedelgem railway station
    {Coordinate{2.12222, 49.0545}, CountryId{"FR"}}, // Q2752323
    {Coordinate{15.4186, 50.0375}, CountryId{"CZ"}}, // Chvaletice
    {Coordinate{6.98812, 51.0458}, CountryId{"DE"}}, // Leverkusen-Küppersteg station
    {Coordinate{5.00693, 45.8339}, CountryId{"FR"}}, // Q2752803
    {Coordinate{3.22039, 50.5306}, CountryId{"FR"}}, // Genech
    {Coordinate{13.0905, 49.7886}, CountryId{"CZ"}}, // Q2753402
    {Coordinate{9.0693, 59.4092}, CountryId{"NO"}}, // Bø Station
    {Coordinate{2.41806, 49.3853}, CountryId{"FR"}}, // Gare de Clermont-de-l'Oise
    {Coordinate{6.81594, 51.0988}, CountryId{"DE"}}, // Dormagen station
    {Coordinate{21.0011, 52.2278}, CountryId{"PL"}}, // Warszawa Śródmieście WKD railway station
    {Coordinate{2.20556, 42.917}, CountryId{"FR"}}, // Gare de Campagne
    {Coordinate{3.13796, 50.6786}, CountryId{"FR"}}, // Croix - Wasquehal
    {Coordinate{4.74556, 52.0819}, CountryId{"NL"}}, // Bodegraven railway station
    {Coordinate{6.07461, 50.8319}, CountryId{"DE"}}, // Kohlscheid railway station
    {Coordinate{30.7798, 59.7601}, CountryId{"RU"}}, // Ivanovskaya railway station
    {Coordinate{6.3069, 45.5436}, CountryId{"FR"}}, // Aiguebelle
    {Coordinate{2.04903, 48.9748}, CountryId{"FR"}}, // Q2759280
    {Coordinate{7.38643, 51.4882}, CountryId{"DE"}}, // Dortmund-Oespel station
    {Coordinate{2.14178, 49.0693}, CountryId{"FR"}}, // Q2761375
    {Coordinate{-1.14556, 46.1528}, CountryId{"FR"}}, // Gare de La Rochelle
    {Coordinate{27.4039, 66.7236}, CountryId{"FI"}}, // Kemijärvi railway station
    {Coordinate{3.20858, 48.7993}, CountryId{"FR"}}, // Gare de Saint-Siméon
    {Coordinate{2.41778, 49.4446}, CountryId{"FR"}}, // Gare d'Avrechy
    {Coordinate{7.7212, 48.6447}, CountryId{"FR"}}, // Mundolsheim
    {Coordinate{-3.41966, 48.4063}, CountryId{"FR"}}, // Gare de Callac
    {Coordinate{5.99911, 49.2183}, CountryId{"FR"}}, // Q2765639
    {Coordinate{4.87861, 50.3208}, CountryId{"BE"}}, // Yvoir railway station
    {Coordinate{12.4428, 50.0486}, CountryId{"CZ"}}, // Q2766883
    {Coordinate{6.65833, 45.1925}, CountryId{"FR"}}, // Modane
    {Coordinate{2.60808, 50.5255}, CountryId{"FR"}}, // Gare de Fouquereuil
    {Coordinate{3.11264, 50.3565}, CountryId{"FR"}}, // Q2767849
    {Coordinate{8.65371, 58.5295}, CountryId{"NO"}}, // Froland Station
    {Coordinate{10.3119, 59.4919}, CountryId{"NO"}}, // Holmestrand Station (1881 - 2016)
    {Coordinate{3.62784, 50.9607}, CountryId{"BE"}}, // Eke-Nazareth railway station
    {Coordinate{6.45056, 52.0806}, CountryId{"NL"}}, // Ruurlo railway station
    {Coordinate{21.0375, 52.2553}, CountryId{"PL"}}, // Warszawa Wileńska station
    {Coordinate{-0.504509, 43.8847}, CountryId{"FR"}}, // Mont-de-Marsan
    {Coordinate{3.88056, 50.8969}, CountryId{"BE"}}, // Herzele railway station
    {Coordinate{13.0544, 51.9976}, CountryId{"DE"}}, // Jüterbog station
    {Coordinate{5.78604, 49.6882}, CountryId{"BE"}}, // Viville railway station
    {Coordinate{-1.16544, 44.6588}, CountryId{"FR"}}, // Gare d'Arcachon
    {Coordinate{7.43486, 52.2765}, CountryId{"DE"}}, // Rheine station
    {Coordinate{16.5075, 50.0314}, CountryId{"CZ"}}, // Letohrad (train station)
    {Coordinate{4.35889, 51.0108}, CountryId{"BE"}}, // Kapelle-op-den-Bos railway station
    {Coordinate{10.5428, 52.4797}, CountryId{"DE"}}, // Gifhorn-Stadt railway station
    {Coordinate{10.5781, 52.5093}, CountryId{"DE"}}, // Triangel railway station
    {Coordinate{10.6074, 52.5487}, CountryId{"DE"}}, // Neudorf-Platendorf railway station
    {Coordinate{10.607, 52.608}, CountryId{"DE"}}, // Wahrenholz railway station
    {Coordinate{10.6347, 52.6279}, CountryId{"DE"}}, // Schönewörde railway station
    {Coordinate{10.656, 52.6477}, CountryId{"DE"}}, // Vorhop railway station
    {Coordinate{4.83583, 50.8358}, CountryId{"BE"}}, // Vertrijk railway station
    {Coordinate{-3.77109, 40.3293}, CountryId{"ES"}}, // Leganés
    {Coordinate{6.13222, 51.9331}, CountryId{"NL"}}, // Didam railway station
    {Coordinate{24.3192, 59.3139}, CountryId{"EE"}}, // Q2778863
    {Coordinate{10.6904, 52.6778}, CountryId{"DE"}}, // Knesebeck railway station
    {Coordinate{8.76167, 50.1064}, CountryId{"DE"}}, // Offenbach (Main) Marktplatz station
    {Coordinate{10.723, 52.7271}, CountryId{"DE"}}, // Wittingen railway station
    {Coordinate{5.56722, 50.4564}, CountryId{"BE"}}, // Comblain-la-Tour railway station
    {Coordinate{10.6734, 52.8342}, CountryId{"DE"}}, // Bad Bodenteich railway station
    {Coordinate{8.03118, 43.8973}, CountryId{"IT"}}, // Imperia railway station
    {Coordinate{8.13834, 43.9601}, CountryId{"IT"}}, // Andora railway station
    {Coordinate{6.16904, 48.7353}, CountryId{"FR"}}, // Q2779510
    {Coordinate{5.72833, 53.1886}, CountryId{"NL"}}, // Deinum railway station
    {Coordinate{-1.81922, 48.1233}, CountryId{"FR"}}, // L'Hermitage - Mordelles
    {Coordinate{8.80211, 50.06}, CountryId{"DE"}}, // Heusenstamm station
    {Coordinate{4.32528, 50.4969}, CountryId{"BE"}}, // Gouy-lez-Piéton railway station
    {Coordinate{4.67134, 52.3829}, CountryId{"NL"}}, // Haarlem Spaarnwoude railway station
    {Coordinate{4.36167, 50.7481}, CountryId{"BE"}}, // Sint-Genesius-Rode railway station
    {Coordinate{0.804719, 48.7658}, CountryId{"FR"}}, // Q2781575
    {Coordinate{2.21825, 43.0684}, CountryId{"FR"}}, // Gare de Limoux-Flassian
    {Coordinate{6.14062, 50.8766}, CountryId{"DE"}}, // Alsdorf-Busch station
    {Coordinate{5.15056, 45.6275}, CountryId{"FR"}}, // Q2781996
    {Coordinate{3.95646, 50.4719}, CountryId{"BE"}}, // Nimy railway station
    {Coordinate{8.83732, 50.1194}, CountryId{"DE"}}, // Mühlheim station
    {Coordinate{8.78923, 50.0177}, CountryId{"DE"}}, // Dietzenbach-Mitte station
    {Coordinate{2.29167, 48.8181}, CountryId{"FR"}}, // Gare de Vanves-Malakoff
    {Coordinate{1.33838, 48.0734}, CountryId{"FR"}}, // Q2782753
    {Coordinate{2.94222, 42.2656}, CountryId{"ES"}}, // Figueres–Vilafant railway station
    {Coordinate{5.44512, 43.5232}, CountryId{"FR"}}, // Gare d'Aix-en-Provence
    {Coordinate{6.73554, 45.5751}, CountryId{"FR"}}, // Gare de Landry
    {Coordinate{65.6068, 62.5314}, CountryId{"RU"}}, // Priobye railway station
    {Coordinate{8.19242, 49.4082}, CountryId{"DE"}}, // Q27842213
    {Coordinate{7.19734, 50.9117}, CountryId{"DE"}}, // Q27842219
    {Coordinate{2.18002, 48.9802}, CountryId{"FR"}}, // Gare de La Frette - Montigny
    {Coordinate{1.75638, 45.2588}, CountryId{"FR"}}, // Gare de Tulle
    {Coordinate{8.64397, 52.7916}, CountryId{"DE"}}, // Twistringen station
    {Coordinate{13.5039, 52.5731}, CountryId{"DE"}}, // Wartenberg station
    {Coordinate{2.3525, 48.7403}, CountryId{"FR"}}, // Rungis - La Fraternelle
    {Coordinate{2.46389, 48.8211}, CountryId{"FR"}}, // Joinville-le-Pont
    {Coordinate{6.92246, 51.1671}, CountryId{"DE"}}, // Hilden station
    {Coordinate{2.92718, 49.5062}, CountryId{"FR"}}, // Ribécourt train station
    {Coordinate{20.9725, 52.3578}, CountryId{"PL"}}, // Warszawa Choszczówka railway station
    {Coordinate{3.57646, 49.2968}, CountryId{"FR"}}, // Q2785553
    {Coordinate{3.2852, 51.3399}, CountryId{"BE"}}, // Knokke railway station
    {Coordinate{2.106, 49.045}, CountryId{"FR"}}, // Gare de Saint-Ouen-l'Aumône
    {Coordinate{60.5616, 59.5944}, CountryId{"RU"}}, // Serov railway station
    {Coordinate{5.33075, 50.5538}, CountryId{"BE"}}, // Haute-Flône railway station
    {Coordinate{-1.72775, 48.4162}, CountryId{"FR"}}, // Gare de Combourg
    {Coordinate{6.75558, 43.4284}, CountryId{"FR"}}, // Q2786235
    {Coordinate{2.22904, 43.598}, CountryId{"FR"}}, // Gare de Castres
    {Coordinate{0.333056, 46.5822}, CountryId{"FR"}}, // Gare de Poitiers
    {Coordinate{7.68756, 51.5533}, CountryId{"DE"}}, // Unna-Königsborn station
    {Coordinate{3.26442, 50.8244}, CountryId{"BE"}}, // Kortrijk railway station
    {Coordinate{7.55694, 47.7317}, CountryId{"DE"}}, // Q27869673
    {Coordinate{2.02497, 49.0758}, CountryId{"FR"}}, // Gare de Boissy-l'Aillerie
    {Coordinate{35.9681, 49.7538}, CountryId{"UA"}}, // Q27876085
    {Coordinate{1.90551, 49.2207}, CountryId{"FR"}}, // Gare de Liancourt-Saint-Pierre
    {Coordinate{4.76579, 45.5852}, CountryId{"FR"}}, // Gare de Givors-Ville
    {Coordinate{5.63778, 51.795}, CountryId{"NL"}}, // Ravenstein railway station
    {Coordinate{1.10209, 49.343}, CountryId{"FR"}}, // Oissel
    {Coordinate{6.12927, 48.2993}, CountryId{"FR"}}, // Q2788266
    {Coordinate{8.53417, 47.8392}, CountryId{"DE"}}, // Q27890098
    {Coordinate{6.90167, 50.9978}, CountryId{"DE"}}, // Köln-Longerich station
    {Coordinate{4.52455, 50.0958}, CountryId{"BE"}}, // Mariembourg railway station
    {Coordinate{9.53426, 51.0978}, CountryId{"DE"}}, // Q27894893
    {Coordinate{7.18031, 51.3972}, CountryId{"DE"}}, // Hattingen Mitte station
    {Coordinate{0.40628, 48.0407}, CountryId{"FR"}}, // Gare de Montfort-le-Gesnois
    {Coordinate{-2.08861, 47.6517}, CountryId{"FR"}}, // Gare de Redon
    {Coordinate{14.3902, 50.9564}, CountryId{"CZ"}}, // Mikulášovice horní nádraží
    {Coordinate{8.7884, 49.3937}, CountryId{"DE"}}, // Neckargemünd
    {Coordinate{5.12818, 47.4057}, CountryId{"FR"}}, // Gare de Saint-Julien - Clénay
    {Coordinate{5.50667, 51.7583}, CountryId{"NL"}}, // Oss West railway station
    {Coordinate{5.1297, 47.4781}, CountryId{"FR"}}, // Gare de Gemeaux
    {Coordinate{16.2836, 48.1733}, CountryId{"AT"}}, // Bahnhof Wien Speising
    {Coordinate{3.14611, 50.2781}, CountryId{"FR"}}, // Gare de Brunémont
    {Coordinate{13.9132, 37.2058}, CountryId{"IT"}}, // Favarotta railway station
    {Coordinate{1.67595, 50.2731}, CountryId{"FR"}}, // Gare de Rue
    {Coordinate{4.12833, 51.9753}, CountryId{"NL"}}, // Hoek van Holland Haven metro station
    {Coordinate{5.66778, 52.0431}, CountryId{"NL"}}, // Ede Centrum railway station
    {Coordinate{6.55611, 44.791}, CountryId{"FR"}}, // Q2792896
    {Coordinate{4.28639, 51.2106}, CountryId{"BE"}}, // Melsele railway station
    {Coordinate{6.29529, 47.9812}, CountryId{"FR"}}, // Gare de Bains-les-Bains
    {Coordinate{8.34361, 47.8836}, CountryId{"DE"}}, // Bahnhof (Löffingen)
    {Coordinate{7.2423, 51.278}, CountryId{"DE"}}, // Wuppertal-Langerfeld station
    {Coordinate{2.05996, 48.3747}, CountryId{"FR"}}, // Gare de Guillerval
    {Coordinate{5.84944, 50.9433}, CountryId{"NL"}}, // Spaubeek railway station
    {Coordinate{16.2886, 48.1471}, CountryId{"AT"}}, // Wien Atzgersdorf railway station
    {Coordinate{2.23028, 49.9147}, CountryId{"FR"}}, // Gare de Dreuil-lès-Amiens
    {Coordinate{3.93561, 50.9135}, CountryId{"BE"}}, // Bambrugge railway station
    {Coordinate{15.4614, 38.2333}, CountryId{"IT"}}, // Gesso railway station
    {Coordinate{}, CountryId{"IT"}}, // Q27961301
    {Coordinate{14.0887, 41.42}, CountryId{"IT"}}, // Q27961303
    {Coordinate{80.9275, 26.8754}, CountryId{"IN"}}, // Daliganj junction railway station
    {Coordinate{75.3138, 11.9841}, CountryId{"IN"}}, // Kannapuram railway station
    {Coordinate{77.5584, 27.6362}, CountryId{"IN"}}, // Ajhai Railway Station
    {Coordinate{79.3, 21.3935}, CountryId{"IN"}}, // Ramtek railway station
    {Coordinate{88.6576, 22.8409}, CountryId{"IN"}}, // Habra railway station
    {Coordinate{1.07667, 44.1019}, CountryId{"FR"}}, // Gare de Moissac
    {Coordinate{2.50667, 48.6989}, CountryId{"FR"}}, // Brunoy railway station
    {Coordinate{6.14278, 52.1578}, CountryId{"NL"}}, // Voorst-Empe railway station
    {Coordinate{3.85243, 50.5942}, CountryId{"BE"}}, // Brugelette railway station
    {Coordinate{0.365725, 48.0286}, CountryId{"FR"}}, // Saint-Mars-la-Brière Station
    {Coordinate{6.9967, 51.0114}, CountryId{"DE"}}, // Leverkusen Chempark
    {Coordinate{6.19955, 47.2926}, CountryId{"FR"}}, // Q2797747
    {Coordinate{4.18265, 45.5291}, CountryId{"FR"}}, // Q2797918
    {Coordinate{7.75267, 48.5636}, CountryId{"FR"}}, // Gare de Krimmeri-Meinau
    {Coordinate{2.52611, 48.8444}, CountryId{"FR"}}, // Bry-sur-Marne
    {Coordinate{12.3128, 50.1619}, CountryId{"CZ"}}, // Q2798846
    {Coordinate{}, CountryId{"DE"}}, // Q27996573
    {Coordinate{5.99667, 51.5922}, CountryId{"NL"}}, // Vierlingsbeek railway station
    {Coordinate{-1.09089, 46.0784}, CountryId{"FR"}}, // Châtelaillon
    {Coordinate{6.07314, 49.3307}, CountryId{"FR"}}, // Hayange railway station
    {Coordinate{7.37799, 51.3366}, CountryId{"DE"}}, // Gevelsberg-Knapp station
    {Coordinate{3.23074, 50.5061}, CountryId{"FR"}}, // Gare de Nomain - Ouvignies
    {Coordinate{7.50752, 48.7459}, CountryId{"FR"}}, // Q2800820
    {Coordinate{4.47667, 51.1339}, CountryId{"BE"}}, // Kontich railway station
    {Coordinate{6.60508, 49.0457}, CountryId{"FR"}}, // Q2801459
    {Coordinate{5.84684, 45.8034}, CountryId{"FR"}}, // Gare de Chindrieux
    {Coordinate{3.21867, 43.3361}, CountryId{"FR"}}, // Béziers railway station
    {Coordinate{9.87972, 48.2289}, CountryId{"DE"}}, // Laupheim West station
    {Coordinate{9.39239, 48.8795}, CountryId{"DE"}}, // Q28025261
    {Coordinate{-1.76435, 43.37}, CountryId{"FR"}}, // Gare des Deux-Jumeaux
    {Coordinate{2.31622, 43.1555}, CountryId{"FR"}}, // Gare de Couffoulens-Leuc
    {Coordinate{2.47889, 48.8939}, CountryId{"FR"}}, // Bondy (Paris RER)
    {Coordinate{40.3933, 48.921}, CountryId{"RU"}}, // Q28027752
    {Coordinate{8.77277, 47.8563}, CountryId{"DE"}}, // Engen station
    {Coordinate{6.04128, 51.4271}, CountryId{"NL"}}, // Horst-Sevenum railway station
    {Coordinate{6.6259, 51.2691}, CountryId{"DE"}}, // Meerbusch-Osterath station
    {Coordinate{77.5953, 14.6865}, CountryId{"IN"}}, // Anantapur railway station
    {Coordinate{13.4621, 51.1523}, CountryId{"DE"}}, // Meissen Triebischtal station
    {Coordinate{1.31412, 43.6164}, CountryId{"FR"}}, // Gare de Colomiers-Lycée International
    {Coordinate{12.7738, 50.7093}, CountryId{"DE"}}, // Stollberg (Sachs) railway station
    {Coordinate{10.6261, 60.7514}, CountryId{"NO"}}, // Breiskallen Station
    {Coordinate{2.43556, 48.6481}, CountryId{"FR"}}, // Gare de Grand Bourg
    {Coordinate{6.31778, 52.1069}, CountryId{"NL"}}, // Vorden railway station
    {Coordinate{9.98639, 53.5492}, CountryId{"DE"}}, // Stadthausbrücke station
    {Coordinate{12.1, 54.0779}, CountryId{"DE"}}, // Rostock Thierfelder Straße railway station
    {Coordinate{12.0463, 54.077}, CountryId{"DE"}}, // Groß Schwaß railway station
    {Coordinate{11.922, 54.0905}, CountryId{"DE"}}, // Althof railway station
    {Coordinate{11.905, 54.1}, CountryId{"DE"}}, // Bad Doberan railway station
    {Coordinate{11.7274, 54.1467}, CountryId{"DE"}}, // Kühlungsborn West railway station
    {Coordinate{11.8429, 54.1417}, CountryId{"DE"}}, // Heiligendamm railway station
    {Coordinate{11.7598, 54.1478}, CountryId{"DE"}}, // Kühlungsborn Ost railway station
    {Coordinate{11.6149, 53.9596}, CountryId{"DE"}}, // Hagebök railway station
    {Coordinate{12.1756, 50.2522}, CountryId{"CZ"}}, // Q2805526
    {Coordinate{-2.20083, 47.2904}, CountryId{"FR"}}, // Gare de Penhoët
    {Coordinate{5.44389, 47.8094}, CountryId{"FR"}}, // Gare de Culmont-Chalindrey
    {Coordinate{7.05855, 47.2771}, CountryId{"CH"}}, // Pré-Petitjean train station
    {Coordinate{2.82239, 44.3749}, CountryId{"FR"}}, // Q28066138
    {Coordinate{14.0873, 51.0371}, CountryId{"DE"}}, // Stolpen railway station
    {Coordinate{13.0108, 47.8161}, CountryId{"AT"}}, // Bahnhof Salzburg Taxham Europark
    {Coordinate{3.3144, 50.8564}, CountryId{"BE"}}, // Harelbeke railway station
    {Coordinate{7.84917, 48.1214}, CountryId{"DE"}}, // Emmendingen station
    {Coordinate{11.8105, 51.9207}, CountryId{"DE"}}, // Calbe (Saale) Ost station
    {Coordinate{10.5753, 60.5978}, CountryId{"NO"}}, // Q28126579
    {Coordinate{9.00126, 49.6844}, CountryId{"DE"}}, // Q28131570
    {Coordinate{15.3271, 47.2664}, CountryId{"AT"}}, // Q28150696
    {Coordinate{76.6379, 12.2984}, CountryId{"IN"}}, // Chamarajapuram railway station
    {Coordinate{76.6353, 12.2738}, CountryId{"IN"}}, // Ashokapuram railway station
    {Coordinate{76.8589, 11.9961}, CountryId{"IN"}}, // Badanaguppe railway station
    {Coordinate{76.9328, 11.9349}, CountryId{"IN"}}, // Chamarajanagar railway station
    {Coordinate{79.5018, 18.0783}, CountryId{"IN"}}, // Hasanparthi Road railway station
    {Coordinate{81.2112, 16.7974}, CountryId{"IN"}}, // Sitampet railway station
    {Coordinate{76.678, 12.4247}, CountryId{"IN"}}, // Shrirangapattana railway station
    {Coordinate{83.067, 17.6862}, CountryId{"IN"}}, // Thadi railway station
    {Coordinate{76.2079, 10.9812}, CountryId{"IN"}}, // Angadipuram railway station
    {Coordinate{79.4322, 23.8367}, CountryId{"IN"}}, // Damoh railway station
    {Coordinate{77.9651, 10.0223}, CountryId{"IN"}}, // Sholavandan railway station
    {Coordinate{80.9023, 26.7776}, CountryId{"IN"}}, // Transport Nagar Railway station
    {Coordinate{83.342, 26.7653}, CountryId{"IN"}}, // Domingarh railway station
    {Coordinate{73.3664, 18.7832}, CountryId{"IN"}}, // Monkey Hill railway station
    {Coordinate{74.8565, 12.8444}, CountryId{"IN"}}, // Nethravathi railway station
    {Coordinate{74.8582, 12.8182}, CountryId{"IN"}}, // Tokkottu railway station
    {Coordinate{74.8548, 12.7913}, CountryId{"IN"}}, // Ullal railway station
    {Coordinate{74.9985, 12.4677}, CountryId{"IN"}}, // Kalanad railway station
    {Coordinate{75.024, 12.4235}, CountryId{"IN"}}, // Kotikulam railway station
    {Coordinate{75.1683, 12.1798}, CountryId{"IN"}}, // Chandera railway station
    {Coordinate{75.5597, 11.669}, CountryId{"IN"}}, // Mukkali railway station
    {Coordinate{75.6089, 11.5481}, CountryId{"IN"}}, // Iringal railway station
    {Coordinate{75.6534, 11.4723}, CountryId{"IN"}}, // Vellarakkad railway station
    {Coordinate{75.72, 11.4053}, CountryId{"IN"}}, // Chemancheri railway station
    {Coordinate{75.7412, 11.3464}, CountryId{"IN"}}, // Elathur railway station
    {Coordinate{75.7746, 11.2645}, CountryId{"IN"}}, // Vellayil railway station
    {Coordinate{76.2529, 10.7881}, CountryId{"IN"}}, // Vadanamkurishi railway station
    {Coordinate{76.2534, 10.8306}, CountryId{"IN"}}, // Vallapuzha railway station
    {Coordinate{76.2394, 10.8683}, CountryId{"IN"}}, // Kulukkallur railway station
    {Coordinate{76.2281, 10.9292}, CountryId{"IN"}}, // Cherukara railway station
    {Coordinate{76.2318, 11.0206}, CountryId{"IN"}}, // Pattikkad railway station
    {Coordinate{76.2728, 11.0654}, CountryId{"IN"}}, // Melattur railway station
    {Coordinate{76.2829, 11.1205}, CountryId{"IN"}}, // Tuvvur railway station
    {Coordinate{76.2605, 11.1885}, CountryId{"IN"}}, // Vaniyambalam railway station
    {Coordinate{76.2548, 11.2788}, CountryId{"IN"}}, // Nilambur Road railway station
    {Coordinate{81.3642, 16.8153}, CountryId{"IN"}}, // Kaikaram railway station
    {Coordinate{81.3965, 16.8199}, CountryId{"IN"}}, // Chebrol railway station
    {Coordinate{78.2607, 26.392}, CountryId{"IN"}}, // Malanpur railway station
    {Coordinate{77.8493, 18.8883}, CountryId{"IN"}}, // Dharmabad railway station
    {Coordinate{88.7248, 26.8737}, CountryId{"IN"}}, // New Mal Junction railway station
    {Coordinate{76.6637, 12.1904}, CountryId{"IN"}}, // Kadakola railway station
    {Coordinate{76.6776, 12.1695}, CountryId{"IN"}}, // Tandavapura railway station
    {Coordinate{76.6744, 12.136}, CountryId{"IN"}}, // Sujathapuram railway station
    {Coordinate{76.6844, 12.1221}, CountryId{"IN"}}, // Nanjangud Town railway station
    {Coordinate{76.7324, 12.0846}, CountryId{"IN"}}, // Chinnadagudihundi railway station
    {Coordinate{76.7495, 12.0755}, CountryId{"IN"}}, // Narasambudhi railway station
    {Coordinate{76.7945, 12.0363}, CountryId{"IN"}}, // Kavalande railway station
    {Coordinate{76.834, 12.0144}, CountryId{"IN"}}, // Konanur railway station
    {Coordinate{76.6846, 10.6838}, CountryId{"IN"}}, // Pudunagaram railway station
    {Coordinate{76.7717, 10.6264}, CountryId{"IN"}}, // Muthalamada railway station
    {Coordinate{}, CountryId{"IN"}}, // S.G. Pudur railway station
    {Coordinate{81.3248, 16.8099}, CountryId{"IN"}}, // Pulla railway station
    {Coordinate{81.4236, 16.8245}, CountryId{"IN"}}, // Unguturu railway station
    {Coordinate{80.9122, 16.6159}, CountryId{"IN"}}, // Veeravalli railway station
    {Coordinate{80.84, 16.5625}, CountryId{"IN"}}, // Peda Avutapalle railway station
    {Coordinate{80.8904, 16.5986}, CountryId{"IN"}}, // Telaprolu railway station
    {Coordinate{74.4221, 16.7484}, CountryId{"IN"}}, // Hatkanangale railway station
    {Coordinate{91.6177, 23.8612}, CountryId{"IN"}}, // Teliamura Railway Station
    {Coordinate{75.8511, 11.0924}, CountryId{"IN"}}, // Vallikkunnu Railway Station
    {Coordinate{75.1758, 12.1422}, CountryId{"IN"}}, // Trikkaripur railway station
    {Coordinate{79.6764, 21.6132}, CountryId{"IN"}}, // Mahkepar Road railway station
    {Coordinate{79.6779, 21.6665}, CountryId{"IN"}}, // Sukli railway station
    {Coordinate{79.7166, 21.6802}, CountryId{"IN"}}, // Tirodi railway station
    {Coordinate{79.5519, 20.7477}, CountryId{"IN"}}, // Pauni Road railway station
    {Coordinate{79.5795, 20.7129}, CountryId{"IN"}}, // Bhuyar railway station
    {Coordinate{88.1989, 25.225}, CountryId{"IN"}}, // Gazole railway station
    {Coordinate{72.6552, 22.9173}, CountryId{"IN"}}, // Geratpur Railway Station
    {Coordinate{75.7342, 22.619}, CountryId{"IN"}}, // Tihi railway station
    {Coordinate{78.534, 14.6423}, CountryId{"IN"}}, // Yerraguntla Junction railway station
    {Coordinate{74.1551, 18.3841}, CountryId{"IN"}}, // Rajewadi railway station
    {Coordinate{78.0963, 11.6963}, CountryId{"IN"}}, // Magnesite Junction railway station
    {Coordinate{78.6937, 10.8073}, CountryId{"IN"}}, // Tiruchirappalli Palakkarai railway station
    {Coordinate{79.7575, 11.9193}, CountryId{"IN"}}, // Villianur railway station
    {Coordinate{77.7892, 9.46332}, CountryId{"IN"}}, // Sivakasi railway station
    {Coordinate{77.8109, 9.4773}, CountryId{"IN"}}, // Tiruttangal railway station
    {Coordinate{91.9018, 23.9198}, CountryId{"IN"}}, // Jawaharnagar railway station
    {Coordinate{84.3593, 26.2107}, CountryId{"IN"}}, // Siwan Junction railway station
    {Coordinate{93.7915, 27.137}, CountryId{"IN"}}, // Gumto railway station
    {Coordinate{92.6447, 27.0006}, CountryId{"IN"}}, // Bhalukpong railway station
    {Coordinate{76.6869, 10.6417}, CountryId{"IN"}}, // Vadakannikapuram railway station
    {Coordinate{85.6422, 25.0154}, CountryId{"IN"}}, // Warisaliganj railway station
    {Coordinate{13.8247, 52.4067}, CountryId{"DE"}}, // Fangschleuse railway station
    {Coordinate{77.6287, 11.2533}, CountryId{"IN"}}, // Perundurai railway station
    {Coordinate{87.5327, 23.8902}, CountryId{"IN"}}, // Siuri railway station
    {Coordinate{11.1446, 44.7652}, CountryId{"IT"}}, // Q28217247
    {Coordinate{73.0419, 19.1884}, CountryId{"IN"}}, // Diva Junction
    {Coordinate{0.036153, 49.3315}, CountryId{"FR"}}, // Gare de Blonville-sur-Mer-Benerville
    {Coordinate{3.35699, 49.4037}, CountryId{"FR"}}, // Q2831424
    {Coordinate{3.04266, 48.8138}, CountryId{"FR"}}, // Mouroux station
    {Coordinate{6.51794, 50.84}, CountryId{"DE"}}, // Merzenich station
    {Coordinate{9.17631, 39.3458}, CountryId{"IT"}}, // Soleminis railway station
    {Coordinate{20.9422, 52.2056}, CountryId{"PL"}}, // Q2832591
    {Coordinate{2.32278, 49.0661}, CountryId{"FR"}}, // Gare de Montsoult - Maffliers
    {Coordinate{3.3966, 50.613}, CountryId{"BE"}}, // Tournai railway station
    {Coordinate{28.47, 55.6217}, CountryId{"BY"}}, // Adamova
    {Coordinate{24.3028, 53.1117}, CountryId{"BY"}}, // Andreyevichy
    {Coordinate{28.5986, 55.5856}, CountryId{"BY"}}, // Baravukha
    {Coordinate{26.0147, 53.154}, CountryId{"BY"}}, // Baranavichy-Pawnochnyya
    {Coordinate{25.295, 54.0789}, CountryId{"BY"}}, // Bastuny
    {Coordinate{32.1642, 53.2328}, CountryId{"BY"}}, // Byalynkavichy
    {Coordinate{31.1028, 52.3917}, CountryId{"BY"}}, // Byarozki
    {Coordinate{29.2636, 54.3194}, CountryId{"BY"}}, // Bobr
    {Coordinate{29.1956, 53.1378}, CountryId{"BY"}}, // Babruysk
    {Coordinate{26.1537, 54.1711}, CountryId{"BY"}}, // Bahdanaw
    {Coordinate{30.2094, 54.8439}, CountryId{"BY"}}, // Bahushewskaya
    {Coordinate{28.3272, 55.6703}, CountryId{"BY"}}, // Borkavichy
    {Coordinate{28.0817, 55.2144}, CountryId{"BY"}}, // Baravoye
    {Coordinate{25.9389, 53.1069}, CountryId{"BY"}}, // Barawtsy
    {Coordinate{23.7106, 52.0947}, CountryId{"BY"}}, // Brest-Palyeski
    {Coordinate{23.6547, 52.1115}, CountryId{"BY"}}, // Brest-Pawnochny
    {Coordinate{29.1158, 52.9514}, CountryId{"BY"}}, // Brozha
    {Coordinate{23.6669, 53.5556}, CountryId{"BY"}}, // Bruzhi
    {Coordinate{27.4086, 54.7911}, CountryId{"BY"}}, // Budslaw
    {Coordinate{30.2489, 53.8678}, CountryId{"BY"}}, // Buynichy
    {Coordinate{28.8972, 52.7056}, CountryId{"BY"}}, // Bumazhkova
    {Coordinate{29.6506, 54.7125}, CountryId{"BY"}}, // Burbin
    {Coordinate{30.2319, 53.5156}, CountryId{"BY"}}, // Bykhaw
    {Coordinate{30.0389, 53.8031}, CountryId{"BY"}}, // Vyendryzh
    {Coordinate{31.2781, 53.7625}, CountryId{"BY"}}, // Vyeramyeyki
    {Coordinate{27.9417, 55.8175}, CountryId{"BY"}}, // Vyerkhnyadzvinsk
    {Coordinate{28.0503, 52.9669}, CountryId{"BY"}}, // Q28380449
    {Coordinate{26.9319, 54.5028}, CountryId{"BY"}}, // Vilyeyka
    {Coordinate{30.0903, 52.8822}, CountryId{"BY"}}, // Virski
    {Coordinate{30.2697, 55.2211}, CountryId{"BY"}}, // Vits′ba
    {Coordinate{26.4488, 54.2202}, CountryId{"BY"}}, // Valozhyn
    {Coordinate{29.5028, 53.6}, CountryId{"BY"}}, // Q28380469
    {Coordinate{27.2033, 55.1417}, CountryId{"BY"}}, // Varapayeva
    {Coordinate{25.5999, 53.3512}, CountryId{"BY"}}, // Vyhada
    {Coordinate{25.6542, 53.9778}, CountryId{"BY"}}, // Hawya
    {Coordinate{27.6686, 53.7781}, CountryId{"BY"}}, // Hatava
    {Coordinate{23.7718, 53.624}, CountryId{"BY"}}, // Hibulichy
    {Coordinate{27.6722, 55.1333}, CountryId{"BY"}}, // Hlybokaye
    {Coordinate{30.9472, 52.4567}, CountryId{"BY"}}, // Homyel′-Pawnochny
    {Coordinate{27.8494, 53.9861}, CountryId{"BY"}}, // Haradzishcha
    {Coordinate{26.7838, 51.8521}, CountryId{"BY"}}, // Haryn′
    {Coordinate{29.0364, 55.425}, CountryId{"BY"}}, // Harany
    {Coordinate{29.9972, 55.7633}, CountryId{"BY"}}, // Hrybachy
    {Coordinate{30.1008, 55.1783}, CountryId{"BY"}}, // Hryshany
    {Coordinate{25.3653, 53.9169}, CountryId{"BY"}}, // Hutna
    {Coordinate{28.4931, 53.1764}, CountryId{"BY"}}, // Darahanava
    {Coordinate{28.5639, 53.255}, CountryId{"BY"}}, // Dzyerawtsy
    {Coordinate{29.2167, 55.6986}, CountryId{"BY"}}, // Dretun′
    {Coordinate{29.7792, 53.7042}, CountryId{"BY"}}, // Druts′
    {Coordinate{23.6458, 51.8056}, CountryId{"BY"}}, // Dubitsa
    {Coordinate{28.9939, 53.4003}, CountryId{"BY"}}, // Yalizava
    {Coordinate{29.9594, 52.8953}, CountryId{"BY"}}, // Zhlobin-Zakhodni
    {Coordinate{30.0272, 52.8653}, CountryId{"BY"}}, // Zhlobin-Padol′ski
    {Coordinate{30.0069, 52.9139}, CountryId{"BY"}}, // Zhlobin-Pawnochny
    {Coordinate{30.0156, 52.8908}, CountryId{"BY"}}, // Zhlobin-Sartyraval′ny
    {Coordinate{30.2631, 55.185}, CountryId{"BY"}}, // Zhurzhava
    {Coordinate{30.3003, 55.1117}, CountryId{"BY"}}, // Zabalotsinka
    {Coordinate{24.0545, 53.6453}, CountryId{"BY"}}, // Zavadzichy
    {Coordinate{28.3472, 55.3458}, CountryId{"BY"}}, // Zahatstsye
    {Coordinate{23.9194, 51.9444}, CountryId{"BY"}}, // Zakrutsin
    {Coordinate{30.0625, 55.4083}, CountryId{"BY"}}, // Zaluchcha
    {Coordinate{28.9319, 54.8736}, CountryId{"BY"}}, // Zaslonava
    {Coordinate{28.1775, 55.2569}, CountryId{"BY"}}, // Zyabki
    {Coordinate{31.2128, 52.3083}, CountryId{"BY"}}, // Zyabrawka
    {Coordinate{26.8105, 54.2989}, CountryId{"BY"}}, // Kalyedzino
    {Coordinate{27.5875, 52.8264}, CountryId{"BY"}}, // Kaliy I
    {Coordinate{26.6599, 53.0765}, CountryId{"BY"}}, // Klyetsk
    {Coordinate{27.1847, 54.675}, CountryId{"BY"}}, // Knyahinin
    {Coordinate{30.0228, 55.1831}, CountryId{"BY"}}, // Knyazhytsa
    {Coordinate{28.2042, 54.0383}, CountryId{"BY"}}, // Chyrvony Stsyah
    {Coordinate{29.1694, 53.0331}, CountryId{"BY"}}, // Krasny Brod
    {Coordinate{27.7833, 55.0278}, CountryId{"BY"}}, // Krulyawshchyna
    {Coordinate{29.0725, 54.2983}, CountryId{"BY"}}, // Krupki
    {Coordinate{30.4397, 55.031}, CountryId{"BY"}}, // Krynki
    {Coordinate{28.7217, 55.4533}, CountryId{"BY"}}, // Ksty
    {Coordinate{30.8819, 52.5717}, CountryId{"BY"}}, // Lazurnaya
    {Coordinate{29.9, 54.6394}, CountryId{"BY"}}, // Lyemnitsa
    {Coordinate{25.2957, 53.8811}, CountryId{"BY"}}, // Lida
    {Coordinate{30.7986, 55.0139}, CountryId{"BY"}}, // Q28380577
    {Coordinate{31.065, 52.3833}, CountryId{"BY"}}, // Lisichki
    {Coordinate{29.4506, 55.3169}, CountryId{"BY"}}, // Lowsha
    {Coordinate{30.0906, 55.3289}, CountryId{"BY"}}, // Losvida
    {Coordinate{23.8078, 53.6565}, CountryId{"BY"}}, // Lasosna
    {Coordinate{30.1139, 55.2553}, CountryId{"BY"}}, // Luzhasna
    {Coordinate{30.0081, 52.9875}, CountryId{"BY"}}, // Lukskaye
    {Coordinate{30.2386, 55.145}, CountryId{"BY"}}, // Luchosa
    {Coordinate{23.4942, 52.2579}, CountryId{"BY"}}, // Lyshchytsy
    {Coordinate{25.3639, 53.7917}, CountryId{"BY"}}, // Minoyty
    {Coordinate{27.5328, 53.8792}, CountryId{"BY"}}, // Minsk-Sartyraval′ny
    {Coordinate{27.5636, 53.8661}, CountryId{"BY"}}, // Q28380607
    {Coordinate{27.6089, 55.6253}, CountryId{"BY"}}, // Myory
    {Coordinate{29.0694, 53.1767}, CountryId{"BY"}}, // Miradzina
    {Coordinate{25.7513, 53.2975}, CountryId{"BY"}}, // Mitskyevichy
    {Coordinate{25.8178, 53.2679}, CountryId{"BY"}}, // Mordzichy
    {Coordinate{23.5818, 52.2083}, CountryId{"BY"}}, // Matykaly
    {Coordinate{28.5644, 52.2083}, CountryId{"BY"}}, // Mulyarawka
    {Coordinate{27.6972, 52.9828}, CountryId{"BY"}}, // Nyekrashy
    {Coordinate{23.7507, 53.5808}, CountryId{"BY"}}, // Nyemyayshchyna
    {Coordinate{29.2439, 53.5092}, CountryId{"BY"}}, // Nyasyata
    {Coordinate{27.5886, 52.9969}, CountryId{"BY"}}, // Navadvortsy
    {Coordinate{28.7031, 54.25}, CountryId{"BY"}}, // Navasady
    {Coordinate{29.2778, 55.3639}, CountryId{"BY"}}, // Obal′
    {Coordinate{30.3756, 54.505}, CountryId{"BY"}}, // Orsha-Zakhodnyaya
    {Coordinate{30.6614, 54.6494}, CountryId{"BY"}}, // Asinawka
    {Coordinate{31.4442, 53.7556}, CountryId{"BY"}}, // Asavyets
    {Coordinate{27.6039, 54.8781}, CountryId{"BY"}}, // Parafyanava
    {Coordinate{30.9892, 54.265}, CountryId{"BY"}}, // Pahodzina
    {Coordinate{27.9789, 55.1622}, CountryId{"BY"}}, // Padsvillye
    {Coordinate{25.7284, 53.1213}, CountryId{"BY"}}, // Palonka
    {Coordinate{26.8606, 55.1239}, CountryId{"BY"}}, // Pastavy
    {Coordinate{26.7917, 52.1258}, CountryId{"BY"}}, // Prypyats′
    {Coordinate{28.8392, 54.2761}, CountryId{"BY"}}, // Pryyamina
    {Coordinate{28.9558, 52.775}, CountryId{"BY"}}, // Ratmiravichy
    {Coordinate{30.3072, 52.3425}, CountryId{"BY"}}, // Rabusa
    {Coordinate{30.6889, 53.8242}, CountryId{"BY"}}, // Resta
    {Coordinate{29.9404, 55.5852}, CountryId{"BY"}}, // Raslyaki
    {Coordinate{30.4639, 54.44}, CountryId{"BY"}}, // Rumina
    {Coordinate{29.3708, 53.0875}, CountryId{"BY"}}, // Savichy
    {Coordinate{30.3347, 52.8181}, CountryId{"BY"}}, // Saltanawka
    {Coordinate{28.1075, 55.7547}, CountryId{"BY"}}, // Svol′na
    {Coordinate{30.4778, 52.3722}, CountryId{"BY"}}, // Syenazavod
    {Coordinate{29.4463, 54.3082}, CountryId{"BY"}}, // Slawnaye
    {Coordinate{29.0681, 51.6317}, CountryId{"BY"}}, // Slavyechna
    {Coordinate{27.5229, 53.0143}, CountryId{"BY"}}, // Slutsk
    {Coordinate{30.1558, 54.6281}, CountryId{"BY"}}, // Smal′yany
    {Coordinate{27.5494, 52.7944}, CountryId{"BY"}}, // Solihorsk railway station
    {Coordinate{28.8339, 55.48}, CountryId{"BY"}}, // Sosnitsa
    {Coordinate{29.8861, 55.2278}, CountryId{"BY"}}, // Staroye Syalo
    {Coordinate{30.0942, 53.1992}, CountryId{"BY"}}, // Starasyel′ski
    {Coordinate{28.1372, 52.2536}, CountryId{"BY"}}, // Starushki
    {Coordinate{27.6629, 53.9149}, CountryId{"BY"}}, // Stsyapyanka
    {Coordinate{28.8233, 53.2572}, CountryId{"BY"}}, // Tatarka
    {Coordinate{31.2419, 54.0989}, CountryId{"BY"}}, // Q28380797
    {Coordinate{31.1016, 52.2138}, CountryId{"BY"}}, // Tsyerukha
    {Coordinate{27.0358, 53.0867}, CountryId{"BY"}}, // Tsimkavichy
    {Coordinate{29.7556, 54.4022}, CountryId{"BY"}}, // Talachyn
    {Coordinate{30.8183, 52.5969}, CountryId{"BY"}}, // Uza
    {Coordinate{27.9086, 52.9519}, CountryId{"BY"}}, // Urechcha
    {Coordinate{31.0806, 52.3058}, CountryId{"BY"}}, // Uts′
    {Coordinate{28.3283, 53.1214}, CountryId{"BY"}}, // Falichy
    {Coordinate{28.5839, 55.4244}, CountryId{"BY"}}, // Farynava
    {Coordinate{30.1972, 52.8528}, CountryId{"BY"}}, // Khal′ch
    {Coordinate{30.4335, 54.5952}, CountryId{"BY"}}, // Khlusava
    {Coordinate{30.5667, 54.6208}, CountryId{"BY"}}, // Khlyustsina
    {Coordinate{31.4828, 53.9289}, CountryId{"BY"}}, // Khodasy
    {Coordinate{30.9056, 52.4306}, CountryId{"BY"}}, // Tsentralit
    {Coordinate{30.9317, 53.7806}, CountryId{"BY"}}, // Chavusy
    {Coordinate{29.1422, 54.8336}, CountryId{"BY"}}, // Q28380841
    {Coordinate{30.1397, 55.21}, CountryId{"BY"}}, // Chepina
    {Coordinate{30.3236, 54.4444}, CountryId{"BY"}}, // Chervina
    {Coordinate{27.4722, 55.3689}, CountryId{"BY"}}, // Sharkawshchyna
    {Coordinate{29.6208, 55.3039}, CountryId{"BY"}}, // Shumilina
    {Coordinate{25.9171, 54.0642}, CountryId{"BY"}}, // Yuratsishki
    {Coordinate{29.7639, 55.2639}, CountryId{"BY"}}, // Yazvina
    {Coordinate{30.5889, 52.3681}, CountryId{"BY"}}, // Yakimawka
    {Coordinate{29.8208, 52.7236}, CountryId{"BY"}}, // Yashchytsy
    {Coordinate{23.3545, 52.4599}, CountryId{"BY"}}, // Q28381011
    {Coordinate{2.50652, 48.8973}, CountryId{"FR"}}, // Allée de la Tour - Rendez-Vous railway station
    {Coordinate{-0.177779, 45.6711}, CountryId{"FR"}}, // Q2839048
    {Coordinate{78.4991, 9.85297}, CountryId{"IN"}}, // Sivaganga railway station
    {Coordinate{4.6513, 50.7784}, CountryId{"BE"}}, // Pécrot railway station
    {Coordinate{49.1747, 55.8064}, CountryId{"RU"}}, // Q28415
    {Coordinate{5.85204, 47.1185}, CountryId{"FR"}}, // Q2841574
    {Coordinate{49.1678, 55.7778}, CountryId{"RU"}}, // Ometevo
    {Coordinate{80.6476, 16.5254}, CountryId{"IN"}}, // Madhura Nagar railway station
    {Coordinate{6.0855, 44.564}, CountryId{"FR"}}, // Gare de Gap
    {Coordinate{-3.68791, 40.4053}, CountryId{"ES"}}, // Madrid Atocha Railway Station
    {Coordinate{2.04774, 47.4252}, CountryId{"FR"}}, // Gare de Salbris
    {Coordinate{4.46722, 51.3789}, CountryId{"BE"}}, // Kijkuit railway station
    {Coordinate{1.77111, 50.8161}, CountryId{"FR"}}, // Gare du Haut-Banc
    {Coordinate{80.6797, 16.5262}, CountryId{"IN"}}, // Ramavarappadu railway station
    {Coordinate{82.1115, 22.1025}, CountryId{"IN"}}, // Uslapur railway station
    {Coordinate{79.0234, 28.7789}, CountryId{"IN"}}, // Rampur Junction railway station
    {Coordinate{4.51528, 50.7256}, CountryId{"BE"}}, // Genval railway station
    {Coordinate{4.44694, 51.1822}, CountryId{"BE"}}, // Mortsel-Deurnesteenweg railway station
    {Coordinate{4.74611, 51.1656}, CountryId{"BE"}}, // Bouwel railway station
    {Coordinate{37.3075, 47.9892}, CountryId{"UA"}}, // Q28469460
    {Coordinate{9.1199, 39.428}, CountryId{"IT"}}, // Donori railway station
    {Coordinate{-1.89738, 48.1405}, CountryId{"FR"}}, // Q2847254
    {Coordinate{8.02217, 49.039}, CountryId{"DE"}}, // Q28475391
    {Coordinate{5.76944, 49.5131}, CountryId{"FR"}}, // Longwy railway station
    {Coordinate{2.24095, 48.8149}, CountryId{"FR"}}, // Gare de Meudon
    {Coordinate{7.3024, 47.913}, CountryId{"FR"}}, // Gare de Merxheim
    {Coordinate{6.63002, 51.3377}, CountryId{"DE"}}, // Krefeld-Linn station
    {Coordinate{11.0376, 48.1059}, CountryId{"DE"}}, // Geltendorf station
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28491312
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28491321
    {Coordinate{116.421, 39.9022}, CountryId{"CN"}}, // Beijing railway station
    {Coordinate{22.055, 50.5703}, CountryId{"PL"}}, // Q2853323
    {Coordinate{7.3118, 48.5247}, CountryId{"FR"}}, // Mullerhof
    {Coordinate{40.6014, 61.025}, CountryId{"RU"}}, // Q28548181
    {Coordinate{40.5836, 64.1531}, CountryId{"RU"}}, // Q28548199
    {Coordinate{75.1138, 53.8795}, CountryId{"RU"}}, // Q28548206
    {Coordinate{74.441, 54.1602}, CountryId{"RU"}}, // Q28548209
    {Coordinate{43.9814, 56.2517}, CountryId{"RU"}}, // Q28548212
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28548524
    {Coordinate{40.4242, 60.9972}, CountryId{"RU"}}, // Q28548602
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28548607
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28548612
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28548637
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28548660
    {Coordinate{35.4289, 47.9422}, CountryId{"UA"}}, // Q28548757
    {Coordinate{2.61806, 48.8061}, CountryId{"FR"}}, // Émerainville – Pontault-Combault (Paris RER)
    {Coordinate{8.68611, 50.0994}, CountryId{"DE"}}, // Frankfurt South station
    {Coordinate{3.96967, 51.0019}, CountryId{"BE"}}, // Wichelen railway station
    {Coordinate{2.37682, 48.8298}, CountryId{"FR"}}, // Bibliothèque François Mitterrand Station
    {Coordinate{8.79833, 47.98}, CountryId{"DE"}}, // Tuttlingen station
    {Coordinate{5.37917, 49.92}, CountryId{"BE"}}, // Libramont railway station
    {Coordinate{3.19142, 51.3059}, CountryId{"BE"}}, // Zwankendamme railway station
    {Coordinate{-0.94606, 44.3293}, CountryId{"FR"}}, // Ychoux
    {Coordinate{6.42494, 46.3033}, CountryId{"FR"}}, // Perrignier
    {Coordinate{6.16401, 49.2536}, CountryId{"FR"}}, // Q2859801
    {Coordinate{7.8837, 49.2094}, CountryId{"DE"}}, // Railway station Wilgartswiesen
    {Coordinate{3.90633, 50.4875}, CountryId{"BE"}}, // Ghlin railway station
    {Coordinate{1.20528, 45.5192}, CountryId{"FR"}}, // Gare de Saint-Yrieix-la-Perche
    {Coordinate{11.7846, 51.763}, CountryId{"DE"}}, // Bahnhof Baalberge
    {Coordinate{7.86694, 48.0422}, CountryId{"DE"}}, // Q28656485
    {Coordinate{9.13213, 39.5589}, CountryId{"IT"}}, // Suelli railway station
    {Coordinate{-0.391566, 44.9141}, CountryId{"FR"}}, // Saint-Sulpice - Izon
    {Coordinate{10.0251, 47.554}, CountryId{"DE"}}, // Q28661170
    {Coordinate{5.97142, 49.2162}, CountryId{"FR"}}, // Q2866372
    {Coordinate{52.2514, 55.8211}, CountryId{"RU"}}, // Q28667351
    {Coordinate{44.0196, 56.199}, CountryId{"RU"}}, // Q28667363
    {Coordinate{40.2475, 61.9328}, CountryId{"RU"}}, // Q28667397
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28667399
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28667400
    {Coordinate{57.5165, 55.0555}, CountryId{"RU"}}, // Q28667403
    {Coordinate{57.7057, 55.0564}, CountryId{"RU"}}, // Q28667404
    {Coordinate{40.2475, 61.9327}, CountryId{"RU"}}, // Q28667407
    {Coordinate{29.9337, 56.0189}, CountryId{"RU"}}, // Q28667455
    {Coordinate{37.0247, 52.2192}, CountryId{"RU"}}, // Q28667471
    {Coordinate{35.4852, 54.9474}, CountryId{"RU"}}, // Koshnyaki
    {Coordinate{60.6744, 56.8714}, CountryId{"RU"}}, // Q28667498
    {Coordinate{33.3, 58.4074}, CountryId{"RU"}}, // Q28667505
    {Coordinate{33.4755, 58.4869}, CountryId{"RU"}}, // Q28667507
    {Coordinate{33.3427, 59.122}, CountryId{"RU"}}, // Q28667521
    {Coordinate{57.7586, 56.598}, CountryId{"RU"}}, // Krasnoufimsk rail station
    {Coordinate{60.8789, 57.0503}, CountryId{"RU"}}, // Monetnaya
    {Coordinate{61.7172, 57.9408}, CountryId{"RU"}}, // Q28667640
    {Coordinate{42.3814, 52.6486}, CountryId{"RU"}}, // Q28667675
    {Coordinate{131.966, 43.8547}, CountryId{"RU"}}, // Q28667690
    {Coordinate{92.7623, 56.0426}, CountryId{"RU"}}, // Bugach station
    {Coordinate{134.05, 46.3436}, CountryId{"RU"}}, // Q28667699
    {Coordinate{34.5694, 64.9553}, CountryId{"RU"}}, // Q28667740
    {Coordinate{60.8197, 56.7614}, CountryId{"RU"}}, // Q28667753
    {Coordinate{30.6481, 59.5797}, CountryId{"RU"}}, // Q28667755
    {Coordinate{43.3508, 47.7286}, CountryId{"RU"}}, // Q28667766
    {Coordinate{90.8928, 53.3967}, CountryId{"RU"}}, // Q28667802
    {Coordinate{60.9475, 56.7133}, CountryId{"RU"}}, // Q28667848
    {Coordinate{11.8647, 43.5268}, CountryId{"IT"}}, // Giovi railway station
    {Coordinate{15.6482, 38.121}, CountryId{"IT"}}, // Q28668108
    {Coordinate{15.5248, 38.1905}, CountryId{"IT"}}, // Q28668411
    {Coordinate{17.2225, 52.3933}, CountryId{"PL"}}, // Kostrzyn Wielkopolski
    {Coordinate{15.6785, 41.0732}, CountryId{"IT"}}, // Q28670098
    {Coordinate{16.5872, 38.9091}, CountryId{"IT"}}, // Q28670343
    {Coordinate{14.3232, 41.2656}, CountryId{"IT"}}, // Q28671077
    {Coordinate{14.313, 41.2711}, CountryId{"IT"}}, // Q28671079
    {Coordinate{14.245, 41.0862}, CountryId{"IT"}}, // Q28671081
    {Coordinate{3.84344, 50.1973}, CountryId{"FR"}}, // Gare d'Aulnoye-Aymeries
    {Coordinate{16.6191, 47.6416}, CountryId{"HU"}}, // Harka train station
    {Coordinate{16.6197, 47.6039}, CountryId{"AT"}}, // Deutschkreutz railway station
    {Coordinate{4.23572, 47.283}, CountryId{"FR"}}, // Q2868757
    {Coordinate{2.18333, 48.7994}, CountryId{"FR"}}, // Chaville-Vélizy
    {Coordinate{25.9193, 48.3163}, CountryId{"UA"}}, // Q28703958
    {Coordinate{25.9581, 48.265}, CountryId{"UA"}}, // Q28704076
    {Coordinate{30.7422, 50.0703}, CountryId{"UA"}}, // Hordyn
    {Coordinate{38.0633, 47.6678}, CountryId{"UA"}}, // Q28704397
    {Coordinate{37.1755, 49.6944}, CountryId{"UA"}}, // Q28704776
    {Coordinate{24.5237, 50.1949}, CountryId{"UA"}}, // Q28705359
    {Coordinate{32.2828, 49.9306}, CountryId{"UA"}}, // Q28705406
    {Coordinate{33.2866, 49.3267}, CountryId{"UA"}}, // Q28706380
    {Coordinate{34.9628, 48.4393}, CountryId{"UA"}}, // Q28706457
    {Coordinate{25.793, 48.4072}, CountryId{"UA"}}, // Q28706475
    {Coordinate{25.7699, 48.4765}, CountryId{"UA"}}, // Q28706479
    {Coordinate{38.5853, 47.7447}, CountryId{"UA"}}, // Q28706610
    {Coordinate{31.1631, 49.001}, CountryId{"UA"}}, // Stetsivka
    {Coordinate{38.4797, 47.8008}, CountryId{"UA"}}, // Q28706730
    {Coordinate{37.4407, 49.9428}, CountryId{"UA"}}, // Q28706792
    {Coordinate{37.4119, 49.8475}, CountryId{"UA"}}, // Q28706793
    {Coordinate{37.5231, 49.8265}, CountryId{"UA"}}, // Q28706812
    {Coordinate{37.4458, 49.6782}, CountryId{"UA"}}, // Q28706815
    {Coordinate{36.7425, 49.7711}, CountryId{"UA"}}, // Q28706822
    {Coordinate{36.5644, 49.8278}, CountryId{"UA"}}, // Q28706854
    {Coordinate{37.6442, 49.6543}, CountryId{"UA"}}, // Q28706883
    {Coordinate{36.6727, 49.8196}, CountryId{"UA"}}, // Chuhuiv
    {Coordinate{24.3571, 50.0989}, CountryId{"UA"}}, // Q28707402
    {Coordinate{34.9811, 50.4517}, CountryId{"UA"}}, // Q28707714
    {Coordinate{34.3783, 48.0833}, CountryId{"UA"}}, // Q28707750
    {Coordinate{34.1714, 47.9728}, CountryId{"UA"}}, // Q28707757
    {Coordinate{34.0331, 47.8717}, CountryId{"UA"}}, // Q28707769
    {Coordinate{33.8608, 47.7825}, CountryId{"UA"}}, // Q28707772
    {Coordinate{0.041691, 46.4188}, CountryId{"FR"}}, // Q2871831
    {Coordinate{9.58639, 62.4928}, CountryId{"NO"}}, // Engan stoppested
    {Coordinate{9.63333, 62.5339}, CountryId{"NO"}}, // Driva stasjon
    {Coordinate{10.2383, 62.9872}, CountryId{"NO"}}, // Snøan Station
    {Coordinate{-0.050105, 45.5999}, CountryId{"FR"}}, // Q2872674
    {Coordinate{12.0417, 45.2949}, CountryId{"IT"}}, // Piove di Sacco railway station
    {Coordinate{8.85799, 50.1205}, CountryId{"DE"}}, // Mühlheim-Dietesheim station
    {Coordinate{9.15202, 39.6934}, CountryId{"IT"}}, // Serri railway station
    {Coordinate{2.38444, 48.9239}, CountryId{"FR"}}, // La Courneuve – Aubervilliers Station
    {Coordinate{}, CountryId{"DE"}}, // Q28754089
    {Coordinate{2.83807, 50.5419}, CountryId{"FR"}}, // Gare de Salomé
    {Coordinate{5.33838, 46.0116}, CountryId{"FR"}}, // Q2876103
    {Coordinate{10.6666, 44.69}, CountryId{"IT"}}, // Reggio San Lazzaro railway station
    {Coordinate{-0.42995, 39.2842}, CountryId{"ES"}}, // Q2878333
    {Coordinate{-4.25626, 48.4537}, CountryId{"FR"}}, // Gare de Landerneau
    {Coordinate{9.24685, 39.6934}, CountryId{"IT"}}, // Orroli railway station
    {Coordinate{9.22956, 39.7212}, CountryId{"IT"}}, // Nurri railway station
    {Coordinate{9.26309, 39.7536}, CountryId{"IT"}}, // Betilli railway station
    {Coordinate{}, CountryId{"DE"}}, // Q28806114
    {Coordinate{}, CountryId{"DE"}}, // Q28806129
    {Coordinate{7.60631, 51.5293}, CountryId{"DE"}}, // Dortmund-Wickede West station
    {Coordinate{8.41556, 58.5997}, CountryId{"NO"}}, // Hynnekleiv train station
    {Coordinate{5.78444, 45.1847}, CountryId{"FR"}}, // Gare de Grenoble-Universités-Gières
    {Coordinate{9.25596, 39.7884}, CountryId{"IT"}}, // Esterzili railway station
    {Coordinate{5.5951, 48.0541}, CountryId{"FR"}}, // Q2882529
    {Coordinate{20.1746, 47.9156}, CountryId{"HU"}}, // Sirok railway station
    {Coordinate{9.26967, 39.8152}, CountryId{"IT"}}, // Sadali-Seulo railway station
    {Coordinate{9.32643, 39.8369}, CountryId{"IT"}}, // Seui railway station
    {Coordinate{9.44093, 39.8341}, CountryId{"IT"}}, // Ussassai railway station
    {Coordinate{-7.50341, 42.5295}, CountryId{"ES"}}, // Monforte de Lemos railway station
    {Coordinate{3.2557, 48.5294}, CountryId{"FR"}}, // Gare de Sainte-Colombe-Septveilles
    {Coordinate{14.2736, 41.1452}, CountryId{"IT"}}, // Pontelatone railway station
    {Coordinate{8.4835, 52.5547}, CountryId{"DE"}}, // Syke railway station
    {Coordinate{7.35939, 46.2274}, CountryId{"CH"}}, // Sion railway station
    {Coordinate{5.81, 50.5447}, CountryId{"BE"}}, // Juslenville railway station
    {Coordinate{3.8375, 50.8839}, CountryId{"BE"}}, // Hillegem railway station
    {Coordinate{7.43944, 46.9497}, CountryId{"CH"}}, // Bern railway station
    {Coordinate{-1.21737, 37.9641}, CountryId{"ES"}}, // Alcantarilla-Los Romanos
    {Coordinate{9.47626, 39.9195}, CountryId{"IT"}}, // Villagrande railway station
    {Coordinate{37.1845, 48.2844}, CountryId{"UA"}}, // Pokrovsk
    {Coordinate{4.61361, 50.9661}, CountryId{"BE"}}, // Haacht railway station
    {Coordinate{14.33, 50.045}, CountryId{"CZ"}}, // Lužiny
    {Coordinate{9.50932, 39.902}, CountryId{"IT"}}, // Arzana railway station
    {Coordinate{2.15361, 48.7964}, CountryId{"FR"}}, // gare de Porchefontaine
    {Coordinate{2.30417, 48.7619}, CountryId{"FR"}}, // Gare de La Croix de Berny
    {Coordinate{16.2661, 39.288}, CountryId{"IT"}}, // Cosenza Casali railway station
    {Coordinate{16.3283, 39.2398}, CountryId{"IT"}}, // Q28941040
    {Coordinate{16.3223, 39.2328}, CountryId{"IT"}}, // Q28941048
    {Coordinate{16.3264, 39.228}, CountryId{"IT"}}, // Q28941088
    {Coordinate{16.3117, 39.2111}, CountryId{"IT"}}, // Q28941124
    {Coordinate{16.3221, 39.1809}, CountryId{"IT"}}, // Rogliano railway station
    {Coordinate{16.3044, 39.1682}, CountryId{"IT"}}, // Marzi railway station
    {Coordinate{14.8439, 40.8345}, CountryId{"IT"}}, // Q28942313
    {Coordinate{6.38778, 48.3072}, CountryId{"FR"}}, // Q289445
    {Coordinate{5.88036, 48.6792}, CountryId{"FR"}}, // Toul railway station
    {Coordinate{54.6545, 58.0784}, CountryId{"RU"}}, // Q28974621
    {Coordinate{1.04604, 46.1253}, CountryId{"FR"}}, // Q2898331
    {Coordinate{73.3934, 22.5419}, CountryId{"IN"}}, // Champaner Road railway station
    {Coordinate{83.8132, 24.1752}, CountryId{"IN"}}, // Garhwa railway station
    {Coordinate{78.1311, 17.4508}, CountryId{"IN"}}, // Shankarpalli railway station
    {Coordinate{91.8333, 26.1821}, CountryId{"IN"}}, // Narangi railway station
    {Coordinate{91.7922, 26.1817}, CountryId{"IN"}}, // New Guwahati railway station
    {Coordinate{91.6139, 26.0993}, CountryId{"IN"}}, // Azara railway station
    {Coordinate{}, CountryId{"IN"}}, // Amin Gaon railway station
    {Coordinate{91.686, 26.2009}, CountryId{"IN"}}, // Agthori railway station
    {Coordinate{91.6861, 26.1713}, CountryId{"IN"}}, // Pandu railway station
    {Coordinate{76.8075, 30.5176}, CountryId{"IN"}}, // Dappar railway station
    {Coordinate{}, CountryId{"IN"}}, // Dholakhal railway station
    {Coordinate{}, CountryId{"IN"}}, // Kaimai Road railway station
    {Coordinate{}, CountryId{"IN"}}, // Kambiron railway station
    {Coordinate{}, CountryId{"IN"}}, // Thingu railway station
    {Coordinate{}, CountryId{"IN"}}, // Khongsang railway station
    {Coordinate{}, CountryId{"IN"}}, // Noney railway station
    {Coordinate{}, CountryId{"IN"}}, // Tupul railway station
    {Coordinate{}, CountryId{"IN"}}, // Phayeng railway station
    {Coordinate{}, CountryId{"IN"}}, // Imphal railway station
    {Coordinate{92.0353, 24.1513}, CountryId{"IN"}}, // Kumarghat railway station
    {Coordinate{85.4241, 25.0504}, CountryId{"IN"}}, // Sardar Patel Halt railway station
    {Coordinate{0.215912, 49.582}, CountryId{"FR"}}, // Gare de Rolleville
    {Coordinate{74.6008, 30.962}, CountryId{"IN"}}, // Firozpur city railway station
    {Coordinate{82.0356, 21.155}, CountryId{"IN"}}, // Belsonda railway station
    {Coordinate{}, CountryId{"IN"}}, // Dronagiri railway station
    {Coordinate{}, CountryId{"IN"}}, // Nhava Sheva railway station
    {Coordinate{}, CountryId{"IN"}}, // Ranjanpada railway station
    {Coordinate{}, CountryId{"IN"}}, // Gavan railway station
    {Coordinate{}, CountryId{"IN"}}, // Kharkopar railway station
    {Coordinate{73.0243, 18.9752}, CountryId{"IN"}}, // Baman Dongari railway station
    {Coordinate{}, CountryId{"IN"}}, // Targhar railway station
    {Coordinate{}, CountryId{"IN"}}, // Sagar Sangam railway station
    {Coordinate{91.2774, 23.7437}, CountryId{"IN"}}, // Sekerkote railway station
    {Coordinate{91.2731, 23.6767}, CountryId{"IN"}}, // Bishalgarh railway station
    {Coordinate{91.3606, 23.5983}, CountryId{"IN"}}, // Bishramganj railway station
    {Coordinate{91.5323, 23.322}, CountryId{"IN"}}, // Santir Bazar railway station
    {Coordinate{91.4967, 23.4322}, CountryId{"IN"}}, // Garji railway station
    {Coordinate{91.5964, 23.1908}, CountryId{"IN"}}, // Jolaibari railway station
    {Coordinate{91.6461, 23.0619}, CountryId{"IN"}}, // Manu Bazar railway station
    {Coordinate{91.7014, 23.014}, CountryId{"IN"}}, // Sabroom railway station
    {Coordinate{79.9031, 23.1688}, CountryId{"IN"}}, // Kachhpura railway station
    {Coordinate{79.9322, 23.1563}, CountryId{"IN"}}, // Howbagh Jabalpur railway station
    {Coordinate{79.9377, 23.11}, CountryId{"IN"}}, // Gwarighat railway station
    {Coordinate{73.6037, 22.777}, CountryId{"IN"}}, // Godhra Junction railway station
    {Coordinate{94.2171, 26.7507}, CountryId{"IN"}}, // Jorhat Town railway station
    {Coordinate{81.5503, 20.7145}, CountryId{"IN"}}, // Dhamtari railway station
    {Coordinate{81.7453, 21.0519}, CountryId{"IN"}}, // Abhanpur Junction railway station
    {Coordinate{81.7837, 21.0048}, CountryId{"IN"}}, // Manik Chauree Halt railway station
    {Coordinate{81.8674, 20.9695}, CountryId{"IN"}}, // Rajim railway station
    {Coordinate{81.7946, 21.5507}, CountryId{"IN"}}, // Tilda railway station
    {Coordinate{81.6712, 21.2366}, CountryId{"IN"}}, // Telibandha railway station
    {Coordinate{81.6481, 21.2533}, CountryId{"IN"}}, // Raipur City railway station
    {Coordinate{}, CountryId{"IN"}}, // Pattakudi railway station
    {Coordinate{93.1653, 26.7697}, CountryId{"IN"}}, // Biswanath Charali railway station
    {Coordinate{73.7992, 15.4089}, CountryId{"IN"}}, // Marmagao railway station
    {Coordinate{73.8514, 15.3873}, CountryId{"IN"}}, // Dabolim railway station
    {Coordinate{73.8677, 15.3708}, CountryId{"IN"}}, // Sankval railway station
    {Coordinate{73.8972, 15.3445}, CountryId{"IN"}}, // Cansaulim railway station
    {Coordinate{74.0478, 15.2648}, CountryId{"IN"}}, // Chandar railway station
    {Coordinate{74.0108, 15.2657}, CountryId{"IN"}}, // San Juje Da Areyal railway station
    {Coordinate{74.1888, 15.2933}, CountryId{"IN"}}, // Kalem railway station
    {Coordinate{74.2442, 15.334}, CountryId{"IN"}}, // Kulem railway station
    {Coordinate{74.2986, 15.3094}, CountryId{"IN"}}, // Sonalium railway station
    {Coordinate{74.3127, 15.3128}, CountryId{"IN"}}, // Dudh Sagar Water Fall railway station
    {Coordinate{74.3064, 15.3166}, CountryId{"IN"}}, // Dudh Sagar railway station
    {Coordinate{74.3062, 15.3607}, CountryId{"IN"}}, // Caranzol railway station
    {Coordinate{}, CountryId{"IN"}}, // Reasi railway station
    {Coordinate{}, CountryId{"IN"}}, // Sangaldan railway station
    {Coordinate{}, CountryId{"IN"}}, // Nachlana railway station
    {Coordinate{94.1108, 27.2543}, CountryId{"IN"}}, // North Lakhimpur railway station
    {Coordinate{76.3496, 31.3788}, CountryId{"IN"}}, // Naya Nangal railway station
    {Coordinate{76.1104, 31.6707}, CountryId{"IN"}}, // Amb Andaura railway station
    {Coordinate{12.3673, 50.7257}, CountryId{"DE"}}, // Werdau station
    {Coordinate{11.2814, 50.896}, CountryId{"DE"}}, // Q29043546
    {Coordinate{10.025, 47.6203}, CountryId{"DE"}}, // Röthenbach (Allgäu) railway station
    {Coordinate{6.38167, 45.6731}, CountryId{"FR"}}, // Gare d'Albertville
    {Coordinate{1.93979, 48.1935}, CountryId{"FR"}}, // Gare de Toury
    {Coordinate{1.98298, 48.9817}, CountryId{"FR"}}, // Gare de Vernouillet - Verneuil
    {Coordinate{-1.74944, 47.9714}, CountryId{"FR"}}, // Q2910832
    {Coordinate{7.64368, 51.5417}, CountryId{"DE"}}, // Massen station
    {Coordinate{8.7075, 47.2083}, CountryId{"CH"}}, // Richterswil railway station
    {Coordinate{2.311, 42.5616}, CountryId{"FR"}}, // Gare de Joncet
    {Coordinate{24.3373, 57.182}, CountryId{"LV"}}, // Lilaste Station
    {Coordinate{3.47876, 50.3902}, CountryId{"FR"}}, // Q2913331
    {Coordinate{6.7724, 45.9088}, CountryId{"FR"}}, // Q2913384
    {Coordinate{-1.46613, 48.1122}, CountryId{"FR"}}, // Q2913679
    {Coordinate{3.18835, 50.3613}, CountryId{"FR"}}, // Gare de Montigny-en-Ostrevent
    {Coordinate{5.71333, 53.13}, CountryId{"NL"}}, // Mantgum railway station
    {Coordinate{2.9058, 48.8596}, CountryId{"FR"}}, // Gare de Crécy-la-Chapelle
    {Coordinate{4.22917, 51.0144}, CountryId{"BE"}}, // Malderen railway station
    {Coordinate{-3.52778, 37.3958}, CountryId{"ES"}}, // Q2918573
    {Coordinate{5.90132, 45.2626}, CountryId{"FR"}}, // Brignoud
    {Coordinate{2.03219, 42.4569}, CountryId{"FR"}}, // Gare de Saillagouse
    {Coordinate{8.01307, 47.5073}, CountryId{"CH"}}, // Frick railway station
    {Coordinate{9.70748, 39.9386}, CountryId{"IT"}}, // Arbatax railway station
    {Coordinate{4.36361, 50.5358}, CountryId{"BE"}}, // Obaix-Buzet railway station
    {Coordinate{5.49611, 50.9669}, CountryId{"BE"}}, // Genk railway station
    {Coordinate{5.75008, 43.1404}, CountryId{"FR"}}, // Q2931894
    {Coordinate{9.49638, 39.822}, CountryId{"IT"}}, // Osini-Ulassai railway station
    {Coordinate{5.57363, 50.5399}, CountryId{"BE"}}, // Hony railway station
    {Coordinate{1.40147, 43.5956}, CountryId{"FR"}}, // Station of TOEC
    {Coordinate{13.02, 58.0789}, CountryId{"SE"}}, // Herrljunga railway station
    {Coordinate{13.335, 58.1392}, CountryId{"SE"}}, // Floby railway station
    {Coordinate{13.0533, 57.9867}, CountryId{"SE"}}, // Ljung railway station
    {Coordinate{16.7031, 41.0239}, CountryId{"IT"}}, // Q29366570
    {Coordinate{16.7108, 41.0514}, CountryId{"IT"}}, // Palo del Colle train station
    {Coordinate{16.6841, 40.996}, CountryId{"IT"}}, // Q29366652
    {Coordinate{4.77261, 45.5958}, CountryId{"FR"}}, // Q2936724
    {Coordinate{7.90778, 47.3519}, CountryId{"CH"}}, // Olten railway station
    {Coordinate{9.21998, 49.1887}, CountryId{"DE"}}, // Neckarsulm station
    {Coordinate{7.362, 48.7446}, CountryId{"FR"}}, // Gare de Saverne
    {Coordinate{10.906, 43.6944}, CountryId{"IT"}}, // Ponte a Elsa
    {Coordinate{10.9452, 43.6523}, CountryId{"IT"}}, // Granaiolo railway station
    {Coordinate{19.156, 63.3441}, CountryId{"SE"}}, // Husum railway station
    {Coordinate{18.7153, 63.3027}, CountryId{"SE"}}, // Örnsköldsvik north station
    {Coordinate{17.7447, 63.0526}, CountryId{"SE"}}, // Västeraspby railway station
    {Coordinate{19.4851, 63.5786}, CountryId{"SE"}}, // Nordmaling railway station
    {Coordinate{19.9101, 63.6329}, CountryId{"SE"}}, // Hörnefors railway station
    {Coordinate{2.48583, 48.8703}, CountryId{"FR"}}, // Rosny-sous-Bois station
    {Coordinate{14.3078, 59.6235}, CountryId{"SE"}}, // Nykroppa railway station
    {Coordinate{6.82417, 45.8987}, CountryId{"FR"}}, // Q2942136
    {Coordinate{38.0833, 50.2032}, CountryId{"RU"}}, // Q2943934
    {Coordinate{5.52791, 46.1847}, CountryId{"FR"}}, // Gare de Nurieux
    {Coordinate{8.04257, 49.2093}, CountryId{"DE"}}, // Siebeldingen-Birkweiler station
    {Coordinate{79.918, 21.415}, CountryId{"IN"}}, // Tirora railway station
    {Coordinate{9.5027, 49.2032}, CountryId{"DE"}}, // Öhringen Central Station
    {Coordinate{}, CountryId{"DE"}}, // Q29478870
    {Coordinate{4.46889, 50.3928}, CountryId{"BE"}}, // Couillet railway station
    {Coordinate{3.79111, 50.9706}, CountryId{"BE"}}, // Landskouter railway station
    {Coordinate{7.30329, 51.4782}, CountryId{"DE"}}, // Bochum-Langendreer West station
    {Coordinate{1.46667, 44.9022}, CountryId{"FR"}}, // Gare de Souillac
    {Coordinate{1.75583, 49.765}, CountryId{"FR"}}, // Gare d'Aumale
    {Coordinate{2.34528, 48.935}, CountryId{"FR"}}, // Gare de Saint-Denis
    {Coordinate{9.69, 60.2911}, CountryId{"NO"}}, // Ørgenvika Station
    {Coordinate{2.98152, 50.3274}, CountryId{"FR"}}, // Gare de Vitry-en-Artois
    {Coordinate{5.82561, 48.1087}, CountryId{"FR"}}, // Q2952673
    {Coordinate{1.72222, 49.6539}, CountryId{"FR"}}, // Gare de Formerie
    {Coordinate{11.2627, 58.9222}, CountryId{"SE"}}, // Skee railway station
    {Coordinate{4.33528, 50.6006}, CountryId{"BE"}}, // Nivelles railway station
    {Coordinate{11.2958, 58.7134}, CountryId{"SE"}}, // Tanum railway station
    {Coordinate{11.2598, 58.843}, CountryId{"SE"}}, // Överby railway station
    {Coordinate{7.08496, 48.9359}, CountryId{"FR"}}, // Q2955054
    {Coordinate{14.1279, 58.7056}, CountryId{"SE"}}, // Töreboda railway station
    {Coordinate{14.3334, 58.872}, CountryId{"SE"}}, // Gårdsjö railway station
    {Coordinate{14.2152, 58.8548}, CountryId{"SE"}}, // Hova railway station
    {Coordinate{11.485, 43.3069}, CountryId{"IT"}}, // Castelnuovo Berardenga railway station
    {Coordinate{11.7877, 43.1742}, CountryId{"IT"}}, // Torrita di Siena railway station
    {Coordinate{2.02742, 41.3094}, CountryId{"ES"}}, // Viladecans
    {Coordinate{5.18556, 50.9642}, CountryId{"BE"}}, // Schulen railway station
    {Coordinate{1.82611, 49.7364}, CountryId{"FR"}}, // Gare de Fouilloy
    {Coordinate{6.72088, 49.0858}, CountryId{"FR"}}, // Q2958494
    {Coordinate{20.9911, 52.2258}, CountryId{"PL"}}, // Q2961989
    {Coordinate{4.18722, 50.9747}, CountryId{"BE"}}, // Opwijk railway station
    {Coordinate{15.7892, 50.0311}, CountryId{"CZ"}}, // Pardubice-Pardubičky
    {Coordinate{4.40111, 50.8678}, CountryId{"BE"}}, // Evere railway station
    {Coordinate{0.848908, 48.3838}, CountryId{"FR"}}, // Q2971091
    {Coordinate{9.08317, 47.3197}, CountryId{"CH"}}, // Lichtensteig station
    {Coordinate{14.4744, 50.1036}, CountryId{"CZ"}}, // Palmovka
    {Coordinate{6.89222, 51.0286}, CountryId{"DE"}}, // Köln-Chorweiler Nord
    {Coordinate{78.38, 14.85}, CountryId{"IN"}}, // Jammalamadugu railway station
    {Coordinate{7.64225, 48.7558}, CountryId{"FR"}}, // Mommenheim
    {Coordinate{5.14333, 52.0656}, CountryId{"NL"}}, // Utrecht Lunetten railway station
    {Coordinate{7.61835, 51.363}, CountryId{"DE"}}, // Bahnhof Letmathe
    {Coordinate{10.503, 43.5518}, CountryId{"IT"}}, // Fauglia-Lorenzana railway station
    {Coordinate{13.8989, 37.623}, CountryId{"IT"}}, // Q29918875
    {Coordinate{13.964, 37.5473}, CountryId{"IT"}}, // Mimiani-San Cataldo railway station
    {Coordinate{13.9977, 37.4697}, CountryId{"IT"}}, // Q29919038
    {Coordinate{13.8833, 37.4318}, CountryId{"IT"}}, // Q29919060
    {Coordinate{13.8851, 37.6685}, CountryId{"IT"}}, // Villalba railway station
    {Coordinate{13.8467, 37.6914}, CountryId{"IT"}}, // Vallelunga station
    {Coordinate{13.7199, 37.7174}, CountryId{"IT"}}, // Q29919133
    {Coordinate{14.4046, 50.0972}, CountryId{"CZ"}}, // Hradčanská
    {Coordinate{6.05944, 50.8761}, CountryId{"NL"}}, // Chevremont railway station
    {Coordinate{1.76889, 50.4661}, CountryId{"FR"}}, // Gare de Montreuil-sur-Mer
    {Coordinate{16.6971, 48.7747}, CountryId{"CZ"}}, // Sedlec u Mikulova
    {Coordinate{13.2906, 49.4736}, CountryId{"CZ"}}, // Švihov u Klatov
    {Coordinate{14.6422, 49.3953}, CountryId{"CZ"}}, // Horky u Tábora
    {Coordinate{15.9864, 50.5864}, CountryId{"CZ"}}, // Lhota u Trutnova
    {Coordinate{31.0637, 54.9469}, CountryId{"RU"}}, // Q29956810
    {Coordinate{2.27197, 42.5547}, CountryId{"FR"}}, // Gare d'Olette - Canaveilles-les-Bains
    {Coordinate{80.9388, 16.4688}, CountryId{"IN"}}, // Dosapadu railway station
    {Coordinate{2.0619, 48.8413}, CountryId{"FR"}}, // Gare de Noisy-le-Roi
    {Coordinate{11.7799, 51.6741}, CountryId{"DE"}}, // Könnern station
    {Coordinate{7.15247, 50.8137}, CountryId{"DE"}}, // Troisdorf station
    {Coordinate{6.37224, 49.4588}, CountryId{"FR"}}, // Apach
    {Coordinate{14.0141, 51.1882}, CountryId{"DE"}}, // Q30046682
    {Coordinate{12.6486, 51.1439}, CountryId{"DE"}}, // Bad Lausick station
    {Coordinate{7.62817, 48.5469}, CountryId{"FR"}}, // Entzheim-Aéroport Station
    {Coordinate{14.5262, 51.0343}, CountryId{"DE"}}, // Q30053133
    {Coordinate{13.5288, 50.7403}, CountryId{"DE"}}, // Q30055362
    {Coordinate{12.2443, 50.6113}, CountryId{"DE"}}, // Netzschkau railway station
    {Coordinate{12.3019, 50.548}, CountryId{"DE"}}, // Bahnhof Treuen
    {Coordinate{12.8126, 50.9157}, CountryId{"DE"}}, // Bahnhof Burgstädt
    {Coordinate{4.11806, 51.0217}, CountryId{"BE"}}, // Sint-Gillis railway station
    {Coordinate{11.1244, 62.4472}, CountryId{"NO"}}, // Håmålvoll Station
    {Coordinate{6.09111, 50.7681}, CountryId{"DE"}}, // Aachen Central Station
    {Coordinate{-3.11833, 47.4853}, CountryId{"FR"}}, // Gare de Quiberon
    {Coordinate{7.35702, 46.9046}, CountryId{"CH"}}, // Q30088642
    {Coordinate{7.66231, 47.5315}, CountryId{"CH"}}, // Schweizerhalle Station
    {Coordinate{2.31, 48.7703}, CountryId{"FR"}}, // Parc de Sceaux Station
    {Coordinate{12.9774, 52.9055}, CountryId{"DE"}}, // Herzberg (Mark) station
    {Coordinate{0.953728, 49.5492}, CountryId{"FR"}}, // Gare de Barentin
    {Coordinate{4.36858, 52.0892}, CountryId{"NL"}}, // Den Haag Mariahoeve railway station
    {Coordinate{6.51917, 52.3117}, CountryId{"NL"}}, // Rijssen railway station
    {Coordinate{8.50833, 49.2481}, CountryId{"DE"}}, // Bahnhof Waghäusel
    {Coordinate{4.35413, 50.7675}, CountryId{"BE"}}, // Holleken railway station
    {Coordinate{1.11065, 49.7916}, CountryId{"FR"}}, // Q3022757
    {Coordinate{8.25505, 50.2968}, CountryId{"DE"}}, // Q30238830
    {Coordinate{7.20163, 47.2198}, CountryId{"CH"}}, // Tavannes Station
    {Coordinate{7.22741, 47.2352}, CountryId{"CH"}}, // Reconvilier Station
    {Coordinate{7.27593, 47.2387}, CountryId{"CH"}}, // Malleray-Bévilard Station
    {Coordinate{8.90796, 49.236}, CountryId{"DE"}}, // Steinsfurt station
    {Coordinate{7.52833, 51.5719}, CountryId{"DE"}}, // Dortmund-Derne station
    {Coordinate{11.7588, 51.9057}, CountryId{"DE"}}, // Calbe (Saale) West station
    {Coordinate{13.3124, 52.4797}, CountryId{"DE"}}, // Berlin Heidelberger Platz station
    {Coordinate{8.34493, 48.2912}, CountryId{"DE"}}, // Q30303373
    {Coordinate{20.1077, 47.9317}, CountryId{"HU"}}, // Recsk-Parádfürdő railway station
    {Coordinate{20.078, 47.9464}, CountryId{"HU"}}, // Mátraderecske railway station
    {Coordinate{20.0241, 47.9846}, CountryId{"HU"}}, // Mátraballa railway station
    {Coordinate{19.9388, 47.9973}, CountryId{"HU"}}, // Mátramindszent railway station
    {Coordinate{19.902, 48.0038}, CountryId{"HU"}}, // Nemti railway station
    {Coordinate{20.1827, 47.9009}, CountryId{"HU"}}, // Kőkútpuszta railway station
    {Coordinate{20.1972, 47.8793}, CountryId{"HU"}}, // Tarnaszentmária railway station
    {Coordinate{20.2119, 47.8554}, CountryId{"HU"}}, // Verpelét railway station
    {Coordinate{20.2188, 47.8113}, CountryId{"HU"}}, // Feldebrő railway station
    {Coordinate{20.2243, 47.7843}, CountryId{"HU"}}, // Aldebrő railway station
    {Coordinate{20.235, 47.7608}, CountryId{"HU"}}, // Kápolna railway station
    {Coordinate{6.28176, 43.3172}, CountryId{"FR"}}, // Q3031449
    {Coordinate{88.2848, 23.7782}, CountryId{"IN"}}, // Plassey railway station
    {Coordinate{3.02306, 42.5464}, CountryId{"FR"}}, // Gare d'Argelès-sur-Mer
    {Coordinate{1.47987, 45.6099}, CountryId{"FR"}}, // Gare de Saint-Germain-les-Belles
    {Coordinate{4.37955, 50.8299}, CountryId{"BE"}}, // Mouterij railway station
    {Coordinate{9.38365, 53.9263}, CountryId{"DE"}}, // Q30340466
    {Coordinate{2.26067, 48.9314}, CountryId{"FR"}}, // Gare du Stade
    {Coordinate{-0.129777, 46.3809}, CountryId{"FR"}}, // Q3036487
    {Coordinate{8.78519, 50.008}, CountryId{"DE"}}, // Dietzenbach station
    {Coordinate{2.86827, 48.7345}, CountryId{"FR"}}, // Q3040113
    {Coordinate{1.87929, 48.0266}, CountryId{"FR"}}, // Gare de Chevilly
    {Coordinate{-2.07264, 47.3089}, CountryId{"FR"}}, // Donges
    {Coordinate{18.5468, 49.8603}, CountryId{"CZ"}}, // Q30531168
    {Coordinate{1.53822, 45.5742}, CountryId{"FR"}}, // Gare de La Porcherie
    {Coordinate{7.79691, 48.7178}, CountryId{"FR"}}, // Q305421
    {Coordinate{1.44394, 45.6288}, CountryId{"FR"}}, // Gare de Magnac-Vicq
    {Coordinate{4.06273, 46.0395}, CountryId{"FR"}}, // Gare de Roanne
    {Coordinate{5.20528, 52.13}, CountryId{"NL"}}, // Bilthoven railway station
    {Coordinate{76.0092, 23.0471}, CountryId{"IN"}}, // Naranjipur railway station
    {Coordinate{75.9793, 23.087}, CountryId{"IN"}}, // Undasa Madhopur railway station
    {Coordinate{85.4371, 25.0842}, CountryId{"IN"}}, // Silao railway station
    {Coordinate{76.7078, 21.964}, CountryId{"IN"}}, // Chhanera railway station
    {Coordinate{75.6082, 23.2313}, CountryId{"IN"}}, // Aslaoda railway station
    {Coordinate{76.0076, 23.2564}, CountryId{"IN"}}, // Shivpura railway station
    {Coordinate{80.7983, 26.8855}, CountryId{"IN"}}, // Kakori railway station
    {Coordinate{80.1089, 22.4257}, CountryId{"IN"}}, // Nainpur Junction railway station
    {Coordinate{79.8343, 22.907}, CountryId{"IN"}}, // Sukrimangela railway station
    {Coordinate{77.7684, 20.3213}, CountryId{"IN"}}, // Darwha Moti Bagh Junction railway station
    {Coordinate{80.0896, 21.0216}, CountryId{"IN"}}, // Gond Umri railway station
    {Coordinate{80.0958, 21.086}, CountryId{"IN"}}, // Sondad railway station
    {Coordinate{73.6359, 19.7229}, CountryId{"IN"}}, // Ghoti railway station
    {Coordinate{91.6939, 26.2621}, CountryId{"IN"}}, // Changsari railway station
    {Coordinate{76.8568, 14.7058}, CountryId{"IN"}}, // Rayadurg Junction railway station
    {Coordinate{78.5219, 14.7583}, CountryId{"IN"}}, // Proddatur railway station
    {Coordinate{73.4748, 27.5562}, CountryId{"IN"}}, // Nokha railway station
    {Coordinate{79.9261, 27.0265}, CountryId{"IN"}}, // Kannauj railway station
    {Coordinate{79.91, 27.0398}, CountryId{"IN"}}, // Kannauj City railway station
    {Coordinate{73.6955, 23.8672}, CountryId{"IN"}}, // Dungarpur railway station
    {Coordinate{74.0187, 24.6904}, CountryId{"IN"}}, // Vallabhnagar railway station
    {Coordinate{76.7004, 25.6755}, CountryId{"IN"}}, // Sheopur Kalan railway station
    {Coordinate{76.7496, 21.2963}, CountryId{"IN"}}, // Dhulghat railway station
    {Coordinate{75.9737, 22.3984}, CountryId{"IN"}}, // Mukhtiara Balwada railway station
    {Coordinate{75.9441, 22.4507}, CountryId{"IN"}}, // Choral railway station
    {Coordinate{76.074, 22.1781}, CountryId{"IN"}}, // Sanawad railway station
    {Coordinate{76.151, 22.1112}, CountryId{"IN"}}, // Nimar Kheri railway station
    {Coordinate{75.8593, 22.478}, CountryId{"IN"}}, // Kalakund railway station
    {Coordinate{76.1737, 22.0782}, CountryId{"IN"}}, // Kotla Kheri railway station
    {Coordinate{76.3891, 21.8786}, CountryId{"IN"}}, // Mathela railway station
    {Coordinate{76.4438, 21.9273}, CountryId{"IN"}}, // Talvadiya Junction railway station
    {Coordinate{76.4778, 22.0062}, CountryId{"IN"}}, // Khaigaon railway station
    {Coordinate{76.5442, 21.9461}, CountryId{"IN"}}, // Surgaon Banjari railway station
    {Coordinate{76.6426, 21.9388}, CountryId{"IN"}}, // Charkheda Khurd railway station
    {Coordinate{80.3944, 23.7872}, CountryId{"IN"}}, // Madhavnagar Road railway station
    {Coordinate{74.3764, 18.4821}, CountryId{"IN"}}, // Kedgaon railway station
    {Coordinate{}, CountryId{"IN"}}, // Jhabua railway station
    {Coordinate{74.3155, 18.4861}, CountryId{"IN"}}, // Khutbav railway station
    {Coordinate{74.4708, 18.4735}, CountryId{"IN"}}, // Patas railway station
    {Coordinate{74.4217, 18.4778}, CountryId{"IN"}}, // Kadethan railway station
    {Coordinate{85.2379, 25.5874}, CountryId{"IN"}}, // Patna Ghat railway station
    {Coordinate{85.2532, 25.5724}, CountryId{"IN"}}, // Deedarganj railway station
    {Coordinate{74.5209, 18.4687}, CountryId{"IN"}}, // Daund Patas Road railway station
    {Coordinate{85.0998, 25.6313}, CountryId{"IN"}}, // Rajiv Nagar railway station
    {Coordinate{85.1189, 25.55}, CountryId{"IN"}}, // Parsa Bazar railway station
    {Coordinate{85.1171, 25.6066}, CountryId{"IN"}}, // Bailey Road railway station
    {Coordinate{85.1174, 25.5962}, CountryId{"IN"}}, // Sachiwalay Halt railway station
    {Coordinate{85.1191, 25.6038}, CountryId{"IN"}}, // Old Sachdeva railway station
    {Coordinate{85.2978, 25.4739}, CountryId{"IN"}}, // Gokulnagar railway station
    {Coordinate{84.8985, 25.5648}, CountryId{"IN"}}, // Patel Halt railway station
    {Coordinate{84.7393, 26.7582}, CountryId{"IN"}}, // Sagauli Junction railway station
    {Coordinate{83.782, 26.5077}, CountryId{"IN"}}, // Deoria Sadar railway station
    {Coordinate{79.4037, 28.3557}, CountryId{"IN"}}, // Bareilly City railway station
    {Coordinate{79.4212, 28.3883}, CountryId{"IN"}}, // Izzatnagar railway station
    {Coordinate{79.6216, 27.3696}, CountryId{"IN"}}, // Fatehgarh railway station
    {Coordinate{79.0976, 28.0034}, CountryId{"IN"}}, // Sheikhupur railway station
    {Coordinate{80.2529, 26.5035}, CountryId{"IN"}}, // Kalianpur railway station
    {Coordinate{78.6772, 27.8294}, CountryId{"IN"}}, // Kasganj City railway station
    {Coordinate{79.8139, 28.615}, CountryId{"IN"}}, // Pilibhit Junction railway station
    {Coordinate{79.0149, 27.9952}, CountryId{"IN"}}, // Ujhani railway station
    {Coordinate{80.2981, 26.483}, CountryId{"IN"}}, // Rawatpur railway station
    {Coordinate{83.0551, 26.7745}, CountryId{"IN"}}, // Khalilabad railway station
    {Coordinate{83.0883, 27.275}, CountryId{"IN"}}, // Naugarh railway station
    {Coordinate{81.9781, 27.1546}, CountryId{"IN"}}, // Gonda Junction railway station
    {Coordinate{80.6993, 27.5575}, CountryId{"IN"}}, // Sitapur Cantonment railway station
    {Coordinate{80.6797, 27.5836}, CountryId{"IN"}}, // Sitapur City Junction railway station
    {Coordinate{80.6872, 27.5646}, CountryId{"IN"}}, // Sitapur Cutchery railway station
    {Coordinate{76.6213, 27.5593}, CountryId{"IN"}}, // Alwar Junction railway station
    {Coordinate{73.3273, 25.7907}, CountryId{"IN"}}, // Pali Marwar railway station
    {Coordinate{73.7236, 27.2}, CountryId{"IN"}}, // Nagaur railway station
    {Coordinate{78.8937, 26.873}, CountryId{"IN"}}, // Jaswantnagar railway station
    {Coordinate{79.0574, 27.2242}, CountryId{"IN"}}, // Mainpuri Kachehri railway station
    {Coordinate{78.3958, 24.6882}, CountryId{"IN"}}, // Lalitpur Junction railway station
    {Coordinate{79.8491, 25.3069}, CountryId{"IN"}}, // Mahoba Junction railway station
    {Coordinate{80.7776, 27.9474}, CountryId{"IN"}}, // Lakhimpur railway station
    {Coordinate{80.7885, 27.9029}, CountryId{"IN"}}, // Kheri Town railway station
    {Coordinate{74.5894, 22.9631}, CountryId{"IN"}}, // Thandla Road railway station
    {Coordinate{76.7235, 23.3812}, CountryId{"IN"}}, // Shujalpur railway station
    {Coordinate{77.0779, 23.2151}, CountryId{"IN"}}, // Sehore railway station
    {Coordinate{83.8044, 25.4887}, CountryId{"IN"}}, // Gahmar railway station
    {Coordinate{76.8905, 23.2936}, CountryId{"IN"}}, // Jabri railway station
    {Coordinate{85.4551, 25.6615}, CountryId{"IN"}}, // Sahadai Buzurg Railway Station
    {Coordinate{84.0513, 25.7703}, CountryId{"IN"}}, // Phephna Junction railway station
    {Coordinate{79.8348, 21.3725}, CountryId{"IN"}}, // Mundikota railway station
    {Coordinate{79.1547, 17.7251}, CountryId{"IN"}}, // Jangaon railway station
    {Coordinate{85.0994, 25.7633}, CountryId{"IN"}}, // Nayagaon railway station
    {Coordinate{88.2816, 24.177}, CountryId{"IN"}}, // Murshidabad railway station
    {Coordinate{80.7306, 16.5072}, CountryId{"IN"}}, // Nidamanuru railway station
    {Coordinate{80.7801, 16.4928}, CountryId{"IN"}}, // Uppaluru railway station
    {Coordinate{82.9638, 17.6733}, CountryId{"IN"}}, // Kasimkota railway station
    {Coordinate{82.8526, 17.5537}, CountryId{"IN"}}, // Elamanchili railway station
    {Coordinate{82.7903, 17.5052}, CountryId{"IN"}}, // Regupalem railway station
    {Coordinate{82.891, 17.6068}, CountryId{"IN"}}, // Narasingapalli railway station
    {Coordinate{82.6335, 17.4098}, CountryId{"IN"}}, // Gullipadu railway station
    {Coordinate{82.7246, 17.4529}, CountryId{"IN"}}, // Narsipatnam Road railway station
    {Coordinate{82.5425, 17.3611}, CountryId{"IN"}}, // Tuni railway station, Andhra Pradesh
    {Coordinate{82.4197, 17.2696}, CountryId{"IN"}}, // Annavaram railway station
    {Coordinate{82.4894, 17.3162}, CountryId{"IN"}}, // Hamsavaram railway station
    {Coordinate{82.3681, 17.2302}, CountryId{"IN"}}, // Ravikampadu railway station
    {Coordinate{82.349, 17.2125}, CountryId{"IN"}}, // Durgada Gate railway station
    {Coordinate{82.4504, 17.2889}, CountryId{"IN"}}, // Timmapuram railway station
    {Coordinate{82.3215, 17.1866}, CountryId{"IN"}}, // Mallavaram railway station
    {Coordinate{82.2908, 17.1517}, CountryId{"IN"}}, // Gollaprolu railway station
    {Coordinate{82.2575, 17.1109}, CountryId{"IN"}}, // Pithapuram railway station
    {Coordinate{82.2231, 17.0854}, CountryId{"IN"}}, // Chandrampalem railway station
    {Coordinate{82.1311, 17.0282}, CountryId{"IN"}}, // Gudaparti railway station
    {Coordinate{82.0961, 17.0051}, CountryId{"IN"}}, // Medapadu railway station
    {Coordinate{82.0312, 16.9693}, CountryId{"IN"}}, // Bikkavolu railway station
    {Coordinate{82.079, 16.9908}, CountryId{"IN"}}, // Peddabrahmadevam railway station
    {Coordinate{82.0004, 16.9658}, CountryId{"IN"}}, // Balabhadrapuram railway station
    {Coordinate{81.9532, 16.9358}, CountryId{"IN"}}, // Anaparti railway station
    {Coordinate{81.9227, 16.9276}, CountryId{"IN"}}, // Dwarapudi railway station
    {Coordinate{81.8327, 16.9143}, CountryId{"IN"}}, // Kadiyam railway station
    {Coordinate{81.8799, 16.931}, CountryId{"IN"}}, // Kesavaram railway station
    {Coordinate{81.7009, 16.9933}, CountryId{"IN"}}, // Pasivedala railway station
    {Coordinate{81.691, 16.9711}, CountryId{"IN"}}, // Chagallu railway station
    {Coordinate{81.6752, 16.9347}, CountryId{"IN"}}, // Brahmanagudem railway station
    {Coordinate{81.6339, 16.8439}, CountryId{"IN"}}, // Marampalli railway station
    {Coordinate{81.6067, 16.8316}, CountryId{"IN"}}, // Navabpalem railway station
    {Coordinate{81.575, 16.8182}, CountryId{"IN"}}, // Prattipadu railway station
    {Coordinate{80.5169, 16.3828}, CountryId{"IN"}}, // Nagarjuna Nagar Halt railway station
    {Coordinate{76.8453, 18.5065}, CountryId{"IN"}}, // Latur Road junction railway station
    {Coordinate{80.205, 16.4339}, CountryId{"IN"}}, // Gudipudi railway station
    {Coordinate{80.8363, 16.4857}, CountryId{"IN"}}, // Tarigoppula railway station
    {Coordinate{80.253, 16.4593}, CountryId{"IN"}}, // Pedakurapadu railway station
    {Coordinate{74.4369, 20.1832}, CountryId{"IN"}}, // Ankai Killa railway station
    {Coordinate{77.6409, 14.5919}, CountryId{"IN"}}, // Zangalapalle railway station
    {Coordinate{81.046, 16.3484}, CountryId{"IN"}}, // Gudlavalleru railway station
    {Coordinate{81.0696, 16.3289}, CountryId{"IN"}}, // Kavutaram railway station
    {Coordinate{81.0989, 16.3002}, CountryId{"IN"}}, // Vadlamannadu railway station
    {Coordinate{81.1621, 16.2027}, CountryId{"IN"}}, // Chilakalapudi railway station
    {Coordinate{84.7345, 23.5511}, CountryId{"IN"}}, // Barkichampi railway station
    {Coordinate{80.8771, 16.4791}, CountryId{"IN"}}, // Indupalli railway station
    {Coordinate{80.9144, 16.4738}, CountryId{"IN"}}, // Ventrapragada railway station
    {Coordinate{80.814, 16.4889}, CountryId{"IN"}}, // Tenneru railway station
    {Coordinate{79.1108, 15.5929}, CountryId{"IN"}}, // Cumbum railway station
    {Coordinate{77.6869, 29.016}, CountryId{"IN"}}, // Meerut Cantt railway station
    {Coordinate{88.2575, 24.4212}, CountryId{"IN"}}, // Lalgola railway station
    {Coordinate{73.3518, 19.55}, CountryId{"IN"}}, // Thansit railway station
    {Coordinate{73.0398, 24.791}, CountryId{"IN"}}, // Sirohi Road Railway Station
    {Coordinate{5.09222, 51.8944}, CountryId{"NL"}}, // Leerdam railway station
    {Coordinate{12.6944, 56.0444}, CountryId{"SE"}}, // Helsingborg Central Station
    {Coordinate{73.4227, 19.628}, CountryId{"IN"}}, // Umbermali railway station
    {Coordinate{5.9975, 44.0615}, CountryId{"FR"}}, // Q3063125
    {Coordinate{5.93597, 49.2057}, CountryId{"FR"}}, // Q3063522
    {Coordinate{88.4675, 22.9692}, CountryId{"IN"}}, // Kalyani railway station
    {Coordinate{1.2825, 43.4039}, CountryId{"FR"}}, // Gare du Fauga
    {Coordinate{88.3846, 23.611}, CountryId{"IN"}}, // Bethuadahari railway station
    {Coordinate{85.1151, 20.1439}, CountryId{"IN"}}, // Nayagarh Town railway station
    {Coordinate{82.0013, 25.9129}, CountryId{"IN"}}, // Pratapgarh Junction railway station
    {Coordinate{71.756, 21.0941}, CountryId{"IN"}}, // Mahuva Junction railway station
    {Coordinate{90.7116, 25.9528}, CountryId{"IN"}}, // Nolbari railway station
    {Coordinate{90.7619, 26.0015}, CountryId{"IN"}}, // Dudhnoi railway station
    {Coordinate{83.6999, 26.9264}, CountryId{"IN"}}, // Kaptanganj Junction railway station
    {Coordinate{2.26278, 48.8294}, CountryId{"FR"}}, // Issy – Val de Seine
    {Coordinate{7.15111, 46.8028}, CountryId{"CH"}}, // Fribourg railway station
    {Coordinate{14.7284, 49.1481}, CountryId{"CZ"}}, // Q30700272
    {Coordinate{21.0486, 47.9099}, CountryId{"HU"}}, // Tiszapalkonya-Erőmű railway station
    {Coordinate{4.7688, 50.5208}, CountryId{"BE"}}, // Saint-Denis-Bovesse railway station
    {Coordinate{8.2825, 50.0069}, CountryId{"DE"}}, // Mainz-Kastel station
    {Coordinate{3.87914, 51.087}, CountryId{"BE"}}, // Beervelde railway station
    {Coordinate{4.71987, 45.9394}, CountryId{"FR"}}, // Q3078253
    {Coordinate{6.10139, 50.8856}, CountryId{"DE"}}, // Herzogenrath-Alt-Merkstein station
    {Coordinate{4.72111, 51.6058}, CountryId{"NL"}}, // Breda-Prinsenbeek railway station
    {Coordinate{14.2175, 50.6471}, CountryId{"CZ"}}, // Q30857869
    {Coordinate{-1.06703, 45.5663}, CountryId{"FR"}}, // La Pointe-de-Grave
    {Coordinate{2.81611, 41.9778}, CountryId{"ES"}}, // Girona railway station
    {Coordinate{}, CountryId{"NO"}}, // Skoger Station
    {Coordinate{1.09389, 49.4489}, CountryId{"FR"}}, // Gare de Rouen-Rive-Droite
    {Coordinate{5.32, 50.5461}, CountryId{"BE"}}, // Amay railway station
    {Coordinate{34.3769, 54.065}, CountryId{"RU"}}, // Q30888871
    {Coordinate{42.5048, 48.5419}, CountryId{"RU"}}, // Q30890454
    {Coordinate{60.369, 56.979}, CountryId{"RU"}}, // Q30890532
    {Coordinate{62.6125, 56.8508}, CountryId{"RU"}}, // Q30890594
    {Coordinate{34.3769, 54.065}, CountryId{"RU"}}, // Q30890612
    {Coordinate{61.5404, 55.1631}, CountryId{"RU"}}, // Q30890736
    {Coordinate{48.0747, 46.3456}, CountryId{"RU"}}, // Q30890781
    {Coordinate{47.7325, 46.3369}, CountryId{"RU"}}, // Q30890800
    {Coordinate{52.3044, 59.2903}, CountryId{"RU"}}, // Q30890926
    {Coordinate{52.3294, 59.1853}, CountryId{"RU"}}, // Q30890939
    {Coordinate{42.2188, 48.4269}, CountryId{"RU"}}, // Q30890971
    {Coordinate{58.8672, 53.1446}, CountryId{"RU"}}, // Q30891065
    {Coordinate{59.7094, 58.2667}, CountryId{"RU"}}, // Q30891080
    {Coordinate{49.0352, 59.2252}, CountryId{"RU"}}, // Q30891164
    {Coordinate{50.6333, 53.2307}, CountryId{"RU"}}, // Kinel railway station
    {Coordinate{49.6442, 58.6061}, CountryId{"RU"}}, // Q30891172
    {Coordinate{10.0935, 45.7384}, CountryId{"IT"}}, // Marone-Zone railway station
    {Coordinate{1.02083, 47.8219}, CountryId{"FR"}}, // Gare de Vendôme-Villiers-sur-Loir TGV
    {Coordinate{40.8033, 48.1769}, CountryId{"RU"}}, // Q30896981
    {Coordinate{21.6926, 56.6205}, CountryId{"LV"}}, // Q30897330
    {Coordinate{21.5524, 56.5751}, CountryId{"LV"}}, // Q30897336
    {Coordinate{9.24944, 59.3925}, CountryId{"NO"}}, // Akkerhaugen Station
    {Coordinate{13.6983, 49.7733}, CountryId{"CZ"}}, // Q3090963
    {Coordinate{4.30861, 52.0533}, CountryId{"NL"}}, // Den Haag Moerwijk railway station
    {Coordinate{9.34111, 58.8925}, CountryId{"NO"}}, // Vadfoss Station
    {Coordinate{9.31861, 58.9006}, CountryId{"NO"}}, // Sannidal Station
    {Coordinate{9.16667, 45.6667}, CountryId{"IT"}}, // Cabiate railway station
    {Coordinate{9.08833, 59.3311}, CountryId{"NO"}}, // Svenseid Station
    {Coordinate{8.08444, 58.4114}, CountryId{"NO"}}, // Vatnestrøm Station
    {Coordinate{2.37333, 48.8967}, CountryId{"FR"}}, // Gare Rosa-Parks
    {Coordinate{-1.52446, 47.5546}, CountryId{"FR"}}, // Q3095579
    {Coordinate{10.3989, 63.4364}, CountryId{"NO"}}, // Trondheim Central Station
    {Coordinate{6.85652, 43.4314}, CountryId{"FR"}}, // Q3095586
    {Coordinate{7.6034, 47.4677}, CountryId{"CH"}}, // Aesch railway station
    {Coordinate{3.12175, 46.0551}, CountryId{"FR"}}, // Q3095589
    {Coordinate{4.19105, 43.5709}, CountryId{"FR"}}, // Gare d'Aigues-Mortes
    {Coordinate{2.78046, 50.1317}, CountryId{"FR"}}, // Gare d'Achiet
    {Coordinate{0.748709, 45.2866}, CountryId{"FR"}}, // Gare d'Agonac
    {Coordinate{4.20875, 43.6787}, CountryId{"FR"}}, // Gare d'Aimargues
    {Coordinate{7.55521, 43.8713}, CountryId{"IT"}}, // Q3095596
    {Coordinate{2.39833, 45.6139}, CountryId{"FR"}}, // Gare d'Aix-La Marsalouse
    {Coordinate{1.14566, 45.7965}, CountryId{"FR"}}, // Q3095598
    {Coordinate{4.77182, 45.752}, CountryId{"FR"}}, // Gare d'Alaï
    {Coordinate{5.90944, 45.6881}, CountryId{"FR"}}, // Gare d'Aix-les-Bains-Le Revard
    {Coordinate{2.64431, 50.0056}, CountryId{"FR"}}, // Gare d'Albert
    {Coordinate{4.83263, 45.8748}, CountryId{"FR"}}, // Gare d'Albigny-Neuville
    {Coordinate{2.25191, 42.9974}, CountryId{"FR"}}, // Gare d'Alet-les-Bains
    {Coordinate{3.66377, 44.5413}, CountryId{"FR"}}, // Q3095615
    {Coordinate{3.67334, 44.9189}, CountryId{"FR"}}, // Q3095616
    {Coordinate{4.08492, 44.128}, CountryId{"FR"}}, // Gare d'Alès
    {Coordinate{4.4739, 49.5239}, CountryId{"FR"}}, // Gare d'Amagne-Lucquy
    {Coordinate{10.6326, 62.1091}, CountryId{"NO"}}, // Alvdal stasjon
    {Coordinate{4.3267, 45.971}, CountryId{"FR"}}, // Gare d'Amplepuis
    {Coordinate{3.91055, 49.4847}, CountryId{"FR"}}, // Q3095623
    {Coordinate{0.981175, 47.4216}, CountryId{"FR"}}, // Gare d'Amboise
    {Coordinate{4.67035, 49.9308}, CountryId{"FR"}}, // Q3095628
    {Coordinate{4.2552, 45.5216}, CountryId{"FR"}}, // Q3095632
    {Coordinate{2.30833, 49.8906}, CountryId{"FR"}}, // Amiens railway station
    {Coordinate{19.0892, 47.55}, CountryId{"HU"}}, // Angyalföld train station
    {Coordinate{2.00389, 48.3114}, CountryId{"FR"}}, // Gare d'Angerville
    {Coordinate{6.89209, 43.435}, CountryId{"FR"}}, // Gare d'Anthéor-Cap-Roux
    {Coordinate{4.09316, 49.9849}, CountryId{"FR"}}, // Gare d'Anor
    {Coordinate{4.90472, 50.2375}, CountryId{"BE"}}, // Anseremme railway station
    {Coordinate{0.165278, 45.6542}, CountryId{"FR"}}, // Gare d'Angoulême
    {Coordinate{6.45988, 49.2623}, CountryId{"FR"}}, // Anzeling
    {Coordinate{7.29613, 45.7326}, CountryId{"IT"}}, // Q3095652
    {Coordinate{7.30632, 45.7316}, CountryId{"IT"}}, // Aosta Istituto train station
    {Coordinate{6.42373, 46.5509}, CountryId{"CH"}}, // Apples railway station
    {Coordinate{7.3225, 45.7342}, CountryId{"IT"}}, // Aosta railway station
    {Coordinate{7.9735, 48.5413}, CountryId{"DE"}}, // Appenweier
    {Coordinate{19.0481, 47.5662}, CountryId{"HU"}}, // Aquincum MÁV station
    {Coordinate{3.7672, 47.6006}, CountryId{"FR"}}, // Gare d'Arcy-sur-Cure
    {Coordinate{5.77673, 47.0304}, CountryId{"FR"}}, // Q3095662
    {Coordinate{-0.025337, 48.7385}, CountryId{"FR"}}, // Gare d'Argentan
    {Coordinate{0.190015, 47.9286}, CountryId{"FR"}}, // Gare d'Arnage
    {Coordinate{1.12855, 48.0999}, CountryId{"FR"}}, // Q3095672
    {Coordinate{3.31062, 45.3654}, CountryId{"FR"}}, // Q3095673
    {Coordinate{2.25722, 48.9469}, CountryId{"FR"}}, // gare d'Argenteuil
    {Coordinate{7.16675, 45.7041}, CountryId{"IT"}}, // Q3095675
    {Coordinate{-0.570131, 43.3931}, CountryId{"FR"}}, // Gare d'Artix
    {Coordinate{6.62052, 46.6132}, CountryId{"CH"}}, // Assens railway station
    {Coordinate{-0.295131, 43.2545}, CountryId{"FR"}}, // Gare d'Assat
    {Coordinate{1.86954, 44.6745}, CountryId{"FR"}}, // Gare d'Assier
    {Coordinate{5.02306, 50.3681}, CountryId{"BE"}}, // Assesse railway station
    {Coordinate{3.16036, 45.9838}, CountryId{"FR"}}, // Q3095685
    {Coordinate{-0.419804, 45.0153}, CountryId{"FR"}}, // Q3095686
    {Coordinate{0.265749, 47.6869}, CountryId{"FR"}}, // Q3095688
    {Coordinate{2.59276, 50.3531}, CountryId{"FR"}}, // Q3095689
    {Coordinate{2.10225, 50.3962}, CountryId{"FR"}}, // Q3095692
    {Coordinate{3.61118, 47.7663}, CountryId{"FR"}}, // Q3095693
    {Coordinate{1.77988, 48.4461}, CountryId{"FR"}}, // Q3095696
    {Coordinate{4.19836, 45.3711}, CountryId{"FR"}}, // Q3095697
    {Coordinate{10.6618, 62.2223}, CountryId{"NO"}}, // Auma Station
    {Coordinate{-2.99917, 47.68}, CountryId{"FR"}}, // Gare d'Auray
    {Coordinate{4.29285, 46.9551}, CountryId{"FR"}}, // Gare d'Autun
    {Coordinate{2.49444, 48.9319}, CountryId{"FR"}}, // Gare d'Aulnay-sous-Bois
    {Coordinate{4.04351, 49.0648}, CountryId{"FR"}}, // Q3095704
    {Coordinate{3.58492, 47.798}, CountryId{"FR"}}, // Gare d'Auxerre-Saint-Gervais
    {Coordinate{3.91238, 47.4955}, CountryId{"FR"}}, // Gare d'Avallon
    {Coordinate{1.78772, 43.3638}, CountryId{"FR"}}, // Gare d'Avignonet
    {Coordinate{2.83397, 50.4072}, CountryId{"FR"}}, // Gare d'Avion
    {Coordinate{3.93313, 50.1269}, CountryId{"FR"}}, // Q3095711
    {Coordinate{7.13131, 45.7063}, CountryId{"IT"}}, // Q3095712
    {Coordinate{4.0016, 49.0487}, CountryId{"FR"}}, // Gare d'Ay
    {Coordinate{2.65264, 47.0349}, CountryId{"FR"}}, // Gare d'Avord
    {Coordinate{0.447649, 47.2663}, CountryId{"FR"}}, // Q3095715
    {Coordinate{0.86007, 47.3652}, CountryId{"FR"}}, // Q3095716
    {Coordinate{5.30139, 50.2242}, CountryId{"BE"}}, // Aye railway station
    {Coordinate{7.99007, 47.5331}, CountryId{"CH"}}, // Eiken railway station
    {Coordinate{6.39329, 48.5035}, CountryId{"FR"}}, // Gare d'Einvaux
    {Coordinate{3.99356, 50.8238}, CountryId{"BE"}}, // Eichem railway station
    {Coordinate{7.33344, 49.0162}, CountryId{"FR"}}, // gare d'Enchenberg
    {Coordinate{4.04722, 50.6972}, CountryId{"BE"}}, // Enghien railway station
    {Coordinate{5.40111, 50.5822}, CountryId{"BE"}}, // Engis railway station
    {Coordinate{2.30667, 48.9731}, CountryId{"FR"}}, // Gare d'Enghien-les-Bains
    {Coordinate{7.4509, 48.3636}, CountryId{"FR"}}, // Q3095742
    {Coordinate{-1.54465, 47.283}, CountryId{"FR"}}, // Q3095744
    {Coordinate{1.54227, 43.5171}, CountryId{"FR"}}, // Gare d'Escalquens
    {Coordinate{2.81067, 48.9032}, CountryId{"FR"}}, // Gare d'Esbly
    {Coordinate{0.781666, 47.2841}, CountryId{"FR"}}, // Q3095750
    {Coordinate{4.86813, 45.5403}, CountryId{"FR"}}, // gare d'Estressin
    {Coordinate{5.04472, 48.583}, CountryId{"FR"}}, // Q3095752
    {Coordinate{1.74119, 45.7398}, CountryId{"FR"}}, // Q3095756
    {Coordinate{0.666598, 45.8863}, CountryId{"FR"}}, // Gare d'Exideuil
    {Coordinate{2.06611, 49.9825}, CountryId{"FR"}}, // Gare d'Hangest
    {Coordinate{4.05999, 50.4706}, CountryId{"BE"}}, // Havré railway station
    {Coordinate{4.70243, 50.0114}, CountryId{"FR"}}, // Gare de Haybes
    {Coordinate{2.54136, 50.7252}, CountryId{"FR"}}, // Hazebrouck
    {Coordinate{2.01094, 49.488}, CountryId{"FR"}}, // Q3095768
    {Coordinate{6.17974, 48.6455}, CountryId{"FR"}}, // Q3095770
    {Coordinate{6.8057, 48.6466}, CountryId{"FR"}}, // Gare d'Igney - Avricourt
    {Coordinate{2.23083, 48.74}, CountryId{"FR"}}, // gare d'Igny
    {Coordinate{3.25957, 46.9334}, CountryId{"FR"}}, // Q3095786
    {Coordinate{2.6244, 42.6683}, CountryId{"FR"}}, // Gare d'Ille-sur-Têt
    {Coordinate{1.24477, 48.3041}, CountryId{"FR"}}, // Gare d'Illiers-Combray
    {Coordinate{-0.919624, 47.4065}, CountryId{"FR"}}, // Q3095790
    {Coordinate{5.12935, 47.5203}, CountryId{"FR"}}, // Q3095794
    {Coordinate{3.25396, 45.544}, CountryId{"FR"}}, // Q3095800
    {Coordinate{-1.45185, 47.6263}, CountryId{"FR"}}, // Q3095801
    {Coordinate{19.1063, 47.5503}, CountryId{"HU"}}, // Istvántelek railway station
    {Coordinate{2.25889, 48.8197}, CountryId{"FR"}}, // Issy
    {Coordinate{7.78725, 47.4673}, CountryId{"CH"}}, // Itingen railway station
    {Coordinate{3.21475, 50.9211}, CountryId{"BE"}}, // Izegem railway station
    {Coordinate{2.39111, 48.8142}, CountryId{"FR"}}, // Ivry-sur-Seine
    {Coordinate{6.97357, 47.9105}, CountryId{"FR"}}, // Q3095816
    {Coordinate{7.95556, 48.4594}, CountryId{"DE"}}, // Offenbourg-Kreisschulzentrum
    {Coordinate{-1.76751, 46.5484}, CountryId{"FR"}}, // Olonne-sur-Mer
    {Coordinate{7.5349, 43.8783}, CountryId{"IT"}}, // Olivetta San Michele station
    {Coordinate{4.05367, 50.8566}, CountryId{"BE"}}, // Okegem railway station
    {Coordinate{1.70251, 48.8265}, CountryId{"FR"}}, // Orgerus-Béhoust station
    {Coordinate{1.186, 47.4919}, CountryId{"FR"}}, // Gare d'Onzain
    {Coordinate{3.62684, 50.1032}, CountryId{"FR"}}, // Ors railway station
    {Coordinate{2.05759, 49.063}, CountryId{"FR"}}, // Q3095835
    {Coordinate{-0.021411, 43.1834}, CountryId{"FR"}}, // Gare d'Ossun
    {Coordinate{-1.29198, 47.3433}, CountryId{"FR"}}, // Q3095840
    {Coordinate{1.97722, 42.4197}, CountryId{"FR"}}, // Gare d'Osséja
    {Coordinate{6.8294, 45.0385}, CountryId{"IT"}}, // Oulx-Cesana-Claviere-Sestriere railway station
    {Coordinate{4.26727, 43.758}, CountryId{"FR"}}, // Gare d'Uchaud
    {Coordinate{4.3321, 50.7919}, CountryId{"BE"}}, // Uccle-Calevoet railway station
    {Coordinate{2.58658, 46.6294}, CountryId{"FR"}}, // Gare d'Urçay
    {Coordinate{2.36447, 44.9106}, CountryId{"FR"}}, // Q3095857
    {Coordinate{6.41097, 49.2748}, CountryId{"FR"}}, // Ébersviller
    {Coordinate{1.57045, 45.4407}, CountryId{"FR"}}, // Gare d'Uzerche
    {Coordinate{6.63294, 46.6394}, CountryId{"CH"}}, // Échallens railway station
    {Coordinate{5.99465, 47.2748}, CountryId{"FR"}}, // Gare d'École-Valentin
    {Coordinate{0.268898, 47.8245}, CountryId{"FR"}}, // Q3095866
    {Coordinate{36.0378, 45.3544}, CountryId{"RU"}}, // Q30958667
    {Coordinate{-0.51949, 47.5039}, CountryId{"FR"}}, // Q3095867
    {Coordinate{1.68155, 48.6052}, CountryId{"FR"}}, // Q3095869
    {Coordinate{-4.68333, 40.6572}, CountryId{"ES"}}, // Ávila Railway Station
    {Coordinate{2.36306, 49.0228}, CountryId{"FR"}}, // Gare d'Écouen - Ézanville
    {Coordinate{6.29253, 45.457}, CountryId{"FR"}}, // Gare d'Épierre-Saint-Léger
    {Coordinate{2.33167, 48.6692}, CountryId{"FR"}}, // Épinay-sur-Orge (Paris RER)
    {Coordinate{4.1838, 46.8679}, CountryId{"FR"}}, // Étang-sur-Arroux train station
    {Coordinate{-0.460694, 47.6571}, CountryId{"FR"}}, // Q3095879
    {Coordinate{2.30228, 48.9542}, CountryId{"FR"}}, // Épinay-sur-Seine
    {Coordinate{5.63976, 49.2076}, CountryId{"FR"}}, // Q3095881
    {Coordinate{19.0322, 47.5692}, CountryId{"HU"}}, // Óbuda railway station
    {Coordinate{19.0796, 47.5588}, CountryId{"HU"}}, // Újpest railway station
    {Coordinate{-1.54534, 47.2589}, CountryId{"FR"}}, // Babinière
    {Coordinate{8.23085, 48.4489}, CountryId{"DE"}}, // Q3095888
    {Coordinate{1.32478, 48.3669}, CountryId{"FR"}}, // Q3095889
    {Coordinate{4.00699, 43.6533}, CountryId{"FR"}}, // Gare de Baillargues
    {Coordinate{2.73488, 50.729}, CountryId{"FR"}}, // Bailleul
    {Coordinate{6.09929, 48.5864}, CountryId{"FR"}}, // Q3095895
    {Coordinate{0.618691, 47.337}, CountryId{"FR"}}, // Gare de Ballan
    {Coordinate{3.23469, 50.6185}, CountryId{"FR"}}, // Baisieux
    {Coordinate{7.50432, 47.811}, CountryId{"FR"}}, // Gare de Bantzenheim
    {Coordinate{7.4567, 48.4033}, CountryId{"FR"}}, // Gare de Barr
    {Coordinate{2.01898, 45.5663}, CountryId{"FR"}}, // Q3095906
    {Coordinate{4.13961, 45.2977}, CountryId{"FR"}}, // Q3095908
    {Coordinate{7.24684, 47.3367}, CountryId{"CH"}}, // Bassecourt railway station
    {Coordinate{5.925, 49.5583}, CountryId{"LU"}}, // Bascharage-Sanem railway station
    {Coordinate{-2.4789, 47.281}, CountryId{"FR"}}, // Batz-sur-Mer train station
    {Coordinate{2.90519, 50.5116}, CountryId{"FR"}}, // Gare de Bauvin - Provin
    {Coordinate{5.07602, 48.5516}, CountryId{"FR"}}, // Gare de Bayard
    {Coordinate{1.66818, 47.8118}, CountryId{"FR"}}, // Q3095924
    {Coordinate{6.32275, 48.4679}, CountryId{"FR"}}, // Gare de Bayon
    {Coordinate{4.17414, 49.3611}, CountryId{"FR"}}, // Q3095927
    {Coordinate{1.6206, 43.4535}, CountryId{"FR"}}, // Gare de Baziège
    {Coordinate{4.64708, 43.8022}, CountryId{"FR"}}, // Beaucaire
    {Coordinate{1.62577, 47.7785}, CountryId{"FR"}}, // Q3095933
    {Coordinate{1.89529, 50.4228}, CountryId{"FR"}}, // Gare de Beaurainville
    {Coordinate{4.32131, 43.7246}, CountryId{"FR"}}, // Gare de Beauvoisin
    {Coordinate{-0.468878, 46.1767}, CountryId{"FR"}}, // Gare de Beauvoir-sur-Niort
    {Coordinate{-0.603529, 42.9949}, CountryId{"FR"}}, // Q3095940
    {Coordinate{-0.450085, 44.7011}, CountryId{"FR"}}, // Gare de Beautiran
    {Coordinate{-1.47, 43.4972}, CountryId{"FR"}}, // Bayonne railway station
    {Coordinate{-0.526509, 45.7007}, CountryId{"FR"}}, // Beillant
    {Coordinate{6.10184, 48.8196}, CountryId{"FR"}}, // Q3095947
    {Coordinate{-1.43445, 46.7883}, CountryId{"FR"}}, // Belleville
    {Coordinate{4.72886, 46.112}, CountryId{"FR"}}, // Gare de Belleville-sur-Saône
    {Coordinate{5.823, 46.1095}, CountryId{"FR"}}, // Gare de Bellegarde
    {Coordinate{3.75189, 44.5618}, CountryId{"FR"}}, // Q3095955
    {Coordinate{2.36083, 49.0978}, CountryId{"FR"}}, // Gare de Belloy – Saint-Martin
    {Coordinate{-3.07217, 47.6525}, CountryId{"FR"}}, // Gare de Belz-Ploemel
    {Coordinate{2.74997, 47.0001}, CountryId{"FR"}}, // Q3095962
    {Coordinate{6.7037, 46.6929}, CountryId{"CH"}}, // Bercher railway station
    {Coordinate{10.0161, 62.8222}, CountryId{"NO"}}, // Berkåk Station
    {Coordinate{4.28992, 50.8727}, CountryId{"BE"}}, // Berchem-Sainte-Agathe railway station
    {Coordinate{6.79112, 48.4284}, CountryId{"FR"}}, // Gare de Bertrichamps
    {Coordinate{3.36048, 46.443}, CountryId{"FR"}}, // Q3095977
    {Coordinate{-1.87, 47.6992}, CountryId{"FR"}}, // Beslé station
    {Coordinate{2.69169, 50.5358}, CountryId{"FR"}}, // Q3095981
    {Coordinate{7.12633, 43.6109}, CountryId{"FR"}}, // Gare de Biot
    {Coordinate{7.74116, 48.6112}, CountryId{"FR"}}, // Bischheim
    {Coordinate{7.4981, 48.4871}, CountryId{"FR"}}, // Q3095992
    {Coordinate{4.17278, 50.4086}, CountryId{"BE"}}, // Binche railway station
    {Coordinate{7.43227, 49.0488}, CountryId{"FR"}}, // gare de Bitche
    {Coordinate{-2.92672, 43.2603}, CountryId{"ES"}}, // Bilbao-Concordia
    {Coordinate{7.85132, 48.7656}, CountryId{"FR"}}, // Q3095997
    {Coordinate{7.07822, 47.8277}, CountryId{"FR"}}, // Q3095998
    {Coordinate{6.333, 46.538}, CountryId{"CH"}}, // Bière railway station
    {Coordinate{4.7405, 47.374}, CountryId{"FR"}}, // Q3096003
    {Coordinate{4.39144, 46.6941}, CountryId{"FR"}}, // Q3096004
    {Coordinate{0.987822, 47.3379}, CountryId{"FR"}}, // Q3096007
    {Coordinate{3.13387, 51.3122}, CountryId{"BE"}}, // Blankenberge railway station
    {Coordinate{4.57518, 45.9066}, CountryId{"FR"}}, // Q3096013
    {Coordinate{4.70796, 44.2716}, CountryId{"FR"}}, // Q3096014
    {Coordinate{7.26733, 47.857}, CountryId{"FR"}}, // Gare de Bollwiller
    {Coordinate{2.77131, 50.2107}, CountryId{"FR"}}, // Estacion de Boisleux
    {Coordinate{4.40944, 50.8772}, CountryId{"BE"}}, // Bordet railway station
    {Coordinate{-1.68139, 47.1381}, CountryId{"FR"}}, // Gare de Bouaye
    {Coordinate{4.18762, 43.9927}, CountryId{"FR"}}, // Gare de Boucoiran
    {Coordinate{2.2072, 49.1947}, CountryId{"FR"}}, // Gare de Bornel-Belle-Église
    {Coordinate{2.13212, 48.8542}, CountryId{"FR"}}, // Gare de Bougival
    {Coordinate{-1.17869, 46.6516}, CountryId{"FR"}}, // Q3096037
    {Coordinate{-1.95528, 47.0464}, CountryId{"FR"}}, // Gare de Bourgneuf-en-Retz
    {Coordinate{-1.18281, 47.0506}, CountryId{"FR"}}, // Gare de Boussay - La Bruffière
    {Coordinate{0.83836, 49.3176}, CountryId{"FR"}}, // Bourgtheroulde-Thuit-Hébert
    {Coordinate{2.69194, 48.3325}, CountryId{"FR"}}, // Gare de Bourron-Marlotte–Grez
    {Coordinate{5.21461, 46.2001}, CountryId{"FR"}}, // Gare de Bourg-en-Bresse
    {Coordinate{4.27761, 45.5247}, CountryId{"FR"}}, // Q3096044
    {Coordinate{4.35308, 49.0913}, CountryId{"FR"}}, // Q3096046
    {Coordinate{6.52903, 49.2899}, CountryId{"FR"}}, // Bouzonville
    {Coordinate{2.37611, 48.4347}, CountryId{"FR"}}, // Gare de Boutigny
    {Coordinate{4.00491, 45.7413}, CountryId{"FR"}}, // Q3096049
    {Coordinate{3.20217, 50.5739}, CountryId{"FR"}}, // Bouvines
    {Coordinate{4.13844, 50.6056}, CountryId{"BE"}}, // Braine-le-Comte railway station
    {Coordinate{3.33017, 45.4141}, CountryId{"FR"}}, // Q3096057
    {Coordinate{2.1193, 43.244}, CountryId{"FR"}}, // Gare de Bram
    {Coordinate{7.10367, 48.0283}, CountryId{"FR"}}, // Breitenbach station
    {Coordinate{-0.496381, 46.8384}, CountryId{"FR"}}, // Gare de Bressuire
    {Coordinate{-0.51167, 49.2031}, CountryId{"FR"}}, // Q3096062
    {Coordinate{3.7665, 49.3084}, CountryId{"FR"}}, // Gare de Breuil-Romain
    {Coordinate{1.44008, 45.8642}, CountryId{"FR"}}, // Q3096065
    {Coordinate{4.76377, 45.6737}, CountryId{"FR"}}, // Q3096066
    {Coordinate{4.20702, 46.9086}, CountryId{"FR"}}, // Q3096068
    {Coordinate{3.37875, 45.3006}, CountryId{"FR"}}, // Gare de Brioude
    {Coordinate{1.8334, 50.4469}, CountryId{"FR"}}, // Q3096072
    {Coordinate{1.16056, 48.2158}, CountryId{"FR"}}, // Q3096073
    {Coordinate{0.711597, 49.1964}, CountryId{"FR"}}, // Brionne
    {Coordinate{4.29548, 46.8622}, CountryId{"FR"}}, // Q3096075
    {Coordinate{4.32134, 50.849}, CountryId{"BE"}}, // Brussels West railway station
    {Coordinate{-1.75181, 48.0286}, CountryId{"FR"}}, // Q3096079
    {Coordinate{1.54156, 48.9433}, CountryId{"FR"}}, // Bréval
    {Coordinate{19.0315, 47.4413}, CountryId{"HU"}}, // Albertfalva railway station
    {Coordinate{7.84799, 47.4089}, CountryId{"CH"}}, // Buckten railway station
    {Coordinate{19.0327, 47.4113}, CountryId{"HU"}}, // Háros railway station
    {Coordinate{19.0413, 47.4238}, CountryId{"HU"}}, // Budafok railway station
    {Coordinate{19.0018, 47.5808}, CountryId{"HU"}}, // Üröm railway station
    {Coordinate{19.0165, 47.4051}, CountryId{"HU"}}, // Budatétény railway station
    {Coordinate{1.92436, 45.6005}, CountryId{"FR"}}, // Q3096089
    {Coordinate{1.44352, 48.9253}, CountryId{"FR"}}, // Bueil
    {Coordinate{2.73329, 50.4486}, CountryId{"FR"}}, // Gare de Bully - Grenay
    {Coordinate{1.02614, 45.6075}, CountryId{"FR"}}, // Gare de Bussière-Galant
    {Coordinate{3.31803, 46.8652}, CountryId{"FR"}}, // Gare de Béard
    {Coordinate{3.14947, 43.6087}, CountryId{"FR"}}, // Q3096097
    {Coordinate{4.89299, 44.0408}, CountryId{"FR"}}, // Gare de Bédarrides
    {Coordinate{7.61952, 47.5426}, CountryId{"CH"}}, // Q3096099
    {Coordinate{2.16305, 48.6958}, CountryId{"FR"}}, // Bures-sur-Yvette Station
    {Coordinate{6.82847, 49.1382}, CountryId{"FR"}}, // Q3096104
    {Coordinate{-1.36977, 43.6278}, CountryId{"FR"}}, // Bénesse-Maremne
    {Coordinate{1.91671, 42.4581}, CountryId{"FR"}}, // Gare de Béna Fanès
    {Coordinate{7.14806, 43.6578}, CountryId{"FR"}}, // Gare de Cagnes-sur-Mer
    {Coordinate{-0.3477, 49.1764}, CountryId{"FR"}}, // Gare de Caen
    {Coordinate{3.06634, 44.422}, CountryId{"FR"}}, // Q3096117
    {Coordinate{1.27406, 41.1922}, CountryId{"ES"}}, // Camp de Tarragona railway station
    {Coordinate{5.04399, 44.0503}, CountryId{"FR"}}, // Gare de Carpentras
    {Coordinate{5.154, 43.3365}, CountryId{"FR"}}, // Carry-le-Rouet train station
    {Coordinate{4.73067, 45.788}, CountryId{"FR"}}, // Q3096140
    {Coordinate{-0.040707, 44.8571}, CountryId{"FR"}}, // Gare de Castillon
    {Coordinate{5.04365, 43.8347}, CountryId{"FR"}}, // Q3096148
    {Coordinate{-0.38215, 45.1052}, CountryId{"FR"}}, // Cavignac
    {Coordinate{6.15734, 48.5239}, CountryId{"FR"}}, // Ceintrey railway station
    {Coordinate{3.15515, 43.8123}, CountryId{"FR"}}, // Q3096153
    {Coordinate{3.6452, 46.8578}, CountryId{"FR"}}, // Q3096157
    {Coordinate{-0.667485, 46.8175}, CountryId{"FR"}}, // Gare de Cerizay
    {Coordinate{-0.533632, 44.8563}, CountryId{"FR"}}, // Cenon station
    {Coordinate{3.15183, 48.8143}, CountryId{"FR"}}, // Gare de Chailly - Boissy-le-Châtel
    {Coordinate{2.59417, 48.5653}, CountryId{"FR"}}, // Gare de Cesson
    {Coordinate{2.25722, 48.985}, CountryId{"FR"}}, // Gare de Cernay
    {Coordinate{-0.743689, 47.3429}, CountryId{"FR"}}, // Q3096169
    {Coordinate{3.99245, 45.206}, CountryId{"FR"}}, // Q3096170
    {Coordinate{1.78244, 47.8771}, CountryId{"FR"}}, // Q3096173
    {Coordinate{-1.87194, 46.8433}, CountryId{"FR"}}, // Gare de Challans
    {Coordinate{2.21361, 48.5117}, CountryId{"FR"}}, // Chamarande (Paris RER)
    {Coordinate{3.97931, 44.3003}, CountryId{"FR"}}, // Q3096177
    {Coordinate{7.55718, 45.7443}, CountryId{"IT"}}, // Chambave train station
    {Coordinate{0.96538, 47.1818}, CountryId{"FR"}}, // Q3096179
    {Coordinate{4.50711, 45.9816}, CountryId{"FR"}}, // Q3096181
    {Coordinate{3.60366, 47.7385}, CountryId{"FR"}}, // Q3096182
    {Coordinate{5.91937, 45.561}, CountryId{"FR"}}, // Gare de Chambéry-Challes-les-Eaux
    {Coordinate{-1.05454, 46.6901}, CountryId{"FR"}}, // Q3096184
    {Coordinate{3.17192, 46.7283}, CountryId{"FR"}}, // Q3096185
    {Coordinate{3.74189, 44.838}, CountryId{"FR"}}, // Gare de Chapeauroux
    {Coordinate{-1.59434, 47.1972}, CountryId{"FR"}}, // Chantenay Station
    {Coordinate{4.76427, 45.6983}, CountryId{"FR"}}, // Q3096190
    {Coordinate{4.73582, 45.7822}, CountryId{"FR"}}, // Gare de Charbonnières-les-Bains
    {Coordinate{4.80083, 45.5814}, CountryId{"FR"}}, // Q3096199
    {Coordinate{3.8399, 44.554}, CountryId{"FR"}}, // Q3096201
    {Coordinate{0.453528, 45.8244}, CountryId{"FR"}}, // Q3096202
    {Coordinate{6.30155, 48.3786}, CountryId{"FR"}}, // Q3096204
    {Coordinate{4.3454, 46.2074}, CountryId{"FR"}}, // Q3096206
    {Coordinate{4.72534, 45.8733}, CountryId{"FR"}}, // Q3096209
    {Coordinate{4.67585, 46.8925}, CountryId{"FR"}}, // Q3096210
    {Coordinate{3.55426, 47.8974}, CountryId{"FR"}}, // Q3096213
    {Coordinate{2.18853, 48.8048}, CountryId{"FR"}}, // gare de Chaville-Rive-Gauche
    {Coordinate{-0.732163, 47.2177}, CountryId{"FR"}}, // Gare de Chemillé
    {Coordinate{6.60608, 46.5844}, CountryId{"CH"}}, // Cheseaux-sur-Lausanne railway station
    {Coordinate{5.11157, 48.5245}, CountryId{"FR"}}, // Q3096218
    {Coordinate{4.62253, 45.8856}, CountryId{"FR"}}, // Gare de Chessy
    {Coordinate{1.13353, 47.3348}, CountryId{"FR"}}, // Q3096220
    {Coordinate{3.2638, 44.5246}, CountryId{"FR"}}, // Q3096221
    {Coordinate{6.27186, 44.5458}, CountryId{"FR"}}, // Gare de Chorges
    {Coordinate{1.24732, 47.52}, CountryId{"FR"}}, // Q3096226
    {Coordinate{0.901374, 47.5879}, CountryId{"FR"}}, // Q3096228
    {Coordinate{-0.86979, 47.066}, CountryId{"FR"}}, // Gare de Cholet
    {Coordinate{0.688232, 45.2446}, CountryId{"FR"}}, // Gare de Château-l'Évêque
    {Coordinate{0.414916, 47.6832}, CountryId{"FR"}}, // Gare de Château-du-Loir
    {Coordinate{-1.40522, 48.1062}, CountryId{"FR"}}, // Gare de Châteaubourg
    {Coordinate{1.64517, 45.7594}, CountryId{"FR"}}, // Q3096235
    {Coordinate{6.81549, 46.5705}, CountryId{"CH"}}, // Châtillens railway station
    {Coordinate{4.64523, 45.8753}, CountryId{"FR"}}, // Q3096237
    {Coordinate{4.51889, 50.4087}, CountryId{"BE"}}, // Châtelet railway station
    {Coordinate{6.19572, 46.1967}, CountryId{"CH"}}, // Chêne-Bourg Station
    {Coordinate{0.460506, 47.3451}, CountryId{"FR"}}, // Gare de Cinq-Mars-la-Pile
    {Coordinate{4.29959, 46.6042}, CountryId{"FR"}}, // Q3096246
    {Coordinate{4.7184, 45.8593}, CountryId{"FR"}}, // Gare de Civrieux-d'Azergues
    {Coordinate{3.52055, 47.4668}, CountryId{"FR"}}, // Gare de Clamecy
    {Coordinate{3.5766, 49.5439}, CountryId{"FR"}}, // Q3096250
    {Coordinate{3.13415, 45.767}, CountryId{"FR"}}, // Q3096253
    {Coordinate{5.06485, 49.1066}, CountryId{"FR"}}, // Gare de Clermont-en-Argonne
    {Coordinate{1.24336, 47.9921}, CountryId{"FR"}}, // Gare de Cloyes
    {Coordinate{-1.2865, 47.0859}, CountryId{"FR"}}, // Clisson
    {Coordinate{1.10652, 49.5994}, CountryId{"FR"}}, // Gare de Clères
    {Coordinate{5.26615, 47.221}, CountryId{"FR"}}, // Q3096264
    {Coordinate{4.84641, 45.8291}, CountryId{"FR"}}, // Gare de Collonges-Fontaines
    {Coordinate{1.33395, 43.6036}, CountryId{"FR"}}, // Gare de Colomiers
    {Coordinate{5.58868, 48.7659}, CountryId{"FR"}}, // Q3096271
    {Coordinate{2.99825, 50.7717}, CountryId{"BE"}}, // Comines railway station
    {Coordinate{1.22675, 45.1267}, CountryId{"FR"}}, // Gare de Condat-Le Lardin
    {Coordinate{4.34309, 47.0509}, CountryId{"FR"}}, // Gare de Cordesse - Igornay
    {Coordinate{3.67833, 47.2547}, CountryId{"FR"}}, // Gare de Corbigny
    {Coordinate{1.89978, 44.0671}, CountryId{"FR"}}, // Gare de Cordes-Vindrac
    {Coordinate{0.833971, 47.2625}, CountryId{"FR"}}, // Gare de Cormery
    {Coordinate{4.91714, 47.0842}, CountryId{"FR"}}, // Gare de Corgoloin
    {Coordinate{2.88604, 50.415}, CountryId{"FR"}}, // Q3096295
    {Coordinate{1.69791, 45.2151}, CountryId{"FR"}}, // Gare de Cornil
    {Coordinate{3.08155, 48.8077}, CountryId{"FR"}}, // Gare de Coulommiers
    {Coordinate{7.12417, 47.4053}, CountryId{"CH"}}, // Courgenay railway station
    {Coordinate{2.24853, 48.8984}, CountryId{"FR"}}, // Gare de Courbevoie
    {Coordinate{3.05092, 43.2337}, CountryId{"FR"}}, // Coursan
    {Coordinate{7.29116, 47.3351}, CountryId{"CH"}}, // Courfaivre railway station
    {Coordinate{4.88831, 44.09}, CountryId{"FR"}}, // Q3096308
    {Coordinate{6.59583, 52.0119}, CountryId{"NL"}}, // Lichtenvoorde-Groenlo railway station
    {Coordinate{-4.78948, 37.8884}, CountryId{"ES"}}, // Córdoba railway station
    {Coordinate{7.31798, 47.3427}, CountryId{"CH"}}, // Courtételle railway station
    {Coordinate{1.23484, 48.4515}, CountryId{"FR"}}, // Q3096314
    {Coordinate{0.867747, 47.2378}, CountryId{"FR"}}, // Q3096315
    {Coordinate{-1.44148, 49.0427}, CountryId{"FR"}}, // Coutances
    {Coordinate{0.70364, 44.8366}, CountryId{"FR"}}, // Gare de Couze
    {Coordinate{3.68114, 47.6786}, CountryId{"FR"}}, // Q3096319
    {Coordinate{4.82928, 45.8487}, CountryId{"FR"}}, // Gare de Couzon-au-Mont-d'Or
    {Coordinate{-1.72357, 47.2219}, CountryId{"FR"}}, // Couëron
    {Coordinate{3.16307, 50.6957}, CountryId{"FR"}}, // Croix-L'Allumette
    {Coordinate{5.01966, 43.4089}, CountryId{"FR"}}, // Croix-Sainte train station
    {Coordinate{2.40556, 49.2564}, CountryId{"FR"}}, // Gare de Cramoisy
    {Coordinate{3.0628, 49.0917}, CountryId{"FR"}}, // Q3096328
    {Coordinate{-0.459042, 44.9729}, CountryId{"FR"}}, // Cubzac-les-Ponts
    {Coordinate{4.78417, 46.2462}, CountryId{"FR"}}, // Q3096336
    {Coordinate{-1.25486, 47.0587}, CountryId{"FR"}}, // Gare de Cugand
    {Coordinate{2.88653, 49.231}, CountryId{"FR"}}, // Gare de Crépy-en-Valois
    {Coordinate{2.74465, 50.522}, CountryId{"FR"}}, // Q3096339
    {Coordinate{3.21002, 50.5619}, CountryId{"FR"}}, // Cysoing
    {Coordinate{7.43558, 48.3217}, CountryId{"FR"}}, // Q3096344
    {Coordinate{5.65679, 48.094}, CountryId{"FR"}}, // Gare de Damblain
    {Coordinate{34.6556, 45.5247}, CountryId{"UA"}}, // Q30963450
    {Coordinate{34.4625, 45.6475}, CountryId{"UA"}}, // Q30963451
    {Coordinate{34.8056, 45.3869}, CountryId{"UA"}}, // 50 km
    {Coordinate{34.9269, 45.3406}, CountryId{"UA"}}, // Q30963455
    {Coordinate{35.0642, 45.2875}, CountryId{"RU"}}, // Q30963456
    {Coordinate{4.76122, 45.8153}, CountryId{"FR"}}, // Q3096346
    {Coordinate{35.3994, 45.1269}, CountryId{"UA"}}, // Q30963468
    {Coordinate{4.75996, 45.7968}, CountryId{"FR"}}, // Q3096347
    {Coordinate{35.5383, 45.2292}, CountryId{"RU"}}, // Petrovo station (Crimea)
    {Coordinate{3.73656, 45.1421}, CountryId{"FR"}}, // Gare de Darsac
    {Coordinate{3.46728, 46.8375}, CountryId{"FR"}}, // Q3096352
    {Coordinate{4.36183, 50.7481}, CountryId{"BE"}}, // De Hoek railway station
    {Coordinate{3.64908, 50.9965}, CountryId{"BE"}}, // De Pinte railway station
    {Coordinate{7.0865, 45.7304}, CountryId{"IT"}}, // Q3096357
    {Coordinate{4.70722, 49.8796}, CountryId{"FR"}}, // Q3096359
    {Coordinate{6.12638, 48.3976}, CountryId{"FR"}}, // Q3096361
    {Coordinate{7.83776, 47.4496}, CountryId{"CH"}}, // Diepflingen railway station
    {Coordinate{6.07184, 48.844}, CountryId{"FR"}}, // Gare de Dieulouard
    {Coordinate{3.98765, 46.4853}, CountryId{"FR"}}, // Q3096365
    {Coordinate{3.75182, 46.5307}, CountryId{"FR"}}, // Q3096370
    {Coordinate{6.26017, 49.335}, CountryId{"FR"}}, // Q3096372
    {Coordinate{5.02722, 47.3233}, CountryId{"FR"}}, // Gare de Dijon-Ville
    {Coordinate{6.34346, 48.6233}, CountryId{"FR"}}, // Q3096382
    {Coordinate{4.73441, 45.8397}, CountryId{"FR"}}, // Gare de Dommartin - Lissieu
    {Coordinate{-0.025953, 48.1078}, CountryId{"FR"}}, // Q3096385
    {Coordinate{3.67492, 46.5264}, CountryId{"FR"}}, // Gare de Dompierre-Sept-Fons
    {Coordinate{4.87481, 49.6984}, CountryId{"FR"}}, // Gare de Donchery
    {Coordinate{5.1483, 48.3658}, CountryId{"FR"}}, // Q3096388
    {Coordinate{3.87106, 50.1461}, CountryId{"FR"}}, // Q3096389
    {Coordinate{7.49293, 48.5244}, CountryId{"FR"}}, // Q3096390
    {Coordinate{7.61103, 47.4886}, CountryId{"CH"}}, // Dornach-Arlesheim railway station
    {Coordinate{2.98693, 50.4322}, CountryId{"FR"}}, // Dourges
    {Coordinate{0.417295, 45.0795}, CountryId{"FR"}}, // Gare de Douzillac
    {Coordinate{1.99528, 48.5356}, CountryId{"FR"}}, // Gare de Dourdan-la-Forêt
    {Coordinate{-2.0502, 47.4824}, CountryId{"FR"}}, // Gare de Drefféac
    {Coordinate{7.94764, 48.766}, CountryId{"FR"}}, // Gare de Drusenheim
    {Coordinate{0.535685, 47.3069}, CountryId{"FR"}}, // Q3096403
    {Coordinate{2.41111, 48.9437}, CountryId{"FR"}}, // Gare de Dugny - La Courneuve
    {Coordinate{9.06601, 59.0966}, CountryId{"NO"}}, // Drangedal Station
    {Coordinate{7.83951, 47.6613}, CountryId{"DE"}}, // Fahrnau station
    {Coordinate{6.90806, 49.0879}, CountryId{"FR"}}, // Farschviller railway station
    {Coordinate{6.86167, 49.1181}, CountryId{"FR"}}, // Farébersviller
    {Coordinate{7.67236, 48.491}, CountryId{"FR"}}, // Fegersheim - Lipsheim
    {Coordinate{6.98705, 47.8977}, CountryId{"FR"}}, // Q3096419
    {Coordinate{2.16971, 45.8863}, CountryId{"FR"}}, // Gare de Felletin
    {Coordinate{19.2237, 47.4374}, CountryId{"HU"}}, // Ferihegy railway station
    {Coordinate{4.85308, 45.6659}, CountryId{"FR"}}, // Q3096429
    {Coordinate{4.23077, 45.744}, CountryId{"FR"}}, // Q3096431
    {Coordinate{2.77278, 48.0964}, CountryId{"FR"}}, // Gare de Ferrières-Fontenay
    {Coordinate{2.0373, 44.6035}, CountryId{"FR"}}, // Gare de Figeac
    {Coordinate{4.2864, 45.3918}, CountryId{"FR"}}, // Gare de Firminy
    {Coordinate{3.61497, 47.3631}, CountryId{"FR"}}, // Q3096437
    {Coordinate{4.66012, 45.8451}, CountryId{"FR"}}, // Q3096438
    {Coordinate{4.80729, 50.4562}, CountryId{"BE"}}, // Flawinne railway station
    {Coordinate{4.20668, 43.9073}, CountryId{"FR"}}, // Q3096441
    {Coordinate{-0.760833, 48.0764}, CountryId{"FR"}}, // Laval railway station
    {Coordinate{-0.383186, 45.3871}, CountryId{"FR"}}, // Fontaines-d'Ozillac
    {Coordinate{4.77507, 46.8513}, CountryId{"FR"}}, // Q3096448
    {Coordinate{5.98005, 48.7115}, CountryId{"FR"}}, // Gare de Fontenoy-sur-Moselle
    {Coordinate{7.55107, 43.9967}, CountryId{"FR"}}, // Fontan - Saorge railway station
    {Coordinate{7.11222, 60.8631}, CountryId{"NO"}}, // Flåm Station
    {Coordinate{4.32455, 50.4332}, CountryId{"BE"}}, // Forchies railway station
    {Coordinate{4.97472, 43.4281}, CountryId{"FR"}}, // Q3096453
    {Coordinate{2.1885, 42.5138}, CountryId{"FR"}}, // Gare de Fontpédrouse-Saint-Thomas-les-Bains
    {Coordinate{-0.40693, 46.2346}, CountryId{"FR"}}, // Gare de Fors
    {Coordinate{5.79132, 48.6793}, CountryId{"FR"}}, // Gare de Foug
    {Coordinate{-1.23186, 46.6653}, CountryId{"FR"}}, // Gare de Fougeré
    {Coordinate{0.597129, 49.6083}, CountryId{"FR"}}, // Q3096464
    {Coordinate{-1.85139, 47.7297}, CountryId{"FR"}}, // Gare de Fougeray - Langon
    {Coordinate{4.2697, 45.395}, CountryId{"FR"}}, // Q3096467
    {Coordinate{4.05384, 50.0154}, CountryId{"FR"}}, // Gare de Fourmies
    {Coordinate{3.08722, 47.0189}, CountryId{"FR"}}, // Gare de Fourchambault
    {Coordinate{3.90611, 50.4058}, CountryId{"BE"}}, // Frameries railway station
    {Coordinate{4.014, 49.2422}, CountryId{"FR"}}, // Q3096474
    {Coordinate{6.49131, 49.2773}, CountryId{"FR"}}, // Freistroff
    {Coordinate{5.93753, 47.2274}, CountryId{"FR"}}, // Gare de Franois
    {Coordinate{7.71912, 47.5014}, CountryId{"CH"}}, // Frenkendorf-Füllinsdorf railway station
    {Coordinate{2.23472, 48.9933}, CountryId{"FR"}}, // Gare de Franconville – Le Plessis-Bouchard
    {Coordinate{6.31408, 45.6304}, CountryId{"FR"}}, // Frontenex
    {Coordinate{5.14167, 48.2964}, CountryId{"FR"}}, // Q3096489
    {Coordinate{3.75891, 43.4449}, CountryId{"FR"}}, // Frontignan
    {Coordinate{1.43248, 46.1714}, CountryId{"FR"}}, // Q3096492
    {Coordinate{5.15614, 48.4008}, CountryId{"FR"}}, // Q3096493
    {Coordinate{1.2118, 47.8919}, CountryId{"FR"}}, // Q3096495
    {Coordinate{3.35447, 50.6301}, CountryId{"BE"}}, // Froyennes railway station
    {Coordinate{2.63331, 50.3473}, CountryId{"FR"}}, // Q3096497
    {Coordinate{4.69253, 49.9861}, CountryId{"FR"}}, // Gare de Fumay
    {Coordinate{2.67028, 51.0736}, CountryId{"BE"}}, // Veurne railway station
    {Coordinate{4.72642, 50.0235}, CountryId{"FR"}}, // Q3096505
    {Coordinate{4.17127, 43.7161}, CountryId{"FR"}}, // Gare de Gallargues
    {Coordinate{4.32999, 46.6422}, CountryId{"FR"}}, // Q3096510
    {Coordinate{7.87918, 48.6951}, CountryId{"FR"}}, // Gare de Gambsheim
    {Coordinate{4.14674, 44.2703}, CountryId{"FR"}}, // Q3096512
    {Coordinate{1.89606, 43.9068}, CountryId{"FR"}}, // Gare de Gaillac
    {Coordinate{6.13597, 49.261}, CountryId{"FR"}}, // Q3096518
    {Coordinate{3.74057, 51.0561}, CountryId{"BE"}}, // Gent-Dampoort railway station
    {Coordinate{3.08583, 47.0431}, CountryId{"FR"}}, // Gare de Garchizy
    {Coordinate{0.331864, 44.8347}, CountryId{"FR"}}, // Gare de Gardonne
    {Coordinate{-0.399223, 45.0544}, CountryId{"FR"}}, // Q3096524
    {Coordinate{7.84757, 47.4658}, CountryId{"CH"}}, // Gelterkinden railway station
    {Coordinate{-0.699411, 44.7722}, CountryId{"FR"}}, // gare de Gazinet-Cestas
    {Coordinate{4.02279, 49.128}, CountryId{"FR"}}, // Q3096531
    {Coordinate{2.34056, 48.8156}, CountryId{"FR"}}, // Gentilly
    {Coordinate{3.14309, 45.8335}, CountryId{"FR"}}, // Q3096533
    {Coordinate{5.27083, 51.8839}, CountryId{"NL"}}, // Geldermalsen railway station
    {Coordinate{-3.44278, 47.8028}, CountryId{"FR"}}, // Gare de Gestel
    {Coordinate{4.99905, 47.2275}, CountryId{"FR"}}, // Gare de Gevrey-Chambertin
    {Coordinate{3.78212, 46.5371}, CountryId{"FR"}}, // Q3096539
    {Coordinate{0.86748, 43.6331}, CountryId{"FR"}}, // Q3096543
    {Coordinate{7.2093, 47.3352}, CountryId{"CH"}}, // Glovelier railway station
    {Coordinate{5.53548, 50.7506}, CountryId{"BE"}}, // Glons railway station
    {Coordinate{-1.31379, 47.1079}, CountryId{"FR"}}, // Gorges
    {Coordinate{1.73802, 49.4814}, CountryId{"FR"}}, // Q3096557
    {Coordinate{7.47875, 48.4329}, CountryId{"FR"}}, // Q3096559
    {Coordinate{0.851389, 44.1167}, CountryId{"FR"}}, // Gare de Golfech
    {Coordinate{7.69028, 48.5328}, CountryId{"FR"}}, // Graffenstaden railway station
    {Coordinate{4.03289, 44.2098}, CountryId{"FR"}}, // Q3096562
    {Coordinate{5.95335, 50.19}, CountryId{"BE"}}, // Gouvy railway station
    {Coordinate{1.72226, 44.7734}, CountryId{"FR"}}, // Gare de Gramat
    {Coordinate{2.46306, 49.0236}, CountryId{"FR"}}, // Goussainville
    {Coordinate{7.59235, 47.4413}, CountryId{"CH"}}, // Grellingen railway station
    {Coordinate{2.39556, 48.6533}, CountryId{"FR"}}, // Gare de Grigny-Centre
    {Coordinate{6.17579, 46.0111}, CountryId{"FR"}}, // Groisy-Thorens-la-Caille
    {Coordinate{1.30139, 43.8269}, CountryId{"FR"}}, // Gare de Grisolles
    {Coordinate{6.25891, 45.5944}, CountryId{"FR"}}, // Grésy-sur-Isère
    {Coordinate{5.92198, 45.7247}, CountryId{"FR"}}, // Grésy-sur-Aix train station
    {Coordinate{5.14099, 48.3382}, CountryId{"FR"}}, // Q3096594
    {Coordinate{7.8909, 46.5965}, CountryId{"CH"}}, // Grütschalp railway station
    {Coordinate{7.17474, 48.0416}, CountryId{"FR"}}, // Q3096599
    {Coordinate{17.634, 47.682}, CountryId{"HU"}}, // Győr railway station
    {Coordinate{4.23805, 46.5812}, CountryId{"FR"}}, // Q3096601
    {Coordinate{3.95165, 44.3472}, CountryId{"FR"}}, // Gare de Génolhac
    {Coordinate{4.34337, 43.7324}, CountryId{"FR"}}, // Gare de Générac
    {Coordinate{5.74329, 49.556}, CountryId{"BE"}}, // Halanzy railway station
    {Coordinate{-1.52259, 47.249}, CountryId{"FR"}}, // Haluchère-Batignolles
    {Coordinate{7.84637, 47.6793}, CountryId{"DE"}}, // Hausen-Raitbach station
    {Coordinate{3.91537, 50.2539}, CountryId{"FR"}}, // Hautmont
    {Coordinate{7.91015, 48.7276}, CountryId{"FR"}}, // Q3096622
    {Coordinate{9.10076, 59.299}, CountryId{"NO"}}, // Lunde Station
    {Coordinate{3.23913, 51.3339}, CountryId{"BE"}}, // Heist railway station
    {Coordinate{4.5377, 50.9977}, CountryId{"BE"}}, // Hever railway station
    {Coordinate{4.46778, 50.76}, CountryId{"BE"}}, // Hoeilaart railway station
    {Coordinate{6.35077, 49.2825}, CountryId{"FR"}}, // Hombourg-Budange
    {Coordinate{7.66318, 48.5556}, CountryId{"FR"}}, // Q3096635
    {Coordinate{5.00583, 50.1906}, CountryId{"BE"}}, // Houyet railway station
    {Coordinate{6.97754, 49.1066}, CountryId{"FR"}}, // Hundling railway station
    {Coordinate{6.20256, 48.6701}, CountryId{"FR"}}, // Q3096650
    {Coordinate{2.13966, 45.5435}, CountryId{"FR"}}, // Q3096652
    {Coordinate{5.26667, 50.16}, CountryId{"BE"}}, // Jemelle railway station
    {Coordinate{4.76707, 49.8337}, CountryId{"FR"}}, // Q3096655
    {Coordinate{37.6881, 49.7948}, CountryId{"UA"}}, // Q30966552
    {Coordinate{37.6373, 49.7083}, CountryId{"UA"}}, // Q30966553
    {Coordinate{5.14366, 48.4443}, CountryId{"FR"}}, // Joinville station
    {Coordinate{3.81946, 49.2902}, CountryId{"FR"}}, // Gare de Jonchery-sur-Vesle
    {Coordinate{3.39314, 47.9736}, CountryId{"FR"}}, // Q3096662
    {Coordinate{6.60172, 46.5484}, CountryId{"CH"}}, // Jouxtens-Mézery railway station
    {Coordinate{1.55753, 48.5102}, CountryId{"FR"}}, // Gare de Jouy
    {Coordinate{3.27376, 48.7908}, CountryId{"FR"}}, // Gare de Jouy-sur-Morin - Le Marais
    {Coordinate{2.16333, 48.7647}, CountryId{"FR"}}, // Jouy-en-Josas
    {Coordinate{7.11141, 43.571}, CountryId{"FR"}}, // Gare de Juan-les-Pins
    {Coordinate{7.7241, 47.5386}, CountryId{"CH"}}, // Kaiseraugst railway station
    {Coordinate{7.12527, 49.0351}, CountryId{"FR"}}, // Kalhausen station
    {Coordinate{-3.13655, 47.5364}, CountryId{"FR"}}, // Gare de Kerhostin
    {Coordinate{7.85518, 48.6796}, CountryId{"FR"}}, // Q3096687
    {Coordinate{19.1572, 47.4479}, CountryId{"HU"}}, // Kispest railway station
    {Coordinate{7.87423, 48.5702}, CountryId{"DE"}}, // Kork
    {Coordinate{10.5611, 62.9765}, CountryId{"NO"}}, // Kotsøy Station
    {Coordinate{6.969, 47.924}, CountryId{"FR"}}, // Gare de Kruth
    {Coordinate{6.23455, 49.3499}, CountryId{"FR"}}, // Kuntzig
    {Coordinate{7.81324, 48.7419}, CountryId{"FR"}}, // Q3096706
    {Coordinate{10.1655, 61.4727}, CountryId{"NO"}}, // Kvitfjell Station
    {Coordinate{6.33254, 49.3052}, CountryId{"FR"}}, // Kédange
    {Coordinate{19.1491, 47.4631}, CountryId{"HU"}}, // Kőbánya-Kispest railway station
    {Coordinate{0.620062, 48.7663}, CountryId{"FR"}}, // Gare de L'Aigle
    {Coordinate{7.35196, 43.8397}, CountryId{"FR"}}, // Gare de L'Escarène
    {Coordinate{-1.37122, 46.9069}, CountryId{"FR"}}, // Q3096724
    {Coordinate{5.0475, 43.9174}, CountryId{"FR"}}, // Q3096732
    {Coordinate{5.21944, 45.6075}, CountryId{"FR"}}, // Gare de L'Isle-d'Abeau
    {Coordinate{2.80516, 50.5278}, CountryId{"FR"}}, // Q3096743
    {Coordinate{1.16009, 45.1511}, CountryId{"FR"}}, // Gare de La Bachellerie
    {Coordinate{3.9042, 44.5935}, CountryId{"FR"}}, // Gare de La Bastide - Saint-Laurent-les-Bains
    {Coordinate{-0.40088, 47.4344}, CountryId{"FR"}}, // Gare de La Bohalle
    {Coordinate{-1.66028, 47.2041}, CountryId{"FR"}}, // Gare de Basse-Indre-Saint-Herblain
    {Coordinate{-2.38944, 47.2886}, CountryId{"FR"}}, // La Baule-Escoublac train station
    {Coordinate{-2.03361, 47.0828}, CountryId{"FR"}}, // Gare de La Bernerie-en-Retz
    {Coordinate{-2.11034, 48.2136}, CountryId{"FR"}}, // Gare de La Brohinière
    {Coordinate{2.74609, 45.5906}, CountryId{"FR"}}, // Q3096758
    {Coordinate{-1.28353, 46.6769}, CountryId{"FR"}}, // La Chaize-le-Vicomte
    {Coordinate{7.60284, 44.0625}, CountryId{"FR"}}, // La Brigue railway halt
    {Coordinate{2.50556, 49.1269}, CountryId{"FR"}}, // La Borne Blanche
    {Coordinate{0.627762, 45.1839}, CountryId{"FR"}}, // Gare de La Cave
    {Coordinate{-1.54134, 47.3087}, CountryId{"FR"}}, // Gare de La Chapelle-Aulnay
    {Coordinate{-1.54803, 47.2974}, CountryId{"FR"}}, // Q3096765
    {Coordinate{0.218684, 47.2513}, CountryId{"FR"}}, // Q3096766
    {Coordinate{1.82684, 47.893}, CountryId{"FR"}}, // Estacion de La Chapelle-Saint-Mesmin
    {Coordinate{5.96133, 46.6049}, CountryId{"FR"}}, // Gare de La Chaumusse - Fort-du-Plasne
    {Coordinate{4.29841, 46.2882}, CountryId{"FR"}}, // Q3096769
    {Coordinate{1.35416, 47.6131}, CountryId{"FR"}}, // Q3096770
    {Coordinate{3.02389, 47.1797}, CountryId{"FR"}}, // Gare de La Charité
    {Coordinate{6.82504, 47.0986}, CountryId{"CH"}}, // La Chaux-de-Fonds railway station
    {Coordinate{0.974336, 45.5407}, CountryId{"FR"}}, // Gare de La Coquille
    {Coordinate{0.653075, 47.3386}, CountryId{"FR"}}, // Q3096775
    {Coordinate{3.29775, 48.7821}, CountryId{"FR"}}, // Q3096776
    {Coordinate{-0.379182, 43.2856}, CountryId{"FR"}}, // Gare de La Croix du Prince
    {Coordinate{4.31687, 45.4979}, CountryId{"FR"}}, // Q3096780
    {Coordinate{6.97211, 43.5581}, CountryId{"FR"}}, // Gare de La Frayère
    {Coordinate{6.01006, 43.1187}, CountryId{"FR"}}, // Q3096782
    {Coordinate{3.12075, 49.1796}, CountryId{"FR"}}, // Gare de La Ferté-Milon
    {Coordinate{0.19304, 48.114}, CountryId{"FR"}}, // Q3096784
    {Coordinate{2.94841, 46.9478}, CountryId{"FR"}}, // Gare de La Guerche-sur-l'Aubois
    {Coordinate{35.6106, 49.5583}, CountryId{"UA"}}, // Q30967853
    {Coordinate{-1.90593, 48.6144}, CountryId{"FR"}}, // La Gouesnière - Cancale - Saint-Méloir-des-Ondes
    {Coordinate{-1.39194, 47.1614}, CountryId{"FR"}}, // Gare de La Haye-Fouassière
    {Coordinate{0.105565, 48.3033}, CountryId{"FR"}}, // Q3096791
    {Coordinate{4.01049, 44.2285}, CountryId{"FR"}}, // Q3096792
    {Coordinate{4.49708, 50.7383}, CountryId{"BE"}}, // La Hulpe railway station
    {Coordinate{3.04083, 47.1392}, CountryId{"FR"}}, // Gare de La Marche
    {Coordinate{-1.65958, 46.6071}, CountryId{"FR"}}, // La Mothe-Achard
    {Coordinate{5.99961, 46.1787}, CountryId{"CH"}}, // La Plaine
    {Coordinate{4.35815, 45.4034}, CountryId{"FR"}}, // Q3096803
    {Coordinate{-0.691705, 47.3714}, CountryId{"FR"}}, // Q3096804
    {Coordinate{4.17017, 47.3853}, CountryId{"FR"}}, // Q3096808
    {Coordinate{1.36554, 45.1397}, CountryId{"FR"}}, // Gare de La Rivière-de-Mansac
    {Coordinate{4.71615, 45.8001}, CountryId{"FR"}}, // Q3096811
    {Coordinate{0.026461, 47.8924}, CountryId{"FR"}}, // Gare de La Suze
    {Coordinate{1.37291, 48.4074}, CountryId{"FR"}}, // Q3096814
    {Coordinate{7.31206, 43.7432}, CountryId{"FR"}}, // Q3096816
    {Coordinate{2.5917, 46.35}, CountryId{"FR"}}, // Q3096819
    {Coordinate{7.85518, 48.6796}, CountryId{"FR"}}, // Q3096820
    {Coordinate{1.21694, 44.0356}, CountryId{"FR"}}, // Gare de La Ville-Dieu
    {Coordinate{2.26542, 44.9203}, CountryId{"FR"}}, // Q3096824
    {Coordinate{4.18528, 50.3161}, CountryId{"BE"}}, // Labuissière railway station
    {Coordinate{1.82648, 45.6412}, CountryId{"FR"}}, // Q3096826
    {Coordinate{1.5129, 43.5474}, CountryId{"FR"}}, // Gare de Labège-Innopole
    {Coordinate{3.61035, 45.1229}, CountryId{"FR"}}, // Q3096828
    {Coordinate{37.7296, 49.8522}, CountryId{"UA"}}, // Dvorichna
    {Coordinate{0.217, 47.874}, CountryId{"FR"}}, // Q3096830
    {Coordinate{37.9083, 49.9603}, CountryId{"UA"}}, // Q30968307
    {Coordinate{4.69282, 49.9114}, CountryId{"FR"}}, // Gare de Laifour
    {Coordinate{1.13101, 45.6339}, CountryId{"FR"}}, // Gare de Lafarge
    {Coordinate{0.742823, 44.8396}, CountryId{"FR"}}, // Gare de Lalinde
    {Coordinate{5.7591, 48.0905}, CountryId{"FR"}}, // Q3096839
    {Coordinate{0.380301, 44.8434}, CountryId{"FR"}}, // Gare de Lamonzie-Saint-Martin
    {Coordinate{0.02152, 44.8538}, CountryId{"FR"}}, // Gare de Lamothe-Montravel
    {Coordinate{-3.08639, 47.7361}, CountryId{"FR"}}, // Q3096845
    {Coordinate{6.22803, 48.6555}, CountryId{"FR"}}, // Gare de Laneuveville-devant-Nancy
    {Coordinate{3.4905, 45.1012}, CountryId{"FR"}}, // Q3096847
    {Coordinate{0.410647, 47.324}, CountryId{"FR"}}, // Q3096848
    {Coordinate{-3.12556, 47.7597}, CountryId{"FR"}}, // Gare de Landévant
    {Coordinate{2.89326, 46.2268}, CountryId{"FR"}}, // Q3096852
    {Coordinate{4.86109, 47.3351}, CountryId{"FR"}}, // Q3096853
    {Coordinate{8.06109, 47.5595}, CountryId{"CH"}}, // Laufenburg railway station
    {Coordinate{1.41599, 45.1321}, CountryId{"FR"}}, // Gare de Larche
    {Coordinate{7.50263, 47.4193}, CountryId{"CH"}}, // Laufen railway station
    {Coordinate{0.965004, 46.3381}, CountryId{"FR"}}, // Q3096858
    {Coordinate{7.75986, 47.4702}, CountryId{"CH"}}, // Lausen railway station
    {Coordinate{2.27008, 46.3213}, CountryId{"FR"}}, // Q3096862
    {Coordinate{6.62611, 46.5233}, CountryId{"CH"}}, // Lausanne-Chauderon railway station
    {Coordinate{2.08912, 46.0795}, CountryId{"FR"}}, // Q3096864
    {Coordinate{1.81235, 43.7034}, CountryId{"FR"}}, // Q3096865
    {Coordinate{3.90531, 45.1214}, CountryId{"FR"}}, // Q3096866
    {Coordinate{7.91366, 48.5585}, CountryId{"DE"}}, // Legelshurst
    {Coordinate{4.66718, 45.8218}, CountryId{"FR"}}, // Gare de Lentilly
    {Coordinate{4.68213, 45.8164}, CountryId{"FR"}}, // Q3096872
    {Coordinate{4.22112, 50.7147}, CountryId{"BE"}}, // Lembeek railway station
    {Coordinate{3.9034, 50.559}, CountryId{"BE"}}, // Lens railway station
    {Coordinate{2.82786, 50.4267}, CountryId{"FR"}}, // Gare de Lens
    {Coordinate{-0.945278, 45.3036}, CountryId{"FR"}}, // Gare de Lesparre
    {Coordinate{3.83734, 50.1837}, CountryId{"FR"}}, // Leval
    {Coordinate{4.26728, 47.2138}, CountryId{"FR"}}, // Q3096879
    {Coordinate{7.73148, 47.4844}, CountryId{"CH"}}, // Liestal railway station
    {Coordinate{7.65969, 48.4609}, CountryId{"FR"}}, // Limersheim
    {Coordinate{1.747, 48.9843}, CountryId{"FR"}}, // Limay
    {Coordinate{1.04957, 47.4501}, CountryId{"FR"}}, // Q3096886
    {Coordinate{4.36583, 50.6453}, CountryId{"BE"}}, // Lillois railway station
    {Coordinate{0.977793, 45.1563}, CountryId{"FR"}}, // Gare de Limeyrat
    {Coordinate{6.06177, 48.7494}, CountryId{"FR"}}, // Gare de Liverdun
    {Coordinate{3.19445, 51.2947}, CountryId{"BE"}}, // Lissewege railway station
    {Coordinate{-1.0504, 49.227}, CountryId{"FR"}}, // Gare de Lison
    {Coordinate{2.85918, 50.4402}, CountryId{"FR"}}, // Q3096897
    {Coordinate{2.79323, 50.4379}, CountryId{"FR"}}, // Gare de Loos-en-Gohelle
    {Coordinate{2.71755, 49.3425}, CountryId{"FR"}}, // Q3096904
    {Coordinate{2.00278, 50.0117}, CountryId{"FR"}}, // Gare de Longpré-les-Corps-Saints
    {Coordinate{3.01701, 50.6128}, CountryId{"FR"}}, // Station Loos-lez-Lille
    {Coordinate{5.21741, 46.6309}, CountryId{"FR"}}, // Gare de Louhans
    {Coordinate{2.98486, 46.2241}, CountryId{"FR"}}, // Q3096909
    {Coordinate{-3.36611, 47.7553}, CountryId{"FR"}}, // Gare de Lorient
    {Coordinate{3.89146, 44.6541}, CountryId{"FR"}}, // Q3096912
    {Coordinate{3.74583, 47.6281}, CountryId{"FR"}}, // Q3096916
    {Coordinate{5.45472, 44.6136}, CountryId{"FR"}}, // Gare de Luc-en-Diois
    {Coordinate{6.17088, 48.6221}, CountryId{"FR"}}, // Q3096918
    {Coordinate{4.78323, 49.7331}, CountryId{"FR"}}, // Q3096919
    {Coordinate{3.19475, 43.7093}, CountryId{"FR"}}, // Q3096920
    {Coordinate{4.09352, 43.6811}, CountryId{"FR"}}, // Gare de Lunel-Viel
    {Coordinate{7.11906, 48.0355}, CountryId{"FR"}}, // Luttenbach-près-Munster station
    {Coordinate{0.718649, 46.4052}, CountryId{"FR"}}, // Lussac-les-Châteaux railway station
    {Coordinate{7.27704, 47.7582}, CountryId{"FR"}}, // Gare de Lutterbach
    {Coordinate{3.96939, 46.7942}, CountryId{"FR"}}, // Q3096928
    {Coordinate{-1.16738, 46.4638}, CountryId{"FR"}}, // Luçon
    {Coordinate{7.85636, 47.3921}, CountryId{"CH"}}, // Läufelfingen railway station
    {Coordinate{5.53847, 48.797}, CountryId{"FR"}}, // Q3096935
    {Coordinate{7.6951, 47.6374}, CountryId{"DE"}}, // Q3096937
    {Coordinate{7.66111, 47.6075}, CountryId{"DE"}}, // Lörrach-Museum/Burghof
    {Coordinate{7.67278, 47.6244}, CountryId{"DE"}}, // Lörrach-Schwarzwaldstraße
    {Coordinate{10.945, 59.945}, CountryId{"NO"}}, // Lørenskog Station
    {Coordinate{-0.619829, 45.0041}, CountryId{"FR"}}, // gare de Macau
    {Coordinate{7.65917, 47.6011}, CountryId{"DE"}}, // Lörrach-Stetten
    {Coordinate{6.32809, 46.2513}, CountryId{"FR"}}, // Machilly
    {Coordinate{-1.8225, 46.99}, CountryId{"FR"}}, // Gare de Machecoul
    {Coordinate{3.22948, 43.4676}, CountryId{"FR"}}, // Gare de Magalas
    {Coordinate{6.62157, 46.0169}, CountryId{"FR"}}, // Q3096951
    {Coordinate{3.73373, 49.31}, CountryId{"FR"}}, // Gare de Magneux-Courlandon
    {Coordinate{2.60282, 46.4642}, CountryId{"FR"}}, // Q3096954
    {Coordinate{1.28105, 48.3343}, CountryId{"FR"}}, // Q3096955
    {Coordinate{6.15845, 49.2155}, CountryId{"FR"}}, // Gare de Maizières-lès-Metz
    {Coordinate{0.58302, 47.0533}, CountryId{"FR"}}, // Q3096962
    {Coordinate{2.42639, 48.8019}, CountryId{"FR"}}, // Maisons-Alfort – Alfortville
    {Coordinate{6.94145, 43.5239}, CountryId{"FR"}}, // Gare de Mandelieu-la-Napoule
    {Coordinate{4.47935, 43.8264}, CountryId{"FR"}}, // Manduel - Redessan
    {Coordinate{4.32671, 47.1325}, CountryId{"FR"}}, // Q3096967
    {Coordinate{6.10937, 48.8021}, CountryId{"FR"}}, // Q3096968
    {Coordinate{-1.00138, 46.3042}, CountryId{"FR"}}, // Marans Station
    {Coordinate{3.40301, 49.4393}, CountryId{"FR"}}, // Gare de Margival
    {Coordinate{-0.685424, 45.0359}, CountryId{"FR"}}, // Gare de Margaux
    {Coordinate{2.58167, 49.8533}, CountryId{"FR"}}, // Gare de Marcelcave
    {Coordinate{1.93069, 50.408}, CountryId{"FR"}}, // Q3096975
    {Coordinate{6.50785, 46.0888}, CountryId{"FR"}}, // Marignier railway station
    {Coordinate{5.07319, 46.0639}, CountryId{"FR"}}, // Gare de Marlieux - Châtillon
    {Coordinate{-0.428446, 46.1991}, CountryId{"FR"}}, // Gare de Marigny
    {Coordinate{4.36029, 46.8335}, CountryId{"FR"}}, // Q3096980
    {Coordinate{2.28264, 47.1}, CountryId{"FR"}}, // Q3096981
    {Coordinate{1.5856, 46.0942}, CountryId{"FR"}}, // Q3096983
    {Coordinate{0.168031, 44.5032}, CountryId{"FR"}}, // Gare de Marmande
    {Coordinate{7.07912, 46.1058}, CountryId{"CH"}}, // Martigny railway station
    {Coordinate{2.02659, 43.9151}, CountryId{"FR"}}, // Gare de Marssac-sur-Tarn
    {Coordinate{3.28101, 44.5447}, CountryId{"FR"}}, // Q3096989
    {Coordinate{2.69816, 50.3225}, CountryId{"FR"}}, // Q3096993
    {Coordinate{-1.91417, 47.6744}, CountryId{"FR"}}, // Massérac
    {Coordinate{7.61969, 48.3989}, CountryId{"FR"}}, // Matzenheim
    {Coordinate{0.265901, 47.7601}, CountryId{"FR"}}, // Q3097004
    {Coordinate{2.05987, 48.9872}, CountryId{"FR"}}, // Q3097005
    {Coordinate{2.7013, 50.4606}, CountryId{"FR"}}, // Q3097006
    {Coordinate{0.789937, 44.8558}, CountryId{"FR"}}, // Gare de Mauzac
    {Coordinate{2.87371, 48.958}, CountryId{"FR"}}, // Gare de Meaux
    {Coordinate{1.40564, 47.6451}, CountryId{"FR"}}, // Q3097014
    {Coordinate{3.50188, 44.5223}, CountryId{"FR"}}, // Gare de Mende
    {Coordinate{3.11407, 50.7996}, CountryId{"BE"}}, // Menen railway station
    {Coordinate{1.50622, 47.706}, CountryId{"FR"}}, // Q3097018
    {Coordinate{7.51694, 43.785}, CountryId{"FR"}}, // Gare de Menton-Garavan
    {Coordinate{5.17938, 46.7989}, CountryId{"FR"}}, // Q3097025
    {Coordinate{6.1379, 48.6129}, CountryId{"FR"}}, // Q3097027
    {Coordinate{4.24493, 46.8629}, CountryId{"FR"}}, // Q3097030
    {Coordinate{7.07322, 48.0132}, CountryId{"FR"}}, // gare de Metzeral
    {Coordinate{3.00639, 47.2422}, CountryId{"FR"}}, // Gare de Mesves-Bulcy
    {Coordinate{6.28366, 49.3181}, CountryId{"FR"}}, // Station Metzervisse
    {Coordinate{6.16795, 49.1369}, CountryId{"FR"}}, // Gare de Metz-Nord
    {Coordinate{2.89319, 50.4973}, CountryId{"FR"}}, // Gare de Meurchin
    {Coordinate{1.90199, 49.0055}, CountryId{"FR"}}, // Gare de Meulan - Hardricourt
    {Coordinate{4.7945, 46.9677}, CountryId{"FR"}}, // Gare de Meursault
    {Coordinate{3.07437, 44.1024}, CountryId{"FR"}}, // Q3097038
    {Coordinate{4.30323, 43.7886}, CountryId{"FR"}}, // Gare de Milhaud
    {Coordinate{0.918035, 45.1291}, CountryId{"FR"}}, // Gare de Milhac-d'Auberoche
    {Coordinate{4.91961, 45.8968}, CountryId{"FR"}}, // Q3097042
    {Coordinate{5.60003, 50.6928}, CountryId{"BE"}}, // Milmort railway station
    {Coordinate{4.95388, 45.8221}, CountryId{"FR"}}, // Q3097047
    {Coordinate{5.56492, 45.3241}, CountryId{"FR"}}, // Q3097052
    {Coordinate{4.16023, 44.2593}, CountryId{"FR"}}, // Q3097055
    {Coordinate{4.73327, 49.7527}, CountryId{"FR"}}, // Gare de Mohon
    {Coordinate{3.64988, 44.9697}, CountryId{"FR"}}, // Gare de Monistrol-d'Allier
    {Coordinate{7.50009, 48.5373}, CountryId{"FR"}}, // Gare de Molsheim
    {Coordinate{0.793249, 47.4988}, CountryId{"FR"}}, // Gare de Monnaie
    {Coordinate{5.63391, 44.9119}, CountryId{"FR"}}, // Monestier-de-Clermont
    {Coordinate{1.73394, 46.1368}, CountryId{"FR"}}, // Q3097064
    {Coordinate{-1.31635, 46.9838}, CountryId{"FR"}}, // Montaigu
    {Coordinate{0.190705, 48.1513}, CountryId{"FR"}}, // Q3097066
    {Coordinate{0.721381, 47.2917}, CountryId{"FR"}}, // Q3097067
    {Coordinate{3.94172, 50.454}, CountryId{"BE"}}, // Mons railway station
    {Coordinate{4.03884, 49.194}, CountryId{"FR"}}, // Q3097070
    {Coordinate{4.48151, 46.7593}, CountryId{"FR"}}, // Q3097072
    {Coordinate{4.36105, 46.6706}, CountryId{"FR"}}, // Q3097073
    {Coordinate{-0.198324, 43.1271}, CountryId{"FR"}}, // Gare de Montaut-Bétharram
    {Coordinate{4.74069, 49.8657}, CountryId{"FR"}}, // Gare de Monthermé
    {Coordinate{1.57771, 43.4752}, CountryId{"FR"}}, // Gare de Montlaur
    {Coordinate{5.37162, 49.5229}, CountryId{"FR"}}, // Montmédy
    {Coordinate{0.817277, 47.3915}, CountryId{"FR"}}, // Gare de Montlouis
    {Coordinate{2.73861, 48.3364}, CountryId{"FR"}}, // Gare de Montigny-sur-Loing
    {Coordinate{3.10969, 43.8685}, CountryId{"FR"}}, // Q3097085
    {Coordinate{6.04313, 45.5031}, CountryId{"FR"}}, // Montmélian
    {Coordinate{-0.148103, 47.1253}, CountryId{"FR"}}, // Gare de Montreuil-Bellay
    {Coordinate{0.159355, 45.0062}, CountryId{"FR"}}, // Gare de Montpon-Ménestérol
    {Coordinate{7.05087, 47.8607}, CountryId{"FR"}}, // Gare de Moosch
    {Coordinate{-0.4181, 47.739}, CountryId{"FR"}}, // Q3097100
    {Coordinate{0.6547, 47.2818}, CountryId{"FR"}}, // Q3097101
    {Coordinate{4.74472, 44.5592}, CountryId{"FR"}}, // Montélimar railway station
    {Coordinate{1.33444, 49.6031}, CountryId{"FR"}}, // Gare de Montérolier-Buchy
    {Coordinate{6.65936, 48.9365}, CountryId{"FR"}}, // Gare de Morhange
    {Coordinate{4.90834, 43.9414}, CountryId{"FR"}}, // Q3097106
    {Coordinate{7.034, 45.7572}, CountryId{"IT"}}, // Q3097107
    {Coordinate{1.24778, 49.5233}, CountryId{"FR"}}, // Gare de Morgny
    {Coordinate{4.2471, 50.4585}, CountryId{"BE"}}, // Morlanwelz railway station
    {Coordinate{8.16164, 48.9347}, CountryId{"FR"}}, // Q3097112
    {Coordinate{-0.744705, 45.084}, CountryId{"FR"}}, // gare de Moulis - Listrac
    {Coordinate{6.97417, 43.6206}, CountryId{"FR"}}, // Gare de Mouans-Sartoux
    {Coordinate{4.31778, 49.1313}, CountryId{"FR"}}, // Gare de Mourmelon-le-Petit
    {Coordinate{2.47333, 48.5861}, CountryId{"FR"}}, // Moulin-Galant
    {Coordinate{7.08774, 48.0246}, CountryId{"FR"}}, // Muhlbach-sur-Munster station
    {Coordinate{3.22806, 50.74}, CountryId{"BE"}}, // Mouscron railway station
    {Coordinate{6.53119, 45.4862}, CountryId{"FR"}}, // Gare de Moûtiers-Salins-Brides-les-Bains
    {Coordinate{7.9098, 47.5475}, CountryId{"CH"}}, // Mumpf railway station
    {Coordinate{8.14112, 48.924}, CountryId{"FR"}}, // Q3097133
    {Coordinate{7.33125, 47.7363}, CountryId{"FR"}}, // Gare de Mulhouse-Hasenrain
    {Coordinate{7.15278, 48.0391}, CountryId{"FR"}}, // Q3097135
    {Coordinate{7.13416, 48.0383}, CountryId{"FR"}}, // Gare de Munster
    {Coordinate{2.86964, 45.109}, CountryId{"FR"}}, // Gare de Murat
    {Coordinate{7.64806, 47.5336}, CountryId{"CH"}}, // Muttenz
    {Coordinate{0.353911, 45.0345}, CountryId{"FR"}}, // Gare de Mussidan
    {Coordinate{1.60103, 48.9666}, CountryId{"FR"}}, // Gare de Ménerville
    {Coordinate{1.15058, 43.6367}, CountryId{"FR"}}, // Mérenvielle train station
    {Coordinate{1.83667, 42.6589}, CountryId{"FR"}}, // Gare de Mérens-les-Vals
    {Coordinate{2.13278, 49.2319}, CountryId{"FR"}}, // Gare de Méru
    {Coordinate{7.83403, 47.5619}, CountryId{"CH"}}, // Möhlin railway station
    {Coordinate{7.59935, 47.8101}, CountryId{"DE"}}, // Müllheim (Baden) station
    {Coordinate{7.61727, 47.5132}, CountryId{"CH"}}, // Münchenstein railway station
    {Coordinate{2.19083, 49.0578}, CountryId{"FR"}}, // Gare de Méry-sur-Oise
    {Coordinate{18.9554, 47.3852}, CountryId{"HU"}}, // Tétényliget railway station
    {Coordinate{18.9741, 47.3981}, CountryId{"HU"}}, // Nagytétény-Diósd railway station
    {Coordinate{4.99756, 50.4701}, CountryId{"BE"}}, // Namêche railway station
    {Coordinate{5.29118, 48.7181}, CountryId{"FR"}}, // Q3097170
    {Coordinate{4.92981, 50.4196}, CountryId{"BE"}}, // Naninne railway station
    {Coordinate{1.15638, 46.0056}, CountryId{"FR"}}, // Q3097172
    {Coordinate{17.4417, 68.4417}, CountryId{"NO"}}, // Narvik Station
    {Coordinate{2.3635, 44.1855}, CountryId{"FR"}}, // Gare de Naucelle
    {Coordinate{7.56194, 47.8115}, CountryId{"DE"}}, // Neuenburg
    {Coordinate{1.43576, 49.7334}, CountryId{"FR"}}, // Gare de Neufchâtel-en-Bray
    {Coordinate{5.45265, 49.8541}, CountryId{"BE"}}, // Neufchâteau railway station
    {Coordinate{5.74167, 50.5719}, CountryId{"BE"}}, // Nessonvaux railway station
    {Coordinate{1.64327, 50.6237}, CountryId{"FR"}}, // Q3097187
    {Coordinate{5.11176, 47.2815}, CountryId{"FR"}}, // Q3097188
    {Coordinate{8.62972, 58.6572}, CountryId{"NO"}}, // Nelaug Station
    {Coordinate{0.564776, 47.5579}, CountryId{"FR"}}, // Gare de Neuillé-Pont-Pierre
    {Coordinate{6.10789, 48.6148}, CountryId{"FR"}}, // Q3097192
    {Coordinate{0.199639, 48.0704}, CountryId{"FR"}}, // Q3097193
    {Coordinate{3.1638, 47.0069}, CountryId{"FR"}}, // Q3097195
    {Coordinate{0.445105, 45.0999}, CountryId{"FR"}}, // Gare de Neuvic
    {Coordinate{3.14669, 47.0056}, CountryId{"FR"}}, // Gare de Nevers-les-Perrières
    {Coordinate{7.28687, 43.7153}, CountryId{"FR"}}, // Nice-Saint-Roch
    {Coordinate{7.21642, 43.6708}, CountryId{"FR"}}, // Nice-Saint-Augustin
    {Coordinate{3.11667, 43.2956}, CountryId{"FR"}}, // Nissan
    {Coordinate{0.896264, 47.4098}, CountryId{"FR"}}, // Estacion de Noizay
    {Coordinate{0.219734, 48.7039}, CountryId{"FR"}}, // Nonant-le-Pin
    {Coordinate{1.19297, 48.7757}, CountryId{"FR"}}, // Nonancourt Station
    {Coordinate{0.706985, 47.4597}, CountryId{"FR"}}, // Q3097220
    {Coordinate{6.46863, 45.5393}, CountryId{"FR"}}, // Q3097221
    {Coordinate{4.79484, 49.6972}, CountryId{"FR"}}, // Q3097227
    {Coordinate{2.0329, 47.5346}, CountryId{"FR"}}, // Gare de Nouan-le-Fuzelier
    {Coordinate{-0.0983333, 47.8744}, CountryId{"FR"}}, // Q3097229
    {Coordinate{4.20732, 43.976}, CountryId{"FR"}}, // Q3097231
    {Coordinate{4.95618, 47.1305}, CountryId{"FR"}}, // Nuits-Saint-Georges train station
    {Coordinate{1.70471, 50.1874}, CountryId{"FR"}}, // Gare de Noyelles
    {Coordinate{7.47114, 45.7389}, CountryId{"IT"}}, // Nus train station
    {Coordinate{0.861185, 45.346}, CountryId{"FR"}}, // Gare de Négrondes
    {Coordinate{2.67438, 50.4831}, CountryId{"FR"}}, // Q3097237
    {Coordinate{1.84069, 48.9388}, CountryId{"FR"}}, // Nézel - Aulnay
    {Coordinate{5.73382, 48.6967}, CountryId{"FR"}}, // Gare de Pagny-sur-Meuse
    {Coordinate{3.21677, 45.6143}, CountryId{"FR"}}, // Q3097244
    {Coordinate{4.11372, 46.4473}, CountryId{"FR"}}, // Gare de Paray-le-Monial
    {Coordinate{-0.619498, 44.9441}, CountryId{"FR"}}, // gare de Parempuyre
    {Coordinate{1.61944, 43.1161}, CountryId{"FR"}}, // Gare de Pamiers
    {Coordinate{2.17469, 46.1984}, CountryId{"FR"}}, // Q3097250
    {Coordinate{-0.755093, 45.2038}, CountryId{"FR"}}, // gare de Pauillac
    {Coordinate{3.50045, 45.2102}, CountryId{"FR"}}, // Q3097258
    {Coordinate{7.38, 43.7919}, CountryId{"FR"}}, // Q3097259
    {Coordinate{7.36677, 43.7679}, CountryId{"FR"}}, // Gare de Peillon-Sainte-Thècle
    {Coordinate{6.22245, 49.0736}, CountryId{"FR"}}, // Q3097261
    {Coordinate{0.950467, 49.564}, CountryId{"FR"}}, // Gare de Pavilly-Station
    {Coordinate{-3.13306, 47.5581}, CountryId{"FR"}}, // Gare de Penthièvre
    {Coordinate{2.26542, 44.9203}, CountryId{"FR"}}, // Q3097265
    {Coordinate{7.29994, 49.0494}, CountryId{"FR"}}, // gare de Petit-Réderching
    {Coordinate{1.14105, 47.8674}, CountryId{"FR"}}, // Q3097269
    {Coordinate{6.12416, 48.5489}, CountryId{"FR"}}, // Q3097271
    {Coordinate{2.33417, 48.6756}, CountryId{"FR"}}, // Petit Vaux
    {Coordinate{4.28879, 50.4349}, CountryId{"BE"}}, // Piéton railway station
    {Coordinate{-1.85075, 48.5316}, CountryId{"FR"}}, // Plerguer
    {Coordinate{1.96001, 48.8308}, CountryId{"FR"}}, // Q3097278
    {Coordinate{-3.11837, 47.6043}, CountryId{"FR"}}, // Gare de Plouharnel-Carnac
    {Coordinate{-3.37059, 48.4583}, CountryId{"FR"}}, // Q3097284
    {Coordinate{-0.359057, 44.649}, CountryId{"FR"}}, // Gare de Podensac
    {Coordinate{5.47378, 45.2559}, CountryId{"FR"}}, // Q3097293
    {Coordinate{-1.1265, 49.1625}, CountryId{"FR"}}, // Gare de Pont-Hébert
    {Coordinate{6.10288, 48.6025}, CountryId{"FR"}}, // Q3097296
    {Coordinate{4.13739, 45.2599}, CountryId{"FR"}}, // Gare de Pont-de-Lignon
    {Coordinate{3.13059, 50.6239}, CountryId{"FR"}}, // Pont-de-Bois
    {Coordinate{2.86296, 50.4159}, CountryId{"FR"}}, // Gare de Pont-de-Sallaumines
    {Coordinate{3.49049, 45.8428}, CountryId{"FR"}}, // Gare de Pont-de-Dore
    {Coordinate{2.87515, 50.4714}, CountryId{"FR"}}, // Q3097306
    {Coordinate{3.20175, 48.2863}, CountryId{"FR"}}, // Gare de Pont-sur-Yonne
    {Coordinate{4.77277, 46.2131}, CountryId{"FR"}}, // Gare de Pontanevaux
    {Coordinate{4.49287, 45.8714}, CountryId{"FR"}}, // Q3097312
    {Coordinate{3.16003, 45.9398}, CountryId{"FR"}}, // Gare de Pontmort
    {Coordinate{2.54444, 48.535}, CountryId{"FR"}}, // Gare de Ponthierry - Pringy
    {Coordinate{7.08007, 47.4209}, CountryId{"CH"}}, // Porrentruy railway station
    {Coordinate{0.155535, 47.2487}, CountryId{"FR"}}, // Q3097321
    {Coordinate{-1.73944, 47.1167}, CountryId{"FR"}}, // Gare de Port-Saint-Père-Saint-Mars
    {Coordinate{-2.34489, 47.2706}, CountryId{"FR"}}, // Pornichet train station
    {Coordinate{1.52338, 49.0627}, CountryId{"FR"}}, // Q3097324
    {Coordinate{4.98463, 43.4073}, CountryId{"FR"}}, // Q3097326
    {Coordinate{0.390556, 44.25}, CountryId{"FR"}}, // Gare de Port-Sainte-Marie
    {Coordinate{1.14601, 41.0884}, CountryId{"ES"}}, // Port Aventura
    {Coordinate{3.09387, 47.0768}, CountryId{"FR"}}, // Gare de Pougues-les-Eaux
    {Coordinate{6.12664, 48.3226}, CountryId{"FR"}}, // Q3097337
    {Coordinate{2.96361, 47.2828}, CountryId{"FR"}}, // Gare de Pouilly-sur-Loire
    {Coordinate{7.69131, 47.5228}, CountryId{"CH"}}, // Pratteln railway station
    {Coordinate{7.71024, 47.5307}, CountryId{"CH"}}, // Pratteln Salina Raurica station
    {Coordinate{6.10076, 48.4328}, CountryId{"FR"}}, // Gare de Praye-sous-Vaudémont
    {Coordinate{4.18382, 49.1987}, CountryId{"FR"}}, // gare de Prunay
    {Coordinate{-0.302356, 44.5784}, CountryId{"FR"}}, // Gare de Preignac
    {Coordinate{3.46114, 50.3167}, CountryId{"FR"}}, // Q3097348
    {Coordinate{7.08556, 48.3047}, CountryId{"FR"}}, // Gare de Provenchères-sur-Fave
    {Coordinate{1.67204, 47.3132}, CountryId{"FR"}}, // Q3097351
    {Coordinate{6.13745, 48.5361}, CountryId{"FR"}}, // Q3097353
    {Coordinate{1.97772, 45.585}, CountryId{"FR"}}, // Q3097359
    {Coordinate{0.733615, 45.1784}, CountryId{"FR"}}, // Gare de Périgueux-Saint-Georges
    {Coordinate{1.73037, 43.8196}, CountryId{"FR"}}, // Gare de Rabastens-Couffouleux
    {Coordinate{3.68667, 50.41}, CountryId{"BE"}}, // Quiévrain railway station
    {Coordinate{7.01245, 47.8817}, CountryId{"FR"}}, // Gare de Ranspach
    {Coordinate{6.9693, 43.5691}, CountryId{"FR"}}, // Gare de Ranguin
    {Coordinate{0.599256, 45.1659}, CountryId{"FR"}}, // Gare de Razac
    {Coordinate{0.900974, 47.2181}, CountryId{"FR"}}, // Q3097388
    {Coordinate{6.26744, 46.1255}, CountryId{"FR"}}, // Reignier
    {Coordinate{6.57893, 46.537}, CountryId{"CH"}}, // Renens VD railway station
    {Coordinate{2.37205, 50.732}, CountryId{"FR"}}, // Q3097394
    {Coordinate{4.03614, 45.2013}, CountryId{"FR"}}, // Q3097397
    {Coordinate{4.98536, 48.8242}, CountryId{"FR"}}, // Gare de Revigny
    {Coordinate{7.78361, 47.5567}, CountryId{"DE"}}, // Rheinfelden railway station
    {Coordinate{4.64286, 49.9387}, CountryId{"FR"}}, // Gare de Revin
    {Coordinate{7.76813, 47.5456}, CountryId{"CH"}}, // Rheinfelden-Augarten railway station
    {Coordinate{1.10015, 41.1605}, CountryId{"ES"}}, // Reus railway station
    {Coordinate{7.65167, 47.5831}, CountryId{"CH"}}, // Riehen
    {Coordinate{7.63333, 47.5694}, CountryId{"CH"}}, // Riehen-Niederholz
    {Coordinate{0.36192, 47.2677}, CountryId{"FR"}}, // Q3097413
    {Coordinate{5.49167, 45.3575}, CountryId{"FR"}}, // Rives railway station
    {Coordinate{9.73621, 44.1007}, CountryId{"IT"}}, // Riomaggiore
    {Coordinate{4.16111, 51.4228}, CountryId{"NL"}}, // Rilland-Bath railway station
    {Coordinate{4.12272, 44.2768}, CountryId{"FR"}}, // Q3097422
    {Coordinate{7.40618, 47.7487}, CountryId{"FR"}}, // Rixheim station
    {Coordinate{10.4589, 63.0044}, CountryId{"NO"}}, // Rognes Station
    {Coordinate{2.1725, 49.3989}, CountryId{"FR"}}, // Gare de Rochy-Condé
    {Coordinate{7.26458, 49.0554}, CountryId{"FR"}}, // Gare de Rohrbach-lès-Bitche
    {Coordinate{5.23058, 43.4866}, CountryId{"FR"}}, // Q3097434
    {Coordinate{6.60315, 46.5624}, CountryId{"CH"}}, // R