/* ----- decode/761x4591, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_761x4591_checksums[] = {
  "e1f8b74a5bf8507d583864d986c9febfecbaf6a447fc0ef78949e0c2684004ce",
  "278e3fba567cece740483ca6d1c367e929189741d75f068c38dee2b7467cf58b",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_761x4591_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_761x4591_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_761x4591_ITEMBYTES

static void *storage_decode_761x4591_x;
static unsigned char *test_decode_761x4591_x;
static void *storage_decode_761x4591_s;
static unsigned char *test_decode_761x4591_s;
static void *storage_decode_761x4591_x2;
static unsigned char *test_decode_761x4591_x2;
static void *storage_decode_761x4591_s2;
static unsigned char *test_decode_761x4591_s2;

#define precomputed_decode_761x4591_NUM 4

static const int16_t precomputed_decode_761x4591_x[precomputed_decode_761x4591_NUM][crypto_decode_ITEMS] = {
  {-287,-1583,773,-638,-1886,-606,-2182,1029,-1746,-1168,-990,-595,1390,-922,797,-352,-199,-1548,-2125,1738,-736,-2043,1397,-1041,-635,348,51,-1146,-564,-876,30,2051,-1426,-119,-234,-451,-1608,2109,-1320,903,486,1027,1839,-489,-1779,1472,-1992,2101,1570,469,-1036,-1616,-415,-396,1856,-1478,1558,578,-1830,740,-2268,2024,-1542,-704,848,2070,-134,-1454,454,1800,1020,1411,1682,-1913,1101,-1434,1834,1336,-1831,-1123,-2176,-2086,-697,676,1547,-1856,-1901,516,-453,-686,480,2041,313,1995,-934,27,1279,-1001,-697,495,-1406,-1824,-937,778,-1783,1762,-371,-2248,870,-1547,2251,1730,-2200,1376,627,738,1592,-2099,-1774,-43,474,-819,361,-1065,1111,467,1639,701,-1780,-1460,1246,1411,-501,-1043,1860,1366,-1874,-845,-127,200,2288,928,1191,-441,943,-118,-656,-763,871,1862,521,433,1736,-1257,887,799,-1232,1354,2285,-2067,1519,39,-1396,1488,-2056,1453,-1946,1572,2078,1980,-1384,365,-104,-939,2136,-1705,-824,-1244,2169,348,95,1791,1475,478,674,-108,173,1000,669,5,1270,-296,-989,-2040,2092,39,-1409,-1098,502,-833,1017,1030,1484,320,-2219,-1903,-732,-2216,-1079,-625,-1662,-1007,1128,1699,-1736,-531,1483,1569,2016,-345,1722,-1498,-425,-2233,1133,-939,-2047,1548,915,-673,-930,-1139,-626,358,379,-224,-1418,-352,1885,1849,-900,463,-1000,-1244,-33,1844,-504,-1551,-1433,2069,-136,-1564,-451,-1533,-983,-1440,703,-922,-1784,675,884,1536,-1927,-553,1150,-259,-322,-1502,-1251,810,-693,1902,1243,1787,1700,-1329,-424,1793,1519,-2230,1209,1269,2080,-69,-1824,-1796,-815,1762,-1191,1668,2223,708,-1873,-1483,76,-1642,-2176,343,-1647,-10,-834,1656,-833,-1151,1525,-572,-176,759,12,479,-541,-2265,-509,-2131,775,137,745,310,-859,-144,1490,879,449,543,726,-955,-479,637,-1631,-1912,1160,1297,117,81,874,1036,1187,-431,-1174,1435,1121,-1902,2074,-170,1848,1534,-1047,834,23,-227,1927,358,-1934,-1595,-1376,575,156,-2295,12,88,1532,-1900,551,-2168,-1367,-1501,-1004,-1475,-1218,1302,2211,-1475,-1655,-320,-645,1688,939,-759,849,-21,-284,1047,1642,-418,1573,666,-2207,-1767,1282,-1269,-283,1565,671,-844,-1995,-417,2118,-635,-1973,-2003,-424,-1520,278,1258,1372,76,833,2284,1890,-1308,1136,-240,1072,1089,-2259,998,-480,-1050,-111,567,-1981,2053,477,-1776,-1294,-1507,1415,2087,-1188,720,907,669,-2239,213,-1934,1616,959,-1165,-1734,137,870,1941,-87,1820,254,-2246,-1616,-2109,1370,-1624,-1527,-1293,-911,1476,-288,-1679,-1498,-810,1937,19,-2262,-1956,886,-1665,-487,571,1887,1632,-1601,-2284,995,-2173,202,602,-295,-758,-1905,1461,-70,1238,303,1764,854,-1657,1520,-1884,-597,-1965,1612,1325,-375,1118,-1252,254,423,-230,-948,-823,125,-899,-326,-1898,1563,730,-1674,1963,1198,1154,-2220,-756,-353,2065,-1832,-1772,-626,2186,-2241,-2179,-2114,-1174,498,57,1749,-76,-510,596,885,-2276,1080,-1773,729,-786,890,153,983,-379,-738,1772,1328,1938,2231,1027,1177,193,-427,937,119,899,-1415,-2050,-181,1591,-570,-200,-1184,1305,-747,-1632,1639,1948,-1208,-415,-1218,-1837,678,-1753,2206,1880,354,-1884,666,181,-2,-2266,-2056,1030,826,-1310,2179,-454,-2031,-980,-122,1535,1490,-956,32,901,-685,645,335,876,604,-669,2040,2139,256,1466,-198,1258,570,921,1568,1545,523,-1628,-2033,-1831,1168,883,-1807,-1927,1999,1592,1462,1444,-2064,901,1362,-1430,666,-2282,-369,-1552,-1553,-1645,946,-762,1729,-483,-909,456,130,-962,2287,175,-1436,1884,924,1092,-1282,473,-2031,851,234,-1639,-806,-2027,1127,899,-195,-2157,-1619,1587,-2179,-1124,873,656,-1329,207,-378,-1420,-18,-1166,374,-505,-2171,-1662,700,-488,156,-251,-960,-525,1761,-442,-394,11,693,1786,-2096,1415,-620,-1103,-1597,-947,321,1737,-124,-736,1443,809,1517,71,-837,-359,-1922,-338,99,-273,697,-2216,-1544,-1837,818,-993,-1914,232,2160,-2151,1910,1073,1070,-270,-2105,-1844,-1383,2131,-271,1708,-420,-485,18,-352,-202,2238,1038,-368,-523,-520,683,1388,1573,1215,-1882,-2268,529,-450,1930,-1829,249,-1717,-1480,736,2226,714,-452,42,-1771,1694,1598,-456,-1747,-1201,-600,1663,971,-886,2161,1743,-1294},
  {-2222,-706,-1152,-1237,-1569,1589,-474,1328,1212,-2091,2175,1277,663,-590,428,1279,6,-1237,-927,-1704,48,1325,-1190,141,2077,-1381,-1065,-1342,-918,1916,-2069,-2242,1664,701,-937,392,-113,1269,263,-1405,2158,1337,-615,-1668,-1943,773,-1015,1617,-159,-1306,-1747,239,663,-1961,1220,-1763,-753,-1908,1782,-133,-432,980,347,878,591,559,-663,1090,1503,-2201,-1425,72,983,157,-718,-1797,-1942,975,-671,767,211,-734,889,1185,-1531,865,-934,1717,1872,1906,-920,43,72,-2004,-1463,1362,284,495,-694,-1198,-333,665,-960,-1088,-488,462,-246,670,129,-1660,1399,319,-1808,2022,-1633,-811,-328,1294,1036,-2295,-2201,960,-1467,1663,-1242,1296,-423,141,478,-353,239,-786,975,-1205,1096,1853,2154,-2066,708,-1615,-602,-1697,796,-1559,1417,-256,-1925,780,-220,213,2032,-1009,-1943,961,1403,1197,-2262,-2199,-1148,76,-1801,-753,-1779,58,-551,-626,761,266,-752,292,1257,1705,239,-995,-1553,-1929,-1365,1102,-1074,-2105,1979,1600,-618,-993,685,775,-2284,1578,-1027,1678,-1247,1545,-838,2136,-1914,1006,2241,-1209,1495,2157,1128,-107,-1587,1633,-2235,1257,-561,-2153,1329,2079,-1531,1431,1168,877,-2,-409,1300,-34,-1269,-1317,1900,1585,1156,337,-813,761,1805,-505,-1885,482,-1405,-2050,2080,-1081,810,-140,-436,-2031,-65,911,1729,2264,-939,-1022,377,272,-739,551,652,755,1646,1249,1171,-556,1420,2289,-1896,-1413,-1698,-779,-204,-1149,-14,2168,1206,652,-28,873,2086,-387,-730,-916,1733,-1834,1736,2135,2161,-2227,-516,-386,-1020,-17,1981,-1854,-751,-506,-306,-1616,450,494,-290,2101,648,-1227,802,-1101,-897,1291,955,878,349,802,1571,129,937,-525,-1304,-1939,-287,-1414,2239,-404,39,-1191,2188,2110,1872,935,1143,177,-332,-821,816,-497,-1507,-1613,-1823,573,65,1390,914,-1078,828,-1552,-1083,-899,643,-228,-1591,-1496,-1755,-1439,-1616,1207,2137,928,-226,-184,-2113,2232,-951,-1476,1840,-1267,-1075,1079,-495,1029,-1517,-2225,-1665,1584,-431,-383,-1535,-1018,103,-1173,804,2260,1106,797,1434,-231,-2038,2135,341,-1346,478,1153,2022,-283,2186,2266,546,1063,-1450,460,-484,566,-1274,1396,-1928,-891,-43,-1467,-1437,-1957,804,-1657,-1598,-2116,2090,-1096,-1211,-1156,-84,-1812,-672,533,-822,-1960,1195,-765,1832,-1828,-952,2126,-2088,2006,-846,-1383,-1404,-671,2217,1445,1673,1386,-2081,1775,145,-1545,-1129,-563,-929,1061,-175,1104,1647,932,1659,813,965,11,-391,-1499,1827,-237,1408,-938,-385,-1409,1192,-34,-36,-1997,-1047,-1011,-881,2007,559,108,746,1759,951,141,1328,-536,-793,127,1057,1630,-1619,-727,-59,629,1642,-1281,-704,-1247,-257,1217,307,950,270,1810,1868,1516,-914,-2050,-1846,321,-1681,-853,857,1408,514,735,-1022,390,380,778,303,-1209,118,-1395,-1724,-926,-755,-1731,-680,1682,1347,-43,-1644,1937,1030,-125,1641,-147,4,413,-2139,1590,-1938,1528,-900,103,255,-297,-490,-1710,2026,1318,1201,500,-1820,1984,1298,1470,-1830,696,-727,-16,-1351,338,-2220,-1290,1427,-1965,-827,1474,153,1098,2072,-209,-1603,-1759,-1587,883,-2004,-998,1535,-1467,-2128,1077,2093,-2294,-619,-1636,-1337,-172,-2234,-1722,844,-1198,-1006,-379,-942,49,1159,849,1006,-1618,598,-291,1349,-1035,-872,-153,556,-767,-1724,-2172,1431,-1640,464,-639,349,1969,-609,1063,-1227,109,-751,929,-1207,530,1996,-2219,675,-790,-1748,1418,2205,614,-4,-1021,-861,2140,1051,-295,-2247,1830,-1595,-1640,-853,-703,1630,514,-515,-172,-1638,7,-562,-1043,1811,-1609,560,1468,446,196,-1051,1730,-1242,2072,-1690,-1885,-1617,1095,-651,-1178,-1258,2067,2290,-2281,298,1637,-1811,172,1582,1854,1400,-769,-530,417,-742,1410,-1328,463,-1682,1182,-1636,1709,1705,-2009,-1031,1283,-1128,-1089,-2219,-2063,111,-1566,129,-949,230,1458,-1324,915,-246,-1447,-83,1038,2122,-410,2024,-1146,1389,-2023,1394,254,71,1740,-1879,208,-1098,-1665,-785,873,-1223,2140,-631,-2172,1394,-1658,-51,-709,153,1861,1951,137,1017,-1642,884,1624,-286,-741,1668,280,764,2288,930,2267,225,-89,-1262,-1571,203,-1498,-1207,1528,-1339,1293,-2161,1087,37,-710,-1445,106,1664,487,-1927,1097,-2271,264,-1950,-1063,216,472,564},
  {1266,-618,-278,-1061,1748,1751,-677,-1315,-312,2153,1896,2278,331,36,462,-1075,1908,-111,2053,-633,244,-1869,1360,-1559,595,-526,-791,399,546,-1692,1725,-901,2280,2184,598,-1694,1863,735,1962,2190,-2159,217,-65,-1759,-1405,-1876,223,950,2055,1103,-2171,-1789,-197,0,1615,12,1539,-369,201,-1473,1513,-1221,686,1477,-1950,-1019,-1159,-2255,-562,-430,850,1712,77,-481,-861,912,1072,2010,-1627,-1243,1210,-1002,-1734,833,-66,844,626,-95,-1358,1970,-611,1050,918,-1976,270,-1191,1419,528,1490,-333,-1455,-358,1507,1229,871,-1207,-1565,-573,2140,2126,1573,-1697,-507,-138,-873,-754,1616,-1549,865,-508,-166,-1370,1348,853,1087,-1681,1484,299,953,79,-1057,-1345,942,1920,1388,1536,1601,-891,233,-1418,-663,1243,-1333,757,-1278,838,1033,501,1145,2189,40,673,1222,1122,-1051,-1348,746,-1912,1560,1333,988,-600,1966,-294,-1474,1665,348,1034,-1518,1378,-804,1562,-1856,-1814,1668,-1483,-2109,2233,-3,638,-116,167,-2066,1489,785,-1025,-1351,-7,-1395,2208,-920,-799,-1582,1608,871,-629,1485,1582,-367,-1261,-1287,-1320,-1895,-1216,-1869,2130,-380,946,838,-2192,1077,-173,-1671,-230,-1013,369,737,-2279,1789,-1292,-1263,1706,-762,-2151,-47,433,1653,-1743,1030,751,1178,158,424,-580,-1982,895,1879,-2010,1579,-928,-1128,658,984,1667,-802,539,2245,-2178,643,-451,290,-684,-889,-1756,-1607,-801,-1770,1637,-1254,-145,-123,-2288,-1985,-22,1762,1298,1805,-1460,1467,-927,1268,-797,835,-566,755,1710,-2047,580,-1227,-1263,310,-1863,1892,187,2273,209,1237,1776,-1602,-1772,1935,-1112,1901,2136,2204,657,-705,-1868,994,-2194,79,1968,669,1800,-1992,672,-1915,-870,1298,-2128,432,1806,-926,657,-1456,-1761,457,191,-1813,-1537,1740,746,-687,2084,1477,-1396,-508,1213,-1187,918,1782,-57,1362,1406,-1998,113,1103,-1979,-1252,1006,-2261,1441,-1338,-268,612,-2012,-230,512,-1862,-1818,157,-1366,1779,-896,1892,381,2211,-1052,-794,-357,-314,-247,645,-493,1780,773,-1528,507,491,-336,1214,545,1150,-413,1294,-1200,-385,-602,-1918,1856,-243,1788,-1744,-1551,442,1061,-690,-1159,-417,-2238,-2068,1175,1308,-1380,-1521,1986,1408,1350,665,-2252,1062,880,-713,78,526,1323,92,-286,-1458,2086,-659,222,1814,-781,-559,1223,307,-1450,1783,-89,1517,-1971,26,164,1863,1587,-787,1050,-2207,503,-2198,-121,-1951,-5,-1877,1394,1168,-1348,1439,1990,-1302,894,1952,-626,-24,145,1783,-1091,1774,360,-1440,-628,-71,1320,99,527,2250,-753,-161,-392,1001,-886,1857,-1839,192,1896,-1685,-1480,-1845,-1226,-1475,1469,-940,-356,-988,1827,-586,697,777,-831,516,-873,-2047,2216,-290,1769,-1802,-586,-369,-2180,-694,-942,-1154,-1329,-159,1503,-1606,-1585,1203,-2050,1863,-625,-1881,429,1111,529,735,1831,-1655,-1660,-1852,-25,32,-2093,986,-1169,-516,-100,536,-172,-1662,-456,2,-290,1181,-545,-1080,1229,-476,-2035,-2088,-2142,-1150,-1482,-1547,-1563,-1467,-1460,1350,-1434,-2001,1282,-1182,1692,2210,-1018,1253,112,-916,1630,1649,-1206,-1362,1617,-238,-665,520,-318,-2171,1738,133,-172,1200,-1698,-1030,-158,227,-1780,120,-1570,959,-612,-802,26,1772,-1317,-735,-1683,-163,-1194,-1981,2023,-829,-529,-855,727,1821,-1880,-177,1518,-1170,1132,-772,-1588,-66,677,169,1884,1342,-714,1296,-2096,1061,-1106,-2018,-2166,1933,773,1725,154,-1903,-2145,208,366,-1238,-2136,-1724,855,-249,1204,1477,19,-368,2244,-972,-1239,1892,1166,43,2094,-152,-1523,167,574,-1870,-1063,1767,1423,422,1349,333,1692,-1463,-420,1258,-1408,758,-125,-2234,1052,648,1329,747,-1104,-2059,-149,-810,2249,1941,2220,1887,-77,2263,1072,-777,-692,2177,375,1599,923,1023,-1906,-1696,1767,-240,-1276,-1253,1598,-649,-1958,1228,1422,-1676,-2027,-313,-948,-1495,1441,904,1524,-491,1137,462,-2017,-266,1788,-766,1261,2244,1141,1262,-2256,835,-444,1170,-1087,-809,618,-400,-1072,-2134,1567,-1237,-989,-1223,556,1107,-2059,582,-157,1569,-1241,-957,946,-296,1090,1306,1975,1869,1594,-1134,-833,997,670,772,-2098,-1469,-768,182,-1951,-1319,-1920,-47,90,1441,1109,-778,-325,810,1731,157,-152,1002,1041,-2029,-401,-432,569,-2044,1795,471},
  {318,-194,-1129,-804,-920,-1272,1816,263,-1500,1396,1104,-1280,2237,264,1632,473,855,1442,-1296,-871,760,265,1005,-1175,-256,-1739,-2188,1004,813,-1039,-168,751,-2166,-64,1752,2101,724,-321,-713,1966,-1327,187,-2126,-1322,-4,-905,1212,-278,1003,-1346,487,736,1334,-412,-141,814,-2009,1520,2285,1065,-1432,-1671,-1388,-594,-1010,-1149,2201,-2063,-274,1646,-94,540,979,952,849,-527,816,217,2051,529,2089,1578,436,286,-1313,420,-1861,2236,742,-2294,97,1918,-1335,304,-680,-2128,-325,373,1252,-1874,-1682,885,-1457,2221,213,-758,323,112,-534,-1980,-970,475,1337,242,-310,-898,2036,-1702,-1350,-1732,1078,1470,-988,2100,97,-211,-1818,-1335,-1292,1240,-63,-1075,-2195,-773,924,-1664,-927,561,-1348,-1354,1390,-2275,-1135,1941,497,-2056,-355,-293,257,478,-1470,1769,-265,2280,265,1756,1560,578,-1347,1060,1981,1465,1559,994,-1703,1490,315,-1205,-2127,40,2223,733,-1282,-1629,-113,-972,-1897,-1004,939,-2254,2227,1305,119,-2013,1748,-1479,-1574,943,1256,1886,1437,1959,2249,-761,-1674,-439,1905,-959,930,1329,-2012,-169,-769,481,2177,2041,-1129,-1203,956,-1343,42,-1101,1560,2009,39,314,301,-1296,-244,315,-400,-1128,-1014,-760,-551,1166,1196,2018,2110,-2201,2167,-1605,-2067,321,1356,-301,1734,2224,202,-222,166,-1590,645,1919,716,1697,349,-1964,1941,2260,1124,587,-889,-1685,-1838,-598,882,-2017,-586,-1449,86,-1476,326,-325,2243,-1185,1142,1011,-976,-1987,-2074,1241,-1054,-1377,-1198,1483,-1506,-899,-2089,-69,105,1863,-1788,901,-890,1419,726,-788,909,-2092,-561,876,1564,-1930,-1726,463,1567,-886,1263,-1805,2122,783,186,673,-2088,1430,112,-353,468,117,-2007,-1940,1471,-1486,-1873,1746,-376,-689,-874,1985,-2062,-1286,1930,-522,1101,2164,1196,490,843,-719,1955,314,-255,-125,1806,-558,1208,-173,1291,-1172,2185,-1367,-1543,1156,1136,-2192,231,1199,747,-412,-607,2251,1613,379,2252,2237,-1725,2019,2155,-2170,-789,-1569,49,44,1331,-789,1833,1897,-695,-890,138,722,1788,985,-2179,-745,-406,-652,-1583,-591,1397,-348,850,2029,747,1169,852,1805,635,2186,800,-301,1494,1549,2028,80,1974,1276,977,1933,-1737,388,210,-1306,239,1591,703,-991,-30,830,1497,2123,2294,-2171,454,1302,1067,1284,-1420,1405,-1517,-818,1054,899,-1668,-1877,742,235,2228,-2247,-2078,-1555,1889,-2225,-974,-1,1773,959,701,-1947,-1797,1478,1225,1014,751,549,-2159,-1321,-1867,-547,24,-2272,-1999,-671,-1150,1987,527,1693,1574,1012,-815,681,1009,-1591,859,-708,-110,-1617,-1184,877,2019,640,2137,541,-787,70,-697,399,832,-1750,-630,-1590,1303,518,-1553,526,2216,1608,1708,1377,-945,1566,-1791,-1855,-1852,-594,-1692,-1030,1459,2064,-1016,2057,-1088,289,-534,2099,-1706,2070,-48,1816,823,-460,190,1364,-282,-1298,-53,1148,-1679,-2016,-619,1909,90,-1059,-1472,1601,-1109,682,-466,1010,-5,-1822,-2175,2023,121,-1267,-129,684,-353,640,1655,2250,-1157,107,-2255,-698,-1609,-1980,346,-555,1222,338,1898,597,1299,-2046,-2126,-1148,1924,2009,1232,622,1726,-1163,747,-988,327,-1836,2220,705,2048,-838,-2285,1051,1818,913,-1219,964,1870,338,-2059,1733,218,-143,216,36,-283,-1430,1603,1310,1579,1709,266,1015,912,-2165,-1496,2122,444,970,-985,-275,-1753,-378,459,2077,1454,522,-1877,817,721,-1878,1053,-1855,-284,-1256,490,1865,1158,306,-1964,1815,249,-1273,-1371,310,2295,664,1878,427,-2051,-1767,668,-1769,1752,-1281,-7,-2011,-1988,35,1566,1532,-98,-1018,-91,108,820,-2263,-1552,540,1520,-1926,2103,666,1722,-1176,-733,1610,296,-138,1398,1008,1946,-861,-231,1926,-305,1711,-1949,-1366,1589,-1627,-702,-616,1766,-1215,-1317,-1039,1004,2089,-151,1001,1279,-1032,-26,1918,2196,127,1438,-147,2169,50,-461,-1031,-2036,1240,-1256,550,-1486,2224,-1147,-1453,1877,-2264,-838,2126,-1795,-1250,-960,-116,-2029,-432,933,-289,-2102,1749,-823,1390,-1592,787,-1555,914,1427,-760,104,268,786,-1562,120,1427,2051,120,-1229,869,1448,-148,-1008,-2141,-1870,1040,1530,732,-1655,-1264,1918,83,1733,-1035,-164,-1350,-688,127,1110,-1333,2272,-1850,-401,1064,-1611,-683,1350},
} ;

static const unsigned char precomputed_decode_761x4591_s[precomputed_decode_761x4591_NUM][crypto_decode_STRBYTES] = {
  {144,232,243,31,112,83,181,219,78,245,53,28,56,61,13,41,149,92,217,134,91,173,38,231,249,44,221,134,136,110,123,124,229,114,153,53,59,134,113,11,67,194,56,148,221,229,67,245,141,175,212,149,61,15,246,75,68,82,70,158,76,143,74,119,106,212,152,242,206,232,217,170,43,210,23,94,2,109,252,27,150,164,243,38,219,207,223,236,89,190,231,202,78,145,31,175,8,180,248,120,50,2,61,75,151,54,101,82,177,114,121,8,152,42,1,132,43,202,125,196,205,112,178,52,228,137,106,240,144,128,187,171,222,187,30,135,91,149,201,208,224,217,128,238,21,142,171,88,81,66,216,37,209,198,248,202,214,163,192,10,232,143,76,6,11,144,146,230,50,139,235,90,131,6,33,102,244,165,237,55,0,70,149,80,94,64,213,220,216,42,46,23,43,226,37,146,249,221,215,117,35,250,28,63,68,118,220,142,218,1,241,60,37,216,11,149,42,190,89,171,196,228,48,95,88,11,197,55,212,172,145,0,88,224,235,30,102,32,36,93,77,58,68,165,251,251,151,37,146,185,228,61,154,104,89,234,137,58,197,16,4,108,194,9,65,174,12,149,227,135,141,9,192,2,117,187,215,103,149,156,4,185,69,1,180,246,95,58,37,163,59,112,186,227,230,199,73,205,203,20,86,205,190,41,129,194,121,249,205,92,220,32,22,132,126,106,227,136,197,180,3,104,66,218,209,234,100,108,41,215,247,174,164,123,46,101,210,161,175,80,63,149,244,237,234,75,23,55,186,231,81,234,237,10,1,17,147,9,196,248,184,186,175,240,230,162,151,118,88,255,38,131,89,93,243,11,162,166,70,89,237,37,188,140,123,124,72,253,215,237,136,111,59,177,118,144,1,91,222,117,216,81,28,240,224,38,37,210,206,52,240,2,111,28,119,175,106,62,122,134,126,152,93,102,149,55,128,7,28,58,174,175,172,177,178,251,172,53,177,96,17,203,93,77,180,120,77,10,194,15,118,52,253,48,239,46,128,10,222,42,158,191,151,46,190,204,143,41,251,199,192,152,96,251,191,179,26,32,20,136,155,98,239,189,156,217,184,36,223,166,219,30,206,148,125,179,131,35,192,212,84,215,49,248,171,75,156,170,24,208,14,118,20,165,244,238,130,32,68,136,185,206,113,130,254,140,41,97,133,158,155,193,225,137,146,69,2,238,14,151,20,201,88,88,172,112,84,201,43,45,52,66,158,201,71,53,5,120,155,75,103,183,203,25,159,3,86,138,14,213,37,127,8,17,34,238,200,12,57,9,181,31,39,86,222,219,219,236,14,251,179,45,89,243,125,174,54,130,64,238,161,85,23,16,183,196,54,130,125,174,120,201,167,92,98,252,171,228,216,166,180,244,47,20,188,139,220,112,100,255,187,188,244,106,224,25,216,195,168,81,37,236,30,100,81,254,5,204,68,205,10,179,218,244,177,8,105,198,160,73,98,83,236,31,143,111,115,88,180,161,215,57,173,3,203,222,75,146,171,238,105,230,99,135,54,113,120,126,244,62,122,128,198,205,34,165,128,25,20,175,113,148,133,24,179,65,174,7,215,39,197,0,172,232,203,152,166,17,21,116,33,211,2,38,40,149,14,11,13,95,15,13,6,242,210,229,131,74,143,181,142,135,232,87,216,219,2,190,39,115,22,227,126,165,201,75,49,193,66,241,25,70,252,112,232,127,89,195,218,244,100,45,223,55,113,204,37,228,146,34,174,166,142,240,160,143,226,232,169,135,147,163,0,87,65,35,46,97,248,31,245,162,31,241,251,34,229,185,23,159,22,101,169,205,30,63,185,83,27,76,147,137,87,107,0,128,188,165,100,38,49,90,57,210,248,180,98,70,223,98,234,55,208,184,204,67,130,66,3,204,43,233,173,120,105,176,23,227,43,156,38,38,101,57,231,120,93,49,17,35,104,93,59,30,44,111,174,16,96,181,116,10,155,210,105,129,76,13,214,36,154,12,54,55,108,196,96,49,138,192,195,110,182,210,135,116,219,9,93,247,59,110,80,90,87,104,195,254,247,62,121,209,49,51,236,155,213,92,190,27,105,18,95,115,227,69,253,226,139,102,142,11,0,55,193,208,216,23,182,22,170,199,64,57,222,97,107,19,78,59,41,5,41,112,121,134,242,93,189,93,133,205,118,65,205,107,67,154,22,149,8,157,66,17,217,243,217,247,206,147,37,233,68,154,221,164,242,118,208,75,90,161,239,112,188,203,146,6,54,193,54,59,192,48,245,239,138,199,125,203,50,91,24,40,86,195,230,98,188,11,249,252,222,175,252,107,173,33,78,253,221,113,4,185,94,139,38,87,110,25,27,241,61,139,6,224,229,243,22,47,189,161,225,217,181,94,240,10,68,185,176,69,188,183,69,174,44,40,124,95,126,139,240,37,106,179,145,133,14,18,31,42,88,4,79,144,38,112,226,18,79,64,236,178,148,57,254,149,212,228,79,43,33,173,84,39,64,87,49,113,17,78,25,54,216,110,135,13,213,191,200,13,172,212,250,101,172,87,108,142,89,61,219,36,154,19,209,255,175,20,11,118,138,5,78,92,170,164},
  {196,80,53,34,234,24,134,212,39,88,66,76,85,124,77,105,187,38,25,108,195,160,141,170,98,24,133,199,190,3,93,183,131,240,223,64,218,179,228,98,53,128,237,242,164,237,56,17,171,80,222,133,96,113,103,82,83,34,91,132,204,115,157,81,192,249,151,39,152,164,55,212,250,209,23,233,59,20,2,135,33,100,88,213,36,97,229,18,78,91,29,206,236,107,103,50,205,124,104,223,26,99,16,147,250,41,28,189,77,133,216,44,58,109,10,248,90,115,3,13,55,6,102,72,166,147,140,173,223,21,177,191,100,104,203,161,44,28,147,174,231,234,51,155,25,229,63,107,143,185,129,39,40,25,142,174,193,185,8,29,136,7,195,215,251,241,223,115,60,64,64,68,146,27,152,166,13,252,39,84,11,236,23,60,198,27,218,80,31,87,24,5,114,109,72,64,154,37,42,239,19,84,236,45,92,212,88,249,178,119,142,7,227,66,183,39,230,113,16,135,187,222,179,110,218,26,38,117,49,139,53,45,121,28,6,3,187,133,208,159,249,110,195,50,249,221,22,101,249,180,13,84,15,224,27,46,253,202,169,53,17,80,138,174,250,127,123,246,105,186,138,160,31,91,145,101,228,212,46,194,181,153,107,245,59,89,174,152,132,107,233,251,147,220,207,176,84,59,253,83,171,254,34,222,22,11,59,244,87,191,35,138,206,95,254,166,201,85,70,57,201,73,193,0,202,201,100,235,131,46,184,77,220,24,8,208,55,216,177,251,68,249,25,86,73,217,230,233,23,34,221,100,227,19,182,96,76,226,100,234,223,190,80,248,43,120,220,162,160,35,245,167,129,165,211,86,71,133,221,149,65,3,160,148,27,72,90,2,22,115,226,148,51,92,208,9,232,176,189,189,214,140,130,15,153,206,144,222,139,34,130,125,8,60,28,199,170,185,50,77,25,233,163,199,68,17,15,237,144,30,186,147,138,89,122,30,145,36,27,31,14,201,154,151,148,202,112,59,90,30,160,24,122,113,9,233,156,247,216,99,147,97,171,10,234,178,88,71,8,177,115,2,132,218,144,222,11,24,159,112,190,14,173,92,108,155,48,9,32,47,9,68,164,6,105,116,195,77,172,28,98,80,8,30,169,21,82,233,144,136,54,160,174,208,131,121,227,16,188,136,39,189,159,40,134,209,53,2,72,1,52,2,244,42,13,218,180,195,4,206,50,137,201,172,215,118,142,103,160,44,115,13,63,186,137,50,28,143,186,163,2,221,250,15,187,56,52,192,201,48,195,188,48,36,106,229,205,61,161,57,182,76,240,121,57,110,144,82,81,19,171,21,16,160,15,241,207,12,44,191,152,67,136,108,240,223,167,234,183,99,169,121,146,29,103,218,89,72,23,181,66,40,67,248,61,229,234,139,204,214,249,191,179,69,161,187,124,30,68,167,74,139,147,251,30,240,35,187,136,125,63,70,99,150,251,12,5,125,17,212,160,181,25,245,205,2,8,146,161,56,128,149,175,128,162,24,86,171,121,128,228,64,253,26,22,84,164,242,161,226,177,111,79,133,20,30,146,142,84,28,36,159,75,179,105,89,215,38,134,243,173,179,85,164,28,174,114,35,148,45,22,111,147,203,44,150,167,228,124,114,156,25,167,161,90,147,245,187,213,222,97,212,120,93,240,235,219,17,225,53,185,242,48,160,41,68,137,79,16,224,131,74,130,235,220,209,68,237,73,245,20,122,231,161,9,33,225,144,111,17,19,79,44,20,91,119,31,90,188,255,78,207,154,16,46,79,252,227,204,210,180,154,229,205,71,134,181,112,196,122,127,74,124,230,38,127,16,36,67,210,49,1,197,59,145,192,200,69,12,78,91,155,233,176,55,106,172,69,181,124,227,191,236,54,190,101,199,239,32,240,89,117,239,124,100,203,173,76,86,111,180,209,180,171,207,97,72,133,15,50,91,87,91,198,243,224,96,143,5,25,124,245,63,43,76,111,189,211,237,68,221,91,30,67,249,207,196,39,145,97,78,174,86,192,206,250,60,44,162,72,59,171,23,90,69,204,203,236,15,254,32,105,9,115,107,118,132,103,64,162,54,234,22,241,54,102,7,201,96,117,68,234,118,243,96,193,138,172,19,24,71,54,151,171,161,93,210,206,116,95,158,122,124,201,208,193,98,187,68,19,164,138,115,247,61,98,141,70,130,100,131,240,53,252,96,184,114,230,98,63,176,231,189,233,23,20,148,37,97,131,111,141,175,240,38,217,244,168,87,233,254,234,45,245,50,142,88,123,224,50,1,100,96,137,242,36,132,162,135,202,122,143,93,146,54,6,143,26,188,171,233,64,109,132,68,70,107,136,57,249,174,220,210,87,96,45,30,189,200,27,18,110,254,238,243,18,176,121,223,224,189,6,193,131,109,169,189,241,126,122,93,182,122,18,211,198,109,208,83,122,43,129,174,57,65,136,35,149,17,170,72,151,47,135,28,82,24,23,241,69,50,207,156,26,158,7,28,238,160,163,31,162,233,9,87,125,238,89,31,23,20,59,178,69,114,152,211,22,233,50,141,100,135,218,237,203,222,158,16,198,130,115,146,166,225,190,140,85},
  {140,136,239,121,29,127,62,173,95,160,178,106,119,85,193,129,99,15,158,126,161,225,103,157,209,247,250,190,14,73,34,183,112,214,100,37,8,83,204,64,184,249,30,149,167,93,89,92,88,27,226,114,203,205,19,172,20,251,42,159,142,75,41,73,157,100,200,209,236,172,50,192,206,28,163,174,70,161,192,180,212,161,121,34,66,238,81,41,112,202,115,90,94,101,181,96,11,209,127,128,167,180,214,236,30,68,128,164,190,197,102,243,191,33,57,249,189,81,173,59,228,212,47,149,112,16,129,198,10,91,192,145,190,82,252,109,252,105,163,121,110,223,22,209,236,125,84,235,172,43,7,244,212,108,249,91,114,224,35,54,68,202,196,61,61,108,66,63,32,81,178,55,198,179,143,241,10,52,47,128,5,129,157,21,178,3,192,75,125,118,7,210,154,109,188,193,79,167,222,118,49,81,233,151,209,253,66,18,102,67,66,180,79,171,26,164,200,42,89,83,87,76,109,28,160,35,196,186,183,110,172,228,188,46,99,121,97,7,91,210,118,226,181,153,163,141,247,67,6,57,30,229,179,199,122,171,241,116,75,161,5,134,69,60,64,195,145,142,218,227,113,254,105,43,245,155,13,104,164,79,125,77,137,239,144,123,117,61,250,165,247,239,37,120,139,221,219,239,36,32,47,172,165,233,40,218,219,212,242,192,82,84,81,209,209,107,170,49,140,27,210,23,125,201,9,9,7,198,247,24,79,215,132,82,65,177,74,48,222,66,10,184,34,3,144,222,170,171,4,108,227,29,3,17,167,134,15,37,43,201,189,127,210,71,47,252,237,76,203,70,29,1,123,228,78,195,9,161,210,203,225,14,191,32,213,35,213,154,141,5,117,22,80,39,189,232,106,102,181,14,70,120,153,66,195,126,234,197,88,234,63,89,131,31,42,121,13,60,112,153,96,193,198,75,116,2,195,89,138,2,3,76,70,109,169,110,164,100,9,60,28,106,194,251,215,246,250,103,150,13,164,202,161,70,244,185,91,23,247,87,79,193,240,1,104,161,67,26,197,228,64,177,136,218,97,199,253,159,200,154,141,168,105,3,245,185,112,186,227,21,104,206,79,176,34,24,139,191,101,55,88,13,186,212,198,225,216,21,85,126,253,6,173,47,11,238,48,203,20,196,90,214,212,125,94,165,187,226,215,61,166,184,124,248,80,74,201,129,16,95,157,149,150,81,204,134,5,172,190,250,23,89,221,15,203,55,182,137,171,134,129,194,2,224,8,185,167,29,74,211,243,242,180,157,241,146,116,229,55,41,124,126,116,188,242,184,133,34,17,37,210,22,0,141,89,59,29,202,56,207,208,254,39,88,132,10,200,252,19,159,146,131,18,115,146,39,13,173,163,37,18,41,28,0,11,255,134,132,173,127,27,29,25,5,217,79,248,132,161,80,129,87,189,92,250,48,211,15,250,119,215,234,203,122,106,86,13,88,185,90,12,113,55,240,123,81,42,28,132,125,33,77,153,144,92,106,141,187,13,162,238,112,159,200,75,100,8,187,228,148,36,115,79,132,202,14,213,33,143,197,78,201,79,183,81,173,93,22,48,180,43,140,104,129,221,188,158,149,67,209,26,229,1,16,6,41,131,46,3,128,115,111,247,193,230,216,211,251,213,34,233,72,103,28,140,132,27,7,199,20,69,41,89,191,68,175,23,169,97,133,161,163,183,141,129,67,243,44,13,200,57,163,244,34,56,91,221,178,63,255,208,143,126,240,23,243,60,199,45,110,248,213,170,63,28,225,33,152,243,150,142,39,157,145,23,254,153,11,249,159,154,187,47,132,13,172,139,235,246,146,56,214,97,245,191,254,239,47,169,89,184,41,72,82,235,230,85,9,88,88,185,105,25,83,164,161,155,227,152,37,11,94,215,27,58,134,73,170,86,197,170,21,146,214,239,110,100,244,36,154,199,82,162,199,182,162,215,24,199,29,219,202,68,215,147,113,71,42,42,193,152,230,166,94,178,232,169,170,118,62,38,221,92,42,4,228,77,235,209,128,115,53,63,144,6,158,173,31,245,194,221,110,36,255,182,49,166,215,106,254,168,168,235,207,217,68,236,241,169,122,207,3,92,41,154,40,130,198,241,132,208,69,18,104,168,45,30,208,66,2,191,103,187,15,133,22,95,85,228,61,244,88,33,33,228,242,214,246,42,210,57,185,87,11,178,51,191,248,3,113,249,253,4,108,135,89,58,25,26,208,135,236,81,17,43,174,226,23,58,0,113,42,31,156,94,190,140,245,19,146,146,247,51,25,119,6,65,149,158,130,143,103,254,215,88,71,136,26,162,140,3,119,42,108,150,180,110,130,122,250,24,182,29,60,134,146,89,36,195,201,73,124,121,132,229,41,161,46,65,128,193,23,247,137,69,55,115,207,21,229,103,242,9,130,226,91,174,78,66,62,67,253,115,182,15,157,163,49,21,99,218,46,151,56,130,120,198,74,43,84,22,164,61,110,67,43,227,41,55,223,169,155,92,239,176,233,176,185,123,93,230,252,170,68,162,46,178,138,109,110,138,137,85,146,60,132,150,66,152,255,96,230,103,5,241,20,200,204},
  {176,56,139,119,112,175,49,66,0,148,224,39,197,85,135,247,37,214,87,197,239,97,132,130,11,251,88,27,188,8,9,106,90,74,227,3,181,84,57,133,246,226,12,42,165,104,194,89,221,135,151,95,34,247,245,211,199,65,196,114,239,185,150,44,235,76,40,82,48,28,86,162,43,131,224,230,87,5,114,229,239,97,70,217,139,53,207,106,237,186,147,43,41,21,56,185,134,238,230,139,57,199,98,95,187,181,99,168,246,23,59,17,183,199,252,228,138,155,78,116,40,205,64,231,244,6,29,66,44,167,180,127,82,159,172,64,176,23,54,239,17,117,60,195,9,201,162,70,211,75,89,181,31,134,253,210,70,82,233,10,4,119,165,118,247,40,208,101,153,147,146,48,187,171,171,182,211,113,233,235,154,66,180,202,155,57,203,215,58,242,22,16,226,135,45,7,176,167,241,235,237,239,158,125,136,209,10,132,123,189,215,173,63,145,221,205,205,5,177,222,232,199,18,141,251,122,58,49,247,166,156,103,44,67,217,189,166,161,24,66,204,108,166,63,171,178,89,58,17,40,249,241,252,192,24,227,243,133,127,74,234,104,107,11,4,212,227,165,179,152,13,182,227,83,103,173,97,206,252,240,66,81,191,229,219,50,186,157,9,69,51,42,214,160,19,55,133,195,92,97,219,176,153,244,114,243,113,20,159,2,141,223,253,186,77,23,217,136,85,217,232,175,196,68,41,107,178,38,154,115,89,213,222,11,172,190,197,180,111,185,224,19,197,195,144,68,216,205,215,244,182,124,178,97,207,140,192,55,21,211,172,225,213,227,40,142,192,185,243,114,40,99,35,214,134,149,70,32,160,97,33,115,37,245,218,181,7,68,225,243,173,187,137,87,44,113,138,57,4,60,3,246,28,82,216,67,30,101,84,243,110,141,177,193,224,5,119,197,183,53,245,122,251,204,177,74,219,71,123,110,181,215,178,247,211,184,206,3,152,108,101,81,3,220,10,71,218,59,152,117,136,165,80,197,31,252,50,106,130,185,40,128,40,94,239,56,131,135,179,57,243,171,252,188,215,178,88,191,6,58,176,105,65,29,145,161,112,124,203,75,225,126,192,212,198,42,90,160,51,107,255,227,31,9,23,215,112,202,200,5,83,152,186,92,168,223,31,58,225,141,96,135,61,159,127,240,241,144,172,141,137,43,186,125,44,13,163,184,175,162,157,115,240,72,27,224,195,19,197,238,228,128,85,168,129,127,126,90,171,146,18,102,137,92,23,155,195,49,107,58,54,34,216,101,9,203,201,81,108,131,112,45,233,202,4,85,107,160,213,153,62,141,51,234,229,39,206,111,226,195,250,134,209,76,110,80,148,101,250,2,23,66,220,223,220,208,161,118,196,66,93,236,18,162,159,128,111,91,139,191,228,253,165,228,121,24,20,238,121,58,242,38,200,125,9,95,11,74,164,156,102,232,141,126,98,115,201,148,226,36,22,113,87,133,195,185,192,169,169,21,208,218,186,164,37,184,106,0,195,41,128,237,23,136,24,43,181,188,241,135,183,87,58,147,68,164,34,81,18,149,146,0,61,60,28,186,143,54,132,170,83,131,102,147,53,76,11,43,21,234,203,207,155,150,44,149,92,101,69,198,155,62,14,170,12,118,205,206,50,162,238,27,9,60,139,166,16,84,146,59,113,177,107,113,74,62,87,86,160,239,99,109,80,117,139,207,180,66,4,94,53,187,234,117,161,217,112,32,153,122,119,120,79,140,52,86,187,26,179,55,45,216,225,194,138,81,40,250,54,95,83,161,75,230,222,226,125,248,239,151,152,199,168,25,50,231,206,102,141,158,63,5,17,150,73,205,219,195,80,87,161,22,74,219,38,53,20,217,46,134,62,126,90,202,176,99,239,127,117,62,56,243,200,189,33,100,240,15,217,74,133,134,132,0,192,229,191,41,68,20,150,79,188,135,165,114,141,184,80,136,251,39,157,204,250,218,213,32,202,215,82,176,105,190,170,142,27,233,44,234,42,155,30,170,84,198,27,44,57,253,25,252,84,174,15,109,20,6,114,25,254,44,56,235,255,175,87,29,203,126,150,185,222,6,63,191,7,28,130,112,118,217,150,137,28,100,86,212,65,203,89,188,233,42,62,12,0,118,144,235,173,168,89,203,48,187,165,74,222,213,98,109,18,214,247,52,44,105,164,233,7,182,168,198,142,7,227,25,64,180,192,245,236,146,1,109,185,62,137,95,185,67,86,94,243,135,81,119,103,240,135,162,23,108,103,241,124,58,118,146,212,189,166,34,54,249,225,162,249,119,50,140,146,93,138,61,8,186,117,46,7,147,119,167,197,233,67,56,230,48,85,3,102,143,142,245,242,220,65,232,93,194,134,248,4,202,76,51,196,88,150,85,213,96,201,86,115,34,84,74,187,236,107,74,221,241,188,172,254,64,22,209,83,185,254,202,181,236,132,207,20,36,200,74,110,214,58,187,40,164,24,55,173,55,251,236,7,212,221,123,48,186,128,10,2,163,84,62,34,138,45,108,230,6,152,196,200,129,211,76,194,64,156,26,189,43,203,201,210,38,215,172,90,104,63,161,172,199},
} ;

static void test_decode_761x4591_impl(long long impl)
{
  unsigned char *x = test_decode_761x4591_x;
  unsigned char *s = test_decode_761x4591_s;
  unsigned char *x2 = test_decode_761x4591_x2;
  unsigned char *s2 = test_decode_761x4591_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_761x4591_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_761x4591(impl);
    printf("decode_761x4591 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761x4591_implementation(impl),ntruprime_dispatch_decode_761x4591_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_761x4591;
    printf("decode_761x4591 selected implementation %s compiler %s\n",ntruprime_decode_761x4591_implementation(),ntruprime_decode_761x4591_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_761x4591_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_761x4591_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_761x4591_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_761x4591_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_761x4591_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_761x4591_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_761x4591(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761x4591")) return;
  storage_decode_761x4591_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_761x4591_x = aligned(storage_decode_761x4591_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_761x4591_s = callocplus(crypto_decode_STRBYTES);
  test_decode_761x4591_s = aligned(storage_decode_761x4591_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_761x4591_x2 = callocplus(maxalloc);
  test_decode_761x4591_x2 = aligned(storage_decode_761x4591_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_761x4591_s2 = callocplus(maxalloc);
  test_decode_761x4591_s2 = aligned(storage_decode_761x4591_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_761x4591 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_761x4591();++impl)
      forked(test_decode_761x4591_impl,impl);
    ++test_decode_761x4591_x;
    ++test_decode_761x4591_s;
    ++test_decode_761x4591_x2;
    ++test_decode_761x4591_s2;
  }
  free(storage_decode_761x4591_s2);
  free(storage_decode_761x4591_x2);
  free(storage_decode_761x4591_s);
  free(storage_decode_761x4591_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

