"use strict";

var helpers = require("../../helpers/helpers");

exports["Asia/Nicosia"] = {

	"guess:by:offset" : helpers.makeTestGuess("Asia/Nicosia", { offset: true, expect: "Europe/Athens" }),

	"guess:by:abbr" : helpers.makeTestGuess("Asia/Nicosia", { abbr: true, expect: "Europe/Athens" }),

	"1921" : helpers.makeTestYear("Asia/Nicosia", [
		["1921-11-13T21:46:32+00:00", "23:46:32", "EET", -120]
	]),

	"1975" : helpers.makeTestYear("Asia/Nicosia", [
		["1975-04-12T21:59:59+00:00", "23:59:59", "EET", -120],
		["1975-04-12T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1975-10-11T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1975-10-11T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1976" : helpers.makeTestYear("Asia/Nicosia", [
		["1976-05-14T21:59:59+00:00", "23:59:59", "EET", -120],
		["1976-05-14T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1976-10-10T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1976-10-10T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1977" : helpers.makeTestYear("Asia/Nicosia", [
		["1977-04-02T21:59:59+00:00", "23:59:59", "EET", -120],
		["1977-04-02T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1977-09-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1977-09-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1978" : helpers.makeTestYear("Asia/Nicosia", [
		["1978-04-01T21:59:59+00:00", "23:59:59", "EET", -120],
		["1978-04-01T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1978-10-01T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1978-10-01T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1979" : helpers.makeTestYear("Asia/Nicosia", [
		["1979-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1979-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1979-09-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1979-09-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1980" : helpers.makeTestYear("Asia/Nicosia", [
		["1980-04-05T21:59:59+00:00", "23:59:59", "EET", -120],
		["1980-04-05T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1980-09-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1980-09-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1981" : helpers.makeTestYear("Asia/Nicosia", [
		["1981-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["1981-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1981-09-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1981-09-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1982" : helpers.makeTestYear("Asia/Nicosia", [
		["1982-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["1982-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1982-09-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1982-09-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1983" : helpers.makeTestYear("Asia/Nicosia", [
		["1983-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["1983-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1983-09-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1983-09-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1984" : helpers.makeTestYear("Asia/Nicosia", [
		["1984-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["1984-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1984-09-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1984-09-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1985" : helpers.makeTestYear("Asia/Nicosia", [
		["1985-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1985-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1985-09-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1985-09-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1986" : helpers.makeTestYear("Asia/Nicosia", [
		["1986-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["1986-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1986-09-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1986-09-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1987" : helpers.makeTestYear("Asia/Nicosia", [
		["1987-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["1987-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1987-09-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1987-09-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1988" : helpers.makeTestYear("Asia/Nicosia", [
		["1988-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["1988-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1988-09-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1988-09-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1989" : helpers.makeTestYear("Asia/Nicosia", [
		["1989-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["1989-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1989-09-23T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1989-09-23T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1990" : helpers.makeTestYear("Asia/Nicosia", [
		["1990-03-24T21:59:59+00:00", "23:59:59", "EET", -120],
		["1990-03-24T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1990-09-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1990-09-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1991" : helpers.makeTestYear("Asia/Nicosia", [
		["1991-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1991-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1991-09-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1991-09-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1992" : helpers.makeTestYear("Asia/Nicosia", [
		["1992-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["1992-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1992-09-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1992-09-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1993" : helpers.makeTestYear("Asia/Nicosia", [
		["1993-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["1993-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1993-09-25T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1993-09-25T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1994" : helpers.makeTestYear("Asia/Nicosia", [
		["1994-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["1994-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1994-09-24T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1994-09-24T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1995" : helpers.makeTestYear("Asia/Nicosia", [
		["1995-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["1995-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1995-09-23T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1995-09-23T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1996" : helpers.makeTestYear("Asia/Nicosia", [
		["1996-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1996-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1996-09-28T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1996-09-28T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1997" : helpers.makeTestYear("Asia/Nicosia", [
		["1997-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["1997-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1997-09-27T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1997-09-27T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1998" : helpers.makeTestYear("Asia/Nicosia", [
		["1998-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["1998-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1998-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1998-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"1999" : helpers.makeTestYear("Asia/Nicosia", [
		["1999-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["1999-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["1999-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["1999-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2000" : helpers.makeTestYear("Asia/Nicosia", [
		["2000-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2000-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2000-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2000-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2001" : helpers.makeTestYear("Asia/Nicosia", [
		["2001-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2001-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2001-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2001-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2002" : helpers.makeTestYear("Asia/Nicosia", [
		["2002-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2002-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2002-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2002-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2003" : helpers.makeTestYear("Asia/Nicosia", [
		["2003-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2003-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2003-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2003-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2004" : helpers.makeTestYear("Asia/Nicosia", [
		["2004-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2004-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2004-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2004-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2005" : helpers.makeTestYear("Asia/Nicosia", [
		["2005-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2005-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2005-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2005-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2006" : helpers.makeTestYear("Asia/Nicosia", [
		["2006-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2006-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2006-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2006-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2007" : helpers.makeTestYear("Asia/Nicosia", [
		["2007-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2007-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2007-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2007-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2008" : helpers.makeTestYear("Asia/Nicosia", [
		["2008-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2008-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2008-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2008-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2009" : helpers.makeTestYear("Asia/Nicosia", [
		["2009-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2009-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2009-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2009-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2010" : helpers.makeTestYear("Asia/Nicosia", [
		["2010-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2010-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2010-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2010-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2011" : helpers.makeTestYear("Asia/Nicosia", [
		["2011-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2011-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2011-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2011-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2012" : helpers.makeTestYear("Asia/Nicosia", [
		["2012-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2012-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2012-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2012-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2013" : helpers.makeTestYear("Asia/Nicosia", [
		["2013-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2013-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2013-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2013-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2014" : helpers.makeTestYear("Asia/Nicosia", [
		["2014-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2014-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2014-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2014-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2015" : helpers.makeTestYear("Asia/Nicosia", [
		["2015-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2015-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2015-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2015-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2016" : helpers.makeTestYear("Asia/Nicosia", [
		["2016-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2016-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2016-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2016-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2017" : helpers.makeTestYear("Asia/Nicosia", [
		["2017-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2017-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2017-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2017-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2018" : helpers.makeTestYear("Asia/Nicosia", [
		["2018-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2018-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2018-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2018-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2019" : helpers.makeTestYear("Asia/Nicosia", [
		["2019-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2019-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2019-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2019-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2020" : helpers.makeTestYear("Asia/Nicosia", [
		["2020-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2020-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2020-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2020-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2021" : helpers.makeTestYear("Asia/Nicosia", [
		["2021-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2021-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2021-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2021-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2022" : helpers.makeTestYear("Asia/Nicosia", [
		["2022-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2022-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2022-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2022-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2023" : helpers.makeTestYear("Asia/Nicosia", [
		["2023-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2023-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2023-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2023-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2024" : helpers.makeTestYear("Asia/Nicosia", [
		["2024-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2024-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2024-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2024-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2025" : helpers.makeTestYear("Asia/Nicosia", [
		["2025-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2025-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2025-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2025-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2026" : helpers.makeTestYear("Asia/Nicosia", [
		["2026-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2026-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2026-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2026-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2027" : helpers.makeTestYear("Asia/Nicosia", [
		["2027-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2027-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2027-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2027-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2028" : helpers.makeTestYear("Asia/Nicosia", [
		["2028-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2028-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2028-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2028-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2029" : helpers.makeTestYear("Asia/Nicosia", [
		["2029-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2029-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2029-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2029-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2030" : helpers.makeTestYear("Asia/Nicosia", [
		["2030-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2030-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2030-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2030-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2031" : helpers.makeTestYear("Asia/Nicosia", [
		["2031-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2031-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2031-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2031-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2032" : helpers.makeTestYear("Asia/Nicosia", [
		["2032-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2032-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2032-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2032-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2033" : helpers.makeTestYear("Asia/Nicosia", [
		["2033-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2033-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2033-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2033-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2034" : helpers.makeTestYear("Asia/Nicosia", [
		["2034-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2034-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2034-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2034-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2035" : helpers.makeTestYear("Asia/Nicosia", [
		["2035-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2035-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2035-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2035-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2036" : helpers.makeTestYear("Asia/Nicosia", [
		["2036-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2036-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2036-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2036-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2037" : helpers.makeTestYear("Asia/Nicosia", [
		["2037-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2037-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2037-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2037-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2038" : helpers.makeTestYear("Asia/Nicosia", [
		["2038-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2038-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2038-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2038-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2039" : helpers.makeTestYear("Asia/Nicosia", [
		["2039-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2039-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2039-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2039-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2040" : helpers.makeTestYear("Asia/Nicosia", [
		["2040-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2040-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2040-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2040-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2041" : helpers.makeTestYear("Asia/Nicosia", [
		["2041-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2041-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2041-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2041-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2042" : helpers.makeTestYear("Asia/Nicosia", [
		["2042-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2042-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2042-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2042-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2043" : helpers.makeTestYear("Asia/Nicosia", [
		["2043-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2043-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2043-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2043-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2044" : helpers.makeTestYear("Asia/Nicosia", [
		["2044-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2044-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2044-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2044-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2045" : helpers.makeTestYear("Asia/Nicosia", [
		["2045-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2045-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2045-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2045-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2046" : helpers.makeTestYear("Asia/Nicosia", [
		["2046-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2046-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2046-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2046-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2047" : helpers.makeTestYear("Asia/Nicosia", [
		["2047-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2047-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2047-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2047-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2048" : helpers.makeTestYear("Asia/Nicosia", [
		["2048-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2048-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2048-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2048-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2049" : helpers.makeTestYear("Asia/Nicosia", [
		["2049-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2049-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2049-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2049-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2050" : helpers.makeTestYear("Asia/Nicosia", [
		["2050-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2050-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2050-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2050-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2051" : helpers.makeTestYear("Asia/Nicosia", [
		["2051-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2051-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2051-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2051-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2052" : helpers.makeTestYear("Asia/Nicosia", [
		["2052-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2052-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2052-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2052-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2053" : helpers.makeTestYear("Asia/Nicosia", [
		["2053-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2053-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2053-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2053-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2054" : helpers.makeTestYear("Asia/Nicosia", [
		["2054-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2054-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2054-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2054-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2055" : helpers.makeTestYear("Asia/Nicosia", [
		["2055-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2055-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2055-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2055-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2056" : helpers.makeTestYear("Asia/Nicosia", [
		["2056-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2056-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2056-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2056-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2057" : helpers.makeTestYear("Asia/Nicosia", [
		["2057-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2057-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2057-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2057-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2058" : helpers.makeTestYear("Asia/Nicosia", [
		["2058-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2058-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2058-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2058-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2059" : helpers.makeTestYear("Asia/Nicosia", [
		["2059-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2059-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2059-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2059-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2060" : helpers.makeTestYear("Asia/Nicosia", [
		["2060-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2060-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2060-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2060-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2061" : helpers.makeTestYear("Asia/Nicosia", [
		["2061-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2061-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2061-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2061-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2062" : helpers.makeTestYear("Asia/Nicosia", [
		["2062-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2062-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2062-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2062-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2063" : helpers.makeTestYear("Asia/Nicosia", [
		["2063-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2063-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2063-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2063-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2064" : helpers.makeTestYear("Asia/Nicosia", [
		["2064-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2064-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2064-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2064-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2065" : helpers.makeTestYear("Asia/Nicosia", [
		["2065-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2065-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2065-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2065-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2066" : helpers.makeTestYear("Asia/Nicosia", [
		["2066-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2066-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2066-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2066-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2067" : helpers.makeTestYear("Asia/Nicosia", [
		["2067-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2067-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2067-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2067-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2068" : helpers.makeTestYear("Asia/Nicosia", [
		["2068-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2068-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2068-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2068-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2069" : helpers.makeTestYear("Asia/Nicosia", [
		["2069-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2069-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2069-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2069-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2070" : helpers.makeTestYear("Asia/Nicosia", [
		["2070-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2070-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2070-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2070-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2071" : helpers.makeTestYear("Asia/Nicosia", [
		["2071-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2071-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2071-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2071-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2072" : helpers.makeTestYear("Asia/Nicosia", [
		["2072-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2072-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2072-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2072-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2073" : helpers.makeTestYear("Asia/Nicosia", [
		["2073-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2073-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2073-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2073-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2074" : helpers.makeTestYear("Asia/Nicosia", [
		["2074-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2074-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2074-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2074-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2075" : helpers.makeTestYear("Asia/Nicosia", [
		["2075-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2075-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2075-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2075-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2076" : helpers.makeTestYear("Asia/Nicosia", [
		["2076-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2076-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2076-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2076-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2077" : helpers.makeTestYear("Asia/Nicosia", [
		["2077-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2077-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2077-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2077-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2078" : helpers.makeTestYear("Asia/Nicosia", [
		["2078-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2078-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2078-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2078-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2079" : helpers.makeTestYear("Asia/Nicosia", [
		["2079-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2079-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2079-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2079-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2080" : helpers.makeTestYear("Asia/Nicosia", [
		["2080-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2080-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2080-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2080-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2081" : helpers.makeTestYear("Asia/Nicosia", [
		["2081-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2081-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2081-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2081-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2082" : helpers.makeTestYear("Asia/Nicosia", [
		["2082-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2082-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2082-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2082-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2083" : helpers.makeTestYear("Asia/Nicosia", [
		["2083-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2083-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2083-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2083-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2084" : helpers.makeTestYear("Asia/Nicosia", [
		["2084-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2084-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2084-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2084-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2085" : helpers.makeTestYear("Asia/Nicosia", [
		["2085-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2085-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2085-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2085-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2086" : helpers.makeTestYear("Asia/Nicosia", [
		["2086-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2086-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2086-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2086-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2087" : helpers.makeTestYear("Asia/Nicosia", [
		["2087-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2087-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2087-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2087-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2088" : helpers.makeTestYear("Asia/Nicosia", [
		["2088-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2088-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2088-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2088-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2089" : helpers.makeTestYear("Asia/Nicosia", [
		["2089-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2089-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2089-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2089-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2090" : helpers.makeTestYear("Asia/Nicosia", [
		["2090-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2090-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2090-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2090-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2091" : helpers.makeTestYear("Asia/Nicosia", [
		["2091-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2091-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2091-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2091-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2092" : helpers.makeTestYear("Asia/Nicosia", [
		["2092-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2092-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2092-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2092-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2093" : helpers.makeTestYear("Asia/Nicosia", [
		["2093-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2093-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2093-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2093-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2094" : helpers.makeTestYear("Asia/Nicosia", [
		["2094-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2094-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2094-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2094-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2095" : helpers.makeTestYear("Asia/Nicosia", [
		["2095-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2095-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2095-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2095-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2096" : helpers.makeTestYear("Asia/Nicosia", [
		["2096-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2096-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2096-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2096-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2097" : helpers.makeTestYear("Asia/Nicosia", [
		["2097-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2097-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2097-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2097-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2098" : helpers.makeTestYear("Asia/Nicosia", [
		["2098-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2098-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2098-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2098-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2099" : helpers.makeTestYear("Asia/Nicosia", [
		["2099-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2099-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2099-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2099-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2100" : helpers.makeTestYear("Asia/Nicosia", [
		["2100-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2100-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2100-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2100-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2101" : helpers.makeTestYear("Asia/Nicosia", [
		["2101-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2101-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2101-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2101-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2102" : helpers.makeTestYear("Asia/Nicosia", [
		["2102-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2102-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2102-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2102-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2103" : helpers.makeTestYear("Asia/Nicosia", [
		["2103-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2103-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2103-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2103-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2104" : helpers.makeTestYear("Asia/Nicosia", [
		["2104-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2104-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2104-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2104-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2105" : helpers.makeTestYear("Asia/Nicosia", [
		["2105-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2105-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2105-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2105-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2106" : helpers.makeTestYear("Asia/Nicosia", [
		["2106-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2106-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2106-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2106-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2107" : helpers.makeTestYear("Asia/Nicosia", [
		["2107-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2107-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2107-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2107-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2108" : helpers.makeTestYear("Asia/Nicosia", [
		["2108-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2108-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2108-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2108-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2109" : helpers.makeTestYear("Asia/Nicosia", [
		["2109-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2109-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2109-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2109-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2110" : helpers.makeTestYear("Asia/Nicosia", [
		["2110-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2110-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2110-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2110-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2111" : helpers.makeTestYear("Asia/Nicosia", [
		["2111-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2111-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2111-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2111-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2112" : helpers.makeTestYear("Asia/Nicosia", [
		["2112-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2112-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2112-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2112-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2113" : helpers.makeTestYear("Asia/Nicosia", [
		["2113-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2113-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2113-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2113-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2114" : helpers.makeTestYear("Asia/Nicosia", [
		["2114-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2114-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2114-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2114-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2115" : helpers.makeTestYear("Asia/Nicosia", [
		["2115-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2115-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2115-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2115-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2116" : helpers.makeTestYear("Asia/Nicosia", [
		["2116-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2116-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2116-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2116-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2117" : helpers.makeTestYear("Asia/Nicosia", [
		["2117-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2117-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2117-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2117-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2118" : helpers.makeTestYear("Asia/Nicosia", [
		["2118-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2118-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2118-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2118-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2119" : helpers.makeTestYear("Asia/Nicosia", [
		["2119-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2119-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2119-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2119-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2120" : helpers.makeTestYear("Asia/Nicosia", [
		["2120-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2120-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2120-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2120-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2121" : helpers.makeTestYear("Asia/Nicosia", [
		["2121-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2121-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2121-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2121-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2122" : helpers.makeTestYear("Asia/Nicosia", [
		["2122-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2122-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2122-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2122-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2123" : helpers.makeTestYear("Asia/Nicosia", [
		["2123-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2123-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2123-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2123-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2124" : helpers.makeTestYear("Asia/Nicosia", [
		["2124-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2124-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2124-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2124-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2125" : helpers.makeTestYear("Asia/Nicosia", [
		["2125-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2125-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2125-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2125-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2126" : helpers.makeTestYear("Asia/Nicosia", [
		["2126-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2126-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2126-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2126-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2127" : helpers.makeTestYear("Asia/Nicosia", [
		["2127-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2127-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2127-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2127-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2128" : helpers.makeTestYear("Asia/Nicosia", [
		["2128-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2128-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2128-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2128-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2129" : helpers.makeTestYear("Asia/Nicosia", [
		["2129-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2129-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2129-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2129-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2130" : helpers.makeTestYear("Asia/Nicosia", [
		["2130-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2130-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2130-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2130-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2131" : helpers.makeTestYear("Asia/Nicosia", [
		["2131-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2131-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2131-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2131-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2132" : helpers.makeTestYear("Asia/Nicosia", [
		["2132-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2132-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2132-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2132-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2133" : helpers.makeTestYear("Asia/Nicosia", [
		["2133-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2133-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2133-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2133-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2134" : helpers.makeTestYear("Asia/Nicosia", [
		["2134-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2134-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2134-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2134-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2135" : helpers.makeTestYear("Asia/Nicosia", [
		["2135-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2135-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2135-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2135-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2136" : helpers.makeTestYear("Asia/Nicosia", [
		["2136-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2136-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2136-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2136-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2137" : helpers.makeTestYear("Asia/Nicosia", [
		["2137-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2137-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2137-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2137-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2138" : helpers.makeTestYear("Asia/Nicosia", [
		["2138-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2138-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2138-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2138-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2139" : helpers.makeTestYear("Asia/Nicosia", [
		["2139-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2139-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2139-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2139-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2140" : helpers.makeTestYear("Asia/Nicosia", [
		["2140-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2140-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2140-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2140-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2141" : helpers.makeTestYear("Asia/Nicosia", [
		["2141-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2141-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2141-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2141-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2142" : helpers.makeTestYear("Asia/Nicosia", [
		["2142-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2142-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2142-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2142-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2143" : helpers.makeTestYear("Asia/Nicosia", [
		["2143-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2143-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2143-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2143-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2144" : helpers.makeTestYear("Asia/Nicosia", [
		["2144-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2144-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2144-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2144-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2145" : helpers.makeTestYear("Asia/Nicosia", [
		["2145-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2145-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2145-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2145-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2146" : helpers.makeTestYear("Asia/Nicosia", [
		["2146-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2146-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2146-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2146-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2147" : helpers.makeTestYear("Asia/Nicosia", [
		["2147-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2147-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2147-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2147-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2148" : helpers.makeTestYear("Asia/Nicosia", [
		["2148-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2148-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2148-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2148-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2149" : helpers.makeTestYear("Asia/Nicosia", [
		["2149-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2149-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2149-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2149-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2150" : helpers.makeTestYear("Asia/Nicosia", [
		["2150-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2150-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2150-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2150-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2151" : helpers.makeTestYear("Asia/Nicosia", [
		["2151-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2151-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2151-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2151-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2152" : helpers.makeTestYear("Asia/Nicosia", [
		["2152-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2152-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2152-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2152-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2153" : helpers.makeTestYear("Asia/Nicosia", [
		["2153-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2153-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2153-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2153-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2154" : helpers.makeTestYear("Asia/Nicosia", [
		["2154-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2154-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2154-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2154-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2155" : helpers.makeTestYear("Asia/Nicosia", [
		["2155-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2155-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2155-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2155-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2156" : helpers.makeTestYear("Asia/Nicosia", [
		["2156-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2156-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2156-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2156-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2157" : helpers.makeTestYear("Asia/Nicosia", [
		["2157-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2157-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2157-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2157-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2158" : helpers.makeTestYear("Asia/Nicosia", [
		["2158-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2158-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2158-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2158-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2159" : helpers.makeTestYear("Asia/Nicosia", [
		["2159-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2159-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2159-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2159-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2160" : helpers.makeTestYear("Asia/Nicosia", [
		["2160-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2160-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2160-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2160-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2161" : helpers.makeTestYear("Asia/Nicosia", [
		["2161-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2161-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2161-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2161-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2162" : helpers.makeTestYear("Asia/Nicosia", [
		["2162-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2162-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2162-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2162-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2163" : helpers.makeTestYear("Asia/Nicosia", [
		["2163-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2163-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2163-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2163-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2164" : helpers.makeTestYear("Asia/Nicosia", [
		["2164-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2164-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2164-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2164-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2165" : helpers.makeTestYear("Asia/Nicosia", [
		["2165-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2165-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2165-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2165-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2166" : helpers.makeTestYear("Asia/Nicosia", [
		["2166-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2166-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2166-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2166-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2167" : helpers.makeTestYear("Asia/Nicosia", [
		["2167-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2167-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2167-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2167-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2168" : helpers.makeTestYear("Asia/Nicosia", [
		["2168-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2168-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2168-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2168-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2169" : helpers.makeTestYear("Asia/Nicosia", [
		["2169-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2169-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2169-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2169-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2170" : helpers.makeTestYear("Asia/Nicosia", [
		["2170-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2170-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2170-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2170-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2171" : helpers.makeTestYear("Asia/Nicosia", [
		["2171-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2171-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2171-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2171-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2172" : helpers.makeTestYear("Asia/Nicosia", [
		["2172-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2172-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2172-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2172-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2173" : helpers.makeTestYear("Asia/Nicosia", [
		["2173-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2173-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2173-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2173-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2174" : helpers.makeTestYear("Asia/Nicosia", [
		["2174-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2174-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2174-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2174-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2175" : helpers.makeTestYear("Asia/Nicosia", [
		["2175-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2175-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2175-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2175-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2176" : helpers.makeTestYear("Asia/Nicosia", [
		["2176-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2176-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2176-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2176-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2177" : helpers.makeTestYear("Asia/Nicosia", [
		["2177-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2177-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2177-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2177-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2178" : helpers.makeTestYear("Asia/Nicosia", [
		["2178-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2178-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2178-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2178-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2179" : helpers.makeTestYear("Asia/Nicosia", [
		["2179-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2179-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2179-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2179-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2180" : helpers.makeTestYear("Asia/Nicosia", [
		["2180-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2180-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2180-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2180-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2181" : helpers.makeTestYear("Asia/Nicosia", [
		["2181-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2181-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2181-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2181-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2182" : helpers.makeTestYear("Asia/Nicosia", [
		["2182-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2182-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2182-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2182-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2183" : helpers.makeTestYear("Asia/Nicosia", [
		["2183-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2183-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2183-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2183-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2184" : helpers.makeTestYear("Asia/Nicosia", [
		["2184-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2184-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2184-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2184-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2185" : helpers.makeTestYear("Asia/Nicosia", [
		["2185-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2185-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2185-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2185-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2186" : helpers.makeTestYear("Asia/Nicosia", [
		["2186-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2186-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2186-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2186-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2187" : helpers.makeTestYear("Asia/Nicosia", [
		["2187-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2187-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2187-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2187-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2188" : helpers.makeTestYear("Asia/Nicosia", [
		["2188-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2188-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2188-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2188-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2189" : helpers.makeTestYear("Asia/Nicosia", [
		["2189-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2189-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2189-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2189-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2190" : helpers.makeTestYear("Asia/Nicosia", [
		["2190-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2190-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2190-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2190-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2191" : helpers.makeTestYear("Asia/Nicosia", [
		["2191-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2191-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2191-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2191-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2192" : helpers.makeTestYear("Asia/Nicosia", [
		["2192-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2192-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2192-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2192-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2193" : helpers.makeTestYear("Asia/Nicosia", [
		["2193-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2193-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2193-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2193-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2194" : helpers.makeTestYear("Asia/Nicosia", [
		["2194-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2194-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2194-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2194-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2195" : helpers.makeTestYear("Asia/Nicosia", [
		["2195-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2195-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2195-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2195-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2196" : helpers.makeTestYear("Asia/Nicosia", [
		["2196-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2196-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2196-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2196-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2197" : helpers.makeTestYear("Asia/Nicosia", [
		["2197-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2197-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2197-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2197-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2198" : helpers.makeTestYear("Asia/Nicosia", [
		["2198-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2198-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2198-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2198-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2199" : helpers.makeTestYear("Asia/Nicosia", [
		["2199-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2199-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2199-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2199-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2200" : helpers.makeTestYear("Asia/Nicosia", [
		["2200-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2200-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2200-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2200-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2201" : helpers.makeTestYear("Asia/Nicosia", [
		["2201-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2201-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2201-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2201-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2202" : helpers.makeTestYear("Asia/Nicosia", [
		["2202-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2202-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2202-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2202-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2203" : helpers.makeTestYear("Asia/Nicosia", [
		["2203-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2203-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2203-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2203-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2204" : helpers.makeTestYear("Asia/Nicosia", [
		["2204-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2204-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2204-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2204-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2205" : helpers.makeTestYear("Asia/Nicosia", [
		["2205-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2205-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2205-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2205-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2206" : helpers.makeTestYear("Asia/Nicosia", [
		["2206-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2206-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2206-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2206-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2207" : helpers.makeTestYear("Asia/Nicosia", [
		["2207-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2207-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2207-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2207-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2208" : helpers.makeTestYear("Asia/Nicosia", [
		["2208-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2208-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2208-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2208-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2209" : helpers.makeTestYear("Asia/Nicosia", [
		["2209-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2209-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2209-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2209-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2210" : helpers.makeTestYear("Asia/Nicosia", [
		["2210-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2210-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2210-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2210-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2211" : helpers.makeTestYear("Asia/Nicosia", [
		["2211-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2211-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2211-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2211-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2212" : helpers.makeTestYear("Asia/Nicosia", [
		["2212-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2212-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2212-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2212-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2213" : helpers.makeTestYear("Asia/Nicosia", [
		["2213-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2213-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2213-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2213-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2214" : helpers.makeTestYear("Asia/Nicosia", [
		["2214-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2214-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2214-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2214-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2215" : helpers.makeTestYear("Asia/Nicosia", [
		["2215-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2215-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2215-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2215-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2216" : helpers.makeTestYear("Asia/Nicosia", [
		["2216-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2216-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2216-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2216-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2217" : helpers.makeTestYear("Asia/Nicosia", [
		["2217-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2217-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2217-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2217-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2218" : helpers.makeTestYear("Asia/Nicosia", [
		["2218-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2218-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2218-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2218-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2219" : helpers.makeTestYear("Asia/Nicosia", [
		["2219-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2219-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2219-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2219-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2220" : helpers.makeTestYear("Asia/Nicosia", [
		["2220-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2220-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2220-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2220-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2221" : helpers.makeTestYear("Asia/Nicosia", [
		["2221-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2221-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2221-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2221-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2222" : helpers.makeTestYear("Asia/Nicosia", [
		["2222-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2222-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2222-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2222-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2223" : helpers.makeTestYear("Asia/Nicosia", [
		["2223-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2223-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2223-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2223-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2224" : helpers.makeTestYear("Asia/Nicosia", [
		["2224-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2224-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2224-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2224-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2225" : helpers.makeTestYear("Asia/Nicosia", [
		["2225-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2225-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2225-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2225-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2226" : helpers.makeTestYear("Asia/Nicosia", [
		["2226-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2226-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2226-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2226-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2227" : helpers.makeTestYear("Asia/Nicosia", [
		["2227-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2227-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2227-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2227-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2228" : helpers.makeTestYear("Asia/Nicosia", [
		["2228-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2228-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2228-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2228-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2229" : helpers.makeTestYear("Asia/Nicosia", [
		["2229-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2229-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2229-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2229-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2230" : helpers.makeTestYear("Asia/Nicosia", [
		["2230-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2230-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2230-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2230-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2231" : helpers.makeTestYear("Asia/Nicosia", [
		["2231-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2231-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2231-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2231-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2232" : helpers.makeTestYear("Asia/Nicosia", [
		["2232-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2232-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2232-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2232-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2233" : helpers.makeTestYear("Asia/Nicosia", [
		["2233-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2233-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2233-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2233-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2234" : helpers.makeTestYear("Asia/Nicosia", [
		["2234-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2234-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2234-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2234-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2235" : helpers.makeTestYear("Asia/Nicosia", [
		["2235-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2235-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2235-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2235-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2236" : helpers.makeTestYear("Asia/Nicosia", [
		["2236-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2236-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2236-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2236-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2237" : helpers.makeTestYear("Asia/Nicosia", [
		["2237-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2237-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2237-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2237-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2238" : helpers.makeTestYear("Asia/Nicosia", [
		["2238-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2238-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2238-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2238-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2239" : helpers.makeTestYear("Asia/Nicosia", [
		["2239-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2239-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2239-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2239-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2240" : helpers.makeTestYear("Asia/Nicosia", [
		["2240-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2240-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2240-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2240-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2241" : helpers.makeTestYear("Asia/Nicosia", [
		["2241-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2241-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2241-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2241-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2242" : helpers.makeTestYear("Asia/Nicosia", [
		["2242-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2242-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2242-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2242-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2243" : helpers.makeTestYear("Asia/Nicosia", [
		["2243-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2243-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2243-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2243-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2244" : helpers.makeTestYear("Asia/Nicosia", [
		["2244-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2244-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2244-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2244-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2245" : helpers.makeTestYear("Asia/Nicosia", [
		["2245-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2245-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2245-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2245-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2246" : helpers.makeTestYear("Asia/Nicosia", [
		["2246-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2246-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2246-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2246-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2247" : helpers.makeTestYear("Asia/Nicosia", [
		["2247-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2247-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2247-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2247-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2248" : helpers.makeTestYear("Asia/Nicosia", [
		["2248-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2248-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2248-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2248-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2249" : helpers.makeTestYear("Asia/Nicosia", [
		["2249-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2249-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2249-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2249-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2250" : helpers.makeTestYear("Asia/Nicosia", [
		["2250-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2250-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2250-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2250-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2251" : helpers.makeTestYear("Asia/Nicosia", [
		["2251-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2251-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2251-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2251-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2252" : helpers.makeTestYear("Asia/Nicosia", [
		["2252-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2252-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2252-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2252-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2253" : helpers.makeTestYear("Asia/Nicosia", [
		["2253-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2253-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2253-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2253-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2254" : helpers.makeTestYear("Asia/Nicosia", [
		["2254-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2254-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2254-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2254-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2255" : helpers.makeTestYear("Asia/Nicosia", [
		["2255-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2255-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2255-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2255-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2256" : helpers.makeTestYear("Asia/Nicosia", [
		["2256-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2256-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2256-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2256-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2257" : helpers.makeTestYear("Asia/Nicosia", [
		["2257-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2257-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2257-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2257-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2258" : helpers.makeTestYear("Asia/Nicosia", [
		["2258-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2258-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2258-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2258-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2259" : helpers.makeTestYear("Asia/Nicosia", [
		["2259-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2259-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2259-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2259-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2260" : helpers.makeTestYear("Asia/Nicosia", [
		["2260-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2260-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2260-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2260-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2261" : helpers.makeTestYear("Asia/Nicosia", [
		["2261-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2261-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2261-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2261-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2262" : helpers.makeTestYear("Asia/Nicosia", [
		["2262-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2262-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2262-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2262-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2263" : helpers.makeTestYear("Asia/Nicosia", [
		["2263-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2263-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2263-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2263-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2264" : helpers.makeTestYear("Asia/Nicosia", [
		["2264-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2264-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2264-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2264-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2265" : helpers.makeTestYear("Asia/Nicosia", [
		["2265-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2265-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2265-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2265-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2266" : helpers.makeTestYear("Asia/Nicosia", [
		["2266-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2266-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2266-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2266-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2267" : helpers.makeTestYear("Asia/Nicosia", [
		["2267-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2267-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2267-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2267-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2268" : helpers.makeTestYear("Asia/Nicosia", [
		["2268-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2268-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2268-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2268-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2269" : helpers.makeTestYear("Asia/Nicosia", [
		["2269-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2269-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2269-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2269-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2270" : helpers.makeTestYear("Asia/Nicosia", [
		["2270-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2270-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2270-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2270-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2271" : helpers.makeTestYear("Asia/Nicosia", [
		["2271-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2271-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2271-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2271-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2272" : helpers.makeTestYear("Asia/Nicosia", [
		["2272-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2272-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2272-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2272-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2273" : helpers.makeTestYear("Asia/Nicosia", [
		["2273-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2273-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2273-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2273-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2274" : helpers.makeTestYear("Asia/Nicosia", [
		["2274-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2274-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2274-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2274-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2275" : helpers.makeTestYear("Asia/Nicosia", [
		["2275-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2275-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2275-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2275-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2276" : helpers.makeTestYear("Asia/Nicosia", [
		["2276-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2276-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2276-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2276-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2277" : helpers.makeTestYear("Asia/Nicosia", [
		["2277-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2277-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2277-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2277-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2278" : helpers.makeTestYear("Asia/Nicosia", [
		["2278-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2278-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2278-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2278-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2279" : helpers.makeTestYear("Asia/Nicosia", [
		["2279-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2279-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2279-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2279-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2280" : helpers.makeTestYear("Asia/Nicosia", [
		["2280-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2280-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2280-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2280-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2281" : helpers.makeTestYear("Asia/Nicosia", [
		["2281-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2281-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2281-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2281-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2282" : helpers.makeTestYear("Asia/Nicosia", [
		["2282-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2282-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2282-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2282-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2283" : helpers.makeTestYear("Asia/Nicosia", [
		["2283-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2283-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2283-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2283-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2284" : helpers.makeTestYear("Asia/Nicosia", [
		["2284-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2284-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2284-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2284-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2285" : helpers.makeTestYear("Asia/Nicosia", [
		["2285-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2285-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2285-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2285-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2286" : helpers.makeTestYear("Asia/Nicosia", [
		["2286-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2286-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2286-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2286-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2287" : helpers.makeTestYear("Asia/Nicosia", [
		["2287-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2287-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2287-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2287-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2288" : helpers.makeTestYear("Asia/Nicosia", [
		["2288-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2288-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2288-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2288-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2289" : helpers.makeTestYear("Asia/Nicosia", [
		["2289-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2289-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2289-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2289-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2290" : helpers.makeTestYear("Asia/Nicosia", [
		["2290-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2290-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2290-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2290-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2291" : helpers.makeTestYear("Asia/Nicosia", [
		["2291-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2291-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2291-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2291-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2292" : helpers.makeTestYear("Asia/Nicosia", [
		["2292-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2292-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2292-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2292-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2293" : helpers.makeTestYear("Asia/Nicosia", [
		["2293-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2293-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2293-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2293-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2294" : helpers.makeTestYear("Asia/Nicosia", [
		["2294-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2294-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2294-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2294-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2295" : helpers.makeTestYear("Asia/Nicosia", [
		["2295-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2295-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2295-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2295-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2296" : helpers.makeTestYear("Asia/Nicosia", [
		["2296-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2296-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2296-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2296-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2297" : helpers.makeTestYear("Asia/Nicosia", [
		["2297-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2297-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2297-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2297-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2298" : helpers.makeTestYear("Asia/Nicosia", [
		["2298-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2298-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2298-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2298-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2299" : helpers.makeTestYear("Asia/Nicosia", [
		["2299-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2299-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2299-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2299-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2300" : helpers.makeTestYear("Asia/Nicosia", [
		["2300-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2300-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2300-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2300-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2301" : helpers.makeTestYear("Asia/Nicosia", [
		["2301-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2301-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2301-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2301-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2302" : helpers.makeTestYear("Asia/Nicosia", [
		["2302-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2302-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2302-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2302-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2303" : helpers.makeTestYear("Asia/Nicosia", [
		["2303-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2303-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2303-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2303-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2304" : helpers.makeTestYear("Asia/Nicosia", [
		["2304-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2304-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2304-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2304-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2305" : helpers.makeTestYear("Asia/Nicosia", [
		["2305-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2305-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2305-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2305-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2306" : helpers.makeTestYear("Asia/Nicosia", [
		["2306-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2306-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2306-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2306-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2307" : helpers.makeTestYear("Asia/Nicosia", [
		["2307-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2307-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2307-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2307-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2308" : helpers.makeTestYear("Asia/Nicosia", [
		["2308-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2308-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2308-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2308-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2309" : helpers.makeTestYear("Asia/Nicosia", [
		["2309-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2309-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2309-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2309-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2310" : helpers.makeTestYear("Asia/Nicosia", [
		["2310-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2310-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2310-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2310-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2311" : helpers.makeTestYear("Asia/Nicosia", [
		["2311-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2311-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2311-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2311-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2312" : helpers.makeTestYear("Asia/Nicosia", [
		["2312-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2312-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2312-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2312-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2313" : helpers.makeTestYear("Asia/Nicosia", [
		["2313-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2313-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2313-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2313-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2314" : helpers.makeTestYear("Asia/Nicosia", [
		["2314-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2314-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2314-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2314-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2315" : helpers.makeTestYear("Asia/Nicosia", [
		["2315-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2315-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2315-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2315-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2316" : helpers.makeTestYear("Asia/Nicosia", [
		["2316-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2316-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2316-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2316-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2317" : helpers.makeTestYear("Asia/Nicosia", [
		["2317-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2317-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2317-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2317-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2318" : helpers.makeTestYear("Asia/Nicosia", [
		["2318-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2318-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2318-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2318-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2319" : helpers.makeTestYear("Asia/Nicosia", [
		["2319-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2319-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2319-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2319-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2320" : helpers.makeTestYear("Asia/Nicosia", [
		["2320-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2320-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2320-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2320-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2321" : helpers.makeTestYear("Asia/Nicosia", [
		["2321-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2321-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2321-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2321-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2322" : helpers.makeTestYear("Asia/Nicosia", [
		["2322-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2322-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2322-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2322-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2323" : helpers.makeTestYear("Asia/Nicosia", [
		["2323-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2323-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2323-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2323-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2324" : helpers.makeTestYear("Asia/Nicosia", [
		["2324-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2324-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2324-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2324-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2325" : helpers.makeTestYear("Asia/Nicosia", [
		["2325-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2325-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2325-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2325-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2326" : helpers.makeTestYear("Asia/Nicosia", [
		["2326-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2326-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2326-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2326-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2327" : helpers.makeTestYear("Asia/Nicosia", [
		["2327-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2327-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2327-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2327-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2328" : helpers.makeTestYear("Asia/Nicosia", [
		["2328-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2328-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2328-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2328-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2329" : helpers.makeTestYear("Asia/Nicosia", [
		["2329-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2329-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2329-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2329-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2330" : helpers.makeTestYear("Asia/Nicosia", [
		["2330-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2330-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2330-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2330-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2331" : helpers.makeTestYear("Asia/Nicosia", [
		["2331-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2331-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2331-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2331-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2332" : helpers.makeTestYear("Asia/Nicosia", [
		["2332-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2332-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2332-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2332-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2333" : helpers.makeTestYear("Asia/Nicosia", [
		["2333-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2333-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2333-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2333-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2334" : helpers.makeTestYear("Asia/Nicosia", [
		["2334-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2334-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2334-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2334-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2335" : helpers.makeTestYear("Asia/Nicosia", [
		["2335-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2335-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2335-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2335-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2336" : helpers.makeTestYear("Asia/Nicosia", [
		["2336-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2336-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2336-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2336-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2337" : helpers.makeTestYear("Asia/Nicosia", [
		["2337-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2337-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2337-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2337-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2338" : helpers.makeTestYear("Asia/Nicosia", [
		["2338-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2338-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2338-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2338-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2339" : helpers.makeTestYear("Asia/Nicosia", [
		["2339-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2339-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2339-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2339-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2340" : helpers.makeTestYear("Asia/Nicosia", [
		["2340-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2340-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2340-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2340-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2341" : helpers.makeTestYear("Asia/Nicosia", [
		["2341-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2341-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2341-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2341-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2342" : helpers.makeTestYear("Asia/Nicosia", [
		["2342-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2342-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2342-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2342-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2343" : helpers.makeTestYear("Asia/Nicosia", [
		["2343-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2343-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2343-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2343-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2344" : helpers.makeTestYear("Asia/Nicosia", [
		["2344-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2344-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2344-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2344-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2345" : helpers.makeTestYear("Asia/Nicosia", [
		["2345-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2345-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2345-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2345-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2346" : helpers.makeTestYear("Asia/Nicosia", [
		["2346-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2346-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2346-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2346-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2347" : helpers.makeTestYear("Asia/Nicosia", [
		["2347-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2347-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2347-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2347-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2348" : helpers.makeTestYear("Asia/Nicosia", [
		["2348-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2348-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2348-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2348-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2349" : helpers.makeTestYear("Asia/Nicosia", [
		["2349-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2349-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2349-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2349-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2350" : helpers.makeTestYear("Asia/Nicosia", [
		["2350-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2350-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2350-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2350-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2351" : helpers.makeTestYear("Asia/Nicosia", [
		["2351-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2351-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2351-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2351-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2352" : helpers.makeTestYear("Asia/Nicosia", [
		["2352-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2352-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2352-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2352-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2353" : helpers.makeTestYear("Asia/Nicosia", [
		["2353-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2353-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2353-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2353-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2354" : helpers.makeTestYear("Asia/Nicosia", [
		["2354-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2354-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2354-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2354-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2355" : helpers.makeTestYear("Asia/Nicosia", [
		["2355-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2355-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2355-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2355-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2356" : helpers.makeTestYear("Asia/Nicosia", [
		["2356-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2356-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2356-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2356-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2357" : helpers.makeTestYear("Asia/Nicosia", [
		["2357-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2357-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2357-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2357-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2358" : helpers.makeTestYear("Asia/Nicosia", [
		["2358-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2358-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2358-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2358-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2359" : helpers.makeTestYear("Asia/Nicosia", [
		["2359-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2359-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2359-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2359-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2360" : helpers.makeTestYear("Asia/Nicosia", [
		["2360-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2360-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2360-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2360-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2361" : helpers.makeTestYear("Asia/Nicosia", [
		["2361-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2361-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2361-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2361-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2362" : helpers.makeTestYear("Asia/Nicosia", [
		["2362-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2362-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2362-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2362-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2363" : helpers.makeTestYear("Asia/Nicosia", [
		["2363-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2363-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2363-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2363-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2364" : helpers.makeTestYear("Asia/Nicosia", [
		["2364-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2364-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2364-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2364-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2365" : helpers.makeTestYear("Asia/Nicosia", [
		["2365-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2365-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2365-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2365-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2366" : helpers.makeTestYear("Asia/Nicosia", [
		["2366-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2366-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2366-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2366-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2367" : helpers.makeTestYear("Asia/Nicosia", [
		["2367-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2367-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2367-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2367-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2368" : helpers.makeTestYear("Asia/Nicosia", [
		["2368-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2368-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2368-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2368-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2369" : helpers.makeTestYear("Asia/Nicosia", [
		["2369-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2369-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2369-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2369-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2370" : helpers.makeTestYear("Asia/Nicosia", [
		["2370-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2370-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2370-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2370-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2371" : helpers.makeTestYear("Asia/Nicosia", [
		["2371-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2371-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2371-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2371-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2372" : helpers.makeTestYear("Asia/Nicosia", [
		["2372-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2372-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2372-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2372-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2373" : helpers.makeTestYear("Asia/Nicosia", [
		["2373-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2373-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2373-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2373-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2374" : helpers.makeTestYear("Asia/Nicosia", [
		["2374-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2374-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2374-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2374-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2375" : helpers.makeTestYear("Asia/Nicosia", [
		["2375-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2375-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2375-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2375-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2376" : helpers.makeTestYear("Asia/Nicosia", [
		["2376-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2376-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2376-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2376-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2377" : helpers.makeTestYear("Asia/Nicosia", [
		["2377-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2377-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2377-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2377-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2378" : helpers.makeTestYear("Asia/Nicosia", [
		["2378-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2378-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2378-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2378-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2379" : helpers.makeTestYear("Asia/Nicosia", [
		["2379-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2379-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2379-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2379-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2380" : helpers.makeTestYear("Asia/Nicosia", [
		["2380-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2380-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2380-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2380-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2381" : helpers.makeTestYear("Asia/Nicosia", [
		["2381-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2381-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2381-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2381-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2382" : helpers.makeTestYear("Asia/Nicosia", [
		["2382-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2382-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2382-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2382-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2383" : helpers.makeTestYear("Asia/Nicosia", [
		["2383-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2383-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2383-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2383-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2384" : helpers.makeTestYear("Asia/Nicosia", [
		["2384-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2384-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2384-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2384-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2385" : helpers.makeTestYear("Asia/Nicosia", [
		["2385-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2385-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2385-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2385-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2386" : helpers.makeTestYear("Asia/Nicosia", [
		["2386-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2386-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2386-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2386-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2387" : helpers.makeTestYear("Asia/Nicosia", [
		["2387-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2387-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2387-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2387-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2388" : helpers.makeTestYear("Asia/Nicosia", [
		["2388-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2388-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2388-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2388-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2389" : helpers.makeTestYear("Asia/Nicosia", [
		["2389-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2389-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2389-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2389-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2390" : helpers.makeTestYear("Asia/Nicosia", [
		["2390-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2390-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2390-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2390-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2391" : helpers.makeTestYear("Asia/Nicosia", [
		["2391-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2391-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2391-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2391-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2392" : helpers.makeTestYear("Asia/Nicosia", [
		["2392-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2392-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2392-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2392-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2393" : helpers.makeTestYear("Asia/Nicosia", [
		["2393-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2393-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2393-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2393-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2394" : helpers.makeTestYear("Asia/Nicosia", [
		["2394-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2394-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2394-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2394-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2395" : helpers.makeTestYear("Asia/Nicosia", [
		["2395-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2395-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2395-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2395-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2396" : helpers.makeTestYear("Asia/Nicosia", [
		["2396-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2396-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2396-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2396-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2397" : helpers.makeTestYear("Asia/Nicosia", [
		["2397-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2397-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2397-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2397-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2398" : helpers.makeTestYear("Asia/Nicosia", [
		["2398-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2398-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2398-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2398-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2399" : helpers.makeTestYear("Asia/Nicosia", [
		["2399-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2399-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2399-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2399-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2400" : helpers.makeTestYear("Asia/Nicosia", [
		["2400-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2400-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2400-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2400-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2401" : helpers.makeTestYear("Asia/Nicosia", [
		["2401-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2401-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2401-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2401-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2402" : helpers.makeTestYear("Asia/Nicosia", [
		["2402-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2402-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2402-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2402-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2403" : helpers.makeTestYear("Asia/Nicosia", [
		["2403-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2403-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2403-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2403-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2404" : helpers.makeTestYear("Asia/Nicosia", [
		["2404-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2404-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2404-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2404-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2405" : helpers.makeTestYear("Asia/Nicosia", [
		["2405-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2405-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2405-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2405-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2406" : helpers.makeTestYear("Asia/Nicosia", [
		["2406-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2406-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2406-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2406-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2407" : helpers.makeTestYear("Asia/Nicosia", [
		["2407-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2407-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2407-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2407-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2408" : helpers.makeTestYear("Asia/Nicosia", [
		["2408-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2408-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2408-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2408-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2409" : helpers.makeTestYear("Asia/Nicosia", [
		["2409-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2409-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2409-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2409-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2410" : helpers.makeTestYear("Asia/Nicosia", [
		["2410-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2410-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2410-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2410-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2411" : helpers.makeTestYear("Asia/Nicosia", [
		["2411-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2411-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2411-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2411-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2412" : helpers.makeTestYear("Asia/Nicosia", [
		["2412-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2412-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2412-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2412-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2413" : helpers.makeTestYear("Asia/Nicosia", [
		["2413-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2413-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2413-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2413-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2414" : helpers.makeTestYear("Asia/Nicosia", [
		["2414-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2414-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2414-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2414-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2415" : helpers.makeTestYear("Asia/Nicosia", [
		["2415-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2415-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2415-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2415-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2416" : helpers.makeTestYear("Asia/Nicosia", [
		["2416-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2416-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2416-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2416-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2417" : helpers.makeTestYear("Asia/Nicosia", [
		["2417-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2417-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2417-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2417-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2418" : helpers.makeTestYear("Asia/Nicosia", [
		["2418-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2418-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2418-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2418-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2419" : helpers.makeTestYear("Asia/Nicosia", [
		["2419-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2419-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2419-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2419-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2420" : helpers.makeTestYear("Asia/Nicosia", [
		["2420-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2420-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2420-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2420-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2421" : helpers.makeTestYear("Asia/Nicosia", [
		["2421-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2421-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2421-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2421-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2422" : helpers.makeTestYear("Asia/Nicosia", [
		["2422-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2422-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2422-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2422-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2423" : helpers.makeTestYear("Asia/Nicosia", [
		["2423-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2423-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2423-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2423-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2424" : helpers.makeTestYear("Asia/Nicosia", [
		["2424-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2424-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2424-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2424-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2425" : helpers.makeTestYear("Asia/Nicosia", [
		["2425-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2425-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2425-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2425-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2426" : helpers.makeTestYear("Asia/Nicosia", [
		["2426-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2426-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2426-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2426-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2427" : helpers.makeTestYear("Asia/Nicosia", [
		["2427-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2427-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2427-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2427-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2428" : helpers.makeTestYear("Asia/Nicosia", [
		["2428-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2428-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2428-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2428-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2429" : helpers.makeTestYear("Asia/Nicosia", [
		["2429-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2429-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2429-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2429-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2430" : helpers.makeTestYear("Asia/Nicosia", [
		["2430-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2430-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2430-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2430-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2431" : helpers.makeTestYear("Asia/Nicosia", [
		["2431-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2431-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2431-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2431-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2432" : helpers.makeTestYear("Asia/Nicosia", [
		["2432-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2432-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2432-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2432-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2433" : helpers.makeTestYear("Asia/Nicosia", [
		["2433-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2433-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2433-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2433-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2434" : helpers.makeTestYear("Asia/Nicosia", [
		["2434-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2434-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2434-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2434-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2435" : helpers.makeTestYear("Asia/Nicosia", [
		["2435-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2435-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2435-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2435-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2436" : helpers.makeTestYear("Asia/Nicosia", [
		["2436-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2436-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2436-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2436-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2437" : helpers.makeTestYear("Asia/Nicosia", [
		["2437-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2437-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2437-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2437-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2438" : helpers.makeTestYear("Asia/Nicosia", [
		["2438-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2438-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2438-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2438-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2439" : helpers.makeTestYear("Asia/Nicosia", [
		["2439-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2439-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2439-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2439-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2440" : helpers.makeTestYear("Asia/Nicosia", [
		["2440-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2440-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2440-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2440-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2441" : helpers.makeTestYear("Asia/Nicosia", [
		["2441-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2441-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2441-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2441-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2442" : helpers.makeTestYear("Asia/Nicosia", [
		["2442-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2442-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2442-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2442-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2443" : helpers.makeTestYear("Asia/Nicosia", [
		["2443-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2443-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2443-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2443-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2444" : helpers.makeTestYear("Asia/Nicosia", [
		["2444-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2444-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2444-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2444-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2445" : helpers.makeTestYear("Asia/Nicosia", [
		["2445-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2445-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2445-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2445-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2446" : helpers.makeTestYear("Asia/Nicosia", [
		["2446-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2446-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2446-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2446-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2447" : helpers.makeTestYear("Asia/Nicosia", [
		["2447-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2447-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2447-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2447-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2448" : helpers.makeTestYear("Asia/Nicosia", [
		["2448-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2448-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2448-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2448-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2449" : helpers.makeTestYear("Asia/Nicosia", [
		["2449-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2449-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2449-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2449-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2450" : helpers.makeTestYear("Asia/Nicosia", [
		["2450-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2450-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2450-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2450-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2451" : helpers.makeTestYear("Asia/Nicosia", [
		["2451-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2451-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2451-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2451-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2452" : helpers.makeTestYear("Asia/Nicosia", [
		["2452-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2452-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2452-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2452-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2453" : helpers.makeTestYear("Asia/Nicosia", [
		["2453-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2453-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2453-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2453-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2454" : helpers.makeTestYear("Asia/Nicosia", [
		["2454-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2454-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2454-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2454-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2455" : helpers.makeTestYear("Asia/Nicosia", [
		["2455-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2455-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2455-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2455-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2456" : helpers.makeTestYear("Asia/Nicosia", [
		["2456-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2456-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2456-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2456-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2457" : helpers.makeTestYear("Asia/Nicosia", [
		["2457-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2457-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2457-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2457-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2458" : helpers.makeTestYear("Asia/Nicosia", [
		["2458-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2458-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2458-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2458-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2459" : helpers.makeTestYear("Asia/Nicosia", [
		["2459-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2459-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2459-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2459-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2460" : helpers.makeTestYear("Asia/Nicosia", [
		["2460-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2460-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2460-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2460-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2461" : helpers.makeTestYear("Asia/Nicosia", [
		["2461-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2461-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2461-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2461-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2462" : helpers.makeTestYear("Asia/Nicosia", [
		["2462-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2462-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2462-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2462-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2463" : helpers.makeTestYear("Asia/Nicosia", [
		["2463-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2463-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2463-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2463-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2464" : helpers.makeTestYear("Asia/Nicosia", [
		["2464-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2464-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2464-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2464-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2465" : helpers.makeTestYear("Asia/Nicosia", [
		["2465-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2465-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2465-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2465-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2466" : helpers.makeTestYear("Asia/Nicosia", [
		["2466-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2466-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2466-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2466-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2467" : helpers.makeTestYear("Asia/Nicosia", [
		["2467-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2467-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2467-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2467-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2468" : helpers.makeTestYear("Asia/Nicosia", [
		["2468-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2468-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2468-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2468-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2469" : helpers.makeTestYear("Asia/Nicosia", [
		["2469-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2469-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2469-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2469-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2470" : helpers.makeTestYear("Asia/Nicosia", [
		["2470-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2470-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2470-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2470-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2471" : helpers.makeTestYear("Asia/Nicosia", [
		["2471-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2471-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2471-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2471-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2472" : helpers.makeTestYear("Asia/Nicosia", [
		["2472-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2472-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2472-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2472-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2473" : helpers.makeTestYear("Asia/Nicosia", [
		["2473-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2473-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2473-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2473-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2474" : helpers.makeTestYear("Asia/Nicosia", [
		["2474-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2474-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2474-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2474-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2475" : helpers.makeTestYear("Asia/Nicosia", [
		["2475-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2475-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2475-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2475-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2476" : helpers.makeTestYear("Asia/Nicosia", [
		["2476-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2476-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2476-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2476-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2477" : helpers.makeTestYear("Asia/Nicosia", [
		["2477-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2477-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2477-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2477-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2478" : helpers.makeTestYear("Asia/Nicosia", [
		["2478-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2478-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2478-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2478-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2479" : helpers.makeTestYear("Asia/Nicosia", [
		["2479-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2479-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2479-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2479-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2480" : helpers.makeTestYear("Asia/Nicosia", [
		["2480-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2480-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2480-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2480-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2481" : helpers.makeTestYear("Asia/Nicosia", [
		["2481-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2481-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2481-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2481-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2482" : helpers.makeTestYear("Asia/Nicosia", [
		["2482-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2482-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2482-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2482-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2483" : helpers.makeTestYear("Asia/Nicosia", [
		["2483-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2483-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2483-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2483-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2484" : helpers.makeTestYear("Asia/Nicosia", [
		["2484-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2484-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2484-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2484-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2485" : helpers.makeTestYear("Asia/Nicosia", [
		["2485-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2485-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2485-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2485-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2486" : helpers.makeTestYear("Asia/Nicosia", [
		["2486-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2486-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2486-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2486-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2487" : helpers.makeTestYear("Asia/Nicosia", [
		["2487-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2487-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2487-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2487-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2488" : helpers.makeTestYear("Asia/Nicosia", [
		["2488-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2488-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2488-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2488-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2489" : helpers.makeTestYear("Asia/Nicosia", [
		["2489-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2489-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2489-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2489-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2490" : helpers.makeTestYear("Asia/Nicosia", [
		["2490-03-26T00:59:59+00:00", "02:59:59", "EET", -120],
		["2490-03-26T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2490-10-29T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2490-10-29T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2491" : helpers.makeTestYear("Asia/Nicosia", [
		["2491-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2491-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2491-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2491-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2492" : helpers.makeTestYear("Asia/Nicosia", [
		["2492-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2492-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2492-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2492-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2493" : helpers.makeTestYear("Asia/Nicosia", [
		["2493-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2493-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2493-10-25T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2493-10-25T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2494" : helpers.makeTestYear("Asia/Nicosia", [
		["2494-03-28T00:59:59+00:00", "02:59:59", "EET", -120],
		["2494-03-28T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2494-10-31T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2494-10-31T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2495" : helpers.makeTestYear("Asia/Nicosia", [
		["2495-03-27T00:59:59+00:00", "02:59:59", "EET", -120],
		["2495-03-27T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2495-10-30T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2495-10-30T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2496" : helpers.makeTestYear("Asia/Nicosia", [
		["2496-03-25T00:59:59+00:00", "02:59:59", "EET", -120],
		["2496-03-25T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2496-10-28T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2496-10-28T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2497" : helpers.makeTestYear("Asia/Nicosia", [
		["2497-03-31T00:59:59+00:00", "02:59:59", "EET", -120],
		["2497-03-31T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2497-10-27T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2497-10-27T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2498" : helpers.makeTestYear("Asia/Nicosia", [
		["2498-03-30T00:59:59+00:00", "02:59:59", "EET", -120],
		["2498-03-30T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2498-10-26T00:59:59+00:00", "03:59:59", "EEST", -180],
		["2498-10-26T01:00:00+00:00", "03:00:00", "EET", -120]
	]),

	"2499" : helpers.makeTestYear("Asia/Nicosia", [
		["2499-03-29T00:59:59+00:00", "02:59:59", "EET", -120],
		["2499-03-29T01:00:00+00:00", "04:00:00", "EEST", -180],
		["2499-10-25T00:59:59+00:00", "03:59:59", "EEST", -180]
	])
};