/* NVTV NV TV-Xbox I2C access -- Milosch Meriac <xboxlinux@meriac.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 *
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * Header: 
 * I2C-related by code - Andy Green <andy@warmcat.com>
 * Adapted for nvtv - "Milosch Meriac" <xboxlinux@meriac.de>
 *  
 */

#ifndef __XBOX_H__
#define __XBOX_H__


enum {
	ERR_SUCCESS = 0,  // completed without error

	ERR_I2C_ERROR_TIMEOUT = 0x80000001,  // I2C action failed because it did not complete in a reasonable time
	ERR_I2C_ERROR_BUS = 0x80000002, // I2C action failed due to non retryable bus error

	ERR_BOOT_PIC_ALG_BROKEN = 0x80000101 // PIC algorithm did not pass its self-test
};

extern int I2CTransmitCmdGetReturn(unsigned char bPicAddressI2cFormat, unsigned char Cmd);
extern int I2CTransmitCmdData(unsigned char bPicAddressI2cFormat, unsigned char Cmd, unsigned char Data, int fMode);
extern void I2CTransmitStop(void);

#endif/*__XBOX_H__*/
