package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDedicatedHostAutoRenewAttribute invokes the ecs.ModifyDedicatedHostAutoRenewAttribute API synchronously
// api document: https://help.aliyun.com/api/ecs/modifydedicatedhostautorenewattribute.html
func (client *Client) ModifyDedicatedHostAutoRenewAttribute(request *ModifyDedicatedHostAutoRenewAttributeRequest) (response *ModifyDedicatedHostAutoRenewAttributeResponse, err error) {
	response = CreateModifyDedicatedHostAutoRenewAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDedicatedHostAutoRenewAttributeWithChan invokes the ecs.ModifyDedicatedHostAutoRenewAttribute API asynchronously
// api document: https://help.aliyun.com/api/ecs/modifydedicatedhostautorenewattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDedicatedHostAutoRenewAttributeWithChan(request *ModifyDedicatedHostAutoRenewAttributeRequest) (<-chan *ModifyDedicatedHostAutoRenewAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyDedicatedHostAutoRenewAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDedicatedHostAutoRenewAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDedicatedHostAutoRenewAttributeWithCallback invokes the ecs.ModifyDedicatedHostAutoRenewAttribute API asynchronously
// api document: https://help.aliyun.com/api/ecs/modifydedicatedhostautorenewattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDedicatedHostAutoRenewAttributeWithCallback(request *ModifyDedicatedHostAutoRenewAttributeRequest, callback func(response *ModifyDedicatedHostAutoRenewAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDedicatedHostAutoRenewAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDedicatedHostAutoRenewAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDedicatedHostAutoRenewAttributeRequest is the request struct for api ModifyDedicatedHostAutoRenewAttribute
type ModifyDedicatedHostAutoRenewAttributeRequest struct {
	*requests.RpcRequest
	Duration             requests.Integer `position:"Query" name:"Duration"`
	DedicatedHostIds     string           `position:"Query" name:"DedicatedHostIds"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PeriodUnit           string           `position:"Query" name:"PeriodUnit"`
	AutoRenew            requests.Boolean `position:"Query" name:"AutoRenew"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RenewalStatus        string           `position:"Query" name:"RenewalStatus"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyDedicatedHostAutoRenewAttributeResponse is the response struct for api ModifyDedicatedHostAutoRenewAttribute
type ModifyDedicatedHostAutoRenewAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDedicatedHostAutoRenewAttributeRequest creates a request to invoke ModifyDedicatedHostAutoRenewAttribute API
func CreateModifyDedicatedHostAutoRenewAttributeRequest() (request *ModifyDedicatedHostAutoRenewAttributeRequest) {
	request = &ModifyDedicatedHostAutoRenewAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyDedicatedHostAutoRenewAttribute", "ecs", "openAPI")
	return
}

// CreateModifyDedicatedHostAutoRenewAttributeResponse creates a response to parse from ModifyDedicatedHostAutoRenewAttribute response
func CreateModifyDedicatedHostAutoRenewAttributeResponse() (response *ModifyDedicatedHostAutoRenewAttributeResponse) {
	response = &ModifyDedicatedHostAutoRenewAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
