// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <avtDefaultPlotMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose:
//   Init utility for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtDefaultPlotMetaData::Init()
{
    plotVar = "var";

    avtDefaultPlotMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose:
//   Copy utility for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtDefaultPlotMetaData::Copy(const avtDefaultPlotMetaData &obj)
{
    pluginID = obj.pluginID;
    plotVar = obj.plotVar;
    plotAttributes = obj.plotAttributes;

    avtDefaultPlotMetaData::SelectAll();
}

// Type map format string
const char *avtDefaultPlotMetaData::TypeMapFormatString = AVTDEFAULTPLOTMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtDefaultPlotMetaData::TmfsStruct = {AVTDEFAULTPLOTMETADATA_TMFS};


// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose:
//   Default constructor for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData() :
    AttributeSubject(avtDefaultPlotMetaData::TypeMapFormatString)
{
    avtDefaultPlotMetaData::Init();
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose:
//   Constructor for the derived classes of avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    avtDefaultPlotMetaData::Init();
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose:
//   Copy constructor for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData(const avtDefaultPlotMetaData &obj) :
    AttributeSubject(avtDefaultPlotMetaData::TypeMapFormatString)
{
    avtDefaultPlotMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose:
//   Copy constructor for derived classes of the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData(const avtDefaultPlotMetaData &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    avtDefaultPlotMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::~avtDefaultPlotMetaData
//
// Purpose:
//   Destructor for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtDefaultPlotMetaData::~avtDefaultPlotMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::operator =
//
// Purpose:
//   Assignment operator for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtDefaultPlotMetaData&
avtDefaultPlotMetaData::operator = (const avtDefaultPlotMetaData &obj)
{
    if (this == &obj) return *this;

    avtDefaultPlotMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::operator ==
//
// Purpose:
//   Comparison operator == for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtDefaultPlotMetaData::operator == (const avtDefaultPlotMetaData &obj) const
{
    // Create the return value
    return ((pluginID == obj.pluginID) &&
            (plotVar == obj.plotVar) &&
            (plotAttributes == obj.plotAttributes));
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::operator !=
//
// Purpose:
//   Comparison operator != for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtDefaultPlotMetaData::operator != (const avtDefaultPlotMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::TypeName
//
// Purpose:
//   Type name method for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
avtDefaultPlotMetaData::TypeName() const
{
    return "avtDefaultPlotMetaData";
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtDefaultPlotMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtDefaultPlotMetaData *tmp = (const avtDefaultPlotMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtDefaultPlotMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtDefaultPlotMetaData(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::NewInstance
//
// Purpose:
//   NewInstance method for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtDefaultPlotMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtDefaultPlotMetaData(*this);
    else
        retval = new avtDefaultPlotMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
avtDefaultPlotMetaData::SelectAll()
{
    Select(ID_pluginID,       (void *)&pluginID);
    Select(ID_plotVar,        (void *)&plotVar);
    Select(ID_plotAttributes, (void *)&plotAttributes);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtDefaultPlotMetaData::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtDefaultPlotMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_pluginID:       return "pluginID";
    case ID_plotVar:        return "plotVar";
    case ID_plotAttributes: return "plotAttributes";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
avtDefaultPlotMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_pluginID:       return FieldType_string;
    case ID_plotVar:        return FieldType_string;
    case ID_plotAttributes: return FieldType_stringVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtDefaultPlotMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_pluginID:       return "string";
    case ID_plotVar:        return "string";
    case ID_plotAttributes: return "stringVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtDefaultPlotMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtDefaultPlotMetaData &obj = *((const avtDefaultPlotMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_pluginID:
        {  // new scope
        retval = (pluginID == obj.pluginID);
        }
        break;
    case ID_plotVar:
        {  // new scope
        retval = (plotVar == obj.plotVar);
        }
        break;
    case ID_plotAttributes:
        {  // new scope
        retval = (plotAttributes == obj.plotAttributes);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtDefaultPlotMetaData constructor
//
//  Arguments:
//      p        The name of the plugin.
//      v        The name of the variable the plot is applied on.
//
//  Programmer:  Walter Herrera Jimenez
//  Creation:    September 04, 2003
//
//  Modifications:
//
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData(const std::string &p,
    const std::string &v) : AttributeSubject(avtDefaultPlotMetaData::TypeMapFormatString)
{
    // Initialize all
    *this = avtDefaultPlotMetaData();

    // Override members
    pluginID      = p;
    plotVar       = v;
}

// ****************************************************************************
//  Method: avtDefaultPlotMetaData::AddAttribute
//
//  Arguments:
//      attr  : the attribute to be added
//
//  Programmer: Walter Herrera Jimenez
//  Creation:   September 04, 2003
//
//  Modifications:
//
// ****************************************************************************

void
avtDefaultPlotMetaData::AddAttribute(const std::string& attr)
{
    plotAttributes.push_back(attr);
}

// ****************************************************************************
//  Method: avtDefaultPlotMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Walter Herrera Jimenez
//  Creation:    September 04, 2003
//
//  Modifications:
//
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtDefaultPlotMetaData::Print(ostream &out, int indent) const
{
    Indent(out, indent);
    out << "PluginID = " << pluginID.c_str() << endl;

    Indent(out, indent);
    out << "Plot Variable = " << plotVar.c_str() << endl;

    out << "Plot Attributes:" << endl;
    for(size_t i = 0; i < plotAttributes.size(); ++i)
      out << "\t" << plotAttributes[i].c_str() << endl;
    out << endl;
}

