/**********************************************************************
 * $test_vpiworkarea example -- PLI application using VPI routines
 *
 * C source to test the PLIbook_set_vpiworkarea() and the
 * PLIbook_get_vpiworkarea() PLI applications. The workarea
 * applications are contained in the file vpi_utilities.c.
 *
 * Usage: $test_vpiworkarea(<integer_value>);
 *
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

#include <stdlib.h>    /* ANSI C standard library */
#include <stdio.h>     /* ANSI C standard input/output library */
#include <string.h>    /* ANSI C standard string library */
#include <malloc.h>    /* ANSI C standard memory allocation library */
#include "vpi_user.h"  /* IEEE 1364 PLI VPI routine library  */
#include "veriuser.h"  /* IEEE 1364 PLI TF routine library    
                          (using TF routines for simulation control) */

/* prototypes of routines in this PLI application */
int PLIbook_TestWorkArea_calltf(), PLIbook_TestWorkArea_compiletf();


/* include PLIbook VPI utility routine examples */
#include "vpi_utilities.c"


/**********************************************************************
 * VPI Registration Data
 *********************************************************************/
void PLIbook_TestWorkArea_register()
{
  s_vpi_systf_data tf_data;
  tf_data.type      = vpiSysTask;
  tf_data.tfname    = "$test_vpiworkarea";
  tf_data.calltf    = PLIbook_TestWorkArea_calltf; 
  tf_data.compiletf = PLIbook_TestWorkArea_compiletf; 
  tf_data.sizetf    = NULL;
  tf_data.user_data = NULL;
  vpi_register_systf(&tf_data);

}
/**********************************************************************
 * compiletf routine
 *********************************************************************/
int PLIbook_TestWorkArea_compiletf()
{
  vpiHandle  systf_h;
  int        foo;

  systf_h = vpi_handle(vpiSysTfCall,NULL);

  /* save something in the work area */
  foo = PLIbook_getarg_intval_vpi(1);
  PLIbook_set_vpiworkarea(systf_h, (char *)foo);

  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_TestWorkArea_calltf()
{
  vpiHandle  systf_h = vpi_handle(vpiSysTfCall,NULL);
  int        bar;
  
  /* retrieve data from the workarea */
  bar = (int)PLIbook_get_vpiworkarea(systf_h);
  vpi_printf("In calltf, foo = %d\n\n", bar);

  /* Modify value in workarea */
  PLIbook_set_vpiworkarea(systf_h, (char *)bar+1);
  return(0);
}

/*********************************************************************/

