
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IVtkVTK_ShapeData.hxx>
#include <IVtkVTK_View.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <vtkRenderer.h>
#include "vtk_pybind.h" 

// Module definiiton
void register_IVtkVTK(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("IVtkVTK"));
py::object klass;

//Python trampoline classes

// classes

    // Class IVtkVTK_ShapeData from ./opencascade/IVtkVTK_ShapeData.hxx
    klass = m.attr("IVtkVTK_ShapeData");


    // nested enums

    static_cast<py::class_<IVtkVTK_ShapeData ,opencascade::handle<IVtkVTK_ShapeData>  , IVtk_IShapeData >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("InsertPoint",
             (IVtk_PointId (IVtkVTK_ShapeData::*)( const gp_Pnt & ,  const NCollection_Vec3<float> &  ) ) static_cast<IVtk_PointId (IVtkVTK_ShapeData::*)( const gp_Pnt & ,  const NCollection_Vec3<float> &  ) >(&IVtkVTK_ShapeData::InsertPoint),
             R"#(Insert a coordinate)#"  , py::arg("thePnt"),  py::arg("theNorm")
          )
        .def("InsertVertex",
             (void (IVtkVTK_ShapeData::*)( const IVtk_IdType ,  const IVtk_PointId ,  const IVtk_MeshType  ) ) static_cast<void (IVtkVTK_ShapeData::*)( const IVtk_IdType ,  const IVtk_PointId ,  const IVtk_MeshType  ) >(&IVtkVTK_ShapeData::InsertVertex),
             R"#(Insert a vertex.)#"  , py::arg("theShapeID"),  py::arg("thePointId"),  py::arg("theMeshType")
          )
        .def("InsertLine",
             (void (IVtkVTK_ShapeData::*)( const IVtk_IdType ,  const IVtk_PointId ,  const IVtk_PointId ,  const IVtk_MeshType  ) ) static_cast<void (IVtkVTK_ShapeData::*)( const IVtk_IdType ,  const IVtk_PointId ,  const IVtk_PointId ,  const IVtk_MeshType  ) >(&IVtkVTK_ShapeData::InsertLine),
             R"#(Insert a line.)#"  , py::arg("theShapeID"),  py::arg("thePointId1"),  py::arg("thePointId2"),  py::arg("theMeshType")
          )
        .def("InsertLine",
             (void (IVtkVTK_ShapeData::*)( const IVtk_IdType ,   const NCollection_List<IVtk_PointId> * ,  const IVtk_MeshType  ) ) static_cast<void (IVtkVTK_ShapeData::*)( const IVtk_IdType ,   const NCollection_List<IVtk_PointId> * ,  const IVtk_MeshType  ) >(&IVtkVTK_ShapeData::InsertLine),
             R"#(Insert a poly-line.)#"  , py::arg("theShapeID"),  py::arg("thePointIds"),  py::arg("theMeshType")
          )
        .def("InsertTriangle",
             (void (IVtkVTK_ShapeData::*)( const IVtk_IdType ,  const IVtk_PointId ,  const IVtk_PointId ,  const IVtk_PointId ,  const IVtk_MeshType  ) ) static_cast<void (IVtkVTK_ShapeData::*)( const IVtk_IdType ,  const IVtk_PointId ,  const IVtk_PointId ,  const IVtk_PointId ,  const IVtk_MeshType  ) >(&IVtkVTK_ShapeData::InsertTriangle),
             R"#(Insert a triangle)#"  , py::arg("theShapeID"),  py::arg("thePointId1"),  py::arg("thePointId2"),  py::arg("thePointId3"),  py::arg("theMeshType")
          )
        .def("getVtkPolyData",
             (vtkPolyData * (IVtkVTK_ShapeData::*)() const) static_cast<vtkPolyData * (IVtkVTK_ShapeData::*)() const>(&IVtkVTK_ShapeData::getVtkPolyData),
             R"#(Get VTK PolyData.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ARRNAME_SUBSHAPE_IDS_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&IVtkVTK_ShapeData::ARRNAME_SUBSHAPE_IDS),
                    R"#(None)#" 
          )
        .def_static("ARRNAME_MESH_TYPES_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&IVtkVTK_ShapeData::ARRNAME_MESH_TYPES),
                    R"#(None)#" 
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&IVtkVTK_ShapeData::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&IVtkVTK_ShapeData::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (IVtkVTK_ShapeData::*)() const) static_cast<const opencascade::handle<Standard_Type> & (IVtkVTK_ShapeData::*)() const>(&IVtkVTK_ShapeData::DynamicType),
             R"#(None)#"
             
         )
;

    // Class IVtkVTK_View from ./opencascade/IVtkVTK_View.hxx
    klass = m.attr("IVtkVTK_View");


    // nested enums

    static_cast<py::class_<IVtkVTK_View ,opencascade::handle<IVtkVTK_View>  , IVtk_IView >>(klass)
    // constructors
        .def(py::init< vtkRenderer * >()  , py::arg("theRenderer") )
    // custom constructors
    // methods
        .def("IsPerspective",
             (bool (IVtkVTK_View::*)() const) static_cast<bool (IVtkVTK_View::*)() const>(&IVtkVTK_View::IsPerspective),
             R"#(Returns true if this is a perspective view, and false otherwise.)#" 
          )
        .def("GetDistance",
             (double (IVtkVTK_View::*)() const) static_cast<double (IVtkVTK_View::*)() const>(&IVtkVTK_View::GetDistance),
             R"#(Returns The focal distance of the view)#" 
          )
        .def("GetEyePosition",
             (void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const>(&IVtkVTK_View::GetEyePosition),
             R"#(Returns The world coordinates of the camera position)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("GetPosition",
             (void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const>(&IVtkVTK_View::GetPosition),
             R"#(Returns The world coordinates of the view position)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("GetViewUp",
             (void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const>(&IVtkVTK_View::GetViewUp),
             R"#(Returns The "view up" direction of the view)#"  , py::arg("theDx"),  py::arg("theDy"),  py::arg("theDz")
          )
        .def("GetDirectionOfProjection",
             (void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const>(&IVtkVTK_View::GetDirectionOfProjection),
             R"#(Returns The projection direction vector of this view)#"  , py::arg("theDx"),  py::arg("theDy"),  py::arg("theDz")
          )
        .def("GetScale",
             (void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const) static_cast<void (IVtkVTK_View::*)( double & ,  double & ,  double &  ) const>(&IVtkVTK_View::GetScale),
             R"#(Returns Three doubles containing scale components of the view transformation)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("GetParallelScale",
             (double (IVtkVTK_View::*)() const) static_cast<double (IVtkVTK_View::*)() const>(&IVtkVTK_View::GetParallelScale),
             R"#(Returns The current view's zoom factor (for parallel projection))#" 
          )
        .def("GetViewAngle",
             (double (IVtkVTK_View::*)() const) static_cast<double (IVtkVTK_View::*)() const>(&IVtkVTK_View::GetViewAngle),
             R"#(Returns The current view angle (for perspective projection))#" 
          )
        .def("GetClippingRange",
             (void (IVtkVTK_View::*)( double & ,  double &  ) const) static_cast<void (IVtkVTK_View::*)( double & ,  double &  ) const>(&IVtkVTK_View::GetClippingRange),
             R"#(Returns The location of the near and far clipping planes along the direction of projection)#"  , py::arg("theZNear"),  py::arg("theZFar")
          )
        .def("GetAspectRatio",
             (double (IVtkVTK_View::*)() const) static_cast<double (IVtkVTK_View::*)() const>(&IVtkVTK_View::GetAspectRatio),
             R"#(Returns The current view the aspect ratio)#" 
          )
        .def("GetViewCenter",
             (void (IVtkVTK_View::*)( double & ,  double &  ) const) static_cast<void (IVtkVTK_View::*)( double & ,  double &  ) const>(&IVtkVTK_View::GetViewCenter),
             R"#(Returns Two doubles containing the display coordinates of the view window center)#"  , py::arg("theX"),  py::arg("theY")
          )
        .def("GetWindowSize",
             (void (IVtkVTK_View::*)( int & ,  int &  ) const) static_cast<void (IVtkVTK_View::*)( int & ,  int &  ) const>(&IVtkVTK_View::GetWindowSize),
             R"#(Gets window size in screen coordinates in pixels)#"  , py::arg("theX"),  py::arg("theY")
          )
        .def("DisplayToWorld",
             (bool (IVtkVTK_View::*)( const gp_XY & ,  gp_XYZ &  ) const) static_cast<bool (IVtkVTK_View::*)( const gp_XY & ,  gp_XYZ &  ) const>(&IVtkVTK_View::DisplayToWorld),
             R"#(Converts 3D display coordinates into 3D world coordinates.)#"  , py::arg("theDisplayPnt"),  py::arg("theWorldPnt")
          )
    // methods using call by reference i.s.o. return
        .def("GetCamera",
             []( IVtkVTK_View &self , NCollection_Mat4<Standard_Real> & theProj,NCollection_Mat4<Standard_Real> & theOrient ){
                 Standard_Boolean  theIsOrtho;

                 self.GetCamera(theProj,theOrient,theIsOrtho);
                 
                 return std::make_tuple(theIsOrtho); },
             R"#(Gets camera projection and orientation matrices)#"  , py::arg("theProj"),  py::arg("theOrient")
          )
        .def("GetViewport",
             []( IVtkVTK_View &self   ){
                 Standard_Real  theX;
                Standard_Real  theY;
                Standard_Real  theWidth;
                Standard_Real  theHeight;

                 self.GetViewport(theX,theY,theWidth,theHeight);
                 
                 return std::make_tuple(theX,theY,theWidth,theHeight); },
             R"#(Gets viewport coordinates)#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&IVtkVTK_View::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&IVtkVTK_View::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (IVtkVTK_View::*)() const) static_cast<const opencascade::handle<Standard_Type> & (IVtkVTK_View::*)() const>(&IVtkVTK_View::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/IVtkVTK_ShapeData.hxx
// ./opencascade/IVtkVTK_View.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
