# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class TaskStatisticsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, task_sid):
        """
        Initialize the TaskStatisticsList

        :param Version version: Version that contains the resource
        :param assistant_sid: The unique ID of the parent Assistant.
        :param task_sid: The unique ID of the Task associated with this Field.

        :returns: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsList
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsList
        """
        super(TaskStatisticsList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'task_sid': task_sid, }

    def get(self):
        """
        Constructs a TaskStatisticsContext

        :returns: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsContext
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsContext
        """
        return TaskStatisticsContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def __call__(self):
        """
        Constructs a TaskStatisticsContext

        :returns: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsContext
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsContext
        """
        return TaskStatisticsContext(
            self._version,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.Understand.TaskStatisticsList>'


class TaskStatisticsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the TaskStatisticsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The unique ID of the parent Assistant.
        :param task_sid: The unique ID of the Task associated with this Field.

        :returns: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsPage
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsPage
        """
        super(TaskStatisticsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of TaskStatisticsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsInstance
        """
        return TaskStatisticsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.Understand.TaskStatisticsPage>'


class TaskStatisticsContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, task_sid):
        """
        Initialize the TaskStatisticsContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The unique ID of the parent Assistant.
        :param task_sid: The unique ID of the Task associated with this Field.

        :returns: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsContext
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsContext
        """
        super(TaskStatisticsContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'task_sid': task_sid, }
        self._uri = '/Assistants/{assistant_sid}/Tasks/{task_sid}/Statistics'.format(**self._solution)

    def fetch(self):
        """
        Fetch the TaskStatisticsInstance

        :returns: The fetched TaskStatisticsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return TaskStatisticsInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            task_sid=self._solution['task_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.Understand.TaskStatisticsContext {}>'.format(context)


class TaskStatisticsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, assistant_sid, task_sid):
        """
        Initialize the TaskStatisticsInstance

        :returns: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsInstance
        """
        super(TaskStatisticsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'assistant_sid': payload.get('assistant_sid'),
            'task_sid': payload.get('task_sid'),
            'samples_count': deserialize.integer(payload.get('samples_count')),
            'fields_count': deserialize.integer(payload.get('fields_count')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'assistant_sid': assistant_sid, 'task_sid': task_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: TaskStatisticsContext for this TaskStatisticsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsContext
        """
        if self._context is None:
            self._context = TaskStatisticsContext(
                self._version,
                assistant_sid=self._solution['assistant_sid'],
                task_sid=self._solution['task_sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The unique ID of the Account that created this Field.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assistant_sid(self):
        """
        :returns: The unique ID of the parent Assistant.
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def task_sid(self):
        """
        :returns: The unique ID of the Task associated with this Field.
        :rtype: unicode
        """
        return self._properties['task_sid']

    @property
    def samples_count(self):
        """
        :returns: The total number of Samples associated with this Task.
        :rtype: unicode
        """
        return self._properties['samples_count']

    @property
    def fields_count(self):
        """
        :returns: The total number of Fields associated with this Task.
        :rtype: unicode
        """
        return self._properties['fields_count']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the TaskStatisticsInstance

        :returns: The fetched TaskStatisticsInstance
        :rtype: twilio.rest.preview.understand.assistant.task.task_statistics.TaskStatisticsInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.Understand.TaskStatisticsInstance {}>'.format(context)
