% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorlegend.r
\name{colorlegend}
\alias{colorlegend}
\title{Color legend}
\usage{
colorlegend(
  col,
  pal = palette(),
  log = FALSE,
  posx = c(0.9, 0.93),
  posy = c(0.05, 0.9),
  main = NULL,
  cex_main = par("cex.sub"),
  cex_axis = par("cex.axis"),
  col_main = par("col.sub"),
  col_lab = par("col.lab"),
  steps = 5,
  steps_color = 100,
  digit = 2,
  left = FALSE,
  ...,
  cex.main = NULL,
  cex.axis = NULL,
  col.main = NULL,
  col.lab = NULL
)
}
\arguments{
\item{col}{Vector of factor, integer, or double used to determine the ticks.}

\item{pal}{If \code{col} is double, pal is used as a continuous palette, else as categorical one}

\item{log}{Use logarithmic scale?}

\item{posx}{Left and right borders of the color bar relative to plot area (Vector of length 2; 0-1)}

\item{posy}{Bottom and top borders of color bar relative to plot area (Vector of length 2; 0-1)}

\item{main}{Legend title}

\item{cex_main}{Size of legend title font (default: subtitle font size \code{\link{par}('cex.sub')})}

\item{cex_axis}{Size of ticks/category labels (default: axis font size \code{\link{par}('cex.axis')})}

\item{col_main}{Color of legend title (default: subtitle color \code{\link{par}('col.sub')})}

\item{col_lab}{Color of tick or category labels (default: axis color \code{\link{par}('col.lab')})}

\item{steps}{Number of labels in case of a continuous axis. If 0 or FALSE, draw no ticks}

\item{steps_color}{Number of gradient samples in case of continuous axis}

\item{digit}{Number of digits for continuous axis labels}

\item{left}{logical. If TRUE, invert posx}

\item{...}{Additional parameters for the \link[graphics]{text} call used for labels}

\item{cex.main, cex.axis, col.main, col.lab}{For compatibility with \code{\link{par}}}
}
\value{
This function is called for the side effect of adding a colorbar to a plot and returns nothing/NULL.
}
\description{
Creates a color legend for a vector used to color a plot. It will use the current \code{\link[grDevices]{palette}()} or the specified \code{pal} as reference.
}
\details{
When passed a factor or integer vector, it will create a discrete legend, whereas a double vector will result in a continuous bar.
}
\examples{
color_data <- 1:6
par(mar = par('mar') + c(0, 0, 0, 3))
plot(sample(6), col = color_data)
colorlegend(color_data)

}
