# Generated by tests/testthat/generate_tests_helper_script.R
# do not edit by hand


# Make a matrix with different features
mat <- matrix(rnorm(16 * 6), nrow = 16, ncol = 6, dimnames = list(letters[1:16], LETTERS[1:6]))
mat[1,1] <- 0
mat[2,3] <- NA
mat[3,3] <- -Inf
mat[5,4] <- NaN
mat[5,1] <- Inf
mat[6,2] <- 0
mat[6,5] <- 0


.check_formals <- function(fnc_name)
{
    if (fnc_name == "rowRanges")
        return(invisible(NULL))

    matrixStats_fun <- eval(parse(text=paste0("matrixStats::", fnc_name)))
    MatrixGenerics_fun <- eval(parse(text=paste0("MatrixGenerics::", fnc_name)))
    MatrixGenerics_matrixStats_method <- eval(parse(text=paste0("MatrixGenerics:::.matrixStats_", fnc_name)))

    matrixStats_formals <- formals(matrixStats_fun)
    MatrixGenerics_matrixStats_method_formals <- formals(MatrixGenerics_matrixStats_method)
    if (fnc_name %in% c("rowMeans2", "colMeans2", "rowVars", "colVars", "rowSds", "colSds"))
        matrixStats_formals$refine <- NULL
    expect_identical(MatrixGenerics_matrixStats_method_formals, matrixStats_formals)

    MatrixGenerics_formals <- formals(MatrixGenerics_fun)
    MatrixGenerics_matrixStats_method_formals <- formals(MatrixGenerics_matrixStats_method)
    MatrixGenerics_matrixStats_method_formals$dim. <- NULL
    if (fnc_name %in% c("rowProds", "colProds"))
        MatrixGenerics_matrixStats_method_formals$method <- NULL
    if (fnc_name %in% c("rowRanks", "colRanks"))
        MatrixGenerics_matrixStats_method_formals$ties.method <- MatrixGenerics_formals$ties.method <- NULL
    if (fnc_name == "colRanks")
        MatrixGenerics_matrixStats_method_formals$preserveShape <- NULL
    expect_identical(MatrixGenerics_matrixStats_method_formals, MatrixGenerics_formals)
    invisible(NULL)
}


test_that("colAlls works", {

	.check_formals("colAlls")

	mg_res_def_1 <- colAlls(x = mat)
	ms_res_def_1 <- matrixStats::colAlls(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colAlls(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colAlls(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colAlls(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colAlls(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colAlls(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_3 <- matrixStats::colAlls(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colAnyNAs works", {

	.check_formals("colAnyNAs")

	mg_res_def_1 <- colAnyNAs(x = mat)
	ms_res_def_1 <- matrixStats::colAnyNAs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colAnyNAs(x = mat, rows = NULL, cols = NULL, useNames = TRUE)
	ms_res_1 <- matrixStats::colAnyNAs(x = mat, rows = NULL, cols = NULL, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colAnyNAs(x = mat, rows = 1:3, cols = 2, useNames = FALSE)
	ms_res_2 <- matrixStats::colAnyNAs(x = mat, rows = 1:3, cols = 2, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colAnys works", {

	.check_formals("colAnys")

	mg_res_def_1 <- colAnys(x = mat)
	ms_res_def_1 <- matrixStats::colAnys(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colAnys(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colAnys(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colAnys(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colAnys(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colAnys(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_3 <- matrixStats::colAnys(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colAvgsPerRowSet works", {

	.check_formals("colAvgsPerRowSet")

	S <- matrix(1:nrow(mat), ncol = 2)
	mg_res_def_1 <- colAvgsPerRowSet(X = mat, S = S, FUN = colMeans)
	ms_res_def_1 <- matrixStats::colAvgsPerRowSet(X = mat, S = S, FUN = colMeans)
	expect_equal(mg_res_def_1, ms_res_def_1)
	mg_res_def_2 <- colAvgsPerRowSet(X = mat, S = S, FUN = colVars)
	ms_res_def_2 <- matrixStats::colAvgsPerRowSet(X = mat, S = S, FUN = colVars)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- colAvgsPerRowSet(X = mat, W = NULL, cols = NULL, S = S, FUN = colMeans, na.rm = TRUE, tFUN = FALSE)
	ms_res_1 <- matrixStats::colAvgsPerRowSet(X = mat, W = NULL, cols = NULL, S = S, FUN = colMeans, na.rm = TRUE, tFUN = FALSE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colAvgsPerRowSet(X = mat, W = NULL, cols = 1:2, S = S, FUN = colVars, na.rm = FALSE, tFUN = FALSE)
	ms_res_2 <- matrixStats::colAvgsPerRowSet(X = mat, W = NULL, cols = 1:2, S = S, FUN = colVars, na.rm = FALSE, tFUN = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCollapse works", {

	.check_formals("colCollapse")

	mg_res_def_1 <- colCollapse(x = mat, idxs = 1)
	ms_res_def_1 <- matrixStats::colCollapse(x = mat, idxs = 1)
	expect_equal(mg_res_def_1, ms_res_def_1)
	mg_res_def_2 <- colCollapse(x = mat, idxs = 2:3)
	ms_res_def_2 <- matrixStats::colCollapse(x = mat, idxs = 2:3)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- colCollapse(x = mat, idxs = 1, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colCollapse(x = mat, idxs = 1, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCollapse(x = mat, idxs = 2:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colCollapse(x = mat, idxs = 2:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCounts works", {

	.check_formals("colCounts")

	mg_res_def_1 <- colCounts(x = mat)
	ms_res_def_1 <- matrixStats::colCounts(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCounts(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colCounts(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCounts(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colCounts(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colCounts(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_3 <- matrixStats::colCounts(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colCummaxs works", {

	.check_formals("colCummaxs")

	mg_res_def_1 <- colCummaxs(x = mat)
	ms_res_def_1 <- matrixStats::colCummaxs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCummaxs(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colCummaxs(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCummaxs(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colCummaxs(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCummins works", {

	.check_formals("colCummins")

	mg_res_def_1 <- colCummins(x = mat)
	ms_res_def_1 <- matrixStats::colCummins(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCummins(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colCummins(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCummins(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colCummins(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCumprods works", {

	.check_formals("colCumprods")

	mg_res_def_1 <- colCumprods(x = mat)
	ms_res_def_1 <- matrixStats::colCumprods(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCumprods(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colCumprods(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCumprods(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colCumprods(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCumsums works", {

	.check_formals("colCumsums")

	mg_res_def_1 <- colCumsums(x = mat)
	ms_res_def_1 <- matrixStats::colCumsums(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCumsums(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colCumsums(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCumsums(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colCumsums(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colDiffs works", {

	.check_formals("colDiffs")

	mg_res_def_1 <- colDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colDiffs(x = mat, rows = NULL, cols = NULL, lag = 1, differences = 1, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colDiffs(x = mat, rows = NULL, cols = NULL, lag = 1, differences = 1, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colDiffs(x = mat, rows = 1:3, cols = 2, lag = 3, differences = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colDiffs(x = mat, rows = 1:3, cols = 2, lag = 3, differences = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colIQRDiffs works", {

	.check_formals("colIQRDiffs")

	mg_res_def_1 <- colIQRDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colIQRDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::colIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colIQRDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	ms_res_2 <- matrixStats::colIQRDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	ms_res_3 <- matrixStats::colIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colIQRs works", {

	.check_formals("colIQRs")

	mg_res_def_1 <- colIQRs(x = mat)
	ms_res_def_1 <- matrixStats::colIQRs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colIQRs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::colIQRs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colIQRs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::colIQRs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colLogSumExps works", {

	.check_formals("colLogSumExps")

	mg_res_def_1 <- colLogSumExps(lx = mat)
	ms_res_def_1 <- matrixStats::colLogSumExps(lx = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colLogSumExps(lx = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colLogSumExps(lx = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colLogSumExps(lx = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colLogSumExps(lx = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMadDiffs works", {

	.check_formals("colMadDiffs")

	mg_res_def_1 <- colMadDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colMadDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::colMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMadDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	ms_res_2 <- matrixStats::colMadDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	ms_res_3 <- matrixStats::colMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colMads works", {

	.check_formals("colMads")

	mg_res_def_1 <- colMads(x = mat)
	ms_res_def_1 <- matrixStats::colMads(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMads(x = mat, rows = NULL, cols = NULL, center = colMeans2(mat, na.rm=TRUE), constant = 1.4826, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colMads(x = mat, rows = NULL, cols = NULL, center = colMeans2(mat, na.rm=TRUE), constant = 1.4826, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMads(x = mat, rows = 1:3, cols = 2, center = NULL, constant = 5, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colMads(x = mat, rows = 1:3, cols = 2, center = NULL, constant = 5, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMaxs works", {

	.check_formals("colMaxs")

	mg_res_def_1 <- colMaxs(x = mat)
	ms_res_def_1 <- matrixStats::colMaxs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMaxs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colMaxs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMaxs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colMaxs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMeans2 works", {

	.check_formals("colMeans2")

	mg_res_def_1 <- colMeans2(x = mat)
	ms_res_def_1 <- matrixStats::colMeans2(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMeans2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colMeans2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMeans2(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colMeans2(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMedians works", {

	.check_formals("colMedians")

	mg_res_def_1 <- colMedians(x = mat)
	ms_res_def_1 <- matrixStats::colMedians(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMedians(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colMedians(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMedians(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colMedians(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMins works", {

	.check_formals("colMins")

	mg_res_def_1 <- colMins(x = mat)
	ms_res_def_1 <- matrixStats::colMins(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMins(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colMins(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMins(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colMins(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colOrderStats works", {

	.check_formals("colOrderStats")

	mat[is.na(mat)] <- 4.1
	mg_res_def_1 <- colOrderStats(x = mat, which = 2)
	ms_res_def_1 <- matrixStats::colOrderStats(x = mat, which = 2)
	expect_equal(mg_res_def_1, ms_res_def_1)
	mg_res_def_2 <- colOrderStats(x = mat, which = 1)
	ms_res_def_2 <- matrixStats::colOrderStats(x = mat, which = 1)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- colOrderStats(x = mat, rows = NULL, cols = NULL, which = 2, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colOrderStats(x = mat, rows = NULL, cols = NULL, which = 2, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colOrderStats(x = mat, rows = 1:3, cols = 2, which = 1, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colOrderStats(x = mat, rows = 1:3, cols = 2, which = 1, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colProds works", {

	.check_formals("colProds")

	mg_res_def_1 <- colProds(x = mat)
	ms_res_def_1 <- matrixStats::colProds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colProds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, method = 'direct', useNames = TRUE)
	ms_res_1 <- matrixStats::colProds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, method = 'direct', useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colProds(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, method = 'expSumLog', useNames = FALSE)
	ms_res_2 <- matrixStats::colProds(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, method = 'expSumLog', useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colQuantiles works", {

	.check_formals("colQuantiles")

	mg_res_def_1 <- colQuantiles(x = mat)
	ms_res_def_1 <- matrixStats::colQuantiles(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colQuantiles(x = mat, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = TRUE, type = 7, digits = 7, useNames = TRUE, drop = TRUE)
	ms_res_1 <- matrixStats::colQuantiles(x = mat, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = TRUE, type = 7, digits = 7, useNames = TRUE, drop = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colQuantiles(x = mat, rows = 1:3, cols = 2, probs = 0.1, na.rm = FALSE, type = 3, digits = 7, useNames = FALSE, drop = FALSE)
	ms_res_2 <- matrixStats::colQuantiles(x = mat, rows = 1:3, cols = 2, probs = 0.1, na.rm = FALSE, type = 3, digits = 7, useNames = FALSE, drop = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colRanges works", {

	.check_formals("colRanges")

	mg_res_def_1 <- colRanges(x = mat)
	ms_res_def_1 <- matrixStats::colRanges(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colRanges(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colRanges(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colRanges(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colRanges(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colRanks works", {

	.check_formals("colRanks")

	mg_res_def_1 <- colRanks(x = mat)
	ms_res_def_1 <- matrixStats::colRanks(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'max', dim. = dim(mat), preserveShape = FALSE, useNames = TRUE)
	ms_res_1 <- matrixStats::colRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'max', dim. = dim(mat), preserveShape = FALSE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colRanks(x = mat, rows = 1:3, cols = 2, ties.method = 'first', dim. = c(12L, 8L), preserveShape = TRUE, useNames = FALSE)
	ms_res_2 <- matrixStats::colRanks(x = mat, rows = 1:3, cols = 2, ties.method = 'first', dim. = c(12L, 8L), preserveShape = TRUE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'dense', dim. = dim(mat), preserveShape = FALSE, useNames = TRUE)
	ms_res_3 <- matrixStats::colRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'dense', dim. = dim(mat), preserveShape = FALSE, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colSdDiffs works", {

	.check_formals("colSdDiffs")

	mg_res_def_1 <- colSdDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colSdDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::colSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colSdDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	ms_res_2 <- matrixStats::colSdDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	ms_res_3 <- matrixStats::colSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colSds works", {

	.check_formals("colSds")

	mg_res_def_1 <- colSds(x = mat)
	ms_res_def_1 <- matrixStats::colSds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colSds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , center = colMeans2(mat, na.rm=TRUE), dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colSds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , center = colMeans2(mat, na.rm=TRUE), dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colSds(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , center = NULL, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colSds(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , center = NULL, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colSums2 works", {

	.check_formals("colSums2")

	mg_res_def_1 <- colSums2(x = mat)
	ms_res_def_1 <- matrixStats::colSums2(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colSums2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colSums2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colSums2(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colSums2(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colTabulates works", {

	.check_formals("colTabulates")

	mat <- array(suppressWarnings(as.integer(mat)), dim(mat))
	mg_res_def_1 <- colTabulates(x = mat)
	ms_res_def_1 <- matrixStats::colTabulates(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colTabulates(x = mat, rows = NULL, cols = NULL, values = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::colTabulates(x = mat, rows = NULL, cols = NULL, values = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colTabulates(x = mat, rows = 1:3, cols = 2, values = c(0, 1), useNames = FALSE)
	ms_res_2 <- matrixStats::colTabulates(x = mat, rows = 1:3, cols = 2, values = c(0, 1), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colVarDiffs works", {

	.check_formals("colVarDiffs")

	mg_res_def_1 <- colVarDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colVarDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::colVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colVarDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	ms_res_2 <- matrixStats::colVarDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	ms_res_3 <- matrixStats::colVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colVars works", {

	.check_formals("colVars")

	mg_res_def_1 <- colVars(x = mat)
	ms_res_def_1 <- matrixStats::colVars(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colVars(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , center = colMeans2(mat, na.rm=TRUE), dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::colVars(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , center = colMeans2(mat, na.rm=TRUE), dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colVars(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , center = NULL, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::colVars(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , center = NULL, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedMads works", {

	.check_formals("colWeightedMads")

	mg_res_def_1 <- colWeightedMads(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedMads(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedMads(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, constant = 1.4826, center = colMeans2(mat, na.rm=TRUE), useNames = TRUE)
	ms_res_1 <- matrixStats::colWeightedMads(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, constant = 1.4826, center = colMeans2(mat, na.rm=TRUE), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedMads(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, constant = 5, center = rep(6, ncol(mat)), useNames = FALSE)
	ms_res_2 <- matrixStats::colWeightedMads(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, constant = 5, center = rep(6, ncol(mat)), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedMeans works", {

	.check_formals("colWeightedMeans")

	mg_res_def_1 <- colWeightedMeans(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedMeans(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedMeans(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::colWeightedMeans(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedMeans(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::colWeightedMeans(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedMedians works", {

	.check_formals("colWeightedMedians")

	mg_res_def_1 <- colWeightedMedians(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedMedians(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedMedians(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::colWeightedMedians(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedMedians(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::colWeightedMedians(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedSds works", {

	.check_formals("colWeightedSds")

	mg_res_def_1 <- colWeightedSds(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedSds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedSds(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::colWeightedSds(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedSds(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::colWeightedSds(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedVars works", {

	.check_formals("colWeightedVars")

	mg_res_def_1 <- colWeightedVars(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedVars(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedVars(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::colWeightedVars(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedVars(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::colWeightedVars(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowAlls works", {

	.check_formals("rowAlls")

	mg_res_def_1 <- rowAlls(x = mat)
	ms_res_def_1 <- matrixStats::rowAlls(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowAlls(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowAlls(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowAlls(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowAlls(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowAlls(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_3 <- matrixStats::rowAlls(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowAnyNAs works", {

	.check_formals("rowAnyNAs")

	mg_res_def_1 <- rowAnyNAs(x = mat)
	ms_res_def_1 <- matrixStats::rowAnyNAs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowAnyNAs(x = mat, rows = NULL, cols = NULL, useNames = TRUE)
	ms_res_1 <- matrixStats::rowAnyNAs(x = mat, rows = NULL, cols = NULL, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowAnyNAs(x = mat, rows = 1:3, cols = 2, useNames = FALSE)
	ms_res_2 <- matrixStats::rowAnyNAs(x = mat, rows = 1:3, cols = 2, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowAnys works", {

	.check_formals("rowAnys")

	mg_res_def_1 <- rowAnys(x = mat)
	ms_res_def_1 <- matrixStats::rowAnys(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowAnys(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowAnys(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowAnys(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowAnys(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowAnys(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_3 <- matrixStats::rowAnys(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowAvgsPerColSet works", {

	.check_formals("rowAvgsPerColSet")

	S <- matrix(1:ncol(mat), ncol = 2)
	mg_res_def_1 <- rowAvgsPerColSet(X = mat, S = S, FUN = rowMeans)
	ms_res_def_1 <- matrixStats::rowAvgsPerColSet(X = mat, S = S, FUN = rowMeans)
	expect_equal(mg_res_def_1, ms_res_def_1)
	mg_res_def_2 <- rowAvgsPerColSet(X = mat, S = S, FUN = rowVars)
	ms_res_def_2 <- matrixStats::rowAvgsPerColSet(X = mat, S = S, FUN = rowVars)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- rowAvgsPerColSet(X = mat, W = NULL, rows = NULL, S = S, FUN = rowMeans, na.rm = TRUE, tFUN = FALSE)
	ms_res_1 <- matrixStats::rowAvgsPerColSet(X = mat, W = NULL, rows = NULL, S = S, FUN = rowMeans, na.rm = TRUE, tFUN = FALSE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowAvgsPerColSet(X = mat, W = NULL, rows = 1:3, S = S, FUN = rowVars, na.rm = FALSE, tFUN = FALSE)
	ms_res_2 <- matrixStats::rowAvgsPerColSet(X = mat, W = NULL, rows = 1:3, S = S, FUN = rowVars, na.rm = FALSE, tFUN = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCollapse works", {

	.check_formals("rowCollapse")

	mg_res_def_1 <- rowCollapse(x = mat, idxs = 1)
	ms_res_def_1 <- matrixStats::rowCollapse(x = mat, idxs = 1)
	expect_equal(mg_res_def_1, ms_res_def_1)
	mg_res_def_2 <- rowCollapse(x = mat, idxs = 2:3)
	ms_res_def_2 <- matrixStats::rowCollapse(x = mat, idxs = 2:3)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- rowCollapse(x = mat, idxs = 1, rows = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowCollapse(x = mat, idxs = 1, rows = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCollapse(x = mat, idxs = 2:3, rows = 1:3, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowCollapse(x = mat, idxs = 2:3, rows = 1:3, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCounts works", {

	.check_formals("rowCounts")

	mg_res_def_1 <- rowCounts(x = mat)
	ms_res_def_1 <- matrixStats::rowCounts(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCounts(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowCounts(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCounts(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowCounts(x = mat, rows = 1:3, cols = 2, value = FALSE, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowCounts(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_3 <- matrixStats::rowCounts(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowCummaxs works", {

	.check_formals("rowCummaxs")

	mg_res_def_1 <- rowCummaxs(x = mat)
	ms_res_def_1 <- matrixStats::rowCummaxs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCummaxs(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowCummaxs(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCummaxs(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowCummaxs(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCummins works", {

	.check_formals("rowCummins")

	mg_res_def_1 <- rowCummins(x = mat)
	ms_res_def_1 <- matrixStats::rowCummins(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCummins(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowCummins(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCummins(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowCummins(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCumprods works", {

	.check_formals("rowCumprods")

	mg_res_def_1 <- rowCumprods(x = mat)
	ms_res_def_1 <- matrixStats::rowCumprods(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCumprods(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowCumprods(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCumprods(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowCumprods(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCumsums works", {

	.check_formals("rowCumsums")

	mg_res_def_1 <- rowCumsums(x = mat)
	ms_res_def_1 <- matrixStats::rowCumsums(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCumsums(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowCumsums(x = mat, rows = NULL, cols = NULL, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCumsums(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowCumsums(x = mat, rows = 1:3, cols = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowDiffs works", {

	.check_formals("rowDiffs")

	mg_res_def_1 <- rowDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowDiffs(x = mat, rows = NULL, cols = NULL, lag = 1, differences = 1, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowDiffs(x = mat, rows = NULL, cols = NULL, lag = 1, differences = 1, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowDiffs(x = mat, rows = 1:3, cols = 2, lag = 3, differences = 2, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowDiffs(x = mat, rows = 1:3, cols = 2, lag = 3, differences = 2, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowIQRDiffs works", {

	.check_formals("rowIQRDiffs")

	mg_res_def_1 <- rowIQRDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowIQRDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::rowIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowIQRDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	ms_res_2 <- matrixStats::rowIQRDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	ms_res_3 <- matrixStats::rowIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowIQRs works", {

	.check_formals("rowIQRs")

	mg_res_def_1 <- rowIQRs(x = mat)
	ms_res_def_1 <- matrixStats::rowIQRs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowIQRs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::rowIQRs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowIQRs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::rowIQRs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowLogSumExps works", {

	.check_formals("rowLogSumExps")

	mg_res_def_1 <- rowLogSumExps(lx = mat)
	ms_res_def_1 <- matrixStats::rowLogSumExps(lx = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowLogSumExps(lx = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowLogSumExps(lx = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowLogSumExps(lx = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowLogSumExps(lx = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMadDiffs works", {

	.check_formals("rowMadDiffs")

	mg_res_def_1 <- rowMadDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowMadDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::rowMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMadDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	ms_res_2 <- matrixStats::rowMadDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	ms_res_3 <- matrixStats::rowMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowMads works", {

	.check_formals("rowMads")

	mg_res_def_1 <- rowMads(x = mat)
	ms_res_def_1 <- matrixStats::rowMads(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMads(x = mat, rows = NULL, cols = NULL, center = rowMeans2(mat, na.rm=TRUE), constant = 1.4826, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowMads(x = mat, rows = NULL, cols = NULL, center = rowMeans2(mat, na.rm=TRUE), constant = 1.4826, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMads(x = mat, rows = 1:3, cols = 2, center = NULL, constant = 5, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowMads(x = mat, rows = 1:3, cols = 2, center = NULL, constant = 5, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMaxs works", {

	.check_formals("rowMaxs")

	mg_res_def_1 <- rowMaxs(x = mat)
	ms_res_def_1 <- matrixStats::rowMaxs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMaxs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowMaxs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMaxs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowMaxs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMeans2 works", {

	.check_formals("rowMeans2")

	mg_res_def_1 <- rowMeans2(x = mat)
	ms_res_def_1 <- matrixStats::rowMeans2(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMeans2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowMeans2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMeans2(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowMeans2(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMedians works", {

	.check_formals("rowMedians")

	mg_res_def_1 <- rowMedians(x = mat)
	ms_res_def_1 <- matrixStats::rowMedians(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMedians(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowMedians(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMedians(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowMedians(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMins works", {

	.check_formals("rowMins")

	mg_res_def_1 <- rowMins(x = mat)
	ms_res_def_1 <- matrixStats::rowMins(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMins(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowMins(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMins(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowMins(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowOrderStats works", {

	.check_formals("rowOrderStats")

	mat[is.na(mat)] <- 4.1
	mg_res_def_1 <- rowOrderStats(x = mat, which = 2)
	ms_res_def_1 <- matrixStats::rowOrderStats(x = mat, which = 2)
	expect_equal(mg_res_def_1, ms_res_def_1)
	mg_res_def_2 <- rowOrderStats(x = mat, which = 1)
	ms_res_def_2 <- matrixStats::rowOrderStats(x = mat, which = 1)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- rowOrderStats(x = mat, rows = NULL, cols = NULL, which = 2, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowOrderStats(x = mat, rows = NULL, cols = NULL, which = 2, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowOrderStats(x = mat, rows = 1:3, cols = 2, which = 1, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowOrderStats(x = mat, rows = 1:3, cols = 2, which = 1, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowProds works", {

	.check_formals("rowProds")

	mg_res_def_1 <- rowProds(x = mat)
	ms_res_def_1 <- matrixStats::rowProds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowProds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, method = 'direct', useNames = TRUE)
	ms_res_1 <- matrixStats::rowProds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, method = 'direct', useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowProds(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, method = 'expSumLog', useNames = FALSE)
	ms_res_2 <- matrixStats::rowProds(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, method = 'expSumLog', useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowQuantiles works", {

	.check_formals("rowQuantiles")

	mg_res_def_1 <- rowQuantiles(x = mat)
	ms_res_def_1 <- matrixStats::rowQuantiles(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowQuantiles(x = mat, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = TRUE, type = 7, digits = 7, useNames = TRUE, drop = TRUE)
	ms_res_1 <- matrixStats::rowQuantiles(x = mat, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = TRUE, type = 7, digits = 7, useNames = TRUE, drop = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowQuantiles(x = mat, rows = 1:3, cols = 2, probs = 0.1, na.rm = FALSE, type = 3, digits = 7, useNames = FALSE, drop = FALSE)
	ms_res_2 <- matrixStats::rowQuantiles(x = mat, rows = 1:3, cols = 2, probs = 0.1, na.rm = FALSE, type = 3, digits = 7, useNames = FALSE, drop = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowRanges works", {

	.check_formals("rowRanges")

	mg_res_def_1 <- rowRanges(x = mat)
	ms_res_def_1 <- matrixStats::rowRanges(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowRanges(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowRanges(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowRanges(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowRanges(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowRanks works", {

	.check_formals("rowRanks")

	mg_res_def_1 <- rowRanks(x = mat)
	ms_res_def_1 <- matrixStats::rowRanks(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'max', dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'max', dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowRanks(x = mat, rows = 1:3, cols = 2, ties.method = 'first', dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowRanks(x = mat, rows = 1:3, cols = 2, ties.method = 'first', dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'dense', dim. = dim(mat), useNames = TRUE)
	ms_res_3 <- matrixStats::rowRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'dense', dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowSdDiffs works", {

	.check_formals("rowSdDiffs")

	mg_res_def_1 <- rowSdDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowSdDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::rowSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowSdDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	ms_res_2 <- matrixStats::rowSdDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	ms_res_3 <- matrixStats::rowSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowSds works", {

	.check_formals("rowSds")

	mg_res_def_1 <- rowSds(x = mat)
	ms_res_def_1 <- matrixStats::rowSds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowSds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , center = rowMeans2(mat, na.rm=TRUE), dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowSds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , center = rowMeans2(mat, na.rm=TRUE), dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowSds(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , center = NULL, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowSds(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , center = NULL, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowSums2 works", {

	.check_formals("rowSums2")

	mg_res_def_1 <- rowSums2(x = mat)
	ms_res_def_1 <- matrixStats::rowSums2(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowSums2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowSums2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowSums2(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowSums2(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowTabulates works", {

	.check_formals("rowTabulates")

	mat <- array(suppressWarnings(as.integer(mat)), dim(mat))
	mg_res_def_1 <- rowTabulates(x = mat)
	ms_res_def_1 <- matrixStats::rowTabulates(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowTabulates(x = mat, rows = NULL, cols = NULL, values = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::rowTabulates(x = mat, rows = NULL, cols = NULL, values = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowTabulates(x = mat, rows = 1:3, cols = 2, values = c(0, 1), useNames = FALSE)
	ms_res_2 <- matrixStats::rowTabulates(x = mat, rows = 1:3, cols = 2, values = c(0, 1), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowVarDiffs works", {

	.check_formals("rowVarDiffs")

	mg_res_def_1 <- rowVarDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowVarDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	ms_res_1 <- matrixStats::rowVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowVarDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	ms_res_2 <- matrixStats::rowVarDiffs(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, diff = 2, trim = 0.333333333333333, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	ms_res_3 <- matrixStats::rowVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5, useNames = TRUE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowVars works", {

	.check_formals("rowVars")

	mg_res_def_1 <- rowVars(x = mat)
	ms_res_def_1 <- matrixStats::rowVars(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowVars(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , center = rowMeans2(mat, na.rm=TRUE), dim. = dim(mat), useNames = TRUE)
	ms_res_1 <- matrixStats::rowVars(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, refine = , center = rowMeans2(mat, na.rm=TRUE), dim. = dim(mat), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowVars(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , center = NULL, dim. = c(12L, 8L), useNames = FALSE)
	ms_res_2 <- matrixStats::rowVars(x = mat, rows = 1:3, cols = 2, na.rm = FALSE, refine = , center = NULL, dim. = c(12L, 8L), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedMads works", {

	.check_formals("rowWeightedMads")

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedMads(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedMads(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedMads(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, constant = 1.4826, center = rowMeans2(mat, na.rm=TRUE), useNames = TRUE)
	ms_res_1 <- matrixStats::rowWeightedMads(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, constant = 1.4826, center = rowMeans2(mat, na.rm=TRUE), useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedMads(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, constant = 5, center = rep(6, nrow(mat)), useNames = FALSE)
	ms_res_2 <- matrixStats::rowWeightedMads(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, constant = 5, center = rep(6, nrow(mat)), useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedMeans works", {

	.check_formals("rowWeightedMeans")

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedMeans(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedMeans(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedMeans(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::rowWeightedMeans(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedMeans(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::rowWeightedMeans(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedMedians works", {

	.check_formals("rowWeightedMedians")

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedMedians(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedMedians(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedMedians(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::rowWeightedMedians(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedMedians(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::rowWeightedMedians(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedSds works", {

	.check_formals("rowWeightedSds")

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedSds(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedSds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedSds(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::rowWeightedSds(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedSds(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::rowWeightedSds(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedVars works", {

	.check_formals("rowWeightedVars")

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedVars(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedVars(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedVars(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	ms_res_1 <- matrixStats::rowWeightedVars(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, useNames = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedVars(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	ms_res_2 <- matrixStats::rowWeightedVars(x = mat, w = NULL, rows = 1:3, cols = 2, na.rm = FALSE, useNames = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})

