% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-integer.R
\name{chk_integer}
\alias{chk_integer}
\alias{vld_integer}
\title{Check Integer}
\usage{
chk_integer(x, x_name = NULL)

vld_integer(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if integer using

\code{is.integer(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_integer()}: Validate Integer

}}
\examples{
# chk_integer
chk_integer(1L)
try(chk_integer(1))
# vld_integer
vld_integer(1L)
vld_integer(matrix(1:4, nrow = 2L))
vld_integer(integer(0))
vld_integer(NA_integer_)
vld_integer(1)
vld_integer(TRUE)
}
\seealso{
\code{\link[=is.integer]{is.integer()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other data_type_checkers: 
\code{\link{chk_character}()},
\code{\link{chk_character_or_factor}()},
\code{\link{chk_complex}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_logical}()},
\code{\link{chk_numeric}()},
\code{\link{chk_raw}()}
}
\concept{data_type_checkers}
