% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eccentricity.R
\name{get_eccentricity}
\alias{get_eccentricity}
\title{Get node eccentricities}
\usage{
get_eccentricity(graph, mode = "out")
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{mode}{the mode with which the shortest paths to or from the given
vertices should be calculated for directed graphs. If \code{out} (the
default) then the shortest paths from the node, if \verb{in} then only
shortest paths to each node are considered. If \code{all} is used, then the
corresponding undirected graph will be used and edge directions will be
ignored. For undirected graphs, this argument is ignored.}
}
\value{
A data frame containing eccentricity values by node ID value.
}
\description{
Get a data frame with node eccentricity values.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get the eccentricity values for
# all nodes in the graph
graph \%>\% get_eccentricity()

}
