% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R, R/structural.properties.R
\name{connect}
\alias{connect}
\alias{ego_size}
\alias{ego}
\alias{neighborhood}
\alias{neighborhood.size}
\alias{graph.neighborhood}
\alias{ego_graph}
\alias{connect.neighborhood}
\alias{make_ego_graph}
\title{Neighborhood of graph vertices}
\usage{
connect(graph, order, mode = c("all", "out", "in", "total"))

ego_size(
  graph,
  order = 1,
  nodes = V(graph),
  mode = c("all", "out", "in"),
  mindist = 0
)

ego(
  graph,
  order = 1,
  nodes = V(graph),
  mode = c("all", "out", "in"),
  mindist = 0
)

make_ego_graph(
  graph,
  order = 1,
  nodes = V(graph),
  mode = c("all", "out", "in"),
  mindist = 0
)
}
\arguments{
\item{graph}{The input graph.}

\item{order}{Integer giving the order of the neighborhood.}

\item{mode}{Character constant, it specifies how to use the direction of
the edges if a directed graph is analyzed. For \sQuote{out} only the
outgoing edges are followed, so all vertices reachable from the source
vertex in at most \code{order} steps are counted. For \sQuote{"in"} all
vertices from which the source vertex is reachable in at most \code{order}
steps are counted. \sQuote{"all"} ignores the direction of the edges. This
argument is ignored for undirected graphs.}

\item{nodes}{The vertices for which the calculation is performed.}

\item{mindist}{The minimum distance to include the vertex in the result.}
}
\value{
\itemize{
  \item{\code{ego_size} returns with an integer vector.}
  \item{\code{ego} returns A list of \code{igraph.vs} or a list of numeric
        vectors depending on the value of \code{igraph_opt("return.vs.es")},
        see details for performance characteristics.}
  \item{\code{make_ego_graph} returns with a list of graphs.}
  \item{\code{connect} returns with a new graph object.}
}
}
\description{
These functions find the vertices not farther than a given limit from
another fixed vertex, these are called the neighborhood of the vertex.
}
\details{
The neighborhood of a given order \code{o} of a vertex \code{v} includes all
vertices which are closer to \code{v} than the order. Ie. order 0 is always
\code{v} itself, order 1 is \code{v} plus its immediate neighbors, order 2
is order 1 plus the immediate neighbors of the vertices in order 1, etc.

\code{ego_size} calculates the size of the neighborhoods for the
given vertices with the given order.

\code{ego} calculates the neighborhoods of the given vertices with
the given order parameter.

\code{make_ego_graph} is creates (sub)graphs from all neighborhoods of
the given vertices with the given order parameter. This function preserves
the vertex, edge and graph attributes.

\code{connect} creates a new graph by connecting each vertex to
all other vertices in its neighborhood.
}
\examples{

g <- make_ring(10)
ego_size(g, order = 0, 1:3)
ego_size(g, order = 1, 1:3)
ego_size(g, order = 2, 1:3)
ego(g, order = 0, 1:3)
ego(g, order = 1, 1:3)
ego(g, order = 2, 1:3)

# attributes are preserved
V(g)$name <- c("a", "b", "c", "d", "e", "f", "g", "h", "i", "j")
make_ego_graph(g, order = 2, 1:3)

# connecting to the neighborhood
g <- make_ring(10)
g <- connect(g, 2)

}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}, the first version was
done by Vincent Matossian
}
\keyword{graphs}
