% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classification.R
\name{ConfusionMatrix}
\alias{ConfusionMatrix}
\title{Confusion Matrix}
\usage{
ConfusionMatrix(y_pred, y_true)
}
\arguments{
\item{y_pred}{Predicted labels vector, as returned by a classifier}

\item{y_true}{Ground truth (correct) 0-1 labels vector}
}
\value{
a table of Confusion Matrix
}
\description{
Compute confusion matrix to evaluate the accuracy of a classification.
}
\examples{
data(cars)
logreg <- glm(formula = vs ~ hp + wt,
              family = binomial(link = "logit"), data = mtcars)
pred <- ifelse(logreg$fitted.values < 0.5, 0, 1)
ConfusionMatrix(y_pred = pred, y_true = mtcars$vs)
}

