% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{st_crop.sftime}
\alias{st_crop.sftime}
\title{Crop an \code{sftime} object to a specific rectangle}
\usage{
\method{st_crop}{sftime}(x, y, ...)
}
\arguments{
\item{x}{An object of class \code{sftime}.}

\item{y}{A numeric vector with named elements \code{xmin}, \code{ymin}, 
\code{xmax} and \code{ymax}, or an object of class \code{bbox}, or an object 
for which there is an \code{\link[sf:st_bbox]{st_bbox}} method to convert it 
to a \code{bbox} object.}

\item{...}{Additional arguments; Ignored.}
}
\value{
\code{x} cropped using \code{y}.
}
\description{
Crop an \code{sftime} object to a specific rectangle
}
\details{
See \code{\link[sf:st_crop]{st_crop}}.
}
\examples{
# modified from sf:
box <- c(xmin = 0, ymin = 0, xmax = 1, ymax = 1)
pol <- sf::st_sfc(sf::st_buffer(sf::st_point(c(0.5, 0.5)), 0.6))
pol_sftime <- st_sftime(a = 1, geom = pol, time = Sys.time() + 1:2 * 1000)

pol_sftime_cropped <- sf::st_crop(pol_sftime, sf::st_bbox(box))

class(pol_sftime_cropped)
plot(pol_sftime_cropped)
}
