package bootstrap

import (
	"regexp"
)

type configVars struct {
	CA        string
	Cert      string
	Key       string
	IPAddr    string
	Port      string
	Transport string
}

// TODO: sanitize the options coming from the service and add them here too
// instead of hardcoding (cipher, etc)
var openvpnConfigTemplate = `# openvpn config generated by bitmaskcfg
client
dev tun
verb 3
tls-client
remote-cert-tls server
tls-version-min 1.2
tls-cipher DHE-RSA-AES128-SHA
cipher AES-128-CBC
pull-filter ignore ifconfig-ipv6
pull-filter ignore route-ipv6
proto {{ .Transport }}
remote {{ .IPAddr }} {{ .Port }} {{ .Transport }}
<ca>
{{ .CA }}
</ca>
<cert>
{{ .Cert }}
</cert>
<key>
{{ .Key }}
</key>`

var (
	keyBegin  = "<key>\n"
	keyEnd    = "</key>\n"
	certBegin = "<cert>\n"
	certEnd   = "</cert>\n"
	caBegin   = "<ca>\n"
	caEnd     = "</ca>\n"
)

func matchDelimitedString(str, left, right string) string {
	rx := regexp.MustCompile(`(?s)` + regexp.QuoteMeta(left) + `(.*?)` + regexp.QuoteMeta(right))
	matches := rx.FindAllStringSubmatch(str, -1)
	if len(matches) != 1 {
		return ""
	}
	return matches[0][1]
}
