#ifndef CXX_MACROS_H
#define CXX_MACROS_H

#ifdef __cplusplus

// these are because it looks ugly to write out <type>::iterator blah blah
// all the time:

#define _iterate_between(_type, _itype, _var, _iter, _start, _end) \
        for (_type :: _itype _iter = (_var).begin() + (_start); \
             _iter != (_var).begin() + (_end); _iter++)

#define _iterate_from(_type, _itype, _var, _iter, _start) \
        for (_type :: _itype _iter = (_var).begin() + (_start); \
             _iter != (_var).end(); _iter++)

// with this macro, one can either use a non-negative number to indicate
// distance from start, or a negative number to indicate distance from end
#define _iterate_until(_type, _itype, _var, _iter, _end) \
        for (_type :: _itype _iter = (_var).begin(); \
             _iter != (((_end) >= 0) ? (_var).begin() + (_end) : \
                       (_var).end() + (_end)); \
             _iter++)

#define _iterate(_type, _itype, _var, _iter) \
        _iterate_from(_type, _itype, _var, _iter, 0)

#define iterate_between(_t, _v, _i, _s, _e) \
        _iterate_between(_t, iterator, _v, _i, _s, _e)

#define iterate_from(_t, _v, _i, _s)  _iterate_from(_t, iterator, _v, _i, _s)
#define iterate_until(_t, _v, _i, _e) _iterate_until(_t, iterator, _v, _i, _e)
#define iterate(_t, _v, _i)           _iterate(_t, iterator, _v, _i)

#define citerate_between(_t, _v, _i, _s, _e) \
        _iterate_between(_t, const_iterator, _v, _i, _s, _e)
#define citerate_from(_t, _v, _i, _s) \
        _iterate_from(_t, const_iterator, _v, _i, _s)
#define citerate_until(_t, _v, _i, _e) \
        _iterate_until(_t, const_iterator, _v, _i, _e)
#define citerate(_t, _v, _i) _iterate(_t, const_iterator, _v, _i)

#endif /* __cplusplus */
#endif

