; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=m68k-pc-linux -relocation-model=pic -verify-machineinstrs | FileCheck %s

;
; C Call passes all arguments on stack ...

define void @test1(i32* nocapture %out, i32 %in) nounwind {
; CHECK-LABEL: test1:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (4,%sp), %a0
; CHECK-NEXT:    move.l (8,%sp), (%a0)
; CHECK-NEXT:    rts
entry:
  store i32 %in, i32* %out, align 4
  ret void
}

define void @test2(i32* nocapture %pOut, i32* nocapture %pIn) nounwind {
; CHECK-LABEL: test2:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (8,%sp), %a0
; CHECK-NEXT:    move.l (4,%sp), %a1
; CHECK-NEXT:    move.l (%a0), (%a1)
; CHECK-NEXT:    rts
entry:
  %0 = load i32, i32* %pIn, align 4
  store i32 %0, i32* %pOut, align 4
  ret void
}

define void @test3(i8* nocapture %out, i8 %in) nounwind {
; CHECK-LABEL: test3:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (4,%sp), %a0
; CHECK-NEXT:    move.b (11,%sp), (%a0)
; CHECK-NEXT:    rts
entry:
  store i8 %in, i8* %out, align 1
  ret void
}

define void @test4(i16* nocapture %out, i16 %in) nounwind {
; CHECK-LABEL: test4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (4,%sp), %a0
; CHECK-NEXT:    move.w (10,%sp), (%a0)
; CHECK-NEXT:    rts
entry:
  store i16 %in, i16* %out, align 2
  ret void
}

define i8 @test5(i8 %a, i8 %b) nounwind {
; CHECK-LABEL: test5:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.b (7,%sp), %d0
; CHECK-NEXT:    add.b (11,%sp), %d0
; CHECK-NEXT:    rts
entry:
  %add = add i8 %a, %b
  ret i8 %add
}

define i16 @test6(i16 %a, i16 %b) nounwind {
; CHECK-LABEL: test6:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.w (6,%sp), %d0
; CHECK-NEXT:    add.w (10,%sp), %d0
; CHECK-NEXT:    rts
entry:
  %add = add i16 %a, %b
  ret i16 %add
}
