import { Spec } from 'vega';

export const spec: Spec = {
  $schema: 'https://vega.github.io/schema/vega/v5.json',
  width: 300,
  height: 200,
  padding: 5,
  marks: [
    {
      type: 'rect',
      encode: {
        update: {
          x: { value: 0 },
          y: { value: 0 },
          width: { value: 50 },
          height: { signal: 'height' },
          fill: { value: '#1f77b4' },
          cornerRadius: { value: 10 }
        }
      }
    },
    {
      type: 'rect',
      encode: {
        update: {
          x: { value: 60 },
          y: { value: 0 },
          width: { value: 50 },
          height: { signal: 'height' },
          fill: { value: '#1f77b4' },
          cornerRadiusTopLeft: { value: 10 },
          cornerRadiusTopRight: { value: 10 }
        }
      }
    },
    {
      type: 'rect',
      encode: {
        update: {
          x: { value: 120 },
          y: { value: 0 },
          width: { value: 50 },
          height: { signal: 'height' },
          fill: { value: '#1f77b4' },
          cornerRadius: { value: 500 },
          cornerRadiusBottomLeft: { value: 10 },
          cornerRadiusBottomRight: { value: 10 }
        }
      }
    },
    {
      type: 'rect',
      encode: {
        update: {
          x: { value: 180 },
          y: { value: 0 },
          width: { value: 100 },
          height: { signal: 'height' },
          fill: { value: '#1f77b4' },
          cornerRadiusTopLeft: { value: 10 },
          cornerRadiusTopRight: { value: 20 },
          cornerRadiusBottomLeft: { value: 40 },
          cornerRadiusBottomRight: { value: 30 }
        }
      }
    },
    {
      type: 'rect',
      encode: {
        update: {
          x: { value: 290 },
          y: { value: 0 },
          width: { value: 110 },
          height: { signal: 'height' },
          fill: { value: '#1f77b4' },
          cornerRadius: { value: 20 },
          cornerRadiusBottomLeft: { value: -10 },
          cornerRadiusBottomRight: { value: 0 }
        }
      }
    },
    {
      type: 'group',
      encode: {
        update: {
          x: { value: 0 },
          y: { signal: 'height + 5' },
          width: { value: 50 },
          height: { signal: 'height' },
          fill: { value: 'firebrick' },
          cornerRadius: { value: 10 }
        }
      }
    },
    {
      type: 'group',
      encode: {
        update: {
          x: { value: 60 },
          y: { signal: 'height + 5' },
          width: { value: 50 },
          height: { signal: 'height' },
          fill: { value: 'firebrick' },
          cornerRadiusBottomLeft: { value: 10 },
          cornerRadiusBottomRight: { value: 10 }
        }
      }
    },
    {
      type: 'group',
      encode: {
        update: {
          x: { value: 120 },
          y: { signal: 'height + 5' },
          width: { value: 50 },
          height: { signal: 'height' },
          fill: { value: 'firebrick' },
          cornerRadius: { value: 500 },
          cornerRadiusTopLeft: { value: 10 },
          cornerRadiusTopRight: { value: 10 }
        }
      }
    },
    {
      type: 'group',
      encode: {
        update: {
          x: { value: 180 },
          y: { signal: 'height + 5' },
          width: { value: 100 },
          height: { signal: 'height' },
          fill: { value: 'firebrick' },
          cornerRadiusTopLeft: { value: 40 },
          cornerRadiusTopRight: { value: 30 },
          cornerRadiusBottomLeft: { value: 10 },
          cornerRadiusBottomRight: { value: 20 }
        }
      }
    },
    {
      type: 'group',
      encode: {
        update: {
          x: { value: 290 },
          y: { signal: 'height + 5' },
          width: { value: 110 },
          height: { signal: 'height' },
          fill: { value: 'firebrick' },
          cornerRadius: { value: 20 },
          cornerRadiusTopLeft: { value: -10 },
          cornerRadiusTopRight: { value: 0 }
        }
      }
    }
  ]
};
