/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb.validity;

import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import spec.jbb.validity.C1;
import spec.jbb.validity.C2;
import spec.jbb.validity.C2intf;
import spec.jbb.validity.C3;
import spec.jbb.validity.C3intf;
import spec.jbb.validity.SideIntf;
import spec.jbb.validity.StringAndInt;
import spec.jbb.validity.subClass;
import spec.jbb.validity.superClass;
import spec.jbb.validity.syncTest;

class PepTest {
    public int fisk;
    public boolean gotError = false;
    private static PrintStream out = System.out;
    private static final boolean deliberateErrorForTest = false;
    static subClass[][] staticSubArray = new subClass[][]{{null, null}, {null, null}};
    static int[][] staticIntArray = new int[][]{{1, 2, 3}, {4, 5, 6}};

    PepTest() {
    }

    String testDiv() {
        out.print("testDiv:    ");
        int n = 7;
        int n2 = 7;
        if (1 != n2 / n) {
            return "failed 1";
        }
        if (-1 != (n2 = -n2) / n) {
            return "failed 2";
        }
        n2 = 600000000;
        n = 600000000;
        if (1 != n2 / n) {
            return "failed 1.1";
        }
        if (-1 != (n2 = -n2) / n) {
            return "failed 2.1";
        }
        long l = 8L;
        long l2 = 8L;
        if (1L != l / l2) {
            return "failed 3";
        }
        if (-1L != (l = -l) / l2) {
            return "failed 4";
        }
        l = 600000000L;
        l2 = 600000000L;
        if (1L != l / l2) {
            return "failed 3.1";
        }
        if (-1L != (l = -l) / l2) {
            return "failed 4.1";
        }
        n = 0;
        try {
            n2 /= n;
            return "failed 5";
        }
        catch (Exception exception) {
            l2 = 0L;
            try {
                l /= l2;
                return "failed 6";
            }
            catch (Exception exception2) {
                try {
                    l %= l2;
                    return "failed 6.1";
                }
                catch (Exception exception3) {
                    double d = 7.0;
                    double d2 = 7.0;
                    if (1.0 != d2 / d) {
                        return "failed 7";
                    }
                    if (-1.0 != (d2 = -d2) / d) {
                        return "failed 8";
                    }
                    d = 0.0;
                    try {
                        d2 /= d;
                    }
                    catch (Exception exception4) {
                        return "failed 9";
                    }
                    try {
                        d2 %= d;
                        d2 = 5.6 % d;
                    }
                    catch (Exception exception5) {
                        return "failed 9";
                    }
                    return null;
                }
            }
        }
    }

    String testIf() {
        int n;
        out.print("testIf:     ");
        int n2 = n = 3;
        if (n2 * n2 != 9) {
            return "branched the wrong way";
        }
        n2 = 1;
        if (n2 != 1) {
            return "didn't execute any of the branches";
        }
        n = 0;
        n2 = 0;
        int n3 = 0;
        n3 = n == 0 ? (n2 == 0 ? 1 : 2) : (n2 == 0 ? 3 : 4);
        if (n3 != 1) {
            return "nested if failed in true/true case";
        }
        n = 0;
        n2 = 1;
        n3 = 0;
        n3 = n == 0 ? (n2 == 0 ? 1 : 2) : (n2 == 0 ? 3 : 4);
        if (n3 != 2) {
            return "nested if failed in true/false case";
        }
        n = 1;
        n2 = 0;
        n3 = 0;
        n3 = n == 0 ? (n2 == 0 ? 1 : 2) : (n2 == 0 ? 3 : 4);
        if (n3 != 3) {
            return "nested if failed in false/true case";
        }
        n = 1;
        n2 = 1;
        n3 = 0;
        n3 = n == 0 ? (n2 == 0 ? 1 : 2) : (n2 == 0 ? 3 : 4);
        if (n3 != 4) {
            return "nested if failed in false/false case";
        }
        return null;
    }

    int shiftAnd(int n, int n2) {
        return n >>> n2 & 0xFF;
    }

    String testBitOps() {
        out.print("testBitOps: ");
        int n = -889275714;
        if (this.shiftAnd(n, 24) != 202) {
            return "bad shift-and 1";
        }
        if (this.shiftAnd(n, 16) != 254) {
            return "bad shift-and 2";
        }
        if (this.shiftAnd(n, 8) != 186) {
            return "bad shift-and 3";
        }
        if (this.shiftAnd(n, 0) != 190) {
            return "bad shift-and 4";
        }
        return null;
    }

    String testFor() {
        int n = 0;
        out.print("testFor:    ");
        for (int i = 0; i < 100; ++i) {
            for (int j = i; j >= 0; j -= 2) {
                n = i + n + j;
            }
        }
        if (n != 252450) {
            return "wrong check sum";
        }
        return null;
    }

    String testTableSwitch() {
        int n;
        out.print("testTableSwitch:  ");
        int n2 = 2;
        switch (n2 *= 3) {
            case 0: 
            case 4: {
                n = 0;
                break;
            }
            case 1: 
            case 2: {
                n = 1;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n = 3;
                break;
            }
            default: {
                n = -1;
            }
        }
        if (n != 3) {
            return "took wrong case branch";
        }
        switch (n2 += 100) {
            case 0: 
            case 4: {
                n = 0;
                break;
            }
            case 1: 
            case 2: {
                n = 1;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n = 3;
                break;
            }
            default: {
                n = -1;
            }
        }
        if (n != -1) {
            return "failed to take default branch";
        }
        return null;
    }

    String testLookupSwitch() {
        int n;
        out.print("testLookupSwitch: ");
        int n2 = 2;
        switch (n2 *= 3000) {
            case 0: 
            case 4000: {
                n = 0;
                break;
            }
            case 1000: 
            case 2000: {
                n = 1;
                break;
            }
            case 3000: 
            case 5000: 
            case 6000: {
                n = 3;
                break;
            }
            default: {
                n = -1;
            }
        }
        if (n != 3) {
            return "took wrong case branch";
        }
        switch (n2 += 999999999) {
            case 0: 
            case 4000: {
                n = 0;
                break;
            }
            case 1000: 
            case 2000: {
                n = 1;
                break;
            }
            case 3000: 
            case 5000: 
            case 6000: {
                n = 3;
                break;
            }
            default: {
                n = -1;
            }
        }
        if (n != -1) {
            return "failed to take default branch";
        }
        return null;
    }

    String testHiddenField() {
        subClass subClass2;
        out.print("testHiddenField:  ");
        subClass subClass3 = subClass2 = new subClass();
        if (((superClass)subClass3).val != 1) {
            return "direct access to field defined by superclass failed";
        }
        if (subClass2.val != 2) {
            return "direct access to field defined by subclass failed";
        }
        if (((superClass)subClass3).getVal() != 2) {
            return "access through method to field defined by superclass failed";
        }
        if (subClass2.getVal() != 2) {
            return "access through method to field defined by subclass failed";
        }
        return null;
    }

    void printTime() {
        Date date = new Date();
        out.print("Time now is ");
        out.print(date.toString());
        out.print(",   ms: ");
        out.println(System.currentTimeMillis());
    }

    String checkInst(superClass superClass2, boolean bl, boolean bl2, boolean bl3, int n) {
        return this.checkInst2(superClass2, bl, superClass2 instanceof superClass, "superClass") + this.checkInst2(superClass2, bl2, superClass2 instanceof subClass, "subClass") + this.checkInst2(superClass2, bl3, superClass2 instanceof Cloneable, "Cloneable");
    }

    String checkInst2(superClass superClass2, boolean bl, boolean bl2, String string) {
        if (bl == bl2) {
            return "";
        }
        return "Failed: 'a " + superClass2.getClass().getName() + "' instanceof " + string + " (returned: " + bl2 + ", should be: " + bl + ")\n";
    }

    String checkInstanceOf() {
        out.print("checkInstanceOf: ");
        if (!(new superClass[2] instanceof superClass[])) {
            return "failed: new superClass[2]) instanceof superClass[]";
        }
        if (!(new subClass[2] instanceof superClass[])) {
            return "failed: new subClass[2]) instanceof superClass[]";
        }
        if (new superClass[2] instanceof subClass[]) {
            return "failed: new superClass[2]) instanceof subClass[]";
        }
        if (new Object[2] instanceof subClass[]) {
            return "failed: new Object[2]) instanceof subClass[]";
        }
        if (!(new subClass[2] instanceof Cloneable[])) {
            return "failed: new subClass[2]) instanceof Cloneable[]";
        }
        return this.checkInst(null, false, false, false, 1) + this.checkInst(new superClass(), true, false, true, 2) + this.checkInst(new subClass(), true, true, true, 3);
    }

    String checkInterfaceInstanceOf() {
        out.print("checkInterfaceInstanceOf: ");
        C1 c1 = new C1();
        C2 c2 = new C2();
        C3 c3 = new C3();
        if (!(c1 instanceof C1)) {
            return "checkInterfaceInstanceOf: error-1";
        }
        if (c1 instanceof C2) {
            return "checkInterfaceInstanceOf: error-2";
        }
        if (c1 instanceof C3) {
            return "checkInterfaceInstanceOf: error-3";
        }
        if (!(c2 instanceof C1)) {
            return "checkInterfaceInstanceOf: error-4";
        }
        if (!(c2 instanceof C2)) {
            return "checkInterfaceInstanceOf: error-5";
        }
        if (c2 instanceof C3) {
            return "checkInterfaceInstanceOf: error-6";
        }
        if (!(c3 instanceof C1)) {
            return "checkInterfaceInstanceOf: error-7";
        }
        if (!(c3 instanceof C2)) {
            return "checkInterfaceInstanceOf: error-8";
        }
        if (!(c3 instanceof C3)) {
            return "checkInterfaceInstanceOf: error-9";
        }
        if (c1 instanceof C2intf) {
            return "checkInterfaceInstanceOf: error-10";
        }
        if (c1 instanceof C3intf) {
            return "checkInterfaceInstanceOf: error-11";
        }
        if (c1 instanceof SideIntf) {
            return "checkInterfaceInstanceOf: error-12";
        }
        if (!(c2 instanceof C2intf)) {
            return "checkInterfaceInstanceOf: error-13";
        }
        if (c2 instanceof C3intf) {
            return "checkInterfaceInstanceOf: error-14";
        }
        if (c2 instanceof SideIntf) {
            return "checkInterfaceInstanceOf: error-15";
        }
        if (!(c3 instanceof C2intf)) {
            return "checkInterfaceInstanceOf: error-16";
        }
        if (!(c3 instanceof C3intf)) {
            return "checkInterfaceInstanceOf: error-17";
        }
        if (!(c3 instanceof SideIntf)) {
            return "checkInterfaceInstanceOf: error-18";
        }
        return null;
    }

    String testExc1() {
        block6: {
            out.print("testExc1(simple throw/catch):  ");
            int n = 0;
            try {
                n = n == 0 ? 1 : -1;
                if (n != 47) {
                    throw new ArithmeticException("fisk");
                }
                n = -1;
            }
            catch (ArithmeticException arithmeticException) {
                n = n == 1 ? 2 : -1;
            }
            if (n != 2) {
                return "failed-1";
            }
            int[] nArray = new int[10];
            try {
                nArray[11] = 11;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (arrayIndexOutOfBoundsException.getClass().getName().equals("java.lang.ArrayIndexOutOfBoundsException")) break block6;
                return "failed-2: " + arrayIndexOutOfBoundsException.getClass().getName();
            }
        }
        return null;
    }

    String testExc2() {
        out.print("testExc2(skip catch clauses):  ");
        int n = 0;
        try {
            n = n == 0 ? 1 : -1;
            if (n != 47) {
                throw new RuntimeException("fisk");
            }
            n = -1;
        }
        catch (ArithmeticException arithmeticException) {
            n = -1;
        }
        catch (AbstractMethodError abstractMethodError) {
            n = -1;
        }
        catch (RuntimeException runtimeException) {
            n = n == 1 ? 2 : -1;
        }
        if (n == 2) {
            return null;
        }
        return "failed";
    }

    String testExc3() {
        out.print("testExc3(catch in inner):      ");
        int n = 0;
        try {
            n = n == 0 ? 1 : -1;
            try {
                n = n != 1 ? -1 : 2;
                if (n != 47) {
                    throw new ArithmeticException("fisk");
                }
                return "failed-1";
            }
            catch (ArithmeticException arithmeticException) {
                n = n != 2 ? -1 : 3;
            }
        }
        catch (ArithmeticException arithmeticException) {
            n = -1;
        }
        if (n == 3) {
            return null;
        }
        return "failed-2";
    }

    String testExc4() {
        out.print("testExc4(catch in outer):      ");
        int n = 0;
        try {
            n = n == 0 ? 1 : -1;
            try {
                n = n != 1 ? -1 : 2;
                if (n != 47) {
                    throw new RuntimeException("fisk");
                }
            }
            catch (ArithmeticException arithmeticException) {
                n = -1;
            }
        }
        catch (RuntimeException runtimeException) {
            n = n != 2 ? -1 : 3;
        }
        if (n == 3) {
            return null;
        }
        return "failed";
    }

    String testExc5() {
        out.print("testExc5(rethrow):             ");
        int n = 0;
        try {
            n = n == 0 ? 1 : -1;
            try {
                n = n != 1 ? -1 : 2;
                if (n != 47) {
                    throw new ArithmeticException("fisk");
                }
            }
            catch (ArithmeticException arithmeticException) {
                n = n != 2 ? -1 : 3;
                throw arithmeticException;
            }
        }
        catch (ArithmeticException arithmeticException) {
            n = n != 3 ? -1 : 4;
        }
        if (n == 4) {
            return null;
        }
        return "failed";
    }

    String testExc6() {
        out.print("testExc6(throw accross call):  ");
        int n = 0;
        try {
            n = 1;
            this.throwArithmeticException(1);
            n = 2;
        }
        catch (ArithmeticException arithmeticException) {
            n = n != 1 ? -1 : 4;
        }
        if (n == 4) {
            return null;
        }
        return "failed";
    }

    String testExc7() {
        out.print("testExc7(throw accr. 2 calls): ");
        int n = 0;
        try {
            n = 1;
            n = this.dontDouble(n);
            n = 2;
        }
        catch (ArithmeticException arithmeticException) {
            n = n != 1 ? -1 : 4;
        }
        if (n == 4) {
            return null;
        }
        return "failed";
    }

    String stringHash(String string, int n, int n2) {
        if (string.hashCode() != n && string.hashCode() != n2) {
            return "unexpected string hash value for '" + string + "': " + string.hashCode() + " (expected: " + n + " or " + n2 + ")";
        }
        return null;
    }

    String testStringHash() {
        out.print("testStringHash:  ");
        String string = this.stringHash("monkey", -817689237, -1068495917);
        if (null != string) {
            return string;
        }
        string = this.stringHash("donkey", -1441784850, -1326158276);
        if (null != string) {
            return string;
        }
        string = this.stringHash("Lavazza", 84343969, 1619816993);
        if (null != string) {
            return string;
        }
        string = this.stringHash("and a longer string with many words 123454876*=+-_%$$@", 47854477, 304406733);
        if (null != string) {
            return string;
        }
        return null;
    }

    String testObjectHash() {
        out.print("testObjectHash:  ");
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            Integer n = new Integer(new syncTest().hashCode());
            hashtable.put(n, n);
        }
        if (hashtable.size() < 700) {
            return "Hash codes not very unique; out of 1000 got only " + hashtable.size() + " unique";
        }
        return null;
    }

    String loopExitContinueInExceptionHandler() {
        int n;
        out.print("loopExitContinueInExceptionHandler: ");
        for (n = 0; n < 10000; ++n) {
            try {
                if (n % 100 == 0) {
                    throw new ArithmeticException("fisk");
                }
                if (n == 9990) break;
                if (n % 2 != 0) continue;
            }
            catch (ArithmeticException arithmeticException) {
                if (n % 2 == 0) continue;
                return "Should not throw odd exceptions!";
            }
        }
        if (n != 9990) {
            return "Seems that break didn't work";
        }
        return null;
    }

    String testClone() {
        int n;
        out.print("testClone:       ");
        int[] nArray = new int[100];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n * n;
        }
        int[] nArray2 = (int[])nArray.clone();
        if (nArray.length != nArray2.length) {
            return "Clone of int array failed (length)";
        }
        for (n = 0; n < nArray2.length; ++n) {
            if (nArray2[n] == n * n) continue;
            return "Clone of int array failed-" + n;
        }
        Hashtable hashtable = new Hashtable(31);
        if (hashtable.clone() == hashtable) {
            return "Clone failed on hash tables";
        }
        boolean bl = false;
        try {
            hashtable = null;
            hashtable.clone();
        }
        catch (NullPointerException nullPointerException) {
            bl = true;
        }
        if (!bl) {
            return "failed to catch exception from null.clone()";
        }
        StringAndInt stringAndInt = new StringAndInt();
        stringAndInt.s = "goat";
        stringAndInt.i = 5;
        StringAndInt stringAndInt2 = (StringAndInt)stringAndInt.clone();
        if (stringAndInt == stringAndInt2) {
            return "clone returned same object";
        }
        if (!stringAndInt2.s.equals("goat")) {
            return "clone didn't get the goat there";
        }
        if (stringAndInt2.i != 5) {
            return "clone didn't get the 5 there";
        }
        if (!stringAndInt.s.equals("goat")) {
            return "clone messed up receiver: goat";
        }
        if (stringAndInt.i != 5) {
            return "clone messed up receiver: 5";
        }
        return null;
    }

    String checkClassNameOf(String string, Object object, String string2) {
        if (string2.equals(object.getClass().getName())) {
            return null;
        }
        return "Error: className(" + string + ") = " + object.getClass().getName() + ", should be = " + string2;
    }

    void printInterfaces(Class clazz) {
        out.print(clazz.getName() + ":  ");
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            out.print(classArray[i].getName() + " ");
            if (classArray[i].isInterface()) continue;
            out.println("Error: should have been an interface!");
        }
        if (0 == classArray.length) {
            out.print("no interfaces");
        }
        out.println();
    }

    String testClass() {
        String string = this.checkClassNameOf("double[][]", new double[2][3], "[[D");
        if (string != null) {
            return string;
        }
        string = this.checkClassNameOf("7", new Integer(7), "java.lang.Integer");
        if (string != null) {
            return string;
        }
        string = this.checkClassNameOf("horse", this, "PepTest");
        if (string != null) {
            return string;
        }
        string = this.checkClassNameOf("new PepTest[2]", new PepTest[2], "[LPepTest;");
        if (string != null) {
            return string;
        }
        string = this.checkClassNameOf("new PepTest[2][2]", new PepTest[2][2], "[[LPepTest;");
        if (string != null) {
            return string;
        }
        string = this.checkClassNameOf("java.util.Hashtable", new Hashtable(), "java.util.Hashtable");
        if (string != null) {
            return string;
        }
        PepTest[] pepTestArray = new PepTest[2];
        if (pepTestArray.getClass().getInterfaces().length != 0) {
            return "Error: array class should not have interfaces";
        }
        this.printInterfaces(pepTestArray.getClass());
        boolean bl = false;
        try {
            this.printInterfaces(null);
        }
        catch (NullPointerException nullPointerException) {
            bl = true;
        }
        if (!bl) {
            return "Error: null pointer exception not caught";
        }
        for (Class<?> clazz = new Hashtable().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            this.printInterfaces(clazz);
        }
        return null;
    }

    String testWaitNull() {
        out.print("testWaitNull: ");
        try {
            ((Object)null).wait(43L);
        }
        catch (Exception exception) {
            if (exception.getClass().getName().equals("java.lang.NullPointerException")) {
                return null;
            }
            return "error: " + exception;
        }
        return "error: missing exception";
    }

    String testVarAndMethodNameClash() {
        out.print("testVarAndMethodNameClash: ");
        superClass superClass2 = new superClass();
        int n = superClass2.bothVarAndMethod;
        if (n != 7) {
            return "1: Var has wrong value: " + n;
        }
        n = superClass2.bothVarAndMethod();
        if (n != 8) {
            return "1: Method returned wrong value: " + n;
        }
        superClass2.bothVarAndMethod = 9;
        n = superClass2.bothVarAndMethod;
        if (n != 9) {
            return "2: Var has wrong value: " + n;
        }
        n = superClass2.bothVarAndMethod();
        if (n != 8) {
            return "2: Method returned wrong value: " + n;
        }
        superClass2.bothVarAndMethod(5);
        n = superClass2.bothVarAndMethod;
        if (n != 5) {
            return "3: Var has wrong value: " + n;
        }
        n = superClass2.bothVarAndMethod();
        if (n != 8) {
            return "3: Method returned wrong value: " + n;
        }
        return null;
    }

    void checkAllNull(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            out.println("error: should have been null");
        }
    }

    String testObjectArray() {
        int n;
        int n2;
        out.print("testObjectArray: ");
        Object[] objectArray = new subClass[10];
        Object[] objectArray2 = new superClass[10];
        if (!(objectArray instanceof subClass[])) {
            return "array instanceof-1 failed";
        }
        if (!(objectArray instanceof superClass[])) {
            return "array instanceof-2 failed";
        }
        if (!(objectArray instanceof Object[])) {
            return "array instanceof-3 failed";
        }
        if (objectArray2 instanceof subClass[]) {
            return "array instanceof-4 failed";
        }
        if (!(objectArray2 instanceof superClass[])) {
            return "array instanceof-5 failed";
        }
        if (!(objectArray2 instanceof Object[])) {
            return "array instanceof-6 failed";
        }
        for (n2 = 0; n2 < 10; ++n2) {
            objectArray[n2] = new subClass();
            objectArray2[n2] = new superClass();
        }
        objectArray2[4] = objectArray[1];
        objectArray2[5] = null;
        objectArray[2] = (subClass)objectArray2[4];
        objectArray[2] = (subClass)objectArray2[5];
        n2 = 0;
        try {
            objectArray[2] = (subClass)objectArray2[7];
        }
        catch (ClassCastException classCastException) {
            n2 = 1;
        }
        if (n2 == 0) {
            return "missing ClassCastException";
        }
        System.arraycopy(objectArray, 0, objectArray2, 0, 10);
        for (n = 0; n < 10; ++n) {
            objectArray[n] = null;
        }
        System.arraycopy(objectArray, 0, objectArray2, 0, 10);
        this.checkAllNull(objectArray2);
        System.arraycopy(objectArray2, 0, objectArray, 0, 10);
        this.checkAllNull(objectArray);
        this.checkAllNull(objectArray2);
        objectArray[4] = new subClass();
        System.arraycopy(objectArray2, 0, objectArray, 0, 10);
        this.checkAllNull(objectArray);
        this.checkAllNull(objectArray2);
        n = 0;
        try {
            System.arraycopy(null, 0, objectArray, 0, 10);
        }
        catch (NullPointerException nullPointerException) {
            n = 1;
        }
        if (n == 0) {
            return "error: should have caught exception-1";
        }
        n = 0;
        try {
            System.arraycopy(objectArray2, 0, null, 0, 10);
        }
        catch (NullPointerException nullPointerException) {
            n = 1;
        }
        if (n == 0) {
            return "error: should have caught exception-2";
        }
        n = 0;
        try {
            System.arraycopy(objectArray2, 0, objectArray, 0, 11);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = 1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n = 1;
        }
        if (n == 0) {
            return "error: should have caught exception-3";
        }
        n = 0;
        try {
            System.arraycopy(objectArray2, 1, objectArray, 0, 10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = 1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n = 1;
        }
        if (n == 0) {
            return "error: should have caught exception-4";
        }
        n = 0;
        try {
            System.arraycopy(objectArray2, -1, null, 100, 100);
        }
        catch (NullPointerException nullPointerException) {
            n = 1;
        }
        if (n == 0) {
            return "error: should have caught exception-5";
        }
        objectArray2[5] = new superClass();
        n = 0;
        try {
            System.arraycopy(objectArray2, 0, objectArray, 0, 10);
        }
        catch (ArrayStoreException arrayStoreException) {
            n = 1;
        }
        if (n == 0) {
            return "error: should have caught exception-6";
        }
        return null;
    }

    int dontDouble(int n) {
        this.throwArithmeticException(n);
        return 2 * n;
    }

    void throwArithmeticException(int n) {
        if (n == 1) {
            throw new ArithmeticException("fisk");
        }
        if (n == 1) {
            out.println("should not print this");
        } else {
            out.println("should print this");
        }
    }

    int testDup() {
        int n = 7;
        int n2 = 7;
        return n2;
    }

    int testForLoop(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += i * i;
        }
        return n3;
    }

    String testArray() {
        out.print("testArray:  ");
        int[] nArray = new int[6];
        nArray[4] = 3;
        nArray[3] = nArray[4];
        if (nArray[3] != 3) {
            return "got bad array value-";
        }
        double[][] dArray = new double[5][6];
        dArray[1][2] = 3.0;
        if (dArray[1][2] != 3.0) {
            return "got bad array value-2";
        }
        Stack[][][] stackArrayArray = new Stack[4][][];
        if (stackArrayArray[2] != null) {
            return "bad array initialization";
        }
        boolean bl = false;
        try {
            for (int i = 0; i < 5; ++i) {
                nArray[i + 3] = i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        if (!bl) {
            return "missing exception";
        }
        if (nArray[4] != 1 || nArray[5] != 2) {
            return "missing side-effect";
        }
        return null;
    }

    boolean isPrime(int n) {
        if (n == 2) {
            return true;
        }
        if (n % 2 == 0) {
            return false;
        }
        int n2 = 3;
        while (n2 * n2 <= n) {
            if (n % n2 == 0) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    void printPrimes() {
        out.print("Primes less than 50: ");
        for (int i = 2; i < 50; ++i) {
            if (!this.isPrime(i)) continue;
            out.print(i);
            out.print(" ");
        }
        out.println("");
    }

    public void Verify(String string) {
        if (null == string || string.equals("")) {
            out.println("OK");
        } else {
            this.gotError = true;
            out.println();
            out.println("******************************************");
            out.println(string);
            out.println("******************************************");
        }
    }

    boolean checkRemL(long l, long l2, long l3) {
        boolean bl;
        boolean bl2 = bl = l3 == l % l2;
        if (!bl) {
            out.print("Failed: " + l + " % " + l2 + " = " + l % l2);
            out.println("   (should be: " + l3);
        }
        return bl;
    }

    boolean checkRemD(double d, double d2, double d3) {
        boolean bl;
        boolean bl2 = bl = d3 == d % d2;
        if (!bl) {
            out.print("Failed: " + d + " % " + d2 + " = " + d % d2);
            out.println("   (should be: " + d3);
        }
        return bl;
    }

    void printRemD(double d, double d2) {
        out.print(d + " % " + d2 + " = " + d % d2);
    }

    String checkRemainders() {
        out.print("checkRemainders: ");
        boolean bl = true;
        out.print(" long ");
        if (!this.checkRemL(10L, 7L, 3L)) {
            bl = false;
        }
        if (!this.checkRemL(10L, -7L, 3L)) {
            bl = false;
        }
        if (!this.checkRemL(-10L, 7L, -3L)) {
            bl = false;
        }
        if (!this.checkRemL(-10L, -7L, -3L)) {
            bl = false;
        }
        if (!this.checkRemD(10.5, 7.0, 3.5)) {
            bl = false;
        }
        if (!this.checkRemD(10.5, -7.0, 3.5)) {
            bl = false;
        }
        if (!this.checkRemD(-10.5, 7.0, -3.5)) {
            bl = false;
        }
        if (!this.checkRemD(-10.5, -7.0, -3.5)) {
            bl = false;
        }
        if (!bl) {
            return "remainders failed";
        }
        out.print("double ");
        return null;
    }

    boolean checkClose(String string, double d, double d2) {
        double d3;
        double d4 = d;
        double d5 = d2;
        if (d4 < 0.0) {
            d4 = -d4;
        }
        if (d5 < 0.0) {
            d5 = -d5;
        }
        if ((d3 = d4 > d5 ? d4 : d5) == 0.0) {
            d3 = 1.0;
        }
        if ((d - d2) / d3 > 1.0E-4) {
            out.println(string + " evaluated to: " + d + ", expected: " + d2);
            return false;
        }
        return true;
    }

    String checkMathFcts() {
        out.print("checkMathFcts: ");
        boolean bl = true;
        if (!this.checkClose("log(0.7)", Math.log(0.7), -0.356675)) {
            bl = false;
        }
        if (!this.checkClose("sin(0.7)", Math.sin(0.7), 0.644218)) {
            bl = false;
        }
        if (!this.checkClose("cos(0.7)", Math.cos(0.7), 0.764842)) {
            bl = false;
        }
        if (!this.checkClose("tan(0.7)", Math.tan(0.7), 0.842288)) {
            bl = false;
        }
        if (!this.checkClose("asin(0.7)", Math.asin(0.7), 0.775397)) {
            bl = false;
        }
        if (!this.checkClose("acos(0.7)", Math.acos(0.7), 0.795399)) {
            bl = false;
        }
        if (!this.checkClose("atan(0.7)", Math.atan(0.7), 0.610726)) {
            bl = false;
        }
        if (!bl) {
            return "Some math function failed";
        }
        return null;
    }

    void doIntWhileLoop() {
        for (int i = 0; i != 100000; ++i) {
        }
    }

    void doLongWhileLoop() {
        for (long i = 0L; i != 100000L; ++i) {
        }
    }

    String fiskString() {
        return "fisk";
    }

    int deepRecursion(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        return this.deepRecursion(n - 1, n + n2);
    }

    String testDeepStack() {
        out.print("testDeepStack: ");
        if (this.deepRecursion(5555, 0) != 15431790) {
            return "failed";
        }
        return null;
    }

    String testMisk() {
        out.print("testMisk: ");
        String string = "-9223372036854775808";
        if (!string.equals("-9223372036854775808")) {
            return "(long)1 << 63 failed, returned: -9223372036854775808, should be: " + string;
        }
        if (!this.getClass().getName().equals(new PepTest().getClass().getName())) {
            return "Error(1): strings should have been equal!";
        }
        String string2 = "fisk";
        String string3 = "fisk";
        if (string2 != string3) {
            return "Error(2): strings should be identical!";
        }
        if (this.fiskString() != this.fiskString()) {
            return "Error(3): strings should be identical!";
        }
        if (new Double("3.14") != 3.14) {
            return "Error: Double.valueOf failed on 3.14";
        }
        if (new Double("-23.14") != -23.14) {
            return "Error: Double.valueOf failed on -23.14";
        }
        try {
            string2 = "java.lang.Thread";
            if (!string2.equals(Class.forName(string2).getName())) {
                return "Error(4): strings should be equal!";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    String testGC() {
        out.print("testGC: ");
        byte[][] byArrayArray = new byte[1000][];
        byArrayArray[0] = new byte[1000];
        Runtime.getRuntime().gc();
        if (!byArrayArray[0].getClass().getName().equals("[B")) {
            return "GC swallowed a live object!";
        }
        String string = this.getClass().getName();
        Runtime.getRuntime().gc();
        if (!string.equals(this.getClass().getName())) {
            return "got different class name";
        }
        return null;
    }

    String testRandom() {
        out.print("testRandom : ");
        Random random = new Random(20357846L);
        long l = 0L;
        for (int i = 0; i < 163; ++i) {
            l = random.nextLong();
        }
        long l2 = -2496176611084489277L;
        if (l == l2) {
            return null;
        }
        return "Random value does not match as required ";
    }

    public void instanceMain() {
        this.Verify(this.testIf());
        this.Verify(this.testArray());
        this.Verify(this.testBitOps());
        this.Verify(this.testFor());
        this.Verify(this.testDiv());
        this.Verify(this.testTableSwitch());
        this.Verify(this.testLookupSwitch());
        this.Verify(this.testHiddenField());
        this.Verify(this.checkRemainders());
        this.Verify(this.checkMathFcts());
        this.printPrimes();
        this.Verify(this.testExc1());
        this.Verify(this.testExc2());
        this.Verify(this.testExc3());
        this.Verify(this.testExc4());
        this.Verify(this.testExc5());
        this.Verify(this.testExc6());
        this.Verify(this.testExc7());
        this.Verify(this.loopExitContinueInExceptionHandler());
        this.Verify(this.testStringHash());
        this.Verify(this.testClone());
        this.Verify(this.testObjectArray());
        this.testClass();
        this.Verify(this.checkInstanceOf());
        this.Verify(this.checkInterfaceInstanceOf());
        this.Verify(this.testWaitNull());
        this.Verify(this.testVarAndMethodNameClash());
        this.Verify(this.testMisk());
        this.Verify(this.testGC());
        this.Verify(this.testRandom());
        if (this.gotError) {
            out.println("PepTest: error");
            System.exit(1);
        } else {
            out.println("PepTest: OK");
        }
    }

    public static void main(String[] stringArray) {
        PepTest pepTest = new PepTest();
        pepTest.instanceMain();
        if (pepTest.gotError) {
            System.exit(1);
        }
    }
}

