/*---------------------------------------------------------------------------*\

    Simple time tracking structure.

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __VTTIMER_H__
#define __VTTIMER_H__

//! Simple time tracking class.
class Timer
{
private:

	unsigned long   m_start;


public:

	Timer() : m_start( 0 ) {}

	//! Initialise the timer's starting time.
	void start();

	//! Disable the the timer reporting a time out.
	void stop() { m_start = 0; }

	//! Return @c true if some number of seconds have @a elapsed since @c timer_start().
	bool check_timeout(unsigned int elapsed);

	//! Return @c true if some number of milliseconds have @a elapsed since @c timer_start().
	bool check_timeout_ms(unsigned long elapsedms);
};

#endif	// __VTTIMER_H__

