/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericTypeMatcher<T extends Component>
extends AbstractComponentMatcher {
    private final Class<T> supportedType;

    public GenericTypeMatcher(Class<T> supportedType) {
        this(supportedType, false);
    }

    public GenericTypeMatcher(Class<T> supportedType, boolean requireShowing) {
        super(requireShowing);
        if (supportedType == null) {
            throw new NullPointerException("The supported type should not be null");
        }
        this.supportedType = supportedType;
    }

    @Override
    @RunsInCurrentThread
    public final boolean matches(Component c) {
        if (c == null) {
            return false;
        }
        if (!this.supportedType.isInstance(c)) {
            return false;
        }
        try {
            return this.requireShowingMatches(c) && this.isMatching((Component)this.supportedType.cast(c));
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }

    public final Class<T> supportedType() {
        return this.supportedType;
    }

    @RunsInCurrentThread
    protected abstract boolean isMatching(T var1);
}

