/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.ArrayList;
import java.util.List;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;

public class InstructionSequenceBuilder {
    private final ConstantPoolEditor constantPoolEditor;
    private final List<Instruction> instructions = new ArrayList<Instruction>(256);

    public InstructionSequenceBuilder() {
        this(null, null);
    }

    public InstructionSequenceBuilder(ClassPool classPool, ClassPool classPool2) {
        this(new MyDummyClass(), classPool, classPool2);
    }

    public InstructionSequenceBuilder(ProgramClass programClass) {
        this(new ConstantPoolEditor(programClass));
    }

    public InstructionSequenceBuilder(ProgramClass programClass, ClassPool classPool, ClassPool classPool2) {
        this(new ConstantPoolEditor(programClass, classPool, classPool2));
    }

    public InstructionSequenceBuilder(ConstantPoolEditor constantPoolEditor) {
        this.constantPoolEditor = constantPoolEditor;
    }

    public ConstantPoolEditor getConstantPoolEditor() {
        return this.constantPoolEditor;
    }

    public InstructionSequenceBuilder label(Instruction instruction) {
        return this.appendInstruction(instruction);
    }

    public InstructionSequenceBuilder catch_(Instruction instruction) {
        return this.appendInstruction(instruction);
    }

    public InstructionSequenceBuilder appendInstruction(Instruction instruction) {
        return this.add(instruction);
    }

    public InstructionSequenceBuilder appendInstructions(Instruction[] instructionArray) {
        for (Instruction instruction : instructionArray) {
            this.add(instruction);
        }
        return this;
    }

    public Instruction[] __() {
        return this.instructions();
    }

    public Instruction[] instructions() {
        Instruction[] instructionArray = new Instruction[this.instructions.size()];
        this.instructions.toArray(instructionArray);
        this.instructions.clear();
        return instructionArray;
    }

    public Constant[] constants() {
        ProgramClass programClass = this.constantPoolEditor.getTargetClass();
        Constant[] constantArray = new Constant[programClass.u2constantPoolCount];
        System.arraycopy(programClass.constantPool, 0, constantArray, 0, programClass.u2constantPoolCount);
        programClass.u2constantPoolCount = 0;
        return constantArray;
    }

    public InstructionSequenceBuilder nop() {
        return this.add(new SimpleInstruction(0));
    }

    public InstructionSequenceBuilder aconst_null() {
        return this.add(new SimpleInstruction(1));
    }

    public InstructionSequenceBuilder iconst(int n) {
        return this.add(new SimpleInstruction(3, n));
    }

    public InstructionSequenceBuilder iconst_m1() {
        return this.add(new SimpleInstruction(2));
    }

    public InstructionSequenceBuilder iconst_0() {
        return this.add(new SimpleInstruction(3));
    }

    public InstructionSequenceBuilder iconst_1() {
        return this.add(new SimpleInstruction(4));
    }

    public InstructionSequenceBuilder iconst_2() {
        return this.add(new SimpleInstruction(5));
    }

    public InstructionSequenceBuilder iconst_3() {
        return this.add(new SimpleInstruction(6));
    }

    public InstructionSequenceBuilder iconst_4() {
        return this.add(new SimpleInstruction(7));
    }

    public InstructionSequenceBuilder iconst_5() {
        return this.add(new SimpleInstruction(8));
    }

    public InstructionSequenceBuilder lconst(int n) {
        return this.add(new SimpleInstruction(9, n));
    }

    public InstructionSequenceBuilder lconst_0() {
        return this.add(new SimpleInstruction(9));
    }

    public InstructionSequenceBuilder lconst_1() {
        return this.add(new SimpleInstruction(10));
    }

    public InstructionSequenceBuilder fconst(int n) {
        return this.add(new SimpleInstruction(11, n));
    }

    public InstructionSequenceBuilder fconst_0() {
        return this.add(new SimpleInstruction(11));
    }

    public InstructionSequenceBuilder fconst_1() {
        return this.add(new SimpleInstruction(12));
    }

    public InstructionSequenceBuilder fconst_2() {
        return this.add(new SimpleInstruction(13));
    }

    public InstructionSequenceBuilder dconst(int n) {
        return this.add(new SimpleInstruction(14, n));
    }

    public InstructionSequenceBuilder dconst_0() {
        return this.add(new SimpleInstruction(14));
    }

    public InstructionSequenceBuilder dconst_1() {
        return this.add(new SimpleInstruction(15));
    }

    public InstructionSequenceBuilder bipush(int n) {
        return this.add(new SimpleInstruction(16, n));
    }

    public InstructionSequenceBuilder sipush(int n) {
        return this.add(new SimpleInstruction(17, n));
    }

    public InstructionSequenceBuilder ldc(int n) {
        return this.ldc_(this.constantPoolEditor.addIntegerConstant(n));
    }

    public InstructionSequenceBuilder ldc(float f) {
        return this.ldc_(this.constantPoolEditor.addFloatConstant(f));
    }

    public InstructionSequenceBuilder ldc(Object object) {
        return this.ldc_(this.constantPoolEditor.addPrimitiveArrayConstant(object));
    }

    public InstructionSequenceBuilder ldc(String string) {
        return this.ldc(string, null, null);
    }

    public InstructionSequenceBuilder ldc(String string, Clazz clazz, Method method) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, clazz, method));
    }

    public InstructionSequenceBuilder ldc(String string, Clazz clazz) {
        return this.ldc_(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public InstructionSequenceBuilder ldc_(int n) {
        return this.add(new ConstantInstruction(18, n));
    }

    public InstructionSequenceBuilder ldc_w(int n) {
        return this.ldc_w_(this.constantPoolEditor.addIntegerConstant(n));
    }

    public InstructionSequenceBuilder ldc_w(float f) {
        return this.ldc_w_(this.constantPoolEditor.addFloatConstant(f));
    }

    public InstructionSequenceBuilder ldc_w(String string) {
        return this.ldc_w(string, null, null);
    }

    public InstructionSequenceBuilder ldc_w(String string, Clazz clazz, Method method) {
        return this.ldc_w_(this.constantPoolEditor.addStringConstant(string, clazz, method));
    }

    public InstructionSequenceBuilder ldc_w(String string, Clazz clazz) {
        return this.ldc_w_(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public InstructionSequenceBuilder ldc_w_(int n) {
        return this.add(new ConstantInstruction(19, n));
    }

    public InstructionSequenceBuilder ldc2_w(long l) {
        return this.ldc2_w(this.constantPoolEditor.addLongConstant(l));
    }

    public InstructionSequenceBuilder ldc2_w(double d) {
        return this.ldc2_w(this.constantPoolEditor.addDoubleConstant(d));
    }

    public InstructionSequenceBuilder ldc2_w(int n) {
        return this.add(new ConstantInstruction(20, n));
    }

    public InstructionSequenceBuilder iload(int n) {
        return this.add(new VariableInstruction(21, n));
    }

    public InstructionSequenceBuilder lload(int n) {
        return this.add(new VariableInstruction(22, n));
    }

    public InstructionSequenceBuilder fload(int n) {
        return this.add(new VariableInstruction(23, n));
    }

    public InstructionSequenceBuilder dload(int n) {
        return this.add(new VariableInstruction(24, n));
    }

    public InstructionSequenceBuilder aload(int n) {
        return this.add(new VariableInstruction(25, n));
    }

    public InstructionSequenceBuilder iload_0() {
        return this.add(new VariableInstruction(26));
    }

    public InstructionSequenceBuilder iload_1() {
        return this.add(new VariableInstruction(27));
    }

    public InstructionSequenceBuilder iload_2() {
        return this.add(new VariableInstruction(28));
    }

    public InstructionSequenceBuilder iload_3() {
        return this.add(new VariableInstruction(29));
    }

    public InstructionSequenceBuilder lload_0() {
        return this.add(new VariableInstruction(30));
    }

    public InstructionSequenceBuilder lload_1() {
        return this.add(new VariableInstruction(31));
    }

    public InstructionSequenceBuilder lload_2() {
        return this.add(new VariableInstruction(32));
    }

    public InstructionSequenceBuilder lload_3() {
        return this.add(new VariableInstruction(33));
    }

    public InstructionSequenceBuilder fload_0() {
        return this.add(new VariableInstruction(34));
    }

    public InstructionSequenceBuilder fload_1() {
        return this.add(new VariableInstruction(35));
    }

    public InstructionSequenceBuilder fload_2() {
        return this.add(new VariableInstruction(36));
    }

    public InstructionSequenceBuilder fload_3() {
        return this.add(new VariableInstruction(37));
    }

    public InstructionSequenceBuilder dload_0() {
        return this.add(new VariableInstruction(38));
    }

    public InstructionSequenceBuilder dload_1() {
        return this.add(new VariableInstruction(39));
    }

    public InstructionSequenceBuilder dload_2() {
        return this.add(new VariableInstruction(40));
    }

    public InstructionSequenceBuilder dload_3() {
        return this.add(new VariableInstruction(41));
    }

    public InstructionSequenceBuilder aload_0() {
        return this.add(new VariableInstruction(42));
    }

    public InstructionSequenceBuilder aload_1() {
        return this.add(new VariableInstruction(43));
    }

    public InstructionSequenceBuilder aload_2() {
        return this.add(new VariableInstruction(44));
    }

    public InstructionSequenceBuilder aload_3() {
        return this.add(new VariableInstruction(45));
    }

    public InstructionSequenceBuilder iaload() {
        return this.add(new SimpleInstruction(46));
    }

    public InstructionSequenceBuilder laload() {
        return this.add(new SimpleInstruction(47));
    }

    public InstructionSequenceBuilder faload() {
        return this.add(new SimpleInstruction(48));
    }

    public InstructionSequenceBuilder daload() {
        return this.add(new SimpleInstruction(49));
    }

    public InstructionSequenceBuilder aaload() {
        return this.add(new SimpleInstruction(50));
    }

    public InstructionSequenceBuilder baload() {
        return this.add(new SimpleInstruction(51));
    }

    public InstructionSequenceBuilder caload() {
        return this.add(new SimpleInstruction(52));
    }

    public InstructionSequenceBuilder saload() {
        return this.add(new SimpleInstruction(53));
    }

    public InstructionSequenceBuilder istore(int n) {
        return this.add(new VariableInstruction(54, n));
    }

    public InstructionSequenceBuilder lstore(int n) {
        return this.add(new VariableInstruction(55, n));
    }

    public InstructionSequenceBuilder fstore(int n) {
        return this.add(new VariableInstruction(56, n));
    }

    public InstructionSequenceBuilder dstore(int n) {
        return this.add(new VariableInstruction(57, n));
    }

    public InstructionSequenceBuilder astore(int n) {
        return this.add(new VariableInstruction(58, n));
    }

    public InstructionSequenceBuilder istore_0() {
        return this.add(new VariableInstruction(59));
    }

    public InstructionSequenceBuilder istore_1() {
        return this.add(new VariableInstruction(60));
    }

    public InstructionSequenceBuilder istore_2() {
        return this.add(new VariableInstruction(61));
    }

    public InstructionSequenceBuilder istore_3() {
        return this.add(new VariableInstruction(62));
    }

    public InstructionSequenceBuilder lstore_0() {
        return this.add(new VariableInstruction(63));
    }

    public InstructionSequenceBuilder lstore_1() {
        return this.add(new VariableInstruction(64));
    }

    public InstructionSequenceBuilder lstore_2() {
        return this.add(new VariableInstruction(65));
    }

    public InstructionSequenceBuilder lstore_3() {
        return this.add(new VariableInstruction(66));
    }

    public InstructionSequenceBuilder fstore_0() {
        return this.add(new VariableInstruction(67));
    }

    public InstructionSequenceBuilder fstore_1() {
        return this.add(new VariableInstruction(68));
    }

    public InstructionSequenceBuilder fstore_2() {
        return this.add(new VariableInstruction(69));
    }

    public InstructionSequenceBuilder fstore_3() {
        return this.add(new VariableInstruction(70));
    }

    public InstructionSequenceBuilder dstore_0() {
        return this.add(new VariableInstruction(71));
    }

    public InstructionSequenceBuilder dstore_1() {
        return this.add(new VariableInstruction(72));
    }

    public InstructionSequenceBuilder dstore_2() {
        return this.add(new VariableInstruction(73));
    }

    public InstructionSequenceBuilder dstore_3() {
        return this.add(new VariableInstruction(74));
    }

    public InstructionSequenceBuilder astore_0() {
        return this.add(new VariableInstruction(75));
    }

    public InstructionSequenceBuilder astore_1() {
        return this.add(new VariableInstruction(76));
    }

    public InstructionSequenceBuilder astore_2() {
        return this.add(new VariableInstruction(77));
    }

    public InstructionSequenceBuilder astore_3() {
        return this.add(new VariableInstruction(78));
    }

    public InstructionSequenceBuilder iastore() {
        return this.add(new SimpleInstruction(79));
    }

    public InstructionSequenceBuilder lastore() {
        return this.add(new SimpleInstruction(80));
    }

    public InstructionSequenceBuilder fastore() {
        return this.add(new SimpleInstruction(81));
    }

    public InstructionSequenceBuilder dastore() {
        return this.add(new SimpleInstruction(82));
    }

    public InstructionSequenceBuilder aastore() {
        return this.add(new SimpleInstruction(83));
    }

    public InstructionSequenceBuilder bastore() {
        return this.add(new SimpleInstruction(84));
    }

    public InstructionSequenceBuilder castore() {
        return this.add(new SimpleInstruction(85));
    }

    public InstructionSequenceBuilder sastore() {
        return this.add(new SimpleInstruction(86));
    }

    public InstructionSequenceBuilder pop() {
        return this.add(new SimpleInstruction(87));
    }

    public InstructionSequenceBuilder pop2() {
        return this.add(new SimpleInstruction(88));
    }

    public InstructionSequenceBuilder dup() {
        return this.add(new SimpleInstruction(89));
    }

    public InstructionSequenceBuilder dup_x1() {
        return this.add(new SimpleInstruction(90));
    }

    public InstructionSequenceBuilder dup_x2() {
        return this.add(new SimpleInstruction(91));
    }

    public InstructionSequenceBuilder dup2() {
        return this.add(new SimpleInstruction(92));
    }

    public InstructionSequenceBuilder dup2_x1() {
        return this.add(new SimpleInstruction(93));
    }

    public InstructionSequenceBuilder dup2_x2() {
        return this.add(new SimpleInstruction(94));
    }

    public InstructionSequenceBuilder swap() {
        return this.add(new SimpleInstruction(95));
    }

    public InstructionSequenceBuilder iadd() {
        return this.add(new SimpleInstruction(96));
    }

    public InstructionSequenceBuilder ladd() {
        return this.add(new SimpleInstruction(97));
    }

    public InstructionSequenceBuilder fadd() {
        return this.add(new SimpleInstruction(98));
    }

    public InstructionSequenceBuilder dadd() {
        return this.add(new SimpleInstruction(99));
    }

    public InstructionSequenceBuilder isub() {
        return this.add(new SimpleInstruction(100));
    }

    public InstructionSequenceBuilder lsub() {
        return this.add(new SimpleInstruction(101));
    }

    public InstructionSequenceBuilder fsub() {
        return this.add(new SimpleInstruction(102));
    }

    public InstructionSequenceBuilder dsub() {
        return this.add(new SimpleInstruction(103));
    }

    public InstructionSequenceBuilder imul() {
        return this.add(new SimpleInstruction(104));
    }

    public InstructionSequenceBuilder lmul() {
        return this.add(new SimpleInstruction(105));
    }

    public InstructionSequenceBuilder fmul() {
        return this.add(new SimpleInstruction(106));
    }

    public InstructionSequenceBuilder dmul() {
        return this.add(new SimpleInstruction(107));
    }

    public InstructionSequenceBuilder idiv() {
        return this.add(new SimpleInstruction(108));
    }

    public InstructionSequenceBuilder ldiv() {
        return this.add(new SimpleInstruction(109));
    }

    public InstructionSequenceBuilder fdiv() {
        return this.add(new SimpleInstruction(110));
    }

    public InstructionSequenceBuilder ddiv() {
        return this.add(new SimpleInstruction(111));
    }

    public InstructionSequenceBuilder irem() {
        return this.add(new SimpleInstruction(112));
    }

    public InstructionSequenceBuilder lrem() {
        return this.add(new SimpleInstruction(113));
    }

    public InstructionSequenceBuilder frem() {
        return this.add(new SimpleInstruction(114));
    }

    public InstructionSequenceBuilder drem() {
        return this.add(new SimpleInstruction(115));
    }

    public InstructionSequenceBuilder ineg() {
        return this.add(new SimpleInstruction(116));
    }

    public InstructionSequenceBuilder lneg() {
        return this.add(new SimpleInstruction(117));
    }

    public InstructionSequenceBuilder fneg() {
        return this.add(new SimpleInstruction(118));
    }

    public InstructionSequenceBuilder dneg() {
        return this.add(new SimpleInstruction(119));
    }

    public InstructionSequenceBuilder ishl() {
        return this.add(new SimpleInstruction(120));
    }

    public InstructionSequenceBuilder lshl() {
        return this.add(new SimpleInstruction(121));
    }

    public InstructionSequenceBuilder ishr() {
        return this.add(new SimpleInstruction(122));
    }

    public InstructionSequenceBuilder lshr() {
        return this.add(new SimpleInstruction(123));
    }

    public InstructionSequenceBuilder iushr() {
        return this.add(new SimpleInstruction(124));
    }

    public InstructionSequenceBuilder lushr() {
        return this.add(new SimpleInstruction(125));
    }

    public InstructionSequenceBuilder iand() {
        return this.add(new SimpleInstruction(126));
    }

    public InstructionSequenceBuilder land() {
        return this.add(new SimpleInstruction(127));
    }

    public InstructionSequenceBuilder ior() {
        return this.add(new SimpleInstruction(-128));
    }

    public InstructionSequenceBuilder lor() {
        return this.add(new SimpleInstruction(-127));
    }

    public InstructionSequenceBuilder ixor() {
        return this.add(new SimpleInstruction(-126));
    }

    public InstructionSequenceBuilder lxor() {
        return this.add(new SimpleInstruction(-125));
    }

    public InstructionSequenceBuilder iinc(int n, int n2) {
        return this.add(new VariableInstruction(-124, n, n2));
    }

    public InstructionSequenceBuilder i2l() {
        return this.add(new SimpleInstruction(-123));
    }

    public InstructionSequenceBuilder i2f() {
        return this.add(new SimpleInstruction(-122));
    }

    public InstructionSequenceBuilder i2d() {
        return this.add(new SimpleInstruction(-121));
    }

    public InstructionSequenceBuilder l2i() {
        return this.add(new SimpleInstruction(-120));
    }

    public InstructionSequenceBuilder l2f() {
        return this.add(new SimpleInstruction(-119));
    }

    public InstructionSequenceBuilder l2d() {
        return this.add(new SimpleInstruction(-118));
    }

    public InstructionSequenceBuilder f2i() {
        return this.add(new SimpleInstruction(-117));
    }

    public InstructionSequenceBuilder f2l() {
        return this.add(new SimpleInstruction(-116));
    }

    public InstructionSequenceBuilder f2d() {
        return this.add(new SimpleInstruction(-115));
    }

    public InstructionSequenceBuilder d2i() {
        return this.add(new SimpleInstruction(-114));
    }

    public InstructionSequenceBuilder d2l() {
        return this.add(new SimpleInstruction(-113));
    }

    public InstructionSequenceBuilder d2f() {
        return this.add(new SimpleInstruction(-112));
    }

    public InstructionSequenceBuilder i2b() {
        return this.add(new SimpleInstruction(-111));
    }

    public InstructionSequenceBuilder i2c() {
        return this.add(new SimpleInstruction(-110));
    }

    public InstructionSequenceBuilder i2s() {
        return this.add(new SimpleInstruction(-109));
    }

    public InstructionSequenceBuilder lcmp() {
        return this.add(new SimpleInstruction(-108));
    }

    public InstructionSequenceBuilder fcmpl() {
        return this.add(new SimpleInstruction(-107));
    }

    public InstructionSequenceBuilder fcmpg() {
        return this.add(new SimpleInstruction(-106));
    }

    public InstructionSequenceBuilder dcmpl() {
        return this.add(new SimpleInstruction(-105));
    }

    public InstructionSequenceBuilder dcmpg() {
        return this.add(new SimpleInstruction(-104));
    }

    public InstructionSequenceBuilder ifeq(int n) {
        return this.add(new BranchInstruction(-103, n));
    }

    public InstructionSequenceBuilder ifne(int n) {
        return this.add(new BranchInstruction(-102, n));
    }

    public InstructionSequenceBuilder iflt(int n) {
        return this.add(new BranchInstruction(-101, n));
    }

    public InstructionSequenceBuilder ifge(int n) {
        return this.add(new BranchInstruction(-100, n));
    }

    public InstructionSequenceBuilder ifgt(int n) {
        return this.add(new BranchInstruction(-99, n));
    }

    public InstructionSequenceBuilder ifle(int n) {
        return this.add(new BranchInstruction(-98, n));
    }

    public InstructionSequenceBuilder ificmpeq(int n) {
        return this.add(new BranchInstruction(-97, n));
    }

    public InstructionSequenceBuilder ificmpne(int n) {
        return this.add(new BranchInstruction(-96, n));
    }

    public InstructionSequenceBuilder ificmplt(int n) {
        return this.add(new BranchInstruction(-95, n));
    }

    public InstructionSequenceBuilder ificmpge(int n) {
        return this.add(new BranchInstruction(-94, n));
    }

    public InstructionSequenceBuilder ificmpgt(int n) {
        return this.add(new BranchInstruction(-93, n));
    }

    public InstructionSequenceBuilder ificmple(int n) {
        return this.add(new BranchInstruction(-92, n));
    }

    public InstructionSequenceBuilder ifacmpeq(int n) {
        return this.add(new BranchInstruction(-91, n));
    }

    public InstructionSequenceBuilder ifacmpne(int n) {
        return this.add(new BranchInstruction(-90, n));
    }

    public InstructionSequenceBuilder goto_(int n) {
        return this.add(new BranchInstruction(-89, n));
    }

    public InstructionSequenceBuilder jsr(int n) {
        return this.add(new BranchInstruction(-88, n));
    }

    public InstructionSequenceBuilder ret(int n) {
        return this.add(new VariableInstruction(-87, n));
    }

    public InstructionSequenceBuilder tableswitch(int n, int n2, int n3, int[] nArray) {
        return this.add(new TableSwitchInstruction(-86, n, n2, n3, nArray));
    }

    public InstructionSequenceBuilder lookupswitch(int n, int[] nArray, int[] nArray2) {
        return this.add(new LookUpSwitchInstruction(-85, n, nArray, nArray2));
    }

    public InstructionSequenceBuilder ireturn() {
        return this.add(new SimpleInstruction(-84));
    }

    public InstructionSequenceBuilder lreturn() {
        return this.add(new SimpleInstruction(-83));
    }

    public InstructionSequenceBuilder freturn() {
        return this.add(new SimpleInstruction(-82));
    }

    public InstructionSequenceBuilder dreturn() {
        return this.add(new SimpleInstruction(-81));
    }

    public InstructionSequenceBuilder areturn() {
        return this.add(new SimpleInstruction(-80));
    }

    public InstructionSequenceBuilder return_() {
        return this.add(new SimpleInstruction(-79));
    }

    public InstructionSequenceBuilder getstatic(Clazz clazz, Member member) {
        return this.getstatic(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder getstatic(String string, String string2, String string3) {
        return this.getstatic(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder getstatic(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.getstatic(this.constantPoolEditor.addFieldrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder getstatic(int n) {
        return this.add(new ConstantInstruction(-78, n));
    }

    public InstructionSequenceBuilder putstatic(Clazz clazz, Member member) {
        return this.putstatic(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder putstatic(String string, String string2, String string3) {
        return this.putstatic(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder putstatic(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.putstatic(this.constantPoolEditor.addFieldrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder putstatic(int n) {
        return this.add(new ConstantInstruction(-77, n));
    }

    public InstructionSequenceBuilder getfield(Clazz clazz, Member member) {
        return this.getfield(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder getfield(String string, String string2, String string3) {
        return this.getfield(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder getfield(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.getfield(this.constantPoolEditor.addFieldrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder getfield(int n) {
        return this.add(new ConstantInstruction(-76, n));
    }

    public InstructionSequenceBuilder putfield(Clazz clazz, Member member) {
        return this.putfield(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder putfield(String string, String string2, String string3) {
        return this.putfield(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder putfield(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.putfield(this.constantPoolEditor.addFieldrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder putfield(int n) {
        return this.add(new ConstantInstruction(-75, n));
    }

    public InstructionSequenceBuilder invokevirtual(Clazz clazz, Member member) {
        return this.invokevirtual(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder invokevirtual(String string, String string2, String string3) {
        return this.invokevirtual(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder invokevirtual(int n, String string, String string2) {
        return this.invokevirtual(this.constantPoolEditor.addMethodrefConstant(n, string, string2, null, null));
    }

    public InstructionSequenceBuilder invokevirtual(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokevirtual(this.constantPoolEditor.addMethodrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder invokevirtual(int n) {
        return this.add(new ConstantInstruction(-74, n));
    }

    public InstructionSequenceBuilder invokespecial(String string, String string2, String string3) {
        return this.invokespecial(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder invokespecial(Clazz clazz, Member member) {
        return this.invokespecial(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder invokespecial(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokespecial(this.constantPoolEditor.addMethodrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder invokespecial_interface(String string, String string2, String string3) {
        return this.invokespecial_interface(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder invokespecial_interface(Clazz clazz, Member member) {
        return this.invokespecial_interface(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder invokespecial_interface(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokespecial(this.constantPoolEditor.addInterfaceMethodrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder invokespecial(int n) {
        return this.add(new ConstantInstruction(-73, n));
    }

    public InstructionSequenceBuilder invokestatic(Clazz clazz, Member member) {
        return this.invokestatic(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder invokestatic(String string, String string2, String string3) {
        return this.invokestatic(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder invokestatic(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokestatic(this.constantPoolEditor.addMethodrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder invokestatic_interface(String string, String string2, String string3) {
        return this.invokestatic_interface(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder invokestatic_interface(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokestatic(this.constantPoolEditor.addInterfaceMethodrefConstant(string, string2, string3, clazz, member));
    }

    public InstructionSequenceBuilder invokestatic(int n) {
        return this.add(new ConstantInstruction(-72, n));
    }

    public InstructionSequenceBuilder invokeinterface(Clazz clazz, Member member) {
        return this.invokeinterface(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public InstructionSequenceBuilder invokeinterface(String string, String string2, String string3) {
        return this.invokeinterface(string, string2, string3, null, null);
    }

    public InstructionSequenceBuilder invokeinterface(String string, String string2, String string3, Clazz clazz, Member member) {
        int n = ClassUtil.internalMethodParameterSize(string3, false) << 8;
        return this.invokeinterface(this.constantPoolEditor.addInterfaceMethodrefConstant(string, string2, string3, clazz, member), n);
    }

    public InstructionSequenceBuilder invokeinterface(int n, int n2) {
        return this.add(new ConstantInstruction(-71, n, n2));
    }

    public InstructionSequenceBuilder invokedynamic(int n, String string, String string2) {
        return this.invokedynamic(n, string, string2, null);
    }

    public InstructionSequenceBuilder invokedynamic(int n, String string, String string2, Clazz[] clazzArray) {
        return this.invokedynamic(this.constantPoolEditor.addInvokeDynamicConstant(n, string, string2, clazzArray));
    }

    public InstructionSequenceBuilder invokedynamic(int n) {
        return this.add(new ConstantInstruction(-70, n));
    }

    public InstructionSequenceBuilder new_(String string) {
        return this.new_(string, null);
    }

    public InstructionSequenceBuilder new_(String string, Clazz clazz) {
        return this.new_(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public InstructionSequenceBuilder new_(int n) {
        return this.add(new ConstantInstruction(-69, n));
    }

    public InstructionSequenceBuilder newarray(int n) {
        return this.add(new SimpleInstruction(-68, n));
    }

    public InstructionSequenceBuilder anewarray(String string, Clazz clazz) {
        return this.anewarray(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public InstructionSequenceBuilder anewarray(int n) {
        return this.add(new ConstantInstruction(-67, n));
    }

    public InstructionSequenceBuilder arraylength() {
        return this.add(new SimpleInstruction(-66));
    }

    public InstructionSequenceBuilder athrow() {
        return this.add(new SimpleInstruction(-65));
    }

    public InstructionSequenceBuilder checkcast(String string) {
        return this.checkcast(string, null);
    }

    public InstructionSequenceBuilder checkcast(String string, Clazz clazz) {
        return this.checkcast(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public InstructionSequenceBuilder checkcast(int n) {
        return this.add(new ConstantInstruction(-64, n));
    }

    public InstructionSequenceBuilder instanceof_(String string, Clazz clazz) {
        return this.instanceof_(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public InstructionSequenceBuilder instanceof_(int n) {
        return this.add(new ConstantInstruction(-63, n));
    }

    public InstructionSequenceBuilder monitorenter() {
        return this.add(new SimpleInstruction(-62));
    }

    public InstructionSequenceBuilder monitorexit() {
        return this.add(new SimpleInstruction(-61));
    }

    public InstructionSequenceBuilder wide() {
        return this.add(new SimpleInstruction(-60));
    }

    public InstructionSequenceBuilder multianewarray(String string, Clazz clazz) {
        return this.multianewarray(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public InstructionSequenceBuilder multianewarray(int n) {
        return this.add(new ConstantInstruction(-59, n));
    }

    public InstructionSequenceBuilder ifnull(int n) {
        return this.add(new BranchInstruction(-58, n));
    }

    public InstructionSequenceBuilder ifnonnull(int n) {
        return this.add(new BranchInstruction(-57, n));
    }

    public InstructionSequenceBuilder goto_w(int n) {
        return this.add(new BranchInstruction(-56, n));
    }

    public InstructionSequenceBuilder jsr_w(int n) {
        return this.add(new BranchInstruction(-55, n));
    }

    public InstructionSequenceBuilder pushPrimitive(Object object, char c) {
        switch (c) {
            case 'Z': {
                return (Boolean)object != false ? this.iconst_1() : this.iconst_0();
            }
            case 'B': 
            case 'I': 
            case 'S': {
                return this.pushInt(((Number)object).intValue());
            }
            case 'C': {
                return this.ldc(((Character)object).charValue());
            }
            case 'J': {
                return this.ldc2_w((Long)object);
            }
            case 'F': {
                return this.ldc(((Float)object).floatValue());
            }
            case 'D': {
                return this.ldc2_w((Double)object);
            }
        }
        throw new IllegalArgumentException("" + c);
    }

    public InstructionSequenceBuilder pushInt(int n) {
        return n >= -1 && n <= 5 ? this.iconst(n) : (n == (byte)n ? this.bipush(n) : (n == (short)n ? this.sipush(n) : this.ldc(n)));
    }

    public InstructionSequenceBuilder pushFloat(float f) {
        return f == 0.0f || f == 1.0f ? this.fconst((int)f) : this.ldc(f);
    }

    public InstructionSequenceBuilder pushLong(long l) {
        return l == 0L || l == 1L ? this.lconst((int)l) : this.ldc2_w(l);
    }

    public InstructionSequenceBuilder pushDouble(double d) {
        return d == 0.0 || d == 1.0 ? this.dconst((int)d) : this.ldc2_w(d);
    }

    public InstructionSequenceBuilder pushNewArray(String string, int n) {
        this.pushInt(n);
        return ClassUtil.isInternalPrimitiveType(string) ? this.newarray(InstructionUtil.arrayTypeFromInternalType(string.charAt(0))) : this.anewarray(string, null);
    }

    public InstructionSequenceBuilder load(int n, String string) {
        return this.load(n, string.charAt(0));
    }

    public InstructionSequenceBuilder load(int n, char c) {
        switch (c) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.iload(n);
            }
            case 'J': {
                return this.lload(n);
            }
            case 'F': {
                return this.fload(n);
            }
            case 'D': {
                return this.dload(n);
            }
        }
        return this.aload(n);
    }

    public InstructionSequenceBuilder store(int n, String string) {
        return this.store(n, string.charAt(0));
    }

    public InstructionSequenceBuilder store(int n, char c) {
        switch (c) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.istore(n);
            }
            case 'J': {
                return this.lstore(n);
            }
            case 'F': {
                return this.fstore(n);
            }
            case 'D': {
                return this.dstore(n);
            }
        }
        return this.astore(n);
    }

    public InstructionSequenceBuilder storeToArray(String string) {
        switch (string.charAt(0)) {
            case 'B': 
            case 'Z': {
                return this.bastore();
            }
            case 'C': {
                return this.castore();
            }
            case 'S': {
                return this.sastore();
            }
            case 'I': {
                return this.iastore();
            }
            case 'J': {
                return this.lastore();
            }
            case 'F': {
                return this.fastore();
            }
            case 'D': {
                return this.dastore();
            }
        }
        return this.aastore();
    }

    private InstructionSequenceBuilder add(Instruction instruction) {
        this.instructions.add(instruction);
        return this;
    }

    public static void main(String[] stringArray) {
        InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder();
        Instruction[] instructionArray = instructionSequenceBuilder.iconst_2().istore_0().iinc(0, 2).iload_0().ldc(12).iadd().putstatic("com/example/SomeClass", "someField", "I", null, null).instructions();
        Constant[] constantArray = instructionSequenceBuilder.constants();
        for (Instruction instruction : instructionArray) {
            System.out.println(instruction);
        }
        System.out.println();
        for (int i = 0; i < constantArray.length; ++i) {
            System.out.println("#" + i + ": " + constantArray[i]);
        }
    }

    private static class MyDummyClass
    extends ProgramClass {
        public MyDummyClass() {
            super(2949123, 1, new Constant[256], 0, 0, 0);
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

