/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.util.SimplifiedVisitor;

public class UnreachableExceptionRemover
extends SimplifiedVisitor
implements AttributeVisitor,
ExceptionInfoVisitor {
    private final ExceptionInfoVisitor extraExceptionInfoVisitor;

    public UnreachableExceptionRemover() {
        this(null);
    }

    public UnreachableExceptionRemover(ExceptionInfoVisitor exceptionInfoVisitor) {
        this.extraExceptionInfoVisitor = exceptionInfoVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.exceptionsAccept(clazz, method, this);
        codeAttribute.u2exceptionTableLength = this.removeEmptyExceptions(codeAttribute.exceptionTable, codeAttribute.u2exceptionTableLength);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (!this.mayThrowExceptions(clazz, method, codeAttribute, exceptionInfo.u2startPC, exceptionInfo.u2endPC)) {
            exceptionInfo.u2endPC = exceptionInfo.u2startPC;
            if (this.extraExceptionInfoVisitor != null) {
                this.extraExceptionInfoVisitor.visitExceptionInfo(clazz, method, codeAttribute, exceptionInfo);
            }
        }
    }

    private boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        Instruction instruction;
        byte[] byArray = codeAttribute.code;
        for (int i = n; i < n2; i += instruction.length(i)) {
            instruction = InstructionFactory.create(byArray, i);
            if (!instruction.mayThrowExceptions()) continue;
            return true;
        }
        return false;
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ExceptionInfo exceptionInfo = exceptionInfoArray[i];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfoArray[n2++] = exceptionInfo;
        }
        return n2;
    }
}

