/***************************************************************************
                            KContainerLayout.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Alternative Layout manager widget.
 Here is an example of using this class:

 See {@link KContainerLayoutSignals} for signals emitted by KContainerLayout.

 See {@link KContainerLayoutEventHandling} for event handlers to override in subclasses of KContainerLayout.

 @author Jorge Monteiro <jomo@casema.net>

 @version 0.1
 
 @short 
 Alternative Layout manager widget.
*/
public class KContainerLayout extends QFrame  {
	protected KContainerLayout(Class dummy){super((Class) null);}


/** 
 Constructs a KContainerLayout as child of parent

*/
	private native void newKContainerLayout( QWidget parent, String name, int orientation, boolean homogeneos, int spacing, int f, boolean allowLines);
	public KContainerLayout( QWidget parent, String name, int orientation, boolean homogeneos, int spacing, int f, boolean allowLines) {
		super((Class) null);
		newKContainerLayout( parent, name, orientation, homogeneos, spacing, f, allowLines);
	}
	public KContainerLayout( QWidget parent, String name) {
		this( parent, name, KContainerLayout.Horizontal, false, 5, 0, true);
	}
	public KContainerLayout( QWidget parent) {
		this( parent, null, KContainerLayout.Horizontal, false, 5, 0, true);
	}
	private native void newKContainerLayout();
	public KContainerLayout() {
		super((Class) null);
		newKContainerLayout();
	}

/** 
 The destructor
     
*/
	protected native void finalize() throws InternalError;

/** 
 Returns the number of widgets inside this container
     
*/
	public native int getNumberOfWidgets();

/** 
 Pack one widget to the start of the container after the previously packed on start widgets

*/
	public native int packStart( QWidget w, boolean e, boolean f, int p);
	public int packStart( QWidget w, boolean e, boolean f) {
		return packStart(w, e, f, 1);
	}
	public int packStart( QWidget w, boolean e) {
		return packStart(w, e, false, 1);
	}
	public native int packStart( QWidget w);

/** 
 Pack one widget to the end of the container after the previously packed on end widgets

*/
	public native int packEnd( QWidget w, boolean e, boolean f, int p);
	public int packEnd( QWidget w, boolean e, boolean f) {
		return packEnd(w, e, f, 1);
	}
	public int packEnd( QWidget w, boolean e) {
		return packEnd(w, e, false, 1);
	}
	public native int packEnd( QWidget w);

/**
 Sets the orientation of the container, one of KContainerLayout.Horizontal or KContainer.Vertical
     
*/
	public native void setOrientation( int i);

/** 
 Sets the container to use the same size to each widget he contains (TRUE) or not (FALSE)
 When homogeneous is true all widgets will be packed as if they had the Expand set to TRUE

*/
	public native void setHomogeneos( boolean b);
	public native void setSpacing( int i);

/** 
 Sets the starting offset for this container 

*/
	public native void setStartOffset( int i);

/** 
 Sets the ending offset for this container 

*/
	public native void setEndOffset( int i);

/** 
 Returns the current orientation of the container 

*/
	public native int orientation();

/** 
 Returns the current homogeneous state of the container 

*/
	public native boolean homogeneos();

/** 
 Returns the current spacing of the container

*/
	public native int spacing();

/** 
 Returns the starting offset for this container 

*/
	public native int startOffset();

/** 
 Returns the ending offset for this container

*/
	public native int endOffset();

/** 
 Resizes the container to be as small as necessary to display
 all widgets
     
*/
	public native void sizeToFit();

/** 
 Calculates the size necessary to display all widgets
     
*/
	protected native void recalcLayout();

/** 
 Returns the size necessary for the widget represented by this
 KContainerLayoutItem
     
*/
//	protected native QSize widgetSize( KContainerLayoutItem item);

/** 
 Reposition all widgets on the container.
     
*/
	protected native void repositionWidgets();

/** 
 Returns the number of widgets that share the extra space on
 the container.
     
*/
	protected native int numberOfWidgetsWithExpand();

/** 
 Calculate our size hint based on the sizeHint() of all out
 widgets, on our properties - expand and homogeneous, and on the
 KContainerLayoutItem properties.

*/
	protected native void calculateSizeHint();

/** 
 Return the size necessary by the largest widget on the container.
     
*/
	protected native QSize sizeOfLargerWidget();

/** 
 Returns the ideal size for the widget represented by this
 KContainerLayoutItem.
     
*/
//	protected native QSize idealSizeOfWidget( KContainerLayoutItem item);

/** 
 Return TRUE if this is an horizontal container.
     
*/
	protected native boolean horizontal();

/** 
 Used to filter resize events from our parent if it isn't a
 KContainerLayout.
     
*/
	public native boolean eventFilter( QObject arg1, QEvent ev);

/** 
 Returns our size hint. The size necessary to display this container.
     
*/
	public native QSize sizeHint();
	public static final int Horizontal = 0;
	public static final int Vertical = 1;
}
