/***************************************************************************
                            KKeyDialog.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KKeyDialog class is used for configuring dictionaries of key/action
 associations for KAccel and KGlobalAccel. It uses the KKeyChooser widget
 and offers buttons to set all keys to defaults and invoke on-line help.

 Three static methods are supplied which provide the most convienient interface
 to the dialog. For example you could use KAccel and KKeyDialog like this

 <pre>
 KAccel keys;

 keys.insertItem( i18n( "Zoom in" ), "Zoom in", "+" );
 keys.connectItem( "Zoom in", myWindow, SLOT(" zoomIn()") );

 keys.connectItem( KAccel.Print, myWindow, SLOT(" print()") );

 keys.readSettings();

 if( KKeyDialog.configureKeys( &keys ) ) {
	      ...
 }
 </pre>

 This will also implicitly save the settings. If you don't want this,
 you can call

 <pre>
 if( KKeyDialog.configureKeys( &keys, false ) ) { // do not save settings
	      ...
 }
 </pre>

 For XML-UI applications, this is much simpler. All you need to do is
 <pre>
 KKeyDialog.configureKeys(actionCollection(), xmlFile());
 </pre>

 See {@link KKeyDialogSignals} for signals emitted by KKeyDialog.

 See {@link KKeyDialogEventHandling} for event handlers to override in subclasses of KKeyDialog.

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: KKeyDialog.java,v 1.3.2.1 2001/08/29 23:14:10 rdale Exp $

 @short Dialog for configuration of @ref KAccel and @ref KGlobalAccel.

*/
public class KKeyDialog extends KDialogBase  {
	protected KKeyDialog(Class dummy){super((Class) null);}

//	private native void newKKeyDialog( KKeyEntryMap aKeyDict, QWidget parent, boolean check_against_std_keys);
//	public KKeyDialog( KKeyEntryMap aKeyDict, QWidget parent, boolean check_against_std_keys) {
//		super((Class) null);
//		newKKeyDialog( aKeyDict, parent, check_against_std_keys);
//	}
//	private native void newKKeyDialog( KKeyEntryMap aKeyDict);
//	public KKeyDialog( KKeyEntryMap aKeyDict) {
//		super((Class) null);
//		newKKeyDialog( aKeyDict);
//	}
//	protected native void finalize() throws InternalError;

/** 
 Configure key settings, from a KAccel object.

*/
	public static native int configureKeys( KAccel keys, boolean save_settings, QWidget parent);
	public static native int configureKeys( KAccel keys);

/** 
 Configure key settings, from a KGlobalAccel object.

*/
	public static native int configureKeys( KGlobalAccel keys, boolean save_settings, QWidget parent);
	public static native int configureKeys( KGlobalAccel keys);

/** 
 Configure key settings, from an action collection (for XMLGUI based applications).

*/
	public static native int configureKeys( KActionCollection coll, String xmlfile, boolean save_settings, QWidget parent);
	public static native int configureKeys( KActionCollection coll, String xmlfile);
}
