//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QDataStream;
import java.util.ArrayList;

/**

 Information about I/O (Internet, etc.) protocols supported by KDE.
 This class is useful if you want to know which protocols
 KDE supports. In addition you can find out lots of information
 about a certain protocol. A KProtocolInfo instance represents a
 single protocol. Most of the functionality is provided by the static
 methods that scan the .protocol files of all installed kioslaves to get
 this information.
 .protocol files are installed in the "services" resource.
		@author Torben Weis <weis@kde.org>
 
		@short    Information about I/O (Internet, etc.

*/
public class KProtocolInfo extends KSycocaEntry  {
	protected KProtocolInfo(Class dummy){super((Class) null);}
	/**	
		 Describes the type of a protocol.
		   		@short    Describes the type of a protocol.
	*/
	public static final int T_STREAM = 0;
	public static final int T_FILESYSTEM = 1;
	public static final int T_NONE = 2;
	public static final int T_ERROR = 3;

	/**	
		 Read a protocol description file
			@param path the path of the description file
		   		@short    Read a protocol description file
	*/
	public KProtocolInfo(String path) {
		super((Class) null);
		newKProtocolInfo(path);
	}
	private native void newKProtocolInfo(String path);
	/**	
		 Returns whether the protocol description file is valid.
				@return true if valid, false otherwise
   
		@short    Returns whether the protocol description file is valid.
	*/
	public native boolean isValid();
	/**	
		 Returns the name of the protocol.
			 This corresponds to the "protocol=" field in the protocol description file.
				@return the name of the protocol

		@short    Returns the name of the protocol.
		@see KURL#protocol
	*/
	public native String name();
	/**	
			   		@short
	*/
	public KProtocolInfo(QDataStream _str, int offset) {
		super((Class) null);
		newKProtocolInfo(_str,offset);
	}
	private native void newKProtocolInfo(QDataStream _str, int offset);
	/**	
			 Load the protocol info from a stream.
		   		@short
	*/
	public native void load(QDataStream arg1);
	/**	
			 Save the protocol info to a stream.
		   		@short
	*/
	public native void save(QDataStream arg1);
	/**	
		 Returns list of all known protocols.
				@return a list of all known protocols
   
		@short    Returns list of all known protocols.
	*/
	public static native ArrayList protocols();
	/**	
		 Returns whether a protocol is installed that is able to handle <code>url.</code>
			@param url the url to check
				@return true if the protocol is known

		@short    Returns whether a protocol is installed that is able to handle <code>url.</code>
		@see #name
	*/
	public static native boolean isKnownProtocol(KURL url);
	/**	
		 Same as above except you can supply just the protocol instead of
		 the whole URL.
		   		@short    Same as above except you can supply just the protocol instead of  the whole URL.
	*/
	public static native boolean isKnownProtocol(String protocol);
	/**	
		 Returns the library / executable to open for the protocol <code>protocol</code>
		 Example : "kio_ftp", meaning either the executable "kio_ftp" or
		 the library "kio_ftp.la" (recommended), whichever is available.
			 This corresponds to the "exec=" field in the protocol description file.
			@param protocol the protocol to check
				@return the executable of library to open, or null for
         unsupported protocols

		@short    Returns the library / executable to open for the protocol <code>protocol</code>  Example : "kio_ftp", meaning either the executable "kio_ftp" or  the library "kio_ftp.
		@see KURL#protocol
	*/
	public static native String exec(String protocol);
	/**	
		 Returns whether the protocol should be treated as a filesystem
		 or as a stream when reading from it.
			 This corresponds to the "input=" field in the protocol description file.
		 Valid values for this field are "filesystem", "stream" or "none" (default).
			@param url the url to check
				@return the input type of the given <code>url</code>
   
		@short    Returns whether the protocol should be treated as a filesystem  or as a stream when reading from it.
	*/
	public static native int inputType(KURL url);
	/**	
		 Returns whether the protocol should be treated as a filesystem
		 or as a stream when writing to it.
			 This corresponds to the "output=" field in the protocol description file.
		 Valid values for this field are "filesystem", "stream" or "none" (default).
			@param url the url to check
				@return the output type of the given <code>url</code>
   
		@short    Returns whether the protocol should be treated as a filesystem  or as a stream when writing to it.
	*/
	public static native int outputType(KURL url);
	/**	
		 Returns the list of fields this protocol returns when listing
		 The current possibilities are
		 Name, Type, Size, Date, AccessDate, Access, Owner, Group, Link, URL, MimeType
		 as well as Extra1, Extra2 etc. for extra fields (see extraFields).
			 This corresponds to the "listing=" field in the protocol description file.
		 The supported fields should be separated with ',' in the protocol description file.
			@param url the url to check
				@return a list of field names
   
		@short    Returns the list of fields this protocol returns when listing  The current possibilities are  Name, Type, Size, Date, AccessDate, Access, Owner, Group, Link, URL, MimeType  as well as Extra1, Extra2 etc.
	*/
	public static native ArrayList listing(KURL url);
	/**	
		 Definition of extra fields in the UDS entries, returned by a listDir operation.
			 This corresponds to the "ExtraNames=" and "ExtraTypes=" fields in the protocol description file.
		 Those two lists should be separated with ',' in the protocol description file.
		 See ExtraField for details about names and types
				@short    Definition of extra fields in the UDS entries, returned by a listDir operation.
	*/
	// KProtocolInfo::ExtraFieldList extraFields(const KURL& arg1); >>>> NOT CONVERTED
	/**	
		 Returns whether the protocol can act as a source protocol.
			 A source protocol retrieves data from or stores data to the
		 location specified by a URL.
		 A source protocol is the opposite of a filter protocol.
			 The "source=" field in the protocol description file determines
		 whether a protocol is a source protocol or a filter protocol.
			@param url the url to check
				@return true if the protocol is a source of data (e.g. http), false if the
         protocol is a filter (e.g. gzip)
   
		@short    Returns whether the protocol can act as a source protocol.
	*/
	public static native boolean isSourceProtocol(KURL url);
	/**	
		 Returns whether the protocol can act as a helper protocol.
		 A helper protocol invokes an external application and does not return
		 a file or stream.
			 This corresponds to the "helper=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol is a helper protocol (e.g. vnc), false
              if not (e.g. http)
   
		@short    Returns whether the protocol can act as a helper protocol.
	*/
	public static native boolean isHelperProtocol(KURL url);
	/**	
		 Same as above except you can supply just the protocol instead of
		 the whole URL.
		   		@short    Same as above except you can supply just the protocol instead of  the whole URL.
	*/
	public static native boolean isHelperProtocol(String protocol);
	/**	
		 Returns whether the protocol can act as a filter protocol.
			 A filter protocol can operate on data that is passed to it
		 but does not retrieve/store data itself, like gzip.
		 A filter protocol is the opposite of a source protocol.
			 The "source=" field in the protocol description file determines
		 whether a protocol is a source protocol or a filter protocol.
		 Valid values for this field are "true" (default) for source protocol or
		 "false" for filter protocol.
			@param url the url to check
				@return true if the protocol is a filter (e.g. gzip), false if the
         protocol is a helper or source
   
		@short    Returns whether the protocol can act as a filter protocol.
	*/
	public static native boolean isFilterProtocol(KURL url);
	/**	
		 Same as above except you can supply just the protocol instead of
		 the whole URL.
		   		@short    Same as above except you can supply just the protocol instead of  the whole URL.
	*/
	public static native boolean isFilterProtocol(String protocol);
	/**	
		 Returns whether the protocol can list files/objects.
		 If a protocol supports listing it can be browsed in e.g. file-dialogs
		 and konqueror.
			 Whether a protocol supports listing is determined by the "listing="
		 field in the protocol description file.
		 If the protocol support listing it should list the fields it provides in
		 this field. If the protocol does not support listing this field should
		 remain empty (default.)
			@param url the url to check
				@return true if the protocol support listing

		@short    Returns whether the protocol can list files/objects.
		@see #listing
	*/
	public static native boolean supportsListing(KURL url);
	/**	
		 Returns whether the protocol can retrieve data from URLs.
			 This corresponds to the "reading=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if it is possible to read from the URL
   
		@short    Returns whether the protocol can retrieve data from URLs.
	*/
	public static native boolean supportsReading(KURL url);
	/**	
		 Returns whether the protocol can store data to URLs.
			 This corresponds to the "writing=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol supports writing
   
		@short    Returns whether the protocol can store data to URLs.
	*/
	public static native boolean supportsWriting(KURL url);
	/**	
		 Returns whether the protocol can create directories/folders.
			 This corresponds to the "makedir=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol can create directories
   
		@short    Returns whether the protocol can create directories/folders.
	*/
	public static native boolean supportsMakeDir(KURL url);
	/**	
		 Returns whether the protocol can delete files/objects.
			 This corresponds to the "deleting=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol supports deleting
   
		@short    Returns whether the protocol can delete files/objects.
	*/
	public static native boolean supportsDeleting(KURL url);
	/**	
		 Returns whether the protocol can create links between files/objects.
			 This corresponds to the "linking=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol supports linking
   
		@short    Returns whether the protocol can create links between files/objects.
	*/
	public static native boolean supportsLinking(KURL url);
	/**	
		 Returns whether the protocol can move files/objects between different
		 locations.
			 This corresponds to the "moving=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol supports moving
   
		@short    Returns whether the protocol can move files/objects between different  locations.
	*/
	public static native boolean supportsMoving(KURL url);
	/**	
		 Returns whether the protocol can copy files/objects directly from the
		 filesystem itself. If not, the application will read files from the
		 filesystem using the file-protocol and pass the data on to the destination
		 protocol.
			 This corresponds to the "copyFromFile=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol can copy files from the local file system
   
		@short    Returns whether the protocol can copy files/objects directly from the  filesystem itself.
	*/
	public static native boolean canCopyFromFile(KURL url);
	/**	
		 Returns whether the protocol can copy files/objects directly to the
		 filesystem itself. If not, the application will receive the data from
		 the source protocol and store it in the filesystem using the
		 file-protocol.
			 This corresponds to the "copyToFile=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol can copy files to the local file system
   
		@short    Returns whether the protocol can copy files/objects directly to the  filesystem itself.
	*/
	public static native boolean canCopyToFile(KURL url);
	/**	
		 Returns whether the protocol can rename (i.e. move fast) files/objects
		 directly from the filesystem itself. If not, the application will read
		 files from the filesystem using the file-protocol and pass the data on
		 to the destination protocol.
			 This corresponds to the "renameFromFile=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol can rename/move files from the local file system

		@short    Returns whether the protocol can rename (i.
	*/
	public static native boolean canRenameFromFile(KURL url);
	/**	
		 Returns whether the protocol can rename (i.e. move fast) files/objects
		 directly to the filesystem itself. If not, the application will receive
		 the data from the source protocol and store it in the filesystem using the
		 file-protocol.
			 This corresponds to the "renameToFile=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol can rename files to the local file system

		@short    Returns whether the protocol can rename (i.
	*/
	public static native boolean canRenameToFile(KURL url);
	/**	
		 Returns whether the protocol can recursively delete directories by itself.
		 If not (the usual case) then KIO will list the directory and delete files
		 and empty directories one by one.
			 This corresponds to the "deleteRecursive=" field in the protocol description file.
		 Valid values for this field are "true" or "false" (default).
			@param url the url to check
				@return true if the protocol can delete non-empty directories by itself.

		@short    Returns whether the protocol can recursively delete directories by itself.
	*/
	public static native boolean canDeleteRecursive(KURL url);
	/**	
		 This setting defines the strategy to use for generating a filename, when
		 copying a file or directory to another directory. By default the destination
		 filename is made out of the filename in the source URL. However if the
		 ioslave displays names that are different from the filename of the URL
		 (e.g. kio_fonts shows Arial for arial.ttf, or kio_trash shows foo.txt and
		 uses some internal URL), using Name means that the display name (UDS_NAME)
		 will be used to as the filename in the destination directory.
			 This corresponds to the "fileNameUsedForCopying=" field in the protocol description file.
		 Valid values for this field are "Name" or "FromURL" (default).
			@param url the url to check
				@return how to generate the filename in the destination directory when copying/moving

		@short    This setting defines the strategy to use for generating a filename, when  copying a file or directory to another directory.
	*/
	// KProtocolInfo::FileNameUsedForCopying fileNameUsedForCopying(const KURL& arg1); >>>> NOT CONVERTED
	/**	
		 Returns default mimetype for this URL based on the protocol.
			 This corresponds to the "defaultMimetype=" field in the protocol description file.
			@param url the url to check
				@return the default mime type of the protocol, or null if unknown
   
		@short    Returns default mimetype for this URL based on the protocol.
	*/
	public static native String defaultMimetype(KURL url);
	/**	
		 Returns the name of the icon, associated with the specified protocol.
			 This corresponds to the "Icon=" field in the protocol description file.
			@param protocol the protocol to check
				@return the icon of the protocol, or null if unknown
   
		@short    Returns the name of the icon, associated with the specified protocol.
	*/
	public static native String icon(String protocol);
	/**	
		 Returns the name of the config file associated with the
		 specified protocol. This is useful if two similar protocols
		 need to share a single config file, e.g. http and https.
			 This corresponds to the "config=" field in the protocol description file.
		 The default is the protocol name, see name()
			@param protocol the protocol to check
				@return the config file, or null if unknown
   
		@short    Returns the name of the config file associated with the  specified protocol.
	*/
	public static native String config(String protocol);
	/**	
		 Returns the soft limit on the number of slaves for this protocol.
		 This limits the number of slaves used for a single operation, note
		 that multiple operations may result in a number of instances that
		 exceeds this soft limit.
			 This corresponds to the "maxInstances=" field in the protocol description file.
		 The default is 1.
			@param protocol the protocol to check
				@return the maximum number of slaves, or 1 if unknown
   
		@short    Returns the soft limit on the number of slaves for this protocol.
	*/
	public static native int maxSlaves(String protocol);
	/**	
		 Returns whether mimetypes can be determined based on extension for this
		 protocol. For some protocols, e.g. http, the filename extension in the URL
		 can not be trusted to truly reflect the file type.
			 This corresponds to the "determineMimetypeFromExtension=" field in the protocol description file.
		 Valid values for this field are "true" (default) or "false".
			@param protocol the protocol to check
				@return true if the mime types can be determined by extension
   
		@short    Returns whether mimetypes can be determined based on extension for this  protocol.
	*/
	public static native boolean determineMimetypeFromExtension(String protocol);
	/**	
		 Returns the documentation path for the specified protocol.
			 This corresponds to the "DocPath=" field in the protocol description file.
			@param protocol the protocol to check
				@return the docpath of the protocol, or null if unknown

		@short    Returns the documentation path for the specified protocol.
	*/
	public static native String docPath(String protocol);
	/**	
		 Returns the protocol class for the specified protocol.
			 This corresponds to the "Class=" field in the protocol description file.
			 The following classes are defined:
		
			<li>
			":internet" for common internet protocols
			</li>
			
			<li>
			":local" for protocols that access local resources
			</li>
				 Protocol classes always start with a ':' so that they can not be confused with
		 the protocols themselves.
			@param protocol the protocol to check
				@return the class of the protocol, or null if unknown

		@short    Returns the protocol class for the specified protocol.
	*/
	public static native String protocolClass(String protocol);
	/**	
		 Returns whether file previews should be shown for the specified protocol.
			 This corresponds to the "ShowPreviews=" field in the protocol description file.
			 By default previews are shown if protocolClass is :local.
			@param protocol the protocol to check
				@return true if previews should be shown by default, false otherwise

		@short    Returns whether file previews should be shown for the specified protocol.
	*/
	public static native boolean showFilePreview(String protocol);
	/**	
		 Returns the suggested URI parsing mode for the KURL parser.
			 This corresponds to the "URIMode=" field in the protocol description file.
			 The following parsing modes are defined:
		
			<li>
			"url" for a standards compliant URL
			</li>
			
			<li>
			"rawuri" for a non-conformant URI for which URL parsing would be meaningless
			</li>
			
			<li>
			"mailto" for a mailto style URI (the path part contains only an email address)
			</li>
				@param protocol the protocol to check
				@return the suggested parsing mode, or KURL.Auto if unspecified

		@short    Returns the suggested URI parsing mode for the KURL parser.
	*/
	public static native int uriParseMode(String protocol);
	/**	
		 Returns the list of capabilities provided by the kioslave implementing
		 this protocol.
			 This corresponds to the "Capabilities=" field in the protocol description file.
			 The capability names are not defined globally, they are up to each
		 slave implementation. For example when adding support for a new
		 special command for mounting, one would add the string "Mount" to the
		 capabilities list, and applications could check for that string
		 before sending a special() command that would otherwise do nothing
		 on older kioslave implementations.
			@param protocol the protocol to check
				@return the list of capabilities.

		@short    Returns the list of capabilities provided by the kioslave implementing  this protocol.
	*/
	public static native ArrayList capabilities(String protocol);
	/**	
		 Returns the name of the protocol through which the request
		 will be routed if proxy support is enabled.
			 A good example of this is the ftp protocol for which proxy
		 support is commonly handled by the http protocol.
			 This corresponds to the "ProxiedBy=" in the protocol description file.
				@short    Returns the name of the protocol through which the request  will be routed if proxy support is enabled.
	*/
	public static native String proxiedBy(String protocol);
	protected native boolean canRenameFromFile();
	protected native boolean canRenameToFile();
	protected native boolean canDeleteRecursive();
	// KProtocolInfo::FileNameUsedForCopying fileNameUsedForCopying(); >>>> NOT CONVERTED
	protected static native KProtocolInfo findProtocol(KURL url);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
