
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGDEBUGGER_H
#define XSLDBGDEBUGGER_H

#include <QEvent>
#include <QTimerEvent>
#include "libxsldbg/xsldbgmsg.h"   /* needed for XsldbgMessageEnum */
#include "libqtnotfier/xsldbgdebuggerbase.h"

#include "xsldbginspector.h"


/**
  *@author Keith Isdale
  */

class QStringList;

class XsldbgWalkSpeedImpl;

class XsldbgDebugger : public XsldbgDebuggerBase {
  Q_OBJECT

public:
	XsldbgDebugger();
	~XsldbgDebugger();

	/** */
	void setInspector(XsldbgInspector *inspector);

	/** Get the name of source file from xsldbg*/
	QString sourceFileName();

	/** Get the name of data file from xsldbg*/
	QString dataFileName();

	/** Get the name of output file from xsldbg*/
	QString outputFileName();

	/** Get the name of working dir from xsldbg*/
	QString workDirName();

	/** Tell quanta to move its cursor to file and line number supplied */
	void gotoLine(QString fileName, int lineNo, bool breakpoint = false);

	bool event(QEvent *e);
	void timerEvent(QTimerEvent *e);

	void setOutputFileActive(bool b) {outputFileActive = b;};

	/* helper function to handle differences between URI's in Qt/KDE and libxml2 */
	static QString fixLocalPaths(QString & file);
	
private:
	/** */
	bool outputFileActive;

public slots:
	/** start xsldbg */
	bool start();

	/** stop xsldbg */
	bool stop();

	/** send text to xsldbg, if wait is true then wait for the reply */
	void fakeInput(QString text, bool wait);

	/** Display configure dialog */
	void slotConfigure();

	/** Config window closed */
	void slotConfigClosed();

  /** Step to next instruction */
  void slotStepCmd();

  /** Continue to next break point */
  void slotContinueCmd();

  /** Restart xsldbg with selected xsl/xml file */
  void slotRunCmd();

  /** Walk through stylesheet at a fixed speed
  	 @param speed : Must be a value of 0  to 9, where 1 mean fast, 9 means slow, and 0 means stop
  */
  void slotWalkSpeed(int speed);

  /** Present a dialog for use to choose walk speed */
  void slotWalkCmd();

  /** Stop walking imediately */
  void slotWalkStopCmd();

  /**
  	Start xslbg's trace mode, where output will be sent to to message window.
  		Can only be be stopped by using "exit" tool button and killing xsldbg */
  void slotTraceCmd();

	/** Add breakpoint at given file and line number */
	void slotBreakCmd(QString fileName, int lineNumber);

	/** Add breakpoint at given template name*/
	void slotBreakCmd(QString templateName, QString modeName);

	/** Toggle the enabling of break point at given file and line number */
	void slotEnableCmd(QString fileName, int lineNumber);

	/** Enable break point for given breakpoint id */
	void slotEnableCmd(int id);

	/** Delete break point at given file and line number */
	void slotDeleteCmd(QString fileName, int lineNumber);

	/** Delete break point for given breakpoint id */
	void slotDeleteCmd(int id);

	/** Switch to view of XSL source */
	void slotSourceCmd();

	/* switch to the output document  */
	void slotShowDocument();

	/** Switch to view of XML data */
	void slotDataCmd();

  /** Stop xsldg, must use start after this command  */
  void slotExitCmd();

  /** Print the result of evaluating xPathExpression to the message window */
  void slotCatCmd(QString xPathExpression);

  /** Move to line specified by xPathExpression */
  void slotCdCmd(QString xPathExpression);

  /** Set a libxslt variable  to  xPathExpression */
  void slotSetVariableCmd(QString variableName, QString xPathExpression);

  void readSettings();
  void writeSettings();


private:
	bool initialized;
        bool waitingFirstmessage;

	 /* xsldbg config and inspection dialog */
	XsldbgInspector *inspector;

	/**Walk speed dialog  */
	XsldbgWalkSpeedImpl *walkDialog;
	bool readMsg;
	bool procMsg;

	/* copy text to output only if no furher output us requested */
	XsldbgMessageEnum lastType;
	int updateTimerID;
	bool addMsg;

	QStringList commandQue;

};

#endif
