#Macro to find xscreensaver directory

# Copyright (c) 2006, Laurent Montel, <montel@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


FIND_PATH(XSCREENSAVER_DIR lib${LIB_SUFFIX}/xscreensaver/deco
   ${KDE4_INCLUDE_DIR}
   /usr/
   /usr/local/
   /opt/local/
   /usr/X11R6/
   /opt/kde/
   /opt/kde3/
   /usr/kde/
   /usr/local/kde/
   /usr/local/xscreensaver/
   /usr/openwin/lib/xscreensaver/
   /etc/
)
if( XSCREENSAVER_DIR)
   set(XSCREENSAVER_DIR ${XSCREENSAVER_DIR}/lib${LIB_SUFFIX}/xscreensaver/)
endif(XSCREENSAVER_DIR)



if(NOT XSCREENSAVER_DIR)
FIND_PATH(XSCREENSAVER_DIR lib/xscreensaver/deco
   ${KDE4_INCLUDE_DIR}
   /usr/
   /usr/local/
   /opt/local/
   /usr/X11R6/
   /opt/kde/
   /opt/kde3/
   /usr/kde/
   /usr/local/kde/
   /usr/local/xscreensaver/
   /usr/openwin/lib/xscreensaver/
   /etc/
)
if( XSCREENSAVER_DIR)
   set(XSCREENSAVER_DIR ${XSCREENSAVER_DIR}/lib/xscreensaver/)	
endif(XSCREENSAVER_DIR)
endif(NOT XSCREENSAVER_DIR)



if(NOT XSCREENSAVER_DIR)
FIND_PATH(XSCREENSAVER_DIR libexec/xscreensaver/deco
   ${KDE4_INCLUDE_DIR}
   /usr/
   /usr/local/
   /opt/local/
   /usr/X11R6/
   /opt/kde/
   /opt/kde3/
   /usr/kde/
   /usr/local/kde/
   /usr/local/xscreensaver/
   /usr/openwin/lib/xscreensaver/
   /etc/
)
if( XSCREENSAVER_DIR)
   set(XSCREENSAVER_DIR ${XSCREENSAVER_DIR}/libexec/xscreensaver/)	
endif(XSCREENSAVER_DIR)
endif(NOT XSCREENSAVER_DIR)



if(NOT XSCREENSAVER_DIR)
FIND_PATH(XSCREENSAVER_DIR bin/xscreensaver-hacks/deco
   ${KDE4_INCLUDE_DIR}
   /usr/
   /usr/local/
   /opt/local/
   /usr/X11R6/
   /opt/kde/
   /opt/kde3/
   /usr/kde/
   /usr/local/kde/
   /usr/local/xscreensaver/
   /usr/openwin/lib/xscreensaver/
   /etc/
)
if( XSCREENSAVER_DIR)
	set(XSCREENSAVER_DIR ${XSCREENSAVER_DIR}/bin/xscreensaver-hacks/)
endif(XSCREENSAVER_DIR)

endif(NOT XSCREENSAVER_DIR)



if(NOT XSCREENSAVER_DIR)
FIND_PATH(XSCREENSAVER_DIR hacks/deco
   ${KDE4_INCLUDE_DIR}
   /usr/
   /usr/local/
   /opt/local/
   /usr/X11R6/
   /opt/kde/
   /opt/kde3/
   /usr/kde/
   /usr/local/kde/
   /usr/local/xscreensaver/
   /usr/openwin/lib/xscreensaver/
   /etc/
)
if( XSCREENSAVER_DIR)
        set(XSCREENSAVER_DIR ${XSCREENSAVER_DIR}/hacks/)
endif(XSCREENSAVER_DIR)
endif(NOT XSCREENSAVER_DIR)



set(XSCREENSAVER_CONFIG_DIR)
FIND_PATH(XSCREENSAVER_CONFIG_DIR config/deco.xml
   ${KDE4_INCLUDE_DIR}
   /usr/
   /usr/local/
   /opt/local/
   /usr/X11R6/
   /opt/kde/
   /opt/kde3/
   /usr/kde/
   /usr/share/xscreensaver/
   /usr/local/kde/
   /usr/local/xscreensaver/
   /usr/openwin/lib/xscreensaver/
   /etc/
)
if(XSCREENSAVER_CONFIG_DIR)
	set(XSCREENSAVER_CONFIG_DIR "${XSCREENSAVER_CONFIG_DIR}/config/")
	MESSAGE(STATUS "XSCREENSAVER_CONFIG_DIR <${XSCREENSAVER_CONFIG_DIR}>")
endif(XSCREENSAVER_CONFIG_DIR)


# Try and locate XScreenSaver config when path doesn't include config
if(NOT XSCREENSAVER_CONFIG_DIR)
  FIND_PATH(XSCREENSAVER_CONFIG_DIR deco.xml
     /etc/xscreensaver
     )
endif(NOT XSCREENSAVER_CONFIG_DIR)

#MESSAGE(STATUS "XSCREENSAVER_CONFIG_DIR :<${XSCREENSAVER_CONFIG_DIR}>")
#MESSAGE(STATUS "XSCREENSAVER_DIR :<${XSCREENSAVER_DIR}>")

# Need to fix hack
if(XSCREENSAVER_DIR AND XSCREENSAVER_CONFIG_DIR)
	set(XSCREENSAVER_FOUND TRUE)
endif(XSCREENSAVER_DIR AND XSCREENSAVER_CONFIG_DIR)

if (XSCREENSAVER_FOUND)
  if (NOT Xscreensaver_FIND_QUIETLY)
    message(STATUS "Found SCREENSAVER_CONFIG_DIR <${XSCREENSAVER_CONFIG_DIR}>")
  endif (NOT Xscreensaver_FIND_QUIETLY)
else (XSCREENSAVER_FOUND)
  if (Xscreensaver_FIND_REQUIRED)
    message(FATAL_ERROR "XScreenSaver not found")
  endif (Xscreensaver_FIND_REQUIRED)
endif (XSCREENSAVER_FOUND)


MARK_AS_ADVANCED(XSCREENSAVER_DIR XSCREENSAVER_CONFIG_DIR)
