#version 140
uniform sampler2D sampler;
uniform vec4 modulation;
uniform float saturation;

in vec2 varyingTexCoords;

out vec4 fragColor;

void main()
{
    vec4 tex = texture(sampler, varyingTexCoords);

    if (saturation != 1.0) {
        vec3 desaturated = tex.rgb * vec3( 0.30, 0.59, 0.11 );
        desaturated = vec3( dot( desaturated, tex.rgb ));
        tex.rgb = tex.rgb * vec3( saturation ) + desaturated * vec3( 1.0 - saturation );
    }

    tex *= modulation;
    tex.rgb = vec3(1.0) - tex.rgb;
    tex.rgb *= tex.a;

    fragColor = tex;
}
