//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class DataEngine plasma/dataengine.h <Plasma/DataEngine>
    ///  This is the base class for DataEngines, which provide access to bodies of
    ///  data via a common and consistent interface. The common use of a DataEngine
    ///  is to provide data to a widget for display. This allows a user interface
    ///  element to show all sorts of data: as long as there is a DataEngine, the
    ///  data is retrievable.
    ///  DataEngines are loaded as plugins on demand and provide zero, one or more
    ///  data sources which are identified by name. For instance, a network
    ///  DataEngine might provide a data source for each network interface.
    ///  See <see cref="IDataEngineSignals"></see> for signals emitted by DataEngine
    /// </remarks>        <short> Data provider for plasmoids (Plasma plugins).</short>
    [SmokeClass("Plasma::DataEngine")]
    public class DataEngine : QObject, IDisposable {
        protected DataEngine(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(DataEngine), this);
        }
        [Q_PROPERTY("QStringList", "sources")]
        public List<string> Sources {
            get { return (List<string>) interceptor.Invoke("sources", "sources()", typeof(List<string>)); }
        }
        [Q_PROPERTY("bool", "valid")]
        public bool Valid {
            get { return (bool) interceptor.Invoke("isValid", "isValid()", typeof(bool)); }
        }
        [Q_PROPERTY("QString", "icon")]
        public string icon {
            get { return (string) interceptor.Invoke("icon", "icon()", typeof(string)); }
            set { interceptor.Invoke("setIcon$", "setIcon(QString)", typeof(void), typeof(string), value); }
        }
        /// <remarks>
        ///  Constructor.
        /// <param> name="parent" The parent object.
        /// </param><param> name="service" pointer to the service that describes the engine
        /// </param></remarks>        <short>    Constructor.</short>
        public DataEngine(QObject parent, KService service) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DataEngine#?", "DataEngine(QObject*, KSharedPtr<KService>)", typeof(void), typeof(QObject), parent, typeof(KService), service);
        }
        public DataEngine(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DataEngine#", "DataEngine(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public DataEngine() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DataEngine", "DataEngine()", typeof(void));
        }
        public DataEngine(QObject parent, List<QVariant> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DataEngine#?", "DataEngine(QObject*, const QList<QVariant>&)", typeof(void), typeof(QObject), parent, typeof(List<QVariant>), args);
        }
        /// <remarks>
        ///  This method is called when the DataEngine is started. When this
        ///  method is called the DataEngine is fully constructed and ready to be
        ///  used. This method should be reimplemented by DataEngine subclasses
        ///  which have the need to perform a startup routine.
        /// </remarks>        <short>    This method is called when the DataEngine is started.</short>
        [SmokeMethod("init()")]
        public virtual void Init() {
            interceptor.Invoke("init", "init()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> a list of all the data sources available via this DataEngine
        ///          Whether these sources are currently available (which is what
        ///          the default implementation provides) or not is up to the
        ///          DataEngine to decide.
        /// </return>
        ///         <short>   </short>
        [SmokeMethod("sources() const")]
        public virtual List<string> sources() {
            return (List<string>) interceptor.Invoke("sources", "sources() const", typeof(List<string>));
        }
        /// <remarks>
        /// <param> name="source" the source to target the Service at
        /// </param></remarks>        <return> a Service that has the source as a destination. The service
        ///          is parented to the DataEngine, but may be deleted by the
        ///          caller when finished with it
        ///          </return>
        ///         <short>   </short>
        [SmokeMethod("serviceForSource(const QString&)")]
        public virtual Plasma.Service ServiceForSource(string source) {
            return (Plasma.Service) interceptor.Invoke("serviceForSource$", "serviceForSource(const QString&)", typeof(Plasma.Service), typeof(string), source);
        }
        /// <remarks>
        ///  Returns the engine name for the DataEngine
        ///          </remarks>        <short>    Returns the engine name for the DataEngine          </short>
        public string Name() {
            return (string) interceptor.Invoke("name", "name() const", typeof(string));
        }
        /// <remarks>
        ///  Connects a source to an object for data updates. The object must
        ///  have a slot with the following signature:
        ///  dataUpdated(stringsourceName, const Plasma.DataEngine.Data &data)
        ///  The data is a QHash of QVariants keyed by string names, allowing
        ///  one data source to provide sets of related data.
        /// <param> name="source" the name of the data source
        /// </param><param> name="visualization" the object to connect the data source to
        /// </param><param> name="pollingInterval" the frequency, in milliseconds, with which to check for updates;
        ///                         a value of 0 (the default) means to update only
        ///                         when there is new data spontaneously generated
        ///                         (e.g. by the engine); any other value results in
        ///                         periodic updates from this source. This value is
        ///                         per-visualization and can be handy for items that require
        ///                         constant updates such as scrolling graphs or clocks.
        ///                         If the data has not changed, no update will be sent.
        /// </param><param> name="intervalAlignment" the number of ms to align the interval to
        /// </param></remarks>        <short>    Connects a source to an object for data updates.</short>
        public void ConnectSource(string source, QObject visualization, uint pollingInterval, Plasma.IntervalAlignment intervalAlignment) {
            interceptor.Invoke("connectSource$#$$", "connectSource(const QString&, QObject*, uint, Plasma::IntervalAlignment) const", typeof(void), typeof(string), source, typeof(QObject), visualization, typeof(uint), pollingInterval, typeof(Plasma.IntervalAlignment), intervalAlignment);
        }
        public void ConnectSource(string source, QObject visualization, uint pollingInterval) {
            interceptor.Invoke("connectSource$#$", "connectSource(const QString&, QObject*, uint) const", typeof(void), typeof(string), source, typeof(QObject), visualization, typeof(uint), pollingInterval);
        }
        public void ConnectSource(string source, QObject visualization) {
            interceptor.Invoke("connectSource$#", "connectSource(const QString&, QObject*) const", typeof(void), typeof(string), source, typeof(QObject), visualization);
        }
        /// <remarks>
        ///  Connects all currently existing sources to an object for data updates.
        ///  The object must have a slot with the following signature:
        ///  SLOT("dataUpdated(string,Plasma.DataEngine.Data)")
        ///  The data is a QHash of QVariants keyed by string names, allowing
        ///  one data source to provide sets of related data.
        ///  This method may be called multiple times for the same visualization
        ///  without side-effects. This can be useful to change the pollingInterval.
        ///  Note that this method does not automatically connect sources that
        ///  may appear later on. Connecting and responding to the sourceAdded sigal
        ///  is still required to achieve that.
        /// <param> name="visualization" the object to connect the data source to
        /// </param><param> name="pollingInterval" the frequency, in milliseconds, with which to check for updates;
        ///                         a value of 0 (the default) means to update only
        ///                         when there is new data spontaneously generated
        ///                         (e.g. by the engine); any other value results in
        ///                         periodic updates from this source. This value is
        ///                         per-visualization and can be handy for items that require
        ///                         constant updates such as scrolling graphs or clocks.
        ///                         If the data has not changed, no update will be sent.
        /// </param><param> name="intervalAlignment" the number of ms to align the interval to
        /// </param></remarks>        <short>    Connects all currently existing sources to an object for data updates.</short>
        public void ConnectAllSources(QObject visualization, uint pollingInterval, Plasma.IntervalAlignment intervalAlignment) {
            interceptor.Invoke("connectAllSources#$$", "connectAllSources(QObject*, uint, Plasma::IntervalAlignment) const", typeof(void), typeof(QObject), visualization, typeof(uint), pollingInterval, typeof(Plasma.IntervalAlignment), intervalAlignment);
        }
        public void ConnectAllSources(QObject visualization, uint pollingInterval) {
            interceptor.Invoke("connectAllSources#$", "connectAllSources(QObject*, uint) const", typeof(void), typeof(QObject), visualization, typeof(uint), pollingInterval);
        }
        public void ConnectAllSources(QObject visualization) {
            interceptor.Invoke("connectAllSources#", "connectAllSources(QObject*) const", typeof(void), typeof(QObject), visualization);
        }
        /// <remarks>
        ///  Disconnects a source to an object that was receiving data updates.
        /// <param> name="source" the name of the data source
        /// </param><param> name="visualization" the object to connect the data source to
        /// </param></remarks>        <short>    Disconnects a source to an object that was receiving data updates.</short>
        public void DisconnectSource(string source, QObject visualization) {
            interceptor.Invoke("disconnectSource$#", "disconnectSource(const QString&, QObject*) const", typeof(void), typeof(string), source, typeof(QObject), visualization);
        }
        /// <remarks>
        ///  Retrevies a pointer to the DataContainer for a given source. This method
        ///  should not be used if possible. An exception is for script engines that
        ///  can not provide a QMetaObject as required by connectSource for the initial
        ///  call to dataUpdated. Using this method, such engines can provide their own
        ///  connectSource API.
        /// <param> name="source" the name of the source.
        /// </param></remarks>        <return> pointer to a DataContainer, or zero on failure
        /// </return>
        ///         <short>    Retrevies a pointer to the DataContainer for a given source.</short>
        public Plasma.DataContainer ContainerForSource(string source) {
            return (Plasma.DataContainer) interceptor.Invoke("containerForSource$", "containerForSource(const QString&)", typeof(Plasma.DataContainer), typeof(string), source);
        }
        /// <remarks>
        ///  Gets the Data associated with a data source.
        ///  The data is a QHash of QVariants keyed by string names, allowing
        ///  one data source to provide sets of related data.
        /// <param> name="source" the data source to retrieve the data for
        /// </param></remarks>        <return> the Data associated with the source; if the source doesn't
        ///          exist an empty data set is returned
        /// </return>
        ///         <short>    Gets the Data associated with a data source.</short>
        public Dictionary<string, QVariant> Query(string source) {
            return (Dictionary<string, QVariant>) interceptor.Invoke("query$", "query(const QString&) const", typeof(Dictionary<string, QVariant>), typeof(string), source);
        }
        /// <remarks>
        ///  Returns true if the data engine is empty, which is to say that it has no
        ///  data sources currently.
        ///          </remarks>        <short>    Returns true if the data engine is empty, which is to say that it has no  data sources currently.</short>
        public bool IsEmpty() {
            return (bool) interceptor.Invoke("isEmpty", "isEmpty() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the maximum number of sources this DataEngine will have
        ///  at any given time.
        /// </remarks>        <return> the maximum number of sources; zero means no limit.
        ///          </return>
        ///         <short>    Returns the maximum number of sources this DataEngine will have  at any given time.</short>
        public uint MaxSourceCount() {
            return (uint) interceptor.Invoke("maxSourceCount", "maxSourceCount() const", typeof(uint));
        }
        /// <remarks>
        ///  Accessor for the associated Package object if any.
        /// </remarks>        <return> the Package object, or 0 if none
        /// </return>
        ///         <short>    Accessor for the associated Package object if any.</short>
        public Plasma.Package Package() {
            return (Plasma.Package) interceptor.Invoke("package", "package() const", typeof(Plasma.Package));
        }
        /// <remarks>
        ///  Returns the plugin name for the applet
        ///          </remarks>        <short>    Returns the plugin name for the applet          </short>
        public string PluginName() {
            return (string) interceptor.Invoke("pluginName", "pluginName() const", typeof(string));
        }
        /// <remarks>
        ///  When a source that does not currently exist is requested by the
        ///  consumer, this method is called to give the DataEngine the
        ///  opportunity to create one.
        ///  The name of the data source (e.g. the source parameter passed into
        ///  setData) must be the same as the name passed to sourceRequestEvent
        ///  otherwise the requesting visualization may not receive notice of a
        ///  data update.
        ///  If the source can not be populated with data immediately (e.g. due to
        ///  an asynchronous data acquisition method such as an HTTP request)
        ///  the source must still be created, even if it is empty. This can
        ///  be accomplished in these cases with the follow line:
        ///       setData(name, DataEngine.Data());
        /// <param> name="source" the name of the source that has been requested
        /// </param></remarks>        <return> true if a DataContainer was set up, false otherwise
        ///          </return>
        ///         <short>    When a source that does not currently exist is requested by the  consumer, this method is called to give the DataEngine the  opportunity to create one.</short>
        [SmokeMethod("sourceRequestEvent(const QString&)")]
        protected virtual bool SourceRequestEvent(string source) {
            return (bool) interceptor.Invoke("sourceRequestEvent$", "sourceRequestEvent(const QString&)", typeof(bool), typeof(string), source);
        }
        /// <remarks>
        ///  Called by internal updating mechanisms to trigger the engine
        ///  to refresh the data contained in a given source. Reimplement this
        ///  method when using facilities such as setPollingInterval.
        /// <param> name="source" the name of the source that should be updated
        /// </param></remarks>        <return> true if the data was changed, or false if there was no
        ///          change or if the change will occur later
        /// </return>
        ///         <short>    Called by internal updating mechanisms to trigger the engine  to refresh the data contained in a given source.</short>
        ///         <see> setPollingInterval</see>
        [SmokeMethod("updateSourceEvent(const QString&)")]
        protected virtual bool UpdateSourceEvent(string source) {
            return (bool) interceptor.Invoke("updateSourceEvent$", "updateSourceEvent(const QString&)", typeof(bool), typeof(string), source);
        }
        /// <remarks>
        ///  Sets a value for a data source. If the source
        ///  doesn't exist then it is created.
        /// <param> name="source" the name of the data source
        /// </param><param> name="value" the data to associated with the source
        /// </param></remarks>        <short>    Sets a value for a data source.</short>
        protected void SetData(string source, QVariant value) {
            interceptor.Invoke("setData$#", "setData(const QString&, const QVariant&)", typeof(void), typeof(string), source, typeof(QVariant), value);
        }
        /// <remarks>
        ///  Sets a value for a data source. If the source
        ///  doesn't exist then it is created.
        /// <param> name="source" the name of the data source
        /// </param><param> name="key" the key to use for the data
        /// </param><param> name="value" the data to associated with the source
        /// </param></remarks>        <short>    Sets a value for a data source.</short>
        protected void SetData(string source, string key, QVariant value) {
            interceptor.Invoke("setData$$#", "setData(const QString&, const QString&, const QVariant&)", typeof(void), typeof(string), source, typeof(string), key, typeof(QVariant), value);
        }
        /// <remarks>
        ///  Adds a set of data to a data source. If the source
        ///  doesn't exist then it is created.
        /// <param> name="source" the name of the data source
        /// </param><param> name="data" the data to add to the source
        /// </param></remarks>        <short>    Adds a set of data to a data source.</short>
        protected void SetData(string source, Dictionary<string, QVariant> data) {
            interceptor.Invoke("setData$?", "setData(const QString&, const QHash<QString,QVariant>&)", typeof(void), typeof(string), source, typeof(Dictionary<string, QVariant>), data);
        }
        /// <remarks>
        ///  Removes all the data associated with a data source.
        /// <param> name="source" the name of the data source
        /// </param></remarks>        <short>    Removes all the data associated with a data source.</short>
        protected void RemoveAllData(string source) {
            interceptor.Invoke("removeAllData$", "removeAllData(const QString&)", typeof(void), typeof(string), source);
        }
        /// <remarks>
        ///  Removes a data entry from a source
        /// <param> name="source" the name of the data source
        /// </param><param> name="key" the data entry to remove
        /// </param></remarks>        <short>    Removes a data entry from a source </short>
        protected void RemoveData(string source, string key) {
            interceptor.Invoke("removeData$$", "removeData(const QString&, const QString&)", typeof(void), typeof(string), source, typeof(string), key);
        }
        /// <remarks>
        ///  Adds an already constructed data source. The DataEngine takes
        ///  ownership of the DataContainer object. The objectName of the source
        ///  is used for the source name.
        /// <param> name="source" the DataContainer to add to the DataEngine
        /// </param></remarks>        <short>    Adds an already constructed data source.</short>
        protected void AddSource(Plasma.DataContainer source) {
            interceptor.Invoke("addSource#", "addSource(Plasma::DataContainer*)", typeof(void), typeof(Plasma.DataContainer), source);
        }
        /// <remarks>
        ///  Sets an upper limit on the number of data sources to keep in this engine.
        ///  If the limit is exceeded, then the oldest data source, as defined by last
        ///  update, is dropped.
        /// <param> name="limit" the maximum number of sources to keep active
        /// </param></remarks>        <short>    Sets an upper limit on the number of data sources to keep in this engine.</short>
        protected void SetMaxSourceCount(uint limit) {
            interceptor.Invoke("setMaxSourceCount$", "setMaxSourceCount(uint)", typeof(void), typeof(uint), limit);
        }
        /// <remarks>
        ///  Sets the minimum amount of time, in milliseconds, that must pass between
        ///  successive updates of data. This can help prevent too many updates happening
        ///  due to multiple update requests coming in, which can be useful for
        ///  expensive (time- or resource-wise) update mechanisms.
        /// <param> name="minimumMs" the minimum time lapse, in milliseconds, between updates.
        ///                 A value less than 0 means to never perform automatic updates,
        ///                 a value of 0 means update immediately on every update request,
        ///                 a value >0 will result in a minimum time lapse being enforced.
        /// </param></remarks>        <short>    Sets the minimum amount of time, in milliseconds, that must pass between  successive updates of data.</short>
        protected void SetMinimumPollingInterval(int minimumMs) {
            interceptor.Invoke("setMinimumPollingInterval$", "setMinimumPollingInterval(int)", typeof(void), typeof(int), minimumMs);
        }
        /// <remarks>
        /// </remarks>        <return> the minimum time between updates. @see setMinimumPollingInterval
        /// </return>
        ///         <short>   </short>
        protected int MinimumPollingInterval() {
            return (int) interceptor.Invoke("minimumPollingInterval", "minimumPollingInterval() const", typeof(int));
        }
        /// <remarks>
        ///  Sets up an internal update tick for all data sources. On every update,
        ///  updateSourceEvent will be called for each applicable source.
        /// <param> name="frequency" the time, in milliseconds, between updates. A value of 0
        ///                   will stop internally triggered updates.
        /// </param></remarks>        <short>    Sets up an internal update tick for all data sources.</short>
        ///         <see> updateSourceEvent</see>
        protected void SetPollingInterval(uint frequency) {
            interceptor.Invoke("setPollingInterval$", "setPollingInterval(uint)", typeof(void), typeof(uint), frequency);
        }
        /// <remarks>
        ///  Removes all data sources
        /// </remarks>        <short>    Removes all data sources </short>
        protected void RemoveAllSources() {
            interceptor.Invoke("removeAllSources", "removeAllSources()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> the list of active DataContainers.
        ///          </return>
        ///         <short>   </short>
        protected Dictionary<string, Plasma.DataContainer> ContainerDict() {
            return (Dictionary<string, Plasma.DataContainer>) interceptor.Invoke("containerDict", "containerDict() const", typeof(Dictionary<string, Plasma.DataContainer>));
        }
        /// <remarks>
        ///  Reimplemented from QObject
        /// </remarks>        <short>    Reimplemented from QObject </short>
        [SmokeMethod("timerEvent(QTimerEvent*)")]
        protected override void TimerEvent(QTimerEvent arg1) {
            interceptor.Invoke("timerEvent#", "timerEvent(QTimerEvent*)", typeof(void), typeof(QTimerEvent), arg1);
        }
        /// <remarks>
        ///  Sets the engine name for the DataEngine
        ///          </remarks>        <short>    Sets the engine name for the DataEngine          </short>
        protected void SetName(string name) {
            interceptor.Invoke("setName$", "setName(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Call this method when you call setData directly on a DataContainer instead
        ///  of using the DataEngine.SetData methods.
        ///  If this method is not called, no dataUpdated(..) signals will be emitted!
        ///          </remarks>        <short>    Call this method when you call setData directly on a DataContainer instead  of using the DataEngine.SetData methods.</short>
        [Q_SLOT("void scheduleSourcesUpdated()")]
        protected void ScheduleSourcesUpdated() {
            interceptor.Invoke("scheduleSourcesUpdated", "scheduleSourcesUpdated()", typeof(void));
        }
        /// <remarks>
        ///  Removes a data source.
        /// <param> name="source" the name of the data source to remove
        /// </param></remarks>        <short>    Removes a data source.</short>
        [Q_SLOT("void removeSource(QString)")]
        protected void RemoveSource(string source) {
            interceptor.Invoke("removeSource$", "removeSource(const QString&)", typeof(void), typeof(string), source);
        }
        /// <remarks>
        ///  Immediately updates all existing sources when called
        ///          </remarks>        <short>    Immediately updates all existing sources when called          </short>
        [Q_SLOT("void updateAllSources()")]
        protected void UpdateAllSources() {
            interceptor.Invoke("updateAllSources", "updateAllSources()", typeof(void));
        }
        /// <remarks>
        ///  Forces an immediate update to all connected sources, even those with
        ///  timeouts that haven't yet expired. This should _only_ be used when
        ///  there was no data available, e.g. due to network non-availability,
        ///  and then it becomes available. Normal changes in data values due to
        ///  calls to updateSource or in the natural progression of the monitored
        ///  object (e.g. CPU heat) should not result in a call to this method!
        /// </remarks>        <short>    Forces an immediate update to all connected sources, even those with  timeouts that haven't yet expired.</short>
        [Q_SLOT("void forceImmediateUpdateOfAllVisualizations()")]
        protected void ForceImmediateUpdateOfAllVisualizations() {
            interceptor.Invoke("forceImmediateUpdateOfAllVisualizations", "forceImmediateUpdateOfAllVisualizations()", typeof(void));
        }
        ~DataEngine() {
            interceptor.Invoke("~DataEngine", "~DataEngine()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~DataEngine", "~DataEngine()", typeof(void));
        }
        protected new IDataEngineSignals Emit {
            get { return (IDataEngineSignals) Q_EMIT; }
        }
    }

    public interface IDataEngineSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted when a new data source is created
        ///  Note that you do not need to emit this yourself unless
        ///  you are reimplementing sources() and want to advertise
        ///  that a new source is available (but hasn't been created
        ///  yet).
        /// <param> name="source" the name of the new data source
        /// </param></remarks>        <short>    Emitted when a new data source is created </short>
        [Q_SIGNAL("void sourceAdded(QString)")]
        void SourceAdded(string source);
        /// <remarks>
        ///  Emitted when a data source is removed.
        ///  Note that you do not need to emit this yourself unless
        ///  you have reimplemented sources() and want to signal that
        ///  a source that was available but was never created is no
        ///  longer available.
        /// <param> name="source" the name of the data source that was removed
        /// </param></remarks>        <short>    Emitted when a data source is removed.</short>
        [Q_SIGNAL("void sourceRemoved(QString)")]
        void SourceRemoved(string source);
    }
}
