/*
    List Strutucture: Implements in Rocs the linked list structure
    Copyright (C) 2010 Wagner Reck <wagner.reck@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef LISTSTRUCTURE_H
#define LISTSTRUCTURE_H

#include "DataType.h"

class ListNode;
namespace Rocs{
class ListStructure : public DataType {
  Q_OBJECT
  public:

    ListStructure ( DataTypeDocument* parent = 0 );

    ListStructure(DataType& other, DataTypeDocument* parent);

    virtual ~ListStructure();
  public slots:
    virtual void setEngine(QScriptEngine* engine);

//     virtual void setEngine ( QScriptEngine* engine );

//     virtual Datum* addNode ( QString name );


    virtual Datum* addDatum(QString name);

    virtual Pointer* addPointer(Datum* from, Datum* to);
//     virtual Pointer* addEdge ( Datum* from, Datum* to );

    void arrangeNodes();

    QScriptValue front();
    QScriptValue createNode(const QString &name);

    virtual void beforeConvert();

private:

  /**@brief Initialize List structure */
  void initialize();

    Datum * m_oldBegin;
    QParallelAnimationGroup* _animationGroup;
};
}
#endif // LISTSTRUCTURE_H
