//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \short A class which provides notifications of state changes to a SmartRange via inheritance.
    ///  \ingroup kte_group_smart_classes
    ///  This class provides notifications of changes to the position or contents of
    ///  a SmartRange via inheritance.
    ///  If you prefer to receive notifications via QObject signals, see SmartRangeNotifier.
    ///  Before destruction, you must unregister the watcher from any ranges it is watching.
    ///  \sa SmartRange, SmartRangeNotifier
    ///  \author Hamish Rodda \<rodda@kde.org\>
    ///  </remarks>        <short>    \short A class which provides notifications of state changes to a SmartRange via virtual inheritance.</short>
    [SmokeClass("KTextEditor::SmartRangeWatcher")]
    public class SmartRangeWatcher : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected SmartRangeWatcher(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(SmartRangeWatcher), this);
        }
        /// <remarks>
        ///  Default constructor
        ///      </remarks>        <short>    Default constructor      </short>
        public SmartRangeWatcher() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SmartRangeWatcher", "SmartRangeWatcher()", typeof(void));
        }
        /// <remarks>
        ///  Returns whether this watcher will be notified of changes that happen
        ///  directly to the range, e.g. by calls to SmartCursor.SetRange(), or by
        ///  direct assignment to either of the start() or end() cursors, rather
        ///  than just when surrounding text changes.
        ///      </remarks>        <short>    Returns whether this watcher will be notified of changes that happen  directly to the range, e.</short>
        public bool WantsDirectChanges() {
            return (bool) interceptor.Invoke("wantsDirectChanges", "wantsDirectChanges() const", typeof(bool));
        }
        /// <remarks>
        ///  Set whether this watcher should be notified of changes that happen
        ///  directly to the range, e.g. by calls to SmartCursor.SetRange(), or by
        ///  direct assignment to either of the start() or end() cursors, rather
        ///  than just when surrounding text changes.
        ///  \param wantsDirectChanges whether this watcher should receive notifications for direct changes.
        ///      </remarks>        <short>    Set whether this watcher should be notified of changes that happen  directly to the range, e.</short>
        public void SetWantsDirectChanges(bool wantsDirectChanges) {
            interceptor.Invoke("setWantsDirectChanges$", "setWantsDirectChanges(bool)", typeof(void), typeof(bool), wantsDirectChanges);
        }
        /// <remarks>
        ///  The range's position changed.
        ///  \param range pointer to the range which generated the notification.
        ///      </remarks>        <short>    The range's position changed.</short>
        [SmokeMethod("rangePositionChanged(KTextEditor::SmartRange*)")]
        public virtual void RangePositionChanged(KTextEditor.SmartRange range) {
            interceptor.Invoke("rangePositionChanged#", "rangePositionChanged(KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), range);
        }
        /// <remarks>
        ///  The contents of the range changed.
        ///  \param range pointer to the range which generated the notification.
        ///      </remarks>        <short>    The contents of the range changed.</short>
        [SmokeMethod("rangeContentsChanged(KTextEditor::SmartRange*)")]
        public virtual void RangeContentsChanged(KTextEditor.SmartRange range) {
            interceptor.Invoke("rangeContentsChanged#", "rangeContentsChanged(KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), range);
        }
        /// <remarks>
        ///  The contents of the range changed.  This notification is special in that it is only emitted by
        ///  the top range of a heirachy, and also gives the furthest descendant child range which still
        ///  encompasses the whole change (see <pre>contents</pre>).
        ///  \param range the range which has changed
        ///  \param mostSpecificChild the child range which both contains the entire change and is 
        ///                           the furthest descendant of this range.
        ///      </remarks>        <short>    The contents of the range changed.</short>
        [SmokeMethod("rangeContentsChanged(KTextEditor::SmartRange*, KTextEditor::SmartRange*)")]
        public virtual void RangeContentsChanged(KTextEditor.SmartRange range, KTextEditor.SmartRange mostSpecificChild) {
            interceptor.Invoke("rangeContentsChanged##", "rangeContentsChanged(KTextEditor::SmartRange*, KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.SmartRange), mostSpecificChild);
        }
        /// <remarks>
        ///  The mouse cursor on \a view entered <pre>range</pre>.
        ///  \todo For now, to receive this notification, the range heirachy must be registered with
        ///  the SmartInterface as for arbitrary highlighting with dynamic highlighting.
        ///  Need to add another (and probably simplify existing) method.
        ///  \param range pointer to the range which generated the notification.
        ///  \param view view over which the mouse moved to generate the notification
        ///      </remarks>        <short>    The mouse cursor on \a view entered \p range.</short>
        [SmokeMethod("mouseEnteredRange(KTextEditor::SmartRange*, KTextEditor::View*)")]
        public virtual void MouseEnteredRange(KTextEditor.SmartRange range, KTextEditor.View view) {
            interceptor.Invoke("mouseEnteredRange##", "mouseEnteredRange(KTextEditor::SmartRange*, KTextEditor::View*)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.View), view);
        }
        /// <remarks>
        ///  The mouse cursor on \a view exited <pre>range</pre>.
        ///  \todo For now, to receive this notification, the range heirachy must be registered with
        ///  the SmartInterface as for arbitrary highlighting with dynamic highlighting.
        ///  Need to add another (and probably simplify existing) method.
        ///  \param range pointer to the range which generated the notification.
        ///  \param view view over which the mouse moved to generate the notification
        ///      </remarks>        <short>    The mouse cursor on \a view exited \p range.</short>
        [SmokeMethod("mouseExitedRange(KTextEditor::SmartRange*, KTextEditor::View*)")]
        public virtual void MouseExitedRange(KTextEditor.SmartRange range, KTextEditor.View view) {
            interceptor.Invoke("mouseExitedRange##", "mouseExitedRange(KTextEditor::SmartRange*, KTextEditor::View*)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.View), view);
        }
        /// <remarks>
        ///  The caret on \a view entered <pre>range</pre>.
        ///  \todo For now, to receive this notification, the range heirachy must be registered with
        ///  the SmartInterface as for arbitrary highlighting with dynamic highlighting.
        ///  Need to add another (and probably simplify existing) method.
        ///  \param range pointer to the range which generated the notification.
        ///  \param view view over which the mouse moved to generate the notification
        ///      </remarks>        <short>    The caret on \a view entered \p range.</short>
        [SmokeMethod("caretEnteredRange(KTextEditor::SmartRange*, KTextEditor::View*)")]
        public virtual void CaretEnteredRange(KTextEditor.SmartRange range, KTextEditor.View view) {
            interceptor.Invoke("caretEnteredRange##", "caretEnteredRange(KTextEditor::SmartRange*, KTextEditor::View*)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.View), view);
        }
        /// <remarks>
        ///  The caret on \a view exited <pre>range</pre>.
        ///  \todo For now, to receive this notification, the range heirachy must be registered with
        ///  the SmartInterface as for arbitrary highlighting with dynamic highlighting.
        ///  Need to add another (and probably simplify existing) method.
        ///  \param range pointer to the range which generated the notification.
        ///  \param view view over which the mouse moved to generate the notification
        ///      </remarks>        <short>    The caret on \a view exited \p range.</short>
        [SmokeMethod("caretExitedRange(KTextEditor::SmartRange*, KTextEditor::View*)")]
        public virtual void CaretExitedRange(KTextEditor.SmartRange range, KTextEditor.View view) {
            interceptor.Invoke("caretExitedRange##", "caretExitedRange(KTextEditor::SmartRange*, KTextEditor::View*)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.View), view);
        }
        /// <remarks>
        ///  The range now contains no characters (ie. the start and end cursors are the same).
        ///  \param range pointer to the range which generated the notification.
        ///      </remarks>        <short>    The range now contains no characters (ie.</short>
        [SmokeMethod("rangeEliminated(KTextEditor::SmartRange*)")]
        public virtual void RangeEliminated(KTextEditor.SmartRange range) {
            interceptor.Invoke("rangeEliminated#", "rangeEliminated(KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), range);
        }
        /// <remarks>
        ///  The SmartRange instance specified by <pre>range</pre> is being deleted.
        ///  \param range pointer to the range which is about to be deleted.  It is
        ///               still safe to access information at this point.
        ///      </remarks>        <short>    The SmartRange instance specified by \p range is being deleted.</short>
        [SmokeMethod("rangeDeleted(KTextEditor::SmartRange*)")]
        public virtual void RangeDeleted(KTextEditor.SmartRange range) {
            interceptor.Invoke("rangeDeleted#", "rangeDeleted(KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), range);
        }
        /// <remarks>
        ///  The range's parent was changed.
        ///  \param range pointer to the range which generated the notification.
        ///  \param newParent pointer to the range which was is now the parent range.
        ///  \param oldParent pointer to the range which used to be the parent range.
        ///      </remarks>        <short>    The range's parent was changed.</short>
        [SmokeMethod("parentRangeChanged(KTextEditor::SmartRange*, KTextEditor::SmartRange*, KTextEditor::SmartRange*)")]
        public virtual void ParentRangeChanged(KTextEditor.SmartRange range, KTextEditor.SmartRange newParent, KTextEditor.SmartRange oldParent) {
            interceptor.Invoke("parentRangeChanged###", "parentRangeChanged(KTextEditor::SmartRange*, KTextEditor::SmartRange*, KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.SmartRange), newParent, typeof(KTextEditor.SmartRange), oldParent);
        }
        /// <remarks>
        ///  The range \a child was inserted as a child range into the current \a range.
        ///  \param range pointer to the range which generated the notification.
        ///  \param child pointer to the range which was inserted as a child range.
        ///      </remarks>        <short>    The range \a child was inserted as a child range into the current \a range.</short>
        [SmokeMethod("childRangeInserted(KTextEditor::SmartRange*, KTextEditor::SmartRange*)")]
        public virtual void ChildRangeInserted(KTextEditor.SmartRange range, KTextEditor.SmartRange child) {
            interceptor.Invoke("childRangeInserted##", "childRangeInserted(KTextEditor::SmartRange*, KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.SmartRange), child);
        }
        /// <remarks>
        ///  The child range \a child was removed from the current \a range.
        ///  \param range pointer to the range which generated the notification.
        ///  \param child pointer to the child range which was removed.
        ///      </remarks>        <short>    The child range \a child was removed from the current \a range.</short>
        [SmokeMethod("childRangeRemoved(KTextEditor::SmartRange*, KTextEditor::SmartRange*)")]
        public virtual void ChildRangeRemoved(KTextEditor.SmartRange range, KTextEditor.SmartRange child) {
            interceptor.Invoke("childRangeRemoved##", "childRangeRemoved(KTextEditor::SmartRange*, KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.SmartRange), child);
        }
        /// <remarks>
        ///  The highlighting attribute of \a range was changed from \a previousAttribute to
        ///  \a currentAttribute.
        ///  \param range pointer to the range which generated the notification.
        ///  \param currentAttribute the attribute newly assigned to this range
        ///  \param previousAttribute the attribute previously assigned to this range
        ///      </remarks>        <short>    The highlighting attribute of \a range was changed from \a previousAttribute to  \a currentAttribute.</short>
        [SmokeMethod("rangeAttributeChanged(KTextEditor::SmartRange*, KSharedPtr<KTextEditor::Attribute>, KSharedPtr<KTextEditor::Attribute>)")]
        public virtual void RangeAttributeChanged(KTextEditor.SmartRange range, KTextEditor.Attribute currentAttribute, KTextEditor.Attribute previousAttribute) {
            interceptor.Invoke("rangeAttributeChanged#??", "rangeAttributeChanged(KTextEditor::SmartRange*, KSharedPtr<KTextEditor::Attribute>, KSharedPtr<KTextEditor::Attribute>)", typeof(void), typeof(KTextEditor.SmartRange), range, typeof(KTextEditor.Attribute), currentAttribute, typeof(KTextEditor.Attribute), previousAttribute);
        }
        ~SmartRangeWatcher() {
            interceptor.Invoke("~SmartRangeWatcher", "~SmartRangeWatcher()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~SmartRangeWatcher", "~SmartRangeWatcher()", typeof(void));
        }
    }
}
