/*
  Copyright (c) 2016 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mailwebengineaccesskeyanchortest.h"
#include "../mailwebengineaccesskeyanchor.h"
#include <QTest>


MailWebEngineAccessKeyAnchorTest::MailWebEngineAccessKeyAnchorTest(QObject *parent)
    : QObject(parent)
{

}

MailWebEngineAccessKeyAnchorTest::~MailWebEngineAccessKeyAnchorTest()
{

}

void MailWebEngineAccessKeyAnchorTest::shouldReturnEmptyAccessKeyAnchor()
{
    QVariant var;
    MessageViewer::MailWebEngineAccessKeyAnchor accessKeyAnchor(var);
    QVERIFY(accessKeyAnchor.href().isEmpty());
    QVERIFY(accessKeyAnchor.accessKey().isEmpty());
    QVERIFY(accessKeyAnchor.boundingRect().isEmpty());
    QVERIFY(accessKeyAnchor.tagName().isEmpty());
    QVERIFY(accessKeyAnchor.target().isEmpty());
    QVERIFY(accessKeyAnchor.innerText().isEmpty());
}

QTEST_MAIN(MailWebEngineAccessKeyAnchorTest)
