#include "ksoaedit.h"
#include "ksoaedit.moc"
#include <stdlib.h>

#define Inherited ksoaeditData

const char *TYPES[] = {"","A","NS","","","CNAME","SOA","MB","MG","MR","","WKS",
                        "PTR","HINFO","MINFO","MX","TXT","RP","AFSDB","X25",
                        "ISDN","RT"} ;          



ksoaedit::ksoaedit
(
	primaryDomain *pl,	
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	QString tmp;
	records *rl;

	pd = pl;
	domainedit->setText(pl->domain);
	rpedit->setText(pl->rp);
	tmp.sprintf("%u",pl->serial);
	serialedit->setText(tmp);
	tmp.sprintf("%u",pl->refresh);
	refreshedit->setText(tmp);
	tmp.sprintf("%u",pl->retry);
	retryedit->setText(tmp);
	tmp.sprintf("%u",pl->TTL);
	ttledit->setText(tmp);
	tmp.sprintf("%u",pl->expire);
	expireedit->setText(tmp);
	listall->setSeparator('\n');
	listall->setNumCols(5);
	listall->setColumn(0,"Owner",100);
	listall->setColumn(1,"Type",50);
	listall->setColumn(2,"Val1",30);
	listall->setColumn(3,"String1",250);
	listall->setColumn(4,"String2",100);
    	listall->clearTableFlags(Tbl_hScrollBar);
    	listall->clearTableFlags(Tbl_autoHScrollBar);
    	listall->setTableFlags(Tbl_autoVScrollBar);   
	for (rl=pl->data->first();rl!=0;rl=pl->data->next()) {
		tmp.sprintf("%u",rl->i);
		tmp=rl->owner+"\n"+TYPES[rl->type]+"\n"+tmp+"\n"+rl->st1+"\n"+rl->st2;
		listall->insertItem(tmp);
	}
	connect(listall,SIGNAL(selected(int,int)),SLOT(listclick(int,int)));   
	connect( changeButton, SIGNAL(clicked()), SLOT(changerecord())); 
	connect( addButton,SIGNAL(clicked()),SLOT(addrecord()));
	listsel = -1;
}


ksoaedit::~ksoaedit()
{
}

void ksoaedit::changerecord()
{
    QString tmp,tmp1;
	records *rl;
   
    if (listsel != -1) {

        tmp = listall->text(listsel,1);
	incser();
	for (rl=pd->data->first();rl!=0;rl=pd->data->next()) {
	   if ((strcmp(tmp,TYPES[rl->type])==0) && (strcmp(listall->text(listsel,0),rl->owner)==0)) {
		rl->owner = owneredit1->text();
		tmp1=MXedit->text();
		rl->i	  = tmp1.toInt();
		rl->st1   = str1edit->text();
		rl->st2   = str2edit->text();
           }
   	}

	listall->clear();
	for (rl=pd->data->first();rl!=0;rl=pd->data->next()) {
		tmp.sprintf("%u",rl->i);
		tmp=rl->owner+"\n"+TYPES[rl->type]+"\n"+tmp+"\n"+rl->st1+"\n"+rl->st2;
		listall->insertItem(tmp);
	}
   }
   
}

void ksoaedit::addrecord()
{
    QString tmp,tmp1;
    records *rl;
    int n;

        tmp = listall->text(listsel,1);
	incser();

	rl = new records();
	
	for (n=0;n<21;n++) {
		if (strcmp(ComboType->currentText(),TYPES[n]) == 0) {
			rl->type=n;
		}
	}
	rl->owner = owneredit1->text();
	tmp1=MXedit->text();
	rl->i	  = tmp1.toInt();
	rl->st1   = str1edit->text();
	rl->st2   = str2edit->text();


	pd->data->append(rl);


	listall->clear();
	for (rl=pd->data->first();rl!=0;rl=pd->data->next()) {
		tmp.sprintf("%u",rl->i);
		tmp=rl->owner+"\n"+TYPES[rl->type]+"\n"+tmp+"\n"+rl->st1+"\n"+rl->st2;
		listall->insertItem(tmp);
	}

}

void ksoaedit::incser()
{
	QString tmp;

	pd->serial++;
	tmp.sprintf("%u",pd->serial);
	serialedit->setText(tmp);

}


void ksoaedit::combochange(const char * txt)
{
   if (strcmp(txt,"NS") == 0) {
      MXlabel->setEnabled(false);
      MXedit->setEnabled(false);
      str1label->setText("Name Server");
      str2label->setEnabled(false);
      str2edit->setEnabled(false);   
   } 
   if (strcmp(txt,"A") == 0) {
      MXlabel->setEnabled(false);
      MXedit->setEnabled(false);
      str1label->setText("Adress");
      str2label->setEnabled(false);
      str2edit->setEnabled(false);   
   }
   if (strcmp(txt,"PTR") == 0) {
      MXlabel->setEnabled(false);
      MXedit->setEnabled(false);
      str1label->setText("Pointer to adress :");
      str2label->setEnabled(false);
      str2edit->setEnabled(false);   
   }

   if (strcmp(txt,"HINFO") == 0) {
      MXlabel->setEnabled(false);
      MXedit->setEnabled(false);
      str1label->setText("Host Desc. :");
      str2label->setEnabled(false);
      str2edit->setEnabled(false);   
   }
   if (strcmp(txt,"TXT") == 0) {
      MXlabel->setEnabled(false);
      MXedit->setEnabled(false);
      str1label->setText("Text :");
      str2label->setEnabled(false);
      str2edit->setEnabled(false);   
   }

   if (strcmp(txt,"CNAME") == 0) {
      MXlabel->setEnabled(false);
      MXedit->setEnabled(false);
      str1label->setText("Alias :");
      str2label->setEnabled(false);
      str2edit->setEnabled(false);   
   }

   if (strcmp(txt,"MX") == 0) {
      MXlabel->setEnabled(true);
      MXedit->setEnabled(true);
      str1label->setText("Mail Server :");
      str2label->setEnabled(false);
      str2edit->setEnabled(false);   
   }

}

void ksoaedit::listclick(int index,int col)
{
   QString tmp;
   int a,b,c;
   c=col;c=0;
   listsel = index;
   tmp = listall->text(index,1);
   a = ComboType->count();
   for (b=0;b<a;b++) {
 	if (strcmp(tmp,ComboType->text(b))==0) c=b;
   }
   ComboType->setCurrentItem(c);
   combochange(tmp);
   tmp=listall->text(index,0);
   owneredit1->setText(tmp);
   tmp=listall->text(index,2);
   MXedit->setText(tmp);
   tmp=listall->text(index,3);
   str1edit->setText(tmp);
    tmp=listall->text(index,4);
   str2edit->setText(tmp);
  
         
}
