/***************************************************************************
                          khcountingmessage.h  -  description                              
                             -------------------                                         
    begin                : Wed Aug 18 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHCOUNTINGMESSAGE_H
#define KHCOUNTINGMESSAGE_H

#include <qmessagebox.h>
#include <sensorid.h>

class KConfig;
class KHSecCounter;

/**
  *@author Ruediger Anlauf
  *@short message box with timer
	*/

class KHCountingMessage : public QMessageBox {

Q_OBJECT

public:
	KHCountingMessage( QString message, SensorId sid );
	~KHCountingMessage();
  void show();

protected:
	/** is a message box for a sensor visible ? */
	static bool VisibleItems[SensorIdSize];

	/** sensor for which this warning message was created */
	SensorId sid;

	/** seconds left until system shuts down */
	int secsLeft;

	/** pointer to kapp->getConfig() */
	KConfig *config;

	/** time at which the message box shows the countdown */	
	int warningTime;

	static KHSecCounter *timer;

  /**  */
  static QMessageBox *shutdownMessage;
  /**  */
  static KHCountingMessage *messages[SensorIdSize];
	
	static bool shutdownMessageDisplaying;

protected slots:
	/** creates a KProcess for "shutdown -h now" and shuts down system */
	void shutdownSystem();

	/** displays the countdown until system shutdown if the user does not
			react to the warning message for a configurable amount of time
			( user is absent while system fails ) */
	void handleAlertMessage( int );

protected: // Protected methods
  /**  */
  bool testShutdownEnabled();
};

#endif

















