/***************************************************************************
                          khseccounter.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Aug 19 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "khseccounter.h"
#include <qtimer.h>

int KHSecCounter::secsCounted;

KHSecCounter::KHSecCounter( int secs ) {
	secsToCount = secs;
	secsCounted = 0;
	timer = new QTimer;
	timer->start( 1000, false );
	connect( timer, SIGNAL( timeout() ),
					 this, 	SLOT	( iterateSecs() ) );
}

KHSecCounter::~KHSecCounter(){
	timer->stop();
	delete timer;
}

void KHSecCounter::iterateSecs(){
	secsCounted++;
	emit secsLeft( secsToCount - secsCounted );
	if ( secsCounted == secsToCount ) {
		emit timeout();
		secsCounted = 0;
	}
}

/**  */
void KHSecCounter::stop(){
	timer->stop();
}

/**  */
void KHSecCounter::restart(){
	timer->stop(); // just to be sure
	secsCounted = 0;
	timer->start( 1000, false );
}


/**  */
bool KHSecCounter::isActive(){
	return timer->isActive();
}


/**  */
void KHSecCounter::changeInterval( int value ){
	secsToCount = value;
}


